/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros_coordinator.diagram.providers;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.gmf.runtime.notation.View;
import org.ros.model.ros_coordinator.diagram.part.SmachDiagramEditorPlugin;
import org.ros.model.ros_coordinator.diagram.part.SmachVisualIDRegistry;

public class SmachValidationProvider {
    private static boolean constraintsActive = false;

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    public static void runWithConstraints(TransactionalEditingDomain editingDomain, Runnable operation) {
        final Runnable op = operation;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    constraintsActive = true;
                    op.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(task);
            }
            catch (Exception e) {
                SmachDiagramEditorPlugin.getInstance().logError("Validation failed", e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (SmachValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "RosCoordinator".equals(SmachVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }

    public static class DefaultCtx
    implements IClientSelector {
        public boolean selects(Object object) {
            return SmachValidationProvider.isInDefaultEditorContext(object);
        }
    }
}

