/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ParameterTypes implements Enumerator
{
    INT(0, "int", "int"),
    DOUBLE(1, "double", "double"),
    BOOL(2, "bool", "bool"),
    STRING(3, "string", "string"),
    XML_RPC_VALUE(4, "XmlRpcValue", "XmlRpcValue");

    public static final int INT_VALUE = 0;
    public static final int DOUBLE_VALUE = 1;
    public static final int BOOL_VALUE = 2;
    public static final int STRING_VALUE = 3;
    public static final int XML_RPC_VALUE_VALUE = 4;
    private static final ParameterTypes[] VALUES_ARRAY;
    public static final List<ParameterTypes> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ParameterTypes[]{INT, DOUBLE, BOOL, STRING, XML_RPC_VALUE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ParameterTypes get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterTypes result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterTypes getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ParameterTypes result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ParameterTypes get(int value) {
        switch (value) {
            case 0: {
                return INT;
            }
            case 1: {
                return DOUBLE;
            }
            case 2: {
                return BOOL;
            }
            case 3: {
                return STRING;
            }
            case 4: {
                return XML_RPC_VALUE;
            }
        }
        return null;
    }

    private ParameterTypes(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

