/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.ros.model.ros.Action;
import org.ros.model.ros.ActionClient;
import org.ros.model.ros.ActionServer;
import org.ros.model.ros.Architecture;
import org.ros.model.ros.diagram.edit.policies.RosBaseItemSemanticEditPolicy;

public class ActionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ActionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Action)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ActionServer) || !(this.newEnd instanceof ActionServer)) {
            return false;
        }
        ActionClient target = this.getLink().getActionclient();
        if (!(this.getLink().eContainer() instanceof Architecture)) {
            return false;
        }
        Architecture container = (Architecture)this.getLink().eContainer();
        return RosBaseItemSemanticEditPolicy.getLinkConstraints().canExistAction_4003(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ActionClient) || !(this.newEnd instanceof ActionClient)) {
            return false;
        }
        ActionServer source = this.getLink().getActionserver();
        if (!(this.getLink().eContainer() instanceof Architecture)) {
            return false;
        }
        Architecture container = (Architecture)this.getLink().eContainer();
        return RosBaseItemSemanticEditPolicy.getLinkConstraints().canExistAction_4003(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setActionserver(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setActionclient(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Action getLink() {
        return (Action)this.getElementToEdit();
    }

    protected ActionServer getOldSource() {
        return (ActionServer)this.oldEnd;
    }

    protected ActionServer getNewSource() {
        return (ActionServer)this.newEnd;
    }

    protected ActionClient getOldTarget() {
        return (ActionClient)this.oldEnd;
    }

    protected ActionClient getNewTarget() {
        return (ActionClient)this.newEnd;
    }
}

