/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros_coordinator.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.ros.model.ros_coordinator.diagram.edit.policies.SmachBaseItemSemanticEditPolicy;
import org.ros.model.smach.SMACHState;
import org.ros.model.smach.SMACHStateMachine;
import org.ros.model.smach.SMACHTransition;

public class StateTransitionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public StateTransitionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof SMACHTransition)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof SMACHState) || !(this.newEnd instanceof SMACHState)) {
            return false;
        }
        SMACHState target = this.getLink().getTarget();
        if (!(this.getLink().eContainer() instanceof SMACHStateMachine)) {
            return false;
        }
        SMACHStateMachine container = (SMACHStateMachine)this.getLink().eContainer();
        return SmachBaseItemSemanticEditPolicy.getLinkConstraints().canExistSMACHTransition_4001(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof SMACHState) || !(this.newEnd instanceof SMACHState)) {
            return false;
        }
        SMACHState source = this.getLink().getSource();
        if (!(this.getLink().eContainer() instanceof SMACHStateMachine)) {
            return false;
        }
        SMACHStateMachine container = (SMACHStateMachine)this.getLink().eContainer();
        return SmachBaseItemSemanticEditPolicy.getLinkConstraints().canExistSMACHTransition_4001(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected SMACHTransition getLink() {
        return (SMACHTransition)this.getElementToEdit();
    }

    protected SMACHState getOldSource() {
        return (SMACHState)this.oldEnd;
    }

    protected SMACHState getNewSource() {
        return (SMACHState)this.newEnd;
    }

    protected SMACHState getOldTarget() {
        return (SMACHState)this.oldEnd;
    }

    protected SMACHState getNewTarget() {
        return (SMACHState)this.newEnd;
    }
}

