/*
 * Decompiled with CFR 0.152.
 */
package org.best_of_robotics.transform.ros.to.cplusplus.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.best_of_robotics.transform.ros.to.cplusplus.EGLTransformer;
import org.best_of_robotics.transform.service.parameter.IEglTransformParameter;
import org.best_of_robotics.transform.service.parameter.TransformParameterFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class RosPythonTransform
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorInput input;
        IFile sourcefile = null;
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            sourcefile = ((IFileEditorInput)input).getFile();
            System.out.println("File from editor: " + sourcefile.getLocation().toOSString());
            if (sourcefile.getFileExtension().compareTo("ros_package") != 0 && sourcefile.getFileExtension().compareTo("ros_package_diagram") != 0) {
                sourcefile = null;
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error on Editor Selection 2", (String)"Please select the editor from which you want to generate code and execute command again.");
            }
            try {
                int errors = sourcefile.getProject().findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2);
                if (errors != -1) {
                    sourcefile = null;
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Model problem found", (String)"Your model is not valid yet. Please fix the issues you find in the Problems tab before generating code out of this model.");
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (sourcefile == null) {
            return null;
        }
        String cmd = "rospack find bride_templates";
        String template_dir = "";
        Runtime run = Runtime.getRuntime();
        try {
            Process pr = run.exec(cmd);
            pr.waitFor();
            BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            template_dir = buf.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (template_dir.length() == 0) {
            System.out.println("Couldn't find template package");
            return null;
        }
        System.out.println("Taking transformation: " + template_dir + "/python/package/package.egl");
        IEglTransformParameter eglTransformParameter = TransformParameterFactory.createEglTransformParameter();
        eglTransformParameter.setTransformName("ROS Package to python implementation");
        eglTransformParameter.setEglTransform("file://" + template_dir + "/python/package/package.egl");
        eglTransformParameter.setPluginID("org.best_of_robotics.transform.ros.to.cplusplus");
        eglTransformParameter.setSourceMetaModelURI("http://ros/1.0");
        eglTransformParameter.setSourceModelFilePath(String.valueOf(sourcefile.getLocation().removeFileExtension().toOSString()) + ".ros_package");
        eglTransformParameter.setSourceName("Source");
        eglTransformParameter.setSourceReadOnLoad(true);
        eglTransformParameter.setSourceStoreOnDisposal(false);
        eglTransformParameter.setOutputRoot("file:" + sourcefile.getProject().getLocation().toOSString());
        EGLTransformer transformer = new EGLTransformer(eglTransformParameter);
        transformer.transform();
        return null;
    }
}

