/*
 * Decompiled with CFR 0.152.
 */
package org.best_of_robotics.transform.ros.to.cplusplus;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.best_of_robotics.transform.service.parameter.IEtlTransformParameter;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.epsilon.common.parse.problem.ParseProblem;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.EtlModule;

public class EtlTransformer {
    private IEtlTransformParameter parameter;

    public EtlTransformer(IEtlTransformParameter etlTransformParameter) {
        this.parameter = etlTransformParameter;
    }

    public void transform() {
        URL transformationEntry = null;
        try {
            transformationEntry = new URL(this.parameter.getEtlTransformPath());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        URL resolvedTransformationURL = null;
        URI transformURI = null;
        try {
            resolvedTransformationURL = FileLocator.resolve((URL)transformationEntry);
            transformURI = resolvedTransformationURL.toURI();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        EtlModule etlModule = new EtlModule();
        try {
            etlModule.parse(transformURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (etlModule.getParseProblems().size() > 0) {
            System.err.println("Parse errors occured...");
            for (ParseProblem problem : etlModule.getParseProblems()) {
                System.err.println(problem.toString());
            }
        }
        etlModule.getContext().getModelRepository().addModel((IModel)this.createSource());
        etlModule.getContext().getModelRepository().addModel((IModel)this.createTarget());
        try {
            etlModule.execute();
        }
        catch (EolRuntimeException e) {
            e.printStackTrace();
        }
        etlModule.getContext().getModelRepository().dispose();
    }

    protected EmfModel createSource() {
        EmfModel emfModel = new EmfModel();
        emfModel.setName(this.parameter.getSourceName());
        emfModel.setMetamodelUri(this.parameter.getSourceMetaModelURI());
        emfModel.setModelFile(this.parameter.getSourceModelFilePath());
        emfModel.setReadOnLoad(this.parameter.isSourceReadOnLoad());
        emfModel.setStoredOnDisposal(this.parameter.isSourceStoreOnDisposal());
        try {
            emfModel.load();
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
        }
        return emfModel;
    }

    protected EmfModel createTarget() {
        EmfModel emfModel = new EmfModel();
        emfModel.setName(this.parameter.getTargetName());
        emfModel.setMetamodelUri(this.parameter.getTargetMetaModelURI());
        emfModel.setModelFile(this.parameter.getTargetModelFilePath());
        emfModel.setReadOnLoad(this.parameter.isTargetReadOnLoad());
        emfModel.setStoredOnDisposal(this.parameter.isTargetStoreOnDisposal());
        try {
            emfModel.load();
        }
        catch (EolModelLoadingException e) {
            e.printStackTrace();
        }
        return emfModel;
    }
}

