/*
 * Decompiled with CFR 0.152.
 */
package org.bride.wizards;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import org.bride.wizards.ROSWizardResourceImportPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class ROSPackageImportWizard
extends Wizard
implements IImportWizard {
    private static final String WIZARD_NAME = "Import ROS Package";
    private ROSWizardResourceImportPage _pageOne;
    IStructuredSelection selection;

    public ROSPackageImportWizard() {
        this.setWindowTitle(WIZARD_NAME);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public boolean performFinish() {
        System.out.println(this._pageOne.getCurrentPath());
        final File directory = new File(this._pageOne.getCurrentPath());
        if (!directory.isDirectory()) {
            return false;
        }
        System.out.println(directory.getName());
        File projectfile = new File(String.valueOf(directory.getPath()) + "/.project");
        if (projectfile.exists() && !projectfile.isDirectory()) {
            System.out.println("Importing existing project");
        } else {
            Runtime run = Runtime.getRuntime();
            try {
                Process pr = run.exec("rosrun bride eclipsefy_catkin_package.sh " + directory.getName(), null, new File(directory.getParent()));
                pr.waitFor();
                BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                String line = "";
                while ((line = buf.readLine()) != null) {
                    System.out.println(line);
                }
                System.out.println("Finished creating eclipse project files");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (projectfile.exists() && !projectfile.isDirectory()) {
            new IOverwriteQuery(){

                public String queryOverwrite(String file) {
                    return "ALL";
                }
            };
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)new Path(String.valueOf(directory.getPath()) + "/.project"));
                        String projectName = description.getName().split("@")[0];
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IProject project = workspace.getRoot().getProject(projectName);
                        description.setName(projectName);
                        monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                        project.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                        project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
                Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
                ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
                return false;
            }
        } else {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Importing failed.", (String)"Check if the Package you are importing is a valid catkin package and is within your current catkin workspaces.");
            return false;
        }
        return true;
    }

    public void addPages() {
        super.addPages();
        this._pageOne = new ROSWizardResourceImportPage("Import ROS catkin projects into workspace", this.selection);
        this._pageOne.setTitle("ROS Import Wizard");
        this._pageOne.setDescription("Import ROS catkin projects into workspace");
        this.addPage((IWizardPage)this._pageOne);
    }
}

