/*
 * Decompiled with CFR 0.152.
 */
package org.ros.model.ros.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.ros.model.ros.diagram.part.Messages;
import org.ros.model.ros.diagram.part.RosCreationWizardPage;
import org.ros.model.ros.diagram.part.RosDiagramEditorPlugin;
import org.ros.model.ros.diagram.part.RosDiagramEditorUtil;

public class RosCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected RosCreationWizardPage diagramModelFilePage;
    protected RosCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.RosCreationWizardTitle);
        this.setDefaultPageImageDescriptor(RosDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewRosWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new RosCreationWizardPage("DiagramModelFile", this.getSelection(), "ros_system_diagram");
        this.diagramModelFilePage.setTitle(Messages.RosCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.RosCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new RosCreationWizardPage("DomainModelFile", this.getSelection(), "ros_system"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = RosCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".ros_system_diagram".length());
                    this.setFileName(RosDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "ros_system"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.RosCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.RosCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                RosCreationWizard.this.diagram = RosDiagramEditorUtil.createDiagram(RosCreationWizard.this.diagramModelFilePage.getURI(), RosCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (RosCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && RosCreationWizard.this.diagram != null) {
                    try {
                        RosDiagramEditorUtil.openDiagram(RosCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)RosCreationWizard.this.getContainer().getShell(), (String)Messages.RosCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.RosCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                RosDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() != this.diagramModelFilePage;
    }
}

