#!/usr/bin/env python
#
# Copyright 2017 Fraunhofer Institute for Manufacturing Engineering and Automation (IPA)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


import time
import rospy
from cob_msgs.msg import EmergencyStopState, PowerState, DashboardState
from diagnostic_msgs.msg import DiagnosticStatus

class DashboardAggregator:
  def __init__(self):
    self.msg = DashboardState()

    # Create publisher
    self.pub = rospy.Publisher("dashboard_agg", DashboardState, queue_size=1)

    # Create subscribers
    # Diagnostics
    rospy.Subscriber("diagnostics_toplevel_state", DiagnosticStatus, self.DiagnosticStatusCB)
    # Power state
    rospy.Subscriber("power_state", PowerState, self.PowerStateCB)
    # Emergency stop state
    rospy.Subscriber("emergency_stop_state", EmergencyStopState, self.EmergencyStopStateCB)

  def DiagnosticStatusCB(self, msg):
    self.msg.diagnostics_toplevel_state = msg

  def PowerStateCB(self, msg):
    self.msg.power_state = msg

  def EmergencyStopStateCB(self, msg):
    self.msg.emergency_stop_state = msg

  def publish(self):
    now = time.time()
    self.pub.publish(self.msg)

if __name__ == "__main__":
  rospy.init_node("cob_dashboard_aggregator")
  rospy.sleep(1)
  da = DashboardAggregator()
  r = rospy.Rate(1)
  while not rospy.is_shutdown():
    da.publish()
    try:
        r.sleep()
    except rospy.exceptions.ROSInterruptException as e:
        pass
