/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2012-11-23 19:10:48.288028
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;
#include "ros/ros.h"
#define IKFAST_ASSERT ROS_ASSERT
// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41,x42,x43,x44,x45,x46,x47,x48,x49,x50,x51,x52,x53,x54,x55,x56,x57,x58,x59,x60,x61,x62,x63,x64,x65,x66;
x0=IKcos(j[0]);
x1=IKsin(j[0]);
x2=IKsin(j[2]);
x3=IKcos(j[1]);
x4=IKcos(j[2]);
x5=IKcos(j[4]);
x6=IKcos(j[3]);
x7=IKsin(j[1]);
x8=IKsin(j[3]);
x9=IKsin(j[4]);
x10=IKsin(j[6]);
x11=IKcos(j[5]);
x12=IKsin(j[5]);
x13=IKcos(j[6]);
x14=((IkReal(0.192700000000000))*(x7));
x15=((IkReal(0.192700000000000))*(x8));
x16=((IkReal(1.00000000000000))*(x7));
x17=((IkReal(1.00000000000000))*(x1));
x18=((IkReal(1.00000000000000))*(x3));
x19=((IkReal(1.00000000000000))*(x11));
x20=((IkReal(1.00000000000000))*(x12));
x21=((IkReal(0.192700000000000))*(x5));
x22=((IkReal(0.316500000000000))*(x0));
x23=((IkReal(1.00000000000000))*(x0));
x24=((IkReal(0.316500000000000))*(x6));
x25=((IkReal(1.00000000000000))*(x5));
x26=((x2)*(x9));
x27=((x4)*(x8));
x28=((x2)*(x3));
x29=((x0)*(x7));
x30=((x1)*(x7));
x31=((x3)*(x4));
x32=((x4)*(x6));
x33=((x1)*(x2));
x34=((x3)*(x6));
x35=((x0)*(x18)*(x4));
x36=((x16)*(x26));
x37=((((IkReal(-1.00000000000000))*(x35)))+(x33));
x38=((((x1)*(x4)))+(((x0)*(x28))));
x39=((((x1)*(x28)))+(((IkReal(-1.00000000000000))*(x23)*(x4))));
x40=((((IkReal(-1.00000000000000))*(x16)*(x27)))+(x34));
x41=((((x32)*(x7)))+(((x3)*(x8))));
x42=((((IkReal(-1.00000000000000))*(x17)*(x2)))+(x35));
x43=((((x17)*(x31)))+(((x2)*(x23))));
x44=((IkReal(-1.00000000000000))*(x43));
x45=((x38)*(x9));
x46=((x41)*(x5));
x47=((x39)*(x9));
x48=((x37)*(x6));
x49=((x42)*(x8));
x50=((x44)*(x6));
x51=((((x29)*(x8)))+(x48));
x52=((((IkReal(-1.00000000000000))*(x36)))+(x46));
x53=((((x29)*(x6)))+(x49));
x54=((((x30)*(x6)))+(((x43)*(x8))));
x55=((((x30)*(x8)))+(x50));
IkReal x67=((IkReal(1.00000000000000))*(x16));
x56=((((x9)*(((((IkReal(-1.00000000000000))*(x18)*(x8)))+(((IkReal(-1.00000000000000))*(x32)*(x67)))))))+(((IkReal(-1.00000000000000))*(x2)*(x5)*(x67))));
x57=((x11)*(x52));
x58=((x5)*(x51));
x59=((x12)*(x53));
x60=((x12)*(x54));
x61=((x5)*(x55));
x62=((x45)+(x58));
x63=((x47)+(x61));
x64=((((x9)*(((((IkReal(-1.00000000000000))*(x48)))+(((IkReal(-1.00000000000000))*(x29)*(x8)))))))+(((x38)*(x5))));
x65=((((x39)*(x5)))+(((x9)*(((((IkReal(-1.00000000000000))*(x50)))+(((IkReal(-1.00000000000000))*(x1)*(x16)*(x8))))))));
x66=((x11)*(x63));
eerot[0]=((((x13)*(((((x11)*(x62)))+(x59)))))+(((x10)*(x64))));
eerot[1]=((((x13)*(x64)))+(((x10)*(((((IkReal(-1.00000000000000))*(x20)*(x53)))+(((IkReal(-1.00000000000000))*(x19)*(x62))))))));
eerot[2]=((((x11)*(x53)))+(((x12)*(((((IkReal(-1.00000000000000))*(x45)))+(((IkReal(-1.00000000000000))*(x25)*(x51))))))));
IkReal x68=((IkReal(1.00000000000000))*(x22));
eetrans[0]=((((IkReal(-1.00000000000000))*(x6)*(x68)*(x7)))+(((x11)*(((((IkReal(-1.00000000000000))*(x15)*(x42)))+(((IkReal(-1.00000000000000))*(x0)*(x14)*(x6)))))))+(((IkReal(-0.408000000000000))*(x29)))+(((x12)*(((((IkReal(0.192700000000000))*(x45)))+(((x21)*(x51)))))))+(((x8)*(((((IkReal(-1.00000000000000))*(x31)*(x68)))+(((IkReal(0.316500000000000))*(x33))))))));
eerot[3]=((((x10)*(x65)))+(((x13)*(((x60)+(x66))))));
eerot[4]=((((x13)*(x65)))+(((x10)*(((((IkReal(-1.00000000000000))*(x66)))+(((IkReal(-1.00000000000000))*(x60))))))));
eerot[5]=((((x12)*(((((IkReal(-1.00000000000000))*(x47)))+(((IkReal(-1.00000000000000))*(x25)*(x55)))))))+(((x11)*(x54))));
eetrans[1]=((((x8)*(((((IkReal(-0.316500000000000))*(x1)*(x31)))+(((IkReal(-1.00000000000000))*(x2)*(x22)))))))+(((x11)*(((((IkReal(-1.00000000000000))*(x15)*(x43)))+(((IkReal(-1.00000000000000))*(x1)*(x14)*(x6)))))))+(((x12)*(((((IkReal(0.192700000000000))*(x47)))+(((x21)*(x55)))))))+(((IkReal(-0.408000000000000))*(x30)))+(((IkReal(-1.00000000000000))*(x24)*(x30))));
eerot[6]=((((x10)*(x56)))+(((x13)*(((x57)+(((x12)*(x40))))))));
eerot[7]=((((x13)*(x56)))+(((x10)*(((((IkReal(-1.00000000000000))*(x20)*(x40)))+(((IkReal(-1.00000000000000))*(x19)*(x52))))))));
eerot[8]=((((x11)*(x40)))+(((x12)*(((((IkReal(-1.00000000000000))*(x25)*(x41)))+(x36))))));
eetrans[2]=((IkReal(-0.250000000000000))+(((x11)*(((((x14)*(x27)))+(((IkReal(-0.192700000000000))*(x34)))))))+(((x12)*(((((x21)*(x41)))+(((IkReal(-1.00000000000000))*(x14)*(x26)))))))+(((IkReal(0.316500000000000))*(x27)*(x7)))+(((IkReal(-1.00000000000000))*(x24)*(x3)))+(((IkReal(-0.408000000000000))*(x3))));
}

IKFAST_API int GetNumFreeParameters() { return 1; }
IKFAST_API int* GetFreeParameters() { static int freeparams[] = {2}; return freeparams; }
IKFAST_API int GetNumJoints() { return 7; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,j5,cj5,sj5,htj5,j6,cj6,sj6,htj6,j2,cj2,sj2,htj2,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5,_ij6[2], _nj6,_ij2[2], _nj2;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1; j6=numeric_limits<IkReal>::quiet_NaN(); _ij6[0] = -1; _ij6[1] = -1; _nj6 = -1;  _ij2[0] = -1; _ij2[1] = -1; _nj2 = 0; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
j2=pfree[0]; cj2=cos(pfree[0]); sj2=sin(pfree[0]);
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=r00;
new_r01=r01;
new_r02=r02;
new_px=((px)+(((IkReal(0.192700000000000))*(r02))));
new_r10=r10;
new_r11=r11;
new_r12=r12;
new_py=((py)+(((IkReal(0.192700000000000))*(r12))));
new_r20=r20;
new_r21=r21;
new_r22=r22;
new_pz=((IkReal(0.250000000000000))+(((IkReal(0.192700000000000))*(r22)))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
pp=(((px)*(px))+((py)*(py))+((pz)*(pz)));
npx=((((px)*(r00)))+(((py)*(r10)))+(((pz)*(r20))));
npy=((((px)*(r01)))+(((py)*(r11)))+(((pz)*(r21))));
npz=((((px)*(r02)))+(((py)*(r12)))+(((pz)*(r22))));
rxp0_0=((((IkReal(-1.00000000000000))*(py)*(r20)))+(((pz)*(r10))));
rxp0_1=((((px)*(r20)))+(((IkReal(-1.00000000000000))*(pz)*(r00))));
rxp0_2=((((IkReal(-1.00000000000000))*(px)*(r10)))+(((py)*(r00))));
rxp1_0=((((IkReal(-1.00000000000000))*(py)*(r21)))+(((pz)*(r11))));
rxp1_1=((((px)*(r21)))+(((IkReal(-1.00000000000000))*(pz)*(r01))));
rxp1_2=((((IkReal(-1.00000000000000))*(px)*(r11)))+(((py)*(r01))));
rxp2_0=((((IkReal(-1.00000000000000))*(py)*(r22)))+(((pz)*(r12))));
rxp2_1=((((px)*(r22)))+(((IkReal(-1.00000000000000))*(pz)*(r02))));
rxp2_2=((((IkReal(-1.00000000000000))*(px)*(r12)))+(((py)*(r02))));
{
IkReal j3array[2], cj3array[2], sj3array[2];
bool j3valid[2]={false};
_nj3 = 2;
cj3array[0]=((IkReal(-1.03241741009200))+(((IkReal(3.87200693863643))*(pp))));
if( cj3array[0] >= -1-IKFAST_SINCOS_THRESH && cj3array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j3valid[0] = j3valid[1] = true;
    j3array[0] = IKacos(cj3array[0]);
    sj3array[0] = IKsin(j3array[0]);
    cj3array[1] = cj3array[0];
    j3array[1] = -j3array[0];
    sj3array[1] = -sj3array[0];
}
else if( isnan(cj3array[0]) )
{
    // probably any value will work
    j3valid[0] = true;
    cj3array[0] = 1; sj3array[0] = 0; j3array[0] = 0;
}
for(int ij3 = 0; ij3 < 2; ++ij3)
{
if( !j3valid[ij3] )
{
    continue;
}
_ij3[0] = ij3; _ij3[1] = -1;
for(int iij3 = ij3+1; iij3 < 2; ++iij3)
{
if( j3valid[iij3] && IKabs(cj3array[ij3]-cj3array[iij3]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij3]-sj3array[iij3]) < IKFAST_SOLUTION_THRESH )
{
    j3valid[iij3]=false; _ij3[1] = iij3; break; 
}
}
j3 = j3array[ij3]; cj3 = cj3array[ij3]; sj3 = sj3array[ij3];

{
IkReal dummyeval[1];
dummyeval[0]=(((px)*(px))+((py)*(py)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=(((px)*(px))+((py)*(py)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=((IkReal(1.66177758810449))+((cj3)*(cj3))+((((cj2)*(cj2))*((sj3)*(sj3))))+(((IkReal(2.57819905213270))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[2], cj1array[2], sj1array[2];
bool j1valid[2]={false};
_nj1 = 2;
IkReal x69=((IkReal(-0.408000000000000))+(((IkReal(-0.316500000000000))*(cj3))));
if( IKabs(x69) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(0.316500000000000))*(cj2)*(sj3))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x70=((IkReal(1.00000000000000))*(IKatan2(x69, ((IkReal(0.316500000000000))*(cj2)*(sj3)))));
if( ((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3)))))) < (IkReal)-0.00001 )
    continue;
if( (((pz)*(((IKabs(IKabs(IKsqrt((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3))))))))):(IkReal)1.0e30)))) < -1-IKFAST_SINCOS_THRESH || (((pz)*(((IKabs(IKabs(IKsqrt((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3))))))))):(IkReal)1.0e30)))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x71=IKasin(((pz)*(((IKabs(IKabs(IKsqrt((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((x69)*(x69))+(((IkReal(0.100172250000000))*((cj2)*(cj2))*((sj3)*(sj3))))))))):(IkReal)1.0e30))));
j1array[0]=((((IkReal(-1.00000000000000))*(x70)))+(x71));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
j1array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x70)))+(((IkReal(-1.00000000000000))*(x71))));
sj1array[1]=IKsin(j1array[1]);
cj1array[1]=IKcos(j1array[1]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
if( j1array[1] > IKPI )
{
    j1array[1]-=IK2PI;
}
else if( j1array[1] < -IKPI )
{    j1array[1]+=IK2PI;
}
j1valid[1] = true;
for(int ij1 = 0; ij1 < 2; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 2; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x72=((IkReal(102000.000000000))*(sj1));
gconst0=IKsign(((((x72)*((px)*(px))))+(((x72)*((py)*(py))))));
dummyeval[0]=((((sj1)*((py)*(py))))+(((sj1)*((px)*(px)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x73=((IkReal(2000.00000000000))*(sj1));
gconst1=IKsign(((((x73)*((px)*(px))))+(((x73)*((py)*(py))))));
dummyeval[0]=((((sj1)*((py)*(py))))+(((sj1)*((px)*(px)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x74=((IkReal(1.00000000000000))*(pp));
IkReal x75=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.316500000000000))*(cj3))));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.266636250000000))+(((IkReal(-1.00000000000000))*(x74)))+(((IkReal(0.258264000000000))*(cj3))));
evalcond[2]=x75;
evalcond[3]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x74)))+(((IkReal(-0.816000000000000))*(pz))));
evalcond[4]=x75;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign(((((IkReal(2000.00000000000))*((py)*(py))))+(((IkReal(2000.00000000000))*((px)*(px))))));
dummyeval[0]=(((px)*(px))+((py)*(py)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x76=((IkReal(2000.00000000000))*(cj2));
gconst3=IKsign(((((x76)*((px)*(px))))+(((x76)*((py)*(py))))));
dummyeval[0]=((((cj2)*((py)*(py))))+(((cj2)*((px)*(px)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x77=((IkReal(1.00000000000000))*(pp));
IkReal x78=x75;
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.266636250000000))+(((IkReal(-1.00000000000000))*(x77)))+(((IkReal(0.258264000000000))*(cj3))));
evalcond[2]=x78;
evalcond[3]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x77)))+(((IkReal(-0.816000000000000))*(pz))));
evalcond[4]=x78;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign(((((IkReal(2000.00000000000))*((py)*(py))))+(((IkReal(2000.00000000000))*((px)*(px))))));
dummyeval[0]=(((px)*(px))+((py)*(py)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x79=((gconst4)*(sj3));
if( IKabs(((IkReal(633.000000000000))*(px)*(x79))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-633.000000000000))*(py)*(x79))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((IkReal(633.000000000000))*(px)*(x79)), ((IkReal(-633.000000000000))*(py)*(x79)));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x80=IKsin(j0);
IkReal x81=IKcos(j0);
evalcond[0]=((((IkReal(-0.316500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(py)*(x81)))+(((px)*(x80))));
evalcond[1]=((((py)*(x80)))+(((px)*(x81))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
IkReal x230=((IkReal(1.00000000000000))*(pp));
IkReal x231=x75;
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.266636250000000))+(((IkReal(-1.00000000000000))*(x230)))+(((IkReal(0.258264000000000))*(cj3))));
evalcond[2]=x231;
evalcond[3]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x230)))+(((IkReal(-0.816000000000000))*(pz))));
evalcond[4]=x231;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst5;
gconst5=IKsign(((((IkReal(-2000.00000000000))*((py)*(py))))+(((IkReal(-2000.00000000000))*((px)*(px))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((px)*(px))))+(((IkReal(-1.00000000000000))*((py)*(py)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x232=((gconst5)*(sj3));
if( IKabs(((IkReal(633.000000000000))*(px)*(x232))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-633.000000000000))*(py)*(x232))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((IkReal(633.000000000000))*(px)*(x232)), ((IkReal(-633.000000000000))*(py)*(x232)));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x233=IKsin(j0);
IkReal x234=IKcos(j0);
evalcond[0]=((((IkReal(-1.00000000000000))*(py)*(x234)))+(((IkReal(0.316500000000000))*(sj3)))+(((px)*(x233))));
evalcond[1]=((((px)*(x234)))+(((py)*(x233))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x235=(cj2)*(cj2);
IkReal x236=((cj2)*(sj2));
IkReal x237=((IkReal(633.000000000000))*(py)*(sj3));
IkReal x238=((IkReal(633.000000000000))*(px)*(sj3));
if( IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x235)*(x237)))+(((x236)*(x238))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((IkReal(-1.00000000000000))*(x235)*(x238)))+(((IkReal(-1.00000000000000))*(x236)*(x237))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst3)*(((((IkReal(-1.00000000000000))*(x235)*(x237)))+(((x236)*(x238)))))), ((gconst3)*(((((IkReal(-1.00000000000000))*(x235)*(x238)))+(((IkReal(-1.00000000000000))*(x236)*(x237)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x239=IKsin(j0);
IkReal x240=IKcos(j0);
IkReal x241=((IkReal(0.316500000000000))*(sj3));
IkReal x242=((px)*(x239));
IkReal x243=((px)*(x240));
IkReal x244=((py)*(x239));
IkReal x245=((IkReal(1.00000000000000))*(py)*(x240));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x241)))+(x242)+(((IkReal(-1.00000000000000))*(x245))));
evalcond[1]=((x243)+(x244)+(((cj2)*(x241))));
evalcond[2]=((((sj2)*(x243)))+(((sj2)*(x244)))+(((IkReal(-1.00000000000000))*(cj2)*(x245)))+(((cj2)*(x242))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj2)*(x242)))+(x241)+(((py)*(sj2)*(x240)))+(((cj2)*(x244)))+(((cj2)*(x243))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x246=((IkReal(633.000000000000))*(sj3));
if( IKabs(((gconst2)*(((((px)*(sj2)*(x246)))+(((IkReal(-1.00000000000000))*(cj2)*(py)*(x246))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(py)*(sj2)*(x246)))+(((IkReal(-1.00000000000000))*(cj2)*(px)*(x246))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst2)*(((((px)*(sj2)*(x246)))+(((IkReal(-1.00000000000000))*(cj2)*(py)*(x246)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(py)*(sj2)*(x246)))+(((IkReal(-1.00000000000000))*(cj2)*(px)*(x246)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x247=IKsin(j0);
IkReal x248=IKcos(j0);
IkReal x249=((IkReal(0.316500000000000))*(sj3));
IkReal x250=((px)*(x247));
IkReal x251=((px)*(x248));
IkReal x252=((py)*(x247));
IkReal x253=((IkReal(1.00000000000000))*(py)*(x248));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x249)))+(x250)+(((IkReal(-1.00000000000000))*(x253))));
evalcond[1]=((x251)+(x252)+(((cj2)*(x249))));
evalcond[2]=((((cj2)*(x250)))+(((sj2)*(x251)))+(((sj2)*(x252)))+(((IkReal(-1.00000000000000))*(cj2)*(x253))));
evalcond[3]=((((cj2)*(x251)))+(((cj2)*(x252)))+(x249)+(((py)*(sj2)*(x248)))+(((IkReal(-1.00000000000000))*(sj2)*(x250))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
IkReal x254=((IkReal(1.00000000000000))*(pp));
IkReal x255=((IkReal(0.316500000000000))*(cj3));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j1)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.266636250000000))+(((IkReal(0.258264000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x254))));
evalcond[2]=((IkReal(0.408000000000000))+(((IkReal(-1.00000000000000))*(pz)))+(x255));
evalcond[3]=((IkReal(-0.0662917500000000))+(((IkReal(0.816000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x254))));
evalcond[4]=((IkReal(-0.408000000000000))+(pz)+(((IkReal(-1.00000000000000))*(x255))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
gconst6=IKsign(((((IkReal(2000.00000000000))*((py)*(py))))+(((IkReal(2000.00000000000))*((px)*(px))))));
dummyeval[0]=(((px)*(px))+((py)*(py)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst7;
IkReal x256=((IkReal(2000.00000000000))*(cj2));
gconst7=IKsign(((((IkReal(-1.00000000000000))*(x256)*((px)*(px))))+(((IkReal(-1.00000000000000))*(x256)*((py)*(py))))));
IkReal x257=((IkReal(1.00000000000000))*(cj2));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x257)*((py)*(py))))+(((IkReal(-1.00000000000000))*(x257)*((px)*(px)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[5];
IkReal x258=((IkReal(1.00000000000000))*(pp));
IkReal x259=((IkReal(0.316500000000000))*(cj3));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.266636250000000))+(((IkReal(0.258264000000000))*(cj3)))+(((IkReal(-1.00000000000000))*(x258))));
evalcond[2]=((IkReal(0.408000000000000))+(((IkReal(-1.00000000000000))*(pz)))+(x259));
evalcond[3]=((IkReal(-0.0662917500000000))+(((IkReal(0.816000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x258))));
evalcond[4]=((IkReal(-0.408000000000000))+(pz)+(((IkReal(-1.00000000000000))*(x259))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst8;
gconst8=IKsign(((((IkReal(2000.00000000000))*((py)*(py))))+(((IkReal(2000.00000000000))*((px)*(px))))));
dummyeval[0]=(((px)*(px))+((py)*(py)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x260=((gconst8)*(sj3));
if( IKabs(((IkReal(633.000000000000))*(px)*(x260))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-633.000000000000))*(py)*(x260))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((IkReal(633.000000000000))*(px)*(x260)), ((IkReal(-633.000000000000))*(py)*(x260)));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x261=IKsin(j0);
IkReal x262=IKcos(j0);
evalcond[0]=((((IkReal(-0.316500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(py)*(x262)))+(((px)*(x261))));
evalcond[1]=((((py)*(x261)))+(((px)*(x262))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
IkReal x263=((IkReal(1.00000000000000))*(pp));
IkReal x264=((IkReal(0.316500000000000))*(cj3));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j2)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(0.266636250000000))+(((IkReal(-1.00000000000000))*(x263)))+(((IkReal(0.258264000000000))*(cj3))));
evalcond[2]=((IkReal(0.408000000000000))+(((IkReal(-1.00000000000000))*(pz)))+(x264));
evalcond[3]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x263)))+(((IkReal(0.816000000000000))*(pz))));
evalcond[4]=((IkReal(-0.408000000000000))+(pz)+(((IkReal(-1.00000000000000))*(x264))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst9;
gconst9=IKsign(((((IkReal(-2000.00000000000))*((py)*(py))))+(((IkReal(-2000.00000000000))*((px)*(px))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((px)*(px))))+(((IkReal(-1.00000000000000))*((py)*(py)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x265=((gconst9)*(sj3));
if( IKabs(((IkReal(633.000000000000))*(px)*(x265))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-633.000000000000))*(py)*(x265))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((IkReal(633.000000000000))*(px)*(x265)), ((IkReal(-633.000000000000))*(py)*(x265)));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x266=IKsin(j0);
IkReal x267=IKcos(j0);
evalcond[0]=((((IkReal(0.316500000000000))*(sj3)))+(((IkReal(-1.00000000000000))*(py)*(x267)))+(((px)*(x266))));
evalcond[1]=((((py)*(x266)))+(((px)*(x267))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x268=(cj2)*(cj2);
IkReal x269=((IkReal(633.000000000000))*(sj3));
IkReal x270=((cj2)*(sj2));
if( IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(px)*(x269)*(x270)))+(((IkReal(-1.00000000000000))*(py)*(x268)*(x269))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst7)*(((((IkReal(-1.00000000000000))*(px)*(x268)*(x269)))+(((py)*(x269)*(x270))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst7)*(((((IkReal(-1.00000000000000))*(px)*(x269)*(x270)))+(((IkReal(-1.00000000000000))*(py)*(x268)*(x269)))))), ((gconst7)*(((((IkReal(-1.00000000000000))*(px)*(x268)*(x269)))+(((py)*(x269)*(x270)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x271=IKsin(j0);
IkReal x272=IKcos(j0);
IkReal x273=((IkReal(1.00000000000000))*(sj2));
IkReal x274=((IkReal(0.316500000000000))*(sj3));
IkReal x275=((IkReal(1.00000000000000))*(cj2));
IkReal x276=((px)*(x271));
IkReal x277=((px)*(x272));
IkReal x278=((py)*(x271));
IkReal x279=((IkReal(1.00000000000000))*(py)*(x272));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x274)))+(x276)+(((IkReal(-1.00000000000000))*(x279))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x274)))+(x277)+(x278));
evalcond[2]=((((IkReal(-1.00000000000000))*(x273)*(x277)))+(((IkReal(-1.00000000000000))*(x273)*(x278)))+(((IkReal(-1.00000000000000))*(py)*(x272)*(x275)))+(((cj2)*(x276))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x273)*(x276)))+(x274)+(((py)*(sj2)*(x272)))+(((IkReal(-1.00000000000000))*(x275)*(x277)))+(((IkReal(-1.00000000000000))*(x275)*(x278))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x280=((IkReal(633.000000000000))*(sj3));
if( IKabs(((gconst6)*(((((px)*(sj2)*(x280)))+(((cj2)*(py)*(x280))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((IkReal(-1.00000000000000))*(py)*(sj2)*(x280)))+(((cj2)*(px)*(x280))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst6)*(((((px)*(sj2)*(x280)))+(((cj2)*(py)*(x280)))))), ((gconst6)*(((((IkReal(-1.00000000000000))*(py)*(sj2)*(x280)))+(((cj2)*(px)*(x280)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x281=IKsin(j0);
IkReal x282=IKcos(j0);
IkReal x283=((IkReal(1.00000000000000))*(sj2));
IkReal x284=((IkReal(0.316500000000000))*(sj3));
IkReal x285=((IkReal(1.00000000000000))*(cj2));
IkReal x286=((px)*(x281));
IkReal x287=((px)*(x282));
IkReal x288=((py)*(x281));
IkReal x289=((IkReal(1.00000000000000))*(py)*(x282));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x284)))+(x286)+(((IkReal(-1.00000000000000))*(x289))));
evalcond[1]=((((IkReal(-1.00000000000000))*(cj2)*(x284)))+(x288)+(x287));
evalcond[2]=((((cj2)*(x286)))+(((IkReal(-1.00000000000000))*(py)*(x282)*(x285)))+(((IkReal(-1.00000000000000))*(x283)*(x287)))+(((IkReal(-1.00000000000000))*(x283)*(x288))));
evalcond[3]=((((py)*(sj2)*(x282)))+(x284)+(((IkReal(-1.00000000000000))*(x285)*(x287)))+(((IkReal(-1.00000000000000))*(x285)*(x288)))+(((IkReal(-1.00000000000000))*(x283)*(x286))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x290=((IkReal(633.000000000000))*(px));
IkReal x291=((IkReal(633.000000000000))*(py));
IkReal x292=((IkReal(2000.00000000000))*(cj1)*(pz));
IkReal x293=((sj1)*(sj2)*(sj3));
if( IKabs(((gconst1)*(((((x290)*(x293)))+(((IkReal(-1.00000000000000))*(py)*(x292)))+(((IkReal(-816.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(cj3)*(x291))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x291)*(x293)))+(((IkReal(-816.000000000000))*(px)))+(((IkReal(-1.00000000000000))*(cj3)*(x290)))+(((IkReal(-1.00000000000000))*(px)*(x292))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst1)*(((((x290)*(x293)))+(((IkReal(-1.00000000000000))*(py)*(x292)))+(((IkReal(-816.000000000000))*(py)))+(((IkReal(-1.00000000000000))*(cj3)*(x291)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(x291)*(x293)))+(((IkReal(-816.000000000000))*(px)))+(((IkReal(-1.00000000000000))*(cj3)*(x290)))+(((IkReal(-1.00000000000000))*(px)*(x292)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x294=IKcos(j0);
IkReal x295=IKsin(j0);
IkReal x296=((cj1)*(sj2));
IkReal x297=((cj1)*(cj2));
IkReal x298=((cj1)*(pz));
IkReal x299=((IkReal(0.316500000000000))*(cj3));
IkReal x300=((IkReal(1.00000000000000))*(sj2));
IkReal x301=((IkReal(0.816000000000000))*(sj1));
IkReal x302=((IkReal(1.00000000000000))*(cj2));
IkReal x303=((pz)*(sj1));
IkReal x304=((IkReal(0.316500000000000))*(sj3));
IkReal x305=((IkReal(1.00000000000000))*(sj1));
IkReal x306=((px)*(x295));
IkReal x307=((px)*(x294));
IkReal x308=((py)*(x295));
IkReal x309=((py)*(x294));
evalcond[0]=((((IkReal(-1.00000000000000))*(sj2)*(x304)))+(((IkReal(-1.00000000000000))*(x309)))+(x306));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x301)*(x308)))+(((IkReal(-1.00000000000000))*(x301)*(x307)))+(((IkReal(-0.816000000000000))*(x298)))+(((IkReal(-1.00000000000000))*(pp))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x298)))+(((IkReal(-1.00000000000000))*(x299)))+(((IkReal(-1.00000000000000))*(x305)*(x307)))+(((IkReal(-1.00000000000000))*(x305)*(x308))));
evalcond[3]=((((sj1)*(x299)))+(x308)+(x307)+(((x297)*(x304)))+(((IkReal(0.408000000000000))*(sj1))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x302)*(x309)))+(((cj2)*(x306)))+(((x296)*(x307)))+(((x296)*(x308)))+(((IkReal(-1.00000000000000))*(x300)*(x303))));
evalcond[5]=((((sj2)*(x309)))+(((IkReal(-1.00000000000000))*(x302)*(x303)))+(x304)+(((x297)*(x307)))+(((x297)*(x308)))+(((IkReal(-1.00000000000000))*(x300)*(x306))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x310=((IkReal(125000.000000000))*(pp));
IkReal x311=((IkReal(102000.000000000))*(cj1)*(pz));
IkReal x312=((IkReal(32283.0000000000))*(sj1)*(sj2)*(sj3));
if( IKabs(((gconst0)*(((((IkReal(-1.00000000000000))*(py)*(x311)))+(((IkReal(-1.00000000000000))*(py)*(x310)))+(((px)*(x312)))+(((IkReal(-8286.46875000000))*(py))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((IkReal(-1.00000000000000))*(py)*(x312)))+(((IkReal(-1.00000000000000))*(px)*(x310)))+(((IkReal(-1.00000000000000))*(px)*(x311)))+(((IkReal(-8286.46875000000))*(px))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst0)*(((((IkReal(-1.00000000000000))*(py)*(x311)))+(((IkReal(-1.00000000000000))*(py)*(x310)))+(((px)*(x312)))+(((IkReal(-8286.46875000000))*(py)))))), ((gconst0)*(((((IkReal(-1.00000000000000))*(py)*(x312)))+(((IkReal(-1.00000000000000))*(px)*(x310)))+(((IkReal(-1.00000000000000))*(px)*(x311)))+(((IkReal(-8286.46875000000))*(px)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[6];
IkReal x313=IKcos(j0);
IkReal x314=IKsin(j0);
IkReal x315=((cj1)*(sj2));
IkReal x316=((cj1)*(cj2));
IkReal x317=((cj1)*(pz));
IkReal x318=((IkReal(0.316500000000000))*(cj3));
IkReal x319=((IkReal(1.00000000000000))*(sj2));
IkReal x320=((IkReal(0.816000000000000))*(sj1));
IkReal x321=((IkReal(1.00000000000000))*(cj2));
IkReal x322=((pz)*(sj1));
IkReal x323=((IkReal(0.316500000000000))*(sj3));
IkReal x324=((IkReal(1.00000000000000))*(sj1));
IkReal x325=((px)*(x314));
IkReal x326=((px)*(x313));
IkReal x327=((py)*(x314));
IkReal x328=((py)*(x313));
evalcond[0]=((((IkReal(-1.00000000000000))*(x328)))+(x325)+(((IkReal(-1.00000000000000))*(sj2)*(x323))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x320)*(x327)))+(((IkReal(-1.00000000000000))*(x320)*(x326)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(-0.816000000000000))*(x317))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x318)))+(((IkReal(-1.00000000000000))*(x317)))+(((IkReal(-1.00000000000000))*(x324)*(x326)))+(((IkReal(-1.00000000000000))*(x324)*(x327))));
evalcond[3]=((((sj1)*(x318)))+(x326)+(x327)+(((IkReal(0.408000000000000))*(sj1)))+(((x316)*(x323))));
evalcond[4]=((((cj2)*(x325)))+(((IkReal(-1.00000000000000))*(x321)*(x328)))+(((IkReal(-1.00000000000000))*(x319)*(x322)))+(((x315)*(x326)))+(((x315)*(x327))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x321)*(x322)))+(x323)+(((sj2)*(x328)))+(((IkReal(-1.00000000000000))*(x319)*(x325)))+(((x316)*(x327)))+(((x316)*(x326))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
if( IKabs(((IkReal(-1.00000000000000))*(py))) < IKFAST_ATAN2_MAGTHRESH && IKabs(px) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x329=((IkReal(1.00000000000000))*(IKatan2(((IkReal(-1.00000000000000))*(py)), px)));
if( ((((px)*(px))+((py)*(py)))) < (IkReal)-0.00001 )
    continue;
if( (((IkReal(0.316500000000000))*(sj2)*(sj3)*(((IKabs(IKabs(IKsqrt((((px)*(px))+((py)*(py)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((px)*(px))+((py)*(py))))))):(IkReal)1.0e30)))) < -1-IKFAST_SINCOS_THRESH || (((IkReal(0.316500000000000))*(sj2)*(sj3)*(((IKabs(IKabs(IKsqrt((((px)*(px))+((py)*(py)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((px)*(px))+((py)*(py))))))):(IkReal)1.0e30)))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x330=IKasin(((IkReal(0.316500000000000))*(sj2)*(sj3)*(((IKabs(IKabs(IKsqrt((((px)*(px))+((py)*(py)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((px)*(px))+((py)*(py))))))):(IkReal)1.0e30))));
j0array[0]=((((IkReal(-1.00000000000000))*(x329)))+(x330));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x329)))+(((IkReal(-1.00000000000000))*(x330))));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[2];
IkReal x331=(sj2)*(sj2);
IkReal x332=(cj2)*(cj2);
IkReal x333=(py)*(py);
IkReal x334=(px)*(px);
IkReal x335=IKsin(j0);
IkReal x336=IKcos(j0);
IkReal x337=((IkReal(0.316500000000000))*(sj2)*(sj3));
IkReal x338=((IkReal(1.00000000000000))*(x333));
IkReal x339=((px)*(py)*(x331));
IkReal x340=((px)*(py)*(x332));
evalcond[0]=((((IkReal(-1.00000000000000))*(py)*(x337)))+(((x335)*(((x339)+(x340)))))+(((x336)*(((((IkReal(-1.00000000000000))*(x331)*(x338)))+(((IkReal(-1.00000000000000))*(x332)*(x338))))))));
evalcond[1]=((((IkReal(-1.00000000000000))*(px)*(x337)))+(((x336)*(((((IkReal(-1.00000000000000))*(x339)))+(((IkReal(-1.00000000000000))*(x340)))))))+(((x335)*(((((x331)*(x334)))+(((x332)*(x334))))))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst11;
IkReal x341=((py)*(sj0));
IkReal x342=((IkReal(633.000000000000))*(cj3));
IkReal x343=((cj0)*(px));
gconst11=IKsign(((((IkReal(633.000000000000))*(cj2)*(pz)*(sj3)))+(((x341)*(x342)))+(((IkReal(816.000000000000))*(x341)))+(((IkReal(816.000000000000))*(x343)))+(((x342)*(x343)))));
IkReal x344=((cj0)*(px));
IkReal x345=((py)*(sj0));
dummyeval[0]=((((cj2)*(pz)*(sj3)))+(((IkReal(1.28909952606635))*(x345)))+(((IkReal(1.28909952606635))*(x344)))+(((cj3)*(x344)))+(((cj3)*(x345))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst10;
gconst10=IKsign(((IkReal(665856.000000000))+(((IkReal(1033056.00000000))*(cj3)))+(((IkReal(400689.000000000))*((cj3)*(cj3))))+(((IkReal(400689.000000000))*((cj2)*(cj2))*((sj3)*(sj3))))));
dummyeval[0]=((IkReal(1.66177758810449))+((cj3)*(cj3))+((((cj2)*(cj2))*((sj3)*(sj3))))+(((IkReal(2.57819905213270))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal x346=((cj0)*(px));
IkReal x347=((py)*(sj0));
dummyeval[0]=((((cj2)*(pz)*(sj3)))+(((IkReal(1.28909952606635))*(x347)))+(((IkReal(1.28909952606635))*(x346)))+(((cj3)*(x346)))+(((cj3)*(x347))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x348=((py)*(sj0));
IkReal x349=((IkReal(32283.0000000000))*(cj3));
IkReal x350=((cj2)*(sj3));
IkReal x351=((IkReal(64566.0000000000))*(cj3));
IkReal x352=((cj0)*(px));
IkReal x353=((IkReal(204000.000000000))*(pz));
if( IKabs(((((IKabs(((((x348)*(x349)))+(((IkReal(41616.0000000000))*(x348)))+(((IkReal(41616.0000000000))*(x352)))+(((x349)*(x352)))+(((IkReal(32283.0000000000))*(pz)*(x350))))) != 0)?((IkReal)1/(((((x348)*(x349)))+(((IkReal(41616.0000000000))*(x348)))+(((IkReal(41616.0000000000))*(x352)))+(((x349)*(x352)))+(((IkReal(32283.0000000000))*(pz)*(x350)))))):(IkReal)1.0e30))*(((IkReal(-3380.87925000000))+(((IkReal(-39562.5000000000))*(cj3)*(pp)))+(((IkReal(-2622.66735937500))*(cj3)))+(((IkReal(-51000.0000000000))*(pp)))+(((IkReal(102000.000000000))*((pz)*(pz)))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((((IkReal(83232.0000000000))*(x348)))+(((IkReal(83232.0000000000))*(x352)))+(((x351)*(x352)))+(((x348)*(x351)))+(((IkReal(64566.0000000000))*(pz)*(x350))))) != 0)?((IkReal)1/(((((IkReal(83232.0000000000))*(x348)))+(((IkReal(83232.0000000000))*(x352)))+(((x351)*(x352)))+(((x348)*(x351)))+(((IkReal(64566.0000000000))*(pz)*(x350)))))):(IkReal)1.0e30))*(((((IkReal(-5245.33471875000))*(x350)))+(((IkReal(-1.00000000000000))*(x348)*(x353)))+(((IkReal(-79125.0000000000))*(pp)*(x350)))+(((IkReal(-1.00000000000000))*(x352)*(x353))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((x348)*(x349)))+(((IkReal(41616.0000000000))*(x348)))+(((IkReal(41616.0000000000))*(x352)))+(((x349)*(x352)))+(((IkReal(32283.0000000000))*(pz)*(x350))))) != 0)?((IkReal)1/(((((x348)*(x349)))+(((IkReal(41616.0000000000))*(x348)))+(((IkReal(41616.0000000000))*(x352)))+(((x349)*(x352)))+(((IkReal(32283.0000000000))*(pz)*(x350)))))):(IkReal)1.0e30))*(((IkReal(-3380.87925000000))+(((IkReal(-39562.5000000000))*(cj3)*(pp)))+(((IkReal(-2622.66735937500))*(cj3)))+(((IkReal(-51000.0000000000))*(pp)))+(((IkReal(102000.000000000))*((pz)*(pz))))))))+IKsqr(((((IKabs(((((IkReal(83232.0000000000))*(x348)))+(((IkReal(83232.0000000000))*(x352)))+(((x351)*(x352)))+(((x348)*(x351)))+(((IkReal(64566.0000000000))*(pz)*(x350))))) != 0)?((IkReal)1/(((((IkReal(83232.0000000000))*(x348)))+(((IkReal(83232.0000000000))*(x352)))+(((x351)*(x352)))+(((x348)*(x351)))+(((IkReal(64566.0000000000))*(pz)*(x350)))))):(IkReal)1.0e30))*(((((IkReal(-5245.33471875000))*(x350)))+(((IkReal(-1.00000000000000))*(x348)*(x353)))+(((IkReal(-79125.0000000000))*(pp)*(x350)))+(((IkReal(-1.00000000000000))*(x352)*(x353)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j1array[0]=IKatan2(((((IKabs(((((x348)*(x349)))+(((IkReal(41616.0000000000))*(x348)))+(((IkReal(41616.0000000000))*(x352)))+(((x349)*(x352)))+(((IkReal(32283.0000000000))*(pz)*(x350))))) != 0)?((IkReal)1/(((((x348)*(x349)))+(((IkReal(41616.0000000000))*(x348)))+(((IkReal(41616.0000000000))*(x352)))+(((x349)*(x352)))+(((IkReal(32283.0000000000))*(pz)*(x350)))))):(IkReal)1.0e30))*(((IkReal(-3380.87925000000))+(((IkReal(-39562.5000000000))*(cj3)*(pp)))+(((IkReal(-2622.66735937500))*(cj3)))+(((IkReal(-51000.0000000000))*(pp)))+(((IkReal(102000.000000000))*((pz)*(pz))))))), ((((IKabs(((((IkReal(83232.0000000000))*(x348)))+(((IkReal(83232.0000000000))*(x352)))+(((x351)*(x352)))+(((x348)*(x351)))+(((IkReal(64566.0000000000))*(pz)*(x350))))) != 0)?((IkReal)1/(((((IkReal(83232.0000000000))*(x348)))+(((IkReal(83232.0000000000))*(x352)))+(((x351)*(x352)))+(((x348)*(x351)))+(((IkReal(64566.0000000000))*(pz)*(x350)))))):(IkReal)1.0e30))*(((((IkReal(-5245.33471875000))*(x350)))+(((IkReal(-1.00000000000000))*(x348)*(x353)))+(((IkReal(-79125.0000000000))*(pp)*(x350)))+(((IkReal(-1.00000000000000))*(x352)*(x353)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x354=IKcos(j1);
IkReal x355=IKsin(j1);
IkReal x356=((py)*(sj0));
IkReal x357=((cj0)*(px));
IkReal x358=((IkReal(0.316500000000000))*(cj3));
IkReal x359=((cj0)*(py));
IkReal x360=((IkReal(0.316500000000000))*(sj3));
IkReal x361=((px)*(sj0));
IkReal x362=((IkReal(0.816000000000000))*(x355));
IkReal x363=((sj2)*(x354));
IkReal x364=((IkReal(1.00000000000000))*(x355));
IkReal x365=((pz)*(x354));
IkReal x366=((cj2)*(x354));
evalcond[0]=((((IkReal(-0.408000000000000))*(x354)))+(((cj2)*(x355)*(x360)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x354)*(x358))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-0.816000000000000))*(x365)))+(((IkReal(-1.00000000000000))*(x356)*(x362)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(-1.00000000000000))*(x357)*(x362))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x365)))+(((IkReal(-1.00000000000000))*(x358)))+(((IkReal(-1.00000000000000))*(x356)*(x364)))+(((IkReal(-1.00000000000000))*(x357)*(x364))));
evalcond[3]=((((IkReal(0.408000000000000))*(x355)))+(((x355)*(x358)))+(x357)+(x356)+(((x360)*(x366))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj2)*(x359)))+(((IkReal(-1.00000000000000))*(pz)*(sj2)*(x364)))+(((x356)*(x363)))+(((cj2)*(x361)))+(((x357)*(x363))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj2)*(x361)))+(((x356)*(x366)))+(((sj2)*(x359)))+(x360)+(((IkReal(-1.00000000000000))*(cj2)*(pz)*(x364)))+(((x357)*(x366))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x367=((IkReal(1266000.00000000))*(cj3));
IkReal x368=((cj0)*(px));
IkReal x369=((py)*(sj0));
IkReal x370=((IkReal(1266000.00000000))*(cj2)*(sj3));
if( IKabs(((gconst10)*(((((IkReal(-1.00000000000000))*(x367)*(x369)))+(((IkReal(-1.00000000000000))*(x367)*(x368)))+(((pz)*(x370)))+(((IkReal(-1632000.00000000))*(x369)))+(((IkReal(-1632000.00000000))*(x368))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst10)*(((((IkReal(-1.00000000000000))*(x368)*(x370)))+(((IkReal(-1632000.00000000))*(pz)))+(((IkReal(-1.00000000000000))*(x369)*(x370)))+(((IkReal(-1.00000000000000))*(pz)*(x367))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst10)*(((((IkReal(-1.00000000000000))*(x367)*(x369)))+(((IkReal(-1.00000000000000))*(x367)*(x368)))+(((pz)*(x370)))+(((IkReal(-1632000.00000000))*(x369)))+(((IkReal(-1632000.00000000))*(x368)))))), ((gconst10)*(((((IkReal(-1.00000000000000))*(x368)*(x370)))+(((IkReal(-1632000.00000000))*(pz)))+(((IkReal(-1.00000000000000))*(x369)*(x370)))+(((IkReal(-1.00000000000000))*(pz)*(x367)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x371=IKcos(j1);
IkReal x372=IKsin(j1);
IkReal x373=((py)*(sj0));
IkReal x374=((cj0)*(px));
IkReal x375=((IkReal(0.316500000000000))*(cj3));
IkReal x376=((cj0)*(py));
IkReal x377=((IkReal(0.316500000000000))*(sj3));
IkReal x378=((px)*(sj0));
IkReal x379=((IkReal(0.816000000000000))*(x372));
IkReal x380=((sj2)*(x371));
IkReal x381=((IkReal(1.00000000000000))*(x372));
IkReal x382=((pz)*(x371));
IkReal x383=((cj2)*(x371));
evalcond[0]=((((IkReal(-0.408000000000000))*(x371)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-1.00000000000000))*(x371)*(x375)))+(((cj2)*(x372)*(x377))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x374)*(x379)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(-1.00000000000000))*(x373)*(x379)))+(((IkReal(-0.816000000000000))*(x382))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x373)*(x381)))+(((IkReal(-1.00000000000000))*(x374)*(x381)))+(((IkReal(-1.00000000000000))*(x375)))+(((IkReal(-1.00000000000000))*(x382))));
evalcond[3]=((((x377)*(x383)))+(((x372)*(x375)))+(x374)+(x373)+(((IkReal(0.408000000000000))*(x372))));
evalcond[4]=((((x373)*(x380)))+(((IkReal(-1.00000000000000))*(pz)*(sj2)*(x381)))+(((x374)*(x380)))+(((IkReal(-1.00000000000000))*(cj2)*(x376)))+(((cj2)*(x378))));
evalcond[5]=((((x373)*(x383)))+(((IkReal(-1.00000000000000))*(sj2)*(x378)))+(((x374)*(x383)))+(x377)+(((IkReal(-1.00000000000000))*(cj2)*(pz)*(x381)))+(((sj2)*(x376))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x384=((IkReal(2000.00000000000))*(pz));
IkReal x385=((cj2)*(sj3));
if( IKabs(((gconst11)*(((IkReal(-332.928000000000))+(((IkReal(-516.528000000000))*(cj3)))+(((IkReal(-200.344500000000))*((cj3)*(cj3))))+(((pz)*(x384))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst11)*(((((IkReal(-200.344500000000))*(cj3)*(x385)))+(((IkReal(-258.264000000000))*(x385)))+(((IkReal(-1.00000000000000))*(py)*(sj0)*(x384)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x384))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst11)*(((IkReal(-332.928000000000))+(((IkReal(-516.528000000000))*(cj3)))+(((IkReal(-200.344500000000))*((cj3)*(cj3))))+(((pz)*(x384)))))), ((gconst11)*(((((IkReal(-200.344500000000))*(cj3)*(x385)))+(((IkReal(-258.264000000000))*(x385)))+(((IkReal(-1.00000000000000))*(py)*(sj0)*(x384)))+(((IkReal(-1.00000000000000))*(cj0)*(px)*(x384)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x386=IKcos(j1);
IkReal x387=IKsin(j1);
IkReal x388=((py)*(sj0));
IkReal x389=((cj0)*(px));
IkReal x390=((IkReal(0.316500000000000))*(cj3));
IkReal x391=((cj0)*(py));
IkReal x392=((IkReal(0.316500000000000))*(sj3));
IkReal x393=((px)*(sj0));
IkReal x394=((IkReal(0.816000000000000))*(x387));
IkReal x395=((sj2)*(x386));
IkReal x396=((IkReal(1.00000000000000))*(x387));
IkReal x397=((pz)*(x386));
IkReal x398=((cj2)*(x386));
evalcond[0]=((((IkReal(-0.408000000000000))*(x386)))+(((cj2)*(x387)*(x392)))+(((IkReal(-1.00000000000000))*(x386)*(x390)))+(((IkReal(-1.00000000000000))*(pz))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x389)*(x394)))+(((IkReal(-0.816000000000000))*(x397)))+(((IkReal(-1.00000000000000))*(x388)*(x394)))+(((IkReal(-1.00000000000000))*(pp))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x390)))+(((IkReal(-1.00000000000000))*(x397)))+(((IkReal(-1.00000000000000))*(x389)*(x396)))+(((IkReal(-1.00000000000000))*(x388)*(x396))));
evalcond[3]=((((IkReal(0.408000000000000))*(x387)))+(x388)+(x389)+(((x387)*(x390)))+(((x392)*(x398))));
evalcond[4]=((((IkReal(-1.00000000000000))*(cj2)*(x391)))+(((IkReal(-1.00000000000000))*(pz)*(sj2)*(x396)))+(((cj2)*(x393)))+(((x389)*(x395)))+(((x388)*(x395))));
evalcond[5]=((((IkReal(-1.00000000000000))*(sj2)*(x393)))+(x392)+(((sj2)*(x391)))+(((x389)*(x398)))+(((IkReal(-1.00000000000000))*(cj2)*(pz)*(x396)))+(((x388)*(x398))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[2], cj0array[2], sj0array[2];
bool j0valid[2]={false};
_nj0 = 2;
if( IKabs(((IkReal(-1.00000000000000))*(py))) < IKFAST_ATAN2_MAGTHRESH && IKabs(px) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x399=((IkReal(1.00000000000000))*(IKatan2(((IkReal(-1.00000000000000))*(py)), px)));
if( ((((px)*(px))+((py)*(py)))) < (IkReal)-0.00001 )
    continue;
if( (((IkReal(0.316500000000000))*(sj2)*(sj3)*(((IKabs(IKabs(IKsqrt((((px)*(px))+((py)*(py)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((px)*(px))+((py)*(py))))))):(IkReal)1.0e30)))) < -1-IKFAST_SINCOS_THRESH || (((IkReal(0.316500000000000))*(sj2)*(sj3)*(((IKabs(IKabs(IKsqrt((((px)*(px))+((py)*(py)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((px)*(px))+((py)*(py))))))):(IkReal)1.0e30)))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x400=IKasin(((IkReal(0.316500000000000))*(sj2)*(sj3)*(((IKabs(IKabs(IKsqrt((((px)*(px))+((py)*(py)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((px)*(px))+((py)*(py))))))):(IkReal)1.0e30))));
j0array[0]=((((IkReal(-1.00000000000000))*(x399)))+(x400));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
j0array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x399)))+(((IkReal(-1.00000000000000))*(x400))));
sj0array[1]=IKsin(j0array[1]);
cj0array[1]=IKcos(j0array[1]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
if( j0array[1] > IKPI )
{
    j0array[1]-=IK2PI;
}
else if( j0array[1] < -IKPI )
{    j0array[1]+=IK2PI;
}
j0valid[1] = true;
for(int ij0 = 0; ij0 < 2; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 2; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];

{
IkReal dummyeval[1];
IkReal gconst11;
IkReal x401=((py)*(sj0));
IkReal x402=((IkReal(633.000000000000))*(cj3));
IkReal x403=((cj0)*(px));
gconst11=IKsign(((((IkReal(633.000000000000))*(cj2)*(pz)*(sj3)))+(((IkReal(816.000000000000))*(x401)))+(((IkReal(816.000000000000))*(x403)))+(((x402)*(x403)))+(((x401)*(x402)))));
IkReal x404=((cj0)*(px));
IkReal x405=((py)*(sj0));
dummyeval[0]=((((IkReal(1.28909952606635))*(x404)))+(((IkReal(1.28909952606635))*(x405)))+(((cj2)*(pz)*(sj3)))+(((cj3)*(x404)))+(((cj3)*(x405))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst10;
gconst10=IKsign(((IkReal(665856.000000000))+(((IkReal(1033056.00000000))*(cj3)))+(((IkReal(400689.000000000))*((cj3)*(cj3))))+(((IkReal(400689.000000000))*((cj2)*(cj2))*((sj3)*(sj3))))));
dummyeval[0]=((IkReal(1.66177758810449))+((cj3)*(cj3))+((((cj2)*(cj2))*((sj3)*(sj3))))+(((IkReal(2.57819905213270))*(cj3))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal x406=((cj0)*(px));
IkReal x407=((py)*(sj0));
dummyeval[0]=((((IkReal(1.28909952606635))*(x406)))+(((IkReal(1.28909952606635))*(x407)))+(((cj2)*(pz)*(sj3)))+(((cj3)*(x407)))+(((cj3)*(x406))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x408=((py)*(sj0));
IkReal x409=((IkReal(32283.0000000000))*(cj3));
IkReal x410=((cj2)*(sj3));
IkReal x411=((IkReal(64566.0000000000))*(cj3));
IkReal x412=((cj0)*(px));
IkReal x413=((IkReal(204000.000000000))*(pz));
if( IKabs(((((IKabs(((((IkReal(41616.0000000000))*(x412)))+(((x409)*(x412)))+(((x408)*(x409)))+(((IkReal(41616.0000000000))*(x408)))+(((IkReal(32283.0000000000))*(pz)*(x410))))) != 0)?((IkReal)1/(((((IkReal(41616.0000000000))*(x412)))+(((x409)*(x412)))+(((x408)*(x409)))+(((IkReal(41616.0000000000))*(x408)))+(((IkReal(32283.0000000000))*(pz)*(x410)))))):(IkReal)1.0e30))*(((IkReal(-3380.87925000000))+(((IkReal(-39562.5000000000))*(cj3)*(pp)))+(((IkReal(-2622.66735937500))*(cj3)))+(((IkReal(-51000.0000000000))*(pp)))+(((IkReal(102000.000000000))*((pz)*(pz)))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IKabs(((((x411)*(x412)))+(((IkReal(83232.0000000000))*(x412)))+(((x408)*(x411)))+(((IkReal(83232.0000000000))*(x408)))+(((IkReal(64566.0000000000))*(pz)*(x410))))) != 0)?((IkReal)1/(((((x411)*(x412)))+(((IkReal(83232.0000000000))*(x412)))+(((x408)*(x411)))+(((IkReal(83232.0000000000))*(x408)))+(((IkReal(64566.0000000000))*(pz)*(x410)))))):(IkReal)1.0e30))*(((((IkReal(-5245.33471875000))*(x410)))+(((IkReal(-1.00000000000000))*(x412)*(x413)))+(((IkReal(-79125.0000000000))*(pp)*(x410)))+(((IkReal(-1.00000000000000))*(x408)*(x413))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IKabs(((((IkReal(41616.0000000000))*(x412)))+(((x409)*(x412)))+(((x408)*(x409)))+(((IkReal(41616.0000000000))*(x408)))+(((IkReal(32283.0000000000))*(pz)*(x410))))) != 0)?((IkReal)1/(((((IkReal(41616.0000000000))*(x412)))+(((x409)*(x412)))+(((x408)*(x409)))+(((IkReal(41616.0000000000))*(x408)))+(((IkReal(32283.0000000000))*(pz)*(x410)))))):(IkReal)1.0e30))*(((IkReal(-3380.87925000000))+(((IkReal(-39562.5000000000))*(cj3)*(pp)))+(((IkReal(-2622.66735937500))*(cj3)))+(((IkReal(-51000.0000000000))*(pp)))+(((IkReal(102000.000000000))*((pz)*(pz))))))))+IKsqr(((((IKabs(((((x411)*(x412)))+(((IkReal(83232.0000000000))*(x412)))+(((x408)*(x411)))+(((IkReal(83232.0000000000))*(x408)))+(((IkReal(64566.0000000000))*(pz)*(x410))))) != 0)?((IkReal)1/(((((x411)*(x412)))+(((IkReal(83232.0000000000))*(x412)))+(((x408)*(x411)))+(((IkReal(83232.0000000000))*(x408)))+(((IkReal(64566.0000000000))*(pz)*(x410)))))):(IkReal)1.0e30))*(((((IkReal(-5245.33471875000))*(x410)))+(((IkReal(-1.00000000000000))*(x412)*(x413)))+(((IkReal(-79125.0000000000))*(pp)*(x410)))+(((IkReal(-1.00000000000000))*(x408)*(x413)))))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j1array[0]=IKatan2(((((IKabs(((((IkReal(41616.0000000000))*(x412)))+(((x409)*(x412)))+(((x408)*(x409)))+(((IkReal(41616.0000000000))*(x408)))+(((IkReal(32283.0000000000))*(pz)*(x410))))) != 0)?((IkReal)1/(((((IkReal(41616.0000000000))*(x412)))+(((x409)*(x412)))+(((x408)*(x409)))+(((IkReal(41616.0000000000))*(x408)))+(((IkReal(32283.0000000000))*(pz)*(x410)))))):(IkReal)1.0e30))*(((IkReal(-3380.87925000000))+(((IkReal(-39562.5000000000))*(cj3)*(pp)))+(((IkReal(-2622.66735937500))*(cj3)))+(((IkReal(-51000.0000000000))*(pp)))+(((IkReal(102000.000000000))*((pz)*(pz))))))), ((((IKabs(((((x411)*(x412)))+(((IkReal(83232.0000000000))*(x412)))+(((x408)*(x411)))+(((IkReal(83232.0000000000))*(x408)))+(((IkReal(64566.0000000000))*(pz)*(x410))))) != 0)?((IkReal)1/(((((x411)*(x412)))+(((IkReal(83232.0000000000))*(x412)))+(((x408)*(x411)))+(((IkReal(83232.0000000000))*(x408)))+(((IkReal(64566.0000000000))*(pz)*(x410)))))):(IkReal)1.0e30))*(((((IkReal(-5245.33471875000))*(x410)))+(((IkReal(-1.00000000000000))*(x412)*(x413)))+(((IkReal(-79125.0000000000))*(pp)*(x410)))+(((IkReal(-1.00000000000000))*(x408)*(x413)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x414=IKcos(j1);
IkReal x415=IKsin(j1);
IkReal x416=((py)*(sj0));
IkReal x417=((cj0)*(px));
IkReal x418=((IkReal(0.316500000000000))*(cj3));
IkReal x419=((cj0)*(py));
IkReal x420=((IkReal(0.316500000000000))*(sj3));
IkReal x421=((px)*(sj0));
IkReal x422=((IkReal(0.816000000000000))*(x415));
IkReal x423=((sj2)*(x414));
IkReal x424=((IkReal(1.00000000000000))*(x415));
IkReal x425=((pz)*(x414));
IkReal x426=((cj2)*(x414));
evalcond[0]=((((cj2)*(x415)*(x420)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.408000000000000))*(x414)))+(((IkReal(-1.00000000000000))*(x414)*(x418))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(x416)*(x422)))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(-1.00000000000000))*(x417)*(x422)))+(((IkReal(-0.816000000000000))*(x425))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x425)))+(((IkReal(-1.00000000000000))*(x416)*(x424)))+(((IkReal(-1.00000000000000))*(x417)*(x424)))+(((IkReal(-1.00000000000000))*(x418))));
evalcond[3]=((((x420)*(x426)))+(((IkReal(0.408000000000000))*(x415)))+(((x415)*(x418)))+(x416)+(x417));
evalcond[4]=((((x416)*(x423)))+(((IkReal(-1.00000000000000))*(cj2)*(x419)))+(((cj2)*(x421)))+(((IkReal(-1.00000000000000))*(pz)*(sj2)*(x424)))+(((x417)*(x423))));
evalcond[5]=((((sj2)*(x419)))+(((x416)*(x426)))+(x420)+(((IkReal(-1.00000000000000))*(sj2)*(x421)))+(((IkReal(-1.00000000000000))*(cj2)*(pz)*(x424)))+(((x417)*(x426))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x427=((IkReal(1266000.00000000))*(cj3));
IkReal x428=((cj0)*(px));
IkReal x429=((py)*(sj0));
IkReal x430=((IkReal(1266000.00000000))*(cj2)*(sj3));
if( IKabs(((gconst10)*(((((IkReal(-1632000.00000000))*(x429)))+(((IkReal(-1632000.00000000))*(x428)))+(((IkReal(-1.00000000000000))*(x427)*(x428)))+(((IkReal(-1.00000000000000))*(x427)*(x429)))+(((pz)*(x430))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst10)*(((((IkReal(-1632000.00000000))*(pz)))+(((IkReal(-1.00000000000000))*(x429)*(x430)))+(((IkReal(-1.00000000000000))*(x428)*(x430)))+(((IkReal(-1.00000000000000))*(pz)*(x427))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst10)*(((((IkReal(-1632000.00000000))*(x429)))+(((IkReal(-1632000.00000000))*(x428)))+(((IkReal(-1.00000000000000))*(x427)*(x428)))+(((IkReal(-1.00000000000000))*(x427)*(x429)))+(((pz)*(x430)))))), ((gconst10)*(((((IkReal(-1632000.00000000))*(pz)))+(((IkReal(-1.00000000000000))*(x429)*(x430)))+(((IkReal(-1.00000000000000))*(x428)*(x430)))+(((IkReal(-1.00000000000000))*(pz)*(x427)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x431=IKcos(j1);
IkReal x432=IKsin(j1);
IkReal x433=((py)*(sj0));
IkReal x434=((cj0)*(px));
IkReal x435=((IkReal(0.316500000000000))*(cj3));
IkReal x436=((cj0)*(py));
IkReal x437=((IkReal(0.316500000000000))*(sj3));
IkReal x438=((px)*(sj0));
IkReal x439=((IkReal(0.816000000000000))*(x432));
IkReal x440=((sj2)*(x431));
IkReal x441=((IkReal(1.00000000000000))*(x432));
IkReal x442=((pz)*(x431));
IkReal x443=((cj2)*(x431));
evalcond[0]=((((IkReal(-1.00000000000000))*(x431)*(x435)))+(((cj2)*(x432)*(x437)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.408000000000000))*(x431))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-0.816000000000000))*(x442)))+(((IkReal(-1.00000000000000))*(x433)*(x439)))+(((IkReal(-1.00000000000000))*(x434)*(x439)))+(((IkReal(-1.00000000000000))*(pp))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x435)))+(((IkReal(-1.00000000000000))*(x433)*(x441)))+(((IkReal(-1.00000000000000))*(x442)))+(((IkReal(-1.00000000000000))*(x434)*(x441))));
evalcond[3]=((x433)+(x434)+(((IkReal(0.408000000000000))*(x432)))+(((x437)*(x443)))+(((x432)*(x435))));
evalcond[4]=((((x434)*(x440)))+(((cj2)*(x438)))+(((IkReal(-1.00000000000000))*(cj2)*(x436)))+(((x433)*(x440)))+(((IkReal(-1.00000000000000))*(pz)*(sj2)*(x441))));
evalcond[5]=((((x434)*(x443)))+(x437)+(((sj2)*(x436)))+(((IkReal(-1.00000000000000))*(sj2)*(x438)))+(((x433)*(x443)))+(((IkReal(-1.00000000000000))*(cj2)*(pz)*(x441))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}

} else
{
{
IkReal j1array[1], cj1array[1], sj1array[1];
bool j1valid[1]={false};
_nj1 = 1;
IkReal x444=((IkReal(2000.00000000000))*(pz));
IkReal x445=((cj2)*(sj3));
if( IKabs(((gconst11)*(((IkReal(-332.928000000000))+(((IkReal(-516.528000000000))*(cj3)))+(((IkReal(-200.344500000000))*((cj3)*(cj3))))+(((pz)*(x444))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst11)*(((((IkReal(-1.00000000000000))*(cj0)*(px)*(x444)))+(((IkReal(-1.00000000000000))*(py)*(sj0)*(x444)))+(((IkReal(-258.264000000000))*(x445)))+(((IkReal(-200.344500000000))*(cj3)*(x445))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j1array[0]=IKatan2(((gconst11)*(((IkReal(-332.928000000000))+(((IkReal(-516.528000000000))*(cj3)))+(((IkReal(-200.344500000000))*((cj3)*(cj3))))+(((pz)*(x444)))))), ((gconst11)*(((((IkReal(-1.00000000000000))*(cj0)*(px)*(x444)))+(((IkReal(-1.00000000000000))*(py)*(sj0)*(x444)))+(((IkReal(-258.264000000000))*(x445)))+(((IkReal(-200.344500000000))*(cj3)*(x445)))))));
sj1array[0]=IKsin(j1array[0]);
cj1array[0]=IKcos(j1array[0]);
if( j1array[0] > IKPI )
{
    j1array[0]-=IK2PI;
}
else if( j1array[0] < -IKPI )
{    j1array[0]+=IK2PI;
}
j1valid[0] = true;
for(int ij1 = 0; ij1 < 1; ++ij1)
{
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
for(int iij1 = ij1+1; iij1 < 1; ++iij1)
{
if( j1valid[iij1] && IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH )
{
    j1valid[iij1]=false; _ij1[1] = iij1; break; 
}
}
j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];
{
IkReal evalcond[6];
IkReal x446=IKcos(j1);
IkReal x447=IKsin(j1);
IkReal x448=((py)*(sj0));
IkReal x449=((cj0)*(px));
IkReal x450=((IkReal(0.316500000000000))*(cj3));
IkReal x451=((cj0)*(py));
IkReal x452=((IkReal(0.316500000000000))*(sj3));
IkReal x453=((px)*(sj0));
IkReal x454=((IkReal(0.816000000000000))*(x447));
IkReal x455=((sj2)*(x446));
IkReal x456=((IkReal(1.00000000000000))*(x447));
IkReal x457=((pz)*(x446));
IkReal x458=((cj2)*(x446));
evalcond[0]=((((IkReal(-1.00000000000000))*(x446)*(x450)))+(((cj2)*(x447)*(x452)))+(((IkReal(-1.00000000000000))*(pz)))+(((IkReal(-0.408000000000000))*(x446))));
evalcond[1]=((IkReal(-0.0662917500000000))+(((IkReal(-1.00000000000000))*(pp)))+(((IkReal(-0.816000000000000))*(x457)))+(((IkReal(-1.00000000000000))*(x449)*(x454)))+(((IkReal(-1.00000000000000))*(x448)*(x454))));
evalcond[2]=((IkReal(-0.408000000000000))+(((IkReal(-1.00000000000000))*(x457)))+(((IkReal(-1.00000000000000))*(x450)))+(((IkReal(-1.00000000000000))*(x449)*(x456)))+(((IkReal(-1.00000000000000))*(x448)*(x456))));
evalcond[3]=((((x452)*(x458)))+(((x447)*(x450)))+(x449)+(x448)+(((IkReal(0.408000000000000))*(x447))));
evalcond[4]=((((IkReal(-1.00000000000000))*(pz)*(sj2)*(x456)))+(((IkReal(-1.00000000000000))*(cj2)*(x451)))+(((cj2)*(x453)))+(((x449)*(x455)))+(((x448)*(x455))));
evalcond[5]=((((sj2)*(x451)))+(((IkReal(-1.00000000000000))*(cj2)*(pz)*(x456)))+(((IkReal(-1.00000000000000))*(sj2)*(x453)))+(x452)+(((x449)*(x458)))+(((x448)*(x458))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

rotationfunction0(solutions);
}
}

}

}
}
}

}

}
}
}
}
return solutions.GetNumSolutions()>0;
}
inline void rotationfunction0(IkSolutionListBase<IkReal>& solutions) {
for(int rotationiter = 0; rotationiter < 1; ++rotationiter) {
IkReal x82=((cj3)*(sj1));
IkReal x83=((sj0)*(sj2));
IkReal x84=((IkReal(1.00000000000000))*(sj3));
IkReal x85=((IkReal(1.00000000000000))*(cj2));
IkReal x86=((cj1)*(cj3));
IkReal x87=((cj0)*(sj2));
IkReal x88=((cj1)*(sj3));
IkReal x89=((IkReal(1.00000000000000))*(sj1)*(sj2));
IkReal x90=((((sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(x85)*(x86))));
IkReal x91=((((cj2)*(x82)))+(x88));
IkReal x92=((((IkReal(-1.00000000000000))*(cj0)*(x85)))+(((cj1)*(x83))));
IkReal x93=((((cj2)*(sj0)))+(((cj1)*(x87))));
IkReal x94=((((cj2)*(x88)))+(x82));
IkReal x95=((x86)+(((IkReal(-1.00000000000000))*(cj2)*(sj1)*(x84))));
IkReal x96=((sj0)*(x90));
IkReal x97=((((cj3)*(x83)))+(((cj0)*(x90))));
IkReal x98=((x96)+(((IkReal(-1.00000000000000))*(cj3)*(x87))));
IkReal x99=((((IkReal(-1.00000000000000))*(x83)*(x84)))+(((cj0)*(x94))));
IkReal x100=((((sj0)*(x94)))+(((sj3)*(x87))));
new_r00=((((r10)*(x98)))+(((r00)*(x97)))+(((r20)*(x91))));
new_r01=((((r21)*(x91)))+(((r11)*(((x96)+(((IkReal(-1.00000000000000))*(cj3)*(x87)))))))+(((r01)*(x97))));
new_r02=((((r12)*(x98)))+(((r02)*(x97)))+(((r22)*(x91))));
new_r10=((((r10)*(x92)))+(((r00)*(x93)))+(((IkReal(-1.00000000000000))*(r20)*(x89))));
new_r11=((((r11)*(x92)))+(((r01)*(x93)))+(((IkReal(-1.00000000000000))*(r21)*(x89))));
new_r12=((((r12)*(x92)))+(((IkReal(-1.00000000000000))*(r22)*(x89)))+(((r02)*(x93))));
new_r20=((((r10)*(x100)))+(((r00)*(x99)))+(((r20)*(x95))));
new_r21=((((r21)*(x95)))+(((r01)*(x99)))+(((r11)*(x100))));
new_r22=((((r12)*(x100)))+(((r02)*(x99)))+(((r22)*(x95))));
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
cj5array[0]=new_r22;
if( cj5array[0] >= -1-IKFAST_SINCOS_THRESH && cj5array[0] <= 1+IKFAST_SINCOS_THRESH )
{
    j5valid[0] = j5valid[1] = true;
    j5array[0] = IKacos(cj5array[0]);
    sj5array[0] = IKsin(j5array[0]);
    cj5array[1] = cj5array[0];
    j5array[1] = -j5array[0];
    sj5array[1] = -sj5array[0];
}
else if( isnan(cj5array[0]) )
{
    // probably any value will work
    j5valid[0] = true;
    cj5array[0] = 1; sj5array[0] = 0; j5array[0] = 0;
}
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];

{
IkReal dummyeval[1];
IkReal gconst14;
gconst14=IKsign(sj5);
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst12;
gconst12=IKsign(((((IkReal(-1.00000000000000))*((new_r02)*(new_r02))))+(((IkReal(-1.00000000000000))*((new_r12)*(new_r12))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((new_r02)*(new_r02))))+(((IkReal(-1.00000000000000))*((new_r12)*(new_r12)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst13;
gconst13=IKsign(((((cj5)*((new_r02)*(new_r02))))+(((cj5)*((new_r12)*(new_r12))))));
dummyeval[0]=((((cj5)*((new_r02)*(new_r02))))+(((cj5)*((new_r12)*(new_r12)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[7];
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.57079632679490))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=new_r22;
evalcond[2]=new_r22;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  )
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((IkReal(-1.00000000000000))*(new_r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r20) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((IkReal(-1.00000000000000))*(new_r21)))+IKsqr(new_r20)-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((IkReal(-1.00000000000000))*(new_r21)), new_r20);
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[2];
evalcond[0]=((IKsin(j6))+(new_r21));
evalcond[1]=((((IkReal(-1.00000000000000))*(IKcos(j6))))+(new_r20));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst20;
gconst20=IKsign(((((IkReal(-1.00000000000000))*(new_r01)*(new_r12)))+(((new_r02)*(new_r11)))));
dummyeval[0]=((((IkReal(-1.00000000000000))*(new_r01)*(new_r12)))+(((new_r02)*(new_r11))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst21;
gconst21=IKsign(((((IkReal(-1.00000000000000))*(new_r00)*(new_r12)))+(((new_r02)*(new_r10)))));
dummyeval[0]=((((IkReal(-1.00000000000000))*(new_r00)*(new_r12)))+(((new_r02)*(new_r10))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst21)*(new_r00))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))*(gconst21)*(new_r10))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst21)*(new_r00)), ((IkReal(-1.00000000000000))*(gconst21)*(new_r10)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x101=IKcos(j4);
IkReal x102=IKsin(j4);
IkReal x103=((IkReal(1.00000000000000))*(x101));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r02)*(x102)))+(((new_r12)*(x101))));
evalcond[1]=((IkReal(1.00000000000000))+(((new_r02)*(x101)))+(((new_r12)*(x102))));
evalcond[2]=((sj6)+(((IkReal(-1.00000000000000))*(new_r10)*(x103)))+(((new_r00)*(x102))));
evalcond[3]=((((IkReal(-1.00000000000000))*(new_r11)*(x103)))+(cj6)+(((new_r01)*(x102))));
evalcond[4]=((((new_r01)*(x101)))+(((new_r11)*(x102))));
evalcond[5]=((((new_r10)*(x102)))+(((new_r00)*(x101))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst20)*(new_r01))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))*(gconst20)*(new_r11))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst20)*(new_r01)), ((IkReal(-1.00000000000000))*(gconst20)*(new_r11)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x104=IKcos(j4);
IkReal x105=IKsin(j4);
IkReal x106=((IkReal(1.00000000000000))*(x104));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r02)*(x105)))+(((new_r12)*(x104))));
evalcond[1]=((IkReal(1.00000000000000))+(((new_r02)*(x104)))+(((new_r12)*(x105))));
evalcond[2]=((sj6)+(((IkReal(-1.00000000000000))*(new_r10)*(x106)))+(((new_r00)*(x105))));
evalcond[3]=((((IkReal(-1.00000000000000))*(new_r11)*(x106)))+(cj6)+(((new_r01)*(x105))));
evalcond[4]=((((new_r01)*(x104)))+(((new_r11)*(x105))));
evalcond[5]=((((new_r10)*(x105)))+(((new_r00)*(x104))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(4.71238898038469))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=new_r22;
evalcond[2]=((IkReal(-1.00000000000000))*(new_r22));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  )
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(new_r21) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))*(new_r20))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(new_r21)+IKsqr(((IkReal(-1.00000000000000))*(new_r20)))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(new_r21, ((IkReal(-1.00000000000000))*(new_r20)));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[2];
evalcond[0]=((new_r21)+(((IkReal(-1.00000000000000))*(IKsin(j6)))));
evalcond[1]=((IKcos(j6))+(new_r20));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst24;
gconst24=IKsign(((((new_r01)*(new_r12)))+(((IkReal(-1.00000000000000))*(new_r02)*(new_r11)))));
dummyeval[0]=((((new_r01)*(new_r12)))+(((IkReal(-1.00000000000000))*(new_r02)*(new_r11))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst25;
gconst25=IKsign(((((new_r00)*(new_r12)))+(((IkReal(-1.00000000000000))*(new_r02)*(new_r10)))));
dummyeval[0]=((((new_r00)*(new_r12)))+(((IkReal(-1.00000000000000))*(new_r02)*(new_r10))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst25)*(new_r00))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))*(gconst25)*(new_r10))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst25)*(new_r00)), ((IkReal(-1.00000000000000))*(gconst25)*(new_r10)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x107=IKcos(j4);
IkReal x108=IKsin(j4);
IkReal x109=((IkReal(1.00000000000000))*(x107));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r02)*(x108)))+(((new_r12)*(x107))));
evalcond[1]=((IkReal(-1.00000000000000))+(((new_r02)*(x107)))+(((new_r12)*(x108))));
evalcond[2]=((sj6)+(((IkReal(-1.00000000000000))*(new_r10)*(x109)))+(((new_r00)*(x108))));
evalcond[3]=((((IkReal(-1.00000000000000))*(new_r11)*(x109)))+(cj6)+(((new_r01)*(x108))));
evalcond[4]=((((new_r01)*(x107)))+(((new_r11)*(x108))));
evalcond[5]=((((new_r10)*(x108)))+(((new_r00)*(x107))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst24)*(new_r01))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))*(gconst24)*(new_r11))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst24)*(new_r01)), ((IkReal(-1.00000000000000))*(gconst24)*(new_r11)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x110=IKcos(j4);
IkReal x111=IKsin(j4);
IkReal x112=((IkReal(1.00000000000000))*(x110));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r02)*(x111)))+(((new_r12)*(x110))));
evalcond[1]=((IkReal(-1.00000000000000))+(((new_r02)*(x110)))+(((new_r12)*(x111))));
evalcond[2]=((sj6)+(((IkReal(-1.00000000000000))*(new_r10)*(x112)))+(((new_r00)*(x111))));
evalcond[3]=((cj6)+(((IkReal(-1.00000000000000))*(new_r11)*(x112)))+(((new_r01)*(x111))));
evalcond[4]=((((new_r11)*(x111)))+(((new_r01)*(x110))));
evalcond[5]=((((new_r10)*(x111)))+(((new_r00)*(x110))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

} else
{
IkReal x113=((IkReal(-1.00000000000000))+(new_r22));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=x113;
evalcond[2]=new_r21;
evalcond[3]=new_r20;
evalcond[4]=new_r20;
evalcond[5]=new_r21;
evalcond[6]=x113;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
if( IKabs(new_r02) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r12) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x114=IKatan2(new_r02, new_r12);
j4array[0]=((IkReal(-1.00000000000000))*(x114));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x114))));
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
evalcond[0]=((((new_r12)*(IKcos(j4))))+(((IkReal(-1.00000000000000))*(new_r02)*(IKsin(j4)))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
IkReal x115=((IkReal(1.00000000000000))*(sj4));
if( IKabs(((((IkReal(-1.00000000000000))*(new_r00)*(x115)))+(((cj4)*(new_r10))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(new_r01)*(x115)))+(((cj4)*(new_r11))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((IkReal(-1.00000000000000))*(new_r00)*(x115)))+(((cj4)*(new_r10)))))+IKsqr(((((IkReal(-1.00000000000000))*(new_r01)*(x115)))+(((cj4)*(new_r11)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((IkReal(-1.00000000000000))*(new_r00)*(x115)))+(((cj4)*(new_r10)))), ((((IkReal(-1.00000000000000))*(new_r01)*(x115)))+(((cj4)*(new_r11)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[4];
IkReal x116=IKsin(j6);
IkReal x117=IKcos(j6);
IkReal x118=((IkReal(1.00000000000000))*(cj4));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r10)*(x118)))+(((new_r00)*(sj4)))+(x116));
evalcond[1]=((((IkReal(-1.00000000000000))*(new_r11)*(x118)))+(((new_r01)*(sj4)))+(x117));
evalcond[2]=((((cj4)*(new_r01)))+(((new_r11)*(sj4)))+(x116));
evalcond[3]=((((cj4)*(new_r00)))+(((new_r10)*(sj4)))+(((IkReal(-1.00000000000000))*(x117))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

} else
{
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(1.00000000000000))+(new_r22));
evalcond[2]=new_r21;
evalcond[3]=new_r20;
evalcond[4]=((IkReal(-1.00000000000000))*(new_r20));
evalcond[5]=((IkReal(-1.00000000000000))*(new_r21));
evalcond[6]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(new_r22))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  )
{
{
IkReal j4array[2], cj4array[2], sj4array[2];
bool j4valid[2]={false};
_nj4 = 2;
if( IKabs(new_r02) < IKFAST_ATAN2_MAGTHRESH && IKabs(new_r12) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x119=IKatan2(new_r02, new_r12);
j4array[0]=((IkReal(-1.00000000000000))*(x119));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
j4array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x119))));
sj4array[1]=IKsin(j4array[1]);
cj4array[1]=IKcos(j4array[1]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
if( j4array[1] > IKPI )
{
    j4array[1]-=IK2PI;
}
else if( j4array[1] < -IKPI )
{    j4array[1]+=IK2PI;
}
j4valid[1] = true;
for(int ij4 = 0; ij4 < 2; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 2; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[1];
evalcond[0]=((((new_r12)*(IKcos(j4))))+(((IkReal(-1.00000000000000))*(new_r02)*(IKsin(j4)))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
IkReal x120=((IkReal(1.00000000000000))*(sj4));
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x120))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(new_r01)*(x120)))+(((cj4)*(new_r11))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x120)))))+IKsqr(((((IkReal(-1.00000000000000))*(new_r01)*(x120)))+(((cj4)*(new_r11)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x120)))), ((((IkReal(-1.00000000000000))*(new_r01)*(x120)))+(((cj4)*(new_r11)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[4];
IkReal x121=IKsin(j6);
IkReal x122=IKcos(j6);
IkReal x123=((IkReal(1.00000000000000))*(cj4));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r10)*(x123)))+(((new_r00)*(sj4)))+(x121));
evalcond[1]=((((new_r01)*(sj4)))+(x122)+(((IkReal(-1.00000000000000))*(new_r11)*(x123))));
evalcond[2]=((((cj4)*(new_r01)))+(((new_r11)*(sj4)))+(((IkReal(-1.00000000000000))*(x121))));
evalcond[3]=((((cj4)*(new_r00)))+(((new_r10)*(sj4)))+(x122));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}
}
}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x124=((IkReal(-1.00000000000000))*(gconst13)*(new_r22)*(sj5));
if( IKabs(((new_r12)*(x124))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((new_r02)*(x124))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((new_r12)*(x124)), ((new_r02)*(x124)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x125=IKcos(j4);
IkReal x126=IKsin(j4);
IkReal x127=((IkReal(1.00000000000000))*(sj5));
IkReal x128=((new_r12)*(x126));
IkReal x129=((new_r02)*(x125));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r02)*(x126)))+(((new_r12)*(x125))));
evalcond[1]=((sj5)+(x128)+(x129));
evalcond[2]=((((new_r22)*(sj5)))+(((cj5)*(x128)))+(((cj5)*(x129))));
evalcond[3]=((((cj5)*(new_r20)))+(((IkReal(-1.00000000000000))*(new_r00)*(x125)*(x127)))+(((IkReal(-1.00000000000000))*(new_r10)*(x126)*(x127))));
evalcond[4]=((((cj5)*(new_r21)))+(((IkReal(-1.00000000000000))*(new_r01)*(x125)*(x127)))+(((IkReal(-1.00000000000000))*(new_r11)*(x126)*(x127))));
evalcond[5]=((IkReal(-1.00000000000000))+(((cj5)*(new_r22)))+(((IkReal(-1.00000000000000))*(x127)*(x129)))+(((IkReal(-1.00000000000000))*(x127)*(x128))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst15;
gconst15=IKsign(sj5);
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[11];
IkReal x130=((IkReal(-1.00000000000000))+(new_r22));
IkReal x131=((new_r02)*(sj4));
IkReal x132=((cj4)*(new_r12));
IkReal x133=((((new_r12)*(sj4)))+(((cj4)*(new_r02))));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=x130;
evalcond[2]=new_r21;
evalcond[3]=new_r20;
evalcond[4]=((x132)+(((IkReal(-1.00000000000000))*(x131))));
evalcond[5]=((x131)+(((IkReal(-1.00000000000000))*(x132))));
evalcond[6]=x133;
evalcond[7]=x133;
evalcond[8]=new_r20;
evalcond[9]=new_r21;
evalcond[10]=x130;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
IkReal x134=((IkReal(1.00000000000000))*(sj4));
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x134))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(new_r01)*(x134)))+(((cj4)*(new_r11))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x134)))))+IKsqr(((((IkReal(-1.00000000000000))*(new_r01)*(x134)))+(((cj4)*(new_r11)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x134)))), ((((IkReal(-1.00000000000000))*(new_r01)*(x134)))+(((cj4)*(new_r11)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[4];
IkReal x135=IKsin(j6);
IkReal x136=IKcos(j6);
IkReal x137=((IkReal(1.00000000000000))*(cj4));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r10)*(x137)))+(((new_r00)*(sj4)))+(x135));
evalcond[1]=((((IkReal(-1.00000000000000))*(new_r11)*(x137)))+(((new_r01)*(sj4)))+(x136));
evalcond[2]=((((cj4)*(new_r01)))+(((new_r11)*(sj4)))+(x135));
evalcond[3]=((((cj4)*(new_r00)))+(((new_r10)*(sj4)))+(((IkReal(-1.00000000000000))*(x136))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x138=((cj4)*(new_r02));
IkReal x139=((IkReal(1.00000000000000))*(new_r12));
IkReal x140=((new_r02)*(sj4));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(1.00000000000000))+(new_r22));
evalcond[2]=new_r21;
evalcond[3]=new_r20;
evalcond[4]=((((cj4)*(new_r12)))+(((IkReal(-1.00000000000000))*(x140))));
evalcond[5]=((x140)+(((IkReal(-1.00000000000000))*(cj4)*(x139))));
evalcond[6]=((((new_r12)*(sj4)))+(x138));
evalcond[7]=((((IkReal(-1.00000000000000))*(sj4)*(x139)))+(((IkReal(-1.00000000000000))*(x138))));
evalcond[8]=((IkReal(-1.00000000000000))*(new_r20));
evalcond[9]=((IkReal(-1.00000000000000))*(new_r21));
evalcond[10]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(new_r22))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
IkReal x141=((IkReal(1.00000000000000))*(sj4));
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x141))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(new_r01)*(x141)))+(((cj4)*(new_r11))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x141)))))+IKsqr(((((IkReal(-1.00000000000000))*(new_r01)*(x141)))+(((cj4)*(new_r11)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x141)))), ((((IkReal(-1.00000000000000))*(new_r01)*(x141)))+(((cj4)*(new_r11)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[4];
IkReal x142=IKsin(j6);
IkReal x143=IKcos(j6);
IkReal x144=((IkReal(1.00000000000000))*(cj4));
evalcond[0]=((((new_r00)*(sj4)))+(x142)+(((IkReal(-1.00000000000000))*(new_r10)*(x144))));
evalcond[1]=((((new_r01)*(sj4)))+(((IkReal(-1.00000000000000))*(new_r11)*(x144)))+(x143));
evalcond[2]=((((cj4)*(new_r01)))+(((new_r11)*(sj4)))+(((IkReal(-1.00000000000000))*(x142))));
evalcond[3]=((((cj4)*(new_r00)))+(((new_r10)*(sj4)))+(x143));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((IkReal(-1.00000000000000))*(new_r21)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(new_r01)*(sj4)))+(((cj4)*(new_r11))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((IkReal(-1.00000000000000))*(new_r21)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))))+IKsqr(((((IkReal(-1.00000000000000))*(new_r01)*(sj4)))+(((cj4)*(new_r11)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((IkReal(-1.00000000000000))*(new_r21)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))), ((((IkReal(-1.00000000000000))*(new_r01)*(sj4)))+(((cj4)*(new_r11)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[8];
IkReal x145=IKsin(j6);
IkReal x146=IKcos(j6);
IkReal x147=((cj4)*(new_r00));
IkReal x148=((cj4)*(new_r01));
IkReal x149=((cj5)*(sj4));
IkReal x150=((IkReal(1.00000000000000))*(cj4));
IkReal x151=((IkReal(1.00000000000000))*(x146));
evalcond[0]=((new_r21)+(((sj5)*(x145))));
evalcond[1]=((new_r20)+(((IkReal(-1.00000000000000))*(sj5)*(x151))));
evalcond[2]=((((new_r00)*(sj4)))+(x145)+(((IkReal(-1.00000000000000))*(new_r10)*(x150))));
evalcond[3]=((((new_r01)*(sj4)))+(x146)+(((IkReal(-1.00000000000000))*(new_r11)*(x150))));
evalcond[4]=((((cj5)*(x145)))+(((new_r11)*(sj4)))+(x148));
evalcond[5]=((((new_r10)*(sj4)))+(x147)+(((IkReal(-1.00000000000000))*(cj5)*(x151))));
evalcond[6]=((((cj5)*(x148)))+(((new_r11)*(x149)))+(x145)+(((new_r21)*(sj5))));
evalcond[7]=((((cj5)*(x147)))+(((IkReal(-1.00000000000000))*(x151)))+(((new_r20)*(sj5)))+(((new_r10)*(x149))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((new_r20)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(sj4)))))+IKsqr(((new_r20)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(sj4)))), ((new_r20)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[8];
IkReal x152=IKsin(j6);
IkReal x153=IKcos(j6);
IkReal x154=((cj4)*(new_r00));
IkReal x155=((cj4)*(new_r01));
IkReal x156=((cj5)*(sj4));
IkReal x157=((IkReal(1.00000000000000))*(cj4));
IkReal x158=((IkReal(1.00000000000000))*(x153));
evalcond[0]=((((sj5)*(x152)))+(new_r21));
evalcond[1]=((new_r20)+(((IkReal(-1.00000000000000))*(sj5)*(x158))));
evalcond[2]=((((new_r00)*(sj4)))+(x152)+(((IkReal(-1.00000000000000))*(new_r10)*(x157))));
evalcond[3]=((((new_r01)*(sj4)))+(x153)+(((IkReal(-1.00000000000000))*(new_r11)*(x157))));
evalcond[4]=((((new_r11)*(sj4)))+(x155)+(((cj5)*(x152))));
evalcond[5]=((((new_r10)*(sj4)))+(x154)+(((IkReal(-1.00000000000000))*(cj5)*(x158))));
evalcond[6]=((((new_r11)*(x156)))+(x152)+(((new_r21)*(sj5)))+(((cj5)*(x155))));
evalcond[7]=((((IkReal(-1.00000000000000))*(x158)))+(((new_r20)*(sj5)))+(((new_r10)*(x156)))+(((cj5)*(x154))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((IkReal(-1.00000000000000))*(gconst15)*(new_r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst15)*(new_r20))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j6array[0]=IKatan2(((IkReal(-1.00000000000000))*(gconst15)*(new_r21)), ((gconst15)*(new_r20)));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[8];
IkReal x159=IKsin(j6);
IkReal x160=IKcos(j6);
IkReal x161=((cj4)*(new_r00));
IkReal x162=((cj4)*(new_r01));
IkReal x163=((cj5)*(sj4));
IkReal x164=((IkReal(1.00000000000000))*(cj4));
IkReal x165=((IkReal(1.00000000000000))*(x160));
evalcond[0]=((((sj5)*(x159)))+(new_r21));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x165)))+(new_r20));
evalcond[2]=((((new_r00)*(sj4)))+(((IkReal(-1.00000000000000))*(new_r10)*(x164)))+(x159));
evalcond[3]=((((new_r01)*(sj4)))+(((IkReal(-1.00000000000000))*(new_r11)*(x164)))+(x160));
evalcond[4]=((((new_r11)*(sj4)))+(x162)+(((cj5)*(x159))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj5)*(x165)))+(((new_r10)*(sj4)))+(x161));
evalcond[6]=((((new_r11)*(x163)))+(((cj5)*(x162)))+(x159)+(((new_r21)*(sj5))));
evalcond[7]=((((new_r20)*(sj5)))+(((IkReal(-1.00000000000000))*(x165)))+(((new_r10)*(x163)))+(((cj5)*(x161))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x166=((gconst12)*(sj5));
if( IKabs(((new_r12)*(x166))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((new_r02)*(x166))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((new_r12)*(x166)), ((new_r02)*(x166)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x167=IKcos(j4);
IkReal x168=IKsin(j4);
IkReal x169=((IkReal(1.00000000000000))*(sj5));
IkReal x170=((new_r12)*(x168));
IkReal x171=((new_r02)*(x167));
evalcond[0]=((((new_r12)*(x167)))+(((IkReal(-1.00000000000000))*(new_r02)*(x168))));
evalcond[1]=((sj5)+(x171)+(x170));
evalcond[2]=((((cj5)*(x170)))+(((cj5)*(x171)))+(((new_r22)*(sj5))));
evalcond[3]=((((IkReal(-1.00000000000000))*(new_r00)*(x167)*(x169)))+(((cj5)*(new_r20)))+(((IkReal(-1.00000000000000))*(new_r10)*(x168)*(x169))));
evalcond[4]=((((IkReal(-1.00000000000000))*(new_r01)*(x167)*(x169)))+(((IkReal(-1.00000000000000))*(new_r11)*(x168)*(x169)))+(((cj5)*(new_r21))));
evalcond[5]=((IkReal(-1.00000000000000))+(((cj5)*(new_r22)))+(((IkReal(-1.00000000000000))*(x169)*(x171)))+(((IkReal(-1.00000000000000))*(x169)*(x170))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst15;
gconst15=IKsign(sj5);
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=sj5;
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal evalcond[11];
IkReal x172=((IkReal(-1.00000000000000))+(new_r22));
IkReal x173=((new_r02)*(sj4));
IkReal x174=((cj4)*(new_r12));
IkReal x175=((((new_r12)*(sj4)))+(((cj4)*(new_r02))));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(3.14159265358979))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=x172;
evalcond[2]=new_r21;
evalcond[3]=new_r20;
evalcond[4]=((((IkReal(-1.00000000000000))*(x173)))+(x174));
evalcond[5]=((((IkReal(-1.00000000000000))*(x174)))+(x173));
evalcond[6]=x175;
evalcond[7]=x175;
evalcond[8]=new_r20;
evalcond[9]=new_r21;
evalcond[10]=x172;
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
IkReal x176=((IkReal(1.00000000000000))*(sj4));
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x176))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj4)*(new_r11)))+(((IkReal(-1.00000000000000))*(new_r01)*(x176))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x176)))))+IKsqr(((((cj4)*(new_r11)))+(((IkReal(-1.00000000000000))*(new_r01)*(x176)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x176)))), ((((cj4)*(new_r11)))+(((IkReal(-1.00000000000000))*(new_r01)*(x176)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[4];
IkReal x177=IKsin(j6);
IkReal x178=IKcos(j6);
IkReal x179=((IkReal(1.00000000000000))*(cj4));
evalcond[0]=((((IkReal(-1.00000000000000))*(new_r10)*(x179)))+(((new_r00)*(sj4)))+(x177));
evalcond[1]=((((new_r01)*(sj4)))+(((IkReal(-1.00000000000000))*(new_r11)*(x179)))+(x178));
evalcond[2]=((((cj4)*(new_r01)))+(((new_r11)*(sj4)))+(x177));
evalcond[3]=((((cj4)*(new_r00)))+(((new_r10)*(sj4)))+(((IkReal(-1.00000000000000))*(x178))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
IkReal x180=((cj4)*(new_r02));
IkReal x181=((IkReal(1.00000000000000))*(new_r12));
IkReal x182=((new_r02)*(sj4));
evalcond[0]=((IkReal(-3.14159265358979))+(IKfmod(((IkReal(1.11022302462516e-16))+(j5)), IkReal(6.28318530717959))));
evalcond[1]=((IkReal(1.00000000000000))+(new_r22));
evalcond[2]=new_r21;
evalcond[3]=new_r20;
evalcond[4]=((((cj4)*(new_r12)))+(((IkReal(-1.00000000000000))*(x182))));
evalcond[5]=((((IkReal(-1.00000000000000))*(cj4)*(x181)))+(x182));
evalcond[6]=((((new_r12)*(sj4)))+(x180));
evalcond[7]=((((IkReal(-1.00000000000000))*(x180)))+(((IkReal(-1.00000000000000))*(sj4)*(x181))));
evalcond[8]=((IkReal(-1.00000000000000))*(new_r20));
evalcond[9]=((IkReal(-1.00000000000000))*(new_r21));
evalcond[10]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(new_r22))));
if( IKabs(evalcond[0]) < 0.0000010000000000  && IKabs(evalcond[1]) < 0.0000010000000000  && IKabs(evalcond[2]) < 0.0000010000000000  && IKabs(evalcond[3]) < 0.0000010000000000  && IKabs(evalcond[4]) < 0.0000010000000000  && IKabs(evalcond[5]) < 0.0000010000000000  && IKabs(evalcond[6]) < 0.0000010000000000  && IKabs(evalcond[7]) < 0.0000010000000000  && IKabs(evalcond[8]) < 0.0000010000000000  && IKabs(evalcond[9]) < 0.0000010000000000  && IKabs(evalcond[10]) < 0.0000010000000000  )
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
IkReal x183=((IkReal(1.00000000000000))*(sj4));
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x183))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((cj4)*(new_r11)))+(((IkReal(-1.00000000000000))*(new_r01)*(x183))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x183)))))+IKsqr(((((cj4)*(new_r11)))+(((IkReal(-1.00000000000000))*(new_r01)*(x183)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(x183)))), ((((cj4)*(new_r11)))+(((IkReal(-1.00000000000000))*(new_r01)*(x183)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[4];
IkReal x184=IKsin(j6);
IkReal x185=IKcos(j6);
IkReal x186=((IkReal(1.00000000000000))*(cj4));
evalcond[0]=((((new_r00)*(sj4)))+(x184)+(((IkReal(-1.00000000000000))*(new_r10)*(x186))));
evalcond[1]=((((new_r01)*(sj4)))+(x185)+(((IkReal(-1.00000000000000))*(new_r11)*(x186))));
evalcond[2]=((((cj4)*(new_r01)))+(((new_r11)*(sj4)))+(((IkReal(-1.00000000000000))*(x184))));
evalcond[3]=((((cj4)*(new_r00)))+(((new_r10)*(sj4)))+(x185));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

} else
{
if( 1 )
{
continue;

} else
{
}
}
}
}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((IkReal(-1.00000000000000))*(new_r21)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((((IkReal(-1.00000000000000))*(new_r01)*(sj4)))+(((cj4)*(new_r11))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((IkReal(-1.00000000000000))*(new_r21)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))))+IKsqr(((((IkReal(-1.00000000000000))*(new_r01)*(sj4)))+(((cj4)*(new_r11)))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((IkReal(-1.00000000000000))*(new_r21)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))), ((((IkReal(-1.00000000000000))*(new_r01)*(sj4)))+(((cj4)*(new_r11)))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[8];
IkReal x187=IKsin(j6);
IkReal x188=IKcos(j6);
IkReal x189=((cj4)*(new_r00));
IkReal x190=((cj4)*(new_r01));
IkReal x191=((cj5)*(sj4));
IkReal x192=((IkReal(1.00000000000000))*(cj4));
IkReal x193=((IkReal(1.00000000000000))*(x188));
evalcond[0]=((new_r21)+(((sj5)*(x187))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x193)))+(new_r20));
evalcond[2]=((((new_r00)*(sj4)))+(x187)+(((IkReal(-1.00000000000000))*(new_r10)*(x192))));
evalcond[3]=((((new_r01)*(sj4)))+(x188)+(((IkReal(-1.00000000000000))*(new_r11)*(x192))));
evalcond[4]=((((cj5)*(x187)))+(((new_r11)*(sj4)))+(x190));
evalcond[5]=((((new_r10)*(sj4)))+(((IkReal(-1.00000000000000))*(cj5)*(x193)))+(x189));
evalcond[6]=((((cj5)*(x190)))+(((new_r11)*(x191)))+(x187)+(((new_r21)*(sj5))));
evalcond[7]=((((new_r10)*(x191)))+(((cj5)*(x189)))+(((new_r20)*(sj5)))+(((IkReal(-1.00000000000000))*(x193))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(sj4))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((new_r20)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30)))) < IKFAST_ATAN2_MAGTHRESH && IKabs(IKsqr(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(sj4)))))+IKsqr(((new_r20)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))))-1) <= IKFAST_SINCOS_THRESH )
    continue;
j6array[0]=IKatan2(((((cj4)*(new_r10)))+(((IkReal(-1.00000000000000))*(new_r00)*(sj4)))), ((new_r20)*(((IKabs(sj5) != 0)?((IkReal)1/(sj5)):(IkReal)1.0e30))));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[8];
IkReal x194=IKsin(j6);
IkReal x195=IKcos(j6);
IkReal x196=((cj4)*(new_r00));
IkReal x197=((cj4)*(new_r01));
IkReal x198=((cj5)*(sj4));
IkReal x199=((IkReal(1.00000000000000))*(cj4));
IkReal x200=((IkReal(1.00000000000000))*(x195));
evalcond[0]=((new_r21)+(((sj5)*(x194))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x200)))+(new_r20));
evalcond[2]=((((new_r00)*(sj4)))+(x194)+(((IkReal(-1.00000000000000))*(new_r10)*(x199))));
evalcond[3]=((((new_r01)*(sj4)))+(x195)+(((IkReal(-1.00000000000000))*(new_r11)*(x199))));
evalcond[4]=((((cj5)*(x194)))+(((new_r11)*(sj4)))+(x197));
evalcond[5]=((((new_r10)*(sj4)))+(x196)+(((IkReal(-1.00000000000000))*(cj5)*(x200))));
evalcond[6]=((((cj5)*(x197)))+(((new_r11)*(x198)))+(x194)+(((new_r21)*(sj5))));
evalcond[7]=((((new_r10)*(x198)))+(((cj5)*(x196)))+(((new_r20)*(sj5)))+(((IkReal(-1.00000000000000))*(x200))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((IkReal(-1.00000000000000))*(gconst15)*(new_r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst15)*(new_r20))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j6array[0]=IKatan2(((IkReal(-1.00000000000000))*(gconst15)*(new_r21)), ((gconst15)*(new_r20)));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[8];
IkReal x201=IKsin(j6);
IkReal x202=IKcos(j6);
IkReal x203=((cj4)*(new_r00));
IkReal x204=((cj4)*(new_r01));
IkReal x205=((cj5)*(sj4));
IkReal x206=((IkReal(1.00000000000000))*(cj4));
IkReal x207=((IkReal(1.00000000000000))*(x202));
evalcond[0]=((new_r21)+(((sj5)*(x201))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x207)))+(new_r20));
evalcond[2]=((((new_r00)*(sj4)))+(x201)+(((IkReal(-1.00000000000000))*(new_r10)*(x206))));
evalcond[3]=((((new_r01)*(sj4)))+(x202)+(((IkReal(-1.00000000000000))*(new_r11)*(x206))));
evalcond[4]=((((new_r11)*(sj4)))+(x204)+(((cj5)*(x201))));
evalcond[5]=((((new_r10)*(sj4)))+(((IkReal(-1.00000000000000))*(cj5)*(x207)))+(x203));
evalcond[6]=((((new_r11)*(x205)))+(x201)+(((cj5)*(x204)))+(((new_r21)*(sj5))));
evalcond[7]=((((new_r20)*(sj5)))+(((new_r10)*(x205)))+(((IkReal(-1.00000000000000))*(x207)))+(((cj5)*(x203))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j6array[1], cj6array[1], sj6array[1];
bool j6valid[1]={false};
_nj6 = 1;
if( IKabs(((IkReal(-1.00000000000000))*(gconst14)*(new_r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst14)*(new_r20))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j6array[0]=IKatan2(((IkReal(-1.00000000000000))*(gconst14)*(new_r21)), ((gconst14)*(new_r20)));
sj6array[0]=IKsin(j6array[0]);
cj6array[0]=IKcos(j6array[0]);
if( j6array[0] > IKPI )
{
    j6array[0]-=IK2PI;
}
else if( j6array[0] < -IKPI )
{    j6array[0]+=IK2PI;
}
j6valid[0] = true;
for(int ij6 = 0; ij6 < 1; ++ij6)
{
if( !j6valid[ij6] )
{
    continue;
}
_ij6[0] = ij6; _ij6[1] = -1;
for(int iij6 = ij6+1; iij6 < 1; ++iij6)
{
if( j6valid[iij6] && IKabs(cj6array[ij6]-cj6array[iij6]) < IKFAST_SOLUTION_THRESH && IKabs(sj6array[ij6]-sj6array[iij6]) < IKFAST_SOLUTION_THRESH )
{
    j6valid[iij6]=false; _ij6[1] = iij6; break; 
}
}
j6 = j6array[ij6]; cj6 = cj6array[ij6]; sj6 = sj6array[ij6];
{
IkReal evalcond[2];
evalcond[0]=((((sj5)*(IKsin(j6))))+(new_r21));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(IKcos(j6))))+(new_r20));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst17;
gconst17=IKsign(((((IkReal(-1.00000000000000))*(new_r00)*(new_r12)))+(((new_r02)*(new_r10)))));
dummyeval[0]=((((IkReal(-1.00000000000000))*(new_r00)*(new_r12)))+(((new_r02)*(new_r10))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst16;
gconst16=IKsign(((((IkReal(-1.00000000000000))*((new_r02)*(new_r02))))+(((IkReal(-1.00000000000000))*((new_r12)*(new_r12))))));
dummyeval[0]=((((IkReal(-1.00000000000000))*((new_r02)*(new_r02))))+(((IkReal(-1.00000000000000))*((new_r12)*(new_r12)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x208=((gconst16)*(sj5));
if( IKabs(((new_r12)*(x208))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((new_r02)*(x208))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((new_r12)*(x208)), ((new_r02)*(x208)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[12];
IkReal x209=IKcos(j4);
IkReal x210=IKsin(j4);
IkReal x211=((IkReal(1.00000000000000))*(cj6));
IkReal x212=((IkReal(1.00000000000000))*(sj5));
IkReal x213=((IkReal(1.00000000000000))*(x209));
IkReal x214=((cj5)*(x210));
IkReal x215=((new_r11)*(x210));
IkReal x216=((cj5)*(x209));
IkReal x217=((new_r12)*(x210));
IkReal x218=((new_r10)*(x210));
evalcond[0]=((((new_r12)*(x209)))+(((IkReal(-1.00000000000000))*(new_r02)*(x210))));
evalcond[1]=((sj5)+(((new_r02)*(x209)))+(x217));
evalcond[2]=((sj6)+(((IkReal(-1.00000000000000))*(new_r10)*(x213)))+(((new_r00)*(x210))));
evalcond[3]=((cj6)+(((IkReal(-1.00000000000000))*(new_r11)*(x213)))+(((new_r01)*(x210))));
evalcond[4]=((((new_r01)*(x209)))+(((cj5)*(sj6)))+(x215));
evalcond[5]=((((new_r00)*(x209)))+(x218)+(((IkReal(-1.00000000000000))*(cj5)*(x211))));
evalcond[6]=((((new_r22)*(sj5)))+(((new_r02)*(x216)))+(((new_r12)*(x214))));
evalcond[7]=((((IkReal(-1.00000000000000))*(new_r00)*(x209)*(x212)))+(((cj5)*(new_r20)))+(((IkReal(-1.00000000000000))*(x212)*(x218))));
evalcond[8]=((((cj5)*(new_r21)))+(((IkReal(-1.00000000000000))*(new_r01)*(x209)*(x212)))+(((IkReal(-1.00000000000000))*(x212)*(x215))));
evalcond[9]=((sj6)+(((new_r01)*(x216)))+(((new_r21)*(sj5)))+(((new_r11)*(x214))));
evalcond[10]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(new_r02)*(x209)*(x212)))+(((cj5)*(new_r22)))+(((IkReal(-1.00000000000000))*(x212)*(x217))));
evalcond[11]=((((new_r20)*(sj5)))+(((new_r00)*(x216)))+(((IkReal(-1.00000000000000))*(x211)))+(((new_r10)*(x214))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  || IKabs(evalcond[8]) > 0.000001  || IKabs(evalcond[9]) > 0.000001  || IKabs(evalcond[10]) > 0.000001  || IKabs(evalcond[11]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x219=((gconst17)*(sj6));
if( IKabs(((new_r12)*(x219))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((new_r02)*(x219))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((new_r12)*(x219)), ((new_r02)*(x219)));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[12];
IkReal x220=IKcos(j4);
IkReal x221=IKsin(j4);
IkReal x222=((IkReal(1.00000000000000))*(cj6));
IkReal x223=((IkReal(1.00000000000000))*(sj5));
IkReal x224=((IkReal(1.00000000000000))*(x220));
IkReal x225=((cj5)*(x221));
IkReal x226=((new_r11)*(x221));
IkReal x227=((cj5)*(x220));
IkReal x228=((new_r12)*(x221));
IkReal x229=((new_r10)*(x221));
evalcond[0]=((((new_r12)*(x220)))+(((IkReal(-1.00000000000000))*(new_r02)*(x221))));
evalcond[1]=((sj5)+(((new_r02)*(x220)))+(x228));
evalcond[2]=((((new_r00)*(x221)))+(sj6)+(((IkReal(-1.00000000000000))*(new_r10)*(x224))));
evalcond[3]=((((new_r01)*(x221)))+(cj6)+(((IkReal(-1.00000000000000))*(new_r11)*(x224))));
evalcond[4]=((((new_r01)*(x220)))+(((cj5)*(sj6)))+(x226));
evalcond[5]=((((new_r00)*(x220)))+(((IkReal(-1.00000000000000))*(cj5)*(x222)))+(x229));
evalcond[6]=((((new_r02)*(x227)))+(((new_r22)*(sj5)))+(((new_r12)*(x225))));
evalcond[7]=((((IkReal(-1.00000000000000))*(new_r00)*(x220)*(x223)))+(((cj5)*(new_r20)))+(((IkReal(-1.00000000000000))*(x223)*(x229))));
evalcond[8]=((((IkReal(-1.00000000000000))*(new_r01)*(x220)*(x223)))+(((cj5)*(new_r21)))+(((IkReal(-1.00000000000000))*(x223)*(x226))));
evalcond[9]=((sj6)+(((new_r01)*(x227)))+(((new_r11)*(x225)))+(((new_r21)*(sj5))));
evalcond[10]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(new_r02)*(x220)*(x223)))+(((cj5)*(new_r22)))+(((IkReal(-1.00000000000000))*(x223)*(x228))));
evalcond[11]=((((new_r00)*(x227)))+(((new_r20)*(sj5)))+(((new_r10)*(x225)))+(((IkReal(-1.00000000000000))*(x222))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  || IKabs(evalcond[8]) > 0.000001  || IKabs(evalcond[9]) > 0.000001  || IKabs(evalcond[10]) > 0.000001  || IKabs(evalcond[11]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(7);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
vinfos[6].jointtype = 1;
vinfos[6].foffset = j6;
vinfos[6].indices[0] = _ij6[0];
vinfos[6].indices[1] = _ij6[1];
vinfos[6].maxsolutions = _nj6;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}
}
}};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:GenericRobot - cob3_2 (f8ac16d287e31152f9a0008d98e80d9e)>"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
