/// autogenerated analytical inverse kinematics code from ikfast program part of OpenRAVE
/// \author Rosen Diankov
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///     http://www.apache.org/licenses/LICENSE-2.0
/// 
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
///
/// ikfast version 61 generated on 2012-11-23 19:10:48.288028
/// To compile with gcc:
///     gcc -lstdc++ ik.cpp
/// To compile without any main function as a shared object (might need -llapack):
///     gcc -fPIC -lstdc++ -DIKFAST_NO_MAIN -DIKFAST_CLIBRARY -shared -Wl,-soname,libik.so -o libik.so ik.cpp
#define IKFAST_HAS_LIBRARY
#include "ikfast.h" // found inside share/openrave-X.Y/python/ikfast.h
using namespace ikfast;

// check if the included ikfast version matches what this file was compiled with
#define IKFAST_COMPILE_ASSERT(x) extern int __dummy[(int)x]
IKFAST_COMPILE_ASSERT(IKFAST_VERSION==61);

#include <cmath>
#include <vector>
#include <limits>
#include <algorithm>
#include <complex>

#define IKFAST_STRINGIZE2(s) #s
#define IKFAST_STRINGIZE(s) IKFAST_STRINGIZE2(s)

#ifndef IKFAST_ASSERT
#include <stdexcept>
#include <sstream>
#include <iostream>

#ifdef _MSC_VER
#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __FUNCDNAME__
#endif
#endif

#ifndef __PRETTY_FUNCTION__
#define __PRETTY_FUNCTION__ __func__
#endif

#define IKFAST_ASSERT(b) { if( !(b) ) { std::stringstream ss; ss << "ikfast exception: " << __FILE__ << ":" << __LINE__ << ": " <<__PRETTY_FUNCTION__ << ": Assertion '" << #b << "' failed"; throw std::runtime_error(ss.str()); } }

#endif

#if defined(_MSC_VER)
#define IKFAST_ALIGNED16(x) __declspec(align(16)) x
#else
#define IKFAST_ALIGNED16(x) x __attribute((aligned(16)))
#endif

#define IK2PI  ((IkReal)6.28318530717959)
#define IKPI  ((IkReal)3.14159265358979)
#define IKPI_2  ((IkReal)1.57079632679490)

#ifdef _MSC_VER
#ifndef isnan
#define isnan _isnan
#endif
#endif // _MSC_VER

// lapack routines
extern "C" {
  void dgetrf_ (const int* m, const int* n, double* a, const int* lda, int* ipiv, int* info);
  void zgetrf_ (const int* m, const int* n, std::complex<double>* a, const int* lda, int* ipiv, int* info);
  void dgetri_(const int* n, const double* a, const int* lda, int* ipiv, double* work, const int* lwork, int* info);
  void dgesv_ (const int* n, const int* nrhs, double* a, const int* lda, int* ipiv, double* b, const int* ldb, int* info);
  void dgetrs_(const char *trans, const int *n, const int *nrhs, double *a, const int *lda, int *ipiv, double *b, const int *ldb, int *info);
  void dgeev_(const char *jobvl, const char *jobvr, const int *n, double *a, const int *lda, double *wr, double *wi,double *vl, const int *ldvl, double *vr, const int *ldvr, double *work, const int *lwork, int *info);
}

using namespace std; // necessary to get std math routines

#ifdef IKFAST_NAMESPACE
namespace IKFAST_NAMESPACE {
#endif

inline float IKabs(float f) { return fabsf(f); }
inline double IKabs(double f) { return fabs(f); }

inline float IKsqr(float f) { return f*f; }
inline double IKsqr(double f) { return f*f; }

inline float IKlog(float f) { return logf(f); }
inline double IKlog(double f) { return log(f); }

// allows asin and acos to exceed 1
#ifndef IKFAST_SINCOS_THRESH
#define IKFAST_SINCOS_THRESH ((IkReal)0.000001)
#endif

// used to check input to atan2 for degenerate cases
#ifndef IKFAST_ATAN2_MAGTHRESH
#define IKFAST_ATAN2_MAGTHRESH ((IkReal)2e-6)
#endif

// minimum distance of separate solutions
#ifndef IKFAST_SOLUTION_THRESH
#define IKFAST_SOLUTION_THRESH ((IkReal)1e-6)
#endif

inline float IKasin(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(-IKPI_2);
else if( f >= 1 ) return float(IKPI_2);
return asinf(f);
}
inline double IKasin(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return -IKPI_2;
else if( f >= 1 ) return IKPI_2;
return asin(f);
}

// return positive value in [0,y)
inline float IKfmod(float x, float y)
{
    while(x < 0) {
        x += y;
    }
    return fmodf(x,y);
}

// return positive value in [0,y)
inline double IKfmod(double x, double y)
{
    while(x < 0) {
        x += y;
    }
    return fmod(x,y);
}

inline float IKacos(float f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return float(IKPI);
else if( f >= 1 ) return float(0);
return acosf(f);
}
inline double IKacos(double f)
{
IKFAST_ASSERT( f > -1-IKFAST_SINCOS_THRESH && f < 1+IKFAST_SINCOS_THRESH ); // any more error implies something is wrong with the solver
if( f <= -1 ) return IKPI;
else if( f >= 1 ) return 0;
return acos(f);
}
inline float IKsin(float f) { return sinf(f); }
inline double IKsin(double f) { return sin(f); }
inline float IKcos(float f) { return cosf(f); }
inline double IKcos(double f) { return cos(f); }
inline float IKtan(float f) { return tanf(f); }
inline double IKtan(double f) { return tan(f); }
inline float IKsqrt(float f) { if( f <= 0.0f ) return 0.0f; return sqrtf(f); }
inline double IKsqrt(double f) { if( f <= 0.0 ) return 0.0; return sqrt(f); }
inline float IKatan2(float fy, float fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return float(IKPI_2);
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2f(fy,fx);
}
inline double IKatan2(double fy, double fx) {
    if( isnan(fy) ) {
        IKFAST_ASSERT(!isnan(fx)); // if both are nan, probably wrong value will be returned
        return IKPI_2;
    }
    else if( isnan(fx) ) {
        return 0;
    }
    return atan2(fy,fx);
}

inline float IKsign(float f) {
    if( f > 0 ) {
        return float(1);
    }
    else if( f < 0 ) {
        return float(-1);
    }
    return 0;
}

inline double IKsign(double f) {
    if( f > 0 ) {
        return 1.0;
    }
    else if( f < 0 ) {
        return -1.0;
    }
    return 0;
}

/// solves the forward kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API void ComputeFk(const IkReal* j, IkReal* eetrans, IkReal* eerot) {
IkReal x0,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32,x33,x34,x35,x36,x37,x38,x39,x40,x41;
x0=IKcos(j[0]);
x1=IKcos(j[1]);
x2=IKsin(j[2]);
x3=IKcos(j[2]);
x4=IKsin(j[1]);
x5=IKcos(j[3]);
x6=IKsin(j[3]);
x7=IKsin(j[4]);
x8=IKcos(j[4]);
x9=IKsin(j[0]);
x10=IKsin(j[5]);
x11=IKcos(j[5]);
x12=((IkReal(0.392250000000000))*(x0));
x13=((IkReal(0.0946500000000000))*(x0));
x14=((IkReal(1.00000000000000))*(x9));
x15=((IkReal(0.0946500000000000))*(x9));
x16=((IkReal(1.00000000000000))*(x6));
x17=((IkReal(0.392250000000000))*(x9));
x18=((IkReal(1.00000000000000))*(x5));
x19=((IkReal(0.425000000000000))*(x1));
x20=((IkReal(1.00000000000000))*(x0));
x21=((x1)*(x3));
x22=((x2)*(x4));
x23=((x1)*(x2));
x24=((x3)*(x4));
x25=((x20)*(x21));
x26=((x14)*(x21));
x27=((x24)+(x23));
x28=((((IkReal(-1.00000000000000))*(x22)))+(((IkReal(1.00000000000000))*(x21))));
x29=((((IkReal(-1.00000000000000))*(x23)))+(((IkReal(-1.00000000000000))*(x24))));
x30=((x28)*(x5));
x31=((((x0)*(x22)))+(((IkReal(-1.00000000000000))*(x25))));
x32=((((x22)*(x9)))+(((IkReal(-1.00000000000000))*(x26))));
x33=((x29)*(x6));
x34=((x25)+(((IkReal(-1.00000000000000))*(x20)*(x22))));
x35=((((IkReal(-1.00000000000000))*(x14)*(x22)))+(x26));
x36=((x20)*(((x24)+(x23))));
x37=((x14)*(((x24)+(x23))));
x38=((((x27)*(x5)))+(((x28)*(x6))));
x39=((x38)*(x8));
x40=((((IkReal(-1.00000000000000))*(x14)*(x7)))+(((x8)*(((((x31)*(x5)))+(((x36)*(x6))))))));
x41=((((x0)*(x7)))+(((x8)*(((((x32)*(x5)))+(((x37)*(x6))))))));
eerot[0]=((((x11)*(x40)))+(((x10)*(((((x34)*(x6)))+(((x36)*(x5))))))));
eerot[1]=((((IkReal(-1.00000000000000))*(x14)*(x8)))+(((x7)*(((((IkReal(-1.00000000000000))*(x18)*(x31)))+(((IkReal(-1.00000000000000))*(x16)*(x36))))))));
eerot[2]=((((x10)*(x40)))+(((x11)*(((((IkReal(-1.00000000000000))*(x18)*(x36)))+(((IkReal(-1.00000000000000))*(x16)*(x34))))))));
IkReal x42=((IkReal(1.00000000000000))*(x13));
eetrans[0]=((((x0)*(x19)))+(((IkReal(-1.00000000000000))*(x12)*(x22)))+(((IkReal(-0.109150000000000))*(x9)))+(((x6)*(((((IkReal(-1.00000000000000))*(x21)*(x42)))+(((x13)*(x22)))))))+(((x5)*(((((IkReal(-1.00000000000000))*(x23)*(x42)))+(((IkReal(-1.00000000000000))*(x24)*(x42)))))))+(((x12)*(x21))));
eerot[3]=((((x11)*(x41)))+(((x10)*(((((x35)*(x6)))+(((x37)*(x5))))))));
eerot[4]=((((x0)*(x8)))+(((x7)*(((((IkReal(-1.00000000000000))*(x18)*(x32)))+(((IkReal(-1.00000000000000))*(x16)*(x37))))))));
eerot[5]=((((x10)*(x41)))+(((x11)*(((((IkReal(-1.00000000000000))*(x18)*(x37)))+(((IkReal(-1.00000000000000))*(x16)*(x35))))))));
IkReal x43=((IkReal(1.00000000000000))*(x15));
eetrans[1]=((((IkReal(0.109150000000000))*(x0)))+(((x19)*(x9)))+(((IkReal(-1.00000000000000))*(x17)*(x22)))+(((x17)*(x21)))+(((x5)*(((((IkReal(-1.00000000000000))*(x23)*(x43)))+(((IkReal(-1.00000000000000))*(x24)*(x43)))))))+(((x6)*(((((IkReal(-1.00000000000000))*(x21)*(x43)))+(((x15)*(x22))))))));
eerot[6]=((((x11)*(x39)))+(((x10)*(((x33)+(x30))))));
eerot[7]=((x7)*(((((IkReal(-1.00000000000000))*(x16)*(x28)))+(((IkReal(-1.00000000000000))*(x18)*(x27))))));
eerot[8]=((((x11)*(((((IkReal(-1.00000000000000))*(x33)))+(((IkReal(-1.00000000000000))*(x30)))))))+(((x10)*(x39))));
eetrans[2]=((IkReal(0.0891590000000000))+(((x5)*(((((IkReal(-0.0946500000000000))*(x21)))+(((IkReal(0.0946500000000000))*(x22)))))))+(((IkReal(-0.425000000000000))*(x4)))+(((x6)*(((((IkReal(0.0946500000000000))*(x23)))+(((IkReal(0.0946500000000000))*(x24)))))))+(((IkReal(-0.392250000000000))*(x23)))+(((IkReal(-0.392250000000000))*(x24))));
}

IKFAST_API int GetNumFreeParameters() { return 0; }
IKFAST_API int* GetFreeParameters() { return NULL; }
IKFAST_API int GetNumJoints() { return 6; }

IKFAST_API int GetIkRealSize() { return sizeof(IkReal); }

IKFAST_API int GetIkType() { return 0x67000001; }

class IKSolver {
public:
IkReal j0,cj0,sj0,htj0,j1,cj1,sj1,htj1,j2,cj2,sj2,htj2,j3,cj3,sj3,htj3,j4,cj4,sj4,htj4,j5,cj5,sj5,htj5,new_r00,r00,rxp0_0,new_r01,r01,rxp0_1,new_r02,r02,rxp0_2,new_r10,r10,rxp1_0,new_r11,r11,rxp1_1,new_r12,r12,rxp1_2,new_r20,r20,rxp2_0,new_r21,r21,rxp2_1,new_r22,r22,rxp2_2,new_px,px,npx,new_py,py,npy,new_pz,pz,npz,pp;
unsigned char _ij0[2], _nj0,_ij1[2], _nj1,_ij2[2], _nj2,_ij3[2], _nj3,_ij4[2], _nj4,_ij5[2], _nj5;

bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
j0=numeric_limits<IkReal>::quiet_NaN(); _ij0[0] = -1; _ij0[1] = -1; _nj0 = -1; j1=numeric_limits<IkReal>::quiet_NaN(); _ij1[0] = -1; _ij1[1] = -1; _nj1 = -1; j2=numeric_limits<IkReal>::quiet_NaN(); _ij2[0] = -1; _ij2[1] = -1; _nj2 = -1; j3=numeric_limits<IkReal>::quiet_NaN(); _ij3[0] = -1; _ij3[1] = -1; _nj3 = -1; j4=numeric_limits<IkReal>::quiet_NaN(); _ij4[0] = -1; _ij4[1] = -1; _nj4 = -1; j5=numeric_limits<IkReal>::quiet_NaN(); _ij5[0] = -1; _ij5[1] = -1; _nj5 = -1; 
for(int dummyiter = 0; dummyiter < 1; ++dummyiter) {
    solutions.Clear();
r00 = eerot[0*3+0];
r01 = eerot[0*3+1];
r02 = eerot[0*3+2];
r10 = eerot[1*3+0];
r11 = eerot[1*3+1];
r12 = eerot[1*3+2];
r20 = eerot[2*3+0];
r21 = eerot[2*3+1];
r22 = eerot[2*3+2];
px = eetrans[0]; py = eetrans[1]; pz = eetrans[2];

new_r00=r00;
new_r01=((IkReal(-1.00000000000000))*(r02));
new_r02=r01;
new_px=px;
new_r10=r10;
new_r11=((IkReal(-1.00000000000000))*(r12));
new_r12=r11;
new_py=py;
new_r20=r20;
new_r21=((IkReal(-1.00000000000000))*(r22));
new_r22=r21;
new_pz=((IkReal(-0.0891590000000000))+(pz));
r00 = new_r00; r01 = new_r01; r02 = new_r02; r10 = new_r10; r11 = new_r11; r12 = new_r12; r20 = new_r20; r21 = new_r21; r22 = new_r22; px = new_px; py = new_py; pz = new_pz;
pp=(((px)*(px))+((py)*(py))+((pz)*(pz)));
npx=((((px)*(r00)))+(((py)*(r10)))+(((pz)*(r20))));
npy=((((px)*(r01)))+(((py)*(r11)))+(((pz)*(r21))));
npz=((((px)*(r02)))+(((py)*(r12)))+(((pz)*(r22))));
rxp0_0=((((IkReal(-1.00000000000000))*(py)*(r20)))+(((pz)*(r10))));
rxp0_1=((((px)*(r20)))+(((IkReal(-1.00000000000000))*(pz)*(r00))));
rxp0_2=((((IkReal(-1.00000000000000))*(px)*(r10)))+(((py)*(r00))));
rxp1_0=((((IkReal(-1.00000000000000))*(py)*(r21)))+(((pz)*(r11))));
rxp1_1=((((px)*(r21)))+(((IkReal(-1.00000000000000))*(pz)*(r01))));
rxp1_2=((((IkReal(-1.00000000000000))*(px)*(r11)))+(((py)*(r01))));
rxp2_0=((((IkReal(-1.00000000000000))*(py)*(r22)))+(((pz)*(r12))));
rxp2_1=((((px)*(r22)))+(((IkReal(-1.00000000000000))*(pz)*(r02))));
rxp2_2=((((IkReal(-1.00000000000000))*(px)*(r12)))+(((py)*(r02))));
IkReal IKFAST_ALIGNED16(matrixinvcoeffs[64]);
IkReal x44=((IkReal(0.189300000000000))*(py));
IkReal x45=((IkReal(0.0946500000000000))*(r10));
IkReal x46=((IkReal(0.0946500000000000))*(r11));
IkReal x47=((IkReal(2.00000000000000))*(npx));
IkReal x48=((IkReal(2.00000000000000))*(npy));
IkReal x49=((pp)*(r01));
IkReal x50=((pp)*(r00));
IkReal x51=((IkReal(1.00000000000000))*(pp));
IkReal x52=((px)*(x47));
IkReal x53=((py)*(x47));
IkReal x54=((r10)*(x51));
IkReal x55=((px)*(x48));
IkReal x56=((py)*(x48));
IkReal x57=((r11)*(x51));
matrixinvcoeffs[0]=((IkReal(0.271700000000000))*(rxp0_2));
matrixinvcoeffs[1]=((IkReal(-0.271700000000000))*(npx));
matrixinvcoeffs[2]=((IkReal(0.189300000000000))*(npx));
matrixinvcoeffs[3]=IkReal(0);
matrixinvcoeffs[4]=IkReal(0);
matrixinvcoeffs[5]=((IkReal(-0.135850000000000))*(r20));
matrixinvcoeffs[6]=rxp0_2;
matrixinvcoeffs[7]=((((pp)*(r20)))+(((IkReal(-1.00000000000000))*(pz)*(x47)))+(((IkReal(0.00949660000000000))*(r20))));
matrixinvcoeffs[8]=((IkReal(0.271700000000000))*(rxp1_2));
matrixinvcoeffs[9]=((IkReal(-0.271700000000000))*(npy));
matrixinvcoeffs[10]=((IkReal(0.189300000000000))*(npy));
matrixinvcoeffs[11]=IkReal(0);
matrixinvcoeffs[12]=IkReal(0);
matrixinvcoeffs[13]=((IkReal(-0.135850000000000))*(r21));
matrixinvcoeffs[14]=rxp1_2;
matrixinvcoeffs[15]=((((pp)*(r21)))+(((IkReal(-1.00000000000000))*(pz)*(x48)))+(((IkReal(0.00949660000000000))*(r21))));
matrixinvcoeffs[16]=x44;
matrixinvcoeffs[17]=((IkReal(-0.189300000000000))*(px));
matrixinvcoeffs[18]=((IkReal(0.271700000000000))*(px));
matrixinvcoeffs[19]=py;
matrixinvcoeffs[20]=((IkReal(-1.00000000000000))*(px));
matrixinvcoeffs[21]=IkReal(0);
matrixinvcoeffs[22]=IkReal(0);
matrixinvcoeffs[23]=IkReal(0);
matrixinvcoeffs[24]=((((IkReal(-0.00949660000000000))*(r10)))+(x53)+(((IkReal(-1.00000000000000))*(x54))));
matrixinvcoeffs[25]=((((IkReal(-0.0274138450000000))*(r00)))+(x50)+(((IkReal(-1.00000000000000))*(x52))));
matrixinvcoeffs[26]=((IkReal(0.0257164050000000))*(r00));
matrixinvcoeffs[27]=x45;
matrixinvcoeffs[28]=((IkReal(-0.0946500000000000))*(r00));
matrixinvcoeffs[29]=((IkReal(-1.00000000000000))*(rxp0_1));
matrixinvcoeffs[30]=((IkReal(-0.135850000000000))*(r10));
matrixinvcoeffs[31]=((IkReal(0.271700000000000))*(rxp0_1));
matrixinvcoeffs[32]=((((IkReal(-0.00949660000000000))*(r11)))+(x56)+(((IkReal(-1.00000000000000))*(x57))));
matrixinvcoeffs[33]=((((IkReal(-0.0274138450000000))*(r01)))+(x49)+(((IkReal(-1.00000000000000))*(x55))));
matrixinvcoeffs[34]=((IkReal(0.0257164050000000))*(r01));
matrixinvcoeffs[35]=x46;
matrixinvcoeffs[36]=((IkReal(-0.0946500000000000))*(r01));
matrixinvcoeffs[37]=((IkReal(-1.00000000000000))*(rxp1_1));
matrixinvcoeffs[38]=((IkReal(-0.135850000000000))*(r11));
matrixinvcoeffs[39]=((IkReal(0.271700000000000))*(rxp1_1));
matrixinvcoeffs[40]=((IkReal(0.189300000000000))*(px));
matrixinvcoeffs[41]=x44;
matrixinvcoeffs[42]=((IkReal(-0.271700000000000))*(py));
matrixinvcoeffs[43]=px;
matrixinvcoeffs[44]=py;
matrixinvcoeffs[45]=IkReal(0);
matrixinvcoeffs[46]=IkReal(0);
matrixinvcoeffs[47]=IkReal(0);
matrixinvcoeffs[48]=((((IkReal(-0.00949660000000000))*(r00)))+(x52)+(((IkReal(-1.00000000000000))*(x50))));
matrixinvcoeffs[49]=((x53)+(((IkReal(0.0274138450000000))*(r10)))+(((IkReal(-1.00000000000000))*(x54))));
matrixinvcoeffs[50]=((IkReal(-0.0257164050000000))*(r10));
matrixinvcoeffs[51]=((IkReal(0.0946500000000000))*(r00));
matrixinvcoeffs[52]=x45;
matrixinvcoeffs[53]=((IkReal(-1.00000000000000))*(rxp0_0));
matrixinvcoeffs[54]=((IkReal(-0.135850000000000))*(r00));
matrixinvcoeffs[55]=((IkReal(0.271700000000000))*(rxp0_0));
matrixinvcoeffs[56]=((((IkReal(-1.00000000000000))*(x49)))+(((IkReal(-0.00949660000000000))*(r01)))+(x55));
matrixinvcoeffs[57]=((x56)+(((IkReal(0.0274138450000000))*(r11)))+(((IkReal(-1.00000000000000))*(x57))));
matrixinvcoeffs[58]=((IkReal(-0.0257164050000000))*(r11));
matrixinvcoeffs[59]=((IkReal(0.0946500000000000))*(r01));
matrixinvcoeffs[60]=x46;
matrixinvcoeffs[61]=((IkReal(-1.00000000000000))*(rxp1_0));
matrixinvcoeffs[62]=((IkReal(-0.135850000000000))*(r01));
matrixinvcoeffs[63]=((IkReal(0.271700000000000))*(rxp1_0));
if( !matrixinverse<8>(matrixinvcoeffs) ) {
continue;
}
IkReal gconst0_0=matrixinvcoeffs[0], gconst0_1=matrixinvcoeffs[8], gconst0_2=matrixinvcoeffs[16], gconst0_3=matrixinvcoeffs[24], gconst0_4=matrixinvcoeffs[32], gconst0_5=matrixinvcoeffs[40], gconst0_6=matrixinvcoeffs[48], gconst0_7=matrixinvcoeffs[56], gconst1_0=matrixinvcoeffs[1], gconst1_1=matrixinvcoeffs[9], gconst1_2=matrixinvcoeffs[17], gconst1_3=matrixinvcoeffs[25], gconst1_4=matrixinvcoeffs[33], gconst1_5=matrixinvcoeffs[41], gconst1_6=matrixinvcoeffs[49], gconst1_7=matrixinvcoeffs[57], gconst2_0=matrixinvcoeffs[2], gconst2_1=matrixinvcoeffs[10], gconst2_2=matrixinvcoeffs[18], gconst2_3=matrixinvcoeffs[26], gconst2_4=matrixinvcoeffs[34], gconst2_5=matrixinvcoeffs[42], gconst2_6=matrixinvcoeffs[50], gconst2_7=matrixinvcoeffs[58], gconst3_0=matrixinvcoeffs[3], gconst3_1=matrixinvcoeffs[11], gconst3_2=matrixinvcoeffs[19], gconst3_3=matrixinvcoeffs[27], gconst3_4=matrixinvcoeffs[35], gconst3_5=matrixinvcoeffs[43], gconst3_6=matrixinvcoeffs[51], gconst3_7=matrixinvcoeffs[59], gconst4_0=matrixinvcoeffs[4], gconst4_1=matrixinvcoeffs[12], gconst4_2=matrixinvcoeffs[20], gconst4_3=matrixinvcoeffs[28], gconst4_4=matrixinvcoeffs[36], gconst4_5=matrixinvcoeffs[44], gconst4_6=matrixinvcoeffs[52], gconst4_7=matrixinvcoeffs[60], gconst5_0=matrixinvcoeffs[5], gconst5_1=matrixinvcoeffs[13], gconst5_2=matrixinvcoeffs[21], gconst5_3=matrixinvcoeffs[29], gconst5_4=matrixinvcoeffs[37], gconst5_5=matrixinvcoeffs[45], gconst5_6=matrixinvcoeffs[53], gconst5_7=matrixinvcoeffs[61], gconst6_0=matrixinvcoeffs[6], gconst6_1=matrixinvcoeffs[14], gconst6_2=matrixinvcoeffs[22], gconst6_3=matrixinvcoeffs[30], gconst6_4=matrixinvcoeffs[38], gconst6_5=matrixinvcoeffs[46], gconst6_6=matrixinvcoeffs[54], gconst6_7=matrixinvcoeffs[62], gconst7_0=matrixinvcoeffs[7], gconst7_1=matrixinvcoeffs[15], gconst7_2=matrixinvcoeffs[23], gconst7_3=matrixinvcoeffs[31], gconst7_4=matrixinvcoeffs[39], gconst7_5=matrixinvcoeffs[47], gconst7_6=matrixinvcoeffs[55], gconst7_7=matrixinvcoeffs[63];
IkReal op[162], zeror[48];
int numroots;
IkReal x58=((gconst7_7)*(r01));
IkReal x59=((gconst1_3)*(r21));
IkReal x60=((gconst0_1)*(npx));
IkReal x61=((gconst1_3)*(npy));
IkReal x62=((IkReal(0.0521040950000000))*(gconst4_0));
IkReal x63=((IkReal(0.109150000000000))*(gconst1_4));
IkReal x64=((gconst3_1)*(rxp0_0));
IkReal x65=((IkReal(0.0257164050000000))*(r01));
IkReal x66=((gconst4_7)*(pz));
IkReal x67=((gconst3_0)*(r00));
IkReal x68=((IkReal(0.109911310000000))*(gconst4_7));
IkReal x69=((gconst6_1)*(r10));
IkReal x70=((gconst0_3)*(r20));
IkReal x71=((IkReal(0.0327500000000000))*(gconst7_3));
IkReal x72=((gconst4_2)*(r01));
IkReal x73=((gconst4_1)*(r01));
IkReal x74=((gconst7_7)*(r11));
IkReal x75=((IkReal(0.135850000000000))*(pp));
IkReal x76=((gconst1_7)*(r21));
IkReal x77=((gconst4_1)*(rxp1_0));
IkReal x78=((IkReal(0.00178545250000000))*(r10));
IkReal x79=((gconst0_1)*(r20));
IkReal x80=((gconst3_2)*(r00));
IkReal x81=((gconst3_7)*(r00));
IkReal x82=((gconst0_5)*(npx));
IkReal x83=((IkReal(1.33436934500000))*(gconst7_0));
IkReal x84=((gconst7_0)*(r11));
IkReal x85=((IkReal(0.109150000000000))*(gconst3_4));
IkReal x86=((IkReal(0.668610452500000))*(gconst3_7));
IkReal x87=((gconst4_3)*(r01));
IkReal x88=((IkReal(0.189300000000000))*(pz));
IkReal x89=((gconst0_7)*(npx));
IkReal x90=((gconst6_2)*(r10));
IkReal x91=((gconst1_2)*(npy));
IkReal x92=((IkReal(0.0257164050000000))*(pz));
IkReal x93=((IkReal(0.668610452500000))*(gconst6_7));
IkReal x94=((IkReal(0.109150000000000))*(gconst7_4));
IkReal x95=((IkReal(0.0534000000000000))*(gconst0_6));
IkReal x96=((IkReal(0.106800000000000))*(gconst4_5));
IkReal x97=((gconst0_2)*(r20));
IkReal x98=((gconst1_1)*(npy));
IkReal x99=((gconst0_0)*(r20));
IkReal x100=((gconst6_0)*(r10));
IkReal x101=((gconst0_3)*(npx));
IkReal x102=((gconst3_0)*(rxp0_0));
IkReal x103=((IkReal(0.0534000000000000))*(gconst1_6));
IkReal x104=((gconst4_7)*(r01));
IkReal x105=((gconst3_1)*(r00));
IkReal x106=((gconst7_5)*(rxp1_1));
IkReal x107=((gconst6_2)*(rxp0_1));
IkReal x108=((gconst6_3)*(r10));
IkReal x109=((IkReal(0.817250000000000))*(r11));
IkReal x110=((gconst1_0)*(r21));
IkReal x111=((IkReal(0.0267000000000000))*(gconst3_5));
IkReal x112=((IkReal(0.641196607500000))*(gconst7_2));
IkReal x113=((IkReal(0.0327500000000000))*(r00));
IkReal x114=((gconst0_0)*(npx));
IkReal x115=((gconst0_7)*(r20));
IkReal x116=((IkReal(0.0534000000000000))*(gconst3_6));
IkReal x117=((IkReal(1.33436934500000))*(gconst6_0));
IkReal x118=((gconst6_7)*(r10));
IkReal x119=((gconst3_2)*(rxp0_0));
IkReal x120=((IkReal(0.668610452500000))*(gconst4_7));
IkReal x121=((gconst0_4)*(r20));
IkReal x122=((IkReal(0.0256283925000000))*(r11));
IkReal x123=((gconst7_1)*(r11));
IkReal x124=((IkReal(0.106800000000000))*(gconst6_5));
IkReal x125=((gconst6_5)*(r10));
IkReal x126=((gconst3_1)*(r10));
IkReal x127=((gconst6_1)*(r00));
IkReal x128=((gconst6_0)*(r00));
IkReal x129=((IkReal(0.817250000000000))*(gconst7_3));
IkReal x130=((gconst7_5)*(r01));
IkReal x131=((gconst6_2)*(r00));
IkReal x132=((IkReal(0.000719345000000000))*(gconst4_0));
IkReal x133=((IkReal(0.109150000000000))*(gconst4_4));
IkReal x134=((IkReal(1.00000000000000))*(pp));
IkReal x135=((gconst7_2)*(rxp1_1));
IkReal x136=((gconst1_1)*(r21));
IkReal x137=((gconst1_0)*(npy));
IkReal x138=((gconst6_1)*(rxp0_1));
IkReal x139=((gconst3_3)*(r00));
IkReal x140=((IkReal(0.817250000000000))*(gconst3_3));
IkReal x141=((IkReal(0.0534000000000000))*(gconst7_6));
IkReal x142=((gconst6_7)*(rxp0_1));
IkReal x143=((gconst7_2)*(r11));
IkReal x144=((gconst7_3)*(r11));
IkReal x145=((gconst3_7)*(rxp0_0));
IkReal x146=((gconst7_7)*(rxp1_1));
IkReal x147=((gconst3_7)*(r10));
IkReal x148=((IkReal(0.0534000000000000))*(gconst4_6));
IkReal x149=((gconst0_2)*(npx));
IkReal x150=((gconst0_5)*(r20));
IkReal x151=((gconst4_5)*(r01));
IkReal x152=((gconst4_2)*(rxp1_0));
IkReal x153=((gconst7_5)*(r11));
IkReal x154=((IkReal(0.0946500000000000))*(pp));
IkReal x155=((gconst4_2)*(r11));
IkReal x156=((gconst1_2)*(r21));
IkReal x157=((gconst7_1)*(r01));
IkReal x158=((gconst6_4)*(r10));
IkReal x159=((gconst7_1)*(rxp1_1));
IkReal x160=((gconst4_1)*(r11));
IkReal x161=((gconst4_0)*(r01));
IkReal x162=((gconst1_5)*(r21));
IkReal x163=((gconst6_0)*(rxp0_1));
IkReal x164=((gconst1_5)*(npy));
IkReal x165=((gconst3_5)*(r00));
IkReal x166=((IkReal(1.33436934500000))*(gconst4_0));
IkReal x167=((IkReal(0.106800000000000))*(gconst3_5));
IkReal x168=((IkReal(0.00178545250000000))*(gconst4_7));
IkReal x169=((gconst6_6)*(r10));
IkReal x170=((gconst7_2)*(r01));
IkReal x171=((gconst1_7)*(npy));
IkReal x172=((gconst4_3)*(rxp1_0));
IkReal x173=((gconst7_0)*(r01));
IkReal x174=((gconst7_0)*(rxp1_1));
IkReal x175=((IkReal(0.817250000000000))*(gconst6_3));
IkReal x176=((gconst3_2)*(r10));
IkReal x177=((IkReal(0.0327500000000000))*(gconst3_3));
IkReal x178=((IkReal(0.0179172450000000))*(pz));
IkReal x179=((gconst6_7)*(r00));
IkReal x180=((gconst3_0)*(r10));
IkReal x181=((IkReal(0.0534000000000000))*(gconst6_6));
IkReal x182=((IkReal(0.0267000000000000))*(gconst6_5));
IkReal x183=((IkReal(0.0267000000000000))*(gconst4_5));
IkReal x184=((IkReal(0.109150000000000))*(gconst6_4));
IkReal x185=((IkReal(0.00362719500000000))*(x151));
IkReal x186=((IkReal(0.0148280275000000))*(gconst4_4)*(r01));
IkReal x187=((IkReal(0.0257164050000000))*(x60));
IkReal x188=((IkReal(0.00349357361925000))*(x73));
IkReal x189=((IkReal(0.817250000000000))*(x61));
IkReal x190=((IkReal(0.0267000000000000))*(x82));
IkReal x191=((IkReal(0.0267000000000000))*(x164));
IkReal x192=((IkReal(0.00362719500000000))*(x165));
IkReal x193=((IkReal(0.641196607500000))*(x91));
IkReal x194=((IkReal(0.0871065591288750))*(x80));
IkReal x195=((IkReal(0.0257164050000000))*(x98));
IkReal x196=((IkReal(0.111023412500000))*(x139));
IkReal x197=((IkReal(0.0871065591288750))*(x72));
IkReal x198=((IkReal(0.0148280275000000))*(gconst3_4)*(r00));
IkReal x199=((IkReal(0.641196607500000))*(x149));
IkReal x200=((IkReal(0.00349357361925000))*(x105));
IkReal x201=((IkReal(0.0908307299721250))*(x118));
IkReal x202=((IkReal(0.111023412500000))*(x87));
IkReal x203=((IkReal(0.817250000000000))*(x101));
IkReal x204=((npy)*(x63));
IkReal x205=((IkReal(0.109150000000000))*(gconst0_4)*(npx));
IkReal x206=((IkReal(0.0908307299721250))*(x74));
IkReal x207=((IkReal(0.0148280275000000))*(x158));
IkReal x208=((IkReal(0.0871065591288750))*(x143));
IkReal x209=((IkReal(0.111023412500000))*(x108));
IkReal x210=((IkReal(0.00362719500000000))*(x125));
IkReal x211=((IkReal(0.668610452500000))*(x89));
IkReal x212=((IkReal(0.0148280275000000))*(gconst7_4)*(r11));
IkReal x213=((IkReal(0.111023412500000))*(x144));
IkReal x214=((IkReal(0.0871065591288750))*(x90));
IkReal x215=((IkReal(0.00349357361925000))*(x123));
IkReal x216=((IkReal(0.00362719500000000))*(x153));
IkReal x217=((IkReal(0.0908307299721250))*(x81));
IkReal x218=((IkReal(0.00349357361925000))*(x69));
IkReal x219=((IkReal(0.0908307299721250))*(x104));
IkReal x220=((IkReal(0.668610452500000))*(x171));
IkReal x221=((IkReal(0.00725439000000000))*(gconst7_6)*(r11));
IkReal x222=((IkReal(0.00725439000000000))*(x169));
IkReal x223=((IkReal(0.00725439000000000))*(gconst3_6)*(r00));
IkReal x224=((IkReal(0.00725439000000000))*(gconst4_6)*(r01));
IkReal x225=((npx)*(x95));
IkReal x226=((npy)*(x103));
IkReal x227=((IkReal(0.00616623150000000))*(x105));
IkReal x228=((IkReal(0.0453900000000000))*(x60));
IkReal x229=((IkReal(0.00707834130575000))*(x84));
IkReal x230=((IkReal(0.00616623150000000))*(x73));
IkReal x231=((IkReal(0.00707834130575000))*(x100));
IkReal x232=((IkReal(0.0453900000000000))*(x98));
IkReal x233=((IkReal(0.0521040950000000))*(x137));
IkReal x234=((IkReal(0.00707834130575000))*(x161));
IkReal x235=((IkReal(0.00707834130575000))*(x67));
IkReal x236=((IkReal(0.00616623150000000))*(x69));
IkReal x237=((IkReal(0.0521040950000000))*(x114));
IkReal x238=((IkReal(0.00616623150000000))*(x123));
IkReal x239=((IkReal(0.00444908750000000))*(x87));
IkReal x240=((IkReal(0.00348161712112500))*(x143));
IkReal x241=((IkReal(0.00444908750000000))*(x139));
IkReal x242=((IkReal(0.0327500000000000))*(x101));
IkReal x243=((IkReal(0.000242553722125000))*(x81));
IkReal x244=((IkReal(0.000242553722125000))*(x104));
IkReal x245=((IkReal(0.00348161712112500))*(x90));
IkReal x246=((IkReal(0.00178545250000000))*(x171));
IkReal x247=((IkReal(0.00178545250000000))*(x89));
IkReal x248=((IkReal(0.0327500000000000))*(x61));
IkReal x249=((IkReal(0.000242553722125000))*(x74));
IkReal x250=((IkReal(0.00348161712112500))*(x72));
IkReal x251=((IkReal(0.0256283925000000))*(x149));
IkReal x252=((IkReal(0.000242553722125000))*(x118));
IkReal x253=((IkReal(0.0256283925000000))*(x91));
IkReal x254=((IkReal(0.00444908750000000))*(x144));
IkReal x255=((IkReal(0.00444908750000000))*(x108));
IkReal x256=((IkReal(0.00348161712112500))*(x80));
IkReal x257=((r00)*(x175));
IkReal x258=((r00)*(x184));
IkReal x259=((r00)*(x182));
IkReal x260=((r01)*(x129));
IkReal x261=((r11)*(x133));
IkReal x262=((r10)*(x111));
IkReal x263=((IkReal(0.0257164050000000))*(x160));
IkReal x264=((IkReal(0.0257164050000000))*(x126));
IkReal x265=((IkReal(0.641196607500000))*(x176));
IkReal x266=((gconst4_3)*(x109));
IkReal x267=((IkReal(0.641196607500000))*(x155));
IkReal x268=((IkReal(0.0257164050000000))*(x127));
IkReal x269=((r10)*(x140));
IkReal x270=((r11)*(x183));
IkReal x271=((gconst7_1)*(x65));
IkReal x272=((r01)*(x94));
IkReal x273=((IkReal(0.641196607500000))*(x131));
IkReal x274=((r01)*(x112));
IkReal x275=((r10)*(x85));
IkReal x276=((IkReal(0.0267000000000000))*(x130));
IkReal x277=((r00)*(x93));
IkReal x278=((IkReal(0.668610452500000))*(x58));
IkReal x279=((r11)*(x120));
IkReal x280=((r10)*(x86));
IkReal x281=((r11)*(x148));
IkReal x282=((r01)*(x141));
IkReal x283=((r00)*(x181));
IkReal x284=((r10)*(x116));
IkReal x285=((IkReal(0.0453900000000000))*(x160));
IkReal x286=((IkReal(0.0453900000000000))*(x157));
IkReal x287=((IkReal(0.0453900000000000))*(x127));
IkReal x288=((IkReal(0.0453900000000000))*(x126));
IkReal x289=((IkReal(0.0521040950000000))*(x128));
IkReal x290=((IkReal(0.0521040950000000))*(x180));
IkReal x291=((IkReal(0.0521040950000000))*(x173));
IkReal x292=((r11)*(x62));
IkReal x293=((IkReal(0.0327500000000000))*(gconst4_3)*(r11));
IkReal x294=((IkReal(0.00178545250000000))*(x179));
IkReal x295=((IkReal(0.00178545250000000))*(x58));
IkReal x296=((gconst3_7)*(x78));
IkReal x297=((r11)*(x168));
IkReal x298=((r01)*(x71));
IkReal x299=((gconst6_3)*(x113));
IkReal x300=((r10)*(x177));
IkReal x301=((IkReal(0.0256283925000000))*(x170));
IkReal x302=((IkReal(0.0256283925000000))*(x176));
IkReal x303=((gconst4_2)*(x122));
IkReal x304=((IkReal(0.0256283925000000))*(x131));
IkReal x305=((IkReal(0.0267000000000000))*(x125));
IkReal x306=((IkReal(0.668610452500000))*(x104));
IkReal x307=((gconst7_3)*(x109));
IkReal x308=((IkReal(0.817250000000000))*(x108));
IkReal x309=((pp)*(x72));
IkReal x310=((pp)*(x80));
IkReal x311=((IkReal(0.0257164050000000))*(x69));
IkReal x312=((IkReal(0.668610452500000))*(x81));
IkReal x313=((r11)*(x94));
IkReal x314=((r11)*(x112));
IkReal x315=((IkReal(0.0257164050000000))*(x123));
IkReal x316=((IkReal(0.641196607500000))*(x90));
IkReal x317=((IkReal(0.0267000000000000))*(x153));
IkReal x318=((IkReal(0.109150000000000))*(x158));
IkReal x319=((IkReal(0.668610452500000))*(x74));
IkReal x320=((r10)*(x93));
IkReal x321=((gconst4_1)*(x65));
IkReal x322=((r00)*(x111));
IkReal x323=((r01)*(x133));
IkReal x324=((IkReal(0.817250000000000))*(x87));
IkReal x325=((IkReal(0.641196607500000))*(x72));
IkReal x326=((IkReal(0.817250000000000))*(x139));
IkReal x327=((IkReal(0.0257164050000000))*(x105));
IkReal x328=((IkReal(0.641196607500000))*(x80));
IkReal x329=((IkReal(0.0267000000000000))*(x151));
IkReal x330=((r00)*(x85));
IkReal x331=((r01)*(x148));
IkReal x332=((r00)*(x116));
IkReal x333=((IkReal(0.0534000000000000))*(x169));
IkReal x334=((r11)*(x141));
IkReal x335=((IkReal(0.0256283925000000))*(x80));
IkReal x336=((gconst6_7)*(x78));
IkReal x337=((IkReal(0.00178545250000000))*(x74));
IkReal x338=((r11)*(x71));
IkReal x339=((IkReal(0.0327500000000000))*(x108));
IkReal x340=((IkReal(0.0256283925000000))*(x72));
IkReal x341=((IkReal(0.0327500000000000))*(x87));
IkReal x342=((gconst7_2)*(x122));
IkReal x343=((IkReal(0.00178545250000000))*(x104));
IkReal x344=((IkReal(0.00178545250000000))*(x81));
IkReal x345=((IkReal(0.0256283925000000))*(x90));
IkReal x346=((gconst3_3)*(x113));
IkReal x347=((IkReal(0.668610452500000))*(x115));
IkReal x348=((pp)*(x97));
IkReal x349=((pp)*(x156));
IkReal x350=((IkReal(0.668610452500000))*(x76));
IkReal x351=((IkReal(0.0267000000000000))*(x150));
IkReal x352=((IkReal(0.817250000000000))*(x59));
IkReal x353=((IkReal(0.109150000000000))*(x121));
IkReal x354=((IkReal(0.0257164050000000))*(x136));
IkReal x355=((IkReal(0.817250000000000))*(x70));
IkReal x356=((IkReal(0.641196607500000))*(x156));
IkReal x357=((IkReal(0.641196607500000))*(x97));
IkReal x358=((IkReal(0.0257164050000000))*(x79));
IkReal x359=((r21)*(x63));
IkReal x360=((IkReal(0.0267000000000000))*(x162));
IkReal x361=((r20)*(x95));
IkReal x362=((r21)*(x103));
IkReal x363=((IkReal(0.0256283925000000))*(x97));
IkReal x364=((IkReal(0.0256283925000000))*(x156));
IkReal x365=((IkReal(0.00178545250000000))*(x115));
IkReal x366=((IkReal(0.0327500000000000))*(x70));
IkReal x367=((IkReal(0.0327500000000000))*(x59));
IkReal x368=((IkReal(0.00178545250000000))*(x76));
IkReal x369=((rxp0_1)*(x184));
IkReal x370=((rxp1_0)*(x120));
IkReal x371=((rxp1_1)*(x112));
IkReal x372=((rxp0_1)*(x182));
IkReal x373=((rxp0_1)*(x175));
IkReal x374=((pp)*(x152));
IkReal x375=((IkReal(0.0257164050000000))*(x138));
IkReal x376=((IkReal(0.0267000000000000))*(x106));
IkReal x377=((rxp1_1)*(x129));
IkReal x378=((rxp1_1)*(x94));
IkReal x379=((pp)*(x119));
IkReal x380=((rxp0_0)*(x86));
IkReal x381=((IkReal(0.0257164050000000))*(x159));
IkReal x382=((IkReal(0.641196607500000))*(x107));
IkReal x383=((rxp0_0)*(x85));
IkReal x384=((rxp1_0)*(x183));
IkReal x385=((IkReal(0.641196607500000))*(x119));
IkReal x386=((rxp0_0)*(x111));
IkReal x387=((IkReal(0.668610452500000))*(x146));
IkReal x388=((IkReal(0.0257164050000000))*(x77));
IkReal x389=((rxp0_0)*(x140));
IkReal x390=((IkReal(0.0257164050000000))*(x64));
IkReal x391=((rxp1_0)*(x133));
IkReal x392=((IkReal(0.817250000000000))*(x172));
IkReal x393=((rxp0_1)*(x93));
IkReal x394=((IkReal(0.641196607500000))*(x152));
IkReal x395=((rxp0_0)*(x116));
IkReal x396=((rxp1_0)*(x148));
IkReal x397=((rxp1_1)*(x141));
IkReal x398=((rxp0_1)*(x181));
IkReal x399=((IkReal(0.0256283925000000))*(x152));
IkReal x400=((IkReal(0.00178545250000000))*(x146));
IkReal x401=((rxp1_1)*(x71));
IkReal x402=((IkReal(0.0327500000000000))*(gconst6_3)*(rxp0_1));
IkReal x403=((IkReal(0.0256283925000000))*(x119));
IkReal x404=((IkReal(0.00178545250000000))*(x142));
IkReal x405=((rxp0_0)*(x177));
IkReal x406=((rxp1_0)*(x168));
IkReal x407=((IkReal(0.0256283925000000))*(x107));
IkReal x408=((IkReal(0.00178545250000000))*(x145));
IkReal x409=((IkReal(0.0327500000000000))*(x172));
IkReal x410=((IkReal(0.0256283925000000))*(x135));
IkReal x411=((IkReal(0.00243405773325000))*(x136));
IkReal x412=((IkReal(0.00252715500000000))*(x162));
IkReal x413=((IkReal(0.0103310475000000))*(gconst1_4)*(r21));
IkReal x414=((IkReal(0.0606892588998750))*(x156));
IkReal x415=((IkReal(0.00243405773325000))*(x79));
IkReal x416=((IkReal(0.0773527125000000))*(x59));
IkReal x417=((IkReal(0.0606892588998750))*(x97));
IkReal x418=((IkReal(0.0103310475000000))*(x121));
IkReal x419=((IkReal(0.00252715500000000))*(x150));
IkReal x420=((IkReal(0.0773527125000000))*(x70));
IkReal x421=((IkReal(0.0632839793291250))*(x76));
IkReal x422=((IkReal(0.0632839793291250))*(x115));
IkReal x423=((IkReal(0.00505431000000000))*(gconst0_6)*(r20));
IkReal x424=((IkReal(0.00505431000000000))*(gconst1_6)*(r21));
IkReal x425=((IkReal(0.00429616350000000))*(x79));
IkReal x426=((IkReal(0.00429616350000000))*(x136));
IkReal x427=((IkReal(0.00493165259175000))*(x110));
IkReal x428=((IkReal(0.00493165259175000))*(x99));
IkReal x429=((r00)*(x88));
IkReal x430=((x88)*(x89));
IkReal x431=((x65)*(x66));
IkReal x432=((x81)*(x92));
IkReal x433=((x171)*(x88));
IkReal x434=((x75)*(x90));
IkReal x435=((x143)*(x75));
IkReal x436=((x74)*(x92));
IkReal x437=((x118)*(x92));
IkReal x438=((x72)*(x75));
IkReal x439=((x134)*(x91));
IkReal x440=((x134)*(x149));
IkReal x441=((x75)*(x80));
IkReal x442=((x179)*(x88));
IkReal x443=((IkReal(0.189300000000000))*(r11)*(x66));
IkReal x444=((x147)*(x88));
IkReal x445=((x58)*(x88));
IkReal x446=((x134)*(x155));
IkReal x447=((x131)*(x134));
IkReal x448=((x134)*(x170));
IkReal x449=((x134)*(x176));
IkReal x450=((x118)*(x88));
IkReal x451=((x74)*(x88));
IkReal x452=((IkReal(0.189300000000000))*(r01)*(x66));
IkReal x453=((x81)*(x88));
IkReal x454=((x134)*(x90));
IkReal x455=((x134)*(x143));
IkReal x456=((x115)*(x88));
IkReal x457=((x76)*(x88));
IkReal x458=((x146)*(x88));
IkReal x459=((x142)*(x88));
IkReal x460=((x134)*(x135));
IkReal x461=((x107)*(x134));
IkReal x462=((IkReal(0.189300000000000))*(rxp1_0)*(x66));
IkReal x463=((x145)*(x88));
IkReal x464=((x115)*(x178));
IkReal x465=((x178)*(x76));
IkReal x466=((x154)*(x156));
IkReal x467=((x154)*(x97));
IkReal x468=((((IkReal(0.0521040950000000))*(x110)))+(((IkReal(0.0521040950000000))*(x99))));
IkReal x469=((x221)+(x222));
IkReal x470=((x350)+(x347));
IkReal x471=((x348)+(x349));
IkReal x472=((x366)+(x367));
IkReal x473=((x368)+(x365));
IkReal x474=((x424)+(x423));
IkReal x475=((x332)+(x331));
IkReal x476=((x351)+(x360));
IkReal x477=((x333)+(x334));
IkReal x478=((x376)+(x372));
IkReal x479=((x380)+(x370));
IkReal x480=((x305)+(x317));
IkReal x481=((x343)+(x344));
IkReal x482=((x363)+(x364));
IkReal x483=((x426)+(x425));
IkReal x484=((x397)+(x398));
IkReal x485=((x422)+(x421));
IkReal x486=((x428)+(x427));
IkReal x487=((x361)+(x362));
IkReal x488=((x406)+(x408));
IkReal x489=((x395)+(x396));
IkReal x490=((x306)+(x312));
IkReal x491=((x412)+(x419));
IkReal x492=((x467)+(x466));
IkReal x493=((((IkReal(0.0453900000000000))*(x136)))+(((IkReal(0.0453900000000000))*(x79)))+(x487));
IkReal x494=((x337)+(x336)+(x322)+(x329));
IkReal x495=((x342)+(x341)+(x346)+(x345));
IkReal x496=((x294)+(x295)+(x296)+(x297));
IkReal x497=((x300)+(x298)+(x299)+(x293));
IkReal x498=((x339)+(x338)+(x335)+(x340));
IkReal x499=((x304)+(x302)+(x303)+(x301));
IkReal x500=((x352)+(x355)+(x357)+(x356));
IkReal x501=((x308)+(x307)+(x314)+(x316));
IkReal x502=((x320)+(x322)+(x329)+(x319));
IkReal x503=((x277)+(x278)+(x279)+(x280));
IkReal x504=((x416)+(x417)+(x414)+(x420));
IkReal x505=((x386)+(x387)+(x384)+(x393));
IkReal x506=((x213)+(x214)+(x209)+(x208));
IkReal x507=((x385)+(x389)+(x394)+(x392));
IkReal x508=((x290)+(x291)+(x292)+(x289));
IkReal x509=((x259)+(x262)+(x276)+(x270));
IkReal x510=((x284)+(x283)+(x282)+(x281));
IkReal x511=((x405)+(x407)+(x409)+(x410));
IkReal x512=((x288)+(x287)+(x286)+(x285));
IkReal x513=((x324)+(x325)+(x326)+(x328));
IkReal x514=((x386)+(x384)+(x400)+(x404));
IkReal x515=((x223)+(x225)+(x224)+(x226));
IkReal x516=((x449)+(x448)+(x447)+(x446));
IkReal x517=((((IkReal(0.0521040950000000))*(x67)))+(((IkReal(0.0453900000000000))*(x69)))+(((r01)*(x62)))+(x477)+(((IkReal(0.0453900000000000))*(x123))));
IkReal x518=((((IkReal(0.0521040950000000))*(x100)))+(((IkReal(0.0521040950000000))*(x84)))+(((IkReal(0.0453900000000000))*(x73)))+(x475)+(((IkReal(0.0453900000000000))*(x105))));
IkReal x519=((((IkReal(0.0453900000000000))*(x138)))+(((IkReal(0.0453900000000000))*(x159)))+(((IkReal(0.0521040950000000))*(x102)))+(x484)+(((rxp1_0)*(x62))));
IkReal x520=((((IkReal(0.0453900000000000))*(x64)))+(((IkReal(0.0521040950000000))*(x163)))+(((IkReal(0.0521040950000000))*(x174)))+(((IkReal(0.0453900000000000))*(x77)))+(x489));
IkReal x521=((x238)+(x233)+(x236)+(x237)+(x234)+(x235));
IkReal x522=((x210)+(x211)+(x216)+(x217)+(x219)+(x220));
IkReal x523=((x192)+(x191)+(x190)+(x185)+(x206)+(x201));
IkReal x524=((x210)+(x216)+(x243)+(x247)+(x246)+(x244));
IkReal x525=((x254)+(x255)+(x256)+(x250)+(x251)+(x253));
IkReal x526=((x192)+(x191)+(x190)+(x185)+(x252)+(x249));
IkReal x527=((x353)+(x354)+(x359)+(x358)+(x456)+(x457));
IkReal x528=((x413)+(x411)+(x415)+(x418)+(x465)+(x464)+(pz));
IkReal x529=((x257)+(x265)+(x267)+(x266)+(x260)+(x269)+(x274)+(x273));
IkReal x530=((x309)+(x318)+(x315)+(x311)+(x310)+(x313)+(x450)+(x451));
IkReal x531=((x330)+(x327)+(x321)+(x323)+(x454)+(x455)+(x452)+(x453));
IkReal x532=((x383)+(x388)+(x391)+(x390)+(x463)+(x462)+(x461)+(x460));
IkReal x533=((x229)+(x228)+(x227)+(x232)+(x230)+(x231)+(x515));
IkReal x534=((x212)+(x215)+(x218)+(x207)+(x438)+(x439)+(x436)+(x437)+(x441)+(x440));
IkReal x535=((x382)+(x381)+(x379)+(x378)+(x377)+(x375)+(x374)+(x373)+(x371)+(x369)+(x458)+(x459));
IkReal x536=((x381)+(x379)+(x378)+(x375)+(x374)+(x369)+(x399)+(x401)+(x403)+(x402)+(x458)+(x459));
IkReal x537=((x258)+(x264)+(x261)+(x263)+(x268)+(x275)+(x272)+(x271)+(x445)+(x444)+(x443)+(x442));
IkReal x538=((IkReal(0.0946500000000000))+(x198)+(x195)+(x186)+(x187)+(x188)+(x239)+(x205)+(x204)+(x200)+(x242)+(x241)+(x240)+(x245)+(x248)+(x430)+(x431)+(x432)+(x433)+(x434)+(x435));
IkReal x539=((IkReal(0.0946500000000000))+(x199)+(x198)+(x193)+(x197)+(x196)+(x195)+(x194)+(x186)+(x187)+(x188)+(x189)+(x205)+(x204)+(x203)+(x202)+(x200)+(x430)+(x431)+(x432)+(x433)+(x434)+(x435));
op[0]=((((IkReal(-1.00000000000000))*(x506)))+(((IkReal(-1.00000000000000))*(x534)))+(((IkReal(-1.00000000000000))*(x523)))+(x539)+(x522));
op[1]=((IkReal(-1.63450000000000))+(((IkReal(-0.0118573004550000))*(x73)))+(((IkReal(1.33436934500000))*(x137)))+(((IkReal(-0.181274075518250))*(x100)))+(((IkReal(1.33436934500000))*(x114)))+(((IkReal(0.181274075518250))*(x161)))+(((IkReal(-0.0872823000000000))*(x60)))+(((IkReal(-0.0872823000000000))*(x98)))+(((IkReal(0.181274075518250))*(x67)))+(x469)+(((IkReal(-0.0118573004550000))*(x105)))+(((IkReal(0.0118573004550000))*(x69)))+(((IkReal(-0.181274075518250))*(x84)))+(((IkReal(-1.00000000000000))*(x515)))+(((IkReal(0.0118573004550000))*(x123))));
op[2]=((((IkReal(-1.00000000000000))*(x506)))+(((IkReal(-1.00000000000000))*(x534)))+(((IkReal(-1.00000000000000))*(x522)))+(x539)+(x523));
op[3]=((IkReal(-0.850000000000000))+(((IkReal(-1.00000000000000))*(x533)))+(x469)+(x521));
op[4]=((((IkReal(0.106800000000000))*(x164)))+(((IkReal(0.0145087800000000))*(x151)))+(((IkReal(-0.0149314514635000))*(x81)))+(((IkReal(0.0149314514635000))*(x74)))+(((IkReal(-0.0145087800000000))*(x125)))+(((IkReal(0.0145087800000000))*(x165)))+(((IkReal(0.0149314514635000))*(x118)))+(((IkReal(-0.0149314514635000))*(x104)))+(((IkReal(0.106800000000000))*(x82)))+(((IkReal(-0.0145087800000000))*(x153)))+(((IkReal(-0.109911310000000))*(x171)))+(((IkReal(-0.109911310000000))*(x89))));
op[5]=((IkReal(0.850000000000000))+(((IkReal(-1.00000000000000))*(x469)))+(((IkReal(-1.00000000000000))*(x521)))+(x533));
op[6]=((((IkReal(-1.00000000000000))*(x534)))+(((IkReal(-1.00000000000000))*(x525)))+(((IkReal(-1.00000000000000))*(x524)))+(x538)+(x526));
op[7]=((IkReal(0.0655000000000000))+(((IkReal(-9.77230182500000e-5))*(x67)))+(((IkReal(-9.77230182500000e-5))*(x161)))+(((IkReal(0.00349770000000000))*(x60)))+(((IkReal(-0.000475162545000000))*(x69)))+(((IkReal(-1.00000000000000))*(x469)))+(((IkReal(-0.000719345000000000))*(x114)))+(((IkReal(9.77230182500000e-5))*(x84)))+(x515)+(((IkReal(-0.000719345000000000))*(x137)))+(((IkReal(-0.000475162545000000))*(x123)))+(((IkReal(0.000475162545000000))*(x73)))+(((IkReal(0.000475162545000000))*(x105)))+(((IkReal(0.00349770000000000))*(x98)))+(((IkReal(9.77230182500000e-5))*(x100))));
op[8]=((((IkReal(-1.00000000000000))*(x534)))+(((IkReal(-1.00000000000000))*(x526)))+(((IkReal(-1.00000000000000))*(x525)))+(x538)+(x524));
op[9]=((((IkReal(-1.00000000000000))*(x509)))+(x503)+(x537)+(x529)+(((IkReal(-1.00000000000000))*(x516))));
op[10]=((IkReal(-2.00000000000000))+(((IkReal(-0.0872823000000000))*(x160)))+(((r01)*(x83)))+(((IkReal(-0.0872823000000000))*(x157)))+(((IkReal(1.33436934500000))*(x180)))+(((r00)*(x117)))+(((IkReal(-1.00000000000000))*(x510)))+(((IkReal(-0.0872823000000000))*(x126)))+(((IkReal(-0.0872823000000000))*(x127)))+(((r11)*(x166))));
op[11]=((((IkReal(-1.00000000000000))*(x503)))+(x509)+(x537)+(x529)+(((IkReal(-1.00000000000000))*(x516))));
op[12]=((IkReal(-2.00000000000000))+(x508)+(((IkReal(-1.00000000000000))*(x512)))+(((IkReal(-1.00000000000000))*(x510))));
op[13]=((((r11)*(x96)))+(((IkReal(0.106800000000000))*(x130)))+(((r00)*(x124)))+(((IkReal(-1.00000000000000))*(r11)*(x68)))+(((IkReal(-0.109911310000000))*(x58)))+(((r10)*(x167)))+(((IkReal(-0.109911310000000))*(x147)))+(((IkReal(-0.109911310000000))*(x179))));
op[14]=((IkReal(2.00000000000000))+(((IkReal(-1.00000000000000))*(x508)))+(x512)+(x510));
op[15]=((((IkReal(-1.00000000000000))*(x499)))+(((IkReal(-1.00000000000000))*(x496)))+(x497)+(x509)+(x537)+(((IkReal(-1.00000000000000))*(x516))));
op[16]=((IkReal(2.00000000000000))+(((IkReal(0.00349770000000000))*(x160)))+(((IkReal(0.00349770000000000))*(x127)))+(((IkReal(0.00349770000000000))*(x126)))+(((IkReal(-1.00000000000000))*(r11)*(x132)))+(((IkReal(-0.000719345000000000))*(x173)))+(((IkReal(-0.000719345000000000))*(x180)))+(x510)+(((IkReal(-0.000719345000000000))*(x128)))+(((IkReal(0.00349770000000000))*(x157))));
op[17]=((((IkReal(-1.00000000000000))*(x499)))+(((IkReal(-1.00000000000000))*(x509)))+(x496)+(x497)+(x537)+(((IkReal(-1.00000000000000))*(x516))));
op[18]=((((IkReal(-1.00000000000000))*(x490)))+(((IkReal(-1.00000000000000))*(x480)))+(((IkReal(-1.00000000000000))*(x531)))+(x501)+(x502)+(x530)+(((IkReal(-1.00000000000000))*(x513))));
op[19]=((((IkReal(0.0872823000000000))*(x73)))+(((r11)*(x83)))+(((IkReal(1.33436934500000))*(x100)))+(((IkReal(0.0872823000000000))*(x105)))+(((IkReal(-0.0872823000000000))*(x69)))+(((IkReal(-1.00000000000000))*(x477)))+(x475)+(((IkReal(-1.33436934500000))*(x161)))+(((IkReal(-1.33436934500000))*(x67)))+(((IkReal(-0.0872823000000000))*(x123))));
op[20]=((((IkReal(-1.00000000000000))*(x502)))+(((IkReal(-1.00000000000000))*(x531)))+(x480)+(x490)+(x501)+(x530)+(((IkReal(-1.00000000000000))*(x513))));
op[21]=((x518)+(((IkReal(-1.00000000000000))*(x517))));
op[22]=((((IkReal(-0.106800000000000))*(x165)))+(((IkReal(0.109911310000000))*(x81)))+(((IkReal(-0.109911310000000))*(x118)))+(((IkReal(-0.109911310000000))*(x74)))+(((r01)*(x68)))+(((IkReal(-1.00000000000000))*(r01)*(x96)))+(((IkReal(0.106800000000000))*(x153)))+(((r10)*(x124))));
op[23]=((x517)+(((IkReal(-1.00000000000000))*(x518))));
op[24]=((((IkReal(-1.00000000000000))*(x495)))+(((IkReal(-1.00000000000000))*(x494)))+(((IkReal(-1.00000000000000))*(x531)))+(x481)+(x480)+(x498)+(x530));
op[25]=((((IkReal(0.00349770000000000))*(x69)))+(((IkReal(-0.00349770000000000))*(x73)))+(((IkReal(0.00349770000000000))*(x123)))+(((IkReal(-1.00000000000000))*(x475)))+(((r01)*(x132)))+(((IkReal(-0.000719345000000000))*(x84)))+(((IkReal(-0.000719345000000000))*(x100)))+(x477)+(((IkReal(-0.00349770000000000))*(x105)))+(((IkReal(0.000719345000000000))*(x67))));
op[26]=((((IkReal(-1.00000000000000))*(x495)))+(((IkReal(-1.00000000000000))*(x480)))+(((IkReal(-1.00000000000000))*(x481)))+(((IkReal(-1.00000000000000))*(x531)))+(x498)+(x494)+(x530));
op[27]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x500)))+(((IkReal(-1.00000000000000))*(x470)))+(((IkReal(-1.00000000000000))*(x527)))+(x476)+(x471));
op[28]=((((IkReal(0.0872823000000000))*(x79)))+(((IkReal(-1.33436934500000))*(x99)))+(((IkReal(0.0872823000000000))*(x136)))+(((IkReal(-1.33436934500000))*(x110)))+(x487));
op[29]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x500)))+(((IkReal(-1.00000000000000))*(x476)))+(((IkReal(-1.00000000000000))*(x527)))+(x470)+(x471));
op[30]=((((IkReal(-1.00000000000000))*(x468)))+(x493));
op[31]=((IkReal(-4.00000000000000))+(((IkReal(-0.106800000000000))*(x162)))+(((IkReal(0.109911310000000))*(x115)))+(((IkReal(-0.106800000000000))*(x150)))+(((IkReal(0.109911310000000))*(x76))));
op[32]=((((IkReal(-1.00000000000000))*(x493)))+(x468));
op[33]=((IkReal(-1.00000000000000))+(((IkReal(-1.00000000000000))*(x476)))+(((IkReal(-1.00000000000000))*(x472)))+(((IkReal(-1.00000000000000))*(x527)))+(x482)+(x471)+(x473));
op[34]=((((IkReal(-1.00000000000000))*(x487)))+(((IkReal(-0.00349770000000000))*(x79)))+(((IkReal(0.000719345000000000))*(x99)))+(((IkReal(-0.00349770000000000))*(x136)))+(((IkReal(0.000719345000000000))*(x110))));
op[35]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x473)))+(((IkReal(-1.00000000000000))*(x472)))+(((IkReal(-1.00000000000000))*(x527)))+(x482)+(x476)+(x471));
op[36]=((IkReal(-0.817250000000000))+(((IkReal(-1.00000000000000))*(x507)))+(((IkReal(-1.00000000000000))*(x479)))+(((IkReal(-1.00000000000000))*(x478)))+(((IkReal(-1.00000000000000))*(x532)))+(x505)+(x535));
op[37]=((((IkReal(0.0872823000000000))*(x77)))+(((IkReal(-0.0872823000000000))*(x138)))+(((IkReal(-1.00000000000000))*(x484)))+(((IkReal(0.0872823000000000))*(x64)))+(((IkReal(-0.0872823000000000))*(x159)))+(((rxp1_1)*(x83)))+(x489)+(((IkReal(-1.33436934500000))*(x102)))+(((rxp0_1)*(x117)))+(((IkReal(-1.00000000000000))*(rxp1_0)*(x166))));
op[38]=((IkReal(0.817250000000000))+(((IkReal(-1.00000000000000))*(x507)))+(((IkReal(-1.00000000000000))*(x505)))+(((IkReal(-1.00000000000000))*(x532)))+(x478)+(x479)+(x535));
op[39]=((x520)+(((IkReal(-1.00000000000000))*(x519))));
op[40]=((IkReal(1.70000000000000))+(((IkReal(0.106800000000000))*(x106)))+(((IkReal(-1.00000000000000))*(rxp1_0)*(x96)))+(((rxp0_1)*(x124)))+(((rxp1_0)*(x68)))+(((IkReal(0.109911310000000))*(x145)))+(((IkReal(-0.109911310000000))*(x142)))+(((IkReal(-0.109911310000000))*(x146)))+(((IkReal(-1.00000000000000))*(rxp0_0)*(x167))));
op[41]=((((IkReal(-1.00000000000000))*(x520)))+(x519));
op[42]=((IkReal(0.0327500000000000))+(((IkReal(-1.00000000000000))*(x532)))+(x488)+(x478)+(x536)+(((IkReal(-1.00000000000000))*(x514)))+(((IkReal(-1.00000000000000))*(x511))));
op[43]=((((IkReal(-0.00349770000000000))*(x64)))+(((rxp1_0)*(x132)))+(((IkReal(-1.00000000000000))*(x489)))+(((IkReal(-0.00349770000000000))*(x77)))+(((IkReal(-0.000719345000000000))*(x174)))+(((IkReal(0.00349770000000000))*(x138)))+(((IkReal(-0.000719345000000000))*(x163)))+(x484)+(((IkReal(0.000719345000000000))*(x102)))+(((IkReal(0.00349770000000000))*(x159))));
op[44]=((IkReal(-0.0327500000000000))+(((IkReal(-1.00000000000000))*(x488)))+(((IkReal(-1.00000000000000))*(x478)))+(((IkReal(-1.00000000000000))*(x532)))+(x536)+(x514)+(((IkReal(-1.00000000000000))*(x511))));
op[45]=((((IkReal(-1.00000000000000))*(x491)))+(((IkReal(-1.00000000000000))*(x492)))+(x485)+(x504)+(x528));
op[46]=((((IkReal(-0.00826126969500000))*(x136)))+(((IkReal(-1.00000000000000))*(x474)))+(((IkReal(0.126298058504250))*(x110)))+(((IkReal(0.126298058504250))*(x99)))+(((IkReal(-0.00826126969500000))*(x79))));
op[47]=((((IkReal(-1.00000000000000))*(x492)))+(((IkReal(-1.00000000000000))*(x485)))+(x491)+(x504)+(x528));
op[48]=((IkReal(0.784500000000000))+(((IkReal(-1.00000000000000))*(x483)))+(((IkReal(-1.00000000000000))*(x474)))+(x486));
op[49]=((((IkReal(-0.0104031054915000))*(x76)))+(((IkReal(0.0101086200000000))*(x162)))+(((IkReal(-0.0104031054915000))*(x115)))+(((IkReal(0.0101086200000000))*(x150))));
op[50]=((IkReal(0.784500000000000))+(((IkReal(-1.00000000000000))*(x486)))+(x483)+(x474));
op[51]=((((IkReal(-1.00000000000000))*(x492)))+(((IkReal(-0.00242572735012500))*(x97)))+(((IkReal(-0.00242572735012500))*(x156)))+(x491)+(x528)+(((IkReal(0.00309978750000000))*(x59)))+(((IkReal(-0.000168993079125000))*(x76)))+(((IkReal(0.00309978750000000))*(x70)))+(((IkReal(-0.000168993079125000))*(x115))));
op[52]=((((IkReal(0.000331057305000000))*(x79)))+(x474)+(((IkReal(-6.80860042500000e-5))*(x110)))+(((IkReal(-6.80860042500000e-5))*(x99)))+(((IkReal(0.000331057305000000))*(x136))));
IkReal x540=((gconst7_7)*(r01));
IkReal x541=((gconst0_3)*(r20));
IkReal x542=((gconst1_3)*(r21));
IkReal x543=((gconst4_0)*(r11));
IkReal x544=((gconst0_1)*(npx));
IkReal x545=((gconst1_3)*(npy));
IkReal x546=((gconst4_0)*(r01));
IkReal x547=((gconst6_7)*(r10));
IkReal x548=((gconst0_7)*(npx));
IkReal x549=((gconst6_0)*(r10));
IkReal x550=((gconst7_0)*(r01));
IkReal x551=((IkReal(0.0257164050000000))*(r01));
IkReal x552=((gconst4_7)*(pz));
IkReal x553=((gconst3_0)*(r00));
IkReal x554=((gconst4_7)*(r11));
IkReal x555=((gconst3_0)*(r10));
IkReal x556=((gconst6_3)*(r10));
IkReal x557=((gconst0_0)*(r20));
IkReal x558=((gconst3_2)*(r00));
IkReal x559=((gconst4_1)*(r01));
IkReal x560=((IkReal(2.66873869000000))*(gconst7_7));
IkReal x561=((gconst7_7)*(r11));
IkReal x562=((gconst4_2)*(r01));
IkReal x563=((IkReal(0.135850000000000))*(pp));
IkReal x564=((gconst0_6)*(npx));
IkReal x565=((gconst0_5)*(npx));
IkReal x566=((IkReal(0.189300000000000))*(pz));
IkReal x567=((gconst3_7)*(r00));
IkReal x568=((gconst7_0)*(r11));
IkReal x569=((gconst4_7)*(r01));
IkReal x570=((gconst6_1)*(r10));
IkReal x571=((gconst1_0)*(npy));
IkReal x572=((gconst6_2)*(r10));
IkReal x573=((gconst1_2)*(npy));
IkReal x574=((IkReal(0.0257164050000000))*(pz));
IkReal x575=((gconst4_3)*(r01));
IkReal x576=((gconst0_6)*(r20));
IkReal x577=((IkReal(0.213600000000000))*(gconst6_6));
IkReal x578=((IkReal(0.106800000000000))*(gconst4_5));
IkReal x579=((gconst0_2)*(r20));
IkReal x580=((gconst1_1)*(npy));
IkReal x581=((gconst0_3)*(npx));
IkReal x582=((gconst1_6)*(r21));
IkReal x583=((gconst3_7)*(r10));
IkReal x584=((gconst1_7)*(npy));
IkReal x585=((gconst1_7)*(r21));
IkReal x586=((gconst3_1)*(r00));
IkReal x587=((gconst6_1)*(r00));
IkReal x588=((IkReal(1.56900000000000))*(gconst4_3));
IkReal x589=((IkReal(0.817250000000000))*(r11));
IkReal x590=((IkReal(0.0267000000000000))*(gconst3_5));
IkReal x591=((gconst0_2)*(npx));
IkReal x592=((gconst7_2)*(r01));
IkReal x593=((gconst0_7)*(r20));
IkReal x594=((gconst6_6)*(r10));
IkReal x595=((gconst0_0)*(npx));
IkReal x596=((IkReal(0.0534000000000000))*(gconst3_6));
IkReal x597=((gconst6_0)*(r00));
IkReal x598=((gconst4_6)*(r01));
IkReal x599=((gconst6_7)*(r00));
IkReal x600=((gconst3_3)*(r10));
IkReal x601=((gconst0_5)*(r20));
IkReal x602=((gconst7_1)*(r11));
IkReal x603=((gconst6_3)*(r00));
IkReal x604=((IkReal(0.106800000000000))*(gconst6_5));
IkReal x605=((gconst6_5)*(r10));
IkReal x606=((gconst3_1)*(r10));
IkReal x607=((IkReal(0.106800000000000))*(gconst7_5));
IkReal x608=((gconst3_2)*(r10));
IkReal x609=((gconst3_6)*(r00));
IkReal x610=((gconst6_2)*(r00));
IkReal x611=((gconst3_5)*(r00));
IkReal x612=((gconst7_4)*(r11));
IkReal x613=((gconst3_3)*(r00));
IkReal x614=((IkReal(1.56900000000000))*(gconst7_3));
IkReal x615=((IkReal(0.0534000000000000))*(gconst7_6));
IkReal x616=((gconst1_6)*(npy));
IkReal x617=((gconst7_6)*(r11));
IkReal x618=((gconst7_2)*(r11));
IkReal x619=((gconst7_3)*(r11));
IkReal x620=((gconst7_0)*(rxp1_1));
IkReal x621=((gconst6_7)*(rxp0_1));
IkReal x622=((gconst4_6)*(r11));
IkReal x623=((IkReal(1.00000000000000))*(pp));
IkReal x624=((IkReal(0.213600000000000))*(gconst3_6));
IkReal x625=((gconst4_5)*(r01));
IkReal x626=((gconst7_5)*(r11));
IkReal x627=((gconst3_0)*(rxp0_0));
IkReal x628=((IkReal(0.0946500000000000))*(pp));
IkReal x629=((gconst3_7)*(rxp0_0));
IkReal x630=((gconst4_2)*(r11));
IkReal x631=((gconst7_1)*(r01));
IkReal x632=((gconst6_4)*(r10));
IkReal x633=((gconst6_0)*(rxp0_1));
IkReal x634=((gconst1_2)*(r21));
IkReal x635=((IkReal(0.109150000000000))*(r01));
IkReal x636=((gconst1_0)*(r21));
IkReal x637=((gconst1_5)*(r21));
IkReal x638=((gconst1_5)*(npy));
IkReal x639=((gconst4_7)*(rxp1_0));
IkReal x640=((IkReal(0.106800000000000))*(gconst3_5));
IkReal x641=((gconst4_1)*(r11));
IkReal x642=((gconst3_4)*(r00));
IkReal x643=((IkReal(0.213600000000000))*(gconst7_6));
IkReal x644=((IkReal(0.0179172450000000))*(pz));
IkReal x645=((gconst4_0)*(rxp1_0));
IkReal x646=((gconst4_6)*(rxp1_0));
IkReal x647=((gconst7_3)*(r01));
IkReal x648=((IkReal(0.0534000000000000))*(gconst6_6));
IkReal x649=((gconst7_7)*(rxp1_1));
IkReal x650=((IkReal(0.0145087800000000))*(x611));
IkReal x651=((IkReal(0.106800000000000))*(x638));
IkReal x652=((IkReal(0.106800000000000))*(x565));
IkReal x653=((IkReal(0.0145087800000000))*(x625));
IkReal x654=((IkReal(0.0145087800000000))*(x605));
IkReal x655=((IkReal(0.0145087800000000))*(x626));
IkReal x656=((IkReal(0.0141566826115000))*(x561));
IkReal x657=((IkReal(0.213148650000000))*(x619));
IkReal x658=((IkReal(0.213148650000000))*(x556));
IkReal x659=((IkReal(0.0141566826115000))*(x547));
IkReal x660=((IkReal(0.104208190000000))*(x548));
IkReal x661=((IkReal(0.213148650000000))*(x575));
IkReal x662=((IkReal(0.213148650000000))*(x613));
IkReal x663=((IkReal(0.0141566826115000))*(x567));
IkReal x664=((IkReal(0.104208190000000))*(x584));
IkReal x665=((IkReal(1.56900000000000))*(x545));
IkReal x666=((IkReal(0.0141566826115000))*(x569));
IkReal x667=((IkReal(1.56900000000000))*(x581));
IkReal x668=((IkReal(0.00725439000000000))*(x609));
IkReal x669=((IkReal(0.00725439000000000))*(x598));
IkReal x670=((IkReal(0.0534000000000000))*(x564));
IkReal x671=((IkReal(0.0534000000000000))*(x616));
IkReal x672=((IkReal(0.00725439000000000))*(x617));
IkReal x673=((IkReal(0.00725439000000000))*(x594));
IkReal x674=((IkReal(0.0534000000000000))*(x622));
IkReal x675=((r01)*(x615));
IkReal x676=((IkReal(1.33722090500000))*(x597));
IkReal x677=((IkReal(1.33722090500000))*(x543));
IkReal x678=((r00)*(x648));
IkReal x679=((r10)*(x596));
IkReal x680=((IkReal(1.33722090500000))*(x555));
IkReal x681=((IkReal(1.33722090500000))*(x550));
IkReal x682=((r10)*(x640));
IkReal x683=((r00)*(x604));
IkReal x684=((r11)*(x578));
IkReal x685=((r01)*(x607));
IkReal x686=((IkReal(0.104208190000000))*(x540));
IkReal x687=((IkReal(1.56900000000000))*(x603));
IkReal x688=((IkReal(0.104208190000000))*(x583));
IkReal x689=((IkReal(0.104208190000000))*(x554));
IkReal x690=((r01)*(x614));
IkReal x691=((IkReal(0.104208190000000))*(x599));
IkReal x692=((r11)*(x588));
IkReal x693=((IkReal(1.56900000000000))*(x600));
IkReal x694=((IkReal(0.00357090500000000))*(x550));
IkReal x695=((IkReal(0.00357090500000000))*(x597));
IkReal x696=((IkReal(0.00357090500000000))*(x555));
IkReal x697=((IkReal(0.00357090500000000))*(x543));
IkReal x698=((r10)*(x604));
IkReal x699=((r11)*(x607));
IkReal x700=((r01)*(x578));
IkReal x701=((IkReal(0.106800000000000))*(x611));
IkReal x702=((IkReal(0.104208190000000))*(x567));
IkReal x703=((IkReal(0.104208190000000))*(x569));
IkReal x704=((IkReal(1.56900000000000))*(x613));
IkReal x705=((IkReal(1.56900000000000))*(x575));
IkReal x706=((IkReal(1.56900000000000))*(x556));
IkReal x707=((r11)*(x614));
IkReal x708=((IkReal(0.104208190000000))*(x547));
IkReal x709=((IkReal(0.104208190000000))*(x561));
IkReal x710=((IkReal(0.0534000000000000))*(x594));
IkReal x711=((r11)*(x615));
IkReal x712=((IkReal(0.0534000000000000))*(x598));
IkReal x713=((r00)*(x596));
IkReal x714=((IkReal(0.106800000000000))*(x637));
IkReal x715=((IkReal(0.106800000000000))*(x601));
IkReal x716=((IkReal(0.104208190000000))*(x593));
IkReal x717=((IkReal(1.56900000000000))*(x541));
IkReal x718=((IkReal(0.104208190000000))*(x585));
IkReal x719=((IkReal(1.56900000000000))*(x542));
IkReal x720=((IkReal(0.0534000000000000))*(x576));
IkReal x721=((IkReal(0.0534000000000000))*(x582));
IkReal x722=((rxp1_1)*(x607));
IkReal x723=((rxp0_1)*(x604));
IkReal x724=((rxp1_0)*(x578));
IkReal x725=((rxp0_0)*(x640));
IkReal x726=((IkReal(1.56900000000000))*(gconst3_3)*(rxp0_0));
IkReal x727=((IkReal(0.104208190000000))*(x639));
IkReal x728=((IkReal(0.104208190000000))*(x629));
IkReal x729=((rxp1_0)*(x588));
IkReal x730=((IkReal(0.104208190000000))*(x649));
IkReal x731=((IkReal(0.104208190000000))*(x621));
IkReal x732=((IkReal(1.56900000000000))*(gconst6_3)*(rxp0_1));
IkReal x733=((rxp1_1)*(x614));
IkReal x734=((rxp1_1)*(x615));
IkReal x735=((rxp0_1)*(x648));
IkReal x736=((rxp0_0)*(x596));
IkReal x737=((IkReal(0.0534000000000000))*(x646));
IkReal x738=((IkReal(0.126567958658250))*(x557));
IkReal x739=((IkReal(0.126567958658250))*(x636));
IkReal x740=((IkReal(0.00505431000000000))*(x576));
IkReal x741=((IkReal(0.00505431000000000))*(x582));
IkReal x742=((IkReal(0.0101086200000000))*(x637));
IkReal x743=((IkReal(0.0101086200000000))*(x601));
IkReal x744=((IkReal(0.148505850000000))*(x541));
IkReal x745=((IkReal(0.00986330518350000))*(x585));
IkReal x746=((IkReal(0.00986330518350000))*(x593));
IkReal x747=((IkReal(0.148505850000000))*(x542));
IkReal x748=((IkReal(0.000337986158250000))*(x557));
IkReal x749=((IkReal(0.000337986158250000))*(x636));
IkReal x750=((IkReal(0.111023412500000))*(x556));
IkReal x751=((IkReal(0.0148280275000000))*(gconst4_4)*(r01));
IkReal x752=((IkReal(0.0257164050000000))*(x544));
IkReal x753=((IkReal(0.00349357361925000))*(x559));
IkReal x754=((IkReal(0.00362719500000000))*(x605));
IkReal x755=((IkReal(0.668610452500000))*(x548));
IkReal x756=((IkReal(0.641196607500000))*(x573));
IkReal x757=((IkReal(0.0871065591288750))*(x558));
IkReal x758=((IkReal(0.0257164050000000))*(x580));
IkReal x759=((IkReal(0.0871065591288750))*(x562));
IkReal x760=((IkReal(0.111023412500000))*(x619));
IkReal x761=((IkReal(0.0148280275000000))*(x642));
IkReal x762=((IkReal(0.00362719500000000))*(x626));
IkReal x763=((IkReal(0.641196607500000))*(x591));
IkReal x764=((IkReal(0.00349357361925000))*(x586));
IkReal x765=((IkReal(0.0908307299721250))*(x567));
IkReal x766=((IkReal(0.109150000000000))*(gconst1_4)*(npy));
IkReal x767=((IkReal(0.0908307299721250))*(x569));
IkReal x768=((IkReal(0.668610452500000))*(x584));
IkReal x769=((IkReal(0.109150000000000))*(gconst0_4)*(npx));
IkReal x770=((IkReal(0.0148280275000000))*(x632));
IkReal x771=((IkReal(0.0871065591288750))*(x618));
IkReal x772=((IkReal(0.00362719500000000))*(x625));
IkReal x773=((IkReal(0.817250000000000))*(x545));
IkReal x774=((IkReal(0.0267000000000000))*(x565));
IkReal x775=((IkReal(0.0267000000000000))*(x638));
IkReal x776=((IkReal(0.00362719500000000))*(x611));
IkReal x777=((IkReal(0.0148280275000000))*(x612));
IkReal x778=((IkReal(0.111023412500000))*(x613));
IkReal x779=((IkReal(0.0871065591288750))*(x572));
IkReal x780=((IkReal(0.00349357361925000))*(x602));
IkReal x781=((IkReal(0.0908307299721250))*(x547));
IkReal x782=((IkReal(0.111023412500000))*(x575));
IkReal x783=((IkReal(0.817250000000000))*(x581));
IkReal x784=((IkReal(0.00349357361925000))*(x570));
IkReal x785=((IkReal(0.0908307299721250))*(x561));
IkReal x786=((IkReal(0.00616623150000000))*(x586));
IkReal x787=((IkReal(0.0453900000000000))*(x544));
IkReal x788=((IkReal(0.0521040950000000))*(x571));
IkReal x789=((IkReal(0.00707834130575000))*(x546));
IkReal x790=((IkReal(0.00707834130575000))*(x553));
IkReal x791=((IkReal(0.0521040950000000))*(x595));
IkReal x792=((IkReal(0.00616623150000000))*(x559));
IkReal x793=((IkReal(0.0453900000000000))*(x580));
IkReal x794=((IkReal(0.00616623150000000))*(x570));
IkReal x795=((IkReal(0.00707834130575000))*(x568));
IkReal x796=((IkReal(0.00707834130575000))*(x549));
IkReal x797=((IkReal(0.00616623150000000))*(x602));
IkReal x798=((IkReal(0.000242553722125000))*(x561));
IkReal x799=((IkReal(0.00348161712112500))*(x618));
IkReal x800=((IkReal(0.000242553722125000))*(x547));
IkReal x801=((IkReal(0.00348161712112500))*(x572));
IkReal x802=((IkReal(0.00444908750000000))*(x619));
IkReal x803=((IkReal(0.00444908750000000))*(x556));
IkReal x804=((IkReal(0.00444908750000000))*(x575));
IkReal x805=((IkReal(0.00348161712112500))*(x562));
IkReal x806=((IkReal(0.00444908750000000))*(x613));
IkReal x807=((IkReal(0.0327500000000000))*(x581));
IkReal x808=((IkReal(0.0256283925000000))*(x591));
IkReal x809=((IkReal(0.000242553722125000))*(x567));
IkReal x810=((IkReal(0.000242553722125000))*(x569));
IkReal x811=((IkReal(0.0256283925000000))*(x573));
IkReal x812=((IkReal(0.00178545250000000))*(x584));
IkReal x813=((IkReal(0.00178545250000000))*(x548));
IkReal x814=((IkReal(0.00348161712112500))*(x558));
IkReal x815=((IkReal(0.0327500000000000))*(x545));
IkReal x816=((IkReal(0.109150000000000))*(gconst6_4)*(r00));
IkReal x817=((IkReal(0.668610452500000))*(x599));
IkReal x818=((IkReal(0.668610452500000))*(x540));
IkReal x819=((IkReal(0.668610452500000))*(x554));
IkReal x820=((IkReal(0.109150000000000))*(gconst4_4)*(r11));
IkReal x821=((IkReal(0.0257164050000000))*(x641));
IkReal x822=((IkReal(0.0257164050000000))*(x606));
IkReal x823=((IkReal(0.641196607500000))*(x608));
IkReal x824=((IkReal(0.641196607500000))*(x630));
IkReal x825=((IkReal(0.0257164050000000))*(x587));
IkReal x826=((IkReal(0.668610452500000))*(x583));
IkReal x827=((gconst7_1)*(x551));
IkReal x828=((gconst7_4)*(x635));
IkReal x829=((IkReal(0.641196607500000))*(x610));
IkReal x830=((IkReal(0.641196607500000))*(x592));
IkReal x831=((IkReal(0.109150000000000))*(gconst3_4)*(r10));
IkReal x832=((IkReal(0.817250000000000))*(x603));
IkReal x833=((IkReal(0.0267000000000000))*(gconst6_5)*(r00));
IkReal x834=((IkReal(0.817250000000000))*(x647));
IkReal x835=((r10)*(x590));
IkReal x836=((gconst4_3)*(x589));
IkReal x837=((IkReal(0.817250000000000))*(x600));
IkReal x838=((IkReal(0.0267000000000000))*(gconst4_5)*(r11));
IkReal x839=((IkReal(0.0267000000000000))*(gconst7_5)*(r01));
IkReal x840=((IkReal(0.0453900000000000))*(x641));
IkReal x841=((IkReal(0.0521040950000000))*(x597));
IkReal x842=((IkReal(0.0521040950000000))*(x555));
IkReal x843=((IkReal(0.0453900000000000))*(x631));
IkReal x844=((IkReal(0.0521040950000000))*(x550));
IkReal x845=((IkReal(0.0521040950000000))*(x543));
IkReal x846=((IkReal(0.0453900000000000))*(x587));
IkReal x847=((IkReal(0.0453900000000000))*(x606));
IkReal x848=((IkReal(0.0327500000000000))*(gconst4_3)*(r11));
IkReal x849=((IkReal(0.0256283925000000))*(x592));
IkReal x850=((IkReal(0.0256283925000000))*(x608));
IkReal x851=((IkReal(0.00178545250000000))*(x599));
IkReal x852=((IkReal(0.00178545250000000))*(x540));
IkReal x853=((IkReal(0.00178545250000000))*(x583));
IkReal x854=((IkReal(0.00178545250000000))*(x554));
IkReal x855=((IkReal(0.0327500000000000))*(x647));
IkReal x856=((IkReal(0.0327500000000000))*(x603));
IkReal x857=((IkReal(0.0256283925000000))*(x630));
IkReal x858=((IkReal(0.0256283925000000))*(x610));
IkReal x859=((IkReal(0.0327500000000000))*(x600));
IkReal x860=((IkReal(0.668610452500000))*(x561));
IkReal x861=((IkReal(0.668610452500000))*(x547));
IkReal x862=((pp)*(x562));
IkReal x863=((r00)*(x590));
IkReal x864=((IkReal(0.817250000000000))*(x575));
IkReal x865=((pp)*(x558));
IkReal x866=((IkReal(0.817250000000000))*(x613));
IkReal x867=((IkReal(0.0257164050000000))*(x570));
IkReal x868=((IkReal(0.109150000000000))*(x612));
IkReal x869=((IkReal(0.641196607500000))*(x618));
IkReal x870=((IkReal(0.0257164050000000))*(x602));
IkReal x871=((IkReal(0.0267000000000000))*(x625));
IkReal x872=((IkReal(0.641196607500000))*(x572));
IkReal x873=((IkReal(0.109150000000000))*(x632));
IkReal x874=((IkReal(0.0267000000000000))*(x605));
IkReal x875=((IkReal(0.668610452500000))*(x569));
IkReal x876=((gconst7_3)*(x589));
IkReal x877=((IkReal(0.817250000000000))*(x556));
IkReal x878=((gconst4_1)*(x551));
IkReal x879=((gconst4_4)*(x635));
IkReal x880=((IkReal(0.641196607500000))*(x562));
IkReal x881=((IkReal(0.0257164050000000))*(x586));
IkReal x882=((IkReal(0.641196607500000))*(x558));
IkReal x883=((IkReal(0.668610452500000))*(x567));
IkReal x884=((IkReal(0.109150000000000))*(x642));
IkReal x885=((IkReal(0.0267000000000000))*(x626));
IkReal x886=((x548)*(x566));
IkReal x887=((x551)*(x552));
IkReal x888=((x567)*(x574));
IkReal x889=((x566)*(x584));
IkReal x890=((x563)*(x572));
IkReal x891=((x563)*(x618));
IkReal x892=((x561)*(x574));
IkReal x893=((x547)*(x574));
IkReal x894=((x562)*(x563));
IkReal x895=((x573)*(x623));
IkReal x896=((x591)*(x623));
IkReal x897=((x558)*(x563));
IkReal x898=((x566)*(x599));
IkReal x899=((IkReal(0.189300000000000))*(r11)*(x552));
IkReal x900=((x566)*(x583));
IkReal x901=((x540)*(x566));
IkReal x902=((x623)*(x630));
IkReal x903=((x610)*(x623));
IkReal x904=((x592)*(x623));
IkReal x905=((x608)*(x623));
IkReal x906=((x547)*(x566));
IkReal x907=((x561)*(x566));
IkReal x908=((IkReal(0.189300000000000))*(r01)*(x552));
IkReal x909=((x566)*(x567));
IkReal x910=((x572)*(x623));
IkReal x911=((x618)*(x623));
IkReal x912=((x798)+(x800));
IkReal x913=((x754)+(x762));
IkReal x914=((x672)+(x673));
IkReal x915=((x700)+(x701));
IkReal x916=((x654)+(x655));
IkReal x917=((x720)+(x721));
IkReal x918=((x781)+(x785));
IkReal x919=((x747)+(x744));
IkReal x920=((x704)+(x705));
IkReal x921=((x718)+(x716));
IkReal x922=((x719)+(x717));
IkReal x923=((x737)+(x736));
IkReal x924=((x702)+(x703));
IkReal x925=((x724)+(x725));
IkReal x926=((x727)+(x728));
IkReal x927=((x733)+(x732));
IkReal x928=((x722)+(x723));
IkReal x929=((x726)+(x729));
IkReal x930=((x731)+(x730));
IkReal x931=((x711)+(x710));
IkReal x932=((x706)+(x707));
IkReal x933=((x715)+(x714));
IkReal x934=((x742)+(x743));
IkReal x935=((x746)+(x745));
IkReal x936=((x713)+(x712));
IkReal x937=((x656)+(x659));
IkReal x938=((x657)+(x658));
IkReal x939=((x698)+(x699));
IkReal x940=((x735)+(x734));
IkReal x941=((IkReal(4.00000000000000))+(x933));
IkReal x942=((((IkReal(0.181661459944250))*(x549)))+(x914)+(((IkReal(0.181661459944250))*(x568))));
IkReal x943=((((IkReal(0.000485107444250000))*(x549)))+(((IkReal(0.000485107444250000))*(x568)))+(x914));
IkReal x944=((((IkReal(1.33722090500000))*(x549)))+(((IkReal(1.33722090500000))*(x568)))+(x931));
IkReal x945=((((IkReal(1.33722090500000))*(x546)))+(x936)+(((IkReal(1.33722090500000))*(x553))));
IkReal x946=((((IkReal(0.00357090500000000))*(x553)))+(x936)+(((IkReal(0.00357090500000000))*(x546))));
IkReal x947=((((IkReal(0.00357090500000000))*(x568)))+(x931)+(((IkReal(0.00357090500000000))*(x549))));
IkReal x948=((((IkReal(1.33722090500000))*(x636)))+(x917)+(((IkReal(1.33722090500000))*(x557))));
IkReal x949=((((IkReal(0.00357090500000000))*(x636)))+(((IkReal(0.00357090500000000))*(x557)))+(x917));
IkReal x950=((((IkReal(1.33722090500000))*(x620)))+(((IkReal(1.33722090500000))*(x633)))+(x940));
IkReal x951=((((IkReal(1.33722090500000))*(x645)))+(((IkReal(1.33722090500000))*(x627)))+(x923));
IkReal x952=((((IkReal(0.00357090500000000))*(x627)))+(x923)+(((IkReal(0.00357090500000000))*(x645))));
IkReal x953=((((IkReal(0.00357090500000000))*(x620)))+(((IkReal(0.00357090500000000))*(x633)))+(x940));
IkReal x954=((x678)+(x679)+(x674)+(x675));
IkReal x955=((x772)+(x776)+(x775)+(x774));
IkReal x956=((x683)+(x682)+(x685)+(x684));
IkReal x957=((x799)+(x801)+(x803)+(x802));
IkReal x958=((x812)+(x813)+(x810)+(x809));
IkReal x959=((x650)+(x651)+(x652)+(x653));
IkReal x960=((x708)+(x709)+(x939));
IkReal x961=((x863)+(x861)+(x860)+(x871));
IkReal x962=((x687)+(x690)+(x692)+(x693));
IkReal x963=((x689)+(x688)+(x686)+(x691));
IkReal x964=((x739)+(x738)+(x740)+(x741));
IkReal x965=((x835)+(x833)+(x838)+(x839));
IkReal x966=((x874)+(x875)+(x885)+(x883));
IkReal x967=((x755)+(x768)+(x765)+(x767));
IkReal x968=((x740)+(x741)+(x748)+(x749));
IkReal x969=((x669)+(x668)+(x670)+(x671));
IkReal x970=((x795)+(x794)+(x797)+(x796));
IkReal x971=((x852)+(x853)+(x851)+(x854));
IkReal x972=((x661)+(x662)+(x665)+(x667));
IkReal x973=((x829)+(x823)+(x824)+(x830));
IkReal x974=((x660)+(x663)+(x664)+(x666));
IkReal x975=((x676)+(x677)+(x681)+(x680));
IkReal x976=((x818)+(x819)+(x817)+(x826));
IkReal x977=((IkReal(2.00000000000000))+(x954));
IkReal x978=((x757)+(x756)+(x750)+(x759)+(x760)+(x763));
IkReal x979=((x773)+(x771)+(x779)+(x778)+(x782)+(x783));
IkReal x980=((((IkReal(0.181661459944250))*(x553)))+(((IkReal(0.181661459944250))*(x546)))+(((IkReal(1.33722090500000))*(x595)))+(((IkReal(1.33722090500000))*(x571)))+(x969));
IkReal x981=((((IkReal(0.000485107444250000))*(x546)))+(((IkReal(0.000485107444250000))*(x553)))+(((IkReal(0.00357090500000000))*(x595)))+(x969)+(((IkReal(0.00357090500000000))*(x571))));
IkReal x982=((x814)+(x815)+(x811)+(x808)+(x805)+(x804)+(x807)+(x806));
IkReal x983=((x791)+(x790)+(x793)+(x792)+(x786)+(x787)+(x788)+(x789));
IkReal x984=((x694)+(x695)+(x696)+(x697)+(x954));
IkReal x985=((x841)+(x840)+(x843)+(x842)+(x845)+(x844)+(x847)+(x846));
IkReal x986=((x834)+(x836)+(x837)+(x832)+(x904)+(x905)+(x902)+(x903));
IkReal x987=((x770)+(x777)+(x780)+(x784)+(x896)+(x897)+(x894)+(x895)+(x892)+(x893));
IkReal x988=((x869)+(x868)+(x867)+(x866)+(x865)+(x864)+(x862)+(x870)+(x872)+(x873)+(x906)+(x907));
IkReal x989=((x878)+(x879)+(x876)+(x877)+(x884)+(x881)+(x880)+(x882)+(x911)+(x910)+(x908)+(x909));
IkReal x990=((x850)+(x856)+(x857)+(x855)+(x858)+(x859)+(x849)+(x848)+(x904)+(x905)+(x902)+(x903));
IkReal x991=((x898)+(x899)+(x816)+(x828)+(x822)+(x821)+(x820)+(x827)+(x825)+(x831)+(x900)+(x901));
IkReal x992=((IkReal(0.0946500000000000))+(x751)+(x753)+(x752)+(x758)+(x769)+(x764)+(x766)+(x761)+(x887)+(x886)+(x889)+(x888)+(x890)+(x891));
op[53]=((((IkReal(-1.00000000000000))*(x579)*(x628)))+(((IkReal(0.00243405773325000))*(gconst1_1)*(r21)))+(((x585)*(x644)))+(((IkReal(-0.00252715500000000))*(x637)))+(((IkReal(-1.00000000000000))*(x628)*(x634)))+(((IkReal(0.0103310475000000))*(gconst1_4)*(r21)))+(((IkReal(-0.00242572735012500))*(x634)))+(((IkReal(0.00243405773325000))*(gconst0_1)*(r20)))+(((x593)*(x644)))+(((IkReal(-0.00242572735012500))*(x579)))+(((IkReal(0.000168993079125000))*(x585)))+(pz)+(((IkReal(0.0103310475000000))*(gconst0_4)*(r20)))+(((IkReal(-0.00252715500000000))*(x601)))+(((IkReal(0.00309978750000000))*(x541)))+(((IkReal(0.00309978750000000))*(x542)))+(((IkReal(0.000168993079125000))*(x593))));
op[54]=((((IkReal(-1.00000000000000))*(x980)))+(x942));
op[55]=((((IkReal(-1.00000000000000))*(x916)))+(((IkReal(-0.362548151036500))*(x561)))+(((IkReal(0.362548151036500))*(x569)))+(((IkReal(0.362548151036500))*(x567)))+(((IkReal(-0.362548151036500))*(x547)))+(x959)+(((IkReal(2.66873869000000))*(x584)))+(((IkReal(2.66873869000000))*(x548))));
op[56]=((((IkReal(-1.00000000000000))*(x942)))+(x980));
op[57]=((((IkReal(-1.00000000000000))*(x916)))+(x938)+(x974)+(x959)+(((IkReal(-1.00000000000000))*(x972)))+(((IkReal(-1.00000000000000))*(x937))));
op[58]=((((IkReal(0.219822620000000))*(x571)))+(((IkReal(0.0298629029270000))*(x553)))+(((IkReal(-0.0290175600000000))*(x617)))+(((IkReal(-0.0298629029270000))*(x568)))+(((IkReal(0.0298629029270000))*(x546)))+(((IkReal(0.213600000000000))*(x616)))+(((IkReal(-0.0298629029270000))*(x549)))+(((IkReal(0.213600000000000))*(x564)))+(((IkReal(-0.0290175600000000))*(x594)))+(((IkReal(0.0290175600000000))*(x609)))+(((IkReal(0.219822620000000))*(x595)))+(((IkReal(0.0290175600000000))*(x598))));
op[59]=((((IkReal(-1.00000000000000))*(x959)))+(x938)+(x937)+(x916)+(((IkReal(-1.00000000000000))*(x974)))+(((IkReal(-1.00000000000000))*(x972))));
op[60]=((((IkReal(-1.00000000000000))*(x943)))+(x981));
op[61]=((((IkReal(-0.00143869000000000))*(x548)))+(((IkReal(0.000195446036500000))*(x547)))+(((IkReal(-0.000195446036500000))*(x567)))+(((IkReal(-0.000195446036500000))*(x569)))+(((IkReal(0.000195446036500000))*(x561)))+(((IkReal(-0.00143869000000000))*(x584)))+(((IkReal(-1.00000000000000))*(x959)))+(x916));
op[62]=((((IkReal(-1.00000000000000))*(x981)))+(x943));
op[63]=((IkReal(-2.00000000000000))+(((IkReal(-1.00000000000000))*(x954)))+(((IkReal(-1.00000000000000))*(x975))));
op[64]=((((IkReal(2.66873869000000))*(x599)))+(x956)+(((IkReal(2.66873869000000))*(x583)))+(((IkReal(2.66873869000000))*(x540)))+(((IkReal(2.66873869000000))*(x554))));
op[65]=((x975)+(x977));
op[66]=((x963)+(x956)+(((IkReal(-1.00000000000000))*(x962))));
op[67]=((IkReal(8.00000000000000))+(((IkReal(0.219822620000000))*(x543)))+(((r00)*(x577)))+(((IkReal(0.213600000000000))*(x622)))+(((IkReal(0.219822620000000))*(x550)))+(((IkReal(0.219822620000000))*(x555)))+(((r10)*(x624)))+(((IkReal(0.219822620000000))*(x597)))+(((r01)*(x643))));
op[68]=((((IkReal(-1.00000000000000))*(x956)))+(((IkReal(-1.00000000000000))*(x962)))+(((IkReal(-1.00000000000000))*(x963))));
op[69]=((x694)+(x695)+(x696)+(x697)+(x977));
op[70]=((((IkReal(-0.00143869000000000))*(x540)))+(((IkReal(-0.00143869000000000))*(x599)))+(((IkReal(-0.00143869000000000))*(x583)))+(((IkReal(-1.00000000000000))*(x956)))+(((IkReal(-0.00143869000000000))*(x554))));
op[71]=((IkReal(-2.00000000000000))+(((IkReal(-1.00000000000000))*(x984))));
op[72]=((((IkReal(-1.00000000000000))*(x944)))+(x945));
op[73]=((((IkReal(-2.66873869000000))*(x567)))+(((IkReal(-2.66873869000000))*(x569)))+(((IkReal(-1.00000000000000))*(x915)))+(((r11)*(x560)))+(x939)+(((IkReal(2.66873869000000))*(x547))));
op[74]=((((IkReal(-1.00000000000000))*(x945)))+(x944));
op[75]=((((IkReal(-1.00000000000000))*(x924)))+(((IkReal(-1.00000000000000))*(x915)))+(x920)+(x960)+(((IkReal(-1.00000000000000))*(x932))));
op[76]=((((IkReal(0.219822620000000))*(x549)))+(((IkReal(-0.219822620000000))*(x546)))+(((IkReal(0.213600000000000))*(x617)))+(((IkReal(-0.213600000000000))*(x598)))+(((IkReal(-0.219822620000000))*(x553)))+(((IkReal(-0.213600000000000))*(x609)))+(((r10)*(x577)))+(((IkReal(0.219822620000000))*(x568))));
op[77]=((x924)+(x920)+(x915)+(((IkReal(-1.00000000000000))*(x960)))+(((IkReal(-1.00000000000000))*(x932))));
op[78]=((((IkReal(-1.00000000000000))*(x946)))+(x947));
op[79]=((((IkReal(-0.00143869000000000))*(x547)))+(((IkReal(0.00143869000000000))*(x569)))+(((IkReal(0.00143869000000000))*(x567)))+(((IkReal(-0.00143869000000000))*(x561)))+(x915)+(((IkReal(-1.00000000000000))*(x939))));
op[80]=((((IkReal(-1.00000000000000))*(x947)))+(x946));
op[81]=x948;
op[82]=((IkReal(-4.00000000000000))+(((IkReal(-2.66873869000000))*(x593)))+(((IkReal(-2.66873869000000))*(x585)))+(((IkReal(-1.00000000000000))*(x933))));
op[83]=((IkReal(-1.00000000000000))*(x948));
op[84]=((IkReal(-4.00000000000000))+(((IkReal(-1.00000000000000))*(x921)))+(x922)+(((IkReal(-1.00000000000000))*(x933))));
op[85]=((((IkReal(-0.213600000000000))*(x582)))+(((IkReal(-0.213600000000000))*(x576)))+(((IkReal(-0.219822620000000))*(x557)))+(((IkReal(-0.219822620000000))*(x636))));
op[86]=((x922)+(x921)+(x941));
op[87]=((IkReal(-1.00000000000000))*(x949));
op[88]=((((IkReal(0.00143869000000000))*(x585)))+(((IkReal(0.00143869000000000))*(x593)))+(x941));
op[89]=x949;
op[90]=((((IkReal(-1.00000000000000))*(x950)))+(x951));
op[91]=((((IkReal(-1.00000000000000))*(x925)))+(((IkReal(2.66873869000000))*(x621)))+(((rxp1_1)*(x560)))+(((IkReal(-2.66873869000000))*(x629)))+(((IkReal(-2.66873869000000))*(x639)))+(x928));
op[92]=((((IkReal(-1.00000000000000))*(x951)))+(x950));
op[93]=((((IkReal(-1.00000000000000))*(x927)))+(((IkReal(-1.00000000000000))*(x926)))+(((IkReal(-1.00000000000000))*(x925)))+(x930)+(x928)+(x929));
op[94]=((((IkReal(-0.213600000000000))*(x646)))+(((rxp1_1)*(x643)))+(((IkReal(0.219822620000000))*(x620)))+(((IkReal(-1.00000000000000))*(rxp0_0)*(x624)))+(((IkReal(0.219822620000000))*(x633)))+(((IkReal(-0.219822620000000))*(x627)))+(((rxp0_1)*(x577)))+(((IkReal(-0.219822620000000))*(x645))));
op[95]=((((IkReal(-1.00000000000000))*(x927)))+(((IkReal(-1.00000000000000))*(x928)))+(x929)+(x926)+(x925)+(((IkReal(-1.00000000000000))*(x930))));
op[96]=((((IkReal(-1.00000000000000))*(x952)))+(x953));
op[97]=((((IkReal(-1.00000000000000))*(x928)))+(((IkReal(0.00143869000000000))*(x629)))+(((IkReal(0.00143869000000000))*(x639)))+(((IkReal(-0.00143869000000000))*(x621)))+(((IkReal(-0.00143869000000000))*(x649)))+(x925));
op[98]=((((IkReal(-1.00000000000000))*(x953)))+(x952));
op[99]=((IkReal(1.63450000000000))+(((IkReal(-1.00000000000000))*(x964))));
op[100]=((((IkReal(0.252596117008500))*(x593)))+(x934)+(((IkReal(0.252596117008500))*(x585))));
op[101]=((IkReal(1.63450000000000))+(x964));
op[102]=((((IkReal(-1.00000000000000))*(x919)))+(x935)+(x934));
op[103]=((((IkReal(0.0202172400000000))*(x576)))+(((IkReal(0.0208062109830000))*(x636)))+(((IkReal(0.0208062109830000))*(x557)))+(((IkReal(0.0202172400000000))*(x582))));
op[104]=((((IkReal(-1.00000000000000))*(x919)))+(((IkReal(-1.00000000000000))*(x934)))+(((IkReal(-1.00000000000000))*(x935))));
op[105]=((IkReal(0.0655000000000000))+(x968));
op[106]=((((IkReal(-0.000136172008500000))*(x585)))+(((IkReal(-0.000136172008500000))*(x593)))+(((IkReal(-1.00000000000000))*(x934))));
op[107]=((IkReal(0.0655000000000000))+(((IkReal(-1.00000000000000))*(x968))));
op[108]=((((IkReal(-1.00000000000000))*(x987)))+(((IkReal(-1.00000000000000))*(x913)))+(x918)+(x992)+(x978)+(x955)+(((IkReal(-1.00000000000000))*(x967)))+(((IkReal(-1.00000000000000))*(x979))));
op[109]=((IkReal(-1.63450000000000))+(((IkReal(-1.33436934500000))*(x571)))+(((IkReal(-0.0872823000000000))*(x544)))+(((IkReal(-0.181274075518250))*(x546)))+(((IkReal(0.0118573004550000))*(x602)))+(((IkReal(0.181274075518250))*(x568)))+(((IkReal(-1.00000000000000))*(x914)))+(((IkReal(-0.0872823000000000))*(x580)))+(((IkReal(-0.0118573004550000))*(x586)))+(((IkReal(-1.33436934500000))*(x595)))+(((IkReal(-0.0118573004550000))*(x559)))+(((IkReal(0.0118573004550000))*(x570)))+(x969)+(((IkReal(0.181274075518250))*(x549)))+(((IkReal(-0.181274075518250))*(x553))));
op[110]=((((IkReal(-1.00000000000000))*(x987)))+(((IkReal(-1.00000000000000))*(x918)))+(((IkReal(-1.00000000000000))*(x955)))+(x913)+(x992)+(x978)+(x967)+(((IkReal(-1.00000000000000))*(x979))));
op[111]=((IkReal(-0.850000000000000))+(((IkReal(-1.00000000000000))*(x983)))+(((IkReal(-1.00000000000000))*(x914)))+(x970)+(x969));
op[112]=((((IkReal(-0.0149314514635000))*(x561)))+(((IkReal(0.0149314514635000))*(x567)))+(((IkReal(0.0149314514635000))*(x569)))+(((IkReal(0.109911310000000))*(x584)))+(((IkReal(-1.00000000000000))*(x959)))+(x916)+(((IkReal(0.109911310000000))*(x548)))+(((IkReal(-0.0149314514635000))*(x547))));
op[113]=((IkReal(0.850000000000000))+(x914)+(x983)+(((IkReal(-1.00000000000000))*(x969)))+(((IkReal(-1.00000000000000))*(x970))));
op[114]=((((IkReal(-1.00000000000000))*(x982)))+(((IkReal(-1.00000000000000))*(x987)))+(((IkReal(-1.00000000000000))*(x912)))+(((IkReal(-1.00000000000000))*(x955)))+(x913)+(x992)+(x958)+(x957));
op[115]=((IkReal(0.0655000000000000))+(((IkReal(0.000475162545000000))*(x586)))+(((IkReal(-9.77230182500000e-5))*(x568)))+(((IkReal(0.000719345000000000))*(x595)))+(((IkReal(9.77230182500000e-5))*(x553)))+(((IkReal(0.000719345000000000))*(x571)))+(((IkReal(0.00349770000000000))*(x580)))+(((IkReal(9.77230182500000e-5))*(x546)))+(((IkReal(0.00349770000000000))*(x544)))+(((IkReal(-9.77230182500000e-5))*(x549)))+(((IkReal(-0.000475162545000000))*(x602)))+(((IkReal(0.000475162545000000))*(x559)))+(x914)+(((IkReal(-1.00000000000000))*(x969)))+(((IkReal(-0.000475162545000000))*(x570))));
op[116]=((((IkReal(-1.00000000000000))*(x982)))+(((IkReal(-1.00000000000000))*(x987)))+(((IkReal(-1.00000000000000))*(x913)))+(((IkReal(-1.00000000000000))*(x958)))+(x912)+(x992)+(x957)+(x955));
op[117]=((((IkReal(-1.00000000000000))*(x986)))+(x991)+(x973)+(x965)+(((IkReal(-1.00000000000000))*(x976))));
op[118]=((((IkReal(-1.33436934500000))*(x550)))+(((IkReal(-1.33436934500000))*(x555)))+(((IkReal(-1.33436934500000))*(x543)))+(((IkReal(-0.0872823000000000))*(x587)))+(((IkReal(-1.33436934500000))*(x597)))+(((IkReal(-0.0872823000000000))*(x606)))+(((IkReal(-0.0872823000000000))*(x641)))+(x977)+(((IkReal(-0.0872823000000000))*(x631))));
op[119]=((((IkReal(-1.00000000000000))*(x986)))+(x991)+(x973)+(x976)+(((IkReal(-1.00000000000000))*(x965))));
op[120]=((((IkReal(-1.00000000000000))*(x985)))+(x977));
op[121]=((((IkReal(0.109911310000000))*(x599)))+(((IkReal(0.109911310000000))*(x583)))+(((IkReal(0.109911310000000))*(x554)))+(((IkReal(-1.00000000000000))*(x956)))+(((IkReal(0.109911310000000))*(x540))));
op[122]=((IkReal(-2.00000000000000))+(((IkReal(-1.00000000000000))*(x954)))+(x985));
op[123]=((((IkReal(-1.00000000000000))*(x990)))+(x991)+(x971)+(((IkReal(-1.00000000000000))*(x965))));
op[124]=((IkReal(-2.00000000000000))+(((IkReal(0.00349770000000000))*(x631)))+(((IkReal(0.000719345000000000))*(x543)))+(((IkReal(0.000719345000000000))*(x597)))+(((IkReal(0.000719345000000000))*(x555)))+(((IkReal(0.000719345000000000))*(x550)))+(((IkReal(0.00349770000000000))*(x587)))+(((IkReal(0.00349770000000000))*(x641)))+(((IkReal(0.00349770000000000))*(x606)))+(((IkReal(-1.00000000000000))*(x954))));
op[125]=((((IkReal(-1.00000000000000))*(x990)))+(x991)+(x965)+(((IkReal(-1.00000000000000))*(x971))));
op[126]=((((IkReal(-1.00000000000000))*(x989)))+(x988)+(x966)+(((IkReal(-1.00000000000000))*(x961))));
op[127]=((((IkReal(-1.33436934500000))*(x549)))+(((IkReal(1.33436934500000))*(x546)))+(((IkReal(0.0872823000000000))*(x559)))+(((IkReal(0.0872823000000000))*(x586)))+(((IkReal(-1.33436934500000))*(x568)))+(((IkReal(-0.0872823000000000))*(x602)))+(x931)+(((IkReal(-0.0872823000000000))*(x570)))+(((IkReal(1.33436934500000))*(x553)))+(((IkReal(-1.00000000000000))*(x936))));
op[128]=((((IkReal(-1.00000000000000))*(x989)))+(x988)+(x961)+(((IkReal(-1.00000000000000))*(x966))));
op[129]=((((IkReal(-0.0453900000000000))*(x570)))+(((IkReal(0.0521040950000000))*(x546)))+(((IkReal(-0.0521040950000000))*(x568)))+(((IkReal(-0.0453900000000000))*(x602)))+(((IkReal(0.0453900000000000))*(x559)))+(((IkReal(0.0453900000000000))*(x586)))+(x931)+(((IkReal(0.0521040950000000))*(x553)))+(((IkReal(-0.0521040950000000))*(x549)))+(((IkReal(-1.00000000000000))*(x936))));
IkReal x993=((gconst7_7)*(rxp1_1));
IkReal x994=((IkReal(0.106800000000000))*(gconst7_5));
IkReal x995=((gconst0_3)*(r20));
IkReal x996=((gconst6_2)*(r10));
IkReal x997=((IkReal(1.00000000000000))*(pp));
IkReal x998=((gconst4_0)*(r01));
IkReal x999=((gconst1_2)*(r21));
IkReal x1000=((IkReal(0.0946500000000000))*(pp));
IkReal x1001=((gconst1_4)*(r21));
IkReal x1002=((gconst0_2)*(r20));
IkReal x1003=((gconst0_1)*(r20));
IkReal x1004=((IkReal(0.189300000000000))*(pz));
IkReal x1005=((gconst3_7)*(rxp0_0));
IkReal x1006=((gconst3_1)*(r00));
IkReal x1007=((gconst1_3)*(r21));
IkReal x1008=((gconst1_1)*(r21));
IkReal x1009=((gconst3_1)*(rxp0_0));
IkReal x1010=((gconst6_3)*(rxp0_1));
IkReal x1011=((gconst6_1)*(r10));
IkReal x1012=((IkReal(0.0267000000000000))*(gconst6_5));
IkReal x1013=((gconst3_2)*(r00));
IkReal x1014=((gconst4_0)*(rxp1_0));
IkReal x1015=((gconst0_5)*(r20));
IkReal x1016=((gconst1_5)*(r21));
IkReal x1017=((gconst7_2)*(rxp1_1));
IkReal x1018=((IkReal(0.0257164050000000))*(gconst7_1));
IkReal x1019=((gconst4_2)*(rxp1_0));
IkReal x1020=((gconst1_0)*(r21));
IkReal x1021=((gconst0_0)*(r20));
IkReal x1022=((gconst4_7)*(rxp1_0));
IkReal x1023=((gconst6_7)*(r10));
IkReal x1024=((gconst0_7)*(r20));
IkReal x1025=((gconst6_1)*(rxp0_1));
IkReal x1026=((IkReal(0.0534000000000000))*(gconst6_6));
IkReal x1027=((gconst3_7)*(r00));
IkReal x1028=((gconst4_1)*(rxp1_0));
IkReal x1029=((gconst1_7)*(r21));
IkReal x1030=((gconst7_0)*(rxp1_1));
IkReal x1031=((gconst7_0)*(r11));
IkReal x1032=((gconst7_3)*(rxp1_1));
IkReal x1033=((IkReal(0.0534000000000000))*(gconst3_6));
IkReal x1034=((IkReal(0.106800000000000))*(gconst6_5));
IkReal x1035=((IkReal(0.109150000000000))*(gconst3_4));
IkReal x1036=((gconst3_2)*(rxp0_0));
IkReal x1037=((gconst0_6)*(r20));
IkReal x1038=((gconst7_1)*(r11));
IkReal x1039=((IkReal(0.0327500000000000))*(gconst4_3));
IkReal x1040=((gconst6_7)*(rxp0_1));
IkReal x1041=((IkReal(0.0521040950000000))*(gconst6_0));
IkReal x1042=((IkReal(0.109150000000000))*(gconst7_4));
IkReal x1043=((gconst7_7)*(r11));
IkReal x1044=((IkReal(0.0534000000000000))*(gconst7_6));
IkReal x1045=((gconst4_5)*(r01));
IkReal x1046=((IkReal(0.0534000000000000))*(gconst4_6));
IkReal x1047=((gconst4_7)*(r01));
IkReal x1048=((gconst3_0)*(rxp0_0));
IkReal x1049=((gconst4_5)*(rxp1_0));
IkReal x1050=((gconst3_0)*(r00));
IkReal x1051=((IkReal(0.106800000000000))*(gconst3_5));
IkReal x1052=((gconst1_6)*(r21));
IkReal x1053=((gconst6_2)*(rxp0_1));
IkReal x1054=((IkReal(0.0179172450000000))*(pz));
IkReal x1055=((gconst3_3)*(rxp0_0));
IkReal x1056=((IkReal(0.0267000000000000))*(gconst7_5));
IkReal x1057=((IkReal(0.109150000000000))*(gconst6_4));
IkReal x1058=((gconst6_0)*(rxp0_1));
IkReal x1059=((IkReal(0.109150000000000))*(gconst4_4));
IkReal x1060=((gconst4_1)*(r01));
IkReal x1061=((gconst7_1)*(rxp1_1));
IkReal x1062=((gconst7_2)*(r11));
IkReal x1063=((gconst4_2)*(r01));
IkReal x1064=((IkReal(0.0267000000000000))*(gconst3_5));
IkReal x1065=((gconst0_4)*(r20));
IkReal x1066=((r01)*(x1046));
IkReal x1067=((r00)*(x1033));
IkReal x1068=((r10)*(x1026));
IkReal x1069=((r11)*(x1044));
IkReal x1070=((r10)*(x1012));
IkReal x1071=((r01)*(x1039));
IkReal x1072=((IkReal(0.0256283925000000))*(x1013));
IkReal x1073=((IkReal(0.00178545250000000))*(x1047));
IkReal x1074=((pp)*(x1063));
IkReal x1075=((IkReal(0.00178545250000000))*(x1027));
IkReal x1076=((pp)*(x1013));
IkReal x1077=((IkReal(0.0257164050000000))*(x1011));
IkReal x1078=((r11)*(x1042));
IkReal x1079=((IkReal(0.0256283925000000))*(x1063));
IkReal x1080=((r11)*(x1018));
IkReal x1081=((IkReal(0.0327500000000000))*(gconst3_3)*(r00));
IkReal x1082=((r11)*(x1056));
IkReal x1083=((r10)*(x1057));
IkReal x1084=((IkReal(0.0256283925000000))*(x1062));
IkReal x1085=((IkReal(0.00178545250000000))*(x1023));
IkReal x1086=((IkReal(0.00178545250000000))*(x1043));
IkReal x1087=((IkReal(0.0257164050000000))*(x1060));
IkReal x1088=((r00)*(x1064));
IkReal x1089=((r01)*(x1059));
IkReal x1090=((IkReal(0.0327500000000000))*(gconst7_3)*(r11));
IkReal x1091=((IkReal(0.0257164050000000))*(x1006));
IkReal x1092=((IkReal(0.0327500000000000))*(gconst6_3)*(r10));
IkReal x1093=((IkReal(0.0267000000000000))*(x1045));
IkReal x1094=((IkReal(0.0256283925000000))*(x996));
IkReal x1095=((r00)*(x1035));
IkReal x1096=((pp)*(x1002));
IkReal x1097=((IkReal(0.0267000000000000))*(x1015));
IkReal x1098=((IkReal(0.817250000000000))*(x1007));
IkReal x1099=((IkReal(0.817250000000000))*(x995));
IkReal x1100=((pp)*(x999));
IkReal x1101=((IkReal(0.0267000000000000))*(x1016));
IkReal x1102=((IkReal(0.668610452500000))*(x1024));
IkReal x1103=((IkReal(0.109150000000000))*(x1065));
IkReal x1104=((IkReal(0.0257164050000000))*(x1008));
IkReal x1105=((IkReal(0.641196607500000))*(x999));
IkReal x1106=((IkReal(0.641196607500000))*(x1002));
IkReal x1107=((IkReal(0.0257164050000000))*(x1003));
IkReal x1108=((IkReal(0.109150000000000))*(x1001));
IkReal x1109=((IkReal(0.668610452500000))*(x1029));
IkReal x1110=((IkReal(0.00178545250000000))*(x1024));
IkReal x1111=((IkReal(0.0327500000000000))*(x995));
IkReal x1112=((IkReal(0.0327500000000000))*(x1007));
IkReal x1113=((IkReal(0.0256283925000000))*(x1002));
IkReal x1114=((IkReal(0.00178545250000000))*(x1029));
IkReal x1115=((IkReal(0.0256283925000000))*(x999));
IkReal x1116=((rxp0_1)*(x1057));
IkReal x1117=((IkReal(0.641196607500000))*(x1017));
IkReal x1118=((IkReal(0.0267000000000000))*(x1049));
IkReal x1119=((rxp0_0)*(x1064));
IkReal x1120=((IkReal(0.668610452500000))*(x993));
IkReal x1121=((pp)*(x1019));
IkReal x1122=((IkReal(0.0257164050000000))*(x1025));
IkReal x1123=((IkReal(0.817250000000000))*(x1055));
IkReal x1124=((rxp1_1)*(x1042));
IkReal x1125=((pp)*(x1036));
IkReal x1126=((rxp1_1)*(x1018));
IkReal x1127=((IkReal(0.641196607500000))*(x1053));
IkReal x1128=((IkReal(0.817250000000000))*(gconst4_3)*(rxp1_0));
IkReal x1129=((IkReal(0.668610452500000))*(x1040));
IkReal x1130=((IkReal(0.668610452500000))*(x1022));
IkReal x1131=((rxp0_0)*(x1035));
IkReal x1132=((IkReal(0.641196607500000))*(x1036));
IkReal x1133=((rxp0_1)*(x1012));
IkReal x1134=((IkReal(0.817250000000000))*(x1010));
IkReal x1135=((rxp1_1)*(x1056));
IkReal x1136=((IkReal(0.0257164050000000))*(x1028));
IkReal x1137=((IkReal(0.817250000000000))*(x1032));
IkReal x1138=((IkReal(0.0257164050000000))*(x1009));
IkReal x1139=((IkReal(0.668610452500000))*(x1005));
IkReal x1140=((rxp1_0)*(x1059));
IkReal x1141=((IkReal(0.641196607500000))*(x1019));
IkReal x1142=((rxp1_1)*(x1044));
IkReal x1143=((rxp0_1)*(x1026));
IkReal x1144=((rxp0_0)*(x1033));
IkReal x1145=((rxp1_0)*(x1046));
IkReal x1146=((IkReal(0.0327500000000000))*(x1055));
IkReal x1147=((IkReal(0.00178545250000000))*(x1022));
IkReal x1148=((IkReal(0.0256283925000000))*(x1019));
IkReal x1149=((IkReal(0.00178545250000000))*(x1005));
IkReal x1150=((rxp1_0)*(x1039));
IkReal x1151=((IkReal(0.0256283925000000))*(x1036));
IkReal x1152=((IkReal(0.00178545250000000))*(x993));
IkReal x1153=((IkReal(0.0256283925000000))*(x1053));
IkReal x1154=((IkReal(0.0327500000000000))*(x1032));
IkReal x1155=((IkReal(0.0256283925000000))*(x1017));
IkReal x1156=((IkReal(0.0327500000000000))*(x1010));
IkReal x1157=((IkReal(0.00178545250000000))*(x1040));
IkReal x1158=((IkReal(0.00243405773325000))*(x1008));
IkReal x1159=((IkReal(0.0632839793291250))*(x1029));
IkReal x1160=((IkReal(0.0103310475000000))*(x1001));
IkReal x1161=((IkReal(0.0606892588998750))*(x999));
IkReal x1162=((IkReal(0.00243405773325000))*(x1003));
IkReal x1163=((IkReal(0.0632839793291250))*(x1024));
IkReal x1164=((IkReal(0.0606892588998750))*(x1002));
IkReal x1165=((IkReal(0.0103310475000000))*(x1065));
IkReal x1166=((IkReal(0.00252715500000000))*(x1016));
IkReal x1167=((IkReal(0.0773527125000000))*(x1007));
IkReal x1168=((IkReal(0.00252715500000000))*(x1015));
IkReal x1169=((IkReal(0.0773527125000000))*(x995));
IkReal x1170=((IkReal(0.00505431000000000))*(x1037));
IkReal x1171=((IkReal(0.00505431000000000))*(x1052));
IkReal x1172=((IkReal(0.00493165259175000))*(x1020));
IkReal x1173=((IkReal(0.00429616350000000))*(x1003));
IkReal x1174=((IkReal(0.00429616350000000))*(x1008));
IkReal x1175=((IkReal(0.00493165259175000))*(x1021));
IkReal x1176=((IkReal(0.00309978750000000))*(x1007));
IkReal x1177=((IkReal(0.00242572735012500))*(x1002));
IkReal x1178=((IkReal(0.000168993079125000))*(x1024));
IkReal x1179=((IkReal(0.000168993079125000))*(x1029));
IkReal x1180=((IkReal(0.00242572735012500))*(x999));
IkReal x1181=((IkReal(0.00309978750000000))*(x995));
IkReal x1182=((x1004)*(x1023));
IkReal x1183=((x1004)*(x1043));
IkReal x1184=((x1004)*(x1047));
IkReal x1185=((x1004)*(x1027));
IkReal x1186=((x996)*(x997));
IkReal x1187=((x1062)*(x997));
IkReal x1188=((x1004)*(x1024));
IkReal x1189=((x1004)*(x1029));
IkReal x1190=((x1004)*(x993));
IkReal x1191=((x1004)*(x1040));
IkReal x1192=((x1017)*(x997));
IkReal x1193=((x1053)*(x997));
IkReal x1194=((x1004)*(x1022));
IkReal x1195=((x1004)*(x1005));
IkReal x1196=((x1024)*(x1054));
IkReal x1197=((x1029)*(x1054));
IkReal x1198=((x1000)*(x999));
IkReal x1199=((x1000)*(x1002));
IkReal x1200=((((IkReal(0.0534000000000000))*(x1037)))+(((IkReal(0.0534000000000000))*(x1052))));
IkReal x1201=((x1171)+(x1170));
IkReal x1202=((x1067)+(x1066));
IkReal x1203=((x1142)+(x1143));
IkReal x1204=((x1164)+(x1161));
IkReal x1205=((x1102)+(x1109));
IkReal x1206=((x1101)+(x1097));
IkReal x1207=((x1179)+(x1178));
IkReal x1208=((x1100)+(x1096));
IkReal x1209=((x1098)+(x1099));
IkReal x1210=((x1167)+(x1169));
IkReal x1211=((x1069)+(x1068));
IkReal x1212=((x1159)+(x1163));
IkReal x1213=((x1144)+(x1145));
IkReal x1214=((x1110)+(x1114));
IkReal x1215=((x1199)+(x1198));
IkReal x1216=((((IkReal(0.0521040950000000))*(x1020)))+(((IkReal(0.0521040950000000))*(x1021)))+(((IkReal(0.0453900000000000))*(x1003)))+(((IkReal(0.0453900000000000))*(x1008))));
IkReal x1217=((x1139)+(x1133)+(x1130)+(x1135));
IkReal x1218=((x1117)+(x1128)+(x1123)+(x1127));
IkReal x1219=((x1075)+(x1073)+(x1070)+(x1082));
IkReal x1220=((x1141)+(x1132)+(x1137)+(x1134));
IkReal x1221=((x1147)+(x1149)+(x1133)+(x1135));
IkReal x1222=((x1155)+(x1154)+(x1156)+(x1153));
IkReal x1223=((x1146)+(x1148)+(x1151)+(x1150));
IkReal x1224=((x1119)+(x1118)+(x1157)+(x1152));
IkReal x1225=((x1180)+(x1181)+(x1177)+(x1176));
IkReal x1226=((x1093)+(x1086)+(x1085)+(x1088));
IkReal x1227=((x1111)+(x1113)+(x1112)+(x1115));
IkReal x1228=((x1175)+(x1174)+(x1173)+(x1172));
IkReal x1229=((x1119)+(x1118)+(x1129)+(x1120));
IkReal x1230=((x1166)+(x1168)+(x1215));
IkReal x1231=((x1213)+(((IkReal(0.0453900000000000))*(x1025)))+(((IkReal(0.0521040950000000))*(x1030)))+(((IkReal(0.0453900000000000))*(x1061)))+(((rxp0_1)*(x1041))));
IkReal x1232=((x1203)+(((IkReal(0.0453900000000000))*(x1028)))+(((IkReal(0.0521040950000000))*(x1014)))+(((IkReal(0.0453900000000000))*(x1009)))+(((IkReal(0.0521040950000000))*(x1048))));
IkReal x1233=((x1107)+(x1104)+(x1103)+(x1108)+(x1188)+(x1189));
IkReal x1234=((x1158)+(x1197)+(x1196)+(x1165)+(x1160)+(x1162)+(pz));
IkReal x1235=((x1116)+(x1121)+(x1122)+(x1124)+(x1125)+(x1126)+(x1191)+(x1190));
IkReal x1236=((x1106)+(x1105)+(x1233));
IkReal x1237=((x1166)+(x1168)+(x1234));
IkReal x1238=((x1140)+(x1138)+(x1131)+(x1136)+(x1193)+(x1192)+(x1195)+(x1194));
IkReal x1239=((x1182)+(x1183)+(x1078)+(x1079)+(x1076)+(x1077)+(x1074)+(x1072)+(x1071)+(x1083)+(x1081)+(x1080));
IkReal x1240=((x1186)+(x1187)+(x1184)+(x1185)+(x1094)+(x1095)+(x1090)+(x1091)+(x1092)+(x1087)+(x1084)+(x1089));
op[130]=((((IkReal(-1.00000000000000))*(r10)*(x1034)))+(((IkReal(0.109911310000000))*(x1023)))+(((IkReal(0.106800000000000))*(x1045)))+(((IkReal(-1.00000000000000))*(r11)*(x994)))+(((r00)*(x1051)))+(((IkReal(0.109911310000000))*(x1043)))+(((IkReal(-0.109911310000000))*(x1047)))+(((IkReal(-0.109911310000000))*(x1027))));
op[131]=((((IkReal(-0.0521040950000000))*(x1050)))+(x1202)+(((IkReal(-0.0521040950000000))*(x998)))+(((IkReal(-0.0453900000000000))*(x1006)))+(((IkReal(-0.0453900000000000))*(x1060)))+(((r10)*(x1041)))+(((IkReal(0.0453900000000000))*(x1038)))+(((IkReal(0.0453900000000000))*(x1011)))+(((IkReal(-1.00000000000000))*(x1211)))+(((IkReal(0.0521040950000000))*(x1031))));
op[132]=((x1239)+(x1226)+(((IkReal(-1.00000000000000))*(x1240)))+(((IkReal(-1.00000000000000))*(x1219))));
op[133]=((((IkReal(0.00349770000000000))*(x1038)))+(x1202)+(((IkReal(-0.000719345000000000))*(x998)))+(((IkReal(-0.000719345000000000))*(x1050)))+(((IkReal(0.00349770000000000))*(x1011)))+(((IkReal(0.000719345000000000))*(x1031)))+(((IkReal(-0.00349770000000000))*(x1006)))+(((IkReal(0.000719345000000000))*(gconst6_0)*(r10)))+(((IkReal(-1.00000000000000))*(x1211)))+(((IkReal(-0.00349770000000000))*(x1060))));
op[134]=((x1239)+(x1219)+(((IkReal(-1.00000000000000))*(x1226)))+(((IkReal(-1.00000000000000))*(x1240))));
op[135]=((IkReal(-1.00000000000000))+(x1209)+(x1208)+(x1205)+(((IkReal(-1.00000000000000))*(x1236)))+(((IkReal(-1.00000000000000))*(x1206))));
op[136]=((((IkReal(0.0872823000000000))*(x1008)))+(((IkReal(0.0872823000000000))*(x1003)))+(((IkReal(-1.00000000000000))*(x1200)))+(((IkReal(1.33436934500000))*(x1021)))+(((IkReal(1.33436934500000))*(x1020))));
op[137]=((IkReal(1.00000000000000))+(x1209)+(x1208)+(x1206)+(((IkReal(-1.00000000000000))*(x1236)))+(((IkReal(-1.00000000000000))*(x1205))));
op[138]=((x1216)+(((IkReal(-1.00000000000000))*(x1200))));
op[139]=((IkReal(4.00000000000000))+(((IkReal(0.106800000000000))*(x1015)))+(((IkReal(0.106800000000000))*(x1016)))+(((IkReal(-0.109911310000000))*(x1024)))+(((IkReal(-0.109911310000000))*(x1029))));
op[140]=((x1200)+(((IkReal(-1.00000000000000))*(x1216))));
op[141]=((IkReal(1.00000000000000))+(x1208)+(x1206)+(x1227)+(((IkReal(-1.00000000000000))*(x1233)))+(((IkReal(-1.00000000000000))*(x1214))));
op[142]=((x1200)+(((IkReal(-0.00349770000000000))*(x1008)))+(((IkReal(-0.00349770000000000))*(x1003)))+(((IkReal(-0.000719345000000000))*(x1020)))+(((IkReal(-0.000719345000000000))*(x1021))));
op[143]=((IkReal(-1.00000000000000))+(x1208)+(x1227)+(x1214)+(((IkReal(-1.00000000000000))*(x1233)))+(((IkReal(-1.00000000000000))*(x1206))));
op[144]=((IkReal(-0.817250000000000))+(x1235)+(x1217)+(x1218)+(((IkReal(-1.00000000000000))*(x1220)))+(((IkReal(-1.00000000000000))*(x1229)))+(((IkReal(-1.00000000000000))*(x1238))));
op[145]=((((IkReal(-1.33436934500000))*(x1030)))+(((IkReal(-1.33436934500000))*(x1058)))+(((IkReal(1.33436934500000))*(x1014)))+(x1203)+(((IkReal(-0.0872823000000000))*(x1025)))+(((IkReal(1.33436934500000))*(x1048)))+(((IkReal(0.0872823000000000))*(x1009)))+(((IkReal(-0.0872823000000000))*(x1061)))+(((IkReal(0.0872823000000000))*(x1028)))+(((IkReal(-1.00000000000000))*(x1213))));
op[146]=((IkReal(0.817250000000000))+(x1235)+(x1229)+(x1218)+(((IkReal(-1.00000000000000))*(x1220)))+(((IkReal(-1.00000000000000))*(x1238)))+(((IkReal(-1.00000000000000))*(x1217))));
op[147]=((x1232)+(((IkReal(-1.00000000000000))*(x1231))));
op[148]=((IkReal(1.70000000000000))+(((IkReal(-0.109911310000000))*(x1005)))+(((IkReal(0.106800000000000))*(x1049)))+(((IkReal(-1.00000000000000))*(rxp1_1)*(x994)))+(((IkReal(0.109911310000000))*(x993)))+(((IkReal(0.109911310000000))*(x1040)))+(((rxp0_0)*(x1051)))+(((IkReal(-1.00000000000000))*(rxp0_1)*(x1034)))+(((IkReal(-0.109911310000000))*(x1022))));
op[149]=((x1231)+(((IkReal(-1.00000000000000))*(x1232))));
op[150]=((IkReal(0.0327500000000000))+(x1235)+(x1224)+(x1223)+(((IkReal(-1.00000000000000))*(x1221)))+(((IkReal(-1.00000000000000))*(x1222)))+(((IkReal(-1.00000000000000))*(x1238))));
op[151]=((x1213)+(((IkReal(0.000719345000000000))*(x1058)))+(((IkReal(0.000719345000000000))*(x1030)))+(((IkReal(-0.000719345000000000))*(x1048)))+(((IkReal(-0.00349770000000000))*(x1009)))+(((IkReal(0.00349770000000000))*(x1025)))+(((IkReal(-0.00349770000000000))*(x1028)))+(((IkReal(-0.000719345000000000))*(x1014)))+(((IkReal(-1.00000000000000))*(x1203)))+(((IkReal(0.00349770000000000))*(x1061))));
op[152]=((IkReal(-0.0327500000000000))+(x1235)+(x1223)+(x1221)+(((IkReal(-1.00000000000000))*(x1222)))+(((IkReal(-1.00000000000000))*(x1224)))+(((IkReal(-1.00000000000000))*(x1238))));
op[153]=((x1204)+(x1237)+(((IkReal(-1.00000000000000))*(x1215)))+(((IkReal(-1.00000000000000))*(x1210)))+(((IkReal(-1.00000000000000))*(x1212))));
op[154]=((x1201)+(((IkReal(-0.00826126969500000))*(x1008)))+(((IkReal(-0.00826126969500000))*(x1003)))+(((IkReal(-0.126298058504250))*(x1020)))+(((IkReal(-0.126298058504250))*(x1021))));
op[155]=((x1204)+(x1234)+(x1212)+(((IkReal(-1.00000000000000))*(x1230)))+(((IkReal(-1.00000000000000))*(x1210))));
op[156]=((IkReal(-0.784500000000000))+(x1201)+(((IkReal(-1.00000000000000))*(x1228))));
op[157]=((((IkReal(0.0104031054915000))*(x1029)))+(((IkReal(0.0104031054915000))*(x1024)))+(((IkReal(-0.0101086200000000))*(x1016)))+(((IkReal(-0.0101086200000000))*(x1015))));
op[158]=((IkReal(-0.784500000000000))+(x1228)+(((IkReal(-1.00000000000000))*(x1201))));
op[159]=((x1207)+(x1234)+(((IkReal(-1.00000000000000))*(x1225)))+(((IkReal(-1.00000000000000))*(x1230))));
op[160]=((((IkReal(0.000331057305000000))*(x1003)))+(((IkReal(0.000331057305000000))*(x1008)))+(((IkReal(6.80860042500000e-5))*(x1021)))+(((IkReal(6.80860042500000e-5))*(x1020)))+(((IkReal(-1.00000000000000))*(x1201))));
op[161]=((x1237)+(((IkReal(-1.00000000000000))*(x1225)))+(((IkReal(-1.00000000000000))*(x1207)))+(((IkReal(-1.00000000000000))*(x1215))));
solvedialyticpoly12qep(op,zeror,numroots);
IkReal j1array[16], cj1array[16], sj1array[16], j2array[16], cj2array[16], sj2array[16], j3array[16], cj3array[16], sj3array[16];
int numsolutions = 0;
for(int ij1 = 0; ij1 < numroots; ij1 += 3)
{
IkReal htj1 = zeror[ij1+0], htj2 = zeror[ij1+1], htj3 = zeror[ij1+2];
j1array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj1)));
j2array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj2)));
j3array[numsolutions]=((IkReal(2.00000000000000))*(atan(htj3)));
IkReal x1241=(htj1)*(htj1);
IkReal x1242=(htj2)*(htj2);
IkReal x1243=(htj3)*(htj3);
cj1array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x1241))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x1241)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1241))))));
cj2array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x1242))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x1242)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1242))))));
cj3array[numsolutions]=((((IKabs(((IkReal(1.00000000000000))+(x1243))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+(x1243)))):(IkReal)1.0e30))*(((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1243))))));
sj1array[numsolutions]=((IkReal(2.00000000000000))*(htj1)*(((IKabs(((IkReal(1.00000000000000))+((htj1)*(htj1)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj1)*(htj1))))):(IkReal)1.0e30)));
sj2array[numsolutions]=((IkReal(2.00000000000000))*(htj2)*(((IKabs(((IkReal(1.00000000000000))+((htj2)*(htj2)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj2)*(htj2))))):(IkReal)1.0e30)));
sj3array[numsolutions]=((IkReal(2.00000000000000))*(htj3)*(((IKabs(((IkReal(1.00000000000000))+((htj3)*(htj3)))) != 0)?((IkReal)1/(((IkReal(1.00000000000000))+((htj3)*(htj3))))):(IkReal)1.0e30)));
if( j1array[numsolutions] > IKPI )
{
    j1array[numsolutions]-=IK2PI;
}
else if( j1array[numsolutions] < -IKPI )
{
    j1array[numsolutions]+=IK2PI;
}
if( j2array[numsolutions] > IKPI )
{
    j2array[numsolutions]-=IK2PI;
}
else if( j2array[numsolutions] < -IKPI )
{
    j2array[numsolutions]+=IK2PI;
}
if( j3array[numsolutions] > IKPI )
{
    j3array[numsolutions]-=IK2PI;
}
else if( j3array[numsolutions] < -IKPI )
{
    j3array[numsolutions]+=IK2PI;
}
numsolutions++;
}
bool j1valid[16]={true,true,true,true,true,true,true,true,true,true,true,true,true,true,true,true};
_nj1 = 16;
_nj2 = 1;
_nj3 = 1;
for(int ij1 = 0; ij1 < numsolutions; ++ij1)
    {
if( !j1valid[ij1] )
{
    continue;
}
_ij1[0] = ij1; _ij1[1] = -1;
_ij2[0] = 0; _ij2[1] = -1;
_ij3[0] = 0; _ij3[1] = -1;
for(int iij1 = ij1+1; iij1 < numsolutions; ++iij1)
{
if( !j1valid[iij1] ) { continue; }
if( IKabs(cj1array[ij1]-cj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj1array[ij1]-sj1array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(cj2array[ij1]-cj2array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj2array[ij1]-sj2array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(cj3array[ij1]-cj3array[iij1]) < IKFAST_SOLUTION_THRESH && IKabs(sj3array[ij1]-sj3array[iij1]) < IKFAST_SOLUTION_THRESH &&  1 )
{
    j1valid[iij1]=false; _ij1[1] = iij1; _ij2[1] = 0; _ij3[1] = 0;  break; 
}
}
    j1 = j1array[ij1]; cj1 = cj1array[ij1]; sj1 = sj1array[ij1];

    j2 = j2array[ij1]; cj2 = cj2array[ij1]; sj2 = sj2array[ij1];

    j3 = j3array[ij1]; cj3 = cj3array[ij1]; sj3 = sj3array[ij1];

{
IkReal dummyeval[1];
dummyeval[0]=(((r20)*(r20))+((r21)*(r21)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=(((r20)*(r20))+((r21)*(r21)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
dummyeval[0]=(((r20)*(r20))+((r21)*(r21)));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
IkReal x1244=((IkReal(1.00000000000000))*(sj3));
if( IKabs(((IkReal(-1.00000000000000))*(r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(-1.00000000000000))*(r20))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x1245=((IkReal(1.00000000000000))*(IKatan2(((IkReal(-1.00000000000000))*(r21)), ((IkReal(-1.00000000000000))*(r20)))));
if( ((((r20)*(r20))+((r21)*(r21)))) < (IkReal)-0.00001 )
    continue;
if( (((((IKabs(IKabs(IKsqrt((((r20)*(r20))+((r21)*(r21)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((r20)*(r20))+((r21)*(r21))))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(cj3)*(sj1)*(sj2)))+(((cj1)*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(cj2)*(sj1)*(x1244)))+(((IkReal(-1.00000000000000))*(cj1)*(sj2)*(x1244))))))) < -1-IKFAST_SINCOS_THRESH || (((((IKabs(IKabs(IKsqrt((((r20)*(r20))+((r21)*(r21)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((r20)*(r20))+((r21)*(r21))))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(cj3)*(sj1)*(sj2)))+(((cj1)*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(cj2)*(sj1)*(x1244)))+(((IkReal(-1.00000000000000))*(cj1)*(sj2)*(x1244))))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1246=IKasin(((((IKabs(IKabs(IKsqrt((((r20)*(r20))+((r21)*(r21)))))) != 0)?((IkReal)1/(IKabs(IKsqrt((((r20)*(r20))+((r21)*(r21))))))):(IkReal)1.0e30))*(((((IkReal(-1.00000000000000))*(cj3)*(sj1)*(sj2)))+(((cj1)*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(cj2)*(sj1)*(x1244)))+(((IkReal(-1.00000000000000))*(cj1)*(sj2)*(x1244)))))));
j5array[0]=((((IkReal(-1.00000000000000))*(x1246)))+(((IkReal(-1.00000000000000))*(x1245))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((IkReal(3.14159265358979))+(x1246)+(((IkReal(-1.00000000000000))*(x1245))));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[1];
evalcond[0]=((((IkReal(0.0946500000000000))*(r21)*(IKcos(j5))))+(pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1)))+(((IkReal(0.0946500000000000))*(r20)*(IKsin(j5)))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x1247=((IkReal(20000.0000000000))*(cj5));
IkReal x1248=((IkReal(20000.0000000000))*(sj5));
gconst0=IKsign(((((IkReal(-1.00000000000000))*(px)*(r11)*(x1247)))+(((py)*(r01)*(x1247)))+(((py)*(r00)*(x1248)))+(((IkReal(-1.00000000000000))*(px)*(r10)*(x1248)))));
IkReal x1249=((IkReal(1.00000000000000))*(px));
dummyeval[0]=((((cj5)*(py)*(r01)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1249)))+(((py)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1249))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x1250=(cj5)*(cj5);
IkReal x1251=(sj5)*(sj5);
IkReal x1252=((IkReal(1.00000000000000))*(x1251));
IkReal x1253=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1254=((IkReal(1.00000000000000))*(x1250));
gconst1=IKsign(((((IkReal(-1.00000000000000))*(x1252)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1253)))+(((IkReal(-1.00000000000000))*(x1254)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1253)))+(((IkReal(-1.00000000000000))*(x1254)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(x1252)*((r00)*(r00))))));
IkReal x1255=(cj5)*(cj5);
IkReal x1256=(sj5)*(sj5);
IkReal x1257=((IkReal(1.00000000000000))*(x1256));
IkReal x1258=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1259=((IkReal(1.00000000000000))*(x1255));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r00)*(r01)*(x1258)))+(((IkReal(-1.00000000000000))*(x1259)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1258)))+(((IkReal(-1.00000000000000))*(x1257)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x1259)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x1257)*((r10)*(r10)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1260=((sj2)*(sj3));
IkReal x1261=((cj5)*(r01));
IkReal x1262=((cj5)*(r11));
IkReal x1263=((r00)*(sj5));
IkReal x1264=((r10)*(sj5));
IkReal x1265=((sj1)*(x1263));
IkReal x1266=((IkReal(1.00000000000000))*(cj2)*(cj3));
IkReal x1267=((sj1)*(x1264));
IkReal x1268=((IkReal(1.00000000000000))*(cj1)*(cj2)*(sj3));
IkReal x1269=((IkReal(1.00000000000000))*(cj1)*(cj3)*(sj2));
if( IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x1264)*(x1268)))+(((IkReal(-1.00000000000000))*(x1264)*(x1269)))+(((IkReal(-1.00000000000000))*(x1266)*(x1267)))+(((IkReal(-1.00000000000000))*(x1262)*(x1269)))+(((IkReal(-1.00000000000000))*(x1262)*(x1268)))+(((x1260)*(x1267)))+(((sj1)*(x1260)*(x1262)))+(((IkReal(-1.00000000000000))*(sj1)*(x1262)*(x1266))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x1261)*(x1269)))+(((IkReal(-1.00000000000000))*(x1261)*(x1268)))+(((IkReal(-1.00000000000000))*(sj1)*(x1261)*(x1266)))+(((IkReal(-1.00000000000000))*(x1263)*(x1269)))+(((IkReal(-1.00000000000000))*(x1263)*(x1268)))+(((x1260)*(x1265)))+(((IkReal(-1.00000000000000))*(x1265)*(x1266)))+(((sj1)*(x1260)*(x1261))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst1)*(((((IkReal(-1.00000000000000))*(x1264)*(x1268)))+(((IkReal(-1.00000000000000))*(x1264)*(x1269)))+(((IkReal(-1.00000000000000))*(x1266)*(x1267)))+(((IkReal(-1.00000000000000))*(x1262)*(x1269)))+(((IkReal(-1.00000000000000))*(x1262)*(x1268)))+(((x1260)*(x1267)))+(((sj1)*(x1260)*(x1262)))+(((IkReal(-1.00000000000000))*(sj1)*(x1262)*(x1266)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(x1261)*(x1269)))+(((IkReal(-1.00000000000000))*(x1261)*(x1268)))+(((IkReal(-1.00000000000000))*(sj1)*(x1261)*(x1266)))+(((IkReal(-1.00000000000000))*(x1263)*(x1269)))+(((IkReal(-1.00000000000000))*(x1263)*(x1268)))+(((x1260)*(x1265)))+(((IkReal(-1.00000000000000))*(x1265)*(x1266)))+(((sj1)*(x1260)*(x1261)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1270=IKcos(j0);
IkReal x1271=IKsin(j0);
IkReal x1272=((r00)*(sj5));
IkReal x1273=((IkReal(1.00000000000000))*(cj2));
IkReal x1274=((cj5)*(r11));
IkReal x1275=((sj1)*(sj2));
IkReal x1276=((r10)*(sj5));
IkReal x1277=((IkReal(0.0946500000000000))*(x1271));
IkReal x1278=((IkReal(0.0946500000000000))*(x1270));
IkReal x1279=((IkReal(1.00000000000000))*(x1271));
IkReal x1280=((IkReal(1.00000000000000))*(x1270));
IkReal x1281=((cj5)*(r01)*(x1271));
IkReal x1282=((cj5)*(x1278));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1279)))+(((IkReal(-1.00000000000000))*(x1272)*(x1279)))+(((x1270)*(x1276)))+(((x1270)*(x1274))));
evalcond[1]=((IkReal(0.109150000000000))+(((x1272)*(x1277)))+(((IkReal(-1.00000000000000))*(x1276)*(x1278)))+(((IkReal(-1.00000000000000))*(x1274)*(x1278)))+(((cj5)*(r01)*(x1277)))+(((px)*(x1271)))+(((IkReal(-1.00000000000000))*(py)*(x1280))));
evalcond[2]=((((IkReal(-1.00000000000000))*(py)*(x1279)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(px)*(x1280)))+(((IkReal(-1.00000000000000))*(x1276)*(x1277)))+(((IkReal(-0.392250000000000))*(x1275)))+(((IkReal(-1.00000000000000))*(r01)*(x1282)))+(((IkReal(-1.00000000000000))*(x1272)*(x1278)))+(((IkReal(-1.00000000000000))*(x1274)*(x1277))));
evalcond[3]=((((sj3)*(x1275)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)*(x1273)))+(((IkReal(-1.00000000000000))*(cj1)*(cj3)*(sj2)))+(((IkReal(-1.00000000000000))*(cj3)*(sj1)*(x1273)))+(((x1270)*(x1272)))+(((x1271)*(x1276)))+(((x1271)*(x1274)))+(((cj5)*(r01)*(x1270))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x1283=((IkReal(1.00000000000000))*(sj0));
IkReal x1284=((cj5)*(r22));
IkReal x1285=((r21)*(sj5));
IkReal x1286=((IkReal(1.00000000000000))*(cj0));
IkReal x1287=((r22)*(sj5));
IkReal x1288=((cj5)*(r20));
gconst3=IKsign(((((r02)*(sj0)*(x1288)))+(((IkReal(-1.00000000000000))*(r02)*(x1283)*(x1285)))+(((cj0)*(r10)*(x1284)))+(((IkReal(-1.00000000000000))*(r00)*(x1283)*(x1284)))+(((r01)*(sj0)*(x1287)))+(((IkReal(-1.00000000000000))*(r12)*(x1286)*(x1288)))+(((IkReal(-1.00000000000000))*(r11)*(x1286)*(x1287)))+(((cj0)*(r12)*(x1285)))));
IkReal x1289=((IkReal(1.00000000000000))*(sj0));
IkReal x1290=((cj5)*(r22));
IkReal x1291=((r21)*(sj5));
IkReal x1292=((IkReal(1.00000000000000))*(cj0));
IkReal x1293=((r22)*(sj5));
IkReal x1294=((cj5)*(r20));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r02)*(x1289)*(x1291)))+(((IkReal(-1.00000000000000))*(r00)*(x1289)*(x1290)))+(((r01)*(sj0)*(x1293)))+(((cj0)*(r12)*(x1291)))+(((IkReal(-1.00000000000000))*(r12)*(x1292)*(x1294)))+(((r02)*(sj0)*(x1294)))+(((cj0)*(r10)*(x1290)))+(((IkReal(-1.00000000000000))*(r11)*(x1292)*(x1293))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1295=((cj3)*(sj2));
IkReal x1296=((cj2)*(cj3));
IkReal x1297=((cj2)*(sj3));
IkReal x1298=((sj2)*(sj3));
IkReal x1299=((r21)*(sj5));
IkReal x1300=((IkReal(1.00000000000000))*(cj1));
IkReal x1301=((IkReal(1.00000000000000))*(sj1));
IkReal x1302=((r22)*(x1300));
IkReal x1303=((cj5)*(r20)*(sj1));
IkReal x1304=((cj1)*(cj5)*(r20));
if( IKabs(((gconst4)*(((((r22)*(sj1)*(x1298)))+(((IkReal(-1.00000000000000))*(x1297)*(x1302)))+(((IkReal(-1.00000000000000))*(r22)*(x1296)*(x1301)))+(((IkReal(-1.00000000000000))*(x1295)*(x1302))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x1296)*(x1299)*(x1301)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1298)*(x1301)))+(((IkReal(-1.00000000000000))*(x1297)*(x1299)*(x1300)))+(((x1295)*(x1304)))+(((IkReal(-1.00000000000000))*(x1295)*(x1299)*(x1300)))+(((x1297)*(x1304)))+(((x1296)*(x1303)))+(((sj1)*(x1298)*(x1299))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst4)*(((((r22)*(sj1)*(x1298)))+(((IkReal(-1.00000000000000))*(x1297)*(x1302)))+(((IkReal(-1.00000000000000))*(r22)*(x1296)*(x1301)))+(((IkReal(-1.00000000000000))*(x1295)*(x1302)))))), ((gconst4)*(((((IkReal(-1.00000000000000))*(x1296)*(x1299)*(x1301)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1298)*(x1301)))+(((IkReal(-1.00000000000000))*(x1297)*(x1299)*(x1300)))+(((x1295)*(x1304)))+(((IkReal(-1.00000000000000))*(x1295)*(x1299)*(x1300)))+(((x1297)*(x1304)))+(((x1296)*(x1303)))+(((sj1)*(x1298)*(x1299)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1305=IKsin(j4);
IkReal x1306=IKcos(j4);
IkReal x1307=((IkReal(1.00000000000000))*(cj2));
IkReal x1308=((cj3)*(sj1));
IkReal x1309=((cj1)*(sj3));
IkReal x1310=((IkReal(1.00000000000000))*(cj5));
IkReal x1311=((IkReal(1.00000000000000))*(r01));
IkReal x1312=((cj1)*(cj3));
IkReal x1313=((r11)*(sj5));
IkReal x1314=((sj1)*(sj3));
IkReal x1315=((r01)*(sj5));
IkReal x1316=((r21)*(sj5));
IkReal x1317=((cj0)*(x1305));
IkReal x1318=((cj5)*(x1305));
IkReal x1319=((sj0)*(x1306));
IkReal x1320=((IkReal(1.00000000000000))*(x1305));
IkReal x1321=((cj0)*(x1306));
IkReal x1322=((sj0)*(sj5)*(x1305));
IkReal x1323=((IkReal(1.00000000000000))*(x1321));
evalcond[0]=((((r22)*(x1306)))+(((r20)*(x1318)))+(((IkReal(-1.00000000000000))*(x1316)*(x1320))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x1311)*(x1319)))+(((x1313)*(x1321)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1320)))+(((cj5)*(r00)*(x1319)))+(((r12)*(x1317)))+(((IkReal(-1.00000000000000))*(r10)*(x1310)*(x1321))));
evalcond[2]=((((sj0)*(x1305)*(x1313)))+(((IkReal(-1.00000000000000))*(r12)*(x1319)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1305)*(x1310)))+(((IkReal(-1.00000000000000))*(r02)*(x1323)))+(((IkReal(-1.00000000000000))*(r00)*(x1310)*(x1317)))+(((x1315)*(x1317))));
evalcond[3]=((IkReal(1.00000000000000))+(((x1313)*(x1317)))+(((IkReal(-1.00000000000000))*(r12)*(x1323)))+(((r02)*(x1319)))+(((IkReal(-1.00000000000000))*(r10)*(x1310)*(x1317)))+(((r00)*(sj0)*(x1318)))+(((IkReal(-1.00000000000000))*(x1311)*(x1322))));
evalcond[4]=((((cj5)*(r20)*(x1306)))+(((IkReal(-1.00000000000000))*(x1307)*(x1308)))+(((IkReal(-1.00000000000000))*(x1307)*(x1309)))+(((sj2)*(x1314)))+(((IkReal(-1.00000000000000))*(r22)*(x1320)))+(((IkReal(-1.00000000000000))*(x1306)*(x1316)))+(((IkReal(-1.00000000000000))*(sj2)*(x1312))));
evalcond[5]=((((x1313)*(x1319)))+(((sj2)*(x1309)))+(((sj2)*(x1308)))+(((r12)*(sj0)*(x1305)))+(((IkReal(-1.00000000000000))*(x1307)*(x1312)))+(((cj2)*(x1314)))+(((r02)*(x1317)))+(((IkReal(-1.00000000000000))*(r10)*(x1310)*(x1319)))+(((IkReal(-1.00000000000000))*(r00)*(x1310)*(x1321)))+(((x1315)*(x1321))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst3)*(r22))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(r22)), ((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1324=IKsin(j4);
IkReal x1325=IKcos(j4);
IkReal x1326=((IkReal(1.00000000000000))*(cj2));
IkReal x1327=((cj3)*(sj1));
IkReal x1328=((cj1)*(sj3));
IkReal x1329=((IkReal(1.00000000000000))*(cj5));
IkReal x1330=((IkReal(1.00000000000000))*(r01));
IkReal x1331=((cj1)*(cj3));
IkReal x1332=((r11)*(sj5));
IkReal x1333=((sj1)*(sj3));
IkReal x1334=((r01)*(sj5));
IkReal x1335=((r21)*(sj5));
IkReal x1336=((cj0)*(x1324));
IkReal x1337=((cj5)*(x1324));
IkReal x1338=((sj0)*(x1325));
IkReal x1339=((IkReal(1.00000000000000))*(x1324));
IkReal x1340=((cj0)*(x1325));
IkReal x1341=((sj0)*(sj5)*(x1324));
IkReal x1342=((IkReal(1.00000000000000))*(x1340));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1335)*(x1339)))+(((r20)*(x1337)))+(((r22)*(x1325))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r10)*(x1329)*(x1340)))+(((r12)*(x1336)))+(((cj5)*(r00)*(x1338)))+(((x1332)*(x1340)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1339)))+(((IkReal(-1.00000000000000))*(sj5)*(x1330)*(x1338))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r02)*(x1342)))+(((IkReal(-1.00000000000000))*(r12)*(x1338)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1324)*(x1329)))+(((IkReal(-1.00000000000000))*(r00)*(x1329)*(x1336)))+(((sj0)*(x1324)*(x1332)))+(((x1334)*(x1336))));
evalcond[3]=((IkReal(1.00000000000000))+(((r00)*(sj0)*(x1337)))+(((IkReal(-1.00000000000000))*(r12)*(x1342)))+(((IkReal(-1.00000000000000))*(r10)*(x1329)*(x1336)))+(((IkReal(-1.00000000000000))*(x1330)*(x1341)))+(((r02)*(x1338)))+(((x1332)*(x1336))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r22)*(x1339)))+(((IkReal(-1.00000000000000))*(x1325)*(x1335)))+(((IkReal(-1.00000000000000))*(x1326)*(x1327)))+(((IkReal(-1.00000000000000))*(x1326)*(x1328)))+(((sj2)*(x1333)))+(((IkReal(-1.00000000000000))*(sj2)*(x1331)))+(((cj5)*(r20)*(x1325))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1326)*(x1331)))+(((sj2)*(x1327)))+(((sj2)*(x1328)))+(((IkReal(-1.00000000000000))*(r10)*(x1329)*(x1338)))+(((r12)*(sj0)*(x1324)))+(((x1334)*(x1340)))+(((cj2)*(x1333)))+(((IkReal(-1.00000000000000))*(r00)*(x1329)*(x1340)))+(((r02)*(x1336)))+(((x1332)*(x1338))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1343=((cj3)*(sj2));
IkReal x1344=((cj2)*(sj3));
IkReal x1345=((cj5)*(r20));
IkReal x1346=((r21)*(sj5));
IkReal x1347=((IkReal(1.00000000000000))*(cj1));
IkReal x1348=((r22)*(x1347));
IkReal x1349=((sj1)*(sj2)*(sj3));
IkReal x1350=((cj2)*(cj3)*(sj1));
if( IKabs(((gconst2)*(((((r22)*(x1349)))+(((IkReal(-1.00000000000000))*(r22)*(x1350)))+(((IkReal(-1.00000000000000))*(x1343)*(x1348)))+(((IkReal(-1.00000000000000))*(x1344)*(x1348))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x1346)*(x1350)))+(((x1345)*(x1350)))+(((IkReal(-1.00000000000000))*(x1344)*(x1346)*(x1347)))+(((x1346)*(x1349)))+(((cj1)*(x1344)*(x1345)))+(((IkReal(-1.00000000000000))*(x1345)*(x1349)))+(((cj1)*(x1343)*(x1345)))+(((IkReal(-1.00000000000000))*(x1343)*(x1346)*(x1347))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst2)*(((((r22)*(x1349)))+(((IkReal(-1.00000000000000))*(r22)*(x1350)))+(((IkReal(-1.00000000000000))*(x1343)*(x1348)))+(((IkReal(-1.00000000000000))*(x1344)*(x1348)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(x1346)*(x1350)))+(((x1345)*(x1350)))+(((IkReal(-1.00000000000000))*(x1344)*(x1346)*(x1347)))+(((x1346)*(x1349)))+(((cj1)*(x1344)*(x1345)))+(((IkReal(-1.00000000000000))*(x1345)*(x1349)))+(((cj1)*(x1343)*(x1345)))+(((IkReal(-1.00000000000000))*(x1343)*(x1346)*(x1347)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[2];
IkReal x1351=IKsin(j4);
IkReal x1352=IKcos(j4);
IkReal x1353=((IkReal(1.00000000000000))*(cj1));
IkReal x1354=((cj5)*(r20));
IkReal x1355=((IkReal(1.00000000000000))*(r21)*(sj5));
evalcond[0]=((((r22)*(x1352)))+(((x1351)*(x1354)))+(((IkReal(-1.00000000000000))*(x1351)*(x1355))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1352)*(x1355)))+(((IkReal(-1.00000000000000))*(r22)*(x1351)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3)*(sj1)))+(((IkReal(-1.00000000000000))*(cj2)*(sj3)*(x1353)))+(((sj1)*(sj2)*(sj3)))+(((IkReal(-1.00000000000000))*(cj3)*(sj2)*(x1353)))+(((x1352)*(x1354))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst5;
IkReal x1356=((IkReal(20000.0000000000))*(cj5));
IkReal x1357=((IkReal(20000.0000000000))*(sj5));
gconst5=IKsign(((((IkReal(-1.00000000000000))*(px)*(r11)*(x1356)))+(((IkReal(-1.00000000000000))*(px)*(r10)*(x1357)))+(((py)*(r00)*(x1357)))+(((py)*(r01)*(x1356)))));
IkReal x1358=((IkReal(1.00000000000000))*(px));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1358)))+(((cj5)*(py)*(r01)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1358)))+(((py)*(r00)*(sj5))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
IkReal x1359=(sj5)*(sj5);
IkReal x1360=(cj5)*(cj5);
IkReal x1361=((cj4)*(sj5));
IkReal x1362=((IkReal(1.00000000000000))*(r02));
IkReal x1363=((r01)*(r10));
IkReal x1364=((cj4)*(cj5));
IkReal x1365=((sj4)*(x1360));
IkReal x1366=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1367=((sj4)*(x1359));
gconst6=IKsign(((((IkReal(-1.00000000000000))*(x1366)*(x1367)))+(((x1363)*(x1367)))+(((x1363)*(x1365)))+(((IkReal(-1.00000000000000))*(r11)*(x1362)*(x1364)))+(((IkReal(-1.00000000000000))*(r10)*(x1361)*(x1362)))+(((r00)*(r12)*(x1361)))+(((IkReal(-1.00000000000000))*(x1365)*(x1366)))+(((r01)*(r12)*(x1364)))));
IkReal x1368=(sj5)*(sj5);
IkReal x1369=(cj5)*(cj5);
IkReal x1370=((cj4)*(sj5));
IkReal x1371=((IkReal(1.00000000000000))*(r02));
IkReal x1372=((r01)*(r10));
IkReal x1373=((cj4)*(cj5));
IkReal x1374=((sj4)*(x1369));
IkReal x1375=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1376=((sj4)*(x1368));
dummyeval[0]=((((x1372)*(x1376)))+(((x1372)*(x1374)))+(((IkReal(-1.00000000000000))*(r11)*(x1371)*(x1373)))+(((IkReal(-1.00000000000000))*(x1375)*(x1376)))+(((r01)*(r12)*(x1373)))+(((IkReal(-1.00000000000000))*(x1374)*(x1375)))+(((IkReal(-1.00000000000000))*(r10)*(x1370)*(x1371)))+(((r00)*(r12)*(x1370))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst6)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((r00)*(sj5)))+(((cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst6)*(((((cj5)*(r11)))+(((r10)*(sj5)))))), ((gconst6)*(((((r00)*(sj5)))+(((cj5)*(r01)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x1377=IKcos(j0);
IkReal x1378=IKsin(j0);
IkReal x1379=((IkReal(1.00000000000000))*(cj5));
IkReal x1380=((IkReal(0.0946500000000000))*(sj5));
IkReal x1381=((IkReal(1.00000000000000))*(cj2));
IkReal x1382=((cj3)*(sj1));
IkReal x1383=((cj1)*(sj3));
IkReal x1384=((IkReal(0.0946500000000000))*(cj5));
IkReal x1385=((r02)*(sj4));
IkReal x1386=((cj1)*(cj3));
IkReal x1387=((sj1)*(sj2));
IkReal x1388=((sj4)*(sj5));
IkReal x1389=((IkReal(1.00000000000000))*(sj5));
IkReal x1390=((cj4)*(r02));
IkReal x1391=((cj4)*(r12));
IkReal x1392=((cj4)*(sj5));
IkReal x1393=((r12)*(sj4));
IkReal x1394=((r01)*(x1378));
IkReal x1395=((r00)*(x1377));
IkReal x1396=((r00)*(x1378));
IkReal x1397=((r11)*(x1377));
IkReal x1398=((r01)*(x1377));
IkReal x1399=((r11)*(x1378));
IkReal x1400=((r10)*(x1378));
IkReal x1401=((IkReal(1.00000000000000))*(x1378));
IkReal x1402=((r10)*(x1377));
IkReal x1403=((IkReal(1.00000000000000))*(x1377));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1389)*(x1396)))+(((sj5)*(x1402)))+(((cj5)*(x1397)))+(((IkReal(-1.00000000000000))*(x1379)*(x1394))));
evalcond[1]=((IkReal(0.109150000000000))+(((IkReal(-1.00000000000000))*(x1384)*(x1397)))+(((px)*(x1378)))+(((IkReal(-1.00000000000000))*(x1380)*(x1402)))+(((x1384)*(x1394)))+(((IkReal(-1.00000000000000))*(py)*(x1403)))+(((x1380)*(x1396))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj4)*(x1379)*(x1402)))+(((IkReal(-1.00000000000000))*(cj4)*(x1389)*(x1394)))+(((x1377)*(x1393)))+(((IkReal(-1.00000000000000))*(x1385)*(x1401)))+(((cj4)*(cj5)*(x1396)))+(((x1392)*(x1397))));
evalcond[3]=((((x1388)*(x1398)))+(((x1388)*(x1399)))+(((IkReal(-1.00000000000000))*(sj4)*(x1379)*(x1400)))+(((IkReal(-1.00000000000000))*(x1390)*(x1403)))+(((IkReal(-1.00000000000000))*(x1391)*(x1401)))+(((IkReal(-1.00000000000000))*(sj4)*(x1379)*(x1395))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1388)*(x1394)))+(((x1388)*(x1397)))+(((IkReal(-1.00000000000000))*(sj4)*(x1379)*(x1402)))+(((cj5)*(sj4)*(x1396)))+(((IkReal(-1.00000000000000))*(x1391)*(x1403)))+(((x1378)*(x1390))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1384)*(x1399)))+(((IkReal(-1.00000000000000))*(x1384)*(x1398)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-0.392250000000000))*(x1387)))+(((IkReal(-1.00000000000000))*(x1380)*(x1400)))+(((IkReal(-1.00000000000000))*(px)*(x1403)))+(((IkReal(-1.00000000000000))*(x1380)*(x1395)))+(((IkReal(-1.00000000000000))*(py)*(x1401))));
evalcond[6]=((((IkReal(-1.00000000000000))*(sj2)*(x1386)))+(((sj5)*(x1400)))+(((cj5)*(x1398)))+(((cj5)*(x1399)))+(((sj3)*(x1387)))+(((IkReal(-1.00000000000000))*(x1381)*(x1383)))+(((IkReal(-1.00000000000000))*(x1381)*(x1382)))+(((sj5)*(x1395))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj4)*(x1379)*(x1400)))+(((IkReal(-1.00000000000000))*(x1381)*(x1386)))+(((sj2)*(x1383)))+(((sj2)*(x1382)))+(((x1377)*(x1385)))+(((IkReal(-1.00000000000000))*(cj4)*(x1379)*(x1395)))+(((x1392)*(x1399)))+(((x1392)*(x1398)))+(((cj2)*(sj1)*(sj3)))+(((x1378)*(x1393))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1404=((IkReal(2183.00000000000))*(sj5));
IkReal x1405=((IkReal(2183.00000000000))*(cj5));
if( IKabs(((gconst5)*(((((r11)*(x1405)))+(((r10)*(x1404))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((r00)*(x1404)))+(((r01)*(x1405))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst5)*(((((r11)*(x1405)))+(((r10)*(x1404)))))), ((gconst5)*(((((r00)*(x1404)))+(((r01)*(x1405)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x1406=IKcos(j0);
IkReal x1407=IKsin(j0);
IkReal x1408=((IkReal(1.00000000000000))*(cj5));
IkReal x1409=((IkReal(0.0946500000000000))*(sj5));
IkReal x1410=((IkReal(1.00000000000000))*(cj2));
IkReal x1411=((cj3)*(sj1));
IkReal x1412=((cj1)*(sj3));
IkReal x1413=((IkReal(0.0946500000000000))*(cj5));
IkReal x1414=((r02)*(sj4));
IkReal x1415=((cj1)*(cj3));
IkReal x1416=((sj1)*(sj2));
IkReal x1417=((sj4)*(sj5));
IkReal x1418=((IkReal(1.00000000000000))*(sj5));
IkReal x1419=((cj4)*(r02));
IkReal x1420=((cj4)*(r12));
IkReal x1421=((cj4)*(sj5));
IkReal x1422=((r12)*(sj4));
IkReal x1423=((r01)*(x1407));
IkReal x1424=((r00)*(x1406));
IkReal x1425=((r00)*(x1407));
IkReal x1426=((r11)*(x1406));
IkReal x1427=((r01)*(x1406));
IkReal x1428=((r11)*(x1407));
IkReal x1429=((r10)*(x1407));
IkReal x1430=((IkReal(1.00000000000000))*(x1407));
IkReal x1431=((r10)*(x1406));
IkReal x1432=((IkReal(1.00000000000000))*(x1406));
evalcond[0]=((((sj5)*(x1431)))+(((IkReal(-1.00000000000000))*(x1408)*(x1423)))+(((IkReal(-1.00000000000000))*(x1418)*(x1425)))+(((cj5)*(x1426))));
evalcond[1]=((IkReal(0.109150000000000))+(((px)*(x1407)))+(((x1409)*(x1425)))+(((IkReal(-1.00000000000000))*(x1409)*(x1431)))+(((IkReal(-1.00000000000000))*(x1413)*(x1426)))+(((IkReal(-1.00000000000000))*(py)*(x1432)))+(((x1413)*(x1423))));
evalcond[2]=((((x1406)*(x1422)))+(((IkReal(-1.00000000000000))*(cj4)*(x1408)*(x1431)))+(((cj4)*(cj5)*(x1425)))+(((IkReal(-1.00000000000000))*(x1414)*(x1430)))+(((IkReal(-1.00000000000000))*(cj4)*(x1418)*(x1423)))+(((x1421)*(x1426))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1420)*(x1430)))+(((IkReal(-1.00000000000000))*(x1419)*(x1432)))+(((IkReal(-1.00000000000000))*(sj4)*(x1408)*(x1429)))+(((IkReal(-1.00000000000000))*(sj4)*(x1408)*(x1424)))+(((x1417)*(x1427)))+(((x1417)*(x1428))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1420)*(x1432)))+(((x1407)*(x1419)))+(((IkReal(-1.00000000000000))*(x1417)*(x1423)))+(((IkReal(-1.00000000000000))*(sj4)*(x1408)*(x1431)))+(((x1417)*(x1426)))+(((cj5)*(sj4)*(x1425))));
evalcond[5]=((((IkReal(-0.392250000000000))*(x1416)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(x1409)*(x1429)))+(((IkReal(-1.00000000000000))*(x1409)*(x1424)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(px)*(x1432)))+(((IkReal(-1.00000000000000))*(x1413)*(x1427)))+(((IkReal(-1.00000000000000))*(x1413)*(x1428)))+(((IkReal(-1.00000000000000))*(py)*(x1430))));
evalcond[6]=((((IkReal(-1.00000000000000))*(sj2)*(x1415)))+(((IkReal(-1.00000000000000))*(x1410)*(x1411)))+(((IkReal(-1.00000000000000))*(x1410)*(x1412)))+(((sj5)*(x1424)))+(((sj5)*(x1429)))+(((cj5)*(x1428)))+(((cj5)*(x1427)))+(((sj3)*(x1416))));
evalcond[7]=((((sj2)*(x1411)))+(((sj2)*(x1412)))+(((x1406)*(x1414)))+(((x1407)*(x1422)))+(((IkReal(-1.00000000000000))*(x1410)*(x1415)))+(((IkReal(-1.00000000000000))*(cj4)*(x1408)*(x1429)))+(((IkReal(-1.00000000000000))*(cj4)*(x1408)*(x1424)))+(((cj2)*(sj1)*(sj3)))+(((x1421)*(x1427)))+(((x1421)*(x1428))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1433=((IkReal(2183.00000000000))*(sj5));
IkReal x1434=((IkReal(2183.00000000000))*(cj5));
if( IKabs(((gconst0)*(((((r11)*(x1434)))+(((r10)*(x1433))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((r01)*(x1434)))+(((r00)*(x1433))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst0)*(((((r11)*(x1434)))+(((r10)*(x1433)))))), ((gconst0)*(((((r01)*(x1434)))+(((r00)*(x1433)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1435=IKcos(j0);
IkReal x1436=IKsin(j0);
IkReal x1437=((r00)*(sj5));
IkReal x1438=((IkReal(1.00000000000000))*(cj2));
IkReal x1439=((cj5)*(r11));
IkReal x1440=((sj1)*(sj2));
IkReal x1441=((r10)*(sj5));
IkReal x1442=((IkReal(0.0946500000000000))*(x1436));
IkReal x1443=((IkReal(0.0946500000000000))*(x1435));
IkReal x1444=((IkReal(1.00000000000000))*(x1436));
IkReal x1445=((IkReal(1.00000000000000))*(x1435));
IkReal x1446=((cj5)*(r01)*(x1436));
IkReal x1447=((cj5)*(x1443));
evalcond[0]=((((x1435)*(x1441)))+(((x1435)*(x1439)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1444)))+(((IkReal(-1.00000000000000))*(x1437)*(x1444))));
evalcond[1]=((IkReal(0.109150000000000))+(((x1437)*(x1442)))+(((px)*(x1436)))+(((IkReal(-1.00000000000000))*(x1439)*(x1443)))+(((IkReal(-1.00000000000000))*(x1441)*(x1443)))+(((IkReal(-1.00000000000000))*(py)*(x1445)))+(((cj5)*(r01)*(x1442))));
evalcond[2]=((((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(r01)*(x1447)))+(((IkReal(-1.00000000000000))*(px)*(x1445)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1437)*(x1443)))+(((IkReal(-1.00000000000000))*(x1439)*(x1442)))+(((IkReal(-1.00000000000000))*(x1441)*(x1442)))+(((IkReal(-1.00000000000000))*(py)*(x1444)))+(((IkReal(-0.392250000000000))*(x1440))));
evalcond[3]=((((x1436)*(x1439)))+(((cj5)*(r01)*(x1435)))+(((IkReal(-1.00000000000000))*(cj1)*(cj3)*(sj2)))+(((x1435)*(x1437)))+(((x1436)*(x1441)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)*(x1438)))+(((sj3)*(x1440)))+(((IkReal(-1.00000000000000))*(cj3)*(sj1)*(x1438))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x1448=((IkReal(1.00000000000000))*(sj0));
IkReal x1449=((cj5)*(r22));
IkReal x1450=((r21)*(sj5));
IkReal x1451=((IkReal(1.00000000000000))*(cj0));
IkReal x1452=((r22)*(sj5));
IkReal x1453=((cj5)*(r20));
gconst3=IKsign(((((r02)*(sj0)*(x1453)))+(((IkReal(-1.00000000000000))*(r11)*(x1451)*(x1452)))+(((IkReal(-1.00000000000000))*(r02)*(x1448)*(x1450)))+(((IkReal(-1.00000000000000))*(r12)*(x1451)*(x1453)))+(((cj0)*(r12)*(x1450)))+(((r01)*(sj0)*(x1452)))+(((cj0)*(r10)*(x1449)))+(((IkReal(-1.00000000000000))*(r00)*(x1448)*(x1449)))));
IkReal x1454=((IkReal(1.00000000000000))*(sj0));
IkReal x1455=((cj5)*(r22));
IkReal x1456=((r21)*(sj5));
IkReal x1457=((IkReal(1.00000000000000))*(cj0));
IkReal x1458=((r22)*(sj5));
IkReal x1459=((cj5)*(r20));
dummyeval[0]=((((r02)*(sj0)*(x1459)))+(((IkReal(-1.00000000000000))*(r12)*(x1457)*(x1459)))+(((IkReal(-1.00000000000000))*(r11)*(x1457)*(x1458)))+(((cj0)*(r12)*(x1456)))+(((r01)*(sj0)*(x1458)))+(((IkReal(-1.00000000000000))*(r02)*(x1454)*(x1456)))+(((IkReal(-1.00000000000000))*(r00)*(x1454)*(x1455)))+(((cj0)*(r10)*(x1455))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1460=((cj3)*(sj2));
IkReal x1461=((cj2)*(cj3));
IkReal x1462=((cj2)*(sj3));
IkReal x1463=((sj2)*(sj3));
IkReal x1464=((r21)*(sj5));
IkReal x1465=((IkReal(1.00000000000000))*(cj1));
IkReal x1466=((IkReal(1.00000000000000))*(sj1));
IkReal x1467=((r22)*(x1465));
IkReal x1468=((cj5)*(r20)*(sj1));
IkReal x1469=((cj1)*(cj5)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x1462)*(x1467)))+(((r22)*(sj1)*(x1463)))+(((IkReal(-1.00000000000000))*(x1460)*(x1467)))+(((IkReal(-1.00000000000000))*(r22)*(x1461)*(x1466))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1463)*(x1466)))+(((x1461)*(x1468)))+(((IkReal(-1.00000000000000))*(x1460)*(x1464)*(x1465)))+(((IkReal(-1.00000000000000))*(x1462)*(x1464)*(x1465)))+(((x1460)*(x1469)))+(((x1462)*(x1469)))+(((sj1)*(x1463)*(x1464)))+(((IkReal(-1.00000000000000))*(x1461)*(x1464)*(x1466))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(x1462)*(x1467)))+(((r22)*(sj1)*(x1463)))+(((IkReal(-1.00000000000000))*(x1460)*(x1467)))+(((IkReal(-1.00000000000000))*(r22)*(x1461)*(x1466)))))), ((gconst4)*(((((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1463)*(x1466)))+(((x1461)*(x1468)))+(((IkReal(-1.00000000000000))*(x1460)*(x1464)*(x1465)))+(((IkReal(-1.00000000000000))*(x1462)*(x1464)*(x1465)))+(((x1460)*(x1469)))+(((x1462)*(x1469)))+(((sj1)*(x1463)*(x1464)))+(((IkReal(-1.00000000000000))*(x1461)*(x1464)*(x1466)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1470=IKsin(j4);
IkReal x1471=IKcos(j4);
IkReal x1472=((IkReal(1.00000000000000))*(cj2));
IkReal x1473=((cj3)*(sj1));
IkReal x1474=((cj1)*(sj3));
IkReal x1475=((IkReal(1.00000000000000))*(cj5));
IkReal x1476=((IkReal(1.00000000000000))*(r01));
IkReal x1477=((cj1)*(cj3));
IkReal x1478=((r11)*(sj5));
IkReal x1479=((sj1)*(sj3));
IkReal x1480=((r01)*(sj5));
IkReal x1481=((r21)*(sj5));
IkReal x1482=((cj0)*(x1470));
IkReal x1483=((cj5)*(x1470));
IkReal x1484=((sj0)*(x1471));
IkReal x1485=((IkReal(1.00000000000000))*(x1470));
IkReal x1486=((cj0)*(x1471));
IkReal x1487=((sj0)*(sj5)*(x1470));
IkReal x1488=((IkReal(1.00000000000000))*(x1486));
evalcond[0]=((((r20)*(x1483)))+(((r22)*(x1471)))+(((IkReal(-1.00000000000000))*(x1481)*(x1485))));
evalcond[1]=((((r12)*(x1482)))+(((IkReal(-1.00000000000000))*(r10)*(x1475)*(x1486)))+(((x1478)*(x1486)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1485)))+(((IkReal(-1.00000000000000))*(sj5)*(x1476)*(x1484)))+(((cj5)*(r00)*(x1484))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r00)*(x1475)*(x1482)))+(((x1480)*(x1482)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1470)*(x1475)))+(((IkReal(-1.00000000000000))*(r02)*(x1488)))+(((sj0)*(x1470)*(x1478)))+(((IkReal(-1.00000000000000))*(r12)*(x1484))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r12)*(x1488)))+(((r00)*(sj0)*(x1483)))+(((IkReal(-1.00000000000000))*(r10)*(x1475)*(x1482)))+(((x1478)*(x1482)))+(((r02)*(x1484)))+(((IkReal(-1.00000000000000))*(x1476)*(x1487))));
evalcond[4]=((((cj5)*(r20)*(x1471)))+(((IkReal(-1.00000000000000))*(x1471)*(x1481)))+(((sj2)*(x1479)))+(((IkReal(-1.00000000000000))*(r22)*(x1485)))+(((IkReal(-1.00000000000000))*(x1472)*(x1474)))+(((IkReal(-1.00000000000000))*(x1472)*(x1473)))+(((IkReal(-1.00000000000000))*(sj2)*(x1477))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x1475)*(x1486)))+(((x1480)*(x1486)))+(((cj2)*(x1479)))+(((sj2)*(x1473)))+(((sj2)*(x1474)))+(((IkReal(-1.00000000000000))*(r10)*(x1475)*(x1484)))+(((x1478)*(x1484)))+(((r12)*(sj0)*(x1470)))+(((r02)*(x1482)))+(((IkReal(-1.00000000000000))*(x1472)*(x1477))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst3)*(r22))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(r22)), ((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1489=IKsin(j4);
IkReal x1490=IKcos(j4);
IkReal x1491=((IkReal(1.00000000000000))*(cj2));
IkReal x1492=((cj3)*(sj1));
IkReal x1493=((cj1)*(sj3));
IkReal x1494=((IkReal(1.00000000000000))*(cj5));
IkReal x1495=((IkReal(1.00000000000000))*(r01));
IkReal x1496=((cj1)*(cj3));
IkReal x1497=((r11)*(sj5));
IkReal x1498=((sj1)*(sj3));
IkReal x1499=((r01)*(sj5));
IkReal x1500=((r21)*(sj5));
IkReal x1501=((cj0)*(x1489));
IkReal x1502=((cj5)*(x1489));
IkReal x1503=((sj0)*(x1490));
IkReal x1504=((IkReal(1.00000000000000))*(x1489));
IkReal x1505=((cj0)*(x1490));
IkReal x1506=((sj0)*(sj5)*(x1489));
IkReal x1507=((IkReal(1.00000000000000))*(x1505));
evalcond[0]=((((r20)*(x1502)))+(((IkReal(-1.00000000000000))*(x1500)*(x1504)))+(((r22)*(x1490))));
evalcond[1]=((((IkReal(-1.00000000000000))*(sj5)*(x1495)*(x1503)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1504)))+(((r12)*(x1501)))+(((cj5)*(r00)*(x1503)))+(((IkReal(-1.00000000000000))*(r10)*(x1494)*(x1505)))+(((x1497)*(x1505))));
evalcond[2]=((((x1499)*(x1501)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1489)*(x1494)))+(((IkReal(-1.00000000000000))*(r00)*(x1494)*(x1501)))+(((IkReal(-1.00000000000000))*(r02)*(x1507)))+(((IkReal(-1.00000000000000))*(r12)*(x1503)))+(((sj0)*(x1489)*(x1497))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x1494)*(x1501)))+(((r00)*(sj0)*(x1502)))+(((x1497)*(x1501)))+(((r02)*(x1503)))+(((IkReal(-1.00000000000000))*(x1495)*(x1506)))+(((IkReal(-1.00000000000000))*(r12)*(x1507))));
evalcond[4]=((((sj2)*(x1498)))+(((IkReal(-1.00000000000000))*(r22)*(x1504)))+(((IkReal(-1.00000000000000))*(x1490)*(x1500)))+(((cj5)*(r20)*(x1490)))+(((IkReal(-1.00000000000000))*(sj2)*(x1496)))+(((IkReal(-1.00000000000000))*(x1491)*(x1493)))+(((IkReal(-1.00000000000000))*(x1491)*(x1492))));
evalcond[5]=((((x1499)*(x1505)))+(((sj2)*(x1493)))+(((sj2)*(x1492)))+(((IkReal(-1.00000000000000))*(r00)*(x1494)*(x1505)))+(((cj2)*(x1498)))+(((IkReal(-1.00000000000000))*(r10)*(x1494)*(x1503)))+(((x1497)*(x1503)))+(((IkReal(-1.00000000000000))*(x1491)*(x1496)))+(((r02)*(x1501)))+(((r12)*(sj0)*(x1489))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
if( IKabs(((IkReal(0.0946500000000000))*(r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(0.0946500000000000))*(r20))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x1508=((IkReal(1.00000000000000))*(IKatan2(((IkReal(0.0946500000000000))*(r21)), ((IkReal(0.0946500000000000))*(r20)))));
if( (((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))) < (IkReal)-0.00001 )
    continue;
if( (((((IKabs(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20))))))))):(IkReal)1.0e30))*(((pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1))))))) < -1-IKFAST_SINCOS_THRESH || (((((IKabs(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20))))))))):(IkReal)1.0e30))*(((pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1))))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1509=IKasin(((((IKabs(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20))))))))):(IkReal)1.0e30))*(((pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1)))))));
j5array[0]=((((IkReal(-1.00000000000000))*(x1508)))+(((IkReal(-1.00000000000000))*(x1509))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((IkReal(3.14159265358979))+(((IkReal(-1.00000000000000))*(x1508)))+(x1509));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[1];
IkReal x1510=((IkReal(1.00000000000000))*(sj3));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj3)*(sj1)*(sj2)))+(((cj1)*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(cj2)*(sj1)*(x1510)))+(((IkReal(-1.00000000000000))*(cj1)*(sj2)*(x1510)))+(((IkReal(-1.00000000000000))*(r21)*(IKcos(j5))))+(((IkReal(-1.00000000000000))*(r20)*(IKsin(j5)))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x1511=((IkReal(20000.0000000000))*(cj5));
IkReal x1512=((IkReal(20000.0000000000))*(sj5));
gconst0=IKsign(((((IkReal(-1.00000000000000))*(px)*(r11)*(x1511)))+(((py)*(r01)*(x1511)))+(((IkReal(-1.00000000000000))*(px)*(r10)*(x1512)))+(((py)*(r00)*(x1512)))));
IkReal x1513=((IkReal(1.00000000000000))*(px));
dummyeval[0]=((((cj5)*(py)*(r01)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1513)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1513)))+(((py)*(r00)*(sj5))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x1514=(cj5)*(cj5);
IkReal x1515=(sj5)*(sj5);
IkReal x1516=((IkReal(1.00000000000000))*(x1515));
IkReal x1517=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1518=((IkReal(1.00000000000000))*(x1514));
gconst1=IKsign(((((IkReal(-1.00000000000000))*(x1516)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x1518)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x1516)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1517)))+(((IkReal(-1.00000000000000))*(x1518)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1517)))));
IkReal x1519=(cj5)*(cj5);
IkReal x1520=(sj5)*(sj5);
IkReal x1521=((IkReal(1.00000000000000))*(x1520));
IkReal x1522=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1523=((IkReal(1.00000000000000))*(x1519));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1521)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1522)))+(((IkReal(-1.00000000000000))*(x1521)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(x1523)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1522)))+(((IkReal(-1.00000000000000))*(x1523)*((r11)*(r11)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1524=((sj2)*(sj3));
IkReal x1525=((cj5)*(r01));
IkReal x1526=((cj5)*(r11));
IkReal x1527=((r00)*(sj5));
IkReal x1528=((r10)*(sj5));
IkReal x1529=((sj1)*(x1527));
IkReal x1530=((IkReal(1.00000000000000))*(cj2)*(cj3));
IkReal x1531=((sj1)*(x1528));
IkReal x1532=((IkReal(1.00000000000000))*(cj1)*(cj2)*(sj3));
IkReal x1533=((IkReal(1.00000000000000))*(cj1)*(cj3)*(sj2));
if( IKabs(((gconst1)*(((((x1524)*(x1531)))+(((IkReal(-1.00000000000000))*(x1530)*(x1531)))+(((sj1)*(x1524)*(x1526)))+(((IkReal(-1.00000000000000))*(x1528)*(x1533)))+(((IkReal(-1.00000000000000))*(x1528)*(x1532)))+(((IkReal(-1.00000000000000))*(x1526)*(x1532)))+(((IkReal(-1.00000000000000))*(x1526)*(x1533)))+(((IkReal(-1.00000000000000))*(sj1)*(x1526)*(x1530))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x1529)*(x1530)))+(((x1524)*(x1529)))+(((IkReal(-1.00000000000000))*(sj1)*(x1525)*(x1530)))+(((IkReal(-1.00000000000000))*(x1525)*(x1532)))+(((IkReal(-1.00000000000000))*(x1525)*(x1533)))+(((sj1)*(x1524)*(x1525)))+(((IkReal(-1.00000000000000))*(x1527)*(x1532)))+(((IkReal(-1.00000000000000))*(x1527)*(x1533))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst1)*(((((x1524)*(x1531)))+(((IkReal(-1.00000000000000))*(x1530)*(x1531)))+(((sj1)*(x1524)*(x1526)))+(((IkReal(-1.00000000000000))*(x1528)*(x1533)))+(((IkReal(-1.00000000000000))*(x1528)*(x1532)))+(((IkReal(-1.00000000000000))*(x1526)*(x1532)))+(((IkReal(-1.00000000000000))*(x1526)*(x1533)))+(((IkReal(-1.00000000000000))*(sj1)*(x1526)*(x1530)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(x1529)*(x1530)))+(((x1524)*(x1529)))+(((IkReal(-1.00000000000000))*(sj1)*(x1525)*(x1530)))+(((IkReal(-1.00000000000000))*(x1525)*(x1532)))+(((IkReal(-1.00000000000000))*(x1525)*(x1533)))+(((sj1)*(x1524)*(x1525)))+(((IkReal(-1.00000000000000))*(x1527)*(x1532)))+(((IkReal(-1.00000000000000))*(x1527)*(x1533)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1534=IKcos(j0);
IkReal x1535=IKsin(j0);
IkReal x1536=((r00)*(sj5));
IkReal x1537=((IkReal(1.00000000000000))*(cj2));
IkReal x1538=((cj5)*(r11));
IkReal x1539=((sj1)*(sj2));
IkReal x1540=((r10)*(sj5));
IkReal x1541=((IkReal(0.0946500000000000))*(x1535));
IkReal x1542=((IkReal(0.0946500000000000))*(x1534));
IkReal x1543=((IkReal(1.00000000000000))*(x1535));
IkReal x1544=((IkReal(1.00000000000000))*(x1534));
IkReal x1545=((cj5)*(r01)*(x1535));
IkReal x1546=((cj5)*(x1542));
evalcond[0]=((((x1534)*(x1540)))+(((IkReal(-1.00000000000000))*(x1536)*(x1543)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1543)))+(((x1534)*(x1538))));
evalcond[1]=((IkReal(0.109150000000000))+(((x1536)*(x1541)))+(((IkReal(-1.00000000000000))*(x1540)*(x1542)))+(((IkReal(-1.00000000000000))*(py)*(x1544)))+(((px)*(x1535)))+(((cj5)*(r01)*(x1541)))+(((IkReal(-1.00000000000000))*(x1538)*(x1542))));
evalcond[2]=((((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(x1540)*(x1541)))+(((IkReal(-0.392250000000000))*(x1539)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)*(x1543)))+(((IkReal(-1.00000000000000))*(px)*(x1544)))+(((IkReal(-1.00000000000000))*(x1536)*(x1542)))+(((IkReal(-1.00000000000000))*(r01)*(x1546)))+(((IkReal(-1.00000000000000))*(x1538)*(x1541))));
evalcond[3]=((((sj3)*(x1539)))+(((IkReal(-1.00000000000000))*(cj3)*(sj1)*(x1537)))+(((cj5)*(r01)*(x1534)))+(((IkReal(-1.00000000000000))*(cj1)*(cj3)*(sj2)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)*(x1537)))+(((x1535)*(x1538)))+(((x1535)*(x1540)))+(((x1534)*(x1536))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x1547=((IkReal(1.00000000000000))*(sj0));
IkReal x1548=((cj5)*(r22));
IkReal x1549=((r21)*(sj5));
IkReal x1550=((IkReal(1.00000000000000))*(cj0));
IkReal x1551=((r22)*(sj5));
IkReal x1552=((cj5)*(r20));
gconst3=IKsign(((((r01)*(sj0)*(x1551)))+(((IkReal(-1.00000000000000))*(r02)*(x1547)*(x1549)))+(((cj0)*(r12)*(x1549)))+(((IkReal(-1.00000000000000))*(r00)*(x1547)*(x1548)))+(((IkReal(-1.00000000000000))*(r12)*(x1550)*(x1552)))+(((r02)*(sj0)*(x1552)))+(((IkReal(-1.00000000000000))*(r11)*(x1550)*(x1551)))+(((cj0)*(r10)*(x1548)))));
IkReal x1553=((IkReal(1.00000000000000))*(sj0));
IkReal x1554=((cj5)*(r22));
IkReal x1555=((r21)*(sj5));
IkReal x1556=((IkReal(1.00000000000000))*(cj0));
IkReal x1557=((r22)*(sj5));
IkReal x1558=((cj5)*(r20));
dummyeval[0]=((((r01)*(sj0)*(x1557)))+(((IkReal(-1.00000000000000))*(r02)*(x1553)*(x1555)))+(((IkReal(-1.00000000000000))*(r12)*(x1556)*(x1558)))+(((IkReal(-1.00000000000000))*(r11)*(x1556)*(x1557)))+(((cj0)*(r12)*(x1555)))+(((IkReal(-1.00000000000000))*(r00)*(x1553)*(x1554)))+(((r02)*(sj0)*(x1558)))+(((cj0)*(r10)*(x1554))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1559=((cj3)*(sj2));
IkReal x1560=((cj2)*(cj3));
IkReal x1561=((cj2)*(sj3));
IkReal x1562=((sj2)*(sj3));
IkReal x1563=((r21)*(sj5));
IkReal x1564=((IkReal(1.00000000000000))*(cj1));
IkReal x1565=((IkReal(1.00000000000000))*(sj1));
IkReal x1566=((r22)*(x1564));
IkReal x1567=((cj5)*(r20)*(sj1));
IkReal x1568=((cj1)*(cj5)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x1559)*(x1566)))+(((IkReal(-1.00000000000000))*(r22)*(x1560)*(x1565)))+(((r22)*(sj1)*(x1562)))+(((IkReal(-1.00000000000000))*(x1561)*(x1566))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((x1560)*(x1567)))+(((IkReal(-1.00000000000000))*(x1561)*(x1563)*(x1564)))+(((IkReal(-1.00000000000000))*(x1560)*(x1563)*(x1565)))+(((sj1)*(x1562)*(x1563)))+(((x1561)*(x1568)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1562)*(x1565)))+(((x1559)*(x1568)))+(((IkReal(-1.00000000000000))*(x1559)*(x1563)*(x1564))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(x1559)*(x1566)))+(((IkReal(-1.00000000000000))*(r22)*(x1560)*(x1565)))+(((r22)*(sj1)*(x1562)))+(((IkReal(-1.00000000000000))*(x1561)*(x1566)))))), ((gconst4)*(((((x1560)*(x1567)))+(((IkReal(-1.00000000000000))*(x1561)*(x1563)*(x1564)))+(((IkReal(-1.00000000000000))*(x1560)*(x1563)*(x1565)))+(((sj1)*(x1562)*(x1563)))+(((x1561)*(x1568)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1562)*(x1565)))+(((x1559)*(x1568)))+(((IkReal(-1.00000000000000))*(x1559)*(x1563)*(x1564)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1569=IKsin(j4);
IkReal x1570=IKcos(j4);
IkReal x1571=((IkReal(1.00000000000000))*(cj2));
IkReal x1572=((cj3)*(sj1));
IkReal x1573=((cj1)*(sj3));
IkReal x1574=((IkReal(1.00000000000000))*(cj5));
IkReal x1575=((IkReal(1.00000000000000))*(r01));
IkReal x1576=((cj1)*(cj3));
IkReal x1577=((r11)*(sj5));
IkReal x1578=((sj1)*(sj3));
IkReal x1579=((r01)*(sj5));
IkReal x1580=((r21)*(sj5));
IkReal x1581=((cj0)*(x1569));
IkReal x1582=((cj5)*(x1569));
IkReal x1583=((sj0)*(x1570));
IkReal x1584=((IkReal(1.00000000000000))*(x1569));
IkReal x1585=((cj0)*(x1570));
IkReal x1586=((sj0)*(sj5)*(x1569));
IkReal x1587=((IkReal(1.00000000000000))*(x1585));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1580)*(x1584)))+(((r20)*(x1582)))+(((r22)*(x1570))));
evalcond[1]=((((cj5)*(r00)*(x1583)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1584)))+(((IkReal(-1.00000000000000))*(r10)*(x1574)*(x1585)))+(((r12)*(x1581)))+(((IkReal(-1.00000000000000))*(sj5)*(x1575)*(x1583)))+(((x1577)*(x1585))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1569)*(x1574)))+(((IkReal(-1.00000000000000))*(r00)*(x1574)*(x1581)))+(((IkReal(-1.00000000000000))*(r02)*(x1587)))+(((x1579)*(x1581)))+(((sj0)*(x1569)*(x1577)))+(((IkReal(-1.00000000000000))*(r12)*(x1583))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x1574)*(x1581)))+(((r00)*(sj0)*(x1582)))+(((r02)*(x1583)))+(((x1577)*(x1581)))+(((IkReal(-1.00000000000000))*(r12)*(x1587)))+(((IkReal(-1.00000000000000))*(x1575)*(x1586))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj2)*(x1576)))+(((IkReal(-1.00000000000000))*(x1571)*(x1572)))+(((IkReal(-1.00000000000000))*(x1571)*(x1573)))+(((cj5)*(r20)*(x1570)))+(((IkReal(-1.00000000000000))*(x1570)*(x1580)))+(((IkReal(-1.00000000000000))*(r22)*(x1584)))+(((sj2)*(x1578))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r10)*(x1574)*(x1583)))+(((IkReal(-1.00000000000000))*(x1571)*(x1576)))+(((IkReal(-1.00000000000000))*(r00)*(x1574)*(x1585)))+(((r12)*(sj0)*(x1569)))+(((cj2)*(x1578)))+(((r02)*(x1581)))+(((x1577)*(x1583)))+(((x1579)*(x1585)))+(((sj2)*(x1572)))+(((sj2)*(x1573))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst3)*(r22))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(r22)), ((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1588=IKsin(j4);
IkReal x1589=IKcos(j4);
IkReal x1590=((IkReal(1.00000000000000))*(cj2));
IkReal x1591=((cj3)*(sj1));
IkReal x1592=((cj1)*(sj3));
IkReal x1593=((IkReal(1.00000000000000))*(cj5));
IkReal x1594=((IkReal(1.00000000000000))*(r01));
IkReal x1595=((cj1)*(cj3));
IkReal x1596=((r11)*(sj5));
IkReal x1597=((sj1)*(sj3));
IkReal x1598=((r01)*(sj5));
IkReal x1599=((r21)*(sj5));
IkReal x1600=((cj0)*(x1588));
IkReal x1601=((cj5)*(x1588));
IkReal x1602=((sj0)*(x1589));
IkReal x1603=((IkReal(1.00000000000000))*(x1588));
IkReal x1604=((cj0)*(x1589));
IkReal x1605=((sj0)*(sj5)*(x1588));
IkReal x1606=((IkReal(1.00000000000000))*(x1604));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1599)*(x1603)))+(((r22)*(x1589)))+(((r20)*(x1601))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r10)*(x1593)*(x1604)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1603)))+(((r12)*(x1600)))+(((cj5)*(r00)*(x1602)))+(((x1596)*(x1604)))+(((IkReal(-1.00000000000000))*(sj5)*(x1594)*(x1602))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r12)*(x1602)))+(((IkReal(-1.00000000000000))*(r00)*(x1593)*(x1600)))+(((sj0)*(x1588)*(x1596)))+(((x1598)*(x1600)))+(((IkReal(-1.00000000000000))*(r02)*(x1606)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1588)*(x1593))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r10)*(x1593)*(x1600)))+(((IkReal(-1.00000000000000))*(x1594)*(x1605)))+(((r00)*(sj0)*(x1601)))+(((x1596)*(x1600)))+(((IkReal(-1.00000000000000))*(r12)*(x1606)))+(((r02)*(x1602))));
evalcond[4]=((((IkReal(-1.00000000000000))*(x1589)*(x1599)))+(((sj2)*(x1597)))+(((cj5)*(r20)*(x1589)))+(((IkReal(-1.00000000000000))*(r22)*(x1603)))+(((IkReal(-1.00000000000000))*(x1590)*(x1592)))+(((IkReal(-1.00000000000000))*(x1590)*(x1591)))+(((IkReal(-1.00000000000000))*(sj2)*(x1595))));
evalcond[5]=((((sj2)*(x1591)))+(((sj2)*(x1592)))+(((IkReal(-1.00000000000000))*(r10)*(x1593)*(x1602)))+(((r12)*(sj0)*(x1588)))+(((cj2)*(x1597)))+(((IkReal(-1.00000000000000))*(r00)*(x1593)*(x1604)))+(((x1598)*(x1604)))+(((IkReal(-1.00000000000000))*(x1590)*(x1595)))+(((x1596)*(x1602)))+(((r02)*(x1600))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1607=((cj3)*(sj2));
IkReal x1608=((cj2)*(sj3));
IkReal x1609=((cj5)*(r20));
IkReal x1610=((r21)*(sj5));
IkReal x1611=((IkReal(1.00000000000000))*(cj1));
IkReal x1612=((r22)*(x1611));
IkReal x1613=((sj1)*(sj2)*(sj3));
IkReal x1614=((cj2)*(cj3)*(sj1));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(r22)*(x1614)))+(((IkReal(-1.00000000000000))*(x1608)*(x1612)))+(((r22)*(x1613)))+(((IkReal(-1.00000000000000))*(x1607)*(x1612))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x1609)*(x1613)))+(((IkReal(-1.00000000000000))*(x1607)*(x1610)*(x1611)))+(((IkReal(-1.00000000000000))*(x1610)*(x1614)))+(((IkReal(-1.00000000000000))*(x1608)*(x1610)*(x1611)))+(((x1609)*(x1614)))+(((cj1)*(x1607)*(x1609)))+(((cj1)*(x1608)*(x1609)))+(((x1610)*(x1613))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst2)*(((((IkReal(-1.00000000000000))*(r22)*(x1614)))+(((IkReal(-1.00000000000000))*(x1608)*(x1612)))+(((r22)*(x1613)))+(((IkReal(-1.00000000000000))*(x1607)*(x1612)))))), ((gconst2)*(((((IkReal(-1.00000000000000))*(x1609)*(x1613)))+(((IkReal(-1.00000000000000))*(x1607)*(x1610)*(x1611)))+(((IkReal(-1.00000000000000))*(x1610)*(x1614)))+(((IkReal(-1.00000000000000))*(x1608)*(x1610)*(x1611)))+(((x1609)*(x1614)))+(((cj1)*(x1607)*(x1609)))+(((cj1)*(x1608)*(x1609)))+(((x1610)*(x1613)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[2];
IkReal x1615=IKsin(j4);
IkReal x1616=IKcos(j4);
IkReal x1617=((IkReal(1.00000000000000))*(cj1));
IkReal x1618=((cj5)*(r20));
IkReal x1619=((IkReal(1.00000000000000))*(r21)*(sj5));
evalcond[0]=((((x1615)*(x1618)))+(((r22)*(x1616)))+(((IkReal(-1.00000000000000))*(x1615)*(x1619))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1616)*(x1619)))+(((IkReal(-1.00000000000000))*(r22)*(x1615)))+(((IkReal(-1.00000000000000))*(cj3)*(sj2)*(x1617)))+(((IkReal(-1.00000000000000))*(cj2)*(sj3)*(x1617)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3)*(sj1)))+(((x1616)*(x1618)))+(((sj1)*(sj2)*(sj3))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst5;
IkReal x1620=((IkReal(20000.0000000000))*(cj5));
IkReal x1621=((IkReal(20000.0000000000))*(sj5));
gconst5=IKsign(((((IkReal(-1.00000000000000))*(px)*(r10)*(x1621)))+(((IkReal(-1.00000000000000))*(px)*(r11)*(x1620)))+(((py)*(r00)*(x1621)))+(((py)*(r01)*(x1620)))));
IkReal x1622=((IkReal(1.00000000000000))*(px));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1622)))+(((cj5)*(py)*(r01)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1622)))+(((py)*(r00)*(sj5))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
IkReal x1623=(sj5)*(sj5);
IkReal x1624=(cj5)*(cj5);
IkReal x1625=((cj4)*(sj5));
IkReal x1626=((IkReal(1.00000000000000))*(r02));
IkReal x1627=((r01)*(r10));
IkReal x1628=((cj4)*(cj5));
IkReal x1629=((sj4)*(x1624));
IkReal x1630=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1631=((sj4)*(x1623));
gconst6=IKsign(((((x1627)*(x1631)))+(((IkReal(-1.00000000000000))*(r10)*(x1625)*(x1626)))+(((x1627)*(x1629)))+(((r00)*(r12)*(x1625)))+(((IkReal(-1.00000000000000))*(r11)*(x1626)*(x1628)))+(((r01)*(r12)*(x1628)))+(((IkReal(-1.00000000000000))*(x1629)*(x1630)))+(((IkReal(-1.00000000000000))*(x1630)*(x1631)))));
IkReal x1632=(sj5)*(sj5);
IkReal x1633=(cj5)*(cj5);
IkReal x1634=((cj4)*(sj5));
IkReal x1635=((IkReal(1.00000000000000))*(r02));
IkReal x1636=((r01)*(r10));
IkReal x1637=((cj4)*(cj5));
IkReal x1638=((sj4)*(x1633));
IkReal x1639=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1640=((sj4)*(x1632));
dummyeval[0]=((((x1636)*(x1640)))+(((x1636)*(x1638)))+(((r01)*(r12)*(x1637)))+(((IkReal(-1.00000000000000))*(r10)*(x1634)*(x1635)))+(((IkReal(-1.00000000000000))*(x1638)*(x1639)))+(((IkReal(-1.00000000000000))*(x1639)*(x1640)))+(((r00)*(r12)*(x1634)))+(((IkReal(-1.00000000000000))*(r11)*(x1635)*(x1637))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst6)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((r00)*(sj5)))+(((cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst6)*(((((cj5)*(r11)))+(((r10)*(sj5)))))), ((gconst6)*(((((r00)*(sj5)))+(((cj5)*(r01)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x1641=IKcos(j0);
IkReal x1642=IKsin(j0);
IkReal x1643=((IkReal(1.00000000000000))*(cj5));
IkReal x1644=((IkReal(0.0946500000000000))*(sj5));
IkReal x1645=((IkReal(1.00000000000000))*(cj2));
IkReal x1646=((cj3)*(sj1));
IkReal x1647=((cj1)*(sj3));
IkReal x1648=((IkReal(0.0946500000000000))*(cj5));
IkReal x1649=((r02)*(sj4));
IkReal x1650=((cj1)*(cj3));
IkReal x1651=((sj1)*(sj2));
IkReal x1652=((sj4)*(sj5));
IkReal x1653=((IkReal(1.00000000000000))*(sj5));
IkReal x1654=((cj4)*(r02));
IkReal x1655=((cj4)*(r12));
IkReal x1656=((cj4)*(sj5));
IkReal x1657=((r12)*(sj4));
IkReal x1658=((r01)*(x1642));
IkReal x1659=((r00)*(x1641));
IkReal x1660=((r00)*(x1642));
IkReal x1661=((r11)*(x1641));
IkReal x1662=((r01)*(x1641));
IkReal x1663=((r11)*(x1642));
IkReal x1664=((r10)*(x1642));
IkReal x1665=((IkReal(1.00000000000000))*(x1642));
IkReal x1666=((r10)*(x1641));
IkReal x1667=((IkReal(1.00000000000000))*(x1641));
evalcond[0]=((((cj5)*(x1661)))+(((IkReal(-1.00000000000000))*(x1653)*(x1660)))+(((IkReal(-1.00000000000000))*(x1643)*(x1658)))+(((sj5)*(x1666))));
evalcond[1]=((IkReal(0.109150000000000))+(((IkReal(-1.00000000000000))*(x1644)*(x1666)))+(((IkReal(-1.00000000000000))*(py)*(x1667)))+(((x1648)*(x1658)))+(((px)*(x1642)))+(((x1644)*(x1660)))+(((IkReal(-1.00000000000000))*(x1648)*(x1661))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj4)*(x1643)*(x1666)))+(((IkReal(-1.00000000000000))*(cj4)*(x1653)*(x1658)))+(((x1641)*(x1657)))+(((cj4)*(cj5)*(x1660)))+(((IkReal(-1.00000000000000))*(x1649)*(x1665)))+(((x1656)*(x1661))));
evalcond[3]=((((IkReal(-1.00000000000000))*(sj4)*(x1643)*(x1659)))+(((IkReal(-1.00000000000000))*(x1654)*(x1667)))+(((IkReal(-1.00000000000000))*(sj4)*(x1643)*(x1664)))+(((IkReal(-1.00000000000000))*(x1655)*(x1665)))+(((x1652)*(x1663)))+(((x1652)*(x1662))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(sj4)*(x1643)*(x1666)))+(((IkReal(-1.00000000000000))*(x1655)*(x1667)))+(((cj5)*(sj4)*(x1660)))+(((IkReal(-1.00000000000000))*(x1652)*(x1658)))+(((x1652)*(x1661)))+(((x1642)*(x1654))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1644)*(x1659)))+(((IkReal(-1.00000000000000))*(x1644)*(x1664)))+(((IkReal(-1.00000000000000))*(py)*(x1665)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(px)*(x1667)))+(((IkReal(-0.392250000000000))*(x1651)))+(((IkReal(-1.00000000000000))*(x1648)*(x1662)))+(((IkReal(-1.00000000000000))*(x1648)*(x1663))));
evalcond[6]=((((cj5)*(x1663)))+(((cj5)*(x1662)))+(((IkReal(-1.00000000000000))*(x1645)*(x1646)))+(((IkReal(-1.00000000000000))*(x1645)*(x1647)))+(((sj5)*(x1659)))+(((sj5)*(x1664)))+(((sj3)*(x1651)))+(((IkReal(-1.00000000000000))*(sj2)*(x1650))));
evalcond[7]=((((IkReal(-1.00000000000000))*(cj4)*(x1643)*(x1659)))+(((IkReal(-1.00000000000000))*(cj4)*(x1643)*(x1664)))+(((sj2)*(x1647)))+(((sj2)*(x1646)))+(((IkReal(-1.00000000000000))*(x1645)*(x1650)))+(((x1641)*(x1649)))+(((x1642)*(x1657)))+(((cj2)*(sj1)*(sj3)))+(((x1656)*(x1663)))+(((x1656)*(x1662))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1668=((IkReal(2183.00000000000))*(sj5));
IkReal x1669=((IkReal(2183.00000000000))*(cj5));
if( IKabs(((gconst5)*(((((r10)*(x1668)))+(((r11)*(x1669))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((r00)*(x1668)))+(((r01)*(x1669))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst5)*(((((r10)*(x1668)))+(((r11)*(x1669)))))), ((gconst5)*(((((r00)*(x1668)))+(((r01)*(x1669)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x1670=IKcos(j0);
IkReal x1671=IKsin(j0);
IkReal x1672=((IkReal(1.00000000000000))*(cj5));
IkReal x1673=((IkReal(0.0946500000000000))*(sj5));
IkReal x1674=((IkReal(1.00000000000000))*(cj2));
IkReal x1675=((cj3)*(sj1));
IkReal x1676=((cj1)*(sj3));
IkReal x1677=((IkReal(0.0946500000000000))*(cj5));
IkReal x1678=((r02)*(sj4));
IkReal x1679=((cj1)*(cj3));
IkReal x1680=((sj1)*(sj2));
IkReal x1681=((sj4)*(sj5));
IkReal x1682=((IkReal(1.00000000000000))*(sj5));
IkReal x1683=((cj4)*(r02));
IkReal x1684=((cj4)*(r12));
IkReal x1685=((cj4)*(sj5));
IkReal x1686=((r12)*(sj4));
IkReal x1687=((r01)*(x1671));
IkReal x1688=((r00)*(x1670));
IkReal x1689=((r00)*(x1671));
IkReal x1690=((r11)*(x1670));
IkReal x1691=((r01)*(x1670));
IkReal x1692=((r11)*(x1671));
IkReal x1693=((r10)*(x1671));
IkReal x1694=((IkReal(1.00000000000000))*(x1671));
IkReal x1695=((r10)*(x1670));
IkReal x1696=((IkReal(1.00000000000000))*(x1670));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1682)*(x1689)))+(((IkReal(-1.00000000000000))*(x1672)*(x1687)))+(((cj5)*(x1690)))+(((sj5)*(x1695))));
evalcond[1]=((IkReal(0.109150000000000))+(((x1673)*(x1689)))+(((IkReal(-1.00000000000000))*(py)*(x1696)))+(((x1677)*(x1687)))+(((px)*(x1671)))+(((IkReal(-1.00000000000000))*(x1673)*(x1695)))+(((IkReal(-1.00000000000000))*(x1677)*(x1690))));
evalcond[2]=((((IkReal(-1.00000000000000))*(cj4)*(x1682)*(x1687)))+(((x1670)*(x1686)))+(((cj4)*(cj5)*(x1689)))+(((IkReal(-1.00000000000000))*(x1678)*(x1694)))+(((x1685)*(x1690)))+(((IkReal(-1.00000000000000))*(cj4)*(x1672)*(x1695))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1684)*(x1694)))+(((IkReal(-1.00000000000000))*(sj4)*(x1672)*(x1688)))+(((IkReal(-1.00000000000000))*(x1683)*(x1696)))+(((IkReal(-1.00000000000000))*(sj4)*(x1672)*(x1693)))+(((x1681)*(x1692)))+(((x1681)*(x1691))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1684)*(x1696)))+(((x1671)*(x1683)))+(((IkReal(-1.00000000000000))*(x1681)*(x1687)))+(((IkReal(-1.00000000000000))*(sj4)*(x1672)*(x1695)))+(((cj5)*(sj4)*(x1689)))+(((x1681)*(x1690))));
evalcond[5]=((((IkReal(-1.00000000000000))*(py)*(x1694)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1673)*(x1688)))+(((IkReal(-1.00000000000000))*(x1673)*(x1693)))+(((IkReal(-1.00000000000000))*(x1677)*(x1692)))+(((IkReal(-1.00000000000000))*(x1677)*(x1691)))+(((IkReal(-1.00000000000000))*(px)*(x1696)))+(((IkReal(-0.392250000000000))*(x1680))));
evalcond[6]=((((sj5)*(x1688)))+(((cj5)*(x1691)))+(((cj5)*(x1692)))+(((IkReal(-1.00000000000000))*(x1674)*(x1675)))+(((IkReal(-1.00000000000000))*(x1674)*(x1676)))+(((sj5)*(x1693)))+(((sj3)*(x1680)))+(((IkReal(-1.00000000000000))*(sj2)*(x1679))));
evalcond[7]=((((x1671)*(x1686)))+(((sj2)*(x1676)))+(((sj2)*(x1675)))+(((x1685)*(x1692)))+(((x1685)*(x1691)))+(((IkReal(-1.00000000000000))*(cj4)*(x1672)*(x1693)))+(((IkReal(-1.00000000000000))*(x1674)*(x1679)))+(((cj2)*(sj1)*(sj3)))+(((IkReal(-1.00000000000000))*(cj4)*(x1672)*(x1688)))+(((x1670)*(x1678))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1697=((IkReal(2183.00000000000))*(sj5));
IkReal x1698=((IkReal(2183.00000000000))*(cj5));
if( IKabs(((gconst0)*(((((r10)*(x1697)))+(((r11)*(x1698))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((r01)*(x1698)))+(((r00)*(x1697))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst0)*(((((r10)*(x1697)))+(((r11)*(x1698)))))), ((gconst0)*(((((r01)*(x1698)))+(((r00)*(x1697)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1699=IKcos(j0);
IkReal x1700=IKsin(j0);
IkReal x1701=((r00)*(sj5));
IkReal x1702=((IkReal(1.00000000000000))*(cj2));
IkReal x1703=((cj5)*(r11));
IkReal x1704=((sj1)*(sj2));
IkReal x1705=((r10)*(sj5));
IkReal x1706=((IkReal(0.0946500000000000))*(x1700));
IkReal x1707=((IkReal(0.0946500000000000))*(x1699));
IkReal x1708=((IkReal(1.00000000000000))*(x1700));
IkReal x1709=((IkReal(1.00000000000000))*(x1699));
IkReal x1710=((cj5)*(r01)*(x1700));
IkReal x1711=((cj5)*(x1707));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1701)*(x1708)))+(((x1699)*(x1703)))+(((x1699)*(x1705)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1708))));
evalcond[1]=((IkReal(0.109150000000000))+(((IkReal(-1.00000000000000))*(py)*(x1709)))+(((px)*(x1700)))+(((IkReal(-1.00000000000000))*(x1705)*(x1707)))+(((x1701)*(x1706)))+(((cj5)*(r01)*(x1706)))+(((IkReal(-1.00000000000000))*(x1703)*(x1707))));
evalcond[2]=((((IkReal(-1.00000000000000))*(py)*(x1708)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(-1.00000000000000))*(px)*(x1709)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1705)*(x1706)))+(((IkReal(-1.00000000000000))*(x1703)*(x1706)))+(((IkReal(-0.392250000000000))*(x1704)))+(((IkReal(-1.00000000000000))*(x1701)*(x1707)))+(((IkReal(-1.00000000000000))*(r01)*(x1711))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj3)*(sj1)*(x1702)))+(((cj5)*(r01)*(x1699)))+(((IkReal(-1.00000000000000))*(cj1)*(cj3)*(sj2)))+(((x1700)*(x1705)))+(((x1700)*(x1703)))+(((sj3)*(x1704)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)*(x1702)))+(((x1699)*(x1701))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x1712=((IkReal(1.00000000000000))*(sj0));
IkReal x1713=((cj5)*(r22));
IkReal x1714=((r21)*(sj5));
IkReal x1715=((IkReal(1.00000000000000))*(cj0));
IkReal x1716=((r22)*(sj5));
IkReal x1717=((cj5)*(r20));
gconst3=IKsign(((((cj0)*(r12)*(x1714)))+(((r01)*(sj0)*(x1716)))+(((cj0)*(r10)*(x1713)))+(((IkReal(-1.00000000000000))*(r02)*(x1712)*(x1714)))+(((IkReal(-1.00000000000000))*(r11)*(x1715)*(x1716)))+(((IkReal(-1.00000000000000))*(r00)*(x1712)*(x1713)))+(((r02)*(sj0)*(x1717)))+(((IkReal(-1.00000000000000))*(r12)*(x1715)*(x1717)))));
IkReal x1718=((IkReal(1.00000000000000))*(sj0));
IkReal x1719=((cj5)*(r22));
IkReal x1720=((r21)*(sj5));
IkReal x1721=((IkReal(1.00000000000000))*(cj0));
IkReal x1722=((r22)*(sj5));
IkReal x1723=((cj5)*(r20));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r00)*(x1718)*(x1719)))+(((r02)*(sj0)*(x1723)))+(((cj0)*(r10)*(x1719)))+(((IkReal(-1.00000000000000))*(r12)*(x1721)*(x1723)))+(((IkReal(-1.00000000000000))*(r02)*(x1718)*(x1720)))+(((r01)*(sj0)*(x1722)))+(((cj0)*(r12)*(x1720)))+(((IkReal(-1.00000000000000))*(r11)*(x1721)*(x1722))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1724=((cj3)*(sj2));
IkReal x1725=((cj2)*(cj3));
IkReal x1726=((cj2)*(sj3));
IkReal x1727=((sj2)*(sj3));
IkReal x1728=((r21)*(sj5));
IkReal x1729=((IkReal(1.00000000000000))*(cj1));
IkReal x1730=((IkReal(1.00000000000000))*(sj1));
IkReal x1731=((r22)*(x1729));
IkReal x1732=((cj5)*(r20)*(sj1));
IkReal x1733=((cj1)*(cj5)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x1726)*(x1731)))+(((IkReal(-1.00000000000000))*(x1724)*(x1731)))+(((IkReal(-1.00000000000000))*(r22)*(x1725)*(x1730)))+(((r22)*(sj1)*(x1727))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((x1724)*(x1733)))+(((x1725)*(x1732)))+(((x1726)*(x1733)))+(((IkReal(-1.00000000000000))*(x1726)*(x1728)*(x1729)))+(((IkReal(-1.00000000000000))*(x1724)*(x1728)*(x1729)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1727)*(x1730)))+(((sj1)*(x1727)*(x1728)))+(((IkReal(-1.00000000000000))*(x1725)*(x1728)*(x1730))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(x1726)*(x1731)))+(((IkReal(-1.00000000000000))*(x1724)*(x1731)))+(((IkReal(-1.00000000000000))*(r22)*(x1725)*(x1730)))+(((r22)*(sj1)*(x1727)))))), ((gconst4)*(((((x1724)*(x1733)))+(((x1725)*(x1732)))+(((x1726)*(x1733)))+(((IkReal(-1.00000000000000))*(x1726)*(x1728)*(x1729)))+(((IkReal(-1.00000000000000))*(x1724)*(x1728)*(x1729)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1727)*(x1730)))+(((sj1)*(x1727)*(x1728)))+(((IkReal(-1.00000000000000))*(x1725)*(x1728)*(x1730)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1734=IKsin(j4);
IkReal x1735=IKcos(j4);
IkReal x1736=((IkReal(1.00000000000000))*(cj2));
IkReal x1737=((cj3)*(sj1));
IkReal x1738=((cj1)*(sj3));
IkReal x1739=((IkReal(1.00000000000000))*(cj5));
IkReal x1740=((IkReal(1.00000000000000))*(r01));
IkReal x1741=((cj1)*(cj3));
IkReal x1742=((r11)*(sj5));
IkReal x1743=((sj1)*(sj3));
IkReal x1744=((r01)*(sj5));
IkReal x1745=((r21)*(sj5));
IkReal x1746=((cj0)*(x1734));
IkReal x1747=((cj5)*(x1734));
IkReal x1748=((sj0)*(x1735));
IkReal x1749=((IkReal(1.00000000000000))*(x1734));
IkReal x1750=((cj0)*(x1735));
IkReal x1751=((sj0)*(sj5)*(x1734));
IkReal x1752=((IkReal(1.00000000000000))*(x1750));
evalcond[0]=((((r22)*(x1735)))+(((IkReal(-1.00000000000000))*(x1745)*(x1749)))+(((r20)*(x1747))));
evalcond[1]=((((r12)*(x1746)))+(((IkReal(-1.00000000000000))*(sj5)*(x1740)*(x1748)))+(((IkReal(-1.00000000000000))*(r10)*(x1739)*(x1750)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1749)))+(((x1742)*(x1750)))+(((cj5)*(r00)*(x1748))));
evalcond[2]=((((x1744)*(x1746)))+(((IkReal(-1.00000000000000))*(r12)*(x1748)))+(((IkReal(-1.00000000000000))*(r00)*(x1739)*(x1746)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1734)*(x1739)))+(((IkReal(-1.00000000000000))*(r02)*(x1752)))+(((sj0)*(x1734)*(x1742))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1740)*(x1751)))+(((IkReal(-1.00000000000000))*(r12)*(x1752)))+(((r02)*(x1748)))+(((IkReal(-1.00000000000000))*(r10)*(x1739)*(x1746)))+(((x1742)*(x1746)))+(((r00)*(sj0)*(x1747))));
evalcond[4]=((((cj5)*(r20)*(x1735)))+(((IkReal(-1.00000000000000))*(x1735)*(x1745)))+(((IkReal(-1.00000000000000))*(sj2)*(x1741)))+(((IkReal(-1.00000000000000))*(r22)*(x1749)))+(((IkReal(-1.00000000000000))*(x1736)*(x1738)))+(((IkReal(-1.00000000000000))*(x1736)*(x1737)))+(((sj2)*(x1743))));
evalcond[5]=((((x1744)*(x1750)))+(((IkReal(-1.00000000000000))*(x1736)*(x1741)))+(((r02)*(x1746)))+(((cj2)*(x1743)))+(((IkReal(-1.00000000000000))*(r00)*(x1739)*(x1750)))+(((IkReal(-1.00000000000000))*(r10)*(x1739)*(x1748)))+(((x1742)*(x1748)))+(((r12)*(sj0)*(x1734)))+(((sj2)*(x1738)))+(((sj2)*(x1737))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst3)*(r22))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(r22)), ((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1753=IKsin(j4);
IkReal x1754=IKcos(j4);
IkReal x1755=((IkReal(1.00000000000000))*(cj2));
IkReal x1756=((cj3)*(sj1));
IkReal x1757=((cj1)*(sj3));
IkReal x1758=((IkReal(1.00000000000000))*(cj5));
IkReal x1759=((IkReal(1.00000000000000))*(r01));
IkReal x1760=((cj1)*(cj3));
IkReal x1761=((r11)*(sj5));
IkReal x1762=((sj1)*(sj3));
IkReal x1763=((r01)*(sj5));
IkReal x1764=((r21)*(sj5));
IkReal x1765=((cj0)*(x1753));
IkReal x1766=((cj5)*(x1753));
IkReal x1767=((sj0)*(x1754));
IkReal x1768=((IkReal(1.00000000000000))*(x1753));
IkReal x1769=((cj0)*(x1754));
IkReal x1770=((sj0)*(sj5)*(x1753));
IkReal x1771=((IkReal(1.00000000000000))*(x1769));
evalcond[0]=((((r20)*(x1766)))+(((r22)*(x1754)))+(((IkReal(-1.00000000000000))*(x1764)*(x1768))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1768)))+(((IkReal(-1.00000000000000))*(sj5)*(x1759)*(x1767)))+(((cj5)*(r00)*(x1767)))+(((r12)*(x1765)))+(((x1761)*(x1769)))+(((IkReal(-1.00000000000000))*(r10)*(x1758)*(x1769))));
evalcond[2]=((((sj0)*(x1753)*(x1761)))+(((IkReal(-1.00000000000000))*(r00)*(x1758)*(x1765)))+(((IkReal(-1.00000000000000))*(r02)*(x1771)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1753)*(x1758)))+(((IkReal(-1.00000000000000))*(r12)*(x1767)))+(((x1763)*(x1765))));
evalcond[3]=((IkReal(1.00000000000000))+(((r00)*(sj0)*(x1766)))+(((IkReal(-1.00000000000000))*(x1759)*(x1770)))+(((r02)*(x1767)))+(((x1761)*(x1765)))+(((IkReal(-1.00000000000000))*(r12)*(x1771)))+(((IkReal(-1.00000000000000))*(r10)*(x1758)*(x1765))));
evalcond[4]=((((sj2)*(x1762)))+(((IkReal(-1.00000000000000))*(x1754)*(x1764)))+(((IkReal(-1.00000000000000))*(sj2)*(x1760)))+(((IkReal(-1.00000000000000))*(r22)*(x1768)))+(((cj5)*(r20)*(x1754)))+(((IkReal(-1.00000000000000))*(x1755)*(x1757)))+(((IkReal(-1.00000000000000))*(x1755)*(x1756))));
evalcond[5]=((((IkReal(-1.00000000000000))*(r00)*(x1758)*(x1769)))+(((IkReal(-1.00000000000000))*(x1755)*(x1760)))+(((r02)*(x1765)))+(((sj2)*(x1757)))+(((sj2)*(x1756)))+(((r12)*(sj0)*(x1753)))+(((cj2)*(x1762)))+(((x1761)*(x1767)))+(((IkReal(-1.00000000000000))*(r10)*(x1758)*(x1767)))+(((x1763)*(x1769))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j5array[2], cj5array[2], sj5array[2];
bool j5valid[2]={false};
_nj5 = 2;
if( IKabs(((IkReal(0.0946500000000000))*(r21))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((IkReal(0.0946500000000000))*(r20))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
IkReal x1772=((IkReal(1.00000000000000))*(IKatan2(((IkReal(0.0946500000000000))*(r21)), ((IkReal(0.0946500000000000))*(r20)))));
if( (((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))) < (IkReal)-0.00001 )
    continue;
if( (((((IKabs(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20))))))))):(IkReal)1.0e30))*(((pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1))))))) < -1-IKFAST_SINCOS_THRESH || (((((IKabs(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20))))))))):(IkReal)1.0e30))*(((pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1))))))) > 1+IKFAST_SINCOS_THRESH )
    continue;
IkReal x1773=IKasin(((((IKabs(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20)))))))) != 0)?((IkReal)1/(IKabs(IKsqrt(((((IkReal(0.00895862250000000))*((r21)*(r21))))+(((IkReal(0.00895862250000000))*((r20)*(r20))))))))):(IkReal)1.0e30))*(((pz)+(((IkReal(0.392250000000000))*(cj1)*(sj2)))+(((IkReal(0.425000000000000))*(sj1)))+(((IkReal(0.392250000000000))*(cj2)*(sj1)))))));
j5array[0]=((((IkReal(-1.00000000000000))*(x1773)))+(((IkReal(-1.00000000000000))*(x1772))));
sj5array[0]=IKsin(j5array[0]);
cj5array[0]=IKcos(j5array[0]);
j5array[1]=((IkReal(3.14159265358979))+(x1773)+(((IkReal(-1.00000000000000))*(x1772))));
sj5array[1]=IKsin(j5array[1]);
cj5array[1]=IKcos(j5array[1]);
if( j5array[0] > IKPI )
{
    j5array[0]-=IK2PI;
}
else if( j5array[0] < -IKPI )
{    j5array[0]+=IK2PI;
}
j5valid[0] = true;
if( j5array[1] > IKPI )
{
    j5array[1]-=IK2PI;
}
else if( j5array[1] < -IKPI )
{    j5array[1]+=IK2PI;
}
j5valid[1] = true;
for(int ij5 = 0; ij5 < 2; ++ij5)
{
if( !j5valid[ij5] )
{
    continue;
}
_ij5[0] = ij5; _ij5[1] = -1;
for(int iij5 = ij5+1; iij5 < 2; ++iij5)
{
if( j5valid[iij5] && IKabs(cj5array[ij5]-cj5array[iij5]) < IKFAST_SOLUTION_THRESH && IKabs(sj5array[ij5]-sj5array[iij5]) < IKFAST_SOLUTION_THRESH )
{
    j5valid[iij5]=false; _ij5[1] = iij5; break; 
}
}
j5 = j5array[ij5]; cj5 = cj5array[ij5]; sj5 = sj5array[ij5];
{
IkReal evalcond[1];
IkReal x1774=((IkReal(1.00000000000000))*(sj3));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj2)*(sj1)*(x1774)))+(((IkReal(-1.00000000000000))*(cj3)*(sj1)*(sj2)))+(((cj1)*(cj2)*(cj3)))+(((IkReal(-1.00000000000000))*(cj1)*(sj2)*(x1774)))+(((IkReal(-1.00000000000000))*(r21)*(IKcos(j5))))+(((IkReal(-1.00000000000000))*(r20)*(IKsin(j5)))));
if( IKabs(evalcond[0]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst0;
IkReal x1775=((IkReal(20000.0000000000))*(cj5));
IkReal x1776=((IkReal(20000.0000000000))*(sj5));
gconst0=IKsign(((((py)*(r00)*(x1776)))+(((py)*(r01)*(x1775)))+(((IkReal(-1.00000000000000))*(px)*(r11)*(x1775)))+(((IkReal(-1.00000000000000))*(px)*(r10)*(x1776)))));
IkReal x1777=((IkReal(1.00000000000000))*(px));
dummyeval[0]=((((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1777)))+(((cj5)*(py)*(r01)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1777)))+(((py)*(r00)*(sj5))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst2;
gconst2=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst1;
IkReal x1778=(cj5)*(cj5);
IkReal x1779=(sj5)*(sj5);
IkReal x1780=((IkReal(1.00000000000000))*(x1779));
IkReal x1781=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1782=((IkReal(1.00000000000000))*(x1778));
gconst1=IKsign(((((IkReal(-1.00000000000000))*(x1782)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1781)))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1781)))+(((IkReal(-1.00000000000000))*(x1780)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(x1780)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x1782)*((r01)*(r01))))));
IkReal x1783=(cj5)*(cj5);
IkReal x1784=(sj5)*(sj5);
IkReal x1785=((IkReal(1.00000000000000))*(x1784));
IkReal x1786=((IkReal(2.00000000000000))*(cj5)*(sj5));
IkReal x1787=((IkReal(1.00000000000000))*(x1783));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1787)*((r01)*(r01))))+(((IkReal(-1.00000000000000))*(x1785)*((r00)*(r00))))+(((IkReal(-1.00000000000000))*(x1787)*((r11)*(r11))))+(((IkReal(-1.00000000000000))*(x1785)*((r10)*(r10))))+(((IkReal(-1.00000000000000))*(r00)*(r01)*(x1786)))+(((IkReal(-1.00000000000000))*(r10)*(r11)*(x1786))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1788=((sj2)*(sj3));
IkReal x1789=((cj5)*(r01));
IkReal x1790=((cj5)*(r11));
IkReal x1791=((r00)*(sj5));
IkReal x1792=((r10)*(sj5));
IkReal x1793=((sj1)*(x1791));
IkReal x1794=((IkReal(1.00000000000000))*(cj2)*(cj3));
IkReal x1795=((sj1)*(x1792));
IkReal x1796=((IkReal(1.00000000000000))*(cj1)*(cj2)*(sj3));
IkReal x1797=((IkReal(1.00000000000000))*(cj1)*(cj3)*(sj2));
if( IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x1792)*(x1797)))+(((IkReal(-1.00000000000000))*(x1792)*(x1796)))+(((IkReal(-1.00000000000000))*(x1790)*(x1797)))+(((IkReal(-1.00000000000000))*(x1790)*(x1796)))+(((x1788)*(x1795)))+(((IkReal(-1.00000000000000))*(sj1)*(x1790)*(x1794)))+(((sj1)*(x1788)*(x1790)))+(((IkReal(-1.00000000000000))*(x1794)*(x1795))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst1)*(((((IkReal(-1.00000000000000))*(x1793)*(x1794)))+(((IkReal(-1.00000000000000))*(x1789)*(x1796)))+(((IkReal(-1.00000000000000))*(x1789)*(x1797)))+(((IkReal(-1.00000000000000))*(sj1)*(x1789)*(x1794)))+(((sj1)*(x1788)*(x1789)))+(((x1788)*(x1793)))+(((IkReal(-1.00000000000000))*(x1791)*(x1796)))+(((IkReal(-1.00000000000000))*(x1791)*(x1797))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst1)*(((((IkReal(-1.00000000000000))*(x1792)*(x1797)))+(((IkReal(-1.00000000000000))*(x1792)*(x1796)))+(((IkReal(-1.00000000000000))*(x1790)*(x1797)))+(((IkReal(-1.00000000000000))*(x1790)*(x1796)))+(((x1788)*(x1795)))+(((IkReal(-1.00000000000000))*(sj1)*(x1790)*(x1794)))+(((sj1)*(x1788)*(x1790)))+(((IkReal(-1.00000000000000))*(x1794)*(x1795)))))), ((gconst1)*(((((IkReal(-1.00000000000000))*(x1793)*(x1794)))+(((IkReal(-1.00000000000000))*(x1789)*(x1796)))+(((IkReal(-1.00000000000000))*(x1789)*(x1797)))+(((IkReal(-1.00000000000000))*(sj1)*(x1789)*(x1794)))+(((sj1)*(x1788)*(x1789)))+(((x1788)*(x1793)))+(((IkReal(-1.00000000000000))*(x1791)*(x1796)))+(((IkReal(-1.00000000000000))*(x1791)*(x1797)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1798=IKcos(j0);
IkReal x1799=IKsin(j0);
IkReal x1800=((r00)*(sj5));
IkReal x1801=((IkReal(1.00000000000000))*(cj2));
IkReal x1802=((cj5)*(r11));
IkReal x1803=((sj1)*(sj2));
IkReal x1804=((r10)*(sj5));
IkReal x1805=((IkReal(0.0946500000000000))*(x1799));
IkReal x1806=((IkReal(0.0946500000000000))*(x1798));
IkReal x1807=((IkReal(1.00000000000000))*(x1799));
IkReal x1808=((IkReal(1.00000000000000))*(x1798));
IkReal x1809=((cj5)*(r01)*(x1799));
IkReal x1810=((cj5)*(x1806));
evalcond[0]=((((x1798)*(x1804)))+(((x1798)*(x1802)))+(((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1807)))+(((IkReal(-1.00000000000000))*(x1800)*(x1807))));
evalcond[1]=((IkReal(0.109150000000000))+(((cj5)*(r01)*(x1805)))+(((x1800)*(x1805)))+(((IkReal(-1.00000000000000))*(x1804)*(x1806)))+(((IkReal(-1.00000000000000))*(x1802)*(x1806)))+(((IkReal(-1.00000000000000))*(py)*(x1808)))+(((px)*(x1799))));
evalcond[2]=((((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1804)*(x1805)))+(((IkReal(-1.00000000000000))*(x1802)*(x1805)))+(((IkReal(-1.00000000000000))*(r01)*(x1810)))+(((IkReal(-1.00000000000000))*(py)*(x1807)))+(((IkReal(-1.00000000000000))*(x1800)*(x1806)))+(((IkReal(-1.00000000000000))*(px)*(x1808)))+(((IkReal(-0.392250000000000))*(x1803))));
evalcond[3]=((((x1799)*(x1802)))+(((x1799)*(x1804)))+(((x1798)*(x1800)))+(((cj5)*(r01)*(x1798)))+(((IkReal(-1.00000000000000))*(cj1)*(cj3)*(sj2)))+(((sj3)*(x1803)))+(((IkReal(-1.00000000000000))*(cj3)*(sj1)*(x1801)))+(((IkReal(-1.00000000000000))*(cj1)*(sj3)*(x1801))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x1811=((IkReal(1.00000000000000))*(sj0));
IkReal x1812=((cj5)*(r22));
IkReal x1813=((r21)*(sj5));
IkReal x1814=((IkReal(1.00000000000000))*(cj0));
IkReal x1815=((r22)*(sj5));
IkReal x1816=((cj5)*(r20));
gconst3=IKsign(((((IkReal(-1.00000000000000))*(r00)*(x1811)*(x1812)))+(((cj0)*(r12)*(x1813)))+(((cj0)*(r10)*(x1812)))+(((IkReal(-1.00000000000000))*(r11)*(x1814)*(x1815)))+(((IkReal(-1.00000000000000))*(r12)*(x1814)*(x1816)))+(((r01)*(sj0)*(x1815)))+(((r02)*(sj0)*(x1816)))+(((IkReal(-1.00000000000000))*(r02)*(x1811)*(x1813)))));
IkReal x1817=((IkReal(1.00000000000000))*(sj0));
IkReal x1818=((cj5)*(r22));
IkReal x1819=((r21)*(sj5));
IkReal x1820=((IkReal(1.00000000000000))*(cj0));
IkReal x1821=((r22)*(sj5));
IkReal x1822=((cj5)*(r20));
dummyeval[0]=((((cj0)*(r12)*(x1819)))+(((r01)*(sj0)*(x1821)))+(((cj0)*(r10)*(x1818)))+(((IkReal(-1.00000000000000))*(r11)*(x1820)*(x1821)))+(((IkReal(-1.00000000000000))*(r00)*(x1817)*(x1818)))+(((IkReal(-1.00000000000000))*(r12)*(x1820)*(x1822)))+(((IkReal(-1.00000000000000))*(r02)*(x1817)*(x1819)))+(((r02)*(sj0)*(x1822))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1823=((cj3)*(sj2));
IkReal x1824=((cj2)*(cj3));
IkReal x1825=((cj2)*(sj3));
IkReal x1826=((sj2)*(sj3));
IkReal x1827=((r21)*(sj5));
IkReal x1828=((IkReal(1.00000000000000))*(cj1));
IkReal x1829=((IkReal(1.00000000000000))*(sj1));
IkReal x1830=((r22)*(x1828));
IkReal x1831=((cj5)*(r20)*(sj1));
IkReal x1832=((cj1)*(cj5)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(x1825)*(x1830)))+(((r22)*(sj1)*(x1826)))+(((IkReal(-1.00000000000000))*(x1823)*(x1830)))+(((IkReal(-1.00000000000000))*(r22)*(x1824)*(x1829))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((sj1)*(x1826)*(x1827)))+(((x1824)*(x1831)))+(((IkReal(-1.00000000000000))*(x1825)*(x1827)*(x1828)))+(((IkReal(-1.00000000000000))*(x1823)*(x1827)*(x1828)))+(((x1823)*(x1832)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1826)*(x1829)))+(((x1825)*(x1832)))+(((IkReal(-1.00000000000000))*(x1824)*(x1827)*(x1829))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(x1825)*(x1830)))+(((r22)*(sj1)*(x1826)))+(((IkReal(-1.00000000000000))*(x1823)*(x1830)))+(((IkReal(-1.00000000000000))*(r22)*(x1824)*(x1829)))))), ((gconst4)*(((((sj1)*(x1826)*(x1827)))+(((x1824)*(x1831)))+(((IkReal(-1.00000000000000))*(x1825)*(x1827)*(x1828)))+(((IkReal(-1.00000000000000))*(x1823)*(x1827)*(x1828)))+(((x1823)*(x1832)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1826)*(x1829)))+(((x1825)*(x1832)))+(((IkReal(-1.00000000000000))*(x1824)*(x1827)*(x1829)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1833=IKsin(j4);
IkReal x1834=IKcos(j4);
IkReal x1835=((IkReal(1.00000000000000))*(cj2));
IkReal x1836=((cj3)*(sj1));
IkReal x1837=((cj1)*(sj3));
IkReal x1838=((IkReal(1.00000000000000))*(cj5));
IkReal x1839=((IkReal(1.00000000000000))*(r01));
IkReal x1840=((cj1)*(cj3));
IkReal x1841=((r11)*(sj5));
IkReal x1842=((sj1)*(sj3));
IkReal x1843=((r01)*(sj5));
IkReal x1844=((r21)*(sj5));
IkReal x1845=((cj0)*(x1833));
IkReal x1846=((cj5)*(x1833));
IkReal x1847=((sj0)*(x1834));
IkReal x1848=((IkReal(1.00000000000000))*(x1833));
IkReal x1849=((cj0)*(x1834));
IkReal x1850=((sj0)*(sj5)*(x1833));
IkReal x1851=((IkReal(1.00000000000000))*(x1849));
evalcond[0]=((((r22)*(x1834)))+(((r20)*(x1846)))+(((IkReal(-1.00000000000000))*(x1844)*(x1848))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1848)))+(((cj5)*(r00)*(x1847)))+(((IkReal(-1.00000000000000))*(sj5)*(x1839)*(x1847)))+(((r12)*(x1845)))+(((x1841)*(x1849)))+(((IkReal(-1.00000000000000))*(r10)*(x1838)*(x1849))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1833)*(x1838)))+(((IkReal(-1.00000000000000))*(r00)*(x1838)*(x1845)))+(((IkReal(-1.00000000000000))*(r12)*(x1847)))+(((IkReal(-1.00000000000000))*(r02)*(x1851)))+(((x1843)*(x1845)))+(((sj0)*(x1833)*(x1841))));
evalcond[3]=((IkReal(1.00000000000000))+(((r00)*(sj0)*(x1846)))+(((r02)*(x1847)))+(((IkReal(-1.00000000000000))*(r12)*(x1851)))+(((x1841)*(x1845)))+(((IkReal(-1.00000000000000))*(x1839)*(x1850)))+(((IkReal(-1.00000000000000))*(r10)*(x1838)*(x1845))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r22)*(x1848)))+(((cj5)*(r20)*(x1834)))+(((sj2)*(x1842)))+(((IkReal(-1.00000000000000))*(x1835)*(x1836)))+(((IkReal(-1.00000000000000))*(x1835)*(x1837)))+(((IkReal(-1.00000000000000))*(sj2)*(x1840)))+(((IkReal(-1.00000000000000))*(x1834)*(x1844))));
evalcond[5]=((((r02)*(x1845)))+(((cj2)*(x1842)))+(((sj2)*(x1836)))+(((sj2)*(x1837)))+(((IkReal(-1.00000000000000))*(r00)*(x1838)*(x1849)))+(((r12)*(sj0)*(x1833)))+(((IkReal(-1.00000000000000))*(x1835)*(x1840)))+(((x1843)*(x1849)))+(((x1841)*(x1847)))+(((IkReal(-1.00000000000000))*(r10)*(x1838)*(x1847))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst3)*(r22))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(r22)), ((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1852=IKsin(j4);
IkReal x1853=IKcos(j4);
IkReal x1854=((IkReal(1.00000000000000))*(cj2));
IkReal x1855=((cj3)*(sj1));
IkReal x1856=((cj1)*(sj3));
IkReal x1857=((IkReal(1.00000000000000))*(cj5));
IkReal x1858=((IkReal(1.00000000000000))*(r01));
IkReal x1859=((cj1)*(cj3));
IkReal x1860=((r11)*(sj5));
IkReal x1861=((sj1)*(sj3));
IkReal x1862=((r01)*(sj5));
IkReal x1863=((r21)*(sj5));
IkReal x1864=((cj0)*(x1852));
IkReal x1865=((cj5)*(x1852));
IkReal x1866=((sj0)*(x1853));
IkReal x1867=((IkReal(1.00000000000000))*(x1852));
IkReal x1868=((cj0)*(x1853));
IkReal x1869=((sj0)*(sj5)*(x1852));
IkReal x1870=((IkReal(1.00000000000000))*(x1868));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1863)*(x1867)))+(((r22)*(x1853)))+(((r20)*(x1865))));
evalcond[1]=((((r12)*(x1864)))+(((x1860)*(x1868)))+(((cj5)*(r00)*(x1866)))+(((IkReal(-1.00000000000000))*(sj5)*(x1858)*(x1866)))+(((IkReal(-1.00000000000000))*(r10)*(x1857)*(x1868)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x1867))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r12)*(x1866)))+(((IkReal(-1.00000000000000))*(r02)*(x1870)))+(((IkReal(-1.00000000000000))*(r00)*(x1857)*(x1864)))+(((x1862)*(x1864)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1852)*(x1857)))+(((sj0)*(x1852)*(x1860))));
evalcond[3]=((IkReal(1.00000000000000))+(((x1860)*(x1864)))+(((r02)*(x1866)))+(((r00)*(sj0)*(x1865)))+(((IkReal(-1.00000000000000))*(r10)*(x1857)*(x1864)))+(((IkReal(-1.00000000000000))*(r12)*(x1870)))+(((IkReal(-1.00000000000000))*(x1858)*(x1869))));
evalcond[4]=((((IkReal(-1.00000000000000))*(sj2)*(x1859)))+(((IkReal(-1.00000000000000))*(x1853)*(x1863)))+(((sj2)*(x1861)))+(((cj5)*(r20)*(x1853)))+(((IkReal(-1.00000000000000))*(x1854)*(x1855)))+(((IkReal(-1.00000000000000))*(x1854)*(x1856)))+(((IkReal(-1.00000000000000))*(r22)*(x1867))));
evalcond[5]=((((r12)*(sj0)*(x1852)))+(((x1860)*(x1866)))+(((IkReal(-1.00000000000000))*(r00)*(x1857)*(x1868)))+(((x1862)*(x1868)))+(((r02)*(x1864)))+(((IkReal(-1.00000000000000))*(r10)*(x1857)*(x1866)))+(((sj2)*(x1855)))+(((sj2)*(x1856)))+(((IkReal(-1.00000000000000))*(x1854)*(x1859)))+(((cj2)*(x1861))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1871=((cj3)*(sj2));
IkReal x1872=((cj2)*(sj3));
IkReal x1873=((cj5)*(r20));
IkReal x1874=((r21)*(sj5));
IkReal x1875=((IkReal(1.00000000000000))*(cj1));
IkReal x1876=((r22)*(x1875));
IkReal x1877=((sj1)*(sj2)*(sj3));
IkReal x1878=((cj2)*(cj3)*(sj1));
if( IKabs(((gconst2)*(((((IkReal(-1.00000000000000))*(x1872)*(x1876)))+(((r22)*(x1877)))+(((IkReal(-1.00000000000000))*(r22)*(x1878)))+(((IkReal(-1.00000000000000))*(x1871)*(x1876))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst2)*(((((x1874)*(x1877)))+(((cj1)*(x1872)*(x1873)))+(((IkReal(-1.00000000000000))*(x1874)*(x1878)))+(((IkReal(-1.00000000000000))*(x1873)*(x1877)))+(((x1873)*(x1878)))+(((IkReal(-1.00000000000000))*(x1871)*(x1874)*(x1875)))+(((cj1)*(x1871)*(x1873)))+(((IkReal(-1.00000000000000))*(x1872)*(x1874)*(x1875))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst2)*(((((IkReal(-1.00000000000000))*(x1872)*(x1876)))+(((r22)*(x1877)))+(((IkReal(-1.00000000000000))*(r22)*(x1878)))+(((IkReal(-1.00000000000000))*(x1871)*(x1876)))))), ((gconst2)*(((((x1874)*(x1877)))+(((cj1)*(x1872)*(x1873)))+(((IkReal(-1.00000000000000))*(x1874)*(x1878)))+(((IkReal(-1.00000000000000))*(x1873)*(x1877)))+(((x1873)*(x1878)))+(((IkReal(-1.00000000000000))*(x1871)*(x1874)*(x1875)))+(((cj1)*(x1871)*(x1873)))+(((IkReal(-1.00000000000000))*(x1872)*(x1874)*(x1875)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[2];
IkReal x1879=IKsin(j4);
IkReal x1880=IKcos(j4);
IkReal x1881=((IkReal(1.00000000000000))*(cj1));
IkReal x1882=((cj5)*(r20));
IkReal x1883=((IkReal(1.00000000000000))*(r21)*(sj5));
evalcond[0]=((((x1879)*(x1882)))+(((IkReal(-1.00000000000000))*(x1879)*(x1883)))+(((r22)*(x1880))));
evalcond[1]=((((IkReal(-1.00000000000000))*(x1880)*(x1883)))+(((x1880)*(x1882)))+(((IkReal(-1.00000000000000))*(r22)*(x1879)))+(((IkReal(-1.00000000000000))*(cj3)*(sj2)*(x1881)))+(((IkReal(-1.00000000000000))*(cj2)*(cj3)*(sj1)))+(((sj1)*(sj2)*(sj3)))+(((IkReal(-1.00000000000000))*(cj2)*(sj3)*(x1881))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst5;
IkReal x1884=((IkReal(20000.0000000000))*(cj5));
IkReal x1885=((IkReal(20000.0000000000))*(sj5));
gconst5=IKsign(((((py)*(r01)*(x1884)))+(((IkReal(-1.00000000000000))*(px)*(r10)*(x1885)))+(((IkReal(-1.00000000000000))*(px)*(r11)*(x1884)))+(((py)*(r00)*(x1885)))));
IkReal x1886=((IkReal(1.00000000000000))*(px));
dummyeval[0]=((((cj5)*(py)*(r01)))+(((py)*(r00)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r11)*(x1886)))+(((IkReal(-1.00000000000000))*(r10)*(sj5)*(x1886))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst6;
IkReal x1887=(sj5)*(sj5);
IkReal x1888=(cj5)*(cj5);
IkReal x1889=((cj4)*(sj5));
IkReal x1890=((IkReal(1.00000000000000))*(r02));
IkReal x1891=((r01)*(r10));
IkReal x1892=((cj4)*(cj5));
IkReal x1893=((sj4)*(x1888));
IkReal x1894=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1895=((sj4)*(x1887));
gconst6=IKsign(((((IkReal(-1.00000000000000))*(x1893)*(x1894)))+(((r01)*(r12)*(x1892)))+(((IkReal(-1.00000000000000))*(r11)*(x1890)*(x1892)))+(((x1891)*(x1893)))+(((x1891)*(x1895)))+(((IkReal(-1.00000000000000))*(x1894)*(x1895)))+(((r00)*(r12)*(x1889)))+(((IkReal(-1.00000000000000))*(r10)*(x1889)*(x1890)))));
IkReal x1896=(sj5)*(sj5);
IkReal x1897=(cj5)*(cj5);
IkReal x1898=((cj4)*(sj5));
IkReal x1899=((IkReal(1.00000000000000))*(r02));
IkReal x1900=((r01)*(r10));
IkReal x1901=((cj4)*(cj5));
IkReal x1902=((sj4)*(x1897));
IkReal x1903=((IkReal(1.00000000000000))*(r00)*(r11));
IkReal x1904=((sj4)*(x1896));
dummyeval[0]=((((IkReal(-1.00000000000000))*(x1902)*(x1903)))+(((r01)*(r12)*(x1901)))+(((IkReal(-1.00000000000000))*(x1903)*(x1904)))+(((IkReal(-1.00000000000000))*(r11)*(x1899)*(x1901)))+(((x1900)*(x1904)))+(((x1900)*(x1902)))+(((IkReal(-1.00000000000000))*(r10)*(x1898)*(x1899)))+(((r00)*(r12)*(x1898))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
if( IKabs(((gconst6)*(((((cj5)*(r11)))+(((r10)*(sj5))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst6)*(((((r00)*(sj5)))+(((cj5)*(r01))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst6)*(((((cj5)*(r11)))+(((r10)*(sj5)))))), ((gconst6)*(((((r00)*(sj5)))+(((cj5)*(r01)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x1905=IKcos(j0);
IkReal x1906=IKsin(j0);
IkReal x1907=((IkReal(1.00000000000000))*(cj5));
IkReal x1908=((IkReal(0.0946500000000000))*(sj5));
IkReal x1909=((IkReal(1.00000000000000))*(cj2));
IkReal x1910=((cj3)*(sj1));
IkReal x1911=((cj1)*(sj3));
IkReal x1912=((IkReal(0.0946500000000000))*(cj5));
IkReal x1913=((r02)*(sj4));
IkReal x1914=((cj1)*(cj3));
IkReal x1915=((sj1)*(sj2));
IkReal x1916=((sj4)*(sj5));
IkReal x1917=((IkReal(1.00000000000000))*(sj5));
IkReal x1918=((cj4)*(r02));
IkReal x1919=((cj4)*(r12));
IkReal x1920=((cj4)*(sj5));
IkReal x1921=((r12)*(sj4));
IkReal x1922=((r01)*(x1906));
IkReal x1923=((r00)*(x1905));
IkReal x1924=((r00)*(x1906));
IkReal x1925=((r11)*(x1905));
IkReal x1926=((r01)*(x1905));
IkReal x1927=((r11)*(x1906));
IkReal x1928=((r10)*(x1906));
IkReal x1929=((IkReal(1.00000000000000))*(x1906));
IkReal x1930=((r10)*(x1905));
IkReal x1931=((IkReal(1.00000000000000))*(x1905));
evalcond[0]=((((IkReal(-1.00000000000000))*(x1907)*(x1922)))+(((cj5)*(x1925)))+(((IkReal(-1.00000000000000))*(x1917)*(x1924)))+(((sj5)*(x1930))));
evalcond[1]=((IkReal(0.109150000000000))+(((IkReal(-1.00000000000000))*(py)*(x1931)))+(((px)*(x1906)))+(((IkReal(-1.00000000000000))*(x1912)*(x1925)))+(((x1912)*(x1922)))+(((IkReal(-1.00000000000000))*(x1908)*(x1930)))+(((x1908)*(x1924))));
evalcond[2]=((((cj4)*(cj5)*(x1924)))+(((IkReal(-1.00000000000000))*(x1913)*(x1929)))+(((IkReal(-1.00000000000000))*(cj4)*(x1907)*(x1930)))+(((x1905)*(x1921)))+(((x1920)*(x1925)))+(((IkReal(-1.00000000000000))*(cj4)*(x1917)*(x1922))));
evalcond[3]=((((x1916)*(x1927)))+(((x1916)*(x1926)))+(((IkReal(-1.00000000000000))*(sj4)*(x1907)*(x1923)))+(((IkReal(-1.00000000000000))*(sj4)*(x1907)*(x1928)))+(((IkReal(-1.00000000000000))*(x1918)*(x1931)))+(((IkReal(-1.00000000000000))*(x1919)*(x1929))));
evalcond[4]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x1919)*(x1931)))+(((IkReal(-1.00000000000000))*(sj4)*(x1907)*(x1930)))+(((cj5)*(sj4)*(x1924)))+(((x1916)*(x1925)))+(((IkReal(-1.00000000000000))*(x1916)*(x1922)))+(((x1906)*(x1918))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1908)*(x1928)))+(((IkReal(-1.00000000000000))*(x1908)*(x1923)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(-0.392250000000000))*(x1915)))+(((IkReal(-1.00000000000000))*(py)*(x1929)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1912)*(x1926)))+(((IkReal(-1.00000000000000))*(x1912)*(x1927)))+(((IkReal(-1.00000000000000))*(px)*(x1931))));
evalcond[6]=((((cj5)*(x1927)))+(((cj5)*(x1926)))+(((IkReal(-1.00000000000000))*(sj2)*(x1914)))+(((sj5)*(x1928)))+(((sj5)*(x1923)))+(((IkReal(-1.00000000000000))*(x1909)*(x1910)))+(((IkReal(-1.00000000000000))*(x1909)*(x1911)))+(((sj3)*(x1915))));
evalcond[7]=((((x1905)*(x1913)))+(((IkReal(-1.00000000000000))*(cj4)*(x1907)*(x1923)))+(((IkReal(-1.00000000000000))*(cj4)*(x1907)*(x1928)))+(((x1906)*(x1921)))+(((IkReal(-1.00000000000000))*(x1909)*(x1914)))+(((x1920)*(x1926)))+(((x1920)*(x1927)))+(((sj2)*(x1910)))+(((sj2)*(x1911)))+(((cj2)*(sj1)*(sj3))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1932=((IkReal(2183.00000000000))*(sj5));
IkReal x1933=((IkReal(2183.00000000000))*(cj5));
if( IKabs(((gconst5)*(((((r11)*(x1933)))+(((r10)*(x1932))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst5)*(((((r00)*(x1932)))+(((r01)*(x1933))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst5)*(((((r11)*(x1933)))+(((r10)*(x1932)))))), ((gconst5)*(((((r00)*(x1932)))+(((r01)*(x1933)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[8];
IkReal x1934=IKcos(j0);
IkReal x1935=IKsin(j0);
IkReal x1936=((IkReal(1.00000000000000))*(cj5));
IkReal x1937=((IkReal(0.0946500000000000))*(sj5));
IkReal x1938=((IkReal(1.00000000000000))*(cj2));
IkReal x1939=((cj3)*(sj1));
IkReal x1940=((cj1)*(sj3));
IkReal x1941=((IkReal(0.0946500000000000))*(cj5));
IkReal x1942=((r02)*(sj4));
IkReal x1943=((cj1)*(cj3));
IkReal x1944=((sj1)*(sj2));
IkReal x1945=((sj4)*(sj5));
IkReal x1946=((IkReal(1.00000000000000))*(sj5));
IkReal x1947=((cj4)*(r02));
IkReal x1948=((cj4)*(r12));
IkReal x1949=((cj4)*(sj5));
IkReal x1950=((r12)*(sj4));
IkReal x1951=((r01)*(x1935));
IkReal x1952=((r00)*(x1934));
IkReal x1953=((r00)*(x1935));
IkReal x1954=((r11)*(x1934));
IkReal x1955=((r01)*(x1934));
IkReal x1956=((r11)*(x1935));
IkReal x1957=((r10)*(x1935));
IkReal x1958=((IkReal(1.00000000000000))*(x1935));
IkReal x1959=((r10)*(x1934));
IkReal x1960=((IkReal(1.00000000000000))*(x1934));
evalcond[0]=((((sj5)*(x1959)))+(((cj5)*(x1954)))+(((IkReal(-1.00000000000000))*(x1946)*(x1953)))+(((IkReal(-1.00000000000000))*(x1936)*(x1951))));
evalcond[1]=((IkReal(0.109150000000000))+(((IkReal(-1.00000000000000))*(x1937)*(x1959)))+(((x1937)*(x1953)))+(((px)*(x1935)))+(((x1941)*(x1951)))+(((IkReal(-1.00000000000000))*(x1941)*(x1954)))+(((IkReal(-1.00000000000000))*(py)*(x1960))));
evalcond[2]=((((IkReal(-1.00000000000000))*(x1942)*(x1958)))+(((IkReal(-1.00000000000000))*(cj4)*(x1946)*(x1951)))+(((IkReal(-1.00000000000000))*(cj4)*(x1936)*(x1959)))+(((cj4)*(cj5)*(x1953)))+(((x1934)*(x1950)))+(((x1949)*(x1954))));
evalcond[3]=((((IkReal(-1.00000000000000))*(x1948)*(x1958)))+(((x1945)*(x1956)))+(((x1945)*(x1955)))+(((IkReal(-1.00000000000000))*(sj4)*(x1936)*(x1952)))+(((IkReal(-1.00000000000000))*(sj4)*(x1936)*(x1957)))+(((IkReal(-1.00000000000000))*(x1947)*(x1960))));
evalcond[4]=((IkReal(1.00000000000000))+(((x1945)*(x1954)))+(((IkReal(-1.00000000000000))*(x1948)*(x1960)))+(((IkReal(-1.00000000000000))*(sj4)*(x1936)*(x1959)))+(((IkReal(-1.00000000000000))*(x1945)*(x1951)))+(((x1935)*(x1947)))+(((cj5)*(sj4)*(x1953))));
evalcond[5]=((((IkReal(-1.00000000000000))*(x1937)*(x1952)))+(((IkReal(-1.00000000000000))*(x1937)*(x1957)))+(((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(-0.392250000000000))*(x1944)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(py)*(x1958)))+(((IkReal(-1.00000000000000))*(px)*(x1960)))+(((IkReal(-1.00000000000000))*(x1941)*(x1956)))+(((IkReal(-1.00000000000000))*(x1941)*(x1955))));
evalcond[6]=((((sj3)*(x1944)))+(((sj5)*(x1957)))+(((sj5)*(x1952)))+(((cj5)*(x1956)))+(((cj5)*(x1955)))+(((IkReal(-1.00000000000000))*(x1938)*(x1940)))+(((IkReal(-1.00000000000000))*(x1938)*(x1939)))+(((IkReal(-1.00000000000000))*(sj2)*(x1943))));
evalcond[7]=((((sj2)*(x1939)))+(((sj2)*(x1940)))+(((x1935)*(x1950)))+(((IkReal(-1.00000000000000))*(x1938)*(x1943)))+(((IkReal(-1.00000000000000))*(cj4)*(x1936)*(x1952)))+(((IkReal(-1.00000000000000))*(cj4)*(x1936)*(x1957)))+(((cj2)*(sj1)*(sj3)))+(((x1934)*(x1942)))+(((x1949)*(x1955)))+(((x1949)*(x1956))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  || IKabs(evalcond[6]) > 0.000001  || IKabs(evalcond[7]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}

} else
{
{
IkReal j0array[1], cj0array[1], sj0array[1];
bool j0valid[1]={false};
_nj0 = 1;
IkReal x1961=((IkReal(2183.00000000000))*(sj5));
IkReal x1962=((IkReal(2183.00000000000))*(cj5));
if( IKabs(((gconst0)*(((((r10)*(x1961)))+(((r11)*(x1962))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst0)*(((((r00)*(x1961)))+(((r01)*(x1962))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j0array[0]=IKatan2(((gconst0)*(((((r10)*(x1961)))+(((r11)*(x1962)))))), ((gconst0)*(((((r00)*(x1961)))+(((r01)*(x1962)))))));
sj0array[0]=IKsin(j0array[0]);
cj0array[0]=IKcos(j0array[0]);
if( j0array[0] > IKPI )
{
    j0array[0]-=IK2PI;
}
else if( j0array[0] < -IKPI )
{    j0array[0]+=IK2PI;
}
j0valid[0] = true;
for(int ij0 = 0; ij0 < 1; ++ij0)
{
if( !j0valid[ij0] )
{
    continue;
}
_ij0[0] = ij0; _ij0[1] = -1;
for(int iij0 = ij0+1; iij0 < 1; ++iij0)
{
if( j0valid[iij0] && IKabs(cj0array[ij0]-cj0array[iij0]) < IKFAST_SOLUTION_THRESH && IKabs(sj0array[ij0]-sj0array[iij0]) < IKFAST_SOLUTION_THRESH )
{
    j0valid[iij0]=false; _ij0[1] = iij0; break; 
}
}
j0 = j0array[ij0]; cj0 = cj0array[ij0]; sj0 = sj0array[ij0];
{
IkReal evalcond[4];
IkReal x1963=IKcos(j0);
IkReal x1964=IKsin(j0);
IkReal x1965=((r00)*(sj5));
IkReal x1966=((IkReal(1.00000000000000))*(cj2));
IkReal x1967=((cj5)*(r11));
IkReal x1968=((sj1)*(sj2));
IkReal x1969=((r10)*(sj5));
IkReal x1970=((IkReal(0.0946500000000000))*(x1964));
IkReal x1971=((IkReal(0.0946500000000000))*(x1963));
IkReal x1972=((IkReal(1.00000000000000))*(x1964));
IkReal x1973=((IkReal(1.00000000000000))*(x1963));
IkReal x1974=((cj5)*(r01)*(x1964));
IkReal x1975=((cj5)*(x1971));
evalcond[0]=((((IkReal(-1.00000000000000))*(cj5)*(r01)*(x1972)))+(((IkReal(-1.00000000000000))*(x1965)*(x1972)))+(((x1963)*(x1967)))+(((x1963)*(x1969))));
evalcond[1]=((IkReal(0.109150000000000))+(((px)*(x1964)))+(((x1965)*(x1970)))+(((IkReal(-1.00000000000000))*(py)*(x1973)))+(((IkReal(-1.00000000000000))*(x1969)*(x1971)))+(((IkReal(-1.00000000000000))*(x1967)*(x1971)))+(((cj5)*(r01)*(x1970))));
evalcond[2]=((((IkReal(0.392250000000000))*(cj1)*(cj2)))+(((IkReal(0.425000000000000))*(cj1)))+(((IkReal(-1.00000000000000))*(x1965)*(x1971)))+(((IkReal(-0.392250000000000))*(x1968)))+(((IkReal(-1.00000000000000))*(r01)*(x1975)))+(((IkReal(-1.00000000000000))*(px)*(x1973)))+(((IkReal(-1.00000000000000))*(py)*(x1972)))+(((IkReal(-1.00000000000000))*(x1969)*(x1970)))+(((IkReal(-1.00000000000000))*(x1967)*(x1970))));
evalcond[3]=((((IkReal(-1.00000000000000))*(cj1)*(sj3)*(x1966)))+(((sj3)*(x1968)))+(((x1964)*(x1967)))+(((x1964)*(x1969)))+(((IkReal(-1.00000000000000))*(cj1)*(cj3)*(sj2)))+(((IkReal(-1.00000000000000))*(cj3)*(sj1)*(x1966)))+(((x1963)*(x1965)))+(((cj5)*(r01)*(x1963))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  )
{
continue;
}
}

{
IkReal dummyeval[1];
IkReal gconst3;
IkReal x1976=((IkReal(1.00000000000000))*(sj0));
IkReal x1977=((cj5)*(r22));
IkReal x1978=((r21)*(sj5));
IkReal x1979=((IkReal(1.00000000000000))*(cj0));
IkReal x1980=((r22)*(sj5));
IkReal x1981=((cj5)*(r20));
gconst3=IKsign(((((IkReal(-1.00000000000000))*(r11)*(x1979)*(x1980)))+(((IkReal(-1.00000000000000))*(r12)*(x1979)*(x1981)))+(((cj0)*(r10)*(x1977)))+(((r02)*(sj0)*(x1981)))+(((r01)*(sj0)*(x1980)))+(((IkReal(-1.00000000000000))*(r02)*(x1976)*(x1978)))+(((IkReal(-1.00000000000000))*(r00)*(x1976)*(x1977)))+(((cj0)*(r12)*(x1978)))));
IkReal x1982=((IkReal(1.00000000000000))*(sj0));
IkReal x1983=((cj5)*(r22));
IkReal x1984=((r21)*(sj5));
IkReal x1985=((IkReal(1.00000000000000))*(cj0));
IkReal x1986=((r22)*(sj5));
IkReal x1987=((cj5)*(r20));
dummyeval[0]=((((IkReal(-1.00000000000000))*(r12)*(x1985)*(x1987)))+(((IkReal(-1.00000000000000))*(r11)*(x1985)*(x1986)))+(((IkReal(-1.00000000000000))*(r02)*(x1982)*(x1984)))+(((r02)*(sj0)*(x1987)))+(((r01)*(sj0)*(x1986)))+(((IkReal(-1.00000000000000))*(r00)*(x1982)*(x1983)))+(((cj0)*(r12)*(x1984)))+(((cj0)*(r10)*(x1983))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
{
IkReal dummyeval[1];
IkReal gconst4;
gconst4=IKsign((((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5))))));
dummyeval[0]=(((r22)*(r22))+((((cj5)*(cj5))*((r20)*(r20))))+(((IkReal(-2.00000000000000))*(cj5)*(r20)*(r21)*(sj5)))+((((r21)*(r21))*((sj5)*(sj5)))));
if( IKabs(dummyeval[0]) < 0.0000010000000000  )
{
continue;

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
IkReal x1988=((cj3)*(sj2));
IkReal x1989=((cj2)*(cj3));
IkReal x1990=((cj2)*(sj3));
IkReal x1991=((sj2)*(sj3));
IkReal x1992=((r21)*(sj5));
IkReal x1993=((IkReal(1.00000000000000))*(cj1));
IkReal x1994=((IkReal(1.00000000000000))*(sj1));
IkReal x1995=((r22)*(x1993));
IkReal x1996=((cj5)*(r20)*(sj1));
IkReal x1997=((cj1)*(cj5)*(r20));
if( IKabs(((gconst4)*(((((IkReal(-1.00000000000000))*(r22)*(x1989)*(x1994)))+(((r22)*(sj1)*(x1991)))+(((IkReal(-1.00000000000000))*(x1990)*(x1995)))+(((IkReal(-1.00000000000000))*(x1988)*(x1995))))))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst4)*(((((sj1)*(x1991)*(x1992)))+(((x1988)*(x1997)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1991)*(x1994)))+(((IkReal(-1.00000000000000))*(x1989)*(x1992)*(x1994)))+(((x1989)*(x1996)))+(((IkReal(-1.00000000000000))*(x1990)*(x1992)*(x1993)))+(((IkReal(-1.00000000000000))*(x1988)*(x1992)*(x1993)))+(((x1990)*(x1997))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst4)*(((((IkReal(-1.00000000000000))*(r22)*(x1989)*(x1994)))+(((r22)*(sj1)*(x1991)))+(((IkReal(-1.00000000000000))*(x1990)*(x1995)))+(((IkReal(-1.00000000000000))*(x1988)*(x1995)))))), ((gconst4)*(((((sj1)*(x1991)*(x1992)))+(((x1988)*(x1997)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)*(x1991)*(x1994)))+(((IkReal(-1.00000000000000))*(x1989)*(x1992)*(x1994)))+(((x1989)*(x1996)))+(((IkReal(-1.00000000000000))*(x1990)*(x1992)*(x1993)))+(((IkReal(-1.00000000000000))*(x1988)*(x1992)*(x1993)))+(((x1990)*(x1997)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x1998=IKsin(j4);
IkReal x1999=IKcos(j4);
IkReal x2000=((IkReal(1.00000000000000))*(cj2));
IkReal x2001=((cj3)*(sj1));
IkReal x2002=((cj1)*(sj3));
IkReal x2003=((IkReal(1.00000000000000))*(cj5));
IkReal x2004=((IkReal(1.00000000000000))*(r01));
IkReal x2005=((cj1)*(cj3));
IkReal x2006=((r11)*(sj5));
IkReal x2007=((sj1)*(sj3));
IkReal x2008=((r01)*(sj5));
IkReal x2009=((r21)*(sj5));
IkReal x2010=((cj0)*(x1998));
IkReal x2011=((cj5)*(x1998));
IkReal x2012=((sj0)*(x1999));
IkReal x2013=((IkReal(1.00000000000000))*(x1998));
IkReal x2014=((cj0)*(x1999));
IkReal x2015=((sj0)*(sj5)*(x1998));
IkReal x2016=((IkReal(1.00000000000000))*(x2014));
evalcond[0]=((((IkReal(-1.00000000000000))*(x2009)*(x2013)))+(((r20)*(x2011)))+(((r22)*(x1999))));
evalcond[1]=((((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2013)))+(((cj5)*(r00)*(x2012)))+(((r12)*(x2010)))+(((x2006)*(x2014)))+(((IkReal(-1.00000000000000))*(r10)*(x2003)*(x2014)))+(((IkReal(-1.00000000000000))*(sj5)*(x2004)*(x2012))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r12)*(x2012)))+(((sj0)*(x1998)*(x2006)))+(((x2008)*(x2010)))+(((IkReal(-1.00000000000000))*(r00)*(x2003)*(x2010)))+(((IkReal(-1.00000000000000))*(r10)*(sj0)*(x1998)*(x2003)))+(((IkReal(-1.00000000000000))*(r02)*(x2016))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(x2004)*(x2015)))+(((r00)*(sj0)*(x2011)))+(((IkReal(-1.00000000000000))*(r12)*(x2016)))+(((r02)*(x2012)))+(((x2006)*(x2010)))+(((IkReal(-1.00000000000000))*(r10)*(x2003)*(x2010))));
evalcond[4]=((((cj5)*(r20)*(x1999)))+(((sj2)*(x2007)))+(((IkReal(-1.00000000000000))*(x1999)*(x2009)))+(((IkReal(-1.00000000000000))*(sj2)*(x2005)))+(((IkReal(-1.00000000000000))*(x2000)*(x2002)))+(((IkReal(-1.00000000000000))*(x2000)*(x2001)))+(((IkReal(-1.00000000000000))*(r22)*(x2013))));
evalcond[5]=((((sj2)*(x2001)))+(((sj2)*(x2002)))+(((IkReal(-1.00000000000000))*(x2000)*(x2005)))+(((r12)*(sj0)*(x1998)))+(((x2008)*(x2014)))+(((cj2)*(x2007)))+(((IkReal(-1.00000000000000))*(r00)*(x2003)*(x2014)))+(((r02)*(x2010)))+(((x2006)*(x2012)))+(((IkReal(-1.00000000000000))*(r10)*(x2003)*(x2012))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}

} else
{
{
IkReal j4array[1], cj4array[1], sj4array[1];
bool j4valid[1]={false};
_nj4 = 1;
if( IKabs(((gconst3)*(r22))) < IKFAST_ATAN2_MAGTHRESH && IKabs(((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20))))))) < IKFAST_ATAN2_MAGTHRESH )
    continue;
j4array[0]=IKatan2(((gconst3)*(r22)), ((gconst3)*(((((r21)*(sj5)))+(((IkReal(-1.00000000000000))*(cj5)*(r20)))))));
sj4array[0]=IKsin(j4array[0]);
cj4array[0]=IKcos(j4array[0]);
if( j4array[0] > IKPI )
{
    j4array[0]-=IK2PI;
}
else if( j4array[0] < -IKPI )
{    j4array[0]+=IK2PI;
}
j4valid[0] = true;
for(int ij4 = 0; ij4 < 1; ++ij4)
{
if( !j4valid[ij4] )
{
    continue;
}
_ij4[0] = ij4; _ij4[1] = -1;
for(int iij4 = ij4+1; iij4 < 1; ++iij4)
{
if( j4valid[iij4] && IKabs(cj4array[ij4]-cj4array[iij4]) < IKFAST_SOLUTION_THRESH && IKabs(sj4array[ij4]-sj4array[iij4]) < IKFAST_SOLUTION_THRESH )
{
    j4valid[iij4]=false; _ij4[1] = iij4; break; 
}
}
j4 = j4array[ij4]; cj4 = cj4array[ij4]; sj4 = sj4array[ij4];
{
IkReal evalcond[6];
IkReal x2017=IKsin(j4);
IkReal x2018=IKcos(j4);
IkReal x2019=((IkReal(1.00000000000000))*(cj2));
IkReal x2020=((cj3)*(sj1));
IkReal x2021=((cj1)*(sj3));
IkReal x2022=((IkReal(1.00000000000000))*(cj5));
IkReal x2023=((IkReal(1.00000000000000))*(r01));
IkReal x2024=((cj1)*(cj3));
IkReal x2025=((r11)*(sj5));
IkReal x2026=((sj1)*(sj3));
IkReal x2027=((r01)*(sj5));
IkReal x2028=((r21)*(sj5));
IkReal x2029=((cj0)*(x2017));
IkReal x2030=((cj5)*(x2017));
IkReal x2031=((sj0)*(x2018));
IkReal x2032=((IkReal(1.00000000000000))*(x2017));
IkReal x2033=((cj0)*(x2018));
IkReal x2034=((sj0)*(sj5)*(x2017));
IkReal x2035=((IkReal(1.00000000000000))*(x2033));
evalcond[0]=((((r22)*(x2018)))+(((r20)*(x2030)))+(((IkReal(-1.00000000000000))*(x2028)*(x2032))));
evalcond[1]=((((x2025)*(x2033)))+(((IkReal(-1.00000000000000))*(r02)*(sj0)*(x2032)))+(((cj5)*(r00)*(x2031)))+(((IkReal(-1.00000000000000))*(r10)*(x2022)*(x2033)))+(((r12)*(x2029)))+(((IkReal(-1.00000000000000))*(sj5)*(x2023)*(x2031))));
evalcond[2]=((((IkReal(-1.00000000000000))*(r10)*(sj0)*(x2017)*(x2022)))+(((IkReal(-1.00000000000000))*(r00)*(x2022)*(x2029)))+(((IkReal(-1.00000000000000))*(r02)*(x2035)))+(((sj0)*(x2017)*(x2025)))+(((x2027)*(x2029)))+(((IkReal(-1.00000000000000))*(r12)*(x2031))));
evalcond[3]=((IkReal(1.00000000000000))+(((IkReal(-1.00000000000000))*(r12)*(x2035)))+(((r00)*(sj0)*(x2030)))+(((IkReal(-1.00000000000000))*(x2023)*(x2034)))+(((x2025)*(x2029)))+(((r02)*(x2031)))+(((IkReal(-1.00000000000000))*(r10)*(x2022)*(x2029))));
evalcond[4]=((((IkReal(-1.00000000000000))*(r22)*(x2032)))+(((IkReal(-1.00000000000000))*(x2018)*(x2028)))+(((sj2)*(x2026)))+(((IkReal(-1.00000000000000))*(x2019)*(x2020)))+(((IkReal(-1.00000000000000))*(x2019)*(x2021)))+(((IkReal(-1.00000000000000))*(sj2)*(x2024)))+(((cj5)*(r20)*(x2018))));
evalcond[5]=((((x2027)*(x2033)))+(((x2025)*(x2031)))+(((sj2)*(x2021)))+(((sj2)*(x2020)))+(((IkReal(-1.00000000000000))*(r00)*(x2022)*(x2033)))+(((IkReal(-1.00000000000000))*(x2019)*(x2024)))+(((IkReal(-1.00000000000000))*(r10)*(x2022)*(x2031)))+(((r02)*(x2029)))+(((cj2)*(x2026)))+(((r12)*(sj0)*(x2017))));
if( IKabs(evalcond[0]) > 0.000001  || IKabs(evalcond[1]) > 0.000001  || IKabs(evalcond[2]) > 0.000001  || IKabs(evalcond[3]) > 0.000001  || IKabs(evalcond[4]) > 0.000001  || IKabs(evalcond[5]) > 0.000001  )
{
continue;
}
}

{
std::vector<IkSingleDOFSolutionBase<IkReal> > vinfos(6);
vinfos[0].jointtype = 1;
vinfos[0].foffset = j0;
vinfos[0].indices[0] = _ij0[0];
vinfos[0].indices[1] = _ij0[1];
vinfos[0].maxsolutions = _nj0;
vinfos[1].jointtype = 1;
vinfos[1].foffset = j1;
vinfos[1].indices[0] = _ij1[0];
vinfos[1].indices[1] = _ij1[1];
vinfos[1].maxsolutions = _nj1;
vinfos[2].jointtype = 1;
vinfos[2].foffset = j2;
vinfos[2].indices[0] = _ij2[0];
vinfos[2].indices[1] = _ij2[1];
vinfos[2].maxsolutions = _nj2;
vinfos[3].jointtype = 1;
vinfos[3].foffset = j3;
vinfos[3].indices[0] = _ij3[0];
vinfos[3].indices[1] = _ij3[1];
vinfos[3].maxsolutions = _nj3;
vinfos[4].jointtype = 1;
vinfos[4].foffset = j4;
vinfos[4].indices[0] = _ij4[0];
vinfos[4].indices[1] = _ij4[1];
vinfos[4].maxsolutions = _nj4;
vinfos[5].jointtype = 1;
vinfos[5].foffset = j5;
vinfos[5].indices[0] = _ij5[0];
vinfos[5].indices[1] = _ij5[1];
vinfos[5].maxsolutions = _nj5;
std::vector<int> vfree(0);
solutions.AddSolution(vinfos,vfree);
}
}
}

}

}
}
}

}

}
}
}

}

}
    }
}
return solutions.GetNumSolutions()>0;
}

template<int D>
static inline bool matrixinverse(IkReal* A)
{
    int n = D;
    int info;
    IkReal IKFAST_ALIGNED16(work[D*D*(D-1)]);
    int ipiv[D];
    dgetrf_(&n, &n, A, &n, &ipiv[0], &info);
    if( info != 0 ) {
        return false;
    }
    int worksize=D*D*(D-1);
    dgetri_(&n, A, &n, &ipiv[0], &work[0], &worksize, &info);
    return info==0;
}

/// \brief Solve the det Ax^2+Bx+C = 0 problem using the Manocha and Canny method (1994)
///
/// matcoeffs is of length 54*3, for 3 matrices
static inline void solvedialyticpoly12qep(const IkReal* matcoeffs, IkReal* rawroots, int& numroots)
{
    const IkReal tol = 128.0*std::numeric_limits<IkReal>::epsilon();
    IkReal IKFAST_ALIGNED16(M[24*24]) = {0};
    IkReal IKFAST_ALIGNED16(A[12*12]);
    IkReal IKFAST_ALIGNED16(work[24*24*23]);
    int ipiv[12];
    int info, coeffindex;
    const int worksize=24*24*23;
    const int matrixdim = 12;
    const int matrixdim2 = 24;
    numroots = 0;
    // first setup M = [0 I; -C -B] and A
    coeffindex = 0;
    for(int j = 0; j < 6; ++j) {
        for(int k = 0; k < 9; ++k) {
            M[matrixdim+(j+6)+2*matrixdim*k] = M[matrixdim+j+2*matrixdim*(k+3)] = -matcoeffs[coeffindex++];
        }
    }
    for(int j = 0; j < 6; ++j) {
        for(int k = 0; k < 9; ++k) {
            M[matrixdim+(j+6)+2*matrixdim*k+matrixdim*2*matrixdim] = M[matrixdim+j+2*matrixdim*(k+3)+matrixdim*2*matrixdim] = -matcoeffs[coeffindex++];
        }
    }
    for(int j = 0; j < 6; ++j) {
        for(int k = 0; k < 9; ++k) {
            A[(j+6)+matrixdim*k] = A[j+matrixdim*(k+3)] = matcoeffs[coeffindex++];
        }
        for(int k = 0; k < 3; ++k) {
            A[j+matrixdim*k] = A[(j+6)+matrixdim*(k+9)] = 0;
        }
    }
    const IkReal lfpossibilities[4][4] = {{1,-1,1,1},{1,0,-2,1},{1,1,2,0},{1,-1,4,1}};
    int lfindex = -1;
    bool bsingular = true;
    do {
        dgetrf_(&matrixdim,&matrixdim,A,&matrixdim,&ipiv[0],&info);
        if( info == 0 ) {
            bsingular = false;
            for(int j = 0; j < matrixdim; ++j) {
                if( IKabs(A[j*matrixdim+j]) < 100*tol ) {
                    bsingular = true;
                    break;
                }
            }
            if( !bsingular ) {
                break;
            }
        }
        if( lfindex == 3 ) {
            break;
        }
        // transform by the linear functional
        lfindex++;
        const IkReal* lf = lfpossibilities[lfindex];
        // have to reinitialize A
        coeffindex = 0;
        for(int j = 0; j < 6; ++j) {
            for(int k = 0; k < 9; ++k) {
                IkReal a = matcoeffs[coeffindex+108], b = matcoeffs[coeffindex+54], c = matcoeffs[coeffindex];
                A[(j+6)+matrixdim*k] = A[j+matrixdim*(k+3)] = lf[0]*lf[0]*a+lf[0]*lf[2]*b+lf[2]*lf[2]*c;
                M[matrixdim+(j+6)+2*matrixdim*k] = M[matrixdim+j+2*matrixdim*(k+3)] = -(lf[1]*lf[1]*a + lf[1]*lf[3]*b + lf[3]*lf[3]*c);
                M[matrixdim+(j+6)+2*matrixdim*k+matrixdim*2*matrixdim] = M[matrixdim+j+2*matrixdim*(k+3)+matrixdim*2*matrixdim] = -(2*lf[0]*lf[1]*a + (lf[0]*lf[3]+lf[1]*lf[2])*b + 2*lf[2]*lf[3]*c);
                coeffindex++;
            }
            for(int k = 0; k < 3; ++k) {
                A[j+matrixdim*k] = A[(j+6)+matrixdim*(k+9)] = 0;
            }
        }
    } while(lfindex<4);

    if( bsingular ) {
        return;
    }
    dgetrs_("No transpose", &matrixdim, &matrixdim2, A, &matrixdim, &ipiv[0], &M[matrixdim], &matrixdim2, &info);
    if( info != 0 ) {
        return;
    }

    // set identity in upper corner
    for(int j = 0; j < matrixdim; ++j) {
        M[matrixdim*2*matrixdim+j+matrixdim*2*j] = 1;
    }
    IkReal IKFAST_ALIGNED16(wr[24]);
    IkReal IKFAST_ALIGNED16(wi[24]);
    IkReal IKFAST_ALIGNED16(vr[24*24]);
    int one=1;
    dgeev_("N", "V", &matrixdim2, M, &matrixdim2, wr, wi,NULL, &one, vr, &matrixdim2, work, &worksize, &info);
    if( info != 0 ) {
        return;
    }
    IkReal Breal[matrixdim-1];
    for(int i = 0; i < matrixdim2; ++i) {
        if( IKabs(wi[i]) < tol*100 ) {
            IkReal* ev = vr+matrixdim2*i;
            if( IKabs(wr[i]) > 1 ) {
                ev += matrixdim;
            }
            // consistency has to be checked!!
            if( IKabs(ev[0]) < tol ) {
                continue;
            }
            IkReal iconst = 1/ev[0];
            for(int j = 1; j < matrixdim; ++j) {
                Breal[j-1] = ev[j]*iconst;
            }
            if( checkconsistency12(Breal) ) {
                if( lfindex >= 0 ) {
                    const IkReal* lf = lfpossibilities[lfindex];
                    rawroots[numroots++] = (wr[i]*lf[0]+lf[1])/(wr[i]*lf[2]+lf[3]);
                }
                else {
                    rawroots[numroots++] = wr[i];
                }
                bool bsmall0=IKabs(ev[0]) > IKabs(ev[3]);
                bool bsmall1=IKabs(ev[0]) > IKabs(ev[1]);
                if( bsmall0 && bsmall1 ) {
                    rawroots[numroots++] = ev[3]/ev[0];
                    rawroots[numroots++] = ev[1]/ev[0];
                }
                else if( bsmall0 && !bsmall1 ) {
                    rawroots[numroots++] = ev[5]/ev[2];
                    rawroots[numroots++] = ev[2]/ev[1];
                }
                else if( !bsmall0 && bsmall1 ) {
                    rawroots[numroots++] = ev[9]/ev[6];
                    rawroots[numroots++] = ev[10]/ev[9];
                }
                else if( !bsmall0 && !bsmall1 ) {
                    rawroots[numroots++] = ev[11]/ev[8];
                    rawroots[numroots++] = ev[11]/ev[10];
                }
            }
        }
    }
}
static inline bool checkconsistency12(const IkReal* Breal)
{
    IkReal norm = 0.1;
    for(int i = 0; i < 11; ++i) {
        norm += IKabs(Breal[i]);
    }
    IkReal tol = 1e-6*norm; // have to increase the threshold since many computations are involved
    return IKabs(Breal[0]*Breal[0]-Breal[1]) < tol && IKabs(Breal[0]*Breal[2]-Breal[3]) < tol && IKabs(Breal[1]*Breal[2]-Breal[4]) < tol && IKabs(Breal[2]*Breal[2]-Breal[5]) < tol && IKabs(Breal[0]*Breal[5]-Breal[6]) < tol && IKabs(Breal[1]*Breal[5]-Breal[7]) < tol && IKabs(Breal[2]*Breal[5]-Breal[8]) < tol && IKabs(Breal[0]*Breal[8]-Breal[9]) < tol && IKabs(Breal[1]*Breal[8]-Breal[10]) < tol;
}
};


/// solves the inverse kinematics equations.
/// \param pfree is an array specifying the free joints of the chain.
IKFAST_API bool ComputeIk(const IkReal* eetrans, const IkReal* eerot, const IkReal* pfree, IkSolutionListBase<IkReal>& solutions) {
IKSolver solver;
return solver.ComputeIk(eetrans,eerot,pfree,solutions);
}

IKFAST_API const char* GetKinematicsHash() { return "<robot:GenericRobot - icob (3c4ef0b5d70ca998966ba76c38edfd2e)>"; }

IKFAST_API const char* GetIkFastVersion() { return IKFAST_STRINGIZE(IKFAST_VERSION); }

#ifdef IKFAST_NAMESPACE
} // end namespace
#endif

#ifndef IKFAST_NO_MAIN
#include <stdio.h>
#include <stdlib.h>
#ifdef IKFAST_NAMESPACE
using namespace IKFAST_NAMESPACE;
#endif
int main(int argc, char** argv)
{
    if( argc != 12+GetNumFreeParameters()+1 ) {
        printf("\nUsage: ./ik r00 r01 r02 t0 r10 r11 r12 t1 r20 r21 r22 t2 free0 ...\n\n"
               "Returns the ik solutions given the transformation of the end effector specified by\n"
               "a 3x3 rotation R (rXX), and a 3x1 translation (tX).\n"
               "There are %d free parameters that have to be specified.\n\n",GetNumFreeParameters());
        return 1;
    }

    IkSolutionList<IkReal> solutions;
    std::vector<IkReal> vfree(GetNumFreeParameters());
    IkReal eerot[9],eetrans[3];
    eerot[0] = atof(argv[1]); eerot[1] = atof(argv[2]); eerot[2] = atof(argv[3]); eetrans[0] = atof(argv[4]);
    eerot[3] = atof(argv[5]); eerot[4] = atof(argv[6]); eerot[5] = atof(argv[7]); eetrans[1] = atof(argv[8]);
    eerot[6] = atof(argv[9]); eerot[7] = atof(argv[10]); eerot[8] = atof(argv[11]); eetrans[2] = atof(argv[12]);
    for(std::size_t i = 0; i < vfree.size(); ++i)
        vfree[i] = atof(argv[13+i]);
    bool bSuccess = ComputeIk(eetrans, eerot, vfree.size() > 0 ? &vfree[0] : NULL, solutions);

    if( !bSuccess ) {
        fprintf(stderr,"Failed to get ik solution\n");
        return -1;
    }

    printf("Found %d ik solutions:\n", (int)solutions.GetNumSolutions());
    std::vector<IkReal> solvalues(GetNumJoints());
    for(std::size_t i = 0; i < solutions.GetNumSolutions(); ++i) {
        const IkSolutionBase<IkReal>& sol = solutions.GetSolution(i);
        printf("sol%d (free=%d): ", (int)i, (int)sol.GetFree().size());
        std::vector<IkReal> vsolfree(sol.GetFree().size());
        sol.GetSolution(&solvalues[0],vsolfree.size()>0?&vsolfree[0]:NULL);
        for( std::size_t j = 0; j < solvalues.size(); ++j)
            printf("%.15f, ", solvalues[j]);
        printf("\n");
    }
    return 0;
}

#endif
