;; Regression test LOGISTIC for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST LOGISTIC
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST
    (LIST 82.6131993192451d0 -16.367346042668906d0
	  -9.31513272043762d0 28.87020708710654d0
	  -11.989809875784625d0 -0.6012364762000397d0
	  31.142555263622d0 10.684673721048895d0
	  1.6051840954024446d0 10.457241904701199d0
	  11.523714106294097d0))
   (MULTIPLE-VALUE-LIST
    (LET ((RNG (MAKE-RANDOM-NUMBER-GENERATOR +MT19937+ 0)))
      (LOOP FOR I FROM 0 TO 10 COLLECT
	   (sample rng :logistic :a 10.0d0)))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 0.2350037122015945d0)
   (MULTIPLE-VALUE-LIST (LOGISTIC-PDF 0.5d0 1.0d0)))
  ;; Automatically converted from cdf/test_auto.c
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d10 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d9 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d8 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d7 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1000000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -100000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -10000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -100.0d0 1.3d0) 3.915003559824d-34 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 3.915003559824466d-34 1.3d0) -100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -10.0d0 1.3d0) 4.561157640565d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 4.5611576405646045d-4 1.3d0) -10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.0d0 1.3d0) 0.3166455298122d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.316645529812217d0 1.3d0) -1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -0.1d0 1.3d0) 0.4807787077894d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.4807787077893918d0 1.3d0) -0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -0.01d0 1.3d0) 0.4980769325595d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.4980769325594948d0 1.3d0) -0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -0.001d0 1.3d0) 0.4998076923172d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.4998076923171749d0 1.3d0) -0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-4 1.3d0) 0.4999807692308d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-5 1.3d0) 0.4999980769231d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-6 1.3d0) 0.4999998076923d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-7 1.3d0) 0.4999999807692d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-8 1.3d0) 0.4999999980769d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-9 1.3d0) 0.4999999998077d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P -1.d-10 1.3d0) 0.4999999999808d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 0.0d0 1.3d0) 0.5d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.5d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-10 1.3d0) 0.5000000000192d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-9 1.3d0) 0.5000000001923d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-8 1.3d0) 0.5000000019231d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-7 1.3d0) 0.5000000192308d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-6 1.3d0) 0.5000001923077d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-5 1.3d0) 0.5000019230769d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d-4 1.3d0) 0.5000192307692d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 0.001d0 1.3d0) 0.5001923076828d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.5001923076828251d0 1.3d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 0.01d0 1.3d0) 0.5019230674405d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.5019230674405052d0 1.3d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 0.1d0 1.3d0) 0.5192212922106d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.5192212922106082d0 1.3d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.0d0 1.3d0) 0.6833544701878d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.683354470187783d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 10.0d0 1.3d0) 0.9995438842359d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-PINV 0.9995438842359435d0 1.3d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 100.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 10000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 100000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1000000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d7 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d8 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d9 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-P 1.d10 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d10 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d9 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d8 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d7 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1000000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 100000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 10000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1000.0d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 100.0d0 1.3d0) 3.915003559824d-34 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 3.915003559824466d-34 1.3d0) 100.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 10.0d0 1.3d0) 4.561157640565d-4 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 4.5611576405646045d-4 1.3d0) 10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.0d0 1.3d0) 0.3166455298122d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.316645529812217d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 0.1d0 1.3d0) 0.4807787077894d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.4807787077893918d0 1.3d0) 0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 0.01d0 1.3d0) 0.4980769325595d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.4980769325594948d0 1.3d0) 0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 0.001d0 1.3d0) 0.4998076923172d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.4998076923171749d0 1.3d0) 0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-4 1.3d0) 0.4999807692308d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-5 1.3d0) 0.4999980769231d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-6 1.3d0) 0.4999998076923d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-7 1.3d0) 0.4999999807692d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-8 1.3d0) 0.4999999980769d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-9 1.3d0) 0.4999999998077d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 1.d-10 1.3d0) 0.4999999999808d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q 0.0d0 1.3d0) 0.5d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.5d0 1.3d0) 0.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-10 1.3d0) 0.5000000000192d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-9 1.3d0) 0.5000000001923d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-8 1.3d0) 0.5000000019231d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-7 1.3d0) 0.5000000192308d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-6 1.3d0) 0.5000001923077d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-5 1.3d0) 0.5000019230769d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d-4 1.3d0) 0.5000192307692d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -0.001d0 1.3d0) 0.5001923076828d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.5001923076828251d0 1.3d0) -0.001d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -0.01d0 1.3d0) 0.5019230674405d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.5019230674405052d0 1.3d0) -0.01d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -0.1d0 1.3d0) 0.5192212922106d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.5192212922106082d0 1.3d0) -0.1d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.0d0 1.3d0) 0.6833544701878d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.683354470187783d0 1.3d0) -1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -10.0d0 1.3d0) 0.9995438842359d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-QINV 0.9995438842359435d0 1.3d0) -10.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -100.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -10000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -100000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1000000.0d0 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d7 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d8 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d9 1.3d0) 1.0d0 +TEST-TOL6+)
  (ASSERT-TO-TOLERANCE (LOGISTIC-Q -1.d10 1.3d0) 1.0d0 +TEST-TOL6+))
