;; Regression test ODE for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST ODE
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 495 1.0d0 -1.4568657425802234d0 -11.547345633897558d0)
   (MULTIPLE-VALUE-LIST (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RK2+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 40 1.0d0 -1.4568569264026898d0 -11.547449151779395d0)
   (MULTIPLE-VALUE-LIST (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RK4+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 35 1.0d0 -1.456874342553472d0 -11.547250693698407d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RKF45+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 27 1.0d0 -1.4568588825970334d0 -11.547432342449643d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RKCK+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 16 1.0d0 -1.4568622636249005d0 -11.547385179410822d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RK8PD+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 359 1.0d0 -1.4569507371916566d0 -11.546406519788615d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RK2IMP+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 40 1.0d0 -1.4568644436344684d0 -11.547361181933427d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-RK4IMP+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 9 1.0d0 -1.4568620806209944d0 -11.547387321938151d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-BSIMP+ NIL)))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 11176 1.0d0 -1.459959741392502d0 -11.510866371379606d0)
   (MULTIPLE-VALUE-LIST
    (LET ((*MAX-ITER* 12000))
      (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-GEAR1+ NIL))))
  (LISP-UNIT::ASSERT-NUMERICAL-EQUAL
   (LIST 52 1.0d0 -1.4568645170220367d0 -11.54736019525012d0)
   (MULTIPLE-VALUE-LIST
    (INTEGRATE-VANDERPOL 1.0d0 1.d-4 +STEP-GEAR2+ NIL))))
