;; Regression test POLYNOMIAL for GSLL, automatically generated
;;
;; Copyright 2009 Liam M. Healy
;; Distributed under the terms of the GNU General Public License
;;
;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, see <http://www.gnu.org/licenses/>.

(in-package :gsl)

(LISP-UNIT:DEFINE-TEST
    POLYNOMIAL
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST (LIST 2.5d0 7.2d0 32.7d0 91.0d0))
   (MULTIPLE-VALUE-LIST
    (LET* ((XA
	    (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT :INITIAL-CONTENTS
				     '(0.0d0 1.0d0 2.0d0 3.0d0)))
	   (DD
	    (DIVIDED-DIFFERENCE
	     XA
	     (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT
				      :INITIAL-CONTENTS
				      '(2.5d0 7.2d0
					32.7d0
					91.0d0)))))
      (LIST (EVALUATE XA 0.0d0 :DIVIDED-DIFFERENCE DD)
	    (EVALUATE XA 1.0d0 :DIVIDED-DIFFERENCE DD)
	    (EVALUATE XA 2.0d0 :DIVIDED-DIFFERENCE DD)
	    (EVALUATE XA 3.0d0 :DIVIDED-DIFFERENCE DD)))))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 2.0d0)
   (MULTIPLE-VALUE-LIST
    (LET ((VEC
	   (GRID:MAKE-FOREIGN-ARRAY
	    'DOUBLE-FLOAT :INITIAL-CONTENTS '(1.0d0 2.0d0 3.0d0))))
      (EVALUATE VEC -1.0d0))))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST (LIST) (LIST))
   (MULTIPLE-VALUE-LIST (SOLVE-QUADRATIC 1.0d0 0.0d0 1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0 1.0d0)
   (MULTIPLE-VALUE-LIST (SOLVE-QUADRATIC 1.0d0 -2.0d0 1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(1.0d0 0.0d0) #C(1.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 1.0d0 -2.0d0 1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST -3.000000000000001d0 1.9999999999999996d0
	 7.000000000000001d0)
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC -6.0d0 -13.0d0 42.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-5.551115123125783d-17 -0.9999999999999999d0)
	 #C(-5.551115123125783d-17 0.9999999999999999d0)
	 #C(1.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX -1.0d0 1.0d0 -1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST
    #(#C(-0.8090169943749477d0 0.5877852522924734d0)
      #C(-0.8090169943749477d0 -0.5877852522924734d0)
      #C(0.3090169943749475d0 0.951056516295153d0)
      #C(0.3090169943749475d0 -0.951056516295153d0)
      #C(0.9999999999999999d0 0.0d0)))
   (MULTIPLE-VALUE-LIST
    (grid:COPY-to
     (POLYNOMIAL-SOLVE
      (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT :INITIAL-CONTENTS
			       '(-1.0d0 0.0d0 0.0d0 0.0d0 0.0d0
				 1.0d0))))))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 1.325d0)
   (MULTIPLE-VALUE-LIST
    (EVALUATE
     (GRID:MAKE-FOREIGN-ARRAY 'DOUBLE-FLOAT :INITIAL-CONTENTS
			      '(1.0d0 0.5d0 0.3d0))
     0.5d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 1.0d0)
   (MULTIPLE-VALUE-LIST
    (EVALUATE
     (GRID:MAKE-FOREIGN-ARRAY
      'DOUBLE-FLOAT
      :INITIAL-CONTENTS
      '(1.0d0 -1.0d0 1.0d0 -1.0d0 1.0d0 -1.0d0 1.0d0 -1.0d0 1.0d0 -1.0d0 1.0d0))
     1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST (LIST) (LIST))
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      4.0d0 -20.0d0
				      26.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST 2.5d0 2.5d0)
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      4.0d0 -20.0d0
				      25.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST 1.5d0 3.5d0)
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      4.0d0 -20.0d0
				      21.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST -1.75d0 -0.0d0)
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      4.0d0 7.0d0 0.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST -2.0d0 2.0d0)
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      5.0d0 0.0d0
				      -20.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST 7.0d0 (LIST))
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      0.0d0 3.0d0
				      -21.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST (LIST) (LIST))
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC
				      0.0d0 0.0d0 1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 3.0d0 (LIST) (LIST))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC 0.0d0 0.0d0 -27.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 17.0d0 17.0d0 17.0d0)
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC -51.0d0 867.0d0 -4913.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 17.0d0 17.0d0 23.0d0)
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC -57.0d0 1071.0d0 -6647.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST -23.0d0 17.0d0 17.0d0)
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC -11.0d0 -493.0d0 6647.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST 16.999999999999993d0 31.000000000000004d0 95.0d0)
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC -143.0d0 5087.0d0 -50065.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST -16.999999999999993d0 30.999999999999996d0
	 95.0d0)
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC -109.0d0 803.0d0 50065.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(2.5d0 -0.5d0) #C(2.5d0 0.5d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 4.0d0 -20.0d0 26.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(2.5d0 0.0d0) #C(2.5d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 4.0d0 -20.0d0 25.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(1.5d0 0.0d0) #C(3.5d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 4.0d0 -20.0d0 21.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-1.75d0 0.0d0) #C(-0.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 4.0d0 7.0d0 0.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-2.0d0 0.0d0) #C(2.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 5.0d0 0.0d0 -20.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-0.0d0 -2.0d0) #C(-0.0d0 2.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 5.0d0 0.0d0 20.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(7.0d0 0.0d0) (LIST))
   (MULTIPLE-VALUE-LIST
    (SOLVE-QUADRATIC-COMPLEX 0.0d0 3.0d0 -21.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL (LIST (LIST) (LIST))
				    (MULTIPLE-VALUE-LIST
				     (SOLVE-QUADRATIC-COMPLEX
				      0.0d0 0.0d0 1.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-1.5d0 -2.598076211353316d0)
	 #C(-1.5d0 2.598076211353316d0) #C(3.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX 0.0d0 0.0d0 -27.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-2.9999999999999996d0 0.0d0)
	 #C(1.9999999999999998d0 -2.9999999999999996d0)
	 #C(1.9999999999999998d0 2.9999999999999996d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX -1.0d0 1.0d0 39.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(17.0d0 0.0d0) #C(17.0d0 0.0d0)
	 #C(17.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX -51.0d0 867.0d0 -4913.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(17.0d0 0.0d0) #C(17.0d0 0.0d0)
	 #C(23.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX -57.0d0 1071.0d0 -6647.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(-23.0d0 0.0d0) #C(17.0d0 0.0d0)
	 #C(17.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX -11.0d0 -493.0d0 6647.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST #C(16.999999999999993d0 0.0d0)
	 #C(31.000000000000004d0 0.0d0) #C(95.0d0 0.0d0))
   (MULTIPLE-VALUE-LIST
    (SOLVE-CUBIC-COMPLEX -143.0d0 5087.0d0 -50065.0d0)))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST
    #(#C(0.9999999999999969d0 0.0d0)
      #C(2.000000000000055d0 0.0d0)
      #C(2.9999999999998614d0 0.0d0)
      #C(4.000000000000085d0 0.0d0)
      #C(4.9999999999999964d0 0.0d0)))
   (MULTIPLE-VALUE-LIST
    (grid:COPY-to
     (POLYNOMIAL-SOLVE
      (GRID:MAKE-FOREIGN-ARRAY
       'DOUBLE-FLOAT :INITIAL-CONTENTS
       '(-120.0d0 274.0d0 -225.0d0 85.0d0 -15.0d0 1.0d0))))))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST
    #(#C(-0.8660254037844393d0 0.49999999999999983d0)
      #C(-0.8660254037844393d0 -0.49999999999999983d0)
      #C(-0.5000000000000001d0 0.866025403784439d0)
      #C(-0.5000000000000001d0 -0.866025403784439d0)
      #C(0.4999999999999999d0 0.8660254037844388d0)
      #C(0.4999999999999999d0 -0.8660254037844388d0)
      #C(0.8660254037844388d0 0.4999999999999996d0)
      #C(0.8660254037844388d0 -0.4999999999999996d0)))
   (MULTIPLE-VALUE-LIST
    (grid:COPY-to
     (POLYNOMIAL-SOLVE
      (GRID:MAKE-FOREIGN-ARRAY
       'DOUBLE-FLOAT :INITIAL-CONTENTS
       '(1.0d0 0.0d0 0.0d0 0.0d0 1.0d0 0.0d0 0.0d0 0.0d0 1.0d0))))))
  (LISP-UNIT:ASSERT-NUMERICAL-EQUAL
   (LIST
     #(0.73d0 1.11d0 1.4900000000000002d0 1.84d0 2.3d0 2.41d0 3.07d0)
     #(0.73d0 1.11d0 1.49d0 1.84d0 2.3d0 2.41d0 3.069999999999999d0))
   (LET* ((XA
	   (GRID:MAKE-FOREIGN-ARRAY
	    'DOUBLE-FLOAT :INITIAL-CONTENTS
	    '(0.16d0 0.97d0 1.94d0 2.74d0 3.58d0 3.73d0 4.7d0)))
	  (YA
	   (GRID:MAKE-FOREIGN-ARRAY
	    'DOUBLE-FLOAT :INITIAL-CONTENTS
	    '(0.73d0 1.11d0 1.49d0 1.84d0 2.3d0 2.41d0 3.07d0)))
	  (DD (DIVIDED-DIFFERENCE XA YA)))
     (list
      (MAP 'VECTOR
	   (LAMBDA (X)
	     (EVALUATE XA X :DIVIDED-DIFFERENCE DD))
	   (grid:COPY-to XA))
      (MAP 'VECTOR
	   (LAMBDA (X)
	     (EVALUATE
	      (TAYLOR-DIVIDED-DIFFERENCE 1.5d0 DD XA)
	      (- X 1.5d0)))
	   (grid:COPY-to XA))))))

