;;
;; DO NOT EDIT THIS FILE
;;
;; this file is automatically generated from /home/k-okada/ros/groovy/rtm-ros-robotics/rtmros_hironx/hironx_ros_bridge/models/kawada-hironx.dae on (Linux kokada-t430s 3.2.0-49-generic x86_64) at Fri Aug 30 21:17:18 2013

;;
;; /home/k-okada/ros/groovy/rtm-ros-robotics/rtmros_hironx/hironx_ros_bridge/build $ /home/k-okada/ros/groovy/jsk-ros-pkg/jsk_model_tools/euscollada/bin/collada2eus /home/k-okada/ros/groovy/rtm-ros-robotics/rtmros_hironx/hironx_ros_bridge/models/kawada-hironx.dae /home/k-okada/ros/groovy/rtm-ros-robotics/rtmros_hironx/hironx_ros_bridge/models/kawada-hironx.yaml /home/k-okada/ros/groovy/rtm-ros-robotics/rtmros_hironx/hironx_ros_bridge/models/kawada-hironx.l 
;;

;; copy euscollada-robot class definition from euscollada/src/euscollada-robot.l
;;
;; This euscollada-robot class is for robots converted from collada files.
;; This class provides :init-ending override.
(defclass euscollada-robot
  :super robot-model
  :slots ()
  )
(defmethod euscollada-robot
  (:init-ending
   ()
   ;; fix all links' mass properties ;; root link relative (collada) -> link local (euslisp)
   (dolist (l links)
     (setq (l . acentroid) (send l :inverse-transform-vector
                                 (send (send (car links) :worldcoords) :transform-vector
                                       (l . acentroid))))
     (setq (l . inertia-tensor) (m* (transpose (send l :worldrot))
                                    (m* (send (car links) :worldrot)
                                        (l . inertia-tensor))))
     )
   (send-super :init-ending)

   ;;
   (dolist (j (mapcan #'(lambda (x) (if (and (derivedp (cdr x) joint)
					     (not (memq (cdr x) (send self :joint-list))))
					(list (cdr x)))) (send self :slots)))
     (send (send j :child-link) :add-joint j)
     (send (send j :child-link) :add-parent-link (send j :parent-link))
     (send (send j :parent-link) :add-child-links (send j :child-link)))
   ;; add sensor method ;; e.g., (send self :camera 0), (send self :force-sensor :rasensor), ... etc
   (dolist (sensor-name '(:force-sensor :imu-sensor))
     (eval `(defmethod ,(send (class self) :name)
              (,sensor-name (&rest args)
                            (cond ((integerp (car args))
                                   (forward-message-to (elt (send self ,(read-from-string (format nil "~As" sensor-name)) ) (car args)) (cdr args)))
                                  ;; enable to access sensors by limb name
                                  ((memq (car args) '(:larm :rarm :lleg :rleg :head :torso))
                                   (find-if
                                    #'(lambda (x) (member (send x :parent) (send self (car args))))
                                    (send self ,(read-from-string (format nil "~As" sensor-name)))))
                                  ((and (keywordp (car args))
                                        (derivedp (send self (car args)) cascaded-coords))
                                   (send* self args))
                                  ((keywordp (car args))
                                   ;;(warn ";; no such sensor ~A~%" (car args))
                                   nil)
                                  (t
                                   (forward-message-to (car (send self ,(read-from-string (format nil "~As" sensor-name)))) args)
                                   )))
              )))
   )
  ;; fullbody-inverse-kinematics overwrite
  ;;  reduce root-link's weight based on leg's joint limit
  ;;  increase stop and cog-gain
  (:fullbody-inverse-kinematics
   (target-coords &rest args &key (stop 250) (cog-gain 2.0) &allow-other-keys)
   (let* ((leg-ul (send self :calc-union-link-list (send self :legs :links))))
     (send self :reset-joint-angle-limit-weight-old leg-ul)
     (send-message* self robot-model :fullbody-inverse-kinematics
                    target-coords
                    :stop stop :cog-gain cog-gain
                    :weight #'(lambda (ul)
                                (let ((tw (fill (instantiate float-vector (send self :calc-target-joint-dimension ul)) 1.0)))
                                  ;; set root-link 6dof-joint's weight based on legs' joint limit
                                  (let* ((min-weight
                                          (reduce #'(lambda (x y) (min x y))
                                                  (coerce (send self :calc-inverse-kinematics-weight-from-link-list
                                                                leg-ul :union-link-list leg-ul) cons))))
                                    (dotimes (i 6) (setf (elt tw i) (* min-weight (elt tw i)))))
                                  ;; additional weight setting
                                  (if (memq :weight args)
                                      (let ((tmp-weight2 (funcall (cadr (memq :weight args)) ul)))
                                        (dotimes (i (length tmp-weight2)) (setf (elt tw i) (* (elt tw i) (elt tmp-weight2 i))))))
                                  tw))
                    args)
     ))
  )
;;
(defun HiroNX () (setq *HiroNX* (instance HiroNX-robot :init)))

(defclass HiroNX-robot
  :super euscollada-robot
  :slots (WAIST_JOINT_jt CHEST_JOINT0_jt HEAD_JOINT0_jt HEAD_JOINT1_jt RARM_JOINT0_jt RARM_JOINT1_jt RARM_JOINT2_jt RARM_JOINT3_jt RARM_JOINT4_jt RARM_JOINT5_jt RHAND_JOINT0_jt RHAND_JOINT1_jt RHAND_JOINT2_jt RHAND_JOINT3_jt LARM_JOINT0_jt LARM_JOINT1_jt LARM_JOINT2_jt LARM_JOINT3_jt LARM_JOINT4_jt LARM_JOINT5_jt LHAND_JOINT0_jt LHAND_JOINT1_jt LHAND_JOINT2_jt LHAND_JOINT3_jt HEAD_JOINT1_Link_lk HEAD_JOINT0_Link_lk RHAND_JOINT1_Link_lk RHAND_JOINT0_Link_lk RHAND_JOINT3_Link_lk RHAND_JOINT2_Link_lk RARM_JOINT5_Link_lk RARM_JOINT4_Link_lk RARM_JOINT3_Link_lk RARM_JOINT2_Link_lk RARM_JOINT1_Link_lk RARM_JOINT0_Link_lk LHAND_JOINT1_Link_lk LHAND_JOINT0_Link_lk LHAND_JOINT3_Link_lk LHAND_JOINT2_Link_lk LARM_JOINT5_Link_lk LARM_JOINT4_Link_lk LARM_JOINT3_Link_lk LARM_JOINT2_Link_lk LARM_JOINT1_Link_lk LARM_JOINT0_Link_lk CHEST_JOINT0_Link_lk WAIST_lk rightarm-frame-tip rightarm_torso-frame-tip leftarm-frame-tip leftarm_torso-frame-tip head-frame-tip head_torso-frame-tip ))
(defmethod HiroNX-robot
  (:init
   (&rest args)
   (let ()
     (send-super* :init :name "HiroNX" args)

     ;; node id=v1.node3, name=HEAD_JOINT1_Link, sid=node3
     (let ( b_g1_3_geom0)
       ;; define bodyset-link for HEAD_JOINT1_Link : v1.node3
       (setq b_g1_3_geom0 (instance HiroNX_g1_3_geom0 :init))

       ;; writeTransform(name=b_g1_3_geom0,domNode=HEAD_JOINT1_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_3_geom0 :transform localcds :world)
       )
       (setq HEAD_JOINT1_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_3_geom0)
                       :name "HEAD_JOINT1_Link"
                       :weight 80.859))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 569.500) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.005 -16.678 16.315) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (HEAD_JOINT1_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (HEAD_JOINT1_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=HEAD_JOINT1_Link_lk,domNode=HEAD_JOINT1_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send HEAD_JOINT1_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 1.000000 0.000000)) :local)
       ;;1;
       )

     ;; node id=v1.node2, name=HEAD_JOINT0_Link, sid=node2
     (let ( b_g1_2_geom0)
       ;; define bodyset-link for HEAD_JOINT0_Link : v1.node2
       (setq b_g1_2_geom0 (instance HiroNX_g1_2_geom0 :init))

       ;; writeTransform(name=b_g1_2_geom0,domNode=HEAD_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_2_geom0 :transform localcds :world)
       )
       (setq HEAD_JOINT0_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_2_geom0)
                       :name "HEAD_JOINT0_Link"
                       :weight 317.929))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 569.500) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.023 5.478 -7.840) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (HEAD_JOINT0_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (HEAD_JOINT0_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=HEAD_JOINT0_Link_lk,domNode=HEAD_JOINT0_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send HEAD_JOINT0_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 569.500000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=HEAD_JOINT1_Link_lk,domNode=HEAD_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 569.500000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send HEAD_JOINT1_Link_lk :transform localcds :world)
       )
       ;;2;
       (send HEAD_JOINT0_Link_lk :assoc HEAD_JOINT1_Link_lk)
       )

     ;; node id=v1.node11, name=RHAND_JOINT1_Link, sid=node11
     (let ( b_g1_11_geom0)
       ;; define bodyset-link for RHAND_JOINT1_Link : v1.node11
       (setq b_g1_11_geom0 (instance HiroNX_g1_11_geom0 :init))

       ;; writeTransform(name=b_g1_11_geom0,domNode=RHAND_JOINT1_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_11_geom0 :transform localcds :world)
       )
       (setq RHAND_JOINT1_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_11_geom0)
                       :name "RHAND_JOINT1_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 -33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -41.900 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RHAND_JOINT1_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RHAND_JOINT1_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RHAND_JOINT1_Link_lk,domNode=RHAND_JOINT1_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RHAND_JOINT1_Link_lk :transform
             (make-coords :pos (float-vector -41.900000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;
       )

     ;; node id=v1.node10, name=RHAND_JOINT0_Link, sid=node10
     (let ( b_g1_10_geom0)
       ;; define bodyset-link for RHAND_JOINT0_Link : v1.node10
       (setq b_g1_10_geom0 (instance HiroNX_g1_10_geom0 :init))

       ;; writeTransform(name=b_g1_10_geom0,domNode=RHAND_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_10_geom0 :transform localcds :world)
       )
       (setq RHAND_JOINT0_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_10_geom0)
                       :name "RHAND_JOINT0_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 -33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RHAND_JOINT0_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RHAND_JOINT0_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RHAND_JOINT0_Link_lk,domNode=RHAND_JOINT0_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RHAND_JOINT0_Link_lk :transform
             (make-coords :pos (float-vector -29.900000 -33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RHAND_JOINT1_Link_lk,domNode=RHAND_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -29.900000 -33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RHAND_JOINT1_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RHAND_JOINT0_Link_lk :assoc RHAND_JOINT1_Link_lk)
       )

     ;; node id=v1.node13, name=RHAND_JOINT3_Link, sid=node13
     (let ( b_g1_13_geom0)
       ;; define bodyset-link for RHAND_JOINT3_Link : v1.node13
       (setq b_g1_13_geom0 (instance HiroNX_g1_13_geom0 :init))

       ;; writeTransform(name=b_g1_13_geom0,domNode=RHAND_JOINT3_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_13_geom0 :transform localcds :world)
       )
       (setq RHAND_JOINT3_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_13_geom0)
                       :name "RHAND_JOINT3_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -41.900 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RHAND_JOINT3_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RHAND_JOINT3_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RHAND_JOINT3_Link_lk,domNode=RHAND_JOINT3_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RHAND_JOINT3_Link_lk :transform
             (make-coords :pos (float-vector -41.900000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;
       )

     ;; node id=v1.node12, name=RHAND_JOINT2_Link, sid=node12
     (let ( b_g1_12_geom0)
       ;; define bodyset-link for RHAND_JOINT2_Link : v1.node12
       (setq b_g1_12_geom0 (instance HiroNX_g1_12_geom0 :init))

       ;; writeTransform(name=b_g1_12_geom0,domNode=RHAND_JOINT2_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_12_geom0 :transform localcds :world)
       )
       (setq RHAND_JOINT2_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_12_geom0)
                       :name "RHAND_JOINT2_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RHAND_JOINT2_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RHAND_JOINT2_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RHAND_JOINT2_Link_lk,domNode=RHAND_JOINT2_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RHAND_JOINT2_Link_lk :transform
             (make-coords :pos (float-vector -29.900000 33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RHAND_JOINT3_Link_lk,domNode=RHAND_JOINT2_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -29.900000 33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RHAND_JOINT3_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RHAND_JOINT2_Link_lk :assoc RHAND_JOINT3_Link_lk)
       )

     ;; node id=v1.node9, name=RARM_JOINT5_Link, sid=node9
     (let ( b_g1_9_geom0)
       ;; define bodyset-link for RARM_JOINT5_Link : v1.node9
       (setq b_g1_9_geom0 (instance HiroNX_g1_9_geom0 :init))

       ;; writeTransform(name=b_g1_9_geom0,domNode=RARM_JOINT5_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_9_geom0 :transform localcds :world)
       )
       (setq RARM_JOINT5_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_9_geom0)
                       :name "RARM_JOINT5_Link"
                       :weight 1051.560))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -48.476 0.003 -38.899) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RARM_JOINT5_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RARM_JOINT5_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RARM_JOINT5_Link_lk,domNode=RARM_JOINT5_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RARM_JOINT5_Link_lk :transform
             (make-coords :pos (float-vector -40.000000 0.000000 -90.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RHAND_JOINT0_Link_lk,domNode=RARM_JOINT5_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -40.000000 0.000000 -90.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RHAND_JOINT0_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT5_Link_lk :assoc RHAND_JOINT0_Link_lk)

       ;; writeTransform(name=RHAND_JOINT2_Link_lk,domNode=RARM_JOINT5_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -40.000000 0.000000 -90.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RHAND_JOINT2_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT5_Link_lk :assoc RHAND_JOINT2_Link_lk)
       )

     ;; node id=v1.node8, name=RARM_JOINT4_Link, sid=node8
     (let ( b_g1_8_geom0)
       ;; define bodyset-link for RARM_JOINT4_Link : v1.node8
       (setq b_g1_8_geom0 (instance HiroNX_g1_8_geom0 :init))

       ;; writeTransform(name=b_g1_8_geom0,domNode=RARM_JOINT4_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_8_geom0 :transform localcds :world)
       )
       (setq RARM_JOINT4_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_8_geom0)
                       :name "RARM_JOINT4_Link"
                       :weight 418.434))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 2.431 -3.797 -57.704) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RARM_JOINT4_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RARM_JOINT4_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RARM_JOINT4_Link_lk,domNode=RARM_JOINT4_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RARM_JOINT4_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 -235.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RARM_JOINT5_Link_lk,domNode=RARM_JOINT4_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 -235.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RARM_JOINT5_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT4_Link_lk :assoc RARM_JOINT5_Link_lk)
       )

     ;; node id=v1.node7, name=RARM_JOINT3_Link, sid=node7
     (let ( b_g1_7_geom0)
       ;; define bodyset-link for RARM_JOINT3_Link : v1.node7
       (setq b_g1_7_geom0 (instance HiroNX_g1_7_geom0 :init))

       ;; writeTransform(name=b_g1_7_geom0,domNode=RARM_JOINT3_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_7_geom0 :transform localcds :world)
       )
       (setq RARM_JOINT3_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_7_geom0)
                       :name "RARM_JOINT3_Link"
                       :weight 457.418))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.018 3.958 -202.731) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RARM_JOINT3_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RARM_JOINT3_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RARM_JOINT3_Link_lk,domNode=RARM_JOINT3_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RARM_JOINT3_Link_lk :transform
             (make-coords :pos (float-vector -30.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RARM_JOINT4_Link_lk,domNode=RARM_JOINT3_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -30.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RARM_JOINT4_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT3_Link_lk :assoc RARM_JOINT4_Link_lk)
       )

     ;; node id=v1.node6, name=RARM_JOINT2_Link, sid=node6
     (let ( b_g1_6_geom0)
       ;; define bodyset-link for RARM_JOINT2_Link : v1.node6
       (setq b_g1_6_geom0 (instance HiroNX_g1_6_geom0 :init))

       ;; writeTransform(name=b_g1_6_geom0,domNode=RARM_JOINT2_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_6_geom0 :transform localcds :world)
       )
       (setq RARM_JOINT2_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_6_geom0)
                       :name "RARM_JOINT2_Link"
                       :weight 577.518))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.023 -1.671 -71.512) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RARM_JOINT2_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RARM_JOINT2_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RARM_JOINT2_Link_lk,domNode=RARM_JOINT2_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RARM_JOINT2_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 -95.000000 -250.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RARM_JOINT3_Link_lk,domNode=RARM_JOINT2_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 -95.000000 -250.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RARM_JOINT3_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT2_Link_lk :assoc RARM_JOINT3_Link_lk)
       )

     ;; node id=v1.node5, name=RARM_JOINT1_Link, sid=node5
     (let ( b_g1_5_geom0)
       ;; define bodyset-link for RARM_JOINT1_Link : v1.node5
       (setq b_g1_5_geom0 (instance HiroNX_g1_5_geom0 :init))

       ;; writeTransform(name=b_g1_5_geom0,domNode=RARM_JOINT1_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_5_geom0 :transform localcds :world)
       )
       (setq RARM_JOINT1_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_5_geom0)
                       :name "RARM_JOINT1_Link"
                       :weight 1148.980))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.052 -58.313 -107.061) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RARM_JOINT1_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RARM_JOINT1_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RARM_JOINT1_Link_lk,domNode=RARM_JOINT1_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RARM_JOINT1_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=RARM_JOINT2_Link_lk,domNode=RARM_JOINT1_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RARM_JOINT2_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT1_Link_lk :assoc RARM_JOINT2_Link_lk)
       )

     ;; node id=v1.node4, name=RARM_JOINT0_Link, sid=node4
     (let ( b_g1_4_geom0)
       ;; define bodyset-link for RARM_JOINT0_Link : v1.node4
       (setq b_g1_4_geom0 (instance HiroNX_g1_4_geom0 :init))

       ;; writeTransform(name=b_g1_4_geom0,domNode=RARM_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_4_geom0 :transform localcds :world)
       )
       (setq RARM_JOINT0_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_4_geom0)
                       :name "RARM_JOINT0_Link"
                       :weight 1326.260))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 -145.000 370.296) :rot (matrix-exponent (scale 0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector -2.264 5.214 15.608) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (RARM_JOINT0_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (RARM_JOINT0_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=RARM_JOINT0_Link_lk,domNode=RARM_JOINT0_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send RARM_JOINT0_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 -145.000000 370.296000)
                          :angle 0.261799 :axis (float-vector 1.000000 0.000000 0.000000)) :local)
       ;;1;

       ;; writeTransform(name=RARM_JOINT1_Link_lk,domNode=RARM_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 -145.000000 370.296000)
                          :angle 0.261799 :axis (float-vector 1.000000 0.000000 0.000000)) :local)
       (send RARM_JOINT1_Link_lk :transform localcds :world)
       )
       ;;2;
       (send RARM_JOINT0_Link_lk :assoc RARM_JOINT1_Link_lk)
       )

     ;; node id=v1.node21, name=LHAND_JOINT1_Link, sid=node21
     (let ( b_g1_21_geom0)
       ;; define bodyset-link for LHAND_JOINT1_Link : v1.node21
       (setq b_g1_21_geom0 (instance HiroNX_g1_21_geom0 :init))

       ;; writeTransform(name=b_g1_21_geom0,domNode=LHAND_JOINT1_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_21_geom0 :transform localcds :world)
       )
       (setq LHAND_JOINT1_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_21_geom0)
                       :name "LHAND_JOINT1_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 -33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -41.900 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LHAND_JOINT1_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LHAND_JOINT1_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LHAND_JOINT1_Link_lk,domNode=LHAND_JOINT1_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LHAND_JOINT1_Link_lk :transform
             (make-coords :pos (float-vector -41.900000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;
       )

     ;; node id=v1.node20, name=LHAND_JOINT0_Link, sid=node20
     (let ( b_g1_20_geom0)
       ;; define bodyset-link for LHAND_JOINT0_Link : v1.node20
       (setq b_g1_20_geom0 (instance HiroNX_g1_20_geom0 :init))

       ;; writeTransform(name=b_g1_20_geom0,domNode=LHAND_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_20_geom0 :transform localcds :world)
       )
       (setq LHAND_JOINT0_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_20_geom0)
                       :name "LHAND_JOINT0_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 -33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LHAND_JOINT0_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LHAND_JOINT0_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LHAND_JOINT0_Link_lk,domNode=LHAND_JOINT0_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LHAND_JOINT0_Link_lk :transform
             (make-coords :pos (float-vector -29.900000 -33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LHAND_JOINT1_Link_lk,domNode=LHAND_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -29.900000 -33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LHAND_JOINT1_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LHAND_JOINT0_Link_lk :assoc LHAND_JOINT1_Link_lk)
       )

     ;; node id=v1.node23, name=LHAND_JOINT3_Link, sid=node23
     (let ( b_g1_23_geom0)
       ;; define bodyset-link for LHAND_JOINT3_Link : v1.node23
       (setq b_g1_23_geom0 (instance HiroNX_g1_23_geom0 :init))

       ;; writeTransform(name=b_g1_23_geom0,domNode=LHAND_JOINT3_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_23_geom0 :transform localcds :world)
       )
       (setq LHAND_JOINT3_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_23_geom0)
                       :name "LHAND_JOINT3_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -41.900 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LHAND_JOINT3_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LHAND_JOINT3_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LHAND_JOINT3_Link_lk,domNode=LHAND_JOINT3_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LHAND_JOINT3_Link_lk :transform
             (make-coords :pos (float-vector -41.900000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;
       )

     ;; node id=v1.node22, name=LHAND_JOINT2_Link, sid=node22
     (let ( b_g1_22_geom0)
       ;; define bodyset-link for LHAND_JOINT2_Link : v1.node22
       (setq b_g1_22_geom0 (instance HiroNX_g1_22_geom0 :init))

       ;; writeTransform(name=b_g1_22_geom0,domNode=LHAND_JOINT2_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_22_geom0 :transform localcds :world)
       )
       (setq LHAND_JOINT2_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_22_geom0)
                       :name "LHAND_JOINT2_Link"
                       :weight 10.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -29.900 33.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LHAND_JOINT2_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LHAND_JOINT2_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LHAND_JOINT2_Link_lk,domNode=LHAND_JOINT2_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LHAND_JOINT2_Link_lk :transform
             (make-coords :pos (float-vector -29.900000 33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LHAND_JOINT3_Link_lk,domNode=LHAND_JOINT2_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -29.900000 33.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LHAND_JOINT3_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LHAND_JOINT2_Link_lk :assoc LHAND_JOINT3_Link_lk)
       )

     ;; node id=v1.node19, name=LARM_JOINT5_Link, sid=node19
     (let ( b_g1_19_geom0)
       ;; define bodyset-link for LARM_JOINT5_Link : v1.node19
       (setq b_g1_19_geom0 (instance HiroNX_g1_19_geom0 :init))

       ;; writeTransform(name=b_g1_19_geom0,domNode=LARM_JOINT5_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_19_geom0 :transform localcds :world)
       )
       (setq LARM_JOINT5_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_19_geom0)
                       :name "LARM_JOINT5_Link"
                       :weight 1051.560))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -40.000 0.000 -90.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -48.476 -0.003 -38.899) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LARM_JOINT5_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LARM_JOINT5_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LARM_JOINT5_Link_lk,domNode=LARM_JOINT5_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LARM_JOINT5_Link_lk :transform
             (make-coords :pos (float-vector -40.000000 0.000000 -90.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LHAND_JOINT0_Link_lk,domNode=LARM_JOINT5_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -40.000000 0.000000 -90.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LHAND_JOINT0_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT5_Link_lk :assoc LHAND_JOINT0_Link_lk)

       ;; writeTransform(name=LHAND_JOINT2_Link_lk,domNode=LARM_JOINT5_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -40.000000 0.000000 -90.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LHAND_JOINT2_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT5_Link_lk :assoc LHAND_JOINT2_Link_lk)
       )

     ;; node id=v1.node18, name=LARM_JOINT4_Link, sid=node18
     (let ( b_g1_18_geom0)
       ;; define bodyset-link for LARM_JOINT4_Link : v1.node18
       (setq b_g1_18_geom0 (instance HiroNX_g1_18_geom0 :init))

       ;; writeTransform(name=b_g1_18_geom0,domNode=LARM_JOINT4_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_18_geom0 :transform localcds :world)
       )
       (setq LARM_JOINT4_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_18_geom0)
                       :name "LARM_JOINT4_Link"
                       :weight 418.434))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 -235.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 2.431 3.797 -57.704) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LARM_JOINT4_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LARM_JOINT4_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LARM_JOINT4_Link_lk,domNode=LARM_JOINT4_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LARM_JOINT4_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 -235.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LARM_JOINT5_Link_lk,domNode=LARM_JOINT4_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 -235.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LARM_JOINT5_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT4_Link_lk :assoc LARM_JOINT5_Link_lk)
       )

     ;; node id=v1.node17, name=LARM_JOINT3_Link, sid=node17
     (let ( b_g1_17_geom0)
       ;; define bodyset-link for LARM_JOINT3_Link : v1.node17
       (setq b_g1_17_geom0 (instance HiroNX_g1_17_geom0 :init))

       ;; writeTransform(name=b_g1_17_geom0,domNode=LARM_JOINT3_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_17_geom0 :transform localcds :world)
       )
       (setq LARM_JOINT3_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_17_geom0)
                       :name "LARM_JOINT3_Link"
                       :weight 457.418))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -30.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.018 -3.958 -202.731) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LARM_JOINT3_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LARM_JOINT3_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LARM_JOINT3_Link_lk,domNode=LARM_JOINT3_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LARM_JOINT3_Link_lk :transform
             (make-coords :pos (float-vector -30.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LARM_JOINT4_Link_lk,domNode=LARM_JOINT3_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector -30.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LARM_JOINT4_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT3_Link_lk :assoc LARM_JOINT4_Link_lk)
       )

     ;; node id=v1.node16, name=LARM_JOINT2_Link, sid=node16
     (let ( b_g1_16_geom0)
       ;; define bodyset-link for LARM_JOINT2_Link : v1.node16
       (setq b_g1_16_geom0 (instance HiroNX_g1_16_geom0 :init))

       ;; writeTransform(name=b_g1_16_geom0,domNode=LARM_JOINT2_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_16_geom0 :transform localcds :world)
       )
       (setq LARM_JOINT2_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_16_geom0)
                       :name "LARM_JOINT2_Link"
                       :weight 577.518))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 95.000 -250.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.023 1.671 -71.512) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LARM_JOINT2_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LARM_JOINT2_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LARM_JOINT2_Link_lk,domNode=LARM_JOINT2_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LARM_JOINT2_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 95.000000 -250.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LARM_JOINT3_Link_lk,domNode=LARM_JOINT2_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 95.000000 -250.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LARM_JOINT3_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT2_Link_lk :assoc LARM_JOINT3_Link_lk)
       )

     ;; node id=v1.node15, name=LARM_JOINT1_Link, sid=node15
     (let ( b_g1_15_geom0)
       ;; define bodyset-link for LARM_JOINT1_Link : v1.node15
       (setq b_g1_15_geom0 (instance HiroNX_g1_15_geom0 :init))

       ;; writeTransform(name=b_g1_15_geom0,domNode=LARM_JOINT1_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_15_geom0 :transform localcds :world)
       )
       (setq LARM_JOINT1_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_15_geom0)
                       :name "LARM_JOINT1_Link"
                       :weight 1148.980))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector -0.052 58.313 -107.061) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LARM_JOINT1_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LARM_JOINT1_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LARM_JOINT1_Link_lk,domNode=LARM_JOINT1_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LARM_JOINT1_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=LARM_JOINT2_Link_lk,domNode=LARM_JOINT1_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LARM_JOINT2_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT1_Link_lk :assoc LARM_JOINT2_Link_lk)
       )

     ;; node id=v1.node14, name=LARM_JOINT0_Link, sid=node14
     (let ( b_g1_14_geom0)
       ;; define bodyset-link for LARM_JOINT0_Link : v1.node14
       (setq b_g1_14_geom0 (instance HiroNX_g1_14_geom0 :init))

       ;; writeTransform(name=b_g1_14_geom0,domNode=LARM_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_14_geom0 :transform localcds :world)
       )
       (setq LARM_JOINT0_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_14_geom0)
                       :name "LARM_JOINT0_Link"
                       :weight 1326.260))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 145.000 370.296) :rot (matrix-exponent (scale -0.261799 (float-vector 1.000000 0.000000 0.000000))))
                          (make-coords :pos (float-vector -2.264 -5.214 15.608) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (LARM_JOINT0_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (LARM_JOINT0_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=LARM_JOINT0_Link_lk,domNode=LARM_JOINT0_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send LARM_JOINT0_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 145.000000 370.296000)
                          :angle -0.261799 :axis (float-vector 1.000000 0.000000 0.000000)) :local)
       ;;1;

       ;; writeTransform(name=LARM_JOINT1_Link_lk,domNode=LARM_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 145.000000 370.296000)
                          :angle -0.261799 :axis (float-vector 1.000000 0.000000 0.000000)) :local)
       (send LARM_JOINT1_Link_lk :transform localcds :world)
       )
       ;;2;
       (send LARM_JOINT0_Link_lk :assoc LARM_JOINT1_Link_lk)
       )

     ;; node id=v1.node1, name=CHEST_JOINT0_Link, sid=node1
     (let ( b_g1_1_geom0 b_g1_1_geom1)
       ;; define bodyset-link for CHEST_JOINT0_Link : v1.node1
       (setq b_g1_1_geom0 (instance HiroNX_g1_1_geom0 :init))

       ;; writeTransform(name=b_g1_1_geom0,domNode=CHEST_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_1_geom0 :transform localcds :world)
       )
       (setq b_g1_1_geom1 (instance HiroNX_g1_1_geom1 :init))

       ;; writeTransform(name=b_g1_1_geom1,domNode=CHEST_JOINT0_Link,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_1_geom1 :transform localcds :world)
       )
       (send b_g1_1_geom0 :assoc b_g1_1_geom1)
       (setq CHEST_JOINT0_Link_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_1_geom0 b_g1_1_geom1)
                       :name "CHEST_JOINT0_Link"
                       :weight 0.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 0.000000 1.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (CHEST_JOINT0_Link_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (CHEST_JOINT0_Link_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=CHEST_JOINT0_Link_lk,domNode=CHEST_JOINT0_Link,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send CHEST_JOINT0_Link_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       ;;1;

       ;; writeTransform(name=HEAD_JOINT0_Link_lk,domNode=CHEST_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send HEAD_JOINT0_Link_lk :transform localcds :world)
       )
       ;;2;
       (send CHEST_JOINT0_Link_lk :assoc HEAD_JOINT0_Link_lk)

       ;; writeTransform(name=RARM_JOINT0_Link_lk,domNode=CHEST_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send RARM_JOINT0_Link_lk :transform localcds :world)
       )
       ;;2;
       (send CHEST_JOINT0_Link_lk :assoc RARM_JOINT0_Link_lk)

       ;; writeTransform(name=LARM_JOINT0_Link_lk,domNode=CHEST_JOINT0_Link,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 0.000000 1.000000)) :local)
       (send LARM_JOINT0_Link_lk :transform localcds :world)
       )
       ;;2;
       (send CHEST_JOINT0_Link_lk :assoc LARM_JOINT0_Link_lk)
       )

     ;; node id=v1.node0, name=WAIST, sid=node0
     (let ( b_g1_0_geom0)
       ;; define bodyset-link for WAIST : v1.node0
       (setq b_g1_0_geom0 (instance HiroNX_g1_0_geom0 :init))

       ;; writeTransform(name=b_g1_0_geom0,domNode=WAIST,targetCount=1,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send b_g1_0_geom0 :transform localcds :world)
       )
       (setq WAIST_lk
             (instance bodyset-link
                       :init (make-cascoords)
                       :bodies (list  b_g1_0_geom0)
                       :name "WAIST"
                       :weight 0.000))
       (let ((tmp-c-list (list
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 0.000000 1.000000 0.000000))))
                          (make-coords :pos (float-vector 0.000 0.000 0.000) :rot (matrix-exponent (scale 0.000000 (float-vector 1.000000 0.000000 0.000000))))
                          ))
             (tmp-c (make-coords)))
         (dolist (cc tmp-c-list)
           (setq tmp-c (send tmp-c :transform cc)))
         (setq (WAIST_lk . inertia-tensor)
               (m* (send tmp-c :worldrot) (diagonal (float-vector 0.000 0.000 0.000)) (transpose (send tmp-c :worldrot))))
         (setq (WAIST_lk . acentroid) (send tmp-c :worldpos))
        )

       ;; writeTransform(name=WAIST_lk,domNode=WAIST,targetCount=0,parent=:local), translateCount=1, rotateCount=2, matrixCount=0
       (send WAIST_lk :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 1.000000 0.000000)) :local)
       ;;1;

       ;; writeTransform(name=CHEST_JOINT0_Link_lk,domNode=WAIST,targetCount=0,parent=:world), translateCount=1, rotateCount=2, matrixCount=0
       (let ((localcds (make-coords)))
       (send localcds :transform
             (make-coords :pos (float-vector 0.000000 0.000000 0.000000)
                          :angle 0.000000 :axis (float-vector 0.000000 1.000000 0.000000)) :local)
       (send CHEST_JOINT0_Link_lk :transform localcds :world)
       )
       ;;2;
       (send WAIST_lk :assoc CHEST_JOINT0_Link_lk)
       )

     (send self :assoc WAIST_lk)
     (setq HEAD_JOINT1_jt
           (instance rotational-joint :init
                     :name "HEAD_JOINT1"
                     :parent-link HEAD_JOINT0_Link_lk :child-link HEAD_JOINT1_Link_lk
                     :max-joint-velocity 4.363320
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -20.000000 :max 70.000000
                     ))
     (setq RHAND_JOINT1_jt
           (instance rotational-joint :init
                     :name "RHAND_JOINT1"
                     :parent-link RHAND_JOINT0_Link_lk :child-link RHAND_JOINT1_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq RHAND_JOINT3_jt
           (instance rotational-joint :init
                     :name "RHAND_JOINT3"
                     :parent-link RHAND_JOINT2_Link_lk :child-link RHAND_JOINT3_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq RHAND_JOINT0_jt
           (instance rotational-joint :init
                     :name "RHAND_JOINT0"
                     :parent-link RARM_JOINT5_Link_lk :child-link RHAND_JOINT0_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq RHAND_JOINT2_jt
           (instance rotational-joint :init
                     :name "RHAND_JOINT2"
                     :parent-link RARM_JOINT5_Link_lk :child-link RHAND_JOINT2_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq RARM_JOINT5_jt
           (instance rotational-joint :init
                     :name "RARM_JOINT5"
                     :parent-link RARM_JOINT4_Link_lk :child-link RARM_JOINT5_Link_lk
                     :max-joint-velocity 5.235990
                     :axis (let ((tmp-axis (float-vector 1.000000 0.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -163.000000 :max 163.000000
                     ))
     (setq RARM_JOINT4_jt
           (instance rotational-joint :init
                     :name "RARM_JOINT4"
                     :parent-link RARM_JOINT3_Link_lk :child-link RARM_JOINT4_Link_lk
                     :max-joint-velocity 4.363320
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -100.000000 :max 100.000000
                     ))
     (setq RARM_JOINT3_jt
           (instance rotational-joint :init
                     :name "RARM_JOINT3"
                     :parent-link RARM_JOINT2_Link_lk :child-link RARM_JOINT3_Link_lk
                     :max-joint-velocity 2.617990
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -165.000000 :max 105.000000
                     ))
     (setq RARM_JOINT2_jt
           (instance rotational-joint :init
                     :name "RARM_JOINT2"
                     :parent-link RARM_JOINT1_Link_lk :child-link RARM_JOINT2_Link_lk
                     :max-joint-velocity 3.996800
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -158.000000 :max 0.000000
                     ))
     (setq RARM_JOINT1_jt
           (instance rotational-joint :init
                     :name "RARM_JOINT1"
                     :parent-link RARM_JOINT0_Link_lk :child-link RARM_JOINT1_Link_lk
                     :max-joint-velocity 2.321290
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -140.000000 :max 60.000000
                     ))
     (setq LHAND_JOINT1_jt
           (instance rotational-joint :init
                     :name "LHAND_JOINT1"
                     :parent-link LHAND_JOINT0_Link_lk :child-link LHAND_JOINT1_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq LHAND_JOINT3_jt
           (instance rotational-joint :init
                     :name "LHAND_JOINT3"
                     :parent-link LHAND_JOINT2_Link_lk :child-link LHAND_JOINT3_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq LHAND_JOINT0_jt
           (instance rotational-joint :init
                     :name "LHAND_JOINT0"
                     :parent-link LARM_JOINT5_Link_lk :child-link LHAND_JOINT0_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq LHAND_JOINT2_jt
           (instance rotational-joint :init
                     :name "LHAND_JOINT2"
                     :parent-link LARM_JOINT5_Link_lk :child-link LHAND_JOINT2_Link_lk
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -30.000000 :max 30.000000
                     ))
     (setq LARM_JOINT5_jt
           (instance rotational-joint :init
                     :name "LARM_JOINT5"
                     :parent-link LARM_JOINT4_Link_lk :child-link LARM_JOINT5_Link_lk
                     :max-joint-velocity 5.235990
                     :axis (let ((tmp-axis (float-vector 1.000000 0.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -163.000000 :max 163.000000
                     ))
     (setq LARM_JOINT4_jt
           (instance rotational-joint :init
                     :name "LARM_JOINT4"
                     :parent-link LARM_JOINT3_Link_lk :child-link LARM_JOINT4_Link_lk
                     :max-joint-velocity 4.363320
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -100.000000 :max 100.000000
                     ))
     (setq LARM_JOINT3_jt
           (instance rotational-joint :init
                     :name "LARM_JOINT3"
                     :parent-link LARM_JOINT2_Link_lk :child-link LARM_JOINT3_Link_lk
                     :max-joint-velocity 2.617990
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -165.000000 :max 105.000000
                     ))
     (setq LARM_JOINT2_jt
           (instance rotational-joint :init
                     :name "LARM_JOINT2"
                     :parent-link LARM_JOINT1_Link_lk :child-link LARM_JOINT2_Link_lk
                     :max-joint-velocity 3.996800
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -158.000000 :max 0.000000
                     ))
     (setq LARM_JOINT1_jt
           (instance rotational-joint :init
                     :name "LARM_JOINT1"
                     :parent-link LARM_JOINT0_Link_lk :child-link LARM_JOINT1_Link_lk
                     :max-joint-velocity 2.321290
                     :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -140.000000 :max 60.000000
                     ))
     (setq HEAD_JOINT0_jt
           (instance rotational-joint :init
                     :name "HEAD_JOINT0"
                     :parent-link CHEST_JOINT0_Link_lk :child-link HEAD_JOINT0_Link_lk
                     :max-joint-velocity 2.617990
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -70.000000 :max 70.000000
                     ))
     (setq RARM_JOINT0_jt
           (instance rotational-joint :init
                     :name "RARM_JOINT0"
                     :parent-link CHEST_JOINT0_Link_lk :child-link RARM_JOINT0_Link_lk
                     :max-joint-velocity 3.001970
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -88.000000 :max 88.000000
                     ))
     (setq LARM_JOINT0_jt
           (instance rotational-joint :init
                     :name "LARM_JOINT0"
                     :parent-link CHEST_JOINT0_Link_lk :child-link LARM_JOINT0_Link_lk
                     :max-joint-velocity 3.001970
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -88.000000 :max 88.000000
                     ))
     (setq CHEST_JOINT0_jt
           (instance rotational-joint :init
                     :name "CHEST_JOINT0"
                     :parent-link WAIST_lk :child-link CHEST_JOINT0_Link_lk
                     :max-joint-velocity 2.268000
                     :axis (let ((tmp-axis (float-vector 0.000000 0.000000 1.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis))
                     :min -162.949005 :max 162.949005
                     ))

     ;; end coords from openrave manipulater tag
     (setq rightarm-frame-tip (make-cascoords :coords (send RARM_JOINT5_Link_lk :copy-worldcoords) :name :rightarm-frame-tip))
     (send rightarm-frame-tip :transform (make-coords :pos #f( -50.000000 0.000000 0.000000) :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle -1.570796) :local)
     (send RARM_JOINT5_Link_lk :assoc rightarm-frame-tip)

     (setq rarm-end-coords (make-cascoords :coords (send rightarm-frame-tip :copy-worldcoords)))
     (send rightarm-frame-tip :assoc rarm-end-coords)

     (setq rightarm_torso-frame-tip (make-cascoords :coords (send RARM_JOINT5_Link_lk :copy-worldcoords) :name :rightarm_torso-frame-tip))
     (send rightarm_torso-frame-tip :transform (make-coords :pos #f( -50.000000 0.000000 0.000000) :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle -1.570796) :local)
     (send RARM_JOINT5_Link_lk :assoc rightarm_torso-frame-tip)

     (setq leftarm-frame-tip (make-cascoords :coords (send LARM_JOINT5_Link_lk :copy-worldcoords) :name :leftarm-frame-tip))
     (send leftarm-frame-tip :transform (make-coords :pos #f( -50.000000 0.000000 0.000000) :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle -1.570796) :local)
     (send LARM_JOINT5_Link_lk :assoc leftarm-frame-tip)

     (setq larm-end-coords (make-cascoords :coords (send leftarm-frame-tip :copy-worldcoords)))
     (send leftarm-frame-tip :assoc larm-end-coords)

     (setq leftarm_torso-frame-tip (make-cascoords :coords (send LARM_JOINT5_Link_lk :copy-worldcoords) :name :leftarm_torso-frame-tip))
     (send leftarm_torso-frame-tip :transform (make-coords :pos #f( -50.000000 0.000000 0.000000) :axis (let ((tmp-axis (float-vector 0.000000 1.000000 0.000000))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle -1.570796) :local)
     (send LARM_JOINT5_Link_lk :assoc leftarm_torso-frame-tip)

     (setq head-frame-tip (make-cascoords :coords (send HEAD_JOINT1_Link_lk :copy-worldcoords) :name :head-frame-tip))
     (send head-frame-tip :transform (make-coords :pos #f( 90.000000 70.000000 85.000000) :axis (let ((tmp-axis (float-vector 0.577350 0.577350 0.577350))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle 2.094395) :local)
     (send HEAD_JOINT1_Link_lk :assoc head-frame-tip)

     (setq head_torso-frame-tip (make-cascoords :coords (send HEAD_JOINT1_Link_lk :copy-worldcoords) :name :head_torso-frame-tip))
     (send head_torso-frame-tip :transform (make-coords :pos #f( 90.000000 70.000000 85.000000) :axis (let ((tmp-axis (float-vector 0.577350 0.577350 0.577350))) (if (eps= (norm tmp-axis) 0.0) (float-vector 1 0 0) tmp-axis)) :angle 2.094395) :local)
     (send HEAD_JOINT1_Link_lk :assoc head_torso-frame-tip)

     ;; end coords from yaml file
     (setq rarm-end-coords (make-cascoords :coords (send RARM_JOINT5_Link_lk :copy-worldcoords)))
     (send rarm-end-coords :translate (float-vector -50.000000 0.000000 0.000000))
     (send rarm-end-coords :rotate 1.570796 (float-vector 0.000000 1.000000 0.000000))
     (send RARM_JOINT5_Link_lk :assoc rarm-end-coords)
     (setq larm-end-coords (make-cascoords :coords (send LARM_JOINT5_Link_lk :copy-worldcoords)))
     (send larm-end-coords :translate (float-vector -50.000000 0.000000 0.000000))
     (send larm-end-coords :rotate 1.570796 (float-vector 0.000000 1.000000 0.000000))
     (send LARM_JOINT5_Link_lk :assoc larm-end-coords)
     (setq torso-end-coords (make-cascoords :coords (send CHEST_JOINT0_Link_lk :copy-worldcoords)))
     (send CHEST_JOINT0_Link_lk :assoc torso-end-coords)
     (setq head-end-coords (make-cascoords :coords (send HEAD_JOINT1_Link_lk :copy-worldcoords)))
     (send head-end-coords :translate (float-vector 100.000000 0.000000 100.000000))
     (send head-end-coords :rotate 1.570796 (float-vector 0.000000 1.000000 0.000000))
     (send HEAD_JOINT1_Link_lk :assoc head-end-coords)

     ;; limbs
     (setq rarm (list RARM_JOINT0_Link_lk RARM_JOINT1_Link_lk RARM_JOINT2_Link_lk RARM_JOINT3_Link_lk RARM_JOINT4_Link_lk RARM_JOINT5_Link_lk))

     (setq rarm-root-link (labels ((find-parent (l) (if (find (send l :parent) rarm) (find-parent (send l :parent)) l))) (find-parent (car rarm))))
     (setq larm (list LARM_JOINT0_Link_lk LARM_JOINT1_Link_lk LARM_JOINT2_Link_lk LARM_JOINT3_Link_lk LARM_JOINT4_Link_lk LARM_JOINT5_Link_lk))

     (setq larm-root-link (labels ((find-parent (l) (if (find (send l :parent) larm) (find-parent (send l :parent)) l))) (find-parent (car larm))))
     (setq torso (list CHEST_JOINT0_Link_lk))

     (setq torso-root-link (labels ((find-parent (l) (if (find (send l :parent) torso) (find-parent (send l :parent)) l))) (find-parent (car torso))))
     (setq head (list HEAD_JOINT0_Link_lk HEAD_JOINT1_Link_lk))

     (setq head-root-link (labels ((find-parent (l) (if (find (send l :parent) head) (find-parent (send l :parent)) l))) (find-parent (car head))))

     ;; links
     (setq links (list WAIST_lk RARM_JOINT0_Link_lk RARM_JOINT1_Link_lk RARM_JOINT2_Link_lk RARM_JOINT3_Link_lk RARM_JOINT4_Link_lk RARM_JOINT5_Link_lk LARM_JOINT0_Link_lk LARM_JOINT1_Link_lk LARM_JOINT2_Link_lk LARM_JOINT3_Link_lk LARM_JOINT4_Link_lk LARM_JOINT5_Link_lk CHEST_JOINT0_Link_lk HEAD_JOINT0_Link_lk HEAD_JOINT1_Link_lk))
     ;; joint-list
     (setq joint-list (list RARM_JOINT0_jt RARM_JOINT1_jt RARM_JOINT2_jt RARM_JOINT3_jt RARM_JOINT4_jt RARM_JOINT5_jt LARM_JOINT0_jt LARM_JOINT1_jt LARM_JOINT2_jt LARM_JOINT3_jt LARM_JOINT4_jt LARM_JOINT5_jt CHEST_JOINT0_jt HEAD_JOINT0_jt HEAD_JOINT1_jt))

     ;; init-ending
     (send self :init-ending)

     ;; overwrite bodies to return draw-things links not (send link :bodies)
     (setq bodies (flatten (mapcar #'(lambda (b) (if (find-method b :bodies) (send b :bodies))) (list HEAD_JOINT1_Link_lk HEAD_JOINT0_Link_lk RHAND_JOINT1_Link_lk RHAND_JOINT0_Link_lk RHAND_JOINT3_Link_lk RHAND_JOINT2_Link_lk RARM_JOINT5_Link_lk RARM_JOINT4_Link_lk RARM_JOINT3_Link_lk RARM_JOINT2_Link_lk RARM_JOINT1_Link_lk RARM_JOINT0_Link_lk LHAND_JOINT1_Link_lk LHAND_JOINT0_Link_lk LHAND_JOINT3_Link_lk LHAND_JOINT2_Link_lk LARM_JOINT5_Link_lk LARM_JOINT4_Link_lk LARM_JOINT3_Link_lk LARM_JOINT2_Link_lk LARM_JOINT1_Link_lk LARM_JOINT0_Link_lk CHEST_JOINT0_Link_lk WAIST_lk))))

     (send self :reset-pose) ;; :set reset-pose

     self)) ;; :init

    ;; pre-defined pose methods
    (:off-pose () (send self :angle-vector (float-vector 0.000000 -140.000000 -158.000000 0.000000 0.000000 0.000000 0.000000 -140.000000 -158.000000 0.000000 0.000000 0.000000 0.000000 0.000000 0.000000)))
    (:reset-pose () (send self :angle-vector (float-vector 0.000000 -40.000000 -90.000000 0.000000 0.000000 0.000000 0.000000 -40.000000 -90.000000 0.000000 0.000000 0.000000 0.000000 0.000000 30.000000)))

    ;; all joints
    (:WAIST_JOINT (&rest args) (forward-message-to WAIST_JOINT_jt args))
    (:CHEST_JOINT0 (&rest args) (forward-message-to CHEST_JOINT0_jt args))
    (:HEAD_JOINT0 (&rest args) (forward-message-to HEAD_JOINT0_jt args))
    (:HEAD_JOINT1 (&rest args) (forward-message-to HEAD_JOINT1_jt args))
    (:RARM_JOINT0 (&rest args) (forward-message-to RARM_JOINT0_jt args))
    (:RARM_JOINT1 (&rest args) (forward-message-to RARM_JOINT1_jt args))
    (:RARM_JOINT2 (&rest args) (forward-message-to RARM_JOINT2_jt args))
    (:RARM_JOINT3 (&rest args) (forward-message-to RARM_JOINT3_jt args))
    (:RARM_JOINT4 (&rest args) (forward-message-to RARM_JOINT4_jt args))
    (:RARM_JOINT5 (&rest args) (forward-message-to RARM_JOINT5_jt args))
    (:RHAND_JOINT0 (&rest args) (forward-message-to RHAND_JOINT0_jt args))
    (:RHAND_JOINT1 (&rest args) (forward-message-to RHAND_JOINT1_jt args))
    (:RHAND_JOINT2 (&rest args) (forward-message-to RHAND_JOINT2_jt args))
    (:RHAND_JOINT3 (&rest args) (forward-message-to RHAND_JOINT3_jt args))
    (:LARM_JOINT0 (&rest args) (forward-message-to LARM_JOINT0_jt args))
    (:LARM_JOINT1 (&rest args) (forward-message-to LARM_JOINT1_jt args))
    (:LARM_JOINT2 (&rest args) (forward-message-to LARM_JOINT2_jt args))
    (:LARM_JOINT3 (&rest args) (forward-message-to LARM_JOINT3_jt args))
    (:LARM_JOINT4 (&rest args) (forward-message-to LARM_JOINT4_jt args))
    (:LARM_JOINT5 (&rest args) (forward-message-to LARM_JOINT5_jt args))
    (:LHAND_JOINT0 (&rest args) (forward-message-to LHAND_JOINT0_jt args))
    (:LHAND_JOINT1 (&rest args) (forward-message-to LHAND_JOINT1_jt args))
    (:LHAND_JOINT2 (&rest args) (forward-message-to LHAND_JOINT2_jt args))
    (:LHAND_JOINT3 (&rest args) (forward-message-to LHAND_JOINT3_jt args))

    ;; all links forwarding
    (:links (&rest args)
     (if (null args) (return-from :links (send-super :links)))
     (let ((key (car args))
           (nargs (cdr args)))
       (unless (keywordp key)
         (return-from :links (send-super* :links args)))
       (case key
         (:HEAD_JOINT1_Link (forward-message-to HEAD_JOINT1_Link_lk nargs))
         (:HEAD_JOINT0_Link (forward-message-to HEAD_JOINT0_Link_lk nargs))
         (:RHAND_JOINT1_Link (forward-message-to RHAND_JOINT1_Link_lk nargs))
         (:RHAND_JOINT0_Link (forward-message-to RHAND_JOINT0_Link_lk nargs))
         (:RHAND_JOINT3_Link (forward-message-to RHAND_JOINT3_Link_lk nargs))
         (:RHAND_JOINT2_Link (forward-message-to RHAND_JOINT2_Link_lk nargs))
         (:RARM_JOINT5_Link (forward-message-to RARM_JOINT5_Link_lk nargs))
         (:RARM_JOINT4_Link (forward-message-to RARM_JOINT4_Link_lk nargs))
         (:RARM_JOINT3_Link (forward-message-to RARM_JOINT3_Link_lk nargs))
         (:RARM_JOINT2_Link (forward-message-to RARM_JOINT2_Link_lk nargs))
         (:RARM_JOINT1_Link (forward-message-to RARM_JOINT1_Link_lk nargs))
         (:RARM_JOINT0_Link (forward-message-to RARM_JOINT0_Link_lk nargs))
         (:LHAND_JOINT1_Link (forward-message-to LHAND_JOINT1_Link_lk nargs))
         (:LHAND_JOINT0_Link (forward-message-to LHAND_JOINT0_Link_lk nargs))
         (:LHAND_JOINT3_Link (forward-message-to LHAND_JOINT3_Link_lk nargs))
         (:LHAND_JOINT2_Link (forward-message-to LHAND_JOINT2_Link_lk nargs))
         (:LARM_JOINT5_Link (forward-message-to LARM_JOINT5_Link_lk nargs))
         (:LARM_JOINT4_Link (forward-message-to LARM_JOINT4_Link_lk nargs))
         (:LARM_JOINT3_Link (forward-message-to LARM_JOINT3_Link_lk nargs))
         (:LARM_JOINT2_Link (forward-message-to LARM_JOINT2_Link_lk nargs))
         (:LARM_JOINT1_Link (forward-message-to LARM_JOINT1_Link_lk nargs))
         (:LARM_JOINT0_Link (forward-message-to LARM_JOINT0_Link_lk nargs))
         (:CHEST_JOINT0_Link (forward-message-to CHEST_JOINT0_Link_lk nargs))
         (:WAIST (forward-message-to WAIST_lk nargs))
         (t (send-super* :links args)))))

    ;; all links
    (:HEAD_JOINT1_Link_lk (&rest args) (forward-message-to HEAD_JOINT1_Link_lk args))
    (:HEAD_JOINT0_Link_lk (&rest args) (forward-message-to HEAD_JOINT0_Link_lk args))
    (:RHAND_JOINT1_Link_lk (&rest args) (forward-message-to RHAND_JOINT1_Link_lk args))
    (:RHAND_JOINT0_Link_lk (&rest args) (forward-message-to RHAND_JOINT0_Link_lk args))
    (:RHAND_JOINT3_Link_lk (&rest args) (forward-message-to RHAND_JOINT3_Link_lk args))
    (:RHAND_JOINT2_Link_lk (&rest args) (forward-message-to RHAND_JOINT2_Link_lk args))
    (:RARM_JOINT5_Link_lk (&rest args) (forward-message-to RARM_JOINT5_Link_lk args))
    (:RARM_JOINT4_Link_lk (&rest args) (forward-message-to RARM_JOINT4_Link_lk args))
    (:RARM_JOINT3_Link_lk (&rest args) (forward-message-to RARM_JOINT3_Link_lk args))
    (:RARM_JOINT2_Link_lk (&rest args) (forward-message-to RARM_JOINT2_Link_lk args))
    (:RARM_JOINT1_Link_lk (&rest args) (forward-message-to RARM_JOINT1_Link_lk args))
    (:RARM_JOINT0_Link_lk (&rest args) (forward-message-to RARM_JOINT0_Link_lk args))
    (:LHAND_JOINT1_Link_lk (&rest args) (forward-message-to LHAND_JOINT1_Link_lk args))
    (:LHAND_JOINT0_Link_lk (&rest args) (forward-message-to LHAND_JOINT0_Link_lk args))
    (:LHAND_JOINT3_Link_lk (&rest args) (forward-message-to LHAND_JOINT3_Link_lk args))
    (:LHAND_JOINT2_Link_lk (&rest args) (forward-message-to LHAND_JOINT2_Link_lk args))
    (:LARM_JOINT5_Link_lk (&rest args) (forward-message-to LARM_JOINT5_Link_lk args))
    (:LARM_JOINT4_Link_lk (&rest args) (forward-message-to LARM_JOINT4_Link_lk args))
    (:LARM_JOINT3_Link_lk (&rest args) (forward-message-to LARM_JOINT3_Link_lk args))
    (:LARM_JOINT2_Link_lk (&rest args) (forward-message-to LARM_JOINT2_Link_lk args))
    (:LARM_JOINT1_Link_lk (&rest args) (forward-message-to LARM_JOINT1_Link_lk args))
    (:LARM_JOINT0_Link_lk (&rest args) (forward-message-to LARM_JOINT0_Link_lk args))
    (:CHEST_JOINT0_Link_lk (&rest args) (forward-message-to CHEST_JOINT0_Link_lk args))
    (:WAIST_lk (&rest args) (forward-message-to WAIST_lk args))

    ;; all manipulator
    (:rightarm-frame-tip (&rest args) (forward-message-to rightarm-frame-tip args))
    (:rightarm_torso-frame-tip (&rest args) (forward-message-to rightarm_torso-frame-tip args))
    (:leftarm-frame-tip (&rest args) (forward-message-to leftarm-frame-tip args))
    (:leftarm_torso-frame-tip (&rest args) (forward-message-to leftarm_torso-frame-tip args))
    (:head-frame-tip (&rest args) (forward-message-to head-frame-tip args))
    (:head_torso-frame-tip (&rest args) (forward-message-to head_torso-frame-tip args))

    ;; user-defined joint
    (:rarm-shoulder-y (&rest args) (forward-message-to RARM_JOINT0_jt args))
    (:rarm-shoulder-p (&rest args) (forward-message-to RARM_JOINT1_jt args))
    (:rarm-elbow-p (&rest args) (forward-message-to RARM_JOINT2_jt args))
    (:rarm-wrist-y (&rest args) (forward-message-to RARM_JOINT3_jt args))
    (:rarm-wrist-p (&rest args) (forward-message-to RARM_JOINT4_jt args))
    (:rarm-wrist-r (&rest args) (forward-message-to RARM_JOINT5_jt args))
    (:larm-shoulder-y (&rest args) (forward-message-to LARM_JOINT0_jt args))
    (:larm-shoulder-p (&rest args) (forward-message-to LARM_JOINT1_jt args))
    (:larm-elbow-p (&rest args) (forward-message-to LARM_JOINT2_jt args))
    (:larm-wrist-y (&rest args) (forward-message-to LARM_JOINT3_jt args))
    (:larm-wrist-p (&rest args) (forward-message-to LARM_JOINT4_jt args))
    (:larm-wrist-r (&rest args) (forward-message-to LARM_JOINT5_jt args))
    (:torso-waist-y (&rest args) (forward-message-to CHEST_JOINT0_jt args))
    (:head-neck-y (&rest args) (forward-message-to HEAD_JOINT0_jt args))
    (:head-neck-p (&rest args) (forward-message-to HEAD_JOINT1_jt args))

    ;; attach_sensor
    (:force-sensors (&rest args) (forward-message-to-all (list ) args))
    (:imu-sensors (&rest args) (forward-message-to-all (list ) args))
  )

(defclass collada-body
  :super body
  :slots (glvertices)
  )
(defmethod collada-body
  (:draw (vwr)
   (when glvertices
     (send glvertices :draw vwr)))
  (:set-color (&rest args)
   (send-super* :set-color args)
   (when glvertices (send* glvertices :set-color args)))
  )
(defclass HiroNX_g1_0_geom0
  :super collada-body
  :slots ())
(defmethod HiroNX_g1_0_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.900000 0.900000 0.900000 1.000000))
           ))
           (list :indices #i( 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256 257 258 259 260 261 262 263 264 265 266 267 268 269 270 271 272 273 274 275 276 277 278 279 280 281 282 283 284 285 286 287 288 289 290 291 292 293 294 295 296 297 298 299 300 301 302 303 304 305 306 307 308 309 310 311 312 313 314 315 316 317 318 319 320 321 322 323 324 325 326 327 328 329 330 331 332 333 334 335 336 337 338 339 340 341 342 343 344 345 346 347 348 349 350 351 352 353 354 355 356 357 358 359 360 361 362 363 364 365 366 367 368 369 370 371 372 373 374 375 376 377 378 379 380 381 382 383 384 385 386 387 388 389 390 391 392 393 394 395 396 397 398 399 400 401 402 403 404 405 406 407 408 409 410 411 412 413 414 415 416 417 418 419 420 421 422 423 424 425 426 427 428 429 430 431 432 433 434 435 436 437 438 439 440 441 442 443 444 445 446 447 448 449 450 451 452 453 454 455 456 457 458 459 460 461 462 463 464 465 466 467 468 469 470 471 472 473 474 475 476 477 478 479 480 481 482 483 484 485 486 487 488 489 490 491 492 493 494 495 496 497 498 499 500 501 502 503 504 505 506 507 508 509 510 511 512 513 514 515 516 517 518 519 520 521 522 523 524 525 526 527 528 529 530 531 532 533 534 535 536 537 538 539 540 541 542 543 544 545 546 547 548 549 550 551 552 553 554 555 556 557 558 559 560 561 562 563 564 565 566 567 568 569 570 571 572 573 574 575 576 577 578 579 580 581 582 583 584 585 586 587 588 589 590 591 592 593 594 595 596 597 598 599 600 601 602 603 604 605 606 607 608 609 610 611 612 613 614 615 616 617 618 619 620 621 622 623 624 625 626 627 628 629 630 631 632 633 634 635 636 637 638 639 640 641 642 643 644 645 646 647 648 649 650 651 652 653 654 655 656 657 658 659 660 661 662 663 664 665 666 667 668 669 670 671 672 673 674 675 676 677 678 679 680 681 682 683 684 685 686 687 688 689 690 691 692 693 694 695 696 697 698 699 700 701 702 703 704 705 706 707 708 709 710 711 712 713 714 715 716 717 718 719 720 721 722 723 724 725 726 727 728 729 730 731 732 733 734 735 736 737 738 739 740 741 742 743 744 745 746 747 748 749 750 751 752 753 754 755 756 757 758 759 760 761 762 763 764 765 766 767 768 769 770 771 772 773 774 775 776 777 778 779 780 781 782 783 784 785 786 787 788 789 790 791 792 793 794 795 796 797 798 799 800 801 802 803 804 805 806 807 808 809 810 811 812 813 814 815 816 817 818 819 820 821 822 823 824 825 826 827 828 829 830 831 832 833 834 835 836 837 838 839 840 841 842 843 844 845 846 847 848 849 850 851 852 853 854 855 856 857 858 859 860 861 862 863 864 865 866 867 868 869 870 871 872 873 874 875 876 877 878 879 880 881 882 883 884 885 886 887 888 889 890 891 892 893 894 895 896 897 898 899 900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915 916 917 918 919 920 921 922 923 924 925 926 927 928 929 930 931 932 933 934 935 936 937 938 939 940 941 942 943 944 945 946 947 948 949 950 951 952 953 954 955 956 957 958 959 960 961 962 963 964 965 966 967 968 969 970 971 972 973 974 975 976 977 978 979 980 981 982 983 984 985 986 987 988 989 990 991 992 993 994 995 996 997 998 999 1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248 1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 1295 1296 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 1312 1313 1314 1315 1316 1317 1318 1319 1320 1321 1322 1323 1324 1325 1326 1327 1328 1329 1330 1331 1332 1333 1334 1335 1336 1337 1338 1339 1340 1341 1342 1343 1344 1345 1346 1347 1348 1349 1350 1351 1352 1353 1354 1355 1356 1357 1358 1359 1360 1361 1362 1363 1364 1365 1366 1367 1368 1369 1370 1371 1372 1373 1374 1375 1376 1377 1378 1379 1380 1381 1382 1383 1384 1385 1386 1387 1388 1389 1390 1391 1392 1393 1394 1395 1396 1397 1398 1399 1400 1401 1402 1403 1404 1405 1406 1407 1408 1409 1410 1411 1412 1413 1414 1415 1416 1417 1418 1419 1420 1421 1422 1423 1424 1425 1426 1427 1428 1429 1430 1431 1432 1433 1434 1435 1436 1437 1438 1439 1440 1441 1442 1443 1444 1445 1446 1447 1448 1449 1450 1451 1452 1453 1454 1455 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1473 1474 1475 1476 1477 1478 1479 1480 1481 1482 1483 1484 1485 1486 1487 1488 1489 1490 1491 1492 1493 1494 1495 1496 1497 1498 1499 1500 1501 1502 1503 1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1520 1521 1522 1523 1524 1525 1526 1527 1528 1529 1530 1531 1532 1533 1534 1535 1536 1537 1538 1539 1540 1541 1542 1543 1544 1545 1546 1547 1548 1549 1550 1551 1552 1553 1554 1555 1556 1557 1558 1559 1560 1561 1562 1563 1564 1565 1566 1567 1568 1569 1570 1571 1572 1573 1574 1575 1576 1577 1578 1579 1580 1581 1582 1583 1584 1585 1586 1587 1588 1589 1590 1591 1592 1593 1594 1595 1596 1597 1598 1599 1600 1601 1602 1603 1604 1605 1606 1607 1608 1609 1610 1611 1612 1613 1614 1615 1616 1617 1618 1619 1620 1621 1622 1623 1624 1625 1626 1627 1628 1629 1630 1631 1632 1633 1634 1635 1636 1637 1638 1639 1640 1641 1642 1643 1644 1645 1646 1647 1648 1649 1650 1651 1652 1653 1654 1655 1656 1657 1658 1659 1660 1661 1662 1663 1664 1665 1666 1667 1668 1669 1670 1671 1672 1673 1674 1675 1676 1677 1678 1679 1680 1681 1682 1683 1684 1685 1686 1687 1688 1689 1690 1691 1692 1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721 1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733 1734 1735 1736 1737 1738 1739 1740 1741 1742 1743 1744 1745 1746 1747 1748 1749 1750 1751 1752 1753 1754 1755 1756 1757 1758 1759 1760 1761 1762 1763 1764 1765 1766 1767 1768 1769 1770 1771 1772 1773 1774 1775 1776 1777 1778 1779 1780 1781 1782 1783 1784 1785 1786 1787 1788 1789 1790 1791 1792 1793 1794 1795 1796 1797 1798 1799 1800 1801 1802 1803 1804 1805 1806 1807 1808 1809 1810 1811 1812 1813 1814 1815 1816 1817 1818 1819 1820 1821 1822 1823 1824 1825 1826 1827 1828 1829 1830 1831 1832 1833 1834 1835 1836 1837 1838 1839 1840 1841 1842 1843 1844 1845 1846 1847 1848 1849 1850 1851 1852 1853))
           (list :vertices #2f((58.084999 -15.039000 0.003998)(53.868000 -26.424000 0.003998)(59.923000 -3.039000 0.003998)(53.868000 -26.424000 0.003998)(47.446003 -36.727001 0.003998)(59.923000 -3.039000 0.003998)(59.923000 -3.039000 12.004000)(58.084999 -15.039000 0.003998)(59.923000 -3.039000 0.003998)(58.084999 -15.039000 0.003998)(58.084999 -15.039000 12.004000)(53.868000 -26.424000 0.003998)(47.446003 -36.727001 0.003998)(39.081997 -45.526001 0.003998)(59.923000 -3.039000 0.003998)(53.868000 -26.424000 12.004000)(47.446003 -36.727001 0.003998)(53.868000 -26.424000 0.003998)(59.923000 -3.039000 0.003998)(59.307999 9.084999 12.004000)(59.923000 -3.039000 12.004000)(58.084999 -15.039000 0.003998)(59.923000 -3.039000 12.004000)(58.084999 -15.039000 12.004000)(53.868000 -26.424000 0.003998)(58.084999 -15.039000 12.004000)(53.868000 -26.424000 12.004000)(39.081997 -45.526001 0.003998)(29.118000 -52.460999 0.003998)(59.923000 -3.039000 0.003998)(47.446003 -36.727001 12.004000)(39.081997 -45.526001 0.003998)(47.446003 -36.727001 0.003998)(53.868000 -26.424000 12.004000)(47.446003 -36.727001 12.004000)(47.446003 -36.727001 0.003998)(59.307999 9.084999 12.004000)(59.923000 -3.039000 0.003998)(59.307999 9.084999 0.003998)(59.307999 9.084999 12.004000)(56.264999 20.837999 12.004000)(59.923000 -3.039000 12.004000)(53.868000 -26.424000 12.004000)(58.084999 -15.039000 12.004000)(59.923000 -3.039000 12.004000)(29.118000 -52.460999 0.003998)(17.962000 -57.248997 0.003998)(59.923000 -3.039000 0.003998)(29.118000 -52.460999 0.003998)(39.081997 -45.526001 0.003998)(39.081997 -45.526001 12.004000)(39.081997 -45.526001 0.003998)(47.446003 -36.727001 12.004000)(39.081997 -45.526001 12.004000)(47.446003 -36.727001 12.004000)(53.868000 -26.424000 12.004000)(59.923000 -3.039000 12.004000)(56.264999 20.837999 0.003998)(59.307999 9.084999 0.003998)(59.923000 -3.039000 0.003998)(56.264999 20.837999 12.004000)(59.307999 9.084999 12.004000)(59.307999 9.084999 0.003998)(56.264999 20.837999 12.004000)(50.918999 31.738003 12.004000)(59.923000 -3.039000 12.004000)(17.962000 -57.248997 0.003998)(6.070000 -59.691998 0.003998)(59.923000 -3.039000 0.003998)(29.118000 -52.460999 12.004000)(17.962000 -57.248997 0.003998)(29.118000 -52.460999 0.003998)(29.118000 -52.460999 12.004000)(29.118000 -52.460999 0.003998)(39.081997 -45.526001 12.004000)(39.081997 -45.526001 12.004000)(47.446003 -36.727001 12.004000)(59.923000 -3.039000 12.004000)(50.918999 31.738003 0.003998)(56.264999 20.837999 0.003998)(59.923000 -3.039000 0.003998)(56.264999 20.837999 0.003998)(56.264999 20.837999 12.004000)(59.307999 9.084999 0.003998)(50.918999 31.738003 12.004000)(43.487999 41.338001 12.004000)(59.923000 -3.039000 12.004000)(56.264999 20.837999 0.003998)(50.918999 31.738003 12.004000)(56.264999 20.837999 12.004000)(6.070000 -59.691998 0.003998)(-6.070000 -59.691998 0.003998)(59.923000 -3.039000 0.003998)(17.962000 -57.248997 12.004000)(6.070000 -59.691998 0.003998)(17.962000 -57.248997 0.003998)(17.962000 -57.248997 12.004000)(17.962000 -57.248997 0.003998)(29.118000 -52.460999 12.004000)(29.118000 -52.460999 12.004000)(39.081997 -45.526001 12.004000)(59.923000 -3.039000 12.004000)(43.487999 41.338001 0.003998)(50.918999 31.738003 0.003998)(59.923000 -3.039000 0.003998)(50.918999 31.738003 0.003998)(50.918999 31.738003 12.004000)(56.264999 20.837999 0.003998)(43.487999 41.338001 12.004000)(34.276001 49.245998 12.004000)(59.923000 -3.039000 12.004000)(50.918999 31.738003 0.003998)(43.487999 41.338001 12.004000)(50.918999 31.738003 12.004000)(-6.070000 -59.691998 0.003998)(-17.962000 -57.248001 0.003998)(59.923000 -3.039000 0.003998)(-6.070000 -59.691998 0.003998)(6.070000 -59.691998 0.003998)(6.070000 -59.691998 12.004000)(6.070000 -59.691998 12.004000)(6.070000 -59.691998 0.003998)(17.962000 -57.248997 12.004000)(17.962000 -57.248997 12.004000)(29.118000 -52.460999 12.004000)(59.923000 -3.039000 12.004000)(34.276001 49.245998 0.003998)(43.487999 41.338001 0.003998)(59.923000 -3.039000 0.003998)(43.487999 41.338001 12.004000)(50.918999 31.738003 0.003998)(43.487999 41.338001 0.003998)(59.923000 -3.039000 12.004000)(34.276001 49.245998 12.004000)(23.662001 55.137001 12.004000)(43.487999 41.338001 0.003998)(34.276001 49.245998 12.004000)(43.487999 41.338001 12.004000)(-17.962000 -57.248001 0.003998)(-29.118000 -52.460999 0.003998)(59.923000 -3.039000 0.003998)(-6.070000 -59.691998 12.004000)(-17.962000 -57.248001 0.003998)(-6.070000 -59.691998 0.003998)(-6.070000 -59.691998 12.004000)(-6.070000 -59.691998 0.003998)(6.070000 -59.691998 12.004000)(6.070000 -59.691998 12.004000)(17.962000 -57.248997 12.004000)(59.923000 -3.039000 12.004000)(59.923000 -3.039000 0.003998)(23.662001 55.137001 0.003998)(34.276001 49.245998 0.003998)(34.276001 49.245998 12.004000)(43.487999 41.338001 0.003998)(34.276001 49.245998 0.003998)(59.923000 -3.039000 12.004000)(23.662001 55.137001 12.004000)(12.078000 58.772003 12.004000)(34.276001 49.245998 12.004000)(34.276001 49.245998 0.003998)(23.662001 55.137001 12.004000)(-29.118000 -52.460999 0.003998)(-39.081997 -45.524998 0.003998)(59.923000 -3.039000 0.003998)(-17.962000 -57.248001 12.004000)(-29.118000 -52.460999 0.003998)(-17.962000 -57.248001 0.003998)(-17.962000 -57.248001 12.004000)(-17.962000 -57.248001 0.003998)(-6.070000 -59.691998 12.004000)(6.070000 -59.691998 12.004000)(59.923000 -3.039000 12.004000)(-6.070000 -59.691998 12.004000)(59.923000 -3.039000 0.003998)(12.078000 58.772003 0.003998)(23.662001 55.137001 0.003998)(23.662001 55.137001 12.004000)(34.276001 49.245998 0.003998)(23.662001 55.137001 0.003998)(59.923000 -3.039000 12.004000)(12.078000 58.772003 12.004000)(0.000000 60.000000 12.004000)(23.662001 55.137001 12.004000)(23.662001 55.137001 0.003998)(12.078000 58.772003 12.004000)(-39.081997 -45.524998 0.003998)(-47.446999 -36.726002 0.003998)(59.923000 -3.039000 0.003998)(-29.118000 -52.460999 12.004000)(-39.081997 -45.524998 0.003998)(-29.118000 -52.460999 0.003998)(-29.118000 -52.460999 12.004000)(-29.118000 -52.460999 0.003998)(-17.962000 -57.248001 12.004000)(28.702900 -24.899601 12.004000)(59.923000 -3.039000 12.004000)(28.740000 -24.853100 12.004000)(28.740000 -24.853100 12.004000)(59.923000 -3.039000 12.004000)(28.868301 -24.653500 12.004000)(-6.070000 -59.691998 12.004000)(20.571800 -31.945400 12.004000)(20.522701 -31.978901 12.004000)(-6.070000 -59.691998 12.004000)(20.522701 -31.978901 12.004000)(14.185900 -34.872601 12.004000)(-6.070000 -59.691998 12.004000)(14.185900 -34.872601 12.004000)(-17.962000 -57.248001 12.004000)(20.571800 -31.945400 12.004000)(-6.070000 -59.691998 12.004000)(59.923000 -3.039000 12.004000)(28.702900 -24.899601 12.004000)(20.571800 -31.945400 12.004000)(59.923000 -3.039000 12.004000)(59.923000 -3.039000 0.003998)(0.000000 60.000000 0.003998)(12.078000 58.772003 0.003998)(12.078000 58.772003 12.004000)(23.662001 55.137001 0.003998)(12.078000 58.772003 0.003998)(30.348200 22.350199 12.004000)(59.923000 -3.039000 12.004000)(28.723200 24.878700 12.004000)(17.554300 33.333500 12.004000)(20.493601 31.991199 12.004000)(0.000000 60.000000 12.004000)(20.493601 31.991199 12.004000)(20.546301 31.966499 12.004000)(0.000000 60.000000 12.004000)(17.554300 33.333500 12.004000)(0.000000 60.000000 12.004000)(-12.078000 58.772003 12.004000)(28.723200 24.878700 12.004000)(59.923000 -3.039000 12.004000)(0.000000 60.000000 12.004000)(28.677299 24.920700 12.004000)(28.723200 24.878700 12.004000)(0.000000 60.000000 12.004000)(20.546301 31.966499 12.004000)(28.677299 24.920700 12.004000)(0.000000 60.000000 12.004000)(12.078000 58.772003 12.004000)(12.078000 58.772003 0.003998)(0.000000 60.000000 12.004000)(-47.446999 -36.726002 0.003998)(-53.868000 -26.423000 0.003998)(59.923000 -3.039000 0.003998)(-39.081997 -45.524998 0.003998)(-39.081997 -45.524998 12.004000)(-47.446999 -36.726002 0.003998)(-39.081997 -45.524998 12.004000)(-39.081997 -45.524998 0.003998)(-29.118000 -52.460999 12.004000)(10.735400 -36.448299 12.004000)(-17.962000 -57.248001 12.004000)(14.185900 -34.872601 12.004000)(10.678500 -36.465897 12.004000)(-17.962000 -57.248001 12.004000)(10.735400 -36.448299 12.004000)(-2.435660 -37.650997 12.004000)(-29.118000 -52.460999 12.004000)(-7.466040 -46.060303 12.004000)(-29.118000 -52.460999 12.004000)(-17.962000 -57.248001 12.004000)(-7.466040 -46.060303 12.004000)(10.678500 -36.465897 12.004000)(0.028736 -37.996799 12.004000)(-7.466040 -46.060303 12.004000)(0.028736 -37.996799 12.004000)(-0.030731 -37.996799 12.004000)(-7.466040 -46.060303 12.004000)(-0.030731 -37.996799 12.004000)(-2.435660 -37.650997 12.004000)(-7.466040 -46.060303 12.004000)(-17.962000 -57.248001 12.004000)(10.678500 -36.465897 12.004000)(-7.466040 -46.060303 12.004000)(28.868301 -24.653500 12.004000)(59.923000 -3.039000 12.004000)(33.241001 -17.848801 12.004000)(31.792202 -20.420101 48.383499)(33.241001 -17.848801 12.004000)(34.556301 -15.801899 12.004000)(31.792202 -20.420101 48.383499)(28.868301 -24.653500 12.004000)(33.241001 -17.848801 12.004000)(31.792202 -20.420101 48.383499)(28.740000 -24.853100 12.004000)(28.868301 -24.653500 12.004000)(31.792202 -20.420101 48.383499)(32.908997 -18.998999 84.763000)(28.740000 -24.853100 12.004000)(31.792202 -20.420101 48.383499)(34.556301 -15.801899 12.004000)(32.908997 -18.998999 84.763000)(28.702900 -24.899601 12.004000)(28.740000 -24.853100 12.004000)(25.846001 -27.855999 84.763000)(28.740000 -24.853100 12.004000)(32.908997 -18.998999 84.763000)(25.846001 -27.855999 84.763000)(25.846001 -27.855999 84.763000)(20.571800 -31.945400 12.004000)(28.702900 -24.899601 12.004000)(20.571800 -31.945400 12.004000)(25.846001 -27.855999 84.763000)(16.487001 -34.236000 84.763000)(20.522701 -31.978901 12.004000)(20.571800 -31.945400 12.004000)(16.487001 -34.236000 84.763000)(10.735400 -36.448299 12.004000)(14.185900 -34.872601 12.004000)(15.707299 -34.384998 48.383499)(14.185900 -34.872601 12.004000)(20.522701 -31.978901 12.004000)(15.707299 -34.384998 48.383499)(20.522701 -31.978901 12.004000)(16.487001 -34.236000 84.763000)(15.707299 -34.384998 48.383499)(16.487001 -34.236000 84.763000)(10.735400 -36.448299 12.004000)(15.707299 -34.384998 48.383499)(59.923000 -3.039000 0.003998)(-12.078000 58.772003 0.003998)(0.000000 60.000000 0.003998)(0.000000 60.000000 12.004000)(12.078000 58.772003 0.003998)(0.000000 60.000000 0.003998)(35.000801 14.307600 12.004000)(59.923000 -3.039000 12.004000)(34.569199 15.776999 12.004000)(34.539497 15.828500 12.004000)(59.923000 -3.039000 12.004000)(30.348200 22.350199 12.004000)(34.569199 15.776999 12.004000)(59.923000 -3.039000 12.004000)(34.539497 15.828500 12.004000)(0.000000 60.000000 12.004000)(0.000000 60.000000 0.003998)(-12.078000 58.772003 12.004000)(-12.078000 58.772003 12.004000)(10.706300 36.460602 12.004000)(17.554300 33.333500 12.004000)(1.210410 37.826698 12.004000)(10.648800 36.469097 12.004000)(-3.053370 46.052700 12.004000)(10.648800 36.469097 12.004000)(10.706300 36.460602 12.004000)(-3.053370 46.052700 12.004000)(-12.078000 58.772003 12.004000)(-23.661001 55.138000 12.004000)(-3.053370 46.052700 12.004000)(-23.661001 55.138000 12.004000)(1.210410 37.826698 12.004000)(-3.053370 46.052700 12.004000)(10.706300 36.460602 12.004000)(-12.078000 58.772003 12.004000)(-3.053370 46.052700 12.004000)(10.952499 36.386501 84.763000)(20.493601 31.991199 12.004000)(17.554300 33.333500 12.004000)(10.952499 36.386501 84.763000)(17.554300 33.333500 12.004000)(10.706300 36.460602 12.004000)(10.952499 36.386501 84.763000)(20.974998 31.683002 84.763000)(20.493601 31.991199 12.004000)(20.974998 31.683002 84.763000)(20.546301 31.966499 12.004000)(20.493601 31.991199 12.004000)(28.677299 24.920700 12.004000)(20.546301 31.966499 12.004000)(20.974998 31.683002 84.763000)(28.677299 24.920700 12.004000)(20.974998 31.683002 84.763000)(29.709000 23.693001 84.763000)(28.723200 24.878700 12.004000)(28.677299 24.920700 12.004000)(29.709000 23.693001 84.763000)(30.348200 22.350199 12.004000)(28.723200 24.878700 12.004000)(29.709000 23.693001 84.763000)(34.539497 15.828500 12.004000)(30.348200 22.350199 12.004000)(29.709000 23.693001 84.763000)(-53.868000 -26.423000 0.003998)(-58.084999 -15.039000 0.003998)(59.923000 -3.039000 0.003998)(-47.446999 -36.726002 0.003998)(-47.446999 -36.726002 12.004000)(-53.868000 -26.423000 0.003998)(-47.446999 -36.726002 0.003998)(-39.081997 -45.524998 12.004000)(-47.446999 -36.726002 12.004000)(-10.736401 -36.448299 12.004000)(-14.221700 -34.856701 12.004000)(-20.758801 -43.658901 12.004000)(-14.221700 -34.856701 12.004000)(-39.081997 -45.524998 12.004000)(-20.758801 -43.658901 12.004000)(-39.081997 -45.524998 12.004000)(-29.118000 -52.460999 12.004000)(-20.758801 -43.658901 12.004000)(-29.118000 -52.460999 12.004000)(-2.435660 -37.650997 12.004000)(-20.758801 -43.658901 12.004000)(-2.435660 -37.650997 12.004000)(-10.679501 -36.465897 12.004000)(-20.758801 -43.658901 12.004000)(-10.679501 -36.465897 12.004000)(-10.736401 -36.448299 12.004000)(-20.758801 -43.658901 12.004000)(16.487001 -34.236000 84.763000)(5.663000 -37.575001 84.763000)(10.735400 -36.448299 12.004000)(5.663000 -37.575001 84.763000)(10.678500 -36.465897 12.004000)(10.735400 -36.448299 12.004000)(0.028736 -37.996799 12.004000)(10.678500 -36.465897 12.004000)(5.663000 -37.575001 84.763000)(-0.000500 -37.785900 48.383499)(-0.030731 -37.996799 12.004000)(0.028736 -37.996799 12.004000)(-0.000500 -37.785900 48.383499)(-5.664000 -37.575001 84.763000)(-0.030731 -37.996799 12.004000)(-0.000500 -37.785900 48.383499)(5.663000 -37.575001 84.763000)(-5.664000 -37.575001 84.763000)(-0.000500 -37.785900 48.383499)(0.028736 -37.996799 12.004000)(5.663000 -37.575001 84.763000)(-10.679501 -36.465897 12.004000)(-2.435660 -37.650997 12.004000)(-5.382460 -37.421402 48.383499)(-2.435660 -37.650997 12.004000)(-0.030731 -37.996799 12.004000)(-5.382460 -37.421402 48.383499)(-0.030731 -37.996799 12.004000)(-5.664000 -37.575001 84.763000)(-5.382460 -37.421402 48.383499)(-5.664000 -37.575001 84.763000)(-10.679501 -36.465897 12.004000)(-5.382460 -37.421402 48.383499)(33.241001 -17.848801 12.004000)(59.923000 -3.039000 12.004000)(34.556301 -15.801899 12.004000)(34.556301 -15.801899 12.004000)(59.923000 -3.039000 12.004000)(34.577999 -15.746500 12.004000)(34.577999 -15.746500 12.004000)(59.923000 -3.039000 12.004000)(35.193398 -13.651199 12.004000)(34.556301 -15.801899 12.004000)(34.577999 -15.746500 12.004000)(32.908997 -18.998999 84.763000)(34.577999 -15.746500 12.004000)(37.046997 -8.455000 84.763000)(32.908997 -18.998999 84.763000)(45.466000 -26.250000 109.619995)(25.846001 -27.855999 84.763000)(32.908997 -18.998999 84.763000)(25.846001 -27.855999 84.763000)(35.709000 -38.485001 109.619995)(16.487001 -34.236000 84.763000)(-23.661001 55.138000 0.003998)(-12.078000 58.772003 0.003998)(59.923000 -3.039000 0.003998)(-12.078000 58.772003 12.004000)(0.000000 60.000000 0.003998)(-12.078000 58.772003 0.003998)(36.199303 10.648701 48.383499)(35.000801 14.307600 12.004000)(34.569199 15.776999 12.004000)(36.199303 10.648701 48.383499)(36.233700 10.109700 12.004000)(35.000801 14.307600 12.004000)(36.199303 10.648701 48.383499)(37.236099 6.696780 12.004000)(36.233700 10.109700 12.004000)(36.199303 10.648701 48.383499)(37.601200 5.453490 12.004000)(37.236099 6.696780 12.004000)(36.199303 10.648701 48.383499)(35.372997 13.884000 84.763000)(37.601200 5.453490 12.004000)(36.199303 10.648701 48.383499)(34.569199 15.776999 12.004000)(35.372997 13.884000 84.763000)(36.233700 10.109700 12.004000)(59.923000 -3.039000 12.004000)(35.000801 14.307600 12.004000)(34.569199 15.776999 12.004000)(34.539497 15.828500 12.004000)(35.372997 13.884000 84.763000)(34.539497 15.828500 12.004000)(29.709000 23.693001 84.763000)(35.372997 13.884000 84.763000)(-0.001000 38.000000 84.763000)(10.648800 36.469097 12.004000)(1.210410 37.826698 12.004000)(-0.001000 38.000000 84.763000)(1.210410 37.826698 12.004000)(-0.001000 38.000999 12.004000)(-0.001000 38.000000 84.763000)(10.952499 36.386501 84.763000)(10.648800 36.469097 12.004000)(10.952499 36.386501 84.763000)(10.706300 36.460602 12.004000)(10.648800 36.469097 12.004000)(-12.078000 58.772003 12.004000)(-12.078000 58.772003 0.003998)(-23.661001 55.138000 12.004000)(-23.661001 55.138000 12.004000)(-0.001000 38.000999 12.004000)(1.210410 37.826698 12.004000)(-0.058500 37.992500 12.004000)(-0.001000 38.000999 12.004000)(-16.532799 45.732498 12.004000)(-23.661001 55.138000 12.004000)(-34.276001 49.245998 12.004000)(-16.532799 45.732498 12.004000)(-34.276001 49.245998 12.004000)(-11.000700 36.327103 12.004000)(-16.532799 45.732498 12.004000)(-11.000700 36.327103 12.004000)(-10.708301 36.460602 12.004000)(-16.532799 45.732498 12.004000)(-10.708301 36.460602 12.004000)(-0.058500 37.992500 12.004000)(-16.532799 45.732498 12.004000)(-0.001000 38.000999 12.004000)(-23.661001 55.138000 12.004000)(-16.532799 45.732498 12.004000)(10.952499 36.386501 84.763000)(15.474000 50.167999 109.619995)(20.974998 31.683002 84.763000)(29.573999 43.377998 109.619995)(29.709000 23.693001 84.763000)(20.974998 31.683002 84.763000)(-58.084999 -15.039000 0.003998)(-59.923000 -3.039000 0.003998)(59.923000 -3.039000 0.003998)(-53.868000 -26.423000 0.003998)(-53.868000 -26.423000 12.004000)(-58.084999 -15.039000 0.003998)(-47.446999 -36.726002 12.004000)(-53.868000 -26.423000 12.004000)(-53.868000 -26.423000 0.003998)(-23.666300 -29.264900 12.004000)(-47.446999 -36.726002 12.004000)(-30.834398 -37.394901 12.004000)(-47.446999 -36.726002 12.004000)(-39.081997 -45.524998 12.004000)(-30.834398 -37.394901 12.004000)(-39.081997 -45.524998 12.004000)(-14.221700 -34.856701 12.004000)(-30.834398 -37.394901 12.004000)(-14.221700 -34.856701 12.004000)(-20.523701 -31.978901 12.004000)(-30.834398 -37.394901 12.004000)(-20.523701 -31.978901 12.004000)(-20.572800 -31.945400 12.004000)(-30.834398 -37.394901 12.004000)(-20.572800 -31.945400 12.004000)(-23.666300 -29.264900 12.004000)(-30.834398 -37.394901 12.004000)(-15.708300 -34.384998 48.383499)(-20.523701 -31.978901 12.004000)(-14.221700 -34.856701 12.004000)(-15.708300 -34.384998 48.383499)(-16.488001 -34.236000 84.763000)(-20.523701 -31.978901 12.004000)(-15.708300 -34.384998 48.383499)(-10.736401 -36.448299 12.004000)(-16.488001 -34.236000 84.763000)(-15.708300 -34.384998 48.383499)(-14.221700 -34.856701 12.004000)(-10.736401 -36.448299 12.004000)(-5.664000 -37.575001 84.763000)(-16.488001 -34.236000 84.763000)(-10.736401 -36.448299 12.004000)(-5.664000 -37.575001 84.763000)(-10.736401 -36.448299 12.004000)(-10.679501 -36.465897 12.004000)(5.663000 -37.575001 84.763000)(16.487001 -34.236000 84.763000)(22.779001 -47.299999 109.619995)(5.663000 -37.575001 84.763000)(7.824000 -51.913002 109.619995)(-5.664000 -37.575001 84.763000)(36.244797 -10.629000 48.383499)(36.922001 -7.765700 12.004000)(37.610001 -5.423000 12.004000)(36.244797 -10.629000 48.383499)(36.116501 -10.508200 12.004000)(36.922001 -7.765700 12.004000)(36.244797 -10.629000 48.383499)(35.193398 -13.651199 12.004000)(36.116501 -10.508200 12.004000)(36.244797 -10.629000 48.383499)(34.577999 -15.746500 12.004000)(35.193398 -13.651199 12.004000)(36.244797 -10.629000 48.383499)(37.046997 -8.455000 84.763000)(34.577999 -15.746500 12.004000)(36.244797 -10.629000 48.383499)(37.610001 -5.423000 12.004000)(37.046997 -8.455000 84.763000)(35.193398 -13.651199 12.004000)(59.923000 -3.039000 12.004000)(36.116501 -10.508200 12.004000)(51.182999 -11.682000 109.619995)(32.908997 -18.998999 84.763000)(37.046997 -8.455000 84.763000)(51.182999 -11.682000 109.619995)(45.466000 -26.250000 109.619995)(32.908997 -18.998999 84.763000)(45.466000 -26.250000 109.619995)(35.709000 -38.485001 109.619995)(25.846001 -27.855999 84.763000)(22.779001 -47.299999 109.619995)(16.487001 -34.236000 84.763000)(35.709000 -38.485001 109.619995)(-34.276001 49.245998 0.003998)(-23.661001 55.138000 0.003998)(59.923000 -3.039000 0.003998)(-12.078000 58.772003 0.003998)(-23.661001 55.138000 0.003998)(-23.661001 55.138000 12.004000)(37.236099 6.696780 12.004000)(59.923000 -3.039000 12.004000)(36.233700 10.109700 12.004000)(37.614498 3.960370 12.004000)(59.923000 -3.039000 12.004000)(37.614498 5.395510 12.004000)(37.614498 5.395510 12.004000)(59.923000 -3.039000 12.004000)(37.601200 5.453490 12.004000)(37.601200 5.453490 12.004000)(59.923000 -3.039000 12.004000)(37.236099 6.696780 12.004000)(37.893002 2.840000 84.763000)(37.614498 5.395510 12.004000)(37.601200 5.453490 12.004000)(35.372997 13.884000 84.763000)(37.893002 2.840000 84.763000)(37.601200 5.453490 12.004000)(29.709000 23.693001 84.763000)(49.930000 16.224001 109.619995)(35.372997 13.884000 84.763000)(-0.058500 37.992500 12.004000)(-10.953500 36.386501 84.763000)(-0.001000 38.000000 84.763000)(-0.001000 38.000999 12.004000)(-0.058500 37.992500 12.004000)(-0.001000 38.000000 84.763000)(-0.001000 52.500000 109.619995)(10.952499 36.386501 84.763000)(-0.001000 38.000000 84.763000)(-23.661001 55.138000 12.004000)(-23.661001 55.138000 0.003998)(-34.276001 49.245998 12.004000)(-20.494600 31.991199 12.004000)(-11.000700 36.327103 12.004000)(-27.243801 40.448101 12.004000)(-11.000700 36.327103 12.004000)(-34.276001 49.245998 12.004000)(-27.243801 40.448101 12.004000)(-34.276001 49.245998 12.004000)(-43.487000 41.338001 12.004000)(-27.243801 40.448101 12.004000)(-43.487000 41.338001 12.004000)(-20.911800 31.650200 12.004000)(-27.243801 40.448101 12.004000)(-20.911800 31.650200 12.004000)(-20.545000 31.968000 12.004000)(-27.243801 40.448101 12.004000)(-20.545000 31.968000 12.004000)(-20.494600 31.991199 12.004000)(-27.243801 40.448101 12.004000)(-11.000700 36.327103 12.004000)(-20.494600 31.991199 12.004000)(-10.953500 36.386501 84.763000)(-10.708301 36.460602 12.004000)(-11.000700 36.327103 12.004000)(-10.953500 36.386501 84.763000)(-0.058500 37.992500 12.004000)(-10.708301 36.460602 12.004000)(-10.953500 36.386501 84.763000)(-0.001000 52.500000 109.619995)(15.474000 50.167999 109.619995)(10.952499 36.386501 84.763000)(29.573999 43.377998 109.619995)(20.974998 31.683002 84.763000)(15.474000 50.167999 109.619995)(29.709000 23.693001 84.763000)(29.573999 43.377998 109.619995)(44.327000 28.131001 109.619995)(-59.923000 -3.039000 0.003998)(-59.307999 9.085999 0.003998)(59.923000 -3.039000 0.003998)(-58.084999 -15.039000 12.004000)(-59.923000 -3.039000 0.003998)(-58.084999 -15.039000 0.003998)(-53.868000 -26.423000 12.004000)(-58.084999 -15.039000 12.004000)(-58.084999 -15.039000 0.003998)(-28.703899 -24.899601 12.004000)(-28.716200 -24.887100 12.004000)(-38.767097 -29.200699 12.004000)(-28.716200 -24.887100 12.004000)(-30.765499 -21.675400 12.004000)(-38.767097 -29.200699 12.004000)(-30.765499 -21.675400 12.004000)(-53.868000 -26.423000 12.004000)(-38.767097 -29.200699 12.004000)(-53.868000 -26.423000 12.004000)(-47.446999 -36.726002 12.004000)(-38.767097 -29.200699 12.004000)(-47.446999 -36.726002 12.004000)(-23.666300 -29.264900 12.004000)(-38.767097 -29.200699 12.004000)(-23.666300 -29.264900 12.004000)(-28.703899 -24.899601 12.004000)(-38.767097 -29.200699 12.004000)(-20.572800 -31.945400 12.004000)(-16.488001 -34.236000 84.763000)(-25.846998 -27.855999 84.763000)(-20.572800 -31.945400 12.004000)(-20.523701 -31.978901 12.004000)(-16.488001 -34.236000 84.763000)(-28.703899 -24.899601 12.004000)(-23.666300 -29.264900 12.004000)(-24.757401 -28.559801 48.383499)(-23.666300 -29.264900 12.004000)(-20.572800 -31.945400 12.004000)(-24.757401 -28.559801 48.383499)(-20.572800 -31.945400 12.004000)(-25.846998 -27.855999 84.763000)(-24.757401 -28.559801 48.383499)(-25.846998 -27.855999 84.763000)(-28.703899 -24.899601 12.004000)(-24.757401 -28.559801 48.383499)(-16.488001 -34.236000 84.763000)(-5.664000 -37.575001 84.763000)(-7.825000 -51.913002 109.619995)(7.824000 -51.913002 109.619995)(5.663000 -37.575001 84.763000)(22.779001 -47.299999 109.619995)(-7.825000 -51.913002 109.619995)(-5.664000 -37.575001 84.763000)(7.824000 -51.913002 109.619995)(36.922001 -7.765700 12.004000)(59.923000 -3.039000 12.004000)(37.610001 -5.423000 12.004000)(37.610001 -5.423000 12.004000)(59.923000 -3.039000 12.004000)(37.614498 -5.363700 12.004000)(37.614498 -5.363700 12.004000)(59.923000 -3.039000 12.004000)(37.614498 -5.307510 12.004000)(36.116501 -10.508200 12.004000)(59.923000 -3.039000 12.004000)(36.922001 -7.765700 12.004000)(37.610001 -5.423000 12.004000)(37.614498 -5.363700 12.004000)(37.046997 -8.455000 84.763000)(37.614498 -5.363700 12.004000)(37.893002 2.840000 84.763000)(37.046997 -8.455000 84.763000)(51.182999 -11.682000 109.619995)(37.046997 -8.455000 84.763000)(52.352997 3.924000 109.619995)(45.466000 -26.250000 109.619995)(51.182999 -11.682000 109.619995)(47.502998 -22.352999 208.619995)(40.452000 -33.465000 208.619995)(35.709000 -38.485001 109.619995)(45.466000 -26.250000 109.619995)(22.779001 -47.299999 109.619995)(35.709000 -38.485001 109.619995)(30.858999 -42.473000 208.619995)(-43.487000 41.338001 0.003998)(-34.276001 49.245998 0.003998)(59.923000 -3.039000 0.003998)(-23.661001 55.138000 0.003998)(-34.276001 49.245998 0.003998)(-34.276001 49.245998 12.004000)(37.753700 0.015905 48.383499)(37.614498 3.960370 12.004000)(37.614498 5.395510 12.004000)(37.753700 0.015905 48.383499)(37.614498 1.545470 12.004000)(37.614498 3.960370 12.004000)(37.753700 0.015905 48.383499)(37.614498 -0.770371 12.004000)(37.614498 1.545470 12.004000)(37.753700 0.015905 48.383499)(37.614498 -3.039000 12.004000)(37.614498 -0.770371 12.004000)(37.753700 0.015905 48.383499)(37.614498 -5.307510 12.004000)(37.614498 -3.039000 12.004000)(37.753700 0.015905 48.383499)(37.614498 -5.363700 12.004000)(37.614498 -5.307510 12.004000)(37.753700 0.015905 48.383499)(37.893002 2.840000 84.763000)(37.614498 -5.363700 12.004000)(37.753700 0.015905 48.383499)(37.614498 5.395510 12.004000)(37.893002 2.840000 84.763000)(37.614498 1.545470 12.004000)(59.923000 -3.039000 12.004000)(37.614498 3.960370 12.004000)(35.372997 13.884000 84.763000)(49.930000 16.224001 109.619995)(37.893002 2.840000 84.763000)(44.327000 28.131001 109.619995)(49.930000 16.224001 109.619995)(29.709000 23.693001 84.763000)(-10.953500 36.386501 84.763000)(-15.475000 50.167999 109.619995)(-0.001000 38.000000 84.763000)(-15.475000 50.167999 109.619995)(-0.001000 52.500000 109.619995)(-0.001000 38.000000 84.763000)(-34.276001 49.245998 12.004000)(-34.276001 49.245998 0.003998)(-43.487000 41.338001 12.004000)(-28.676100 24.922199 12.004000)(-20.911800 31.650200 12.004000)(-35.915401 33.064602 12.004000)(-20.911800 31.650200 12.004000)(-43.487000 41.338001 12.004000)(-35.915401 33.064602 12.004000)(-43.487000 41.338001 12.004000)(-50.918999 31.738003 12.004000)(-35.915401 33.064602 12.004000)(-50.918999 31.738003 12.004000)(-28.778101 24.791201 12.004000)(-35.915401 33.064602 12.004000)(-28.778101 24.791201 12.004000)(-28.716200 24.888100 12.004000)(-35.915401 33.064602 12.004000)(-28.716200 24.888100 12.004000)(-28.676100 24.922199 12.004000)(-35.915401 33.064602 12.004000)(-20.911800 31.650200 12.004000)(-28.676100 24.922199 12.004000)(-20.545000 31.968000 84.763000)(-20.545000 31.968000 12.004000)(-20.911800 31.650200 12.004000)(-20.545000 31.968000 84.763000)(-20.545000 31.968000 84.763000)(-10.953500 36.386501 84.763000)(-20.494600 31.991199 12.004000)(-20.545000 31.968000 84.763000)(-20.494600 31.991199 12.004000)(-20.545000 31.968000 12.004000)(15.474000 50.167999 109.619995)(-0.001000 52.500000 109.619995)(0.000000 52.500000 153.419998)(13.056000 50.850998 153.419998)(29.573999 43.377998 109.619995)(15.474000 50.167999 109.619995)(44.327000 28.131001 109.619995)(29.573999 43.377998 109.619995)(35.938000 38.271000 208.619995)(-59.307999 9.085999 0.003998)(-56.264999 20.837999 0.003998)(59.923000 -3.039000 0.003998)(-59.923000 -3.039000 0.003998)(-59.923000 -3.039000 12.004000)(-59.307999 9.085999 0.003998)(-59.923000 -3.039000 0.003998)(-58.084999 -15.039000 12.004000)(-59.923000 -3.039000 12.004000)(-30.765499 -21.675400 12.004000)(-34.634998 -15.611100 12.004000)(-34.767399 -15.611100 12.004000)(-50.121799 -15.611100 12.004000)(-50.136902 -15.572200 12.004000)(-58.084999 -15.039000 12.004000)(-50.136902 -15.572200 12.004000)(-50.144798 -15.547800 12.004000)(-58.084999 -15.039000 12.004000)(-50.144798 -15.547800 12.004000)(-50.465401 -14.264200 12.004000)(-58.084999 -15.039000 12.004000)(-53.868000 -26.423000 12.004000)(-50.121799 -15.611100 12.004000)(-58.084999 -15.039000 12.004000)(-34.767399 -15.611100 12.004000)(-50.121799 -15.611100 12.004000)(-44.425301 -20.343599 12.004000)(-53.868000 -26.423000 12.004000)(-30.765499 -21.675400 12.004000)(-44.425301 -20.343599 12.004000)(-30.765499 -21.675400 12.004000)(-34.767399 -15.611100 12.004000)(-44.425301 -20.343599 12.004000)(-50.121799 -15.611100 12.004000)(-53.868000 -26.423000 12.004000)(-44.425301 -20.343599 12.004000)(-28.195000 -25.476999 84.763000)(-28.716200 -24.887100 12.004000)(-28.703899 -24.899601 12.004000)(-25.846998 -27.855999 84.763000)(-28.195000 -25.476999 84.763000)(-28.703899 -24.899601 12.004000)(-28.195000 -25.476999 84.763000)(-34.634998 -15.611100 12.004000)(-30.765499 -21.675400 12.004000)(-28.195000 -25.476999 84.763000)(-30.765499 -21.675400 12.004000)(-28.716200 -24.887100 12.004000)(-25.846998 -27.855999 84.763000)(-16.488001 -34.236000 84.763000)(-22.779001 -47.301003 109.619995)(-16.488001 -34.236000 84.763000)(-7.825000 -51.913002 109.619995)(-22.779001 -47.301003 109.619995)(7.824000 -51.913002 109.619995)(22.779001 -47.299999 109.619995)(17.000000 -49.671001 153.419998)(7.824000 -51.913002 109.619995)(6.580000 -52.085999 153.419998)(-7.825000 -51.913002 109.619995)(37.614498 -5.307510 12.004000)(59.923000 -3.039000 12.004000)(37.614498 -3.039000 12.004000)(52.352997 3.924000 109.619995)(37.046997 -8.455000 84.763000)(37.893002 2.840000 84.763000)(51.182999 -11.682000 109.619995)(52.352997 3.924000 109.619995)(52.396000 3.297000 208.619995)(51.182999 -11.682000 109.619995)(51.570000 -9.837000 208.619995)(47.502998 -22.352999 208.619995)(45.466000 -26.250000 109.619995)(47.502998 -22.352999 208.619995)(40.452000 -33.465000 208.619995)(35.709000 -38.485001 109.619995)(40.452000 -33.465000 208.619995)(30.858999 -42.473000 208.619995)(22.779001 -47.299999 109.619995)(30.858999 -42.473000 208.619995)(19.327000 -48.813000 208.619995)(-50.918999 31.738003 0.003998)(-43.487000 41.338001 0.003998)(59.923000 -3.039000 0.003998)(-43.487000 41.338001 12.004000)(-34.276001 49.245998 0.003998)(-43.487000 41.338001 0.003998)(37.614498 -0.770371 12.004000)(59.923000 -3.039000 12.004000)(37.614498 1.545470 12.004000)(37.614498 -3.039000 12.004000)(59.923000 -3.039000 12.004000)(37.614498 -0.770371 12.004000)(49.930000 16.224001 109.619995)(52.352997 3.924000 109.619995)(37.893002 2.840000 84.763000)(49.930000 16.224001 109.619995)(44.327000 28.131001 109.619995)(44.327000 28.131001 208.619995)(-15.475000 50.167999 109.619995)(-10.953500 36.386501 84.763000)(-29.574999 43.377998 109.619995)(-0.001000 52.500000 109.619995)(-15.475000 50.167999 109.619995)(-13.057000 50.850998 153.419998)(-43.487000 41.338001 0.003998)(-50.918999 31.738003 12.004000)(-43.487000 41.338001 12.004000)(-28.778101 24.791201 12.004000)(-50.918999 31.738003 12.004000)(-42.521500 24.020201 12.004000)(-50.918999 31.738003 12.004000)(-56.264999 20.837999 12.004000)(-42.521500 24.020201 12.004000)(-56.264999 20.837999 12.004000)(-34.194500 16.302399 12.004000)(-42.521500 24.020201 12.004000)(-34.194500 16.302399 12.004000)(-28.778101 24.791201 12.004000)(-42.521500 24.020201 12.004000)(-28.716200 24.888100 12.004000)(-28.778101 24.791201 12.004000)(-28.195000 25.476999 84.763000)(-28.778101 24.791201 12.004000)(-34.194500 16.302399 12.004000)(-28.195000 25.476999 84.763000)(-34.194500 16.302399 12.004000)(-34.634998 15.612101 12.004000)(-28.195000 25.476999 84.763000)(-28.676100 24.922199 12.004000)(-28.195000 25.476999 84.763000)(-20.545000 31.968000 84.763000)(-28.676100 24.922199 12.004000)(-28.716200 24.888100 12.004000)(-28.195000 25.476999 84.763000)(-29.574999 43.377998 109.619995)(-10.953500 36.386501 84.763000)(-20.545000 31.968000 84.763000)(-0.001000 52.500000 109.619995)(-13.057000 50.850998 153.419998)(0.000000 52.500000 153.419998)(15.474000 50.167999 109.619995)(0.000000 52.500000 153.419998)(13.056000 50.850998 153.419998)(29.573999 43.377998 109.619995)(13.056000 50.850998 153.419998)(17.000000 49.672001 153.419998)(25.292000 46.006001 208.619995)(35.938000 38.271000 208.619995)(29.573999 43.377998 109.619995)(44.327000 28.131001 109.619995)(35.938000 38.271000 208.619995)(44.327000 28.131001 208.619995)(-56.264999 20.837999 0.003998)(-50.918999 31.738003 0.003998)(59.923000 -3.039000 0.003998)(-59.307999 9.085999 0.003998)(-59.307999 9.085999 12.004000)(-56.264999 20.837999 0.003998)(-59.307999 9.085999 0.003998)(-59.923000 -3.039000 12.004000)(-59.307999 9.085999 12.004000)(-51.998501 -3.039000 12.004000)(-59.923000 -3.039000 12.004000)(-55.194199 -9.039000 12.004000)(-59.923000 -3.039000 12.004000)(-58.084999 -15.039000 12.004000)(-55.194199 -9.039000 12.004000)(-58.084999 -15.039000 12.004000)(-50.465401 -14.264200 12.004000)(-55.194199 -9.039000 12.004000)(-50.465401 -14.264200 12.004000)(-51.570999 -9.837000 12.004000)(-55.194199 -9.039000 12.004000)(-51.570999 -9.837000 12.004000)(-51.998501 -3.039000 12.004000)(-55.194199 -9.039000 12.004000)(-34.767399 -15.611100 12.004000)(-34.634998 -15.611100 12.004000)(-37.849503 -20.543900 48.383499)(-34.634998 -15.611100 12.004000)(-28.195000 -25.476999 84.763000)(-37.849503 -20.543900 48.383499)(-28.195000 -25.476999 84.763000)(-47.504002 -22.352999 61.726002)(-37.849503 -20.543900 48.383499)(-47.504002 -22.352999 61.726002)(-34.767399 -15.611100 12.004000)(-37.849503 -20.543900 48.383499)(-50.121799 -15.611100 12.004000)(-34.767399 -15.611100 12.004000)(-47.504002 -22.352999 61.726002)(-50.136902 -15.572200 12.004000)(-50.121799 -15.611100 12.004000)(-47.504002 -22.352999 61.726002)(-50.136902 -15.572200 12.004000)(-47.504002 -22.352999 61.726002)(-47.502998 -22.352999 208.619995)(-50.144798 -15.547800 12.004000)(-50.136902 -15.572200 12.004000)(-51.570000 -9.838000 208.619995)(-50.136902 -15.572200 12.004000)(-47.502998 -22.352999 208.619995)(-51.570000 -9.838000 208.619995)(-51.570000 -9.838000 208.619995)(-51.570999 -9.837000 12.004000)(-50.465401 -14.264200 12.004000)(-51.570000 -9.838000 208.619995)(-50.465401 -14.264200 12.004000)(-50.144798 -15.547800 12.004000)(-35.709000 -38.485001 109.619995)(-28.195000 -25.476999 84.763000)(-25.846998 -27.855999 84.763000)(-25.846998 -27.855999 84.763000)(-22.779001 -47.301003 109.619995)(-30.858999 -42.473000 109.619995)(-6.580000 -52.085999 153.419998)(-22.779001 -47.301003 109.619995)(-7.825000 -51.913002 109.619995)(19.327000 -48.813000 208.619995)(17.000000 -49.671001 153.419998)(22.779001 -47.299999 109.619995)(17.000000 -49.671001 153.419998)(6.580000 -52.085999 153.419998)(7.824000 -51.913002 109.619995)(-7.825000 -51.913002 109.619995)(6.580000 -52.085999 153.419998)(-6.580000 -52.085999 153.419998)(52.352997 3.924000 109.619995)(49.930000 16.224001 208.619995)(52.396000 3.297000 208.619995)(52.396000 3.297000 208.619995)(51.570000 -9.837000 208.619995)(51.182999 -11.682000 109.619995)(51.570000 -9.837000 208.619995)(60.353001 -18.068001 225.619995)(47.502998 -22.352999 208.619995)(47.502998 -22.352999 208.619995)(54.559998 -31.500000 225.619995)(40.452000 -33.465000 208.619995)(30.858999 -42.473000 208.619995)(40.452000 -33.465000 208.619995)(45.825001 -43.232998 225.619995)(19.327000 -48.813000 208.619995)(30.858999 -42.473000 208.619995)(34.618999 -52.636002 225.619995)(-50.918999 31.738003 12.004000)(-43.487000 41.338001 0.003998)(-50.918999 31.738003 0.003998)(52.352997 3.924000 109.619995)(49.930000 16.224001 109.619995)(49.930000 16.224001 208.619995)(44.327000 28.131001 208.619995)(49.930000 16.224001 208.619995)(49.930000 16.224001 109.619995)(-25.292000 46.006001 208.619995)(-15.475000 50.167999 109.619995)(-29.574999 43.377998 109.619995)(-17.000000 49.672001 153.419998)(-13.057000 50.850998 153.419998)(-15.475000 50.167999 109.619995)(-56.264999 20.837999 12.004000)(-50.918999 31.738003 12.004000)(-50.918999 31.738003 0.003998)(-34.634998 15.612101 12.004000)(-34.194500 16.302399 12.004000)(-50.026802 15.612101 12.004000)(-51.478901 8.289830 12.004000)(-50.146400 15.536099 12.004000)(-59.307999 9.085999 12.004000)(-50.117401 15.612101 12.004000)(-50.026802 15.612101 12.004000)(-56.264999 20.837999 12.004000)(-50.146400 15.536099 12.004000)(-50.141598 15.561300 12.004000)(-56.264999 20.837999 12.004000)(-50.141598 15.561300 12.004000)(-50.117401 15.612101 12.004000)(-56.264999 20.837999 12.004000)(-59.307999 9.085999 12.004000)(-50.146400 15.536099 12.004000)(-56.264999 20.837999 12.004000)(-50.026802 15.612101 12.004000)(-34.194500 16.302399 12.004000)(-56.264999 20.837999 12.004000)(-28.195000 25.476999 84.763000)(-34.634998 15.612101 12.004000)(-50.026802 15.612101 12.004000)(-35.938999 38.271000 109.619995)(-20.545000 31.968000 84.763000)(-28.195000 25.476999 84.763000)(-20.545000 31.968000 84.763000)(-35.938999 38.271000 109.619995)(-29.574999 43.377998 109.619995)(29.573999 43.377998 109.619995)(17.000000 49.672001 153.419998)(25.292000 46.006001 208.619995)(25.292000 46.006001 208.619995)(43.125999 45.924999 225.619995)(35.938000 38.271000 208.619995)(53.193001 33.757000 225.619995)(44.327000 28.131001 208.619995)(35.938000 38.271000 208.619995)(-56.264999 20.837999 12.004000)(-50.918999 31.738003 0.003998)(-56.264999 20.837999 0.003998)(-56.264999 20.837999 0.003998)(-59.307999 9.085999 12.004000)(-56.264999 20.837999 12.004000)(-51.478901 8.289830 12.004000)(-59.307999 9.085999 12.004000)(-55.700897 3.023500 12.004000)(-59.307999 9.085999 12.004000)(-59.923000 -3.039000 12.004000)(-55.700897 3.023500 12.004000)(-59.923000 -3.039000 12.004000)(-51.998501 -3.039000 12.004000)(-55.700897 3.023500 12.004000)(-51.998501 -3.039000 12.004000)(-52.395401 3.271400 12.004000)(-55.700897 3.023500 12.004000)(-55.700897 3.023500 12.004000)(-52.397003 3.297000 12.004000)(-52.395401 3.271400 12.004000)(-52.397003 3.297000 12.004000)(-51.478901 8.289830 12.004000)(-55.700897 3.023500 12.004000)(-51.570000 -9.838000 208.619995)(-52.395401 3.271400 12.004000)(-51.998501 -3.039000 12.004000)(-51.570000 -9.838000 208.619995)(-51.998501 -3.039000 12.004000)(-51.570999 -9.837000 12.004000)(-47.504002 -22.352999 61.726002)(-28.195000 -25.476999 84.763000)(-37.849503 -25.600201 85.672997)(-28.195000 -25.476999 84.763000)(-43.864998 -28.847000 109.619995)(-37.849503 -25.600201 85.672997)(-43.864998 -28.847000 109.619995)(-47.504002 -22.352999 61.726002)(-37.849503 -25.600201 85.672997)(-43.864998 -28.847000 109.619995)(-47.502998 -22.352999 208.619995)(-47.504002 -22.352999 61.726002)(-47.502998 -22.352999 208.619995)(-61.884003 -11.804999 225.619995)(-51.570000 -9.838000 208.619995)(-30.858999 -42.473000 109.619995)(-35.709000 -38.485001 109.619995)(-25.846998 -27.855999 84.763000)(-28.195000 -25.476999 84.763000)(-35.709000 -38.485001 109.619995)(-40.452000 -33.465000 109.619995)(-30.858999 -42.473000 208.619995)(-30.858999 -42.473000 109.619995)(-22.779001 -47.301003 109.619995)(-6.580000 -52.085999 153.419998)(-17.000000 -49.671001 153.419998)(-22.779001 -47.301003 109.619995)(19.327000 -48.813000 208.619995)(17.000000 -49.671001 201.919998)(17.000000 -49.671001 153.419998)(49.930000 16.224001 208.619995)(62.875999 3.956000 225.619995)(52.396000 3.297000 208.619995)(62.875999 3.956000 225.619995)(51.570000 -9.837000 208.619995)(52.396000 3.297000 208.619995)(61.884003 -11.804999 225.619995)(60.353001 -18.068001 225.619995)(51.570000 -9.837000 208.619995)(54.559998 -31.500000 225.619995)(47.502998 -22.352999 208.619995)(60.353001 -18.068001 225.619995)(40.452000 -33.465000 208.619995)(54.559998 -31.500000 225.619995)(45.825001 -43.232998 225.619995)(45.825001 -43.232998 225.619995)(34.618999 -52.636002 225.619995)(30.858999 -42.473000 208.619995)(21.547001 -59.201000 225.619995)(19.327000 -48.813000 208.619995)(34.618999 -52.636002 225.619995)(59.917000 19.468000 225.619995)(49.930000 16.224001 208.619995)(44.327000 28.131001 208.619995)(-17.000000 49.672001 153.419998)(-15.475000 50.167999 109.619995)(-25.292000 46.006001 208.619995)(-29.574999 43.377998 109.619995)(-35.938999 38.271000 208.619995)(-25.292000 46.006001 208.619995)(-43.864998 28.848000 109.619995)(-50.117401 15.612101 12.004000)(-46.585400 23.250200 68.337097)(-50.026802 15.612101 12.004000)(-50.117401 15.612101 12.004000)(-39.156197 22.229799 60.812000)(-50.117401 15.612101 12.004000)(-43.864998 28.848000 109.619995)(-39.156197 22.229799 60.812000)(-43.864998 28.848000 109.619995)(-28.195000 25.476999 84.763000)(-39.156197 22.229799 60.812000)(-28.195000 25.476999 84.763000)(-50.026802 15.612101 12.004000)(-39.156197 22.229799 60.812000)(-52.397003 3.296000 208.619995)(-50.146400 15.536099 12.004000)(-51.478901 8.289830 12.004000)(-52.397003 3.296000 208.619995)(-51.478901 8.289830 12.004000)(-52.397003 3.297000 12.004000)(-49.931000 16.223000 208.619995)(-50.141598 15.561300 12.004000)(-50.146400 15.536099 12.004000)(-52.397003 3.296000 208.619995)(-49.931000 16.223000 208.619995)(-50.146400 15.536099 12.004000)(-46.585400 23.250200 68.337097)(-50.117401 15.612101 12.004000)(-50.141598 15.561300 12.004000)(-49.931000 16.223000 208.619995)(-46.585400 23.250200 68.337097)(-50.141598 15.561300 12.004000)(-28.195000 25.476999 84.763000)(-41.047001 32.733002 109.619995)(-35.938999 38.271000 109.619995)(-35.938999 38.271000 208.619995)(-29.574999 43.377998 109.619995)(-35.938999 38.271000 109.619995)(17.000000 49.672001 201.919998)(25.292000 46.006001 208.619995)(17.000000 49.672001 153.419998)(43.125999 45.924999 225.619995)(25.292000 46.006001 208.619995)(30.350000 55.207001 225.619995)(35.938000 38.271000 208.619995)(43.125999 45.924999 225.619995)(53.193001 33.757000 225.619995)(59.917000 19.468000 225.619995)(44.327000 28.131001 208.619995)(53.193001 33.757000 225.619995)(-52.397003 3.296000 208.619995)(-52.397003 3.297000 12.004000)(-52.395401 3.271400 12.004000)(-51.570000 -9.838000 208.619995)(-52.397003 3.296000 208.619995)(-52.395401 3.271400 12.004000)(-28.195000 -25.476999 84.763000)(-40.452000 -33.465000 109.619995)(-43.864998 -28.847000 109.619995)(-43.864998 -28.847000 109.619995)(-40.452000 -33.465000 109.619995)(-47.502998 -22.352999 208.619995)(-61.884003 -11.804999 225.619995)(-47.502998 -22.352999 208.619995)(-57.004002 -26.823999 225.619995)(-62.875999 3.956000 225.619995)(-51.570000 -9.838000 208.619995)(-61.884003 -11.804999 225.619995)(-30.858999 -42.473000 208.619995)(-35.709000 -38.485001 109.619995)(-30.858999 -42.473000 109.619995)(-40.452000 -33.465000 109.619995)(-35.709000 -38.485001 109.619995)(-40.452000 -33.465000 208.619995)(-22.779001 -47.301003 109.619995)(-19.326000 -48.813000 208.619995)(-30.858999 -42.473000 208.619995)(-19.326000 -48.813000 208.619995)(-22.779001 -47.301003 109.619995)(-17.000000 -49.671001 153.419998)(19.327000 -48.813000 208.619995)(6.580000 -52.085999 201.919998)(17.000000 -49.671001 201.919998)(62.875999 3.956000 225.619995)(49.930000 16.224001 208.619995)(59.917000 19.468000 225.619995)(62.875999 3.956000 225.619995)(61.884003 -11.804999 225.619995)(51.570000 -9.837000 208.619995)(60.353001 -18.068001 225.619995)(61.884003 -11.804999 225.619995)(60.353001 -18.068001 229.619995)(60.353001 -18.068001 225.619995)(60.353001 -18.068001 229.619995)(54.559998 -31.500000 225.619995)(54.559998 -31.500000 225.619995)(54.559998 -31.500000 229.619995)(45.825001 -43.232998 225.619995)(45.825001 -43.232998 229.619995)(34.618999 -52.636002 225.619995)(45.825001 -43.232998 225.619995)(6.580000 -52.085999 208.619995)(19.327000 -48.813000 208.619995)(21.547001 -59.201000 225.619995)(21.547001 -59.201000 225.619995)(34.618999 -52.636002 225.619995)(34.618999 -52.636002 229.619995)(-17.000000 49.672001 153.419998)(-25.292000 46.006001 208.619995)(-17.000000 49.671001 201.919998)(-25.292000 46.006001 208.619995)(-35.938999 38.271000 208.619995)(-40.495998 48.261002 225.619995)(-44.327000 28.131001 208.619995)(-43.864998 28.848000 109.619995)(-46.585400 23.250200 68.337097)(-28.195000 25.476999 84.763000)(-43.864998 28.848000 109.619995)(-41.047001 32.733002 109.619995)(-52.397003 3.296000 208.619995)(-59.917000 19.468000 225.619995)(-49.931000 16.223000 208.619995)(-49.931000 16.223000 208.619995)(-44.327000 28.131001 208.619995)(-46.585400 23.250200 68.337097)(-35.938999 38.271000 109.619995)(-41.047001 32.733002 109.619995)(-35.938999 38.271000 208.619995)(13.056000 50.850998 208.619995)(25.292000 46.006001 208.619995)(17.000000 49.672001 201.919998)(13.056000 50.850998 208.619995)(30.350000 55.207001 225.619995)(25.292000 46.006001 208.619995)(40.495998 48.261002 229.619995)(43.125999 45.924999 225.619995)(30.350000 55.207001 225.619995)(43.125999 45.924999 225.619995)(50.534000 37.620998 229.619995)(53.193001 33.757000 225.619995)(53.193001 33.757000 225.619995)(57.848000 24.953001 229.619995)(59.917000 19.468000 225.619995)(-52.397003 3.296000 208.619995)(-51.570000 -9.838000 208.619995)(-62.875999 3.956000 225.619995)(-40.452000 -33.465000 109.619995)(-40.452000 -33.465000 208.619995)(-47.502998 -22.352999 208.619995)(-40.452000 -33.465000 208.619995)(-57.004002 -26.823999 225.619995)(-47.502998 -22.352999 208.619995)(-57.004002 -26.823999 225.619995)(-60.353001 -18.069000 229.619995)(-61.884003 -11.804999 225.619995)(-62.893002 -3.663000 229.619995)(-62.875999 3.956000 225.619995)(-61.884003 -11.804999 225.619995)(-35.709000 -38.485001 109.619995)(-30.858999 -42.473000 208.619995)(-40.452000 -33.465000 208.619995)(-37.029999 -50.967999 225.619995)(-30.858999 -42.473000 208.619995)(-19.326000 -48.813000 208.619995)(-19.326000 -48.813000 208.619995)(-17.000000 -49.671001 153.419998)(-17.000000 -49.671001 201.919998)(6.580000 -52.085999 208.619995)(6.580000 -52.085999 201.919998)(19.327000 -48.813000 208.619995)(59.917000 19.468000 225.619995)(62.042999 10.940001 229.619995)(62.875999 3.956000 225.619995)(62.875999 3.956000 225.619995)(62.893002 -3.663000 229.619995)(61.884003 -11.804999 225.619995)(61.884003 -11.804999 225.619995)(62.893002 -3.663000 229.619995)(60.353001 -18.068001 229.619995)(60.353001 -18.068001 229.619995)(54.559998 -31.500000 229.619995)(54.559998 -31.500000 225.619995)(45.825001 -43.232998 225.619995)(54.559998 -31.500000 229.619995)(45.825001 -43.232998 229.619995)(34.618999 -52.636002 225.619995)(45.825001 -43.232998 229.619995)(34.618999 -52.636002 229.619995)(6.580000 -52.085999 208.619995)(21.547001 -59.201000 225.619995)(7.314000 -62.573997 225.619995)(21.547001 -59.201000 225.619995)(34.618999 -52.636002 229.619995)(21.547998 -59.201000 229.619995)(-13.056000 50.850998 201.919998)(-17.000000 49.671001 201.919998)(-25.292000 46.006001 208.619995)(-50.534000 37.620998 225.619995)(-40.495998 48.261002 225.619995)(-35.938999 38.271000 208.619995)(-40.495998 48.261002 225.619995)(-28.275000 56.299000 225.619995)(-25.292000 46.006001 208.619995)(-44.327000 28.131001 208.619995)(-35.938999 38.271000 208.619995)(-43.864998 28.848000 109.619995)(-35.938999 38.271000 208.619995)(-41.047001 32.733002 109.619995)(-43.864998 28.848000 109.619995)(-59.917000 19.468000 225.619995)(-52.397003 3.296000 208.619995)(-62.875999 3.956000 225.619995)(-57.848000 24.953001 225.619995)(-49.931000 16.223000 208.619995)(-59.917000 19.468000 225.619995)(-49.931000 16.223000 208.619995)(-57.848000 24.953001 225.619995)(-44.327000 28.131001 208.619995)(13.056000 50.850998 208.619995)(17.000000 49.672001 201.919998)(13.056000 50.850998 201.919998)(13.056000 50.850998 208.619995)(15.667001 61.021000 225.619995)(30.350000 55.207001 225.619995)(28.274000 56.299000 229.619995)(40.495998 48.261002 229.619995)(30.350000 55.207001 225.619995)(43.125999 45.924999 225.619995)(40.495998 48.261002 229.619995)(50.534000 37.620998 229.619995)(50.534000 37.620998 229.619995)(57.848000 24.953001 229.619995)(53.193001 33.757000 225.619995)(57.848000 24.953001 229.619995)(62.042999 10.940001 229.619995)(59.917000 19.468000 225.619995)(-57.004002 -26.823999 225.619995)(-40.452000 -33.465000 208.619995)(-48.542000 -40.158001 225.619995)(-57.004002 -26.823999 225.619995)(-54.558998 -31.500000 229.619995)(-60.353001 -18.069000 229.619995)(-60.353001 -18.069000 229.619995)(-62.893002 -3.663000 229.619995)(-61.884003 -11.804999 225.619995)(-63.000000 0.000001 229.619995)(-62.875999 3.956000 225.619995)(-62.893002 -3.663000 229.619995)(-40.452000 -33.465000 208.619995)(-30.858999 -42.473000 208.619995)(-48.542000 -40.158001 225.619995)(-37.029999 -50.967999 225.619995)(-19.326000 -48.813000 208.619995)(-23.191999 -58.576000 225.619995)(-37.029999 -50.967999 225.619995)(-48.542000 -40.158001 225.619995)(-30.858999 -42.473000 208.619995)(-19.326000 -48.813000 208.619995)(-17.000000 -49.671001 201.919998)(-6.580000 -52.085999 208.619995)(-6.580000 -52.085999 201.919998)(6.580000 -52.085999 201.919998)(6.580000 -52.085999 208.619995)(62.875999 3.956000 225.619995)(62.042999 10.940001 229.619995)(62.893002 -3.663000 229.619995)(62.893002 -3.663000 229.619995)(62.042999 10.940001 229.619995)(60.353001 -18.068001 229.619995)(54.559998 -31.500000 229.619995)(60.353001 -18.068001 229.619995)(14.529000 61.301998 229.619995)(45.825001 -43.232998 229.619995)(54.559998 -31.500000 229.619995)(14.529000 61.301998 229.619995)(34.618999 -52.636002 229.619995)(45.825001 -43.232998 229.619995)(14.529000 61.301998 229.619995)(-7.314000 -62.573997 225.619995)(6.580000 -52.085999 208.619995)(7.314000 -62.573997 225.619995)(7.314000 -62.573997 225.619995)(21.547001 -59.201000 225.619995)(21.547998 -59.201000 229.619995)(21.547998 -59.201000 229.619995)(34.618999 -52.636002 229.619995)(0.000000 63.000000 229.619995)(-13.056000 50.850998 208.619995)(-13.056000 50.850998 201.919998)(-25.292000 46.006001 208.619995)(-50.534000 37.620998 225.619995)(-35.938999 38.271000 208.619995)(-44.327000 28.131001 208.619995)(-50.534000 37.620998 229.619995)(-40.495998 48.261002 225.619995)(-50.534000 37.620998 225.619995)(-25.292000 46.006001 208.619995)(-28.275000 56.299000 225.619995)(-13.056000 50.850998 208.619995)(-40.495998 48.261002 229.619995)(-28.275000 56.299000 225.619995)(-40.495998 48.261002 225.619995)(-62.875999 3.956000 225.619995)(-62.042999 10.940001 229.619995)(-59.917000 19.468000 225.619995)(-57.848000 24.953001 225.619995)(-59.917000 19.468000 225.619995)(-57.848000 24.953001 229.619995)(-50.534000 37.620998 225.619995)(-44.327000 28.131001 208.619995)(-57.848000 24.953001 225.619995)(13.056000 50.850998 208.619995)(13.056000 50.850998 201.919998)(0.000000 52.500000 208.619995)(0.000000 52.500000 208.619995)(15.667001 61.021000 225.619995)(13.056000 50.850998 208.619995)(28.274000 56.299000 229.619995)(30.350000 55.207001 225.619995)(15.667001 61.021000 225.619995)(60.353001 -18.068001 229.619995)(40.495998 48.261002 229.619995)(28.274000 56.299000 229.619995)(50.534000 37.620998 229.619995)(40.495998 48.261002 229.619995)(60.353001 -18.068001 229.619995)(57.848000 24.953001 229.619995)(50.534000 37.620998 229.619995)(60.353001 -18.068001 229.619995)(62.042999 10.940001 229.619995)(57.848000 24.953001 229.619995)(60.353001 -18.068001 229.619995)(-48.542000 -40.158001 225.619995)(-54.558998 -31.500000 229.619995)(-57.004002 -26.823999 225.619995)(-60.353001 -18.069000 229.619995)(-54.558998 -31.500000 229.619995)(-62.893002 -3.663000 229.619995)(-62.893002 -3.663000 229.619995)(0.000000 63.000000 229.619995)(-63.000000 0.000001 229.619995)(-62.875999 3.956000 225.619995)(-63.000000 0.000001 229.619995)(-62.042999 10.940001 229.619995)(-19.326000 -48.813000 208.619995)(-6.580000 -52.085999 208.619995)(-23.191999 -58.576000 225.619995)(-37.029999 -50.967999 225.619995)(-23.191999 -58.576000 225.619995)(-34.618999 -52.636002 229.619995)(-45.823997 -43.232998 229.619995)(-48.542000 -40.158001 225.619995)(-37.029999 -50.967999 225.619995)(-6.580000 -52.085999 208.619995)(-17.000000 -49.671001 201.919998)(-6.580000 -52.085999 201.919998)(-6.580000 -52.085999 208.619995)(-6.580000 -52.085999 201.919998)(6.580000 -52.085999 208.619995)(60.353001 -18.068001 229.619995)(28.274000 56.299000 229.619995)(14.529000 61.301998 229.619995)(34.618999 -52.636002 229.619995)(14.529000 61.301998 229.619995)(0.000000 63.000000 229.619995)(-6.580000 -52.085999 208.619995)(6.580000 -52.085999 208.619995)(-7.314000 -62.573997 225.619995)(-7.314000 -62.573997 225.619995)(7.314000 -62.573997 225.619995)(7.314000 -62.573997 229.619995)(7.314000 -62.573997 229.619995)(7.314000 -62.573997 225.619995)(21.547998 -59.201000 229.619995)(21.547998 -59.201000 229.619995)(0.000000 63.000000 229.619995)(-20.672501 1.899500 229.619995)(0.000000 63.000000 229.619995)(-62.893002 -3.663000 229.619995)(-20.672501 1.899500 229.619995)(-62.893002 -3.663000 229.619995)(21.547998 -59.201000 229.619995)(-20.672501 1.899500 229.619995)(-13.056000 50.850998 208.619995)(0.000000 52.500000 201.919998)(-13.056000 50.850998 201.919998)(-50.534000 37.620998 225.619995)(-57.848000 24.953001 229.619995)(-50.534000 37.620998 229.619995)(-40.495998 48.261002 225.619995)(-50.534000 37.620998 229.619995)(-40.495998 48.261002 229.619995)(-14.529000 61.301998 225.619995)(-13.056000 50.850998 208.619995)(-28.275000 56.299000 225.619995)(-28.275000 56.299000 225.619995)(-40.495998 48.261002 229.619995)(-28.274000 56.299000 229.619995)(-59.917000 19.468000 225.619995)(-62.042999 10.940001 229.619995)(-57.848000 24.953001 229.619995)(-57.848000 24.953001 229.619995)(-50.534000 37.620998 225.619995)(-57.848000 24.953001 225.619995)(0.000000 52.500000 208.619995)(13.056000 50.850998 201.919998)(0.000000 52.500000 201.919998)(0.000000 63.000000 225.619995)(15.667001 61.021000 225.619995)(0.000000 52.500000 208.619995)(28.274000 56.299000 229.619995)(15.667001 61.021000 225.619995)(14.529000 61.301998 229.619995)(-45.823997 -43.232998 229.619995)(-54.558998 -31.500000 229.619995)(-48.542000 -40.158001 225.619995)(-54.558998 -31.500000 229.619995)(-45.823997 -43.232998 229.619995)(-62.893002 -3.663000 229.619995)(-63.000000 0.000001 229.619995)(0.000000 63.000000 229.619995)(-62.042999 10.940001 229.619995)(-6.580000 -52.085999 208.619995)(-7.314000 -62.573997 225.619995)(-23.191999 -58.576000 225.619995)(-34.618999 -52.636002 229.619995)(-23.191999 -58.576000 225.619995)(-21.547001 -59.201000 229.619995)(-34.618999 -52.636002 229.619995)(-45.823997 -43.232998 229.619995)(-37.029999 -50.967999 225.619995)(15.667001 61.021000 225.619995)(0.000000 63.000000 229.619995)(14.529000 61.301998 229.619995)(-7.314000 -62.573997 229.619995)(-7.314000 -62.573997 225.619995)(7.314000 -62.573997 229.619995)(7.314000 -62.573997 229.619995)(21.547998 -59.201000 229.619995)(-21.547001 -59.201000 229.619995)(-21.547001 -59.201000 229.619995)(21.547998 -59.201000 229.619995)(-62.893002 -3.663000 229.619995)(0.000000 52.500000 208.619995)(0.000000 52.500000 201.919998)(-13.056000 50.850998 208.619995)(-50.534000 37.620998 229.619995)(-57.848000 24.953001 229.619995)(-28.274000 56.299000 229.619995)(-40.495998 48.261002 229.619995)(-50.534000 37.620998 229.619995)(-28.274000 56.299000 229.619995)(-13.056000 50.850998 208.619995)(-14.529000 61.301998 225.619995)(0.000000 52.500000 208.619995)(-28.274000 56.299000 229.619995)(-14.529000 61.301998 225.619995)(-28.275000 56.299000 225.619995)(-57.848000 24.953001 229.619995)(-62.042999 10.940001 229.619995)(-28.274000 56.299000 229.619995)(0.000000 63.000000 225.619995)(0.000000 52.500000 208.619995)(-14.529000 61.301998 225.619995)(15.667001 61.021000 225.619995)(0.000000 63.000000 225.619995)(0.000000 63.000000 229.619995)(-45.823997 -43.232998 229.619995)(-34.618999 -52.636002 229.619995)(-62.893002 -3.663000 229.619995)(-62.042999 10.940001 229.619995)(0.000000 63.000000 229.619995)(-14.529000 61.301998 229.619995)(-21.547001 -59.201000 229.619995)(-23.191999 -58.576000 225.619995)(-7.314000 -62.573997 225.619995)(-34.618999 -52.636002 229.619995)(-21.547001 -59.201000 229.619995)(-62.893002 -3.663000 229.619995)(-7.314000 -62.573997 229.619995)(7.314000 -62.573997 229.619995)(-21.547001 -59.201000 229.619995)(-7.314000 -62.573997 229.619995)(-21.547001 -59.201000 229.619995)(-7.314000 -62.573997 225.619995)(-14.529000 61.301998 229.619995)(-14.529000 61.301998 225.619995)(-28.274000 56.299000 229.619995)(-62.042999 10.940001 229.619995)(-14.529000 61.301998 229.619995)(-28.274000 56.299000 229.619995)(-14.529000 61.301998 229.619995)(0.000000 63.000000 225.619995)(-14.529000 61.301998 225.619995)(0.000000 63.000000 229.619995)(0.000000 63.000000 225.619995)(-14.529000 61.301998 229.619995)(0.000000 52.500000 153.419998)(-13.057000 50.850998 153.419998)(17.000000 60.500000 153.419998)(13.056000 50.850998 153.419998)(0.000000 52.500000 153.419998)(17.000000 60.500000 153.419998)(17.000000 49.672001 153.419998)(13.056000 50.850998 153.419998)(17.000000 60.500000 153.419998)(17.000000 -60.500000 153.419998)(6.580000 -52.085999 153.419998)(17.000000 -49.671001 153.419998)(-6.580000 -52.085999 153.419998)(6.580000 -52.085999 153.419998)(17.000000 -60.500000 153.419998)(-13.057000 50.850998 153.419998)(-17.000000 49.672001 153.419998)(17.000000 60.500000 153.419998)(17.000000 60.500000 153.419998)(17.000000 60.500000 201.919998)(17.000000 49.672001 153.419998)(-17.000000 -49.671001 153.419998)(-6.580000 -52.085999 153.419998)(17.000000 -60.500000 153.419998)(17.000000 -49.671001 153.419998)(17.000000 -49.671001 201.919998)(17.000000 -60.500000 153.419998)(-17.000000 49.672001 153.419998)(-17.000000 60.500000 153.419998)(17.000000 60.500000 153.419998)(17.000000 60.500000 201.919998)(17.000000 49.672001 201.919998)(17.000000 49.672001 153.419998)(-17.000000 60.500000 201.919998)(17.000000 60.500000 201.919998)(17.000000 60.500000 153.419998)(-17.000000 -60.500000 153.419998)(-17.000000 -49.671001 153.419998)(17.000000 -60.500000 153.419998)(17.000000 -49.671001 201.919998)(17.000000 -60.500000 201.919998)(17.000000 -60.500000 153.419998)(17.000000 -60.500000 201.919998)(17.000000 -49.671001 201.919998)(6.580000 -52.085999 201.919998)(-17.000000 60.500000 153.419998)(-17.000000 49.672001 153.419998)(-17.000000 49.671001 201.919998)(-17.000000 60.500000 153.419998)(-17.000000 60.500000 201.919998)(17.000000 60.500000 153.419998)(13.056000 50.850998 201.919998)(17.000000 49.672001 201.919998)(17.000000 60.500000 201.919998)(-13.056000 50.850998 201.919998)(17.000000 60.500000 201.919998)(-17.000000 60.500000 201.919998)(-17.000000 -60.500000 153.419998)(17.000000 -60.500000 153.419998)(17.000000 -60.500000 201.919998)(-17.000000 -49.671001 153.419998)(-17.000000 -60.500000 153.419998)(-17.000000 -60.500000 201.919998)(-17.000000 -49.671001 201.919998)(-17.000000 -49.671001 153.419998)(-17.000000 -60.500000 201.919998)(17.000000 -60.500000 201.919998)(6.580000 -52.085999 201.919998)(-6.580000 -52.085999 201.919998)(-17.000000 49.671001 201.919998)(-13.056000 50.850998 201.919998)(-17.000000 60.500000 201.919998)(-17.000000 60.500000 201.919998)(-17.000000 60.500000 153.419998)(-17.000000 49.671001 201.919998)(13.056000 50.850998 201.919998)(17.000000 60.500000 201.919998)(0.000000 52.500000 201.919998)(-13.056000 50.850998 201.919998)(0.000000 52.500000 201.919998)(17.000000 60.500000 201.919998)(-17.000000 -60.500000 201.919998)(-17.000000 -60.500000 153.419998)(17.000000 -60.500000 201.919998)(-17.000000 -60.500000 201.919998)(17.000000 -60.500000 201.919998)(-17.000000 -49.671001 201.919998)(-6.580000 -52.085999 201.919998)(-17.000000 -49.671001 201.919998)(17.000000 -60.500000 201.919998)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 1854 -> 23 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector 58.084998 -15.039000 0.003998) (float-vector 54.559998 -31.500001 229.619995) (float-vector 62.893003 -3.663000 229.619995)))
    (instance face :init :vertices (list (float-vector 45.825001 -43.233000 229.619995) (float-vector 54.559998 -31.500001 229.619995) (float-vector 58.084998 -15.039000 0.003998) (float-vector 47.446001 -36.727000 0.003998)))
    (instance face :init :vertices (list (float-vector -43.487001 41.338000 0.003998) (float-vector -40.495999 48.261002 229.619995) (float-vector -57.847999 24.953000 229.619995) (float-vector -50.919000 31.738002 0.003998)))
    (instance face :init :vertices (list (float-vector -59.308000 9.086000 0.003998) (float-vector -50.919000 31.738002 0.003998) (float-vector -57.847999 24.953000 229.619995) (float-vector -63.000001 0.000001 229.619995)))
    (instance face :init :vertices (list (float-vector 59.308000 9.085000 0.003998) (float-vector 58.084998 -15.039000 0.003998) (float-vector 62.893003 -3.663000 229.619995)))
    (instance face :init :vertices (list (float-vector 56.265000 20.838000 0.003998) (float-vector 59.308000 9.085000 0.003998) (float-vector 62.893003 -3.663000 229.619995) (float-vector 57.847999 24.953000 229.619995)))
    (instance face :init :vertices (list (float-vector 17.961999 -57.248998 0.003998) (float-vector -6.070000 -59.691999 0.003998) (float-vector -7.314000 -62.573999 229.619995) (float-vector 21.547999 -59.200998 229.619995)))
    (instance face :init :vertices (list (float-vector -23.192000 -58.575999 225.620002) (float-vector -7.314000 -62.573999 229.619995) (float-vector -6.070000 -59.691999 0.003998) (float-vector -17.961999 -57.248000 0.003998)))
    (instance face :init :vertices (list (float-vector 47.446001 -36.727000 0.003998) (float-vector 29.118000 -52.460998 0.003998) (float-vector 45.825001 -43.233000 229.619995)))
    (instance face :init :vertices (list (float-vector 29.118000 -52.460998 0.003998) (float-vector 17.961999 -57.248998 0.003998) (float-vector 21.547999 -59.200998 229.619995) (float-vector 45.825001 -43.233000 229.619995)))
    (instance face :init :vertices (list (float-vector -23.661001 55.137999 0.003998) (float-vector -40.495999 48.261002 229.619995) (float-vector -43.487001 41.338000 0.003998)))
    (instance face :init :vertices (list (float-vector -23.661001 55.137999 0.003998) (float-vector -14.529000 61.301999 229.619995) (float-vector -40.495999 48.261002 229.619995)))
    (instance face :init :vertices (list (float-vector -23.661001 55.137999 0.003998) (float-vector 12.078000 58.772001 0.003998) (float-vector 15.667001 61.021000 225.620002) (float-vector 0.000000 63.000001 229.619995) (float-vector -14.529000 61.301999 229.619995)))
    (instance face :init :vertices (list (float-vector 43.488000 41.338000 0.003998) (float-vector 56.265000 20.838000 0.003998) (float-vector 57.847999 24.953000 229.619995) (float-vector 40.495999 48.261002 229.619995)))
    (instance face :init :vertices (list (float-vector -23.192000 -58.575999 225.620002) (float-vector -34.619000 -52.636001 229.619995) (float-vector -7.314000 -62.573999 229.619995)))
    (instance face :init :vertices (list (float-vector -58.084998 -15.039000 0.003998) (float-vector -59.308000 9.086000 0.003998) (float-vector -63.000001 0.000001 229.619995)))
    (instance face :init :vertices (list (float-vector -47.447000 -36.726002 0.003998) (float-vector -58.084998 -15.039000 0.003998) (float-vector -63.000001 0.000001 229.619995) (float-vector -45.823999 -43.233000 229.619995)))
    (instance face :init :vertices (list (float-vector 15.667001 61.021000 225.620002) (float-vector 28.274000 56.299001 229.619995) (float-vector 0.000000 63.000001 229.619995)))
    (instance face :init :vertices (list (float-vector 0.000000 63.000001 229.619995) (float-vector 28.274000 56.299001 229.619995) (float-vector 40.495999 48.261002 229.619995) (float-vector 57.847999 24.953000 229.619995) (float-vector 62.893003 -3.663000 229.619995) (float-vector 54.559998 -31.500001 229.619995) (float-vector 45.825001 -43.233000 229.619995) (float-vector 21.547999 -59.200998 229.619995) (float-vector -7.314000 -62.573999 229.619995) (float-vector -34.619000 -52.636001 229.619995) (float-vector -45.823999 -43.233000 229.619995) (float-vector -63.000001 0.000001 229.619995) (float-vector -57.847999 24.953000 229.619995) (float-vector -40.495999 48.261002 229.619995) (float-vector -14.529000 61.301999 229.619995)))
    (instance face :init :vertices (list (float-vector -34.619000 -52.636001 229.619995) (float-vector -29.118000 -52.460998 0.003998) (float-vector -47.447000 -36.726002 0.003998) (float-vector -45.823999 -43.233000 229.619995)))
    (instance face :init :vertices (list (float-vector -23.192000 -58.575999 225.620002) (float-vector -17.961999 -57.248000 0.003998) (float-vector -29.118000 -52.460998 0.003998) (float-vector -34.619000 -52.636001 229.619995)))
    (instance face :init :vertices (list (float-vector 43.488000 41.338000 0.003998) (float-vector 12.078000 58.772001 0.003998) (float-vector -23.661001 55.137999 0.003998) (float-vector -43.487001 41.338000 0.003998) (float-vector -50.919000 31.738002 0.003998) (float-vector -59.308000 9.086000 0.003998) (float-vector -58.084998 -15.039000 0.003998) (float-vector -47.447000 -36.726002 0.003998) (float-vector -29.118000 -52.460998 0.003998) (float-vector -17.961999 -57.248000 0.003998) (float-vector -6.070000 -59.691999 0.003998) (float-vector 17.961999 -57.248998 0.003998) (float-vector 29.118000 -52.460998 0.003998) (float-vector 47.446001 -36.727000 0.003998) (float-vector 58.084998 -15.039000 0.003998) (float-vector 59.308000 9.085000 0.003998) (float-vector 56.265000 20.838000 0.003998)))
    (instance face :init :vertices (list (float-vector 43.488000 41.338000 0.003998) (float-vector 40.495999 48.261002 229.619995) (float-vector 28.274000 56.299001 229.619995) (float-vector 15.667001 61.021000 225.620002) (float-vector 12.078000 58.772001 0.003998)))
    ))
   )
  )

(defclass HiroNX_g1_1_geom0
  :super collada-body
  :slots ())
(defmethod HiroNX_g1_1_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.000000 2.000000 2.000000 1.000000))
           ))
           (list :indices #i( 180 1 0 180 2 1 180 3 2 180 4 3 180 5 4 180 6 5 180 7 6 180 8 7 180 9 8 180 10 9 180 11 10 180 12 11 180 13 12 180 14 13 180 15 14 180 16 15 180 17 16 180 18 17 180 19 18 180 0 19 0 21 20 0 1 21 1 22 21 1 2 22 2 23 22 2 3 23 3 24 23 3 4 24 4 25 24 4 5 25 5 26 25 5 6 26 6 27 26 6 7 27 7 28 27 7 8 28 8 29 28 8 9 29 9 30 29 9 10 30 10 31 30 10 11 31 11 32 31 11 12 32 12 33 32 12 13 33 13 34 33 13 14 34 14 35 34 14 15 35 15 36 35 15 16 36 16 37 36 16 17 37 17 38 37 17 18 38 18 39 38 18 19 39 19 20 39 19 0 20 20 41 40 20 21 41 21 42 41 21 22 42 22 43 42 22 23 43 23 44 43 23 24 44 24 45 44 24 25 45 25 46 45 25 26 46 26 47 46 26 27 47 27 48 47 27 28 48 28 49 48 28 29 49 29 50 49 29 30 50 30 51 50 30 31 51 31 52 51 31 32 52 32 53 52 32 33 53 33 54 53 33 34 54 34 55 54 34 35 55 35 56 55 35 36 56 36 57 56 36 37 57 37 58 57 37 38 58 38 59 58 38 39 59 39 40 59 39 20 40 40 61 60 40 41 61 41 62 61 41 42 62 42 63 62 42 43 63 43 64 63 43 44 64 44 65 64 44 45 65 45 66 65 45 46 66 46 67 66 46 47 67 47 68 67 47 48 68 48 69 68 48 49 69 49 70 69 49 50 70 50 71 70 50 51 71 51 72 71 51 52 72 52 73 72 52 53 73 53 74 73 53 54 74 54 75 74 54 55 75 55 76 75 55 56 76 56 77 76 56 57 77 57 78 77 57 58 78 58 79 78 58 59 79 59 60 79 59 40 60 60 81 80 60 61 81 61 82 81 61 62 82 62 83 82 62 63 83 63 84 83 63 64 84 64 85 84 64 65 85 65 86 85 65 66 86 66 87 86 66 67 87 67 88 87 67 68 88 68 89 88 68 69 89 69 90 89 69 70 90 70 91 90 70 71 91 71 92 91 71 72 92 72 93 92 72 73 93 73 94 93 73 74 94 74 95 94 74 75 95 75 96 95 75 76 96 76 97 96 76 77 97 77 98 97 77 78 98 78 99 98 78 79 99 79 80 99 79 60 80 80 101 100 80 81 101 81 102 101 81 82 102 82 103 102 82 83 103 83 104 103 83 84 104 84 105 104 84 85 105 85 106 105 85 86 106 86 107 106 86 87 107 87 108 107 87 88 108 88 109 108 88 89 109 89 110 109 89 90 110 90 111 110 90 91 111 91 112 111 91 92 112 92 113 112 92 93 113 93 114 113 93 94 114 94 115 114 94 95 115 95 116 115 95 96 116 96 117 116 96 97 117 97 118 117 97 98 118 98 119 118 98 99 119 99 100 119 99 80 100 100 121 120 100 101 121 101 122 121 101 102 122 102 123 122 102 103 123 103 124 123 103 104 124 104 125 124 104 105 125 105 126 125 105 106 126 106 127 126 106 107 127 107 128 127 107 108 128 108 129 128 108 109 129 109 130 129 109 110 130 110 131 130 110 111 131 111 132 131 111 112 132 112 133 132 112 113 133 113 134 133 113 114 134 114 135 134 114 115 135 115 136 135 115 116 136 116 137 136 116 117 137 117 138 137 117 118 138 118 139 138 118 119 139 119 120 139 119 100 120 120 141 140 120 121 141 121 142 141 121 122 142 122 143 142 122 123 143 123 144 143 123 124 144 124 145 144 124 125 145 125 146 145 125 126 146 126 147 146 126 127 147 127 148 147 127 128 148 128 149 148 128 129 149 129 150 149 129 130 150 130 151 150 130 131 151 131 152 151 131 132 152 132 153 152 132 133 153 133 154 153 133 134 154 134 155 154 134 135 155 135 156 155 135 136 156 136 157 156 136 137 157 137 158 157 137 138 158 138 159 158 138 139 159 139 140 159 139 120 140 140 161 160 140 141 161 141 162 161 141 142 162 142 163 162 142 143 163 143 164 163 143 144 164 144 165 164 144 145 165 145 166 165 145 146 166 146 167 166 146 147 167 147 168 167 147 148 168 148 169 168 148 149 169 149 170 169 149 150 170 150 171 170 150 151 171 151 172 171 151 152 172 152 173 172 152 153 173 153 174 173 153 154 174 154 175 174 154 155 175 155 176 175 155 156 176 156 177 176 156 157 177 157 178 177 157 158 178 158 179 178 158 159 179 159 160 179 159 140 160 181 160 161 181 161 162 181 162 163 181 163 164 181 164 165 181 165 166 181 166 167 181 167 168 181 168 169 181 169 170 181 170 171 181 171 172 181 172 173 181 173 174 181 174 175 181 175 176 181 176 177 181 177 178 181 178 179 181 179 160))
           (list :vertices #2f((-2.582370 6.132920 344.100006)(-2.695810 6.132920 344.816010)(-3.025000 6.132920 345.462006)(-3.537730 6.132920 345.975006)(-4.183810 6.132920 346.303986)(-4.900000 6.132920 346.417999)(-5.616190 6.132920 346.303986)(-6.262270 6.132920 345.975006)(-6.775000 6.132920 345.462006)(-7.104190 6.132920 344.816010)(-7.217630 6.132920 344.100006)(-7.104190 6.132920 343.384003)(-6.775000 6.132920 342.738007)(-6.262270 6.132920 342.224976)(-5.616190 6.132920 341.895996)(-4.900000 6.132920 341.782013)(-4.183810 6.132920 341.895996)(-3.537730 6.132920 342.224976)(-3.025000 6.132920 342.738007)(-2.695810 6.132920 343.384003)(-0.491611 5.067630 344.100006)(-0.707372 5.067630 345.462006)(-1.333540 5.067630 346.691010)(-2.308810 5.067630 347.665985)(-3.537730 5.067630 348.292999)(-4.900000 5.067630 348.507996)(-6.262270 5.067630 348.292999)(-7.491190 5.067630 347.665985)(-8.466460 5.067630 346.691010)(-9.092629 5.067630 345.462006)(-9.308391 5.067630 344.100006)(-9.092629 5.067630 342.738007)(-8.466460 5.067630 341.509003)(-7.491190 5.067630 340.533997)(-6.262270 5.067630 339.906982)(-4.900000 5.067630 339.691986)(-3.537730 5.067630 339.906982)(-2.308810 5.067630 340.533997)(-1.333540 5.067630 341.509003)(-0.707372 5.067630 342.738007)(1.167630 3.408390 344.100006)(0.870657 3.408390 345.975006)(0.008814 3.408390 347.665985)(-1.333540 3.408390 349.009003)(-3.025000 3.408390 349.871002)(-4.900000 3.408390 350.167999)(-6.775000 3.408390 349.871002)(-8.466460 3.408390 349.009003)(-9.808810 3.408390 347.665985)(-10.670700 3.408390 345.975006)(-10.967600 3.408390 344.100006)(-10.670700 3.408390 342.224976)(-9.808810 3.408390 340.533997)(-8.466460 3.408390 339.190979)(-6.775000 3.408390 338.328979)(-4.900000 3.408390 338.032013)(-3.025000 3.408390 338.328979)(-1.333540 3.408390 339.190979)(0.008814 3.408390 340.533997)(0.870657 3.408390 342.224976)(2.232920 1.317630 344.100006)(1.883810 1.317630 346.303986)(0.870657 1.317630 348.292999)(-0.707372 1.317630 349.871002)(-2.695810 1.317630 350.884003)(-4.900000 1.317630 351.233002)(-7.104190 1.317630 350.884003)(-9.092629 1.317630 349.871002)(-10.670700 1.317630 348.292999)(-11.683801 1.317630 346.303986)(-12.032900 1.317630 344.100006)(-11.683801 1.317630 341.895996)(-10.670700 1.317630 339.906982)(-9.092629 1.317630 338.328979)(-7.104190 1.317630 337.316010)(-4.900000 1.317630 336.966980)(-2.695810 1.317630 337.316010)(-0.707372 1.317630 338.328979)(0.870657 1.317630 339.906982)(1.883810 1.317630 341.895996)(2.600000 -1.000000 344.100006)(2.232920 -1.000000 346.417999)(1.167630 -1.000000 348.507996)(-0.491611 -1.000000 350.167999)(-2.582370 -1.000000 351.233002)(-4.900000 -1.000000 351.600006)(-7.217630 -1.000000 351.233002)(-9.308391 -1.000000 350.167999)(-10.967600 -1.000000 348.507996)(-12.032900 -1.000000 346.417999)(-12.400001 -1.000000 344.100006)(-12.032900 -1.000000 341.782013)(-10.967600 -1.000000 339.691986)(-9.308391 -1.000000 338.032013)(-7.217630 -1.000000 336.966980)(-4.900000 -1.000000 336.600006)(-2.582370 -1.000000 336.966980)(-0.491611 -1.000000 338.032013)(1.167630 -1.000000 339.691986)(2.232920 -1.000000 341.782013)(2.232920 -3.317630 344.100006)(1.883810 -3.317630 346.303986)(0.870657 -3.317630 348.292999)(-0.707372 -3.317630 349.871002)(-2.695810 -3.317630 350.884003)(-4.900000 -3.317630 351.233002)(-7.104190 -3.317630 350.884003)(-9.092629 -3.317630 349.871002)(-10.670700 -3.317630 348.292999)(-11.683801 -3.317630 346.303986)(-12.032900 -3.317630 344.100006)(-11.683801 -3.317630 341.895996)(-10.670700 -3.317630 339.906982)(-9.092629 -3.317630 338.328979)(-7.104190 -3.317630 337.316010)(-4.900000 -3.317630 336.966980)(-2.695810 -3.317630 337.316010)(-0.707372 -3.317630 338.328979)(0.870657 -3.317630 339.906982)(1.883810 -3.317630 341.895996)(1.167630 -5.408390 344.100006)(0.870657 -5.408390 345.975006)(0.008814 -5.408390 347.665985)(-1.333540 -5.408390 349.009003)(-3.025000 -5.408390 349.871002)(-4.900000 -5.408390 350.167999)(-6.775000 -5.408390 349.871002)(-8.466460 -5.408390 349.009003)(-9.808810 -5.408390 347.665985)(-10.670700 -5.408390 345.975006)(-10.967600 -5.408390 344.100006)(-10.670700 -5.408390 342.224976)(-9.808810 -5.408390 340.533997)(-8.466460 -5.408390 339.190979)(-6.775000 -5.408390 338.328979)(-4.900000 -5.408390 338.032013)(-3.025000 -5.408390 338.328979)(-1.333540 -5.408390 339.190979)(0.008814 -5.408390 340.533997)(0.870657 -5.408390 342.224976)(-0.491611 -7.067630 344.100006)(-0.707372 -7.067630 345.462006)(-1.333540 -7.067630 346.691010)(-2.308810 -7.067630 347.665985)(-3.537730 -7.067630 348.292999)(-4.900000 -7.067630 348.507996)(-6.262270 -7.067630 348.292999)(-7.491190 -7.067630 347.665985)(-8.466460 -7.067630 346.691010)(-9.092629 -7.067630 345.462006)(-9.308391 -7.067630 344.100006)(-9.092629 -7.067630 342.738007)(-8.466460 -7.067630 341.509003)(-7.491190 -7.067630 340.533997)(-6.262270 -7.067630 339.906982)(-4.900000 -7.067630 339.691986)(-3.537730 -7.067630 339.906982)(-2.308810 -7.067630 340.533997)(-1.333540 -7.067630 341.509003)(-0.707372 -7.067630 342.738007)(-2.582370 -8.132919 344.100006)(-2.695810 -8.132919 344.816010)(-3.025000 -8.132919 345.462006)(-3.537730 -8.132919 345.975006)(-4.183810 -8.132919 346.303986)(-4.900000 -8.132919 346.417999)(-5.616190 -8.132919 346.303986)(-6.262270 -8.132919 345.975006)(-6.775000 -8.132919 345.462006)(-7.104190 -8.132919 344.816010)(-7.217630 -8.132919 344.100006)(-7.104190 -8.132919 343.384003)(-6.775000 -8.132919 342.738007)(-6.262270 -8.132919 342.224976)(-5.616190 -8.132919 341.895996)(-4.900000 -8.132919 341.782013)(-4.183810 -8.132919 341.895996)(-3.537730 -8.132919 342.224976)(-3.025000 -8.132919 342.738007)(-2.695810 -8.132919 343.384003)(-4.900000 6.500000 344.100006)(-4.900000 -8.500000 344.100006)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 182 -> 14 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -1.333540 -5.408390 349.009007) (float-vector -1.333540 3.408390 349.009007) (float-vector 2.600000 -1.000000 344.099998)))
    (instance face :init :vertices (list (float-vector -1.333540 3.408390 349.009007) (float-vector -8.466460 3.408390 349.009007) (float-vector -4.900000 6.500000 344.099998)))
    (instance face :init :vertices (list (float-vector -8.466460 -5.408390 349.009007) (float-vector -1.333540 -5.408390 349.009007) (float-vector -4.900000 -8.500000 344.099998)))
    (instance face :init :vertices (list (float-vector -8.466460 3.408390 349.009007) (float-vector -8.466460 -5.408390 349.009007) (float-vector -12.400000 -1.000000 344.099998)))
    (instance face :init :vertices (list (float-vector -1.333540 -5.408390 349.009007) (float-vector -8.466460 -5.408390 349.009007) (float-vector -8.466460 3.408390 349.009007) (float-vector -1.333540 3.408390 349.009007)))
    (instance face :init :vertices (list (float-vector -1.333540 -5.408390 349.009007) (float-vector 2.600000 -1.000000 344.099998) (float-vector -1.333540 -5.408390 339.190990) (float-vector -4.900000 -8.500000 344.099998)))
    (instance face :init :vertices (list (float-vector -8.466460 3.408390 349.009007) (float-vector -12.400000 -1.000000 344.099998) (float-vector -8.466460 3.408390 339.190990) (float-vector -4.900000 6.500000 344.099998)))
    (instance face :init :vertices (list (float-vector -1.333540 3.408390 339.190990) (float-vector -1.333540 -5.408390 339.190990) (float-vector 2.600000 -1.000000 344.099998)))
    (instance face :init :vertices (list (float-vector -8.466460 3.408390 339.190990) (float-vector -1.333540 3.408390 339.190990) (float-vector -4.900000 6.500000 344.099998)))
    (instance face :init :vertices (list (float-vector 2.600000 -1.000000 344.099998) (float-vector -1.333540 3.408390 349.009007) (float-vector -4.900000 6.500000 344.099998) (float-vector -1.333540 3.408390 339.190990)))
    (instance face :init :vertices (list (float-vector -1.333540 -5.408390 339.190990) (float-vector -8.466460 -5.408390 339.190990) (float-vector -4.900000 -8.500000 344.099998)))
    (instance face :init :vertices (list (float-vector -8.466460 -5.408390 339.190990) (float-vector -8.466460 3.408390 339.190990) (float-vector -12.400000 -1.000000 344.099998)))
    (instance face :init :vertices (list (float-vector -8.466460 -5.408390 339.190990) (float-vector -1.333540 -5.408390 339.190990) (float-vector -1.333540 3.408390 339.190990) (float-vector -8.466460 3.408390 339.190990)))
    (instance face :init :vertices (list (float-vector -12.400000 -1.000000 344.099998) (float-vector -8.466460 -5.408390 349.009007) (float-vector -4.900000 -8.500000 344.099998) (float-vector -8.466460 -5.408390 339.190990)))
    ))
   )
  )

(defclass HiroNX_g1_1_geom1
  :super collada-body
  :slots ())
(defmethod HiroNX_g1_1_geom1
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.900000 0.900000 0.900000 1.000000))
           ))
           (list :indices #i( 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256 257 258 259 260 261 262 263 264 265 266 267 268 269 270 271 272 273 274 275 276 277 278 279 280 281 282 283 284 285 286 287 288 289 290 291 292 293 294 295 296 297 298 299 300 301 302 303 304 305 306 307 308 309 310 311 312 313 314 315 316 317 318 319 320 321 322 323 324 325 326 327 328 329 330 331 332 333 334 335 336 337 338 339 340 341 342 343 344 345 346 347 348 349 350 351 352 353 354 355 356 357 358 359 360 361 362 363 364 365 366 367 368 369 370 371 372 373 374 375 376 377 378 379 380 381 382 383 384 385 386 387 388 389 390 391 392 393 394 395 396 397 398 399 400 401 402 403 404 405 406 407 408 409 410 411 412 413 414 415 416 417 418 419 420 421 422 423 424 425 426 427 428 429 430 431 432 433 434 435 436 437 438 439 440 441 442 443 444 445 446 447 448 449 450 451 452 453 454 455 456 457 458 459 460 461 462 463 464 465 466 467 468 469 470 471 472 473 474 475 476 477 478 479 480 481 482 483 484 485 486 487 488 489 490 491 492 493 494 495 496 497 498 499 500 501 502 503 504 505 506 507 508 509 510 511 512 513 514 515 516 517 518 519 520 521 522 523 524 525 526 527 528 529 530 531 532 533 534 535 536 537 538 539 540 541 542 543 544 545 546 547 548 549 550 551 552 553 554 555 556 557 558 559 560 561 562 563 564 565 566 567 568 569 570 571 572 573 574 575 576 577 578 579 580 581 582 583 584 585 586 587 588 589 590 591 592 593 594 595 596 597 598 599 600 601 602 603 604 605 606 607 608 609 610 611 612 613 614 615 616 617 618 619 620 621 622 623 624 625 626 627 628 629 630 631 632 633 634 635 636 637 638 639 640 641 642 643 644 645 646 647 648 649 650 651 652 653 654 655 656 657 658 659 660 661 662 663 664 665 666 667 668 669 670 671 672 673 674 675 676 677 678 679 680 681 682 683 684 685 686 687 688 689 690 691 692 693 694 695 696 697 698 699 700 701 702 703 704 705 706 707 708 709 710 711 712 713 714 715 716 717 718 719 720 721 722 723 724 725 726 727 728 729 730 731 732 733 734 735 736 737 738 739 740 741 742 743 744 745 746 747 748 749 750 751 752 753 754 755 756 757 758 759 760 761 762 763 764 765 766 767 768 769 770 771 772 773 774 775 776 777 778 779 780 781 782 783 784 785 786 787 788 789 790 791 792 793 794 795 796 797 798 799 800 801 802 803 804 805 806 807 808 809 810 811 812 813 814 815 816 817 818 819 820 821 822 823 824 825 826 827 828 829 830 831 832 833 834 835 836 837 838 839 840 841 842 843 844 845 846 847 848 849 850 851 852 853 854 855 856 857 858 859 860 861 862 863 864 865 866 867 868 869 870 871 872 873 874 875 876 877 878 879 880 881 882 883 884 885 886 887 888 889 890 891 892 893 894 895 896 897 898 899 900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915 916 917 918 919 920 921 922 923 924 925 926 927 928 929 930 931 932 933 934 935 936 937 938 939 940 941 942 943 944 945 946 947 948 949 950 951 952 953 954 955 956 957 958 959 960 961 962 963 964 965 966 967 968 969 970 971 972 973 974 975 976 977 978 979 980 981 982 983 984 985 986 987 988 989 990 991 992 993 994 995 996 997 998 999 1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248 1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 1295 1296 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 1312 1313 1314 1315 1316 1317 1318 1319 1320 1321 1322 1323 1324 1325 1326 1327 1328 1329 1330 1331 1332 1333 1334 1335 1336 1337 1338 1339 1340 1341 1342 1343 1344 1345 1346 1347 1348 1349 1350 1351 1352 1353 1354 1355 1356 1357 1358 1359 1360 1361 1362 1363 1364 1365 1366 1367 1368 1369 1370 1371 1372 1373 1374 1375 1376 1377 1378 1379 1380 1381 1382 1383 1384 1385 1386 1387 1388 1389 1390 1391 1392 1393 1394 1395 1396 1397 1398 1399 1400 1401 1402 1403 1404 1405 1406 1407 1408 1409 1410 1411 1412 1413 1414 1415 1416 1417 1418 1419 1420 1421 1422 1423 1424 1425 1426 1427 1428 1429 1430 1431 1432 1433 1434 1435 1436 1437 1438 1439 1440 1441 1442 1443 1444 1445 1446 1447 1448 1449 1450 1451 1452 1453 1454 1455 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1473 1474 1475 1476 1477 1478 1479 1480 1481 1482 1483 1484 1485 1486 1487 1488 1489 1490 1491 1492 1493 1494 1495 1496 1497 1498 1499 1500 1501 1502 1503 1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1520 1521 1522 1523 1524 1525 1526 1527 1528 1529 1530 1531 1532 1533 1534 1535 1536 1537 1538 1539 1540 1541 1542 1543 1544 1545 1546 1547 1548 1549 1550 1551 1552 1553 1554 1555 1556 1557 1558 1559 1560 1561 1562 1563 1564 1565 1566 1567 1568 1569 1570 1571 1572 1573 1574 1575 1576 1577 1578 1579 1580 1581 1582 1583 1584 1585 1586 1587 1588 1589 1590 1591 1592 1593 1594 1595 1596 1597 1598 1599 1600 1601 1602 1603 1604 1605 1606 1607 1608 1609 1610 1611 1612 1613 1614 1615 1616 1617 1618 1619 1620 1621 1622 1623 1624 1625 1626 1627 1628 1629 1630 1631 1632 1633 1634 1635 1636 1637 1638 1639 1640 1641 1642 1643 1644 1645 1646 1647 1648 1649 1650 1651 1652 1653 1654 1655 1656 1657 1658 1659 1660 1661 1662 1663 1664 1665 1666 1667 1668 1669 1670 1671 1672 1673 1674 1675 1676 1677 1678 1679 1680 1681 1682 1683 1684 1685 1686 1687 1688 1689 1690 1691 1692 1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721 1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733 1734 1735 1736 1737 1738 1739 1740 1741 1742 1743 1744 1745 1746 1747 1748 1749 1750 1751 1752 1753 1754 1755 1756 1757 1758 1759 1760 1761 1762 1763 1764 1765 1766 1767 1768 1769 1770 1771 1772 1773 1774 1775 1776 1777 1778 1779 1780 1781 1782 1783 1784 1785 1786 1787 1788 1789 1790 1791 1792 1793 1794 1795 1796 1797 1798 1799 1800 1801 1802 1803 1804 1805 1806 1807 1808 1809 1810 1811 1812 1813 1814 1815 1816 1817 1818 1819 1820 1821 1822 1823 1824 1825 1826 1827 1828 1829 1830 1831 1832 1833 1834 1835 1836 1837 1838 1839 1840 1841 1842 1843 1844 1845 1846 1847 1848 1849 1850 1851 1852 1853 1854 1855 1856 1857 1858 1859 1860 1861 1862 1863 1864 1865 1866 1867 1868 1869 1870 1871 1872 1873 1874 1875 1876 1877 1878 1879 1880 1881 1882 1883 1884 1885 1886 1887 1888 1889 1890 1891 1892 1893 1894 1895 1896 1897 1898 1899 1900 1901 1902 1903 1904 1905 1906 1907 1908 1909 1910 1911 1912 1913 1914 1915 1916 1917 1918 1919 1920 1921 1922 1923 1924 1925 1926 1927 1928 1929 1930 1931 1932 1933 1934 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1961 1962 1963 1964 1965 1966 1967 1968 1969 1970 1971 1972 1973 1974 1975 1976 1977 1978 1979 1980 1981 1982 1983 1984 1985 1986 1987 1988 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 2023 2024 2025 2026 2027 2028 2029 2030 2031 2032 2033 2034 2035 2036 2037 2038 2039 2040 2041 2042 2043 2044 2045 2046 2047 2048 2049 2050 2051 2052 2053 2054 2055 2056 2057 2058 2059 2060 2061 2062 2063 2064 2065 2066 2067 2068 2069 2070 2071 2072 2073 2074 2075 2076 2077 2078 2079 2080 2081 2082 2083 2084 2085 2086 2087 2088 2089 2090 2091 2092 2093 2094 2095 2096 2097 2098 2099 2100 2101 2102 2103 2104 2105 2106 2107 2108 2109 2110 2111 2112 2113 2114 2115 2116 2117 2118 2119 2120 2121 2122 2123 2124 2125 2126 2127 2128 2129 2130 2131 2132 2133 2134 2135 2136 2137 2138 2139 2140 2141 2142 2143 2144 2145 2146 2147 2148 2149 2150 2151 2152 2153 2154 2155 2156 2157 2158 2159 2160 2161 2162 2163 2164 2165 2166 2167 2168 2169 2170 2171 2172 2173 2174 2175 2176 2177 2178 2179 2180 2181 2182 2183 2184 2185 2186 2187 2188 2189 2190 2191 2192 2193 2194 2195 2196 2197 2198 2199 2200 2201 2202 2203 2204 2205 2206 2207 2208 2209 2210 2211 2212 2213 2214 2215 2216 2217 2218 2219 2220 2221 2222 2223 2224 2225 2226 2227 2228 2229 2230 2231 2232 2233 2234 2235 2236 2237 2238 2239 2240 2241 2242 2243 2244 2245 2246 2247 2248 2249 2250 2251 2252 2253 2254 2255 2256 2257 2258 2259 2260 2261 2262 2263 2264 2265 2266 2267 2268 2269 2270 2271 2272 2273 2274 2275 2276 2277 2278 2279 2280 2281 2282 2283 2284 2285 2286 2287 2288 2289 2290 2291 2292 2293 2294 2295 2296 2297 2298 2299 2300 2301 2302 2303 2304 2305 2306 2307 2308 2309 2310 2311 2312 2313 2314 2315 2316 2317 2318 2319 2320 2321 2322 2323 2324 2325 2326 2327 2328 2329 2330 2331 2332 2333 2334 2335 2336 2337 2338 2339 2340 2341 2342 2343 2344 2345 2346 2347 2348 2349 2350 2351 2352 2353 2354 2355 2356 2357 2358 2359 2360 2361 2362 2363 2364 2365 2366 2367 2368 2369 2370 2371 2372 2373 2374 2375 2376 2377 2378 2379 2380 2381 2382 2383 2384 2385 2386 2387 2388 2389 2390 2391 2392 2393 2394 2395 2396 2397 2398 2399 2400 2401 2402 2403 2404 2405 2406 2407 2408 2409 2410 2411 2412 2413 2414 2415 2416 2417 2418 2419 2420 2421 2422 2423 2424 2425 2426 2427 2428 2429 2430 2431 2432 2433 2434 2435 2436 2437 2438 2439 2440 2441 2442 2443 2444 2445 2446 2447 2448 2449 2450 2451 2452 2453 2454 2455 2456 2457 2458 2459 2460 2461 2462 2463 2464 2465 2466 2467 2468 2469 2470 2471 2472 2473 2474 2475 2476 2477 2478 2479 2480 2481 2482 2483 2484 2485 2486 2487 2488 2489 2490 2491 2492 2493 2494 2495 2496 2497 2498 2499 2500 2501 2502 2503 2504 2505 2506 2507 2508 2509 2510 2511 2512 2513 2514 2515 2516 2517 2518 2519 2520 2521 2522 2523 2524 2525 2526 2527 2528 2529 2530 2531 2532 2533 2534 2535 2536 2537 2538 2539 2540 2541 2542 2543 2544 2545 2546 2547 2548 2549 2550 2551 2552 2553 2554 2555 2556 2557 2558 2559 2560 2561 2562 2563 2564 2565 2566 2567 2568 2569 2570 2571 2572 2573 2574 2575 2576 2577 2578 2579 2580 2581 2582 2583 2584 2585 2586 2587 2588 2589 2590 2591 2592 2593 2594 2595 2596 2597 2598 2599 2600 2601 2602 2603 2604 2605 2606 2607 2608 2609 2610 2611 2612 2613 2614 2615 2616 2617 2618 2619 2620 2621 2622 2623 2624 2625 2626 2627 2628 2629 2630 2631 2632 2633 2634 2635 2636 2637 2638 2639 2640 2641 2642 2643 2644 2645 2646 2647 2648 2649 2650 2651 2652 2653 2654 2655 2656 2657 2658 2659 2660 2661 2662 2663 2664 2665 2666 2667 2668 2669 2670 2671 2672 2673 2674 2675 2676 2677 2678 2679 2680 2681 2682 2683 2684 2685 2686 2687 2688 2689 2690 2691 2692 2693 2694 2695 2696 2697 2698 2699 2700 2701 2702 2703 2704 2705 2706 2707 2708 2709 2710 2711 2712 2713 2714 2715 2716 2717 2718 2719 2720 2721 2722 2723 2724 2725 2726 2727 2728 2729 2730 2731 2732 2733 2734 2735 2736 2737 2738 2739 2740 2741 2742 2743 2744 2745 2746 2747 2748 2749 2750 2751 2752 2753 2754 2755 2756 2757 2758 2759 2760 2761 2762 2763 2764 2765 2766 2767 2768 2769 2770 2771 2772 2773 2774 2775 2776 2777 2778 2779 2780 2781 2782 2783 2784 2785 2786 2787 2788 2789 2790 2791 2792 2793 2794 2795 2796 2797 2798 2799 2800 2801 2802 2803 2804 2805 2806 2807 2808 2809 2810 2811 2812 2813 2814 2815 2816 2817 2818 2819 2820 2821 2822 2823 2824 2825 2826 2827 2828 2829 2830 2831 2832 2833 2834 2835 2836 2837 2838 2839 2840 2841 2842 2843 2844 2845 2846 2847 2848 2849 2850 2851 2852 2853 2854 2855 2856 2857 2858 2859 2860 2861 2862 2863 2864 2865 2866 2867 2868 2869 2870 2871 2872 2873 2874 2875 2876 2877 2878 2879 2880 2881 2882 2883 2884 2885 2886 2887 2888 2889 2890 2891 2892 2893 2894 2895 2896 2897 2898 2899 2900 2901 2902 2903 2904 2905 2906 2907 2908 2909 2910 2911 2912 2913 2914 2915 2916 2917 2918 2919 2920 2921 2922 2923 2924 2925 2926 2927 2928 2929 2930 2931 2932 2933 2934 2935 2936 2937 2938 2939 2940 2941 2942 2943 2944 2945 2946 2947 2948 2949 2950 2951 2952 2953 2954 2955 2956 2957 2958 2959 2960 2961 2962 2963 2964 2965 2966 2967 2968 2969 2970 2971 2972 2973 2974 2975 2976 2977 2978 2979 2980 2981 2982 2983 2984 2985 2986 2987 2988 2989 2990 2991 2992 2993 2994 2995 2996 2997 2998 2999 3000 3001 3002 3003 3004 3005 3006 3007 3008 3009 3010 3011 3012 3013 3014 3015 3016 3017 3018 3019 3020 3021 3022 3023 3024 3025 3026 3027 3028 3029 3030 3031 3032 3033 3034 3035 3036 3037 3038 3039 3040 3041 3042 3043 3044 3045 3046 3047 3048 3049 3050 3051 3052 3053 3054 3055 3056 3057 3058 3059 3060 3061 3062 3063 3064 3065 3066 3067 3068 3069 3070 3071 3072 3073 3074 3075 3076 3077 3078 3079 3080 3081 3082 3083 3084 3085 3086 3087 3088 3089 3090 3091 3092 3093 3094 3095 3096 3097 3098 3099 3100 3101 3102 3103 3104 3105 3106 3107 3108 3109 3110 3111 3112 3113 3114 3115 3116 3117 3118 3119 3120 3121 3122 3123 3124 3125 3126 3127 3128 3129 3130 3131 3132 3133 3134 3135 3136 3137 3138 3139 3140 3141 3142 3143 3144 3145 3146 3147 3148 3149 3150 3151 3152 3153 3154 3155 3156 3157 3158 3159 3160 3161 3162 3163 3164 3165 3166 3167 3168 3169 3170 3171 3172 3173 3174 3175 3176 3177 3178 3179 3180 3181 3182 3183 3184 3185 3186 3187 3188 3189 3190 3191 3192 3193 3194 3195 3196 3197 3198 3199 3200 3201 3202 3203 3204 3205 3206 3207 3208 3209 3210 3211 3212 3213 3214 3215 3216 3217 3218 3219 3220 3221 3222 3223 3224 3225 3226 3227 3228 3229 3230 3231 3232 3233 3234 3235 3236 3237 3238 3239 3240 3241 3242 3243 3244 3245 3246 3247 3248 3249 3250 3251 3252 3253 3254 3255 3256 3257 3258 3259 3260 3261 3262 3263 3264 3265 3266 3267 3268 3269 3270 3271 3272 3273 3274 3275 3276 3277 3278 3279 3280 3281 3282 3283 3284 3285 3286 3287 3288 3289 3290 3291 3292 3293 3294 3295 3296 3297 3298 3299 3300 3301 3302 3303 3304 3305 3306 3307 3308 3309 3310 3311 3312 3313 3314 3315 3316 3317 3318 3319 3320 3321 3322 3323 3324 3325 3326 3327 3328 3329 3330 3331 3332 3333 3334 3335 3336 3337 3338 3339 3340 3341 3342 3343 3344 3345 3346 3347 3348 3349 3350 3351 3352 3353 3354 3355 3356 3357 3358 3359 3360 3361 3362 3363 3364 3365 3366 3367 3368 3369 3370 3371 3372 3373 3374 3375 3376 3377 3378 3379 3380 3381 3382 3383 3384 3385 3386 3387 3388 3389 3390 3391 3392 3393 3394 3395 3396 3397 3398 3399 3400 3401 3402 3403 3404 3405 3406 3407 3408 3409 3410 3411 3412 3413 3414 3415 3416 3417 3418 3419 3420 3421 3422 3423 3424 3425 3426 3427 3428 3429 3430 3431 3432 3433 3434 3435 3436 3437 3438 3439 3440 3441 3442 3443 3444 3445 3446 3447 3448 3449 3450 3451 3452 3453 3454 3455 3456 3457 3458 3459 3460 3461 3462 3463 3464 3465 3466 3467 3468 3469 3470 3471 3472 3473 3474 3475 3476 3477 3478 3479 3480 3481 3482 3483 3484 3485 3486 3487 3488 3489 3490 3491 3492 3493 3494 3495 3496 3497 3498 3499 3500 3501 3502 3503 3504 3505 3506 3507 3508 3509 3510 3511 3512 3513 3514 3515 3516 3517 3518 3519 3520 3521 3522 3523 3524 3525 3526 3527 3528 3529 3530 3531 3532 3533 3534 3535 3536 3537 3538 3539 3540 3541 3542 3543 3544 3545 3546 3547 3548 3549 3550 3551 3552 3553 3554 3555 3556 3557 3558 3559 3560 3561 3562 3563 3564 3565 3566 3567 3568 3569 3570 3571 3572 3573 3574 3575 3576 3577 3578 3579 3580 3581 3582 3583 3584 3585 3586 3587 3588 3589 3590 3591 3592 3593 3594 3595 3596 3597 3598 3599 3600 3601 3602 3603 3604 3605 3606 3607 3608 3609 3610 3611 3612 3613 3614 3615 3616 3617 3618 3619 3620 3621 3622 3623 3624 3625 3626 3627 3628 3629 3630 3631 3632 3633 3634 3635 3636 3637 3638 3639 3640 3641 3642 3643 3644 3645 3646 3647 3648 3649 3650 3651 3652 3653 3654 3655 3656 3657 3658 3659 3660 3661 3662 3663 3664 3665 3666 3667 3668 3669 3670 3671 3672 3673 3674 3675 3676 3677 3678 3679 3680 3681 3682 3683 3684 3685 3686 3687 3688 3689 3690 3691 3692 3693 3694 3695 3696 3697 3698 3699 3700 3701 3702 3703 3704 3705 3706 3707 3708 3709 3710 3711 3712 3713 3714 3715 3716 3717 3718 3719 3720 3721 3722 3723 3724 3725 3726 3727 3728 3729 3730 3731 3732 3733 3734 3735 3736 3737 3738 3739 3740 3741 3742 3743 3744 3745 3746 3747 3748 3749 3750 3751 3752 3753 3754 3755 3756 3757 3758 3759 3760 3761 3762 3763 3764 3765 3766 3767 3768 3769 3770 3771 3772 3773 3774 3775 3776 3777 3778 3779 3780 3781 3782 3783 3784 3785 3786 3787 3788 3789 3790 3791 3792 3793 3794 3795 3796 3797 3798 3799 3800 3801 3802 3803 3804 3805 3806 3807 3808 3809 3810 3811 3812 3813 3814 3815 3816 3817 3818 3819 3820 3821 3822 3823 3824 3825 3826 3827 3828 3829 3830 3831 3832 3833 3834 3835 3836 3837 3838 3839 3840 3841 3842 3843 3844 3845 3846 3847 3848 3849 3850 3851 3852 3853 3854 3855 3856 3857 3858 3859 3860 3861 3862 3863 3864 3865 3866 3867 3868 3869 3870 3871 3872 3873 3874 3875 3876 3877 3878 3879 3880 3881 3882 3883 3884 3885 3886 3887 3888 3889 3890 3891 3892 3893 3894 3895 3896 3897 3898 3899 3900 3901 3902 3903 3904 3905 3906 3907 3908 3909 3910 3911 3912 3913 3914 3915 3916 3917 3918 3919 3920 3921 3922 3923 3924 3925 3926 3927 3928 3929 3930 3931 3932 3933 3934 3935 3936 3937 3938 3939 3940 3941 3942 3943 3944 3945 3946 3947 3948 3949 3950 3951 3952 3953 3954 3955 3956 3957 3958 3959 3960 3961 3962 3963 3964 3965 3966 3967 3968 3969 3970 3971 3972 3973 3974 3975 3976 3977 3978 3979 3980 3981 3982 3983 3984 3985 3986 3987 3988 3989 3990 3991 3992 3993 3994 3995 3996 3997 3998 3999 4000 4001 4002 4003 4004 4005 4006 4007 4008 4009 4010 4011 4012 4013 4014 4015 4016 4017 4018 4019 4020 4021 4022 4023 4024 4025 4026 4027 4028 4029 4030 4031 4032 4033 4034 4035 4036 4037 4038 4039 4040 4041 4042 4043 4044 4045 4046 4047 4048 4049 4050 4051 4052 4053 4054 4055 4056 4057 4058 4059 4060 4061 4062 4063 4064 4065 4066 4067 4068 4069 4070 4071 4072 4073 4074 4075 4076 4077 4078 4079 4080 4081 4082 4083 4084 4085 4086 4087 4088 4089 4090 4091 4092 4093 4094 4095 4096 4097 4098 4099 4100 4101 4102 4103 4104 4105 4106 4107 4108 4109 4110 4111 4112 4113 4114 4115 4116 4117 4118 4119 4120 4121 4122 4123 4124 4125 4126 4127 4128 4129 4130 4131 4132 4133 4134 4135 4136 4137 4138 4139 4140 4141 4142 4143 4144 4145 4146 4147 4148 4149 4150 4151 4152 4153 4154 4155 4156 4157 4158 4159 4160 4161 4162 4163 4164 4165 4166 4167 4168 4169 4170 4171 4172 4173 4174 4175 4176 4177 4178 4179 4180 4181 4182 4183 4184 4185 4186 4187 4188 4189 4190 4191 4192 4193 4194 4195 4196 4197 4198 4199 4200 4201 4202 4203 4204 4205 4206 4207 4208 4209 4210 4211 4212 4213 4214 4215 4216 4217 4218 4219 4220 4221 4222 4223 4224 4225 4226 4227 4228 4229 4230 4231 4232 4233 4234 4235 4236 4237 4238 4239 4240 4241 4242 4243 4244 4245 4246 4247 4248 4249 4250 4251 4252 4253 4254 4255 4256 4257 4258 4259 4260 4261 4262 4263 4264 4265 4266 4267 4268 4269 4270 4271 4272 4273 4274 4275 4276 4277 4278 4279 4280 4281 4282 4283 4284 4285 4286 4287 4288 4289 4290 4291 4292 4293 4294 4295 4296 4297 4298 4299 4300 4301 4302 4303 4304 4305 4306 4307 4308 4309 4310 4311 4312 4313 4314 4315 4316 4317 4318 4319 4320 4321 4322 4323 4324 4325 4326 4327 4328 4329 4330 4331 4332 4333 4334 4335 4336 4337 4338 4339 4340 4341 4342 4343 4344 4345 4346 4347 4348 4349 4350 4351 4352 4353 4354 4355 4356 4357 4358 4359 4360 4361 4362 4363 4364 4365 4366 4367 4368 4369 4370 4371 4372 4373 4374 4375 4376 4377 4378 4379 4380 4381 4382 4383 4384 4385 4386 4387 4388 4389 4390 4391 4392 4393 4394 4395 4396 4397 4398 4399 4400 4401 4402 4403 4404 4405 4406 4407 4408 4409 4410 4411 4412 4413 4414 4415 4416 4417 4418 4419 4420 4421 4422 4423 4424 4425 4426 4427 4428 4429 4430 4431 4432 4433 4434 4435 4436 4437 4438 4439 4440 4441 4442 4443 4444 4445 4446 4447 4448 4449 4450 4451 4452 4453 4454 4455 4456 4457 4458 4459 4460 4461 4462 4463 4464 4465 4466 4467 4468 4469 4470 4471 4472 4473 4474 4475 4476 4477 4478 4479 4480 4481 4482 4483 4484 4485 4486 4487 4488 4489 4490 4491 4492 4493 4494 4495 4496 4497 4498 4499 4500 4501 4502 4503 4504 4505 4506 4507 4508 4509 4510 4511 4512 4513 4514 4515 4516 4517 4518 4519 4520 4521 4522 4523 4524 4525 4526 4527 4528 4529 4530 4531 4532 4533 4534 4535 4536 4537 4538 4539 4540 4541 4542 4543 4544 4545 4546 4547 4548 4549 4550 4551 4552 4553 4554 4555 4556 4557 4558 4559 4560 4561 4562 4563 4564 4565 4566 4567 4568 4569 4570 4571 4572 4573 4574 4575 4576 4577 4578 4579 4580 4581 4582 4583 4584 4585 4586 4587 4588 4589 4590 4591 4592 4593 4594 4595 4596 4597 4598 4599 4600 4601 4602 4603 4604 4605 4606 4607 4608 4609 4610 4611 4612 4613 4614 4615 4616 4617 4618 4619 4620 4621 4622 4623 4624 4625 4626 4627 4628 4629 4630 4631 4632 4633 4634 4635 4636 4637 4638 4639 4640 4641 4642 4643 4644 4645 4646 4647 4648 4649 4650 4651 4652 4653 4654 4655 4656 4657 4658 4659 4660 4661 4662 4663 4664 4665 4666 4667 4668 4669 4670 4671 4672 4673 4674 4675 4676 4677 4678 4679 4680 4681 4682 4683 4684 4685 4686 4687 4688 4689 4690 4691 4692 4693 4694 4695 4696 4697 4698 4699 4700 4701 4702 4703 4704 4705 4706 4707 4708 4709 4710 4711 4712 4713 4714 4715 4716 4717 4718 4719 4720 4721 4722 4723 4724 4725 4726 4727 4728 4729 4730 4731 4732 4733 4734 4735 4736 4737 4738 4739 4740 4741 4742 4743 4744 4745 4746 4747 4748 4749 4750 4751 4752 4753 4754 4755 4756 4757 4758 4759 4760 4761 4762 4763 4764 4765 4766 4767 4768 4769 4770 4771 4772 4773 4774 4775 4776 4777 4778 4779 4780 4781 4782 4783 4784 4785 4786 4787 4788 4789 4790 4791 4792 4793 4794 4795 4796 4797 4798 4799 4800 4801 4802 4803 4804 4805 4806 4807 4808 4809 4810 4811 4812 4813 4814 4815 4816 4817 4818 4819 4820 4821 4822 4823 4824 4825 4826 4827 4828 4829 4830 4831 4832 4833 4834 4835 4836 4837 4838 4839 4840 4841 4842 4843 4844 4845 4846 4847 4848 4849 4850 4851 4852 4853 4854 4855 4856 4857 4858 4859 4860 4861 4862 4863 4864 4865 4866 4867 4868 4869 4870 4871 4872 4873 4874 4875 4876 4877 4878 4879 4880 4881 4882 4883 4884 4885 4886 4887 4888 4889 4890 4891 4892 4893 4894 4895 4896 4897 4898 4899 4900 4901 4902 4903 4904 4905 4906 4907 4908 4909 4910 4911 4912 4913 4914 4915 4916 4917 4918 4919 4920 4921 4922 4923 4924 4925 4926 4927 4928 4929 4930 4931 4932 4933 4934 4935 4936 4937 4938 4939 4940 4941 4942 4943 4944 4945 4946 4947 4948 4949 4950 4951 4952 4953 4954 4955 4956 4957 4958 4959 4960 4961 4962 4963 4964 4965 4966 4967 4968 4969 4970 4971 4972 4973 4974 4975 4976 4977 4978 4979 4980 4981 4982 4983 4984 4985 4986 4987 4988 4989 4990 4991 4992 4993 4994 4995 4996 4997 4998 4999 5000 5001 5002 5003 5004 5005 5006 5007 5008 5009 5010 5011 5012 5013 5014 5015 5016 5017 5018 5019 5020 5021 5022 5023 5024 5025 5026 5027 5028 5029 5030 5031 5032 5033 5034 5035 5036 5037 5038 5039 5040 5041 5042 5043 5044 5045 5046 5047 5048 5049 5050 5051 5052 5053 5054 5055 5056 5057 5058 5059 5060 5061 5062 5063 5064 5065 5066 5067 5068 5069 5070 5071 5072 5073 5074 5075 5076 5077 5078 5079 5080 5081 5082 5083 5084 5085 5086 5087 5088 5089 5090 5091 5092 5093 5094 5095 5096 5097 5098 5099 5100 5101 5102 5103 5104 5105 5106 5107 5108 5109 5110 5111 5112 5113 5114 5115 5116 5117 5118 5119 5120 5121 5122 5123 5124 5125 5126 5127 5128 5129 5130 5131 5132 5133 5134 5135 5136 5137 5138 5139 5140 5141 5142 5143 5144 5145 5146 5147 5148 5149 5150 5151 5152 5153 5154 5155 5156 5157 5158 5159 5160 5161 5162 5163 5164 5165 5166 5167 5168 5169 5170 5171 5172 5173 5174 5175 5176 5177 5178 5179 5180 5181 5182 5183 5184 5185 5186 5187 5188 5189 5190 5191 5192 5193 5194 5195 5196 5197 5198 5199 5200 5201 5202 5203 5204 5205 5206 5207 5208 5209 5210 5211 5212 5213 5214 5215 5216 5217 5218 5219 5220 5221 5222 5223 5224 5225 5226 5227 5228 5229 5230 5231 5232 5233 5234 5235 5236 5237 5238 5239 5240 5241 5242 5243 5244 5245 5246 5247 5248 5249 5250 5251 5252 5253 5254 5255 5256 5257 5258 5259 5260 5261 5262 5263 5264 5265 5266 5267 5268 5269 5270 5271 5272 5273 5274 5275 5276 5277 5278 5279 5280 5281 5282 5283 5284 5285 5286 5287 5288 5289 5290 5291 5292 5293 5294 5295 5296 5297 5298 5299 5300 5301 5302 5303 5304 5305 5306 5307 5308 5309 5310 5311 5312 5313 5314 5315 5316 5317 5318 5319 5320 5321 5322 5323 5324 5325 5326 5327 5328 5329 5330 5331 5332 5333 5334 5335 5336 5337 5338 5339 5340 5341 5342 5343 5344 5345 5346 5347 5348 5349 5350 5351 5352 5353 5354 5355 5356 5357 5358 5359 5360 5361 5362 5363 5364 5365 5366 5367 5368 5369 5370 5371 5372 5373 5374 5375 5376 5377 5378 5379 5380 5381 5382 5383 5384 5385 5386 5387 5388 5389 5390 5391 5392 5393 5394 5395 5396 5397 5398 5399 5400 5401 5402 5403 5404 5405 5406 5407 5408 5409 5410 5411 5412 5413 5414 5415 5416 5417 5418 5419 5420 5421 5422 5423 5424 5425 5426 5427 5428 5429 5430 5431 5432 5433 5434 5435 5436 5437 5438 5439 5440 5441 5442 5443 5444 5445 5446 5447 5448 5449 5450 5451 5452 5453 5454 5455 5456 5457 5458 5459 5460 5461 5462 5463 5464 5465 5466 5467 5468 5469 5470 5471 5472 5473 5474 5475 5476 5477 5478 5479 5480 5481 5482 5483 5484 5485 5486 5487 5488 5489 5490 5491 5492 5493 5494 5495 5496 5497 5498 5499 5500 5501 5502 5503 5504 5505 5506 5507 5508 5509 5510 5511 5512 5513 5514 5515 5516 5517 5518 5519 5520 5521 5522 5523 5524 5525 5526 5527 5528 5529 5530 5531 5532 5533 5534 5535 5536 5537 5538 5539 5540 5541 5542 5543 5544 5545 5546 5547 5548 5549 5550 5551 5552 5553 5554 5555 5556 5557 5558 5559 5560 5561 5562 5563 5564 5565 5566 5567 5568 5569 5570 5571 5572 5573 5574 5575 5576 5577 5578 5579 5580 5581 5582 5583 5584 5585 5586 5587 5588 5589 5590 5591 5592 5593 5594 5595 5596 5597 5598 5599 5600 5601 5602 5603 5604 5605 5606 5607 5608 5609 5610 5611 5612 5613 5614 5615 5616 5617 5618 5619 5620 5621 5622 5623 5624 5625 5626 5627 5628 5629 5630 5631 5632 5633 5634 5635 5636 5637 5638 5639 5640 5641 5642 5643 5644 5645 5646 5647 5648 5649 5650 5651 5652 5653 5654 5655 5656 5657 5658 5659 5660 5661 5662 5663 5664 5665 5666 5667 5668 5669 5670 5671 5672 5673 5674 5675 5676 5677 5678 5679 5680 5681 5682 5683 5684 5685 5686 5687 5688 5689 5690 5691 5692 5693 5694 5695 5696 5697 5698 5699 5700 5701 5702 5703 5704 5705 5706 5707 5708 5709 5710 5711 5712 5713 5714 5715 5716 5717 5718 5719 5720 5721 5722 5723 5724 5725 5726 5727 5728 5729 5730 5731 5732 5733 5734 5735 5736 5737 5738 5739 5740 5741 5742 5743 5744 5745 5746 5747 5748 5749 5750 5751 5752 5753 5754 5755 5756 5757 5758 5759 5760 5761 5762 5763 5764 5765 5766 5767 5768 5769 5770 5771 5772 5773 5774 5775 5776 5777 5778 5779 5780 5781 5782 5783 5784 5785 5786 5787 5788 5789 5790 5791 5792 5793 5794 5795 5796 5797 5798 5799 5800 5801 5802 5803 5804 5805 5806 5807 5808 5809 5810 5811 5812 5813 5814 5815 5816 5817 5818 5819 5820 5821 5822 5823 5824 5825 5826 5827 5828 5829 5830 5831 5832 5833 5834 5835 5836 5837 5838 5839 5840 5841 5842 5843 5844 5845 5846 5847 5848 5849 5850 5851 5852 5853 5854 5855 5856 5857 5858 5859 5860 5861 5862 5863 5864 5865 5866 5867 5868 5869 5870 5871 5872 5873 5874 5875 5876 5877 5878 5879 5880 5881 5882 5883 5884 5885 5886 5887 5888 5889 5890 5891 5892 5893 5894 5895 5896 5897 5898 5899 5900 5901 5902 5903 5904 5905 5906 5907 5908 5909 5910 5911 5912 5913 5914 5915 5916 5917 5918 5919 5920 5921 5922 5923 5924 5925 5926 5927 5928 5929 5930 5931 5932 5933 5934 5935 5936 5937 5938 5939 5940 5941 5942 5943 5944 5945 5946 5947 5948 5949 5950 5951 5952 5953 5954 5955 5956 5957 5958 5959 5960 5961 5962 5963 5964 5965 5966 5967 5968 5969 5970 5971 5972 5973 5974 5975 5976 5977 5978 5979 5980 5981 5982 5983 5984 5985 5986 5987 5988 5989 5990 5991 5992 5993 5994 5995 5996 5997 5998 5999 6000 6001 6002 6003 6004 6005 6006 6007 6008 6009 6010 6011 6012 6013 6014 6015 6016 6017 6018 6019 6020 6021 6022 6023 6024 6025 6026 6027 6028 6029 6030 6031 6032 6033 6034 6035 6036 6037 6038 6039 6040 6041 6042 6043 6044 6045 6046 6047 6048 6049 6050 6051 6052 6053 6054 6055 6056 6057 6058 6059 6060 6061 6062 6063 6064 6065 6066 6067 6068 6069 6070 6071 6072 6073 6074 6075 6076 6077 6078 6079 6080 6081 6082 6083 6084 6085 6086 6087 6088 6089 6090 6091 6092 6093 6094 6095 6096 6097 6098 6099 6100 6101 6102 6103 6104 6105 6106 6107 6108 6109 6110 6111 6112 6113 6114 6115 6116 6117 6118 6119 6120 6121 6122 6123 6124 6125 6126 6127 6128 6129 6130 6131 6132 6133 6134 6135 6136 6137 6138 6139 6140 6141 6142 6143 6144 6145 6146 6147 6148 6149 6150 6151 6152 6153 6154 6155 6156 6157 6158 6159 6160 6161 6162 6163 6164 6165 6166 6167 6168 6169 6170 6171 6172 6173 6174 6175 6176 6177 6178 6179 6180 6181 6182 6183 6184 6185 6186 6187 6188 6189 6190 6191 6192 6193 6194 6195 6196 6197 6198 6199 6200 6201 6202 6203 6204 6205 6206 6207 6208 6209 6210 6211 6212 6213 6214 6215 6216 6217 6218 6219 6220 6221 6222 6223 6224 6225 6226 6227 6228 6229 6230 6231 6232 6233 6234 6235 6236 6237 6238 6239 6240 6241 6242 6243 6244 6245 6246 6247 6248 6249 6250 6251 6252 6253 6254 6255 6256 6257 6258 6259 6260 6261 6262 6263 6264 6265 6266 6267 6268 6269 6270 6271 6272 6273 6274 6275 6276 6277 6278 6279 6280 6281 6282 6283 6284 6285 6286 6287 6288 6289 6290 6291 6292 6293 6294 6295 6296 6297 6298 6299 6300 6301 6302 6303 6304 6305 6306 6307 6308 6309 6310 6311 6312 6313 6314 6315 6316 6317 6318 6319 6320 6321 6322 6323 6324 6325 6326 6327 6328 6329 6330 6331 6332 6333 6334 6335 6336 6337 6338 6339 6340 6341 6342 6343 6344 6345 6346 6347 6348 6349 6350 6351 6352 6353 6354 6355 6356 6357 6358 6359 6360 6361 6362 6363 6364 6365 6366 6367 6368 6369 6370 6371 6372 6373 6374 6375 6376 6377 6378 6379 6380 6381 6382 6383 6384 6385 6386 6387 6388 6389 6390 6391 6392 6393 6394 6395 6396 6397 6398 6399 6400 6401 6402 6403 6404 6405 6406 6407 6408 6409 6410 6411 6412 6413 6414 6415 6416 6417 6418 6419 6420 6421 6422 6423 6424 6425 6426 6427 6428 6429 6430 6431 6432 6433 6434 6435 6436 6437 6438 6439 6440 6441 6442 6443 6444 6445 6446 6447 6448 6449 6450 6451 6452 6453 6454 6455 6456 6457 6458 6459 6460 6461 6462 6463 6464 6465 6466 6467 6468 6469 6470 6471 6472 6473 6474 6475 6476 6477 6478 6479 6480 6481 6482 6483 6484 6485 6486 6487 6488 6489 6490 6491 6492 6493 6494 6495 6496 6497 6498 6499 6500 6501 6502 6503 6504 6505 6506 6507 6508 6509 6510 6511 6512 6513 6514 6515 6516 6517 6518 6519 6520 6521 6522 6523 6524 6525 6526 6527 6528 6529 6530 6531 6532 6533 6534 6535 6536 6537 6538 6539 6540 6541 6542 6543 6544 6545 6546 6547 6548 6549 6550 6551 6552 6553 6554 6555 6556 6557 6558 6559 6560 6561 6562 6563 6564 6565 6566 6567 6568 6569 6570 6571 6572 6573 6574 6575 6576 6577 6578 6579 6580 6581 6582 6583 6584 6585 6586 6587 6588 6589 6590 6591 6592 6593 6594 6595 6596 6597 6598 6599 6600 6601 6602 6603 6604 6605 6606 6607 6608 6609 6610 6611 6612 6613 6614 6615 6616 6617 6618 6619 6620 6621 6622 6623 6624 6625 6626 6627 6628 6629 6630 6631 6632 6633 6634 6635 6636 6637 6638 6639 6640 6641 6642 6643 6644 6645 6646 6647 6648 6649 6650 6651 6652 6653 6654 6655 6656 6657 6658 6659 6660 6661 6662 6663 6664 6665 6666 6667 6668 6669 6670 6671 6672 6673 6674 6675 6676 6677 6678 6679 6680 6681 6682 6683 6684 6685 6686 6687 6688 6689 6690 6691 6692 6693 6694 6695 6696 6697 6698 6699 6700 6701 6702 6703 6704 6705 6706 6707 6708 6709 6710 6711 6712 6713 6714 6715 6716 6717 6718 6719 6720 6721 6722 6723 6724 6725 6726 6727 6728 6729 6730 6731 6732 6733 6734 6735 6736 6737 6738 6739 6740 6741 6742 6743 6744 6745 6746 6747 6748 6749 6750 6751 6752 6753 6754 6755 6756 6757 6758 6759 6760 6761 6762 6763 6764 6765 6766 6767 6768 6769 6770 6771 6772 6773 6774 6775 6776 6777 6778 6779 6780 6781 6782 6783 6784 6785 6786 6787 6788 6789 6790 6791 6792 6793 6794 6795 6796 6797 6798 6799 6800 6801 6802 6803 6804 6805 6806 6807 6808 6809 6810 6811 6812 6813 6814 6815 6816 6817 6818 6819 6820 6821 6822 6823 6824 6825 6826 6827 6828 6829 6830 6831 6832 6833 6834 6835 6836 6837 6838 6839 6840 6841 6842 6843 6844 6845 6846 6847 6848 6849 6850 6851 6852 6853 6854 6855 6856 6857 6858 6859 6860 6861 6862 6863 6864 6865 6866 6867 6868 6869 6870 6871 6872 6873 6874 6875 6876 6877 6878 6879 6880 6881 6882 6883 6884 6885 6886 6887 6888 6889 6890 6891 6892 6893 6894 6895 6896 6897 6898 6899 6900 6901 6902 6903 6904 6905 6906 6907 6908 6909 6910 6911 6912 6913 6914 6915 6916 6917 6918 6919 6920 6921 6922 6923 6924 6925 6926 6927 6928 6929 6930 6931 6932 6933 6934 6935 6936 6937 6938 6939 6940 6941 6942 6943 6944 6945 6946 6947 6948 6949 6950 6951 6952 6953 6954 6955 6956 6957 6958 6959 6960 6961 6962 6963 6964 6965 6966 6967 6968 6969 6970 6971 6972 6973 6974 6975 6976 6977 6978 6979 6980 6981 6982 6983 6984 6985 6986 6987 6988 6989 6990 6991 6992 6993 6994 6995 6996 6997 6998 6999 7000 7001 7002 7003 7004 7005 7006 7007 7008 7009 7010 7011 7012 7013 7014 7015 7016 7017 7018 7019 7020 7021 7022 7023 7024 7025 7026 7027 7028 7029 7030 7031 7032 7033 7034 7035 7036 7037 7038 7039 7040 7041 7042 7043 7044 7045 7046 7047 7048 7049 7050 7051 7052 7053 7054 7055 7056 7057 7058 7059 7060 7061 7062 7063 7064 7065 7066 7067 7068 7069 7070 7071 7072 7073 7074 7075 7076 7077 7078 7079 7080 7081 7082 7083 7084 7085 7086 7087 7088 7089 7090 7091 7092 7093 7094 7095 7096 7097 7098 7099 7100 7101 7102 7103 7104 7105 7106 7107 7108 7109 7110 7111 7112 7113 7114 7115 7116 7117 7118 7119 7120 7121 7122 7123 7124 7125 7126 7127 7128 7129 7130 7131 7132 7133 7134 7135 7136 7137 7138 7139 7140 7141 7142 7143 7144 7145 7146 7147 7148 7149 7150 7151 7152 7153 7154 7155 7156 7157 7158 7159 7160 7161 7162 7163 7164 7165 7166 7167 7168 7169 7170 7171 7172 7173 7174 7175 7176 7177 7178 7179 7180 7181 7182 7183 7184 7185 7186 7187 7188 7189 7190 7191 7192 7193 7194 7195 7196 7197 7198 7199 7200 7201 7202 7203 7204 7205 7206 7207 7208 7209 7210 7211 7212 7213 7214 7215 7216 7217 7218 7219 7220 7221 7222 7223 7224 7225 7226 7227 7228 7229 7230 7231 7232 7233 7234 7235 7236 7237 7238 7239 7240 7241 7242 7243 7244 7245 7246 7247 7248 7249 7250 7251 7252 7253 7254 7255 7256 7257 7258 7259 7260 7261 7262 7263 7264 7265 7266 7267 7268 7269 7270 7271 7272 7273 7274 7275 7276 7277 7278 7279 7280 7281 7282 7283 7284 7285 7286 7287 7288 7289 7290 7291 7292 7293 7294 7295 7296 7297 7298 7299 7300 7301 7302 7303 7304 7305 7306 7307 7308 7309 7310 7311 7312 7313 7314 7315 7316 7317 7318 7319 7320 7321 7322 7323 7324 7325 7326 7327 7328 7329 7330 7331 7332 7333 7334 7335 7336 7337 7338 7339 7340 7341 7342 7343 7344 7345 7346 7347 7348 7349 7350 7351 7352 7353 7354 7355 7356 7357 7358 7359 7360 7361 7362 7363 7364 7365 7366 7367 7368 7369 7370 7371 7372 7373 7374 7375 7376 7377 7378 7379 7380 7381 7382 7383 7384 7385 7386 7387 7388 7389 7390 7391 7392 7393 7394 7395 7396 7397 7398 7399 7400 7401 7402 7403 7404 7405 7406 7407 7408 7409 7410 7411 7412 7413 7414 7415 7416 7417 7418 7419 7420 7421 7422 7423 7424 7425 7426 7427 7428 7429 7430 7431 7432 7433 7434 7435 7436 7437 7438 7439 7440 7441 7442 7443 7444 7445 7446 7447 7448 7449 7450 7451 7452 7453 7454 7455 7456 7457 7458 7459 7460 7461 7462 7463 7464 7465 7466 7467 7468 7469 7470 7471 7472 7473 7474 7475 7476 7477 7478 7479 7480 7481 7482 7483 7484 7485 7486 7487 7488 7489 7490 7491 7492 7493 7494 7495 7496 7497 7498 7499 7500 7501 7502 7503 7504 7505 7506 7507 7508 7509 7510 7511 7512 7513 7514 7515 7516 7517 7518 7519 7520 7521 7522 7523 7524 7525 7526 7527 7528 7529 7530 7531 7532 7533 7534 7535 7536 7537 7538 7539 7540 7541 7542 7543 7544 7545 7546 7547 7548 7549 7550 7551 7552 7553 7554 7555 7556 7557 7558 7559 7560 7561 7562 7563 7564 7565 7566 7567 7568 7569 7570 7571 7572 7573 7574 7575 7576 7577 7578 7579 7580 7581 7582 7583 7584 7585 7586 7587 7588 7589 7590 7591 7592 7593 7594 7595 7596 7597 7598 7599 7600 7601 7602 7603 7604 7605 7606 7607 7608 7609 7610 7611 7612 7613 7614 7615 7616 7617 7618 7619 7620 7621 7622 7623 7624 7625 7626 7627 7628 7629 7630 7631 7632 7633 7634 7635 7636 7637 7638 7639 7640 7641 7642 7643 7644 7645 7646 7647 7648 7649 7650 7651 7652 7653 7654 7655 7656 7657 7658 7659 7660 7661 7662 7663 7664 7665 7666 7667 7668 7669 7670 7671 7672 7673 7674 7675 7676 7677 7678 7679 7680 7681 7682 7683 7684 7685 7686 7687 7688 7689 7690 7691 7692 7693 7694 7695 7696 7697 7698 7699 7700 7701 7702 7703 7704 7705 7706 7707 7708 7709 7710 7711 7712 7713 7714 7715 7716 7717 7718 7719 7720 7721 7722 7723 7724 7725 7726 7727 7728 7729 7730 7731 7732 7733 7734 7735 7736 7737 7738 7739 7740 7741 7742 7743 7744 7745 7746 7747 7748 7749 7750 7751 7752 7753 7754 7755 7756 7757 7758 7759 7760 7761 7762 7763 7764 7765 7766 7767 7768 7769 7770 7771 7772 7773 7774 7775 7776 7777 7778 7779 7780 7781 7782 7783 7784 7785 7786 7787 7788 7789 7790 7791 7792 7793 7794 7795 7796 7797 7798 7799 7800 7801 7802 7803 7804 7805 7806 7807 7808 7809 7810 7811 7812 7813 7814 7815 7816 7817 7818 7819 7820 7821 7822 7823 7824 7825 7826 7827 7828 7829 7830 7831 7832 7833 7834 7835 7836 7837 7838 7839 7840 7841 7842 7843 7844 7845 7846 7847 7848 7849 7850 7851 7852 7853 7854 7855 7856 7857 7858 7859 7860 7861 7862 7863 7864 7865 7866 7867 7868 7869 7870 7871 7872 7873 7874 7875 7876 7877 7878 7879 7880 7881 7882 7883 7884 7885 7886 7887 7888 7889 7890 7891 7892 7893 7894 7895 7896 7897 7898 7899 7900 7901 7902 7903 7904 7905 7906 7907 7908 7909 7910 7911 7912 7913 7914 7915 7916 7917 7918 7919 7920 7921 7922 7923 7924 7925 7926 7927 7928 7929 7930 7931 7932 7933 7934 7935 7936 7937 7938 7939 7940 7941 7942 7943 7944 7945 7946 7947 7948 7949 7950 7951 7952 7953 7954 7955 7956 7957 7958 7959 7960 7961 7962 7963 7964 7965 7966 7967 7968 7969 7970 7971 7972 7973 7974 7975 7976 7977 7978 7979 7980 7981 7982 7983 7984 7985 7986 7987 7988 7989 7990 7991 7992 7993 7994 7995 7996 7997 7998 7999 8000 8001 8002 8003 8004 8005 8006 8007 8008 8009 8010 8011 8012 8013 8014 8015 8016 8017 8018 8019 8020 8021 8022 8023 8024 8025 8026 8027 8028 8029 8030 8031 8032 8033 8034 8035 8036 8037 8038 8039 8040 8041 8042 8043 8044 8045 8046 8047 8048 8049 8050 8051 8052 8053 8054 8055 8056 8057 8058 8059 8060 8061 8062 8063 8064 8065 8066 8067 8068 8069 8070 8071 8072 8073 8074 8075 8076 8077 8078 8079 8080 8081 8082 8083 8084 8085 8086 8087 8088 8089 8090 8091 8092 8093 8094 8095 8096 8097 8098 8099 8100 8101 8102 8103 8104 8105 8106 8107 8108 8109 8110 8111 8112 8113 8114 8115 8116 8117 8118 8119 8120 8121 8122 8123 8124 8125 8126 8127 8128 8129 8130 8131 8132 8133 8134 8135 8136 8137 8138 8139 8140 8141 8142 8143 8144 8145 8146 8147 8148 8149 8150 8151 8152 8153 8154 8155 8156 8157 8158 8159 8160 8161 8162 8163 8164 8165 8166 8167 8168 8169 8170 8171 8172 8173 8174 8175 8176 8177 8178 8179 8180 8181 8182 8183 8184 8185 8186 8187 8188 8189 8190 8191 8192 8193 8194 8195 8196 8197 8198 8199 8200 8201 8202 8203 8204 8205 8206 8207 8208 8209 8210 8211 8212 8213 8214 8215 8216 8217 8218 8219 8220 8221 8222 8223 8224 8225 8226 8227 8228 8229 8230 8231 8232 8233 8234 8235 8236 8237 8238 8239 8240 8241 8242 8243 8244 8245 8246 8247 8248 8249 8250 8251 8252 8253 8254 8255 8256 8257 8258 8259 8260 8261 8262 8263 8264 8265 8266 8267 8268 8269 8270 8271 8272 8273 8274 8275 8276 8277 8278 8279 8280 8281 8282 8283 8284 8285 8286 8287 8288 8289 8290 8291 8292 8293 8294 8295 8296 8297 8298 8299 8300 8301 8302 8303 8304 8305 8306 8307 8308 8309 8310 8311 8312 8313 8314 8315 8316 8317 8318 8319 8320 8321 8322 8323 8324 8325 8326 8327 8328 8329 8330 8331 8332 8333 8334 8335 8336 8337 8338 8339 8340 8341 8342 8343 8344 8345 8346 8347 8348 8349 8350 8351 8352 8353 8354 8355 8356 8357 8358 8359 8360 8361 8362 8363 8364 8365 8366 8367 8368 8369 8370 8371 8372 8373 8374 8375 8376 8377 8378 8379 8380 8381 8382 8383 8384 8385 8386 8387 8388 8389 8390 8391 8392 8393 8394 8395 8396 8397 8398 8399 8400 8401 8402 8403 8404 8405 8406 8407 8408 8409 8410 8411 8412 8413 8414 8415 8416 8417 8418 8419 8420 8421 8422 8423 8424 8425 8426 8427 8428 8429 8430 8431 8432 8433 8434 8435 8436 8437 8438 8439 8440 8441 8442 8443 8444 8445 8446 8447 8448 8449 8450 8451 8452 8453 8454 8455 8456 8457 8458 8459 8460 8461 8462 8463 8464 8465 8466 8467 8468 8469 8470 8471 8472 8473 8474 8475 8476 8477 8478 8479 8480 8481 8482 8483 8484 8485 8486 8487 8488 8489 8490 8491 8492 8493 8494 8495 8496 8497 8498 8499 8500 8501 8502 8503 8504 8505 8506 8507 8508 8509 8510 8511 8512 8513 8514 8515 8516 8517 8518 8519 8520 8521 8522 8523 8524 8525 8526 8527 8528 8529 8530 8531 8532 8533 8534 8535 8536 8537 8538 8539 8540 8541 8542 8543 8544 8545 8546 8547 8548 8549 8550 8551 8552 8553 8554 8555 8556 8557 8558 8559 8560 8561 8562 8563 8564 8565 8566 8567 8568 8569 8570 8571 8572 8573 8574 8575 8576 8577 8578 8579 8580 8581 8582 8583 8584 8585 8586 8587 8588 8589 8590 8591 8592 8593 8594 8595 8596 8597 8598 8599 8600 8601 8602 8603 8604 8605 8606 8607 8608 8609 8610 8611 8612 8613 8614 8615 8616 8617 8618 8619 8620 8621 8622 8623 8624 8625 8626 8627 8628 8629 8630 8631 8632 8633 8634 8635 8636 8637 8638 8639 8640 8641 8642 8643 8644 8645 8646 8647 8648 8649 8650 8651 8652 8653 8654 8655 8656 8657 8658 8659 8660 8661 8662 8663 8664 8665 8666 8667 8668 8669 8670 8671 8672 8673 8674 8675 8676 8677 8678 8679 8680 8681 8682 8683 8684 8685 8686 8687 8688 8689 8690 8691 8692 8693 8694 8695 8696 8697 8698 8699 8700 8701 8702 8703 8704 8705 8706 8707 8708 8709 8710 8711 8712 8713 8714 8715 8716 8717 8718 8719 8720 8721 8722 8723 8724 8725 8726 8727 8728 8729 8730 8731 8732 8733 8734 8735 8736 8737 8738 8739 8740 8741 8742 8743 8744 8745 8746 8747 8748 8749 8750 8751 8752 8753 8754 8755 8756 8757 8758 8759 8760 8761 8762 8763 8764 8765 8766 8767 8768 8769 8770 8771 8772 8773 8774 8775 8776 8777 8778 8779 8780 8781 8782 8783 8784 8785 8786 8787 8788 8789 8790 8791 8792 8793 8794 8795 8796 8797 8798 8799 8800 8801 8802 8803 8804 8805 8806 8807 8808 8809 8810 8811 8812 8813 8814 8815 8816 8817 8818 8819 8820 8821 8822 8823 8824 8825 8826 8827 8828 8829 8830 8831 8832 8833 8834 8835 8836 8837 8838 8839 8840 8841 8842 8843 8844 8845 8846 8847 8848 8849 8850 8851 8852 8853 8854 8855 8856 8857 8858 8859 8860 8861 8862 8863 8864 8865 8866 8867 8868 8869 8870 8871 8872 8873 8874 8875 8876 8877 8878 8879 8880 8881 8882 8883 8884 8885 8886 8887 8888 8889 8890 8891 8892 8893 8894 8895 8896 8897 8898 8899 8900 8901 8902 8903 8904 8905 8906 8907 8908 8909 8910 8911 8912 8913 8914 8915 8916 8917 8918 8919 8920 8921 8922 8923 8924 8925 8926 8927 8928 8929 8930 8931 8932 8933 8934 8935 8936 8937 8938 8939 8940 8941 8942 8943 8944 8945 8946 8947 8948 8949 8950 8951 8952 8953 8954 8955 8956 8957 8958 8959 8960 8961 8962 8963 8964 8965 8966 8967 8968 8969 8970 8971 8972 8973 8974 8975 8976 8977 8978 8979 8980 8981 8982 8983 8984 8985 8986 8987 8988 8989 8990 8991 8992 8993 8994 8995 8996 8997 8998 8999 9000 9001 9002 9003 9004 9005 9006 9007 9008 9009 9010 9011 9012 9013 9014 9015 9016 9017 9018 9019 9020 9021 9022 9023 9024 9025 9026 9027 9028 9029 9030 9031 9032 9033 9034 9035 9036 9037 9038 9039 9040 9041 9042 9043 9044 9045 9046 9047 9048 9049 9050 9051 9052 9053 9054 9055 9056 9057 9058 9059 9060 9061 9062 9063 9064 9065 9066 9067 9068 9069 9070 9071 9072 9073 9074 9075 9076 9077 9078 9079 9080 9081 9082 9083 9084 9085 9086 9087 9088 9089 9090 9091 9092 9093 9094 9095 9096 9097 9098 9099 9100 9101 9102 9103 9104 9105 9106 9107 9108 9109 9110 9111 9112 9113 9114 9115 9116 9117 9118 9119 9120 9121 9122 9123 9124 9125 9126 9127 9128 9129 9130 9131 9132 9133 9134 9135 9136 9137 9138 9139 9140 9141 9142 9143 9144 9145 9146 9147 9148 9149 9150 9151 9152 9153 9154 9155 9156 9157 9158 9159 9160 9161 9162 9163 9164 9165 9166 9167 9168 9169 9170 9171 9172 9173 9174 9175 9176 9177 9178 9179 9180 9181 9182 9183 9184 9185 9186 9187 9188 9189 9190 9191 9192 9193 9194 9195 9196 9197 9198 9199 9200 9201 9202 9203 9204 9205 9206 9207 9208 9209 9210 9211 9212 9213 9214 9215 9216 9217 9218 9219 9220 9221 9222 9223 9224 9225 9226 9227 9228 9229 9230 9231 9232 9233 9234 9235 9236 9237 9238 9239 9240 9241 9242 9243 9244 9245 9246 9247 9248 9249 9250 9251 9252 9253 9254 9255 9256 9257 9258 9259 9260 9261 9262 9263 9264 9265 9266 9267 9268 9269 9270 9271 9272 9273 9274 9275 9276 9277 9278 9279 9280 9281 9282 9283 9284 9285 9286 9287 9288 9289 9290 9291 9292 9293 9294 9295 9296 9297 9298 9299 9300 9301 9302 9303 9304 9305 9306 9307 9308 9309 9310 9311 9312 9313 9314 9315 9316 9317 9318 9319 9320 9321 9322 9323 9324 9325 9326 9327 9328 9329 9330 9331 9332 9333 9334 9335 9336 9337 9338 9339 9340 9341 9342 9343 9344 9345 9346 9347 9348 9349 9350 9351 9352 9353 9354 9355 9356 9357 9358 9359 9360 9361 9362 9363 9364 9365 9366 9367 9368 9369 9370 9371 9372 9373 9374 9375 9376 9377 9378 9379 9380 9381 9382 9383 9384 9385 9386 9387 9388 9389 9390 9391 9392 9393 9394 9395 9396 9397 9398 9399 9400 9401 9402 9403 9404 9405 9406 9407 9408 9409 9410 9411 9412 9413 9414 9415 9416 9417 9418 9419 9420 9421 9422 9423 9424 9425 9426 9427 9428 9429 9430 9431 9432 9433 9434 9435 9436 9437 9438 9439 9440 9441 9442 9443 9444 9445 9446 9447 9448 9449 9450 9451 9452 9453 9454 9455 9456 9457 9458 9459 9460 9461 9462 9463 9464 9465 9466 9467 9468 9469 9470 9471 9472 9473 9474 9475 9476 9477 9478 9479 9480 9481 9482 9483 9484 9485 9486 9487 9488 9489 9490 9491 9492 9493 9494 9495 9496 9497 9498 9499 9500 9501 9502 9503 9504 9505 9506 9507 9508 9509 9510 9511 9512 9513 9514 9515 9516 9517 9518 9519 9520 9521 9522 9523 9524 9525 9526 9527 9528 9529 9530 9531 9532 9533 9534 9535 9536 9537 9538 9539 9540 9541 9542 9543 9544 9545 9546 9547 9548 9549 9550 9551 9552 9553 9554 9555 9556 9557 9558 9559 9560 9561 9562 9563 9564 9565 9566 9567 9568 9569 9570 9571 9572 9573 9574 9575 9576 9577 9578 9579 9580 9581 9582 9583 9584 9585 9586 9587 9588 9589 9590 9591 9592 9593 9594 9595 9596 9597 9598 9599 9600 9601 9602 9603 9604 9605 9606 9607 9608 9609 9610 9611 9612 9613 9614 9615 9616 9617 9618 9619 9620 9621 9622 9623 9624 9625 9626 9627 9628 9629 9630 9631 9632 9633 9634 9635 9636 9637 9638 9639 9640 9641 9642 9643 9644 9645 9646 9647 9648 9649 9650 9651 9652 9653 9654 9655 9656 9657 9658 9659 9660 9661 9662 9663 9664 9665 9666 9667 9668 9669 9670 9671 9672 9673 9674 9675 9676 9677 9678 9679 9680 9681 9682 9683 9684 9685 9686 9687 9688 9689 9690 9691 9692 9693 9694 9695 9696 9697 9698 9699 9700 9701 9702 9703 9704 9705 9706 9707 9708 9709 9710 9711 9712 9713 9714 9715 9716 9717 9718 9719 9720 9721 9722 9723 9724 9725 9726 9727 9728 9729 9730 9731 9732 9733 9734 9735 9736 9737 9738 9739 9740 9741 9742 9743 9744 9745 9746 9747 9748 9749 9750 9751 9752 9753 9754 9755 9756 9757 9758 9759 9760 9761 9762 9763 9764 9765 9766 9767 9768 9769 9770 9771 9772 9773 9774 9775 9776 9777 9778 9779 9780 9781 9782 9783 9784 9785 9786 9787 9788 9789 9790 9791 9792 9793 9794 9795 9796 9797 9798 9799 9800 9801 9802 9803 9804 9805 9806 9807 9808 9809 9810 9811 9812 9813 9814 9815 9816 9817 9818 9819 9820 9821 9822 9823 9824 9825 9826 9827 9828 9829 9830 9831 9832 9833 9834 9835 9836 9837 9838 9839 9840 9841 9842 9843 9844 9845 9846 9847 9848 9849 9850 9851 9852 9853 9854 9855 9856 9857 9858 9859 9860 9861 9862 9863 9864 9865 9866 9867 9868 9869 9870 9871 9872 9873 9874 9875 9876 9877 9878 9879 9880 9881 9882 9883 9884 9885 9886 9887 9888 9889 9890 9891 9892 9893 9894 9895 9896 9897 9898 9899 9900 9901 9902 9903 9904 9905 9906 9907 9908 9909 9910 9911 9912 9913 9914 9915 9916 9917 9918 9919 9920 9921 9922 9923 9924 9925 9926 9927 9928 9929 9930 9931 9932 9933 9934 9935 9936 9937 9938 9939 9940 9941 9942 9943 9944 9945 9946 9947 9948 9949 9950 9951 9952 9953 9954 9955 9956 9957 9958 9959 9960 9961 9962 9963 9964 9965 9966 9967 9968 9969 9970 9971 9972 9973 9974 9975 9976 9977 9978 9979 9980 9981 9982 9983 9984 9985 9986 9987 9988 9989 9990 9991 9992 9993 9994 9995 9996 9997 9998 9999 10000 10001 10002 10003 10004 10005 10006 10007 10008 10009 10010 10011 10012 10013 10014 10015 10016 10017 10018 10019 10020 10021 10022 10023 10024 10025 10026 10027 10028 10029 10030 10031 10032 10033 10034 10035 10036 10037 10038 10039 10040 10041 10042 10043 10044 10045 10046 10047 10048 10049 10050 10051 10052 10053 10054 10055 10056 10057 10058 10059 10060 10061 10062 10063 10064 10065 10066 10067 10068 10069 10070 10071 10072 10073 10074 10075 10076 10077 10078 10079 10080 10081 10082 10083 10084 10085 10086 10087 10088 10089 10090 10091 10092 10093 10094 10095 10096 10097 10098 10099 10100 10101 10102 10103 10104 10105 10106 10107 10108 10109 10110 10111 10112 10113 10114 10115 10116 10117 10118 10119 10120 10121 10122 10123 10124 10125 10126 10127 10128 10129 10130 10131 10132 10133 10134 10135 10136 10137 10138 10139 10140 10141 10142 10143 10144 10145 10146 10147 10148 10149 10150 10151 10152 10153 10154 10155 10156 10157 10158 10159 10160 10161 10162 10163 10164 10165 10166 10167 10168 10169 10170 10171 10172 10173 10174 10175 10176 10177 10178 10179 10180 10181 10182 10183 10184 10185 10186 10187 10188 10189 10190 10191 10192 10193 10194 10195 10196 10197 10198 10199 10200 10201 10202 10203 10204 10205 10206 10207 10208 10209 10210 10211 10212 10213 10214 10215 10216 10217 10218 10219 10220 10221 10222 10223 10224 10225 10226 10227 10228 10229 10230 10231 10232 10233 10234 10235 10236 10237 10238 10239 10240 10241 10242 10243 10244 10245 10246 10247 10248 10249 10250 10251 10252 10253 10254 10255 10256 10257 10258 10259 10260 10261 10262 10263 10264 10265 10266 10267 10268 10269 10270 10271 10272 10273 10274 10275 10276 10277 10278 10279 10280 10281 10282 10283 10284 10285 10286 10287 10288 10289 10290 10291 10292 10293 10294 10295 10296 10297 10298 10299 10300 10301 10302 10303 10304 10305 10306 10307 10308 10309 10310 10311 10312 10313 10314 10315 10316 10317 10318 10319 10320 10321 10322 10323 10324 10325 10326 10327 10328 10329 10330 10331 10332 10333 10334 10335 10336 10337 10338 10339 10340 10341 10342 10343 10344 10345 10346 10347 10348 10349 10350 10351 10352 10353 10354 10355 10356 10357 10358 10359 10360 10361 10362 10363 10364 10365 10366 10367 10368 10369 10370 10371 10372 10373 10374 10375 10376 10377 10378 10379 10380 10381 10382 10383 10384 10385 10386 10387 10388 10389 10390 10391 10392 10393 10394 10395 10396 10397 10398 10399 10400 10401 10402 10403 10404 10405 10406 10407 10408 10409 10410 10411 10412 10413 10414 10415 10416 10417 10418 10419 10420 10421 10422 10423 10424 10425 10426 10427 10428 10429 10430 10431 10432 10433 10434 10435 10436 10437 10438 10439 10440 10441 10442 10443 10444 10445 10446 10447 10448 10449 10450 10451 10452 10453 10454 10455 10456 10457 10458 10459 10460 10461 10462 10463 10464 10465 10466 10467 10468 10469 10470 10471 10472 10473 10474 10475 10476 10477 10478 10479 10480 10481 10482 10483 10484 10485 10486 10487 10488 10489 10490 10491 10492 10493 10494 10495 10496 10497 10498 10499 10500 10501 10502 10503 10504 10505 10506 10507 10508 10509 10510 10511 10512 10513 10514 10515 10516 10517 10518 10519 10520 10521 10522 10523 10524 10525 10526 10527 10528 10529 10530 10531 10532 10533 10534 10535 10536 10537 10538 10539 10540 10541 10542 10543 10544 10545 10546 10547 10548 10549 10550 10551 10552 10553 10554 10555 10556 10557 10558 10559 10560 10561 10562 10563 10564 10565 10566 10567 10568 10569 10570 10571 10572 10573 10574 10575 10576 10577 10578 10579 10580 10581 10582 10583 10584 10585 10586 10587 10588 10589 10590 10591 10592 10593 10594 10595 10596 10597 10598 10599 10600 10601 10602 10603 10604 10605 10606 10607 10608 10609 10610 10611 10612 10613 10614 10615 10616 10617 10618 10619 10620 10621 10622 10623 10624 10625 10626 10627 10628 10629 10630 10631 10632 10633 10634 10635 10636 10637 10638 10639 10640 10641 10642 10643 10644 10645 10646 10647 10648 10649 10650 10651 10652 10653 10654 10655 10656 10657 10658 10659 10660 10661 10662 10663 10664 10665 10666 10667 10668 10669 10670 10671 10672 10673 10674 10675 10676 10677 10678 10679 10680 10681 10682 10683 10684 10685 10686 10687 10688 10689 10690 10691 10692 10693 10694 10695 10696 10697 10698 10699 10700 10701 10702 10703 10704 10705 10706 10707 10708 10709 10710 10711 10712 10713 10714 10715 10716 10717 10718 10719 10720 10721 10722 10723 10724 10725 10726 10727 10728 10729 10730 10731 10732 10733 10734 10735 10736 10737 10738 10739 10740 10741 10742 10743 10744 10745 10746 10747 10748 10749 10750 10751 10752 10753 10754 10755 10756 10757 10758 10759 10760 10761 10762 10763 10764 10765 10766 10767 10768 10769 10770 10771 10772 10773 10774 10775 10776 10777 10778 10779 10780 10781 10782 10783 10784 10785 10786 10787 10788 10789 10790 10791 10792 10793 10794 10795 10796 10797 10798 10799 10800 10801 10802 10803 10804 10805 10806 10807 10808 10809 10810 10811 10812 10813 10814 10815 10816 10817 10818 10819 10820 10821 10822 10823 10824 10825 10826 10827 10828 10829 10830 10831 10832 10833 10834 10835 10836 10837 10838 10839 10840 10841 10842 10843 10844 10845 10846 10847 10848 10849 10850 10851 10852 10853 10854 10855 10856 10857 10858 10859 10860 10861 10862 10863 10864 10865 10866 10867 10868 10869 10870 10871 10872 10873 10874 10875 10876 10877 10878 10879 10880 10881 10882 10883 10884 10885 10886 10887 10888 10889 10890 10891 10892 10893 10894 10895 10896 10897 10898 10899 10900 10901 10902 10903 10904 10905 10906 10907 10908 10909 10910 10911 10912 10913 10914 10915 10916 10917 10918 10919 10920 10921 10922 10923 10924 10925 10926 10927 10928 10929 10930 10931 10932 10933 10934 10935 10936 10937 10938 10939 10940 10941 10942 10943 10944 10945 10946 10947 10948 10949 10950 10951 10952 10953 10954 10955 10956 10957 10958 10959 10960 10961 10962 10963 10964 10965 10966 10967 10968 10969 10970 10971 10972 10973 10974 10975 10976 10977 10978 10979 10980 10981 10982 10983 10984 10985 10986 10987 10988 10989 10990 10991 10992 10993 10994 10995 10996 10997 10998 10999 11000 11001 11002 11003 11004 11005 11006 11007 11008 11009 11010 11011 11012 11013 11014 11015 11016 11017 11018 11019 11020 11021 11022 11023 11024 11025 11026 11027 11028 11029 11030 11031 11032 11033 11034 11035 11036 11037 11038 11039 11040 11041 11042 11043 11044 11045 11046 11047 11048 11049 11050 11051 11052 11053 11054 11055 11056 11057 11058 11059 11060 11061 11062 11063 11064 11065 11066 11067 11068 11069 11070 11071 11072 11073 11074 11075 11076 11077 11078 11079 11080 11081 11082 11083 11084 11085 11086 11087 11088 11089 11090 11091 11092 11093 11094 11095 11096 11097 11098 11099 11100 11101 11102 11103 11104 11105 11106 11107 11108 11109 11110 11111 11112 11113 11114 11115 11116 11117 11118 11119 11120 11121 11122 11123 11124 11125 11126 11127 11128 11129 11130 11131 11132 11133 11134 11135 11136 11137 11138 11139 11140 11141 11142 11143 11144 11145 11146 11147 11148 11149 11150 11151 11152 11153 11154 11155 11156 11157 11158 11159 11160 11161 11162 11163 11164 11165 11166 11167 11168 11169 11170 11171 11172 11173 11174 11175 11176 11177 11178 11179 11180 11181 11182 11183 11184 11185 11186 11187 11188 11189 11190 11191 11192 11193 11194 11195 11196 11197 11198 11199 11200 11201 11202 11203 11204 11205 11206 11207 11208 11209 11210 11211 11212 11213 11214 11215 11216 11217 11218 11219 11220 11221 11222 11223 11224 11225 11226 11227 11228 11229 11230 11231 11232 11233 11234 11235 11236 11237 11238 11239 11240 11241 11242 11243 11244 11245 11246 11247 11248 11249 11250 11251 11252 11253 11254 11255 11256 11257 11258 11259 11260 11261 11262 11263 11264 11265 11266 11267 11268 11269 11270 11271 11272 11273 11274 11275 11276 11277 11278 11279 11280 11281 11282 11283 11284 11285 11286 11287 11288 11289 11290 11291 11292 11293 11294 11295 11296 11297 11298 11299 11300 11301 11302 11303 11304 11305 11306 11307 11308 11309 11310 11311 11312 11313 11314 11315 11316 11317 11318 11319 11320 11321 11322 11323 11324 11325 11326 11327 11328 11329 11330 11331 11332 11333 11334 11335 11336 11337 11338 11339 11340 11341 11342 11343 11344 11345 11346 11347 11348 11349 11350 11351 11352 11353 11354 11355 11356 11357 11358 11359 11360 11361 11362 11363 11364 11365 11366 11367 11368 11369 11370 11371 11372 11373 11374 11375 11376 11377 11378 11379 11380 11381 11382 11383 11384 11385 11386 11387 11388 11389 11390 11391 11392 11393 11394 11395 11396 11397 11398 11399 11400 11401 11402 11403 11404 11405 11406 11407 11408 11409 11410 11411 11412 11413 11414 11415 11416 11417 11418 11419 11420 11421 11422 11423 11424 11425 11426 11427 11428 11429 11430 11431 11432 11433 11434 11435 11436 11437 11438 11439 11440 11441 11442 11443 11444 11445 11446 11447 11448 11449 11450 11451 11452 11453 11454 11455 11456 11457 11458 11459 11460 11461 11462 11463 11464 11465 11466 11467 11468 11469 11470 11471 11472 11473 11474 11475 11476 11477 11478 11479 11480 11481 11482 11483 11484 11485 11486 11487 11488 11489 11490 11491 11492 11493 11494 11495 11496 11497 11498 11499 11500 11501 11502 11503 11504 11505 11506 11507 11508 11509 11510 11511 11512 11513 11514 11515 11516 11517 11518 11519 11520 11521 11522 11523 11524 11525 11526 11527 11528 11529 11530 11531 11532 11533 11534 11535 11536 11537 11538 11539 11540 11541 11542 11543 11544 11545 11546 11547 11548 11549 11550 11551 11552 11553 11554 11555 11556 11557 11558 11559 11560 11561 11562 11563 11564 11565 11566 11567 11568 11569 11570 11571 11572 11573 11574 11575 11576 11577 11578 11579 11580 11581 11582 11583 11584 11585 11586 11587 11588 11589 11590 11591 11592 11593 11594 11595 11596 11597 11598 11599 11600 11601 11602 11603 11604 11605 11606 11607 11608 11609 11610 11611 11612 11613 11614 11615 11616 11617 11618 11619 11620 11621 11622 11623 11624 11625 11626 11627 11628 11629 11630 11631 11632 11633 11634 11635 11636 11637 11638 11639 11640 11641 11642 11643 11644 11645 11646 11647 11648 11649 11650 11651 11652 11653 11654 11655 11656 11657 11658 11659 11660 11661 11662 11663 11664 11665 11666 11667 11668 11669 11670 11671 11672 11673 11674 11675 11676 11677 11678 11679 11680 11681 11682 11683 11684 11685 11686 11687 11688 11689 11690 11691 11692 11693 11694 11695 11696 11697 11698 11699 11700 11701 11702 11703 11704 11705 11706 11707 11708 11709 11710 11711 11712 11713 11714 11715 11716 11717 11718 11719 11720 11721 11722 11723 11724 11725 11726 11727 11728 11729 11730 11731 11732 11733 11734 11735 11736 11737 11738 11739 11740 11741 11742 11743 11744 11745 11746 11747 11748 11749 11750 11751 11752 11753 11754 11755 11756 11757 11758 11759 11760 11761 11762 11763 11764 11765 11766 11767 11768 11769 11770 11771 11772 11773 11774 11775 11776 11777 11778 11779 11780 11781 11782 11783 11784 11785 11786 11787 11788 11789 11790 11791 11792 11793 11794 11795 11796 11797 11798 11799 11800 11801 11802 11803 11804 11805 11806 11807 11808 11809 11810 11811 11812 11813 11814 11815 11816 11817 11818 11819 11820 11821 11822 11823 11824 11825 11826 11827 11828 11829 11830 11831 11832 11833 11834 11835 11836 11837 11838 11839 11840 11841 11842 11843 11844 11845 11846 11847 11848 11849 11850 11851 11852 11853 11854 11855 11856 11857 11858 11859 11860 11861 11862 11863 11864 11865 11866 11867 11868 11869 11870 11871 11872 11873 11874 11875 11876 11877 11878 11879 11880 11881 11882 11883 11884 11885 11886 11887 11888 11889 11890 11891 11892 11893 11894 11895 11896 11897 11898 11899 11900 11901 11902 11903 11904 11905 11906 11907 11908 11909 11910 11911 11912 11913 11914 11915 11916 11917 11918 11919 11920 11921 11922 11923 11924 11925 11926 11927 11928 11929 11930 11931 11932 11933 11934 11935 11936 11937 11938 11939 11940 11941 11942 11943 11944 11945 11946 11947 11948 11949 11950 11951 11952 11953 11954 11955 11956 11957 11958 11959 11960 11961 11962 11963 11964 11965 11966 11967 11968 11969 11970 11971 11972 11973 11974 11975 11976 11977 11978 11979 11980 11981 11982 11983 11984 11985 11986 11987 11988 11989 11990 11991 11992 11993 11994 11995 11996 11997 11998 11999 12000 12001 12002 12003 12004 12005 12006 12007 12008 12009 12010 12011 12012 12013 12014 12015 12016 12017 12018 12019 12020 12021 12022 12023 12024 12025 12026 12027 12028 12029 12030 12031 12032 12033 12034 12035 12036 12037 12038 12039 12040 12041 12042 12043 12044 12045 12046 12047 12048 12049 12050 12051 12052 12053 12054 12055 12056 12057 12058 12059 12060 12061 12062 12063 12064 12065 12066 12067 12068 12069 12070 12071 12072 12073 12074 12075 12076 12077 12078 12079 12080 12081 12082 12083 12084 12085 12086 12087 12088 12089 12090 12091 12092 12093 12094 12095 12096 12097 12098 12099 12100 12101 12102 12103 12104 12105 12106 12107 12108 12109 12110 12111 12112 12113 12114 12115 12116 12117 12118 12119 12120 12121 12122 12123 12124 12125 12126 12127 12128 12129 12130 12131 12132 12133 12134 12135 12136 12137 12138 12139 12140 12141 12142 12143 12144 12145 12146 12147 12148 12149 12150 12151 12152 12153 12154 12155 12156 12157 12158 12159 12160 12161 12162 12163 12164 12165 12166 12167 12168 12169 12170 12171 12172 12173 12174 12175 12176 12177 12178 12179 12180 12181 12182 12183 12184 12185 12186 12187 12188 12189 12190 12191 12192 12193 12194 12195 12196 12197 12198 12199 12200 12201 12202 12203 12204 12205 12206 12207 12208 12209 12210 12211 12212 12213 12214 12215 12216 12217 12218 12219 12220 12221 12222 12223 12224 12225 12226 12227 12228 12229 12230 12231 12232 12233 12234 12235 12236 12237 12238 12239 12240 12241 12242 12243 12244 12245 12246 12247 12248 12249 12250 12251 12252 12253 12254 12255 12256 12257 12258 12259 12260 12261 12262 12263 12264 12265 12266 12267 12268 12269 12270 12271 12272 12273 12274 12275 12276 12277 12278 12279 12280 12281 12282 12283 12284 12285 12286 12287 12288 12289 12290 12291 12292 12293 12294 12295 12296 12297 12298 12299 12300 12301 12302 12303 12304 12305 12306 12307 12308 12309 12310 12311 12312 12313 12314 12315 12316 12317 12318 12319 12320 12321 12322 12323 12324 12325 12326 12327 12328 12329 12330 12331 12332 12333 12334 12335 12336 12337 12338 12339 12340 12341 12342 12343 12344 12345 12346 12347 12348 12349 12350 12351 12352 12353 12354 12355 12356 12357 12358 12359 12360 12361 12362 12363 12364 12365 12366 12367 12368 12369 12370 12371 12372 12373 12374 12375 12376 12377 12378 12379 12380 12381 12382 12383 12384 12385 12386 12387 12388 12389 12390 12391 12392 12393 12394 12395 12396 12397 12398 12399 12400 12401 12402 12403 12404 12405 12406 12407 12408 12409 12410 12411 12412 12413 12414 12415 12416 12417 12418 12419 12420 12421 12422 12423 12424 12425 12426 12427 12428 12429 12430 12431 12432 12433 12434 12435 12436 12437 12438 12439 12440 12441 12442 12443 12444 12445 12446 12447 12448 12449 12450 12451 12452 12453 12454 12455 12456 12457 12458 12459 12460 12461 12462 12463 12464 12465 12466 12467 12468 12469 12470 12471 12472 12473 12474 12475 12476 12477 12478 12479 12480 12481 12482 12483 12484 12485 12486 12487 12488 12489 12490 12491 12492 12493 12494 12495 12496 12497 12498 12499 12500 12501 12502 12503 12504 12505 12506 12507 12508 12509 12510 12511 12512 12513 12514 12515 12516 12517 12518 12519 12520 12521 12522 12523 12524 12525 12526 12527 12528 12529 12530 12531 12532 12533 12534 12535 12536 12537 12538 12539 12540 12541 12542 12543 12544 12545 12546 12547 12548 12549 12550 12551 12552 12553 12554 12555 12556 12557 12558 12559 12560 12561 12562 12563 12564 12565 12566 12567 12568 12569 12570 12571 12572 12573 12574 12575 12576 12577 12578 12579 12580 12581 12582 12583 12584 12585 12586 12587 12588 12589 12590 12591 12592 12593 12594 12595 12596 12597 12598 12599 12600 12601 12602 12603 12604 12605 12606 12607 12608 12609 12610 12611 12612 12613 12614 12615 12616 12617 12618 12619 12620 12621 12622 12623 12624 12625 12626 12627 12628 12629 12630 12631 12632 12633 12634 12635 12636 12637 12638 12639 12640 12641 12642 12643 12644 12645 12646 12647 12648 12649 12650 12651 12652 12653 12654 12655 12656 12657 12658 12659 12660 12661 12662 12663 12664 12665 12666 12667 12668 12669 12670 12671 12672 12673 12674 12675 12676 12677 12678 12679 12680 12681 12682 12683 12684 12685 12686 12687 12688 12689 12690 12691 12692 12693 12694 12695 12696 12697 12698 12699 12700 12701 12702 12703 12704 12705 12706 12707 12708 12709 12710 12711 12712 12713 12714 12715 12716 12717 12718 12719 12720 12721 12722 12723 12724 12725 12726 12727 12728 12729 12730 12731 12732 12733 12734 12735 12736 12737 12738 12739 12740 12741 12742 12743 12744 12745 12746 12747 12748 12749 12750 12751 12752 12753 12754 12755 12756 12757 12758 12759 12760 12761 12762 12763 12764 12765 12766 12767 12768 12769 12770 12771 12772 12773 12774 12775 12776 12777 12778 12779 12780 12781 12782 12783 12784 12785 12786 12787 12788 12789 12790 12791 12792 12793 12794 12795 12796 12797 12798 12799 12800 12801 12802 12803 12804 12805 12806 12807 12808 12809 12810 12811 12812 12813 12814 12815 12816 12817 12818 12819 12820 12821 12822 12823 12824 12825 12826 12827 12828 12829 12830 12831 12832 12833 12834 12835 12836 12837 12838 12839 12840 12841 12842 12843 12844 12845 12846 12847 12848 12849 12850 12851 12852 12853 12854 12855 12856 12857 12858 12859 12860 12861 12862 12863 12864 12865 12866 12867 12868 12869 12870 12871 12872 12873 12874 12875 12876 12877 12878 12879 12880 12881 12882 12883 12884 12885 12886 12887 12888 12889 12890 12891 12892 12893 12894 12895 12896 12897 12898 12899 12900 12901 12902 12903 12904 12905 12906 12907 12908 12909 12910 12911 12912 12913 12914 12915 12916 12917 12918 12919 12920 12921 12922 12923 12924 12925 12926 12927 12928 12929 12930 12931 12932 12933 12934 12935 12936 12937 12938 12939 12940 12941 12942 12943 12944 12945 12946 12947 12948 12949 12950 12951 12952 12953 12954 12955 12956 12957 12958 12959 12960 12961 12962 12963 12964 12965 12966 12967 12968 12969 12970 12971 12972 12973 12974 12975 12976 12977 12978 12979 12980 12981 12982 12983 12984 12985 12986 12987 12988 12989 12990 12991 12992 12993 12994 12995 12996 12997 12998 12999 13000 13001 13002 13003 13004 13005 13006 13007 13008 13009 13010 13011 13012 13013 13014 13015 13016 13017 13018 13019 13020 13021 13022 13023 13024 13025 13026 13027 13028 13029 13030 13031 13032 13033 13034 13035 13036 13037 13038 13039 13040 13041 13042 13043 13044 13045 13046 13047 13048 13049 13050 13051 13052 13053 13054 13055 13056 13057 13058 13059 13060 13061 13062 13063 13064 13065 13066 13067 13068 13069 13070 13071 13072 13073 13074 13075 13076 13077 13078 13079 13080 13081 13082 13083 13084 13085 13086 13087 13088 13089 13090 13091 13092 13093 13094 13095 13096 13097 13098 13099 13100 13101 13102 13103 13104 13105 13106 13107 13108 13109 13110 13111 13112 13113 13114 13115 13116 13117 13118 13119 13120 13121 13122 13123 13124 13125 13126 13127 13128 13129 13130 13131 13132 13133 13134 13135 13136 13137 13138 13139 13140 13141 13142 13143 13144 13145 13146 13147 13148 13149 13150 13151 13152 13153 13154 13155 13156 13157 13158 13159 13160 13161 13162 13163 13164 13165 13166 13167 13168 13169 13170 13171 13172 13173 13174 13175 13176 13177 13178 13179 13180 13181 13182 13183 13184 13185 13186 13187 13188 13189 13190 13191 13192 13193 13194 13195 13196 13197 13198 13199 13200 13201 13202 13203 13204 13205 13206 13207 13208 13209 13210 13211 13212 13213 13214 13215 13216 13217 13218 13219 13220 13221 13222 13223 13224 13225 13226 13227 13228 13229 13230 13231 13232 13233 13234 13235 13236 13237 13238 13239 13240 13241 13242 13243 13244 13245 13246 13247 13248 13249 13250 13251 13252 13253 13254 13255 13256 13257 13258 13259 13260 13261 13262 13263 13264 13265 13266 13267 13268 13269 13270 13271 13272 13273 13274 13275 13276 13277 13278 13279 13280 13281 13282 13283 13284 13285 13286 13287 13288 13289 13290 13291 13292 13293 13294 13295 13296 13297 13298 13299 13300 13301 13302 13303 13304 13305 13306 13307))
           (list :vertices #2f((0.320995 169.414001 322.342010)(8.331990 168.541992 322.575012)(8.331990 165.539993 311.369995)(8.331990 168.541992 322.575012)(0.320995 169.414001 322.342010)(36.320999 134.639999 331.658997)(35.543400 125.382004 323.787994)(35.418999 124.314003 324.074005)(36.000000 125.073997 323.869995)(35.418999 124.314003 324.074005)(35.543400 125.382004 323.787994)(35.418999 126.902000 333.733002)(36.000000 129.298004 322.738007)(35.543400 125.382004 323.787994)(36.000000 125.073997 323.869995)(35.543400 125.382004 323.787994)(36.320999 134.639999 331.658997)(35.418999 126.902000 333.733002)(-15.297999 100.722000 330.395996)(-21.181702 104.293007 329.439026)(-26.830200 105.148003 329.210022)(-21.181702 104.293007 329.439026)(-15.297999 100.722000 330.395996)(-15.297999 103.309998 340.054016)(-15.297999 103.309998 340.054016)(-22.124001 107.453003 338.944000)(-21.181702 104.293007 329.439026)(-27.038200 109.611000 328.013977)(-23.934601 107.862999 333.478973)(-22.124001 107.453003 338.944000)(-27.038200 109.611000 328.013977)(-22.124001 107.453003 338.944000)(-27.824999 112.959000 337.469025)(-27.038200 109.611000 328.013977)(-25.662201 108.281998 328.369995)(-23.934601 107.862999 333.478973)(-25.662201 108.281998 328.369995)(-27.038200 109.611000 328.013977)(-39.616997 112.034004 327.365021)(-27.038200 109.611000 328.013977)(-27.824999 110.371002 327.809998)(-39.616997 112.034004 327.365021)(-23.934601 107.862999 333.478973)(-22.124001 104.864998 329.286011)(-22.124001 107.453003 338.944000)(-22.124001 107.453003 338.944000)(36.320999 134.639999 331.658997)(-27.824999 112.959000 337.469025)(-22.124001 107.453003 338.944000)(-15.297999 103.309998 340.054016)(36.320999 134.639999 331.658997)(36.320999 134.639999 331.658997)(-32.113998 119.553001 335.701996)(-27.824999 112.959000 337.469025)(-27.824999 110.371002 327.809998)(-27.038200 109.611000 328.013977)(-27.824999 112.959000 337.469025)(-19.302401 162.013000 318.217987)(-20.933599 159.962006 314.523010)(-22.124001 159.238998 314.716980)(-19.302401 162.013000 318.217987)(-22.124001 159.238998 314.716980)(-22.124001 161.826996 324.375000)(-34.885899 138.799988 319.997009)(-36.000000 132.054001 322.000000)(-34.885899 138.848999 320.179993)(-34.760098 139.374008 318.381012)(-34.885899 138.799988 319.997009)(-34.885899 138.848999 320.179993)(-34.760098 139.374008 318.381012)(-34.885899 138.848999 320.179993)(-34.775997 142.378006 329.585999)(-34.760098 139.374008 318.381012)(-34.885899 138.433990 318.632996)(-34.885899 138.799988 319.997009)(-34.760098 139.374008 318.381012)(-34.775997 142.378006 329.585999)(-34.694702 140.014999 319.867004)(-34.694702 139.601013 318.320984)(-34.760098 139.374008 318.381012)(-34.694702 140.014999 319.867004)(-34.885899 138.433990 318.632996)(-36.000000 132.054001 322.000000)(-34.885899 138.799988 319.997009)(-34.237999 132.706009 281.450012)(-36.000000 132.054001 322.000000)(-34.885899 138.433990 318.632996)(-34.775997 142.378006 329.585999)(-34.083900 142.904999 323.907990)(-34.694702 140.014999 319.867004)(-34.775997 124.314003 324.075012)(-34.805099 124.564003 324.007996)(-36.000000 125.073997 323.870972)(-34.775997 126.902000 333.733002)(-34.805099 124.564003 324.007996)(-34.775997 124.314003 324.075012)(-34.775997 124.314003 324.075012)(-34.408600 123.300003 324.346008)(-34.775997 126.902000 333.733002)(-35.554401 130.983994 322.286987)(-34.805099 124.564003 324.007996)(-34.775997 126.902000 333.733002)(-34.775997 126.902000 333.733002)(-35.679001 134.639999 331.658997)(-35.554401 130.983994 322.286987)(-34.675201 122.160004 324.651001)(-36.000000 125.073997 323.870972)(-36.410000 120.544998 325.084015)(-34.408600 123.300003 324.346008)(-36.000000 125.073997 323.870972)(-34.675201 122.160004 324.651001)(-34.408600 123.300003 324.346008)(-34.675201 122.160004 324.651001)(-32.940300 119.246002 325.432007)(-34.408600 123.300003 324.346008)(-32.940300 119.246002 325.432007)(-32.868797 120.264999 330.024017)(36.320999 134.639999 331.658997)(-34.775997 142.378006 329.585999)(-35.679001 134.639999 331.658997)(-35.679001 134.639999 331.658997)(-34.775997 142.378006 329.585999)(-34.900597 138.722000 320.212982)(36.320999 134.639999 331.658997)(-32.113998 149.727997 327.617004)(-34.775997 142.378006 329.585999)(-34.775997 142.378006 329.585999)(-32.113998 149.727997 327.617004)(-32.478897 146.133011 318.227997)(-31.965799 146.693008 316.420990)(-32.113998 146.725998 316.411987)(-31.239100 148.070999 316.052002)(-31.239100 148.070999 316.052002)(-32.113998 146.725998 316.411987)(-31.239201 148.485001 317.597992)(-28.800501 152.234009 316.592987)(-29.125000 152.492996 316.523987)(-31.239201 148.485001 317.597992)(-28.800501 152.234009 316.592987)(-31.239201 148.485001 317.597992)(-30.908501 150.165009 321.833984)(-31.239201 148.485001 317.597992)(-32.113998 146.725998 316.411987)(-30.908501 150.165009 321.833984)(-30.908501 150.165009 321.833984)(-32.113998 146.725998 316.411987)(-32.113998 149.727997 327.617004)(-32.113998 146.725998 316.411987)(-32.478897 146.133011 318.227997)(-32.113998 149.727997 327.617004)(-32.478897 146.133011 318.227997)(-34.083900 142.904999 323.907990)(-34.775997 142.378006 329.585999)(-33.789898 142.513000 319.197998)(-34.237999 142.800003 319.121002)(-34.694702 140.014999 319.867004)(-33.789898 142.513000 319.197998)(-33.357201 144.326004 318.712006)(-34.237999 142.800003 319.121002)(-34.237999 142.800003 319.121002)(-33.357201 144.326004 318.712006)(-32.478897 146.133011 318.227997)(-32.478897 146.133011 318.227997)(-34.237999 142.800003 319.121002)(-32.476501 146.134003 318.206024)(-32.113998 146.725998 316.411987)(-32.476501 145.724991 316.680023)(-32.476501 146.134003 318.206024)(-32.476501 145.724991 316.680023)(-34.237999 142.800003 319.121002)(-32.476501 146.134003 318.206024)(-34.237999 142.800003 319.121002)(-32.476501 145.724991 316.680023)(-29.125000 142.399002 278.852997)(-29.125000 142.399002 278.852997)(-34.237999 132.706009 281.450012)(-34.237999 142.800003 319.121002)(-32.478897 146.133011 318.227997)(-33.357201 144.326004 318.712006)(-33.789898 142.513000 319.197998)(-32.478897 146.133011 318.227997)(-33.789898 142.513000 319.197998)(-34.083900 142.904999 323.907990)(-31.965799 146.693008 316.420990)(-32.476501 145.724991 316.680023)(-32.113998 146.725998 316.411987)(-34.900597 138.722000 320.212982)(-35.679001 132.052002 322.000000)(-35.679001 134.639999 331.658997)(-27.824999 156.320999 325.850006)(-32.113998 149.727997 327.617004)(36.320999 134.639999 331.658997)(-39.616997 101.939995 289.694000)(-45.644997 95.002007 291.552979)(-45.644997 105.096001 329.223999)(-53.764999 100.567001 330.437012)(-45.644997 105.096001 329.223999)(-45.644997 95.002007 291.552979)(-53.764999 100.567001 330.437012)(-45.644997 95.002007 291.552979)(-53.764999 90.473007 292.765991)(-53.764999 100.567001 330.437012)(-39.445698 83.375198 334.000000)(-45.644997 105.096001 329.223999)(-61.307003 99.044998 330.845001)(-53.764999 100.567001 330.437012)(-53.764999 90.473007 292.765991)(-32.113998 116.965004 326.042999)(-36.410000 120.544998 325.084015)(-32.639599 114.414001 326.726990)(-32.639599 114.414001 326.726990)(-36.410000 120.544998 325.084015)(-39.616997 112.034004 327.365021)(-36.410000 110.451996 287.412994)(-39.616997 101.939995 289.694000)(-39.616997 112.034004 327.365021)(-39.616997 112.034004 327.365021)(-36.410000 120.544998 325.084015)(-36.410000 110.451996 287.412994)(-39.616997 101.939995 289.694000)(-45.644997 105.096001 329.223999)(-39.616997 112.034004 327.365021)(-36.000000 114.979996 286.199982)(-36.410000 110.451996 287.412994)(-36.410000 120.544998 325.084015)(-31.522099 116.055000 326.286987)(-32.113998 116.965004 326.042999)(-32.639599 114.414001 326.726990)(-27.824999 110.371002 327.809998)(-31.522099 116.055000 326.286987)(-32.639599 114.414001 326.726990)(-31.522099 116.055000 326.286987)(-27.824999 110.371002 327.809998)(-27.824999 112.959000 337.469025)(-32.113998 116.965004 326.042999)(-32.940300 119.246002 325.432007)(-36.410000 120.544998 325.084015)(-26.830200 105.148003 329.210022)(-39.616997 112.034004 327.365021)(-45.644997 105.096001 329.223999)(-36.000000 121.959999 284.329010)(-36.000000 114.979996 286.199982)(-36.000000 125.073997 323.870972)(-61.307003 88.950996 293.174011)(-61.307003 99.044998 330.845001)(-53.764999 90.473007 292.765991)(-61.307003 88.950996 293.174011)(-61.307003 82.135002 295.000000)(-61.307003 87.268997 334.000000)(-36.000000 132.054001 322.000000)(-36.000000 121.959999 284.329010)(-36.000000 125.073997 323.870972)(-36.000000 132.054001 322.000000)(-36.000000 125.073997 323.870972)(-35.554401 130.983994 322.286987)(-36.000000 132.054001 322.000000)(-35.554401 130.983994 322.286987)(-35.659100 131.880997 322.046021)(-35.679001 132.052002 322.000000)(-35.442902 135.364990 321.112976)(-36.000000 132.054001 322.000000)(-36.000000 132.054001 322.000000)(-35.659100 131.880997 322.046021)(-35.679001 132.052002 322.000000)(-35.679001 134.639999 331.658997)(-35.659100 131.880997 322.046021)(-35.554401 130.983994 322.286987)(-32.868797 120.264999 330.024017)(-32.940300 119.246002 325.432007)(-32.113998 116.965004 326.042999)(-32.868797 120.264999 330.024017)(-32.113998 116.965004 326.042999)(-32.113998 119.553001 335.701996)(-32.113998 149.727997 327.617004)(-27.824999 156.320999 325.850006)(-28.417000 152.822998 316.436005)(-27.824999 153.733002 316.191986)(-28.417000 152.822998 316.436005)(-27.824999 156.320999 325.850006)(-27.824999 153.733002 316.191986)(-29.125000 152.492996 316.523987)(-28.417000 152.822998 316.436005)(-22.910900 158.479004 314.920013)(-29.125000 152.492996 316.523987)(-22.124001 159.238998 314.716980)(-21.160000 160.185989 314.462982)(-29.125000 152.492996 316.523987)(-22.124001 159.238998 314.716980)(-27.824999 153.733002 316.191986)(-29.125000 152.492996 316.523987)(-22.910900 158.479004 314.920013)(-22.910900 158.479004 314.920013)(-27.824999 153.733002 316.191986)(-27.824999 156.320999 325.850006)(-28.417000 152.822998 316.436005)(-28.800501 152.234009 316.592987)(-30.908501 150.165009 321.833984)(-29.125000 152.492996 316.523987)(-21.160000 160.185989 314.462982)(-21.160000 150.092010 276.791016)(-11.974199 165.581009 317.317017)(-13.279699 164.065002 313.423004)(-15.297999 162.968002 312.059998)(-13.279699 164.065002 313.423004)(-13.279600 163.650009 311.877014)(-15.297999 162.968002 312.059998)(-13.279699 164.065002 313.423004)(-11.125000 165.125000 313.138977)(-13.279600 163.650009 311.877014)(-14.059900 158.708008 294.966003)(-13.279600 163.650009 311.877014)(-11.125000 165.125000 313.138977)(-11.125000 165.125000 313.138977)(-0.000008 156.733002 275.011993)(-11.125000 155.031998 275.467987)(-14.059900 158.708008 294.966003)(-11.125000 165.125000 313.138977)(-11.125000 155.031998 275.467987)(-11.125000 165.125000 313.138977)(-9.330561 164.985001 311.518982)(-0.000008 156.733002 275.011993)(-15.297999 162.968002 312.059998)(-15.014900 162.796005 312.106018)(-18.009399 161.321991 312.501007)(-13.279600 163.650009 311.877014)(-15.014900 162.796005 312.106018)(-15.297999 162.968002 312.059998)(-14.059900 158.708008 294.966003)(-11.125000 155.031998 275.467987)(-21.160000 160.185989 314.462982)(-11.125000 155.031998 275.467987)(-21.160000 150.092010 276.791016)(-21.160000 160.185989 314.462982)(-21.160000 160.185989 314.462982)(-18.009399 161.321991 312.501007)(-14.059900 158.708008 294.966003)(-18.009300 161.737000 314.046997)(-18.009399 161.321991 312.501007)(-21.160000 160.185989 314.462982)(-18.009399 161.321991 312.501007)(-15.014900 162.796005 312.106018)(-14.059900 158.708008 294.966003)(-18.009300 161.737000 314.046997)(-21.160000 160.185989 314.462982)(-20.933599 159.962006 314.523010)(-11.974199 165.581009 317.317017)(-10.912300 164.865005 313.208984)(-13.279699 164.065002 313.423004)(-28.417000 152.822998 316.436005)(-30.908501 150.165009 321.833984)(-32.113998 149.727997 327.617004)(-11.974199 165.581009 317.317017)(-9.330299 165.399994 313.065002)(-10.912300 164.865005 313.208984)(-34.408600 123.300003 324.346008)(-32.868797 120.264999 330.024017)(-32.113998 119.553001 335.701996)(-15.297999 165.970001 323.264984)(-11.974199 165.581009 317.317017)(-15.297999 162.968002 312.059998)(-22.124001 161.826996 324.375000)(-15.297999 165.970001 323.264984)(-15.297999 162.968002 312.059998)(-19.302401 162.013000 318.217987)(-22.124001 161.826996 324.375000)(-15.297999 162.968002 312.059998)(36.320999 134.639999 331.658997)(-22.124001 161.826996 324.375000)(-27.824999 156.320999 325.850006)(-36.000000 114.979996 286.199982)(-36.410000 120.544998 325.084015)(-36.000000 125.073997 323.870972)(36.320999 134.639999 331.658997)(-35.679001 134.639999 331.658997)(-34.775997 126.902000 333.733002)(-7.689010 165.539993 311.369995)(-11.974199 165.581009 317.317017)(-15.297999 165.970001 323.264984)(8.331990 165.539993 311.369995)(8.711970 165.080002 311.493011)(0.456574 166.343002 311.154999)(0.456574 166.343002 311.154999)(0.320995 166.412003 311.136993)(8.331990 165.539993 311.369995)(0.320995 166.412003 311.136993)(-0.807269 166.289001 311.170013)(0.456574 166.343002 311.154999)(-0.807269 166.289001 311.170013)(-0.000008 156.733002 275.011993)(-7.359990 165.287003 311.437988)(-0.807269 166.289001 311.170013)(0.456574 166.343002 311.154999)(-0.000008 156.733002 275.011993)(0.456574 166.343002 311.154999)(11.124000 155.031998 275.467987)(-0.000008 156.733002 275.011993)(-0.807269 166.289001 311.170013)(-7.359990 165.287003 311.437988)(-7.689010 165.539993 311.369995)(-7.689010 165.539993 311.369995)(-7.359990 165.287003 311.437988)(-9.330561 164.985001 311.518982)(-9.330299 165.399994 313.065002)(-7.689010 165.539993 311.369995)(-9.330561 164.985001 311.518982)(-15.297999 165.970001 323.264984)(36.320999 134.639999 331.658997)(-7.689010 168.541992 322.575012)(36.320999 134.639999 331.658997)(0.320995 169.414001 322.342010)(-7.689010 168.541992 322.575012)(-7.689010 168.541992 322.575012)(0.320995 169.414001 322.342010)(-0.807269 166.289001 311.170013)(-15.297999 165.970001 323.264984)(-7.689010 168.541992 322.575012)(-7.689010 165.539993 311.369995)(-7.689010 168.541992 322.575012)(-0.807269 166.289001 311.170013)(-7.689010 165.539993 311.369995)(25.785500 155.606995 314.031982)(22.767000 158.824997 313.169983)(28.466999 153.319000 314.644989)(28.804100 152.389008 314.893982)(25.785500 155.606995 314.031982)(28.466999 153.319000 314.644989)(29.125000 152.078995 314.976990)(28.804100 152.389008 314.893982)(28.466999 153.319000 314.644989)(28.804100 152.389008 314.893982)(23.349100 157.656998 313.483002)(25.785500 155.606995 314.031982)(22.767000 158.824997 313.169983)(22.767000 161.826996 324.375000)(28.466999 153.319000 314.644989)(23.349100 157.656998 313.483002)(22.767000 158.824997 313.169983)(25.785500 155.606995 314.031982)(29.125000 142.399002 278.852997)(28.804100 152.389008 314.893982)(29.125000 152.078995 314.976990)(21.486799 159.455994 313.001007)(22.767000 158.824997 313.169983)(23.349100 157.656998 313.483002)(21.160000 159.771988 312.916016)(16.541401 162.044998 312.307007)(15.941000 162.968002 312.059998)(16.541401 162.044998 312.307007)(21.160000 159.771988 312.916016)(21.160000 150.092010 276.791016)(29.125000 142.399002 278.852997)(21.486799 159.455994 313.001007)(23.349100 157.656998 313.483002)(21.486799 159.455994 313.001007)(29.125000 142.399002 278.852997)(21.160000 150.092010 276.791016)(21.160000 150.092010 276.791016)(21.160000 159.771988 312.916016)(21.486799 159.455994 313.001007)(21.160000 159.771988 312.916016)(22.767000 158.824997 313.169983)(21.486799 159.455994 313.001007)(29.125000 142.399002 278.852997)(23.349100 157.656998 313.483002)(28.804100 152.389008 314.893982)(29.334902 151.681000 315.084015)(34.237999 132.706009 281.450012)(29.125000 142.399002 278.852997)(28.466999 153.319000 314.644989)(22.767000 161.826996 324.375000)(28.466999 156.320999 325.850006)(22.767000 161.826996 324.375000)(36.320999 134.639999 331.658997)(28.466999 156.320999 325.850006)(22.767000 161.826996 324.375000)(15.941000 165.970001 323.264984)(36.320999 134.639999 331.658997)(28.466999 156.320999 325.850006)(32.756001 146.725998 316.411987)(28.466999 153.319000 314.644989)(15.941000 162.968002 312.059998)(22.767000 158.824997 313.169983)(21.160000 159.771988 312.916016)(15.941000 162.968002 312.059998)(8.331990 168.541992 322.575012)(15.941000 165.970001 323.264984)(15.941000 165.970001 323.264984)(22.767000 158.824997 313.169983)(15.941000 162.968002 312.059998)(8.711970 165.080002 311.493011)(16.541401 162.044998 312.307007)(21.160000 150.092010 276.791016)(8.711970 165.080002 311.493011)(21.160000 150.092010 276.791016)(11.124000 155.031998 275.467987)(-31.239201 148.485001 317.597992)(-29.125000 152.492996 316.523987)(-31.239100 148.070999 316.052002)(-29.125000 142.399002 278.852997)(-31.239100 148.070999 316.052002)(-29.125000 152.492996 316.523987)(-9.330299 165.399994 313.065002)(-11.974199 165.581009 317.317017)(-7.689010 165.539993 311.369995)(32.756001 146.725998 316.411987)(33.411201 143.953003 317.154999)(29.125000 152.078995 314.976990)(34.237999 142.386002 317.575012)(33.411201 143.953003 317.154999)(32.756001 146.725998 316.411987)(34.237999 132.706009 281.450012)(33.411201 143.953003 317.154999)(34.237999 142.386002 317.575012)(34.237999 132.706009 281.450012)(34.237999 142.386002 317.575012)(34.310299 141.945007 317.692993)(35.418999 139.376007 318.381012)(34.237999 142.386002 317.575012)(32.756001 146.725998 316.411987)(35.418999 139.376007 318.381012)(34.310299 141.945007 317.692993)(34.237999 142.386002 317.575012)(35.418999 139.376007 318.381012)(35.272999 136.072998 319.265991)(34.310299 141.945007 317.692993)(35.418999 139.376007 318.381012)(35.418999 142.378006 329.585999)(36.320999 131.638000 320.454010)(35.418999 139.376007 318.381012)(32.756001 149.727997 327.617004)(35.418999 142.378006 329.585999)(36.320999 131.638000 320.454010)(35.418999 142.378006 329.585999)(36.320999 134.639999 331.658997)(36.320999 131.638000 320.454010)(35.272999 136.072998 319.265991)(35.418999 139.376007 318.381012)(36.320999 131.638000 320.454010)(35.735001 133.255997 320.020996)(35.272999 136.072998 319.265991)(36.000000 130.279999 320.817993)(35.735001 133.255997 320.020996)(36.320999 131.638000 320.454010)(35.980198 130.005997 326.056000)(36.320999 131.638000 320.454010)(36.320999 134.639999 331.658997)(35.735001 133.255997 320.020996)(36.000000 130.279999 320.817993)(36.000000 121.959999 284.329010)(32.756001 149.727997 327.617004)(35.418999 139.376007 318.381012)(32.756001 146.725998 316.411987)(34.310299 141.945007 317.692993)(36.000000 121.959999 284.329010)(34.237999 132.706009 281.450012)(36.320999 134.639999 331.658997)(35.543400 125.382004 323.787994)(35.980198 130.005997 326.056000)(36.000000 128.884003 321.191986)(36.000000 130.279999 320.817993)(36.320999 131.638000 320.454010)(36.000000 128.884003 321.191986)(36.320999 131.638000 320.454010)(36.000000 129.298004 322.738007)(36.000000 130.279999 320.817993)(36.000000 128.884003 321.191986)(36.000000 123.167000 305.033997)(36.000000 128.884003 321.191986)(36.000000 125.073997 323.869995)(36.000000 123.167000 305.033997)(36.000000 125.073997 323.869995)(36.000000 114.979996 286.199005)(36.000000 123.167000 305.033997)(15.941000 165.970001 323.264984)(8.331990 168.541992 322.575012)(36.320999 134.639999 331.658997)(41.857998 101.320000 289.860016)(37.521999 107.587006 288.179993)(37.523003 117.681000 325.850983)(37.521999 107.587006 288.179993)(36.000000 125.073997 323.869995)(37.523003 117.681000 325.850983)(48.346001 107.225998 328.653015)(52.500000 95.959999 291.296021)(48.346001 97.133003 290.981995)(52.500000 95.959999 291.296021)(52.500000 87.269997 334.000000)(52.500000 82.135002 295.000000)(48.346001 107.225998 328.653015)(52.500000 106.054001 328.967010)(52.500000 95.959999 291.296021)(41.857998 111.414001 327.531006)(48.346001 107.225998 328.653015)(48.346001 97.133003 290.981995)(41.857998 111.414001 327.531006)(48.346001 97.133003 290.981995)(41.857998 101.320000 289.860016)(37.523003 117.681000 325.850983)(41.857998 111.414001 327.531006)(41.857998 101.320000 289.860016)(41.625599 102.190002 330.002014)(48.346001 107.225998 328.653015)(44.985802 106.802002 328.766998)(48.346001 107.225998 328.653015)(41.857998 111.414001 327.531006)(44.985802 106.802002 328.766998)(41.857998 111.414001 327.531006)(41.625599 102.190002 330.002014)(44.985802 106.802002 328.766998)(37.523003 117.681000 325.850983)(41.625599 102.190002 330.002014)(41.857998 111.414001 327.531006)(52.500000 106.054001 328.967010)(52.500000 87.269997 334.000000)(52.500000 95.959999 291.296021)(-25.662201 108.281998 328.369995)(-22.124001 104.864998 329.286011)(-23.934601 107.862999 333.478973)(-36.000000 125.073997 323.870972)(-34.408600 123.300003 324.346008)(-34.775997 124.314003 324.075012)(-34.885899 138.848999 320.179993)(-34.900597 138.722000 320.212982)(-34.775997 142.378006 329.585999)(-34.885899 138.848999 320.179993)(-35.442902 135.364990 321.112976)(-34.900597 138.722000 320.212982)(32.756001 149.727997 327.617004)(36.320999 134.639999 331.658997)(35.418999 142.378006 329.585999)(29.125000 152.078995 314.976990)(28.466999 153.319000 314.644989)(32.756001 146.725998 316.411987)(32.756001 119.553001 335.701996)(28.466999 112.959000 337.469025)(28.466999 110.371002 327.809998)(32.756001 119.553001 335.701996)(28.466999 110.371002 327.809998)(32.756001 116.965004 326.042999)(32.756001 119.553001 335.701996)(32.756001 116.965004 326.042999)(35.418999 124.314003 324.074005)(28.466999 112.959000 337.469025)(32.756001 119.553001 335.701996)(36.320999 134.639999 331.658997)(32.756001 119.553001 335.701996)(35.418999 126.902000 333.733002)(36.320999 134.639999 331.658997)(37.523003 117.681000 325.850983)(35.418999 124.314003 324.074005)(32.756001 116.965004 326.042999)(28.466999 112.959000 337.469025)(22.767000 104.864998 329.285004)(28.466999 110.371002 327.809998)(41.625599 102.190002 330.002014)(28.466999 110.371002 327.809998)(22.767000 104.864998 329.285004)(-61.307003 82.135002 295.000000)(-61.307003 81.366898 314.500000)(-61.307003 87.268997 334.000000)(31.234100 94.067299 332.179016)(22.767000 104.864998 329.285004)(15.941000 100.722000 330.395996)(15.941000 100.722000 330.395996)(22.767000 104.864998 329.285004)(22.767000 107.453003 338.944000)(15.941000 100.722000 330.395996)(22.756399 92.987000 332.468018)(31.234100 94.067299 332.179016)(52.500000 87.269997 334.000000)(41.625599 102.190002 330.002014)(36.488201 96.500595 331.527008)(15.941000 103.309998 340.054016)(15.941000 100.722000 330.395996)(22.767000 107.453003 338.944000)(15.941000 103.309998 340.054016)(9.968170 98.703896 330.937012)(15.941000 100.722000 330.395996)(15.941000 103.309998 340.054016)(8.331990 100.738998 340.743011)(9.968170 98.703896 330.937012)(36.320999 134.639999 331.658997)(8.331990 100.738998 340.743011)(15.941000 103.309998 340.054016)(0.320996 99.867004 340.977997)(36.320999 134.639999 331.658997)(-7.689010 100.738998 340.743011)(-7.689010 100.738998 340.743011)(-7.689010 98.151100 331.084991)(0.320996 99.867004 340.977997)(-15.297999 100.722000 330.395996)(-7.689010 98.151100 331.084991)(-7.689010 100.738998 340.743011)(-7.689010 98.151100 331.084991)(-15.297999 100.722000 330.395996)(-15.803801 83.706497 334.000000)(-15.297999 100.722000 330.395996)(-27.348400 83.493393 334.000000)(-15.803801 83.706497 334.000000)(-7.689010 98.151100 331.084991)(0.320996 97.278702 331.317993)(0.320996 99.867004 340.977997)(0.320996 97.278702 331.317993)(-7.689010 98.151100 331.084991)(-11.225201 83.688400 334.000000)(-11.225201 83.688400 334.000000)(-7.689010 98.151100 331.084991)(-15.803801 83.706497 334.000000)(8.331990 100.738998 340.743011)(36.320999 134.639999 331.658997)(0.320996 99.867004 340.977997)(22.756399 92.987000 332.468018)(15.941000 100.722000 330.395996)(9.968170 98.703896 330.937012)(-61.307003 82.135002 295.000000)(-61.307003 77.601700 305.225006)(-61.307003 81.366898 314.500000)(-15.297999 103.309998 340.054016)(-7.689010 100.738998 340.743011)(36.320999 134.639999 331.658997)(32.756001 149.727997 327.617004)(28.466999 156.320999 325.850006)(36.320999 134.639999 331.658997)(-34.900597 138.722000 320.212982)(-35.442902 135.364990 321.112976)(-35.679001 132.052002 322.000000)(8.331990 98.151001 331.084991)(9.968170 98.703896 330.937012)(8.331990 100.738998 340.743011)(-15.297999 100.722000 330.395996)(-7.689010 100.738998 340.743011)(-15.297999 103.309998 340.054016)(-19.302401 162.013000 318.217987)(-15.297999 162.968002 312.059998)(-18.009300 161.737000 314.046997)(-28.800501 152.234009 316.592987)(-28.417000 152.822998 316.436005)(-29.125000 152.492996 316.523987)(36.320999 134.639999 331.658997)(-15.297999 165.970001 323.264984)(-22.124001 161.826996 324.375000)(-39.445698 83.375198 334.000000)(-53.764999 100.567001 330.437012)(-61.307003 87.268997 334.000000)(-35.679001 132.052002 322.000000)(-35.659100 131.880997 322.046021)(-35.679001 134.639999 331.658997)(-21.181702 104.293007 329.439026)(-22.124001 104.864998 329.286011)(-26.830200 105.148003 329.210022)(-34.408600 123.300003 324.346008)(-32.113998 119.553001 335.701996)(-34.775997 126.902000 333.733002)(22.767000 104.864998 329.285004)(28.466999 112.959000 337.469025)(22.767000 107.453003 338.944000)(-9.330561 164.985001 311.518982)(-7.359990 165.287003 311.437988)(-0.000008 156.733002 275.011993)(36.488201 96.500595 331.527008)(22.767000 104.864998 329.285004)(31.234100 94.067299 332.179016)(34.237999 132.706009 281.450012)(29.334902 151.681000 315.084015)(33.411201 143.953003 317.154999)(15.941000 165.970001 323.264984)(22.767000 161.826996 324.375000)(22.767000 158.824997 313.169983)(-34.694702 139.601013 318.320984)(-34.237999 142.800003 319.121002)(-34.237999 132.706009 281.450012)(16.541401 162.044998 312.307007)(8.711970 165.080002 311.493011)(8.331990 165.539993 311.369995)(-27.824999 110.371002 327.809998)(-32.639599 114.414001 326.726990)(-39.616997 112.034004 327.365021)(35.272999 136.072998 319.265991)(35.735001 133.255997 320.020996)(36.000000 121.959999 284.329010)(48.346001 107.225998 328.653015)(41.625599 102.190002 330.002014)(52.500000 87.269997 334.000000)(-11.125000 165.125000 313.138977)(-9.330299 165.399994 313.065002)(-9.330561 164.985001 311.518982)(-22.124001 107.453003 338.944000)(-22.124001 104.864998 329.286011)(-21.181702 104.293007 329.439026)(36.488201 96.500595 331.527008)(41.625599 102.190002 330.002014)(22.767000 104.864998 329.285004)(-29.125000 142.399002 278.852997)(-32.476501 145.724991 316.680023)(-31.965799 146.693008 316.420990)(-61.307003 99.044998 330.845001)(-61.307003 88.950996 293.174011)(-61.307003 87.268997 334.000000)(-10.912300 164.865005 313.208984)(-11.125000 165.125000 313.138977)(-13.279699 164.065002 313.423004)(-32.478897 146.133011 318.227997)(-32.476501 146.134003 318.206024)(-32.113998 146.725998 316.411987)(-21.160000 150.092010 276.791016)(-29.125000 142.399002 278.852997)(-29.125000 152.492996 316.523987)(36.320999 134.639999 331.658997)(-34.775997 126.902000 333.733002)(-32.113998 119.553001 335.701996)(-53.764999 100.567001 330.437012)(-61.307003 99.044998 330.845001)(-61.307003 87.268997 334.000000)(34.310299 141.945007 317.692993)(35.272999 136.072998 319.265991)(36.000000 121.959999 284.329010)(-22.124001 159.238998 314.716980)(-22.910900 158.479004 314.920013)(-22.124001 161.826996 324.375000)(-36.000000 132.054001 322.000000)(-35.442902 135.364990 321.112976)(-34.885899 138.848999 320.179993)(15.941000 103.309998 340.054016)(22.767000 107.453003 338.944000)(36.320999 134.639999 331.658997)(-15.297999 100.722000 330.395996)(-45.644997 105.096001 329.223999)(-27.348400 83.493393 334.000000)(-34.675201 122.160004 324.651001)(-36.410000 120.544998 325.084015)(-34.675201 120.702995 325.042023)(-36.410000 120.544998 325.084015)(-32.940300 119.246002 325.432007)(-34.675201 120.702995 325.042023)(-32.940300 119.246002 325.432007)(-34.675201 122.160004 324.651001)(-34.675201 120.702995 325.042023)(-34.760098 139.374008 318.381012)(-34.694702 139.601013 318.320984)(-34.237999 132.706009 281.450012)(36.000000 129.298004 322.738007)(35.980198 130.005997 326.056000)(35.543400 125.382004 323.787994)(-45.644997 105.096001 329.223999)(-15.297999 100.722000 330.395996)(-26.830200 105.148003 329.210022)(-22.124001 104.864998 329.286011)(-25.662201 108.281998 328.369995)(-26.830200 105.148003 329.210022)(-33.789898 142.513000 319.197998)(-34.694702 140.014999 319.867004)(-34.083900 142.904999 323.907990)(36.000000 125.073997 323.869995)(35.418999 124.314003 324.074005)(37.523003 117.681000 325.850983)(36.000000 129.298004 322.738007)(36.320999 131.638000 320.454010)(35.980198 130.005997 326.056000)(-15.014900 162.796005 312.106018)(-13.279600 163.650009 311.877014)(-14.059900 158.708008 294.966003)(-27.824999 112.959000 337.469025)(-32.113998 119.553001 335.701996)(-31.522099 116.055000 326.286987)(36.000000 130.279999 320.817993)(36.000000 123.167000 305.033997)(36.000000 121.959999 284.329010)(32.756001 116.965004 326.042999)(28.466999 110.371002 327.809998)(41.625599 102.190002 330.002014)(-26.830200 105.148003 329.210022)(-25.662201 108.281998 328.369995)(-39.616997 112.034004 327.365021)(29.125000 152.078995 314.976990)(33.411201 143.953003 317.154999)(29.334902 151.681000 315.084015)(-18.009300 161.737000 314.046997)(-20.933599 159.962006 314.523010)(-19.302401 162.013000 318.217987)(0.320995 166.412003 311.136993)(0.320995 169.414001 322.342010)(8.331990 165.539993 311.369995)(32.756001 116.965004 326.042999)(41.625599 102.190002 330.002014)(37.523003 117.681000 325.850983)(22.756399 92.987000 332.468018)(9.968170 98.703896 330.937012)(8.331990 98.151001 331.084991)(36.000000 128.884003 321.191986)(36.000000 129.298004 322.738007)(36.000000 125.073997 323.869995)(-27.348400 83.493393 334.000000)(-45.644997 105.096001 329.223999)(-39.445698 83.375198 334.000000)(36.320999 134.639999 331.658997)(22.767000 107.453003 338.944000)(28.466999 112.959000 337.469025)(-34.237999 132.706009 281.450012)(-34.885899 138.433990 318.632996)(-34.760098 139.374008 318.381012)(-32.113998 116.965004 326.042999)(-31.522099 116.055000 326.286987)(-32.113998 119.553001 335.701996)(-36.000000 132.054001 322.000000)(-34.237999 132.706009 281.450012)(-36.000000 121.959999 284.329010)(37.521999 107.587006 288.179993)(36.000000 114.979996 286.199005)(36.000000 125.073997 323.869995)(-9.330299 165.399994 313.065002)(-11.125000 165.125000 313.138977)(-10.912300 164.865005 313.208984)(-34.805099 124.564003 324.007996)(-35.554401 130.983994 322.286987)(-36.000000 125.073997 323.870972)(15.941000 162.968002 312.059998)(16.541401 162.044998 312.307007)(8.331990 165.539993 311.369995)(32.756001 146.725998 316.411987)(28.466999 156.320999 325.850006)(32.756001 149.727997 327.617004)(-22.910900 158.479004 314.920013)(-27.824999 156.320999 325.850006)(-22.124001 161.826996 324.375000)(-20.933599 159.962006 314.523010)(-21.160000 160.185989 314.462982)(-22.124001 159.238998 314.716980)(29.125000 142.399002 278.852997)(29.125000 152.078995 314.976990)(29.334902 151.681000 315.084015)(0.456574 166.343002 311.154999)(8.711970 165.080002 311.493011)(11.124000 155.031998 275.467987)(-34.694702 139.601013 318.320984)(-34.694702 140.014999 319.867004)(-34.237999 142.800003 319.121002)(8.331990 168.541992 322.575012)(15.941000 162.968002 312.059998)(8.331990 165.539993 311.369995)(-29.125000 142.399002 278.852997)(-31.965799 146.693008 316.420990)(-31.239100 148.070999 316.052002)(52.500000 106.054001 328.967010)(48.346001 107.225998 328.653015)(52.500000 87.269997 334.000000)(-18.009300 161.737000 314.046997)(-15.297999 162.968002 312.059998)(-18.009399 161.321991 312.501007)(-0.807269 166.289001 311.170013)(0.320995 169.414001 322.342010)(0.320995 166.412003 311.136993)(35.418999 126.902000 333.733002)(32.756001 119.553001 335.701996)(35.418999 124.314003 324.074005)(52.500000 87.269997 334.000000)(36.488201 96.500595 331.527008)(31.234100 94.067299 332.179016)(31.234100 94.067299 332.179016)(22.756399 92.987000 332.468018)(52.500000 87.269997 334.000000)(22.756399 92.987000 332.468018)(41.496601 84.434998 334.000000)(52.500000 87.269997 334.000000)(11.392000 83.905502 334.000000)(41.496601 84.434998 334.000000)(22.756399 92.987000 332.468018)(15.544200 91.055000 332.675995)(11.392000 83.905502 334.000000)(22.756399 92.987000 332.468018)(15.544200 91.055000 332.675995)(8.331990 98.151001 331.084991)(11.392000 83.905502 334.000000)(15.544200 91.055000 332.675995)(22.756399 92.987000 332.468018)(8.331990 98.151001 331.084991)(8.331990 98.151001 331.084991)(8.331990 100.738998 340.743011)(0.320996 97.278702 331.317993)(8.331990 98.151001 331.084991)(0.320996 97.278702 331.317993)(1.062120 83.916298 334.000000)(0.320996 99.867004 340.977997)(0.320996 97.278702 331.317993)(8.331990 100.738998 340.743011)(8.331990 98.151001 331.084991)(1.062120 83.916298 334.000000)(11.392000 83.905502 334.000000)(1.062120 83.916298 334.000000)(0.320996 97.278702 331.317993)(-11.225201 83.688400 334.000000)(-53.764999 90.473007 292.765991)(-61.307003 82.135002 295.000000)(-61.307003 88.950996 293.174011)(-61.307003 82.135002 295.000000)(-61.307003 77.163399 302.778992)(-61.307003 77.601700 305.225006)(-61.307003 82.135002 295.000000)(-61.307003 75.464706 295.000000)(-61.307003 77.163399 302.778992)(-59.974903 75.463303 295.000000)(-60.119099 75.463501 295.000000)(-61.307003 82.135002 295.000000)(-60.119099 75.463501 295.000000)(-61.307003 75.464706 295.000000)(-61.307003 82.135002 295.000000)(-58.339001 79.063202 295.000000)(-59.974903 75.463303 295.000000)(-61.307003 82.135002 295.000000)(-58.339001 79.063202 295.000000)(-61.307003 82.135002 295.000000)(-58.258198 79.227295 295.000000)(-58.258198 79.227295 295.000000)(-61.307003 82.135002 295.000000)(-56.825802 82.135002 295.000000)(-55.224003 85.168999 294.187012)(-56.825802 82.135002 295.000000)(-61.307003 82.135002 295.000000)(-55.224003 85.168999 294.187012)(-61.307003 82.135002 295.000000)(-53.764999 90.473007 292.765991)(-39.209000 99.082001 290.459015)(-39.616997 101.939995 289.694000)(-35.427002 106.377998 288.503998)(-39.209000 99.082001 290.459015)(-45.644997 95.002007 291.552979)(-39.616997 101.939995 289.694000)(-45.644997 95.002007 291.552979)(-50.446999 89.918999 292.914001)(-53.764999 90.473007 292.765991)(-39.209000 99.082001 290.459015)(-45.139999 93.271004 292.015991)(-45.644997 95.002007 291.552979)(-45.644997 95.002007 291.552979)(-47.857002 91.569000 292.472015)(-50.446999 89.918999 292.914001)(-58.944603 75.462196 295.000000)(-59.974903 75.463303 295.000000)(-58.339001 79.063202 295.000000)(-45.139999 93.271004 292.015991)(-47.857002 91.569000 292.472015)(-45.644997 95.002007 291.552979)(-35.427002 106.377998 288.503998)(-39.616997 101.939995 289.694000)(-36.410000 110.451996 287.412994)(-50.446999 89.918999 292.914001)(-55.224003 85.168999 294.187012)(-53.764999 90.473007 292.765991)(-32.311996 134.179993 281.053986)(-34.237999 132.706009 281.450012)(-29.125000 142.399002 278.852997)(-28.139999 141.634995 279.057007)(-32.311996 134.179993 281.053986)(-29.125000 142.399002 278.852997)(-34.164997 114.445999 286.341980)(-36.410000 110.451996 287.412994)(-36.000000 114.979996 286.199982)(-34.432999 125.957001 283.257996)(-36.000000 121.959999 284.329010)(-34.237999 132.706009 281.450012)(-32.311996 134.179993 281.053986)(-34.432999 125.957001 283.257996)(-34.237999 132.706009 281.450012)(-34.387997 117.612999 285.492981)(-36.000000 121.959999 284.329010)(-34.432999 125.957001 283.257996)(-34.387997 117.612999 285.492981)(-36.000000 114.979996 286.199982)(-36.000000 121.959999 284.329010)(-34.164997 114.445999 286.341980)(-36.000000 114.979996 286.199982)(-34.387997 117.612999 285.492981)(-0.000008 156.733002 275.011993)(2.270990 155.713013 275.285004)(-6.481010 155.121002 275.442993)(-20.121698 149.134003 277.048004)(-22.179001 147.852997 277.390991)(-21.160000 150.092010 276.791016)(-14.805000 152.445007 276.160004)(-20.121698 149.134003 277.048004)(-21.160000 150.092010 276.791016)(-22.179001 147.852997 277.390991)(-29.125000 142.399002 278.852997)(-21.160000 150.092010 276.791016)(-11.125000 155.031998 275.467987)(-6.481010 155.121002 275.442993)(-14.805000 152.445007 276.160004)(-22.179001 147.852997 277.390991)(-28.139999 141.634995 279.057007)(-29.125000 142.399002 278.852997)(-35.427002 106.377998 288.503998)(-36.410000 110.451996 287.412994)(-34.164997 114.445999 286.341980)(-14.805000 152.445007 276.160004)(-21.160000 150.092010 276.791016)(-11.125000 155.031998 275.467987)(-0.000008 156.733002 275.011993)(-6.481010 155.121002 275.442993)(-11.125000 155.031998 275.467987)(52.500000 82.135002 295.000000)(52.500000 81.335899 314.500000)(52.500000 75.987099 297.262024)(52.500000 87.269997 334.000000)(52.500000 81.335899 314.500000)(52.500000 82.135002 295.000000)(37.521999 107.587006 288.179993)(31.111000 105.881996 288.637024)(34.283001 113.783005 286.520020)(22.327799 96.009796 291.282013)(52.500000 82.135002 295.000000)(20.062700 94.173401 291.774994)(52.500000 82.135002 295.000000)(26.004999 98.990997 290.483002)(29.344400 103.497993 289.276001)(26.004999 98.990997 290.483002)(52.500000 82.135002 295.000000)(22.327799 96.009796 291.282013)(19.284901 93.542801 291.944000)(20.062700 94.173401 291.774994)(52.500000 82.135002 295.000000)(37.521999 107.587006 288.179993)(29.344400 103.497993 289.276001)(31.111000 105.881996 288.637024)(10.900001 154.184006 275.694000)(2.270990 155.713013 275.285004)(-0.000008 156.733002 275.011993)(11.124000 155.031998 275.467987)(10.900001 154.184006 275.694000)(-0.000008 156.733002 275.011993)(18.865000 150.630005 276.645996)(10.900001 154.184006 275.694000)(11.124000 155.031998 275.467987)(29.125000 142.399002 278.852997)(25.664000 145.274994 278.080994)(21.160000 150.092010 276.791016)(30.872000 138.455002 279.910004)(25.664000 145.274994 278.080994)(29.125000 142.399002 278.852997)(34.237999 132.706009 281.450012)(30.872000 138.455002 279.910004)(29.125000 142.399002 278.852997)(35.320000 122.197998 284.265015)(34.159000 130.597992 282.014008)(34.237999 132.706009 281.450012)(34.159000 130.597992 282.014008)(30.872000 138.455002 279.910004)(34.237999 132.706009 281.450012)(36.000000 121.959999 284.329010)(35.320000 122.197998 284.265015)(34.237999 132.706009 281.450012)(36.000000 114.979996 286.199005)(34.283001 113.783005 286.520020)(35.320000 122.197998 284.265015)(36.000000 121.959999 284.329010)(36.000000 114.979996 286.199005)(35.320000 122.197998 284.265015)(41.857998 101.320000 289.860016)(52.500000 82.135002 295.000000)(29.344400 103.497993 289.276001)(41.857998 101.320000 289.860016)(35.601200 104.452995 289.019989)(37.521999 107.587006 288.179993)(35.601200 104.452995 289.019989)(41.857998 101.320000 289.860016)(29.344400 103.497993 289.276001)(52.500000 95.959999 291.296021)(52.500000 82.135002 295.000000)(48.346001 97.133003 290.981995)(48.346001 97.133003 290.981995)(52.500000 82.135002 295.000000)(41.857998 101.320000 289.860016)(36.000000 114.979996 286.199005)(37.521999 107.587006 288.179993)(34.283001 113.783005 286.520020)(52.500000 82.135002 295.000000)(7.256990 88.820999 293.208008)(11.373000 89.879997 292.923981)(7.256990 88.820999 293.208008)(52.500000 82.135002 295.000000)(-9.491710 77.874603 295.000000)(52.500000 82.135002 295.000000)(41.411198 76.998001 295.000000)(28.827499 76.776695 295.000000)(52.500000 82.135002 295.000000)(28.827499 76.776695 295.000000)(-9.491710 77.874603 295.000000)(47.652699 75.137901 295.000000)(41.411198 76.998001 295.000000)(52.500000 82.135002 295.000000)(49.063000 75.113701 295.000000)(47.652699 75.137901 295.000000)(52.500000 82.135002 295.000000)(51.340302 75.074501 295.000000)(49.063000 75.113701 295.000000)(52.500000 82.135002 295.000000)(52.500000 75.401794 295.000000)(51.340302 75.074501 295.000000)(52.500000 82.135002 295.000000)(52.500000 82.135002 295.000000)(52.500000 75.750999 296.348999)(52.500000 75.401794 295.000000)(36.000000 121.959999 284.329010)(36.000000 123.167000 305.033997)(36.000000 114.979996 286.199005)(21.160000 150.092010 276.791016)(25.664000 145.274994 278.080994)(18.865000 150.630005 276.645996)(52.500000 82.135002 295.000000)(52.500000 75.987099 297.262024)(52.500000 75.750999 296.348999)(37.521999 107.587006 288.179993)(35.601200 104.452995 289.019989)(29.344400 103.497993 289.276001)(19.284901 93.542801 291.944000)(52.500000 82.135002 295.000000)(11.373000 89.879997 292.923981)(21.160000 150.092010 276.791016)(18.865000 150.630005 276.645996)(11.124000 155.031998 275.467987)(-9.491710 77.874603 295.000000)(0.508551 86.214401 293.906982)(7.256990 88.820999 293.208008)(-10.356000 76.087494 295.000000)(-9.491710 77.874603 295.000000)(28.827499 76.776695 295.000000)(-61.307003 81.366898 314.500000)(-61.307003 78.823700 310.820007)(-61.307003 79.329498 313.720001)(-61.307003 77.601700 305.225006)(-61.307003 78.823700 310.820007)(-61.307003 81.366898 314.500000)(-61.307003 87.268997 334.000000)(-61.307003 82.820702 332.976013)(-61.307003 83.014198 334.000000)(-61.307003 83.014198 334.000000)(-58.542400 83.028801 334.000000)(-61.307003 87.268997 334.000000)(-61.307003 87.268997 334.000000)(-61.307003 81.329002 324.300995)(-61.307003 82.618805 331.907013)(-61.307003 87.268997 334.000000)(-61.307003 82.618805 331.907013)(-61.307003 82.820702 332.976013)(-58.203102 83.030594 334.000000)(-39.445698 83.375198 334.000000)(-61.307003 87.268997 334.000000)(-58.542400 83.028801 334.000000)(-58.203102 83.030594 334.000000)(-61.307003 87.268997 334.000000)(-61.307003 81.366898 314.500000)(-61.307003 79.329498 313.720001)(-61.307003 81.329002 324.300995)(-61.307003 81.366898 314.500000)(-61.307003 81.329002 324.300995)(-61.307003 87.268997 334.000000)(52.500000 82.581001 334.000000)(52.500000 87.269997 334.000000)(45.727802 83.584702 334.000000)(52.500000 87.269997 334.000000)(41.496601 84.434998 334.000000)(45.727802 83.584702 334.000000)(52.500000 87.269997 334.000000)(52.500000 82.378998 332.873993)(52.500000 81.335899 314.500000)(52.500000 87.269997 334.000000)(52.500000 82.581001 334.000000)(52.500000 82.378998 332.873993)(52.500000 81.335899 314.500000)(52.500000 82.378998 332.873993)(52.500000 75.987099 297.262024)(-36.000000 -114.979996 286.199982)(-36.000000 -121.959999 284.329010)(-36.000000 -125.073997 323.870972)(-36.000000 -114.979996 286.199982)(-36.000000 -125.073997 323.870972)(-36.410000 -120.544998 325.084015)(-21.160000 -160.185989 314.462982)(-29.125000 -152.492996 316.523987)(-21.160000 -150.092010 276.791016)(-29.125000 -142.399002 278.852997)(-21.160000 -150.092010 276.791016)(-29.125000 -152.492996 316.523987)(-61.307003 -87.268997 334.000000)(-61.307003 -88.950996 293.174011)(-61.307003 -99.044998 330.845001)(-53.764999 -90.473007 292.765991)(-61.307003 -99.044998 330.845001)(-61.307003 -88.950996 293.174011)(-61.307003 -99.044998 330.845001)(-53.764999 -90.473007 292.765991)(-53.764999 -100.567001 330.437012)(-61.307003 -82.135002 295.000000)(-61.307003 -88.950996 293.174011)(-61.307003 -87.268997 334.000000)(-61.307003 -77.601700 305.225006)(-61.307003 -77.163399 302.778992)(-61.307003 -82.135002 295.000000)(-61.307003 -81.366898 314.500000)(-61.307003 -77.601700 305.225006)(-61.307003 -82.135002 295.000000)(-61.307003 -87.268997 334.000000)(-61.307003 -81.366898 314.500000)(-61.307003 -82.135002 295.000000)(-61.307003 -75.464706 295.000000)(-61.307003 -82.135002 295.000000)(-61.307003 -77.163399 302.778992)(-61.307003 -82.135002 295.000000)(-61.307003 -75.464706 295.000000)(-60.119099 -75.463501 295.000000)(-58.339001 -79.063202 295.000000)(-61.307003 -82.135002 295.000000)(-59.974903 -75.463303 295.000000)(-58.258198 -79.227295 295.000000)(-61.307003 -82.135002 295.000000)(-58.339001 -79.063202 295.000000)(34.237999 -132.706009 281.450012)(36.000000 -121.959999 284.329010)(34.310299 -141.945007 317.692993)(34.237999 -132.706009 281.450012)(34.310299 -141.945007 317.692993)(34.237999 -142.386002 317.575012)(-32.476501 -145.724991 316.680023)(-32.476501 -146.134003 318.206024)(-34.237999 -142.800003 319.121002)(-29.125000 -142.399002 278.852997)(-32.476501 -145.724991 316.680023)(-34.237999 -142.800003 319.121002)(32.756001 -119.553001 335.701996)(35.418999 -124.314003 324.074005)(32.756001 -116.965004 326.042999)(37.523003 -117.681000 325.850983)(32.756001 -116.965004 326.042999)(35.418999 -124.314003 324.074005)(37.523003 -117.681000 325.850983)(35.418999 -124.314003 324.074005)(36.000000 -125.073997 323.869995)(37.523003 -117.681000 325.850983)(36.000000 -125.073997 323.869995)(37.521999 -107.587006 288.179993)(36.000000 -129.298004 322.738007)(35.543400 -125.382004 323.787994)(35.980198 -130.005997 326.056000)(36.320999 -131.638000 320.454010)(36.000000 -129.298004 322.738007)(35.980198 -130.005997 326.056000)(35.543400 -125.382004 323.787994)(36.000000 -129.298004 322.738007)(36.000000 -125.073997 323.869995)(36.000000 -128.884003 321.191986)(36.000000 -129.298004 322.738007)(36.320999 -131.638000 320.454010)(36.000000 -125.073997 323.869995)(36.000000 -129.298004 322.738007)(36.000000 -128.884003 321.191986)(36.000000 -125.073997 323.869995)(36.000000 -123.167000 305.033997)(36.000000 -114.979996 286.199005)(36.000000 -125.073997 323.869995)(36.000000 -128.884003 321.191986)(36.000000 -123.167000 305.033997)(36.000000 -125.073997 323.869995)(36.000000 -114.979996 286.199005)(37.521999 -107.587006 288.179993)(36.000000 -128.884003 321.191986)(36.000000 -130.279999 320.817993)(36.000000 -123.167000 305.033997)(35.418999 -124.314003 324.074005)(35.543400 -125.382004 323.787994)(36.000000 -125.073997 323.869995)(37.521999 -107.587006 288.179993)(41.857998 -101.320000 289.860016)(37.523003 -117.681000 325.850983)(41.625599 -102.190002 330.002014)(32.756001 -116.965004 326.042999)(37.523003 -117.681000 325.850983)(41.857998 -111.414001 327.531006)(41.625599 -102.190002 330.002014)(37.523003 -117.681000 325.850983)(36.000000 -130.279999 320.817993)(36.000000 -121.959999 284.329010)(36.000000 -123.167000 305.033997)(-32.478897 -146.133011 318.227997)(-33.357201 -144.326004 318.712006)(-34.237999 -142.800003 319.121002)(-33.789898 -142.513000 319.197998)(-33.357201 -144.326004 318.712006)(-32.478897 -146.133011 318.227997)(-33.789898 -142.513000 319.197998)(-32.478897 -146.133011 318.227997)(-34.083900 -142.904999 323.907990)(-33.789898 -142.513000 319.197998)(-34.237999 -142.800003 319.121002)(-33.357201 -144.326004 318.712006)(-32.940300 -119.246002 325.432007)(-34.675201 -122.160004 324.651001)(-34.408600 -123.300003 324.346008)(-34.408600 -123.300003 324.346008)(-34.675201 -122.160004 324.651001)(-36.000000 -125.073997 323.870972)(-34.675201 -122.160004 324.651001)(-36.410000 -120.544998 325.084015)(-36.000000 -125.073997 323.870972)(-34.775997 -124.314003 324.075012)(-34.408600 -123.300003 324.346008)(-36.000000 -125.073997 323.870972)(-35.554401 -130.983994 322.286987)(-36.000000 -125.073997 323.870972)(-36.000000 -132.054001 322.000000)(-34.805099 -124.564003 324.007996)(-36.000000 -125.073997 323.870972)(-35.554401 -130.983994 322.286987)(-34.805099 -124.564003 324.007996)(-34.775997 -124.314003 324.075012)(-36.000000 -125.073997 323.870972)(-34.675201 -122.160004 324.651001)(-32.940300 -119.246002 325.432007)(-34.675201 -120.702995 325.042023)(-32.940300 -119.246002 325.432007)(-36.410000 -120.544998 325.084015)(-34.675201 -120.702995 325.042023)(-36.410000 -120.544998 325.084015)(-34.675201 -122.160004 324.651001)(-34.675201 -120.702995 325.042023)(-32.113998 -116.965004 326.042999)(-32.639599 -114.414001 326.726990)(-36.410000 -120.544998 325.084015)(-32.940300 -119.246002 325.432007)(-32.113998 -116.965004 326.042999)(-36.410000 -120.544998 325.084015)(-32.940300 -119.246002 325.432007)(-34.408600 -123.300003 324.346008)(-32.868797 -120.264999 330.024017)(-35.679001 -132.052002 322.000000)(-35.442902 -135.364990 321.112976)(-34.900597 -138.722000 320.212982)(-35.679001 -132.052002 322.000000)(-36.000000 -132.054001 322.000000)(-35.442902 -135.364990 321.112976)(-34.900597 -138.722000 320.212982)(-35.442902 -135.364990 321.112976)(-34.885899 -138.848999 320.179993)(-35.554401 -130.983994 322.286987)(-35.659100 -131.880997 322.046021)(-35.679001 -134.639999 331.658997)(-35.554401 -130.983994 322.286987)(-35.679001 -134.639999 331.658997)(-34.775997 -126.902000 333.733002)(36.320999 -134.639999 331.658997)(-34.775997 -126.902000 333.733002)(-35.679001 -134.639999 331.658997)(-34.885899 -138.848999 320.179993)(-34.760098 -139.374008 318.381012)(-34.775997 -142.378006 329.585999)(-34.900597 -138.722000 320.212982)(-34.885899 -138.848999 320.179993)(-34.775997 -142.378006 329.585999)(-34.900597 -138.722000 320.212982)(-34.775997 -142.378006 329.585999)(-35.679001 -134.639999 331.658997)(36.320999 -134.639999 331.658997)(-35.679001 -134.639999 331.658997)(-34.775997 -142.378006 329.585999)(-32.478897 -146.133011 318.227997)(-32.113998 -146.725998 316.411987)(-32.113998 -149.727997 327.617004)(-32.478897 -146.133011 318.227997)(-32.113998 -149.727997 327.617004)(-34.775997 -142.378006 329.585999)(36.320999 -134.639999 331.658997)(-34.775997 -142.378006 329.585999)(-32.113998 -149.727997 327.617004)(-32.113998 -146.725998 316.411987)(-30.908501 -150.165009 321.833984)(-32.113998 -149.727997 327.617004)(-32.113998 -146.725998 316.411987)(-31.239201 -148.485001 317.597992)(-30.908501 -150.165009 321.833984)(-31.239100 -148.070999 316.052002)(-31.239201 -148.485001 317.597992)(-32.113998 -146.725998 316.411987)(-31.239100 -148.070999 316.052002)(-29.125000 -152.492996 316.523987)(-31.239201 -148.485001 317.597992)(-29.125000 -142.399002 278.852997)(-29.125000 -152.492996 316.523987)(-31.239100 -148.070999 316.052002)(-29.125000 -142.399002 278.852997)(-31.239100 -148.070999 316.052002)(-31.965799 -146.693008 316.420990)(-31.239201 -148.485001 317.597992)(-28.800501 -152.234009 316.592987)(-30.908501 -150.165009 321.833984)(-28.800501 -152.234009 316.592987)(-31.239201 -148.485001 317.597992)(-29.125000 -152.492996 316.523987)(-22.910900 -158.479004 314.920013)(-29.125000 -152.492996 316.523987)(-27.824999 -153.733002 316.191986)(-22.124001 -159.238998 314.716980)(-29.125000 -152.492996 316.523987)(-22.910900 -158.479004 314.920013)(-28.417000 -152.822998 316.436005)(-29.125000 -152.492996 316.523987)(-27.824999 -153.733002 316.191986)(-28.417000 -152.822998 316.436005)(-27.824999 -153.733002 316.191986)(-27.824999 -156.320999 325.850006)(-22.910900 -158.479004 314.920013)(-22.124001 -159.238998 314.716980)(-22.124001 -161.826996 324.375000)(-22.910900 -158.479004 314.920013)(-22.124001 -161.826996 324.375000)(-27.824999 -156.320999 325.850006)(-28.417000 -152.822998 316.436005)(-28.800501 -152.234009 316.592987)(-29.125000 -152.492996 316.523987)(-34.775997 -126.902000 333.733002)(-32.113998 -119.553001 335.701996)(-34.408600 -123.300003 324.346008)(-32.113998 -119.553001 335.701996)(-32.868797 -120.264999 330.024017)(-34.408600 -123.300003 324.346008)(36.320999 -134.639999 331.658997)(-32.113998 -119.553001 335.701996)(-34.775997 -126.902000 333.733002)(-31.965799 -146.693008 316.420990)(-31.239100 -148.070999 316.052002)(-32.113998 -146.725998 316.411987)(-31.965799 -146.693008 316.420990)(-32.113998 -146.725998 316.411987)(-32.476501 -145.724991 316.680023)(-35.679001 -132.052002 322.000000)(-34.900597 -138.722000 320.212982)(-35.679001 -134.639999 331.658997)(36.320999 -134.639999 331.658997)(-27.824999 -112.959000 337.469025)(-32.113998 -119.553001 335.701996)(-32.113998 -119.553001 335.701996)(-27.824999 -112.959000 337.469025)(-31.522099 -116.055000 326.286987)(-27.824999 -112.959000 337.469025)(-27.824999 -110.371002 327.809998)(-31.522099 -116.055000 326.286987)(-27.038200 -109.611000 328.013977)(-27.824999 -110.371002 327.809998)(-27.824999 -112.959000 337.469025)(-27.824999 -110.371002 327.809998)(-27.038200 -109.611000 328.013977)(-39.616997 -112.034004 327.365021)(-27.038200 -109.611000 328.013977)(-25.662201 -108.281998 328.369995)(-39.616997 -112.034004 327.365021)(-25.662201 -108.281998 328.369995)(-27.038200 -109.611000 328.013977)(-23.934601 -107.862999 333.478973)(-32.639599 -114.414001 326.726990)(-27.824999 -110.371002 327.809998)(-39.616997 -112.034004 327.365021)(-34.885899 -138.848999 320.179993)(-35.442902 -135.364990 321.112976)(-36.000000 -132.054001 322.000000)(-61.307003 -87.268997 334.000000)(-53.764999 -100.567001 330.437012)(-39.445698 -83.375198 334.000000)(-39.616997 -101.939995 289.694000)(-36.410000 -110.451996 287.412994)(-39.616997 -112.034004 327.365021)(-36.410000 -120.544998 325.084015)(-39.616997 -112.034004 327.365021)(-36.410000 -110.451996 287.412994)(-39.616997 -101.939995 289.694000)(-39.616997 -112.034004 327.365021)(-45.644997 -105.096001 329.223999)(-45.644997 -95.002007 291.552979)(-39.616997 -101.939995 289.694000)(-45.644997 -105.096001 329.223999)(-36.410000 -110.451996 287.412994)(-36.000000 -114.979996 286.199982)(-36.410000 -120.544998 325.084015)(-26.830200 -105.148003 329.210022)(-45.644997 -105.096001 329.223999)(-39.616997 -112.034004 327.365021)(-22.124001 -107.453003 338.944000)(-21.181702 -104.293007 329.439026)(-22.124001 -104.864998 329.286011)(-21.181702 -104.293007 329.439026)(-22.124001 -107.453003 338.944000)(-15.297999 -103.309998 340.054016)(15.941000 -103.309998 340.054016)(15.941000 -100.722000 330.395996)(9.968170 -98.703896 330.937012)(8.331990 -100.738998 340.743011)(15.941000 -103.309998 340.054016)(9.968170 -98.703896 330.937012)(9.968170 -98.703896 330.937012)(15.941000 -100.722000 330.395996)(22.756399 -92.987000 332.468018)(31.234100 -94.067299 332.179016)(22.756399 -92.987000 332.468018)(15.941000 -100.722000 330.395996)(36.320999 -134.639999 331.658997)(-15.297999 -103.309998 340.054016)(-22.124001 -107.453003 338.944000)(-7.689010 -100.738998 340.743011)(0.320996 -99.867004 340.977997)(-7.689010 -98.151100 331.084991)(-7.689010 -98.151100 331.084991)(-15.297999 -100.722000 330.395996)(-7.689010 -100.738998 340.743011)(-7.689010 -98.151100 331.084991)(0.320996 -99.867004 340.977997)(0.320996 -97.278702 331.317993)(1.062120 -83.916298 334.000000)(-11.225201 -83.688400 334.000000)(0.320996 -97.278702 331.317993)(0.320996 -97.278702 331.317993)(-11.225201 -83.688400 334.000000)(-7.689010 -98.151100 331.084991)(-11.225201 -83.688400 334.000000)(-15.803801 -83.706497 334.000000)(-7.689010 -98.151100 331.084991)(11.392000 -83.905502 334.000000)(1.062120 -83.916298 334.000000)(8.331990 -98.151001 331.084991)(15.544200 -91.055000 332.675995)(8.331990 -98.151001 331.084991)(22.756399 -92.987000 332.468018)(15.544200 -91.055000 332.675995)(11.392000 -83.905502 334.000000)(8.331990 -98.151001 331.084991)(15.544200 -91.055000 332.675995)(22.756399 -92.987000 332.468018)(11.392000 -83.905502 334.000000)(52.500000 -87.269997 334.000000)(22.756399 -92.987000 332.468018)(31.234100 -94.067299 332.179016)(52.500000 -87.269997 334.000000)(41.496601 -84.434998 334.000000)(22.756399 -92.987000 332.468018)(11.392000 -83.905502 334.000000)(22.756399 -92.987000 332.468018)(41.496601 -84.434998 334.000000)(1.062120 -83.916298 334.000000)(0.320996 -97.278702 331.317993)(8.331990 -98.151001 331.084991)(8.331990 -100.738998 340.743011)(8.331990 -98.151001 331.084991)(0.320996 -97.278702 331.317993)(-15.297999 -100.722000 330.395996)(-27.348400 -83.493393 334.000000)(-45.644997 -105.096001 329.223999)(-15.803801 -83.706497 334.000000)(-27.348400 -83.493393 334.000000)(-15.297999 -100.722000 330.395996)(-26.830200 -105.148003 329.210022)(-15.297999 -100.722000 330.395996)(-45.644997 -105.096001 329.223999)(-21.181702 -104.293007 329.439026)(-15.297999 -100.722000 330.395996)(-26.830200 -105.148003 329.210022)(-15.297999 -103.309998 340.054016)(-15.297999 -100.722000 330.395996)(-21.181702 -104.293007 329.439026)(-34.760098 -139.374008 318.381012)(-34.694702 -139.601013 318.320984)(-34.694702 -140.014999 319.867004)(-34.694702 -139.601013 318.320984)(-34.237999 -142.800003 319.121002)(-34.694702 -140.014999 319.867004)(-33.789898 -142.513000 319.197998)(-34.694702 -140.014999 319.867004)(-34.237999 -142.800003 319.121002)(-34.694702 -139.601013 318.320984)(-34.760098 -139.374008 318.381012)(-34.237999 -132.706009 281.450012)(-36.000000 -121.959999 284.329010)(-34.237999 -132.706009 281.450012)(-36.000000 -132.054001 322.000000)(-34.237999 -132.706009 281.450012)(-34.885899 -138.433990 318.632996)(-36.000000 -132.054001 322.000000)(-34.760098 -139.374008 318.381012)(-34.885899 -138.433990 318.632996)(-34.237999 -132.706009 281.450012)(-34.885899 -138.433990 318.632996)(-34.760098 -139.374008 318.381012)(-34.885899 -138.799988 319.997009)(-34.885899 -138.433990 318.632996)(-34.885899 -138.799988 319.997009)(-36.000000 -132.054001 322.000000)(-34.885899 -138.799988 319.997009)(-34.885899 -138.848999 320.179993)(-36.000000 -132.054001 322.000000)(-34.237999 -142.800003 319.121002)(-34.237999 -132.706009 281.450012)(-29.125000 -142.399002 278.852997)(-39.209000 -99.082001 290.459015)(-39.616997 -101.939995 289.694000)(-45.644997 -95.002007 291.552979)(-28.800501 -152.234009 316.592987)(-28.417000 -152.822998 316.436005)(-30.908501 -150.165009 321.833984)(-34.237999 -132.706009 281.450012)(-34.237999 -142.800003 319.121002)(-34.694702 -139.601013 318.320984)(22.767000 -107.453003 338.944000)(15.941000 -100.722000 330.395996)(15.941000 -103.309998 340.054016)(22.767000 -107.453003 338.944000)(22.767000 -104.864998 329.285004)(15.941000 -100.722000 330.395996)(22.767000 -104.864998 329.285004)(22.767000 -107.453003 338.944000)(28.466999 -112.959000 337.469025)(28.466999 -112.959000 337.469025)(32.756001 -119.553001 335.701996)(28.466999 -110.371002 327.809998)(22.767000 -104.864998 329.285004)(28.466999 -112.959000 337.469025)(28.466999 -110.371002 327.809998)(35.543400 -125.382004 323.787994)(35.418999 -126.902000 333.733002)(36.320999 -134.639999 331.658997)(36.000000 -121.959999 284.329010)(35.735001 -133.255997 320.020996)(35.272999 -136.072998 319.265991)(36.000000 -121.959999 284.329010)(36.000000 -130.279999 320.817993)(35.735001 -133.255997 320.020996)(36.320999 -131.638000 320.454010)(35.735001 -133.255997 320.020996)(36.000000 -130.279999 320.817993)(35.272999 -136.072998 319.265991)(35.735001 -133.255997 320.020996)(36.320999 -131.638000 320.454010)(22.767000 -158.824997 313.169983)(21.160000 -159.771988 312.916016)(21.486799 -159.455994 313.001007)(15.941000 -162.968002 312.059998)(21.160000 -159.771988 312.916016)(22.767000 -158.824997 313.169983)(21.486799 -159.455994 313.001007)(21.160000 -159.771988 312.916016)(21.160000 -150.092010 276.791016)(21.160000 -150.092010 276.791016)(21.160000 -159.771988 312.916016)(16.541401 -162.044998 312.307007)(15.941000 -165.970001 323.264984)(15.941000 -162.968002 312.059998)(22.767000 -158.824997 313.169983)(15.941000 -165.970001 323.264984)(8.331990 -168.541992 322.575012)(15.941000 -162.968002 312.059998)(8.331990 -165.539993 311.369995)(16.541401 -162.044998 312.307007)(15.941000 -162.968002 312.059998)(8.331990 -165.539993 311.369995)(15.941000 -162.968002 312.059998)(8.331990 -168.541992 322.575012)(0.320995 -169.414001 322.342010)(8.331990 -165.539993 311.369995)(8.331990 -168.541992 322.575012)(0.320995 -166.412003 311.136993)(8.331990 -165.539993 311.369995)(0.320995 -169.414001 322.342010)(8.331990 -165.539993 311.369995)(8.711970 -165.080002 311.493011)(16.541401 -162.044998 312.307007)(0.456574 -166.343002 311.154999)(11.124000 -155.031998 275.467987)(8.711970 -165.080002 311.493011)(8.711970 -165.080002 311.493011)(8.331990 -165.539993 311.369995)(0.456574 -166.343002 311.154999)(8.711970 -165.080002 311.493011)(11.124000 -155.031998 275.467987)(21.160000 -150.092010 276.791016)(8.331990 -165.539993 311.369995)(0.320995 -166.412003 311.136993)(0.456574 -166.343002 311.154999)(-0.000008 -156.733002 275.011993)(11.124000 -155.031998 275.467987)(0.456574 -166.343002 311.154999)(-0.807269 -166.289001 311.170013)(0.320995 -166.412003 311.136993)(0.320995 -169.414001 322.342010)(0.456574 -166.343002 311.154999)(-0.807269 -166.289001 311.170013)(0.320995 -166.412003 311.136993)(-0.807269 -166.289001 311.170013)(0.320995 -169.414001 322.342010)(-7.689010 -168.541992 322.575012)(-0.000008 -156.733002 275.011993)(-11.125000 -165.125000 313.138977)(-11.125000 -155.031998 275.467987)(-11.125000 -165.125000 313.138977)(-0.000008 -156.733002 275.011993)(-9.330561 -164.985001 311.518982)(-11.125000 -165.125000 313.138977)(-13.279600 -163.650009 311.877014)(-14.059900 -158.708008 294.966003)(-11.125000 -165.125000 313.138977)(-14.059900 -158.708008 294.966003)(-11.125000 -155.031998 275.467987)(-13.279699 -164.065002 313.423004)(-13.279600 -163.650009 311.877014)(-11.125000 -165.125000 313.138977)(-11.125000 -165.125000 313.138977)(-10.912300 -164.865005 313.208984)(-13.279699 -164.065002 313.423004)(-13.279699 -164.065002 313.423004)(-15.297999 -162.968002 312.059998)(-13.279600 -163.650009 311.877014)(-15.297999 -162.968002 312.059998)(-11.974199 -165.581009 317.317017)(-15.297999 -165.970001 323.264984)(-11.974199 -165.581009 317.317017)(-15.297999 -162.968002 312.059998)(-13.279699 -164.065002 313.423004)(-15.014900 -162.796005 312.106018)(-13.279600 -163.650009 311.877014)(-15.297999 -162.968002 312.059998)(-18.009300 -161.737000 314.046997)(-20.933599 -159.962006 314.523010)(-21.160000 -160.185989 314.462982)(-19.302401 -162.013000 318.217987)(-20.933599 -159.962006 314.523010)(-18.009300 -161.737000 314.046997)(-15.014900 -162.796005 312.106018)(-15.297999 -162.968002 312.059998)(-18.009399 -161.321991 312.501007)(-15.014900 -162.796005 312.106018)(-18.009399 -161.321991 312.501007)(-14.059900 -158.708008 294.966003)(-18.009300 -161.737000 314.046997)(-18.009399 -161.321991 312.501007)(-15.297999 -162.968002 312.059998)(-19.302401 -162.013000 318.217987)(-18.009300 -161.737000 314.046997)(-15.297999 -162.968002 312.059998)(-18.009399 -161.321991 312.501007)(-21.160000 -160.185989 314.462982)(-14.059900 -158.708008 294.966003)(-9.330561 -164.985001 311.518982)(-0.000008 -156.733002 275.011993)(-7.359990 -165.287003 311.437988)(-0.000008 -156.733002 275.011993)(-0.807269 -166.289001 311.170013)(-7.359990 -165.287003 311.437988)(-7.359990 -165.287003 311.437988)(-0.807269 -166.289001 311.170013)(-7.689010 -165.539993 311.369995)(-0.807269 -166.289001 311.170013)(-7.689010 -168.541992 322.575012)(-7.689010 -165.539993 311.369995)(-7.689010 -165.539993 311.369995)(-7.689010 -168.541992 322.575012)(-15.297999 -165.970001 323.264984)(34.310299 -141.945007 317.692993)(35.272999 -136.072998 319.265991)(35.418999 -139.376007 318.381012)(34.237999 -142.386002 317.575012)(34.310299 -141.945007 317.692993)(35.418999 -139.376007 318.381012)(35.418999 -139.376007 318.381012)(35.272999 -136.072998 319.265991)(36.320999 -131.638000 320.454010)(32.756001 -146.725998 316.411987)(34.237999 -142.386002 317.575012)(35.418999 -139.376007 318.381012)(33.411201 -143.953003 317.154999)(34.237999 -142.386002 317.575012)(32.756001 -146.725998 316.411987)(32.756001 -146.725998 316.411987)(29.125000 -152.078995 314.976990)(33.411201 -143.953003 317.154999)(34.237999 -142.386002 317.575012)(33.411201 -143.953003 317.154999)(34.237999 -132.706009 281.450012)(33.411201 -143.953003 317.154999)(29.334902 -151.681000 315.084015)(34.237999 -132.706009 281.450012)(29.125000 -142.399002 278.852997)(34.237999 -132.706009 281.450012)(29.334902 -151.681000 315.084015)(29.334902 -151.681000 315.084015)(29.125000 -152.078995 314.976990)(33.411201 -143.953003 317.154999)(-0.807269 -166.289001 311.170013)(-0.000008 -156.733002 275.011993)(0.456574 -166.343002 311.154999)(16.541401 -162.044998 312.307007)(8.711970 -165.080002 311.493011)(21.160000 -150.092010 276.791016)(-18.009300 -161.737000 314.046997)(-21.160000 -160.185989 314.462982)(-18.009399 -161.321991 312.501007)(-20.933599 -159.962006 314.523010)(-22.124001 -159.238998 314.716980)(-21.160000 -160.185989 314.462982)(35.418999 -139.376007 318.381012)(32.756001 -149.727997 327.617004)(32.756001 -146.725998 316.411987)(32.756001 -146.725998 316.411987)(32.756001 -149.727997 327.617004)(28.466999 -156.320999 325.850006)(28.466999 -153.319000 314.644989)(32.756001 -146.725998 316.411987)(28.466999 -156.320999 325.850006)(28.466999 -156.320999 325.850006)(22.767000 -161.826996 324.375000)(28.466999 -153.319000 314.644989)(28.466999 -153.319000 314.644989)(28.804100 -152.389008 314.893982)(29.125000 -152.078995 314.976990)(28.466999 -153.319000 314.644989)(25.785500 -155.606995 314.031982)(28.804100 -152.389008 314.893982)(22.767000 -158.824997 313.169983)(23.349100 -157.656998 313.483002)(25.785500 -155.606995 314.031982)(22.767000 -158.824997 313.169983)(25.785500 -155.606995 314.031982)(28.466999 -153.319000 314.644989)(28.466999 -153.319000 314.644989)(22.767000 -161.826996 324.375000)(22.767000 -158.824997 313.169983)(35.418999 -142.378006 329.585999)(32.756001 -149.727997 327.617004)(35.418999 -139.376007 318.381012)(35.418999 -139.376007 318.381012)(36.320999 -131.638000 320.454010)(35.418999 -142.378006 329.585999)(29.125000 -142.399002 278.852997)(29.125000 -152.078995 314.976990)(28.804100 -152.389008 314.893982)(29.125000 -142.399002 278.852997)(28.804100 -152.389008 314.893982)(23.349100 -157.656998 313.483002)(29.125000 -142.399002 278.852997)(23.349100 -157.656998 313.483002)(21.486799 -159.455994 313.001007)(15.941000 -162.968002 312.059998)(16.541401 -162.044998 312.307007)(21.160000 -159.771988 312.916016)(-36.000000 -132.054001 322.000000)(-35.659100 -131.880997 322.046021)(-35.679001 -132.052002 322.000000)(-34.775997 -124.314003 324.075012)(-34.805099 -124.564003 324.007996)(-34.775997 -126.902000 333.733002)(-11.974199 -165.581009 317.317017)(-13.279699 -164.065002 313.423004)(-10.912300 -164.865005 313.208984)(-7.689010 -165.539993 311.369995)(-11.974199 -165.581009 317.317017)(-9.330299 -165.399994 313.065002)(-11.974199 -165.581009 317.317017)(-10.912300 -164.865005 313.208984)(-9.330299 -165.399994 313.065002)(-9.330299 -165.399994 313.065002)(-9.330561 -164.985001 311.518982)(-7.689010 -165.539993 311.369995)(-32.113998 -119.553001 335.701996)(-32.113998 -116.965004 326.042999)(-32.868797 -120.264999 330.024017)(-15.297999 -165.970001 323.264984)(-22.124001 -161.826996 324.375000)(-15.297999 -162.968002 312.059998)(-22.124001 -161.826996 324.375000)(-22.124001 -159.238998 314.716980)(-19.302401 -162.013000 318.217987)(-22.124001 -104.864998 329.286011)(-23.934601 -107.862999 333.478973)(-22.124001 -107.453003 338.944000)(-25.662201 -108.281998 328.369995)(-26.830200 -105.148003 329.210022)(-39.616997 -112.034004 327.365021)(-22.124001 -104.864998 329.286011)(-26.830200 -105.148003 329.210022)(-25.662201 -108.281998 328.369995)(-30.908501 -150.165009 321.833984)(-28.417000 -152.822998 316.436005)(-32.113998 -149.727997 327.617004)(-32.113998 -116.965004 326.042999)(-32.940300 -119.246002 325.432007)(-32.868797 -120.264999 330.024017)(-31.522099 -116.055000 326.286987)(-32.639599 -114.414001 326.726990)(-32.113998 -116.965004 326.042999)(41.625599 -102.190002 330.002014)(28.466999 -110.371002 327.809998)(32.756001 -116.965004 326.042999)(-39.445698 -83.375198 334.000000)(-45.644997 -105.096001 329.223999)(-27.348400 -83.493393 334.000000)(41.857998 -111.414001 327.531006)(37.523003 -117.681000 325.850983)(41.857998 -101.320000 289.860016)(52.500000 -82.135002 295.000000)(52.500000 -87.269997 334.000000)(52.500000 -95.959999 291.296021)(48.346001 -107.225998 328.653015)(48.346001 -97.133003 290.981995)(52.500000 -95.959999 291.296021)(41.857998 -111.414001 327.531006)(41.857998 -101.320000 289.860016)(48.346001 -97.133003 290.981995)(-35.659100 -131.880997 322.046021)(-35.554401 -130.983994 322.286987)(-36.000000 -132.054001 322.000000)(41.625599 -102.190002 330.002014)(22.767000 -104.864998 329.285004)(28.466999 -110.371002 327.809998)(52.500000 -87.269997 334.000000)(36.488201 -96.500595 331.527008)(41.625599 -102.190002 330.002014)(41.625599 -102.190002 330.002014)(36.488201 -96.500595 331.527008)(22.767000 -104.864998 329.285004)(48.346001 -107.225998 328.653015)(52.500000 -87.269997 334.000000)(41.625599 -102.190002 330.002014)(52.500000 -87.269997 334.000000)(48.346001 -107.225998 328.653015)(52.500000 -106.054001 328.967010)(36.488201 -96.500595 331.527008)(31.234100 -94.067299 332.179016)(22.767000 -104.864998 329.285004)(8.331990 -98.151001 331.084991)(9.968170 -98.703896 330.937012)(22.756399 -92.987000 332.468018)(-50.446999 -89.918999 292.914001)(-53.764999 -90.473007 292.765991)(-55.224003 -85.168999 294.187012)(-45.139999 -93.271004 292.015991)(-45.644997 -95.002007 291.552979)(-47.857002 -91.569000 292.472015)(-50.446999 -89.918999 292.914001)(-47.857002 -91.569000 292.472015)(-45.644997 -95.002007 291.552979)(-50.446999 -89.918999 292.914001)(-45.644997 -95.002007 291.552979)(-53.764999 -90.473007 292.765991)(-56.825802 -82.135002 295.000000)(-55.224003 -85.168999 294.187012)(-61.307003 -82.135002 295.000000)(-55.224003 -85.168999 294.187012)(-53.764999 -90.473007 292.765991)(-61.307003 -82.135002 295.000000)(-32.113998 -146.725998 316.411987)(-32.476501 -146.134003 318.206024)(-32.478897 -146.133011 318.227997)(-9.330299 -165.399994 313.065002)(-10.912300 -164.865005 313.208984)(-11.125000 -165.125000 313.138977)(-45.644997 -105.096001 329.223999)(-53.764999 -100.567001 330.437012)(-45.644997 -95.002007 291.552979)(35.980198 -130.005997 326.056000)(35.543400 -125.382004 323.787994)(36.320999 -134.639999 331.658997)(-7.359990 -165.287003 311.437988)(-7.689010 -165.539993 311.369995)(-9.330561 -164.985001 311.518982)(22.767000 -161.826996 324.375000)(15.941000 -165.970001 323.264984)(22.767000 -158.824997 313.169983)(-39.209000 -99.082001 290.459015)(-45.644997 -95.002007 291.552979)(-45.139999 -93.271004 292.015991)(-32.639599 -114.414001 326.726990)(-39.616997 -112.034004 327.365021)(-36.410000 -120.544998 325.084015)(-53.764999 -90.473007 292.765991)(-61.307003 -88.950996 293.174011)(-61.307003 -82.135002 295.000000)(-11.125000 -155.031998 275.467987)(-14.059900 -158.708008 294.966003)(-21.160000 -160.185989 314.462982)(-27.824999 -156.320999 325.850006)(-32.113998 -149.727997 327.617004)(-28.417000 -152.822998 316.436005)(-34.760098 -139.374008 318.381012)(-34.694702 -140.014999 319.867004)(-34.775997 -142.378006 329.585999)(-34.694702 -140.014999 319.867004)(-34.083900 -142.904999 323.907990)(-34.775997 -142.378006 329.585999)(28.466999 -110.371002 327.809998)(32.756001 -119.553001 335.701996)(32.756001 -116.965004 326.042999)(-22.124001 -104.864998 329.286011)(-25.662201 -108.281998 328.369995)(-23.934601 -107.862999 333.478973)(-21.160000 -150.092010 276.791016)(-11.125000 -155.031998 275.467987)(-21.160000 -160.185989 314.462982)(-11.125000 -165.125000 313.138977)(-9.330561 -164.985001 311.518982)(-9.330299 -165.399994 313.065002)(52.500000 -87.269997 334.000000)(52.500000 -106.054001 328.967010)(52.500000 -95.959999 291.296021)(-19.302401 -162.013000 318.217987)(-22.124001 -159.238998 314.716980)(-20.933599 -159.962006 314.523010)(36.320999 -131.638000 320.454010)(36.000000 -130.279999 320.817993)(36.000000 -128.884003 321.191986)(-13.279600 -163.650009 311.877014)(-15.014900 -162.796005 312.106018)(-14.059900 -158.708008 294.966003)(35.272999 -136.072998 319.265991)(34.310299 -141.945007 317.692993)(36.000000 -121.959999 284.329010)(21.486799 -159.455994 313.001007)(21.160000 -150.092010 276.791016)(29.125000 -142.399002 278.852997)(-32.113998 -119.553001 335.701996)(-31.522099 -116.055000 326.286987)(-32.113998 -116.965004 326.042999)(8.331990 -100.738998 340.743011)(0.320996 -97.278702 331.317993)(0.320996 -99.867004 340.977997)(-35.659100 -131.880997 322.046021)(-35.679001 -132.052002 322.000000)(-35.679001 -134.639999 331.658997)(25.785500 -155.606995 314.031982)(23.349100 -157.656998 313.483002)(28.804100 -152.389008 314.893982)(-27.824999 -153.733002 316.191986)(-22.910900 -158.479004 314.920013)(-27.824999 -156.320999 325.850006)(-34.237999 -142.800003 319.121002)(-32.478897 -146.133011 318.227997)(-32.476501 -146.134003 318.206024)(9.968170 -98.703896 330.937012)(8.331990 -98.151001 331.084991)(8.331990 -100.738998 340.743011)(28.466999 -153.319000 314.644989)(29.125000 -152.078995 314.976990)(32.756001 -146.725998 316.411987)(-34.885899 -138.799988 319.997009)(-34.760098 -139.374008 318.381012)(-34.885899 -138.848999 320.179993)(-53.764999 -90.473007 292.765991)(-45.644997 -95.002007 291.552979)(-53.764999 -100.567001 330.437012)(-34.805099 -124.564003 324.007996)(-35.554401 -130.983994 322.286987)(-34.775997 -126.902000 333.733002)(-34.694702 -140.014999 319.867004)(-33.789898 -142.513000 319.197998)(-34.083900 -142.904999 323.907990)(22.767000 -158.824997 313.169983)(21.486799 -159.455994 313.001007)(23.349100 -157.656998 313.483002)(-61.307003 -87.268997 334.000000)(-61.307003 -99.044998 330.845001)(-53.764999 -100.567001 330.437012)(35.418999 -124.314003 324.074005)(32.756001 -119.553001 335.701996)(35.418999 -126.902000 333.733002)(-36.000000 -125.073997 323.870972)(-36.000000 -121.959999 284.329010)(-36.000000 -132.054001 322.000000)(-15.297999 -100.722000 330.395996)(-15.297999 -103.309998 340.054016)(-7.689010 -100.738998 340.743011)(44.985802 -106.802002 328.766998)(41.625599 -102.190002 330.002014)(41.857998 -111.414001 327.531006)(44.985802 -106.802002 328.766998)(41.857998 -111.414001 327.531006)(48.346001 -107.225998 328.653015)(44.985802 -106.802002 328.766998)(48.346001 -107.225998 328.653015)(41.625599 -102.190002 330.002014)(29.125000 -142.399002 278.852997)(29.334902 -151.681000 315.084015)(29.125000 -152.078995 314.976990)(48.346001 -107.225998 328.653015)(41.857998 -111.414001 327.531006)(48.346001 -97.133003 290.981995)(-22.124001 -107.453003 338.944000)(-23.934601 -107.862999 333.478973)(-27.038200 -109.611000 328.013977)(-29.125000 -142.399002 278.852997)(-31.965799 -146.693008 316.420990)(-32.476501 -145.724991 316.680023)(-27.038200 -109.611000 328.013977)(-27.824999 -112.959000 337.469025)(-22.124001 -107.453003 338.944000)(-39.445698 -83.375198 334.000000)(-53.764999 -100.567001 330.437012)(-45.644997 -105.096001 329.223999)(35.543400 -125.382004 323.787994)(35.418999 -124.314003 324.074005)(35.418999 -126.902000 333.733002)(36.320999 -131.638000 320.454010)(36.320999 -134.639999 331.658997)(35.418999 -142.378006 329.585999)(36.320999 -131.638000 320.454010)(35.980198 -130.005997 326.056000)(36.320999 -134.639999 331.658997)(-34.775997 -142.378006 329.585999)(-34.083900 -142.904999 323.907990)(-32.478897 -146.133011 318.227997)(-26.830200 -105.148003 329.210022)(-22.124001 -104.864998 329.286011)(-21.181702 -104.293007 329.439026)(-34.408600 -123.300003 324.346008)(-34.775997 -124.314003 324.075012)(-34.775997 -126.902000 333.733002)(-27.824999 -110.371002 327.809998)(-32.639599 -114.414001 326.726990)(-31.522099 -116.055000 326.286987)(52.500000 -106.054001 328.967010)(48.346001 -107.225998 328.653015)(52.500000 -95.959999 291.296021)(-19.302401 -162.013000 318.217987)(-15.297999 -162.968002 312.059998)(-22.124001 -161.826996 324.375000)(36.000000 -114.979996 286.199005)(36.000000 -123.167000 305.033997)(36.000000 -121.959999 284.329010)(15.941000 -100.722000 330.395996)(22.767000 -104.864998 329.285004)(31.234100 -94.067299 332.179016)(-32.476501 -145.724991 316.680023)(-32.113998 -146.725998 316.411987)(-32.476501 -146.134003 318.206024)(36.488201 -96.500595 331.527008)(52.500000 -87.269997 334.000000)(31.234100 -94.067299 332.179016)(-56.825802 -82.135002 295.000000)(-61.307003 -82.135002 295.000000)(-58.258198 -79.227295 295.000000)(-15.297999 -165.970001 323.264984)(-11.974199 -165.581009 317.317017)(-7.689010 -165.539993 311.369995)(-61.307003 -82.135002 295.000000)(-60.119099 -75.463501 295.000000)(-59.974903 -75.463303 295.000000)(-7.689010 -98.151100 331.084991)(-15.803801 -83.706497 334.000000)(-15.297999 -100.722000 330.395996)(36.320999 -134.639999 331.658997)(-22.124001 -107.453003 338.944000)(-27.824999 -112.959000 337.469025)(-55.224003 -85.168999 294.187012)(-56.825802 -82.135002 295.000000)(-58.258198 -79.227295 295.000000)(-22.124001 -159.238998 314.716980)(-29.125000 -152.492996 316.523987)(-21.160000 -160.185989 314.462982)(36.320999 -134.639999 331.658997)(-32.113998 -149.727997 327.617004)(-27.824999 -156.320999 325.850006)(-15.297999 -103.309998 340.054016)(36.320999 -134.639999 331.658997)(-7.689010 -100.738998 340.743011)(8.331990 -100.738998 340.743011)(0.320996 -99.867004 340.977997)(36.320999 -134.639999 331.658997)(36.320999 -134.639999 331.658997)(0.320996 -99.867004 340.977997)(-7.689010 -100.738998 340.743011)(35.418999 -126.902000 333.733002)(32.756001 -119.553001 335.701996)(36.320999 -134.639999 331.658997)(28.466999 -112.959000 337.469025)(36.320999 -134.639999 331.658997)(32.756001 -119.553001 335.701996)(36.320999 -134.639999 331.658997)(8.331990 -168.541992 322.575012)(15.941000 -165.970001 323.264984)(-7.689010 -168.541992 322.575012)(0.320995 -169.414001 322.342010)(36.320999 -134.639999 331.658997)(-15.297999 -165.970001 323.264984)(-7.689010 -168.541992 322.575012)(36.320999 -134.639999 331.658997)(36.320999 -134.639999 331.658997)(28.466999 -156.320999 325.850006)(32.756001 -149.727997 327.617004)(35.418999 -142.378006 329.585999)(36.320999 -134.639999 331.658997)(32.756001 -149.727997 327.617004)(-22.124001 -161.826996 324.375000)(-15.297999 -165.970001 323.264984)(36.320999 -134.639999 331.658997)(36.320999 -134.639999 331.658997)(15.941000 -165.970001 323.264984)(22.767000 -161.826996 324.375000)(15.941000 -103.309998 340.054016)(36.320999 -134.639999 331.658997)(22.767000 -107.453003 338.944000)(15.941000 -103.309998 340.054016)(8.331990 -100.738998 340.743011)(36.320999 -134.639999 331.658997)(8.331990 -168.541992 322.575012)(36.320999 -134.639999 331.658997)(0.320995 -169.414001 322.342010)(22.767000 -107.453003 338.944000)(36.320999 -134.639999 331.658997)(28.466999 -112.959000 337.469025)(36.320999 -134.639999 331.658997)(22.767000 -161.826996 324.375000)(28.466999 -156.320999 325.850006)(-22.124001 -161.826996 324.375000)(36.320999 -134.639999 331.658997)(-27.824999 -156.320999 325.850006)(7.256990 -88.820999 293.208008)(4.082000 -88.003998 293.427002)(0.508551 -86.214401 293.906982)(7.256990 -88.820999 293.208008)(0.508551 -86.214401 293.906982)(-9.491710 -77.874603 295.000000)(52.500000 -87.269997 334.000000)(45.727802 -83.584702 334.000000)(41.496601 -84.434998 334.000000)(52.500000 -82.135002 295.000000)(19.284901 -93.542801 291.944000)(11.373000 -89.879997 292.923981)(11.373000 -89.879997 292.923981)(7.256990 -88.820999 293.208008)(52.500000 -82.135002 295.000000)(52.500000 -82.135002 295.000000)(26.004999 -98.990997 290.483002)(22.327799 -96.009796 291.282013)(52.500000 -82.135002 295.000000)(29.344400 -103.497993 289.276001)(26.004999 -98.990997 290.483002)(52.500000 -82.135002 295.000000)(22.327799 -96.009796 291.282013)(20.062700 -94.173401 291.774994)(52.500000 -82.135002 295.000000)(20.062700 -94.173401 291.774994)(19.284901 -93.542801 291.944000)(52.500000 -95.959999 291.296021)(48.346001 -97.133003 290.981995)(52.500000 -82.135002 295.000000)(52.500000 -82.378998 332.873993)(52.500000 -87.269997 334.000000)(52.500000 -81.335899 314.500000)(52.500000 -82.135002 295.000000)(52.500000 -81.335899 314.500000)(52.500000 -87.269997 334.000000)(52.500000 -75.987099 297.262024)(52.500000 -81.335899 314.500000)(52.500000 -82.135002 295.000000)(52.500000 -82.378998 332.873993)(52.500000 -82.581001 334.000000)(52.500000 -87.269997 334.000000)(41.857998 -101.320000 289.860016)(52.500000 -82.135002 295.000000)(48.346001 -97.133003 290.981995)(52.500000 -82.378998 332.873993)(52.500000 -81.335899 314.500000)(52.500000 -75.987099 297.262024)(52.500000 -82.135002 295.000000)(41.411198 -76.998001 295.000000)(47.652699 -75.137901 295.000000)(28.827499 -76.776695 295.000000)(41.411198 -76.998001 295.000000)(52.500000 -82.135002 295.000000)(-9.491710 -77.874603 295.000000)(28.827499 -76.776695 295.000000)(52.500000 -82.135002 295.000000)(-9.491710 -77.874603 295.000000)(52.500000 -82.135002 295.000000)(7.256990 -88.820999 293.208008)(52.500000 -82.135002 295.000000)(41.857998 -101.320000 289.860016)(29.344400 -103.497993 289.276001)(52.500000 -87.269997 334.000000)(52.500000 -82.581001 334.000000)(45.727802 -83.584702 334.000000)(35.601200 -104.452995 289.019989)(37.521999 -107.587006 288.179993)(29.344400 -103.497993 289.276001)(41.857998 -101.320000 289.860016)(35.601200 -104.452995 289.019989)(29.344400 -103.497993 289.276001)(37.521999 -107.587006 288.179993)(31.111000 -105.881996 288.637024)(29.344400 -103.497993 289.276001)(37.521999 -107.587006 288.179993)(34.283001 -113.783005 286.520020)(31.111000 -105.881996 288.637024)(34.237999 -132.706009 281.450012)(34.159000 -130.597992 282.014008)(35.320000 -122.197998 284.265015)(52.500000 -75.401794 295.000000)(52.500000 -75.750999 296.348999)(52.500000 -82.135002 295.000000)(52.500000 -82.135002 295.000000)(51.340302 -75.074501 295.000000)(52.500000 -75.401794 295.000000)(52.500000 -82.135002 295.000000)(47.652699 -75.137901 295.000000)(49.063000 -75.113701 295.000000)(52.500000 -82.135002 295.000000)(49.063000 -75.113701 295.000000)(51.340302 -75.074501 295.000000)(-9.491710 -77.874603 295.000000)(-10.356000 -76.087494 295.000000)(28.827499 -76.776695 295.000000)(36.000000 -114.979996 286.199005)(34.283001 -113.783005 286.520020)(37.521999 -107.587006 288.179993)(36.000000 -121.959999 284.329010)(35.320000 -122.197998 284.265015)(36.000000 -114.979996 286.199005)(36.000000 -114.979996 286.199005)(35.320000 -122.197998 284.265015)(34.283001 -113.783005 286.520020)(52.500000 -75.750999 296.348999)(52.500000 -75.987099 297.262024)(52.500000 -82.135002 295.000000)(41.857998 -101.320000 289.860016)(37.521999 -107.587006 288.179993)(35.601200 -104.452995 289.019989)(36.000000 -121.959999 284.329010)(34.237999 -132.706009 281.450012)(35.320000 -122.197998 284.265015)(-61.307003 -81.366898 314.500000)(-61.307003 -78.823700 310.820007)(-61.307003 -77.601700 305.225006)(-61.307003 -79.329498 313.720001)(-61.307003 -78.823700 310.820007)(-61.307003 -81.366898 314.500000)(-61.307003 -79.329498 313.720001)(-61.307003 -81.366898 314.500000)(-61.307003 -81.329002 324.300995)(-61.307003 -87.268997 334.000000)(-61.307003 -81.329002 324.300995)(-61.307003 -81.366898 314.500000)(-58.339001 -79.063202 295.000000)(-59.974903 -75.463303 295.000000)(-58.944603 -75.462196 295.000000)(-61.307003 -83.014198 334.000000)(-61.307003 -82.820702 332.976013)(-61.307003 -87.268997 334.000000)(-61.307003 -87.268997 334.000000)(-58.203102 -83.030594 334.000000)(-58.542400 -83.028801 334.000000)(-61.307003 -87.268997 334.000000)(-39.445698 -83.375198 334.000000)(-58.203102 -83.030594 334.000000)(-61.307003 -87.268997 334.000000)(-58.542400 -83.028801 334.000000)(-61.307003 -83.014198 334.000000)(-61.307003 -82.820702 332.976013)(-61.307003 -82.618805 331.907013)(-61.307003 -87.268997 334.000000)(-61.307003 -82.618805 331.907013)(-61.307003 -81.329002 324.300995)(-61.307003 -87.268997 334.000000)(-34.164997 -114.445999 286.341980)(-34.387997 -117.612999 285.492981)(-36.000000 -114.979996 286.199982)(-34.164997 -114.445999 286.341980)(-36.000000 -114.979996 286.199982)(-36.410000 -110.451996 287.412994)(-35.427002 -106.377998 288.503998)(-36.410000 -110.451996 287.412994)(-39.616997 -101.939995 289.694000)(-35.427002 -106.377998 288.503998)(-39.616997 -101.939995 289.694000)(-39.209000 -99.082001 290.459015)(-34.164997 -114.445999 286.341980)(-36.410000 -110.451996 287.412994)(-35.427002 -106.377998 288.503998)(-34.432999 -125.957001 283.257996)(-36.000000 -121.959999 284.329010)(-34.387997 -117.612999 285.492981)(-34.237999 -132.706009 281.450012)(-36.000000 -121.959999 284.329010)(-34.432999 -125.957001 283.257996)(-32.311996 -134.179993 281.053986)(-34.237999 -132.706009 281.450012)(-34.432999 -125.957001 283.257996)(-28.139999 -141.634995 279.057007)(-29.125000 -142.399002 278.852997)(-32.311996 -134.179993 281.053986)(-28.139999 -141.634995 279.057007)(-22.179001 -147.852997 277.390991)(-29.125000 -142.399002 278.852997)(-29.125000 -142.399002 278.852997)(-34.237999 -132.706009 281.450012)(-32.311996 -134.179993 281.053986)(2.270990 -155.713013 275.285004)(-0.000008 -156.733002 275.011993)(-6.481010 -155.121002 275.442993)(25.664000 -145.274994 278.080994)(21.160000 -150.092010 276.791016)(18.865000 -150.630005 276.645996)(11.124000 -155.031998 275.467987)(18.865000 -150.630005 276.645996)(21.160000 -150.092010 276.791016)(18.865000 -150.630005 276.645996)(11.124000 -155.031998 275.467987)(10.900001 -154.184006 275.694000)(10.900001 -154.184006 275.694000)(11.124000 -155.031998 275.467987)(-0.000008 -156.733002 275.011993)(-0.000008 -156.733002 275.011993)(2.270990 -155.713013 275.285004)(10.900001 -154.184006 275.694000)(34.237999 -132.706009 281.450012)(30.872000 -138.455002 279.910004)(34.159000 -130.597992 282.014008)(-20.121698 -149.134003 277.048004)(-21.160000 -150.092010 276.791016)(-22.179001 -147.852997 277.390991)(-20.121698 -149.134003 277.048004)(-14.805000 -152.445007 276.160004)(-21.160000 -150.092010 276.791016)(-11.125000 -155.031998 275.467987)(-6.481010 -155.121002 275.442993)(-0.000008 -156.733002 275.011993)(-6.481010 -155.121002 275.442993)(-11.125000 -155.031998 275.467987)(-14.805000 -152.445007 276.160004)(-11.125000 -155.031998 275.467987)(-21.160000 -150.092010 276.791016)(-14.805000 -152.445007 276.160004)(29.125000 -142.399002 278.852997)(30.872000 -138.455002 279.910004)(34.237999 -132.706009 281.450012)(21.160000 -150.092010 276.791016)(25.664000 -145.274994 278.080994)(29.125000 -142.399002 278.852997)(-36.000000 -121.959999 284.329010)(-36.000000 -114.979996 286.199982)(-34.387997 -117.612999 285.492981)(29.125000 -142.399002 278.852997)(25.664000 -145.274994 278.080994)(30.872000 -138.455002 279.910004)(-21.160000 -150.092010 276.791016)(-29.125000 -142.399002 278.852997)(-22.179001 -147.852997 277.390991)(36.775700 -52.616997 260.316986)(36.070000 -51.817997 229.615997)(45.763000 -43.496002 229.615997)(36.775700 -52.616997 260.316986)(36.682098 -52.697498 260.318024)(36.070000 -51.817997 229.615997)(13.931200 0.000000 229.615997)(3.626770 0.000000 229.615997)(28.604900 21.748001 229.615997)(45.763000 43.496002 229.615997)(28.604900 21.748001 229.615997)(3.626770 0.000000 229.615997)(-42.663002 47.998001 260.614014)(-36.688000 52.706001 260.614014)(-36.068996 51.817997 229.615997)(-36.688000 52.706001 260.614014)(-24.899000 58.017998 229.615997)(-36.068996 51.817997 229.615997)(-18.354000 0.000000 229.615997)(3.272990 -30.921000 229.615997)(12.710000 -61.841999 229.615997)(12.710000 -61.841999 229.615997)(-0.000012 -63.134998 229.615997)(-18.354000 0.000000 229.615997)(25.326000 59.010597 260.540985)(25.352999 58.995602 260.540985)(24.900000 58.017998 229.615997)(25.352999 58.995602 260.540985)(36.070000 51.817997 229.615997)(24.900000 58.017998 229.615997)(12.020300 29.008999 229.615997)(24.900000 58.017998 229.615997)(36.070000 51.817997 229.615997)(-12.927999 62.903004 260.614014)(-0.000012 64.217003 260.614014)(-0.000012 63.134998 229.615997)(-0.000012 64.217003 260.614014)(12.710000 61.841999 229.615997)(-0.000012 63.134998 229.615997)(-0.000012 64.217003 260.614014)(12.927999 62.903004 260.614014)(12.710000 61.841999 229.615997)(12.927999 62.903004 260.614014)(24.900000 58.017998 229.615997)(12.710000 61.841999 229.615997)(24.900000 58.017998 229.615997)(12.927999 62.903004 260.614014)(21.528200 60.204800 260.615997)(3.272990 30.921000 229.615997)(12.710000 61.841999 229.615997)(24.900000 58.017998 229.615997)(25.352999 -58.995602 260.540985)(24.900000 -58.017998 229.615997)(36.070000 -51.817997 229.615997)(25.352999 -58.995602 260.540985)(25.326000 -59.010597 260.540985)(24.900000 -58.017998 229.615997)(25.326000 -59.010597 260.540985)(21.528200 -60.204800 260.615997)(24.900000 -58.017998 229.615997)(24.900000 -58.017998 229.615997)(21.528200 -60.204800 260.615997)(12.927999 -62.903004 260.614014)(12.710000 -61.841999 229.615997)(24.900000 -58.017998 229.615997)(12.927999 -62.903004 260.614014)(12.927999 -62.903004 260.614014)(-0.000012 -64.217003 260.614014)(12.710000 -61.841999 229.615997)(-0.000012 -64.217003 260.614014)(-0.000012 -63.134998 229.615997)(12.710000 -61.841999 229.615997)(-0.000012 -63.134998 229.615997)(-0.000012 -64.217003 260.614014)(-12.927999 -62.903004 260.614014)(-34.349602 0.000000 229.615997)(-36.068996 51.817997 229.615997)(-24.899000 58.017998 229.615997)(-29.347500 -0.000000 229.615997)(-34.349602 0.000000 229.615997)(-24.899000 58.017998 229.615997)(-24.899000 58.017998 229.615997)(-36.688000 52.706001 260.614014)(-25.326000 59.012001 260.614014)(-12.710000 61.841999 229.615997)(-24.899000 58.017998 229.615997)(-25.326000 59.012001 260.614014)(-29.347500 -0.000000 229.615997)(-24.899000 58.017998 229.615997)(-12.710000 61.841999 229.615997)(-24.063900 0.000000 229.615997)(-29.347500 -0.000000 229.615997)(-12.710000 61.841999 229.615997)(-24.063900 0.000000 229.615997)(-12.710000 61.841999 229.615997)(-0.000012 63.134998 229.615997)(-25.326000 59.012001 260.614014)(-12.927999 62.903004 260.614014)(-12.710000 61.841999 229.615997)(-34.349602 0.000000 229.615997)(-39.188702 0.000000 229.615997)(-36.068996 51.817997 229.615997)(-24.899000 -58.017998 229.615997)(-34.349602 0.000000 229.615997)(-29.347500 -0.000000 229.615997)(-12.927999 -62.903004 260.614014)(-25.326000 -59.012001 260.614014)(-12.710000 -61.841999 229.615997)(-12.710000 -61.841999 229.615997)(-24.899000 -58.017998 229.615997)(-29.347500 -0.000000 229.615997)(-25.326000 -59.012001 260.614014)(-24.899000 -58.017998 229.615997)(-12.710000 -61.841999 229.615997)(-12.029500 0.000000 229.615997)(3.272990 30.921000 229.615997)(24.900000 58.017998 229.615997)(-12.029500 0.000000 229.615997)(-18.354000 0.000000 229.615997)(3.272990 30.921000 229.615997)(-12.710000 -61.841999 229.615997)(-29.347500 -0.000000 229.615997)(-24.063900 0.000000 229.615997)(-42.663002 -47.998001 260.614014)(-45.763000 -43.496002 229.615997)(-36.068996 -51.817997 229.615997)(-36.688000 -52.706001 260.614014)(-42.663002 -47.998001 260.614014)(-36.068996 -51.817997 229.615997)(-36.068996 -51.817997 229.615997)(-39.188702 0.000000 229.615997)(-34.349602 0.000000 229.615997)(-40.916000 -25.908998 229.615997)(-39.188702 0.000000 229.615997)(-36.068996 -51.817997 229.615997)(-40.916000 -25.908998 229.615997)(-43.969299 0.000000 229.615997)(-39.188702 0.000000 229.615997)(-45.763000 -43.496002 229.615997)(-43.969299 0.000000 229.615997)(-40.916000 -25.908998 229.615997)(-48.776199 -21.748001 229.615997)(-43.969299 0.000000 229.615997)(-45.763000 -43.496002 229.615997)(-46.547001 44.241997 260.614014)(-42.663002 47.998001 260.614014)(-45.763000 43.496002 229.615997)(-45.763000 -43.496002 229.615997)(-53.583000 -33.394001 229.615997)(-48.776199 -21.748001 229.615997)(-48.790001 0.000000 229.615997)(-48.776199 -21.748001 229.615997)(-53.583000 -33.394001 229.615997)(-53.583000 -33.394001 229.615997)(-53.999500 -16.697001 229.615997)(-48.790001 0.000000 229.615997)(-48.776199 -21.748001 229.615997)(-48.790001 0.000000 229.615997)(-43.969299 0.000000 229.615997)(-45.763000 43.496002 229.615997)(-53.583000 33.394001 229.615997)(-46.547001 44.241997 260.614014)(-48.776199 21.748001 229.615997)(-53.583000 33.394001 229.615997)(-45.763000 43.496002 229.615997)(-43.969299 0.000000 229.615997)(-48.790001 0.000000 229.615997)(-48.776199 21.748001 229.615997)(-48.790001 0.000000 229.615997)(-53.583000 33.394001 229.615997)(-48.776199 21.748001 229.615997)(-62.410999 9.556000 229.615997)(-63.481003 9.720000 260.614014)(-60.223999 22.299999 260.614014)(-60.223999 22.299999 260.614014)(-59.209000 21.924000 229.615997)(-62.410999 9.556000 229.615997)(-62.410999 9.556000 229.615997)(-63.162804 0.000000 237.298996)(-63.481003 9.720000 260.614014)(-62.895603 0.000000 229.615997)(-63.162804 0.000000 237.298996)(-62.410999 9.556000 229.615997)(-62.410999 -9.556000 229.615997)(-62.895603 0.000000 229.615997)(-58.974300 0.000000 229.615997)(-62.895603 0.000000 229.615997)(-62.410999 -9.556000 229.615997)(-63.162804 0.000000 237.298996)(-62.410999 -9.556000 229.615997)(-58.974300 0.000000 229.615997)(-53.753201 0.000000 229.615997)(-53.753201 0.000000 229.615997)(-58.974300 0.000000 229.615997)(-62.410999 9.556000 229.615997)(-59.209000 -21.924000 229.615997)(-62.410999 -9.556000 229.615997)(-53.753201 0.000000 229.615997)(-53.999500 -16.697001 229.615997)(-59.209000 -21.924000 229.615997)(-53.753201 0.000000 229.615997)(-45.763000 43.496002 229.615997)(-43.969299 0.000000 229.615997)(-48.776199 21.748001 229.615997)(-40.916000 25.908998 229.615997)(-43.969299 0.000000 229.615997)(-45.763000 43.496002 229.615997)(36.775700 52.616997 260.316986)(41.335003 48.699100 260.226990)(45.763000 43.496002 229.615997)(46.548000 44.241997 260.614014)(54.501999 33.966000 260.614014)(53.583000 33.394001 229.615997)(46.548000 44.241997 260.614014)(53.583000 33.394001 229.615997)(45.763000 43.496002 229.615997)(53.583000 33.394001 229.615997)(28.604900 21.748001 229.615997)(45.763000 43.496002 229.615997)(45.763000 43.496002 229.615997)(41.335003 48.699100 260.226990)(46.548000 44.241997 260.614014)(36.682098 52.697498 260.318024)(36.775700 52.616997 260.316986)(36.070000 51.817997 229.615997)(36.775700 52.616997 260.316986)(45.763000 43.496002 229.615997)(36.070000 51.817997 229.615997)(-45.763000 -43.496002 229.615997)(-42.663002 -47.998001 260.614014)(-46.547001 -44.241997 260.614014)(63.163803 0.000000 237.298996)(63.974796 0.000000 260.614014)(63.482002 -9.720000 260.614014)(63.482002 -9.720000 260.614014)(62.412003 -9.556000 229.615997)(63.163803 0.000000 237.298996)(63.482002 -9.720000 260.614014)(60.224998 -22.299999 260.614014)(62.412003 -9.556000 229.615997)(60.224998 -22.299999 260.614014)(59.209999 -21.924000 229.615997)(62.412003 -9.556000 229.615997)(59.209999 21.924000 229.615997)(54.501999 33.966000 260.614014)(60.224998 22.299999 260.614014)(62.412003 9.556000 229.615997)(59.209999 21.924000 229.615997)(60.224998 22.299999 260.614014)(62.412003 9.556000 229.615997)(60.224998 22.299999 260.614014)(63.482002 9.720000 260.614014)(27.066700 0.000000 229.615997)(13.931200 0.000000 229.615997)(53.583000 33.394001 229.615997)(59.209999 21.924000 229.615997)(27.066700 0.000000 229.615997)(53.583000 33.394001 229.615997)(62.412003 9.556000 229.615997)(44.804802 0.000000 229.615997)(59.209999 21.924000 229.615997)(62.896603 0.000000 229.615997)(44.804802 0.000000 229.615997)(62.412003 9.556000 229.615997)(62.896603 0.000000 229.615997)(62.412003 9.556000 229.615997)(63.163803 0.000000 237.298996)(44.804802 0.000000 229.615997)(27.066700 0.000000 229.615997)(59.209999 21.924000 229.615997)(59.209999 -21.924000 229.615997)(27.066700 0.000000 229.615997)(44.804802 0.000000 229.615997)(59.209999 -21.924000 229.615997)(44.804802 0.000000 229.615997)(62.412003 -9.556000 229.615997)(53.583000 -33.394001 229.615997)(27.066700 0.000000 229.615997)(59.209999 -21.924000 229.615997)(53.583000 -33.394001 229.615997)(13.931200 0.000000 229.615997)(27.066700 0.000000 229.615997)(53.583000 -33.394001 229.615997)(28.604900 -21.748001 229.615997)(13.931200 0.000000 229.615997)(63.163803 0.000000 237.298996)(62.412003 9.556000 229.615997)(63.482002 9.720000 260.614014)(-62.410999 -9.556000 229.615997)(-60.223999 -22.299999 260.614014)(-63.481003 -9.720000 260.614014)(-59.209000 -21.924000 229.615997)(-54.500999 -33.966000 260.614014)(-60.223999 -22.299999 260.614014)(-59.209000 -21.924000 229.615997)(-53.583000 -33.394001 229.615997)(-54.500999 -33.966000 260.614014)(-53.583000 -33.394001 229.615997)(-46.547001 -44.241997 260.614014)(-54.500999 -33.966000 260.614014)(36.682098 -52.697498 260.318024)(25.352999 -58.995602 260.540985)(36.070000 -51.817997 229.615997)(-24.899000 -58.017998 229.615997)(-36.068996 -51.817997 229.615997)(-34.349602 0.000000 229.615997)(-12.927999 62.903004 260.614014)(-0.000012 63.134998 229.615997)(-12.710000 61.841999 229.615997)(54.501999 -33.966000 260.614014)(46.548000 -44.241997 260.614014)(53.583000 -33.394001 229.615997)(46.548000 -44.241997 260.614014)(45.763000 -43.496002 229.615997)(53.583000 -33.394001 229.615997)(46.548000 -44.241997 260.614014)(41.335003 -48.699100 260.226990)(45.763000 -43.496002 229.615997)(63.163803 0.000000 237.298996)(63.482002 9.720000 260.614014)(63.974796 0.000000 260.614014)(3.272990 -30.921000 229.615997)(-18.354000 0.000000 229.615997)(-12.029500 0.000000 229.615997)(24.900000 -58.017998 229.615997)(3.272990 -30.921000 229.615997)(-12.029500 0.000000 229.615997)(-12.029500 0.000000 229.615997)(12.020300 -29.008999 229.615997)(24.900000 -58.017998 229.615997)(12.020300 -29.008999 229.615997)(-12.029500 0.000000 229.615997)(-4.829680 0.000000 229.615997)(-4.829680 0.000000 229.615997)(-12.029500 0.000000 229.615997)(12.020300 29.008999 229.615997)(-4.829680 0.000000 229.615997)(12.020300 29.008999 229.615997)(36.070000 51.817997 229.615997)(20.466700 -25.908998 229.615997)(-4.829680 0.000000 229.615997)(3.626770 0.000000 229.615997)(-4.829680 0.000000 229.615997)(20.466700 -25.908998 229.615997)(36.070000 -51.817997 229.615997)(3.626770 0.000000 229.615997)(-4.829680 0.000000 229.615997)(20.466700 25.908998 229.615997)(20.466700 25.908998 229.615997)(-4.829680 0.000000 229.615997)(36.070000 51.817997 229.615997)(62.412003 -9.556000 229.615997)(44.804802 0.000000 229.615997)(62.896603 0.000000 229.615997)(24.900000 -58.017998 229.615997)(12.020300 -29.008999 229.615997)(36.070000 -51.817997 229.615997)(36.070000 -51.817997 229.615997)(12.020300 -29.008999 229.615997)(-4.829680 0.000000 229.615997)(-59.209000 21.924000 229.615997)(-60.223999 22.299999 260.614014)(-54.500999 33.966000 260.614014)(-53.999500 16.697001 229.615997)(-59.209000 21.924000 229.615997)(-53.583000 33.394001 229.615997)(-53.999500 16.697001 229.615997)(-53.753201 0.000000 229.615997)(-59.209000 21.924000 229.615997)(-48.790001 0.000000 229.615997)(-53.753201 0.000000 229.615997)(-53.999500 16.697001 229.615997)(-54.500999 33.966000 260.614014)(-53.583000 33.394001 229.615997)(-59.209000 21.924000 229.615997)(54.501999 33.966000 260.614014)(59.209999 21.924000 229.615997)(53.583000 33.394001 229.615997)(-25.326000 -59.012001 260.614014)(-36.688000 -52.706001 260.614014)(-24.899000 -58.017998 229.615997)(59.209999 -21.924000 229.615997)(60.224998 -22.299999 260.614014)(54.501999 -33.966000 260.614014)(-53.999500 16.697001 229.615997)(-53.583000 33.394001 229.615997)(-48.790001 0.000000 229.615997)(36.070000 51.817997 229.615997)(25.352999 58.995602 260.540985)(36.682098 52.697498 260.318024)(-60.223999 -22.299999 260.614014)(-62.410999 -9.556000 229.615997)(-59.209000 -21.924000 229.615997)(-53.583000 33.394001 229.615997)(-54.500999 33.966000 260.614014)(-46.547001 44.241997 260.614014)(-36.068996 -51.817997 229.615997)(-45.763000 -43.496002 229.615997)(-40.916000 -25.908998 229.615997)(-58.974300 0.000000 229.615997)(-62.895603 0.000000 229.615997)(-62.410999 9.556000 229.615997)(45.763000 -43.496002 229.615997)(20.466700 -25.908998 229.615997)(3.626770 0.000000 229.615997)(3.626770 0.000000 229.615997)(28.604900 -21.748001 229.615997)(45.763000 -43.496002 229.615997)(-18.354000 0.000000 229.615997)(-0.000012 63.134998 229.615997)(12.710000 61.841999 229.615997)(-12.927999 -62.903004 260.614014)(-12.710000 -61.841999 229.615997)(-0.000012 -63.134998 229.615997)(-39.188702 0.000000 229.615997)(-43.969299 0.000000 229.615997)(-40.916000 25.908998 229.615997)(36.070000 -51.817997 229.615997)(20.466700 -25.908998 229.615997)(45.763000 -43.496002 229.615997)(53.583000 -33.394001 229.615997)(59.209999 -21.924000 229.615997)(54.501999 -33.966000 260.614014)(-53.999500 -16.697001 229.615997)(-53.753201 0.000000 229.615997)(-48.790001 0.000000 229.615997)(-0.000012 -63.134998 229.615997)(-12.710000 -61.841999 229.615997)(-24.063900 0.000000 229.615997)(12.710000 61.841999 229.615997)(3.272990 30.921000 229.615997)(-18.354000 0.000000 229.615997)(-63.481003 -9.720000 260.614014)(-63.973801 0.000000 260.614014)(-63.162804 0.000000 237.298996)(12.020300 29.008999 229.615997)(-12.029500 0.000000 229.615997)(24.900000 58.017998 229.615997)(24.900000 58.017998 229.615997)(21.528200 60.204800 260.615997)(25.326000 59.010597 260.540985)(-53.753201 0.000000 229.615997)(-62.410999 9.556000 229.615997)(-59.209000 21.924000 229.615997)(45.763000 -43.496002 229.615997)(28.604900 -21.748001 229.615997)(53.583000 -33.394001 229.615997)(63.163803 0.000000 237.298996)(62.412003 -9.556000 229.615997)(62.896603 0.000000 229.615997)(-53.583000 -33.394001 229.615997)(-59.209000 -21.924000 229.615997)(-53.999500 -16.697001 229.615997)(28.604900 -21.748001 229.615997)(3.626770 0.000000 229.615997)(13.931200 0.000000 229.615997)(-63.481003 -9.720000 260.614014)(-63.162804 0.000000 237.298996)(-62.410999 -9.556000 229.615997)(20.466700 25.908998 229.615997)(36.070000 51.817997 229.615997)(45.763000 43.496002 229.615997)(-39.188702 0.000000 229.615997)(-40.916000 25.908998 229.615997)(-36.068996 51.817997 229.615997)(13.931200 0.000000 229.615997)(28.604900 21.748001 229.615997)(53.583000 33.394001 229.615997)(-36.068996 51.817997 229.615997)(-45.763000 43.496002 229.615997)(-42.663002 47.998001 260.614014)(-40.916000 25.908998 229.615997)(-45.763000 43.496002 229.615997)(-36.068996 51.817997 229.615997)(-0.000012 -63.134998 229.615997)(-24.063900 0.000000 229.615997)(-18.354000 0.000000 229.615997)(-18.354000 0.000000 229.615997)(-24.063900 0.000000 229.615997)(-0.000012 63.134998 229.615997)(20.466700 25.908998 229.615997)(45.763000 43.496002 229.615997)(3.626770 0.000000 229.615997)(24.900000 -58.017998 229.615997)(12.710000 -61.841999 229.615997)(3.272990 -30.921000 229.615997)(-53.583000 -33.394001 229.615997)(-45.763000 -43.496002 229.615997)(-46.547001 -44.241997 260.614014)(-63.162804 0.000000 237.298996)(-63.973801 0.000000 260.614014)(-63.481003 9.720000 260.614014)(41.335003 -48.699100 260.226990)(36.775700 -52.616997 260.316986)(45.763000 -43.496002 229.615997)(-36.688000 -52.706001 260.614014)(-36.068996 -51.817997 229.615997)(-24.899000 -58.017998 229.615997)(-182.143005 -45.311100 463.487000)(-182.000000 -45.454800 462.976013)(-181.967010 -45.590401 463.997009)(-182.143005 -45.311100 463.487000)(-181.967010 -45.590401 463.997009)(-182.343002 -45.050098 463.532013)(-182.000000 -45.454800 462.976013)(-182.000000 -45.799999 462.970001)(-181.967010 -45.590401 463.997009)(-181.869995 -43.308998 455.483002)(-181.731003 -43.294701 455.464996)(-181.832993 -44.672401 458.121979)(-181.869995 -43.308998 455.483002)(-181.832993 -44.672401 458.121979)(-183.264999 -43.174999 459.820984)(-181.909988 -41.462997 453.144989)(-181.869995 -43.308998 455.483002)(-183.264999 -43.174999 459.820984)(-181.869995 -43.308998 455.483002)(-181.909988 -41.462997 453.144989)(-181.731003 -43.294701 455.464996)(-181.832993 -44.672401 458.121979)(-182.542999 -44.611000 461.138000)(-183.264999 -43.174999 459.820984)(-182.770004 -44.549000 464.264984)(-181.959000 -45.582001 464.260010)(-182.705994 -44.516998 465.834991)(-181.967010 -45.590401 463.997009)(-181.959000 -45.582001 464.260010)(-182.770004 -44.549000 464.264984)(-182.030014 -35.792999 449.824005)(-181.778000 -37.358501 450.475983)(-181.963989 -38.924000 451.126984)(-181.525009 -35.792999 449.824005)(-181.778000 -37.358501 450.475983)(-182.030014 -35.792999 449.824005)(-182.030014 -35.792999 449.824005)(-181.525009 -35.792999 449.824005)(-181.525009 -35.682499 449.806000)(-181.572006 -38.800499 451.075989)(-181.778000 -37.358501 450.475983)(-181.525009 -35.792999 449.824005)(-181.572006 -38.800499 451.075989)(-181.963989 -38.924000 451.126984)(-181.778000 -37.358501 450.475983)(-181.963989 -38.924000 451.126984)(-181.574005 -38.924000 451.126984)(-181.572006 -38.800499 451.075989)(-181.574005 -38.924000 451.126984)(-181.645004 -41.395500 453.091003)(-181.963989 -38.924000 451.126984)(-181.645004 -41.395500 453.091003)(-181.909988 -41.462997 453.144989)(-181.963989 -38.924000 451.126984)(-181.909988 -41.462997 453.144989)(-181.647003 -41.462997 453.144989)(-181.645004 -41.395500 453.091003)(-181.501999 -20.481300 449.445007)(-182.291992 -21.139999 449.445007)(-181.948013 -17.015499 449.445007)(-181.501999 -20.481300 449.445007)(-181.948013 -17.015499 449.445007)(-181.500000 -17.228500 449.445007)(-181.501999 -21.139999 449.445007)(-182.291992 -21.139999 449.445007)(-181.501999 -20.481300 449.445007)(-182.078003 -33.615997 449.472015)(-181.794998 -34.704498 449.647980)(-182.030014 -35.792999 449.824005)(-185.662003 -21.164000 456.438995)(-182.078003 -33.615997 449.472015)(-182.030014 -35.792999 449.824005)(-181.511993 -33.615997 449.472015)(-181.794998 -34.704498 449.647980)(-182.078003 -33.615997 449.472015)(-181.525009 -35.682499 449.806000)(-181.794998 -34.704498 449.647980)(-181.511993 -33.615997 449.472015)(-185.662003 -21.164000 456.438995)(-182.239990 -25.265001 449.445007)(-182.078003 -33.615997 449.472015)(-182.291992 -21.139999 449.445007)(-182.239990 -25.265001 449.445007)(-185.662003 -21.164000 456.438995)(-181.897003 -23.202499 449.445007)(-182.239990 -25.265001 449.445007)(-182.291992 -21.139999 449.445007)(-181.873001 -29.440500 449.458984)(-182.078003 -33.615997 449.472015)(-182.239990 -25.265001 449.445007)(-181.511002 -33.134800 449.470001)(-182.078003 -33.615997 449.472015)(-181.873001 -29.440500 449.458984)(-181.897003 -23.202499 449.445007)(-182.291992 -21.139999 449.445007)(-181.501999 -21.139999 449.445007)(-181.504990 -25.265001 449.445007)(-181.873001 -29.440500 449.458984)(-182.239990 -25.265001 449.445007)(-181.504990 -25.265001 449.445007)(-182.239990 -25.265001 449.445007)(-181.504990 -24.960199 449.445007)(-181.504990 -24.960199 449.445007)(-181.897003 -23.202499 449.445007)(-181.501999 -21.139999 449.445007)(-181.963989 38.924000 451.126984)(-181.778000 37.358501 450.475983)(-182.030014 35.792999 449.824005)(-181.572006 38.800499 451.075989)(-181.778000 37.358501 450.475983)(-181.963989 38.924000 451.126984)(-181.574005 38.924000 451.126984)(-181.963989 38.924000 451.126984)(-181.645004 41.395500 453.091003)(-181.963989 38.924000 451.126984)(-181.572006 38.800499 451.075989)(-181.574005 38.924000 451.126984)(-181.963989 38.924000 451.126984)(-182.030014 35.792999 449.824005)(-185.662003 21.164000 456.438995)(-181.645004 41.395500 453.091003)(-181.963989 38.924000 451.126984)(-181.909988 41.462997 453.144989)(-181.994003 45.447102 462.799011)(-182.352005 44.975002 462.700989)(-182.770004 44.549000 464.264984)(-181.994003 45.447102 462.799011)(-182.343002 45.050098 463.532013)(-182.770004 44.549000 464.264984)(-181.850006 -42.749001 473.145996)(-181.824005 -44.380001 470.308990)(-181.679993 -42.776699 473.098022)(-181.824005 -44.380001 470.308990)(-181.766998 -44.380001 470.308990)(-181.679993 -42.776699 473.098022)(-182.664001 -43.738998 468.848999)(-182.522003 -44.486000 467.388977)(-181.824005 -44.380001 470.308990)(-182.522003 -44.486000 467.388977)(-182.664001 -43.738998 468.848999)(-183.231003 -42.904999 468.936005)(-182.522003 -44.486000 467.388977)(-181.815994 -44.977798 468.768005)(-181.824005 -44.380001 470.308990)(-181.766998 -44.380001 470.308990)(-181.768005 -44.384598 470.296997)(-181.824005 -44.380001 470.308990)(-181.768005 -44.384598 470.296997)(-181.815994 -44.977798 468.768005)(-181.824005 -44.380001 470.308990)(-182.522003 -44.486000 467.388977)(-181.834991 -45.183201 468.154999)(-181.815994 -44.977798 468.768005)(-182.059006 -45.473000 464.902985)(-181.914001 -45.526798 465.667999)(-182.522003 -44.486000 467.388977)(-181.914001 -45.526798 465.667999)(-181.891998 -45.439800 466.360992)(-182.522003 -44.486000 467.388977)(-181.891998 -45.439800 466.360992)(-181.834991 -45.183201 468.154999)(-182.522003 -44.486000 467.388977)(-182.705994 -44.516998 465.834991)(-182.059006 -45.473000 464.902985)(-182.522003 -44.486000 467.388977)(-185.662003 -21.164000 456.438995)(-183.993988 -41.234001 458.639008)(-184.498001 -41.145000 460.884979)(-183.993988 -41.234001 458.639008)(-184.049988 -41.582401 459.761993)(-184.498001 -41.145000 460.884979)(-183.785004 -42.111603 459.761993)(-183.264999 -43.174999 459.820984)(-184.498001 -41.145000 460.884979)(-183.993988 -41.234001 458.639008)(-183.264999 -43.174999 459.820984)(-183.785004 -42.111603 459.761993)(-183.993988 -41.234001 458.639008)(-183.785004 -42.111603 459.761993)(-184.049988 -41.582401 459.761993)(-184.498001 -41.145000 460.884979)(-183.264999 -43.174999 459.820984)(-184.744995 -41.005001 464.446991)(-183.264999 -43.174999 459.820984)(-182.542999 -44.611000 461.138000)(-183.718002 -43.040001 464.381012)(-183.264999 -43.174999 459.820984)(-183.718002 -43.040001 464.381012)(-184.744995 -41.005001 464.446991)(-182.542999 -44.611000 461.138000)(-182.770004 -44.549000 464.264984)(-183.718002 -43.040001 464.381012)(-182.352005 -44.975002 462.700989)(-182.770004 -44.549000 464.264984)(-182.542999 -44.611000 461.138000)(-182.542999 -44.611000 461.138000)(-181.970993 -45.429501 462.175018)(-182.352005 -44.975002 462.700989)(-183.718002 -43.040001 464.381012)(-182.770004 -44.549000 464.264984)(-183.684006 -43.006001 465.528992)(-182.352005 -44.975002 462.700989)(-181.994003 -45.447102 462.799011)(-182.770004 -44.549000 464.264984)(-182.343002 -45.050098 463.532013)(-182.000000 -45.454800 462.976013)(-181.994003 -45.447102 462.799011)(-182.770004 -44.549000 464.264984)(-182.343002 -45.050098 463.532013)(-181.994003 -45.447102 462.799011)(-183.731003 -41.280998 457.464996)(-183.264999 -43.174999 459.820984)(-183.993988 -41.234001 458.639008)(-181.970993 -45.429501 462.175018)(-181.994003 -45.447102 462.799011)(-182.352005 -44.975002 462.700989)(-181.951996 -45.611603 464.490997)(-181.967010 -45.590401 463.997009)(-182.000000 -45.799999 462.970001)(-181.967010 -45.590401 463.997009)(-181.959000 -45.582001 464.260010)(-181.951996 -45.611603 464.490997)(-182.000000 -45.799999 462.970001)(-181.951996 -45.611603 464.490997)(-181.914001 -45.526798 465.667999)(-182.038986 -44.842197 459.630005)(-182.542999 -44.611000 461.138000)(-181.832993 -44.672401 458.121979)(-182.038986 -44.842197 459.630005)(-181.930008 -45.375202 461.000000)(-182.542999 -44.611000 461.138000)(-182.000000 -45.799999 462.970001)(-181.970993 -45.429501 462.175018)(-181.930008 -45.375202 461.000000)(-181.994003 -45.447102 462.799011)(-181.970993 -45.429501 462.175018)(-182.000000 -45.799999 462.970001)(-181.930008 -45.375202 461.000000)(-182.038986 -44.842197 459.630005)(-181.838013 -44.763500 458.429993)(-181.838013 -44.763500 458.429993)(-182.038986 -44.842197 459.630005)(-181.832993 -44.672401 458.121979)(-182.542999 44.611000 461.138000)(-182.352005 44.975002 462.700989)(-181.970993 45.429501 462.175018)(-181.930008 45.375202 461.000000)(-182.542999 44.611000 461.138000)(-181.970993 45.429501 462.175018)(-181.511993 33.615997 449.472015)(-181.794998 34.704498 449.647980)(-181.525009 35.682499 449.806000)(-181.525009 35.682499 449.806000)(-181.794998 34.704498 449.647980)(-182.030014 35.792999 449.824005)(-181.511993 33.615997 449.472015)(-182.078003 33.615997 449.472015)(-181.794998 34.704498 449.647980)(-182.239990 25.265001 449.445007)(-182.078003 33.615997 449.472015)(-181.873001 29.440500 449.458984)(-182.078003 33.615997 449.472015)(-182.239990 25.265001 449.445007)(-185.662003 21.164000 456.438995)(-181.504990 25.265001 449.445007)(-182.239990 25.265001 449.445007)(-181.873001 29.440500 449.458984)(-181.504990 24.960199 449.445007)(-182.239990 25.265001 449.445007)(-181.504990 25.265001 449.445007)(-182.291992 21.139999 449.445007)(-182.239990 25.265001 449.445007)(-181.897003 23.202499 449.445007)(-181.897003 23.202499 449.445007)(-182.239990 25.265001 449.445007)(-181.504990 24.960199 449.445007)(-181.501999 21.139999 449.445007)(-182.291992 21.139999 449.445007)(-181.897003 23.202499 449.445007)(-181.504990 25.265001 449.445007)(-181.873001 29.440500 449.458984)(-181.511002 33.134800 449.470001)(-181.930008 45.375202 461.000000)(-181.970993 45.429501 462.175018)(-182.000000 45.799999 462.970001)(-182.000000 45.799999 462.970001)(-181.970993 45.429501 462.175018)(-181.994003 45.447102 462.799011)(-182.395996 12.891000 449.445007)(-182.291992 21.139999 449.445007)(-181.948013 17.015499 449.445007)(-181.525009 12.891000 449.445007)(-182.395996 12.891000 449.445007)(-181.948013 17.015499 449.445007)(-181.500000 17.228500 449.445007)(-181.948013 17.015499 449.445007)(-181.501999 20.481300 449.445007)(-181.525009 12.891000 449.445007)(-181.948013 17.015499 449.445007)(-181.500000 17.228500 449.445007)(-181.531998 11.796700 449.445007)(-181.557999 7.341420 449.445007)(-182.395996 12.891000 449.445007)(-181.531998 11.796700 449.445007)(-182.395996 12.891000 449.445007)(-181.525009 12.891000 449.445007)(-181.511002 33.134800 449.470001)(-181.873001 29.440500 449.458984)(-182.078003 33.615997 449.472015)(-182.059006 45.473000 464.902985)(-182.705994 44.516998 465.834991)(-182.522003 44.486000 467.388977)(-181.914001 45.526798 465.667999)(-182.059006 45.473000 464.902985)(-182.522003 44.486000 467.388977)(-181.951996 45.611603 464.490997)(-182.059006 45.473000 464.902985)(-181.914001 45.526798 465.667999)(-182.059006 45.473000 464.902985)(-181.959000 45.582001 464.260010)(-181.951996 45.611603 464.490997)(-181.914001 45.526798 465.667999)(-181.951996 45.611603 464.490997)(-182.000000 45.799999 462.970001)(-181.768005 44.384598 470.296997)(-181.766998 44.380001 470.308990)(-181.824005 44.380001 470.308990)(-181.815994 44.977798 468.768005)(-181.768005 44.384598 470.296997)(-181.824005 44.380001 470.308990)(-181.815994 44.977798 468.768005)(-182.522003 44.486000 467.388977)(-181.824005 44.380001 470.308990)(-182.522003 44.486000 467.388977)(-182.664001 43.738998 468.848999)(-181.824005 44.380001 470.308990)(-181.891998 45.439800 466.360992)(-182.522003 44.486000 467.388977)(-181.834991 45.183201 468.154999)(-182.664001 43.738998 468.848999)(-183.231003 42.904999 468.936005)(-181.824005 44.380001 470.308990)(-181.850006 42.749001 473.145996)(-181.679993 42.776699 473.098022)(-181.824005 44.380001 470.308990)(-181.679993 42.776699 473.098022)(-181.677994 42.749001 473.145996)(-181.850006 42.749001 473.145996)(-181.824005 44.380001 470.308990)(-183.231003 42.904999 468.936005)(-181.850006 42.749001 473.145996)(-182.000000 45.799999 462.970001)(-181.967010 45.590401 463.997009)(-181.951996 45.611603 464.490997)(-182.000000 45.799999 462.970001)(-182.000000 45.454800 462.976013)(-181.967010 45.590401 463.997009)(-182.000000 45.454800 462.976013)(-182.143005 45.311100 463.487000)(-181.967010 45.590401 463.997009)(-182.000000 45.454800 462.976013)(-181.994003 45.447102 462.799011)(-182.000000 45.799999 462.970001)(-181.832993 44.672401 458.121979)(-182.038986 44.842197 459.630005)(-181.838013 44.763500 458.429993)(-183.718002 43.040001 464.381012)(-184.636002 40.947998 465.911011)(-183.684006 43.006001 465.528992)(-184.744995 41.005001 464.446991)(-184.636002 40.947998 465.911011)(-183.718002 43.040001 464.381012)(-183.264999 43.174999 459.820984)(-184.744995 41.005001 464.446991)(-183.718002 43.040001 464.381012)(-182.542999 44.611000 461.138000)(-183.264999 43.174999 459.820984)(-183.718002 43.040001 464.381012)(-182.542999 44.611000 461.138000)(-183.718002 43.040001 464.381012)(-182.770004 44.549000 464.264984)(-181.832993 44.672401 458.121979)(-183.264999 43.174999 459.820984)(-182.542999 44.611000 461.138000)(-183.993988 41.234001 458.639008)(-184.049988 41.582401 459.761993)(-183.785004 42.111603 459.761993)(-184.049988 41.582401 459.761993)(-184.498001 41.145000 460.884979)(-183.785004 42.111603 459.761993)(-183.785004 42.111603 459.761993)(-184.498001 41.145000 460.884979)(-183.264999 43.174999 459.820984)(-183.264999 43.174999 459.820984)(-184.498001 41.145000 460.884979)(-184.744995 41.005001 464.446991)(-185.662003 21.164000 456.438995)(-184.744995 41.005001 464.446991)(-184.498001 41.145000 460.884979)(-184.498001 41.145000 460.884979)(-183.993988 41.234001 458.639008)(-185.662003 21.164000 456.438995)(-183.993988 41.234001 458.639008)(-183.731003 41.280998 457.464996)(-185.662003 21.164000 456.438995)(-183.731003 41.280998 457.464996)(-182.878998 41.371902 455.285004)(-185.662003 21.164000 456.438995)(-183.731003 41.280998 457.464996)(-181.909988 41.462997 453.144989)(-182.878998 41.371902 455.285004)(-183.731003 41.280998 457.464996)(-183.993988 41.234001 458.639008)(-183.264999 43.174999 459.820984)(-181.832993 44.672401 458.121979)(-182.542999 44.611000 461.138000)(-182.038986 44.842197 459.630005)(-184.049988 41.582401 459.761993)(-183.993988 41.234001 458.639008)(-184.498001 41.145000 460.884979)(-181.850006 42.749001 473.145996)(-181.604004 40.615601 475.529999)(-181.677994 42.749001 473.145996)(-181.600998 40.553997 475.598999)(-181.743988 38.902000 476.592987)(-181.542999 37.382202 477.507996)(-181.542999 37.382202 477.507996)(-181.743988 38.902000 476.592987)(-181.944992 37.250000 477.588013)(-181.600998 40.553997 475.598999)(-181.885010 40.553997 475.598999)(-181.743988 38.902000 476.592987)(-181.604004 40.615601 475.529999)(-181.600998 40.553997 475.598999)(-181.885010 40.553997 475.598999)(-181.885010 40.553997 475.598999)(-181.604004 40.615601 475.529999)(-181.850006 42.749001 473.145996)(-181.539993 37.250000 477.588013)(-181.766998 35.409000 478.003998)(-181.516998 33.751099 478.378998)(-181.539993 37.250000 477.588013)(-181.944992 37.250000 477.588013)(-181.766998 35.409000 478.003998)(-182.017990 33.567997 478.419983)(-181.944992 37.250000 477.588013)(-185.626007 21.236000 471.464996)(-181.944992 37.250000 477.588013)(-181.885010 40.553997 475.598999)(-185.626007 21.236000 471.464996)(-181.944992 37.250000 477.588013)(-182.017990 33.567997 478.419983)(-181.766998 35.409000 478.003998)(-181.516998 33.751099 478.378998)(-181.766998 35.409000 478.003998)(-182.017990 33.567997 478.419983)(-181.959000 45.582001 464.260010)(-182.705994 44.516998 465.834991)(-182.059006 45.473000 464.902985)(-185.662003 21.164000 456.438995)(-182.291992 21.139999 449.445007)(-185.622009 0.539009 456.467987)(-186.770004 21.199999 463.954987)(-185.662003 21.164000 456.438995)(-185.622009 0.539009 456.467987)(-186.770004 21.199999 463.954987)(-185.622009 0.539009 456.467987)(-186.666992 0.539009 463.954987)(-182.447998 -0.294009 449.445007)(-182.447998 0.294009 449.445007)(-181.576004 0.441008 449.445007)(-181.576004 -0.441008 449.445007)(-182.447998 -0.294009 449.445007)(-181.576004 0.441008 449.445007)(-181.557999 -7.341420 449.445007)(-181.989990 -6.592500 449.445007)(-181.576004 -0.441008 449.445007)(-181.989990 -6.592500 449.445007)(-182.447998 -0.294009 449.445007)(-181.576004 -0.441008 449.445007)(-182.447998 0.294009 449.445007)(-182.447998 -0.294009 449.445007)(-185.622009 -0.539009 456.467987)(-185.622009 -0.539009 456.467987)(-182.447998 -0.294009 449.445007)(-182.395996 -12.891000 449.445007)(-181.557999 -7.341420 449.445007)(-182.395996 -12.891000 449.445007)(-181.989990 -6.592500 449.445007)(-185.622009 0.539009 456.467987)(-182.447998 0.294009 449.445007)(-185.622009 -0.539009 456.467987)(-186.666992 0.539009 463.954987)(-185.622009 0.539009 456.467987)(-186.666992 -0.539009 463.954987)(-185.622009 0.539009 456.467987)(-185.622009 -0.539009 456.467987)(-186.666992 -0.539009 463.954987)(-182.395996 12.891000 449.445007)(-182.447998 0.294009 449.445007)(-185.622009 0.539009 456.467987)(-183.684006 43.006001 465.528992)(-184.488998 40.872002 467.869995)(-183.592010 42.972000 466.672974)(-183.684006 43.006001 465.528992)(-183.592010 42.972000 466.672974)(-182.705994 44.516998 465.834991)(-182.705994 44.516998 465.834991)(-183.592010 42.972000 466.672974)(-183.231003 42.904999 468.936005)(-183.231003 42.904999 468.936005)(-183.592010 42.972000 466.672974)(-183.716003 40.736000 471.286011)(-183.972992 40.780998 470.148010)(-186.770004 21.199999 463.954987)(-185.626007 21.236000 471.464996)(-183.716003 40.736000 471.286011)(-183.972992 40.780998 470.148010)(-185.626007 21.236000 471.464996)(-182.914001 40.645000 473.485992)(-183.716003 40.736000 471.286011)(-185.626007 21.236000 471.464996)(-183.972992 40.780998 470.148010)(-184.488998 40.872002 467.869995)(-186.770004 21.199999 463.954987)(-183.231003 42.904999 468.936005)(-183.716003 40.736000 471.286011)(-182.914001 40.645000 473.485992)(-182.914001 40.645000 473.485992)(-181.885010 40.553997 475.598999)(-183.231003 42.904999 468.936005)(-184.636002 40.947998 465.911011)(-186.770004 21.199999 463.954987)(-184.488998 40.872002 467.869995)(-185.626007 21.236000 471.464996)(-186.770004 21.199999 463.954987)(-186.666992 0.539009 463.954987)(-183.592010 42.972000 466.672974)(-183.972992 40.780998 470.148010)(-183.716003 40.736000 471.286011)(-181.967010 45.590401 463.997009)(-182.770004 44.549000 464.264984)(-181.959000 45.582001 464.260010)(-182.343002 45.050098 463.532013)(-182.770004 44.549000 464.264984)(-181.967010 45.590401 463.997009)(-181.959000 45.582001 464.260010)(-182.770004 44.549000 464.264984)(-182.705994 44.516998 465.834991)(-182.770004 44.549000 464.264984)(-183.684006 43.006001 465.528992)(-182.705994 44.516998 465.834991)(-181.576004 0.441008 449.445007)(-182.447998 0.294009 449.445007)(-181.989990 6.592500 449.445007)(-185.622009 -0.539009 456.467987)(-182.395996 -12.891000 449.445007)(-182.291992 -21.139999 449.445007)(-181.501999 20.481300 449.445007)(-182.291992 21.139999 449.445007)(-181.501999 21.139999 449.445007)(-181.850006 -42.749001 473.145996)(-181.677994 -42.749001 473.145996)(-181.604004 -40.615601 475.529999)(-181.527008 -13.635000 478.445007)(-181.527008 -12.981000 478.445007)(-182.325012 -12.981000 478.445007)(-181.923996 -17.120001 478.445007)(-181.527008 -13.635000 478.445007)(-182.325012 -12.981000 478.445007)(-181.522003 -21.547600 478.445007)(-181.522003 -21.259001 478.445007)(-182.223007 -21.259001 478.445007)(-182.325012 -12.981000 478.445007)(-181.527008 -12.981000 478.445007)(-181.529999 -7.748500 478.445007)(-182.173004 25.397999 478.445007)(-185.626007 21.236000 471.464996)(-182.223007 21.259001 478.445007)(-181.871002 23.328501 478.445007)(-182.173004 25.397999 478.445007)(-182.223007 21.259001 478.445007)(-182.223007 21.259001 478.445007)(-181.522003 21.547600 478.445007)(-181.871002 23.328501 478.445007)(-181.520004 25.397999 478.445007)(-181.871002 23.328501 478.445007)(-181.522003 21.547600 478.445007)(-181.871002 23.328501 478.445007)(-181.520004 25.397999 478.445007)(-182.173004 25.397999 478.445007)(-181.520004 25.397999 478.445007)(-181.520004 25.923698 478.442993)(-182.173004 25.397999 478.445007)(-182.173004 25.397999 478.445007)(-181.843994 29.483000 478.432007)(-182.017990 33.567997 478.419983)(-181.516006 33.567997 478.419983)(-182.017990 33.567997 478.419983)(-181.843994 29.483000 478.432007)(-181.520004 25.923698 478.442993)(-181.843994 29.483000 478.432007)(-182.173004 25.397999 478.445007)(-182.223007 21.259001 478.445007)(-185.626007 21.236000 471.464996)(-185.585007 0.539009 471.437012)(-181.516006 33.567997 478.419983)(-181.843994 29.483000 478.432007)(-181.520004 25.923698 478.442993)(-185.585007 0.539009 471.437012)(-182.325012 12.981000 478.445007)(-182.223007 21.259001 478.445007)(-181.522003 -21.547600 478.445007)(-181.871002 -23.328501 478.445007)(-181.520004 -25.397999 478.445007)(-182.173004 -25.397999 478.445007)(-181.520004 -25.397999 478.445007)(-181.871002 -23.328501 478.445007)(-182.223007 -21.259001 478.445007)(-182.173004 -25.397999 478.445007)(-181.871002 -23.328501 478.445007)(-182.223007 -21.259001 478.445007)(-185.626007 -21.236000 471.464996)(-182.173004 -25.397999 478.445007)(-181.885010 -40.553997 475.598999)(-181.850006 -42.749001 473.145996)(-181.604004 -40.615601 475.529999)(-181.600998 -40.553997 475.598999)(-181.604004 -40.615601 475.529999)(-181.885010 -40.553997 475.598999)(-183.231003 -42.904999 468.936005)(-181.850006 -42.749001 473.145996)(-181.885010 -40.553997 475.598999)(-181.885010 -40.553997 475.598999)(-182.914001 -40.645000 473.485992)(-183.231003 -42.904999 468.936005)(-185.626007 -21.236000 471.464996)(-182.914001 -40.645000 473.485992)(-181.885010 -40.553997 475.598999)(-185.626007 -21.236000 471.464996)(-183.716003 -40.736000 471.286011)(-182.914001 -40.645000 473.485992)(-183.592010 -42.972000 466.672974)(-183.231003 -42.904999 468.936005)(-183.716003 -40.736000 471.286011)(-183.972992 -40.780998 470.148010)(-183.592010 -42.972000 466.672974)(-183.716003 -40.736000 471.286011)(-182.375992 -0.294010 478.445007)(-185.585007 -0.539009 471.437012)(-182.325012 -12.981000 478.445007)(-185.585007 -0.539009 471.437012)(-182.375992 -0.294010 478.445007)(-182.375992 0.294010 478.445007)(-181.529999 1.361440 478.445007)(-182.375992 0.294010 478.445007)(-181.529999 -1.361440 478.445007)(-182.375992 0.294010 478.445007)(-181.529999 1.361440 478.445007)(-181.951996 6.637510 478.445007)(-185.585007 0.539009 471.437012)(-185.585007 -0.539009 471.437012)(-182.375992 0.294010 478.445007)(-185.585007 0.539009 471.437012)(-182.375992 0.294010 478.445007)(-182.325012 12.981000 478.445007)(-181.529999 7.748500 478.445007)(-181.951996 6.637510 478.445007)(-181.529999 1.361440 478.445007)(-181.529999 7.748500 478.445007)(-182.325012 12.981000 478.445007)(-181.951996 6.637510 478.445007)(-181.529999 7.748500 478.445007)(-181.527008 12.981000 478.445007)(-182.325012 12.981000 478.445007)(-182.325012 12.981000 478.445007)(-182.375992 0.294010 478.445007)(-181.951996 6.637510 478.445007)(-181.527008 12.981000 478.445007)(-181.527008 13.635000 478.445007)(-182.325012 12.981000 478.445007)(-185.585007 0.539009 471.437012)(-186.666992 -0.539009 463.954987)(-185.585007 -0.539009 471.437012)(-185.585007 -0.539009 471.437012)(-185.626007 -21.236000 471.464996)(-182.223007 -21.259001 478.445007)(-185.585007 -0.539009 471.437012)(-186.666992 -0.539009 463.954987)(-185.626007 -21.236000 471.464996)(-186.770004 -21.199999 463.954987)(-185.626007 -21.236000 471.464996)(-186.666992 -0.539009 463.954987)(-185.626007 -21.236000 471.464996)(-186.770004 -21.199999 463.954987)(-183.972992 -40.780998 470.148010)(-186.770004 -21.199999 463.954987)(-184.488998 -40.872002 467.869995)(-183.972992 -40.780998 470.148010)(-183.972992 -40.780998 470.148010)(-183.716003 -40.736000 471.286011)(-185.626007 -21.236000 471.464996)(-184.636002 -40.947998 465.911011)(-184.488998 -40.872002 467.869995)(-186.770004 -21.199999 463.954987)(-183.684006 -43.006001 465.528992)(-183.592010 -42.972000 466.672974)(-184.488998 -40.872002 467.869995)(-183.684006 -43.006001 465.528992)(-182.705994 -44.516998 465.834991)(-183.592010 -42.972000 466.672974)(-184.636002 -40.947998 465.911011)(-183.684006 -43.006001 465.528992)(-184.488998 -40.872002 467.869995)(-182.325012 -12.981000 478.445007)(-185.585007 -0.539009 471.437012)(-182.223007 -21.259001 478.445007)(-182.173004 -25.397999 478.445007)(-185.626007 -21.236000 471.464996)(-182.017990 -33.567997 478.419983)(-182.017990 -33.567997 478.419983)(-185.626007 -21.236000 471.464996)(-181.944992 -37.250000 477.588013)(-181.600998 -40.553997 475.598999)(-181.743988 -38.902000 476.592987)(-181.885010 -40.553997 475.598999)(-181.766998 -35.409000 478.003998)(-182.017990 -33.567997 478.419983)(-181.944992 -37.250000 477.588013)(-181.539993 -37.250000 477.588013)(-181.766998 -35.409000 478.003998)(-181.944992 -37.250000 477.588013)(-181.516998 -33.751099 478.378998)(-182.017990 -33.567997 478.419983)(-181.766998 -35.409000 478.003998)(-182.017990 -33.567997 478.419983)(-181.516006 -33.567997 478.419983)(-181.516998 -33.751099 478.378998)(-181.520004 -25.923698 478.442993)(-181.843994 -29.483000 478.432007)(-181.516006 -33.567997 478.419983)(-181.520004 -25.923698 478.442993)(-182.173004 -25.397999 478.445007)(-181.843994 -29.483000 478.432007)(-181.516006 -33.567997 478.419983)(-181.843994 -29.483000 478.432007)(-182.017990 -33.567997 478.419983)(-181.516998 -33.751099 478.378998)(-181.766998 -35.409000 478.003998)(-181.539993 -37.250000 477.588013)(-181.522003 21.259001 478.445007)(-181.522003 21.547600 478.445007)(-182.223007 21.259001 478.445007)(-181.527008 13.635000 478.445007)(-181.522003 21.259001 478.445007)(-181.923996 17.120001 478.445007)(-181.923996 17.120001 478.445007)(-181.522003 21.259001 478.445007)(-182.223007 21.259001 478.445007)(-183.716003 -40.736000 471.286011)(-183.231003 -42.904999 468.936005)(-182.914001 -40.645000 473.485992)(-181.944992 -37.250000 477.588013)(-185.626007 -21.236000 471.464996)(-181.885010 -40.553997 475.598999)(-182.017990 -33.567997 478.419983)(-181.843994 -29.483000 478.432007)(-182.173004 -25.397999 478.445007)(-181.951996 -6.637510 478.445007)(-182.375992 -0.294010 478.445007)(-182.325012 -12.981000 478.445007)(-181.951996 -6.637510 478.445007)(-182.325012 -12.981000 478.445007)(-181.529999 -7.748500 478.445007)(-181.529999 -1.361440 478.445007)(-181.951996 -6.637510 478.445007)(-181.529999 -7.748500 478.445007)(-181.951996 -6.637510 478.445007)(-181.529999 -1.361440 478.445007)(-182.375992 -0.294010 478.445007)(-184.488998 -40.872002 467.869995)(-183.592010 -42.972000 466.672974)(-183.972992 -40.780998 470.148010)(-182.395996 -12.891000 449.445007)(-182.447998 -0.294009 449.445007)(-181.989990 -6.592500 449.445007)(-182.522003 44.486000 467.388977)(-183.231003 42.904999 468.936005)(-182.664001 43.738998 468.848999)(-182.542999 -44.611000 461.138000)(-181.930008 -45.375202 461.000000)(-181.970993 -45.429501 462.175018)(-183.592010 -42.972000 466.672974)(-182.705994 -44.516998 465.834991)(-183.231003 -42.904999 468.936005)(-181.944992 -37.250000 477.588013)(-181.539993 -37.250000 477.588013)(-181.542999 -37.382202 477.507996)(-182.000000 45.454800 462.976013)(-182.343002 45.050098 463.532013)(-182.143005 45.311100 463.487000)(-181.948013 17.015499 449.445007)(-182.291992 21.139999 449.445007)(-181.501999 20.481300 449.445007)(-181.989990 6.592500 449.445007)(-182.447998 0.294009 449.445007)(-182.395996 12.891000 449.445007)(-186.666992 -0.539009 463.954987)(-185.585007 0.539009 471.437012)(-186.666992 0.539009 463.954987)(-181.871002 -23.328501 478.445007)(-181.522003 -21.547600 478.445007)(-182.223007 -21.259001 478.445007)(-182.375992 0.294010 478.445007)(-182.375992 -0.294010 478.445007)(-181.529999 -1.361440 478.445007)(-182.705994 44.516998 465.834991)(-183.231003 42.904999 468.936005)(-182.522003 44.486000 467.388977)(-181.869995 43.308998 455.483002)(-183.264999 43.174999 459.820984)(-181.832993 44.672401 458.121979)(-181.869995 43.308998 455.483002)(-181.909988 41.462997 453.144989)(-183.264999 43.174999 459.820984)(-181.869995 43.308998 455.483002)(-181.731003 43.294701 455.464996)(-181.909988 41.462997 453.144989)(-181.869995 43.308998 455.483002)(-181.832993 44.672401 458.121979)(-181.731003 43.294701 455.464996)(-181.909988 41.462997 453.144989)(-181.731003 43.294701 455.464996)(-181.647003 41.462997 453.144989)(-181.850006 42.749001 473.145996)(-183.231003 42.904999 468.936005)(-181.885010 40.553997 475.598999)(-184.498001 -41.145000 460.884979)(-184.744995 -41.005001 464.446991)(-185.662003 -21.164000 456.438995)(-184.744995 -41.005001 464.446991)(-186.770004 -21.199999 463.954987)(-185.662003 -21.164000 456.438995)(-185.622009 -0.539009 456.467987)(-185.662003 -21.164000 456.438995)(-186.770004 -21.199999 463.954987)(-181.885010 40.553997 475.598999)(-182.914001 40.645000 473.485992)(-185.626007 21.236000 471.464996)(-183.993988 41.234001 458.639008)(-183.785004 42.111603 459.761993)(-183.264999 43.174999 459.820984)(-186.666992 -0.539009 463.954987)(-185.622009 -0.539009 456.467987)(-186.770004 -21.199999 463.954987)(-182.223007 -21.259001 478.445007)(-181.522003 -21.259001 478.445007)(-181.923996 -17.120001 478.445007)(-181.511002 -33.134800 449.470001)(-181.873001 -29.440500 449.458984)(-181.504990 -25.265001 449.445007)(-185.662003 -21.164000 456.438995)(-182.030014 -35.792999 449.824005)(-181.963989 -38.924000 451.126984)(-181.677994 -42.749001 473.145996)(-181.679993 -42.776699 473.098022)(-181.850006 -42.749001 473.145996)(-181.944992 37.250000 477.588013)(-181.542999 37.382202 477.507996)(-181.539993 37.250000 477.588013)(-182.038986 44.842197 459.630005)(-182.542999 44.611000 461.138000)(-181.930008 45.375202 461.000000)(-181.948013 -17.015499 449.445007)(-182.291992 -21.139999 449.445007)(-182.395996 -12.891000 449.445007)(-181.948013 -17.015499 449.445007)(-182.395996 -12.891000 449.445007)(-181.525009 -12.891000 449.445007)(-181.525009 35.792999 449.824005)(-182.030014 35.792999 449.824005)(-181.778000 37.358501 450.475983)(-181.909988 41.462997 453.144989)(-181.645004 41.395500 453.091003)(-181.647003 41.462997 453.144989)(-182.143005 45.311100 463.487000)(-182.343002 45.050098 463.532013)(-181.967010 45.590401 463.997009)(-181.576004 0.441008 449.445007)(-181.989990 6.592500 449.445007)(-181.557999 7.341420 449.445007)(-185.626007 21.236000 471.464996)(-186.666992 0.539009 463.954987)(-185.585007 0.539009 471.437012)(-182.017990 33.567997 478.419983)(-185.626007 21.236000 471.464996)(-182.173004 25.397999 478.445007)(-183.718002 43.040001 464.381012)(-183.684006 43.006001 465.528992)(-182.770004 44.549000 464.264984)(-181.951996 -45.611603 464.490997)(-181.959000 -45.582001 464.260010)(-182.059006 -45.473000 464.902985)(-182.878998 41.371902 455.285004)(-181.909988 41.462997 453.144989)(-185.662003 21.164000 456.438995)(-185.662003 -21.164000 456.438995)(-181.963989 -38.924000 451.126984)(-181.909988 -41.462997 453.144989)(-185.662003 -21.164000 456.438995)(-181.909988 -41.462997 453.144989)(-182.878998 -41.371902 455.285004)(-183.731003 -41.280998 457.464996)(-182.878998 -41.371902 455.285004)(-181.909988 -41.462997 453.144989)(-185.662003 -21.164000 456.438995)(-182.878998 -41.371902 455.285004)(-183.731003 -41.280998 457.464996)(-181.525009 35.792999 449.824005)(-181.778000 37.358501 450.475983)(-181.572006 38.800499 451.075989)(-184.744995 -41.005001 464.446991)(-184.636002 -40.947998 465.911011)(-186.770004 -21.199999 463.954987)(-181.951996 45.611603 464.490997)(-181.959000 45.582001 464.260010)(-181.967010 45.590401 463.997009)(-181.511993 33.615997 449.472015)(-181.511002 33.134800 449.470001)(-182.078003 33.615997 449.472015)(-181.824005 44.380001 470.308990)(-181.679993 42.776699 473.098022)(-181.766998 44.380001 470.308990)(-181.743988 38.902000 476.592987)(-181.885010 40.553997 475.598999)(-181.944992 37.250000 477.588013)(-184.744995 -41.005001 464.446991)(-183.718002 -43.040001 464.381012)(-184.636002 -40.947998 465.911011)(-181.838013 44.763500 458.429993)(-182.038986 44.842197 459.630005)(-181.930008 45.375202 461.000000)(-181.743988 -38.902000 476.592987)(-181.944992 -37.250000 477.588013)(-181.885010 -40.553997 475.598999)(-185.622009 -0.539009 456.467987)(-182.291992 -21.139999 449.445007)(-185.662003 -21.164000 456.438995)(-181.525009 -12.891000 449.445007)(-182.395996 -12.891000 449.445007)(-181.531998 -11.796700 449.445007)(-181.909988 -41.462997 453.144989)(-181.647003 -41.462997 453.144989)(-181.731003 -43.294701 455.464996)(-182.664001 -43.738998 468.848999)(-181.824005 -44.380001 470.308990)(-183.231003 -42.904999 468.936005)(-181.500000 -17.228500 449.445007)(-181.948013 -17.015499 449.445007)(-181.525009 -12.891000 449.445007)(-181.914001 -45.526798 465.667999)(-182.059006 -45.473000 464.902985)(-181.951996 -45.611603 464.490997)(-185.662003 -21.164000 456.438995)(-183.731003 -41.280998 457.464996)(-183.993988 -41.234001 458.639008)(-181.834991 45.183201 468.154999)(-182.522003 44.486000 467.388977)(-181.815994 44.977798 468.768005)(-181.525009 -35.682499 449.806000)(-182.030014 -35.792999 449.824005)(-181.794998 -34.704498 449.647980)(-182.000000 -45.799999 462.970001)(-181.994003 -45.447102 462.799011)(-182.000000 -45.454800 462.976013)(-181.959000 -45.582001 464.260010)(-182.059006 -45.473000 464.902985)(-182.705994 -44.516998 465.834991)(-181.504990 -24.960199 449.445007)(-182.239990 -25.265001 449.445007)(-181.897003 -23.202499 449.445007)(-181.794998 34.704498 449.647980)(-182.078003 33.615997 449.472015)(-182.030014 35.792999 449.824005)(-182.395996 12.891000 449.445007)(-185.622009 0.539009 456.467987)(-182.291992 21.139999 449.445007)(-183.231003 -42.904999 468.936005)(-181.824005 -44.380001 470.308990)(-181.850006 -42.749001 473.145996)(-183.264999 -43.174999 459.820984)(-183.731003 -41.280998 457.464996)(-181.909988 -41.462997 453.144989)(-184.744995 41.005001 464.446991)(-186.770004 21.199999 463.954987)(-184.636002 40.947998 465.911011)(-181.501999 21.139999 449.445007)(-181.897003 23.202499 449.445007)(-181.504990 24.960199 449.445007)(-182.239990 25.265001 449.445007)(-182.291992 21.139999 449.445007)(-185.662003 21.164000 456.438995)(-181.520004 -25.923698 478.442993)(-181.520004 -25.397999 478.445007)(-182.173004 -25.397999 478.445007)(-182.030014 35.792999 449.824005)(-182.078003 33.615997 449.472015)(-185.662003 21.164000 456.438995)(-181.542999 -37.382202 477.507996)(-181.944992 -37.250000 477.588013)(-181.743988 -38.902000 476.592987)(-181.527008 -13.635000 478.445007)(-181.923996 -17.120001 478.445007)(-181.522003 -21.259001 478.445007)(-185.662003 21.164000 456.438995)(-186.770004 21.199999 463.954987)(-184.744995 41.005001 464.446991)(-181.557999 7.341420 449.445007)(-181.989990 6.592500 449.445007)(-182.395996 12.891000 449.445007)(-181.542999 -37.382202 477.507996)(-181.743988 -38.902000 476.592987)(-181.600998 -40.553997 475.598999)(-182.343002 45.050098 463.532013)(-181.994003 45.447102 462.799011)(-182.000000 45.454800 462.976013)(-184.049988 -41.582401 459.761993)(-183.785004 -42.111603 459.761993)(-184.498001 -41.145000 460.884979)(-181.914001 45.526798 465.667999)(-182.522003 44.486000 467.388977)(-181.891998 45.439800 466.360992)(-182.705994 -44.516998 465.834991)(-182.522003 -44.486000 467.388977)(-183.231003 -42.904999 468.936005)(-183.684006 43.006001 465.528992)(-184.636002 40.947998 465.911011)(-184.488998 40.872002 467.869995)(-182.000000 -45.454800 462.976013)(-182.143005 -45.311100 463.487000)(-182.343002 -45.050098 463.532013)(-182.223007 21.259001 478.445007)(-182.325012 12.981000 478.445007)(-181.923996 17.120001 478.445007)(-182.325012 12.981000 478.445007)(-181.527008 13.635000 478.445007)(-181.923996 17.120001 478.445007)(-181.909988 41.462997 453.144989)(-183.731003 41.280998 457.464996)(-183.264999 43.174999 459.820984)(-182.017990 33.567997 478.419983)(-181.516998 33.751099 478.378998)(-181.516006 33.567997 478.419983)(-182.542999 44.611000 461.138000)(-182.770004 44.549000 464.264984)(-182.352005 44.975002 462.700989)(-181.909988 41.462997 453.144989)(-181.963989 38.924000 451.126984)(-185.662003 21.164000 456.438995)(-182.325012 -12.981000 478.445007)(-182.223007 -21.259001 478.445007)(-181.923996 -17.120001 478.445007)(-182.030014 35.792999 449.824005)(-181.525009 35.682499 449.806000)(-181.525009 35.792999 449.824005)(-181.511002 -33.134800 449.470001)(-181.511993 -33.615997 449.472015)(-182.078003 -33.615997 449.472015)(-181.970993 45.429501 462.175018)(-182.352005 44.975002 462.700989)(-181.994003 45.447102 462.799011)(-182.343002 -45.050098 463.532013)(-181.967010 -45.590401 463.997009)(-182.770004 -44.549000 464.264984)(-183.592010 42.972000 466.672974)(-184.488998 40.872002 467.869995)(-183.972992 40.780998 470.148010)(-182.770004 -44.549000 464.264984)(-182.705994 -44.516998 465.834991)(-183.684006 -43.006001 465.528992)(-183.718002 -43.040001 464.381012)(-183.684006 -43.006001 465.528992)(-184.636002 -40.947998 465.911011)(-181.531998 -11.796700 449.445007)(-182.395996 -12.891000 449.445007)(-181.557999 -7.341420 449.445007)(28.865000 166.727005 529.002014)(27.898001 184.147003 525.343018)(-17.415001 155.074997 531.200989)(27.898001 184.147003 525.343018)(-16.909000 166.010010 529.140991)(-17.415001 155.074997 531.200989)(30.250999 126.840996 535.477966)(29.966000 138.363998 533.869995)(-18.422001 116.231003 536.732971)(29.966000 138.363998 533.869995)(-18.277000 125.980003 535.587036)(-18.422001 116.231003 536.732971)(-18.277000 125.980003 535.587036)(-24.553999 137.067001 519.904968)(-18.422001 116.231003 536.732971)(-17.415001 155.074997 531.200989)(-24.553999 137.067001 519.904968)(-18.000000 137.470001 534.000000)(-24.553999 137.067001 519.904968)(-18.277000 125.980003 535.587036)(-18.000000 137.470001 534.000000)(29.382000 155.634003 531.104004)(-18.000000 137.470001 534.000000)(-18.277000 125.980003 535.587036)(-24.553999 137.067001 519.904968)(-27.730000 109.431999 515.903992)(-18.422001 116.231003 536.732971)(-24.553999 137.067001 519.904968)(-28.597301 123.250000 509.487976)(-27.730000 109.431999 515.903992)(-28.597301 123.250000 509.487976)(-24.553999 137.067001 519.904968)(-32.288998 114.680000 498.968018)(36.495998 138.225006 519.828979)(38.880001 123.503998 516.132996)(42.614002 110.850998 509.056976)(36.495998 138.225006 519.828979)(42.782001 144.342010 505.160980)(34.765003 168.787003 517.477966)(34.765003 168.787003 517.477966)(32.735600 153.505997 524.613037)(36.495998 138.225006 519.828979)(29.382000 155.634003 531.104004)(32.735600 153.505997 524.613037)(34.765003 168.787003 517.477966)(42.614002 110.850998 509.056976)(42.782001 144.342010 505.160980)(36.495998 138.225006 519.828979)(42.782001 144.342010 505.160980)(42.614002 110.850998 509.056976)(44.333000 113.764999 497.681000)(42.851002 146.615005 495.161011)(42.782001 144.342010 505.160980)(44.333000 113.764999 497.681000)(42.851002 146.615005 495.161011)(44.333000 113.764999 497.681000)(43.039898 113.545998 495.481995)(41.850101 115.831001 495.582001)(42.851002 146.615005 495.161011)(43.039898 113.545998 495.481995)(41.850101 115.831001 495.582001)(38.940701 115.742996 495.884003)(42.851002 146.615005 495.161011)(38.940701 115.742996 495.884003)(36.775997 207.522003 495.162018)(42.851002 146.615005 495.161011)(35.325401 166.192993 495.523010)(36.775997 207.522003 495.162018)(38.940701 115.742996 495.884003)(36.775997 207.522003 495.162018)(40.570000 174.052002 505.160980)(42.851002 146.615005 495.161011)(28.616800 115.555000 495.963013)(11.581401 168.929001 495.562988)(21.304001 221.847992 495.162018)(28.616800 115.555000 495.963013)(10.479900 115.243004 495.968994)(11.581401 168.929001 495.562988)(10.479900 115.243004 495.968994)(-5.454000 222.615997 495.162018)(11.581401 168.929001 495.562988)(10.479900 115.243004 495.968994)(-2.983560 168.862991 495.552979)(-5.454000 222.615997 495.162018)(10.479900 115.243004 495.968994)(2.565930 115.108994 495.950989)(-2.983560 168.862991 495.552979)(36.662003 207.233002 505.161987)(40.570000 174.052002 505.160980)(36.775997 207.522003 495.162018)(21.304001 221.847992 495.162018)(-5.454000 222.441010 505.161987)(5.425000 222.441010 505.161987)(22.799000 221.273010 505.161987)(21.304001 221.847992 495.162018)(5.425000 222.441010 505.161987)(22.799000 221.273010 505.161987)(5.425000 222.441010 505.161987)(5.415000 209.865997 513.713013)(20.683001 209.529999 513.751953)(22.799000 221.273010 505.161987)(5.415000 209.865997 513.713013)(5.415000 209.865997 513.713013)(-15.921000 183.938004 525.391968)(20.683001 209.529999 513.751953)(-5.454000 222.441010 505.161987)(21.304001 221.847992 495.162018)(-5.454000 222.615997 495.162018)(-5.454000 222.615997 495.162018)(-16.907001 218.152008 505.161987)(-5.454000 222.441010 505.161987)(24.948002 196.932999 521.754028)(20.683001 209.529999 513.751953)(-15.921000 183.938004 525.391968)(-18.406000 201.539993 514.411987)(-22.856001 167.634003 517.579956)(-16.909000 166.010010 529.140991)(-15.921000 183.938004 525.391968)(-18.406000 201.539993 514.411987)(-16.909000 166.010010 529.140991)(-18.406000 201.539993 514.411987)(-15.921000 183.938004 525.391968)(-9.838000 209.233002 513.782959)(-18.406000 201.539993 514.411987)(-24.258999 208.572998 505.161987)(-22.856001 167.634003 517.579956)(-15.921000 183.938004 525.391968)(-16.909000 166.010010 529.140991)(24.948002 196.932999 521.754028)(34.765003 168.787003 517.477966)(36.662003 207.233002 505.161987)(29.814999 202.535004 514.326965)(36.662003 207.233002 505.161987)(34.765003 168.787003 517.477966)(40.570000 174.052002 505.160980)(34.765003 168.787003 517.477966)(29.814999 202.535004 514.326965)(27.898001 184.147003 525.343018)(29.814999 202.535004 514.326965)(24.948002 196.932999 521.754028)(27.898001 184.147003 525.343018)(29.814999 202.535004 514.326965)(20.683001 209.529999 513.751953)(24.948002 196.932999 521.754028)(-16.909000 166.010010 529.140991)(27.898001 184.147003 525.343018)(24.948002 196.932999 521.754028)(-16.909000 166.010010 529.140991)(-22.856001 167.634003 517.579956)(-17.415001 155.074997 531.200989)(-16.447001 218.894012 495.162018)(-2.983560 168.862991 495.552979)(2.565930 115.108994 495.950989)(-24.786999 207.522003 495.162018)(-11.110300 166.942001 495.522003)(-4.825290 114.990005 495.889984)(2.565930 115.108994 495.950989)(-4.825290 114.990005 495.889984)(-11.110300 166.942001 495.522003)(-4.825290 114.990005 495.889984)(-22.387800 114.437996 497.869995)(-24.786999 207.522003 495.162018)(-22.387800 114.437996 497.869995)(-32.288998 114.680000 498.968018)(-24.786999 207.522003 495.162018)(-11.110300 166.942001 495.522003)(-16.447001 218.894012 495.162018)(2.565930 115.108994 495.950989)(-16.907001 218.152008 505.161987)(-18.406000 201.539993 514.411987)(-9.838000 209.233002 513.782959)(28.441700 168.702011 495.548981)(28.616800 115.555000 495.963013)(21.304001 221.847992 495.162018)(31.709999 216.707001 495.162018)(28.441700 168.702011 495.548981)(21.304001 221.847992 495.162018)(29.814999 202.535004 514.326965)(36.662003 207.233002 505.161987)(32.177002 215.849991 505.161987)(32.177002 215.849991 505.161987)(22.799000 221.273010 505.161987)(29.814999 202.535004 514.326965)(31.709999 216.707001 495.162018)(36.775997 207.522003 495.162018)(35.325401 166.192993 495.523010)(31.709999 216.707001 495.162018)(35.325401 166.192993 495.523010)(35.579300 115.677994 495.934998)(-5.454000 222.441010 505.161987)(-16.907001 218.152008 505.161987)(-9.838000 209.233002 513.782959)(5.415000 209.865997 513.713013)(-5.454000 222.441010 505.161987)(-9.838000 209.233002 513.782959)(40.570000 174.052002 505.160980)(42.782001 144.342010 505.160980)(42.851002 146.615005 495.161011)(-24.258999 208.572998 505.161987)(-18.406000 201.539993 514.411987)(-16.907001 218.152008 505.161987)(-24.786999 207.522003 495.162018)(-16.907001 218.152008 505.161987)(-16.447001 218.894012 495.162018)(-24.258999 208.572998 505.161987)(-16.907001 218.152008 505.161987)(-24.786999 207.522003 495.162018)(-24.786999 207.522003 495.162018)(-28.607000 173.621002 505.161987)(-24.258999 208.572998 505.161987)(-28.607000 173.621002 505.161987)(-24.786999 207.522003 495.162018)(-30.945999 141.824005 505.161987)(-11.110300 166.942001 495.522003)(-24.786999 207.522003 495.162018)(-16.447001 218.894012 495.162018)(36.775997 207.522003 495.162018)(32.177002 215.849991 505.161987)(36.662003 207.233002 505.161987)(-5.454000 222.441010 505.161987)(5.415000 209.865997 513.713013)(5.425000 222.441010 505.161987)(-24.258999 208.572998 505.161987)(-28.607000 173.621002 505.161987)(-22.856001 167.634003 517.579956)(21.304001 221.847992 495.162018)(11.581401 168.929001 495.562988)(-5.454000 222.615997 495.162018)(35.579300 115.677994 495.934998)(28.441700 168.702011 495.548981)(31.709999 216.707001 495.162018)(-17.415001 155.074997 531.200989)(-22.856001 167.634003 517.579956)(-24.553999 137.067001 519.904968)(-22.856001 167.634003 517.579956)(-30.945999 141.824005 505.161987)(-24.553999 137.067001 519.904968)(32.735600 153.505997 524.613037)(29.382000 155.634003 531.104004)(36.495998 138.225006 519.828979)(29.382000 155.634003 531.104004)(29.966000 138.363998 533.869995)(36.495998 138.225006 519.828979)(-9.838000 209.233002 513.782959)(-15.921000 183.938004 525.391968)(5.415000 209.865997 513.713013)(40.570000 174.052002 505.160980)(34.765003 168.787003 517.477966)(42.782001 144.342010 505.160980)(30.945999 112.570000 535.922974)(30.250999 126.840996 535.477966)(-18.422001 116.231003 536.732971)(36.495998 138.225006 519.828979)(30.250999 126.840996 535.477966)(30.945999 112.570000 535.922974)(30.945999 112.570000 535.922974)(35.002499 108.396004 526.828003)(36.495998 138.225006 519.828979)(-22.856001 167.634003 517.579956)(-28.607000 173.621002 505.161987)(-30.945999 141.824005 505.161987)(29.966000 138.363998 533.869995)(29.382000 155.634003 531.104004)(-18.277000 125.980003 535.587036)(29.814999 202.535004 514.326965)(22.799000 221.273010 505.161987)(20.683001 209.529999 513.751953)(22.799000 221.273010 505.161987)(32.177002 215.849991 505.161987)(31.709999 216.707001 495.162018)(28.865000 166.727005 529.002014)(29.382000 155.634003 531.104004)(34.765003 168.787003 517.477966)(32.177002 215.849991 505.161987)(36.775997 207.522003 495.162018)(31.709999 216.707001 495.162018)(29.382000 155.634003 531.104004)(28.865000 166.727005 529.002014)(-18.000000 137.470001 534.000000)(28.865000 166.727005 529.002014)(34.765003 168.787003 517.477966)(27.898001 184.147003 525.343018)(38.940701 115.742996 495.884003)(35.579300 115.677994 495.934998)(35.325401 166.192993 495.523010)(-24.553999 137.067001 519.904968)(-30.945999 141.824005 505.161987)(-32.288998 114.680000 498.968018)(35.579300 115.677994 495.934998)(28.616800 115.555000 495.963013)(28.441700 168.702011 495.548981)(31.709999 216.707001 495.162018)(21.304001 221.847992 495.162018)(22.799000 221.273010 505.161987)(-5.454000 222.615997 495.162018)(-2.983560 168.862991 495.552979)(-16.447001 218.894012 495.162018)(28.865000 166.727005 529.002014)(-17.415001 155.074997 531.200989)(-18.000000 137.470001 534.000000)(-30.945999 141.824005 505.161987)(-24.786999 207.522003 495.162018)(-32.288998 114.680000 498.968018)(38.880001 123.503998 516.132996)(36.495998 138.225006 519.828979)(35.002499 108.396004 526.828003)(-16.907001 218.152008 505.161987)(-5.454000 222.615997 495.162018)(-16.447001 218.894012 495.162018)(30.250999 126.840996 535.477966)(36.495998 138.225006 519.828979)(29.966000 138.363998 533.869995)(-16.271900 106.265999 536.718994)(-11.589200 106.377998 536.640991)(-18.422001 116.231003 536.732971)(20.557201 107.150002 536.106995)(6.262110 111.249001 536.334961)(-11.589200 106.377998 536.640991)(30.945999 112.570000 535.922974)(6.262110 111.249001 536.334961)(20.557201 107.150002 536.106995)(30.941299 107.333000 535.933960)(30.945999 112.570000 535.922974)(20.557201 107.150002 536.106995)(30.945999 112.570000 535.922974)(30.941299 107.333000 535.933960)(31.407400 107.657997 534.888977)(30.945999 112.570000 535.922974)(31.407400 107.657997 534.888977)(31.999201 107.987000 533.562012)(-18.422001 106.220001 536.732971)(-16.271900 106.265999 536.718994)(-18.422001 116.231003 536.732971)(-18.422001 116.231003 536.732971)(-19.717800 106.887001 533.835999)(-18.810200 106.418999 535.867004)(-18.422001 116.231003 536.732971)(-18.810200 106.418999 535.867004)(-18.422001 106.220001 536.732971)(-18.422001 116.231003 536.732971)(-20.182499 107.125000 532.796021)(-19.717800 106.887001 533.835999)(-18.422001 116.231003 536.732971)(-22.224501 106.913002 528.226013)(-20.822300 106.959999 531.364014)(-18.422001 116.231003 536.732971)(-20.822300 106.959999 531.364014)(-20.182499 107.125000 532.796021)(-27.730000 109.431999 515.903992)(-22.224501 106.913002 528.226013)(-18.422001 116.231003 536.732971)(30.945999 112.570000 535.922974)(31.999201 107.987000 533.562012)(35.002499 108.396004 526.828003)(-11.589200 106.377998 536.640991)(6.262110 111.249001 536.334961)(-18.422001 116.231003 536.732971)(-28.597301 123.250000 509.487976)(-32.288998 114.680000 498.968018)(-31.500801 113.773003 501.896027)(-28.597301 123.250000 509.487976)(-31.500801 113.773003 501.896027)(-30.990301 113.553001 503.700958)(-32.288998 114.680000 498.968018)(-32.287998 114.127998 498.975006)(-31.500801 113.773003 501.896027)(-27.730000 109.431999 515.903992)(-29.100000 110.769005 510.819977)(-27.734499 108.783997 515.893005)(-27.730000 109.431999 515.903992)(-27.734499 108.783997 515.893005)(-27.289999 108.397995 516.888977)(-29.100000 110.769005 510.819977)(-27.730000 109.431999 515.903992)(-29.890100 111.917999 507.879974)(42.614002 110.850998 509.056976)(42.614098 110.106995 509.056976)(43.473499 111.936005 503.368988)(43.766300 112.223000 501.431000)(43.473499 111.936005 503.368988)(42.614098 110.106995 509.056976)(44.333000 113.764999 497.681000)(44.331100 113.262001 497.694000)(44.020298 113.420998 497.148987)(42.614002 110.850998 509.056976)(41.883400 110.609001 510.778015)(42.614098 110.106995 509.056976)(41.883400 110.609001 510.778015)(41.885101 109.429001 511.524963)(42.614098 110.106995 509.056976)(44.333000 113.764999 497.681000)(42.614002 110.850998 509.056976)(43.473499 111.936005 503.368988)(42.614002 110.850998 509.056976)(38.880001 123.503998 516.132996)(41.882999 112.118996 510.591980)(44.333000 113.764999 497.681000)(43.766300 112.223000 501.431000)(44.331100 113.262001 497.694000)(-32.104702 114.133003 498.964996)(-32.288998 114.680000 498.968018)(-22.387800 114.437996 497.869995)(-32.287998 114.127998 498.975006)(-32.104702 114.133003 498.964996)(-22.387800 114.437996 497.869995)(35.002499 108.396004 526.828003)(39.559902 109.838005 516.250000)(38.880001 123.503998 516.132996)(38.880001 123.503998 516.132996)(39.559902 109.838005 516.250000)(41.882999 112.118996 510.591980)(-28.597301 123.250000 509.487976)(-30.990301 113.553001 503.700958)(-29.890100 111.917999 507.879974)(-32.104702 114.133003 498.964996)(-32.287998 114.127998 498.975006)(-32.288998 114.680000 498.968018)(-28.597301 123.250000 509.487976)(-29.890100 111.917999 507.879974)(-27.730000 109.431999 515.903992)(43.039898 113.545998 495.481995)(41.850201 113.562004 495.604980)(41.850101 115.831001 495.582001)(30.945999 112.570000 535.922974)(-18.422001 116.231003 536.732971)(6.262110 111.249001 536.334961)(44.333000 113.764999 497.681000)(44.020298 113.420998 497.148987)(43.163300 113.523003 495.692017)(44.333000 113.764999 497.681000)(43.473499 111.936005 503.368988)(43.766300 112.223000 501.431000)(-27.289999 108.397995 516.888977)(-26.114500 106.509003 519.519958)(-22.224501 106.913002 528.226013)(41.882999 112.118996 510.591980)(41.883400 110.609001 510.778015)(42.614002 110.850998 509.056976)(44.333000 113.764999 497.681000)(43.163300 113.523003 495.692017)(43.039898 113.545998 495.481995)(-27.730000 109.431999 515.903992)(-27.289999 108.397995 516.888977)(-22.224501 106.913002 528.226013)(-27.730000 -109.431999 515.903992)(-29.890100 -111.917999 507.879974)(-28.597301 -123.250000 509.487976)(-27.730000 -109.431999 515.903992)(-28.597301 -123.250000 509.487976)(-24.553999 -137.067001 519.904968)(29.382000 -155.634003 531.104004)(32.735600 -153.505997 524.613037)(36.495998 -138.225006 519.828979)(29.382000 -155.634003 531.104004)(36.495998 -138.225006 519.828979)(29.966000 -138.363998 533.869995)(24.948002 -196.932999 521.754028)(29.814999 -202.535004 514.326965)(27.898001 -184.147003 525.343018)(24.948002 -196.932999 521.754028)(27.898001 -184.147003 525.343018)(-16.909000 -166.010010 529.140991)(29.814999 -202.535004 514.326965)(24.948002 -196.932999 521.754028)(20.683001 -209.529999 513.751953)(29.814999 -202.535004 514.326965)(34.765003 -168.787003 517.477966)(27.898001 -184.147003 525.343018)(-15.921000 -183.938004 525.391968)(20.683001 -209.529999 513.751953)(24.948002 -196.932999 521.754028)(27.898001 -184.147003 525.343018)(34.765003 -168.787003 517.477966)(28.865000 -166.727005 529.002014)(-27.734499 -108.783997 515.893005)(-27.730000 -109.431999 515.903992)(-27.289999 -108.397995 516.888977)(-22.224501 -106.913002 528.226013)(-27.289999 -108.397995 516.888977)(-27.730000 -109.431999 515.903992)(-27.734499 -108.783997 515.893005)(-29.100000 -110.769005 510.819977)(-27.730000 -109.431999 515.903992)(-16.909000 -166.010010 529.140991)(-22.856001 -167.634003 517.579956)(-18.406000 -201.539993 514.411987)(-22.856001 -167.634003 517.579956)(-24.258999 -208.572998 505.161987)(-18.406000 -201.539993 514.411987)(-24.258999 -208.572998 505.161987)(-28.607000 -173.621002 505.161987)(-24.786999 -207.522003 495.162018)(-22.856001 -167.634003 517.579956)(-28.607000 -173.621002 505.161987)(-24.258999 -208.572998 505.161987)(-16.907001 -218.152008 505.161987)(-24.258999 -208.572998 505.161987)(-24.786999 -207.522003 495.162018)(-16.907001 -218.152008 505.161987)(-24.786999 -207.522003 495.162018)(-16.447001 -218.894012 495.162018)(-16.447001 -218.894012 495.162018)(-24.786999 -207.522003 495.162018)(-11.110300 -166.942001 495.522003)(-16.907001 -218.152008 505.161987)(-16.447001 -218.894012 495.162018)(-5.454000 -222.615997 495.162018)(-5.454000 -222.615997 495.162018)(-16.447001 -218.894012 495.162018)(-2.983560 -168.862991 495.552979)(-16.907001 -218.152008 505.161987)(-18.406000 -201.539993 514.411987)(-24.258999 -208.572998 505.161987)(-9.838000 -209.233002 513.782959)(-18.406000 -201.539993 514.411987)(-16.907001 -218.152008 505.161987)(-9.838000 -209.233002 513.782959)(-16.907001 -218.152008 505.161987)(-5.454000 -222.441010 505.161987)(5.415000 -209.865997 513.713013)(-9.838000 -209.233002 513.782959)(-5.454000 -222.441010 505.161987)(21.304001 -221.847992 495.162018)(5.425000 -222.441010 505.161987)(-5.454000 -222.441010 505.161987)(5.425000 -222.441010 505.161987)(5.415000 -209.865997 513.713013)(-5.454000 -222.441010 505.161987)(-4.825290 -114.990005 495.889984)(-11.110300 -166.942001 495.522003)(-24.786999 -207.522003 495.162018)(-24.786999 -207.522003 495.162018)(-22.387800 -114.437996 497.869995)(-4.825290 -114.990005 495.889984)(-11.110300 -166.942001 495.522003)(-4.825290 -114.990005 495.889984)(2.565930 -115.108994 495.950989)(-24.786999 -207.522003 495.162018)(-32.288998 -114.680000 498.968018)(-22.387800 -114.437996 497.869995)(-18.277000 -125.980003 535.587036)(-18.000000 -137.470001 534.000000)(29.382000 -155.634003 531.104004)(28.865000 -166.727005 529.002014)(29.382000 -155.634003 531.104004)(-18.000000 -137.470001 534.000000)(-17.415001 -155.074997 531.200989)(-18.000000 -137.470001 534.000000)(-24.553999 -137.067001 519.904968)(28.865000 -166.727005 529.002014)(-18.000000 -137.470001 534.000000)(-17.415001 -155.074997 531.200989)(27.898001 -184.147003 525.343018)(28.865000 -166.727005 529.002014)(-17.415001 -155.074997 531.200989)(-22.856001 -167.634003 517.579956)(-17.415001 -155.074997 531.200989)(-24.553999 -137.067001 519.904968)(29.382000 -155.634003 531.104004)(28.865000 -166.727005 529.002014)(34.765003 -168.787003 517.477966)(-24.553999 -137.067001 519.904968)(-30.945999 -141.824005 505.161987)(-22.856001 -167.634003 517.579956)(-31.500801 -113.773003 501.896027)(-32.288998 -114.680000 498.968018)(-28.597301 -123.250000 509.487976)(-28.597301 -123.250000 509.487976)(-32.288998 -114.680000 498.968018)(-24.553999 -137.067001 519.904968)(-30.945999 -141.824005 505.161987)(-24.553999 -137.067001 519.904968)(-32.288998 -114.680000 498.968018)(-24.786999 -207.522003 495.162018)(-30.945999 -141.824005 505.161987)(-32.288998 -114.680000 498.968018)(-18.277000 -125.980003 535.587036)(-24.553999 -137.067001 519.904968)(-18.000000 -137.470001 534.000000)(-24.786999 -207.522003 495.162018)(-28.607000 -173.621002 505.161987)(-30.945999 -141.824005 505.161987)(-18.422001 -116.231003 536.732971)(-11.589200 -106.377998 536.640991)(-16.271900 -106.265999 536.718994)(30.945999 -112.570000 535.922974)(6.262110 -111.249001 536.334961)(-18.422001 -116.231003 536.732971)(-18.422001 -116.231003 536.732971)(6.262110 -111.249001 536.334961)(-11.589200 -106.377998 536.640991)(30.250999 -126.840996 535.477966)(30.945999 -112.570000 535.922974)(-18.422001 -116.231003 536.732971)(30.945999 -112.570000 535.922974)(20.557201 -107.150002 536.106995)(6.262110 -111.249001 536.334961)(29.966000 -138.363998 533.869995)(30.250999 -126.840996 535.477966)(-18.422001 -116.231003 536.732971)(29.966000 -138.363998 533.869995)(-18.422001 -116.231003 536.732971)(-18.277000 -125.980003 535.587036)(30.250999 -126.840996 535.477966)(29.966000 -138.363998 533.869995)(36.495998 -138.225006 519.828979)(30.945999 -112.570000 535.922974)(30.250999 -126.840996 535.477966)(36.495998 -138.225006 519.828979)(36.370399 -108.790001 523.738953)(33.232800 -107.897995 530.796021)(30.945999 -112.570000 535.922974)(36.370399 -108.790001 523.738953)(30.945999 -112.570000 535.922974)(36.495998 -138.225006 519.828979)(31.999201 -107.987000 533.562012)(30.945999 -112.570000 535.922974)(33.232800 -107.897995 530.796021)(30.945999 -112.570000 535.922974)(30.941299 -107.333000 535.933960)(20.557201 -107.150002 536.106995)(38.880001 -123.503998 516.132996)(36.370399 -108.790001 523.738953)(36.495998 -138.225006 519.828979)(28.616800 -115.555000 495.963013)(11.581401 -168.929001 495.562988)(10.479900 -115.243004 495.968994)(22.799000 -221.273010 505.161987)(21.304001 -221.847992 495.162018)(31.709999 -216.707001 495.162018)(31.709999 -216.707001 495.162018)(21.304001 -221.847992 495.162018)(28.441700 -168.702011 495.548981)(28.616800 -115.555000 495.963013)(28.441700 -168.702011 495.548981)(21.304001 -221.847992 495.162018)(31.709999 -216.707001 495.162018)(28.441700 -168.702011 495.548981)(35.579300 -115.677994 495.934998)(38.940701 -115.742996 495.884003)(36.775997 -207.522003 495.162018)(35.325401 -166.192993 495.523010)(35.325401 -166.192993 495.523010)(35.579300 -115.677994 495.934998)(38.940701 -115.742996 495.884003)(36.775997 -207.522003 495.162018)(38.940701 -115.742996 495.884003)(42.851002 -146.615005 495.161011)(42.851002 -146.615005 495.161011)(40.570000 -174.052002 505.160980)(36.775997 -207.522003 495.162018)(42.782001 -144.342010 505.160980)(40.570000 -174.052002 505.160980)(42.851002 -146.615005 495.161011)(36.662003 -207.233002 505.161987)(40.570000 -174.052002 505.160980)(34.765003 -168.787003 517.477966)(42.782001 -144.342010 505.160980)(34.765003 -168.787003 517.477966)(40.570000 -174.052002 505.160980)(35.325401 -166.192993 495.523010)(36.775997 -207.522003 495.162018)(31.709999 -216.707001 495.162018)(35.579300 -115.677994 495.934998)(35.325401 -166.192993 495.523010)(31.709999 -216.707001 495.162018)(35.579300 -115.677994 495.934998)(28.441700 -168.702011 495.548981)(28.616800 -115.555000 495.963013)(31.709999 -216.707001 495.162018)(32.177002 -215.849991 505.161987)(22.799000 -221.273010 505.161987)(42.851002 -146.615005 495.161011)(38.940701 -115.742996 495.884003)(41.850101 -115.831001 495.582001)(44.333000 -113.764999 497.681000)(42.614002 -110.850998 509.056976)(42.782001 -144.342010 505.160980)(42.614002 -110.850998 509.056976)(36.495998 -138.225006 519.828979)(42.782001 -144.342010 505.160980)(42.614002 -110.850998 509.056976)(38.880001 -123.503998 516.132996)(36.495998 -138.225006 519.828979)(43.473499 -111.936005 503.368988)(42.614002 -110.850998 509.056976)(44.333000 -113.764999 497.681000)(42.614098 -110.106995 509.056976)(43.473499 -111.936005 503.368988)(43.766300 -112.223000 501.431000)(42.614098 -110.106995 509.056976)(42.614002 -110.850998 509.056976)(43.473499 -111.936005 503.368988)(42.614098 -110.106995 509.056976)(41.883400 -110.609001 510.778015)(42.614002 -110.850998 509.056976)(41.885101 -109.429001 511.524963)(41.883400 -110.609001 510.778015)(42.614098 -110.106995 509.056976)(43.766300 -112.223000 501.431000)(43.473499 -111.936005 503.368988)(44.333000 -113.764999 497.681000)(43.039898 -113.545998 495.481995)(42.851002 -146.615005 495.161011)(41.850101 -115.831001 495.582001)(43.039898 -113.545998 495.481995)(44.333000 -113.764999 497.681000)(42.851002 -146.615005 495.161011)(43.163300 -113.523003 495.692017)(44.333000 -113.764999 497.681000)(43.039898 -113.545998 495.481995)(44.020298 -113.420998 497.148987)(44.333000 -113.764999 497.681000)(43.163300 -113.523003 495.692017)(44.331100 -113.262001 497.694000)(44.333000 -113.764999 497.681000)(44.020298 -113.420998 497.148987)(44.331100 -113.262001 497.694000)(43.766300 -112.223000 501.431000)(44.333000 -113.764999 497.681000)(41.882999 -112.118996 510.591980)(38.880001 -123.503998 516.132996)(42.614002 -110.850998 509.056976)(41.882999 -112.118996 510.591980)(39.559902 -109.838005 516.250000)(38.880001 -123.503998 516.132996)(42.782001 -144.342010 505.160980)(36.495998 -138.225006 519.828979)(34.765003 -168.787003 517.477966)(29.814999 -202.535004 514.326965)(22.799000 -221.273010 505.161987)(32.177002 -215.849991 505.161987)(36.662003 -207.233002 505.161987)(29.814999 -202.535004 514.326965)(32.177002 -215.849991 505.161987)(36.662003 -207.233002 505.161987)(32.177002 -215.849991 505.161987)(36.775997 -207.522003 495.162018)(10.479900 -115.243004 495.968994)(-2.983560 -168.862991 495.552979)(2.565930 -115.108994 495.950989)(-11.589200 -106.377998 536.640991)(6.262110 -111.249001 536.334961)(20.557201 -107.150002 536.106995)(-27.730000 -109.431999 515.903992)(-18.422001 -116.231003 536.732971)(-22.224501 -106.913002 528.226013)(-18.422001 -116.231003 536.732971)(-27.730000 -109.431999 515.903992)(-24.553999 -137.067001 519.904968)(-15.921000 -183.938004 525.391968)(-16.909000 -166.010010 529.140991)(-18.406000 -201.539993 514.411987)(42.851002 -146.615005 495.161011)(44.333000 -113.764999 497.681000)(42.782001 -144.342010 505.160980)(29.382000 -155.634003 531.104004)(34.765003 -168.787003 517.477966)(32.735600 -153.505997 524.613037)(-18.422001 -116.231003 536.732971)(-24.553999 -137.067001 519.904968)(-18.277000 -125.980003 535.587036)(-18.810200 -106.418999 535.867004)(-19.717800 -106.887001 533.835999)(-18.422001 -116.231003 536.732971)(-19.717800 -106.887001 533.835999)(-20.182499 -107.125000 532.796021)(-18.422001 -116.231003 536.732971)(-20.182499 -107.125000 532.796021)(-20.822300 -106.959999 531.364014)(-18.422001 -116.231003 536.732971)(-15.921000 -183.938004 525.391968)(-18.406000 -201.539993 514.411987)(-9.838000 -209.233002 513.782959)(-32.288998 -114.680000 498.968018)(-32.287998 -114.127998 498.975006)(-32.104702 -114.133003 498.964996)(-17.415001 -155.074997 531.200989)(-22.856001 -167.634003 517.579956)(-16.909000 -166.010010 529.140991)(31.999201 -107.987000 533.562012)(31.407400 -107.657997 534.888977)(30.945999 -112.570000 535.922974)(-32.287998 -114.127998 498.975006)(-32.288998 -114.680000 498.968018)(-31.500801 -113.773003 501.896027)(31.407400 -107.657997 534.888977)(30.941299 -107.333000 535.933960)(30.945999 -112.570000 535.922974)(34.765003 -168.787003 517.477966)(29.814999 -202.535004 514.326965)(36.662003 -207.233002 505.161987)(22.799000 -221.273010 505.161987)(5.425000 -222.441010 505.161987)(21.304001 -221.847992 495.162018)(-5.454000 -222.441010 505.161987)(-16.907001 -218.152008 505.161987)(-5.454000 -222.615997 495.162018)(39.559902 -109.838005 516.250000)(39.377602 -109.778000 516.679016)(38.880001 -123.503998 516.132996)(39.377602 -109.778000 516.679016)(39.058498 -109.678001 517.416992)(38.880001 -123.503998 516.132996)(39.058498 -109.678001 517.416992)(38.056900 -109.357994 519.747986)(38.880001 -123.503998 516.132996)(38.056900 -109.357994 519.747986)(37.233700 -109.096001 521.663025)(38.880001 -123.503998 516.132996)(37.233700 -109.096001 521.663025)(36.370399 -108.790001 523.738953)(38.880001 -123.503998 516.132996)(-22.224501 -106.913002 528.226013)(-26.114500 -106.509003 519.519958)(-27.289999 -108.397995 516.888977)(5.415000 -209.865997 513.713013)(5.425000 -222.441010 505.161987)(22.799000 -221.273010 505.161987)(5.415000 -209.865997 513.713013)(22.799000 -221.273010 505.161987)(20.683001 -209.529999 513.751953)(-30.945999 -141.824005 505.161987)(-28.607000 -173.621002 505.161987)(-22.856001 -167.634003 517.579956)(41.850101 -115.831001 495.582001)(41.850201 -113.562004 495.604980)(43.039898 -113.545998 495.481995)(2.565930 -115.108994 495.950989)(-2.983560 -168.862991 495.552979)(-16.447001 -218.894012 495.162018)(29.382000 -155.634003 531.104004)(29.966000 -138.363998 533.869995)(-18.277000 -125.980003 535.587036)(-30.990301 -113.553001 503.700958)(-31.500801 -113.773003 501.896027)(-28.597301 -123.250000 509.487976)(-5.454000 -222.441010 505.161987)(-5.454000 -222.615997 495.162018)(21.304001 -221.847992 495.162018)(21.304001 -221.847992 495.162018)(-5.454000 -222.615997 495.162018)(11.581401 -168.929001 495.562988)(20.683001 -209.529999 513.751953)(-15.921000 -183.938004 525.391968)(5.415000 -209.865997 513.713013)(-18.422001 -116.231003 536.732971)(-16.271900 -106.265999 536.718994)(-18.422001 -106.220001 536.732971)(-20.822300 -106.959999 531.364014)(-22.224501 -106.913002 528.226013)(-18.422001 -116.231003 536.732971)(11.581401 -168.929001 495.562988)(-5.454000 -222.615997 495.162018)(10.479900 -115.243004 495.968994)(40.570000 -174.052002 505.160980)(36.662003 -207.233002 505.161987)(36.775997 -207.522003 495.162018)(-29.890100 -111.917999 507.879974)(-27.730000 -109.431999 515.903992)(-29.100000 -110.769005 510.819977)(36.495998 -138.225006 519.828979)(32.735600 -153.505997 524.613037)(34.765003 -168.787003 517.477966)(2.565930 -115.108994 495.950989)(-16.447001 -218.894012 495.162018)(-11.110300 -166.942001 495.522003)(-18.422001 -106.220001 536.732971)(-18.810200 -106.418999 535.867004)(-18.422001 -116.231003 536.732971)(27.898001 -184.147003 525.343018)(-17.415001 -155.074997 531.200989)(-16.909000 -166.010010 529.140991)(-32.288998 -114.680000 498.968018)(-32.104702 -114.133003 498.964996)(-22.387800 -114.437996 497.869995)(-15.921000 -183.938004 525.391968)(-9.838000 -209.233002 513.782959)(5.415000 -209.865997 513.713013)(29.814999 -202.535004 514.326965)(20.683001 -209.529999 513.751953)(22.799000 -221.273010 505.161987)(31.709999 -216.707001 495.162018)(36.775997 -207.522003 495.162018)(32.177002 -215.849991 505.161987)(24.948002 -196.932999 521.754028)(-16.909000 -166.010010 529.140991)(-15.921000 -183.938004 525.391968)(21.304001 -221.847992 495.162018)(11.581401 -168.929001 495.562988)(28.616800 -115.555000 495.963013)(-29.890100 -111.917999 507.879974)(-30.990301 -113.553001 503.700958)(-28.597301 -123.250000 509.487976)(41.883400 -110.609001 510.778015)(41.882999 -112.118996 510.591980)(42.614002 -110.850998 509.056976)(-5.454000 -222.615997 495.162018)(-2.983560 -168.862991 495.552979)(10.479900 -115.243004 495.968994)(44.020000 96.366005 370.035004)(44.275700 92.553497 368.490997)(44.020000 92.696007 366.596985)(44.275700 92.553497 368.490997)(44.020000 96.366005 370.035004)(44.958000 88.740997 370.332001)(43.692997 94.530998 366.203003)(44.020000 96.366005 370.035004)(44.020000 92.696007 366.596985)(42.863998 96.243004 362.447998)(44.020000 92.696007 366.596985)(43.809998 88.031998 364.948975)(43.692997 94.530998 366.203003)(44.020000 92.696007 366.596985)(42.863998 96.243004 362.447998)(44.020000 92.696007 366.596985)(44.275700 92.553497 368.490997)(44.958000 88.740997 370.332001)(44.958000 88.740997 370.332001)(43.809998 88.031998 364.948975)(44.020000 92.696007 366.596985)(44.763500 92.553497 372.123016)(45.030003 92.881996 374.278015)(44.958000 88.740997 370.332001)(45.030003 92.881996 374.278015)(45.693001 89.557999 376.733002)(44.958000 88.740997 370.332001)(44.020000 96.366005 370.035004)(44.763500 92.553497 372.123016)(44.958000 88.740997 370.332001)(42.863998 96.243004 362.447998)(43.809998 88.031998 364.948975)(42.746998 87.457001 360.680023)(45.805000 90.896004 387.692993)(45.030003 93.781998 380.053986)(45.589001 92.432999 396.824982)(45.859001 90.318001 382.876984)(45.030003 93.781998 380.053986)(45.805000 90.896004 387.692993)(45.030003 92.881996 374.278015)(45.030003 93.781998 380.053986)(45.859001 90.318001 382.876984)(41.932999 108.151001 533.707947)(41.899799 108.604996 518.491028)(41.898003 109.456001 517.320007)(41.932999 108.151001 533.707947)(41.905300 106.750000 521.044006)(41.899799 108.604996 518.491028)(41.905300 106.750000 521.044006)(41.932999 108.151001 533.707947)(41.918198 99.487000 526.510986)(41.899799 108.604996 518.491028)(41.905300 106.750000 521.044006)(41.918198 99.487000 526.510986)(41.916500 100.043999 525.991028)(41.899799 108.604996 518.491028)(41.918198 99.487000 526.510986)(35.002499 108.396004 526.828003)(41.932999 108.151001 533.707947)(41.898003 109.456001 517.320007)(41.563000 -103.900002 364.347992)(41.570801 -104.253998 367.906982)(41.558998 -106.091003 362.724976)(41.561699 -103.788002 363.302002)(41.563000 -103.900002 364.347992)(41.558998 -106.091003 362.724976)(41.563000 -103.900002 364.347992)(42.143700 -102.505997 367.603973)(41.570801 -104.253998 367.906982)(41.570801 -104.253998 367.906982)(42.143700 -102.505997 367.603973)(42.863998 -100.806000 371.921997)(42.863998 -100.806000 371.921997)(41.570900 -104.259003 367.989990)(41.570801 -104.253998 367.906982)(41.561699 -103.788002 363.302002)(42.143700 -102.505997 367.603973)(41.563000 -103.900002 364.347992)(42.863998 -100.806000 371.921997)(42.143700 -102.505997 367.603973)(41.561699 -103.788002 363.302002)(-119.115997 103.874001 538.150024)(-65.370003 104.758003 538.934998)(-65.292999 106.380997 532.132019)(-42.543900 106.000999 535.635986)(-65.292999 106.380997 532.132019)(-65.370003 104.758003 538.934998)(-119.115997 103.874001 538.150024)(-119.135002 99.620003 544.377991)(-65.370003 104.758003 538.934998)(-121.857002 -101.837997 361.869019)(-149.495010 -97.790001 363.494995)(-135.472000 -47.260002 354.721985)(-135.472000 -47.260002 354.721985)(-124.982994 -72.045998 355.863983)(-121.857002 -101.837997 361.869019)(-135.472000 -47.260002 354.721985)(-148.231003 -49.443001 357.250977)(-140.007004 -29.219000 354.571991)(-140.007004 -29.219000 354.571991)(-148.231003 -49.443001 357.250977)(-141.477005 -23.040001 354.537018)(-148.231003 -49.443001 357.250977)(-145.686996 -0.441004 355.087006)(-141.477005 -23.040001 354.537018)(-148.231003 -49.443001 357.250977)(-160.667999 -0.441005 359.252991)(-145.686996 -0.441004 355.087006)(-148.231003 -49.443001 357.250977)(-160.835999 -49.456997 361.252991)(-160.667999 -0.441005 359.252991)(-170.673004 -103.360001 379.378998)(-149.495010 -97.790001 363.494995)(-121.857002 -101.837997 361.869019)(-179.389999 41.200001 378.924988)(-175.944000 44.369999 373.253998)(-179.389999 0.441005 375.324982)(-175.944000 44.369999 373.253998)(-173.869995 0.441005 366.456970)(-179.389999 0.441005 375.324982)(41.912899 101.700996 524.294006)(41.909698 102.618004 522.785034)(41.899799 108.604996 518.491028)(41.899799 108.604996 518.491028)(41.909698 102.618004 522.785034)(41.898197 105.878998 517.421997)(45.030003 -92.881996 374.278015)(44.958000 -88.740997 370.332001)(45.693001 -89.557999 376.733002)(45.030003 -92.881996 374.278015)(45.693001 -89.557999 376.733002)(45.859001 -90.318001 382.876984)(-141.460007 -102.950996 488.976990)(-108.691002 -104.039993 502.781982)(-108.690002 -104.039993 503.285004)(-108.662003 -104.041000 516.104004)(-141.460007 -102.950996 488.976990)(-108.690002 -104.039993 503.285004)(-141.460007 -102.950996 488.976990)(-108.662003 -104.041000 516.104004)(-108.661003 -104.041000 516.291992)(-119.135002 -99.620003 544.377991)(-65.370003 -104.758003 538.934998)(-65.389000 -100.506996 545.154968)(-119.115997 -103.874001 538.150024)(-119.041000 -105.494003 531.342041)(-65.292999 -106.380997 532.132019)(-65.370003 -104.758003 538.934998)(-65.292999 -106.380997 532.132019)(-42.543900 -106.000999 535.635986)(-42.543900 -106.000999 535.635986)(-19.717800 -106.887001 533.835999)(-65.370003 -104.758003 538.934998)(-20.182499 -107.125000 532.796021)(-42.543900 -106.000999 535.635986)(-65.292999 -106.380997 532.132019)(-119.115997 -103.874001 538.150024)(-65.292999 -106.380997 532.132019)(-65.370003 -104.758003 538.934998)(-42.201599 -106.249001 519.438965)(-26.114500 -106.509003 519.519958)(-22.224501 -106.913002 528.226013)(-20.822300 -106.959999 531.364014)(-42.201599 -106.249001 519.438965)(-22.224501 -106.913002 528.226013)(-66.859001 -105.430000 519.893982)(-42.201599 -106.249001 519.438965)(-20.822300 -106.959999 531.364014)(-108.653000 -104.425995 520.135010)(-86.876701 -104.764999 520.263000)(-65.292999 -106.380997 532.132019)(-119.135002 -99.620003 544.377991)(-119.115997 -103.874001 538.150024)(-65.370003 -104.758003 538.934998)(41.865200 -101.732002 362.399017)(41.556400 -100.463005 358.989014)(42.863998 -99.831001 365.808014)(41.865200 -101.732002 362.399017)(42.863998 -99.831001 365.808014)(41.561699 -103.788002 363.302002)(42.863998 -100.806000 371.921997)(41.561699 -103.788002 363.302002)(42.863998 -99.831001 365.808014)(42.499302 -98.357994 362.348999)(42.863998 -99.831001 365.808014)(41.556400 -100.463005 358.989014)(-160.835999 -49.456997 361.252991)(-149.495010 -97.790001 363.494995)(-162.182007 -97.984001 368.515015)(-170.673004 -103.360001 379.378998)(-162.182007 -97.984001 368.515015)(-149.495010 -97.790001 363.494995)(-168.220993 -98.103004 371.578979)(-162.182007 -97.984001 368.515015)(-170.673004 -103.360001 379.378998)(-160.835999 -49.456997 361.252991)(-162.182007 -97.984001 368.515015)(-168.220993 -98.103004 371.578979)(-160.835999 -49.456997 361.252991)(-168.220993 -98.103004 371.578979)(-174.177002 -95.821999 377.274994)(-174.177002 -95.821999 377.274994)(-168.220993 -98.103004 371.578979)(-170.673004 -103.360001 379.378998)(7.603000 -87.778999 354.873016)(0.980996 -99.698997 357.934998)(-19.615000 -101.438995 357.934998)(21.541000 -102.112000 357.934998)(0.980996 -99.698997 357.934998)(7.603000 -87.778999 354.873016)(24.572001 -88.039001 354.567993)(21.541000 -102.112000 357.934998)(7.603000 -87.778999 354.873016)(42.863998 -100.806000 371.921997)(44.018997 -98.164001 388.927002)(42.863998 -101.720001 385.408997)(42.863998 -100.806000 371.921997)(44.020000 -97.305000 375.981018)(44.018997 -98.164001 388.927002)(44.018997 -98.164001 388.927002)(44.020000 -97.305000 375.981018)(45.589001 -92.432999 396.824982)(44.018997 -98.886993 401.951996)(42.863998 -101.720001 385.408997)(44.018997 -98.164001 388.927002)(42.863998 -101.720001 385.408997)(44.018997 -98.886993 401.951996)(42.862999 -102.489998 398.992981)(42.340900 -103.037003 383.490997)(42.863998 -101.720001 385.408997)(42.862999 -102.489998 398.992981)(41.571098 -104.264000 368.078003)(42.340900 -103.037003 383.490997)(42.862999 -102.489998 398.992981)(42.863998 -101.720001 385.408997)(42.340900 -103.037003 383.490997)(41.570900 -104.259003 367.989990)(41.570900 -104.259003 367.989990)(42.340900 -103.037003 383.490997)(41.571098 -104.264000 368.078003)(42.862999 -102.489998 398.992981)(44.018997 -98.886993 401.951996)(43.928001 -100.006996 421.527008)(-179.389999 -94.904999 463.443024)(-179.389999 -90.622002 401.414978)(-174.260010 -101.861000 393.664001)(-174.260010 -101.861000 393.664001)(-174.260010 -101.861000 461.351013)(-179.389999 -94.904999 463.443024)(-108.822998 -104.429001 442.579010)(-174.260010 -101.861000 393.664001)(22.221699 -109.572998 454.324005)(-174.260010 -101.861000 393.664001)(-108.822998 -104.429001 442.579010)(-174.260010 -101.861000 461.351013)(-108.781998 -104.431000 461.050995)(-174.260010 -101.861000 461.351013)(-108.822998 -104.429001 442.579010)(-179.389999 -88.012001 388.846008)(-179.389999 -90.622002 401.414978)(-179.389999 -94.904999 463.443024)(-179.389999 -88.012001 388.846008)(-174.260010 -101.861000 393.664001)(-179.389999 -90.622002 401.414978)(-121.857002 -101.837997 361.869019)(-101.926003 -100.093002 357.934998)(-101.896004 -104.075996 362.724976)(-101.896004 -104.075996 362.724976)(-170.673004 -103.360001 379.378998)(-121.857002 -101.837997 361.869019)(-101.896004 -104.075996 362.724976)(-101.926003 -100.093002 357.934998)(-81.347000 -100.429001 357.934998)(-81.347000 -100.429001 357.934998)(-101.926003 -100.093002 357.934998)(-94.212006 -86.218002 356.704010)(-174.260010 -101.861000 393.664001)(-170.673004 -103.360001 379.378998)(-101.896004 -104.075996 362.724976)(-60.763000 -103.795998 362.724976)(-174.260010 -101.861000 393.664001)(-101.896004 -104.075996 362.724976)(-174.260010 -101.861000 393.664001)(-179.389999 -88.012001 388.846008)(-170.673004 -103.360001 379.378998)(-174.177002 -95.821999 377.274994)(-170.673004 -103.360001 379.378998)(-179.389999 -88.012001 388.846008)(-174.260010 -101.861000 461.351013)(-108.742996 -103.891998 479.122986)(-108.733994 -103.766998 483.282013)(-108.742996 -103.891998 479.122986)(-174.260010 -101.861000 461.351013)(-108.750000 -103.984001 476.016022)(-60.763000 -103.795998 362.724976)(22.221699 -109.572998 454.324005)(-174.260010 -101.861000 393.664001)(36.112701 -109.979004 454.970001)(22.221699 -109.572998 454.324005)(-60.763000 -103.795998 362.724976)(41.736801 -106.903999 443.817993)(42.178001 -105.959000 446.110992)(41.753201 -107.167000 451.436005)(41.736801 -106.903999 443.817993)(42.862999 -102.489998 398.992981)(42.178001 -105.959000 446.110992)(41.761200 -110.111000 455.091003)(41.736801 -106.903999 443.817993)(41.753201 -107.167000 451.436005)(41.586601 -104.509003 375.111023)(41.736801 -106.903999 443.817993)(41.761200 -110.111000 455.091003)(41.586601 -104.509003 375.111023)(41.761200 -110.111000 455.091003)(41.558998 -106.091003 362.724976)(-60.272999 -86.737999 356.092987)(-60.752998 -98.686005 357.934998)(-77.243004 -86.478004 356.397980)(-40.193001 -101.102997 357.934998)(-60.752998 -98.686005 357.934998)(-60.272999 -86.737999 356.092987)(-60.763000 -103.795998 362.724976)(-60.752998 -98.686005 357.934998)(-40.193001 -101.102997 357.934998)(-19.615000 -101.438995 357.934998)(-60.763000 -103.795998 362.724976)(-40.193001 -101.102997 357.934998)(-60.763000 -103.795998 362.724976)(-19.615000 -101.438995 357.934998)(21.573000 -106.091003 362.724976)(21.573000 -106.091003 362.724976)(36.112701 -109.979004 454.970001)(-60.763000 -103.795998 362.724976)(36.112701 -109.979004 454.970001)(21.573000 -106.091003 362.724976)(40.704002 -110.114998 455.193024)(21.573000 -106.091003 362.724976)(41.558998 -106.091003 362.724976)(40.704002 -110.114998 455.193024)(21.573000 -106.091003 362.724976)(41.549000 -103.334000 357.934998)(41.558998 -106.091003 362.724976)(40.704002 -110.114998 455.193024)(41.558998 -106.091003 362.724976)(41.761200 -110.111000 455.091003)(41.560402 -103.690994 363.161011)(41.558998 -106.091003 362.724976)(41.549000 -103.334000 357.934998)(41.571098 -104.264000 368.078003)(41.586601 -104.509003 375.111023)(41.558998 -106.091003 362.724976)(42.858997 -103.848999 437.105011)(42.178001 -105.959000 446.110992)(42.862999 -102.489998 398.992981)(42.070198 -97.139000 359.908020)(42.863998 -96.243004 362.447998)(41.556400 -100.463005 358.989014)(41.560200 -88.260201 356.608978)(42.070198 -97.139000 359.908020)(41.556400 -100.463005 358.989014)(42.070198 -97.139000 359.908020)(41.560200 -88.260201 356.608978)(42.746998 -87.457001 360.680023)(42.863998 -96.243004 362.447998)(42.499302 -98.357994 362.348999)(41.556400 -100.463005 358.989014)(42.863998 -96.243004 362.447998)(42.863998 -99.831001 365.808014)(42.499302 -98.357994 362.348999)(42.863998 -96.243004 362.447998)(44.020000 -96.366005 370.035004)(42.863998 -99.831001 365.808014)(43.692997 -94.530998 366.203003)(44.020000 -96.366005 370.035004)(42.863998 -96.243004 362.447998)(44.020000 -92.696007 366.596985)(44.020000 -96.366005 370.035004)(43.692997 -94.530998 366.203003)(44.275700 -92.553497 368.490997)(44.958000 -88.740997 370.332001)(44.020000 -96.366005 370.035004)(44.020000 -92.696007 366.596985)(44.275700 -92.553497 368.490997)(44.020000 -96.366005 370.035004)(44.958000 -88.740997 370.332001)(44.275700 -92.553497 368.490997)(44.020000 -92.696007 366.596985)(42.863998 -99.831001 365.808014)(44.020000 -96.366005 370.035004)(44.020000 -97.305000 375.981018)(43.362000 -102.135002 430.031006)(42.858997 -103.848999 437.105011)(42.862999 -102.489998 398.992981)(44.020000 -97.305000 375.981018)(44.020000 -96.366005 370.035004)(45.030003 -93.781998 380.053986)(44.020000 -96.366005 370.035004)(45.030003 -92.881996 374.278015)(45.030003 -93.781998 380.053986)(44.763500 -92.553497 372.123016)(45.030003 -92.881996 374.278015)(44.020000 -96.366005 370.035004)(45.030003 -92.881996 374.278015)(45.859001 -90.318001 382.876984)(45.030003 -93.781998 380.053986)(45.589001 -92.432999 396.824982)(45.030003 -93.781998 380.053986)(45.805000 -90.896004 387.692993)(45.589001 -92.432999 396.824982)(44.993999 -95.351006 404.143005)(44.018997 -98.886993 401.951996)(44.018997 -98.886993 401.951996)(44.993999 -95.351006 404.143005)(43.928001 -100.006996 421.527008)(45.030003 -93.781998 380.053986)(45.859001 -90.318001 382.876984)(45.805000 -90.896004 387.692993)(41.541000 -88.298996 354.263000)(41.549000 -103.334000 357.934998)(24.572001 -88.039001 354.567993)(41.541000 -88.298996 354.263000)(41.556400 -100.463005 358.989014)(41.549000 -103.334000 357.934998)(41.549000 -103.334000 357.934998)(21.541000 -102.112000 357.934998)(24.572001 -88.039001 354.567993)(42.746998 -87.457001 360.680023)(43.809998 -88.031998 364.948975)(42.863998 -96.243004 362.447998)(-174.177002 -95.821999 377.274994)(-173.537003 -47.617001 368.218018)(-160.835999 -49.456997 361.252991)(-108.735001 -83.295006 356.660004)(-101.926003 -100.093002 357.934998)(-118.275002 -79.184006 356.402008)(-102.599998 -84.996002 356.729004)(-101.926003 -100.093002 357.934998)(-108.735001 -83.295006 356.660004)(-173.537003 -47.617001 368.218018)(-174.177002 -95.821999 377.274994)(-179.389999 -88.012001 388.846008)(41.916500 -100.043999 525.991028)(41.899799 -108.604996 518.491028)(41.912899 -101.700996 524.294006)(41.918198 -99.487000 526.510986)(41.899799 -108.604996 518.491028)(41.916500 -100.043999 525.991028)(41.973000 -92.264999 551.796997)(41.939301 -87.826401 536.362000)(41.950302 -78.220802 541.342041)(41.939301 -87.826401 536.362000)(41.973000 -92.264999 551.796997)(41.933102 -91.898705 533.554016)(41.932800 -92.076797 533.430969)(41.931801 -95.781898 532.832031)(41.918198 -99.487000 526.510986)(41.931801 -95.781898 532.832031)(41.945698 -96.386406 539.153992)(41.918198 -99.487000 526.510986)(41.932800 -92.076797 533.430969)(41.945698 -96.386406 539.153992)(41.931801 -95.781898 532.832031)(41.933102 -91.898705 533.554016)(41.945698 -96.386406 539.153992)(41.932800 -92.076797 533.430969)(41.973000 -92.264999 551.796997)(41.945698 -96.386406 539.153992)(41.933102 -91.898705 533.554016)(41.973000 -92.264999 551.796997)(41.965000 -100.874001 547.864990)(41.945698 -96.386406 539.153992)(41.965000 -100.874001 547.864990)(41.973000 -92.264999 551.796997)(-11.602000 -95.147995 550.136963)(41.965000 -100.874001 547.864990)(-11.602000 -95.147995 550.136963)(-11.644000 -101.392998 545.932007)(41.950302 -78.220802 541.342041)(41.952099 -75.767197 542.196960)(41.973000 -92.264999 551.796997)(41.959503 -57.327599 545.482971)(41.978001 -54.875000 553.933960)(41.958000 -62.816700 544.821960)(41.952099 -75.767197 542.196960)(41.956997 -65.602196 544.356995)(41.973000 -92.264999 551.796997)(41.956997 -65.602196 544.356995)(41.978001 -54.875000 553.933960)(41.973000 -92.264999 551.796997)(41.956997 -65.602196 544.356995)(41.958000 -62.816700 544.821960)(41.978001 -54.875000 553.933960)(-11.602000 -95.147995 550.136963)(-11.504000 -88.339996 551.713013)(-65.251999 -87.443001 550.935974)(-65.389000 -100.506996 545.154968)(-11.625000 -105.641998 539.717957)(-11.644000 -101.392998 545.932007)(-11.644000 -101.392998 545.932007)(-11.625000 -105.641998 539.717957)(41.951000 -105.669998 541.840942)(31.407400 -107.657997 534.888977)(31.999201 -107.987000 533.562012)(41.932999 -108.151001 533.707947)(31.407400 -107.657997 534.888977)(41.932999 -108.151001 533.707947)(41.951000 -105.669998 541.840942)(30.941299 -107.333000 535.933960)(31.407400 -107.657997 534.888977)(41.951000 -105.669998 541.840942)(20.557201 -107.150002 536.106995)(30.941299 -107.333000 535.933960)(41.951000 -105.669998 541.840942)(20.557201 -107.150002 536.106995)(41.951000 -105.669998 541.840942)(-11.625000 -105.641998 539.717957)(-11.625000 -105.641998 539.717957)(-11.589200 -106.377998 536.640991)(20.557201 -107.150002 536.106995)(-16.271900 -106.265999 536.718994)(-11.589200 -106.377998 536.640991)(-11.625000 -105.641998 539.717957)(-18.422001 -106.220001 536.732971)(-16.271900 -106.265999 536.718994)(-11.625000 -105.641998 539.717957)(41.898003 -109.456001 517.320007)(36.370399 -108.790001 523.738953)(37.233700 -109.096001 521.663025)(41.898003 -109.456001 517.320007)(37.233700 -109.096001 521.663025)(38.056900 -109.357994 519.747986)(41.898003 -109.456001 517.320007)(38.056900 -109.357994 519.747986)(39.058498 -109.678001 517.416992)(41.898003 -109.456001 517.320007)(39.058498 -109.678001 517.416992)(39.313801 -109.762993 516.816040)(41.898003 -109.456001 517.320007)(39.313801 -109.762993 516.816040)(39.559902 -109.838005 516.250000)(33.232800 -107.897995 530.796021)(36.370399 -108.790001 523.738953)(41.898003 -109.456001 517.320007)(41.965000 -100.874001 547.864990)(41.951000 -105.669998 541.840942)(41.932999 -108.151001 533.707947)(41.899799 -108.604996 518.491028)(41.932999 -108.151001 533.707947)(41.898003 -109.456001 517.320007)(41.898197 -105.878998 517.421997)(41.899799 -108.604996 518.491028)(41.898003 -109.456001 517.320007)(41.905300 -106.750000 521.044006)(41.932999 -108.151001 533.707947)(41.899799 -108.604996 518.491028)(41.918198 -99.487000 526.510986)(41.905300 -106.750000 521.044006)(41.899799 -108.604996 518.491028)(41.918198 -99.487000 526.510986)(41.932999 -108.151001 533.707947)(41.905300 -106.750000 521.044006)(41.965000 -100.874001 547.864990)(41.932999 -108.151001 533.707947)(41.918198 -99.487000 526.510986)(45.589001 92.432999 396.824982)(44.018997 98.886993 401.951996)(44.993999 95.351006 404.143005)(44.018997 98.886993 401.951996)(45.589001 92.432999 396.824982)(44.018997 98.164001 388.927002)(44.993999 95.351006 404.143005)(44.018997 98.886993 401.951996)(43.928001 100.006996 421.527008)(43.362000 102.135002 430.031006)(42.862999 102.489998 398.992981)(42.858997 103.848999 437.105011)(43.928001 100.006996 421.527008)(42.862999 102.489998 398.992981)(43.362000 102.135002 430.031006)(44.018997 98.886993 401.951996)(42.862999 102.489998 398.992981)(43.928001 100.006996 421.527008)(44.020000 97.305000 375.981018)(44.018997 98.164001 388.927002)(45.589001 92.432999 396.824982)(44.018997 98.164001 388.927002)(42.863998 101.720001 385.408997)(44.018997 98.886993 401.951996)(42.863998 100.806000 371.921997)(42.863998 101.720001 385.408997)(44.018997 98.164001 388.927002)(44.020000 97.305000 375.981018)(42.863998 100.806000 371.921997)(44.018997 98.164001 388.927002)(42.863998 99.831001 365.808014)(42.863998 100.806000 371.921997)(44.020000 97.305000 375.981018)(45.030003 92.881996 374.278015)(44.020000 96.366005 370.035004)(45.030003 93.781998 380.053986)(44.020000 96.366005 370.035004)(44.020000 97.305000 375.981018)(45.030003 93.781998 380.053986)(44.020000 96.366005 370.035004)(42.863998 99.831001 365.808014)(44.020000 97.305000 375.981018)(42.863998 99.831001 365.808014)(44.020000 96.366005 370.035004)(42.863998 96.243004 362.447998)(42.863998 99.831001 365.808014)(42.499302 98.357994 362.348999)(41.556400 100.463005 358.989014)(42.499302 98.357994 362.348999)(42.863998 99.831001 365.808014)(42.863998 96.243004 362.447998)(42.143700 102.505997 367.603973)(41.570801 104.253998 367.906982)(42.863998 100.806000 371.921997)(41.561699 103.788002 363.302002)(42.143700 102.505997 367.603973)(42.863998 100.806000 371.921997)(41.865200 101.732002 362.399017)(41.561699 103.788002 363.302002)(42.863998 99.831001 365.808014)(41.556400 100.463005 358.989014)(41.561699 103.788002 363.302002)(41.865200 101.732002 362.399017)(41.556400 100.463005 358.989014)(41.561699 103.788002 363.302002)(41.560402 103.690994 363.161011)(41.549000 103.334000 357.934998)(41.556400 100.463005 358.989014)(41.541000 88.298996 354.263000)(41.549000 103.334000 357.934998)(41.541000 88.298996 354.263000)(24.572001 88.039001 354.567993)(41.549000 103.334000 357.934998)(41.560402 103.690994 363.161011)(41.556400 100.463005 358.989014)(42.863998 99.831001 365.808014)(41.561699 103.788002 363.302002)(42.863998 100.806000 371.921997)(41.556400 100.463005 358.989014)(41.560200 88.260201 356.608978)(41.541000 88.298996 354.263000)(24.572001 88.039001 354.567993)(21.541000 102.112000 357.934998)(41.549000 103.334000 357.934998)(41.563000 103.900002 364.347992)(42.143700 102.505997 367.603973)(41.561699 103.788002 363.302002)(41.558998 106.091003 362.724976)(41.570801 104.253998 367.906982)(41.563000 103.900002 364.347992)(41.558998 106.091003 362.724976)(41.563000 103.900002 364.347992)(41.561699 103.788002 363.302002)(41.558998 106.091003 362.724976)(41.570900 104.259003 367.989990)(41.570801 104.253998 367.906982)(41.558998 106.091003 362.724976)(41.561699 103.788002 363.302002)(41.560402 103.690994 363.161011)(41.571098 104.264000 368.078003)(41.570900 104.259003 367.989990)(41.558998 106.091003 362.724976)(42.340900 103.037003 383.490997)(41.570900 104.259003 367.989990)(41.571098 104.264000 368.078003)(41.571098 104.264000 368.078003)(42.862999 102.489998 398.992981)(42.340900 103.037003 383.490997)(41.570900 104.259003 367.989990)(42.340900 103.037003 383.490997)(42.863998 101.720001 385.408997)(41.560200 88.260201 356.608978)(41.556400 100.463005 358.989014)(42.070198 97.139000 359.908020)(41.556400 100.463005 358.989014)(42.863998 96.243004 362.447998)(42.070198 97.139000 359.908020)(42.070198 97.139000 359.908020)(42.863998 96.243004 362.447998)(42.746998 87.457001 360.680023)(42.863998 101.720001 385.408997)(42.340900 103.037003 383.490997)(42.862999 102.489998 398.992981)(24.572001 88.039001 354.567993)(7.603000 87.778999 354.873016)(21.541000 102.112000 357.934998)(0.980996 99.698997 357.934998)(7.603000 87.778999 354.873016)(-19.615000 101.438995 357.934998)(7.603000 87.778999 354.873016)(0.980996 99.698997 357.934998)(21.541000 102.112000 357.934998)(0.980996 99.698997 357.934998)(21.573000 106.091003 362.724976)(21.541000 102.112000 357.934998)(41.586601 104.509003 375.111023)(41.571098 104.264000 368.078003)(41.558998 106.091003 362.724976)(41.761200 110.111000 455.091003)(41.586601 104.509003 375.111023)(41.558998 106.091003 362.724976)(41.761200 110.111000 455.091003)(41.736801 106.903999 443.817993)(41.586601 104.509003 375.111023)(41.761200 110.111000 455.091003)(41.558998 106.091003 362.724976)(40.704002 110.114998 455.193024)(40.704002 110.114998 455.193024)(21.573000 106.091003 362.724976)(36.112701 109.979004 454.970001)(-20.822300 106.959999 531.364014)(-66.859001 105.430000 519.893982)(-86.876701 104.764999 520.263000)(-65.292999 106.380997 532.132019)(-20.822300 106.959999 531.364014)(-86.876701 104.764999 520.263000)(-65.292999 106.380997 532.132019)(-86.876701 104.764999 520.263000)(-108.653000 104.425995 520.135010)(-65.292999 106.380997 532.132019)(-108.653000 104.425995 520.135010)(-174.260010 101.861000 505.577972)(-11.589200 106.377998 536.640991)(-11.625000 105.641998 539.717957)(20.557201 107.150002 536.106995)(-16.271900 106.265999 536.718994)(-11.625000 105.641998 539.717957)(-11.589200 106.377998 536.640991)(41.932999 108.151001 533.707947)(41.951000 105.669998 541.840942)(41.965000 100.874001 547.864990)(31.407400 107.657997 534.888977)(41.951000 105.669998 541.840942)(41.932999 108.151001 533.707947)(35.002499 108.396004 526.828003)(31.999201 107.987000 533.562012)(41.932999 108.151001 533.707947)(31.999201 107.987000 533.562012)(31.407400 107.657997 534.888977)(41.932999 108.151001 533.707947)(31.407400 107.657997 534.888977)(30.941299 107.333000 535.933960)(41.951000 105.669998 541.840942)(41.951000 105.669998 541.840942)(20.557201 107.150002 536.106995)(-11.625000 105.641998 539.717957)(-22.224501 106.913002 528.226013)(-26.114500 106.509003 519.519958)(-42.201599 106.249001 519.438965)(-20.822300 106.959999 531.364014)(-22.224501 106.913002 528.226013)(-42.201599 106.249001 519.438965)(-42.543900 106.000999 535.635986)(-19.717800 106.887001 533.835999)(-20.182499 107.125000 532.796021)(-65.370003 104.758003 538.934998)(-65.389000 100.506996 545.154968)(-11.625000 105.641998 539.717957)(-65.389000 100.506996 545.154968)(-11.644000 101.392998 545.932007)(-11.625000 105.641998 539.717957)(-174.260010 101.861000 505.577972)(-141.460007 102.950996 488.976990)(-174.260010 101.861000 461.351013)(-108.718002 104.039001 490.179993)(-174.260010 101.861000 461.351013)(-141.460007 102.950996 488.976990)(-174.260010 101.861000 461.351013)(-108.718002 104.039001 490.179993)(-108.719994 104.013000 489.520996)(-174.260010 101.861000 461.351013)(-108.719994 104.013000 489.520996)(-108.719994 104.005997 489.352997)(-108.733994 103.766998 483.282013)(-108.742996 103.891998 479.122986)(-174.260010 101.861000 461.351013)(-174.260010 101.861000 461.351013)(-108.719994 104.005997 489.352997)(-108.733994 103.766998 483.282013)(-65.389000 100.506996 545.154968)(-119.135002 99.620003 544.377991)(-119.093002 93.363998 548.587952)(-65.347000 94.255997 549.362000)(-65.389000 100.506996 545.154968)(-119.093002 93.363998 548.587952)(-119.041000 105.494003 531.342041)(-174.260010 101.861000 505.577972)(-174.260010 101.861000 527.593018)(-11.644000 101.392998 545.932007)(-65.389000 100.506996 545.154968)(-65.347000 94.255997 549.362000)(-11.602000 95.147995 550.136963)(-11.644000 101.392998 545.932007)(-65.347000 94.255997 549.362000)(41.965000 100.874001 547.864990)(-11.644000 101.392998 545.932007)(-11.602000 95.147995 550.136963)(-108.718002 104.039001 490.179993)(-141.460007 102.950996 488.976990)(-108.691002 104.039993 502.781982)(-108.690002 104.039993 503.285004)(-108.691002 104.039993 502.781982)(-141.460007 102.950996 488.976990)(-108.661003 104.041000 516.291992)(-108.662003 104.041000 516.104004)(-141.460007 102.950996 488.976990)(-174.260010 101.861000 505.577972)(-108.653000 104.425995 520.135010)(-108.661003 104.041000 516.601990)(-108.661003 104.041000 516.601990)(-141.460007 102.950996 488.976990)(-174.260010 101.861000 505.577972)(-119.135002 99.620003 544.377991)(-65.389000 100.506996 545.154968)(-65.370003 104.758003 538.934998)(41.973000 92.264999 551.796997)(41.965000 100.874001 547.864990)(-11.602000 95.147995 550.136963)(41.973000 92.264999 551.796997)(-11.602000 95.147995 550.136963)(-11.504000 88.339996 551.713013)(41.898003 109.456001 517.320007)(41.898197 105.878998 517.421997)(41.897800 106.003998 517.218018)(41.898003 109.456001 517.320007)(41.897800 106.003998 517.218018)(41.892399 107.468002 514.809021)(35.002499 108.396004 526.828003)(41.898003 109.456001 517.320007)(39.559902 109.838005 516.250000)(39.559902 109.838005 516.250000)(41.898003 109.456001 517.320007)(41.882999 112.118996 510.591980)(41.890499 109.061005 513.955994)(41.898003 109.456001 517.320007)(41.892399 107.468002 514.809021)(41.890499 109.061005 513.955994)(41.892399 107.468002 514.809021)(41.885101 109.429001 511.524963)(41.898003 109.456001 517.320007)(41.890499 109.061005 513.955994)(41.882999 112.118996 510.591980)(41.973000 92.264999 551.796997)(41.933102 91.898705 533.554016)(41.945698 96.386406 539.153992)(41.932800 92.076797 533.430969)(41.945698 96.386406 539.153992)(41.933102 91.898705 533.554016)(41.965000 100.874001 547.864990)(41.973000 92.264999 551.796997)(41.945698 96.386406 539.153992)(41.965000 100.874001 547.864990)(41.945698 96.386406 539.153992)(41.918198 99.487000 526.510986)(41.918198 99.487000 526.510986)(41.931801 95.781898 532.832031)(41.932800 92.076797 533.430969)(41.945698 96.386406 539.153992)(41.931801 95.781898 532.832031)(41.918198 99.487000 526.510986)(41.931801 95.781898 532.832031)(41.945698 96.386406 539.153992)(41.932800 92.076797 533.430969)(41.973000 92.264999 551.796997)(41.939301 87.826401 536.362000)(41.933102 91.898705 533.554016)(41.978001 54.875000 553.933960)(41.959400 56.295303 545.449036)(41.959503 57.327599 545.482971)(41.958000 62.816700 544.821960)(41.978001 54.875000 553.933960)(41.959503 57.327599 545.482971)(41.956997 65.602196 544.356995)(41.978001 54.875000 553.933960)(41.958000 62.816700 544.821960)(41.956997 65.602196 544.356995)(41.973000 92.264999 551.796997)(41.978001 54.875000 553.933960)(41.962200 30.018700 546.692017)(41.959202 53.446301 545.358032)(41.978001 54.875000 553.933960)(41.950302 78.220802 541.342041)(41.973000 92.264999 551.796997)(41.952099 75.767197 542.196960)(41.939301 87.826401 536.362000)(41.973000 92.264999 551.796997)(41.950302 78.220802 541.342041)(41.962200 30.018700 546.692017)(41.968597 1.151140 549.645996)(41.960796 0.000000 546.080994)(41.968597 -1.151140 549.645996)(41.960796 0.000000 546.080994)(41.968597 1.151140 549.645996)(41.960796 0.000000 546.080994)(41.968597 -1.151140 549.645996)(41.962200 -30.018700 546.692017)(41.952099 75.767197 542.196960)(41.973000 92.264999 551.796997)(41.956997 65.602196 544.356995)(-11.602000 95.147995 550.136963)(-65.347000 94.255997 549.362000)(-65.251999 87.443001 550.935974)(41.959400 56.295303 545.449036)(41.978001 54.875000 553.933960)(41.959202 53.446301 545.358032)(-11.625000 105.641998 539.717957)(-11.644000 101.392998 545.932007)(41.951000 105.669998 541.840942)(41.882999 112.118996 510.591980)(41.890499 109.061005 513.955994)(41.883400 110.609001 510.778015)(-119.115997 103.874001 538.150024)(-119.041000 105.494003 531.342041)(-174.260010 101.861000 527.593018)(41.885101 -109.429001 511.524963)(41.890499 -109.061005 513.955994)(41.883400 -110.609001 510.778015)(41.897800 -106.003998 517.218018)(41.898003 -109.456001 517.320007)(41.892399 -107.468002 514.809021)(41.892399 -107.468002 514.809021)(41.898003 -109.456001 517.320007)(41.890499 -109.061005 513.955994)(41.892399 -107.468002 514.809021)(41.890499 -109.061005 513.955994)(41.885101 -109.429001 511.524963)(41.883400 -110.609001 510.778015)(41.890499 -109.061005 513.955994)(41.882999 -112.118996 510.591980)(41.890499 -109.061005 513.955994)(41.898003 -109.456001 517.320007)(41.882999 -112.118996 510.591980)(-81.347000 100.429001 357.934998)(-101.896004 104.075996 362.724976)(-60.763000 103.795998 362.724976)(-60.763000 103.795998 362.724976)(-60.752998 98.686005 357.934998)(-81.347000 100.429001 357.934998)(-40.193001 101.102997 357.934998)(-60.752998 98.686005 357.934998)(-60.763000 103.795998 362.724976)(-77.243004 86.478004 356.397980)(-60.752998 98.686005 357.934998)(-60.272999 86.737999 356.092987)(-60.752998 98.686005 357.934998)(-77.243004 86.478004 356.397980)(-81.347000 100.429001 357.934998)(-40.193001 101.102997 357.934998)(-60.763000 103.795998 362.724976)(-19.615000 101.438995 357.934998)(-60.763000 103.795998 362.724976)(21.573000 106.091003 362.724976)(-19.615000 101.438995 357.934998)(-101.896004 104.075996 362.724976)(-174.260010 101.861000 393.664001)(-60.763000 103.795998 362.724976)(-19.615000 101.438995 357.934998)(-26.334999 87.259003 355.483002)(-40.193001 101.102997 357.934998)(-173.869995 0.441005 366.456970)(-179.389999 -0.441005 375.324982)(-179.389999 0.441005 375.324982)(-121.857002 101.837997 361.869019)(-170.673004 103.360001 379.378998)(-101.896004 104.075996 362.724976)(-149.495010 97.790001 363.494995)(-170.673004 103.360001 379.378998)(-121.857002 101.837997 361.869019)(-173.537003 -47.617001 368.218018)(-173.869995 -0.441005 366.456970)(-160.667999 -0.441005 359.252991)(-173.869995 -0.441005 366.456970)(-173.537003 -47.617001 368.218018)(-175.944000 -44.369999 373.253998)(-175.944000 -44.369999 373.253998)(-173.537003 -47.617001 368.218018)(-179.389999 -88.012001 388.846008)(-160.667999 -0.441005 359.252991)(-173.869995 -0.441005 366.456970)(-160.667999 0.441005 359.252991)(-173.869995 -0.441005 366.456970)(-179.389999 -0.441005 375.324982)(-173.869995 0.441005 366.456970)(-173.869995 -0.441005 366.456970)(-173.869995 0.441005 366.456970)(-160.667999 0.441005 359.252991)(-160.667999 -0.441005 359.252991)(-160.667999 0.441005 359.252991)(-145.686996 0.441004 355.087006)(-148.231003 49.443001 357.250977)(-145.686996 0.441004 355.087006)(-160.667999 0.441005 359.252991)(-140.007004 29.219000 354.571991)(-148.231003 49.443001 357.250977)(-135.472000 47.260002 354.721985)(-140.007004 29.219000 354.571991)(-141.477005 23.040001 354.537018)(-148.231003 49.443001 357.250977)(-141.477005 23.040001 354.537018)(-145.686996 0.441004 355.087006)(-148.231003 49.443001 357.250977)(-141.477005 0.000000 354.537018)(-145.686996 0.441004 355.087006)(-141.477005 23.040001 354.537018)(-145.686996 -0.441004 355.087006)(-145.686996 0.441004 355.087006)(-141.477005 0.000000 354.537018)(-173.537003 47.617001 368.218018)(-160.667999 0.441005 359.252991)(-173.869995 0.441005 366.456970)(-175.944000 44.369999 373.253998)(-173.537003 47.617001 368.218018)(-173.869995 0.441005 366.456970)(-170.673004 103.360001 379.378998)(-162.182007 97.984001 368.515015)(-168.220993 98.103004 371.578979)(-160.835999 49.456997 361.252991)(-168.220993 98.103004 371.578979)(-162.182007 97.984001 368.515015)(-170.673004 103.360001 379.378998)(-168.220993 98.103004 371.578979)(-174.177002 95.821999 377.274994)(-174.177002 95.821999 377.274994)(-179.389999 88.012001 388.846008)(-170.673004 103.360001 379.378998)(-179.389999 88.012001 388.846008)(-174.177002 95.821999 377.274994)(-173.537003 47.617001 368.218018)(-174.177002 95.821999 377.274994)(-160.835999 49.456997 361.252991)(-173.537003 47.617001 368.218018)(-174.177002 95.821999 377.274994)(-168.220993 98.103004 371.578979)(-160.835999 49.456997 361.252991)(-160.835999 49.456997 361.252991)(-162.182007 97.984001 368.515015)(-149.495010 97.790001 363.494995)(-149.495010 97.790001 363.494995)(-148.231003 49.443001 357.250977)(-160.835999 49.456997 361.252991)(-160.667999 0.441005 359.252991)(-173.537003 47.617001 368.218018)(-160.835999 49.456997 361.252991)(-170.673004 103.360001 379.378998)(-179.389999 88.012001 388.846008)(-174.260010 101.861000 393.664001)(-179.389999 94.904999 463.443024)(-174.260010 101.861000 393.664001)(-179.389999 90.622002 401.414978)(-179.389999 90.622002 401.414978)(-174.260010 101.861000 393.664001)(-179.389999 88.012001 388.846008)(-162.182007 97.984001 368.515015)(-170.673004 103.360001 379.378998)(-149.495010 97.790001 363.494995)(-121.857002 101.837997 361.869019)(-101.896004 104.075996 362.724976)(-101.926003 100.093002 357.934998)(-40.193001 101.102997 357.934998)(-26.334999 87.259003 355.483002)(-60.272999 86.737999 356.092987)(-101.926003 100.093002 357.934998)(-118.275002 79.184006 356.402008)(-121.857002 101.837997 361.869019)(-118.275002 79.184006 356.402008)(-101.926003 100.093002 357.934998)(-108.735001 83.295006 356.660004)(-118.275002 79.184006 356.402008)(-124.982994 72.045998 355.863983)(-121.857002 101.837997 361.869019)(-121.857002 101.837997 361.869019)(-124.982994 72.045998 355.863983)(-135.472000 47.260002 354.721985)(-81.347000 100.429001 357.934998)(-94.212006 86.218002 356.704010)(-101.926003 100.093002 357.934998)(-94.212006 86.218002 356.704010)(-102.599998 84.996002 356.729004)(-101.926003 100.093002 357.934998)(-170.673004 103.360001 379.378998)(-174.260010 101.861000 393.664001)(-101.896004 104.075996 362.724976)(41.558998 106.091003 362.724976)(41.560402 103.690994 363.161011)(41.549000 103.334000 357.934998)(21.573000 106.091003 362.724976)(41.558998 106.091003 362.724976)(41.549000 103.334000 357.934998)(7.603000 -87.778999 354.873016)(-19.615000 -101.438995 357.934998)(-26.334999 -87.259003 355.483002)(41.556400 100.463005 358.989014)(42.499302 98.357994 362.348999)(42.863998 96.243004 362.447998)(-179.389999 -0.441005 375.324982)(-173.869995 -0.441005 366.456970)(-175.944000 -44.369999 373.253998)(42.862999 -102.489998 398.992981)(41.586601 -104.509003 375.111023)(41.571098 -104.264000 368.078003)(41.959202 -53.446301 545.358032)(41.978001 -54.875000 553.933960)(41.959400 -56.295303 545.449036)(44.958000 -88.740997 370.332001)(44.763500 -92.553497 372.123016)(44.020000 -96.366005 370.035004)(41.978001 54.875000 553.933960)(41.978001 0.000000 553.933960)(41.968597 1.151140 549.645996)(41.962200 30.018700 546.692017)(41.978001 54.875000 553.933960)(41.968597 1.151140 549.645996)(43.809998 -88.031998 364.948975)(44.958000 -88.740997 370.332001)(44.020000 -92.696007 366.596985)(41.570900 -104.259003 367.989990)(41.571098 -104.264000 368.078003)(41.558998 -106.091003 362.724976)(41.968597 -1.151140 549.645996)(41.978001 -54.875000 553.933960)(41.962200 -30.018700 546.692017)(-60.752998 -98.686005 357.934998)(-81.347000 -100.429001 357.934998)(-77.243004 -86.478004 356.397980)(-108.662003 104.041000 516.104004)(-108.690002 104.039993 503.285004)(-141.460007 102.950996 488.976990)(36.112701 109.979004 454.970001)(-60.763000 103.795998 362.724976)(22.221699 109.572998 454.324005)(-108.750000 103.984001 476.016022)(-174.260010 101.861000 461.351013)(-108.742996 103.891998 479.122986)(-108.750000 103.984001 476.016022)(-108.781998 104.431000 461.050995)(-174.260010 101.861000 461.351013)(21.541000 102.112000 357.934998)(21.573000 106.091003 362.724976)(41.549000 103.334000 357.934998)(-18.422001 -106.220001 536.732971)(-11.625000 -105.641998 539.717957)(-38.479599 -105.834000 536.674011)(-65.370003 -104.758003 538.934998)(-38.479599 -105.834000 536.674011)(-11.625000 -105.641998 539.717957)(-38.479599 -105.834000 536.674011)(-19.717800 -106.887001 533.835999)(-18.810200 -106.418999 535.867004)(-38.479599 -105.834000 536.674011)(-18.810200 -106.418999 535.867004)(-18.422001 -106.220001 536.732971)(-38.479599 105.834000 536.674011)(-18.810200 106.418999 535.867004)(-19.717800 106.887001 533.835999)(44.020000 -92.696007 366.596985)(43.692997 -94.530998 366.203003)(42.863998 -96.243004 362.447998)(44.020000 -97.305000 375.981018)(45.030003 -93.781998 380.053986)(45.589001 -92.432999 396.824982)(20.557201 107.150002 536.106995)(41.951000 105.669998 541.840942)(30.941299 107.333000 535.933960)(39.559902 -109.838005 516.250000)(41.882999 -112.118996 510.591980)(41.898003 -109.456001 517.320007)(41.556400 100.463005 358.989014)(41.865200 101.732002 362.399017)(42.863998 99.831001 365.808014)(-108.822998 104.429001 442.579010)(22.221699 109.572998 454.324005)(-174.260010 101.861000 393.664001)(-20.822300 106.959999 531.364014)(-42.201599 106.249001 519.438965)(-66.859001 105.430000 519.893982)(43.809998 -88.031998 364.948975)(44.020000 -92.696007 366.596985)(42.863998 -96.243004 362.447998)(-108.691002 -104.039993 502.781982)(-141.460007 -102.950996 488.976990)(-108.718002 -104.039001 490.179993)(-108.719994 -104.005997 489.352997)(-108.719994 -104.013000 489.520996)(-174.260010 -101.861000 461.351013)(-174.260010 -101.861000 461.351013)(-108.719994 -104.013000 489.520996)(-108.718002 -104.039001 490.179993)(41.883400 110.609001 510.778015)(41.890499 109.061005 513.955994)(41.885101 109.429001 511.524963)(-101.926003 100.093002 357.934998)(-101.896004 104.075996 362.724976)(-81.347000 100.429001 357.934998)(41.549000 -103.334000 357.934998)(21.573000 -106.091003 362.724976)(21.541000 -102.112000 357.934998)(-42.543900 -106.000999 535.635986)(-20.182499 -107.125000 532.796021)(-19.717800 -106.887001 533.835999)(-65.389000 -100.506996 545.154968)(-65.370003 -104.758003 538.934998)(-11.625000 -105.641998 539.717957)(-42.543900 106.000999 535.635986)(-20.182499 107.125000 532.796021)(-65.292999 106.380997 532.132019)(41.968597 -1.151140 549.645996)(41.978001 0.000000 553.933960)(41.978001 -54.875000 553.933960)(41.570900 -104.259003 367.989990)(42.863998 -100.806000 371.921997)(42.863998 -101.720001 385.408997)(44.958000 -88.740997 370.332001)(45.030003 -92.881996 374.278015)(44.763500 -92.553497 372.123016)(41.556400 -100.463005 358.989014)(41.541000 -88.298996 354.263000)(41.560200 -88.260201 356.608978)(41.912899 101.700996 524.294006)(41.899799 108.604996 518.491028)(41.916500 100.043999 525.991028)(-77.243004 86.478004 356.397980)(-94.212006 86.218002 356.704010)(-81.347000 100.429001 357.934998)(-121.857002 101.837997 361.869019)(-135.472000 47.260002 354.721985)(-149.495010 97.790001 363.494995)(-26.334999 -87.259003 355.483002)(-40.193001 -101.102997 357.934998)(-60.272999 -86.737999 356.092987)(41.945698 -96.386406 539.153992)(41.965000 -100.874001 547.864990)(41.918198 -99.487000 526.510986)(-160.667999 0.441005 359.252991)(-160.835999 49.456997 361.252991)(-148.231003 49.443001 357.250977)(41.570801 104.253998 367.906982)(41.570900 104.259003 367.989990)(42.863998 100.806000 371.921997)(-94.212006 -86.218002 356.704010)(-101.926003 -100.093002 357.934998)(-102.599998 -84.996002 356.729004)(-65.292999 -106.380997 532.132019)(-20.822300 -106.959999 531.364014)(-20.182499 -107.125000 532.796021)(41.556400 -100.463005 358.989014)(41.865200 -101.732002 362.399017)(41.561699 -103.788002 363.302002)(41.560402 -103.690994 363.161011)(41.561699 -103.788002 363.302002)(41.556400 -100.463005 358.989014)(-108.661003 104.041000 516.601990)(-108.661003 104.041000 516.291992)(-141.460007 102.950996 488.976990)(-118.275002 -79.184006 356.402008)(-121.857002 -101.837997 361.869019)(-124.982994 -72.045998 355.863983)(-65.347000 -94.255997 549.362000)(-65.389000 -100.506996 545.154968)(-11.644000 -101.392998 545.932007)(42.863998 100.806000 371.921997)(41.570900 104.259003 367.989990)(42.863998 101.720001 385.408997)(-38.479599 105.834000 536.674011)(-18.422001 106.220001 536.732971)(-18.810200 106.418999 535.867004)(-60.763000 -103.795998 362.724976)(-101.896004 -104.075996 362.724976)(-81.347000 -100.429001 357.934998)(-16.271900 106.265999 536.718994)(-18.422001 106.220001 536.732971)(-11.625000 105.641998 539.717957)(-160.835999 -49.456997 361.252991)(-173.537003 -47.617001 368.218018)(-160.667999 -0.441005 359.252991)(-174.260010 101.861000 461.351013)(-108.822998 104.429001 442.579010)(-174.260010 101.861000 393.664001)(-102.599998 84.996002 356.729004)(-108.735001 83.295006 356.660004)(-101.926003 100.093002 357.934998)(-160.667999 -0.441005 359.252991)(-145.686996 0.441004 355.087006)(-145.686996 -0.441004 355.087006)(0.980996 -99.698997 357.934998)(21.573000 -106.091003 362.724976)(-19.615000 -101.438995 357.934998)(-179.389999 94.904999 463.443024)(-179.389999 90.622002 401.414978)(-179.389999 88.012001 388.846008)(-119.041000 105.494003 531.342041)(-119.115997 103.874001 538.150024)(-65.292999 106.380997 532.132019)(44.020000 96.366005 370.035004)(45.030003 92.881996 374.278015)(44.763500 92.553497 372.123016)(44.020000 96.366005 370.035004)(43.692997 94.530998 366.203003)(42.863998 96.243004 362.447998)(-135.472000 47.260002 354.721985)(-148.231003 49.443001 357.250977)(-149.495010 97.790001 363.494995)(42.862999 -102.489998 398.992981)(41.736801 -106.903999 443.817993)(41.586601 -104.509003 375.111023)(-65.251999 87.443001 550.935974)(-11.504000 88.339996 551.713013)(-11.602000 95.147995 550.136963)(-175.944000 44.369999 373.253998)(-179.389999 41.200001 378.924988)(-179.389999 88.012001 388.846008)(-179.389999 88.012001 388.846008)(-173.537003 47.617001 368.218018)(-175.944000 44.369999 373.253998)(41.898003 109.456001 517.320007)(41.899799 108.604996 518.491028)(41.898197 105.878998 517.421997)(-141.477005 -23.040001 354.537018)(-145.686996 -0.441004 355.087006)(-141.477005 0.000000 354.537018)(-40.193001 101.102997 357.934998)(-60.272999 86.737999 356.092987)(-60.752998 98.686005 357.934998)(0.980996 -99.698997 357.934998)(21.541000 -102.112000 357.934998)(21.573000 -106.091003 362.724976)(-11.644000 -101.392998 545.932007)(-11.602000 -95.147995 550.136963)(-65.347000 -94.255997 549.362000)(-119.041000 105.494003 531.342041)(-65.292999 106.380997 532.132019)(-174.260010 101.861000 505.577972)(-77.243004 -86.478004 356.397980)(-81.347000 -100.429001 357.934998)(-94.212006 -86.218002 356.704010)(41.932999 108.151001 533.707947)(41.965000 100.874001 547.864990)(41.918198 99.487000 526.510986)(42.863998 -100.806000 371.921997)(42.863998 -99.831001 365.808014)(44.020000 -97.305000 375.981018)(41.898197 -105.878998 517.421997)(41.909698 -102.618004 522.785034)(41.899799 -108.604996 518.491028)(-11.625000 105.641998 539.717957)(-18.422001 106.220001 536.732971)(-38.479599 105.834000 536.674011)(44.018997 -98.164001 388.927002)(45.589001 -92.432999 396.824982)(44.018997 -98.886993 401.951996)(41.563000 103.900002 364.347992)(41.570801 104.253998 367.906982)(42.143700 102.505997 367.603973)(-108.661003 -104.041000 516.601990)(-141.460007 -102.950996 488.976990)(-108.661003 -104.041000 516.291992)(41.959400 -56.295303 545.449036)(41.978001 -54.875000 553.933960)(41.959503 -57.327599 545.482971)(-19.615000 101.438995 357.934998)(21.573000 106.091003 362.724976)(0.980996 99.698997 357.934998)(42.863998 101.720001 385.408997)(42.862999 102.489998 398.992981)(44.018997 98.886993 401.951996)(-65.292999 106.380997 532.132019)(-20.182499 107.125000 532.796021)(-20.822300 106.959999 531.364014)(33.232800 -107.897995 530.796021)(41.898003 -109.456001 517.320007)(41.932999 -108.151001 533.707947)(-19.615000 -101.438995 357.934998)(-40.193001 -101.102997 357.934998)(-26.334999 -87.259003 355.483002)(-11.602000 -95.147995 550.136963)(-65.251999 -87.443001 550.935974)(-65.347000 -94.255997 549.362000)(41.736801 106.903999 443.817993)(42.862999 102.489998 398.992981)(41.586601 104.509003 375.111023)(42.178001 105.959000 446.110992)(41.736801 106.903999 443.817993)(41.753201 107.167000 451.436005)(42.178001 105.959000 446.110992)(42.862999 102.489998 398.992981)(41.736801 106.903999 443.817993)(-11.644000 101.392998 545.932007)(41.965000 100.874001 547.864990)(41.951000 105.669998 541.840942)(-108.781998 104.431000 461.050995)(-108.822998 104.429001 442.579010)(-174.260010 101.861000 461.351013)(-60.752998 -98.686005 357.934998)(-60.763000 -103.795998 362.724976)(-81.347000 -100.429001 357.934998)(-86.876701 -104.764999 520.263000)(-20.822300 -106.959999 531.364014)(-65.292999 -106.380997 532.132019)(41.968597 1.151140 549.645996)(41.978001 0.000000 553.933960)(41.968597 -1.151140 549.645996)(36.112701 109.979004 454.970001)(21.573000 106.091003 362.724976)(-60.763000 103.795998 362.724976)(-86.876701 -104.764999 520.263000)(-66.859001 -105.430000 519.893982)(-20.822300 -106.959999 531.364014)(-65.370003 104.758003 538.934998)(-38.479599 105.834000 536.674011)(-19.717800 106.887001 533.835999)(41.556400 -100.463005 358.989014)(41.560402 -103.690994 363.161011)(41.549000 -103.334000 357.934998)(-108.750000 -103.984001 476.016022)(-174.260010 -101.861000 461.351013)(-108.781998 -104.431000 461.050995)(41.570801 -104.253998 367.906982)(41.570900 -104.259003 367.989990)(41.558998 -106.091003 362.724976)(42.862999 -102.489998 398.992981)(43.928001 -100.006996 421.527008)(43.362000 -102.135002 430.031006)(-179.389999 -0.441005 375.324982)(-175.944000 -44.369999 373.253998)(-179.389999 -41.200001 378.924988)(42.746998 87.457001 360.680023)(41.560200 88.260201 356.608978)(42.070198 97.139000 359.908020)(-179.389999 94.904999 463.443024)(-174.260010 101.861000 461.351013)(-174.260010 101.861000 393.664001)(7.603000 87.778999 354.873016)(-26.334999 87.259003 355.483002)(-19.615000 101.438995 357.934998)(41.897800 -106.003998 517.218018)(41.898197 -105.878998 517.421997)(41.898003 -109.456001 517.320007)(42.746998 -87.457001 360.680023)(42.863998 -96.243004 362.447998)(42.070198 -97.139000 359.908020)(41.560402 -103.690994 363.161011)(41.561699 -103.788002 363.302002)(41.558998 -106.091003 362.724976)(41.962200 -30.018700 546.692017)(41.978001 -54.875000 553.933960)(41.959202 -53.446301 545.358032)(42.862999 102.489998 398.992981)(41.571098 104.264000 368.078003)(41.586601 104.509003 375.111023)(31.999201 -107.987000 533.562012)(33.232800 -107.897995 530.796021)(41.932999 -108.151001 533.707947)(40.704002 110.114998 455.193024)(41.558998 106.091003 362.724976)(21.573000 106.091003 362.724976)(-174.260010 -101.861000 461.351013)(-108.718002 -104.039001 490.179993)(-141.460007 -102.950996 488.976990)(-174.260010 101.861000 393.664001)(22.221699 109.572998 454.324005)(-60.763000 103.795998 362.724976)(45.693001 89.557999 376.733002)(45.030003 92.881996 374.278015)(45.859001 90.318001 382.876984)(-148.231003 -49.443001 357.250977)(-135.472000 -47.260002 354.721985)(-149.495010 -97.790001 363.494995)(41.973000 -92.264999 551.796997)(-11.504000 -88.339996 551.713013)(-11.602000 -95.147995 550.136963)(41.899799 -108.604996 518.491028)(41.909698 -102.618004 522.785034)(41.912899 -101.700996 524.294006)(45.589001 92.432999 396.824982)(45.030003 93.781998 380.053986)(44.020000 97.305000 375.981018)(42.862999 102.489998 398.992981)(42.178001 105.959000 446.110992)(42.858997 103.848999 437.105011)(-179.389999 -41.200001 378.924988)(-175.944000 -44.369999 373.253998)(-179.389999 -88.012001 388.846008)(-11.625000 105.641998 539.717957)(-38.479599 105.834000 536.674011)(-65.370003 104.758003 538.934998)(-160.835999 -49.456997 361.252991)(-148.231003 -49.443001 357.250977)(-149.495010 -97.790001 363.494995)(-121.857002 -101.837997 361.869019)(-118.275002 -79.184006 356.402008)(-101.926003 -100.093002 357.934998)(-11.644000 -101.392998 545.932007)(41.951000 -105.669998 541.840942)(41.965000 -100.874001 547.864990)(41.761200 110.111000 455.091003)(41.753201 107.167000 451.436005)(41.736801 106.903999 443.817993)(-19.717800 -106.887001 533.835999)(-38.479599 -105.834000 536.674011)(-65.370003 -104.758003 538.934998)(-65.370003 104.758003 538.934998)(-19.717800 106.887001 533.835999)(-42.543900 106.000999 535.635986)(-108.733994 -103.766998 483.282013)(-108.719994 -104.005997 489.352997)(-174.260010 -101.861000 461.351013)(-172.479004 0.000000 550.620972)(-179.389999 0.441013 545.104980)(-179.389999 -0.441013 545.104980)(-179.389999 0.441013 545.104980)(-181.529999 1.361440 478.445007)(-179.389999 -0.441013 545.104980)(-119.093002 -93.363998 548.587952)(-173.253006 -85.556999 548.661987)(-173.260010 -92.579002 546.385986)(-173.253006 -85.556999 548.661987)(-179.389999 -84.383003 542.888000)(-173.260010 -92.579002 546.385986)(-179.389999 -78.511002 545.104980)(-179.389999 -84.383003 542.888000)(-173.253006 -85.556999 548.661987)(-176.480988 -93.792999 536.950012)(-173.260010 -92.579002 546.385986)(-179.389999 -84.383003 542.888000)(-179.389999 -95.949005 526.393982)(-176.480988 -93.792999 536.950012)(-179.389999 -88.257996 535.483032)(-176.480988 -93.792999 536.950012)(-179.389999 -84.383003 542.888000)(-179.389999 -88.257996 535.483032)(-179.389999 -94.904999 463.443024)(-179.389999 -95.949005 526.393982)(-179.389999 -88.257996 535.483032)(-179.389999 -94.904999 463.443024)(-179.389999 -88.257996 535.483032)(-179.389999 -84.383003 542.888000)(-179.389999 -95.949005 526.393982)(-172.671005 -101.859001 538.221985)(-176.480988 -93.792999 536.950012)(-119.115997 -103.874001 538.150024)(-119.135002 -99.620003 544.377991)(-172.671005 -101.859001 538.221985)(-119.135002 -99.620003 544.377991)(-119.093002 -93.363998 548.587952)(-172.671005 -101.859001 538.221985)(-65.389000 -100.506996 545.154968)(-119.093002 -93.363998 548.587952)(-119.135002 -99.620003 544.377991)(-174.260010 -101.861000 527.593018)(-119.115997 -103.874001 538.150024)(-172.671005 -101.859001 538.221985)(-119.041000 -105.494003 531.342041)(-119.115997 -103.874001 538.150024)(-174.260010 -101.861000 527.593018)(-65.292999 -106.380997 532.132019)(-119.041000 -105.494003 531.342041)(-174.260010 -101.861000 505.577972)(-108.653000 -104.425995 520.135010)(-65.292999 -106.380997 532.132019)(-174.260010 -101.861000 505.577972)(-174.260010 -101.861000 505.577972)(-141.460007 -102.950996 488.976990)(-108.661003 -104.041000 516.601990)(-108.661003 -104.041000 516.601990)(-108.653000 -104.425995 520.135010)(-174.260010 -101.861000 505.577972)(-174.260010 -101.861000 505.577972)(-119.041000 -105.494003 531.342041)(-174.260010 -101.861000 527.593018)(-174.260010 -101.861000 527.593018)(-179.389999 -95.949005 526.393982)(-174.260010 -101.861000 505.577972)(-181.815994 -44.977798 468.768005)(-181.834991 -45.183201 468.154999)(-179.389999 -41.049000 545.104980)(-181.834991 -45.183201 468.154999)(-181.891998 -45.439800 466.360992)(-179.389999 -41.049000 545.104980)(-179.389999 -41.049000 545.104980)(-181.679993 -42.776699 473.098022)(-181.766998 -44.380001 470.308990)(-181.679993 -42.776699 473.098022)(-179.389999 -41.049000 545.104980)(-181.677994 -42.749001 473.145996)(-181.891998 -45.439800 466.360992)(-181.914001 -45.526798 465.667999)(-179.389999 -41.049000 545.104980)(-181.914001 -45.526798 465.667999)(-182.000000 -45.799999 462.970001)(-179.389999 -41.049000 545.104980)(-179.389999 -41.049000 545.104980)(-182.000000 -45.799999 462.970001)(-179.389999 -63.845001 545.104980)(-181.766998 -44.380001 470.308990)(-181.768005 -44.384598 470.296997)(-179.389999 -41.049000 545.104980)(41.973000 -92.264999 551.796997)(41.978001 -54.875000 553.933960)(-172.479004 -55.882000 550.620972)(-172.479004 -55.882000 550.620972)(-173.139999 -67.365997 549.745972)(41.973000 -92.264999 551.796997)(-11.504000 -88.339996 551.713013)(-173.139999 -67.365997 549.745972)(-65.251999 -87.443001 550.935974)(-173.139999 -67.365997 549.745972)(-11.504000 -88.339996 551.713013)(41.973000 -92.264999 551.796997)(-119.000000 -86.544998 550.161011)(-65.251999 -87.443001 550.935974)(-173.139999 -67.365997 549.745972)(-119.000000 -86.544998 550.161011)(-173.139999 -67.365997 549.745972)(-173.253006 -85.556999 548.661987)(-179.389999 88.257996 535.483032)(-179.389999 84.383003 542.888000)(-176.480988 93.792999 536.950012)(-179.389999 94.904999 463.443024)(-179.389999 84.383003 542.888000)(-179.389999 88.257996 535.483032)(-174.260010 101.861000 461.351013)(-179.389999 94.904999 463.443024)(-174.260010 101.861000 505.577972)(-179.389999 95.949005 526.393982)(-174.260010 101.861000 505.577972)(-179.389999 94.904999 463.443024)(-179.389999 94.904999 463.443024)(-179.389999 88.257996 535.483032)(-179.389999 95.949005 526.393982)(-174.260010 101.861000 505.577972)(-179.389999 95.949005 526.393982)(-174.260010 101.861000 527.593018)(-119.093002 93.363998 548.587952)(-119.135002 99.620003 544.377991)(-172.671005 101.859001 538.221985)(-119.093002 93.363998 548.587952)(-172.671005 101.859001 538.221985)(-173.260010 92.579002 546.385986)(-176.480988 93.792999 536.950012)(-173.260010 92.579002 546.385986)(-172.671005 101.859001 538.221985)(-176.480988 93.792999 536.950012)(-172.671005 101.859001 538.221985)(-179.389999 95.949005 526.393982)(-173.260010 92.579002 546.385986)(-173.253006 85.556999 548.661987)(-119.093002 93.363998 548.587952)(-173.260010 92.579002 546.385986)(-179.389999 84.383003 542.888000)(-173.253006 85.556999 548.661987)(-172.671005 101.859001 538.221985)(-174.260010 101.861000 527.593018)(-179.389999 95.949005 526.393982)(-173.253006 85.556999 548.661987)(-179.389999 84.383003 542.888000)(-179.389999 78.511002 545.104980)(-119.000000 86.544998 550.161011)(-119.093002 93.363998 548.587952)(-173.253006 85.556999 548.661987)(-119.000000 86.544998 550.161011)(-173.253006 85.556999 548.661987)(-173.139999 67.365997 549.745972)(-181.891998 45.439800 466.360992)(-181.834991 45.183201 468.154999)(-179.389999 41.049000 545.104980)(-181.834991 45.183201 468.154999)(-181.815994 44.977798 468.768005)(-179.389999 41.049000 545.104980)(-181.815994 44.977798 468.768005)(-181.768005 44.384598 470.296997)(-179.389999 41.049000 545.104980)(-181.914001 45.526798 465.667999)(-181.891998 45.439800 466.360992)(-179.389999 41.049000 545.104980)(-182.000000 45.799999 462.970001)(-181.914001 45.526798 465.667999)(-179.389999 41.049000 545.104980)(-179.389999 63.845001 545.104980)(-182.000000 45.799999 462.970001)(-179.389999 41.049000 545.104980)(-181.766998 44.380001 470.308990)(-181.679993 42.776699 473.098022)(-179.389999 41.049000 545.104980)(-181.679993 42.776699 473.098022)(-181.677994 42.749001 473.145996)(-179.389999 41.049000 545.104980)(-65.347000 94.255997 549.362000)(-119.093002 93.363998 548.587952)(-119.000000 86.544998 550.161011)(-11.504000 88.339996 551.713013)(-65.251999 87.443001 550.935974)(-173.139999 67.365997 549.745972)(41.973000 92.264999 551.796997)(-11.504000 88.339996 551.713013)(-173.139999 67.365997 549.745972)(-173.139999 67.365997 549.745972)(-172.479004 55.882000 550.620972)(41.973000 92.264999 551.796997)(-172.479004 55.882000 550.620972)(-173.139999 67.365997 549.745972)(-179.389999 63.845001 545.104980)(41.978001 54.875000 553.933960)(41.973000 92.264999 551.796997)(-172.479004 55.882000 550.620972)(-65.250504 27.941000 552.277954)(41.978001 54.875000 553.933960)(-172.479004 55.882000 550.620972)(-65.128494 0.000000 552.278992)(41.978001 54.875000 553.933960)(-65.250504 27.941000 552.277954)(41.978001 0.000000 553.933960)(41.978001 54.875000 553.933960)(-65.128494 0.000000 552.278992)(41.978001 -54.875000 553.933960)(41.978001 0.000000 553.933960)(-65.128494 0.000000 552.278992)(41.978001 -54.875000 553.933960)(-65.128494 0.000000 552.278992)(-65.250504 -27.941000 552.277954)(-65.128494 0.000000 552.278992)(-172.479004 0.000000 550.620972)(-65.250504 -27.941000 552.277954)(-65.250504 -27.941000 552.277954)(-172.479004 0.000000 550.620972)(-172.479004 -55.882000 550.620972)(-119.115997 103.874001 538.150024)(-174.260010 101.861000 527.593018)(-172.671005 101.859001 538.221985)(-179.389999 63.845001 545.104980)(-173.139999 67.365997 549.745972)(-179.389999 78.511002 545.104980)(-172.671005 101.859001 538.221985)(-119.135002 99.620003 544.377991)(-119.115997 103.874001 538.150024)(-181.542999 37.382202 477.507996)(-181.539993 37.250000 477.588013)(-180.705002 26.774300 504.037964)(-181.600998 40.553997 475.598999)(-181.542999 37.382202 477.507996)(-180.705002 26.774300 504.037964)(-181.516998 33.751099 478.378998)(-180.705002 26.774300 504.037964)(-181.539993 37.250000 477.588013)(-181.604004 40.615601 475.529999)(-181.600998 40.553997 475.598999)(-179.389999 41.049000 545.104980)(-181.768005 -44.384598 470.296997)(-181.815994 -44.977798 468.768005)(-179.389999 -41.049000 545.104980)(-181.677994 -42.749001 473.145996)(-179.389999 -41.049000 545.104980)(-181.604004 -40.615601 475.529999)(-173.139999 67.365997 549.745972)(-173.253006 85.556999 548.661987)(-179.389999 78.511002 545.104980)(-172.671005 -101.859001 538.221985)(-179.389999 -95.949005 526.393982)(-174.260010 -101.861000 527.593018)(-181.527008 -13.635000 478.445007)(-181.522003 -21.259001 478.445007)(-180.705002 -26.774300 504.037964)(-181.522003 -21.259001 478.445007)(-181.522003 -21.547600 478.445007)(-180.705002 -26.774300 504.037964)(-181.527008 -12.981000 478.445007)(-181.527008 -13.635000 478.445007)(-180.705002 -26.774300 504.037964)(-181.520004 25.397999 478.445007)(-181.522003 21.547600 478.445007)(-180.705002 26.774300 504.037964)(-181.520004 25.923698 478.442993)(-181.520004 25.397999 478.445007)(-180.705002 26.774300 504.037964)(-181.516006 33.567997 478.419983)(-181.520004 25.923698 478.442993)(-180.705002 26.774300 504.037964)(-181.529999 1.361440 478.445007)(-181.529999 -1.361440 478.445007)(-179.389999 -0.441013 545.104980)(-180.705002 26.774300 504.037964)(-181.529999 7.748500 478.445007)(-179.389999 41.049000 545.104980)(-181.529999 7.748500 478.445007)(-179.389999 0.441013 545.104980)(-179.389999 41.049000 545.104980)(-181.527008 12.981000 478.445007)(-181.529999 7.748500 478.445007)(-180.705002 26.774300 504.037964)(-181.527008 13.635000 478.445007)(-181.527008 12.981000 478.445007)(-180.705002 26.774300 504.037964)(-179.389999 41.049000 545.104980)(-179.389999 0.441013 545.104980)(-172.479004 55.882000 550.620972)(-180.705002 -26.774300 504.037964)(-181.539993 -37.250000 477.588013)(-181.542999 -37.382202 477.507996)(-181.516998 -33.751099 478.378998)(-181.539993 -37.250000 477.588013)(-180.705002 -26.774300 504.037964)(-181.516998 -33.751099 478.378998)(-180.705002 -26.774300 504.037964)(-181.516006 -33.567997 478.419983)(-181.520004 -25.923698 478.442993)(-181.516006 -33.567997 478.419983)(-180.705002 -26.774300 504.037964)(-181.520004 -25.397999 478.445007)(-181.520004 -25.923698 478.442993)(-180.705002 -26.774300 504.037964)(-179.389999 95.949005 526.393982)(-179.389999 88.257996 535.483032)(-176.480988 93.792999 536.950012)(41.978001 -54.875000 553.933960)(-65.250504 -27.941000 552.277954)(-172.479004 -55.882000 550.620972)(-181.529999 -7.748500 478.445007)(-181.527008 -12.981000 478.445007)(-180.705002 -26.774300 504.037964)(-181.600998 -40.553997 475.598999)(-179.389999 -41.049000 545.104980)(-180.705002 -26.774300 504.037964)(-181.529999 -7.748500 478.445007)(-180.705002 -26.774300 504.037964)(-179.389999 -41.049000 545.104980)(-181.529999 -7.748500 478.445007)(-179.389999 -41.049000 545.104980)(-179.389999 -0.441013 545.104980)(-172.479004 -55.882000 550.620972)(-179.389999 -0.441013 545.104980)(-179.389999 -41.049000 545.104980)(-172.479004 0.000000 550.620972)(-65.250504 27.941000 552.277954)(-172.479004 55.882000 550.620972)(-119.000000 -86.544998 550.161011)(-65.347000 -94.255997 549.362000)(-65.251999 -87.443001 550.935974)(-173.139999 67.365997 549.745972)(-65.251999 87.443001 550.935974)(-119.000000 86.544998 550.161011)(-179.389999 -95.949005 526.393982)(-179.389999 -94.904999 463.443024)(-174.260010 -101.861000 505.577972)(-176.480988 93.792999 536.950012)(-179.389999 84.383003 542.888000)(-173.260010 92.579002 546.385986)(-181.522003 21.259001 478.445007)(-181.527008 13.635000 478.445007)(-180.705002 26.774300 504.037964)(-179.389999 -78.511002 545.104980)(-173.253006 -85.556999 548.661987)(-173.139999 -67.365997 549.745972)(-179.389999 -78.511002 545.104980)(-173.139999 -67.365997 549.745972)(-179.389999 -63.845001 545.104980)(-181.529999 -7.748500 478.445007)(-179.389999 -0.441013 545.104980)(-181.529999 -1.361440 478.445007)(-181.677994 42.749001 473.145996)(-181.604004 40.615601 475.529999)(-179.389999 41.049000 545.104980)(-181.522003 -21.547600 478.445007)(-181.520004 -25.397999 478.445007)(-180.705002 -26.774300 504.037964)(-181.768005 44.384598 470.296997)(-181.766998 44.380001 470.308990)(-179.389999 41.049000 545.104980)(-181.542999 -37.382202 477.507996)(-181.600998 -40.553997 475.598999)(-180.705002 -26.774300 504.037964)(-174.260010 -101.861000 505.577972)(-179.389999 -94.904999 463.443024)(-174.260010 -101.861000 461.351013)(-65.128494 0.000000 552.278992)(-65.250504 27.941000 552.277954)(-172.479004 0.000000 550.620972)(-119.093002 -93.363998 548.587952)(-173.260010 -92.579002 546.385986)(-172.671005 -101.859001 538.221985)(-179.389999 41.049000 545.104980)(-172.479004 55.882000 550.620972)(-179.389999 63.845001 545.104980)(-65.389000 -100.506996 545.154968)(-65.347000 -94.255997 549.362000)(-119.093002 -93.363998 548.587952)(-119.093002 -93.363998 548.587952)(-119.000000 -86.544998 550.161011)(-173.253006 -85.556999 548.661987)(-179.389999 -63.845001 545.104980)(-172.479004 -55.882000 550.620972)(-179.389999 -41.049000 545.104980)(-181.522003 21.547600 478.445007)(-181.522003 21.259001 478.445007)(-180.705002 26.774300 504.037964)(-181.600998 -40.553997 475.598999)(-181.604004 -40.615601 475.529999)(-179.389999 -41.049000 545.104980)(-181.529999 7.748500 478.445007)(-181.529999 1.361440 478.445007)(-179.389999 0.441013 545.104980)(-172.479004 -55.882000 550.620972)(-172.479004 0.000000 550.620972)(-179.389999 -0.441013 545.104980)(-181.600998 40.553997 475.598999)(-180.705002 26.774300 504.037964)(-179.389999 41.049000 545.104980)(-179.389999 0.441013 545.104980)(-172.479004 0.000000 550.620972)(-172.479004 55.882000 550.620972)(-174.260010 -101.861000 505.577972)(-174.260010 -101.861000 461.351013)(-141.460007 -102.950996 488.976990)(-173.139999 -67.365997 549.745972)(-172.479004 -55.882000 550.620972)(-179.389999 -63.845001 545.104980)(-181.516006 33.567997 478.419983)(-180.705002 26.774300 504.037964)(-181.516998 33.751099 478.378998)(-65.251999 87.443001 550.935974)(-65.347000 94.255997 549.362000)(-119.000000 86.544998 550.161011)(-176.480988 -93.792999 536.950012)(-172.671005 -101.859001 538.221985)(-173.260010 -92.579002 546.385986)(-65.347000 -94.255997 549.362000)(-119.000000 -86.544998 550.161011)(-119.093002 -93.363998 548.587952)(79.360596 42.931400 470.023010)(79.353493 43.105000 470.230988)(80.232002 43.105000 470.230988)(79.360596 42.931400 470.023010)(80.232002 43.105000 470.230988)(79.844803 42.118500 469.049988)(77.800995 75.124001 452.000000)(79.353493 43.105000 470.230988)(79.360596 42.931400 470.023010)(77.800995 75.124001 452.000000)(79.360596 42.931400 470.023010)(79.435104 41.132000 467.869995)(79.353493 43.105000 470.230988)(79.774796 43.627003 471.354004)(80.232002 43.105000 470.230988)(79.317596 44.059700 472.285004)(79.774796 43.627003 471.354004)(79.353493 43.105000 470.230988)(79.317596 44.059700 472.285004)(80.167000 44.149002 472.476990)(79.774796 43.627003 471.354004)(80.167000 44.149002 472.476990)(80.232002 43.105000 470.230988)(79.774796 43.627003 471.354004)(79.317596 44.059700 472.285004)(79.314301 44.149002 472.476990)(80.167000 44.149002 472.476990)(80.111000 45.054996 474.428009)(80.167000 44.149002 472.476990)(79.725105 44.601997 473.452972)(79.283104 44.979599 474.265991)(80.111000 45.054996 474.428009)(79.725105 44.601997 473.452972)(79.314301 44.149002 472.476990)(79.725105 44.601997 473.452972)(80.167000 44.149002 472.476990)(77.800995 75.124001 452.000000)(79.435104 41.132000 467.869995)(79.438904 41.043503 467.806000)(80.329002 41.132000 467.869995)(79.884003 40.884499 467.690002)(79.438904 41.043503 467.806000)(79.435104 41.132000 467.869995)(79.438904 41.043503 467.806000)(80.329002 41.132000 467.869995)(79.435104 41.132000 467.869995)(79.844803 42.118500 469.049988)(80.329002 41.132000 467.869995)(80.329002 41.132000 467.869995)(79.906502 40.637001 467.510986)(79.884003 40.884499 467.690002)(80.140205 40.637001 467.510986)(79.906502 40.637001 467.510986)(80.329002 41.132000 467.869995)(79.928894 39.762798 466.877014)(79.963402 39.383499 466.601990)(79.483803 40.006001 467.053009)(79.963402 39.383499 466.601990)(79.928894 39.762798 466.877014)(80.374001 40.141998 467.152008)(80.443001 38.625000 466.051025)(79.963402 39.383499 466.601990)(80.374001 40.141998 467.152008)(80.374001 40.141998 467.152008)(82.525002 40.196999 472.917999)(80.443001 38.625000 466.051025)(80.329002 41.132000 467.869995)(82.525002 40.196999 472.917999)(80.374001 40.141998 467.152008)(80.443001 38.625000 466.051025)(79.543594 38.625000 466.051025)(79.963402 39.383499 466.601990)(80.443001 38.625000 466.051025)(79.555305 38.361603 465.946991)(79.543594 38.625000 466.051025)(80.329002 41.132000 467.869995)(80.232002 43.105000 470.230988)(82.525002 40.196999 472.917999)(80.374001 40.141998 467.152008)(79.928894 39.762798 466.877014)(79.483803 40.006001 467.053009)(79.438904 41.043503 467.806000)(79.672699 40.592701 467.479004)(79.477898 40.141998 467.152008)(77.800995 75.124001 452.000000)(79.438904 41.043503 467.806000)(79.477898 40.141998 467.152008)(79.477898 40.141998 467.152008)(79.926003 40.265800 467.242004)(80.374001 40.141998 467.152008)(79.926003 40.389500 467.332001)(79.926003 40.265800 467.242004)(80.374001 40.141998 467.152008)(80.374001 40.141998 467.152008)(79.483803 40.006001 467.053009)(79.477898 40.141998 467.152008)(77.800995 75.124001 452.000000)(79.477898 40.141998 467.152008)(79.483803 40.006001 467.053009)(77.800995 75.124001 452.000000)(79.483803 40.006001 467.053009)(79.543594 38.625000 466.051025)(80.232002 43.105000 470.230988)(80.329002 41.132000 467.869995)(79.844803 42.118500 469.049988)(79.283104 44.979599 474.265991)(79.280304 45.054996 474.428009)(80.111000 45.054996 474.428009)(77.800995 75.124001 452.000000)(79.280304 45.054996 474.428009)(79.283104 44.979599 474.265991)(79.314301 44.149002 472.476990)(77.800995 75.124001 452.000000)(79.283104 44.979599 474.265991)(79.280304 45.054996 474.428009)(79.676201 45.388500 476.713989)(80.111000 45.054996 474.428009)(79.272102 45.492599 477.427979)(79.676201 45.388500 476.713989)(79.280304 45.054996 474.428009)(79.272102 45.492599 477.427979)(80.018997 45.722000 479.000000)(79.676201 45.388500 476.713989)(79.963402 39.383499 466.601990)(79.543594 38.625000 466.051025)(79.483803 40.006001 467.053009)(80.374001 40.141998 467.152008)(79.926003 40.389500 467.332001)(79.906502 40.637001 467.510986)(79.926003 40.389500 467.332001)(79.477898 40.141998 467.152008)(79.906502 40.637001 467.510986)(79.360596 42.931400 470.023010)(79.844803 42.118500 469.049988)(79.435104 41.132000 467.869995)(79.884003 40.884499 467.690002)(79.906502 40.637001 467.510986)(79.438904 41.043503 467.806000)(80.374001 40.141998 467.152008)(80.140205 40.637001 467.510986)(80.329002 41.132000 467.869995)(79.353493 43.105000 470.230988)(77.800995 75.124001 452.000000)(79.317596 44.059700 472.285004)(77.800995 75.124001 452.000000)(79.543594 38.625000 466.051025)(79.555305 38.361603 465.946991)(80.443001 38.625000 466.051025)(83.756996 33.969997 471.612000)(80.567001 35.695000 464.893982)(80.567001 35.695000 464.893982)(80.061195 37.160000 465.472992)(80.443001 38.625000 466.051025)(80.567001 35.695000 464.893982)(80.153603 34.827000 464.783020)(79.674301 35.695000 464.893982)(80.153603 34.827000 464.783020)(79.746597 34.111897 464.691010)(79.674301 35.695000 464.893982)(80.567001 35.695000 464.893982)(79.674301 35.695000 464.893982)(80.061195 37.160000 465.472992)(80.633003 33.959000 464.670990)(80.153603 34.827000 464.783020)(80.567001 35.695000 464.893982)(77.800995 75.124001 452.000000)(79.674301 35.695000 464.893982)(79.746597 34.111897 464.691010)(77.800995 75.124001 452.000000)(79.555305 38.361603 465.946991)(79.674301 35.695000 464.893982)(79.555305 38.361603 465.946991)(80.061195 37.160000 465.472992)(79.674301 35.695000 464.893982)(80.633003 33.959000 464.670990)(79.746597 34.111897 464.691010)(80.153603 34.827000 464.783020)(80.247299 32.951000 464.543030)(79.809601 32.731998 464.515015)(80.219299 33.286999 464.584991)(80.247299 32.951000 464.543030)(80.684998 32.614998 464.500000)(79.809601 32.731998 464.515015)(80.219299 33.286999 464.584991)(79.809601 32.731998 464.515015)(79.753601 33.959000 464.670990)(77.800995 75.124001 452.000000)(79.753601 33.959000 464.670990)(79.809601 32.731998 464.515015)(77.800995 75.124001 452.000000)(79.809601 32.731998 464.515015)(79.815002 32.614998 464.500000)(80.684998 32.614998 464.500000)(79.815002 32.614998 464.500000)(79.809601 32.731998 464.515015)(80.193306 33.622997 464.628021)(80.219299 33.286999 464.584991)(79.753601 33.959000 464.670990)(79.753601 33.959000 464.670990)(80.193306 33.790997 464.649994)(80.193306 33.622997 464.628021)(80.193306 33.790997 464.649994)(80.193306 33.622997 464.628021)(80.633003 33.959000 464.670990)(80.633003 33.959000 464.670990)(80.193306 33.790997 464.649994)(79.753601 33.959000 464.670990)(80.633003 33.959000 464.670990)(79.753601 33.959000 464.670990)(79.746597 34.111897 464.691010)(80.567001 35.695000 464.893982)(83.756996 33.969997 471.612000)(80.633003 33.959000 464.670990)(79.477898 40.141998 467.152008)(79.926003 40.389500 467.332001)(79.926003 40.265800 467.242004)(80.018997 45.722000 479.000000)(80.111000 45.054996 474.428009)(79.676201 45.388500 476.713989)(80.684998 32.614998 464.500000)(80.247299 32.951000 464.543030)(80.219299 33.286999 464.584991)(80.452103 33.286999 464.584991)(80.219299 33.286999 464.584991)(80.633003 33.959000 464.670990)(80.452103 33.286999 464.584991)(80.684998 32.614998 464.500000)(80.219299 33.286999 464.584991)(80.684998 32.614998 464.500000)(80.452103 33.286999 464.584991)(80.633003 33.959000 464.670990)(79.906502 40.637001 467.510986)(79.477898 40.141998 467.152008)(79.672699 40.592701 467.479004)(80.443001 38.625000 466.051025)(80.061195 37.160000 465.472992)(79.555305 38.361603 465.946991)(80.633003 33.959000 464.670990)(80.219299 33.286999 464.584991)(80.193306 33.622997 464.628021)(77.800995 75.124001 452.000000)(79.746597 34.111897 464.691010)(79.753601 33.959000 464.670990)(79.317596 44.059700 472.285004)(77.800995 75.124001 452.000000)(79.314301 44.149002 472.476990)(80.167000 44.149002 472.476990)(82.525002 40.196999 472.917999)(80.232002 43.105000 470.230988)(69.753494 -36.353001 373.369995)(67.601006 -72.706001 376.436005)(67.601196 0.000000 361.701019)(72.701996 -62.891998 384.640015)(69.753494 -36.353001 373.369995)(67.601196 0.000000 361.701019)(69.753494 -36.353001 373.369995)(72.701996 -62.891998 384.640015)(67.601006 -72.706001 376.436005)(67.601006 -72.706001 376.436005)(67.601006 -63.148998 371.933990)(67.601196 0.000000 361.701019)(72.701996 -82.625000 415.539001)(67.601006 -72.706001 376.436005)(72.701996 -62.891998 384.640015)(72.701996 -82.625000 415.539001)(67.601006 -77.644997 379.588989)(67.601006 -72.706001 376.436005)(67.601006 -63.148998 371.933990)(67.601006 -72.706001 376.436005)(59.000999 -63.197002 371.791016)(64.200996 18.559999 362.567017)(69.044502 0.000000 338.789001)(69.044907 0.000000 338.782990)(64.200996 18.559999 362.567017)(65.674995 11.033999 361.970978)(69.044502 0.000000 338.789001)(65.674995 11.033999 361.970978)(68.721397 0.000000 341.713013)(69.044502 0.000000 338.789001)(65.674995 11.033999 361.970978)(66.512001 0.034005 361.682007)(68.721397 0.000000 341.713013)(66.512001 0.034005 361.682007)(66.512001 -0.034005 361.682007)(68.721397 0.000000 341.713013)(66.512001 0.034005 361.682007)(65.674995 11.033999 361.970978)(67.601006 24.057001 363.636993)(67.461494 0.000000 361.697998)(66.512001 0.034005 361.682007)(66.512001 -0.034005 361.682007)(65.674995 -11.033999 361.970978)(68.721397 0.000000 341.713013)(66.512001 -0.034005 361.682007)(67.461494 0.000000 361.697998)(66.512001 0.034005 361.682007)(67.601006 24.057001 363.636993)(67.601196 0.000000 361.701019)(67.461494 0.000000 361.697998)(67.601006 24.057001 363.636993)(67.601196 0.000000 361.701019)(67.601006 -24.057001 363.636993)(67.461494 0.000000 361.697998)(67.601006 -24.057001 363.636993)(65.674995 -11.033999 361.970978)(66.512001 -0.034005 361.682007)(67.601006 -24.057001 363.636993)(64.200996 -18.559999 362.567017)(65.674995 -11.033999 361.970978)(67.461494 0.000000 361.697998)(67.601006 -24.057001 363.636993)(66.512001 -0.034005 361.682007)(67.601006 -24.057001 363.636993)(63.235001 -22.982000 362.966003)(64.200996 -18.559999 362.567017)(60.224998 22.299999 260.614014)(60.178898 22.282900 262.020996)(60.324402 21.720699 262.023010)(60.224998 22.299999 260.614014)(60.324402 21.720699 262.023010)(61.828899 16.003599 261.346008)(60.324402 21.720699 262.023010)(61.755299 16.190599 262.048004)(61.828899 16.003599 261.346008)(61.828899 16.003599 261.346008)(61.755299 16.190599 262.048004)(62.091103 14.892700 262.053986)(62.254898 14.259600 262.057007)(62.091103 14.892700 262.053986)(67.703003 33.854000 262.151978)(65.601997 22.568800 262.114990)(62.254898 14.259600 262.057007)(67.703003 33.854000 262.151978)(63.024902 11.283500 262.070007)(62.254898 14.259600 262.057007)(65.601997 22.568800 262.114990)(68.948997 28.271000 262.174011)(63.024902 11.283500 262.070007)(65.601997 22.568800 262.114990)(61.828899 16.003599 261.346008)(62.091103 14.892700 262.053986)(62.254898 14.259600 262.057007)(61.828899 16.003599 261.346008)(62.254898 14.259600 262.057007)(63.482002 9.720000 260.614014)(61.755299 16.190599 262.048004)(60.324402 21.720699 262.023010)(63.761799 30.413801 262.083008)(61.755299 16.190599 262.048004)(63.761799 30.413801 262.083008)(67.703003 33.854000 262.151978)(45.859001 90.318001 382.876984)(59.000999 91.572998 395.704010)(45.693001 89.557999 376.733002)(45.693001 89.557999 376.733002)(59.000999 91.572998 395.704010)(59.000999 89.418999 377.466003)(63.235001 -22.982000 362.966003)(67.601006 -63.148998 371.933990)(61.535999 -28.941999 363.698975)(66.028999 -22.513000 339.349976)(63.235001 -22.982000 362.966003)(61.535999 -28.941999 363.698975)(67.601006 -24.057001 363.636993)(67.601006 -63.148998 371.933990)(63.235001 -22.982000 362.966003)(66.028999 -22.513000 339.349976)(64.200996 -18.559999 362.567017)(63.235001 -22.982000 362.966003)(52.604298 52.723099 261.888000)(48.129997 68.846001 261.809998)(59.000000 68.695000 262.000000)(59.000000 68.695000 262.000000)(52.407299 36.600101 261.884979)(52.604298 52.723099 261.888000)(53.674301 34.961998 261.907013)(52.407299 36.600101 261.884979)(59.000000 68.695000 262.000000)(52.407299 36.600101 261.884979)(53.674301 34.961998 261.907013)(54.501999 33.966000 260.614014)(54.501999 33.966000 260.614014)(53.674301 34.961998 261.907013)(54.463303 33.941898 261.920990)(79.884003 -40.884499 467.690002)(79.438904 -41.043503 467.806000)(79.906502 -40.637001 467.510986)(79.906502 -40.637001 467.510986)(79.438904 -41.043503 467.806000)(79.672699 -40.592701 467.479004)(42.746998 87.457001 360.680023)(43.809998 88.031998 364.948975)(59.000999 89.418999 377.466003)(43.809998 88.031998 364.948975)(44.958000 88.740997 370.332001)(59.000999 89.418999 377.466003)(44.958000 88.740997 370.332001)(45.693001 89.557999 376.733002)(59.000999 89.418999 377.466003)(67.601006 105.671005 446.901001)(72.701996 82.625000 415.539001)(67.601006 104.222000 440.570007)(42.178001 105.959000 446.110992)(67.601006 105.671005 446.901001)(67.601006 104.222000 440.570007)(67.601006 104.222000 440.570007)(42.858997 103.848999 437.105011)(42.178001 105.959000 446.110992)(59.000999 72.435997 375.942993)(59.000000 68.695000 262.000000)(59.000999 89.418999 377.466003)(59.000999 89.418999 377.466003)(59.000999 85.778000 387.139008)(59.000999 72.435997 375.942993)(59.000999 91.572998 395.704010)(59.000999 85.778000 387.139008)(59.000999 89.418999 377.466003)(59.000999 52.636002 298.752014)(59.000000 68.695000 262.000000)(59.000999 72.435997 375.942993)(79.545601 0.879971 493.500000)(79.918396 5.431000 493.500000)(79.476807 10.862000 493.500000)(79.545601 0.879971 493.500000)(80.357498 -0.000000 493.500000)(79.918396 5.431000 493.500000)(77.800400 0.000000 530.000000)(79.545601 0.879971 493.500000)(79.476807 10.862000 493.500000)(81.124001 16.306999 464.500000)(80.550095 16.699800 464.500000)(80.539803 16.924101 464.500000)(80.564003 16.306999 464.500000)(80.550095 16.699800 464.500000)(81.124001 16.306999 464.500000)(81.124001 16.306999 464.500000)(80.539803 16.924101 464.500000)(80.595001 21.743000 464.500000)(80.539803 16.924101 464.500000)(80.550095 16.699800 464.500000)(81.290001 0.000000 456.649017)(81.290001 0.000000 456.649017)(80.550095 16.699800 464.500000)(81.291397 0.000000 457.002014)(80.914497 8.153500 464.500000)(80.564003 16.306999 464.500000)(81.124001 16.306999 464.500000)(45.805000 90.896004 387.692993)(45.589001 92.432999 396.824982)(59.000999 91.572998 395.704010)(-63.481003 -9.720000 260.614014)(-63.780800 -3.229520 261.456024)(-63.973801 0.000000 260.614014)(-63.481003 -9.720000 260.614014)(-63.458199 -9.023340 262.285004)(-63.780800 -3.229520 261.456024)(-94.406998 68.487999 262.893005)(-76.641594 72.824501 282.835999)(-58.876102 73.665703 286.773010)(-94.406998 68.487999 262.893005)(-58.876102 73.665703 286.773010)(-58.770599 72.124001 278.677002)(80.029007 32.595001 493.500000)(79.655701 34.596500 493.169983)(79.326797 32.595001 493.500000)(79.329399 32.212902 493.500000)(80.029007 32.595001 493.500000)(79.326797 32.595001 493.500000)(41.335003 -70.367004 260.226990)(-10.356000 -76.087494 295.000000)(-9.366880 -70.952202 267.973999)(-10.356000 -76.087494 295.000000)(-9.491710 -77.874603 295.000000)(-9.366880 -70.952202 267.973999)(81.290001 0.000000 456.649017)(80.046600 27.599699 464.500000)(80.066101 27.179001 464.500000)(79.815002 32.614998 464.500000)(80.046600 27.599699 464.500000)(81.290001 0.000000 456.649017)(80.066101 27.179001 464.500000)(80.046600 27.599699 464.500000)(80.832001 27.179001 464.500000)(80.046600 27.599699 464.500000)(79.815002 32.614998 464.500000)(80.323502 29.897001 464.500000)(80.832001 27.179001 464.500000)(80.046600 27.599699 464.500000)(80.323502 29.897001 464.500000)(80.595001 21.743000 464.500000)(80.066101 27.179001 464.500000)(80.832001 27.179001 464.500000)(80.684998 32.614998 464.500000)(80.832001 27.179001 464.500000)(80.323502 29.897001 464.500000)(-124.982994 -72.045998 355.863983)(-135.472000 -47.260002 354.721985)(-130.461014 -52.723999 333.459991)(-130.461014 -52.723999 333.459991)(-124.130005 -67.465996 333.440979)(-124.982994 -72.045998 355.863983)(-139.966003 0.441003 333.462006)(-139.966003 -0.441003 333.462006)(-140.720993 -0.441000 344.000000)(-140.720993 -0.441000 344.000000)(-139.966003 -0.441003 333.462006)(-141.477005 -23.040001 354.537018)(-141.477005 -23.040001 354.537018)(-141.477005 0.000000 354.537018)(-140.720993 -0.441000 344.000000)(-137.444000 -26.815001 333.463989)(-141.477005 -23.040001 354.537018)(-139.966003 -0.441003 333.462006)(-130.461014 -52.723999 333.459991)(-137.444000 -26.815001 333.463989)(-128.570999 -47.430000 310.032990)(-137.444000 -26.815001 333.463989)(-133.781998 -23.965000 310.036011)(-128.570999 -47.430000 310.032990)(-130.815002 0.441001 286.712006)(-135.668991 0.441002 310.035004)(-129.649994 21.038000 286.709991)(-135.668991 0.441002 310.035004)(-130.815002 0.441001 286.712006)(-135.668991 -0.441002 310.035004)(-130.815002 -0.441001 286.712006)(-135.668991 -0.441002 310.035004)(-130.815002 0.441001 286.712006)(-130.815002 -0.441001 286.712006)(-129.649994 -21.038000 286.709991)(-135.668991 -0.441002 310.035004)(-125.403999 -0.441000 263.502014)(-129.649994 -21.038000 286.709991)(-130.815002 -0.441001 286.712006)(-135.668991 -0.441002 310.035004)(-129.649994 -21.038000 286.709991)(-133.781998 -23.965000 310.036011)(-133.781998 -23.965000 310.036011)(-139.966003 -0.441003 333.462006)(-135.668991 -0.441002 310.035004)(-133.781998 -23.965000 310.036011)(-137.444000 -26.815001 333.463989)(-139.966003 -0.441003 333.462006)(-130.461014 -52.723999 333.459991)(-128.570999 -47.430000 310.032990)(-123.512001 -61.675999 310.009979)(-129.649994 21.038000 286.709991)(-125.403999 0.441000 263.502014)(-130.815002 0.441001 286.712006)(-94.406998 68.487999 262.893005)(-125.403999 0.441000 263.502014)(-124.935997 19.788000 263.491974)(-125.403999 0.441000 263.502014)(-129.649994 21.038000 286.709991)(-124.935997 19.788000 263.491974)(-124.935997 19.788000 263.491974)(-123.795998 36.459000 263.470001)(-94.406998 68.487999 262.893005)(-125.403999 -0.441000 263.502014)(-124.935997 -19.788000 263.491974)(-129.649994 -21.038000 286.709991)(-94.406998 -68.487999 262.893005)(-124.935997 -19.788000 263.491974)(-125.403999 -0.441000 263.502014)(-129.649994 -21.038000 286.709991)(-124.935997 -19.788000 263.491974)(-126.401009 -41.887001 286.700989)(-123.795998 -36.459000 263.470001)(-126.401009 -41.887001 286.700989)(-124.935997 -19.788000 263.491974)(-122.964005 -45.035999 263.453003)(-124.023994 -52.660000 286.687988)(-126.401009 -41.887001 286.700989)(-123.795998 -36.459000 263.470001)(-122.964005 -45.035999 263.453003)(-126.401009 -41.887001 286.700989)(-94.406998 -68.487999 262.893005)(-122.964005 -45.035999 263.453003)(-123.795998 -36.459000 263.470001)(-120.144005 -52.723003 263.397980)(-122.964005 -45.035999 263.453003)(-94.406998 -68.487999 262.893005)(-123.512001 -61.675999 310.009979)(-124.130005 -67.465996 333.440979)(-130.461014 -52.723999 333.459991)(-120.144005 -52.723003 263.397980)(-117.026001 -63.762001 286.584991)(-121.458000 -58.391003 286.653992)(-121.458000 -58.391003 286.653992)(-117.026001 -63.762001 286.584991)(-123.512001 -61.675999 310.009979)(-117.026001 -63.762001 286.584991)(-117.537003 -69.362000 309.940979)(-123.512001 -61.675999 310.009979)(-123.512001 -61.675999 310.009979)(-117.537003 -69.362000 309.940979)(-124.130005 -67.465996 333.440979)(-117.537003 -69.362000 309.940979)(-117.959000 -74.542999 333.388000)(-124.130005 -67.465996 333.440979)(-118.275002 -79.184006 356.402008)(-124.130005 -67.465996 333.440979)(-117.959000 -74.542999 333.388000)(-118.275002 -79.184006 356.402008)(-124.982994 -72.045998 355.863983)(-124.130005 -67.465996 333.440979)(-94.406998 -68.487999 262.893005)(-123.795998 -36.459000 263.470001)(-124.935997 -19.788000 263.491974)(-122.964005 -45.035999 263.453003)(-120.144005 -52.723003 263.397980)(-121.458000 -58.391003 286.653992)(-121.458000 -58.391003 286.653992)(-124.023994 -52.660000 286.687988)(-122.964005 -45.035999 263.453003)(-135.472000 -47.260002 354.721985)(-140.007004 -29.219000 354.571991)(-137.444000 -26.815001 333.463989)(-140.007004 -29.219000 354.571991)(-141.477005 -23.040001 354.537018)(-137.444000 -26.815001 333.463989)(-130.815002 0.441001 286.712006)(-125.403999 0.441000 263.502014)(-130.815002 -0.441001 286.712006)(-123.795998 36.459000 263.470001)(-124.935997 19.788000 263.491974)(-126.401009 41.887001 286.700989)(-135.668991 0.441002 310.035004)(-139.966003 -0.441003 333.462006)(-139.966003 0.441003 333.462006)(-139.966003 0.441003 333.462006)(-141.477005 23.040001 354.537018)(-137.444000 26.815001 333.463989)(-141.477005 23.040001 354.537018)(-139.966003 0.441003 333.462006)(-140.720993 0.441000 344.000000)(-137.444000 26.815001 333.463989)(-133.781998 23.965000 310.036011)(-139.966003 0.441003 333.462006)(-137.444000 26.815001 333.463989)(-130.461014 52.723999 333.459991)(-128.570999 47.430000 310.032990)(-128.570999 47.430000 310.032990)(-133.781998 23.965000 310.036011)(-137.444000 26.815001 333.463989)(-128.570999 47.430000 310.032990)(-124.023994 52.660000 286.687988)(-126.401009 41.887001 286.700989)(-126.401009 41.887001 286.700989)(-133.781998 23.965000 310.036011)(-128.570999 47.430000 310.032990)(-126.401009 41.887001 286.700989)(-129.649994 21.038000 286.709991)(-133.781998 23.965000 310.036011)(-135.668991 0.441002 310.035004)(-139.966003 0.441003 333.462006)(-133.781998 23.965000 310.036011)(-125.403999 -0.441000 263.502014)(-130.815002 -0.441001 286.712006)(-125.403999 0.441000 263.502014)(-133.781998 23.965000 310.036011)(-129.649994 21.038000 286.709991)(-135.668991 0.441002 310.035004)(79.922997 -43.680000 486.819000)(79.737900 -43.936497 486.182983)(79.934998 -44.193001 485.545990)(80.756996 -44.300999 482.371979)(79.922997 -43.680000 486.819000)(79.934998 -44.193001 485.545990)(79.911003 -42.146000 489.063995)(79.922997 -43.680000 486.819000)(80.756996 -44.300999 482.371979)(80.756996 -44.300999 482.371979)(82.287994 -40.196999 485.184998)(79.911003 -42.146000 489.063995)(67.601006 -72.706001 376.436005)(59.000999 -72.435997 375.942993)(59.000999 -63.197002 371.791016)(59.000999 -63.197002 371.791016)(59.000999 -72.435997 375.942993)(59.000999 -52.636002 298.752014)(-58.339001 -71.764000 267.755981)(-58.633900 -70.127800 268.194000)(-39.505299 -70.447899 268.075989)(-55.224003 -77.662994 266.174988)(-58.339001 -71.764000 267.755981)(-39.505299 -70.447899 268.075989)(-50.446999 -82.413002 264.902008)(-55.224003 -77.662994 266.174988)(-39.505299 -70.447899 268.075989)(-47.857002 -84.063004 264.459991)(-50.446999 -82.413002 264.902008)(-39.505299 -70.447899 268.075989)(-47.857002 -84.063004 264.459991)(-39.505299 -70.447899 268.075989)(-45.139999 -85.764999 264.003998)(-39.209000 -91.576004 262.446991)(-45.139999 -85.764999 264.003998)(-39.505299 -70.447899 268.075989)(41.335003 -70.367004 260.226990)(-39.505299 -70.447899 268.075989)(-58.633900 -70.127800 268.194000)(-58.633900 -70.127800 268.194000)(-58.339001 -71.764000 267.755981)(-58.753300 -71.872101 277.354004)(-94.357002 -73.585007 286.235016)(-76.641594 -72.824501 282.835999)(-61.307003 -77.163399 302.778992)(-94.357002 -73.585007 286.235016)(-61.307003 -77.163399 302.778992)(-61.307003 -77.601700 305.225006)(-77.832001 -76.204399 298.527985)(-94.357002 -73.585007 286.235016)(-61.307003 -77.601700 305.225006)(-77.832001 -76.204399 298.527985)(-61.307003 -77.601700 305.225006)(-61.307003 -78.823700 310.820007)(-94.341003 -75.278999 293.992004)(-94.357002 -73.585007 286.235016)(-77.832001 -76.204399 298.527985)(-58.876102 -73.665703 286.773010)(-58.770599 -72.124001 278.677002)(-58.339001 -79.063202 295.000000)(-58.876102 -73.665703 286.773010)(-58.339001 -79.063202 295.000000)(-58.944603 -75.462196 295.000000)(-59.974903 -75.463303 295.000000)(-58.876102 -73.665703 286.773010)(-58.944603 -75.462196 295.000000)(-60.119099 -75.463501 295.000000)(-58.876102 -73.665703 286.773010)(-59.974903 -75.463303 295.000000)(-61.307003 -75.464706 295.000000)(-58.876102 -73.665703 286.773010)(-60.119099 -75.463501 295.000000)(-76.641594 -72.824501 282.835999)(-58.876102 -73.665703 286.773010)(-61.307003 -75.464706 295.000000)(-94.406998 -68.487999 262.893005)(-58.770599 -72.124001 278.677002)(-58.876102 -73.665703 286.773010)(-94.357002 -73.585007 286.235016)(-94.406998 -68.487999 262.893005)(-76.641594 -72.824501 282.835999)(-58.753300 -71.872101 277.354004)(-58.339001 -71.764000 267.755981)(-58.770599 -72.124001 278.677002)(-94.406998 -68.487999 262.893005)(-58.633900 -70.127800 268.194000)(-58.753300 -71.872101 277.354004)(-94.406998 -68.487999 262.893005)(41.335003 -70.367004 260.226990)(-58.633900 -70.127800 268.194000)(79.534698 -43.808201 486.501007)(79.540703 -43.936497 486.182983)(79.922997 -43.680000 486.819000)(79.146400 -43.719898 486.720001)(79.534698 -43.808201 486.501007)(79.922997 -43.680000 486.819000)(79.720695 29.886501 493.500000)(80.029007 32.595001 493.500000)(79.329399 32.212902 493.500000)(79.720695 29.886501 493.500000)(80.112000 27.178001 493.500000)(80.029007 32.595001 493.500000)(79.372696 25.941099 493.500000)(80.112000 27.178001 493.500000)(79.364204 27.178001 493.500000)(79.364204 27.178001 493.500000)(80.112000 27.178001 493.500000)(79.720695 29.886501 493.500000)(79.866402 19.020000 493.500000)(80.112000 27.178001 493.500000)(79.372696 25.941099 493.500000)(79.866402 19.020000 493.500000)(80.360001 10.862000 493.500000)(80.112000 27.178001 493.500000)(79.476807 10.862000 493.500000)(80.360001 10.862000 493.500000)(79.866402 19.020000 493.500000)(79.364204 27.178001 493.500000)(78.471199 31.063999 511.557983)(79.372696 25.941099 493.500000)(79.329399 32.212902 493.500000)(78.471199 31.063999 511.557983)(79.364204 27.178001 493.500000)(83.608002 27.179001 486.575012)(80.112000 27.178001 493.500000)(80.360001 10.862000 493.500000)(79.476807 10.862000 493.500000)(79.372696 25.941099 493.500000)(78.471199 31.063999 511.557983)(78.471199 31.063999 511.557983)(79.329399 32.212902 493.500000)(79.326797 32.595001 493.500000)(78.471199 31.063999 511.557983)(79.326797 32.595001 493.500000)(79.329102 34.866096 493.126007)(78.471199 31.063999 511.557983)(79.329102 34.866096 493.126007)(77.800995 62.127998 521.060974)(66.028999 22.513000 339.349976)(69.044907 0.000000 338.782990)(71.083099 0.000000 313.239990)(71.083099 0.000000 313.239990)(69.044907 0.000000 338.782990)(66.028999 -22.513000 339.349976)(66.028999 -22.513000 339.349976)(69.044907 0.000000 338.782990)(64.200996 -18.559999 362.567017)(-124.023994 52.660000 286.687988)(-121.458000 58.391003 286.653992)(-122.964005 45.035999 263.453003)(-121.458000 58.391003 286.653992)(-124.023994 52.660000 286.687988)(-123.512001 61.675999 310.009979)(-121.458000 58.391003 286.653992)(-120.144005 52.723003 263.397980)(-122.964005 45.035999 263.453003)(83.160995 -40.196999 479.069000)(82.525002 -40.196999 472.917999)(83.756996 -33.969997 471.612000)(84.684998 -33.971001 479.098999)(83.160995 -40.196999 479.069000)(83.756996 -33.969997 471.612000)(84.889999 -27.179001 479.101013)(83.428001 -33.969997 486.536011)(84.684998 -33.971001 479.098999)(84.889999 -27.179001 479.101013)(84.684998 -33.971001 479.098999)(83.756996 -33.969997 471.612000)(83.160995 -40.196999 479.069000)(84.684998 -33.971001 479.098999)(83.428001 -33.969997 486.536011)(83.608002 -27.179001 486.575012)(80.029007 -32.595001 493.500000)(83.428001 -33.969997 486.536011)(80.029007 -32.595001 493.500000)(79.952003 -36.598000 492.841003)(83.428001 -33.969997 486.536011)(79.914001 -40.181999 490.934998)(82.287994 -40.196999 485.184998)(79.952003 -36.598000 492.841003)(79.952003 -36.598000 492.841003)(79.568901 -38.389999 491.888000)(79.914001 -40.181999 490.934998)(83.428001 -33.969997 486.536011)(79.952003 -36.598000 492.841003)(82.287994 -40.196999 485.184998)(79.914001 -40.181999 490.934998)(79.568901 -38.389999 491.888000)(79.185905 -40.181999 490.934998)(79.185905 -40.181999 490.934998)(79.568901 -38.389999 491.888000)(79.267700 -36.842300 492.710999)(79.185905 -40.181999 490.934998)(79.267700 -36.842300 492.710999)(78.432899 -56.746899 499.244019)(79.952003 -36.598000 492.841003)(79.329102 -34.866096 493.126007)(79.282295 -36.327900 492.884979)(79.952003 -36.598000 492.841003)(79.282295 -36.327900 492.884979)(79.273697 -36.598000 492.841003)(79.655701 -34.596500 493.169983)(79.329102 -34.866096 493.126007)(79.952003 -36.598000 492.841003)(79.952003 -36.598000 492.841003)(79.273697 -36.598000 492.841003)(79.267700 -36.842300 492.710999)(78.432899 -56.746899 499.244019)(79.267700 -36.842300 492.710999)(79.273697 -36.598000 492.841003)(79.273697 -36.598000 492.841003)(79.282295 -36.327900 492.884979)(77.800995 -62.127998 521.060974)(79.914001 -40.181999 490.934998)(79.185905 -40.181999 490.934998)(79.183601 -40.325401 490.798004)(79.914001 -40.181999 490.934998)(79.183601 -40.325401 490.798004)(79.534203 -41.164001 490.000000)(79.154495 -42.146000 489.063995)(79.534203 -41.164001 490.000000)(79.183601 -40.325401 490.798004)(79.544296 -44.064701 485.864014)(79.544296 -44.128899 485.704987)(79.153503 -44.193001 485.545990)(79.544296 -44.128899 485.704987)(79.153503 -44.193001 485.545990)(79.934998 -44.193001 485.545990)(79.153801 -42.262302 488.893982)(79.534393 -42.913002 487.942017)(79.911003 -42.146000 489.063995)(79.145798 -43.680000 486.819000)(79.534393 -42.913002 487.942017)(79.153801 -42.262302 488.893982)(79.145798 -43.680000 486.819000)(79.153801 -42.262302 488.893982)(78.432899 -56.746899 499.244019)(79.153801 -42.262302 488.893982)(79.154495 -42.146000 489.063995)(78.432899 -56.746899 499.244019)(79.154495 -42.146000 489.063995)(79.183601 -40.325401 490.798004)(78.432899 -56.746899 499.244019)(79.145798 -43.680000 486.819000)(79.922997 -43.680000 486.819000)(79.534393 -42.913002 487.942017)(79.922997 -43.680000 486.819000)(79.146400 -43.719898 486.720001)(79.145798 -43.680000 486.819000)(79.146400 -43.719898 486.720001)(79.145798 -43.680000 486.819000)(78.432899 -56.746899 499.244019)(79.154701 -44.272099 485.350006)(79.153503 -44.193001 485.545990)(78.432899 -56.746899 499.244019)(79.153503 -44.193001 485.545990)(79.146400 -43.719898 486.720001)(78.432899 -56.746899 499.244019)(79.153503 -44.193001 485.545990)(79.154701 -44.272099 485.350006)(79.934998 -44.193001 485.545990)(79.934998 -44.193001 485.545990)(79.544296 -44.064701 485.864014)(79.544296 -44.128899 485.704987)(79.911003 -42.146000 489.063995)(79.534203 -41.164001 490.000000)(79.154495 -42.146000 489.063995)(83.160995 -40.196999 479.069000)(83.428001 -33.969997 486.536011)(82.287994 -40.196999 485.184998)(83.160995 -40.196999 479.069000)(81.794701 -42.171600 482.127014)(80.756996 -44.300999 482.371979)(81.072006 -44.300999 479.023010)(83.160995 -40.196999 479.069000)(80.756996 -44.300999 482.371979)(83.160995 -40.196999 479.069000)(82.299202 -41.100201 482.127014)(81.794701 -42.171600 482.127014)(82.299202 -41.100201 482.127014)(83.160995 -40.196999 479.069000)(82.287994 -40.196999 485.184998)(79.911003 -42.146000 489.063995)(79.534393 -42.913002 487.942017)(79.922997 -43.680000 486.819000)(78.432899 -56.746899 499.244019)(79.273697 -36.598000 492.841003)(77.800995 -62.127998 521.060974)(79.183601 -40.325401 490.798004)(79.185905 -40.181999 490.934998)(78.432899 -56.746899 499.244019)(82.525002 -40.196999 472.917999)(83.160995 -40.196999 479.069000)(81.072006 -44.300999 479.023010)(81.072006 -44.300999 479.023010)(80.018997 -45.722000 479.000000)(82.525002 -40.196999 472.917999)(79.153503 -44.193001 485.545990)(79.544296 -44.064701 485.864014)(79.540703 -43.936497 486.182983)(80.029007 -32.595001 493.500000)(79.655701 -34.596500 493.169983)(79.952003 -36.598000 492.841003)(81.794701 -42.171600 482.127014)(82.299202 -41.100201 482.127014)(82.287994 -40.196999 485.184998)(83.756996 -33.969997 471.612000)(82.525002 -40.196999 472.917999)(80.443001 -38.625000 466.051025)(80.167000 -44.149002 472.476990)(82.525002 -40.196999 472.917999)(80.018997 -45.722000 479.000000)(67.601006 98.632996 417.792999)(67.601006 101.487000 429.165985)(72.701996 82.625000 415.539001)(67.601006 101.487000 429.165985)(67.601006 98.632996 417.792999)(42.858997 103.848999 437.105011)(79.314301 -44.149002 472.476990)(79.725105 -44.601997 473.452972)(79.283104 -44.979599 474.265991)(79.283104 -44.979599 474.265991)(77.800995 -75.124001 452.000000)(79.314301 -44.149002 472.476990)(34.283001 106.278000 258.507996)(35.320000 122.197998 284.265015)(34.767200 114.242004 272.513977)(34.283001 113.783005 286.520020)(34.283001 106.278000 258.507996)(34.767200 114.242004 272.513977)(67.601006 101.744003 523.383972)(41.909698 102.618004 522.785034)(41.912899 101.700996 524.294006)(41.912899 101.700996 524.294006)(41.916500 100.043999 525.991028)(67.601006 101.744003 523.383972)(41.898197 105.878998 517.421997)(41.909698 102.618004 522.785034)(67.601006 101.744003 523.383972)(41.916500 100.043999 525.991028)(67.601006 95.750999 529.524048)(67.601006 101.744003 523.383972)(41.897800 106.003998 517.218018)(41.898197 105.878998 517.421997)(67.601006 101.744003 523.383972)(32.603802 106.113998 274.630981)(34.283001 113.783005 286.520020)(31.111000 105.881996 288.637024)(-14.805000 144.939011 248.147995)(-22.179001 140.348007 249.378998)(-22.179001 147.852997 277.390991)(-22.179001 140.348007 249.378998)(-28.139999 141.634995 279.057007)(-22.179001 147.852997 277.390991)(-28.139999 141.634995 279.057007)(-22.179001 140.348007 249.378998)(-28.139999 134.128998 251.044983)(31.111000 98.375999 260.625000)(-28.139999 134.128998 251.044983)(-22.179001 140.348007 249.378998)(34.283001 106.278000 258.507996)(31.111000 98.375999 260.625000)(-22.179001 140.348007 249.378998)(34.283001 113.783005 286.520020)(31.111000 98.375999 260.625000)(34.283001 106.278000 258.507996)(31.111000 98.375999 260.625000)(26.004999 91.485001 262.470978)(-28.139999 134.128998 251.044983)(22.327799 96.009796 291.282013)(20.062700 94.173401 291.774994)(19.285002 86.037003 263.931000)(26.004999 91.485001 262.470978)(31.111000 98.375999 260.625000)(31.111000 105.881996 288.637024)(26.004999 91.485001 262.470978)(31.111000 105.881996 288.637024)(29.344400 103.497993 289.276001)(26.004999 91.485001 262.470978)(29.344400 103.497993 289.276001)(26.004999 98.990997 290.483002)(26.004999 98.990997 290.483002)(19.285002 86.037003 263.931000)(26.004999 91.485001 262.470978)(26.004999 98.990997 290.483002)(22.327799 96.009796 291.282013)(19.285002 86.037003 263.931000)(-14.805000 144.939011 248.147995)(34.283001 106.278000 258.507996)(-22.179001 140.348007 249.378998)(-9.366880 70.952202 267.973999)(-39.209000 91.576004 262.446991)(-35.427002 98.872002 260.492004)(-39.505299 70.447899 268.075989)(-39.209000 91.576004 262.446991)(-9.366880 70.952202 267.973999)(-39.505299 70.447899 268.075989)(-45.139999 85.764999 264.003998)(-39.209000 91.576004 262.446991)(-39.505299 70.447899 268.075989)(-47.857002 84.063004 264.459991)(-45.139999 85.764999 264.003998)(-47.857002 91.569000 292.472015)(-45.139999 85.764999 264.003998)(-47.857002 84.063004 264.459991)(-39.209000 91.576004 262.446991)(-45.139999 85.764999 264.003998)(-45.139999 93.271004 292.015991)(-50.446999 89.918999 292.914001)(-47.857002 91.569000 292.472015)(-47.857002 84.063004 264.459991)(-45.139999 93.271004 292.015991)(-39.209000 99.082001 290.459015)(-39.209000 91.576004 262.446991)(-39.505299 70.447899 268.075989)(-50.446999 82.413002 264.902008)(-47.857002 84.063004 264.459991)(-50.446999 89.918999 292.914001)(-47.857002 84.063004 264.459991)(-50.446999 82.413002 264.902008)(-3.418010 76.742004 266.421997)(-9.366880 70.952202 267.973999)(-35.427002 98.872002 260.492004)(-9.491710 77.874603 295.000000)(-9.366880 70.952202 267.973999)(-3.418010 76.742004 266.421997)(0.508551 86.214401 293.906982)(-9.491710 77.874603 295.000000)(-3.418010 76.742004 266.421997)(-3.418010 76.742004 266.421997)(4.082000 88.003998 293.427002)(0.508551 86.214401 293.906982)(-35.427002 98.872002 260.492004)(-39.209000 91.576004 262.446991)(-39.209000 99.082001 290.459015)(-32.311996 126.673996 253.042999)(-34.432999 125.957001 283.257996)(-32.311996 134.179993 281.053986)(-32.311996 134.179993 281.053986)(-28.139999 134.128998 251.044983)(-32.311996 126.673996 253.042999)(-34.432999 125.957001 283.257996)(-32.311996 126.673996 253.042999)(-34.432999 118.450996 255.246994)(-34.432999 118.450996 255.246994)(-32.311996 126.673996 253.042999)(19.285002 86.037003 263.931000)(-34.432999 118.450996 255.246994)(19.285002 86.037003 263.931000)(11.373000 82.374001 264.912018)(19.284901 93.542801 291.944000)(11.373000 82.374001 264.912018)(19.285002 86.037003 263.931000)(11.373000 82.374001 264.912018)(19.284901 93.542801 291.944000)(11.373000 89.879997 292.923981)(-34.387997 110.106995 257.481995)(-34.164997 114.445999 286.341980)(-34.387997 117.612999 285.492981)(-34.387997 110.106995 257.481995)(-34.164997 106.940002 258.329987)(-34.164997 114.445999 286.341980)(-34.164997 106.940002 258.329987)(-35.427002 106.377998 288.503998)(-34.164997 114.445999 286.341980)(-34.387997 117.612999 285.492981)(-34.432999 118.450996 255.246994)(-34.387997 110.106995 257.481995)(-34.432999 118.450996 255.246994)(-34.387997 117.612999 285.492981)(-34.432999 125.957001 283.257996)(4.082000 80.498001 265.415985)(-34.164997 106.940002 258.329987)(-34.387997 110.106995 257.481995)(-34.387997 110.106995 257.481995)(7.256990 81.315002 265.195984)(4.082000 80.498001 265.415985)(7.256990 88.820999 293.208008)(4.082000 80.498001 265.415985)(7.256990 81.315002 265.195984)(7.256990 88.820999 293.208008)(4.082000 88.003998 293.427002)(4.082000 80.498001 265.415985)(4.082000 80.498001 265.415985)(-3.418010 76.742004 266.421997)(-34.164997 106.940002 258.329987)(11.373000 89.879997 292.923981)(7.256990 81.315002 265.195984)(11.373000 82.374001 264.912018)(-34.164997 106.940002 258.329987)(-35.427002 98.872002 260.492004)(-35.427002 106.377998 288.503998)(-3.418010 76.742004 266.421997)(4.082000 80.498001 265.415985)(4.082000 88.003998 293.427002)(0.508551 86.214401 293.906982)(4.082000 88.003998 293.427002)(7.256990 88.820999 293.208008)(2.270990 148.207001 247.272995)(10.900001 146.677994 247.682007)(30.872000 130.949005 251.897003)(2.270990 155.713013 275.285004)(10.900001 146.677994 247.682007)(2.270990 148.207001 247.272995)(-6.481010 155.121002 275.442993)(2.270990 155.713013 275.285004)(2.270990 148.207001 247.272995)(-6.481010 147.615005 247.431000)(-6.481010 155.121002 275.442993)(2.270990 148.207001 247.272995)(-14.805000 152.445007 276.160004)(-6.481010 155.121002 275.442993)(-6.481010 147.615005 247.431000)(-6.481010 147.615005 247.431000)(35.320000 114.692001 256.252991)(-14.805000 144.939011 248.147995)(34.159000 123.092003 254.001999)(35.320000 114.692001 256.252991)(-6.481010 147.615005 247.431000)(35.320000 114.692001 256.252991)(34.159000 123.092003 254.001999)(34.159000 130.597992 282.014008)(-14.805000 152.445007 276.160004)(-6.481010 147.615005 247.431000)(-14.805000 144.939011 248.147995)(2.270990 148.207001 247.272995)(34.159000 123.092003 254.001999)(-6.481010 147.615005 247.431000)(-14.805000 144.939011 248.147995)(35.320000 114.692001 256.252991)(34.283001 106.278000 258.507996)(18.865000 143.125000 248.634995)(10.900001 154.184006 275.694000)(18.865000 150.630005 276.645996)(25.664000 137.770004 250.070007)(18.865000 143.125000 248.634995)(18.865000 150.630005 276.645996)(30.872000 130.949005 251.897003)(25.664000 137.770004 250.070007)(25.664000 145.274994 278.080994)(25.664000 137.770004 250.070007)(18.865000 150.630005 276.645996)(25.664000 145.274994 278.080994)(25.664000 145.274994 278.080994)(30.872000 138.455002 279.910004)(30.872000 130.949005 251.897003)(34.159000 123.092003 254.001999)(30.872000 130.949005 251.897003)(30.872000 138.455002 279.910004)(30.872000 138.455002 279.910004)(34.159000 130.597992 282.014008)(34.159000 123.092003 254.001999)(-39.209000 99.082001 290.459015)(-35.427002 106.377998 288.503998)(-35.427002 98.872002 260.492004)(30.872000 130.949005 251.897003)(34.159000 123.092003 254.001999)(2.270990 148.207001 247.272995)(30.872000 130.949005 251.897003)(10.900001 146.677994 247.682007)(25.664000 137.770004 250.070007)(-32.311996 134.179993 281.053986)(-28.139999 141.634995 279.057007)(-28.139999 134.128998 251.044983)(79.906502 -40.637001 467.510986)(79.672699 -40.592701 467.479004)(79.477898 -40.141998 467.152008)(79.926003 -40.389500 467.332001)(79.906502 -40.637001 467.510986)(79.477898 -40.141998 467.152008)(80.374001 -40.141998 467.152008)(79.906502 -40.637001 467.510986)(79.926003 -40.389500 467.332001)(80.329002 -41.132000 467.869995)(80.140205 -40.637001 467.510986)(80.374001 -40.141998 467.152008)(80.140205 -40.637001 467.510986)(79.906502 -40.637001 467.510986)(80.374001 -40.141998 467.152008)(80.140205 -40.637001 467.510986)(80.329002 -41.132000 467.869995)(79.906502 -40.637001 467.510986)(80.374001 -40.141998 467.152008)(82.525002 -40.196999 472.917999)(80.329002 -41.132000 467.869995)(79.477898 -40.141998 467.152008)(79.672699 -40.592701 467.479004)(79.438904 -41.043503 467.806000)(79.926003 -40.389500 467.332001)(79.926003 -40.265800 467.242004)(80.374001 -40.141998 467.152008)(79.483803 -40.006001 467.053009)(79.477898 -40.141998 467.152008)(77.800995 -75.124001 452.000000)(80.374001 -40.141998 467.152008)(79.477898 -40.141998 467.152008)(79.483803 -40.006001 467.053009)(79.928894 -39.762798 466.877014)(80.374001 -40.141998 467.152008)(79.483803 -40.006001 467.053009)(80.374001 -40.141998 467.152008)(79.928894 -39.762798 466.877014)(79.963402 -39.383499 466.601990)(80.374001 -40.141998 467.152008)(79.926003 -40.265800 467.242004)(79.477898 -40.141998 467.152008)(79.543594 -38.625000 466.051025)(79.483803 -40.006001 467.053009)(77.800995 -75.124001 452.000000)(79.963402 -39.383499 466.601990)(79.483803 -40.006001 467.053009)(79.543594 -38.625000 466.051025)(80.443001 -38.625000 466.051025)(79.963402 -39.383499 466.601990)(79.543594 -38.625000 466.051025)(80.443001 -38.625000 466.051025)(79.543594 -38.625000 466.051025)(79.555305 -38.361603 465.946991)(79.674301 -35.695000 464.893982)(79.555305 -38.361603 465.946991)(77.800995 -75.124001 452.000000)(79.674301 -35.695000 464.893982)(80.061195 -37.160000 465.472992)(79.555305 -38.361603 465.946991)(79.555305 -38.361603 465.946991)(79.543594 -38.625000 466.051025)(77.800995 -75.124001 452.000000)(80.443001 -38.625000 466.051025)(79.555305 -38.361603 465.946991)(80.061195 -37.160000 465.472992)(79.746597 -34.111897 464.691010)(79.674301 -35.695000 464.893982)(77.800995 -75.124001 452.000000)(80.567001 -35.695000 464.893982)(79.674301 -35.695000 464.893982)(80.153603 -34.827000 464.783020)(80.153603 -34.827000 464.783020)(79.674301 -35.695000 464.893982)(79.746597 -34.111897 464.691010)(80.567001 -35.695000 464.893982)(80.153603 -34.827000 464.783020)(80.633003 -33.959000 464.670990)(80.633003 -33.959000 464.670990)(83.756996 -33.969997 471.612000)(80.567001 -35.695000 464.893982)(80.684998 -32.614998 464.500000)(83.756996 -33.969997 471.612000)(80.633003 -33.959000 464.670990)(-42.395500 48.153004 261.871002)(-39.661900 50.334801 261.242981)(-42.663002 47.998001 260.614014)(-36.665100 52.673199 261.759003)(-39.661900 50.334801 261.242981)(-42.395500 48.153004 261.871002)(-36.688000 52.706001 260.614014)(-39.661900 50.334801 261.242981)(-36.665100 52.673199 261.759003)(-36.688000 52.706001 260.614014)(-42.663002 47.998001 260.614014)(-39.661900 50.334801 261.242981)(-94.406998 68.487999 262.893005)(-36.665100 52.673199 261.759003)(-42.395500 48.153004 261.871002)(79.534698 43.808201 486.501007)(79.146400 43.719898 486.720001)(79.922997 43.680000 486.819000)(79.922997 43.680000 486.819000)(79.145798 43.680000 486.819000)(79.146400 43.719898 486.720001)(79.146400 43.719898 486.720001)(78.432899 56.746899 499.244019)(79.145798 43.680000 486.819000)(79.145798 43.680000 486.819000)(78.432899 56.746899 499.244019)(79.153801 42.262302 488.893982)(79.153801 42.262302 488.893982)(79.534393 42.913002 487.942017)(79.145798 43.680000 486.819000)(79.153801 42.262302 488.893982)(79.911003 42.146000 489.063995)(79.534393 42.913002 487.942017)(82.287994 40.196999 485.184998)(80.756996 44.300999 482.371979)(79.911003 42.146000 489.063995)(81.794701 42.171600 482.127014)(80.756996 44.300999 482.371979)(82.287994 40.196999 485.184998)(82.299202 41.100201 482.127014)(81.794701 42.171600 482.127014)(82.287994 40.196999 485.184998)(80.756996 44.300999 482.371979)(79.922997 43.680000 486.819000)(79.911003 42.146000 489.063995)(79.922997 43.680000 486.819000)(79.534393 42.913002 487.942017)(79.911003 42.146000 489.063995)(83.160995 40.196999 479.069000)(82.299202 41.100201 482.127014)(82.287994 40.196999 485.184998)(83.160995 40.196999 479.069000)(82.287994 40.196999 485.184998)(83.428001 33.969997 486.536011)(83.160995 40.196999 479.069000)(81.794701 42.171600 482.127014)(82.299202 41.100201 482.127014)(83.160995 40.196999 479.069000)(80.756996 44.300999 482.371979)(81.794701 42.171600 482.127014)(79.153801 42.262302 488.893982)(78.432899 56.746899 499.244019)(79.154495 42.146000 489.063995)(79.153801 42.262302 488.893982)(79.154495 42.146000 489.063995)(79.911003 42.146000 489.063995)(79.534698 43.808201 486.501007)(79.922997 43.680000 486.819000)(79.540703 43.936497 486.182983)(79.540703 43.936497 486.182983)(79.922997 43.680000 486.819000)(79.737900 43.936497 486.182983)(79.540703 43.936497 486.182983)(79.737900 43.936497 486.182983)(79.934998 44.193001 485.545990)(79.544296 44.064701 485.864014)(79.540703 43.936497 486.182983)(79.934998 44.193001 485.545990)(79.934998 44.193001 485.545990)(79.737900 43.936497 486.182983)(79.922997 43.680000 486.819000)(82.287994 40.196999 485.184998)(79.952003 36.598000 492.841003)(83.428001 33.969997 486.536011)(79.914001 40.181999 490.934998)(79.534203 41.164001 490.000000)(79.183601 40.325401 490.798004)(79.183601 40.325401 490.798004)(79.534203 41.164001 490.000000)(79.154495 42.146000 489.063995)(79.914001 40.181999 490.934998)(79.183601 40.325401 490.798004)(79.185905 40.181999 490.934998)(79.183601 40.325401 490.798004)(78.432899 56.746899 499.244019)(79.185905 40.181999 490.934998)(79.267700 36.842300 492.710999)(79.568901 38.389999 491.888000)(79.185905 40.181999 490.934998)(79.914001 40.181999 490.934998)(79.185905 40.181999 490.934998)(79.568901 38.389999 491.888000)(79.914001 40.181999 490.934998)(79.568901 38.389999 491.888000)(79.952003 36.598000 492.841003)(79.952003 36.598000 492.841003)(79.568901 38.389999 491.888000)(79.267700 36.842300 492.710999)(79.914001 40.181999 490.934998)(79.952003 36.598000 492.841003)(82.287994 40.196999 485.184998)(79.185905 40.181999 490.934998)(78.432899 56.746899 499.244019)(79.267700 36.842300 492.710999)(79.273697 36.598000 492.841003)(79.267700 36.842300 492.710999)(78.432899 56.746899 499.244019)(79.952003 36.598000 492.841003)(79.267700 36.842300 492.710999)(79.273697 36.598000 492.841003)(77.800995 62.127998 521.060974)(79.329102 34.866096 493.126007)(79.282295 36.327900 492.884979)(77.800995 62.127998 521.060974)(79.282295 36.327900 492.884979)(79.273697 36.598000 492.841003)(79.952003 36.598000 492.841003)(79.273697 36.598000 492.841003)(79.282295 36.327900 492.884979)(83.428001 33.969997 486.536011)(83.608002 27.179001 486.575012)(84.889999 27.179001 479.101013)(84.684998 33.971001 479.098999)(83.428001 33.969997 486.536011)(84.889999 27.179001 479.101013)(84.765907 0.000000 479.118988)(84.889999 27.179001 479.101013)(83.608002 27.179001 486.575012)(80.029007 32.595001 493.500000)(83.608002 27.179001 486.575012)(83.428001 33.969997 486.536011)(79.952003 36.598000 492.841003)(80.029007 32.595001 493.500000)(83.428001 33.969997 486.536011)(79.273697 36.598000 492.841003)(78.432899 56.746899 499.244019)(77.800995 62.127998 521.060974)(7.603000 -87.778999 354.873016)(-1.388220 -85.788200 344.410004)(24.572001 -88.039001 354.567993)(-61.307003 -79.329498 313.720001)(-77.823997 -78.304001 309.147003)(-94.341003 -75.278999 293.992004)(-94.309006 -78.239998 309.659973)(-94.341003 -75.278999 293.992004)(-77.823997 -78.304001 309.147003)(-94.309006 -78.239998 309.659973)(-77.823997 -78.304001 309.147003)(-61.307003 -81.329002 324.300995)(41.753201 -107.167000 451.436005)(42.178001 -105.959000 446.110992)(67.601006 -106.838005 452.000000)(41.784397 -110.182999 465.615997)(41.753201 -107.167000 451.436005)(67.601006 -108.184006 458.108002)(41.753201 -107.167000 451.436005)(67.601006 -106.838005 452.000000)(67.601006 -108.184006 458.108002)(41.802002 -111.883995 473.709991)(41.784397 -110.182999 465.615997)(67.601006 -108.184006 458.108002)(67.601006 -112.671005 480.468018)(41.812000 -112.814003 478.283997)(41.808601 -112.526001 476.743988)(41.808601 -112.526001 476.743988)(41.805199 -112.203003 475.196014)(67.601006 -110.815002 470.542999)(72.714005 -96.683998 488.843994)(67.601006 -110.815002 470.542999)(67.601006 -109.491997 464.199982)(41.805199 -112.203003 475.196014)(67.601006 -109.491997 464.199982)(67.601006 -110.815002 470.542999)(72.714005 -96.683998 488.843994)(67.601006 -112.671005 480.468018)(67.601006 -110.815002 470.542999)(67.601006 -112.671005 480.468018)(72.714005 -96.683998 488.843994)(67.601006 -113.523994 488.196991)(41.805199 -112.203003 475.196014)(41.802002 -111.883995 473.709991)(67.601006 -109.491997 464.199982)(-106.214005 -75.188004 309.794983)(-94.309006 -78.239998 309.659973)(-106.494003 -79.836006 333.272980)(-94.341003 -75.278999 293.992004)(-94.309006 -78.239998 309.659973)(-106.214005 -75.188004 309.794983)(-94.276001 -81.189995 325.270996)(-106.494003 -79.836006 333.272980)(-94.309006 -78.239998 309.659973)(-94.260002 -82.452995 333.162994)(-106.494003 -79.836006 333.272980)(-94.276001 -81.189995 325.270996)(-94.276001 -81.189995 325.270996)(-94.309006 -78.239998 309.659973)(-61.307003 -82.618805 331.907013)(-94.276001 -81.189995 325.270996)(-61.307003 -82.618805 331.907013)(-61.307003 -82.820702 332.976013)(-94.276001 -81.189995 325.270996)(-61.307003 -82.820702 332.976013)(-61.307003 -83.014198 334.000000)(-58.542400 -83.028801 334.000000)(-58.203102 -83.030594 334.000000)(-26.334999 -87.259003 355.483002)(-26.334999 -87.259003 355.483002)(-61.307003 -83.014198 334.000000)(-58.542400 -83.028801 334.000000)(-26.334999 -87.259003 355.483002)(-94.276001 -81.189995 325.270996)(-61.307003 -83.014198 334.000000)(-60.272999 -86.737999 356.092987)(-94.260002 -82.452995 333.162994)(-94.276001 -81.189995 325.270996)(-77.243004 -86.478004 356.397980)(-94.260002 -82.452995 333.162994)(-60.272999 -86.737999 356.092987)(-39.445698 -83.375198 334.000000)(-26.334999 -87.259003 355.483002)(-58.203102 -83.030594 334.000000)(-26.334999 -87.259003 355.483002)(-39.445698 -83.375198 334.000000)(7.603000 -87.778999 354.873016)(7.603000 -87.778999 354.873016)(-39.445698 -83.375198 334.000000)(-27.348400 -83.493393 334.000000)(67.601006 -109.491997 464.199982)(67.601006 -108.184006 458.108002)(72.714005 -96.683998 488.843994)(-94.212006 -86.218002 356.704010)(-94.260002 -82.452995 333.162994)(-77.243004 -86.478004 356.397980)(41.808601 -112.526001 476.743988)(67.601006 -110.815002 470.542999)(67.601006 -112.671005 480.468018)(72.701996 -82.625000 415.539001)(67.601006 -88.885002 391.522003)(67.601006 -84.650002 386.212006)(72.701996 -82.625000 415.539001)(67.601006 -92.889000 398.705994)(67.601006 -88.885002 391.522003)(67.601006 -98.632996 417.792999)(42.858997 -103.848999 437.105011)(43.362000 -102.135002 430.031006)(67.601006 -92.889000 398.705994)(45.589001 -92.432999 396.824982)(59.000999 -91.572998 395.704010)(45.589001 -92.432999 396.824982)(45.805000 -90.896004 387.692993)(59.000999 -91.572998 395.704010)(44.993999 -95.351006 404.143005)(45.589001 -92.432999 396.824982)(67.601006 -92.889000 398.705994)(44.993999 -95.351006 404.143005)(67.601006 -92.889000 398.705994)(67.601006 -94.186996 402.330994)(67.601006 -94.186996 402.330994)(67.601006 -95.661003 406.449005)(44.993999 -95.351006 404.143005)(67.601006 -95.661003 406.449005)(43.928001 -100.006996 421.527008)(44.993999 -95.351006 404.143005)(43.928001 -100.006996 421.527008)(67.601006 -95.661003 406.449005)(67.601006 -97.194000 412.299011)(67.601006 -95.661003 406.449005)(72.701996 -82.625000 415.539001)(67.601006 -97.194000 412.299011)(43.362000 -102.135002 430.031006)(67.601006 -97.194000 412.299011)(67.601006 -98.632996 417.792999)(67.601006 -97.194000 412.299011)(72.701996 -82.625000 415.539001)(67.601006 -98.632996 417.792999)(67.601006 -94.186996 402.330994)(67.601006 -92.889000 398.705994)(72.701996 -82.625000 415.539001)(67.601006 -105.671005 446.901001)(67.601006 -104.222000 440.570007)(72.701996 -82.625000 415.539001)(42.178001 -105.959000 446.110992)(67.601006 -104.222000 440.570007)(67.601006 -105.671005 446.901001)(42.178001 -105.959000 446.110992)(42.858997 -103.848999 437.105011)(67.601006 -104.222000 440.570007)(67.601006 -101.487000 429.165985)(72.701996 -82.625000 415.539001)(67.601006 -104.222000 440.570007)(42.858997 -103.848999 437.105011)(67.601006 -101.487000 429.165985)(67.601006 -104.222000 440.570007)(42.858997 -103.848999 437.105011)(67.601006 -98.632996 417.792999)(67.601006 -101.487000 429.165985)(59.000999 -89.418999 377.466003)(42.746998 -87.457001 360.680023)(41.560200 -88.260201 356.608978)(-9.491710 -77.874603 295.000000)(0.508551 -86.214401 293.906982)(-3.418010 -76.742004 266.421997)(-3.418010 -76.742004 266.421997)(0.508551 -86.214401 293.906982)(4.082000 -88.003998 293.427002)(4.082000 -88.003998 293.427002)(4.082000 -80.498001 265.415985)(-3.418010 -76.742004 266.421997)(4.082000 -80.498001 265.415985)(4.082000 -88.003998 293.427002)(7.256990 -88.820999 293.208008)(-34.164997 -106.940002 258.329987)(-3.418010 -76.742004 266.421997)(4.082000 -80.498001 265.415985)(-34.164997 -106.940002 258.329987)(-34.387997 -110.106995 257.481995)(-34.164997 -114.445999 286.341980)(4.082000 -80.498001 265.415985)(-34.387997 -110.106995 257.481995)(-34.164997 -106.940002 258.329987)(-3.418010 -76.742004 266.421997)(-34.164997 -106.940002 258.329987)(-35.427002 -98.872002 260.492004)(-9.366880 -70.952202 267.973999)(-35.427002 -98.872002 260.492004)(-39.209000 -91.576004 262.446991)(-35.427002 -98.872002 260.492004)(-9.366880 -70.952202 267.973999)(-3.418010 -76.742004 266.421997)(-39.209000 -99.082001 290.459015)(-39.209000 -91.576004 262.446991)(-35.427002 -98.872002 260.492004)(-35.427002 -106.377998 288.503998)(-35.427002 -98.872002 260.492004)(-34.164997 -106.940002 258.329987)(-35.427002 -98.872002 260.492004)(-35.427002 -106.377998 288.503998)(-39.209000 -99.082001 290.459015)(-11.225201 -83.688400 334.000000)(24.572001 -88.039001 354.567993)(-15.803801 -83.706497 334.000000)(15.157900 -86.016106 344.256989)(24.572001 -88.039001 354.567993)(-11.225201 -83.688400 334.000000)(41.541000 -88.298996 354.263000)(15.157900 -86.016106 344.256989)(1.062120 -83.916298 334.000000)(41.541000 -88.298996 354.263000)(1.062120 -83.916298 334.000000)(11.392000 -83.905502 334.000000)(41.541000 -88.298996 354.263000)(24.572001 -88.039001 354.567993)(15.157900 -86.016106 344.256989)(41.496601 -84.434998 334.000000)(45.727802 -83.584702 334.000000)(41.541000 -88.298996 354.263000)(41.560200 -88.260201 356.608978)(41.541000 -88.298996 354.263000)(45.727802 -83.584702 334.000000)(45.727802 -83.584702 334.000000)(52.500000 -82.581001 334.000000)(41.560200 -88.260201 356.608978)(41.560200 -88.260201 356.608978)(52.500000 -82.581001 334.000000)(59.000999 -89.418999 377.466003)(-1.388220 -85.788200 344.410004)(-27.348400 -83.493393 334.000000)(-15.803801 -83.706497 334.000000)(-11.225201 -83.688400 334.000000)(1.062120 -83.916298 334.000000)(15.157900 -86.016106 344.256989)(59.000999 -89.418999 377.466003)(43.809998 -88.031998 364.948975)(42.746998 -87.457001 360.680023)(44.958000 -88.740997 370.332001)(43.809998 -88.031998 364.948975)(59.000999 -89.418999 377.466003)(7.256990 -88.820999 293.208008)(7.256990 -81.315002 265.195984)(4.082000 -80.498001 265.415985)(7.256990 -88.820999 293.208008)(11.373000 -89.879997 292.923981)(7.256990 -81.315002 265.195984)(11.373000 -89.879997 292.923981)(19.284901 -93.542801 291.944000)(11.373000 -82.374001 264.912018)(11.373000 -82.374001 264.912018)(7.256990 -81.315002 265.195984)(11.373000 -89.879997 292.923981)(7.256990 -81.315002 265.195984)(11.373000 -82.374001 264.912018)(-34.432999 -118.450996 255.246994)(7.256990 -81.315002 265.195984)(-34.432999 -118.450996 255.246994)(-34.387997 -110.106995 257.481995)(-34.387997 -110.106995 257.481995)(-34.432999 -118.450996 255.246994)(-34.387997 -117.612999 285.492981)(41.836800 -113.957001 489.412018)(41.833302 -113.969994 487.820007)(67.601006 -113.523994 488.196991)(41.833302 -113.969994 487.820007)(41.824699 -113.646004 483.968994)(67.601006 -113.523994 488.196991)(41.837200 -113.955994 489.576019)(41.836800 -113.957001 489.412018)(67.601006 -113.523994 488.196991)(41.824699 -113.646004 483.968994)(41.820400 -113.435997 482.065002)(67.601006 -112.671005 480.468018)(67.601006 -112.671005 480.468018)(41.813999 -112.979004 479.169006)(41.812099 -112.822006 478.329987)(4.082000 -80.498001 265.415985)(7.256990 -81.315002 265.195984)(-34.387997 -110.106995 257.481995)(-34.432999 -118.450996 255.246994)(-34.432999 -125.957001 283.257996)(-34.387997 -117.612999 285.492981)(22.327799 -96.009796 291.282013)(26.004999 -98.990997 290.483002)(19.285002 -86.037003 263.931000)(19.285002 -86.037003 263.931000)(-32.311996 -126.673996 253.042999)(-34.432999 -118.450996 255.246994)(19.285002 -86.037003 263.931000)(26.004999 -91.485001 262.470978)(-32.311996 -126.673996 253.042999)(26.004999 -91.485001 262.470978)(19.285002 -86.037003 263.931000)(26.004999 -98.990997 290.483002)(26.004999 -91.485001 262.470978)(-28.139999 -134.128998 251.044983)(-32.311996 -126.673996 253.042999)(-32.311996 -134.179993 281.053986)(-32.311996 -126.673996 253.042999)(-28.139999 -134.128998 251.044983)(-28.139999 -134.128998 251.044983)(-28.139999 -141.634995 279.057007)(-32.311996 -134.179993 281.053986)(-28.139999 -134.128998 251.044983)(-22.179001 -140.348007 249.378998)(-28.139999 -141.634995 279.057007)(-32.311996 -126.673996 253.042999)(-32.311996 -134.179993 281.053986)(-34.432999 -125.957001 283.257996)(19.285002 -86.037003 263.931000)(20.062700 -94.173401 291.774994)(22.327799 -96.009796 291.282013)(-28.139999 -134.128998 251.044983)(26.004999 -91.485001 262.470978)(31.111000 -98.375999 260.625000)(19.284901 -93.542801 291.944000)(20.062700 -94.173401 291.774994)(19.285002 -86.037003 263.931000)(67.601006 -84.650002 386.212006)(67.601006 -88.885002 391.522003)(59.000999 -91.572998 395.704010)(-1.388220 -85.788200 344.410004)(7.603000 -87.778999 354.873016)(-27.348400 -83.493393 334.000000)(24.572001 -88.039001 354.567993)(-1.388220 -85.788200 344.410004)(-15.803801 -83.706497 334.000000)(26.004999 -91.485001 262.470978)(26.004999 -98.990997 290.483002)(29.344400 -103.497993 289.276001)(-60.272999 -86.737999 356.092987)(-94.276001 -81.189995 325.270996)(-26.334999 -87.259003 355.483002)(-22.179001 -147.852997 277.390991)(-28.139999 -141.634995 279.057007)(-22.179001 -140.348007 249.378998)(32.603802 -106.113998 274.630981)(31.111000 -105.881996 288.637024)(34.283001 -113.783005 286.520020)(31.111000 -98.375999 260.625000)(32.603802 -106.113998 274.630981)(34.283001 -113.783005 286.520020)(34.283001 -106.278000 258.507996)(31.111000 -98.375999 260.625000)(34.283001 -113.783005 286.520020)(32.603802 -106.113998 274.630981)(31.111000 -98.375999 260.625000)(31.111000 -105.881996 288.637024)(34.767200 -114.242004 272.513977)(34.283001 -106.278000 258.507996)(34.283001 -113.783005 286.520020)(-6.481010 -155.121002 275.442993)(2.270990 -148.207001 247.272995)(2.270990 -155.713013 275.285004)(25.664000 -137.770004 250.070007)(30.872000 -130.949005 251.897003)(25.664000 -145.274994 278.080994)(25.664000 -145.274994 278.080994)(18.865000 -150.630005 276.645996)(25.664000 -137.770004 250.070007)(10.900001 -146.677994 247.682007)(18.865000 -143.125000 248.634995)(10.900001 -154.184006 275.694000)(25.664000 -137.770004 250.070007)(18.865000 -143.125000 248.634995)(10.900001 -146.677994 247.682007)(18.865000 -150.630005 276.645996)(18.865000 -143.125000 248.634995)(25.664000 -137.770004 250.070007)(34.283001 -106.278000 258.507996)(35.320000 -114.692001 256.252991)(-14.805000 -144.939011 248.147995)(35.320000 -114.692001 256.252991)(34.283001 -106.278000 258.507996)(35.320000 -122.197998 284.265015)(34.283001 -106.278000 258.507996)(-14.805000 -144.939011 248.147995)(-22.179001 -140.348007 249.378998)(35.320000 -122.197998 284.265015)(34.283001 -106.278000 258.507996)(34.767200 -114.242004 272.513977)(-14.805000 -144.939011 248.147995)(35.320000 -114.692001 256.252991)(-6.481010 -147.615005 247.431000)(34.159000 -123.092003 254.001999)(35.320000 -114.692001 256.252991)(34.159000 -130.597992 282.014008)(35.320000 -114.692001 256.252991)(34.159000 -123.092003 254.001999)(-6.481010 -147.615005 247.431000)(34.159000 -123.092003 254.001999)(2.270990 -148.207001 247.272995)(-6.481010 -147.615005 247.431000)(34.159000 -130.597992 282.014008)(30.872000 -138.455002 279.910004)(34.159000 -123.092003 254.001999)(34.159000 -123.092003 254.001999)(30.872000 -130.949005 251.897003)(2.270990 -148.207001 247.272995)(-14.805000 -152.445007 276.160004)(-14.805000 -144.939011 248.147995)(-6.481010 -147.615005 247.431000)(-22.179001 -140.348007 249.378998)(-14.805000 -144.939011 248.147995)(-22.179001 -147.852997 277.390991)(-20.121698 -149.134003 277.048004)(-22.179001 -147.852997 277.390991)(-16.759100 -147.552994 262.769012)(-14.805000 -144.939011 248.147995)(-16.759100 -147.552994 262.769012)(-22.179001 -147.852997 277.390991)(-14.805000 -152.445007 276.160004)(-20.121698 -149.134003 277.048004)(-16.759100 -147.552994 262.769012)(30.872000 -138.455002 279.910004)(30.872000 -130.949005 251.897003)(34.159000 -123.092003 254.001999)(-6.481010 -155.121002 275.442993)(-14.805000 -152.445007 276.160004)(-6.481010 -147.615005 247.431000)(2.270990 -155.713013 275.285004)(10.900001 -146.677994 247.682007)(10.900001 -154.184006 275.694000)(-106.214005 -75.188004 309.794983)(-106.494003 -79.836006 333.272980)(-117.959000 -74.542999 333.388000)(-106.494003 -79.836006 333.272980)(-102.599998 -84.996002 356.729004)(-108.735001 -83.295006 356.660004)(-102.599998 -84.996002 356.729004)(-106.494003 -79.836006 333.272980)(-94.212006 -86.218002 356.704010)(-108.735001 -83.295006 356.660004)(-117.959000 -74.542999 333.388000)(-106.494003 -79.836006 333.272980)(-94.212006 -86.218002 356.704010)(-106.494003 -79.836006 333.272980)(-94.260002 -82.452995 333.162994)(83.756996 33.969997 471.612000)(83.160995 40.196999 479.069000)(84.684998 33.971001 479.098999)(83.160995 40.196999 479.069000)(83.756996 33.969997 471.612000)(82.525002 40.196999 472.917999)(82.525002 40.196999 472.917999)(81.072006 44.300999 479.023010)(83.160995 40.196999 479.069000)(81.072006 44.300999 479.023010)(80.018997 45.722000 479.000000)(80.756996 44.300999 482.371979)(82.525002 40.196999 472.917999)(80.018997 45.722000 479.000000)(81.072006 44.300999 479.023010)(82.525002 40.196999 472.917999)(80.167000 44.149002 472.476990)(80.018997 45.722000 479.000000)(80.018997 45.722000 479.000000)(79.994003 45.503002 480.707001)(80.756996 44.300999 482.371979)(77.800400 0.000000 530.000000)(79.545601 -0.879971 493.500000)(79.545601 0.879971 493.500000)(79.545601 -0.879971 493.500000)(77.800400 0.000000 530.000000)(79.476807 -10.862000 493.500000)(79.476807 -10.862000 493.500000)(79.918396 -5.431000 493.500000)(79.545601 -0.879971 493.500000)(77.800400 0.000000 530.000000)(78.569298 -15.532000 511.746002)(79.476807 -10.862000 493.500000)(41.916500 -100.043999 525.991028)(41.912899 -101.700996 524.294006)(67.601006 -101.744003 523.383972)(54.775600 -76.659996 541.580017)(41.950302 -78.220802 541.342041)(67.601006 -80.802002 539.831970)(54.775600 -76.659996 541.580017)(41.952099 -75.767197 542.196960)(41.950302 -78.220802 541.342041)(67.601006 -80.802002 539.831970)(67.601006 -72.328003 542.781982)(54.775600 -76.659996 541.580017)(72.714005 -48.195999 536.594971)(67.601006 -72.328003 542.781982)(67.601006 -80.802002 539.831970)(72.714005 -48.195999 536.594971)(67.601006 -62.781998 544.375000)(67.601006 -72.328003 542.781982)(67.601006 -80.802002 539.831970)(41.950302 -78.220802 541.342041)(41.939301 -87.826401 536.362000)(54.766899 -88.597496 535.143982)(67.601006 -80.802002 539.831970)(41.939301 -87.826401 536.362000)(67.601006 -95.750999 529.524048)(41.932800 -92.076797 533.430969)(41.918198 -99.487000 526.510986)(54.766899 -88.597496 535.143982)(41.933102 -91.898705 533.554016)(41.932800 -92.076797 533.430969)(67.601006 -72.328003 542.781982)(41.952099 -75.767197 542.196960)(54.775600 -76.659996 541.580017)(67.601006 -95.750999 529.524048)(41.918198 -99.487000 526.510986)(41.916500 -100.043999 525.991028)(67.601006 -62.781998 544.375000)(72.714005 -48.195999 536.594971)(68.405998 -43.556000 546.675049)(41.959503 -57.327599 545.482971)(41.958000 -62.816700 544.821960)(67.601006 -62.781998 544.375000)(67.601006 -62.781998 544.375000)(68.405998 -43.556000 546.675049)(41.959503 -57.327599 545.482971)(41.959503 -57.327599 545.482971)(68.405998 -43.556000 546.675049)(41.959400 -56.295303 545.449036)(67.601006 -30.676001 546.212952)(68.405998 -43.556000 546.675049)(72.714005 -48.195999 536.594971)(67.601006 98.632996 417.792999)(43.362000 102.135002 430.031006)(42.858997 103.848999 437.105011)(67.601006 98.632996 417.792999)(67.601006 97.194000 412.299011)(43.362000 102.135002 430.031006)(45.727802 83.584702 334.000000)(41.541000 88.298996 354.263000)(41.560200 88.260201 356.608978)(45.727802 83.584702 334.000000)(41.560200 88.260201 356.608978)(52.500000 82.581001 334.000000)(41.541000 88.298996 354.263000)(11.392000 83.905502 334.000000)(1.062120 83.916298 334.000000)(41.541000 88.298996 354.263000)(41.496601 84.434998 334.000000)(11.392000 83.905502 334.000000)(41.541000 88.298996 354.263000)(45.727802 83.584702 334.000000)(41.496601 84.434998 334.000000)(7.603000 87.778999 354.873016)(-1.388220 85.788200 344.410004)(-27.348400 83.493393 334.000000)(-15.803801 83.706497 334.000000)(-27.348400 83.493393 334.000000)(-1.388220 85.788200 344.410004)(-1.388220 85.788200 344.410004)(7.603000 87.778999 354.873016)(24.572001 88.039001 354.567993)(-27.348400 83.493393 334.000000)(-39.445698 83.375198 334.000000)(7.603000 87.778999 354.873016)(-1.388220 85.788200 344.410004)(24.572001 88.039001 354.567993)(-15.803801 83.706497 334.000000)(41.753201 107.167000 451.436005)(41.784397 110.182999 465.615997)(67.601006 108.184006 458.108002)(41.753201 107.167000 451.436005)(67.601006 108.184006 458.108002)(67.601006 106.838005 452.000000)(41.784397 110.182999 465.615997)(41.802002 111.883995 473.709991)(67.601006 108.184006 458.108002)(72.714005 96.683998 488.843994)(67.601006 106.838005 452.000000)(67.601006 108.184006 458.108002)(41.802002 111.883995 473.709991)(67.601006 109.491997 464.199982)(67.601006 108.184006 458.108002)(1.062120 83.916298 334.000000)(15.157900 86.016106 344.256989)(41.541000 88.298996 354.263000)(1.062120 83.916298 334.000000)(-11.225201 83.688400 334.000000)(15.157900 86.016106 344.256989)(-11.225201 83.688400 334.000000)(24.572001 88.039001 354.567993)(15.157900 86.016106 344.256989)(72.714005 96.683998 488.843994)(67.601006 108.184006 458.108002)(67.601006 109.491997 464.199982)(79.207504 45.520298 480.571991)(79.994003 45.503002 480.707001)(79.613205 45.612499 479.853973)(79.613205 45.612499 479.853973)(79.994003 45.503002 480.707001)(80.018997 45.722000 479.000000)(79.232201 45.722000 479.000000)(79.613205 45.612499 479.853973)(80.018997 45.722000 479.000000)(79.207504 45.520298 480.571991)(79.205299 45.503002 480.707001)(79.994003 45.503002 480.707001)(79.168701 45.203999 483.036987)(79.557396 44.698498 484.290985)(79.960007 45.203999 483.036987)(79.154701 44.272099 485.350006)(79.557396 44.698498 484.290985)(79.168701 45.203999 483.036987)(80.756996 44.300999 482.371979)(79.960007 45.203999 483.036987)(79.934998 44.193001 485.545990)(79.994003 45.503002 480.707001)(79.960007 45.203999 483.036987)(80.756996 44.300999 482.371979)(79.582802 45.353497 481.871979)(79.960007 45.203999 483.036987)(79.994003 45.503002 480.707001)(79.171600 45.227699 482.852997)(79.582802 45.353497 481.871979)(79.205299 45.503002 480.707001)(79.171600 45.227699 482.852997)(79.960007 45.203999 483.036987)(79.582802 45.353497 481.871979)(79.171600 45.227699 482.852997)(79.205299 45.503002 480.707001)(78.432899 56.746899 499.244019)(79.207504 45.520298 480.571991)(77.800995 78.636993 492.308990)(78.432899 56.746899 499.244019)(79.232201 45.722000 479.000000)(77.800995 78.636993 492.308990)(79.207504 45.520298 480.571991)(79.241295 45.669601 478.640991)(77.800995 78.636993 492.308990)(79.232201 45.722000 479.000000)(77.800995 78.636993 492.308990)(79.241295 45.669601 478.640991)(79.272102 45.492599 477.427979)(77.800995 75.124001 452.000000)(77.800995 78.636993 492.308990)(79.272102 45.492599 477.427979)(72.714005 96.683998 488.843994)(77.800995 78.636993 492.308990)(77.800995 75.124001 452.000000)(79.205299 45.503002 480.707001)(79.207504 45.520298 480.571991)(78.432899 56.746899 499.244019)(79.154701 44.272099 485.350006)(79.168701 45.203999 483.036987)(78.432899 56.746899 499.244019)(78.432899 56.746899 499.244019)(79.168701 45.203999 483.036987)(79.171600 45.227699 482.852997)(79.153503 44.193001 485.545990)(79.154701 44.272099 485.350006)(78.432899 56.746899 499.244019)(79.154701 44.272099 485.350006)(79.934998 44.193001 485.545990)(79.557396 44.698498 484.290985)(79.171600 45.227699 482.852997)(79.168701 45.203999 483.036987)(79.960007 45.203999 483.036987)(79.557396 44.698498 484.290985)(79.934998 44.193001 485.545990)(79.960007 45.203999 483.036987)(78.432899 56.746899 499.244019)(77.800995 78.636993 492.308990)(77.800995 62.127998 521.060974)(77.800995 75.124001 452.000000)(72.708000 90.958000 452.000000)(72.714005 96.683998 488.843994)(77.800995 78.636993 492.308990)(72.714005 96.683998 488.843994)(77.800995 62.127998 521.060974)(41.885101 109.429001 511.524963)(41.892399 107.468002 514.809021)(67.601006 109.103996 511.054993)(70.139099 -7.513500 542.466980)(68.856705 -7.513500 544.556030)(67.601006 -15.026999 546.661987)(67.601006 0.000000 546.541992)(68.856705 -7.513500 544.556030)(70.139099 -7.513500 542.466980)(67.601006 -15.026999 546.661987)(68.856705 -7.513500 544.556030)(67.601006 0.000000 546.541992)(60.613503 0.000000 546.342041)(67.601006 0.000000 546.541992)(67.601006 15.026999 546.661987)(67.601006 -15.026999 546.661987)(67.601006 0.000000 546.541992)(60.613503 0.000000 546.342041)(67.601006 -15.026999 546.661987)(60.613503 0.000000 546.342041)(59.982502 0.000000 546.275024)(67.601006 -15.026999 546.661987)(59.982502 0.000000 546.275024)(55.723598 -0.000000 545.817017)(55.723598 -0.000000 545.817017)(59.982502 0.000000 546.275024)(67.601006 15.026999 546.661987)(54.766899 88.597496 535.143982)(67.601006 95.750999 529.524048)(41.932800 92.076797 533.430969)(67.601006 95.750999 529.524048)(41.918198 99.487000 526.510986)(41.932800 92.076797 533.430969)(41.959400 56.295303 545.449036)(68.405998 43.556000 546.675049)(41.959503 57.327599 545.482971)(68.405998 43.556000 546.675049)(67.601006 62.781998 544.375000)(41.959503 57.327599 545.482971)(67.601006 62.781998 544.375000)(68.405998 43.556000 546.675049)(72.714005 48.195999 536.594971)(67.601006 30.676001 546.212952)(41.959202 53.446301 545.358032)(41.962200 30.018700 546.692017)(41.962200 30.018700 546.692017)(54.781601 26.837099 546.380981)(67.601006 30.676001 546.212952)(54.781601 23.003201 546.302979)(54.781601 26.837099 546.380981)(41.962200 30.018700 546.692017)(67.601006 30.676001 546.212952)(68.405998 43.556000 546.675049)(41.959202 53.446301 545.358032)(72.714005 48.195999 536.594971)(68.405998 43.556000 546.675049)(67.601006 30.676001 546.212952)(67.601006 72.328003 542.781982)(67.601006 62.781998 544.375000)(72.714005 48.195999 536.594971)(41.892399 107.468002 514.809021)(67.601006 101.744003 523.383972)(67.601006 109.103996 511.054993)(67.601006 109.103996 511.054993)(67.601006 101.744003 523.383972)(72.714005 82.199997 522.572998)(67.601006 109.103996 511.054993)(72.714005 82.199997 522.572998)(67.601006 112.983002 497.233978)(41.805199 112.203003 475.196014)(41.808601 112.526001 476.743988)(67.601006 110.815002 470.542999)(41.805199 112.203003 475.196014)(67.601006 110.815002 470.542999)(67.601006 109.491997 464.199982)(67.601006 109.491997 464.199982)(67.601006 110.815002 470.542999)(72.714005 96.683998 488.843994)(67.601006 113.523994 488.196991)(41.824699 113.646004 483.968994)(41.833302 113.969994 487.820007)(67.601006 112.671005 480.468018)(72.714005 96.683998 488.843994)(67.601006 110.815002 470.542999)(67.601006 113.523994 488.196991)(72.714005 96.683998 488.843994)(67.601006 112.671005 480.468018)(67.601006 113.523994 488.196991)(67.601006 112.671005 480.468018)(41.824699 113.646004 483.968994)(67.601006 113.523994 488.196991)(67.601006 113.279999 492.261993)(72.714005 96.683998 488.843994)(72.714005 48.195999 536.594971)(67.601006 95.750999 529.524048)(67.601006 80.802002 539.831970)(72.714005 82.199997 522.572998)(67.601006 95.750999 529.524048)(72.714005 48.195999 536.594971)(72.714005 96.683998 488.843994)(67.601006 113.279999 492.261993)(72.714005 82.199997 522.572998)(72.714005 82.199997 522.572998)(77.800995 62.127998 521.060974)(72.714005 96.683998 488.843994)(72.714005 48.195999 536.594971)(77.800995 62.127998 521.060974)(72.714005 82.199997 522.572998)(67.601006 112.983002 497.233978)(72.714005 82.199997 522.572998)(67.601006 113.279999 492.261993)(67.601006 80.802002 539.831970)(67.601006 72.328003 542.781982)(72.714005 48.195999 536.594971)(54.775600 76.659996 541.580017)(41.952099 75.767197 542.196960)(67.601006 72.328003 542.781982)(67.601006 72.328003 542.781982)(67.601006 80.802002 539.831970)(54.775600 76.659996 541.580017)(67.601006 80.802002 539.831970)(41.939301 87.826401 536.362000)(41.950302 78.220802 541.342041)(67.601006 80.802002 539.831970)(41.950302 78.220802 541.342041)(54.775600 76.659996 541.580017)(43.766300 112.223000 501.431000)(42.614098 110.106995 509.056976)(67.601006 109.103996 511.054993)(67.601006 109.103996 511.054993)(67.601006 112.983002 497.233978)(43.766300 112.223000 501.431000)(44.331100 113.262001 497.694000)(43.766300 112.223000 501.431000)(67.601006 112.983002 497.233978)(44.020298 113.420998 497.148987)(44.331100 113.262001 497.694000)(67.601006 112.983002 497.233978)(55.382198 113.355003 494.760986)(44.020298 113.420998 497.148987)(67.601006 112.983002 497.233978)(67.601006 113.279999 492.261993)(43.163300 113.523003 495.692017)(55.382198 113.355003 494.760986)(67.601006 113.279999 492.261993)(41.842899 113.883003 492.217987)(43.163300 113.523003 495.692017)(41.842899 113.883003 492.217987)(43.039898 113.545998 495.481995)(43.163300 113.523003 495.692017)(41.850201 113.562004 495.604980)(43.039898 113.545998 495.481995)(41.842899 113.883003 492.217987)(41.840698 113.944000 491.200012)(67.601006 113.523994 488.196991)(41.837200 113.955994 489.576019)(41.820400 113.435997 482.065002)(41.824699 113.646004 483.968994)(67.601006 112.671005 480.468018)(41.812099 112.822006 478.329987)(41.813999 112.979004 479.169006)(67.601006 112.671005 480.468018)(41.813999 112.979004 479.169006)(41.820400 113.435997 482.065002)(67.601006 112.671005 480.468018)(67.601006 62.781998 544.375000)(67.601006 72.328003 542.781982)(41.956997 65.602196 544.356995)(54.781601 23.003201 546.302979)(41.962200 30.018700 546.692017)(54.780899 15.335300 546.146973)(72.714005 -10.359000 538.294983)(67.601006 -30.676001 546.212952)(72.714005 -48.195999 536.594971)(72.714005 -10.359000 538.294983)(67.601006 -15.026999 546.661987)(67.601006 -30.676001 546.212952)(72.714005 -10.359000 538.294983)(72.714005 -48.195999 536.594971)(77.800995 -62.127998 521.060974)(67.601006 -30.676001 546.212952)(67.601006 -15.026999 546.661987)(55.723598 -0.000000 545.817017)(55.723598 -0.000000 545.817017)(54.780899 -15.335300 546.146973)(67.601006 -30.676001 546.212952)(67.601006 -30.676001 546.212952)(54.780899 -15.335300 546.146973)(54.781601 -23.003201 546.302979)(54.780899 15.335300 546.146973)(41.962200 30.018700 546.692017)(48.370903 15.011801 546.263977)(41.960796 0.000000 546.080994)(48.370903 15.011801 546.263977)(41.962200 30.018700 546.692017)(41.962200 -30.018700 546.692017)(48.370903 -15.011801 546.263977)(41.960796 0.000000 546.080994)(54.780899 -15.335300 546.146973)(48.370903 -15.011801 546.263977)(41.962200 -30.018700 546.692017)(54.781601 -26.837099 546.380981)(54.781601 -23.003201 546.302979)(41.962200 -30.018700 546.692017)(54.781601 -23.003201 546.302979)(54.780899 -15.335300 546.146973)(41.962200 -30.018700 546.692017)(67.601006 -30.676001 546.212952)(54.781601 -26.837099 546.380981)(41.962200 -30.018700 546.692017)(67.601006 -30.676001 546.212952)(41.962200 -30.018700 546.692017)(41.959202 -53.446301 545.358032)(67.601006 -30.676001 546.212952)(54.781601 -23.003201 546.302979)(54.781601 -26.837099 546.380981)(54.780899 15.335300 546.146973)(48.370903 15.011801 546.263977)(41.960796 0.000000 546.080994)(77.800400 0.000000 530.000000)(72.714005 -10.359000 538.294983)(77.800995 -62.127998 521.060974)(77.800995 -62.127998 521.060974)(78.471199 -31.063999 511.557983)(77.800400 0.000000 530.000000)(78.569298 -15.532000 511.746002)(77.800400 0.000000 530.000000)(78.471199 -31.063999 511.557983)(79.372696 -25.941099 493.500000)(79.866402 -19.020000 493.500000)(79.476807 -10.862000 493.500000)(79.476807 -10.862000 493.500000)(78.471199 -31.063999 511.557983)(79.372696 -25.941099 493.500000)(79.476807 -10.862000 493.500000)(78.569298 -15.532000 511.746002)(78.471199 -31.063999 511.557983)(41.840698 113.944000 491.200012)(41.842899 113.883003 492.217987)(67.601006 113.279999 492.261993)(79.372696 -25.941099 493.500000)(78.471199 -31.063999 511.557983)(79.364204 -27.178001 493.500000)(80.029007 -32.595001 493.500000)(80.112000 -27.178001 493.500000)(79.720695 -29.886501 493.500000)(79.720695 -29.886501 493.500000)(80.112000 -27.178001 493.500000)(79.364204 -27.178001 493.500000)(79.329399 -32.212902 493.500000)(80.029007 -32.595001 493.500000)(79.720695 -29.886501 493.500000)(79.326797 -32.595001 493.500000)(80.029007 -32.595001 493.500000)(79.329399 -32.212902 493.500000)(79.329399 -32.212902 493.500000)(78.471199 -31.063999 511.557983)(79.326797 -32.595001 493.500000)(79.364204 -27.178001 493.500000)(78.471199 -31.063999 511.557983)(79.329399 -32.212902 493.500000)(79.329399 -32.212902 493.500000)(79.720695 -29.886501 493.500000)(79.364204 -27.178001 493.500000)(67.601006 62.781998 544.375000)(41.958000 62.816700 544.821960)(41.959503 57.327599 545.482971)(41.837200 113.955994 489.576019)(67.601006 113.523994 488.196991)(41.836800 113.957001 489.412018)(67.601006 112.983002 497.233978)(67.601006 113.279999 492.261993)(55.382198 113.355003 494.760986)(67.601006 30.676001 546.212952)(54.781601 26.837099 546.380981)(54.781601 23.003201 546.302979)(67.601006 62.781998 544.375000)(41.956997 65.602196 544.356995)(41.958000 62.816700 544.821960)(72.714005 10.359000 538.294983)(77.800995 62.127998 521.060974)(72.714005 48.195999 536.594971)(70.139099 -7.513500 542.466980)(67.601006 -15.026999 546.661987)(72.714005 -10.359000 538.294983)(74.165901 0.000000 535.719971)(72.714005 0.000000 538.158997)(72.714005 -10.359000 538.294983)(72.714005 0.000000 538.158997)(71.280098 0.000000 540.548035)(72.714005 -10.359000 538.294983)(71.280098 0.000000 540.548035)(70.139099 -7.513500 542.466980)(72.714005 -10.359000 538.294983)(72.714005 48.195999 536.594971)(67.601006 30.676001 546.212952)(72.714005 10.359000 538.294983)(67.601006 113.523994 488.196991)(41.833302 113.969994 487.820007)(41.836800 113.957001 489.412018)(79.866402 -19.020000 493.500000)(80.360001 -10.862000 493.500000)(79.476807 -10.862000 493.500000)(80.539803 -16.924101 464.500000)(80.550095 -16.699800 464.500000)(81.124001 -16.306999 464.500000)(80.550095 -16.699800 464.500000)(80.564003 -16.306999 464.500000)(81.124001 -16.306999 464.500000)(81.124001 -16.306999 464.500000)(80.564003 -16.306999 464.500000)(80.914497 -8.153500 464.500000)(80.894905 -6.929690 464.500000)(80.914497 -8.153500 464.500000)(80.564003 -16.306999 464.500000)(81.264900 -0.000000 464.500000)(80.914497 -8.153500 464.500000)(80.894905 -6.929690 464.500000)(81.124001 -16.306999 464.500000)(80.914497 -8.153500 464.500000)(81.264900 -0.000000 464.500000)(81.267998 0.000000 464.500000)(81.264900 -0.000000 464.500000)(81.124001 -16.306999 464.500000)(81.124001 16.306999 464.500000)(81.264900 -0.000000 464.500000)(81.267998 0.000000 464.500000)(81.267998 0.000000 464.500000)(84.006798 0.000000 471.638000)(81.124001 -16.306999 464.500000)(83.979004 -27.179001 471.576996)(82.564896 -13.589500 468.069000)(84.006798 0.000000 471.638000)(84.006798 0.000000 471.638000)(82.564896 -13.589500 468.069000)(81.124001 -16.306999 464.500000)(84.889999 -27.179001 479.101013)(83.979004 -27.179001 471.576996)(84.006798 0.000000 471.638000)(80.112000 -27.178001 493.500000)(80.360001 -10.862000 493.500000)(79.866402 -19.020000 493.500000)(80.360001 -10.862000 493.500000)(80.112000 -27.178001 493.500000)(83.608002 -27.179001 486.575012)(80.360001 -10.862000 493.500000)(80.357498 -0.000000 493.500000)(79.918396 -5.431000 493.500000)(83.559402 0.000000 486.539978)(80.357498 -0.000000 493.500000)(80.360001 -10.862000 493.500000)(83.559402 0.000000 486.539978)(80.360001 -10.862000 493.500000)(83.608002 -27.179001 486.575012)(84.765907 0.000000 479.118988)(83.559402 0.000000 486.539978)(83.608002 -27.179001 486.575012)(84.765907 0.000000 479.118988)(83.608002 -27.179001 486.575012)(84.889999 -27.179001 479.101013)(84.006798 0.000000 471.638000)(84.765907 0.000000 479.118988)(84.889999 -27.179001 479.101013)(67.601006 -95.750999 529.524048)(54.766899 -88.597496 535.143982)(41.932800 -92.076797 533.430969)(67.601006 -95.750999 529.524048)(61.184002 -88.436996 534.910950)(54.766899 -88.597496 535.143982)(41.840698 -113.944000 491.200012)(67.601006 -113.523994 488.196991)(67.601006 -113.279999 492.261993)(41.842899 -113.883003 492.217987)(41.840698 -113.944000 491.200012)(67.601006 -113.279999 492.261993)(41.885101 -109.429001 511.524963)(42.614098 -110.106995 509.056976)(67.601006 -109.103996 511.054993)(41.897800 -106.003998 517.218018)(41.892399 -107.468002 514.809021)(67.601006 -101.744003 523.383972)(41.898197 -105.878998 517.421997)(41.897800 -106.003998 517.218018)(67.601006 -101.744003 523.383972)(41.909698 -102.618004 522.785034)(41.898197 -105.878998 517.421997)(67.601006 -101.744003 523.383972)(43.163300 -113.523003 495.692017)(43.039898 -113.545998 495.481995)(41.842899 -113.883003 492.217987)(41.850201 -113.562004 495.604980)(41.842899 -113.883003 492.217987)(43.039898 -113.545998 495.481995)(43.163300 -113.523003 495.692017)(41.842899 -113.883003 492.217987)(67.601006 -113.279999 492.261993)(44.331100 -113.262001 497.694000)(44.020298 -113.420998 497.148987)(67.601006 -112.983002 497.233978)(43.766300 -112.223000 501.431000)(44.331100 -113.262001 497.694000)(67.601006 -112.983002 497.233978)(43.766300 -112.223000 501.431000)(67.601006 -112.983002 497.233978)(67.601006 -109.103996 511.054993)(67.601006 -112.983002 497.233978)(72.714005 -82.199997 522.572998)(67.601006 -109.103996 511.054993)(55.382198 -113.355003 494.760986)(43.163300 -113.523003 495.692017)(67.601006 -113.279999 492.261993)(72.714005 -82.199997 522.572998)(67.601006 -112.983002 497.233978)(67.601006 -113.279999 492.261993)(67.601006 -109.103996 511.054993)(72.714005 -82.199997 522.572998)(67.601006 -101.744003 523.383972)(72.714005 -82.199997 522.572998)(72.714005 -48.195999 536.594971)(67.601006 -95.750999 529.524048)(72.714005 -82.199997 522.572998)(67.601006 -95.750999 529.524048)(67.601006 -101.744003 523.383972)(44.020298 -113.420998 497.148987)(43.163300 -113.523003 495.692017)(55.382198 -113.355003 494.760986)(55.382198 -113.355003 494.760986)(67.601006 -113.279999 492.261993)(67.601006 -112.983002 497.233978)(-94.276001 81.189995 325.270996)(-60.272999 86.737999 356.092987)(-26.334999 87.259003 355.483002)(-117.959000 74.542999 333.388000)(-118.275002 79.184006 356.402008)(-108.735001 83.295006 356.660004)(-60.272999 86.737999 356.092987)(-94.276001 81.189995 325.270996)(-94.260002 82.452995 333.162994)(-94.260002 82.452995 333.162994)(-94.276001 81.189995 325.270996)(-106.494003 79.836006 333.272980)(-94.276001 81.189995 325.270996)(-61.307003 82.820702 332.976013)(-61.307003 82.618805 331.907013)(-94.276001 81.189995 325.270996)(-61.307003 83.014198 334.000000)(-61.307003 82.820702 332.976013)(-94.309006 78.239998 309.659973)(-94.276001 81.189995 325.270996)(-61.307003 82.618805 331.907013)(-94.309006 78.239998 309.659973)(-106.494003 79.836006 333.272980)(-94.276001 81.189995 325.270996)(-106.494003 79.836006 333.272980)(-94.309006 78.239998 309.659973)(-106.214005 75.188004 309.794983)(-106.214005 75.188004 309.794983)(-94.309006 78.239998 309.659973)(-94.341003 75.278999 293.992004)(-94.341003 75.278999 293.992004)(-94.309006 78.239998 309.659973)(-77.823997 78.304001 309.147003)(-77.823997 78.304001 309.147003)(-94.309006 78.239998 309.659973)(-61.307003 81.329002 324.300995)(-94.341003 75.278999 293.992004)(-77.823997 78.304001 309.147003)(-61.307003 79.329498 313.720001)(-94.341003 75.278999 293.992004)(-61.307003 79.329498 313.720001)(-61.307003 78.823700 310.820007)(-61.307003 83.014198 334.000000)(-94.276001 81.189995 325.270996)(-26.334999 87.259003 355.483002)(-102.599998 84.996002 356.729004)(-94.212006 86.218002 356.704010)(-106.494003 79.836006 333.272980)(-94.260002 82.452995 333.162994)(-106.494003 79.836006 333.272980)(-94.212006 86.218002 356.704010)(-106.494003 79.836006 333.272980)(-108.735001 83.295006 356.660004)(-102.599998 84.996002 356.729004)(-106.494003 79.836006 333.272980)(-117.959000 74.542999 333.388000)(-108.735001 83.295006 356.660004)(-94.212006 86.218002 356.704010)(-77.243004 86.478004 356.397980)(-94.260002 82.452995 333.162994)(-106.214005 75.188004 309.794983)(-117.959000 74.542999 333.388000)(-106.494003 79.836006 333.272980)(-94.309006 78.239998 309.659973)(-61.307003 82.618805 331.907013)(-61.307003 81.329002 324.300995)(41.335003 70.367004 260.226990)(25.352999 58.995602 260.540985)(25.326000 59.010597 260.540985)(-60.119099 75.463501 295.000000)(-59.974903 75.463303 295.000000)(-58.876102 73.665703 286.773010)(-59.974903 75.463303 295.000000)(-58.944603 75.462196 295.000000)(-58.876102 73.665703 286.773010)(-24.953701 59.095497 261.528992)(-25.313299 58.982399 261.536011)(-94.406998 68.487999 262.893005)(-12.923200 62.879799 261.292999)(-24.953701 59.095497 261.528992)(-94.406998 68.487999 262.893005)(0.172782 64.184700 261.035004)(-0.000012 64.202194 261.039001)(41.335003 70.367004 260.226990)(-0.000012 64.202194 261.039001)(-94.406998 68.487999 262.893005)(41.335003 70.367004 260.226990)(-58.633900 70.127800 268.194000)(41.335003 70.367004 260.226990)(-94.406998 68.487999 262.893005)(-0.000012 64.217003 260.614014)(0.172782 64.184700 261.035004)(-0.000012 64.202194 261.039001)(0.172782 64.184700 261.035004)(6.463250 63.552700 260.825012)(-0.000012 64.217003 260.614014)(-12.927999 62.903004 260.614014)(-19.122200 60.942299 261.070984)(-12.923200 62.879799 261.292999)(-12.923200 62.879799 261.292999)(-12.647201 62.908001 261.287018)(-12.927999 62.903004 260.614014)(-12.923200 62.879799 261.292999)(-94.406998 68.487999 262.893005)(-12.647201 62.908001 261.287018)(-6.462820 63.548401 260.951019)(-12.927999 62.903004 260.614014)(-12.647201 62.908001 261.287018)(-12.927999 62.903004 260.614014)(-6.462820 63.548401 260.951019)(-0.000012 64.217003 260.614014)(-0.000012 64.202194 261.039001)(-0.000012 64.217003 260.614014)(-6.462820 63.548401 260.951019)(-94.406998 68.487999 262.893005)(-58.753300 71.872101 277.354004)(-58.633900 70.127800 268.194000)(-12.923200 62.879799 261.292999)(-19.122200 60.942299 261.070984)(-24.953701 59.095497 261.528992)(12.926800 62.897198 260.785004)(41.335003 70.367004 260.226990)(12.993500 62.876301 260.783997)(12.927999 62.903004 260.614014)(12.993500 62.876301 260.783997)(12.926800 62.897198 260.785004)(21.528200 60.204800 260.615997)(12.927999 62.903004 260.614014)(12.993500 62.876301 260.783997)(12.993500 62.876301 260.783997)(41.335003 70.367004 260.226990)(21.528200 60.204800 260.615997)(25.326000 59.010597 260.540985)(21.528200 60.204800 260.615997)(41.335003 70.367004 260.226990)(-0.000012 64.202194 261.039001)(-6.462820 63.548401 260.951019)(-12.647201 62.908001 261.287018)(6.463250 63.552700 260.825012)(12.927999 62.903004 260.614014)(-0.000012 64.217003 260.614014)(-94.406998 68.487999 262.893005)(-58.770599 72.124001 278.677002)(-58.753300 71.872101 277.354004)(-58.339001 71.764000 267.755981)(-58.770599 72.124001 278.677002)(-58.339001 79.063202 295.000000)(-58.753300 71.872101 277.354004)(-58.770599 72.124001 278.677002)(-58.339001 71.764000 267.755981)(-58.339001 79.063202 295.000000)(-55.224003 77.662994 266.174988)(-58.339001 71.764000 267.755981)(-55.224003 77.662994 266.174988)(-58.339001 79.063202 295.000000)(-58.258198 79.227295 295.000000)(-58.339001 71.764000 267.755981)(-55.224003 77.662994 266.174988)(-39.505299 70.447899 268.075989)(-58.258198 79.227295 295.000000)(-56.825802 82.135002 295.000000)(-55.224003 85.168999 294.187012)(-55.224003 77.662994 266.174988)(-58.258198 79.227295 295.000000)(-55.224003 85.168999 294.187012)(-50.446999 82.413002 264.902008)(-55.224003 77.662994 266.174988)(-55.224003 85.168999 294.187012)(-24.953701 59.095497 261.528992)(-19.122200 60.942299 261.070984)(-25.326000 59.012001 260.614014)(-25.326000 59.012001 260.614014)(-19.122200 60.942299 261.070984)(-12.927999 62.903004 260.614014)(-0.000012 -64.217003 260.614014)(6.463250 -63.552700 260.825012)(0.172782 -64.184700 261.035004)(-0.000012 -64.217003 260.614014)(-0.000012 -64.202194 261.039001)(0.172782 -64.184700 261.035004)(12.926800 -62.897198 260.785004)(6.463250 -63.552700 260.825012)(12.927999 -62.903004 260.614014)(12.927999 -62.903004 260.614014)(12.993500 -62.876301 260.783997)(12.926800 -62.897198 260.785004)(12.927999 -62.903004 260.614014)(21.528200 -60.204800 260.615997)(12.993500 -62.876301 260.783997)(-12.927999 -62.903004 260.614014)(-0.000012 -64.217003 260.614014)(-6.462820 -63.548401 260.951019)(-12.647201 -62.908001 261.287018)(-6.462820 -63.548401 260.951019)(-0.000012 -64.202194 261.039001)(-0.000012 -64.202194 261.039001)(-6.462820 -63.548401 260.951019)(-0.000012 -64.217003 260.614014)(-12.647201 -62.908001 261.287018)(-12.927999 -62.903004 260.614014)(-6.462820 -63.548401 260.951019)(12.993500 -62.876301 260.783997)(21.528200 -60.204800 260.615997)(41.335003 -70.367004 260.226990)(-94.406998 -68.487999 262.893005)(-12.647201 -62.908001 261.287018)(-0.000012 -64.202194 261.039001)(-94.406998 -68.487999 262.893005)(-0.000012 -64.202194 261.039001)(41.335003 -70.367004 260.226990)(-0.000012 -64.202194 261.039001)(0.172782 -64.184700 261.035004)(41.335003 -70.367004 260.226990)(-94.406998 -68.487999 262.893005)(-12.923200 -62.879799 261.292999)(-12.647201 -62.908001 261.287018)(-25.313299 58.982399 261.536011)(-30.997398 55.841698 261.182007)(-36.255600 52.900799 261.751007)(-30.997398 55.841698 261.182007)(-36.688000 52.706001 260.614014)(-36.255600 52.900799 261.751007)(-36.688000 52.706001 260.614014)(-30.997398 55.841698 261.182007)(-25.326000 59.012001 260.614014)(-94.406998 -68.487999 262.893005)(-25.313299 -58.982399 261.536011)(-24.953701 -59.095497 261.528992)(-94.406998 -68.487999 262.893005)(-24.953701 -59.095497 261.528992)(-12.923200 -62.879799 261.292999)(-94.406998 -68.487999 262.893005)(-36.255600 -52.900799 261.751007)(-25.313299 -58.982399 261.536011)(-24.953701 -59.095497 261.528992)(-19.122200 -60.942299 261.070984)(-12.923200 -62.879799 261.292999)(-19.122200 -60.942299 261.070984)(-25.326000 -59.012001 260.614014)(-12.927999 -62.903004 260.614014)(-25.326000 -59.012001 260.614014)(-19.122200 -60.942299 261.070984)(-24.953701 -59.095497 261.528992)(12.926800 -62.897198 260.785004)(12.993500 -62.876301 260.783997)(41.335003 -70.367004 260.226990)(-0.000012 -64.217003 260.614014)(12.927999 -62.903004 260.614014)(6.463250 -63.552700 260.825012)(0.172782 -64.184700 261.035004)(12.926800 -62.897198 260.785004)(41.335003 -70.367004 260.226990)(21.528200 -60.204800 260.615997)(25.326000 -59.010597 260.540985)(41.335003 -70.367004 260.226990)(12.927999 62.903004 260.614014)(6.463250 63.552700 260.825012)(12.926800 62.897198 260.785004)(25.352999 -58.995602 260.540985)(41.335003 -70.367004 260.226990)(25.326000 -59.010597 260.540985)(41.335003 -70.367004 260.226990)(25.352999 -58.995602 260.540985)(36.682098 -52.697498 260.318024)(41.335003 -70.367004 260.226990)(36.682098 -52.697498 260.318024)(36.775700 -52.616997 260.316986)(12.926800 62.897198 260.785004)(6.463250 63.552700 260.825012)(0.172782 64.184700 261.035004)(-94.357002 73.585007 286.235016)(-61.307003 77.601700 305.225006)(-61.307003 77.163399 302.778992)(-135.472000 47.260002 354.721985)(-124.982994 72.045998 355.863983)(-130.461014 52.723999 333.459991)(-124.130005 67.465996 333.440979)(-130.461014 52.723999 333.459991)(-124.982994 72.045998 355.863983)(-123.512001 61.675999 310.009979)(-130.461014 52.723999 333.459991)(-124.130005 67.465996 333.440979)(-117.537003 69.362000 309.940979)(-123.512001 61.675999 310.009979)(-124.130005 67.465996 333.440979)(-124.130005 67.465996 333.440979)(-117.959000 74.542999 333.388000)(-117.537003 69.362000 309.940979)(-123.512001 61.675999 310.009979)(-117.537003 69.362000 309.940979)(-117.026001 63.762001 286.584991)(-105.911003 70.065002 286.406006)(-94.406998 68.487999 262.893005)(-106.490997 63.938000 263.130005)(-105.911003 70.065002 286.406006)(-94.357002 73.585007 286.235016)(-94.406998 68.487999 262.893005)(-106.490997 63.938000 263.130005)(-115.973999 58.090000 263.316986)(-105.911003 70.065002 286.406006)(-94.357002 73.585007 286.235016)(-105.911003 70.065002 286.406006)(-106.214005 75.188004 309.794983)(-117.537003 69.362000 309.940979)(-106.214005 75.188004 309.794983)(-105.911003 70.065002 286.406006)(-117.537003 69.362000 309.940979)(-105.911003 70.065002 286.406006)(-117.026001 63.762001 286.584991)(-117.026001 63.762001 286.584991)(-105.911003 70.065002 286.406006)(-115.973999 58.090000 263.316986)(-115.973999 58.090000 263.316986)(-120.144005 52.723003 263.397980)(-117.026001 63.762001 286.584991)(-120.144005 52.723003 263.397980)(-121.458000 58.391003 286.653992)(-117.026001 63.762001 286.584991)(-120.144005 52.723003 263.397980)(-115.973999 58.090000 263.316986)(-94.406998 68.487999 262.893005)(-122.964005 45.035999 263.453003)(-120.144005 52.723003 263.397980)(-94.406998 68.487999 262.893005)(43.362000 -102.135002 430.031006)(43.928001 -100.006996 421.527008)(67.601006 -97.194000 412.299011)(67.601006 -112.983002 497.233978)(44.020298 -113.420998 497.148987)(55.382198 -113.355003 494.760986)(67.601006 80.802002 539.831970)(54.766899 88.597496 535.143982)(41.939301 87.826401 536.362000)(54.766899 88.597496 535.143982)(67.601006 80.802002 539.831970)(61.184002 88.436996 534.910950)(84.684998 33.971001 479.098999)(84.889999 27.179001 479.101013)(83.756996 33.969997 471.612000)(83.756996 33.969997 471.612000)(83.979004 27.179001 471.576996)(80.684998 32.614998 464.500000)(80.684998 32.614998 464.500000)(83.979004 27.179001 471.576996)(80.832001 27.179001 464.500000)(83.756996 33.969997 471.612000)(84.889999 27.179001 479.101013)(83.979004 27.179001 471.576996)(-24.953701 -59.095497 261.528992)(-25.313299 -58.982399 261.536011)(-25.326000 -59.012001 260.614014)(-39.661900 -50.334801 261.242981)(-42.663002 -47.998001 260.614014)(-36.688000 -52.706001 260.614014)(-25.313299 -58.982399 261.536011)(-30.997398 -55.841698 261.182007)(-25.326000 -59.012001 260.614014)(-30.997398 -55.841698 261.182007)(-36.688000 -52.706001 260.614014)(-25.326000 -59.012001 260.614014)(-36.688000 -52.706001 260.614014)(-30.997398 -55.841698 261.182007)(-36.255600 -52.900799 261.751007)(-36.255600 -52.900799 261.751007)(-36.665100 -52.673199 261.759003)(-36.688000 -52.706001 260.614014)(-36.665100 -52.673199 261.759003)(-39.661900 -50.334801 261.242981)(-36.688000 -52.706001 260.614014)(-42.395500 -48.153004 261.871002)(-39.661900 -50.334801 261.242981)(-36.665100 -52.673199 261.759003)(-94.406998 -68.487999 262.893005)(-42.395500 -48.153004 261.871002)(-36.665100 -52.673199 261.759003)(-42.395500 -48.153004 261.871002)(-42.663002 -47.998001 260.614014)(-39.661900 -50.334801 261.242981)(-34.432999 -125.957001 283.257996)(-34.432999 -118.450996 255.246994)(-32.311996 -126.673996 253.042999)(41.959400 -56.295303 545.449036)(68.405998 -43.556000 546.675049)(41.959202 -53.446301 545.358032)(61.184002 88.436996 534.910950)(67.601006 95.750999 529.524048)(54.766899 88.597496 535.143982)(64.392502 88.356804 534.793945)(67.601006 95.750999 529.524048)(61.184002 88.436996 534.910950)(-42.663002 47.998001 260.614014)(-46.547001 44.241997 260.614014)(-44.588802 46.103203 261.283020)(-46.513199 44.209801 261.952026)(-44.588802 46.103203 261.283020)(-46.547001 44.241997 260.614014)(-42.789501 47.814297 261.878998)(-44.588802 46.103203 261.283020)(-46.513199 44.209801 261.952026)(-63.481003 9.720000 260.614014)(-63.423298 9.711161 262.283997)(-61.824402 16.002699 261.449005)(-63.481003 9.720000 260.614014)(-61.824402 16.002699 261.449005)(-60.223999 22.299999 260.614014)(-61.824402 16.002699 261.449005)(-60.337601 21.638199 262.223999)(-60.223999 22.299999 260.614014)(-60.223999 22.299999 260.614014)(-60.171398 22.280499 262.221008)(-57.337399 28.120701 261.416992)(-60.223999 22.299999 260.614014)(-60.337601 21.638199 262.223999)(-60.171398 22.280499 262.221008)(-57.337399 28.120701 261.416992)(-60.171398 22.280499 262.221008)(-56.438499 29.895500 262.147003)(-56.438499 29.895500 262.147003)(-60.171398 22.280499 262.221008)(-94.406998 68.487999 262.893005)(-57.337399 28.120701 261.416992)(-56.438499 29.895500 262.147003)(-54.500999 33.966000 260.614014)(-56.438499 29.895500 262.147003)(-94.406998 68.487999 262.893005)(-54.728798 33.383400 262.113983)(-46.852303 43.771301 261.958984)(-94.406998 68.487999 262.893005)(-46.513199 44.209801 261.952026)(-54.456699 33.938400 262.108002)(-94.406998 68.487999 262.893005)(-46.852303 43.771301 261.958984)(-54.728798 33.383400 262.113983)(-94.406998 68.487999 262.893005)(-54.456699 33.938400 262.108002)(-46.513199 44.209801 261.952026)(-94.406998 68.487999 262.893005)(-42.789501 47.814297 261.878998)(-46.547001 44.241997 260.614014)(-46.852303 43.771301 261.958984)(-46.513199 44.209801 261.952026)(-54.500999 33.966000 260.614014)(-54.728798 33.383400 262.113983)(-54.456699 33.938400 262.108002)(-54.500999 33.966000 260.614014)(-50.503498 39.088100 261.360992)(-46.547001 44.241997 260.614014)(-54.500999 33.966000 260.614014)(-54.456699 33.938400 262.108002)(-50.503498 39.088100 261.360992)(-50.503498 39.088100 261.360992)(-46.852303 43.771301 261.958984)(-46.547001 44.241997 260.614014)(-46.852303 43.771301 261.958984)(-50.503498 39.088100 261.360992)(-54.456699 33.938400 262.108002)(81.290001 0.000000 456.649017)(80.550095 -16.699800 464.500000)(80.539803 -16.924101 464.500000)(80.452103 -33.286999 464.584991)(80.633003 -33.959000 464.670990)(80.219299 -33.286999 464.584991)(80.452103 -33.286999 464.584991)(80.219299 -33.286999 464.584991)(80.684998 -32.614998 464.500000)(80.684998 -32.614998 464.500000)(80.219299 -33.286999 464.584991)(80.247299 -32.951000 464.543030)(80.633003 -33.959000 464.670990)(80.452103 -33.286999 464.584991)(80.684998 -32.614998 464.500000)(80.247299 -32.951000 464.543030)(80.219299 -33.286999 464.584991)(79.809601 -32.731998 464.515015)(83.979004 -27.179001 471.576996)(80.832001 -27.179001 464.500000)(81.124001 -16.306999 464.500000)(80.832001 -27.179001 464.500000)(83.979004 -27.179001 471.576996)(80.684998 -32.614998 464.500000)(80.832001 -27.179001 464.500000)(80.595001 -21.743000 464.500000)(81.124001 -16.306999 464.500000)(80.323502 -29.897001 464.500000)(80.832001 -27.179001 464.500000)(80.684998 -32.614998 464.500000)(80.323502 -29.897001 464.500000)(80.046600 -27.599699 464.500000)(80.832001 -27.179001 464.500000)(80.046600 -27.599699 464.500000)(80.066101 -27.179001 464.500000)(80.832001 -27.179001 464.500000)(81.290001 0.000000 456.649017)(80.066101 -27.179001 464.500000)(80.046600 -27.599699 464.500000)(81.290001 0.000000 456.649017)(80.046600 -27.599699 464.500000)(79.815002 -32.614998 464.500000)(81.290001 0.000000 456.649017)(79.815002 -32.614998 464.500000)(77.800995 -75.124001 452.000000)(81.290001 0.000000 456.649017)(77.800995 -75.124001 452.000000)(81.288498 0.000000 456.497986)(79.815002 -32.614998 464.500000)(79.809601 -32.731998 464.515015)(77.800995 -75.124001 452.000000)(79.809601 -32.731998 464.515015)(79.753601 -33.959000 464.670990)(77.800995 -75.124001 452.000000)(80.684998 -32.614998 464.500000)(79.809601 -32.731998 464.515015)(79.815002 -32.614998 464.500000)(80.832001 -27.179001 464.500000)(80.066101 -27.179001 464.500000)(80.595001 -21.743000 464.500000)(80.539803 -16.924101 464.500000)(80.595001 -21.743000 464.500000)(80.066101 -27.179001 464.500000)(80.219299 -33.286999 464.584991)(79.753601 -33.959000 464.670990)(79.809601 -32.731998 464.515015)(81.290001 0.000000 456.649017)(80.539803 -16.924101 464.500000)(80.066101 -27.179001 464.500000)(77.800995 -71.921997 436.239014)(81.288498 0.000000 456.497986)(77.800995 -75.124001 452.000000)(72.701996 -82.625000 415.539001)(77.800995 -75.124001 452.000000)(72.708000 -90.958000 452.000000)(72.708000 -90.958000 452.000000)(67.601006 -106.838005 452.000000)(72.701996 -82.625000 415.539001)(72.701996 -82.625000 415.539001)(77.800995 -71.921997 436.239014)(77.800995 -75.124001 452.000000)(77.800995 -68.164993 419.658020)(81.286697 0.000000 456.321014)(77.800995 -71.921997 436.239014)(81.288498 0.000000 456.497986)(77.800995 -71.921997 436.239014)(81.286697 0.000000 456.321014)(77.800995 71.921997 436.239014)(81.288498 0.000000 456.497986)(81.286697 0.000000 456.321014)(77.800995 -71.921997 436.239014)(72.701996 -82.625000 415.539001)(77.800995 -68.164993 419.658020)(81.275597 0.000000 455.844025)(81.286697 0.000000 456.321014)(77.800995 -68.164993 419.658020)(77.800995 68.164993 419.658020)(81.286697 0.000000 456.321014)(81.275597 0.000000 455.844025)(81.275597 0.000000 455.844025)(77.800995 -68.164993 419.658020)(77.800995 -51.714001 392.269989)(77.800995 0.000000 381.000000)(78.641403 0.000000 389.551025)(77.800995 -21.837999 381.958984)(78.641403 0.000000 389.551025)(78.978004 -15.835000 395.385010)(77.800995 -21.837999 381.958984)(74.368095 0.000000 374.716003)(77.800995 0.000000 381.000000)(77.800995 -21.837999 381.958984)(77.800995 21.837999 381.958984)(78.641403 0.000000 389.551025)(77.800995 0.000000 381.000000)(77.800995 21.837999 381.958984)(78.978004 15.835000 395.385010)(78.641403 0.000000 389.551025)(78.978004 15.835000 395.385010)(78.650101 0.000000 389.654999)(78.641403 0.000000 389.551025)(81.224098 0.000000 454.131989)(77.800995 51.714001 392.269989)(81.275597 0.000000 455.844025)(81.275597 0.000000 455.844025)(77.800995 -51.714001 392.269989)(81.224098 0.000000 454.131989)(78.978004 15.835000 395.385010)(77.800995 51.714001 392.269989)(81.224098 0.000000 454.131989)(78.978004 15.835000 395.385010)(79.367897 0.000000 399.118988)(78.650101 0.000000 389.654999)(78.650101 0.000000 389.654999)(79.367897 0.000000 399.118988)(78.978004 -15.835000 395.385010)(79.367897 0.000000 399.118988)(81.224098 0.000000 454.131989)(78.978004 -15.835000 395.385010)(81.224098 0.000000 454.131989)(79.367897 0.000000 399.118988)(78.978004 15.835000 395.385010)(78.641403 0.000000 389.551025)(78.650101 0.000000 389.654999)(78.978004 -15.835000 395.385010)(77.800995 71.921997 436.239014)(77.800995 75.124001 452.000000)(81.288498 0.000000 456.497986)(77.800995 75.124001 452.000000)(77.800995 71.921997 436.239014)(72.701996 82.625000 415.539001)(77.800995 -51.714001 392.269989)(78.978004 -15.835000 395.385010)(81.224098 0.000000 454.131989)(77.800995 -51.714001 392.269989)(77.800995 -21.837999 381.958984)(78.978004 -15.835000 395.385010)(72.701996 -27.146000 373.149017)(77.800995 -51.714001 392.269989)(72.701996 -62.891998 384.640015)(72.701996 -27.146000 373.149017)(77.800995 -21.837999 381.958984)(77.800995 -51.714001 392.269989)(72.714005 -96.683998 488.843994)(72.708000 -90.958000 452.000000)(77.800995 -75.124001 452.000000)(79.280304 -45.054996 474.428009)(79.283104 -44.979599 474.265991)(80.111000 -45.054996 474.428009)(79.280304 -45.054996 474.428009)(77.800995 -75.124001 452.000000)(79.283104 -44.979599 474.265991)(79.168701 -45.203999 483.036987)(79.960007 -45.203999 483.036987)(79.557396 -44.698498 484.290985)(79.960007 -45.203999 483.036987)(79.934998 -44.193001 485.545990)(79.557396 -44.698498 484.290985)(79.168701 -45.203999 483.036987)(79.557396 -44.698498 484.290985)(79.154701 -44.272099 485.350006)(79.168701 -45.203999 483.036987)(79.171600 -45.227699 482.852997)(79.960007 -45.203999 483.036987)(79.205299 -45.503002 480.707001)(79.171600 -45.227699 482.852997)(78.432899 -56.746899 499.244019)(79.171600 -45.227699 482.852997)(79.168701 -45.203999 483.036987)(78.432899 -56.746899 499.244019)(79.207504 -45.520298 480.571991)(79.205299 -45.503002 480.707001)(78.432899 -56.746899 499.244019)(79.205299 -45.503002 480.707001)(79.207504 -45.520298 480.571991)(79.994003 -45.503002 480.707001)(79.207504 -45.520298 480.571991)(79.613205 -45.612499 479.853973)(79.994003 -45.503002 480.707001)(79.207504 -45.520298 480.571991)(77.800995 -78.636993 492.308990)(79.232201 -45.722000 479.000000)(79.232201 -45.722000 479.000000)(79.613205 -45.612499 479.853973)(79.207504 -45.520298 480.571991)(79.232201 -45.722000 479.000000)(80.018997 -45.722000 479.000000)(79.613205 -45.612499 479.853973)(79.241295 -45.669601 478.640991)(79.272102 -45.492599 477.427979)(80.018997 -45.722000 479.000000)(79.272102 -45.492599 477.427979)(79.676201 -45.388500 476.713989)(80.018997 -45.722000 479.000000)(80.111000 -45.054996 474.428009)(80.167000 -44.149002 472.476990)(80.018997 -45.722000 479.000000)(79.676201 -45.388500 476.713989)(80.111000 -45.054996 474.428009)(80.018997 -45.722000 479.000000)(79.232201 -45.722000 479.000000)(79.241295 -45.669601 478.640991)(80.018997 -45.722000 479.000000)(79.272102 -45.492599 477.427979)(79.241295 -45.669601 478.640991)(77.800995 -78.636993 492.308990)(80.018997 -45.722000 479.000000)(79.994003 -45.503002 480.707001)(79.613205 -45.612499 479.853973)(79.994003 -45.503002 480.707001)(79.960007 -45.203999 483.036987)(79.582802 -45.353497 481.871979)(79.994003 -45.503002 480.707001)(80.756996 -44.300999 482.371979)(79.960007 -45.203999 483.036987)(79.994003 -45.503002 480.707001)(80.018997 -45.722000 479.000000)(80.756996 -44.300999 482.371979)(79.280304 -45.054996 474.428009)(79.676201 -45.388500 476.713989)(79.272102 -45.492599 477.427979)(79.280304 -45.054996 474.428009)(79.272102 -45.492599 477.427979)(77.800995 -75.124001 452.000000)(79.241295 -45.669601 478.640991)(79.232201 -45.722000 479.000000)(77.800995 -78.636993 492.308990)(77.800995 -75.124001 452.000000)(79.272102 -45.492599 477.427979)(77.800995 -78.636993 492.308990)(77.800995 -78.636993 492.308990)(72.714005 -96.683998 488.843994)(77.800995 -75.124001 452.000000)(77.800995 -62.127998 521.060974)(72.714005 -96.683998 488.843994)(77.800995 -78.636993 492.308990)(77.800995 -62.127998 521.060974)(72.714005 -82.199997 522.572998)(72.714005 -96.683998 488.843994)(84.889999 27.179001 479.101013)(84.765907 0.000000 479.118988)(84.006798 0.000000 471.638000)(67.601006 72.328003 542.781982)(41.952099 75.767197 542.196960)(41.956997 65.602196 544.356995)(-58.770599 72.124001 278.677002)(-58.876102 73.665703 286.773010)(-58.339001 79.063202 295.000000)(-61.307003 75.464706 295.000000)(-60.119099 75.463501 295.000000)(-58.876102 73.665703 286.773010)(41.824699 -113.646004 483.968994)(67.601006 -112.671005 480.468018)(67.601006 -113.523994 488.196991)(80.894905 -6.929690 464.500000)(80.939102 -0.523865 464.500000)(81.264900 -0.000000 464.500000)(80.939102 -0.523865 464.500000)(80.894905 -6.929690 464.500000)(81.283302 0.000000 457.399017)(80.939102 0.523865 464.500000)(80.939102 -0.523865 464.500000)(81.283302 0.000000 457.399017)(72.714005 96.683998 488.843994)(72.708000 90.958000 452.000000)(67.601006 106.838005 452.000000)(72.701996 82.625000 415.539001)(67.601006 106.838005 452.000000)(72.708000 90.958000 452.000000)(-9.491710 -77.874603 295.000000)(-3.418010 -76.742004 266.421997)(-9.366880 -70.952202 267.973999)(43.163300 113.523003 495.692017)(44.020298 113.420998 497.148987)(55.382198 113.355003 494.760986)(79.952003 36.598000 492.841003)(79.282295 36.327900 492.884979)(79.329102 34.866096 493.126007)(79.655701 34.596500 493.169983)(79.952003 36.598000 492.841003)(79.329102 34.866096 493.126007)(80.939102 -0.523865 464.500000)(80.939102 0.523865 464.500000)(81.101997 -0.000000 464.500000)(81.101997 -0.000000 464.500000)(81.264900 -0.000000 464.500000)(80.939102 0.523865 464.500000)(81.101997 -0.000000 464.500000)(80.939102 -0.523865 464.500000)(81.264900 -0.000000 464.500000)(80.914497 8.153500 464.500000)(81.264900 -0.000000 464.500000)(80.894905 6.929690 464.500000)(80.894905 6.929690 464.500000)(81.264900 -0.000000 464.500000)(80.939102 0.523865 464.500000)(79.207504 -45.520298 480.571991)(78.432899 -56.746899 499.244019)(77.800995 -78.636993 492.308990)(7.256990 81.315002 265.195984)(11.373000 89.879997 292.923981)(7.256990 88.820999 293.208008)(-124.982994 72.045998 355.863983)(-118.275002 79.184006 356.402008)(-124.130005 67.465996 333.440979)(41.912899 -101.700996 524.294006)(41.909698 -102.618004 522.785034)(67.601006 -101.744003 523.383972)(81.124001 16.306999 464.500000)(81.264900 -0.000000 464.500000)(80.914497 8.153500 464.500000)(-54.500999 33.966000 260.614014)(-56.438499 29.895500 262.147003)(-54.728798 33.383400 262.113983)(45.805000 -90.896004 387.692993)(45.859001 -90.318001 382.876984)(59.000999 -91.572998 395.704010)(77.800995 -62.127998 521.060974)(79.329102 -34.866096 493.126007)(78.471199 -31.063999 511.557983)(11.373000 82.374001 264.912018)(7.256990 81.315002 265.195984)(-34.432999 118.450996 255.246994)(-58.753300 71.872101 277.354004)(-58.339001 71.764000 267.755981)(-58.633900 70.127800 268.194000)(-42.789501 47.814297 261.878998)(-42.663002 47.998001 260.614014)(-44.588802 46.103203 261.283020)(80.374001 -40.141998 467.152008)(79.963402 -39.383499 466.601990)(80.443001 -38.625000 466.051025)(80.232002 -43.105000 470.230988)(82.525002 -40.196999 472.917999)(80.167000 -44.149002 472.476990)(79.774796 -43.627003 471.354004)(80.232002 -43.105000 470.230988)(80.167000 -44.149002 472.476990)(79.353493 -43.105000 470.230988)(80.232002 -43.105000 470.230988)(79.774796 -43.627003 471.354004)(79.353493 -43.105000 470.230988)(79.774796 -43.627003 471.354004)(79.317596 -44.059700 472.285004)(79.317596 -44.059700 472.285004)(79.774796 -43.627003 471.354004)(80.167000 -44.149002 472.476990)(79.314301 -44.149002 472.476990)(79.317596 -44.059700 472.285004)(80.167000 -44.149002 472.476990)(79.314301 -44.149002 472.476990)(77.800995 -75.124001 452.000000)(79.317596 -44.059700 472.285004)(54.766899 -88.597496 535.143982)(41.939301 -87.826401 536.362000)(41.933102 -91.898705 533.554016)(67.601006 104.222000 440.570007)(67.601006 101.487000 429.165985)(42.858997 103.848999 437.105011)(52.407299 36.600101 261.884979)(50.507099 39.090099 261.266998)(46.814201 43.831501 261.786987)(46.548000 44.241997 260.614014)(46.814201 43.831501 261.786987)(50.507099 39.090099 261.266998)(46.548000 44.241997 260.614014)(50.507099 39.090099 261.266998)(54.501999 33.966000 260.614014)(41.411198 76.998001 295.000000)(47.652699 75.137901 295.000000)(48.129997 68.846001 261.809998)(47.652699 75.137901 295.000000)(49.063000 75.113701 295.000000)(48.129997 68.846001 261.809998)(41.411198 76.998001 295.000000)(48.129997 68.846001 261.809998)(41.338203 67.909004 261.691986)(46.548000 44.241997 260.614014)(41.335800 48.715599 260.602997)(43.928703 46.463699 261.198029)(46.208698 44.480000 261.776001)(46.548000 44.241997 260.614014)(43.928703 46.463699 261.198029)(43.928703 46.463699 261.198029)(41.335800 48.715599 260.602997)(41.338203 48.664803 261.691986)(46.208698 44.480000 261.776001)(43.928703 46.463699 261.198029)(41.338203 48.664803 261.691986)(46.208698 44.480000 261.776001)(41.338203 48.664803 261.691986)(44.734100 56.662998 261.751007)(44.734100 56.662998 261.751007)(41.338203 48.664803 261.691986)(41.338203 67.909004 261.691986)(46.208698 44.480000 261.776001)(44.734100 56.662998 261.751007)(48.129997 68.846001 261.809998)(41.336601 59.515900 260.958984)(41.338203 48.664803 261.691986)(41.335800 48.715599 260.602997)(41.335003 70.367004 260.226990)(41.411198 76.998001 295.000000)(41.338203 67.909004 261.691986)(41.336601 59.515900 260.958984)(41.335003 70.367004 260.226990)(41.338203 67.909004 261.691986)(41.335800 48.715599 260.602997)(41.335003 70.367004 260.226990)(41.336601 59.515900 260.958984)(41.335003 70.367004 260.226990)(41.335800 48.715599 260.602997)(41.335003 48.699100 260.226990)(41.335003 48.699100 260.226990)(36.775700 52.616997 260.316986)(41.335003 70.367004 260.226990)(28.827499 76.776695 295.000000)(41.335003 70.367004 260.226990)(-10.356000 76.087494 295.000000)(-9.366880 70.952202 267.973999)(-10.356000 76.087494 295.000000)(41.335003 70.367004 260.226990)(46.208698 44.480000 261.776001)(46.518402 44.213898 261.781982)(46.548000 44.241997 260.614014)(36.775700 52.616997 260.316986)(36.682098 52.697498 260.318024)(41.335003 70.367004 260.226990)(44.734100 56.662998 261.751007)(41.338203 67.909004 261.691986)(48.129997 68.846001 261.809998)(-25.313299 58.982399 261.536011)(-24.953701 59.095497 261.528992)(-25.326000 59.012001 260.614014)(-44.588802 -46.103203 261.283020)(-46.547001 -44.241997 260.614014)(-42.663002 -47.998001 260.614014)(-42.789501 -47.814297 261.878998)(-44.588802 -46.103203 261.283020)(-42.663002 -47.998001 260.614014)(-46.547001 -44.241997 260.614014)(-46.513199 -44.209801 261.952026)(-46.852303 -43.771301 261.958984)(-46.513199 -44.209801 261.952026)(-94.406998 -68.487999 262.893005)(-46.852303 -43.771301 261.958984)(-46.513199 -44.209801 261.952026)(-44.588802 -46.103203 261.283020)(-42.789501 -47.814297 261.878998)(-94.406998 -68.487999 262.893005)(-46.513199 -44.209801 261.952026)(-42.789501 -47.814297 261.878998)(-46.513199 -44.209801 261.952026)(-46.547001 -44.241997 260.614014)(-44.588802 -46.103203 261.283020)(79.146400 43.719898 486.720001)(79.534698 43.808201 486.501007)(79.540703 43.936497 486.182983)(79.146400 43.719898 486.720001)(79.540703 43.936497 486.182983)(79.153503 44.193001 485.545990)(-0.000012 64.202194 261.039001)(-12.647201 62.908001 261.287018)(-94.406998 68.487999 262.893005)(75.193001 -13.573000 376.886017)(74.368095 0.000000 374.716003)(77.800995 -21.837999 381.958984)(59.000999 35.831001 364.783997)(66.028999 22.513000 339.349976)(59.000999 39.448997 354.901001)(66.028999 22.513000 339.349976)(59.000999 35.831001 364.783997)(61.535999 28.941999 363.698975)(63.235001 22.982000 362.966003)(61.535999 28.941999 363.698975)(67.601006 63.148998 371.933990)(61.535999 28.941999 363.698975)(63.235001 22.982000 362.966003)(66.028999 22.513000 339.349976)(66.028999 22.513000 339.349976)(63.235001 22.982000 362.966003)(64.200996 18.559999 362.567017)(61.535999 28.941999 363.698975)(59.000999 35.831001 364.783997)(67.601006 63.148998 371.933990)(67.601006 24.057001 363.636993)(63.235001 22.982000 362.966003)(67.601006 63.148998 371.933990)(64.200996 18.559999 362.567017)(63.235001 22.982000 362.966003)(67.601006 24.057001 363.636993)(67.601006 63.148998 371.933990)(59.000999 35.831001 364.783997)(59.000999 63.197002 371.791016)(67.601006 63.148998 371.933990)(59.000999 63.197002 371.791016)(67.601006 72.706001 376.436005)(59.000999 -39.448997 354.901001)(59.000999 -35.831001 364.783997)(59.000999 -63.197002 371.791016)(59.000999 -39.448997 354.901001)(66.028999 -22.513000 339.349976)(59.000999 -35.831001 364.783997)(67.504005 -25.653002 313.793976)(66.028999 -22.513000 339.349976)(59.000999 -44.068001 339.895020)(59.000999 -44.068001 339.895020)(66.028999 -22.513000 339.349976)(59.000999 -42.695000 344.901001)(66.028999 -22.513000 339.349976)(59.000999 -39.448997 354.901001)(59.000999 -42.695000 344.901001)(66.028999 -22.513000 339.349976)(67.504005 -25.653002 313.793976)(71.083099 0.000000 313.239990)(59.000999 -42.695000 344.901001)(59.000999 -63.197002 371.791016)(59.000999 -44.068001 339.895020)(59.000999 -39.448997 354.901001)(59.000999 -63.197002 371.791016)(59.000999 -42.695000 344.901001)(59.000999 -44.068001 339.895020)(59.000999 -46.861000 329.708008)(67.504005 -25.653002 313.793976)(59.000999 -50.173000 314.332977)(59.000999 -46.861000 329.708008)(59.000999 -63.197002 371.791016)(67.504005 -25.653002 313.793976)(59.000999 -46.861000 329.708008)(59.000999 -50.173000 314.332977)(59.000999 -63.197002 371.791016)(59.000999 -46.861000 329.708008)(59.000999 -44.068001 339.895020)(68.569000 -27.600000 287.979980)(67.504005 -25.653002 313.793976)(59.000999 -50.173000 314.332977)(59.000000 -54.230000 283.061005)(59.000000 -53.697002 288.311005)(59.000000 -68.695000 262.000000)(59.000000 -68.695000 262.000000)(59.000000 -53.697002 288.311005)(59.000999 -52.636002 298.752014)(59.000000 -53.697002 288.311005)(68.569000 -27.600000 287.979980)(59.000999 -52.636002 298.752014)(59.000000 -68.695000 262.000000)(59.000999 -52.636002 298.752014)(59.000999 -72.435997 375.942993)(59.000999 -52.636002 298.752014)(68.569000 -27.600000 287.979980)(59.000999 -50.173000 314.332977)(68.569000 -27.600000 287.979980)(72.301094 0.000000 287.640991)(67.504005 -25.653002 313.793976)(72.301498 0.000000 287.631989)(72.301094 0.000000 287.640991)(68.569000 -27.600000 287.979980)(71.442001 -17.107000 262.216980)(72.301498 0.000000 287.631989)(68.569000 -27.600000 287.979980)(59.000000 -54.230000 283.061005)(68.569000 -27.600000 287.979980)(59.000000 -53.697002 288.311005)(68.569000 -27.600000 287.979980)(59.000000 -54.230000 283.061005)(59.000000 -54.806999 272.545990)(59.000999 -89.418999 377.466003)(59.000000 -68.695000 262.000000)(59.000999 -72.435997 375.942993)(68.948997 -28.271000 262.174011)(71.442001 -17.107000 262.216980)(68.569000 -27.600000 287.979980)(63.761799 -30.413801 262.083008)(60.324402 -21.720699 262.023010)(61.755299 -16.190599 262.048004)(61.828899 -16.003599 261.346008)(61.755299 -16.190599 262.048004)(60.324402 -21.720699 262.023010)(60.224998 -22.299999 260.614014)(60.178898 -22.282900 262.020996)(59.820599 -23.013800 262.014008)(60.224998 -22.299999 260.614014)(60.324402 -21.720699 262.023010)(60.178898 -22.282900 262.020996)(60.224998 -22.299999 260.614014)(61.828899 -16.003599 261.346008)(60.324402 -21.720699 262.023010)(63.761799 -30.413801 262.083008)(59.820599 -23.013800 262.014008)(60.178898 -22.282900 262.020996)(60.224998 -22.299999 260.614014)(59.820599 -23.013800 262.014008)(59.133999 -24.414499 262.001984)(63.868999 -44.636997 262.084991)(59.133999 -24.414499 262.001984)(59.820599 -23.013800 262.014008)(59.000000 -54.994999 262.000000)(54.701099 -33.456799 261.925018)(55.011200 -32.824100 261.929993)(54.501999 -33.966000 260.614014)(55.011200 -32.824100 261.929993)(54.701099 -33.456799 261.925018)(54.501999 -33.966000 260.614014)(54.701099 -33.456799 261.925018)(54.463303 -33.941898 261.920990)(54.501999 -33.966000 260.614014)(55.086201 -32.671299 261.931976)(55.011200 -32.824100 261.929993)(57.341602 -28.122200 261.317017)(58.761898 -25.173399 261.996002)(56.077801 -30.648500 261.949005)(57.341602 -28.122200 261.317017)(56.077801 -30.648500 261.949005)(54.501999 -33.966000 260.614014)(60.224998 -22.299999 260.614014)(57.341602 -28.122200 261.317017)(54.501999 -33.966000 260.614014)(56.077801 -30.648500 261.949005)(55.086201 -32.671299 261.931976)(54.501999 -33.966000 260.614014)(59.973400 -40.084202 262.016998)(56.077801 -30.648500 261.949005)(58.761898 -25.173399 261.996002)(59.000000 -54.994999 262.000000)(56.077801 -30.648500 261.949005)(59.973400 -40.084202 262.016998)(60.224998 -22.299999 260.614014)(58.761898 -25.173399 261.996002)(57.341602 -28.122200 261.317017)(60.224998 -22.299999 260.614014)(59.133999 -24.414499 262.001984)(58.761898 -25.173399 261.996002)(63.868999 -44.636997 262.084991)(59.973400 -40.084202 262.016998)(58.761898 -25.173399 261.996002)(59.000000 -54.994999 262.000000)(55.086201 -32.671299 261.931976)(56.077801 -30.648500 261.949005)(63.868999 -44.636997 262.084991)(59.820599 -23.013800 262.014008)(63.761799 -30.413801 262.083008)(68.569000 -27.600000 287.979980)(67.703003 -33.854000 262.151978)(68.948997 -28.271000 262.174011)(63.868999 -44.636997 262.084991)(67.703003 -33.854000 262.151978)(68.569000 -27.600000 287.979980)(63.868999 -44.636997 262.084991)(68.569000 -27.600000 287.979980)(59.000000 -54.994999 262.000000)(63.868999 -44.636997 262.084991)(63.761799 -30.413801 262.083008)(67.703003 -33.854000 262.151978)(72.701996 82.625000 415.539001)(67.601006 72.706001 376.436005)(67.601006 77.644997 379.588989)(72.701996 82.625000 415.539001)(72.701996 62.891998 384.640015)(67.601006 72.706001 376.436005)(67.601006 77.644997 379.588989)(67.601006 72.706001 376.436005)(59.000999 72.435997 375.942993)(69.753494 36.353001 373.369995)(67.601006 72.706001 376.436005)(72.701996 62.891998 384.640015)(67.601006 72.706001 376.436005)(59.000999 63.197002 371.791016)(59.000999 72.435997 375.942993)(59.000999 72.435997 375.942993)(59.000999 63.197002 371.791016)(59.000999 52.636002 298.752014)(72.301094 0.000000 287.640991)(68.569000 27.600000 287.979980)(67.504005 25.653002 313.793976)(68.569000 27.600000 287.979980)(59.000999 50.173000 314.332977)(67.504005 25.653002 313.793976)(59.000999 52.636002 298.752014)(68.569000 27.600000 287.979980)(59.000000 53.697002 288.311005)(68.569000 27.600000 287.979980)(59.000999 52.636002 298.752014)(59.000999 50.173000 314.332977)(59.000999 63.197002 371.791016)(59.000999 50.173000 314.332977)(59.000999 52.636002 298.752014)(69.753494 36.353001 373.369995)(72.701996 62.891998 384.640015)(67.601196 0.000000 361.701019)(72.701996 27.146000 373.149017)(75.193001 13.573000 376.886017)(72.701996 0.000000 371.746979)(75.193001 13.573000 376.886017)(74.368095 0.000000 374.716003)(72.701996 0.000000 371.746979)(75.193001 13.573000 376.886017)(77.800995 21.837999 381.958984)(74.368095 0.000000 374.716003)(72.701996 0.000000 371.746979)(74.368095 0.000000 374.716003)(75.193001 -13.573000 376.886017)(72.701996 0.000000 371.746979)(75.193001 -13.573000 376.886017)(72.701996 -27.146000 373.149017)(72.701996 27.146000 373.149017)(77.800995 21.837999 381.958984)(75.193001 13.573000 376.886017)(67.601196 0.000000 361.701019)(72.701996 0.000000 371.746979)(72.701996 -27.146000 373.149017)(77.800995 21.837999 381.958984)(72.701996 27.146000 373.149017)(77.800995 51.714001 392.269989)(72.701996 62.891998 384.640015)(77.800995 51.714001 392.269989)(72.701996 27.146000 373.149017)(72.701996 62.891998 384.640015)(72.701996 27.146000 373.149017)(67.601196 0.000000 361.701019)(72.701996 62.891998 384.640015)(72.701996 82.625000 415.539001)(77.800995 68.164993 419.658020)(59.000000 54.230000 283.061005)(59.000000 53.697002 288.311005)(68.569000 27.600000 287.979980)(54.501999 33.966000 260.614014)(55.086201 32.671299 261.931976)(56.077801 30.648500 261.949005)(54.501999 33.966000 260.614014)(55.011200 32.824100 261.929993)(55.086201 32.671299 261.931976)(54.501999 33.966000 260.614014)(54.701099 33.456799 261.925018)(55.011200 32.824100 261.929993)(54.501999 33.966000 260.614014)(54.463303 33.941898 261.920990)(54.701099 33.456799 261.925018)(55.011200 32.824100 261.929993)(54.701099 33.456799 261.925018)(59.000000 54.994999 262.000000)(59.000000 54.994999 262.000000)(55.086201 32.671299 261.931976)(55.011200 32.824100 261.929993)(56.077801 30.648500 261.949005)(55.086201 32.671299 261.931976)(59.000000 54.994999 262.000000)(63.482002 9.720000 260.614014)(63.785397 3.229700 261.350983)(63.974796 0.000000 260.614014)(63.482002 9.720000 260.614014)(63.461998 9.109690 262.077972)(63.785397 3.229700 261.350983)(63.482002 9.720000 260.614014)(63.431503 9.712260 262.077972)(63.461998 9.109690 262.077972)(63.482002 9.720000 260.614014)(63.197701 10.615900 262.072998)(63.431503 9.712260 262.077972)(67.319801 -13.569201 262.145020)(63.431503 -9.712260 262.077972)(63.461998 -9.109690 262.077972)(67.319801 -13.569201 262.145020)(63.461998 -9.109690 262.077972)(64.238304 0.000000 262.091003)(63.197701 -10.615900 262.072998)(63.431503 -9.712260 262.077972)(67.319801 -13.569201 262.145020)(63.482002 -9.720000 260.614014)(63.431503 -9.712260 262.077972)(63.197701 -10.615900 262.072998)(65.601997 -22.568800 262.114990)(63.024902 -11.283500 262.070007)(68.948997 -28.271000 262.174011)(68.948997 -28.271000 262.174011)(63.024902 -11.283500 262.070007)(63.197701 -10.615900 262.072998)(63.482002 -9.720000 260.614014)(63.197701 -10.615900 262.072998)(63.024902 -11.283500 262.070007)(63.482002 -9.720000 260.614014)(63.024902 -11.283500 262.070007)(62.254898 -14.259600 262.057007)(63.482002 -9.720000 260.614014)(62.254898 -14.259600 262.057007)(61.828899 -16.003599 261.346008)(63.482002 -9.720000 260.614014)(63.461998 -9.109690 262.077972)(63.431503 -9.712260 262.077972)(63.461998 -9.109690 262.077972)(63.923599 0.000000 262.085999)(64.238304 0.000000 262.091003)(63.930199 0.000000 261.896027)(63.923599 0.000000 262.085999)(63.785397 -3.229700 261.350983)(63.961903 0.000000 260.984009)(63.930199 0.000000 261.896027)(63.785397 -3.229700 261.350983)(63.461998 -9.109690 262.077972)(63.785397 -3.229700 261.350983)(63.923599 0.000000 262.085999)(72.700600 0.000000 262.239014)(64.651497 0.000000 262.098022)(71.442001 17.107000 262.216980)(71.442001 -17.107000 262.216980)(64.651497 0.000000 262.098022)(72.700600 0.000000 262.239014)(71.442001 -17.107000 262.216980)(64.444305 0.000000 262.095001)(64.651497 0.000000 262.098022)(72.301498 0.000000 287.631989)(72.700600 0.000000 262.239014)(71.442001 17.107000 262.216980)(71.442001 -17.107000 262.216980)(67.319801 -13.569201 262.145020)(64.444305 0.000000 262.095001)(68.569000 27.600000 287.979980)(72.301498 0.000000 287.631989)(71.442001 17.107000 262.216980)(68.948997 -28.271000 262.174011)(67.319801 -13.569201 262.145020)(71.442001 -17.107000 262.216980)(64.651497 0.000000 262.098022)(64.444305 0.000000 262.095001)(71.442001 17.107000 262.216980)(64.238304 0.000000 262.091003)(63.923599 0.000000 262.085999)(63.461998 9.109690 262.077972)(64.238304 0.000000 262.091003)(63.461998 9.109690 262.077972)(67.319801 13.569201 262.145020)(63.923599 0.000000 262.085999)(63.785397 3.229700 261.350983)(63.461998 9.109690 262.077972)(64.444305 0.000000 262.095001)(64.238304 0.000000 262.091003)(67.319801 13.569201 262.145020)(64.444305 0.000000 262.095001)(67.319801 13.569201 262.145020)(71.442001 17.107000 262.216980)(71.442001 17.107000 262.216980)(67.319801 13.569201 262.145020)(68.948997 28.271000 262.174011)(63.961903 0.000000 260.984009)(63.785397 3.229700 261.350983)(63.930199 0.000000 261.896027)(67.319801 -13.569201 262.145020)(64.238304 0.000000 262.091003)(64.444305 0.000000 262.095001)(63.482002 -9.720000 260.614014)(63.785397 -3.229700 261.350983)(63.461998 -9.109690 262.077972)(63.974796 0.000000 260.614014)(63.785397 -3.229700 261.350983)(63.482002 -9.720000 260.614014)(58.761898 25.173399 261.996002)(57.341602 28.122200 261.317017)(56.077801 30.648500 261.949005)(57.341602 28.122200 261.317017)(58.761898 25.173399 261.996002)(60.224998 22.299999 260.614014)(58.761898 25.173399 261.996002)(59.133999 24.414499 262.001984)(60.224998 22.299999 260.614014)(59.133999 24.414499 262.001984)(58.761898 25.173399 261.996002)(63.868999 44.636997 262.084991)(60.178898 22.282900 262.020996)(59.820599 23.013800 262.014008)(63.761799 30.413801 262.083008)(63.761799 30.413801 262.083008)(59.820599 23.013800 262.014008)(63.868999 44.636997 262.084991)(67.703003 33.854000 262.151978)(63.761799 30.413801 262.083008)(63.868999 44.636997 262.084991)(68.569000 27.600000 287.979980)(67.703003 33.854000 262.151978)(63.868999 44.636997 262.084991)(63.868999 44.636997 262.084991)(59.973400 40.084202 262.016998)(59.000000 54.994999 262.000000)(59.973400 40.084202 262.016998)(56.077801 30.648500 261.949005)(59.000000 54.994999 262.000000)(63.868999 44.636997 262.084991)(59.000000 54.994999 262.000000)(68.569000 27.600000 287.979980)(59.000000 54.806999 272.545990)(68.569000 27.600000 287.979980)(59.000000 54.994999 262.000000)(59.000000 54.230000 283.061005)(68.569000 27.600000 287.979980)(59.000000 54.806999 272.545990)(68.569000 27.600000 287.979980)(68.948997 28.271000 262.174011)(67.703003 33.854000 262.151978)(59.820599 23.013800 262.014008)(59.133999 24.414499 262.001984)(63.868999 44.636997 262.084991)(59.000000 54.230000 283.061005)(59.000000 54.806999 272.545990)(59.000000 68.695000 262.000000)(54.501999 33.966000 260.614014)(57.341602 28.122200 261.317017)(60.224998 22.299999 260.614014)(58.761898 25.173399 261.996002)(59.973400 40.084202 262.016998)(63.868999 44.636997 262.084991)(71.442001 17.107000 262.216980)(68.948997 28.271000 262.174011)(68.569000 27.600000 287.979980)(67.319801 13.569201 262.145020)(63.197701 10.615900 262.072998)(68.948997 28.271000 262.174011)(63.461998 9.109690 262.077972)(63.431503 9.712260 262.077972)(67.319801 13.569201 262.145020)(67.601006 72.706001 376.436005)(67.601196 0.000000 361.701019)(67.601006 63.148998 371.933990)(63.868999 -44.636997 262.084991)(58.761898 -25.173399 261.996002)(59.133999 -24.414499 262.001984)(68.569000 -27.600000 287.979980)(59.000000 -54.806999 272.545990)(59.000000 -54.994999 262.000000)(79.153503 44.193001 485.545990)(78.432899 56.746899 499.244019)(79.146400 43.719898 486.720001)(72.301498 0.000000 287.631989)(68.569000 27.600000 287.979980)(72.301094 0.000000 287.640991)(-61.307003 77.163399 302.778992)(-76.641594 72.824501 282.835999)(-94.357002 73.585007 286.235016)(72.714005 10.359000 538.294983)(72.714005 0.000000 538.158997)(74.165901 0.000000 535.719971)(74.165901 0.000000 535.719971)(77.800400 0.000000 530.000000)(72.714005 10.359000 538.294983)(-45.139999 85.764999 264.003998)(-47.857002 91.569000 292.472015)(-45.139999 93.271004 292.015991)(79.145798 43.680000 486.819000)(79.534393 42.913002 487.942017)(79.922997 43.680000 486.819000)(55.723598 -0.000000 545.817017)(41.960796 0.000000 546.080994)(54.780899 -15.335300 546.146973)(54.701099 33.456799 261.925018)(54.463303 33.941898 261.920990)(59.000000 54.994999 262.000000)(54.463303 33.941898 261.920990)(53.674301 34.961998 261.907013)(59.000000 54.994999 262.000000)(59.000999 46.861000 329.708008)(67.504005 25.653002 313.793976)(59.000999 50.173000 314.332977)(59.000999 63.197002 371.791016)(59.000999 39.448997 354.901001)(59.000999 42.695000 344.901001)(59.000999 63.197002 371.791016)(59.000999 42.695000 344.901001)(59.000999 44.068001 339.895020)(59.000999 42.695000 344.901001)(66.028999 22.513000 339.349976)(59.000999 44.068001 339.895020)(59.000999 44.068001 339.895020)(66.028999 22.513000 339.349976)(67.504005 25.653002 313.793976)(67.504005 25.653002 313.793976)(59.000999 46.861000 329.708008)(59.000999 44.068001 339.895020)(79.934998 44.193001 485.545990)(79.922997 43.680000 486.819000)(80.756996 44.300999 482.371979)(55.723598 -0.000000 545.817017)(54.780899 15.335300 546.146973)(41.960796 0.000000 546.080994)(67.601006 30.676001 546.212952)(54.780899 15.335300 546.146973)(55.723598 -0.000000 545.817017)(-61.824402 16.002699 261.449005)(-63.423298 9.711161 262.283997)(-60.337601 21.638199 262.223999)(-54.500999 -33.966000 260.614014)(-56.438499 -29.895500 262.147003)(-57.337399 -28.120701 261.416992)(-54.500999 -33.966000 260.614014)(-57.337399 -28.120701 261.416992)(-60.223999 -22.299999 260.614014)(-54.500999 -33.966000 260.614014)(-54.456699 -33.938400 262.108002)(-54.728798 -33.383400 262.113983)(-54.456699 -33.938400 262.108002)(-94.406998 -68.487999 262.893005)(-54.728798 -33.383400 262.113983)(-54.728798 -33.383400 262.113983)(-94.406998 -68.487999 262.893005)(-56.438499 -29.895500 262.147003)(-56.438499 -29.895500 262.147003)(-94.406998 -68.487999 262.893005)(-60.171398 -22.280499 262.221008)(-50.503498 -39.088100 261.360992)(-54.456699 -33.938400 262.108002)(-54.500999 -33.966000 260.614014)(-50.503498 -39.088100 261.360992)(-46.852303 -43.771301 261.958984)(-54.456699 -33.938400 262.108002)(-60.171398 -22.280499 262.221008)(-94.406998 -68.487999 262.893005)(-60.337601 -21.638199 262.223999)(-60.223999 -22.299999 260.614014)(-60.171398 -22.280499 262.221008)(-60.337601 -21.638199 262.223999)(-60.223999 -22.299999 260.614014)(-60.337601 -21.638199 262.223999)(-61.824402 -16.002699 261.449005)(-60.223999 -22.299999 260.614014)(-61.824402 -16.002699 261.449005)(-63.481003 -9.720000 260.614014)(-63.481003 -9.720000 260.614014)(-61.824402 -16.002699 261.449005)(-63.423298 -9.711161 262.283997)(-60.337601 -21.638199 262.223999)(-94.406998 -68.487999 262.893005)(-63.423298 -9.711161 262.283997)(-63.423298 -9.711161 262.283997)(-94.406998 -68.487999 262.893005)(-63.458199 -9.023340 262.285004)(-63.458199 -9.023340 262.285004)(-94.406998 -68.487999 262.893005)(-65.456200 0.000000 262.324005)(-94.406998 -68.487999 262.893005)(-94.406998 0.000000 262.893005)(-65.456200 0.000000 262.324005)(-63.458199 -9.023340 262.285004)(-65.456200 0.000000 262.324005)(-63.915401 0.000000 262.294006)(-63.915401 0.000000 262.294006)(-65.456200 0.000000 262.324005)(-63.458199 9.023340 262.285004)(-63.458199 9.023340 262.285004)(-65.456200 0.000000 262.324005)(-94.406998 68.487999 262.893005)(-63.915401 0.000000 262.294006)(-63.780800 -3.229520 261.456024)(-63.458199 -9.023340 262.285004)(-57.337399 -28.120701 261.416992)(-60.171398 -22.280499 262.221008)(-60.223999 -22.299999 260.614014)(-63.423298 9.711161 262.283997)(-63.458199 9.023340 262.285004)(-94.406998 68.487999 262.893005)(-60.337601 21.638199 262.223999)(-63.423298 9.711161 262.283997)(-94.406998 68.487999 262.893005)(-61.824402 -16.002699 261.449005)(-60.337601 -21.638199 262.223999)(-63.423298 -9.711161 262.283997)(-54.728798 -33.383400 262.113983)(-56.438499 -29.895500 262.147003)(-54.500999 -33.966000 260.614014)(-63.929996 0.000000 261.875000)(-63.780800 -3.229520 261.456024)(-63.915401 0.000000 262.294006)(-63.929996 0.000000 261.875000)(-63.915401 0.000000 262.294006)(-63.780800 3.229520 261.456024)(-63.959099 0.000000 261.036987)(-63.929996 0.000000 261.875000)(-63.780800 3.229520 261.456024)(-63.973801 0.000000 260.614014)(-63.959099 0.000000 261.036987)(-63.780800 3.229520 261.456024)(-63.973801 0.000000 260.614014)(-63.780800 3.229520 261.456024)(-63.481003 9.720000 260.614014)(-63.959099 0.000000 261.036987)(-63.780800 -3.229520 261.456024)(-63.929996 0.000000 261.875000)(-63.780800 3.229520 261.456024)(-63.458199 9.023340 262.285004)(-63.481003 9.720000 260.614014)(-63.458199 9.023340 262.285004)(-63.780800 3.229520 261.456024)(-63.915401 0.000000 262.294006)(-65.456200 0.000000 262.324005)(-94.406998 0.000000 262.893005)(-94.406998 68.487999 262.893005)(-46.547001 -44.241997 260.614014)(-50.503498 -39.088100 261.360992)(-54.500999 -33.966000 260.614014)(45.693001 -89.557999 376.733002)(44.958000 -88.740997 370.332001)(59.000999 -89.418999 377.466003)(45.693001 -89.557999 376.733002)(59.000999 -89.418999 377.466003)(59.000999 -91.572998 395.704010)(59.000999 -85.778000 387.139008)(59.000999 -91.572998 395.704010)(59.000999 -89.418999 377.466003)(-58.203102 83.030594 334.000000)(-26.334999 87.259003 355.483002)(-39.445698 83.375198 334.000000)(-58.203102 83.030594 334.000000)(-58.542400 83.028801 334.000000)(-26.334999 87.259003 355.483002)(-94.357002 73.585007 286.235016)(-77.832001 76.204399 298.527985)(-61.307003 77.601700 305.225006)(-94.357002 73.585007 286.235016)(-94.341003 75.278999 293.992004)(-77.832001 76.204399 298.527985)(77.800995 75.124001 452.000000)(81.290001 0.000000 456.649017)(81.288498 0.000000 456.497986)(26.004999 91.485001 262.470978)(19.285002 86.037003 263.931000)(-32.311996 126.673996 253.042999)(68.948997 -28.271000 262.174011)(67.703003 -33.854000 262.151978)(65.601997 -22.568800 262.114990)(67.703003 -33.854000 262.151978)(62.254898 -14.259600 262.057007)(65.601997 -22.568800 262.114990)(67.703003 -33.854000 262.151978)(62.091103 -14.892700 262.053986)(62.254898 -14.259600 262.057007)(59.000000 -54.230000 283.061005)(59.000000 -68.695000 262.000000)(59.000000 -54.806999 272.545990)(79.153503 -44.193001 485.545990)(79.540703 -43.936497 486.182983)(79.146400 -43.719898 486.720001)(-16.759100 147.552994 262.769012)(-14.805000 152.445007 276.160004)(-14.805000 144.939011 248.147995)(81.072006 44.300999 479.023010)(80.756996 44.300999 482.371979)(83.160995 40.196999 479.069000)(77.800400 0.000000 530.000000)(79.476807 10.862000 493.500000)(78.569298 15.532000 511.746002)(77.800400 0.000000 530.000000)(78.569298 15.532000 511.746002)(78.471199 31.063999 511.557983)(77.800400 0.000000 530.000000)(78.471199 31.063999 511.557983)(77.800995 62.127998 521.060974)(45.693001 -89.557999 376.733002)(59.000999 -91.572998 395.704010)(45.859001 -90.318001 382.876984)(67.601006 95.750999 529.524048)(64.392502 88.356804 534.793945)(67.601006 80.802002 539.831970)(78.569298 15.532000 511.746002)(79.476807 10.862000 493.500000)(78.471199 31.063999 511.557983)(-3.418010 76.742004 266.421997)(-35.427002 98.872002 260.492004)(-34.164997 106.940002 258.329987)(64.392502 -88.356804 534.793945)(61.184002 -88.436996 534.910950)(67.601006 -95.750999 529.524048)(64.392502 -88.356804 534.793945)(67.601006 -80.802002 539.831970)(61.184002 -88.436996 534.910950)(67.601006 -80.802002 539.831970)(64.392502 -88.356804 534.793945)(67.601006 -95.750999 529.524048)(62.254898 -14.259600 262.057007)(62.091103 -14.892700 262.053986)(61.828899 -16.003599 261.346008)(52.500000 -82.378998 332.873993)(59.000000 -68.695000 262.000000)(52.500000 -82.581001 334.000000)(59.000000 -68.695000 262.000000)(52.500000 -82.378998 332.873993)(52.500000 -75.987099 297.262024)(79.934998 44.193001 485.545990)(79.544296 44.064701 485.864014)(79.544296 44.128899 485.704987)(79.934998 44.193001 485.545990)(79.153503 44.193001 485.545990)(79.544296 44.128899 485.704987)(79.544296 44.064701 485.864014)(79.544296 44.128899 485.704987)(79.153503 44.193001 485.545990)(81.291397 0.000000 457.002014)(81.283302 0.000000 457.399017)(80.894905 -6.929690 464.500000)(-61.307003 -78.823700 310.820007)(-94.341003 -75.278999 293.992004)(-77.832001 -76.204399 298.527985)(52.500000 82.378998 332.873993)(59.000000 68.695000 262.000000)(52.500000 75.987099 297.262024)(59.000000 68.695000 262.000000)(52.500000 75.750999 296.348999)(52.500000 75.987099 297.262024)(52.500000 75.401794 295.000000)(52.500000 75.750999 296.348999)(59.000000 68.695000 262.000000)(59.000000 68.695000 262.000000)(51.340302 75.074501 295.000000)(52.500000 75.401794 295.000000)(49.063000 75.113701 295.000000)(51.340302 75.074501 295.000000)(59.000000 68.695000 262.000000)(52.500000 82.581001 334.000000)(59.000000 68.695000 262.000000)(52.500000 82.378998 332.873993)(81.124001 16.306999 464.500000)(84.006798 0.000000 471.638000)(81.267998 0.000000 464.500000)(83.979004 27.179001 471.576996)(84.006798 0.000000 471.638000)(82.564896 13.589500 468.069000)(82.564896 13.589500 468.069000)(81.124001 16.306999 464.500000)(83.979004 27.179001 471.576996)(81.124001 16.306999 464.500000)(82.564896 13.589500 468.069000)(84.006798 0.000000 471.638000)(52.500000 -75.750999 296.348999)(52.500000 -75.401794 295.000000)(59.000000 -68.695000 262.000000)(59.000000 -68.695000 262.000000)(52.500000 -75.401794 295.000000)(51.340302 -75.074501 295.000000)(54.501999 -33.966000 260.614014)(53.674301 -34.961998 261.907013)(52.407299 -36.600101 261.884979)(54.501999 -33.966000 260.614014)(52.407299 -36.600101 261.884979)(50.507099 -39.090099 261.266998)(44.734100 -56.662998 261.751007)(41.338203 -67.909004 261.691986)(41.338203 -48.664803 261.691986)(48.129997 -68.846001 261.809998)(41.338203 -67.909004 261.691986)(44.734100 -56.662998 261.751007)(52.604298 -52.723099 261.888000)(46.518402 -44.213898 261.781982)(46.814201 -43.831501 261.786987)(52.604298 -52.723099 261.888000)(46.814201 -43.831501 261.786987)(52.407299 -36.600101 261.884979)(50.507099 -39.090099 261.266998)(52.407299 -36.600101 261.884979)(46.814201 -43.831501 261.786987)(50.507099 -39.090099 261.266998)(46.814201 -43.831501 261.786987)(46.548000 -44.241997 260.614014)(52.604298 -52.723099 261.888000)(46.208698 -44.480000 261.776001)(46.518402 -44.213898 261.781982)(52.604298 -52.723099 261.888000)(48.129997 -68.846001 261.809998)(46.208698 -44.480000 261.776001)(41.335003 -48.699100 260.226990)(46.548000 -44.241997 260.614014)(41.335800 -48.715599 260.602997)(41.335003 -48.699100 260.226990)(41.335800 -48.715599 260.602997)(41.335003 -70.367004 260.226990)(41.336601 -59.515900 260.958984)(41.335003 -70.367004 260.226990)(41.335800 -48.715599 260.602997)(43.928703 -46.463699 261.198029)(41.335800 -48.715599 260.602997)(46.548000 -44.241997 260.614014)(46.518402 -44.213898 261.781982)(46.208698 -44.480000 261.776001)(46.548000 -44.241997 260.614014)(46.208698 -44.480000 261.776001)(43.928703 -46.463699 261.198029)(46.548000 -44.241997 260.614014)(41.338203 -48.664803 261.691986)(43.928703 -46.463699 261.198029)(46.208698 -44.480000 261.776001)(48.129997 -68.846001 261.809998)(44.734100 -56.662998 261.751007)(46.208698 -44.480000 261.776001)(41.335800 -48.715599 260.602997)(41.338203 -48.664803 261.691986)(41.336601 -59.515900 260.958984)(41.338203 -67.909004 261.691986)(41.335003 -70.367004 260.226990)(41.336601 -59.515900 260.958984)(41.338203 -67.909004 261.691986)(48.129997 -68.846001 261.809998)(41.411198 -76.998001 295.000000)(41.338203 -67.909004 261.691986)(41.411198 -76.998001 295.000000)(41.335003 -70.367004 260.226990)(46.548000 -44.241997 260.614014)(46.814201 -43.831501 261.786987)(46.518402 -44.213898 261.781982)(47.652699 -75.137901 295.000000)(41.411198 -76.998001 295.000000)(48.129997 -68.846001 261.809998)(47.652699 -75.137901 295.000000)(48.129997 -68.846001 261.809998)(49.063000 -75.113701 295.000000)(59.000000 -68.695000 262.000000)(49.063000 -75.113701 295.000000)(48.129997 -68.846001 261.809998)(59.000000 -68.695000 262.000000)(48.129997 -68.846001 261.809998)(52.604298 -52.723099 261.888000)(41.338203 -48.664803 261.691986)(41.335800 -48.715599 260.602997)(43.928703 -46.463699 261.198029)(28.827499 -76.776695 295.000000)(41.335003 -70.367004 260.226990)(41.411198 -76.998001 295.000000)(52.604298 -52.723099 261.888000)(52.407299 -36.600101 261.884979)(59.000000 -68.695000 262.000000)(-55.224003 77.662994 266.174988)(-50.446999 82.413002 264.902008)(-39.505299 70.447899 268.075989)(54.501999 -33.966000 260.614014)(50.507099 -39.090099 261.266998)(46.548000 -44.241997 260.614014)(-60.223999 22.299999 260.614014)(-57.337399 28.120701 261.416992)(-54.500999 33.966000 260.614014)(54.780899 -15.335300 546.146973)(41.960796 0.000000 546.080994)(48.370903 -15.011801 546.263977)(83.608002 27.179001 486.575012)(83.559402 0.000000 486.539978)(84.765907 0.000000 479.118988)(-12.923200 -62.879799 261.292999)(-19.122200 -60.942299 261.070984)(-12.927999 -62.903004 260.614014)(41.808601 112.526001 476.743988)(67.601006 112.671005 480.468018)(67.601006 110.815002 470.542999)(54.775600 76.659996 541.580017)(41.950302 78.220802 541.342041)(41.952099 75.767197 542.196960)(-25.313299 58.982399 261.536011)(-36.255600 52.900799 261.751007)(-94.406998 68.487999 262.893005)(79.171600 -45.227699 482.852997)(79.582802 -45.353497 481.871979)(79.960007 -45.203999 483.036987)(-22.179001 147.852997 277.390991)(-16.759100 147.552994 262.769012)(-14.805000 144.939011 248.147995)(-22.179001 147.852997 277.390991)(-20.121698 149.134003 277.048004)(-16.759100 147.552994 262.769012)(63.974796 0.000000 260.614014)(63.785397 3.229700 261.350983)(63.961903 0.000000 260.984009)(-42.395500 -48.153004 261.871002)(-42.789501 -47.814297 261.878998)(-42.663002 -47.998001 260.614014)(-106.214005 75.188004 309.794983)(-117.537003 69.362000 309.940979)(-117.959000 74.542999 333.388000)(79.928894 -39.762798 466.877014)(79.483803 -40.006001 467.053009)(79.963402 -39.383499 466.601990)(80.684998 -32.614998 464.500000)(80.247299 -32.951000 464.543030)(79.809601 -32.731998 464.515015)(79.725105 -44.601997 473.452972)(80.167000 -44.149002 472.476990)(80.111000 -45.054996 474.428009)(2.270990 -148.207001 247.272995)(10.900001 -146.677994 247.682007)(2.270990 -155.713013 275.285004)(80.567001 -35.695000 464.893982)(83.756996 -33.969997 471.612000)(80.443001 -38.625000 466.051025)(-125.403999 -0.441000 263.502014)(-125.403999 0.441000 263.502014)(-94.406998 0.000000 262.893005)(41.560200 88.260201 356.608978)(59.000999 89.418999 377.466003)(52.500000 82.581001 334.000000)(-57.337399 -28.120701 261.416992)(-56.438499 -29.895500 262.147003)(-60.171398 -22.280499 262.221008)(-77.832001 76.204399 298.527985)(-61.307003 78.823700 310.820007)(-61.307003 77.601700 305.225006)(-76.641594 -72.824501 282.835999)(-94.406998 -68.487999 262.893005)(-58.876102 -73.665703 286.773010)(72.714005 10.359000 538.294983)(71.280098 0.000000 540.548035)(72.714005 0.000000 538.158997)(70.139099 7.513500 542.466980)(68.856705 7.513500 544.556030)(67.601006 0.000000 546.541992)(67.601006 15.026999 546.661987)(68.856705 7.513500 544.556030)(70.139099 7.513500 542.466980)(67.601006 15.026999 546.661987)(70.139099 7.513500 542.466980)(72.714005 10.359000 538.294983)(70.139099 7.513500 542.466980)(67.601006 0.000000 546.541992)(71.280098 0.000000 540.548035)(72.714005 10.359000 538.294983)(70.139099 7.513500 542.466980)(71.280098 0.000000 540.548035)(67.601006 84.650002 386.212006)(72.701996 82.625000 415.539001)(67.601006 77.644997 379.588989)(67.601006 84.650002 386.212006)(67.601006 77.644997 379.588989)(59.000999 85.778000 387.139008)(63.482002 9.720000 260.614014)(63.024902 11.283500 262.070007)(63.197701 10.615900 262.072998)(79.911003 42.146000 489.063995)(79.914001 40.181999 490.934998)(82.287994 40.196999 485.184998)(67.601006 98.632996 417.792999)(72.701996 82.625000 415.539001)(67.601006 97.194000 412.299011)(43.928001 100.006996 421.527008)(67.601006 97.194000 412.299011)(67.601006 95.661003 406.449005)(67.601006 95.661003 406.449005)(67.601006 97.194000 412.299011)(72.701996 82.625000 415.539001)(67.601006 94.186996 402.330994)(67.601006 95.661003 406.449005)(72.701996 82.625000 415.539001)(67.601006 95.661003 406.449005)(67.601006 94.186996 402.330994)(44.993999 95.351006 404.143005)(44.993999 95.351006 404.143005)(67.601006 94.186996 402.330994)(67.601006 92.889000 398.705994)(67.601006 92.889000 398.705994)(67.601006 94.186996 402.330994)(72.701996 82.625000 415.539001)(77.800995 51.714001 392.269989)(78.978004 15.835000 395.385010)(77.800995 21.837999 381.958984)(79.960007 -45.203999 483.036987)(80.756996 -44.300999 482.371979)(79.934998 -44.193001 485.545990)(-58.944603 75.462196 295.000000)(-58.339001 79.063202 295.000000)(-58.876102 73.665703 286.773010)(41.812000 112.814003 478.283997)(41.812099 112.822006 478.329987)(67.601006 112.671005 480.468018)(72.701996 -82.625000 415.539001)(67.601006 -95.661003 406.449005)(67.601006 -94.186996 402.330994)(79.207504 45.520298 480.571991)(79.613205 45.612499 479.853973)(79.232201 45.722000 479.000000)(71.442001 -17.107000 262.216980)(72.700600 0.000000 262.239014)(72.301498 0.000000 287.631989)(80.633003 -33.959000 464.670990)(80.193306 -33.622997 464.628021)(80.219299 -33.286999 464.584991)(79.753601 -33.959000 464.670990)(80.193306 -33.790997 464.649994)(80.193306 -33.622997 464.628021)(80.193306 -33.790997 464.649994)(80.193306 -33.622997 464.628021)(80.633003 -33.959000 464.670990)(79.753601 -33.959000 464.670990)(80.193306 -33.790997 464.649994)(80.633003 -33.959000 464.670990)(80.633003 -33.959000 464.670990)(79.746597 -34.111897 464.691010)(79.753601 -33.959000 464.670990)(79.153503 44.193001 485.545990)(79.540703 43.936497 486.182983)(79.544296 44.064701 485.864014)(41.335800 48.715599 260.602997)(46.548000 44.241997 260.614014)(41.335003 48.699100 260.226990)(-126.401009 -41.887001 286.700989)(-124.023994 -52.660000 286.687988)(-128.570999 -47.430000 310.032990)(79.914001 -40.181999 490.934998)(79.911003 -42.146000 489.063995)(82.287994 -40.196999 485.184998)(80.329002 -41.132000 467.869995)(82.525002 -40.196999 472.917999)(80.232002 -43.105000 470.230988)(79.435104 -41.132000 467.869995)(80.329002 -41.132000 467.869995)(79.844803 -42.118500 469.049988)(79.435104 -41.132000 467.869995)(79.844803 -42.118500 469.049988)(79.360596 -42.931400 470.023010)(79.438904 -41.043503 467.806000)(79.435104 -41.132000 467.869995)(80.329002 -41.132000 467.869995)(79.438904 -41.043503 467.806000)(79.435104 -41.132000 467.869995)(77.800995 -75.124001 452.000000)(79.844803 -42.118500 469.049988)(80.329002 -41.132000 467.869995)(80.232002 -43.105000 470.230988)(83.608002 27.179001 486.575012)(80.360001 10.862000 493.500000)(83.559402 0.000000 486.539978)(67.703003 -33.854000 262.151978)(63.761799 -30.413801 262.083008)(61.755299 -16.190599 262.048004)(-25.313299 58.982399 261.536011)(-25.326000 59.012001 260.614014)(-30.997398 55.841698 261.182007)(59.000999 63.197002 371.791016)(59.000999 35.831001 364.783997)(59.000999 39.448997 354.901001)(41.802002 111.883995 473.709991)(41.805199 112.203003 475.196014)(67.601006 109.491997 464.199982)(54.501999 33.966000 260.614014)(56.077801 30.648500 261.949005)(57.341602 28.122200 261.317017)(79.154495 -42.146000 489.063995)(79.153801 -42.262302 488.893982)(79.911003 -42.146000 489.063995)(79.314301 -44.149002 472.476990)(80.167000 -44.149002 472.476990)(79.725105 -44.601997 473.452972)(83.979004 -27.179001 471.576996)(84.889999 -27.179001 479.101013)(83.756996 -33.969997 471.612000)(-124.023994 -52.660000 286.687988)(-121.458000 -58.391003 286.653992)(-123.512001 -61.675999 310.009979)(-123.795998 36.459000 263.470001)(-122.964005 45.035999 263.453003)(-94.406998 68.487999 262.893005)(79.476807 10.862000 493.500000)(79.866402 19.020000 493.500000)(79.372696 25.941099 493.500000)(80.357498 -0.000000 493.500000)(79.545601 0.879971 493.500000)(79.951599 0.000000 493.500000)(79.545601 0.879971 493.500000)(79.545601 -0.879971 493.500000)(79.951599 0.000000 493.500000)(79.545601 -0.879971 493.500000)(80.357498 -0.000000 493.500000)(79.951599 0.000000 493.500000)(79.372696 -25.941099 493.500000)(80.112000 -27.178001 493.500000)(79.866402 -19.020000 493.500000)(-94.406998 -68.487999 262.893005)(-58.753300 -71.872101 277.354004)(-58.770599 -72.124001 278.677002)(59.000000 -68.695000 262.000000)(52.500000 -75.987099 297.262024)(52.500000 -75.750999 296.348999)(-34.432999 -118.450996 255.246994)(11.373000 -82.374001 264.912018)(19.285002 -86.037003 263.931000)(79.146400 -43.719898 486.720001)(79.540703 -43.936497 486.182983)(79.534698 -43.808201 486.501007)(79.280304 -45.054996 474.428009)(80.111000 -45.054996 474.428009)(79.676201 -45.388500 476.713989)(79.168701 -45.203999 483.036987)(79.154701 -44.272099 485.350006)(78.432899 -56.746899 499.244019)(80.564003 16.306999 464.500000)(80.914497 8.153500 464.500000)(80.894905 6.929690 464.500000)(81.291397 0.000000 457.002014)(80.564003 16.306999 464.500000)(80.894905 6.929690 464.500000)(59.000999 -85.778000 387.139008)(67.601006 -84.650002 386.212006)(59.000999 -91.572998 395.704010)(67.601006 -84.650002 386.212006)(59.000999 -85.778000 387.139008)(67.601006 -77.644997 379.588989)(59.000000 53.697002 288.311005)(59.000000 54.230000 283.061005)(59.000000 68.695000 262.000000)(79.477898 -40.141998 467.152008)(79.438904 -41.043503 467.806000)(77.800995 -75.124001 452.000000)(31.111000 -98.375999 260.625000)(34.283001 -106.278000 258.507996)(-22.179001 -140.348007 249.378998)(79.317596 -44.059700 472.285004)(77.800995 -75.124001 452.000000)(79.353493 -43.105000 470.230988)(79.353493 -43.105000 470.230988)(77.800995 -75.124001 452.000000)(79.360596 -42.931400 470.023010)(59.000000 -68.695000 262.000000)(52.407299 -36.600101 261.884979)(53.674301 -34.961998 261.907013)(59.000000 -54.994999 262.000000)(53.674301 -34.961998 261.907013)(54.463303 -33.941898 261.920990)(53.674301 -34.961998 261.907013)(59.000000 -54.994999 262.000000)(59.000000 -68.695000 262.000000)(79.952003 36.598000 492.841003)(79.655701 34.596500 493.169983)(80.029007 32.595001 493.500000)(67.601006 -106.838005 452.000000)(72.708000 -90.958000 452.000000)(72.714005 -96.683998 488.843994)(79.283104 -44.979599 474.265991)(79.725105 -44.601997 473.452972)(80.111000 -45.054996 474.428009)(72.701996 82.625000 415.539001)(72.708000 90.958000 452.000000)(77.800995 75.124001 452.000000)(44.734100 -56.662998 261.751007)(41.338203 -48.664803 261.691986)(46.208698 -44.480000 261.776001)(-36.665100 52.673199 261.759003)(-94.406998 68.487999 262.893005)(-36.255600 52.900799 261.751007)(-117.026001 -63.762001 286.584991)(-120.144005 -52.723003 263.397980)(-115.973999 -58.090000 263.316986)(-105.911003 -70.065002 286.406006)(-106.490997 -63.938000 263.130005)(-94.406998 -68.487999 262.893005)(-105.911003 -70.065002 286.406006)(-115.973999 -58.090000 263.316986)(-106.490997 -63.938000 263.130005)(-105.911003 -70.065002 286.406006)(-117.026001 -63.762001 286.584991)(-115.973999 -58.090000 263.316986)(-106.490997 -63.938000 263.130005)(-115.973999 -58.090000 263.316986)(-94.406998 -68.487999 262.893005)(30.872000 -130.949005 251.897003)(10.900001 -146.677994 247.682007)(2.270990 -148.207001 247.272995)(80.894905 6.929690 464.500000)(80.939102 0.523865 464.500000)(81.283302 0.000000 457.399017)(41.812099 -112.822006 478.329987)(41.812000 -112.814003 478.283997)(67.601006 -112.671005 480.468018)(59.000999 89.418999 377.466003)(59.000000 68.695000 262.000000)(52.500000 82.581001 334.000000)(71.083099 0.000000 313.239990)(67.504005 25.653002 313.793976)(66.028999 22.513000 339.349976)(-137.444000 -26.815001 333.463989)(-130.461014 -52.723999 333.459991)(-135.472000 -47.260002 354.721985)(80.357498 -0.000000 493.500000)(80.360001 10.862000 493.500000)(79.918396 5.431000 493.500000)(79.364204 -27.178001 493.500000)(80.112000 -27.178001 493.500000)(79.372696 -25.941099 493.500000)(83.979004 -27.179001 471.576996)(83.756996 -33.969997 471.612000)(80.684998 -32.614998 464.500000)(80.595001 -21.743000 464.500000)(80.539803 -16.924101 464.500000)(81.124001 -16.306999 464.500000)(-34.164997 -106.940002 258.329987)(-34.164997 -114.445999 286.341980)(-35.427002 -106.377998 288.503998)(41.496601 -84.434998 334.000000)(41.541000 -88.298996 354.263000)(11.392000 -83.905502 334.000000)(10.900001 154.184006 275.694000)(18.865000 143.125000 248.634995)(10.900001 146.677994 247.682007)(-76.641594 72.824501 282.835999)(-61.307003 77.163399 302.778992)(-61.307003 75.464706 295.000000)(67.601006 -101.744003 523.383972)(67.601006 -95.750999 529.524048)(41.916500 -100.043999 525.991028)(-6.481010 -147.615005 247.431000)(2.270990 -148.207001 247.272995)(-6.481010 -155.121002 275.442993)(49.063000 -75.113701 295.000000)(59.000000 -68.695000 262.000000)(51.340302 -75.074501 295.000000)(41.338203 -67.909004 261.691986)(41.336601 -59.515900 260.958984)(41.338203 -48.664803 261.691986)(67.601006 -112.671005 480.468018)(41.820400 -113.435997 482.065002)(41.813999 -112.979004 479.169006)(80.046600 -27.599699 464.500000)(80.323502 -29.897001 464.500000)(79.815002 -32.614998 464.500000)(-122.964005 45.035999 263.453003)(-126.401009 41.887001 286.700989)(-124.023994 52.660000 286.687988)(-115.973999 -58.090000 263.316986)(-120.144005 -52.723003 263.397980)(-94.406998 -68.487999 262.893005)(59.000999 -52.636002 298.752014)(59.000999 -50.173000 314.332977)(59.000999 -63.197002 371.791016)(72.701996 82.625000 415.539001)(67.601006 101.487000 429.165985)(67.601006 104.222000 440.570007)(59.000999 39.448997 354.901001)(66.028999 22.513000 339.349976)(59.000999 42.695000 344.901001)(46.518402 44.213898 261.781982)(46.208698 44.480000 261.776001)(52.604298 52.723099 261.888000)(46.814201 43.831501 261.786987)(46.518402 44.213898 261.781982)(52.604298 52.723099 261.888000)(-94.406998 -68.487999 262.893005)(-42.789501 -47.814297 261.878998)(-42.395500 -48.153004 261.871002)(80.684998 -32.614998 464.500000)(79.815002 -32.614998 464.500000)(80.323502 -29.897001 464.500000)(67.601006 88.885002 391.522003)(67.601006 92.889000 398.705994)(72.701996 82.625000 415.539001)(59.000999 91.572998 395.704010)(67.601006 88.885002 391.522003)(67.601006 84.650002 386.212006)(59.000999 91.572998 395.704010)(67.601006 92.889000 398.705994)(67.601006 88.885002 391.522003)(67.601006 112.671005 480.468018)(41.808601 112.526001 476.743988)(41.812000 112.814003 478.283997)(63.761799 -30.413801 262.083008)(60.178898 -22.282900 262.020996)(60.324402 -21.720699 262.023010)(67.601006 -95.750999 529.524048)(72.714005 -48.195999 536.594971)(67.601006 -80.802002 539.831970)(80.029007 -32.595001 493.500000)(79.326797 -32.595001 493.500000)(79.655701 -34.596500 493.169983)(67.504005 25.653002 313.793976)(71.083099 0.000000 313.239990)(72.301094 0.000000 287.640991)(80.550095 16.699800 464.500000)(80.564003 16.306999 464.500000)(81.291397 0.000000 457.002014)(-108.735001 -83.295006 356.660004)(-118.275002 -79.184006 356.402008)(-117.959000 -74.542999 333.388000)(35.320000 -122.197998 284.265015)(34.159000 -130.597992 282.014008)(35.320000 -114.692001 256.252991)(80.112000 27.178001 493.500000)(83.608002 27.179001 486.575012)(80.029007 32.595001 493.500000)(-32.311996 126.673996 253.042999)(-28.139999 134.128998 251.044983)(26.004999 91.485001 262.470978)(59.000000 54.806999 272.545990)(59.000000 54.994999 262.000000)(59.000000 68.695000 262.000000)(60.224998 22.299999 260.614014)(59.133999 24.414499 262.001984)(59.820599 23.013800 262.014008)(81.124001 16.306999 464.500000)(80.595001 21.743000 464.500000)(80.832001 27.179001 464.500000)(67.601006 15.026999 546.661987)(67.601006 0.000000 546.541992)(68.856705 7.513500 544.556030)(-140.007004 29.219000 354.571991)(-135.472000 47.260002 354.721985)(-137.444000 26.815001 333.463989)(77.800995 68.164993 419.658020)(77.800995 51.714001 392.269989)(72.701996 62.891998 384.640015)(-9.366880 70.952202 267.973999)(41.335003 70.367004 260.226990)(-39.505299 70.447899 268.075989)(-140.720993 0.441000 344.000000)(-139.966003 0.441003 333.462006)(-140.720993 -0.441000 344.000000)(-46.852303 -43.771301 261.958984)(-50.503498 -39.088100 261.360992)(-46.547001 -44.241997 260.614014)(67.601006 84.650002 386.212006)(67.601006 88.885002 391.522003)(72.701996 82.625000 415.539001)(79.360596 -42.931400 470.023010)(77.800995 -75.124001 452.000000)(79.435104 -41.132000 467.869995)(80.633003 -33.959000 464.670990)(80.153603 -34.827000 464.783020)(79.746597 -34.111897 464.691010)(80.193306 -33.622997 464.628021)(79.753601 -33.959000 464.670990)(80.219299 -33.286999 464.584991)(59.000999 63.197002 371.791016)(59.000999 44.068001 339.895020)(59.000999 46.861000 329.708008)(42.614098 110.106995 509.056976)(41.885101 109.429001 511.524963)(67.601006 109.103996 511.054993)(59.000000 -54.994999 262.000000)(55.011200 -32.824100 261.929993)(55.086201 -32.671299 261.931976)(80.329002 -41.132000 467.869995)(79.884003 -40.884499 467.690002)(79.906502 -40.637001 467.510986)(67.601006 95.750999 529.524048)(72.714005 82.199997 522.572998)(67.601006 101.744003 523.383972)(-36.255600 -52.900799 261.751007)(-30.997398 -55.841698 261.182007)(-25.313299 -58.982399 261.536011)(79.364204 27.178001 493.500000)(79.720695 29.886501 493.500000)(79.329399 32.212902 493.500000)(19.285002 -86.037003 263.931000)(11.373000 -82.374001 264.912018)(19.284901 -93.542801 291.944000)(-39.445698 83.375198 334.000000)(-26.334999 87.259003 355.483002)(7.603000 87.778999 354.873016)(79.911003 42.146000 489.063995)(79.534203 41.164001 490.000000)(79.914001 40.181999 490.934998)(67.601006 -72.328003 542.781982)(67.601006 -62.781998 544.375000)(41.956997 -65.602196 544.356995)(-117.537003 -69.362000 309.940979)(-117.026001 -63.762001 286.584991)(-105.911003 -70.065002 286.406006)(-106.214005 -75.188004 309.794983)(-117.537003 -69.362000 309.940979)(-105.911003 -70.065002 286.406006)(67.601006 -63.148998 371.933990)(59.000999 -35.831001 364.783997)(61.535999 -28.941999 363.698975)(34.767200 114.242004 272.513977)(35.320000 122.197998 284.265015)(34.283001 113.783005 286.520020)(67.601006 -72.328003 542.781982)(41.956997 -65.602196 544.356995)(41.952099 -75.767197 542.196960)(67.601006 105.671005 446.901001)(67.601006 106.838005 452.000000)(72.701996 82.625000 415.539001)(-130.461014 52.723999 333.459991)(-137.444000 26.815001 333.463989)(-135.472000 47.260002 354.721985)(-94.406998 -68.487999 262.893005)(-94.357002 -73.585007 286.235016)(-105.911003 -70.065002 286.406006)(62.254898 14.259600 262.057007)(63.024902 11.283500 262.070007)(63.482002 9.720000 260.614014)(30.872000 -138.455002 279.910004)(25.664000 -145.274994 278.080994)(30.872000 -130.949005 251.897003)(-106.214005 75.188004 309.794983)(-94.341003 75.278999 293.992004)(-94.357002 73.585007 286.235016)(-124.023994 -52.660000 286.687988)(-123.512001 -61.675999 310.009979)(-128.570999 -47.430000 310.032990)(79.477898 -40.141998 467.152008)(79.926003 -40.389500 467.332001)(79.926003 -40.265800 467.242004)(79.914001 -40.181999 490.934998)(79.534203 -41.164001 490.000000)(79.911003 -42.146000 489.063995)(-106.214005 -75.188004 309.794983)(-105.911003 -70.065002 286.406006)(-94.357002 -73.585007 286.235016)(58.761898 25.173399 261.996002)(56.077801 30.648500 261.949005)(59.973400 40.084202 262.016998)(-39.505299 70.447899 268.075989)(41.335003 70.367004 260.226990)(-58.633900 70.127800 268.194000)(80.360001 10.862000 493.500000)(80.357498 -0.000000 493.500000)(83.559402 0.000000 486.539978)(79.205299 -45.503002 480.707001)(79.582802 -45.353497 481.871979)(79.171600 -45.227699 482.852997)(-58.633900 70.127800 268.194000)(-58.339001 71.764000 267.755981)(-39.505299 70.447899 268.075989)(81.291397 0.000000 457.002014)(80.550095 -16.699800 464.500000)(81.290001 0.000000 456.649017)(-50.446999 82.413002 264.902008)(-55.224003 85.168999 294.187012)(-50.446999 89.918999 292.914001)(43.928001 100.006996 421.527008)(43.362000 102.135002 430.031006)(67.601006 97.194000 412.299011)(41.959202 53.446301 545.358032)(68.405998 43.556000 546.675049)(41.959400 56.295303 545.449036)(67.601006 77.644997 379.588989)(59.000999 72.435997 375.942993)(59.000999 85.778000 387.139008)(18.865000 -150.630005 276.645996)(10.900001 -154.184006 275.694000)(18.865000 -143.125000 248.634995)(68.405998 -43.556000 546.675049)(67.601006 -30.676001 546.212952)(41.959202 -53.446301 545.358032)(-60.272999 86.737999 356.092987)(-94.260002 82.452995 333.162994)(-77.243004 86.478004 356.397980)(67.703003 33.854000 262.151978)(62.091103 14.892700 262.053986)(61.755299 16.190599 262.048004)(-94.341003 -75.278999 293.992004)(-61.307003 -78.823700 310.820007)(-61.307003 -79.329498 313.720001)(79.154701 44.272099 485.350006)(79.153503 44.193001 485.545990)(79.934998 44.193001 485.545990)(67.703003 -33.854000 262.151978)(61.755299 -16.190599 262.048004)(62.091103 -14.892700 262.053986)(45.589001 92.432999 396.824982)(44.993999 95.351006 404.143005)(67.601006 92.889000 398.705994)(75.193001 -13.573000 376.886017)(77.800995 -21.837999 381.958984)(72.701996 -27.146000 373.149017)(67.601006 -98.632996 417.792999)(72.701996 -82.625000 415.539001)(67.601006 -101.487000 429.165985)(80.832001 27.179001 464.500000)(83.979004 27.179001 471.576996)(81.124001 16.306999 464.500000)(-42.789501 47.814297 261.878998)(-94.406998 68.487999 262.893005)(-42.395500 48.153004 261.871002)(61.184002 -88.436996 534.910950)(67.601006 -80.802002 539.831970)(54.766899 -88.597496 535.143982)(77.800995 68.164993 419.658020)(81.275597 0.000000 455.844025)(77.800995 51.714001 392.269989)(50.507099 39.090099 261.266998)(52.407299 36.600101 261.884979)(54.501999 33.966000 260.614014)(79.360596 -42.931400 470.023010)(79.844803 -42.118500 469.049988)(80.232002 -43.105000 470.230988)(80.018997 -45.722000 479.000000)(81.072006 -44.300999 479.023010)(80.756996 -44.300999 482.371979)(-58.542400 83.028801 334.000000)(-61.307003 83.014198 334.000000)(-26.334999 87.259003 355.483002)(79.952003 -36.598000 492.841003)(79.267700 -36.842300 492.710999)(79.568901 -38.389999 491.888000)(63.431503 9.712260 262.077972)(63.197701 10.615900 262.072998)(67.319801 13.569201 262.145020)(77.800400 0.000000 530.000000)(74.165901 0.000000 535.719971)(72.714005 -10.359000 538.294983)(35.320000 114.692001 256.252991)(34.159000 130.597992 282.014008)(35.320000 122.197998 284.265015)(-94.406998 0.000000 262.893005)(-125.403999 0.441000 263.502014)(-94.406998 68.487999 262.893005)(34.767200 -114.242004 272.513977)(34.283001 -113.783005 286.520020)(35.320000 -122.197998 284.265015)(80.029007 -32.595001 493.500000)(83.608002 -27.179001 486.575012)(80.112000 -27.178001 493.500000)(83.608002 -27.179001 486.575012)(83.428001 -33.969997 486.536011)(84.889999 -27.179001 479.101013)(67.601006 -77.644997 379.588989)(59.000999 -85.778000 387.139008)(59.000999 -72.435997 375.942993)(59.000999 -91.572998 395.704010)(67.601006 -88.885002 391.522003)(67.601006 -92.889000 398.705994)(69.753494 36.353001 373.369995)(67.601196 0.000000 361.701019)(67.601006 72.706001 376.436005)(80.066101 27.179001 464.500000)(80.595001 21.743000 464.500000)(80.539803 16.924101 464.500000)(77.800995 -78.636993 492.308990)(78.432899 -56.746899 499.244019)(77.800995 -62.127998 521.060974)(-76.641594 72.824501 282.835999)(-61.307003 75.464706 295.000000)(-58.876102 73.665703 286.773010)(67.601006 -63.148998 371.933990)(59.000999 -63.197002 371.791016)(59.000999 -35.831001 364.783997)(-122.964005 45.035999 263.453003)(-123.795998 36.459000 263.470001)(-126.401009 41.887001 286.700989)(41.338203 48.664803 261.691986)(41.336601 59.515900 260.958984)(41.338203 67.909004 261.691986)(20.062700 94.173401 291.774994)(19.284901 93.542801 291.944000)(19.285002 86.037003 263.931000)(79.545601 -0.879971 493.500000)(79.918396 -5.431000 493.500000)(80.357498 -0.000000 493.500000)(63.930199 0.000000 261.896027)(63.785397 3.229700 261.350983)(63.923599 0.000000 262.085999)(25.664000 -137.770004 250.070007)(10.900001 -146.677994 247.682007)(30.872000 -130.949005 251.897003)(-124.935997 19.788000 263.491974)(-129.649994 21.038000 286.709991)(-126.401009 41.887001 286.700989)(67.601006 95.750999 529.524048)(41.916500 100.043999 525.991028)(41.918198 99.487000 526.510986)(59.000999 63.197002 371.791016)(59.000999 46.861000 329.708008)(59.000999 50.173000 314.332977)(41.802002 -111.883995 473.709991)(67.601006 -108.184006 458.108002)(67.601006 -109.491997 464.199982)(54.766899 88.597496 535.143982)(41.933102 91.898705 533.554016)(41.939301 87.826401 536.362000)(-117.959000 -74.542999 333.388000)(-117.537003 -69.362000 309.940979)(-106.214005 -75.188004 309.794983)(-140.720993 0.441000 344.000000)(-140.720993 -0.441000 344.000000)(-141.477005 0.000000 354.537018)(67.601006 30.676001 546.212952)(67.601006 15.026999 546.661987)(72.714005 10.359000 538.294983)(31.111000 105.881996 288.637024)(31.111000 98.375999 260.625000)(32.603802 106.113998 274.630981)(-77.823997 78.304001 309.147003)(-61.307003 81.329002 324.300995)(-61.307003 79.329498 313.720001)(-94.406998 68.487999 262.893005)(-115.973999 58.090000 263.316986)(-106.490997 63.938000 263.130005)(81.283302 0.000000 457.399017)(81.291397 0.000000 457.002014)(80.894905 6.929690 464.500000)(-129.649994 -21.038000 286.709991)(-126.401009 -41.887001 286.700989)(-133.781998 -23.965000 310.036011)(-61.307003 -81.329002 324.300995)(-61.307003 -82.618805 331.907013)(-94.309006 -78.239998 309.659973)(84.006798 0.000000 471.638000)(83.979004 27.179001 471.576996)(84.889999 27.179001 479.101013)(-60.171398 22.280499 262.221008)(-60.337601 21.638199 262.223999)(-94.406998 68.487999 262.893005)(-94.357002 73.585007 286.235016)(-76.641594 72.824501 282.835999)(-94.406998 68.487999 262.893005)(-46.852303 -43.771301 261.958984)(-94.406998 -68.487999 262.893005)(-54.456699 -33.938400 262.108002)(59.000000 -68.695000 262.000000)(59.000999 -89.418999 377.466003)(52.500000 -82.581001 334.000000)(79.154701 -44.272099 485.350006)(79.557396 -44.698498 484.290985)(79.934998 -44.193001 485.545990)(80.443001 -38.625000 466.051025)(82.525002 -40.196999 472.917999)(80.374001 -40.141998 467.152008)(49.063000 75.113701 295.000000)(59.000000 68.695000 262.000000)(48.129997 68.846001 261.809998)(72.701996 -82.625000 415.539001)(67.601006 -84.650002 386.212006)(67.601006 -77.644997 379.588989)(72.714005 -96.683998 488.843994)(67.601006 -108.184006 458.108002)(67.601006 -106.838005 452.000000)(77.800995 75.124001 452.000000)(79.815002 32.614998 464.500000)(81.290001 0.000000 456.649017)(-137.444000 26.815001 333.463989)(-141.477005 23.040001 354.537018)(-140.007004 29.219000 354.571991)(79.353493 -43.105000 470.230988)(79.360596 -42.931400 470.023010)(80.232002 -43.105000 470.230988)(-77.823997 -78.304001 309.147003)(-61.307003 -79.329498 313.720001)(-61.307003 -81.329002 324.300995)(10.900001 146.677994 247.682007)(18.865000 143.125000 248.634995)(25.664000 137.770004 250.070007)(79.241295 45.669601 478.640991)(80.018997 45.722000 479.000000)(79.272102 45.492599 477.427979)(77.800995 68.164993 419.658020)(77.800995 71.921997 436.239014)(81.286697 0.000000 456.321014)(46.548000 44.241997 260.614014)(46.518402 44.213898 261.781982)(46.814201 43.831501 261.786987)(15.157900 86.016106 344.256989)(24.572001 88.039001 354.567993)(41.541000 88.298996 354.263000)(59.000000 68.695000 262.000000)(59.000000 54.994999 262.000000)(53.674301 34.961998 261.907013)(72.701996 27.146000 373.149017)(72.701996 0.000000 371.746979)(67.601196 0.000000 361.701019)(52.407299 36.600101 261.884979)(46.814201 43.831501 261.786987)(52.604298 52.723099 261.888000)(79.205299 -45.503002 480.707001)(79.994003 -45.503002 480.707001)(79.582802 -45.353497 481.871979)(79.280304 45.054996 474.428009)(77.800995 75.124001 452.000000)(79.272102 45.492599 477.427979)(-63.481003 -9.720000 260.614014)(-63.423298 -9.711161 262.283997)(-63.458199 -9.023340 262.285004)(64.200996 -18.559999 362.567017)(69.044907 0.000000 338.782990)(69.044502 0.000000 338.789001)(81.794701 -42.171600 482.127014)(82.287994 -40.196999 485.184998)(80.756996 -44.300999 482.371979)(45.859001 90.318001 382.876984)(45.805000 90.896004 387.692993)(59.000999 91.572998 395.704010)(42.746998 87.457001 360.680023)(59.000999 89.418999 377.466003)(41.560200 88.260201 356.608978)(79.476807 -10.862000 493.500000)(80.360001 -10.862000 493.500000)(79.918396 -5.431000 493.500000)(41.840698 113.944000 491.200012)(67.601006 113.279999 492.261993)(67.601006 113.523994 488.196991)(72.701996 -62.891998 384.640015)(77.800995 -68.164993 419.658020)(72.701996 -82.625000 415.539001)(79.241295 45.669601 478.640991)(79.232201 45.722000 479.000000)(80.018997 45.722000 479.000000)(52.604298 52.723099 261.888000)(46.208698 44.480000 261.776001)(48.129997 68.846001 261.809998)(-126.401009 -41.887001 286.700989)(-128.570999 -47.430000 310.032990)(-133.781998 -23.965000 310.036011)(69.044907 0.000000 338.782990)(66.028999 22.513000 339.349976)(64.200996 18.559999 362.567017)(79.154495 42.146000 489.063995)(78.432899 56.746899 499.244019)(79.183601 40.325401 490.798004)(42.178001 105.959000 446.110992)(41.753201 107.167000 451.436005)(67.601006 106.838005 452.000000)(-39.209000 -91.576004 262.446991)(-39.505299 -70.447899 268.075989)(-9.366880 -70.952202 267.973999)(-12.647201 -62.908001 261.287018)(-12.923200 -62.879799 261.292999)(-12.927999 -62.903004 260.614014)(54.766899 88.597496 535.143982)(41.932800 92.076797 533.430969)(41.933102 91.898705 533.554016)(72.714005 -96.683998 488.843994)(67.601006 -113.279999 492.261993)(67.601006 -113.523994 488.196991)(65.601997 -22.568800 262.114990)(62.254898 -14.259600 262.057007)(63.024902 -11.283500 262.070007)(44.993999 95.351006 404.143005)(43.928001 100.006996 421.527008)(67.601006 95.661003 406.449005)(79.540703 -43.936497 486.182983)(79.934998 -44.193001 485.545990)(79.737900 -43.936497 486.182983)(-9.366880 -70.952202 267.973999)(-39.505299 -70.447899 268.075989)(41.335003 -70.367004 260.226990)(59.000000 -54.994999 262.000000)(54.463303 -33.941898 261.920990)(54.701099 -33.456799 261.925018)(67.601006 30.676001 546.212952)(54.781601 23.003201 546.302979)(54.780899 15.335300 546.146973)(68.948997 28.271000 262.174011)(65.601997 22.568800 262.114990)(67.703003 33.854000 262.151978)(36.682098 52.697498 260.318024)(25.352999 58.995602 260.540985)(41.335003 70.367004 260.226990)(79.911003 42.146000 489.063995)(79.154495 42.146000 489.063995)(79.534203 41.164001 490.000000)(41.335003 -70.367004 260.226990)(36.775700 -52.616997 260.316986)(41.335003 -48.699100 260.226990)(68.721397 0.000000 341.713013)(65.674995 -11.033999 361.970978)(69.044502 0.000000 338.789001)(-94.406998 -68.487999 262.893005)(-36.665100 -52.673199 261.759003)(-36.255600 -52.900799 261.751007)(80.140205 40.637001 467.510986)(80.374001 40.141998 467.152008)(79.906502 40.637001 467.510986)(63.974796 0.000000 260.614014)(63.961903 0.000000 260.984009)(63.785397 -3.229700 261.350983)(63.197701 10.615900 262.072998)(63.024902 11.283500 262.070007)(68.948997 28.271000 262.174011)(67.601006 -105.671005 446.901001)(72.701996 -82.625000 415.539001)(67.601006 -106.838005 452.000000)(-140.720993 0.441000 344.000000)(-141.477005 0.000000 354.537018)(-141.477005 23.040001 354.537018)(79.544296 -44.064701 485.864014)(79.934998 -44.193001 485.545990)(79.540703 -43.936497 486.182983)(80.018997 45.722000 479.000000)(80.167000 44.149002 472.476990)(80.111000 45.054996 474.428009)(-118.275002 79.184006 356.402008)(-117.959000 74.542999 333.388000)(-124.130005 67.465996 333.440979)(80.066101 27.179001 464.500000)(80.539803 16.924101 464.500000)(81.290001 0.000000 456.649017)(35.320000 122.197998 284.265015)(34.283001 106.278000 258.507996)(35.320000 114.692001 256.252991)(59.982502 0.000000 546.275024)(60.613503 0.000000 546.342041)(67.601006 15.026999 546.661987)(64.392502 88.356804 534.793945)(61.184002 88.436996 534.910950)(67.601006 80.802002 539.831970)(41.892399 -107.468002 514.809021)(41.885101 -109.429001 511.524963)(67.601006 -109.103996 511.054993)(81.124001 -16.306999 464.500000)(82.564896 -13.589500 468.069000)(83.979004 -27.179001 471.576996)(67.601006 106.838005 452.000000)(67.601006 105.671005 446.901001)(42.178001 105.959000 446.110992)(60.224998 22.299999 260.614014)(59.820599 23.013800 262.014008)(60.178898 22.282900 262.020996)(67.601196 0.000000 361.701019)(67.601006 24.057001 363.636993)(67.601006 63.148998 371.933990)(79.918396 5.431000 493.500000)(80.360001 10.862000 493.500000)(79.476807 10.862000 493.500000)(77.800995 -62.127998 521.060974)(72.714005 -48.195999 536.594971)(72.714005 -82.199997 522.572998)(54.501999 -33.966000 260.614014)(54.463303 -33.941898 261.920990)(53.674301 -34.961998 261.907013)(71.280098 0.000000 540.548035)(67.601006 0.000000 546.541992)(70.139099 -7.513500 542.466980)(79.282295 -36.327900 492.884979)(79.329102 -34.866096 493.126007)(77.800995 -62.127998 521.060974)(67.601006 -63.148998 371.933990)(67.601006 -24.057001 363.636993)(67.601196 0.000000 361.701019)(59.000000 -54.994999 262.000000)(59.000000 -54.806999 272.545990)(59.000000 -68.695000 262.000000)(-128.570999 47.430000 310.032990)(-123.512001 61.675999 310.009979)(-124.023994 52.660000 286.687988)(-36.665100 52.673199 261.759003)(-36.255600 52.900799 261.751007)(-36.688000 52.706001 260.614014)(59.000999 85.778000 387.139008)(59.000999 91.572998 395.704010)(67.601006 84.650002 386.212006)(41.837200 -113.955994 489.576019)(67.601006 -113.523994 488.196991)(41.840698 -113.944000 491.200012)(79.283104 44.979599 474.265991)(79.725105 44.601997 473.452972)(79.314301 44.149002 472.476990)(79.655701 34.596500 493.169983)(79.329102 34.866096 493.126007)(79.326797 32.595001 493.500000)(63.482002 -9.720000 260.614014)(61.828899 -16.003599 261.346008)(60.224998 -22.299999 260.614014)(41.411198 76.998001 295.000000)(41.335003 70.367004 260.226990)(28.827499 76.776695 295.000000)(67.601196 0.000000 361.701019)(72.701996 -27.146000 373.149017)(72.701996 -62.891998 384.640015)(80.633003 33.959000 464.670990)(83.756996 33.969997 471.612000)(80.684998 32.614998 464.500000)(59.000999 -72.435997 375.942993)(59.000999 -85.778000 387.139008)(59.000999 -89.418999 377.466003)(-42.789501 47.814297 261.878998)(-42.395500 48.153004 261.871002)(-42.663002 47.998001 260.614014)(-9.491710 77.874603 295.000000)(-10.356000 76.087494 295.000000)(-9.366880 70.952202 267.973999)(80.567001 -35.695000 464.893982)(80.061195 -37.160000 465.472992)(79.674301 -35.695000 464.893982)(-34.387997 110.106995 257.481995)(-34.432999 118.450996 255.246994)(7.256990 81.315002 265.195984)(79.205299 45.503002 480.707001)(79.582802 45.353497 481.871979)(79.994003 45.503002 480.707001)(79.906502 40.637001 467.510986)(79.672699 40.592701 467.479004)(79.438904 41.043503 467.806000)(-34.387997 -117.612999 285.492981)(-34.164997 -114.445999 286.341980)(-34.387997 -110.106995 257.481995)(-135.668991 -0.441002 310.035004)(-139.966003 -0.441003 333.462006)(-135.668991 0.441002 310.035004)(72.714005 -82.199997 522.572998)(67.601006 -113.279999 492.261993)(72.714005 -96.683998 488.843994)(-15.803801 83.706497 334.000000)(24.572001 88.039001 354.567993)(-11.225201 83.688400 334.000000)(67.601006 -72.706001 376.436005)(67.601006 -77.644997 379.588989)(59.000999 -72.435997 375.942993)(31.111000 -105.881996 288.637024)(31.111000 -98.375999 260.625000)(26.004999 -91.485001 262.470978)(-94.341003 -75.278999 293.992004)(-106.214005 -75.188004 309.794983)(-94.357002 -73.585007 286.235016)(-77.832001 76.204399 298.527985)(-94.341003 75.278999 293.992004)(-61.307003 78.823700 310.820007)(0.172782 64.184700 261.035004)(41.335003 70.367004 260.226990)(12.926800 62.897198 260.785004)(26.004999 -91.485001 262.470978)(29.344400 -103.497993 289.276001)(31.111000 -105.881996 288.637024)(2.270990 155.713013 275.285004)(10.900001 154.184006 275.694000)(10.900001 146.677994 247.682007)(59.000999 91.572998 395.704010)(45.589001 92.432999 396.824982)(67.601006 92.889000 398.705994)(61.828899 -16.003599 261.346008)(62.091103 -14.892700 262.053986)(61.755299 -16.190599 262.048004)(-76.641594 -72.824501 282.835999)(-61.307003 -75.464706 295.000000)(-61.307003 -77.163399 302.778992)(-94.406998 -68.487999 262.893005)(-125.403999 -0.441000 263.502014)(-94.406998 0.000000 262.893005)(-14.805000 -152.445007 276.160004)(-16.759100 -147.552994 262.769012)(-14.805000 -144.939011 248.147995)(65.674995 11.033999 361.970978)(64.200996 18.559999 362.567017)(67.601006 24.057001 363.636993)(42.614098 -110.106995 509.056976)(43.766300 -112.223000 501.431000)(67.601006 -109.103996 511.054993)(-10.356000 -76.087494 295.000000)(41.335003 -70.367004 260.226990)(28.827499 -76.776695 295.000000)(67.601006 -109.103996 511.054993)(67.601006 -101.744003 523.383972)(41.892399 -107.468002 514.809021)(0.172782 -64.184700 261.035004)(6.463250 -63.552700 260.825012)(12.926800 -62.897198 260.785004)(-16.759100 147.552994 262.769012)(-20.121698 149.134003 277.048004)(-14.805000 152.445007 276.160004)(81.291397 0.000000 457.002014)(80.894905 -6.929690 464.500000)(80.564003 -16.306999 464.500000)(77.800995 68.164993 419.658020)(72.701996 82.625000 415.539001)(77.800995 71.921997 436.239014)(77.800995 21.837999 381.958984)(77.800995 0.000000 381.000000)(74.368095 0.000000 374.716003)(82.525002 40.196999 472.917999)(83.756996 33.969997 471.612000)(80.443001 38.625000 466.051025)(66.028999 -22.513000 339.349976)(61.535999 -28.941999 363.698975)(59.000999 -35.831001 364.783997)(-58.770599 -72.124001 278.677002)(-58.339001 -71.764000 267.755981)(-58.339001 -79.063202 295.000000)(-63.973801 0.000000 260.614014)(-63.780800 -3.229520 261.456024)(-63.959099 0.000000 261.036987)(77.800400 0.000000 530.000000)(77.800995 62.127998 521.060974)(72.714005 10.359000 538.294983)(42.178001 -105.959000 446.110992)(67.601006 -105.671005 446.901001)(67.601006 -106.838005 452.000000)(-130.461014 52.723999 333.459991)(-123.512001 61.675999 310.009979)(-128.570999 47.430000 310.032990)(55.723598 -0.000000 545.817017)(67.601006 15.026999 546.661987)(67.601006 30.676001 546.212952)(80.323502 29.897001 464.500000)(79.815002 32.614998 464.500000)(80.684998 32.614998 464.500000)(79.655701 -34.596500 493.169983)(79.326797 -32.595001 493.500000)(79.329102 -34.866096 493.126007)(63.868999 -44.636997 262.084991)(59.000000 -54.994999 262.000000)(59.973400 -40.084202 262.016998)(78.471199 -31.063999 511.557983)(79.329102 -34.866096 493.126007)(79.326797 -32.595001 493.500000)(-123.512001 61.675999 310.009979)(-117.026001 63.762001 286.584991)(-121.458000 58.391003 286.653992)(59.000000 53.697002 288.311005)(59.000000 68.695000 262.000000)(59.000999 52.636002 298.752014)(81.291397 0.000000 457.002014)(80.564003 -16.306999 464.500000)(80.550095 -16.699800 464.500000)(60.324402 21.720699 262.023010)(60.178898 22.282900 262.020996)(63.761799 30.413801 262.083008)(80.443001 -38.625000 466.051025)(80.061195 -37.160000 465.472992)(80.567001 -35.695000 464.893982)(77.800995 -68.164993 419.658020)(72.701996 -62.891998 384.640015)(77.800995 -51.714001 392.269989)(31.111000 98.375999 260.625000)(34.283001 113.783005 286.520020)(32.603802 106.113998 274.630981)(60.224998 22.299999 260.614014)(61.828899 16.003599 261.346008)(63.482002 9.720000 260.614014)(31.111000 -98.375999 260.625000)(-22.179001 -140.348007 249.378998)(-28.139999 -134.128998 251.044983)(79.884003 -40.884499 467.690002)(80.329002 -41.132000 467.869995)(79.438904 -41.043503 467.806000)(41.892399 107.468002 514.809021)(41.897800 106.003998 517.218018)(67.601006 101.744003 523.383972)(79.540703 -43.936497 486.182983)(79.737900 -43.936497 486.182983)(79.922997 -43.680000 486.819000)(84.684998 33.971001 479.098999)(83.160995 40.196999 479.069000)(83.428001 33.969997 486.536011)(67.601006 -62.781998 544.375000)(41.958000 -62.816700 544.821960)(41.956997 -65.602196 544.356995)(69.044502 0.000000 338.789001)(65.674995 -11.033999 361.970978)(64.200996 -18.559999 362.567017)(79.753601 -33.959000 464.670990)(79.746597 -34.111897 464.691010)(77.800995 -75.124001 452.000000)(68.948997 -28.271000 262.174011)(63.197701 -10.615900 262.072998)(67.319801 -13.569201 262.145020)(72.301094 0.000000 287.640991)(71.083099 0.000000 313.239990)(67.504005 -25.653002 313.793976)(-63.481003 9.720000 260.614014)(-63.458199 9.023340 262.285004)(-63.423298 9.711161 262.283997)(-55.224003 -85.168999 294.187012)(-55.224003 -77.662994 266.174988)(-50.446999 -82.413002 264.902008)(-50.446999 -82.413002 264.902008)(-47.857002 -84.063004 264.459991)(-50.446999 -89.918999 292.914001)(-50.446999 -89.918999 292.914001)(-55.224003 -85.168999 294.187012)(-50.446999 -82.413002 264.902008)(-55.224003 -85.168999 294.187012)(-58.258198 -79.227295 295.000000)(-55.224003 -77.662994 266.174988)(-58.339001 -71.764000 267.755981)(-55.224003 -77.662994 266.174988)(-58.339001 -79.063202 295.000000)(-47.857002 -91.569000 292.472015)(-47.857002 -84.063004 264.459991)(-45.139999 -85.764999 264.003998)(-45.139999 -85.764999 264.003998)(-39.209000 -91.576004 262.446991)(-45.139999 -93.271004 292.015991)(-58.258198 -79.227295 295.000000)(-58.339001 -79.063202 295.000000)(-55.224003 -77.662994 266.174988)(-45.139999 -85.764999 264.003998)(-45.139999 -93.271004 292.015991)(-47.857002 -91.569000 292.472015)(-39.209000 -91.576004 262.446991)(-39.209000 -99.082001 290.459015)(-45.139999 -93.271004 292.015991)(-47.857002 -91.569000 292.472015)(-50.446999 -89.918999 292.914001)(-47.857002 -84.063004 264.459991)(-108.737000 -108.407997 481.798004)(-108.742996 -112.924004 479.122986)(-108.731003 -108.870003 484.472992)(-108.742996 -103.891998 479.122986)(-108.737000 -108.407997 481.798004)(-108.731003 -108.870003 484.472992)(-108.704002 -108.992004 496.526978)(-108.719002 -113.972000 489.824005)(-108.689003 -112.239998 503.533020)(-108.691002 -104.039993 502.781982)(-108.704002 -108.992004 496.526978)(-108.689003 -112.239998 503.533020)(41.837200 -113.955994 489.576019)(41.840698 -113.944000 491.200012)(41.836998 -116.599998 489.493988)(41.836800 -113.957001 489.412018)(41.837200 -113.955994 489.576019)(41.836998 -116.599998 489.493988)(-108.661003 -107.153000 516.381958)(-108.689003 -112.239998 503.533020)(-29.100000 -110.769005 510.819977)(-108.661003 -107.153000 516.381958)(-29.100000 -110.769005 510.819977)(-27.734499 -108.783997 515.893005)(-108.689003 -112.239998 503.533020)(-108.661003 -107.153000 516.381958)(-108.690002 -104.039993 503.285004)(-108.690002 -104.039993 503.285004)(-108.691002 -104.039993 502.781982)(-108.689003 -112.239998 503.533020)(-108.689003 -112.239998 503.533020)(-29.890100 -111.917999 507.879974)(-29.100000 -110.769005 510.819977)(-30.990301 -113.553001 503.700958)(-108.689003 -112.239998 503.533020)(-65.553398 -113.834999 496.772003)(-108.689003 -112.239998 503.533020)(-30.990301 -113.553001 503.700958)(-29.890100 -111.917999 507.879974)(-108.661003 -107.153000 516.381958)(-27.734499 -108.783997 515.893005)(-27.289999 -108.397995 516.888977)(-108.661003 -107.153000 516.381958)(-66.859001 -105.430000 519.893982)(-86.876701 -104.764999 520.263000)(-108.653000 -104.425995 520.135010)(-108.661003 -107.153000 516.381958)(-86.876701 -104.764999 520.263000)(-108.661003 -107.153000 516.381958)(-67.387703 -106.650002 518.199951)(-66.859001 -105.430000 519.893982)(-67.387703 -106.650002 518.199951)(-27.289999 -108.397995 516.888977)(-42.201599 -106.249001 519.438965)(-42.201599 -106.249001 519.438965)(-27.289999 -108.397995 516.888977)(-26.114500 -106.509003 519.519958)(-108.661003 -107.153000 516.381958)(-27.289999 -108.397995 516.888977)(-67.387703 -106.650002 518.199951)(-108.661003 -104.041000 516.601990)(-108.661003 -107.153000 516.381958)(-108.653000 -104.425995 520.135010)(-108.661003 -104.041000 516.601990)(-108.661003 -104.041000 516.291992)(-108.661003 -107.153000 516.381958)(-31.500801 -113.773003 501.896027)(-30.990301 -113.553001 503.700958)(-65.553398 -113.834999 496.772003)(-32.287998 -114.127998 498.975006)(-31.500801 -113.773003 501.896027)(-65.553398 -113.834999 496.772003)(-32.287998 -114.127998 498.975006)(-65.553398 -113.834999 496.772003)(-22.387800 -114.437996 497.869995)(-108.731003 -108.870003 484.472992)(-108.731003 -111.420998 484.473999)(-108.719002 -113.972000 489.824005)(-108.719002 -113.972000 489.824005)(-108.731003 -111.420998 484.473999)(-108.742996 -112.924004 479.122986)(-108.724998 -108.988998 487.148987)(-108.731003 -108.870003 484.472992)(-108.719002 -113.972000 489.824005)(41.836998 -116.599998 489.493988)(-108.719002 -113.972000 489.824005)(-108.742996 -112.924004 479.122986)(-108.733994 -103.766998 483.282013)(-108.731003 -108.870003 484.472992)(-108.719994 -104.005997 489.352997)(-108.733994 -103.766998 483.282013)(-108.742996 -103.891998 479.122986)(-108.731003 -108.870003 484.472992)(22.221699 -109.572998 454.324005)(-108.822998 -104.429001 442.579010)(-15.808801 -108.080002 450.915985)(-108.742996 -112.924004 479.122986)(-108.781998 -104.431000 461.050995)(-108.822998 -104.429001 442.579010)(-108.750000 -103.984001 476.016022)(-108.781998 -104.431000 461.050995)(-108.742996 -112.924004 479.122986)(-108.742996 -103.891998 479.122986)(-108.750000 -103.984001 476.016022)(-108.742996 -112.924004 479.122986)(41.784397 -110.182999 465.615997)(41.761200 -110.111000 455.091003)(41.753201 -107.167000 451.436005)(41.805199 -112.203003 475.196014)(41.808601 -112.526001 476.743988)(41.812000 -115.501999 478.283997)(41.802002 -111.883995 473.709991)(41.805199 -112.203003 475.196014)(41.812000 -115.501999 478.283997)(41.812000 -115.501999 478.283997)(41.784397 -110.182999 465.615997)(41.802002 -111.883995 473.709991)(41.808601 -112.526001 476.743988)(41.812000 -112.814003 478.283997)(41.812000 -115.501999 478.283997)(36.112701 -109.979004 454.970001)(40.704002 -110.114998 455.193024)(41.812000 -115.501999 478.283997)(22.221699 -109.572998 454.324005)(36.112701 -109.979004 454.970001)(41.812000 -115.501999 478.283997)(-15.808801 -108.080002 450.915985)(22.221699 -109.572998 454.324005)(41.812000 -115.501999 478.283997)(-33.505398 -109.991997 460.545990)(-15.808801 -108.080002 450.915985)(41.812000 -115.501999 478.283997)(41.833302 -113.969994 487.820007)(41.836800 -113.957001 489.412018)(41.836998 -116.599998 489.493988)(41.824699 -113.646004 483.968994)(41.824501 -114.710999 483.889008)(41.820400 -113.435997 482.065002)(41.824699 -113.646004 483.968994)(41.833302 -113.969994 487.820007)(41.824501 -114.710999 483.889008)(41.820400 -113.435997 482.065002)(41.824501 -114.710999 483.889008)(41.812000 -115.501999 478.283997)(-108.742996 -112.924004 479.122986)(41.812000 -115.501999 478.283997)(41.836998 -116.599998 489.493988)(-108.742996 -112.924004 479.122986)(-33.505398 -109.991997 460.545990)(41.812000 -115.501999 478.283997)(41.812000 -115.501999 478.283997)(41.824501 -114.710999 483.889008)(41.836998 -116.599998 489.493988)(41.812099 -112.822006 478.329987)(41.813999 -112.979004 479.169006)(41.812000 -115.501999 478.283997)(41.813999 -112.979004 479.169006)(41.820400 -113.435997 482.065002)(41.812000 -115.501999 478.283997)(41.833302 -113.969994 487.820007)(41.836998 -116.599998 489.493988)(41.824501 -114.710999 483.889008)(41.812000 -112.814003 478.283997)(41.812099 -112.822006 478.329987)(41.812000 -115.501999 478.283997)(-33.434399 -114.789001 493.589996)(-108.719002 -113.972000 489.824005)(41.836998 -116.599998 489.493988)(-33.434399 -114.789001 493.589996)(-22.387800 -114.437996 497.869995)(-108.719002 -113.972000 489.824005)(-33.434399 -114.789001 493.589996)(-4.825290 -114.990005 495.889984)(-22.387800 -114.437996 497.869995)(-22.387800 -114.437996 497.869995)(-65.553398 -113.834999 496.772003)(-108.719002 -113.972000 489.824005)(41.836998 -116.599998 489.493988)(28.616800 -115.555000 495.963013)(10.479900 -115.243004 495.968994)(41.836998 -116.599998 489.493988)(10.479900 -115.243004 495.968994)(2.565930 -115.108994 495.950989)(28.616800 -115.555000 495.963013)(41.836998 -116.599998 489.493988)(35.579300 -115.677994 495.934998)(41.842899 -113.883003 492.217987)(41.850201 -113.562004 495.604980)(41.843601 -115.080994 492.549988)(41.850201 -113.562004 495.604980)(41.850101 -115.831001 495.582001)(41.843601 -115.080994 492.549988)(38.940701 -115.742996 495.884003)(41.836998 -116.599998 489.493988)(41.850101 -115.831001 495.582001)(35.579300 -115.677994 495.934998)(41.836998 -116.599998 489.493988)(38.940701 -115.742996 495.884003)(-32.104702 -114.133003 498.964996)(-32.287998 -114.127998 498.975006)(-22.387800 -114.437996 497.869995)(-66.859001 -105.430000 519.893982)(-67.387703 -106.650002 518.199951)(-42.201599 -106.249001 519.438965)(41.836998 -116.599998 489.493988)(-4.825290 -114.990005 495.889984)(-33.434399 -114.789001 493.589996)(41.836998 -116.599998 489.493988)(2.565930 -115.108994 495.950989)(-4.825290 -114.990005 495.889984)(-108.704002 -106.516006 496.480988)(-108.718002 -104.039001 490.179993)(-108.704002 -108.992004 496.526978)(-108.704002 -106.516006 496.480988)(-108.704002 -108.992004 496.526978)(-108.691002 -104.039993 502.781982)(-108.718002 -104.039001 490.179993)(-108.704002 -106.516006 496.480988)(-108.691002 -104.039993 502.781982)(-108.718002 -104.039001 490.179993)(-108.712006 -109.004997 493.174988)(-108.704002 -108.992004 496.526978)(-108.718002 -104.039001 490.179993)(-108.714996 -109.004997 491.500000)(-108.712006 -109.004997 493.174988)(-108.712006 -109.004997 493.174988)(-108.714996 -109.004997 491.500000)(-108.719002 -113.972000 489.824005)(-108.719002 -113.972000 489.824005)(-108.714996 -109.004997 491.500000)(-108.718002 -104.039001 490.179993)(-108.719002 -113.972000 489.824005)(-108.719994 -104.013000 489.520996)(-108.719994 -104.005997 489.352997)(-108.718002 -104.039001 490.179993)(-108.719994 -104.013000 489.520996)(-108.719002 -113.972000 489.824005)(-108.712006 -109.004997 493.174988)(-108.719002 -113.972000 489.824005)(-108.704002 -108.992004 496.526978)(41.843601 -115.080994 492.549988)(41.850101 -115.831001 495.582001)(41.836998 -116.599998 489.493988)(-108.719994 -104.005997 489.352997)(-108.731003 -108.870003 484.472992)(-108.724998 -108.988998 487.148987)(-108.719994 -104.005997 489.352997)(-108.724998 -108.988998 487.148987)(-108.719002 -113.972000 489.824005)(-108.742996 -103.891998 479.122986)(-108.740005 -108.407997 480.460999)(-108.737000 -108.407997 481.798004)(-65.553398 -113.834999 496.772003)(-108.689003 -112.239998 503.533020)(-108.719002 -113.972000 489.824005)(-33.505398 -109.991997 460.545990)(-108.822998 -104.429001 442.579010)(-15.808801 -108.080002 450.915985)(-108.742996 -112.924004 479.122986)(-108.740005 -108.407997 480.460999)(-108.742996 -103.891998 479.122986)(41.840698 -113.944000 491.200012)(41.843601 -115.080994 492.549988)(41.836998 -116.599998 489.493988)(-108.662003 -104.041000 516.104004)(-108.690002 -104.039993 503.285004)(-108.661003 -107.153000 516.381958)(-108.737000 -108.407997 481.798004)(-108.740005 -108.407997 480.460999)(-108.742996 -112.924004 479.122986)(41.761200 -110.111000 455.091003)(41.784397 -110.182999 465.615997)(41.812000 -115.501999 478.283997)(-108.731003 -108.870003 484.472992)(-108.742996 -112.924004 479.122986)(-108.731003 -111.420998 484.473999)(-108.661003 -104.041000 516.291992)(-108.662003 -104.041000 516.104004)(-108.661003 -107.153000 516.381958)(41.842899 -113.883003 492.217987)(41.843601 -115.080994 492.549988)(41.840698 -113.944000 491.200012)(-108.742996 -112.924004 479.122986)(-108.822998 -104.429001 442.579010)(-33.505398 -109.991997 460.545990)(40.704002 -110.114998 455.193024)(41.761200 -110.111000 455.091003)(41.812000 -115.501999 478.283997)(41.812000 115.501999 478.283997)(-15.808801 108.080002 450.915985)(-33.505398 109.991997 460.545990)(-108.742996 112.924004 479.122986)(41.812000 115.501999 478.283997)(-33.505398 109.991997 460.545990)(-108.742996 112.924004 479.122986)(41.836998 116.599998 489.493988)(41.812000 115.501999 478.283997)(41.812000 115.501999 478.283997)(41.784397 110.182999 465.615997)(41.761200 110.111000 455.091003)(40.704002 110.114998 455.193024)(41.812000 115.501999 478.283997)(41.761200 110.111000 455.091003)(36.112701 109.979004 454.970001)(41.812000 115.501999 478.283997)(40.704002 110.114998 455.193024)(22.221699 109.572998 454.324005)(41.812000 115.501999 478.283997)(36.112701 109.979004 454.970001)(41.753201 107.167000 451.436005)(41.761200 110.111000 455.091003)(41.784397 110.182999 465.615997)(-86.876701 104.764999 520.263000)(-66.859001 105.430000 519.893982)(-108.661003 107.153000 516.381958)(-108.661003 107.153000 516.381958)(-66.859001 105.430000 519.893982)(-67.387703 106.650002 518.199951)(-42.201599 106.249001 519.438965)(-67.387703 106.650002 518.199951)(-66.859001 105.430000 519.893982)(-42.201599 106.249001 519.438965)(-26.114500 106.509003 519.519958)(-27.289999 108.397995 516.888977)(-30.990301 113.553001 503.700958)(-31.500801 113.773003 501.896027)(-65.553398 113.834999 496.772003)(-65.553398 113.834999 496.772003)(-31.500801 113.773003 501.896027)(-32.287998 114.127998 498.975006)(-108.689003 112.239998 503.533020)(-30.990301 113.553001 503.700958)(-65.553398 113.834999 496.772003)(-108.719002 113.972000 489.824005)(-108.719994 104.013000 489.520996)(-108.718002 104.039001 490.179993)(-108.719994 104.013000 489.520996)(-108.719002 113.972000 489.824005)(-108.719994 104.005997 489.352997)(-108.742996 103.891998 479.122986)(-108.740005 108.407997 480.460999)(-108.742996 112.924004 479.122986)(-108.737000 108.407997 481.798004)(-108.740005 108.407997 480.460999)(-108.742996 103.891998 479.122986)(-108.742996 112.924004 479.122986)(-108.740005 108.407997 480.460999)(-108.737000 108.407997 481.798004)(-108.737000 108.407997 481.798004)(-108.742996 103.891998 479.122986)(-108.731003 108.870003 484.472992)(-108.731003 108.870003 484.472992)(-108.742996 103.891998 479.122986)(-108.733994 103.766998 483.282013)(-108.742996 112.924004 479.122986)(-108.750000 103.984001 476.016022)(-108.742996 103.891998 479.122986)(-108.718002 104.039001 490.179993)(-108.714996 109.004997 491.500000)(-108.719002 113.972000 489.824005)(-108.712006 109.004997 493.174988)(-108.718002 104.039001 490.179993)(-108.704002 108.992004 496.526978)(-108.712006 109.004997 493.174988)(-108.714996 109.004997 491.500000)(-108.718002 104.039001 490.179993)(-108.719002 113.972000 489.824005)(-108.712006 109.004997 493.174988)(-108.704002 108.992004 496.526978)(-108.719002 113.972000 489.824005)(-108.704002 108.992004 496.526978)(-108.689003 112.239998 503.533020)(-108.704002 108.992004 496.526978)(-108.718002 104.039001 490.179993)(-108.704002 106.516006 496.480988)(-108.704002 108.992004 496.526978)(-108.704002 106.516006 496.480988)(-108.691002 104.039993 502.781982)(-108.719002 113.972000 489.824005)(-108.689003 112.239998 503.533020)(-65.553398 113.834999 496.772003)(-108.689003 112.239998 503.533020)(-108.691002 104.039993 502.781982)(-108.690002 104.039993 503.285004)(-108.689003 112.239998 503.533020)(-108.690002 104.039993 503.285004)(-108.661003 107.153000 516.381958)(-108.661003 107.153000 516.381958)(-108.662003 104.041000 516.104004)(-108.661003 104.041000 516.291992)(-108.661003 107.153000 516.381958)(-108.690002 104.039993 503.285004)(-108.662003 104.041000 516.104004)(-108.661003 107.153000 516.381958)(-108.661003 104.041000 516.291992)(-108.661003 104.041000 516.601990)(-108.661003 107.153000 516.381958)(-108.661003 104.041000 516.601990)(-108.653000 104.425995 520.135010)(-29.100000 110.769005 510.819977)(-108.689003 112.239998 503.533020)(-108.661003 107.153000 516.381958)(-29.100000 110.769005 510.819977)(-29.890100 111.917999 507.879974)(-108.689003 112.239998 503.533020)(-108.661003 107.153000 516.381958)(-27.734499 108.783997 515.893005)(-29.100000 110.769005 510.819977)(-108.661003 107.153000 516.381958)(-27.289999 108.397995 516.888977)(-27.734499 108.783997 515.893005)(-108.731003 108.870003 484.472992)(-108.733994 103.766998 483.282013)(-108.719994 104.005997 489.352997)(41.812000 115.501999 478.283997)(41.808601 112.526001 476.743988)(41.805199 112.203003 475.196014)(41.812000 115.501999 478.283997)(41.805199 112.203003 475.196014)(41.802002 111.883995 473.709991)(41.824501 114.710999 483.889008)(41.824699 113.646004 483.968994)(41.820400 113.435997 482.065002)(41.824501 114.710999 483.889008)(41.833302 113.969994 487.820007)(41.824699 113.646004 483.968994)(41.836998 116.599998 489.493988)(41.833302 113.969994 487.820007)(41.824501 114.710999 483.889008)(41.836998 116.599998 489.493988)(41.837200 113.955994 489.576019)(41.836800 113.957001 489.412018)(41.836998 116.599998 489.493988)(41.840698 113.944000 491.200012)(41.837200 113.955994 489.576019)(38.940701 115.742996 495.884003)(41.850101 115.831001 495.582001)(41.836998 116.599998 489.493988)(41.843601 115.080994 492.549988)(41.850201 113.562004 495.604980)(41.842899 113.883003 492.217987)(41.850101 115.831001 495.582001)(41.850201 113.562004 495.604980)(41.843601 115.080994 492.549988)(41.850101 115.831001 495.582001)(41.843601 115.080994 492.549988)(41.836998 116.599998 489.493988)(41.843601 115.080994 492.549988)(41.842899 113.883003 492.217987)(41.840698 113.944000 491.200012)(41.836998 116.599998 489.493988)(41.843601 115.080994 492.549988)(41.840698 113.944000 491.200012)(35.579300 115.677994 495.934998)(38.940701 115.742996 495.884003)(41.836998 116.599998 489.493988)(28.616800 115.555000 495.963013)(35.579300 115.677994 495.934998)(41.836998 116.599998 489.493988)(10.479900 115.243004 495.968994)(28.616800 115.555000 495.963013)(41.836998 116.599998 489.493988)(-108.719002 113.972000 489.824005)(-33.434399 114.789001 493.589996)(41.836998 116.599998 489.493988)(-33.434399 114.789001 493.589996)(-4.825290 114.990005 495.889984)(41.836998 116.599998 489.493988)(-4.825290 114.990005 495.889984)(-33.434399 114.789001 493.589996)(-22.387800 114.437996 497.869995)(-4.825290 114.990005 495.889984)(2.565930 115.108994 495.950989)(41.836998 116.599998 489.493988)(2.565930 115.108994 495.950989)(10.479900 115.243004 495.968994)(41.836998 116.599998 489.493988)(41.836998 116.599998 489.493988)(41.824501 114.710999 483.889008)(41.812000 115.501999 478.283997)(41.812000 115.501999 478.283997)(41.813999 112.979004 479.169006)(41.812099 112.822006 478.329987)(41.812000 115.501999 478.283997)(41.820400 113.435997 482.065002)(41.813999 112.979004 479.169006)(-67.387703 106.650002 518.199951)(-27.289999 108.397995 516.888977)(-108.661003 107.153000 516.381958)(-65.553398 113.834999 496.772003)(-32.287998 114.127998 498.975006)(-22.387800 114.437996 497.869995)(41.836998 116.599998 489.493988)(41.836800 113.957001 489.412018)(41.833302 113.969994 487.820007)(-108.742996 112.924004 479.122986)(-108.737000 108.407997 481.798004)(-108.731003 108.870003 484.472992)(-108.731003 111.420998 484.473999)(-108.742996 112.924004 479.122986)(-108.731003 108.870003 484.472992)(-108.742996 112.924004 479.122986)(-108.731003 111.420998 484.473999)(-108.719002 113.972000 489.824005)(-108.731003 111.420998 484.473999)(-108.731003 108.870003 484.472992)(-108.719002 113.972000 489.824005)(-15.808801 108.080002 450.915985)(41.812000 115.501999 478.283997)(22.221699 109.572998 454.324005)(-108.822998 104.429001 442.579010)(-15.808801 108.080002 450.915985)(22.221699 109.572998 454.324005)(41.824501 114.710999 483.889008)(41.820400 113.435997 482.065002)(41.812000 115.501999 478.283997)(-108.742996 112.924004 479.122986)(-108.719002 113.972000 489.824005)(41.836998 116.599998 489.493988)(-108.742996 112.924004 479.122986)(-108.781998 104.431000 461.050995)(-108.750000 103.984001 476.016022)(-108.719002 113.972000 489.824005)(-108.714996 109.004997 491.500000)(-108.712006 109.004997 493.174988)(41.812000 115.501999 478.283997)(41.812099 112.822006 478.329987)(41.812000 112.814003 478.283997)(-108.689003 112.239998 503.533020)(-29.890100 111.917999 507.879974)(-30.990301 113.553001 503.700958)(-108.822998 104.429001 442.579010)(-33.505398 109.991997 460.545990)(-15.808801 108.080002 450.915985)(-42.201599 106.249001 519.438965)(-27.289999 108.397995 516.888977)(-67.387703 106.650002 518.199951)(-108.822998 104.429001 442.579010)(-108.742996 112.924004 479.122986)(-33.505398 109.991997 460.545990)(-108.822998 104.429001 442.579010)(-108.781998 104.431000 461.050995)(-108.742996 112.924004 479.122986)(-108.719002 113.972000 489.824005)(-108.724998 108.988998 487.148987)(-108.719994 104.005997 489.352997)(41.812000 115.501999 478.283997)(41.802002 111.883995 473.709991)(41.784397 110.182999 465.615997)(-108.689003 112.239998 503.533020)(-108.704002 108.992004 496.526978)(-108.691002 104.039993 502.781982)(-108.661003 107.153000 516.381958)(-108.653000 104.425995 520.135010)(-86.876701 104.764999 520.263000)(-108.719002 113.972000 489.824005)(-108.731003 108.870003 484.472992)(-108.724998 108.988998 487.148987)(-108.724998 108.988998 487.148987)(-108.731003 108.870003 484.472992)(-108.719994 104.005997 489.352997)(-108.719002 113.972000 489.824005)(-22.387800 114.437996 497.869995)(-33.434399 114.789001 493.589996)(-108.719002 113.972000 489.824005)(-65.553398 113.834999 496.772003)(-22.387800 114.437996 497.869995)(-108.691002 104.039993 502.781982)(-108.704002 106.516006 496.480988)(-108.718002 104.039001 490.179993)(41.812000 115.501999 478.283997)(41.812000 112.814003 478.283997)(41.808601 112.526001 476.743988)(-181.731003 -43.294701 455.464996)(-180.686005 -52.620197 425.911987)(-181.832993 -44.672401 458.121979)(-181.525009 -35.792999 449.824005)(-180.686005 -52.620197 425.911987)(-181.572006 -38.800499 451.075989)(-181.645004 -41.395500 453.091003)(-180.686005 -52.620197 425.911987)(-181.647003 -41.462997 453.144989)(-181.574005 -38.924000 451.126984)(-180.686005 -52.620197 425.911987)(-181.645004 -41.395500 453.091003)(-181.525009 -35.682499 449.806000)(-180.686005 -52.620197 425.911987)(-181.525009 -35.792999 449.824005)(-179.389999 -78.511002 545.104980)(-179.389999 -94.904999 463.443024)(-179.389999 -84.383003 542.888000)(-179.389999 0.441005 375.324982)(-181.576004 0.441008 449.445007)(-181.557999 7.341420 449.445007)(-179.389999 0.441005 375.324982)(-181.557999 7.341420 449.445007)(-179.389999 41.200001 378.924988)(-181.501999 -21.139999 449.445007)(-181.501999 -20.481300 449.445007)(-180.686005 -52.620197 425.911987)(-181.504990 -25.265001 449.445007)(-181.504990 -24.960199 449.445007)(-180.686005 -52.620197 425.911987)(-180.686005 -52.620197 425.911987)(-181.511002 -33.134800 449.470001)(-181.504990 -25.265001 449.445007)(-181.511993 -33.615997 449.472015)(-180.686005 -52.620197 425.911987)(-181.525009 -35.682499 449.806000)(-181.511002 -33.134800 449.470001)(-180.686005 -52.620197 425.911987)(-181.511993 -33.615997 449.472015)(-180.686005 -52.620197 425.911987)(-181.501999 -20.481300 449.445007)(-181.500000 -17.228500 449.445007)(-181.645004 41.395500 453.091003)(-180.686005 52.620197 425.911987)(-181.574005 38.924000 451.126984)(-180.686005 52.620197 425.911987)(-181.572006 38.800499 451.075989)(-181.574005 38.924000 451.126984)(-179.389999 -41.200001 378.924988)(-181.500000 -17.228500 449.445007)(-181.525009 -12.891000 449.445007)(-181.531998 -11.796700 449.445007)(-179.389999 -41.200001 378.924988)(-181.525009 -12.891000 449.445007)(-181.500000 -17.228500 449.445007)(-179.389999 -41.200001 378.924988)(-179.389999 -88.012001 388.846008)(-181.500000 -17.228500 449.445007)(-179.389999 -88.012001 388.846008)(-180.686005 -52.620197 425.911987)(-182.000000 -45.799999 462.970001)(-179.389999 -94.904999 463.443024)(-179.389999 -63.845001 545.104980)(-179.389999 -94.904999 463.443024)(-182.000000 -45.799999 462.970001)(-179.389999 -88.012001 388.846008)(-182.000000 -45.799999 462.970001)(-180.686005 -52.620197 425.911987)(-179.389999 -88.012001 388.846008)(-181.838013 -44.763500 458.429993)(-180.686005 -52.620197 425.911987)(-181.930008 -45.375202 461.000000)(-182.000000 -45.799999 462.970001)(-181.930008 -45.375202 461.000000)(-180.686005 -52.620197 425.911987)(-179.389999 84.383003 542.888000)(-179.389999 94.904999 463.443024)(-179.389999 78.511002 545.104980)(-179.389999 78.511002 545.104980)(-179.389999 94.904999 463.443024)(-179.389999 63.845001 545.104980)(-179.389999 63.845001 545.104980)(-179.389999 94.904999 463.443024)(-182.000000 45.799999 462.970001)(-181.572006 38.800499 451.075989)(-180.686005 52.620197 425.911987)(-181.525009 35.792999 449.824005)(-181.525009 35.792999 449.824005)(-180.686005 52.620197 425.911987)(-181.525009 35.682499 449.806000)(-181.525009 35.682499 449.806000)(-180.686005 52.620197 425.911987)(-181.511993 33.615997 449.472015)(-181.511993 33.615997 449.472015)(-180.686005 52.620197 425.911987)(-181.511002 33.134800 449.470001)(-181.504990 25.265001 449.445007)(-181.511002 33.134800 449.470001)(-180.686005 52.620197 425.911987)(-181.504990 25.265001 449.445007)(-180.686005 52.620197 425.911987)(-181.504990 24.960199 449.445007)(-181.504990 24.960199 449.445007)(-180.686005 52.620197 425.911987)(-181.501999 21.139999 449.445007)(-181.501999 21.139999 449.445007)(-180.686005 52.620197 425.911987)(-181.501999 20.481300 449.445007)(-181.500000 17.228500 449.445007)(-181.501999 20.481300 449.445007)(-180.686005 52.620197 425.911987)(-180.686005 52.620197 425.911987)(-181.930008 45.375202 461.000000)(-182.000000 45.799999 462.970001)(-180.686005 52.620197 425.911987)(-181.838013 44.763500 458.429993)(-181.930008 45.375202 461.000000)(-180.686005 52.620197 425.911987)(-181.832993 44.672401 458.121979)(-181.838013 44.763500 458.429993)(-179.389999 88.012001 388.846008)(-180.686005 52.620197 425.911987)(-182.000000 45.799999 462.970001)(-179.389999 88.012001 388.846008)(-181.500000 17.228500 449.445007)(-180.686005 52.620197 425.911987)(-179.389999 88.012001 388.846008)(-182.000000 45.799999 462.970001)(-179.389999 94.904999 463.443024)(-179.389999 41.200001 378.924988)(-181.531998 11.796700 449.445007)(-181.525009 12.891000 449.445007)(-179.389999 41.200001 378.924988)(-181.525009 12.891000 449.445007)(-181.500000 17.228500 449.445007)(-179.389999 88.012001 388.846008)(-179.389999 41.200001 378.924988)(-181.500000 17.228500 449.445007)(-179.389999 -0.441005 375.324982)(-181.557999 -7.341420 449.445007)(-181.576004 -0.441008 449.445007)(-179.389999 0.441005 375.324982)(-179.389999 -0.441005 375.324982)(-181.576004 -0.441008 449.445007)(-180.686005 52.620197 425.911987)(-181.647003 41.462997 453.144989)(-181.731003 43.294701 455.464996)(-179.389999 -63.845001 545.104980)(-179.389999 -94.904999 463.443024)(-179.389999 -78.511002 545.104980)(-181.576004 0.441008 449.445007)(-179.389999 0.441005 375.324982)(-181.576004 -0.441008 449.445007)(-180.686005 52.620197 425.911987)(-181.731003 43.294701 455.464996)(-181.832993 44.672401 458.121979)(-181.531998 11.796700 449.445007)(-179.389999 41.200001 378.924988)(-181.557999 7.341420 449.445007)(-181.647003 -41.462997 453.144989)(-180.686005 -52.620197 425.911987)(-181.731003 -43.294701 455.464996)(-179.389999 -41.200001 378.924988)(-181.557999 -7.341420 449.445007)(-179.389999 -0.441005 375.324982)(-181.557999 -7.341420 449.445007)(-179.389999 -41.200001 378.924988)(-181.531998 -11.796700 449.445007)(-181.504990 -24.960199 449.445007)(-181.501999 -21.139999 449.445007)(-180.686005 -52.620197 425.911987)(-180.686005 52.620197 425.911987)(-181.645004 41.395500 453.091003)(-181.647003 41.462997 453.144989)(-181.572006 -38.800499 451.075989)(-180.686005 -52.620197 425.911987)(-181.574005 -38.924000 451.126984)(-181.832993 -44.672401 458.121979)(-180.686005 -52.620197 425.911987)(-181.838013 -44.763500 458.429993)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 13308 -> 91 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -53.583000 -33.394001 229.616001) (float-vector -62.410999 9.556000 229.616001) (float-vector -122.964002 -45.035999 263.453007)))
    (instance face :init :vertices (list (float-vector -174.177006 95.821999 377.274990) (float-vector -120.144002 52.723002 263.397992) (float-vector -22.179000 140.348002 249.378994) (float-vector -170.672998 103.359997 379.379004)))
    (instance face :init :vertices (list (float-vector 25.664000 137.769997 250.070006) (float-vector 59.209999 21.924000 229.616001) (float-vector 59.000000 68.695001 261.999995)))
    (instance face :init :vertices (list (float-vector -172.671005 -101.859003 538.222015) (float-vector -16.907001 -218.152002 505.162001) (float-vector -16.447000 -218.894005 495.162010) (float-vector -170.672998 -103.359997 379.379004) (float-vector -179.389998 -95.949002 526.394010)))
    (instance face :init :vertices (list (float-vector -173.253000 -85.556999 548.662007) (float-vector -172.671005 -101.859003 538.222015) (float-vector -179.389998 -95.949002 526.394010) (float-vector -179.389998 -78.511000 545.104980)))
    (instance face :init :vertices (list (float-vector -6.481010 -147.615001 247.430995) (float-vector 10.900000 -146.678001 247.682005) (float-vector 36.070000 -51.817998 229.616001) (float-vector -12.710000 -61.841998 229.616001)))
    (instance face :init :vertices (list (float-vector 62.896602 0.000000 229.616001) (float-vector 62.412001 -9.556000 229.616001) (float-vector 59.000000 -68.695001 261.999995) (float-vector 71.442001 -17.107001 262.216985)))
    (instance face :init :vertices (list (float-vector -5.454000 -222.441003 505.162001) (float-vector -5.454000 -222.616002 495.162010) (float-vector -16.447000 -218.894005 495.162010) (float-vector -16.907001 -218.152002 505.162001)))
    (instance face :init :vertices (list (float-vector -179.389998 90.622000 401.414990) (float-vector -179.389998 95.949002 526.394010) (float-vector -186.770007 21.199999 463.954985)))
    (instance face :init :vertices (list (float-vector -186.770007 -21.199999 463.954985) (float-vector -186.770007 21.199999 463.954985) (float-vector -179.389998 95.949002 526.394010) (float-vector -179.389998 78.511000 545.104980) (float-vector -179.389998 -78.511000 545.104980) (float-vector -179.389998 -95.949002 526.394010)))
    (instance face :init :vertices (list (float-vector -179.389998 95.949002 526.394010) (float-vector -179.389998 90.622000 401.414990) (float-vector -174.177006 95.821999 377.274990) (float-vector -170.672998 103.359997 379.379004)))
    (instance face :init :vertices (list (float-vector -179.389998 95.949002 526.394010) (float-vector -172.671005 101.859003 538.222015) (float-vector -173.260003 92.579000 546.386003) (float-vector -179.389998 78.511000 545.104980)))
    (instance face :init :vertices (list (float-vector -62.410999 9.556000 229.616001) (float-vector -120.144002 52.723002 263.397992) (float-vector -124.936000 19.788001 263.491988) (float-vector -122.964002 -45.035999 263.453007)))
    (instance face :init :vertices (list (float-vector -124.936000 19.788001 263.491988) (float-vector -120.144002 52.723002 263.397992) (float-vector -174.177006 95.821999 377.274990) (float-vector -179.389998 0.441005 375.324994)))
    (instance face :init :vertices (list (float-vector -174.177006 -95.821999 377.274990) (float-vector -122.964002 -45.035999 263.453007) (float-vector -124.936000 19.788001 263.491988) (float-vector -179.389998 0.441005 375.324994) (float-vector -179.389998 -41.200001 378.924996)))
    (instance face :init :vertices (list (float-vector 77.800997 68.164997 419.658005) (float-vector 84.684998 33.971000 479.099005) (float-vector 77.800997 78.636996 492.309004)))
    (instance face :init :vertices (list (float-vector 36.775999 207.522005 495.162010) (float-vector 77.800997 68.164997 419.658005) (float-vector 77.800997 78.636996 492.309004)))
    (instance face :init :vertices (list (float-vector 77.800997 68.164997 419.658005) (float-vector 36.775999 207.522005 495.162010) (float-vector 59.000000 68.695001 261.999995)))
    (instance face :init :vertices (list (float-vector 71.442001 17.107001 262.216985) (float-vector 77.800997 68.164997 419.658005) (float-vector 59.000000 68.695001 261.999995)))
    (instance face :init :vertices (list (float-vector 59.000000 68.695001 261.999995) (float-vector 59.209999 21.924000 229.616001) (float-vector 62.896602 0.000000 229.616001) (float-vector 71.442001 17.107001 262.216985)))
    (instance face :init :vertices (list (float-vector 77.800997 -68.164997 419.658005) (float-vector 71.442001 -17.107001 262.216985) (float-vector 59.000000 -68.695001 261.999995)))
    (instance face :init :vertices (list (float-vector 59.000000 -68.695001 261.999995) (float-vector 36.775999 -207.522005 495.162010) (float-vector 67.601003 -112.671003 480.468005) (float-vector 77.800997 -68.164997 419.658005)))
    (instance face :init :vertices (list (float-vector 2.270990 148.206994 247.272998) (float-vector -5.454000 222.616002 495.162010) (float-vector -16.447000 218.894005 495.162010) (float-vector -170.672998 103.359997 379.379004) (float-vector -22.179000 140.348002 249.378994)))
    (instance face :init :vertices (list (float-vector 21.304000 221.847996 495.162010) (float-vector 5.425000 222.441003 505.162001) (float-vector -5.454000 222.616002 495.162010) (float-vector 2.270990 148.206994 247.272998)))
    (instance face :init :vertices (list (float-vector 53.583000 -33.394001 229.616001) (float-vector 25.664000 -137.769997 250.070006) (float-vector 59.000000 -68.695001 261.999995) (float-vector 62.412001 -9.556000 229.616001)))
    (instance face :init :vertices (list (float-vector 53.583000 -33.394001 229.616001) (float-vector 36.070000 -51.817998 229.616001) (float-vector 10.900000 -146.678001 247.682005) (float-vector 25.664000 -137.769997 250.070006)))
    (instance face :init :vertices (list (float-vector 31.709999 -216.707006 495.162010) (float-vector 36.775999 -207.522005 495.162010) (float-vector 59.000000 -68.695001 261.999995) (float-vector 25.664000 -137.769997 250.070006)))
    (instance face :init :vertices (list (float-vector -173.253000 -85.556999 548.662007) (float-vector -9.838000 -209.233001 513.782978) (float-vector -5.454000 -222.441003 505.162001) (float-vector -16.907001 -218.152002 505.162001) (float-vector -172.671005 -101.859003 538.222015)))
    (instance face :init :vertices (list (float-vector -16.907001 218.152002 505.162001) (float-vector -172.671005 101.859003 538.222015) (float-vector -179.389998 95.949002 526.394010) (float-vector -170.672998 103.359997 379.379004) (float-vector -16.447000 218.894005 495.162010)))
    (instance face :init :vertices (list (float-vector -5.454000 -222.616002 495.162010) (float-vector -6.481010 -147.615001 247.430995) (float-vector -22.179000 -140.348002 249.378994) (float-vector -170.672998 -103.359997 379.379004) (float-vector -16.447000 -218.894005 495.162010)))
    (instance face :init :vertices (list (float-vector -22.179000 -140.348002 249.378994) (float-vector -6.481010 -147.615001 247.430995) (float-vector -12.710000 -61.841998 229.616001) (float-vector -53.583000 -33.394001 229.616001)))
    (instance face :init :vertices (list (float-vector -179.389998 -88.012002 388.846010) (float-vector -186.770007 -21.199999 463.954985) (float-vector -179.389998 -95.949002 526.394010)))
    (instance face :init :vertices (list (float-vector -179.389998 -88.012002 388.846010) (float-vector -174.177006 -95.821999 377.274990) (float-vector -179.389998 -41.200001 378.924996)))
    (instance face :init :vertices (list (float-vector -174.177006 95.821999 377.274990) (float-vector -179.389998 90.622000 401.414990) (float-vector -186.770007 21.199999 463.954985) (float-vector -186.770007 -21.199999 463.954985) (float-vector -179.389998 -88.012002 388.846010) (float-vector -179.389998 -41.200001 378.924996) (float-vector -179.389998 0.441005 375.324994)))
    (instance face :init :vertices (list (float-vector -174.177006 -95.821999 377.274990) (float-vector -179.389998 -88.012002 388.846010) (float-vector -179.389998 -95.949002 526.394010) (float-vector -170.672998 -103.359997 379.379004)))
    (instance face :init :vertices (list (float-vector 77.800997 -78.636996 492.309004) (float-vector 77.800997 -68.164997 419.658005) (float-vector 67.601003 -112.671003 480.468005)))
    (instance face :init :vertices (list (float-vector 84.684998 33.971000 479.099005) (float-vector 72.700597 0.000000 262.239009) (float-vector 84.890001 -27.179001 479.101002)))
    (instance face :init :vertices (list (float-vector 77.800997 -68.164997 419.658005) (float-vector 84.890001 -27.179001 479.101002) (float-vector 72.700597 0.000000 262.239009) (float-vector 71.442001 -17.107001 262.216985)))
    (instance face :init :vertices (list (float-vector 72.700597 0.000000 262.239009) (float-vector 84.684998 33.971000 479.099005) (float-vector 77.800997 68.164997 419.658005) (float-vector 71.442001 17.107001 262.216985)))
    (instance face :init :vertices (list (float-vector 72.700597 0.000000 262.239009) (float-vector 71.442001 17.107001 262.216985) (float-vector 62.896602 0.000000 229.616001) (float-vector 71.442001 -17.107001 262.216985)))
    (instance face :init :vertices (list (float-vector -120.144002 52.723002 263.397992) (float-vector -45.763001 43.496002 229.616001) (float-vector -22.179000 140.348002 249.378994)))
    (instance face :init :vertices (list (float-vector -45.763001 43.496002 229.616001) (float-vector -120.144002 52.723002 263.397992) (float-vector -62.410999 9.556000 229.616001)))
    (instance face :init :vertices (list (float-vector -22.179000 140.348002 249.378994) (float-vector -45.763001 43.496002 229.616001) (float-vector -0.000012 63.134998 229.616001) (float-vector 2.270990 148.206994 247.272998)))
    (instance face :init :vertices (list (float-vector -0.000012 63.134998 229.616001) (float-vector 36.070000 51.817998 229.616001) (float-vector 2.270990 148.206994 247.272998)))
    (instance face :init :vertices (list (float-vector -12.710000 -61.841998 229.616001) (float-vector 36.070000 -51.817998 229.616001) (float-vector 53.583000 -33.394001 229.616001) (float-vector 62.412001 -9.556000 229.616001) (float-vector 62.896602 0.000000 229.616001) (float-vector 59.209999 21.924000 229.616001) (float-vector 36.070000 51.817998 229.616001) (float-vector -0.000012 63.134998 229.616001) (float-vector -45.763001 43.496002 229.616001) (float-vector -62.410999 9.556000 229.616001) (float-vector -53.583000 -33.394001 229.616001)))
    (instance face :init :vertices (list (float-vector 2.270990 148.206994 247.272998) (float-vector 36.070000 51.817998 229.616001) (float-vector 59.209999 21.924000 229.616001) (float-vector 25.664000 137.769997 250.070006)))
    (instance face :init :vertices (list (float-vector 21.304000 221.847996 495.162010) (float-vector 22.799000 221.273005 505.162001) (float-vector 5.425000 222.441003 505.162001)))
    (instance face :init :vertices (list (float-vector 21.304000 -221.847996 495.162010) (float-vector 10.900000 -146.678001 247.682005) (float-vector -6.481010 -147.615001 247.430995) (float-vector -5.454000 -222.616002 495.162010)))
    (instance face :init :vertices (list (float-vector 21.304000 -221.847996 495.162010) (float-vector -5.454000 -222.616002 495.162010) (float-vector -5.454000 -222.441003 505.162001) (float-vector 22.799000 -221.273005 505.162001)))
    (instance face :init :vertices (list (float-vector 21.304000 -221.847996 495.162010) (float-vector 31.709999 -216.707006 495.162010) (float-vector 25.664000 -137.769997 250.070006) (float-vector 10.900000 -146.678001 247.682005)))
    (instance face :init :vertices (list (float-vector 22.799000 -221.273005 505.162001) (float-vector 32.177001 -215.849996 505.162001) (float-vector 31.709999 -216.707006 495.162010) (float-vector 21.304000 -221.847996 495.162010)))
    (instance face :init :vertices (list (float-vector 5.425000 222.441003 505.162001) (float-vector -5.454000 222.441003 505.162001) (float-vector -5.454000 222.616002 495.162010)))
    (instance face :init :vertices (list (float-vector -5.454000 222.616002 495.162010) (float-vector -5.454000 222.441003 505.162001) (float-vector -16.907001 218.152002 505.162001) (float-vector -16.447000 218.894005 495.162010)))
    (instance face :init :vertices (list (float-vector -22.179000 -140.348002 249.378994) (float-vector -115.974002 -58.090001 263.316989) (float-vector -170.672998 -103.359997 379.379004)))
    (instance face :init :vertices (list (float-vector -122.964002 -45.035999 263.453007) (float-vector -115.974002 -58.090001 263.316989) (float-vector -22.179000 -140.348002 249.378994) (float-vector -53.583000 -33.394001 229.616001)))
    (instance face :init :vertices (list (float-vector -170.672998 -103.359997 379.379004) (float-vector -115.974002 -58.090001 263.316989) (float-vector -122.964002 -45.035999 263.453007) (float-vector -174.177006 -95.821999 377.274990)))
    (instance face :init :vertices (list (float-vector 25.664000 137.769997 250.070006) (float-vector 31.709999 216.707006 495.162010) (float-vector 22.799000 221.273005 505.162001) (float-vector 21.304000 221.847996 495.162010) (float-vector 2.270990 148.206994 247.272998)))
    (instance face :init :vertices (list (float-vector 67.601003 -101.744004 523.383975) (float-vector 32.177001 -215.849996 505.162001) (float-vector 67.601003 -80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector -9.838000 209.233001 513.782978) (float-vector -173.260003 92.579000 546.386003) (float-vector -172.671005 101.859003 538.222015) (float-vector -16.907001 218.152002 505.162001) (float-vector -5.454000 222.441003 505.162001)))
    (instance face :init :vertices (list (float-vector -15.921000 -183.937997 525.391996) (float-vector -9.838000 -209.233001 513.782978) (float-vector -173.253000 -85.556999 548.662007)))
    (instance face :init :vertices (list (float-vector -15.921000 -183.937997 525.391996) (float-vector 24.948001 -196.933001 521.754026) (float-vector -9.838000 -209.233001 513.782978)))
    (instance face :init :vertices (list (float-vector 32.177001 -215.849996 505.162001) (float-vector 24.948001 -196.933001 521.754026) (float-vector 67.601003 -80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector 24.948001 -196.933001 521.754026) (float-vector 41.972999 -92.265002 551.796973) (float-vector 67.601003 -80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector 24.948001 -196.933001 521.754026) (float-vector -15.921000 -183.937997 525.391996) (float-vector -173.253000 -85.556999 548.662007) (float-vector 41.972999 -92.265002 551.796973)))
    (instance face :init :vertices (list (float-vector -9.838000 -209.233001 513.782978) (float-vector 24.948001 -196.933001 521.754026) (float-vector 32.177001 -215.849996 505.162001) (float-vector 22.799000 -221.273005 505.162001) (float-vector -5.454000 -222.441003 505.162001)))
    (instance face :init :vertices (list (float-vector 77.800997 -62.128000 521.061003) (float-vector 67.601003 -101.744004 523.383975) (float-vector 67.601003 -80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector 31.709999 -216.707006 495.162010) (float-vector 32.177001 -215.849996 505.162001) (float-vector 67.601003 -101.744004 523.383975) (float-vector 77.800997 -62.128000 521.061003) (float-vector 77.800997 -78.636996 492.309004) (float-vector 67.601003 -112.671003 480.468005) (float-vector 36.775999 -207.522005 495.162010)))
    (instance face :init :vertices (list (float-vector 77.800997 -78.636996 492.309004) (float-vector 77.800997 -62.128000 521.061003) (float-vector 84.890001 -27.179001 479.101002) (float-vector 77.800997 -68.164997 419.658005)))
    (instance face :init :vertices (list (float-vector -173.260003 92.579000 546.386003) (float-vector -172.479004 55.881999 550.620973) (float-vector -173.253000 -85.556999 548.662007) (float-vector -179.389998 -78.511000 545.104980) (float-vector -179.389998 78.511000 545.104980)))
    (instance face :init :vertices (list (float-vector -9.838000 209.233001 513.782978) (float-vector 24.948001 196.933001 521.754026) (float-vector -173.260003 92.579000 546.386003)))
    (instance face :init :vertices (list (float-vector 5.425000 222.441003 505.162001) (float-vector 22.799000 221.273005 505.162001) (float-vector 24.948001 196.933001 521.754026) (float-vector -9.838000 209.233001 513.782978) (float-vector -5.454000 222.441003 505.162001)))
    (instance face :init :vertices (list (float-vector 41.972999 -92.265002 551.796973) (float-vector 68.406001 -43.556001 546.675026) (float-vector 67.601003 -80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector -11.504000 88.339999 551.712990) (float-vector -172.479004 55.881999 550.620973) (float-vector -173.260003 92.579000 546.386003)))
    (instance face :init :vertices (list (float-vector -172.479004 55.881999 550.620973) (float-vector -11.504000 88.339999 551.712990) (float-vector 41.978002 54.875001 553.933978) (float-vector 41.972999 -92.265002 551.796973) (float-vector -173.253000 -85.556999 548.662007)))
    (instance face :init :vertices (list (float-vector -11.504000 88.339999 551.712990) (float-vector 41.972999 92.265002 551.796973) (float-vector 41.978002 54.875001 553.933978)))
    (instance face :init :vertices (list (float-vector -11.504000 88.339999 551.712990) (float-vector -173.260003 92.579000 546.386003) (float-vector 24.948001 196.933001 521.754026) (float-vector 41.972999 92.265002 551.796973)))
    (instance face :init :vertices (list (float-vector 67.601003 -80.802001 539.831996) (float-vector 68.406001 -43.556001 546.675026) (float-vector 77.800401 0.000000 529.999971) (float-vector 77.800997 -62.128000 521.061003)))
    (instance face :init :vertices (list (float-vector 67.601003 80.802001 539.831996) (float-vector 41.972999 92.265002 551.796973) (float-vector 24.948001 196.933001 521.754026)))
    (instance face :init :vertices (list (float-vector 67.601003 80.802001 539.831996) (float-vector 68.406001 43.556001 546.675026) (float-vector 41.972999 92.265002 551.796973)))
    (instance face :init :vertices (list (float-vector 68.406001 43.556001 546.675026) (float-vector 77.800401 0.000000 529.999971) (float-vector 68.406001 -43.556001 546.675026)))
    (instance face :init :vertices (list (float-vector 41.978002 54.875001 553.933978) (float-vector 41.972999 92.265002 551.796973) (float-vector 68.406001 43.556001 546.675026) (float-vector 68.406001 -43.556001 546.675026) (float-vector 41.972999 -92.265002 551.796973)))
    (instance face :init :vertices (list (float-vector 31.709999 216.707006 495.162010) (float-vector 36.662001 207.232997 505.162001) (float-vector 22.799000 221.273005 505.162001)))
    (instance face :init :vertices (list (float-vector 36.662001 207.232997 505.162001) (float-vector 24.948001 196.933001 521.754026) (float-vector 22.799000 221.273005 505.162001)))
    (instance face :init :vertices (list (float-vector 36.662001 207.232997 505.162001) (float-vector 67.601003 80.802001 539.831996) (float-vector 24.948001 196.933001 521.754026)))
    (instance face :init :vertices (list (float-vector 36.662001 207.232997 505.162001) (float-vector 67.601003 101.744004 523.383975) (float-vector 67.601003 80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector 36.662001 207.232997 505.162001) (float-vector 31.709999 216.707006 495.162010) (float-vector 25.664000 137.769997 250.070006) (float-vector 59.000000 68.695001 261.999995) (float-vector 36.775999 207.522005 495.162010)))
    (instance face :init :vertices (list (float-vector 84.684998 33.971000 479.099005) (float-vector 77.800997 62.128000 521.061003) (float-vector 77.800997 78.636996 492.309004)))
    (instance face :init :vertices (list (float-vector 67.601003 101.744004 523.383975) (float-vector 77.800997 62.128000 521.061003) (float-vector 67.601003 80.802001 539.831996)))
    (instance face :init :vertices (list (float-vector 77.800401 0.000000 529.999971) (float-vector 77.800997 62.128000 521.061003) (float-vector 84.684998 33.971000 479.099005) (float-vector 84.890001 -27.179001 479.101002) (float-vector 77.800997 -62.128000 521.061003)))
    (instance face :init :vertices (list (float-vector 68.406001 43.556001 546.675026) (float-vector 67.601003 80.802001 539.831996) (float-vector 77.800997 62.128000 521.061003) (float-vector 77.800401 0.000000 529.999971)))
    (instance face :init :vertices (list (float-vector 36.775999 207.522005 495.162010) (float-vector 77.800997 78.636996 492.309004) (float-vector 77.800997 62.128000 521.061003) (float-vector 67.601003 101.744004 523.383975) (float-vector 36.662001 207.232997 505.162001)))
    ))
   )
  )

(defclass HiroNX_g1_2_geom0
  :super collada-body
  :slots ())
(defmethod HiroNX_g1_2_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.900000 0.900000 0.900000 1.000000))
           ))
           (list :indices #i( 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256 257 258 259 260 261 262 263 264 265 266 267 268 269 270 271 272 273 274 275 276 277 278 279 280 281 282 283 284 285 286 287 288 289 290 291 292 293 294 295 296 297 298 299 300 301 302 303 304 305 306 307 308 309 310 311 312 313 314 315 316 317 318 319 320 321 322 323 324 325 326 327 328 329 330 331 332 333 334 335 336 337 338 339 340 341 342 343 344 345 346 347 348 349 350 351 352 353 354 355 356 357 358 359 360 361 362 363 364 365 366 367 368 369 370 371 372 373 374 375 376 377 378 379 380 381 382 383 384 385 386 387 388 389 390 391 392 393 394 395 396 397 398 399 400 401 402 403 404 405 406 407 408 409 410 411 412 413 414 415 416 417 418 419 420 421 422 423 424 425 426 427 428 429 430 431 432 433 434 435 436 437 438 439 440 441 442 443 444 445 446 447 448 449 450 451 452 453 454 455 456 457 458 459 460 461 462 463 464 465 466 467 468 469 470 471 472 473 474 475 476 477 478 479 480 481 482 483 484 485 486 487 488 489 490 491 492 493 494 495 496 497 498 499 500 501 502 503 504 505 506 507 508 509 510 511 512 513 514 515 516 517 518 519 520 521 522 523 524 525 526 527 528 529 530 531 532 533 534 535 536 537 538 539 540 541 542 543 544 545 546 547 548 549 550 551 552 553 554 555 556 557 558 559 560 561 562 563 564 565 566 567 568 569 570 571 572 573 574 575 576 577 578 579 580 581 582 583 584 585 586 587 588 589 590 591 592 593 594 595 596 597 598 599 600 601 602 603 604 605 606 607 608 609 610 611 612 613 614 615 616 617 618 619 620 621 622 623 624 625 626 627 628 629 630 631 632 633 634 635 636 637 638 639 640 641 642 643 644 645 646 647 648 649 650 651 652 653 654 655 656 657 658 659 660 661 662 663 664 665 666 667 668 669 670 671 672 673 674 675 676 677 678 679 680 681 682 683 684 685 686 687 688 689 690 691 692 693 694 695 696 697 698 699 700 701 702 703 704 705 706 707 708 709 710 711 712 713 714 715 716 717 718 719 720 721 722 723 724 725 726 727 728 729 730 731 732 733 734 735 736 737 738 739 740 741 742 743 744 745 746 747 748 749 750 751 752 753 754 755 756 757 758 759 760 761 762 763 764 765 766 767 768 769 770 771 772 773 774 775 776 777 778 779 780 781 782 783 784 785 786 787 788 789 790 791 792 793 794 795 796 797 798 799 800 801 802 803 804 805 806 807 808 809 810 811 812 813 814 815 816 817 818 819 820 821 822 823 824 825 826 827 828 829 830 831 832 833 834 835 836 837 838 839 840 841 842 843 844 845 846 847 848 849 850 851 852 853 854 855 856 857 858 859 860 861 862 863 864 865 866 867 868 869 870 871 872 873 874 875 876 877 878 879 880 881 882 883 884 885 886 887 888 889 890 891 892 893 894 895 896 897 898 899 900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915 916 917 918 919 920 921 922 923 924 925 926 927 928 929 930 931 932 933 934 935 936 937 938 939 940 941 942 943 944 945 946 947 948 949 950 951 952 953 954 955 956 957 958 959 960 961 962 963 964 965 966 967 968 969 970 971 972 973 974 975 976 977 978 979 980 981 982 983 984 985 986 987 988 989 990 991 992 993 994 995 996 997 998 999 1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248 1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 1295 1296 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 1312 1313 1314 1315 1316 1317 1318 1319 1320 1321 1322 1323 1324 1325 1326 1327 1328 1329 1330 1331 1332 1333 1334 1335 1336 1337 1338 1339 1340 1341 1342 1343 1344 1345 1346 1347 1348 1349 1350 1351 1352 1353 1354 1355 1356 1357 1358 1359 1360 1361 1362 1363 1364 1365 1366 1367 1368 1369 1370 1371 1372 1373 1374 1375 1376 1377 1378 1379 1380 1381 1382 1383 1384 1385 1386 1387 1388 1389 1390 1391 1392 1393 1394 1395 1396 1397 1398 1399 1400 1401 1402 1403 1404 1405 1406 1407 1408 1409 1410 1411 1412 1413 1414 1415 1416 1417 1418 1419 1420 1421 1422 1423 1424 1425 1426 1427 1428 1429 1430 1431 1432 1433 1434 1435 1436 1437 1438 1439 1440 1441 1442 1443 1444 1445 1446 1447 1448 1449 1450 1451 1452 1453 1454 1455 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1473 1474 1475 1476 1477 1478 1479 1480 1481 1482 1483 1484 1485 1486 1487 1488 1489 1490 1491 1492 1493 1494 1495 1496 1497 1498 1499 1500 1501 1502 1503 1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1520 1521 1522 1523 1524 1525 1526 1527 1528 1529 1530 1531 1532 1533 1534 1535 1536 1537 1538 1539 1540 1541 1542 1543 1544 1545 1546 1547 1548 1549 1550 1551 1552 1553 1554 1555 1556 1557 1558 1559 1560 1561 1562 1563 1564 1565 1566 1567 1568 1569 1570 1571 1572 1573 1574 1575 1576 1577 1578 1579 1580 1581 1582 1583 1584 1585 1586 1587 1588 1589 1590 1591 1592 1593 1594 1595 1596 1597 1598 1599 1600 1601 1602 1603 1604 1605 1606 1607 1608 1609 1610 1611 1612 1613 1614 1615 1616 1617 1618 1619 1620 1621 1622 1623 1624 1625 1626 1627 1628 1629 1630 1631 1632 1633 1634 1635 1636 1637 1638 1639 1640 1641 1642 1643 1644 1645 1646 1647 1648 1649 1650 1651 1652 1653 1654 1655 1656 1657 1658 1659 1660 1661 1662 1663 1664 1665 1666 1667 1668 1669 1670 1671 1672 1673 1674 1675 1676 1677 1678 1679 1680 1681 1682 1683 1684 1685 1686 1687 1688 1689 1690 1691 1692 1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721 1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733 1734 1735 1736 1737 1738 1739 1740 1741 1742 1743 1744 1745 1746 1747 1748 1749 1750 1751 1752 1753 1754 1755 1756 1757 1758 1759 1760 1761 1762 1763 1764 1765 1766 1767 1768 1769 1770 1771 1772 1773 1774 1775 1776 1777 1778 1779 1780 1781 1782 1783 1784 1785 1786 1787 1788 1789 1790 1791 1792 1793 1794 1795 1796 1797 1798 1799 1800 1801 1802 1803 1804 1805 1806 1807 1808 1809 1810 1811 1812 1813 1814 1815 1816 1817 1818 1819 1820 1821 1822 1823 1824 1825 1826 1827 1828 1829 1830 1831 1832 1833 1834 1835 1836 1837 1838 1839 1840 1841 1842 1843 1844 1845 1846 1847 1848 1849 1850 1851 1852 1853 1854 1855 1856 1857 1858 1859 1860 1861 1862 1863 1864 1865 1866 1867 1868 1869 1870 1871 1872 1873 1874 1875 1876 1877 1878 1879 1880 1881 1882 1883 1884 1885 1886 1887 1888 1889 1890 1891 1892 1893 1894 1895 1896 1897 1898 1899 1900 1901 1902 1903 1904 1905 1906 1907 1908 1909 1910 1911 1912 1913 1914 1915 1916 1917 1918 1919 1920 1921 1922 1923 1924 1925 1926 1927 1928 1929 1930 1931 1932 1933 1934 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1961 1962 1963 1964 1965 1966 1967 1968 1969 1970 1971 1972 1973 1974 1975 1976 1977 1978 1979 1980 1981 1982 1983 1984 1985 1986 1987 1988 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 2023 2024 2025 2026 2027 2028 2029 2030 2031 2032 2033 2034 2035 2036 2037 2038 2039 2040 2041 2042 2043 2044 2045 2046 2047 2048 2049 2050 2051 2052 2053 2054 2055 2056 2057 2058 2059 2060 2061 2062 2063 2064 2065 2066 2067 2068 2069 2070 2071 2072 2073 2074 2075 2076 2077 2078 2079 2080 2081 2082 2083 2084 2085 2086 2087 2088 2089 2090 2091 2092 2093 2094 2095 2096 2097 2098 2099 2100 2101 2102 2103 2104 2105 2106 2107 2108 2109 2110 2111 2112 2113 2114 2115 2116 2117 2118 2119 2120 2121 2122 2123 2124 2125 2126 2127 2128 2129 2130 2131 2132 2133 2134 2135 2136 2137 2138 2139 2140 2141 2142 2143 2144 2145 2146 2147 2148 2149 2150 2151 2152 2153 2154 2155 2156 2157 2158 2159 2160 2161 2162 2163 2164 2165 2166 2167 2168 2169 2170 2171 2172 2173 2174 2175 2176 2177 2178 2179 2180 2181 2182 2183 2184 2185 2186 2187 2188 2189 2190 2191 2192 2193 2194 2195 2196 2197 2198 2199 2200 2201 2202 2203 2204 2205 2206 2207 2208 2209 2210 2211 2212 2213 2214 2215 2216 2217 2218 2219 2220 2221 2222 2223 2224 2225 2226 2227 2228 2229 2230 2231 2232 2233 2234 2235 2236 2237 2238 2239 2240 2241 2242 2243 2244 2245 2246 2247 2248 2249 2250 2251 2252 2253 2254 2255 2256 2257 2258 2259 2260 2261 2262 2263 2264 2265 2266 2267 2268 2269 2270 2271 2272 2273 2274 2275 2276 2277 2278 2279 2280 2281 2282 2283 2284 2285 2286 2287 2288 2289 2290 2291 2292 2293 2294 2295 2296 2297 2298 2299 2300 2301 2302 2303 2304 2305 2306 2307 2308 2309 2310 2311 2312 2313 2314 2315 2316 2317 2318 2319 2320 2321 2322 2323 2324 2325 2326 2327 2328 2329 2330 2331 2332 2333 2334 2335 2336 2337 2338 2339 2340 2341 2342 2343 2344 2345 2346 2347 2348 2349 2350 2351 2352 2353 2354 2355 2356 2357 2358 2359 2360 2361 2362 2363 2364 2365 2366 2367 2368 2369 2370 2371 2372 2373 2374 2375 2376 2377 2378 2379 2380 2381 2382 2383 2384 2385 2386 2387 2388 2389 2390 2391 2392 2393 2394 2395 2396 2397 2398 2399 2400 2401 2402 2403 2404 2405 2406 2407 2408 2409 2410 2411 2412 2413 2414 2415 2416 2417 2418 2419 2420 2421 2422 2423 2424 2425 2426 2427 2428 2429 2430 2431 2432 2433 2434 2435 2436 2437 2438 2439 2440 2441 2442 2443 2444 2445 2446 2447 2448 2449 2450 2451 2452 2453 2454 2455 2456 2457 2458 2459 2460 2461 2462 2463 2464 2465 2466 2467 2468 2469 2470 2471 2472 2473 2474 2475 2476 2477 2478 2479 2480 2481 2482 2483 2484 2485 2486 2487 2488 2489 2490 2491 2492 2493 2494 2495 2496 2497 2498 2499 2500 2501 2502 2503 2504 2505 2506 2507 2508 2509 2510 2511 2512 2513 2514 2515 2516 2517 2518 2519 2520 2521 2522 2523 2524 2525 2526 2527 2528 2529 2530 2531 2532 2533 2534 2535 2536 2537 2538 2539 2540 2541 2542 2543 2544 2545 2546 2547 2548 2549 2550 2551 2552 2553 2554 2555 2556 2557 2558 2559 2560 2561 2562 2563 2564 2565 2566 2567 2568 2569 2570 2571 2572 2573 2574 2575 2576 2577 2578 2579 2580 2581 2582 2583 2584 2585 2586 2587 2588 2589 2590 2591 2592 2593 2594 2595 2596 2597 2598 2599 2600 2601 2602 2603 2604 2605 2606 2607 2608 2609 2610 2611 2612 2613 2614 2615 2616 2617 2618 2619 2620 2621 2622 2623 2624 2625 2626 2627 2628 2629 2630 2631 2632 2633 2634 2635 2636 2637 2638 2639 2640 2641 2642 2643 2644 2645 2646 2647 2648 2649 2650 2651 2652 2653 2654 2655 2656 2657 2658 2659 2660 2661 2662 2663 2664 2665 2666 2667 2668 2669 2670 2671 2672 2673 2674 2675 2676 2677 2678 2679 2680 2681 2682 2683 2684 2685 2686 2687 2688 2689 2690 2691 2692 2693 2694 2695 2696 2697 2698 2699 2700 2701 2702 2703 2704 2705 2706 2707 2708 2709 2710 2711 2712 2713 2714 2715 2716 2717 2718 2719 2720 2721 2722 2723 2724 2725 2726 2727 2728 2729 2730 2731 2732 2733 2734 2735 2736 2737 2738 2739 2740 2741 2742 2743 2744 2745 2746 2747 2748 2749 2750 2751 2752 2753 2754 2755 2756 2757 2758 2759 2760 2761 2762 2763 2764 2765 2766 2767 2768 2769 2770 2771 2772 2773 2774 2775 2776 2777 2778 2779 2780 2781 2782 2783 2784 2785 2786 2787 2788 2789 2790 2791 2792 2793 2794 2795 2796 2797 2798 2799 2800 2801 2802 2803 2804 2805 2806 2807 2808 2809 2810 2811 2812 2813 2814 2815 2816 2817 2818 2819 2820 2821 2822 2823 2824 2825 2826 2827 2828 2829 2830 2831 2832 2833 2834 2835 2836 2837 2838 2839 2840 2841 2842 2843 2844 2845 2846 2847 2848 2849 2850 2851 2852 2853 2854 2855 2856 2857 2858 2859 2860 2861 2862 2863 2864 2865 2866 2867 2868 2869 2870 2871 2872 2873 2874 2875 2876 2877 2878 2879 2880 2881 2882 2883 2884 2885 2886 2887 2888 2889 2890 2891 2892 2893 2894 2895 2896 2897 2898 2899 2900 2901 2902 2903 2904 2905 2906 2907 2908 2909 2910 2911 2912 2913 2914 2915 2916 2917 2918 2919 2920 2921 2922 2923 2924 2925 2926 2927 2928 2929 2930 2931 2932 2933 2934 2935 2936 2937 2938 2939 2940 2941 2942 2943 2944 2945 2946 2947 2948 2949 2950 2951 2952 2953 2954 2955 2956 2957 2958 2959 2960 2961 2962 2963 2964 2965 2966 2967 2968 2969 2970 2971 2972 2973 2974 2975 2976 2977 2978 2979 2980 2981 2982 2983 2984 2985 2986 2987 2988 2989 2990 2991 2992 2993 2994 2995 2996 2997 2998 2999 3000 3001 3002 3003 3004 3005 3006 3007 3008 3009 3010 3011 3012 3013 3014 3015 3016 3017 3018 3019 3020 3021 3022 3023 3024 3025 3026 3027 3028 3029 3030 3031 3032 3033 3034 3035))
           (list :vertices #2f((-11.213300 17.698900 -20.036600)(-11.404900 17.533300 -19.957300)(-11.495000 23.500000 -19.920000)(-11.404900 17.533300 -19.957300)(-11.213300 17.698900 -20.036600)(-10.915000 17.937000 -20.243000)(-10.915000 17.937000 -20.243000)(-11.213300 17.698900 -20.036600)(-10.832601 17.875399 -20.194300)(-11.404900 17.533300 -19.957300)(-11.495000 17.455200 -19.920000)(-11.495000 23.500000 -19.920000)(15.351999 -14.334000 -25.001001)(16.118599 -13.088400 -16.378700)(15.294200 -13.970500 -17.011501)(15.351999 -14.334000 -25.001001)(16.268000 -12.928500 -16.264002)(16.118599 -13.088400 -16.378700)(15.351999 -14.334000 -25.001001)(17.560999 -11.523000 -14.859000)(16.268000 -12.928500 -16.264002)(17.560999 -11.523000 -14.859000)(15.351999 -14.334000 -25.001001)(18.650002 -9.661000 -25.001001)(-5.804300 -20.158701 -22.235901)(-5.661000 -20.221001 -22.292000)(-5.948000 -20.096199 -22.216999)(-5.804300 -20.158701 -22.235901)(-5.661000 -20.221001 -22.292000)(-0.666437 -20.903301 -22.912600)(-5.948000 -23.600000 -22.216999)(-5.804300 -20.158701 -22.235901)(-4.459750 -21.879398 -22.413000)(-5.804300 -20.158701 -22.235901)(-2.971500 -21.848099 -22.608999)(-4.459750 -21.879398 -22.413000)(-2.971500 -21.848099 -22.608999)(-5.948000 -23.600000 -22.216999)(-4.459750 -21.879398 -22.413000)(-2.971500 -21.848099 -22.608999)(-5.804300 -20.158701 -22.235901)(-0.666437 -20.903301 -22.912600)(-0.064241 -20.990499 -22.991899)(-2.862620 -20.605700 -22.641901)(-2.803000 -20.811001 -22.829000)(-0.064241 -20.990499 -22.991899)(-0.329676 -20.952000 -22.956900)(-2.862620 -20.605700 -22.641901)(-2.862620 -20.605700 -22.641901)(-0.329676 -20.952000 -22.956900)(-0.666437 -20.903301 -22.912600)(-0.666437 -20.903301 -22.912600)(-5.661000 -20.221001 -22.292000)(-2.862620 -20.605700 -22.641901)(0.005003 -23.600000 -23.000999)(-0.666437 -20.903301 -22.912600)(-0.329676 -20.952000 -22.956900)(-2.803000 -20.811001 -22.829000)(-2.833150 -20.618900 -23.932699)(-0.064241 -20.990499 -22.991899)(-0.005297 -20.993599 -22.999599)(-2.833150 -20.618900 -23.932699)(-0.064241 -20.990499 -22.991899)(-2.833150 -20.618900 -23.932699)(-5.661000 -20.221001 -25.001001)(-0.005297 -20.993599 -22.999599)(0.005004 -29.000000 -25.001001)(0.005003 -21.000000 -25.001001)(-5.661000 -20.221001 -25.001001)(-6.935000 -28.157000 -25.001001)(0.005004 -29.000000 -25.001001)(-5.661000 -20.221001 -25.001001)(-6.935000 -28.157000 -25.001001)(-5.661000 -20.221001 -25.001001)(-10.907000 -17.943001 -25.001001)(-5.661000 -20.221001 -22.292000)(-10.907000 -17.943001 -25.001001)(-5.661000 -20.221001 -25.001001)(-5.661000 -20.221001 -22.292000)(-5.661000 -20.221001 -25.001001)(-2.803000 -20.811001 -22.829000)(-5.661000 -20.221001 -25.001001)(-2.833150 -20.618900 -23.932699)(-2.803000 -20.811001 -22.829000)(0.005003 -23.600000 -23.000999)(-2.971500 -21.848099 -22.608999)(-0.666437 -20.903301 -22.912600)(-5.948000 -23.600000 -22.216999)(-5.948000 -20.096199 -22.216999)(-5.804300 -20.158701 -22.235901)(-0.005297 -20.993599 -22.999599)(-5.661000 -20.221001 -25.001001)(0.005003 -21.000000 -25.001001)(-0.005297 -20.993599 -22.999599)(-0.064241 -20.990499 -22.991899)(0.005003 -20.995001 -23.000999)(-27.111000 -10.283000 -25.001001)(-27.111000 10.284000 -25.001001)(-28.783998 3.496000 -25.001001)(-23.862001 -16.473999 -25.001001)(-27.111000 10.284000 -25.001001)(-27.111000 -10.283000 -25.001001)(8.731501 20.441200 -21.068501)(6.774760 19.763102 -21.878799)(5.958000 23.500000 -22.216999)(8.731501 20.441200 -21.068501)(5.958000 23.500000 -22.216999)(8.731501 21.970600 -21.068501)(5.958000 23.500000 -22.216999)(11.505000 23.500000 -19.920000)(8.731501 21.970600 -21.068501)(11.505000 23.500000 -19.920000)(8.731501 20.441200 -21.068501)(8.731501 21.970600 -21.068501)(21.005001 -0.001000 -9.382000)(20.853100 -1.068300 -9.502220)(20.896999 -2.125000 -9.619000)(21.005001 -0.001000 -9.382000)(20.896999 -2.125000 -9.619000)(20.955999 1.433000 -25.001001)(20.896999 -2.125000 -9.619000)(20.566000 -4.273000 -25.001001)(20.955999 1.433000 -25.001001)(28.898998 -0.000500 -26.250999)(28.792999 3.495000 -25.001001)(28.792999 -3.496000 -25.001001)(28.792999 3.495000 -25.001001)(28.898998 -0.000500 -26.250999)(29.005001 -0.000002 -27.500999)(27.119999 10.283000 -25.001001)(28.792999 -3.496000 -25.001001)(28.792999 3.495000 -25.001001)(18.095501 -16.185400 -13.882500)(19.923000 -23.600000 -11.501000)(16.268000 -23.600000 -16.264002)(19.923000 -23.600000 -11.501000)(18.095501 -16.185400 -13.882500)(18.772200 -8.770841 -13.000600)(18.772200 -8.770841 -13.000600)(19.683401 -7.056580 -11.813300)(19.923000 -23.600000 -11.501000)(-5.948000 -23.600000 -22.216999)(16.268000 -23.600000 -16.264002)(19.923000 -23.600000 -11.501000)(19.991400 6.352780 -11.335900)(19.955400 6.483600 -11.422899)(20.028999 6.329000 -11.316999)(19.998901 6.330440 -11.317901)(19.991400 6.352780 -11.335900)(20.028999 6.329000 -11.316999)(19.955400 6.483600 -11.422899)(19.998901 6.330440 -11.317901)(19.991400 6.352780 -11.335900)(19.923000 23.500000 -11.501000)(19.998901 6.330440 -11.317901)(19.955400 6.483600 -11.422899)(19.923000 23.500000 -11.501000)(19.955400 6.483600 -11.422899)(19.923000 6.552000 -11.501000)(19.923000 23.500000 -11.501000)(20.701799 2.129080 -9.620950)(19.998901 6.330440 -11.317901)(19.923000 23.500000 -11.501000)(19.923000 6.552000 -11.501000)(19.907700 6.583990 -11.520900)(19.998901 6.330440 -11.317901)(20.701799 2.129080 -9.620950)(20.698502 2.145780 -9.629080)(20.698502 2.145780 -9.629080)(20.701799 2.129080 -9.620950)(20.896999 2.123000 -9.619000)(20.028999 6.329000 -11.316999)(19.998901 6.330440 -11.317901)(20.696800 2.153320 -9.633190)(20.701799 2.129080 -9.620950)(20.702999 2.115380 -9.618160)(20.896999 2.123000 -9.619000)(20.458000 -4.250000 -10.478000)(20.896999 -2.125000 -9.619000)(20.602901 -3.248790 -10.094300)(20.896999 -2.125000 -9.619000)(20.458000 -4.250000 -10.478000)(20.566000 -4.273000 -25.001001)(20.308800 -4.372590 -10.569700)(20.458000 -4.250000 -10.478000)(20.602901 -3.248790 -10.094300)(20.602901 -3.248790 -10.094300)(20.632301 -2.364500 -9.788790)(20.308800 -4.372590 -10.569700)(20.308800 -4.372590 -10.569700)(20.632301 -2.364500 -9.788790)(20.696800 -2.155200 -9.633121)(20.696800 -2.155200 -9.633121)(20.632301 -2.364500 -9.788790)(20.896999 -2.125000 -9.619000)(20.696800 -2.155200 -9.633121)(20.698900 -2.145910 -9.628060)(20.896999 -2.125000 -9.619000)(20.308800 -4.372590 -10.569700)(20.696800 -2.155200 -9.633121)(20.698900 -2.145910 -9.628060)(20.698900 -2.145910 -9.628060)(20.701200 -2.135600 -9.622450)(20.308800 -4.372590 -10.569700)(20.308800 -4.372590 -10.569700)(20.027000 -6.334000 -11.320000)(19.988701 -6.362160 -11.342400)(19.988701 -6.362160 -11.342400)(19.955299 -6.484630 -11.423000)(20.027000 -6.334000 -11.320000)(20.027000 -6.334000 -11.320000)(19.923000 -6.550460 -11.501000)(19.955299 -6.484630 -11.423000)(20.240101 -5.427220 -18.160500)(20.027000 -6.334000 -11.320000)(19.923000 -6.550460 -11.501000)(20.240101 -5.427220 -18.160500)(19.923000 -6.550460 -11.501000)(19.909401 -6.579250 -11.518800)(19.988701 -6.362160 -11.342400)(20.308800 -4.372590 -10.569700)(22.221001 -23.600000 -5.954000)(20.734901 1.425270 -9.541250)(20.702999 2.115380 -9.618160)(22.221001 -23.600000 -5.954000)(22.221001 -23.600000 -5.954000)(20.800900 -0.000995 -9.382000)(20.734901 1.425270 -9.541250)(20.701200 -2.135600 -9.622450)(20.800900 -0.000995 -9.382000)(22.221001 -23.600000 -5.954000)(22.221001 -23.600000 -5.954000)(20.308800 -4.372590 -10.569700)(20.701200 -2.135600 -9.622450)(20.931999 1.432000 -9.542000)(20.734901 1.425270 -9.541250)(20.800900 -0.000995 -9.382000)(20.931999 1.432000 -9.542000)(20.896999 2.123000 -9.619000)(20.734901 1.425270 -9.541250)(20.701200 -2.135600 -9.622450)(20.798899 -0.022670 -9.386800)(20.800900 -0.000995 -9.382000)(22.221001 -23.600000 -5.954000)(20.702999 2.115380 -9.618160)(19.923000 23.500000 -11.501000)(19.923000 -6.550460 -11.501000)(19.955299 -6.484630 -11.423000)(22.221001 -23.600000 -5.954000)(19.923000 -6.550460 -11.501000)(19.923000 -23.600000 -11.501000)(19.904900 -6.591660 -11.524600)(19.923000 -6.550460 -11.501000)(22.221001 -23.600000 -5.954000)(19.923000 -23.600000 -11.501000)(-5.948000 -23.600000 -22.216999)(19.923000 -23.600000 -11.501000)(22.221001 -23.600000 -5.954000)(23.004999 -23.600000 -0.001002)(-5.948000 -23.600000 -22.216999)(22.221001 -23.600000 -5.954000)(20.702999 2.115380 -9.618160)(20.734901 1.425270 -9.541250)(20.896999 2.123000 -9.619000)(20.853100 -1.068300 -9.502220)(20.798899 -0.022670 -9.386800)(20.701200 -2.135600 -9.622450)(20.955999 1.433000 -25.001001)(20.896999 2.123000 -9.619000)(20.931999 1.432000 -9.542000)(20.240101 -5.427220 -18.160500)(20.566000 -4.273000 -25.001001)(20.027000 -6.334000 -11.320000)(20.698900 -2.145910 -9.628060)(20.701200 -2.135600 -9.622450)(20.896999 -2.125000 -9.619000)(20.602901 -3.248790 -10.094300)(20.896999 -2.125000 -9.619000)(20.632301 -2.364500 -9.788790)(19.955400 6.483600 -11.422899)(20.028999 6.329000 -11.316999)(19.923000 6.552000 -11.501000)(22.221001 23.500000 -5.954000)(23.004999 -23.600000 -0.001002)(22.221001 -23.600000 -5.954000)(-10.907000 -17.943001 -25.001001)(-5.948000 -20.096199 -22.216999)(-5.975290 -20.084400 -22.205700)(-8.440479 -19.012199 -22.622000)(-10.907000 -17.943001 -25.001001)(-5.975290 -20.084400 -22.205700)(-19.322001 8.213000 -12.469000)(-18.000900 10.206800 -13.994100)(-17.152000 12.110000 -25.001001)(-17.152000 12.110000 -25.001001)(-19.782999 7.033000 -25.001001)(-19.322001 8.213000 -12.469000)(-19.782999 7.033000 -25.001001)(-17.152000 12.110000 -25.001001)(-19.226000 21.707001 -25.001001)(-18.778400 8.865850 -12.980900)(-18.000900 10.206800 -13.994100)(-19.322001 8.213000 -12.469000)(-17.152000 12.110000 -25.001001)(-18.000900 10.206800 -13.994100)(-16.871801 11.921200 -15.465500)(-20.945999 1.433000 -25.001001)(-19.782999 7.033000 -25.001001)(-19.226000 21.707001 -25.001001)(-16.871801 11.921200 -15.465500)(-16.744499 12.066000 -15.631400)(-17.152000 12.110000 -25.001001)(-18.086500 16.182899 -13.882500)(-16.744499 12.066000 -15.631400)(-16.871801 11.921200 -15.465500)(-16.258999 12.784699 -16.264002)(-13.248000 16.289999 -25.001001)(-16.744499 12.066000 -15.631400)(-13.248000 16.289999 -25.001001)(-16.258999 12.784699 -16.264002)(-16.041800 13.129100 -16.430700)(-16.258999 23.500000 -16.264002)(-16.041800 13.129100 -16.430700)(-16.258999 12.784699 -16.264002)(-15.589900 13.845301 -16.777500)(-16.041800 13.129100 -16.430700)(-16.258999 23.500000 -16.264002)(-16.744499 12.066000 -15.631400)(-13.248000 16.289999 -25.001001)(-17.152000 12.110000 -25.001001)(-15.308500 14.102799 -16.993401)(-15.589900 13.845301 -16.777500)(-16.258999 23.500000 -16.264002)(-17.152000 12.110000 -25.001001)(-13.248000 16.289999 -25.001001)(-13.472000 25.677999 -25.001001)(2.864000 20.803999 -25.001001)(0.005003 29.000000 -25.001001)(-2.855000 20.803999 -25.001001)(0.005003 29.000000 -25.001001)(-6.935000 28.157000 -25.001001)(-2.855000 20.803999 -25.001001)(0.005003 29.000000 -27.500999)(-6.935000 28.157000 -25.001001)(0.005003 29.000000 -25.001001)(-10.915000 17.937000 -20.243000)(-8.282001 19.077999 -21.267000)(-8.362000 19.261002 -25.001001)(-8.282001 19.077999 -21.267000)(-2.855000 20.803999 -25.001001)(-8.362000 19.261002 -25.001001)(-13.248000 16.289999 -25.001001)(-8.362000 19.261002 -25.001001)(-6.935000 28.157000 -25.001001)(-8.362000 19.261002 -25.001001)(-2.855000 20.803999 -25.001001)(-6.935000 28.157000 -25.001001)(-7.635190 19.358299 -21.518299)(-2.855000 20.803999 -25.001001)(-8.282001 19.077999 -21.267000)(-8.362000 19.261002 -25.001001)(-13.248000 16.289999 -25.001001)(-13.141000 16.157000 -18.703001)(-8.362000 19.261002 -25.001001)(-13.141000 16.157000 -18.703001)(-11.495000 17.455200 -19.920000)(-5.948000 20.072800 -22.216999)(-2.855000 20.803999 -25.001001)(-7.635190 19.358299 -21.518299)(-7.635190 19.358299 -21.518299)(-8.351480 19.024401 -21.221699)(-8.721499 20.687698 -21.068501)(-7.635190 19.358299 -21.518299)(-8.721499 20.687698 -21.068501)(-5.948000 20.072800 -22.216999)(-8.351480 19.024401 -21.221699)(-8.427310 18.990601 -21.190300)(-8.721499 20.687698 -21.068501)(-8.351480 19.024401 -21.221699)(-8.282001 19.077999 -21.267000)(-8.427310 18.990601 -21.190300)(-5.884380 20.106699 -22.225401)(-2.855000 20.803999 -25.001001)(-5.948000 20.072800 -22.216999)(-5.611000 20.235001 -22.305000)(-2.855000 20.803999 -25.001001)(-5.884380 20.106699 -22.225401)(-2.855000 20.803999 -25.001001)(-5.611000 20.235001 -22.305000)(-2.853000 20.798000 -22.816000)(-5.948000 20.072800 -22.216999)(-8.721499 20.687698 -21.068501)(-5.948000 23.500000 -22.216999)(-15.091001 14.598000 -17.353001)(-13.141000 16.157000 -18.703001)(-13.248000 16.289999 -25.001001)(-12.948400 16.272800 -18.804600)(-13.681000 15.592000 -18.242399)(-13.877000 18.801401 -18.092001)(-12.530000 16.645901 -19.125700)(-12.948400 16.272800 -18.804600)(-13.877000 18.801401 -18.092001)(-12.948400 16.272800 -18.804600)(-13.141000 16.157000 -18.703001)(-12.530000 16.645901 -19.125700)(-13.681000 15.592000 -18.242399)(-13.141000 16.157000 -18.703001)(-12.948400 16.272800 -18.804600)(-13.681000 15.592000 -18.242399)(-15.308500 14.102799 -16.993401)(-13.877000 18.801401 -18.092001)(-13.681000 15.592000 -18.242399)(-13.141000 16.157000 -18.703001)(-15.091001 14.598000 -17.353001)(-13.248000 16.289999 -25.001001)(-6.935000 28.157000 -25.001001)(-13.472000 25.677999 -25.001001)(-6.935000 28.157000 -27.500999)(-13.472000 25.677999 -25.001001)(-6.935000 28.157000 -25.001001)(-6.935000 28.157000 -27.500999)(-13.472000 25.677999 -27.500999)(-13.472000 25.677999 -25.001001)(-6.935000 28.157000 -27.500999)(28.792999 -3.496000 -27.500999)(-13.472000 25.677999 -27.500999)(-13.472000 25.677999 -27.500999)(-19.226000 21.707001 -25.001001)(-13.472000 25.677999 -25.001001)(-7.635190 19.358299 -21.518299)(-8.282001 19.077999 -21.267000)(-8.351480 19.024401 -21.221699)(-11.495000 17.455200 -19.920000)(-11.404900 17.533300 -19.957300)(-8.362000 19.261002 -25.001001)(-8.427310 18.990601 -21.190300)(-8.282001 19.077999 -21.267000)(-8.899090 18.772001 -20.995001)(0.005003 29.000000 -27.500999)(28.792999 -3.496000 -27.500999)(-6.935000 28.157000 -27.500999)(-5.884380 20.106699 -22.225401)(-5.948000 20.072800 -22.216999)(-5.948000 23.500000 -22.216999)(-5.780590 20.161699 -22.239000)(-5.884380 20.106699 -22.225401)(-5.948000 23.500000 -22.216999)(-13.681000 15.592000 -18.242399)(-15.091001 14.598000 -17.353001)(-15.308500 14.102799 -16.993401)(-12.530000 16.645901 -19.125700)(-13.141000 16.157000 -18.703001)(-11.495000 17.455200 -19.920000)(-20.533998 4.378000 -10.353000)(-19.782999 7.033000 -25.001001)(-20.945999 1.433000 -25.001001)(-28.783998 3.496000 -25.001001)(-28.783998 3.496000 -27.500999)(-28.783998 -3.496000 -27.500999)(-28.783998 -3.496000 -27.500999)(-28.783998 3.496000 -27.500999)(28.792999 -3.496000 -27.500999)(28.792999 -3.496000 -27.500999)(-28.783998 3.496000 -27.500999)(-27.111000 10.284000 -27.500999)(-19.226000 -21.707001 -27.500999)(-23.862001 -16.473999 -27.500999)(28.792999 -3.496000 -27.500999)(-23.862001 -16.473999 -27.500999)(-27.111000 -10.283000 -27.500999)(28.792999 -3.496000 -27.500999)(-23.862001 -16.473999 -25.001001)(-27.111000 -10.283000 -27.500999)(-23.862001 -16.473999 -27.500999)(-27.111000 -10.283000 -27.500999)(-23.862001 -16.473999 -25.001001)(-27.111000 -10.283000 -25.001001)(-27.111000 -10.283000 -25.001001)(-28.783998 -3.496000 -27.500999)(-27.111000 -10.283000 -27.500999)(28.792999 -3.496000 -27.500999)(-27.111000 -10.283000 -27.500999)(-28.783998 -3.496000 -27.500999)(-28.783998 -3.496000 -27.500999)(-27.111000 -10.283000 -25.001001)(-28.783998 -3.496000 -25.001001)(-19.226000 -21.707001 -25.001001)(-23.862001 -16.473999 -25.001001)(-23.862001 -16.473999 -27.500999)(-27.111000 10.284000 -27.500999)(-23.862001 16.473999 -27.500999)(28.792999 -3.496000 -27.500999)(-27.111000 10.284000 -27.500999)(-27.111000 10.284000 -25.001001)(-23.862001 16.473999 -27.500999)(-19.226000 -21.707001 -27.500999)(-19.226000 -21.707001 -25.001001)(-23.862001 -16.473999 -27.500999)(-20.681801 2.246430 -9.646871)(-20.875000 2.247000 -9.646999)(-20.721399 1.435250 -9.551320)(-22.211000 23.500000 -5.954000)(-20.681801 2.246430 -9.646871)(-20.721399 1.435250 -9.551320)(-22.211000 23.500000 -5.954000)(-20.390400 4.370190 -10.350500)(-20.681801 2.246430 -9.646871)(-20.390400 4.370190 -10.350500)(-20.632700 3.312220 -9.999930)(-20.681801 2.246430 -9.646871)(-20.791100 0.009213 -9.383030)(-22.211000 23.500000 -5.954000)(-20.721399 1.435250 -9.551320)(20.566000 -4.273000 -25.001001)(19.909401 -6.579250 -11.518800)(19.904900 -6.591660 -11.524600)(18.650002 -9.661000 -25.001001)(20.566000 -4.273000 -25.001001)(19.904900 -6.591660 -11.524600)(18.650002 -9.661000 -25.001001)(19.235001 -21.707001 -25.001001)(20.566000 -4.273000 -25.001001)(15.351999 -14.334000 -25.001001)(19.235001 -21.707001 -25.001001)(18.650002 -9.661000 -25.001001)(13.886500 -18.785299 -18.092001)(14.274800 -15.061300 -17.793900)(15.040600 -14.220000 -17.206100)(13.886500 -18.785299 -18.092001)(15.040600 -14.220000 -17.206100)(15.139900 -14.135699 -17.129900)(12.082700 -17.061699 -19.476601)(14.274800 -15.061300 -17.793900)(13.178801 -16.923302 -18.635302)(14.274800 -15.061300 -17.793900)(13.886500 -18.785299 -18.092001)(13.178801 -16.923302 -18.635302)(13.886500 -18.785299 -18.092001)(12.082700 -17.061699 -19.476601)(13.178801 -16.923302 -18.635302)(11.505000 -17.396900 -19.920000)(12.082700 -17.061699 -19.476601)(13.886500 -18.785299 -18.092001)(12.082700 -17.061699 -19.476601)(11.505000 -17.396900 -19.920000)(10.916000 -17.943001 -25.001001)(10.916000 -17.943001 -25.001001)(15.040600 -14.220000 -17.206100)(14.274800 -15.061300 -17.793900)(12.791000 -16.659000 -19.118999)(12.082700 -17.061699 -19.476601)(10.916000 -17.943001 -25.001001)(15.040600 -14.220000 -17.206100)(10.916000 -17.943001 -25.001001)(15.351999 -14.334000 -25.001001)(16.358500 -20.005999 -25.001001)(19.235001 -21.707001 -25.001001)(15.351999 -14.334000 -25.001001)(13.481999 -25.677999 -25.001001)(16.358500 -20.005999 -25.001001)(15.351999 -14.334000 -25.001001)(13.481999 -25.677999 -25.001001)(15.351999 -14.334000 -25.001001)(10.916000 -17.943001 -25.001001)(13.481999 -25.677999 -25.001001)(10.916000 -17.943001 -25.001001)(6.945000 -28.157000 -25.001001)(15.139900 -14.135699 -17.129900)(15.040600 -14.220000 -17.206100)(15.351999 -14.334000 -25.001001)(6.945000 -28.157000 -25.001001)(13.481999 -25.677999 -27.500999)(13.481999 -25.677999 -25.001001)(19.235001 -21.707001 -27.500999)(13.481999 -25.677999 -27.500999)(28.792999 -3.496000 -27.500999)(13.481999 -25.677999 -27.500999)(6.945000 -28.157000 -27.500999)(28.792999 -3.496000 -27.500999)(6.945000 -28.157000 -25.001001)(6.945000 -28.157000 -27.500999)(13.481999 -25.677999 -27.500999)(0.005004 -29.000000 -25.001001)(6.945000 -28.157000 -27.500999)(6.945000 -28.157000 -25.001001)(0.005004 -29.000000 -25.001001)(0.005003 -29.000000 -27.500999)(6.945000 -28.157000 -27.500999)(0.005004 -29.000000 -25.001001)(-6.935000 -28.157000 -27.500999)(0.005003 -29.000000 -27.500999)(6.945000 -28.157000 -25.001001)(5.670000 -20.221001 -25.001001)(0.005004 -29.000000 -25.001001)(14.274800 -15.061300 -17.793900)(12.082700 -17.061699 -19.476601)(12.791000 -16.659000 -19.118999)(28.792999 -3.496000 -27.500999)(0.005003 -29.000000 -27.500999)(-6.935000 -28.157000 -27.500999)(-20.721399 1.435250 -9.551320)(-20.918001 1.432000 -9.551000)(-20.791100 0.009213 -9.383030)(-20.791100 0.009213 -9.383030)(-20.918001 1.432000 -9.551000)(-20.995001 -0.000000 -9.382000)(-20.945999 1.433000 -25.001001)(-20.995001 -0.000000 -9.382000)(-20.918001 1.432000 -9.551000)(-20.945999 1.433000 -25.001001)(-20.918001 1.432000 -9.551000)(-20.875000 2.247000 -9.646999)(-20.535999 -4.368000 -10.349000)(-20.556000 -4.273000 -25.001001)(-20.222601 -5.347680 -17.674999)(-20.222601 -5.347680 -17.674999)(-20.011301 -6.032440 -11.266000)(-20.535999 -4.368000 -10.349000)(-20.392200 -4.356970 -10.346100)(-20.535999 -4.368000 -10.349000)(-20.011301 -6.032440 -11.266000)(-20.535999 -4.368000 -10.349000)(-20.995001 -0.000000 -9.382000)(-20.875000 -2.242000 -9.646000)(-20.535999 -4.368000 -10.349000)(-20.875000 -2.242000 -9.646000)(-20.551001 -4.272000 -10.316999)(-20.693701 -2.184000 -9.865500)(-20.995001 -0.000000 -9.382000)(-20.535999 -4.368000 -10.349000)(-20.791500 -0.000005 -9.382000)(-20.995001 -0.000000 -9.382000)(-20.693701 -2.184000 -9.865500)(-20.392200 -4.356970 -10.346100)(-20.791500 -0.000005 -9.382000)(-20.693701 -2.184000 -9.865500)(-20.556000 -4.273000 -25.001001)(-20.551001 -4.272000 -10.316999)(-20.875000 -2.242000 -9.646000)(-20.392200 -4.356970 -10.346100)(-20.693701 -2.184000 -9.865500)(-20.535999 -4.368000 -10.349000)(-19.914000 -23.600000 -11.501000)(-20.392200 -4.356970 -10.346100)(-20.011301 -6.032440 -11.266000)(-20.875000 -2.242000 -9.646000)(-20.995001 -0.000000 -9.382000)(-20.995001 -0.000001 -25.001001)(-13.472000 -25.677999 -25.001001)(-13.472000 -25.677999 -27.500999)(-6.935000 -28.157000 -25.001001)(-6.935000 -28.157000 -25.001001)(-13.472000 -25.677999 -27.500999)(-6.935000 -28.157000 -27.500999)(28.792999 -3.496000 -27.500999)(-6.935000 -28.157000 -27.500999)(-13.472000 -25.677999 -27.500999)(-13.472000 -25.677999 -25.001001)(-19.226000 -21.707001 -27.500999)(-13.472000 -25.677999 -27.500999)(-20.556000 -4.273000 -25.001001)(-19.226000 -21.707001 -25.001001)(-18.641001 -9.661000 -25.001001)(-13.472000 -25.677999 -25.001001)(-18.641001 -9.661000 -25.001001)(-19.226000 -21.707001 -25.001001)(-20.995001 -0.000001 -25.001001)(-19.226000 -21.707001 -25.001001)(-20.556000 -4.273000 -25.001001)(-23.862001 16.473999 -25.001001)(-19.226000 -21.707001 -25.001001)(-20.995001 -0.000001 -25.001001)(-23.862001 16.473999 -25.001001)(-20.995001 -0.000001 -25.001001)(-20.945999 1.433000 -25.001001)(-20.945999 1.433000 -25.001001)(-20.995001 -0.000001 -25.001001)(-20.995001 -0.000000 -9.382000)(-19.226000 -21.707001 -25.001001)(-19.226000 -21.707001 -27.500999)(-13.472000 -25.677999 -25.001001)(-19.880499 -6.444260 -11.544600)(-20.556000 -4.273000 -25.001001)(-18.641001 -9.661000 -25.001001)(-20.556000 -4.273000 -25.001001)(-20.535999 -4.368000 -10.349000)(-20.551001 -4.272000 -10.316999)(-19.768900 -6.802200 -11.690100)(-19.880499 -6.444260 -11.544600)(-18.641001 -9.661000 -25.001001)(-19.880499 -6.444260 -11.544600)(-19.888399 -6.422130 -11.534300)(-19.768900 -6.802200 -11.690100)(-19.768900 -6.802200 -11.690100)(-19.188101 -8.172450 -12.446900)(-18.086500 -14.970500 -13.882500)(-19.768900 -6.802200 -11.690100)(-18.086500 -14.970500 -13.882500)(-19.914000 -23.600000 -11.501000)(-19.914000 -23.600000 -11.501000)(-19.888399 -6.422130 -11.534300)(-19.768900 -6.802200 -11.690100)(-19.914000 -6.341040 -11.501000)(-19.888399 -6.422130 -11.534300)(-19.914000 -23.600000 -11.501000)(-19.188101 -8.172450 -12.446900)(-19.768900 -6.802200 -11.690100)(-19.331001 -8.194000 -12.457000)(-19.331001 -8.194000 -12.457000)(-19.072100 -8.365400 -12.598100)(-19.188101 -8.172450 -12.446900)(-18.086500 -14.970500 -13.882500)(-16.258999 -23.600000 -16.264002)(-19.914000 -23.600000 -11.501000)(-17.204700 -11.413799 -15.031700)(-16.258999 -12.849600 -16.264002)(-16.258999 -23.600000 -16.264002)(-18.086500 -14.970500 -13.882500)(-17.204700 -11.413799 -15.031700)(-16.258999 -23.600000 -16.264002)(-16.258999 -12.849600 -16.264002)(-17.204700 -11.413799 -15.031700)(-17.388300 -11.295899 -19.243000)(-18.641001 -9.661000 -25.001001)(-16.183199 -12.963200 -16.322199)(-17.388300 -11.295899 -19.243000)(-18.441000 -9.539000 -13.485000)(-18.641001 -9.661000 -25.001001)(-17.388300 -11.295899 -19.243000)(-17.388300 -11.295899 -19.243000)(-18.001299 -10.204300 -13.993601)(-18.441000 -9.539000 -13.485000)(-16.949501 -11.967500 -20.661600)(-16.183199 -12.963200 -16.322199)(-18.641001 -9.661000 -25.001001)(-16.115099 -13.060800 -16.374399)(-16.949501 -11.967500 -20.661600)(-15.343000 -14.334000 -25.001001)(-16.949501 -11.967500 -20.661600)(-18.641001 -9.661000 -25.001001)(-16.970699 -11.982500 -22.831301)(-18.641001 -9.661000 -25.001001)(-15.343000 -14.334000 -25.001001)(-16.970699 -11.982500 -22.831301)(-15.343000 -14.334000 -25.001001)(-16.949501 -11.967500 -20.661600)(-16.970699 -11.982500 -22.831301)(-18.441000 -9.539000 -13.485000)(-18.001299 -10.204300 -13.993601)(-18.359100 -9.589840 -13.527200)(-19.072100 -8.365400 -12.598100)(-18.359100 -9.589840 -13.527200)(-18.086500 -14.970500 -13.882500)(-18.359100 -9.589840 -13.527200)(-18.001299 -10.204300 -13.993601)(-18.086500 -14.970500 -13.882500)(-17.388300 -11.295899 -19.243000)(-17.204700 -11.413799 -15.031700)(-18.001299 -10.204300 -13.993601)(-16.949501 -11.967500 -20.661600)(-16.115099 -13.060800 -16.374399)(-16.183199 -12.963200 -16.322199)(-16.183199 -12.963200 -16.322199)(-16.115099 -13.060800 -16.374399)(-16.258999 -23.600000 -16.264002)(-20.011301 -6.032440 -11.266000)(-19.914000 -6.341040 -11.501000)(-19.914000 -23.600000 -11.501000)(-16.258999 -23.600000 -16.264002)(-16.258999 -12.849600 -16.264002)(-16.183199 -12.963200 -16.322199)(-20.875000 2.247000 -9.646999)(-20.533998 4.378000 -10.353000)(-20.945999 1.433000 -25.001001)(10.916000 -17.943001 -25.001001)(5.670000 -20.221001 -25.001001)(6.945000 -28.157000 -25.001001)(-20.721399 1.435250 -9.551320)(-20.875000 2.247000 -9.646999)(-20.918001 1.432000 -9.551000)(-20.681801 2.246430 -9.646871)(-20.632700 3.312220 -9.999930)(-20.875000 2.247000 -9.646999)(-20.995001 -0.000000 -9.382000)(-20.791500 -0.000005 -9.382000)(-20.791100 0.009213 -9.383030)(-18.641001 -9.661000 -25.001001)(-18.441000 -9.539000 -13.485000)(-19.331001 -8.194000 -12.457000)(-20.222601 -5.347680 -17.674999)(-20.556000 -4.273000 -25.001001)(-19.888399 -6.422130 -11.534300)(-20.556000 -4.273000 -25.001001)(-19.880499 -6.444260 -11.544600)(-19.888399 -6.422130 -11.534300)(-20.533998 4.378000 -10.353000)(-20.875000 2.247000 -9.646999)(-20.632700 3.312220 -9.999930)(15.294200 -13.970500 -17.011501)(13.886500 -18.785299 -18.092001)(15.139900 -14.135699 -17.129900)(5.958010 -23.600000 -22.216999)(5.514570 -20.091499 -22.275400)(5.631490 -20.074600 -22.260000)(5.631490 -20.074600 -22.260000)(5.514570 -20.091499 -22.275400)(5.670000 -20.221001 -25.001001)(5.348930 -20.115499 -22.297199)(0.005003 -21.000000 -25.001001)(5.670000 -20.221001 -25.001001)(4.630370 -20.329901 -22.391800)(0.005003 -21.000000 -25.001001)(5.348930 -20.115499 -22.297199)(5.514570 -20.091499 -22.275400)(5.348930 -20.115499 -22.297199)(5.670000 -20.221001 -25.001001)(16.268000 -23.600000 -16.264002)(13.886500 -18.785299 -18.092001)(15.294200 -13.970500 -17.011501)(13.886500 -18.785299 -18.092001)(16.268000 -23.600000 -16.264002)(13.886500 -21.192598 -18.092001)(16.268000 -23.600000 -16.264002)(11.505000 -23.600000 -19.920000)(13.886500 -21.192598 -18.092001)(11.505000 -23.600000 -19.920000)(13.886500 -18.785299 -18.092001)(13.886500 -21.192598 -18.092001)(0.096896 -20.983999 -22.988901)(0.077003 -21.000000 -23.000999)(0.536158 -20.923000 -22.931000)(0.536158 -20.923000 -22.931000)(2.353690 -20.664900 -22.696400)(0.077003 -21.000000 -23.000999)(0.077003 -21.000000 -23.000999)(2.760000 -20.818001 -22.834999)(2.353690 -20.664900 -22.696400)(0.029865 -20.996698 -22.997700)(0.077003 -21.000000 -23.000999)(0.096896 -20.983999 -22.988901)(0.005003 -20.995001 -23.000999)(0.029865 -20.996698 -22.997700)(0.077003 -21.000000 -23.000999)(0.005003 -20.995001 -23.000999)(0.029865 -20.996698 -22.997700)(0.005003 -23.600000 -23.000999)(0.077003 -21.000000 -23.000999)(0.005003 -20.995001 -23.000999)(0.005003 -21.000000 -25.001001)(0.005003 -23.600000 -23.000999)(0.029865 -20.996698 -22.997700)(0.096896 -20.983999 -22.988901)(0.005003 -23.600000 -23.000999)(0.096896 -20.983999 -22.988901)(0.536158 -20.923000 -22.931000)(2.981510 -21.845800 -22.608999)(0.536158 -20.923000 -22.931000)(4.630370 -20.329901 -22.391800)(5.958010 -23.600000 -22.216999)(2.981510 -21.845800 -22.608999)(4.630370 -20.329901 -22.391800)(5.958010 -23.600000 -22.216999)(16.268000 -23.600000 -16.264002)(0.005003 -23.600000 -23.000999)(2.981510 -21.845800 -22.608999)(5.958010 -23.600000 -22.216999)(2.981510 -22.722900 -22.608999)(5.958010 -23.600000 -22.216999)(0.005003 -23.600000 -23.000999)(2.981510 -22.722900 -22.608999)(0.005003 -23.600000 -23.000999)(2.981510 -21.845800 -22.608999)(2.981510 -22.722900 -22.608999)(0.005003 -23.600000 -23.000999)(0.536158 -20.923000 -22.931000)(2.981510 -21.845800 -22.608999)(5.958010 -23.600000 -22.216999)(11.505000 -23.600000 -19.920000)(16.268000 -23.600000 -16.264002)(8.731501 -20.691599 -21.068501)(11.505000 -23.600000 -19.920000)(8.731501 -22.145800 -21.068501)(11.505000 -23.600000 -19.920000)(5.958010 -23.600000 -22.216999)(8.731501 -22.145800 -21.068501)(5.958010 -23.600000 -22.216999)(8.731501 -20.691599 -21.068501)(8.731501 -22.145800 -21.068501)(5.958010 -23.600000 -22.216999)(6.746790 -19.776501 -21.890400)(8.731501 -20.691599 -21.068501)(5.958010 -23.600000 -22.216999)(5.958010 -19.990400 -22.216999)(6.746790 -19.776501 -21.890400)(5.958010 -23.600000 -22.216999)(5.912950 -20.001900 -22.222900)(5.958010 -19.990400 -22.216999)(5.958010 -19.990400 -22.216999)(5.912950 -20.001900 -22.222900)(5.670000 -20.221001 -25.001001)(5.912950 -20.001900 -22.222900)(5.631490 -20.074600 -22.260000)(5.670000 -20.221001 -25.001001)(-27.111000 10.284000 -25.001001)(-23.862001 16.473999 -25.001001)(-23.862001 16.473999 -27.500999)(-23.862001 16.473999 -25.001001)(-27.111000 10.284000 -25.001001)(-23.862001 -16.473999 -25.001001)(-19.226000 21.707001 -27.500999)(-23.862001 16.473999 -25.001001)(-19.226000 21.707001 -25.001001)(-23.862001 16.473999 -27.500999)(-23.862001 16.473999 -25.001001)(-19.226000 21.707001 -27.500999)(6.746790 -19.776501 -21.890400)(5.958010 -19.990400 -22.216999)(5.670000 -20.221001 -25.001001)(7.787010 -19.504999 -21.643999)(6.746790 -19.776501 -21.890400)(5.670000 -20.221001 -25.001001)(9.824030 -18.346199 -20.616098)(6.746790 -19.776501 -21.890400)(7.787010 -19.504999 -21.643999)(9.824030 -18.346199 -20.616098)(7.787010 -19.504999 -21.643999)(10.652300 -17.859001 -20.273100)(11.505000 -23.600000 -19.920000)(9.824030 -18.346199 -20.616098)(10.652300 -17.859001 -20.273100)(10.652300 -17.859001 -20.273100)(7.787010 -19.504999 -21.643999)(5.670000 -20.221001 -25.001001)(11.505000 -23.600000 -19.920000)(10.652300 -17.859001 -20.273100)(10.820001 -17.783298 -20.203701)(11.162499 -20.498400 -20.061800)(10.822701 -17.782001 -20.202501)(11.426600 -17.441200 -19.952499)(11.426600 -17.441200 -19.952499)(10.822701 -17.782001 -20.202501)(10.916000 -17.943001 -25.001001)(10.916000 -17.943001 -25.001001)(10.820001 -17.783298 -20.203701)(10.822701 -17.782001 -20.202501)(10.820001 -17.783298 -20.203701)(10.652300 -17.859001 -20.273100)(10.916000 -17.943001 -25.001001)(11.505000 -17.396900 -19.920000)(11.505000 -23.600000 -19.920000)(11.162499 -20.498400 -20.061800)(11.162499 -20.498400 -20.061800)(11.505000 -23.600000 -19.920000)(10.820001 -17.783298 -20.203701)(-19.072100 -8.365400 -12.598100)(-18.441000 -9.539000 -13.485000)(-18.359100 -9.589840 -13.527200)(10.822701 -17.782001 -20.202501)(10.820001 -17.783298 -20.203701)(11.162499 -20.498400 -20.061800)(-18.001299 -10.204300 -13.993601)(-17.204700 -11.413799 -15.031700)(-18.086500 -14.970500 -13.882500)(-18.641001 -9.661000 -25.001001)(-19.331001 -8.194000 -12.457000)(-19.768900 -6.802200 -11.690100)(-23.862001 16.473999 -27.500999)(-19.226000 21.707001 -27.500999)(28.792999 -3.496000 -27.500999)(-11.496800 -17.476599 -19.918701)(-15.343000 -14.334000 -25.001001)(-10.951000 -17.916000 -20.223999)(-10.951000 -17.916000 -20.223999)(-15.343000 -14.334000 -25.001001)(-10.903000 -17.936001 -20.243000)(-7.553000 -19.396502 -21.552401)(-8.440479 -19.012199 -22.622000)(-6.382970 -19.906599 -22.036901)(-7.553000 -19.396502 -21.552401)(-10.903000 -17.936001 -20.243000)(-8.440479 -19.012199 -22.622000)(-9.672939 -18.475801 -22.622000)(-10.907000 -17.943001 -25.001001)(-8.440479 -19.012199 -22.622000)(-9.672939 -18.475801 -22.622000)(-8.440479 -19.012199 -22.622000)(-10.903000 -17.936001 -20.243000)(-9.672939 -18.475801 -22.622000)(-10.903000 -17.936001 -20.243000)(-10.907000 -17.943001 -25.001001)(-13.472000 -25.677999 -25.001001)(-10.907000 -17.943001 -25.001001)(-15.343000 -14.334000 -25.001001)(-15.343000 -14.334000 -25.001001)(-10.907000 -17.943001 -25.001001)(-10.903000 -17.936001 -20.243000)(-10.903000 -17.936001 -20.243000)(-7.553000 -19.396502 -21.552401)(-10.421600 -18.070999 -20.364500)(-8.721499 -20.539001 -21.068501)(-7.553000 -19.396502 -21.552401)(-6.382970 -19.906599 -22.036901)(-10.421600 -18.070999 -20.364500)(-10.903000 -17.936001 -20.243000)(-11.208400 -17.700600 -20.038700)(-5.975290 -20.084400 -22.205700)(-6.382970 -19.906599 -22.036901)(-8.440479 -19.012199 -22.622000)(-5.948000 -23.600000 -22.216999)(-8.721499 -20.539001 -21.068501)(-6.382970 -19.906599 -22.036901)(-8.721499 -20.539001 -21.068501)(-10.421600 -18.070999 -20.364500)(-7.553000 -19.396502 -21.552401)(-10.951000 -17.916000 -20.223999)(-11.496800 -17.476599 -19.918701)(-11.231601 -17.690300 -20.029100)(-5.948000 -23.600000 -22.216999)(-6.382970 -19.906599 -22.036901)(-5.975290 -20.084400 -22.205700)(-10.951000 -17.916000 -20.223999)(-10.903000 -17.936001 -20.243000)(-11.208400 -17.700600 -20.038700)(-11.495000 -23.600000 -19.920000)(-11.496800 -17.476599 -19.918701)(-11.231601 -17.690300 -20.029100)(-11.495000 -23.600000 -19.920000)(-11.231601 -17.690300 -20.029100)(-11.208400 -17.700600 -20.038700)(-10.951000 -17.916000 -20.223999)(-11.208400 -17.700600 -20.038700)(-11.231601 -17.690300 -20.029100)(-11.495000 -23.600000 -19.920000)(-8.721499 -20.539001 -21.068501)(-8.721499 -22.069500 -21.068501)(-8.721499 -20.539001 -21.068501)(-5.948000 -23.600000 -22.216999)(-8.721499 -22.069500 -21.068501)(-5.948000 -23.600000 -22.216999)(-11.495000 -23.600000 -19.920000)(-8.721499 -22.069500 -21.068501)(0.005007 -23.600000 22.999001)(-5.948000 -23.600000 -22.216999)(5.958010 -23.600000 22.215000)(0.005007 -23.600000 22.999001)(5.958010 -23.600000 22.215000)(5.958010 23.500000 22.215000)(-5.948000 -23.600000 -22.216999)(0.005007 -23.600000 22.999001)(-5.947990 -23.600000 22.215000)(-5.947990 -23.600000 22.215000)(-11.495000 -23.600000 19.918001)(-5.948000 -23.600000 -22.216999)(3.735910 20.454399 -22.509600)(2.981510 21.737900 -22.608999)(4.642890 20.327000 -22.390200)(3.735910 20.454399 -22.509600)(3.602360 20.471500 -22.527199)(2.981510 21.737900 -22.608999)(3.331750 20.501699 -22.562901)(3.227210 20.496899 -22.576601)(2.981510 21.737900 -22.608999)(2.981510 21.737900 -22.608999)(3.346500 20.500099 -22.560900)(3.331750 20.501699 -22.562901)(2.863000 20.798000 -22.817001)(3.331750 20.501699 -22.562901)(3.346500 20.500099 -22.560900)(2.863000 20.798000 -22.817001)(3.346500 20.500099 -22.560900)(3.380150 20.496300 -22.556501)(2.863000 20.798000 -22.817001)(3.380150 20.496300 -22.556501)(3.602360 20.471500 -22.527199)(3.602360 20.471500 -22.527199)(3.735910 20.454399 -22.509600)(2.863000 20.798000 -22.817001)(3.602360 20.471500 -22.527199)(3.380150 20.496300 -22.556501)(2.981510 21.737900 -22.608999)(2.863000 20.798000 -22.817001)(3.227210 20.496899 -22.576601)(3.331750 20.501699 -22.562901)(2.981510 21.737900 -22.608999)(3.346500 20.500099 -22.560900)(3.380150 20.496300 -22.556501)(3.227210 20.496899 -22.576601)(1.365690 20.803301 -22.821800)(2.981510 21.737900 -22.608999)(-20.533998 4.378000 -10.353000)(-19.914000 6.341730 -11.501000)(-19.782999 7.033000 -25.001001)(-19.782999 7.033000 -25.001001)(-19.914000 6.341730 -11.501000)(-19.885599 6.431370 -11.538000)(-19.346199 14.920899 -12.240900)(-19.885599 6.431370 -11.538000)(-19.914000 6.341730 -11.501000)(-22.211000 23.500000 -5.954000)(-19.914000 6.341730 -11.501000)(-20.011200 6.032800 -11.266300)(-22.211000 23.500000 -5.954000)(-19.914000 23.500000 -11.501000)(-19.914000 6.341730 -11.501000)(-19.346199 14.920899 -12.240900)(-19.914000 6.341730 -11.501000)(-19.914000 23.500000 -11.501000)(-19.767801 6.804340 -11.691501)(-19.885599 6.431370 -11.538000)(-19.346199 14.920899 -12.240900)(-19.767801 6.804340 -11.691501)(-19.885599 6.431370 -11.538000)(-19.703999 7.007000 -11.803000)(-19.346199 14.920899 -12.240900)(-19.683100 7.004490 -11.801900)(-19.767801 6.804340 -11.691501)(-19.322001 8.213000 -12.469000)(-19.683100 7.004490 -11.801900)(-19.178999 8.191339 -12.458900)(-19.178999 8.191339 -12.458900)(-19.683100 7.004490 -11.801900)(-19.174500 8.205940 -12.464701)(-19.322001 8.213000 -12.469000)(-19.174500 8.205940 -12.464701)(-19.178999 8.191339 -12.458900)(-19.174500 8.205940 -12.464701)(-19.683100 7.004490 -11.801900)(-19.346199 14.920899 -12.240900)(-19.322001 8.213000 -12.469000)(-19.174500 8.205940 -12.464701)(-19.030800 8.435540 -12.652000)(-19.346199 14.920899 -12.240900)(-19.030800 8.435540 -12.652000)(-19.174500 8.205940 -12.464701)(-19.322001 8.213000 -12.469000)(-19.703999 7.007000 -11.803000)(-19.683100 7.004490 -11.801900)(-19.914000 23.500000 -11.501000)(-16.258999 23.500000 -16.264002)(-18.086500 16.182899 -13.882500)(-19.914000 23.500000 -11.501000)(-18.086500 16.182899 -13.882500)(-18.778400 8.865850 -12.980900)(-22.995001 23.500000 -0.001002)(-22.211000 23.500000 -5.954000)(-22.211000 -23.600000 -5.954000)(-22.995001 -23.600000 -0.000998)(-22.211000 -23.600000 -5.954000)(-19.914000 -23.600000 -11.501000)(-22.211000 23.500000 -5.954000)(-19.914000 -23.600000 -11.501000)(-22.211000 -23.600000 -5.954000)(-19.914000 -23.600000 -11.501000)(-22.211000 -23.600000 5.952000)(-22.995001 -23.600000 -0.000998)(-22.211000 23.500000 5.952000)(-22.995001 -23.600000 -0.000998)(-22.211000 -23.600000 5.952000)(-22.211000 -23.600000 5.952000)(-19.914000 -23.600000 -11.501000)(-19.914000 -23.600000 11.499000)(-16.258999 23.500000 16.263000)(-19.914000 23.500000 11.499000)(-19.914000 -23.600000 11.499000)(-19.914000 23.500000 11.499000)(-22.211000 -23.600000 5.952000)(-19.914000 -23.600000 11.499000)(-16.258999 23.500000 16.263000)(-19.914000 -23.600000 11.499000)(-16.258999 -23.600000 16.263000)(-11.495000 -23.600000 19.918001)(-16.258999 -23.600000 16.263000)(-5.948000 -23.600000 -22.216999)(-16.258999 -23.600000 16.263000)(-11.495000 -23.600000 19.918001)(-11.495000 23.500000 19.918001)(-16.258999 -23.600000 16.263000)(-19.914000 -23.600000 11.499000)(-5.948000 -23.600000 -22.216999)(-22.995001 23.500000 -0.001002)(-22.211000 -23.600000 -5.954000)(-22.995001 -23.600000 -0.000998)(-16.258999 -23.600000 16.263000)(-11.495000 23.500000 19.918001)(-16.258999 23.500000 16.263000)(-19.914000 -23.600000 11.499000)(-11.495000 -23.600000 -19.920000)(-5.948000 -23.600000 -22.216999)(1.365690 20.803301 -22.821800)(2.981510 21.737900 -22.608999)(1.298650 20.813599 -22.830601)(1.298650 20.813599 -22.830601)(0.005003 23.500000 -23.000999)(2.981510 21.737900 -22.608999)(0.326874 20.953400 -22.958601)(0.101084 20.985802 -22.988300)(0.005003 23.500000 -23.000999)(1.298650 20.813599 -22.830601)(0.326874 20.953400 -22.958601)(0.005003 23.500000 -23.000999)(0.101084 20.985802 -22.988300)(0.326874 20.953400 -22.958601)(2.809000 20.811998 -22.829000)(0.042116 20.994400 -22.996099)(0.101084 20.985802 -22.988300)(0.128003 21.000000 -23.000999)(0.128003 21.000000 -23.000999)(0.013399 20.991400 -22.999899)(0.042116 20.994400 -22.996099)(0.101084 20.985802 -22.988300)(2.809000 20.811998 -22.829000)(0.128003 21.000000 -23.000999)(2.864000 20.803999 -25.001001)(0.128003 21.000000 -23.000999)(2.809000 20.811998 -22.829000)(0.326874 20.953400 -22.958601)(1.298650 20.813599 -22.830601)(2.809000 20.811998 -22.829000)(2.809000 20.811998 -22.829000)(2.080820 20.805799 -22.823799)(2.863000 20.798000 -22.817001)(2.809000 20.811998 -22.829000)(1.298650 20.813599 -22.830601)(2.080820 20.805799 -22.823799)(14.343000 14.998500 -17.741600)(13.202001 16.233002 -18.765001)(12.809099 16.406500 -18.919001)(12.809099 16.406500 -18.919001)(13.202001 16.233002 -18.765001)(12.390599 16.780600 -19.240299)(12.809099 16.406500 -18.919001)(12.390599 16.780600 -19.240299)(13.886500 18.209801 -18.092001)(12.809099 16.406500 -18.919001)(13.886500 18.209801 -18.092001)(13.576000 16.604099 -18.330299)(13.886500 18.209801 -18.092001)(14.343000 14.998500 -17.741600)(13.576000 16.604099 -18.330299)(14.343000 14.998500 -17.741600)(12.809099 16.406500 -18.919001)(13.576000 16.604099 -18.330299)(12.390599 16.780600 -19.240299)(12.163500 16.987900 -19.414499)(13.886500 18.209801 -18.092001)(13.886500 18.209801 -18.092001)(12.163500 16.987900 -19.414499)(11.505000 23.500000 -19.920000)(12.108200 17.038500 -19.456999)(11.505000 17.382401 -19.920000)(11.505000 23.500000 -19.920000)(12.163500 16.987900 -19.414499)(12.108200 17.038500 -19.456999)(11.505000 23.500000 -19.920000)(-11.495000 17.455200 -19.920000)(-13.877000 18.801401 -18.092001)(-11.495000 23.500000 -19.920000)(-11.495000 23.500000 -19.920000)(-13.877000 18.801401 -18.092001)(-13.877000 21.150702 -18.092001)(-13.877000 18.801401 -18.092001)(-16.258999 23.500000 -16.264002)(-13.877000 21.150702 -18.092001)(-16.258999 23.500000 -16.264002)(-11.495000 23.500000 -19.920000)(-13.877000 21.150702 -18.092001)(5.958000 23.500000 -22.216999)(0.005003 23.500000 -23.000999)(1.225000 23.500000 -22.685001)(2.981510 21.737900 -22.608999)(0.005003 23.500000 -23.000999)(2.981500 22.618898 -22.608999)(0.005003 23.500000 -23.000999)(5.958000 23.500000 -22.216999)(2.981500 22.618898 -22.608999)(5.958000 23.500000 -22.216999)(2.981510 21.737900 -22.608999)(2.981500 22.618898 -22.608999)(1.225000 23.500000 -22.685001)(0.005003 23.500000 -23.000999)(-5.948000 23.500000 -22.216999)(0.005007 23.500000 22.999001)(5.958010 23.500000 22.215000)(5.146010 23.500000 22.125999)(0.005007 23.500000 22.999001)(5.146010 23.500000 22.125999)(-5.948000 23.500000 22.215000)(-5.948000 23.500000 22.215000)(-8.886140 23.446400 20.965601)(-11.495000 -23.600000 19.918001)(5.146010 23.500000 22.125999)(-8.886140 23.446400 20.965601)(-5.948000 23.500000 22.215000)(5.958010 23.500000 22.215000)(11.505000 23.500000 19.918001)(5.146010 23.500000 22.125999)(-11.495000 -23.600000 19.918001)(-5.947990 -23.600000 22.215000)(-5.948000 23.500000 22.215000)(13.886500 18.209801 -18.092001)(11.505000 23.500000 -19.920000)(13.886500 20.854900 -18.092001)(11.505000 23.500000 -19.920000)(16.268000 23.500000 -16.264002)(13.886500 20.854900 -18.092001)(16.268000 23.500000 -16.264002)(13.886500 18.209801 -18.092001)(13.886500 20.854900 -18.092001)(23.004999 -23.600000 -0.001002)(22.221001 23.500000 -5.954000)(23.004999 23.500000 -0.001006)(-5.947990 -23.600000 22.215000)(0.005007 23.500000 22.999001)(-5.948000 23.500000 22.215000)(13.258000 16.289999 -25.001001)(13.202001 16.233002 -18.765001)(14.343000 14.998500 -17.741600)(16.041201 13.165200 -16.438101)(14.343000 14.998500 -17.741600)(13.886500 18.209801 -18.092001)(19.923000 -23.600000 11.499000)(16.268000 -23.600000 16.263000)(-5.948000 -23.600000 -22.216999)(11.505000 -23.600000 19.918001)(-5.948000 -23.600000 -22.216999)(16.268000 -23.600000 16.263000)(11.505000 -23.600000 19.918001)(16.268000 23.500000 16.263000)(11.505000 23.500000 19.918001)(11.505000 -23.600000 19.918001)(16.268000 -23.600000 16.263000)(16.268000 23.500000 16.263000)(5.958010 -23.600000 22.215000)(11.505000 -23.600000 19.918001)(11.505000 23.500000 19.918001)(19.923000 -23.600000 11.499000)(22.221001 23.500000 5.952000)(19.923000 23.500000 11.499000)(19.923000 23.500000 11.499000)(16.268000 -23.600000 16.263000)(19.923000 -23.600000 11.499000)(-19.030800 8.435540 -12.652000)(-19.322001 8.213000 -12.469000)(-18.981899 8.514900 -12.715700)(-19.782999 7.033000 -25.001001)(-19.885599 6.431370 -11.538000)(-19.703999 7.007000 -11.803000)(-11.495000 23.500000 -19.920000)(1.225000 23.500000 -22.685001)(-5.948000 23.500000 -22.216999)(12.163500 16.987900 -19.414499)(12.390599 16.780600 -19.240299)(12.853001 16.611000 -19.077999)(13.258000 16.289999 -25.001001)(12.853001 16.611000 -19.077999)(13.202001 16.233002 -18.765001)(17.161001 12.110000 -25.001001)(16.041201 13.165200 -16.438101)(16.166599 13.029300 -16.341900)(16.041201 13.165200 -16.438101)(17.161001 12.110000 -25.001001)(13.258000 16.289999 -25.001001)(6.945000 28.157000 -25.001001)(6.945000 28.157000 -27.500999)(0.005003 29.000000 -25.001001)(13.481999 25.677999 -27.500999)(6.945000 28.157000 -27.500999)(6.945000 28.157000 -25.001001)(6.016170 19.960602 -22.192900)(7.195240 19.616899 -23.309999)(8.371000 19.261002 -25.001001)(6.386180 19.864300 -22.039700)(7.195240 19.616899 -23.309999)(6.016170 19.960602 -22.192900)(6.386180 19.864300 -22.039700)(6.016170 19.960602 -22.192900)(5.958000 23.500000 -22.216999)(11.485800 17.393499 -19.928001)(12.374500 16.846298 -22.039499)(13.258000 16.289999 -25.001001)(12.374500 16.846298 -22.039499)(11.485800 17.393499 -19.928001)(11.505000 17.382401 -19.920000)(12.374500 16.846298 -22.039499)(12.853001 16.611000 -19.077999)(13.258000 16.289999 -25.001001)(11.485800 17.393499 -19.928001)(13.258000 16.289999 -25.001001)(10.803100 17.752901 -22.464500)(7.857000 19.477001 -21.618999)(8.339000 19.200001 -21.374001)(8.371000 19.261002 -25.001001)(8.339000 19.200001 -21.374001)(7.857000 19.477001 -21.618999)(7.152710 19.587099 -21.722300)(13.258000 16.289999 -25.001001)(8.371000 19.261002 -25.001001)(8.339000 19.200001 -21.374001)(10.803100 17.752901 -22.464500)(13.258000 16.289999 -25.001001)(8.339000 19.200001 -21.374001)(7.857000 19.477001 -21.618999)(6.774760 19.763102 -21.878799)(7.152710 19.587099 -21.722300)(6.774760 19.763102 -21.878799)(7.857000 19.477001 -21.618999)(7.195240 19.616899 -23.309999)(6.386180 19.864300 -22.039700)(6.774760 19.763102 -21.878799)(7.195240 19.616899 -23.309999)(13.258000 16.289999 -25.001001)(13.481999 25.677999 -25.001001)(8.371000 19.261002 -25.001001)(17.161001 12.110000 -25.001001)(19.792000 7.032000 -25.001001)(19.235001 21.707001 -25.001001)(19.792000 7.032000 -25.001001)(23.871000 16.473999 -25.001001)(19.235001 21.707001 -25.001001)(20.955999 1.433000 -25.001001)(19.792000 7.032000 -25.001001)(20.028999 6.329000 -11.316999)(19.792000 7.032000 -25.001001)(20.955999 1.433000 -25.001001)(23.871000 16.473999 -25.001001)(17.161001 12.110000 -25.001001)(19.235001 21.707001 -25.001001)(13.481999 25.677999 -25.001001)(19.235001 21.707001 -25.001001)(19.235001 21.707001 -27.500999)(13.481999 25.677999 -25.001001)(19.235001 21.707001 -27.500999)(19.235001 21.707001 -25.001001)(23.871000 16.473999 -27.500999)(19.235001 21.707001 -27.500999)(13.481999 25.677999 -27.500999)(13.481999 25.677999 -25.001001)(13.481999 25.677999 -25.001001)(13.481999 25.677999 -27.500999)(6.945000 28.157000 -25.001001)(13.258000 16.289999 -25.001001)(17.161001 12.110000 -25.001001)(13.481999 25.677999 -25.001001)(10.803100 17.752901 -22.464500)(8.339000 19.200001 -21.374001)(9.852700 18.332100 -20.604200)(13.481999 25.677999 -27.500999)(28.792999 -3.496000 -27.500999)(6.945000 28.157000 -27.500999)(12.108200 17.038500 -19.456999)(12.853001 16.611000 -19.077999)(12.374500 16.846298 -22.039499)(5.958000 19.975800 -22.216999)(6.016170 19.960602 -22.192900)(8.371000 19.261002 -25.001001)(2.864000 20.803999 -25.001001)(8.371000 19.261002 -25.001001)(6.945000 28.157000 -25.001001)(8.371000 19.261002 -25.001001)(2.864000 20.803999 -25.001001)(2.863000 20.798000 -22.817001)(4.642890 20.327000 -22.390200)(8.371000 19.261002 -25.001001)(2.863000 20.798000 -22.817001)(5.958000 19.975800 -22.216999)(4.642890 20.327000 -22.390200)(5.958000 23.500000 -22.216999)(5.958000 19.975800 -22.216999)(8.371000 19.261002 -25.001001)(4.642890 20.327000 -22.390200)(23.871000 16.473999 -27.500999)(19.235001 21.707001 -25.001001)(23.871000 16.473999 -25.001001)(13.481999 25.677999 -25.001001)(6.945000 28.157000 -25.001001)(8.371000 19.261002 -25.001001)(19.792000 7.032000 -25.001001)(17.161001 12.110000 -25.001001)(17.577000 11.497999 -14.840000)(6.016170 19.960602 -22.192900)(5.958000 19.975800 -22.216999)(5.958000 23.500000 -22.216999)(23.871000 16.473999 -27.500999)(28.792999 -3.496000 -27.500999)(19.235001 21.707001 -27.500999)(27.119999 10.283000 -27.500999)(28.792999 -3.496000 -27.500999)(23.871000 16.473999 -27.500999)(28.792999 3.495000 -27.500999)(28.792999 -3.496000 -27.500999)(27.119999 10.283000 -27.500999)(27.119999 10.283000 -27.500999)(27.119999 10.283000 -25.001001)(28.792999 3.495000 -27.500999)(28.792999 3.495000 -27.500999)(27.119999 10.283000 -25.001001)(28.792999 3.495000 -25.001001)(5.670000 -20.221001 -25.001001)(10.916000 -17.943001 -25.001001)(10.652300 -17.859001 -20.273100)(-5.611000 20.235001 -22.305000)(-5.884380 20.106699 -22.225401)(-5.780590 20.161699 -22.239000)(0.005003 20.990601 -23.000999)(-0.089555 20.986000 -22.988501)(0.005003 23.500000 -23.000999)(2.864000 20.803999 -25.001001)(-0.089555 20.986000 -22.988501)(0.005003 20.990601 -23.000999)(-2.752000 20.818001 -22.834999)(-0.089555 20.986000 -22.988501)(2.864000 20.803999 -25.001001)(-2.752000 20.818001 -22.834999)(2.864000 20.803999 -25.001001)(-2.853000 20.798000 -22.816000)(-2.853000 20.798000 -22.816000)(-2.752000 20.818001 -22.834999)(-2.647870 20.712500 -22.749701)(-2.752000 20.818001 -22.834999)(-1.291020 20.812799 -22.830299)(-1.267620 20.816401 -22.833399)(-1.267620 20.816401 -22.833399)(-0.089555 20.986000 -22.988501)(-2.752000 20.818001 -22.834999)(-2.441380 20.621801 -22.678801)(-1.291020 20.812799 -22.830299)(-2.752000 20.818001 -22.834999)(2.864000 20.803999 -25.001001)(0.013399 20.991400 -22.999899)(0.005003 20.990601 -23.000999)(-2.752000 20.818001 -22.834999)(-2.441380 20.621801 -22.678801)(-2.647870 20.712500 -22.749701)(-0.089555 20.986000 -22.988501)(-1.267620 20.816401 -22.833399)(0.005003 23.500000 -23.000999)(-1.267620 20.816401 -22.833399)(-2.971500 21.848900 -22.608999)(0.005003 23.500000 -23.000999)(0.005003 23.500000 -23.000999)(0.013399 20.991400 -22.999899)(0.005003 20.990601 -23.000999)(-2.551230 20.607199 -22.664299)(-2.647870 20.712500 -22.749701)(-2.441380 20.621801 -22.678801)(-5.405410 20.215799 -22.288500)(-5.530630 20.197701 -22.271999)(-5.948000 23.500000 -22.216999)(-2.971500 21.848900 -22.608999)(-5.405410 20.215799 -22.288500)(-4.459750 21.857901 -22.413000)(-5.405410 20.215799 -22.288500)(-5.948000 23.500000 -22.216999)(-4.459750 21.857901 -22.413000)(-5.948000 23.500000 -22.216999)(-2.971500 21.848900 -22.608999)(-4.459750 21.857901 -22.413000)(-3.238430 20.503500 -22.573801)(-5.405410 20.215799 -22.288500)(-2.971500 21.848900 -22.608999)(-2.551230 20.607199 -22.664299)(-2.853000 20.798000 -22.816000)(-3.238430 20.503500 -22.573801)(-2.551230 20.607199 -22.664299)(-3.238430 20.503500 -22.573801)(-2.971500 21.848900 -22.608999)(-2.971500 21.848900 -22.608999)(-2.441380 20.621801 -22.678801)(-2.551230 20.607199 -22.664299)(-5.611000 20.235001 -22.305000)(-5.530630 20.197701 -22.271999)(-5.405410 20.215799 -22.288500)(-5.780590 20.161699 -22.239000)(-5.530630 20.197701 -22.271999)(-5.611000 20.235001 -22.305000)(-16.258999 -23.600000 -16.264002)(-11.495000 -23.600000 -19.920000)(-19.914000 -23.600000 11.499000)(-13.425500 -15.910400 -21.169500)(-11.496800 -17.476599 -19.918701)(-12.168800 -16.937901 -19.402901)(-12.168800 -16.937901 -19.402901)(-12.501499 -16.671299 -19.147598)(-13.425500 -15.910400 -21.169500)(-13.877000 -18.224800 -18.092001)(-12.501499 -16.671299 -19.147598)(-12.168800 -16.937901 -19.402901)(-13.425500 -15.910400 -21.169500)(-12.501499 -16.671299 -19.147598)(-15.109000 -14.580000 -17.337999)(-14.391200 -15.130800 -21.169500)(-13.425500 -15.910400 -21.169500)(-15.109000 -14.580000 -17.337999)(-14.391200 -15.130800 -21.169500)(-15.109000 -14.580000 -17.337999)(-15.343000 -14.334000 -25.001001)(-14.391200 -15.130800 -21.169500)(-15.343000 -14.334000 -25.001001)(-13.425500 -15.910400 -21.169500)(-15.601800 -13.834100 -16.768301)(-15.295000 -14.298000 -17.123001)(-14.984200 -14.434000 -17.242300)(-15.343000 -14.334000 -25.001001)(-15.295000 -14.298000 -17.123001)(-15.601800 -13.834100 -16.768301)(-15.343000 -14.334000 -25.001001)(-15.109000 -14.580000 -17.337999)(-15.295000 -14.298000 -17.123001)(-15.109000 -14.580000 -17.337999)(-15.295000 -14.298000 -17.123001)(-14.984200 -14.434000 -17.242300)(-13.877000 -18.224800 -18.092001)(-15.601800 -13.834100 -16.768301)(-14.984200 -14.434000 -17.242300)(-13.877000 -18.224800 -18.092001)(-16.258999 -23.600000 -16.264002)(-15.601800 -13.834100 -16.768301)(-11.495000 -23.600000 -19.920000)(-16.258999 -23.600000 -16.264002)(-13.877000 -20.912399 -18.092001)(-16.258999 -23.600000 -16.264002)(-13.877000 -18.224800 -18.092001)(-13.877000 -20.912399 -18.092001)(-13.877000 -18.224800 -18.092001)(-11.495000 -23.600000 -19.920000)(-13.877000 -20.912399 -18.092001)(-14.621901 -14.786700 -17.520300)(-15.109000 -14.580000 -17.337999)(-12.501499 -16.671299 -19.147598)(-14.984200 -14.434000 -17.242300)(-15.109000 -14.580000 -17.337999)(-14.621901 -14.786700 -17.520300)(23.004999 23.500000 -0.001006)(22.221001 -23.600000 5.952000)(23.004999 -23.600000 -0.001002)(-8.886140 23.446400 20.965601)(-11.495000 23.500000 19.918001)(-11.495000 -23.600000 19.918001)(-19.914000 -23.600000 -11.501000)(-20.791500 -0.000005 -9.382000)(-20.392200 -4.356970 -10.346100)(17.161001 12.110000 -25.001001)(17.077002 12.039001 -15.289001)(17.577000 11.497999 -14.840000)(16.659399 12.565599 -20.145000)(16.166599 13.029300 -16.341900)(16.268000 12.919600 -16.264002)(16.268000 12.919600 -16.264002)(16.166599 13.029300 -16.341900)(16.268000 23.500000 -16.264002)(16.659399 12.565599 -20.145000)(16.268000 12.919600 -16.264002)(16.881701 12.250601 -15.464200)(19.679199 7.064120 -11.818700)(17.577000 11.497999 -14.840000)(17.206701 11.732100 -15.040800)(17.206701 11.732100 -15.040800)(17.577000 11.497999 -14.840000)(17.177601 11.778400 -15.078700)(18.095501 15.026000 -13.882500)(17.206701 11.732100 -15.040800)(17.177601 11.778400 -15.078700)(17.077002 12.039001 -15.289001)(17.177601 11.778400 -15.078700)(17.577000 11.497999 -14.840000)(17.177601 11.778400 -15.078700)(17.077002 12.039001 -15.289001)(16.974600 12.102100 -15.343300)(16.268000 23.500000 -16.264002)(16.974600 12.102100 -15.343300)(16.881701 12.250601 -15.464200)(16.974600 12.102100 -15.343300)(17.077002 12.039001 -15.289001)(16.881701 12.250601 -15.464200)(16.659399 12.565599 -20.145000)(16.881701 12.250601 -15.464200)(17.077002 12.039001 -15.289001)(16.268000 23.500000 -16.264002)(17.177601 11.778400 -15.078700)(16.974600 12.102100 -15.343300)(16.659399 12.565599 -20.145000)(17.077002 12.039001 -15.289001)(17.161001 12.110000 -25.001001)(16.268000 23.500000 -16.264002)(18.095501 15.026000 -13.882500)(17.177601 11.778400 -15.078700)(19.235001 21.707001 -27.500999)(28.792999 -3.496000 -27.500999)(13.481999 25.677999 -27.500999)(20.027000 -6.334000 -11.320000)(20.458000 -4.250000 -10.478000)(20.308800 -4.372590 -10.569700)(0.005003 -21.000000 -25.001001)(2.760000 -20.818001 -22.834999)(0.077003 -21.000000 -23.000999)(2.760000 -20.818001 -22.834999)(4.630370 -20.329901 -22.391800)(2.353690 -20.664900 -22.696400)(-18.778400 8.865850 -12.980900)(-19.322001 8.213000 -12.469000)(-18.981899 8.514900 -12.715700)(-19.346199 14.920899 -12.240900)(-18.778400 8.865850 -12.980900)(-18.981899 8.514900 -12.715700)(6.945000 28.157000 -27.500999)(28.792999 -3.496000 -27.500999)(0.005003 29.000000 -27.500999)(20.798899 -0.022670 -9.386800)(20.800900 -0.000995 -9.382000)(21.005001 -0.001000 -9.382000)(0.005003 23.500000 -23.000999)(0.013399 20.991400 -22.999899)(0.042116 20.994400 -22.996099)(-20.222601 -5.347680 -17.674999)(-19.914000 -6.341040 -11.501000)(-20.011301 -6.032440 -11.266000)(-13.877000 18.801401 -18.092001)(-15.308500 14.102799 -16.993401)(-16.258999 23.500000 -16.264002)(4.642890 20.327000 -22.390200)(2.981510 21.737900 -22.608999)(5.958000 23.500000 -22.216999)(0.536158 -20.923000 -22.931000)(2.353690 -20.664900 -22.696400)(4.630370 -20.329901 -22.391800)(6.945000 28.157000 -25.001001)(0.005003 29.000000 -25.001001)(2.864000 20.803999 -25.001001)(19.904900 -6.591660 -11.524600)(19.923000 -23.600000 -11.501000)(19.683401 -7.056580 -11.813300)(2.760000 -20.818001 -22.834999)(0.005003 -21.000000 -25.001001)(4.630370 -20.329901 -22.391800)(5.958010 -23.600000 22.215000)(11.505000 23.500000 19.918001)(5.958010 23.500000 22.215000)(19.923000 23.500000 11.499000)(16.268000 23.500000 16.263000)(16.268000 -23.600000 16.263000)(-17.152000 12.110000 -25.001001)(-13.472000 25.677999 -25.001001)(-19.226000 21.707001 -25.001001)(20.566000 -4.273000 -25.001001)(23.871000 -16.473999 -25.001001)(20.955999 1.433000 -25.001001)(18.650002 -9.661000 -25.001001)(19.904900 -6.591660 -11.524600)(19.683401 -7.056580 -11.813300)(19.683401 -7.056580 -11.813300)(18.483999 -9.580000 -13.534000)(18.650002 -9.661000 -25.001001)(-15.091001 14.598000 -17.353001)(-16.041800 13.129100 -16.430700)(-15.589900 13.845301 -16.777500)(-18.086500 16.182899 -13.882500)(-16.258999 12.784699 -16.264002)(-16.744499 12.066000 -15.631400)(22.221001 -23.600000 5.952000)(-5.948000 -23.600000 -22.216999)(23.004999 -23.600000 -0.001002)(-22.211000 23.500000 5.952000)(-22.995001 23.500000 -0.001002)(-22.995001 -23.600000 -0.000998)(0.101084 20.985802 -22.988300)(0.042116 20.994400 -22.996099)(0.005003 23.500000 -23.000999)(5.958010 -23.600000 -22.216999)(4.630370 -20.329901 -22.391800)(5.348930 -20.115499 -22.297199)(0.005003 29.000000 -27.500999)(-6.935000 28.157000 -27.500999)(-6.935000 28.157000 -25.001001)(16.166599 13.029300 -16.341900)(16.659399 12.565599 -20.145000)(17.161001 12.110000 -25.001001)(-0.064241 -20.990499 -22.991899)(0.005003 -20.995001 -23.000999)(0.005003 -23.600000 -23.000999)(-15.091001 14.598000 -17.353001)(-15.589900 13.845301 -16.777500)(-15.308500 14.102799 -16.993401)(11.485800 17.393499 -19.928001)(9.852700 18.332100 -20.604200)(11.505000 23.500000 -19.920000)(9.852700 18.332100 -20.604200)(8.731501 20.441200 -21.068501)(11.505000 23.500000 -19.920000)(9.852700 18.332100 -20.604200)(7.152710 19.587099 -21.722300)(8.731501 20.441200 -21.068501)(-22.211000 -23.600000 5.952000)(-19.914000 23.500000 11.499000)(-22.211000 23.500000 5.952000)(-12.168800 -16.937901 -19.402901)(-11.496800 -17.476599 -19.918701)(-11.495000 -23.600000 -19.920000)(-13.248000 16.289999 -25.001001)(-16.041800 13.129100 -16.430700)(-15.091001 14.598000 -17.353001)(-20.875000 -2.242000 -9.646000)(-20.995001 -0.000001 -25.001001)(-20.556000 -4.273000 -25.001001)(-5.530630 20.197701 -22.271999)(-5.780590 20.161699 -22.239000)(-5.948000 23.500000 -22.216999)(-18.086500 16.182899 -13.882500)(-16.258999 23.500000 -16.264002)(-16.258999 12.784699 -16.264002)(16.268000 23.500000 -16.264002)(16.881701 12.250601 -15.464200)(16.268000 12.919600 -16.264002)(11.505000 -23.600000 -19.920000)(8.731501 -20.691599 -21.068501)(9.824030 -18.346199 -20.616098)(28.792999 -3.496000 -27.500999)(-13.472000 -25.677999 -27.500999)(-19.226000 -21.707001 -27.500999)(27.119999 10.283000 -27.500999)(23.871000 16.473999 -25.001001)(27.119999 10.283000 -25.001001)(23.871000 -16.473999 -25.001001)(19.235001 -21.707001 -25.001001)(23.871000 -16.473999 -27.500999)(27.119999 -10.284000 -27.500999)(23.871000 -16.473999 -25.001001)(23.871000 -16.473999 -27.500999)(23.871000 16.473999 -25.001001)(27.119999 -10.284000 -25.001001)(27.119999 10.283000 -25.001001)(23.871000 -16.473999 -25.001001)(27.119999 -10.284000 -25.001001)(23.871000 16.473999 -25.001001)(27.119999 -10.284000 -27.500999)(28.792999 -3.496000 -27.500999)(27.119999 -10.284000 -25.001001)(27.119999 -10.284000 -25.001001)(23.871000 -16.473999 -25.001001)(27.119999 -10.284000 -27.500999)(23.871000 -16.473999 -27.500999)(28.792999 -3.496000 -27.500999)(27.119999 -10.284000 -27.500999)(28.792999 -3.496000 -27.500999)(28.792999 -3.496000 -25.001001)(27.119999 -10.284000 -25.001001)(29.005001 -0.000002 -27.500999)(28.792999 -3.496000 -25.001001)(28.792999 -3.496000 -27.500999)(23.871000 -16.473999 -27.500999)(19.235001 -21.707001 -25.001001)(19.235001 -21.707001 -27.500999)(19.235001 -21.707001 -25.001001)(13.481999 -25.677999 -25.001001)(19.235001 -21.707001 -27.500999)(11.505000 17.382401 -19.920000)(12.108200 17.038500 -19.456999)(12.374500 16.846298 -22.039499)(19.235001 -21.707001 -25.001001)(23.871000 -16.473999 -25.001001)(20.566000 -4.273000 -25.001001)(0.005003 29.000000 -25.001001)(6.945000 28.157000 -27.500999)(0.005003 29.000000 -27.500999)(-18.086500 16.182899 -13.882500)(-16.871801 11.921200 -15.465500)(-18.000900 10.206800 -13.994100)(-19.888399 -6.422130 -11.534300)(-19.914000 -6.341040 -11.501000)(-20.222601 -5.347680 -17.674999)(10.916000 -17.943001 -25.001001)(14.274800 -15.061300 -17.793900)(12.791000 -16.659000 -19.118999)(-28.783998 3.496000 -25.001001)(-27.111000 10.284000 -27.500999)(-28.783998 3.496000 -27.500999)(11.162499 -20.498400 -20.061800)(11.426600 -17.441200 -19.952499)(11.505000 -17.396900 -19.920000)(22.221001 -23.600000 5.952000)(19.923000 -23.600000 11.499000)(-5.948000 -23.600000 -22.216999)(2.080820 20.805799 -22.823799)(1.298650 20.813599 -22.830601)(1.365690 20.803301 -22.821800)(13.258000 16.289999 -25.001001)(14.343000 14.998500 -17.741600)(16.041201 13.165200 -16.438101)(20.896999 -2.125000 -9.619000)(20.853100 -1.068300 -9.502220)(20.701200 -2.135600 -9.622450)(-11.496800 -17.476599 -19.918701)(-13.425500 -15.910400 -21.169500)(-15.343000 -14.334000 -25.001001)(11.505000 -17.396900 -19.920000)(11.426600 -17.441200 -19.952499)(10.916000 -17.943001 -25.001001)(-20.791100 0.009213 -9.383030)(-20.791500 -0.000005 -9.382000)(-22.211000 23.500000 -5.954000)(-15.601800 -13.834100 -16.768301)(-16.258999 -23.600000 -16.264002)(-16.115099 -13.060800 -16.374399)(-22.211000 23.500000 -5.954000)(-20.791500 -0.000005 -9.382000)(-19.914000 -23.600000 -11.501000)(-19.346199 14.920899 -12.240900)(-18.981899 8.514900 -12.715700)(-19.030800 8.435540 -12.652000)(20.955999 1.433000 -25.001001)(20.931999 1.432000 -9.542000)(21.005001 -0.001000 -9.382000)(2.864000 20.803999 -25.001001)(0.013399 20.991400 -22.999899)(0.128003 21.000000 -23.000999)(16.166599 13.029300 -16.341900)(16.041201 13.165200 -16.438101)(16.268000 23.500000 -16.264002)(16.268000 23.500000 -16.264002)(19.923000 23.500000 -11.501000)(18.095501 15.026000 -13.882500)(-28.783998 3.496000 -25.001001)(-28.783998 -3.496000 -27.500999)(-28.783998 -3.496000 -25.001001)(-19.072100 -8.365400 -12.598100)(-19.331001 -8.194000 -12.457000)(-18.441000 -9.539000 -13.485000)(19.792000 7.032000 -25.001001)(17.577000 11.497999 -14.840000)(19.679199 7.064120 -11.818700)(19.792000 7.032000 -25.001001)(19.711000 6.997010 -11.777200)(19.907700 6.583990 -11.520900)(19.907700 6.583990 -11.520900)(19.711000 6.997010 -11.777200)(18.095501 15.026000 -13.882500)(18.095501 15.026000 -13.882500)(19.711000 6.997010 -11.777200)(19.679199 7.064120 -11.818700)(19.792000 7.032000 -25.001001)(19.679199 7.064120 -11.818700)(19.711000 6.997010 -11.777200)(-22.211000 23.500000 -5.954000)(-20.011200 6.032800 -11.266300)(-20.390400 4.370190 -10.350500)(29.005001 -0.000002 -27.500999)(28.792999 -3.496000 -27.500999)(28.792999 3.495000 -27.500999)(20.696800 2.153320 -9.633190)(20.698502 2.145780 -9.629080)(20.896999 2.123000 -9.619000)(-11.495000 23.500000 -19.920000)(-5.948000 23.500000 -22.216999)(-8.721499 22.093801 -21.068501)(-5.948000 23.500000 -22.216999)(-8.721499 20.687698 -21.068501)(-8.721499 22.093801 -21.068501)(-8.721499 20.687698 -21.068501)(-11.495000 23.500000 -19.920000)(-8.721499 22.093801 -21.068501)(-11.495000 23.500000 -19.920000)(-8.721499 20.687698 -21.068501)(-10.108299 20.687698 -20.494301)(-8.721499 20.687698 -21.068501)(-10.832601 17.875399 -20.194300)(-10.108299 20.687698 -20.494301)(-10.832601 17.875399 -20.194300)(-11.495000 23.500000 -19.920000)(-10.108299 20.687698 -20.494301)(6.945000 -28.157000 -27.500999)(0.005003 -29.000000 -27.500999)(28.792999 -3.496000 -27.500999)(-2.803000 -20.811001 -22.829000)(-2.862620 -20.605700 -22.641901)(-5.661000 -20.221001 -22.292000)(-19.703999 7.007000 -11.803000)(-19.767801 6.804340 -11.691501)(-19.683100 7.004490 -11.801900)(19.792000 7.032000 -25.001001)(19.907700 6.583990 -11.520900)(19.923000 6.552000 -11.501000)(-8.427310 18.990601 -21.190300)(-8.899090 18.772001 -20.995001)(-8.721499 20.687698 -21.068501)(11.505000 17.382401 -19.920000)(11.485800 17.393499 -19.928001)(11.505000 23.500000 -19.920000)(19.909401 -6.579250 -11.518800)(20.566000 -4.273000 -25.001001)(20.240101 -5.427220 -18.160500)(19.904900 -6.591660 -11.524600)(19.923000 -6.550460 -11.501000)(19.909401 -6.579250 -11.518800)(-20.533998 4.378000 -10.353000)(-20.011200 6.032800 -11.266300)(-19.914000 6.341730 -11.501000)(-2.853000 20.798000 -22.816000)(-2.647870 20.712500 -22.749701)(-2.551230 20.607199 -22.664299)(13.886500 18.209801 -18.092001)(16.268000 23.500000 -16.264002)(15.077300 18.332600 -17.178001)(16.268000 23.500000 -16.264002)(16.041201 13.165200 -16.438101)(15.077300 18.332600 -17.178001)(16.041201 13.165200 -16.438101)(13.886500 18.209801 -18.092001)(15.077300 18.332600 -17.178001)(20.566000 -4.273000 -25.001001)(20.458000 -4.250000 -10.478000)(20.027000 -6.334000 -11.320000)(19.923000 23.500000 -11.501000)(20.701799 2.129080 -9.620950)(20.702999 2.115380 -9.618160)(-2.855000 20.803999 -25.001001)(-2.853000 20.798000 -22.816000)(2.864000 20.803999 -25.001001)(16.268000 -12.928500 -16.264002)(18.095501 -16.185400 -13.882500)(16.268000 -23.600000 -16.264002)(16.878500 -12.257900 -15.468499)(17.681200 -10.919000 -14.501200)(17.680901 -10.770101 -14.422800)(18.483999 -9.580000 -13.534000)(17.680901 -10.770101 -14.422800)(17.681200 -10.919000 -14.501200)(18.230499 -9.790180 -13.706600)(17.680901 -10.770101 -14.422800)(18.483999 -9.580000 -13.534000)(18.772200 -8.770841 -13.000600)(18.230499 -9.790180 -13.706600)(18.483999 -9.580000 -13.534000)(17.680901 -10.770101 -14.422800)(18.230499 -9.790180 -13.706600)(18.095501 -16.185400 -13.882500)(17.560999 -11.523000 -14.859000)(17.681200 -10.919000 -14.501200)(16.878500 -12.257900 -15.468499)(18.095501 -16.185400 -13.882500)(16.878500 -12.257900 -15.468499)(17.680901 -10.770101 -14.422800)(16.268000 -12.928500 -16.264002)(16.878500 -12.257900 -15.468499)(18.095501 -16.185400 -13.882500)(5.958010 -23.600000 -22.216999)(5.631490 -20.074600 -22.260000)(5.912950 -20.001900 -22.222900)(22.221001 23.500000 5.952000)(19.923000 -23.600000 11.499000)(22.221001 -23.600000 5.952000)(10.663300 17.852600 -21.196199)(9.852700 18.332100 -20.604200)(11.485800 17.393499 -19.928001)(10.663300 17.852600 -21.196199)(11.485800 17.393499 -19.928001)(10.803100 17.752901 -22.464500)(10.663300 17.852600 -21.196199)(10.803100 17.752901 -22.464500)(9.852700 18.332100 -20.604200)(21.005001 -0.001000 -9.382000)(20.931999 1.432000 -9.542000)(20.800900 -0.000995 -9.382000)(7.152710 19.587099 -21.722300)(9.852700 18.332100 -20.604200)(8.339000 19.200001 -21.374001)(-18.778400 8.865850 -12.980900)(-19.346199 14.920899 -12.240900)(-19.914000 23.500000 -11.501000)(-23.862001 16.473999 -25.001001)(-20.945999 1.433000 -25.001001)(-19.226000 21.707001 -25.001001)(-18.086500 16.182899 -13.882500)(-18.000900 10.206800 -13.994100)(-18.778400 8.865850 -12.980900)(0.005003 -23.600000 -23.000999)(-0.329676 -20.952000 -22.956900)(-0.064241 -20.990499 -22.991899)(18.650002 -9.661000 -25.001001)(18.483999 -9.580000 -13.534000)(17.560999 -11.523000 -14.859000)(12.163500 16.987900 -19.414499)(12.853001 16.611000 -19.077999)(12.108200 17.038500 -19.456999)(-5.405410 20.215799 -22.288500)(-3.238430 20.503500 -22.573801)(-2.853000 20.798000 -22.816000)(0.005004 -29.000000 -25.001001)(5.670000 -20.221001 -25.001001)(0.005003 -21.000000 -25.001001)(-6.935000 -28.157000 -25.001001)(-6.935000 -28.157000 -27.500999)(0.005004 -29.000000 -25.001001)(16.268000 -12.928500 -16.264002)(17.560999 -11.523000 -14.859000)(16.878500 -12.257900 -15.468499)(-13.472000 -25.677999 -25.001001)(-6.935000 -28.157000 -25.001001)(-10.907000 -17.943001 -25.001001)(-27.111000 10.284000 -27.500999)(-28.783998 3.496000 -25.001001)(-27.111000 10.284000 -25.001001)(16.268000 -23.600000 -16.264002)(16.118599 -13.088400 -16.378700)(16.268000 -12.928500 -16.264002)(-5.405410 20.215799 -22.288500)(-2.853000 20.798000 -22.816000)(-5.611000 20.235001 -22.305000)(13.481999 -25.677999 -25.001001)(13.481999 -25.677999 -27.500999)(19.235001 -21.707001 -27.500999)(-11.495000 -23.600000 -19.920000)(-10.421600 -18.070999 -20.364500)(-10.108299 -20.835501 -20.494301)(-10.421600 -18.070999 -20.364500)(-8.721499 -20.539001 -21.068501)(-10.108299 -20.835501 -20.494301)(-8.721499 -20.539001 -21.068501)(-11.495000 -23.600000 -19.920000)(-10.108299 -20.835501 -20.494301)(-18.641001 -9.661000 -25.001001)(-13.472000 -25.677999 -25.001001)(-15.343000 -14.334000 -25.001001)(18.230499 -9.790180 -13.706600)(18.772200 -8.770841 -13.000600)(18.095501 -16.185400 -13.882500)(-19.188101 -8.172450 -12.446900)(-19.072100 -8.365400 -12.598100)(-18.086500 -14.970500 -13.882500)(22.221001 -23.600000 5.952000)(23.004999 23.500000 -0.001006)(22.221001 23.500000 5.952000)(-12.530000 16.645901 -19.125700)(-13.877000 18.801401 -18.092001)(-11.495000 17.455200 -19.920000)(-28.783998 3.496000 -25.001001)(-28.783998 -3.496000 -25.001001)(-27.111000 -10.283000 -25.001001)(5.958010 -23.600000 22.215000)(-5.948000 -23.600000 -22.216999)(11.505000 -23.600000 19.918001)(27.119999 -10.284000 -25.001001)(28.792999 -3.496000 -25.001001)(27.119999 10.283000 -25.001001)(-17.388300 -11.295899 -19.243000)(-16.183199 -12.963200 -16.322199)(-16.258999 -12.849600 -16.264002)(20.698502 2.145780 -9.629080)(20.696800 2.153320 -9.633190)(19.998901 6.330440 -11.317901)(19.235001 -21.707001 -25.001001)(16.358500 -20.005999 -25.001001)(13.481999 -25.677999 -25.001001)(23.871000 -16.473999 -27.500999)(19.235001 -21.707001 -27.500999)(28.792999 -3.496000 -27.500999)(11.505000 -23.600000 -19.920000)(11.505000 -17.396900 -19.920000)(13.886500 -18.785299 -18.092001)(16.268000 -23.600000 -16.264002)(15.294200 -13.970500 -17.011501)(16.118599 -13.088400 -16.378700)(28.792999 3.495000 -25.001001)(29.005001 -0.000002 -27.500999)(28.792999 3.495000 -27.500999)(18.483999 -9.580000 -13.534000)(17.681200 -10.919000 -14.501200)(17.560999 -11.523000 -14.859000)(2.863000 20.798000 -22.817001)(3.735910 20.454399 -22.509600)(4.642890 20.327000 -22.390200)(-11.495000 -23.600000 -19.920000)(-13.877000 -18.224800 -18.092001)(-12.168800 -16.937901 -19.402901)(-13.877000 -18.224800 -18.092001)(-14.621901 -14.786700 -17.520300)(-12.501499 -16.671299 -19.147598)(-5.948000 -23.600000 -22.216999)(-5.975290 -20.084400 -22.205700)(-5.948000 -20.096199 -22.216999)(-15.343000 -14.334000 -25.001001)(-15.601800 -13.834100 -16.768301)(-16.115099 -13.060800 -16.374399)(5.958010 -23.600000 -22.216999)(5.348930 -20.115499 -22.297199)(5.514570 -20.091499 -22.275400)(0.005003 23.500000 -23.000999)(-2.971500 21.848900 -22.608999)(-2.971500 22.674400 -22.608999)(-2.971500 21.848900 -22.608999)(-5.948000 23.500000 -22.216999)(-2.971500 22.674400 -22.608999)(-5.948000 23.500000 -22.216999)(0.005003 23.500000 -23.000999)(-2.971500 22.674400 -22.608999)(12.390599 16.780600 -19.240299)(13.202001 16.233002 -18.765001)(12.853001 16.611000 -19.077999)(-23.862001 -16.473999 -25.001001)(-19.226000 -21.707001 -25.001001)(-23.862001 16.473999 -25.001001)(-11.495000 -23.600000 -19.920000)(-11.208400 -17.700600 -20.038700)(-10.421600 -18.070999 -20.364500)(-5.947990 -23.600000 22.215000)(0.005007 -23.600000 22.999001)(0.005007 23.500000 22.999001)(-19.914000 -23.600000 -11.501000)(-16.258999 -23.600000 -16.264002)(-19.914000 -23.600000 11.499000)(-8.899090 18.772001 -20.995001)(-8.282001 19.077999 -21.267000)(-10.915000 17.937000 -20.243000)(0.005007 -23.600000 22.999001)(5.958010 23.500000 22.215000)(0.005007 23.500000 22.999001)(29.005001 -0.000002 -27.500999)(28.898998 -0.000500 -26.250999)(28.792999 -3.496000 -25.001001)(20.028999 6.329000 -11.316999)(20.896999 2.123000 -9.619000)(20.955999 1.433000 -25.001001)(22.221001 -23.600000 -5.954000)(19.923000 23.500000 -11.501000)(22.221001 23.500000 -5.954000)(2.809000 20.811998 -22.829000)(2.863000 20.798000 -22.817001)(2.864000 20.803999 -25.001001)(18.095501 15.026000 -13.882500)(19.923000 23.500000 -11.501000)(19.907700 6.583990 -11.520900)(7.195240 19.616899 -23.309999)(7.857000 19.477001 -21.618999)(8.371000 19.261002 -25.001001)(20.955999 1.433000 -25.001001)(23.871000 -16.473999 -25.001001)(23.871000 16.473999 -25.001001)(-20.390400 4.370190 -10.350500)(-20.533998 4.378000 -10.353000)(-20.632700 3.312220 -9.999930)(-20.390400 4.370190 -10.350500)(-20.011200 6.032800 -11.266300)(-20.533998 4.378000 -10.353000)(22.221001 -23.600000 -5.954000)(19.955299 -6.484630 -11.423000)(19.988701 -6.362160 -11.342400)(23.871000 16.473999 -25.001001)(27.119999 10.283000 -27.500999)(23.871000 16.473999 -27.500999)(-5.948000 -23.600000 -22.216999)(-2.971500 -21.848099 -22.608999)(-2.971500 -22.724100 -22.608999)(-2.971500 -21.848099 -22.608999)(0.005003 -23.600000 -23.000999)(-2.971500 -22.724100 -22.608999)(0.005003 -23.600000 -23.000999)(-5.948000 -23.600000 -22.216999)(-2.971500 -22.724100 -22.608999)(19.923000 6.552000 -11.501000)(20.028999 6.329000 -11.316999)(19.792000 7.032000 -25.001001)(-19.226000 21.707001 -25.001001)(-13.472000 25.677999 -27.500999)(-19.226000 21.707001 -27.500999)(-5.948000 -20.096199 -22.216999)(-10.907000 -17.943001 -25.001001)(-5.661000 -20.221001 -22.292000)(16.268000 -23.600000 -16.264002)(-5.948000 -23.600000 -22.216999)(0.005003 -23.600000 -23.000999)(8.731501 -20.691599 -21.068501)(6.746790 -19.776501 -21.890400)(9.824030 -18.346199 -20.616098)(1.365690 20.803301 -22.821800)(3.227210 20.496899 -22.576601)(2.863000 20.798000 -22.817001)(-8.899090 18.772001 -20.995001)(-10.832601 17.875399 -20.194300)(-8.721499 20.687698 -21.068501)(-2.971500 21.848900 -22.608999)(-1.291020 20.812799 -22.830299)(-1.267620 20.816401 -22.833399)(2.863000 20.798000 -22.817001)(2.080820 20.805799 -22.823799)(1.365690 20.803301 -22.821800)(-13.472000 25.677999 -27.500999)(28.792999 -3.496000 -27.500999)(-19.226000 21.707001 -27.500999)(-11.404900 17.533300 -19.957300)(-10.915000 17.937000 -20.243000)(-8.362000 19.261002 -25.001001)(21.005001 -0.001000 -9.382000)(20.798899 -0.022670 -9.386800)(20.853100 -1.068300 -9.502220)(-10.832601 17.875399 -20.194300)(-8.899090 18.772001 -20.995001)(-10.915000 17.937000 -20.243000)(17.206701 11.732100 -15.040800)(18.095501 15.026000 -13.882500)(19.679199 7.064120 -11.818700)(6.774760 19.763102 -21.878799)(6.386180 19.864300 -22.039700)(5.958000 23.500000 -22.216999)(6.774760 19.763102 -21.878799)(8.731501 20.441200 -21.068501)(7.152710 19.587099 -21.722300)(15.351999 -14.334000 -25.001001)(15.294200 -13.970500 -17.011501)(15.139900 -14.135699 -17.129900)(-19.782999 7.033000 -25.001001)(-19.703999 7.007000 -11.803000)(-19.322001 8.213000 -12.469000)(-10.832601 17.875399 -20.194300)(-11.213300 17.698900 -20.036600)(-11.495000 23.500000 -19.920000)(0.005003 -21.000000 -25.001001)(-0.005297 -20.993599 -22.999599)(0.005003 -20.995001 -23.000999)(18.772200 -8.770841 -13.000600)(18.483999 -9.580000 -13.534000)(19.683401 -7.056580 -11.813300)(20.028999 6.329000 -11.316999)(20.696800 2.153320 -9.633190)(20.896999 2.123000 -9.619000)(-13.877000 -18.224800 -18.092001)(-14.984200 -14.434000 -17.242300)(-14.621901 -14.786700 -17.520300)(-2.441380 20.621801 -22.678801)(-2.971500 21.848900 -22.608999)(-1.291020 20.812799 -22.830299)(-44.557999 -28.600000 -5.665000)(-45.638199 23.500000 -4.585250)(-44.557999 23.500000 -5.665000)(-44.557999 -28.600000 -5.665000)(-44.557999 23.500000 -5.665000)(-44.200500 23.500000 -5.831780)(-50.695000 23.500000 -6.250000)(-44.200500 23.500000 -5.831780)(-44.557999 23.500000 -5.665000)(-45.638199 23.500000 -4.585250)(-50.695000 23.500000 -6.250000)(-44.557999 23.500000 -5.665000)(-53.137001 23.500000 -1.689000)(-50.695000 23.500000 -6.250000)(-45.638199 23.500000 -4.585250)(-50.695000 23.500000 -6.250000)(-41.095997 23.500000 -7.279100)(-44.200500 23.500000 -5.831780)(-37.368500 23.500000 14.143100)(-35.794998 23.500000 14.005401)(-37.828598 23.500000 16.081699)(-37.828598 23.500000 16.081699)(-35.794998 23.500000 14.005401)(-35.402000 23.500000 13.971000)(-35.402000 -28.600000 13.971000)(-35.402000 23.500000 13.971000)(-35.794998 23.500000 14.005401)(-39.208000 -28.600000 14.304000)(-35.402000 -28.600000 13.971000)(-35.794998 23.500000 14.005401)(-39.208000 -28.600000 14.304000)(-41.095997 -28.600000 -7.280000)(-35.402000 -28.600000 13.971000)(-42.897999 -28.600000 13.315000)(-41.095997 -28.600000 -7.280000)(-39.208000 -28.600000 14.304000)(-41.905602 43.000000 10.845201)(-41.931801 36.004200 18.174101)(-39.948898 43.000000 11.217500)(-46.546700 36.004200 16.175200)(-41.931801 36.004200 18.174101)(-41.905602 43.000000 10.845201)(-46.784000 23.500000 16.542000)(-41.931801 36.004200 18.174101)(-46.546700 36.004200 16.175200)(-46.784000 23.500000 16.542000)(-42.036999 23.500000 18.598000)(-41.931801 36.004200 18.174101)(-42.076199 23.500000 15.962900)(-46.784000 23.500000 16.542000)(-42.850201 23.500000 13.327800)(-46.784000 23.500000 16.542000)(-42.076199 23.500000 15.962900)(-42.036999 23.500000 18.598000)(-42.036999 23.500000 18.598000)(-39.342003 23.500000 19.022999)(-40.278698 36.004200 18.435101)(-42.036999 23.500000 18.598000)(-40.278698 36.004200 18.435101)(-41.931801 36.004200 18.174101)(-42.076199 23.500000 15.962900)(-42.850201 23.500000 13.327800)(-39.589100 23.500000 14.201900)(-42.076199 23.500000 15.962900)(-39.589100 23.500000 14.201900)(-39.208000 23.500000 14.304000)(-39.208000 -28.600000 14.304000)(-37.368500 23.500000 14.143100)(-39.208000 23.500000 14.304000)(-39.208000 -28.600000 14.304000)(-39.208000 23.500000 14.304000)(-39.589100 23.500000 14.201900)(-42.897999 -28.600000 13.315000)(-39.589100 23.500000 14.201900)(-42.850201 23.500000 13.327800)(-42.897999 -28.600000 13.315000)(-46.027000 -28.600000 11.124000)(-41.095997 -28.600000 -7.280000)(-46.027000 -28.600000 11.124000)(-42.897999 -28.600000 13.315000)(-43.221100 23.500000 13.088700)(-42.897999 -28.600000 13.315000)(-42.897999 23.500000 13.315000)(-43.221100 23.500000 13.088700)(-42.897999 -28.600000 13.315000)(-42.850201 23.500000 13.327800)(-42.897999 23.500000 13.315000)(-50.606998 23.500000 13.055000)(-46.606400 23.500000 10.296400)(-46.728600 23.500000 13.419200)(-50.606998 23.500000 13.055000)(-46.728600 23.500000 13.419200)(-46.784000 23.500000 16.542000)(-46.728600 23.500000 13.419200)(-46.027000 23.500000 11.124000)(-43.221100 23.500000 13.088700)(-46.784000 23.500000 16.542000)(-46.728600 23.500000 13.419200)(-43.221100 23.500000 13.088700)(-46.784000 23.500000 16.542000)(-43.221100 23.500000 13.088700)(-42.897999 23.500000 13.315000)(-46.027000 23.500000 11.124000)(-46.728600 23.500000 13.419200)(-46.253300 23.500000 10.800800)(-41.905602 43.000000 10.845201)(-39.948898 43.000000 11.217500)(-39.768902 42.954697 -8.889971)(-39.208000 -28.600000 14.304000)(-35.794998 23.500000 14.005401)(-37.368500 23.500000 14.143100)(-42.076199 23.500000 15.962900)(-39.208000 23.500000 14.304000)(-42.036999 23.500000 18.598000)(-46.027000 -28.600000 11.124000)(-48.218002 -28.600000 7.994000)(-41.095997 -28.600000 -7.280000)(-42.897999 -28.600000 13.315000)(-39.208000 -28.600000 14.304000)(-39.589100 23.500000 14.201900)(-46.253300 23.500000 10.800800)(-46.728600 23.500000 13.419200)(-46.606400 23.500000 10.296400)(-49.848198 23.500000 9.538490)(-48.227299 23.500000 9.145670)(-46.606400 23.500000 10.296400)(-46.606400 23.500000 10.296400)(-48.227299 23.500000 9.145670)(-48.218002 23.500000 7.994900)(-48.227299 23.500000 9.145670)(-49.848198 23.500000 9.538490)(-48.218002 23.500000 7.994900)(-46.606400 23.500000 10.296400)(-48.218002 23.500000 7.994900)(-48.218002 -28.600000 7.994000)(-48.218002 23.500000 7.994900)(-48.320099 23.500000 7.613830)(-48.218002 -28.600000 7.994000)(-46.253300 23.500000 10.800800)(-46.606400 23.500000 10.296400)(-48.218002 -28.600000 7.994000)(-48.218002 -28.600000 7.994000)(-49.206997 -28.600000 4.304000)(-41.095997 -28.600000 -7.280000)(-49.206997 23.500000 4.304900)(-49.172600 23.500000 3.911950)(-49.206997 -28.600000 4.304000)(-49.172600 23.500000 3.911950)(-48.873997 -28.600000 0.499005)(-49.206997 -28.600000 4.304000)(-48.920700 23.500000 1.032190)(-48.873997 23.500000 0.499000)(-48.873997 -28.600000 0.499005)(-49.172600 23.500000 3.911950)(-48.920700 23.500000 1.032190)(-48.873997 -28.600000 0.499005)(-49.172600 23.500000 3.911950)(-51.355900 23.500000 4.774600)(-48.920700 23.500000 1.032190)(-53.965000 23.500000 3.418000)(-48.920700 23.500000 1.032190)(-51.355900 23.500000 4.774600)(-41.095997 -28.600000 -7.280000)(-49.206997 -28.600000 4.304000)(-48.873997 -28.600000 0.499005)(-49.206997 23.500000 4.304900)(-51.355900 23.500000 4.774600)(-49.172600 23.500000 3.911950)(-51.355900 23.500000 4.774600)(-49.206997 23.500000 4.304900)(-48.746799 23.500000 6.021980)(-53.090000 23.500000 8.517000)(-51.355900 23.500000 4.774600)(-48.746799 23.500000 6.021980)(-53.090000 23.500000 8.517000)(-48.746799 23.500000 6.021980)(-49.848198 23.500000 9.538490)(-53.090000 23.500000 8.517000)(-49.848198 23.500000 9.538490)(-50.606998 23.500000 13.055000)(-48.218002 23.500000 7.994900)(-49.848198 23.500000 9.538490)(-48.320099 23.500000 7.613830)(-48.873997 -28.600000 0.499005)(-47.260002 -28.600000 -2.964000)(-41.095997 -28.600000 -7.280000)(-53.965000 23.500000 3.418000)(-53.137001 23.500000 -1.689000)(-49.801598 23.500000 -0.583624)(-49.801598 23.500000 -0.583624)(-53.137001 23.500000 -1.689000)(-47.260002 23.500000 -2.964000)(-48.707298 23.500000 0.141374)(-49.801598 23.500000 -0.583624)(-47.260002 23.500000 -2.964000)(-48.707298 23.500000 0.141374)(-47.260002 -28.600000 -2.964000)(-48.873997 -28.600000 0.499005)(-48.707298 23.500000 0.141374)(-47.260002 23.500000 -2.964000)(-47.260002 -28.600000 -2.964000)(-44.557999 -28.600000 -5.665000)(-47.260002 -28.600000 -2.964000)(-46.980999 23.500000 -3.242930)(-47.260002 -28.600000 -2.964000)(-47.260002 23.500000 -2.964000)(-46.980999 23.500000 -3.242930)(-48.873997 23.500000 0.499000)(-49.801598 23.500000 -0.583624)(-48.707298 23.500000 0.141374)(-53.965000 23.500000 3.418000)(-49.801598 23.500000 -0.583624)(-48.920700 23.500000 1.032190)(-53.965000 23.500000 3.418000)(-51.355900 23.500000 4.774600)(-53.090000 23.500000 8.517000)(-52.677700 36.004101 8.373360)(-53.965000 23.500000 3.418000)(-53.090000 23.500000 8.517000)(-52.677700 36.004101 8.373360)(-53.528301 36.004200 3.416080)(-53.965000 23.500000 3.418000)(-50.263302 36.004101 12.785700)(-52.677700 36.004101 8.373360)(-53.090000 23.500000 8.517000)(-47.622501 43.000000 5.394220)(-52.677700 36.004101 8.373360)(-50.263302 36.004101 12.785700)(-50.263302 36.004101 12.785700)(-45.258400 43.000000 8.842091)(-47.622501 43.000000 5.394220)(-50.263302 36.004101 12.785700)(-46.546700 36.004200 16.175200)(-45.258400 43.000000 8.842091)(-50.606998 23.500000 13.055000)(-46.546700 36.004200 16.175200)(-50.263302 36.004101 12.785700)(-52.677700 36.004101 8.373360)(-47.622501 43.000000 5.394220)(-48.501301 43.000000 0.921354)(-46.027000 23.500000 11.124000)(-46.253300 23.500000 10.800800)(-46.027000 -28.600000 11.124000)(-45.258400 43.000000 8.842091)(-41.905602 43.000000 10.845201)(-39.768902 42.954697 -8.889971)(-40.278698 36.004200 18.435101)(-39.948898 43.000000 11.217500)(-41.931801 36.004200 18.174101)(-39.342003 23.500000 19.022999)(-37.828598 23.500000 16.081699)(-35.402000 23.500000 13.971000)(-19.914000 23.500000 -11.501000)(-22.211000 23.500000 -5.954000)(-30.471001 23.500000 -4.432100)(-30.471001 23.500000 -4.432100)(-33.599998 23.500000 -6.624000)(-19.914000 23.500000 -11.501000)(-41.095997 -28.600000 -7.280000)(-44.200500 23.500000 -5.831780)(-41.095997 23.500000 -7.279100)(-41.095997 23.500000 -7.279100)(-37.290001 -28.600000 -7.612000)(-41.095997 -28.600000 -7.280000)(-37.290001 23.500000 -7.612000)(-33.599998 -28.600000 -6.624000)(-37.290001 -28.600000 -7.612000)(-37.290001 -28.600000 -7.612000)(-33.599998 -28.600000 -6.624000)(-41.095997 -28.600000 -7.280000)(-41.095997 -28.600000 -7.280000)(-33.599998 -28.600000 -6.624000)(-30.471001 -28.600000 -4.433000)(-33.599998 -28.600000 -6.624000)(-37.290001 23.500000 -7.612000)(-33.599998 23.500000 -6.624000)(-16.258999 23.500000 -16.264002)(-19.914000 23.500000 -11.501000)(-37.290001 23.500000 -7.612000)(-19.914000 23.500000 -11.501000)(-33.599998 23.500000 -6.624000)(-37.290001 23.500000 -7.612000)(-41.095997 23.500000 -7.279100)(-37.290001 23.500000 -7.612000)(-37.290001 -28.600000 -7.612000)(-22.995001 23.500000 -0.001002)(-27.291000 23.500000 2.387000)(-28.279999 23.500000 -1.303000)(-28.279999 23.500000 -1.303000)(-27.291000 23.500000 2.387000)(-27.291000 -28.600000 2.387000)(-22.211000 23.500000 -5.954000)(-22.995001 23.500000 -0.001002)(-28.279999 23.500000 -1.303000)(-11.495000 23.500000 19.918001)(-8.886140 23.446400 20.965601)(-39.342003 23.500000 19.022999)(-39.342003 23.500000 19.022999)(-16.258999 23.500000 16.263000)(-11.495000 23.500000 19.918001)(-32.297501 23.500000 12.523700)(-31.939999 23.500000 12.356899)(-39.342003 23.500000 19.022999)(-39.342003 23.500000 19.022999)(-31.939999 23.500000 12.356899)(-16.258999 23.500000 16.263000)(-19.914000 23.500000 11.499000)(-16.258999 23.500000 16.263000)(-31.939999 23.500000 12.356899)(-31.939999 -28.600000 12.356000)(-31.939999 23.500000 12.356899)(-32.297501 23.500000 12.523700)(-33.620300 23.500000 13.140400)(-32.297501 23.500000 12.523700)(-39.342003 23.500000 19.022999)(-29.238001 23.500000 9.655000)(-31.939999 23.500000 12.356899)(-31.939999 -28.600000 12.356000)(-22.995001 23.500000 -0.001002)(-22.211000 23.500000 5.952000)(-27.291000 23.500000 2.387000)(-39.342003 23.500000 19.022999)(-35.402000 23.500000 13.971000)(-33.620300 23.500000 13.140400)(-27.291000 -28.600000 2.387000)(-28.279999 -28.600000 -1.303000)(-28.279999 23.500000 -1.303000)(-35.402000 -28.600000 13.971000)(-31.939999 -28.600000 12.356000)(-32.297501 23.500000 12.523700)(-30.471001 23.500000 -4.432100)(-28.279999 23.500000 -1.303000)(-28.279999 -28.600000 -1.303000)(-30.471001 -28.600000 -4.433000)(-33.599998 23.500000 -6.624000)(-30.471001 23.500000 -4.432100)(-28.279999 -28.600000 -1.303000)(-30.471001 -28.600000 -4.433000)(-30.471001 23.500000 -4.432100)(-29.238001 23.500000 9.655000)(-31.939999 -28.600000 12.356000)(-29.238001 -28.600000 9.655000)(-35.402000 -28.600000 13.971000)(-32.297501 23.500000 12.523700)(-33.620300 23.500000 13.140400)(-16.258999 23.500000 -16.264002)(-37.290001 23.500000 -7.612000)(-42.176998 23.500000 -11.871000)(-50.349400 36.004101 -5.983250)(-52.723400 36.004200 -1.549210)(-47.474602 43.000000 -4.120130)(-46.664497 36.004101 -9.406780)(-50.349400 36.004101 -5.983250)(-47.474602 43.000000 -4.120130)(18.049999 36.004200 13.066100)(21.000999 36.004200 7.452800)(14.648800 43.000000 6.168960)(14.648800 43.000000 6.168960)(21.000999 36.004200 7.452800)(16.359299 43.000000 0.719893)(14.648800 43.000000 6.168960)(16.359299 43.000000 0.719893)(1.416290 43.000000 -20.555399)(19.923000 23.500000 11.499000)(21.000999 36.004200 7.452800)(18.049999 36.004200 13.066100)(16.268000 23.500000 16.263000)(19.923000 23.500000 11.499000)(18.049999 36.004200 13.066100)(16.359299 43.000000 0.719893)(16.178200 43.000000 -5.310480)(1.416290 43.000000 -20.555399)(11.370100 43.000000 10.582300)(18.049999 36.004200 13.066100)(14.648800 43.000000 6.168960)(16.178200 43.000000 -5.310480)(16.359299 43.000000 0.719893)(22.250000 36.004200 1.235620)(-16.258999 23.500000 -16.264002)(-42.176998 23.500000 -11.871000)(-11.495000 23.500000 -19.920000)(11.505000 23.500000 -19.920000)(10.370700 36.004200 -19.722300)(15.507100 36.004200 -16.003401)(16.268000 23.500000 -16.264002)(11.505000 23.500000 -19.920000)(15.507100 36.004200 -16.003401)(19.923000 23.500000 -11.501000)(15.507100 36.004200 -16.003401)(19.387400 36.004200 -10.987500)(15.507100 36.004200 -16.003401)(19.923000 23.500000 -11.501000)(16.268000 23.500000 -16.264002)(9.239130 43.000000 -17.051300)(19.387400 36.004200 -10.987500)(15.507100 36.004200 -16.003401)(15.507100 36.004200 -16.003401)(10.370700 36.004200 -19.722300)(9.239130 43.000000 -17.051300)(5.958000 23.500000 -22.216999)(1.225000 23.500000 -22.685001)(1.290000 36.000000 -21.999001)(1.225000 23.500000 -22.685001)(-11.495000 23.500000 -19.920000)(1.290000 36.000000 -21.999001)(5.958000 23.500000 -22.216999)(1.290000 36.000000 -21.999001)(4.347000 36.000000 -21.604000)(5.958000 23.500000 -22.216999)(4.347000 36.000000 -21.604000)(10.370700 36.004200 -19.722300)(10.370700 36.004200 -19.722300)(4.347000 36.000000 -21.604000)(9.239130 43.000000 -17.051300)(-42.176998 23.500000 -11.871000)(1.290000 36.000000 -21.999001)(-11.495000 23.500000 -19.920000)(11.505000 23.500000 -19.920000)(5.958000 23.500000 -22.216999)(10.370700 36.004200 -19.722300)(19.387400 36.004200 -10.987500)(22.221001 23.500000 -5.954000)(19.923000 23.500000 -11.501000)(4.347000 36.000000 -21.604000)(1.290000 36.000000 -21.999001)(9.239130 43.000000 -17.051300)(-39.768902 42.954697 -8.889971)(-47.474602 43.000000 -4.120130)(-48.501301 43.000000 0.921354)(-47.474602 43.000000 -4.120130)(-53.528301 36.004200 3.416080)(-48.501301 43.000000 0.921354)(-39.768902 42.954697 -8.889971)(-46.664497 36.004101 -9.406780)(-47.474602 43.000000 -4.120130)(5.110090 36.004303 21.686100)(-40.278698 36.004200 18.435101)(5.146010 23.500000 22.125999)(-8.886140 23.446400 20.965601)(5.146010 23.500000 22.125999)(-40.278698 36.004200 18.435101)(5.146010 23.500000 22.125999)(8.120980 36.004200 20.747799)(5.110090 36.004303 21.686100)(8.120980 36.004200 20.747799)(13.637600 36.004200 17.621000)(6.923990 43.000000 13.532200)(13.637600 36.004200 17.621000)(8.120980 36.004200 20.747799)(11.505000 23.500000 19.918001)(8.120980 36.004200 20.747799)(5.146010 23.500000 22.125999)(11.505000 23.500000 19.918001)(8.120980 36.004200 20.747799)(6.923990 43.000000 13.532200)(4.465490 43.000000 14.301001)(4.465490 43.000000 14.301001)(1.416290 43.000000 -20.555399)(-39.768902 42.954697 -8.889971)(1.416290 43.000000 -20.555399)(4.465490 43.000000 14.301001)(6.923990 43.000000 13.532200)(-39.768902 42.954697 -8.889971)(1.416290 43.000000 -20.555399)(1.290000 36.000000 -21.999001)(1.416290 43.000000 -20.555399)(9.239130 43.000000 -17.051300)(1.290000 36.000000 -21.999001)(6.923990 43.000000 13.532200)(11.370100 43.000000 10.582300)(1.416290 43.000000 -20.555399)(-42.068001 36.000000 -11.448400)(-39.768902 42.954697 -8.889971)(1.290000 36.000000 -21.999001)(-39.768902 42.954697 -8.889971)(-42.068001 36.000000 -11.448400)(-46.664497 36.004101 -9.406780)(1.416290 43.000000 -20.555399)(13.875600 43.000000 -11.408300)(9.239130 43.000000 -17.051300)(6.923990 43.000000 13.532200)(13.637600 36.004200 17.621000)(11.370100 43.000000 10.582300)(-42.068001 36.000000 -11.448400)(1.290000 36.000000 -21.999001)(-42.176998 23.500000 -11.871000)(22.221001 23.500000 -5.954000)(19.387400 36.004200 -10.987500)(21.697899 36.004200 -5.081610)(16.178200 43.000000 -5.310480)(22.250000 36.004200 1.235620)(21.697899 36.004200 -5.081610)(23.004999 23.500000 -0.001006)(21.697899 36.004200 -5.081610)(22.250000 36.004200 1.235620)(21.697899 36.004200 -5.081610)(23.004999 23.500000 -0.001006)(22.221001 23.500000 -5.954000)(11.505000 23.500000 19.918001)(16.268000 23.500000 16.263000)(13.637600 36.004200 17.621000)(-46.904999 23.500000 -9.771000)(-42.176998 23.500000 -11.871000)(-41.095997 23.500000 -7.279100)(-42.176998 23.500000 -11.871000)(-46.904999 23.500000 -9.771000)(-46.664497 36.004101 -9.406780)(-46.904999 23.500000 -9.771000)(-50.349400 36.004101 -5.983250)(-46.664497 36.004101 -9.406780)(16.268000 23.500000 16.263000)(18.049999 36.004200 13.066100)(13.637600 36.004200 17.621000)(19.923000 23.500000 11.499000)(22.221001 23.500000 5.952000)(21.000999 36.004200 7.452800)(22.250000 36.004200 1.235620)(21.000999 36.004200 7.452800)(22.221001 23.500000 5.952000)(-52.723400 36.004200 -1.549210)(-50.349400 36.004101 -5.983250)(-50.695000 23.500000 -6.250000)(-41.095997 -28.600000 -7.280000)(-28.279999 -28.600000 -1.303000)(-27.291000 -28.600000 2.387000)(-41.095997 -28.600000 -7.280000)(-27.291000 -28.600000 2.387000)(-27.624001 -28.600000 6.193000)(-41.095997 -28.600000 -7.280000)(-27.624001 -28.600000 6.193000)(-29.238001 -28.600000 9.655000)(-29.238001 -28.600000 9.655000)(-27.624001 -28.600000 6.193000)(-27.624001 23.500000 6.193000)(-27.624001 -28.600000 6.193000)(-27.291000 23.500000 2.387000)(-27.624001 23.500000 6.193000)(-46.904999 23.500000 -9.771000)(-50.695000 23.500000 -6.250000)(-50.349400 36.004101 -5.983250)(-29.238001 -28.600000 9.655000)(-27.624001 23.500000 6.193000)(-29.238001 23.500000 9.655000)(-19.914000 23.500000 11.499000)(-29.238001 23.500000 9.655000)(-27.624001 23.500000 6.193000)(-22.211000 23.500000 5.952000)(-19.914000 23.500000 11.499000)(-27.624001 23.500000 6.193000)(5.110090 36.004303 21.686100)(4.465490 43.000000 14.301001)(-40.278698 36.004200 18.435101)(-47.622501 43.000000 5.394220)(-45.258400 43.000000 8.842091)(-39.768902 42.954697 -8.889971)(-50.606998 23.500000 13.055000)(-46.784000 23.500000 16.542000)(-46.546700 36.004200 16.175200)(16.178200 43.000000 -5.310480)(21.697899 36.004200 -5.081610)(13.875600 43.000000 -11.408300)(-53.137001 23.500000 -1.689000)(-46.980999 23.500000 -3.242930)(-47.260002 23.500000 -2.964000)(4.465490 43.000000 14.301001)(-39.948898 43.000000 11.217500)(-40.278698 36.004200 18.435101)(-44.557999 -28.600000 -5.665000)(-46.980999 23.500000 -3.242930)(-45.638199 23.500000 -4.585250)(-48.501301 43.000000 0.921354)(-47.622501 43.000000 5.394220)(-39.768902 42.954697 -8.889971)(-41.095997 23.500000 -7.279100)(-50.695000 23.500000 -6.250000)(-46.904999 23.500000 -9.771000)(13.875600 43.000000 -11.408300)(1.416290 43.000000 -20.555399)(16.178200 43.000000 -5.310480)(-42.036999 23.500000 18.598000)(-37.828598 23.500000 16.081699)(-39.342003 23.500000 19.022999)(-50.606998 23.500000 13.055000)(-49.848198 23.500000 9.538490)(-46.606400 23.500000 10.296400)(-48.873997 23.500000 0.499000)(-48.707298 23.500000 0.141374)(-48.873997 -28.600000 0.499005)(-35.402000 -28.600000 13.971000)(-33.620300 23.500000 13.140400)(-35.402000 23.500000 13.971000)(-45.638199 23.500000 -4.585250)(-46.980999 23.500000 -3.242930)(-53.137001 23.500000 -1.689000)(-48.746799 23.500000 6.021980)(-49.206997 23.500000 4.304900)(-49.206997 -28.600000 4.304000)(-48.320099 23.500000 7.613830)(-48.746799 23.500000 6.021980)(-49.206997 -28.600000 4.304000)(-39.768902 42.954697 -8.889971)(-39.948898 43.000000 11.217500)(4.465490 43.000000 14.301001)(-30.471001 -28.600000 -4.433000)(-33.599998 -28.600000 -6.624000)(-33.599998 23.500000 -6.624000)(5.110090 36.004303 21.686100)(8.120980 36.004200 20.747799)(4.465490 43.000000 14.301001)(-37.290001 23.500000 -7.612000)(-41.095997 23.500000 -7.279100)(-42.176998 23.500000 -11.871000)(-37.828598 23.500000 16.081699)(-42.036999 23.500000 18.598000)(-37.368500 23.500000 14.143100)(22.221001 23.500000 5.952000)(23.004999 23.500000 -0.001006)(22.250000 36.004200 1.235620)(-41.095997 -28.600000 -7.280000)(-31.939999 -28.600000 12.356000)(-35.402000 -28.600000 13.971000)(13.637600 36.004200 17.621000)(18.049999 36.004200 13.066100)(11.370100 43.000000 10.582300)(-52.723400 36.004200 -1.549210)(-53.528301 36.004200 3.416080)(-47.474602 43.000000 -4.120130)(-53.528301 36.004200 3.416080)(-52.723400 36.004200 -1.549210)(-53.137001 23.500000 -1.689000)(-46.784000 23.500000 16.542000)(-42.897999 23.500000 13.315000)(-42.850201 23.500000 13.327800)(13.875600 43.000000 -11.408300)(19.387400 36.004200 -10.987500)(9.239130 43.000000 -17.051300)(-50.263302 36.004101 12.785700)(-53.090000 23.500000 8.517000)(-50.606998 23.500000 13.055000)(-31.939999 23.500000 12.356899)(-29.238001 23.500000 9.655000)(-19.914000 23.500000 11.499000)(-22.211000 23.500000 5.952000)(-27.624001 23.500000 6.193000)(-27.291000 23.500000 2.387000)(-52.677700 36.004101 8.373360)(-48.501301 43.000000 0.921354)(-53.528301 36.004200 3.416080)(-27.291000 23.500000 2.387000)(-27.624001 -28.600000 6.193000)(-27.291000 -28.600000 2.387000)(22.250000 36.004200 1.235620)(16.359299 43.000000 0.719893)(21.000999 36.004200 7.452800)(-46.253300 23.500000 10.800800)(-48.218002 -28.600000 7.994000)(-46.027000 -28.600000 11.124000)(-42.176998 23.500000 -11.871000)(-46.664497 36.004101 -9.406780)(-42.068001 36.000000 -11.448400)(-39.342003 23.500000 19.022999)(-8.886140 23.446400 20.965601)(-40.278698 36.004200 18.435101)(19.387400 36.004200 -10.987500)(13.875600 43.000000 -11.408300)(21.697899 36.004200 -5.081610)(-41.095997 -28.600000 -7.280000)(-30.471001 -28.600000 -4.433000)(-28.279999 -28.600000 -1.303000)(-52.723400 36.004200 -1.549210)(-50.695000 23.500000 -6.250000)(-53.137001 23.500000 -1.689000)(11.370100 43.000000 10.582300)(14.648800 43.000000 6.168960)(1.416290 43.000000 -20.555399)(-48.320099 23.500000 7.613830)(-49.206997 -28.600000 4.304000)(-48.218002 -28.600000 7.994000)(-42.036999 23.500000 18.598000)(-39.208000 23.500000 14.304000)(-37.368500 23.500000 14.143100)(-31.939999 -28.600000 12.356000)(-41.095997 -28.600000 -7.280000)(-29.238001 -28.600000 9.655000)(-48.320099 23.500000 7.613830)(-49.848198 23.500000 9.538490)(-48.746799 23.500000 6.021980)(-53.528301 36.004200 3.416080)(-53.137001 23.500000 -1.689000)(-53.965000 23.500000 3.418000)(-46.027000 -28.600000 11.124000)(-43.221100 23.500000 13.088700)(-46.027000 23.500000 11.124000)(-41.095997 -28.600000 -7.280000)(-44.557999 -28.600000 -5.665000)(-44.200500 23.500000 -5.831780)(-41.095997 -28.600000 -7.280000)(-47.260002 -28.600000 -2.964000)(-44.557999 -28.600000 -5.665000)(-45.258400 43.000000 8.842091)(-46.546700 36.004200 16.175200)(-41.905602 43.000000 10.845201)(-22.211000 23.500000 -5.954000)(-28.279999 23.500000 -1.303000)(-30.471001 23.500000 -4.432100)(-48.873997 23.500000 0.499000)(-48.920700 23.500000 1.032190)(-49.801598 23.500000 -0.583624)))
           )
           )))
    (send glvertices :calc-normals)
    (send self :assoc glvertices)
    glvertices)
  (:qhull-faceset ()
   ;; qhull 3036 -> 30 faces
   (instance faceset :init :faces (list
    (instance face :init :vertices (list (float-vector -41.931801 36.004201 18.174101) (float-vector 5.110090 36.004301 21.686099) (float-vector 0.005007 -23.600001 22.999000)))
    (instance face :init :vertices (list (float-vector 19.235000 -21.707000 -27.501000) (float-vector 0.005003 -28.999999 -27.501000) (float-vector 23.004999 -23.600001 -0.001002)))
    (instance face :init :vertices (list (float-vector 5.110090 36.004301 21.686099) (float-vector 16.268000 -23.600001 16.263001) (float-vector 0.005007 -23.600001 22.999000)))
    (instance face :init :vertices (list (float-vector -50.607000 23.499999 13.055000) (float-vector -41.931801 36.004201 18.174101) (float-vector 0.005007 -23.600001 22.999000) (float-vector -42.897999 -28.600000 13.315000)))
    (instance face :init :vertices (list (float-vector -53.964999 23.499999 3.418000) (float-vector -50.607000 23.499999 13.055000) (float-vector -42.897999 -28.600000 13.315000) (float-vector -49.206998 -28.600000 4.304000)))
    (instance face :init :vertices (list (float-vector 27.120000 -10.284000 -27.501000) (float-vector 19.235000 -21.707000 -27.501000) (float-vector 23.004999 -23.600001 -0.001002)))
    (instance face :init :vertices (list (float-vector 27.120000 -10.284000 -27.501000) (float-vector 23.004999 -23.600001 -0.001002) (float-vector 22.250000 36.004201 1.235620) (float-vector 29.005000 -0.000002 -27.501000)))
    (instance face :init :vertices (list (float-vector 0.005007 -23.600001 22.999000) (float-vector 16.268000 -23.600001 16.263001) (float-vector 23.004999 -23.600001 -0.001002) (float-vector 0.005003 -28.999999 -27.501000) (float-vector -44.558000 -28.600000 -5.665000) (float-vector -49.206998 -28.600000 4.304000) (float-vector -42.897999 -28.600000 13.315000)))
    (instance face :init :vertices (list (float-vector 23.871001 16.473999 -27.501000) (float-vector 29.005000 -0.000002 -27.501000) (float-vector 22.250000 36.004201 1.235620) (float-vector 16.359299 43.000001 0.719893) (float-vector 13.875600 43.000001 -11.408300)))
    (instance face :init :vertices (list (float-vector -50.694998 23.499999 -6.250000) (float-vector -52.723400 36.004201 -1.549210) (float-vector -53.964999 23.499999 3.418000) (float-vector -49.206998 -28.600000 4.304000) (float-vector -44.558000 -28.600000 -5.665000)))
    (instance face :init :vertices (list (float-vector -41.931801 36.004201 18.174101) (float-vector -41.905601 43.000001 10.845200) (float-vector 11.370100 43.000001 10.582300) (float-vector 5.110090 36.004301 21.686099)))
    (instance face :init :vertices (list (float-vector 18.050000 36.004201 13.066100) (float-vector 16.268000 -23.600001 16.263001) (float-vector 5.110090 36.004301 21.686099)))
    (instance face :init :vertices (list (float-vector 18.050000 36.004201 13.066100) (float-vector 5.110090 36.004301 21.686099) (float-vector 11.370100 43.000001 10.582300)))
    (instance face :init :vertices (list (float-vector 16.268000 -23.600001 16.263001) (float-vector 18.050000 36.004201 13.066100) (float-vector 22.250000 36.004201 1.235620) (float-vector 23.004999 -23.600001 -0.001002)))
    (instance face :init :vertices (list (float-vector 18.050000 36.004201 13.066100) (float-vector 11.370100 43.000001 10.582300) (float-vector 16.359299 43.000001 0.719893) (float-vector 22.250000 36.004201 1.235620)))
    (instance face :init :vertices (list (float-vector -13.472000 -25.677999 -27.501000) (float-vector -44.558000 -28.600000 -5.665000) (float-vector 0.005003 -28.999999 -27.501000)))
    (instance face :init :vertices (list (float-vector -44.558000 -28.600000 -5.665000) (float-vector -13.472000 -25.677999 -27.501000) (float-vector -23.862001 -16.473999 -27.501000)))
    (instance face :init :vertices (list (float-vector 27.120000 -10.284000 -27.501000) (float-vector 29.005000 -0.000002 -27.501000) (float-vector 23.871001 16.473999 -27.501000) (float-vector 6.945000 28.156999 -27.501000) (float-vector -13.472000 25.677999 -27.501000) (float-vector -23.862001 16.473999 -27.501000) (float-vector -28.783999 -3.496000 -27.501000) (float-vector -23.862001 -16.473999 -27.501000) (float-vector -13.472000 -25.677999 -27.501000) (float-vector 0.005003 -28.999999 -27.501000) (float-vector 19.235000 -21.707000 -27.501000)))
    (instance face :init :vertices (list (float-vector -23.862001 -16.473999 -27.501000) (float-vector -28.783999 -3.496000 -27.501000) (float-vector -50.694998 23.499999 -6.250000) (float-vector -44.558000 -28.600000 -5.665000)))
    (instance face :init :vertices (list (float-vector 1.416290 43.000001 -20.555399) (float-vector -13.472000 25.677999 -27.501000) (float-vector 6.945000 28.156999 -27.501000)))
    (instance face :init :vertices (list (float-vector 11.370100 43.000001 10.582300) (float-vector -41.905601 43.000001 10.845200) (float-vector -47.474600 43.000001 -4.120130) (float-vector 1.416290 43.000001 -20.555399) (float-vector 13.875600 43.000001 -11.408300) (float-vector 16.359299 43.000001 0.719893)))
    (instance face :init :vertices (list (float-vector 1.416290 43.000001 -20.555399) (float-vector 6.945000 28.156999 -27.501000) (float-vector 23.871001 16.473999 -27.501000) (float-vector 13.875600 43.000001 -11.408300)))
    (instance face :init :vertices (list (float-vector -50.607000 23.499999 13.055000) (float-vector -52.677698 36.004100 8.373360) (float-vector -41.931801 36.004201 18.174101)))
    (instance face :init :vertices (list (float-vector -52.723400 36.004201 -1.549210) (float-vector -52.677698 36.004100 8.373360) (float-vector -53.964999 23.499999 3.418000)))
    (instance face :init :vertices (list (float-vector -52.677698 36.004100 8.373360) (float-vector -50.607000 23.499999 13.055000) (float-vector -53.964999 23.499999 3.418000)))
    (instance face :init :vertices (list (float-vector -52.677698 36.004100 8.373360) (float-vector -41.905601 43.000001 10.845200) (float-vector -41.931801 36.004201 18.174101)))
    (instance face :init :vertices (list (float-vector -52.677698 36.004100 8.373360) (float-vector -52.723400 36.004201 -1.549210) (float-vector -47.474600 43.000001 -4.120130) (float-vector -41.905601 43.000001 10.845200)))
    (instance face :init :vertices (list (float-vector -46.664499 36.004100 -9.406780) (float-vector -23.862001 16.473999 -27.501000) (float-vector -13.472000 25.677999 -27.501000) (float-vector 1.416290 43.000001 -20.555399) (float-vector -47.474600 43.000001 -4.120130)))
    (instance face :init :vertices (list (float-vector -46.664499 36.004100 -9.406780) (float-vector -50.694998 23.499999 -6.250000) (float-vector -28.783999 -3.496000 -27.501000) (float-vector -23.862001 16.473999 -27.501000)))
    (instance face :init :vertices (list (float-vector -46.664499 36.004100 -9.406780) (float-vector -47.474600 43.000001 -4.120130) (float-vector -52.723400 36.004201 -1.549210) (float-vector -50.694998 23.499999 -6.250000)))
    ))
   )
  )

(defclass HiroNX_g1_3_geom0
  :super collada-body
  :slots ())
(defmethod HiroNX_g1_3_geom0
  (:init (&key (name))
         (replace-object self (send self :qhull-faceset))
         (if name (send self :name name))
         (send self :def-gl-vertices)
         self)
  (:def-gl-vertices ()
    (setq glvertices
       (instance gl::glvertices :init
          (list
          (list
           (list :type :triangles)
           (list :material (list
             (list :color (float-vector 0.1 0.1 0.1))
             (list :ambient (float-vector 0.200000 0.200000 0.200000 1.000000))
             (list :diffuse (float-vector 0.900000 0.900000 0.900000 1.000000))
           ))
           (list :indices #i( 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100 101 102 103 104 105 106 107 108 109 110 111 112 113 114 115 116 117 118 119 120 121 122 123 124 125 126 127 128 129 130 131 132 133 134 135 136 137 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 256 257 258 259 260 261 262 263 264 265 266 267 268 269 270 271 272 273 274 275 276 277 278 279 280 281 282 283 284 285 286 287 288 289 290 291 292 293 294 295 296 297 298 299 300 301 302 303 304 305 306 307 308 309 310 311 312 313 314 315 316 317 318 319 320 321 322 323 324 325 326 327 328 329 330 331 332 333 334 335 336 337 338 339 340 341 342 343 344 345 346 347 348 349 350 351 352 353 354 355 356 357 358 359 360 361 362 363 364 365 366 367 368 369 370 371 372 373 374 375 376 377 378 379 380 381 382 383 384 385 386 387 388 389 390 391 392 393 394 395 396 397 398 399 400 401 402 403 404 405 406 407 408 409 410 411 412 413 414 415 416 417 418 419 420 421 422 423 424 425 426 427 428 429 430 431 432 433 434 435 436 437 438 439 440 441 442 443 444 445 446 447 448 449 450 451 452 453 454 455 456 457 458 459 460 461 462 463 464 465 466 467 468 469 470 471 472 473 474 475 476 477 478 479 480 481 482 483 484 485 486 487 488 489 490 491 492 493 494 495 496 497 498 499 500 501 502 503 504 505 506 507 508 509 510 511 512 513 514 515 516 517 518 519 520 521 522 523 524 525 526 527 528 529 530 531 532 533 534 535 536 537 538 539 540 541 542 543 544 545 546 547 548 549 550 551 552 553 554 555 556 557 558 559 560 561 562 563 564 565 566 567 568 569 570 571 572 573 574 575 576 577 578 579 580 581 582 583 584 585 586 587 588 589 590 591 592 593 594 595 596 597 598 599 600 601 602 603 604 605 606 607 608 609 610 611 612 613 614 615 616 617 618 619 620 621 622 623 624 625 626 627 628 629 630 631 632 633 634 635 636 637 638 639 640 641 642 643 644 645 646 647 648 649 650 651 652 653 654 655 656 657 658 659 660 661 662 663 664 665 666 667 668 669 670 671 672 673 674 675 676 677 678 679 680 681 682 683 684 685 686 687 688 689 690 691 692 693 694 695 696 697 698 699 700 701 702 703 704 705 706 707 708 709 710 711 712 713 714 715 716 717 718 719 720 721 722 723 724 725 726 727 728 729 730 731 732 733 734 735 736 737 738 739 740 741 742 743 744 745 746 747 748 749 750 751 752 753 754 755 756 757 758 759 760 761 762 763 764 765 766 767 768 769 770 771 772 773 774 775 776 777 778 779 780 781 782 783 784 785 786 787 788 789 790 791 792 793 794 795 796 797 798 799 800 801 802 803 804 805 806 807 808 809 810 811 812 813 814 815 816 817 818 819 820 821 822 823 824 825 826 827 828 829 830 831 832 833 834 835 836 837 838 839 840 841 842 843 844 845 846 847 848 849 850 851 852 853 854 855 856 857 858 859 860 861 862 863 864 865 866 867 868 869 870 871 872 873 874 875 876 877 878 879 880 881 882 883 884 885 886 887 888 889 890 891 892 893 894 895 896 897 898 899 900 901 902 903 904 905 906 907 908 909 910 911 912 913 914 915 916 917 918 919 920 921 922 923 924 925 926 927 928 929 930 931 932 933 934 935 936 937 938 939 940 941 942 943 944 945 946 947 948 949 950 951 952 953 954 955 956 957 958 959 960 961 962 963 964 965 966 967 968 969 970 971 972 973 974 975 976 977 978 979 980 981 982 983 984 985 986 987 988 989 990 991 992 993 994 995 996 997 998 999 1000 1001 1002 1003 1004 1005 1006 1007 1008 1009 1010 1011 1012 1013 1014 1015 1016 1017 1018 1019 1020 1021 1022 1023 1024 1025 1026 1027 1028 1029 1030 1031 1032 1033 1034 1035 1036 1037 1038 1039 1040 1041 1042 1043 1044 1045 1046 1047 1048 1049 1050 1051 1052 1053 1054 1055 1056 1057 1058 1059 1060 1061 1062 1063 1064 1065 1066 1067 1068 1069 1070 1071 1072 1073 1074 1075 1076 1077 1078 1079 1080 1081 1082 1083 1084 1085 1086 1087 1088 1089 1090 1091 1092 1093 1094 1095 1096 1097 1098 1099 1100 1101 1102 1103 1104 1105 1106 1107 1108 1109 1110 1111 1112 1113 1114 1115 1116 1117 1118 1119 1120 1121 1122 1123 1124 1125 1126 1127 1128 1129 1130 1131 1132 1133 1134 1135 1136 1137 1138 1139 1140 1141 1142 1143 1144 1145 1146 1147 1148 1149 1150 1151 1152 1153 1154 1155 1156 1157 1158 1159 1160 1161 1162 1163 1164 1165 1166 1167 1168 1169 1170 1171 1172 1173 1174 1175 1176 1177 1178 1179 1180 1181 1182 1183 1184 1185 1186 1187 1188 1189 1190 1191 1192 1193 1194 1195 1196 1197 1198 1199 1200 1201 1202 1203 1204 1205 1206 1207 1208 1209 1210 1211 1212 1213 1214 1215 1216 1217 1218 1219 1220 1221 1222 1223 1224 1225 1226 1227 1228 1229 1230 1231 1232 1233 1234 1235 1236 1237 1238 1239 1240 1241 1242 1243 1244 1245 1246 1247 1248 1249 1250 1251 1252 1253 1254 1255 1256 1257 1258 1259 1260 1261 1262 1263 1264 1265 1266 1267 1268 1269 1270 1271 1272 1273 1274 1275 1276 1277 1278 1279 1280 1281 1282 1283 1284 1285 1286 1287 1288 1289 1290 1291 1292 1293 1294 1295 1296 1297 1298 1299 1300 1301 1302 1303 1304 1305 1306 1307 1308 1309 1310 1311 1312 1313 1314 1315 1316 1317 1318 1319 1320 1321 1322 1323 1324 1325 1326 1327 1328 1329 1330 1331 1332 1333 1334 1335 1336 1337 1338 1339 1340 1341 1342 1343 1344 1345 1346 1347 1348 1349 1350 1351 1352 1353 1354 1355 1356 1357 1358 1359 1360 1361 1362 1363 1364 1365 1366 1367 1368 1369 1370 1371 1372 1373 1374 1375 1376 1377 1378 1379 1380 1381 1382 1383 1384 1385 1386 1387 1388 1389 1390 1391 1392 1393 1394 1395 1396 1397 1398 1399 1400 1401 1402 1403 1404 1405 1406 1407 1408 1409 1410 1411 1412 1413 1414 1415 1416 1417 1418 1419 1420 1421 1422 1423 1424 1425 1426 1427 1428 1429 1430 1431 1432 1433 1434 1435 1436 1437 1438 1439 1440 1441 1442 1443 1444 1445 1446 1447 1448 1449 1450 1451 1452 1453 1454 1455 1456 1457 1458 1459 1460 1461 1462 1463 1464 1465 1466 1467 1468 1469 1470 1471 1472 1473 1474 1475 1476 1477 1478 1479 1480 1481 1482 1483 1484 1485 1486 1487 1488 1489 1490 1491 1492 1493 1494 1495 1496 1497 1498 1499 1500 1501 1502 1503 1504 1505 1506 1507 1508 1509 1510 1511 1512 1513 1514 1515 1516 1517 1518 1519 1520 1521 1522 1523 1524 1525 1526 1527 1528 1529 1530 1531 1532 1533 1534 1535 1536 1537 1538 1539 1540 1541 1542 1543 1544 1545 1546 1547 1548 1549 1550 1551 1552 1553 1554 1555 1556 1557 1558 1559 1560 1561 1562 1563 1564 1565 1566 1567 1568 1569 1570 1571 1572 1573 1574 1575 1576 1577 1578 1579 1580 1581 1582 1583 1584 1585 1586 1587 1588 1589 1590 1591 1592 1593 1594 1595 1596 1597 1598 1599 1600 1601 1602 1603 1604 1605 1606 1607 1608 1609 1610 1611 1612 1613 1614 1615 1616 1617 1618 1619 1620 1621 1622 1623 1624 1625 1626 1627 1628 1629 1630 1631 1632 1633 1634 1635 1636 1637 1638 1639 1640 1641 1642 1643 1644 1645 1646 1647 1648 1649 1650 1651 1652 1653 1654 1655 1656 1657 1658 1659 1660 1661 1662 1663 1664 1665 1666 1667 1668 1669 1670 1671 1672 1673 1674 1675 1676 1677 1678 1679 1680 1681 1682 1683 1684 1685 1686 1687 1688 1689 1690 1691 1692 1693 1694 1695 1696 1697 1698 1699 1700 1701 1702 1703 1704 1705 1706 1707 1708 1709 1710 1711 1712 1713 1714 1715 1716 1717 1718 1719 1720 1721 1722 1723 1724 1725 1726 1727 1728 1729 1730 1731 1732 1733 1734 1735 1736 1737 1738 1739 1740 1741 1742 1743 1744 1745 1746 1747 1748 1749 1750 1751 1752 1753 1754 1755 1756 1757 1758 1759 1760 1761 1762 1763 1764 1765 1766 1767 1768 1769 1770 1771 1772 1773 1774 1775 1776 1777 1778 1779 1780 1781 1782 1783 1784 1785 1786 1787 1788 1789 1790 1791 1792 1793 1794 1795 1796 1797 1798 1799 1800 1801 1802 1803 1804 1805 1806 1807 1808 1809 1810 1811 1812 1813 1814 1815 1816 1817 1818 1819 1820 1821 1822 1823 1824 1825 1826 1827 1828 1829 1830 1831 1832 1833 1834 1835 1836 1837 1838 1839 1840 1841 1842 1843 1844 1845 1846 1847 1848 1849 1850 1851 1852 1853 1854 1855 1856 1857 1858 1859 1860 1861 1862 1863 1864 1865 1866 1867 1868 1869 1870 1871 1872 1873 1874 1875 1876 1877 1878 1879 1880 1881 1882 1883 1884 1885 1886 1887 1888 1889 1890 1891 1892 1893 1894 1895 1896 1897 1898 1899 1900 1901 1902 1903 1904 1905 1906 1907 1908 1909 1910 1911 1912 1913 1914 1915 1916 1917 1918 1919 1920 1921 1922 1923 1924 1925 1926 1927 1928 1929 1930 1931 1932 1933 1934 1935 1936 1937 1938 1939 1940 1941 1942 1943 1944 1945 1946 1947 1948 1949 1950 1951 1952 1953 1954 1955 1956 1957 1958 1959 1960 1961 1962 1963 1964 1965 1966 1967 1968 1969 1970 1971 1972 1973 1974 1975 1976 1977 1978 1979 1980 1981 1982 1983 1984 1985 1986 1987 1988 1989 1990 1991 1992 1993 1994 1995 1996 1997 1998 1999 2000 2001 2002 2003 2004 2005 2006 2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019 2020 2021 2022 2023 2024 2025 2026 2027 2028 2029 2030 2031 2032 2033 2034 2035 2036 2037 2038 2039 2040 2041 2042 2043 2044 2045 2046 2047 2048 2049 2050 2051 2052 2053 2054 2055 2056 2057 2058 2059 2060 2061 2062 2063 2064 2065 2066 2067 2068 2069 2070 2071 2072 2073 2074 2075 2076 2077 2078 2079 2080 2081 2082 2083 2084 2085 2086 2087 2088 2089 2090 2091 2092 2093 2094 2095 2096 2097 2098 2099 2100 2101 2102 2103 2104 2105 2106 2107 2108 2109 2110 2111 2112 2113 2114 2115 2116 2117 2118 2119 2120 2121 2122 2123 2124 2125 2126 2127 2128 2129 2130 2131 2132 2133 2134 2135 2136 2137 2138 2139 2140 2141 2142 2143 2144 2145 2146 2147 2148 2149 2150 2151 2152 2153 2154 2155 2156 2157 2158 2159 2160 2161 2162 2163 2164 2165 2166 2167 2168 2169 2170 2171 2172 2173 2174 2175 2176 2177 2178 2179 2180 2181 2182 2183 2184 2185 2186 2187 2188 2189 2190 2191 2192 2193 2194 2195 2196 2197 2198 2199 2200 2201 2202 2203 2204 2205 2206 2207 2208 2209 2210 2211 2212 2213 2214 2215 2216 2217 2218 2219 2220 2221 2222 2223 2224 2225 2226 2227 2228 2229 2230 2231 2232 2233 2234 2235 2236 2237 2238 2239 2240 2241 2242 2243 2244 2245 2246 2247 2248 2249 2250 2251 2252 2253 2254 2255 2256 2257 2258 2259 2260 2261 2262 2263 2264 2265 2266 2267 2268 2269 2270 2271 2272 2273 2274 2275 2276 2277 2278 2279 2280 2281 2282 2283 2284 2285 2286 2287 2288 2289 2290 2291 2292 2293 2294 2295 2296 2297 2298 2299 2300 2301 2302 2303 2304 2305 2306 2307 2308 2309 2310 2311 2312 2313 2314 2315 2316 2317 2318 2319 2320 2321 2322 2323 2324 2325 2326 2327 2328 2329 2330 2331 2332 2333 2334 2335 2336 2337 2338 2339 2340 2341 2342 2343 2344 2345 2346 2347 2348 2349 2350 2351 2352 2353 2354 2355 2356 2357 2358 2359 2360 2361 2362 2363 2364 2365 2366 2367 2368 2369 2370 2371 2372 2373 2374 2375 2376 2377 2378 2379 2380 2381 2382 2383 2384 2385 2386 2387 2388 2389 2390 2391 2392 2393 2394 2395 2396 2397 2398 2399 2400 2401 2402 2403 2404 2405 2406 2407 2408 2409 2410 2411 2412 2413 2414 2415 2416 2417 2418 2419 2420 2421 2422 2423 2424 2425 2426 2427 2428 2429 2430 2431 2432 2433 2434 2435 2436 2437 2438 2439 2440 2441 2442 2443 2444 2445 2446 2447 2448 2449 2450 2451 2452 2453 2454 2455 2456 2457 2458 2459 2460 2461 2462 2463 2464 2465 2466 2467 2468 2469 2470 2471 2472 2473 2474 2475 2476 2477 2478 2479 2480 2481 2482 2483 2484 2485 2486 2487 2488 2489 2490 2491 2492 2493 2494 2495 2496 2497 2498 2499 2500 2501 2502 2503 2504 2505 2506 2507 2508 2509 2510 2511 2512 2513 2514 2515 2516 2517 2518 2519 2520 2521 2522 2523 2524 2525 2526 2527 2528 2529 2530 2531 2532 2533 2534 2535 2536 2537 2538 2539 2540 2541 2542 2543 2544 2545 2546 2547 2548 2549 2550 2551 2552 2553 2554 2555 2556 2557 2558 2559 2560 2561 2562 2563 2564 2565 2566 2567 2568 2569 2570 2571 2572 2573 2574 2575 2576 2577 2578 2579 2580 2581 2582 2583 2584 2585 2586 2587 2588 2589 2590 2591 2592 2593 2594 2595 2596 2597 2598 2599 2600 2601 2602 2603 2604 2605 2606 2607 2608 2609 2610 2611 2612 2613 2614 2615 2616 2617 2618 2619 2620 2621 2622 2623 2624 2625 2626 2627 2628 2629 2630 2631 2632 2633 2634 2635 2636 2637 2638 2639 2640 2641 2642 2643 2644 2645 2646 2647 2648 2649 2650 2651 2652 2653 2654 2655 2656 2657 2658 2659 2660 2661 2662 2663 2664 2665 2666 2667 2668 2669 2670 2671 2672 2673 2674 2675 2676 2677 2678 2679 2680 2681 2682 2683 2684 2685 2686 2687 2688 2689 2690 2691 2692 2693 2694 2695 2696 2697 2698 2699 2700 2701 2702 2703 2704 2705 2706 2707 2708 2709 2710 2711 2712 2713 2714 2715 2716 2717 2718 2719 2720 2721 2722 2723 2724 2725 2726 2727 2728 2729 2730 2731 2732 2733 2734 2735 2736 2737 2738 2739 2740 2741 2742 2743 2744 2745 2746 2747 2748 2749 2750 2751 2752 2753 2754 2755 2756 2757 2758 2759 2760 2761 2762 2763 2764 2765 2766 2767 2768 2769 2770 2771 2772 2773 2774 2775 2776 2777 2778 2779 2780 2781 2782 2783 2784 2785 2786 2787 2788 2789 2790 2791 2792 2793 2794 2795 2796 2797 2798 2799 2800 2801 2802 2803 2804 2805 2806 2807 2808 2809 2810 2811 2812 2813 2814 2815 2816 2817 2818 2819 2820 2821 2822 2823 2824 2825 2826 2827 2828 2829 2830 2831 2832 2833 2834 2835 2836 2837 2838 2839 2840 2841 2842 2843 2844 2845 2846 2847 2848 2849 2850 2851 2852 2853 2854 2855 2856 2857 2858 2859 2860 2861 2862 2863 2864 2865 2866 2867 2868 2869 2870 2871 2872 2873 2874 2875 2876 2877 2878 2879 2880 2881 2882 2883 2884 2885 2886 2887 2888 2889 2890 2891 2892 2893 2894 2895 2896 2897 2898 2899 2900 2901 2902 2903 2904 2905 2906 2907 2908 2909 2910 2911 2912 2913 2914 2915 2916 2917 2918 2919 2920 2921 2922 2923 2924 2925 2926 2927 2928 2929 2930 2931 2932 2933 2934 2935 2936 2937 2938 2939 2940 2941 2942 2943 2944 2945 2946 2947 2948 2949 2950 2951 2952 2953 2954 2955 2956 2957 2958 2959 2960 2961 2962 2963 2964 2965 2966 2967 2968 2969 2970 2971 2972 2973 2974 2975 2976 2977 2978 2979 2980 2981 2982 2983 2984 2985 2986 2987 2988 2989 2990 2991 2992 2993 2994 2995 2996 2997 2998 2999 3000 3001 3002 3003 3004 3005 3006 3007 3008 3009 3010 3011 3012 3013 3014 3015 3016 3017 3018 3019 3020 3021 3022 3023 3024 3025 3026 3027 3028 3029 3030 3031 3032 3033 3034 3035 3036 3037 3038 3039 3040 3041 3042 3043 3044 3045 3046 3047 3048 3049 3050 3051 3052 3053 3054 3055 3056 3057 3058 3059 3060 3061 3062 3063 3064 3065 3066 3067 3068 3069 3070 3071 3072 3073 3074 3075 3076 3077 3078 3079 3080 3081 3082 3083 3084 3085 3086 3087 3088 3089 3090 3091 3092 3093 3094 3095 3096 3097 3098 3099 3100 3101 3102 3103 3104 3105 3106 3107 3108 3109 3110 3111 3112 3113 3114 3115 3116 3117 3118 3119 3120 3121 3122 3123 3124 3125 3126 3127 3128 3129 3130 3131 3132 3133 3134 3135 3136 3137 3138 3139 3140 3141 3142 3143 3144 3145 3146 3147 3148 3149 3150 3151 3152 3153 3154 3155 3156 3157 3158 3159 3160 3161 3162 3163 3164 3165 3166 3167 3168 3169 3170 3171 3172 3173 3174 3175 3176 3177 3178 3179 3180 3181 3182 3183 3184 3185 3186 3187 3188 3189 3190 3191 3192 3193 3194 3195 3196 3197 3198 3199 3200 3201 3202 3203 3204 3205 3206 3207 3208 3209 3210 3211 3212 3213 3214 3215 3216 3217 3218 3219 3220 3221 3222 3223 3224 3225 3226 3227 3228 3229 3230 3231 3232 3233 3234 3235 3236 3237 3238 3239 3240 3241 3242 3243 3244 3245 3246 3247 3248 3249 3250 3251 3252 3253 3254 3255 3256 3257 3258 3259 3260 3261 3262 3263 3264 3265 3266 3267 3268 3269 3270 3271 3272 3273 3274 3275 3276 3277 3278 3279 3280 3281 3282 3283 3284 3285 3286 3287 3288 3289 3290 3291 3292 3293 3294 3295 3296 3297 3298 3299 3300 3301 3302 3303 3304 3305 3306 3307 3308 3309 3310 3311 3312 3313 3314 3315 3316 3317 3318 3319 3320 3321 3322 3323 3324 3325 3326 3327 3328 3329 3330 3331 3332 3333 3334 3335 3336 3337 3338 3339 3340 3341 3342 3343 3344 3345 3346 3347 3348 3349 3350 3351 3352 3353 3354 3355 3356 3357 3358 3359 3360 3361 3362 3363 3364 3365 3366 3367 3368 3369 3370 3371 3372 3373 3374 3375 3376 3377 3378 3379 3380 3381 3382 3383 3384 3385 3386 3387 3388 3389 3390 3391 3392 3393 3394 3395 3396 3397 3398 3399 3400 3401 3402 3403 3404 3405 3406 3407 3408 3409 3410 3411 3412 3413 3414 3415 3416 3417 3418 3419 3420 3421 3422 3423 3424 3425 3426 3427 3428 3429 3430 3431 3432 3433 3434 3435 3436 3437 3438 3439 3440 3441 3442 3443 3444 3445 3446 3447 3448 3449 3450 3451 3452 3453 3454 3455 3456 3457 3458 3459 3460 3461 3462 3463 3464 3465 3466 3467 3468 3469 3470 3471 3472 3473 3474 3475 3476 3477 3478 3479 3480 3481 3482 3483 3484 3485 3486 3487 3488 3489 3490 3491 3492 3493 3494 3495 3496 3497 3498 3499 3500 3501 3502 3503 3504 3505 3506 3507 3508 3509 3510 3511 3512 3513 3514 3515 3516 3517 3518 3519 3520 3521 3522 3523 3524 3525 3526 3527 3528 3529 3530 3531 3532 3533 3534 3535 3536 3537 3538 3539 3540 3541 3542 3543 3544 3545 3546 3547 3548 3549 3550 3551 3552 3553 3554 3555 3556 3557 3558 3559 3560 3561 3562 3563 3564 3565 3566 3567 3568 3569 3570 3571 3572 3573 3574 3575 3576 3577 3578 3579 3580 3581 3582 3583 3584 3585 3586 3587 3588 3589 3590 3591 3592 3593 3594 3595 3596 3597 3598 3599 3600 3601 3602 3603 3604 3605 3606 3607 3608 3609 3610 3611 3612 3613 3614 3615 3616 3617 3618 3619 3620 3621 3622 3623 3624 3625 3626 3627 3628 3629 3630 3631 3632 3633 3634 3635 3636 3637 3638 3639 3640 3641 3642 3643 3644 3645 3646 3647 3648 3649 3650 3651 3652 3653 3654 3655 3656 3657 3658 3659 3660 3661 3662 3663 3664 3665 3666 3667 3668 3669 3670 3671 3672 3673 3674 3675 3676 3677 3678 3679 3680 3681 3682 3683 3684 3685 3686 3687 3688 3689 3690 3691 3692 3693 3694 3695 3696 3697 3698 3699 3700 3701 3702 3703 3704 3705 3706 3707 3708 3709 3710 3711 3712 3713 3714 3715 3716 3717 3718 3719 3720 3721 3722 3723 3724 3725 3726 3727 3728 3729 3730 3731 3732 3733 3734 3735 3736 3737 3738 3739 3740 3741 3742 3743 3744 3745 3746 3747 3748 3749 3750 3751 3752 3753 3754 3755 3756 3757 3758 3759 3760 3761 3762 3763 3764 3765 3766 3767 3768 3769 3770 3771 3772 3773 3774 3775 3776 3777 3778 3779 3780 3781 3782 3783 3784 3785 3786 3787 3788 3789 3790 3791 3792 3793 3794 3795 3796 3797 3798 3799 3800 3801 3802 3803 3804 3805 3806 3807 3808 3809 3810 3811 3812 3813 3814 3815 3816 3817 3818 3819 3820 3821 3822 3823 3824 3825 3826 3827 3828 3829 3830 3831 3832 3833 3834 3835 3836 3837 3838 3839 3840 3841 3842 3843 3844 3845 3846 3847 3848 3849 3850 3851 3852 3853 3854 3855 3856 3857 3858 3859 3860 3861 3862 3863 3864 3865 3866 3867 3868 3869 3870 3871 3872 3873 3874 3875 3876 3877 3878 3879 3880 3881 3882 3883 3884 3885 3886 3887 3888 3889 3890 3891 3892 3893 3894 3895 3896 3897 3898 3899 3900 3901 3902 3903 3904 3905 3906 3907 3908 3909 3910 3911 3912 3913 3914 3915 3916 3917 3918 3919 3920 3921 3922 3923 3924 3925 3926 3927 3928 3929 3930 3931 3932 3933 3934 3935 3936 3937 3938 3939 3940 3941 3942 3943 3944 3945 3946 3947 3948 3949 3950 3951 3952 3953 3954 3955 3956 3957 3958 3959 3960 3961 3962 3963 3964 3965 3966 3967 3968 3969 3970 3971 3972 3973 3974 3975 3976 3977 3978 3979 3980 3981 3982 3983 3984 3985 3986 3987 3988 3989 3990 3991 3992 3993 3994 3995 3996 3997 3998 3999 4000 4001 4002 4003 4004 4005 4006 4007 4008 4009 4010 4011 4012 4013 4014 4015 4016 4017 4018 4019 4020 4021 4022 4023 4024 4025 4026 4027 4028 4029 4030 4031 4032 4033 4034 4035 4036 4037 4038 4039 4040 4041 4042 4043 4044 4045 4046 4047 4048 4049 4050 4051 4052 4053 4054 4055 4056 4057 4058 4059 4060 4061 4062 4063 4064 4065 4066 4067 4068 4069 4070 4071 4072 4073 4074 4075 4076 4077 4078 4079 4080 4081 4082 4083 4084 4085 4086 4087 4088 4089 4090 4091 4092 4093 4094 4095 4096 4097 4098 4099 4100 4101 4102 4103 4104 4105 4106 4107 4108 4109 4110 4111 4112 4113 4114 4115 4116 4117 4118 4119 4120 4121 4122 4123 4124 4125 4126 4127 4128 4129 4130 4131 4132 4133 4134 4135 4136 4137 4138 4139 4140 4141 4142 4143 4144 4145 4146 4147 4148 4149 4150 4151 4152 4153 4154 4155 4156 4157 4158 4159 4160 4161 4162 4163 4164 4165 4166 4167 4168 4169 4170 4171 4172 4173 4174 4175 4176 4177 4178 4179 4180 4181 4182 4183 4184 4185 4186 4187 4188 4189 4190 4191 4192 4193 4194 4195 4196 4197 4198 4199 4200 4201 4202 4203 4204 4205 4206 4207 4208 4209 4210 4211 4212 4213 4214 4215 4216 4217 4218 4219 4220 4221 4222 4223 4224 4225 4226 4227 4228 4229 4230 4231 4232 4233 4234 4235 4236 4237 4238 4239 4240 4241 4242 4243 4244 4245 4246 4247 4248 4249 4250 4251 4252 4253 4254 4255 4256 4257 4258 4259 4260 4261 4262 4263 4264 4265 4266 4267 4268 4269 4270 4271 4272 4273 4274 4275 4276 4277 4278 4279 4280 4281 4282 4283 4284 4285 4286 4287 4288 4289 4290 4291 4292 4293 4294 4295 4296 4297 4298 4299 4300 4301 4302 4303 4304 4305 4306 4307 4308 4309 4310 4311 4312 4313 4314 4315 4316 4317 4318 4319 4320 4321 4322 4323 4324 4325 4326 4327 4328 4329 4330 4331 4332 4333 4334 4335 4336 4337 4338 4339 4340 4341 4342 4343 4344 4345 4346 4347 4348 4349 4350 4351 4352 4353 4354 4355 4356 4357 4358 4359 4360 4361 4362 4363 4364 4365 4366 4367 4368 4369 4370 4371 4372 4373 4374 4375 4376 4377 4378 4379 4380 4381 4382 4383 4384 4385 4386 4387 4388 4389 4390 4391 4392 4393 4394 4395 4396 4397 4398 4399 4400 4401 4402 4403 4404 4405 4406 4407 4408 4409 4410 4411 4412 4413 4414 4415 4416 4417 4418 4419 4420 4421 4422 4423 4424 4425 4426 4427 4428 4429 4430 4431 4432 4433 4434 4435 4436 4437 4438 4439 4440 4441 4442 4443 4444 4445 4446 4447 4448 4449 4450 4451 4452 4453 4454 4455 4456 4457 4458 4459 4460 4461 4462 4463 4464 4465 4466 4467 4468 4469 4470 4471 4472 4473 4474 4475 4476 4477 4478 4479 4480 4481 4482 4483 4484 4485 4486 4487 4488 4489 4490 4491 4492 4493 4494 4495 4496 4497 4498 4499 4500 4501 4502 4503 4504 4505 4506 4507 4508 4509 4510 4511 4512 4513 4514 4515 4516 4517 4518 4519 4520 4521 4522 4523 4524 4525 4526 4527 4528 4529 4530 4531 4532 4533 4534 4535 4536 4537 4538 4539 4540 4541 4542 4543 4544 4545 4546 4547 4548 4549 4550 4551 4552 4553 4554 4555 4556 4557 4558 4559 4560 4561 4562 4563 4564 4565 4566 4567 4568 4569 4570 4571 4572 4573 4574 4575 4576 4577 4578 4579 4580 4581 4582 4583 4584 4585 4586 4587 4588 4589 4590 4591 4592 4593 4594 4595 4596 4597 4598 4599 4600 4601 4602 4603 4604 4605 4606 4607 4608 4609 4610 4611 4612 4613 4614 4615 4616 4617 4618 4619 4620 4621 4622 4623 4624 4625 4626 4627 4628 4629 4630 4631 4632 4633 4634 4635 4636 4637 4638 4639 4640 4641 4642 4643 4644 4645 4646 4647 4648 4649 4650 4651 4652 4653 4654 4655 4656 4657 4658 4659 4660 4661 4662 4663 4664 4665 4666 4667 4668 4669 4670 4671 4672 4673 4674 4675 4676 4677 4678 4679 4680 4681 4682 4683 4684 4685 4686 4687 4688 4689 4690 4691 4692 4693 4694 4695 4696 4697 4698 4699 4700 4701 4702 4703 4704 4705 4706 4707 4708 4709 4710 4711 4712 4713 4714 4715 4716 4717 4718 4719 4720 4721 4722 4723 4724 4725 4726 4727 4728 4729 4730 4731 4732 4733 4734 4735 4736 4737 4738 4739 4740 4741 4742 4743 4744 4745 4746 4747 4748 4749 4750 4751 4752 4753 4754 4755 4756 4757 4758 4759 4760 4761 4762 4763 4764 4765 4766 4767 4768 4769 4770 4771 4772 4773 4774 4775))
           (list :vertices #2f((-20.000000 -28.500000 54.671001)(-20.000000 -28.500000 45.000000)(-15.507700 -28.500000 54.671001)(-15.507700 -28.500000 54.671001)(-20.000000 -28.500000 45.000000)(-12.609800 -28.500000 54.671001)(-12.609800 -28.500000 54.671001)(-20.000000 -28.500000 45.000000)(-7.975369 -28.500000 54.671001)(7.053750 -28.500000 54.671001)(6.229510 -28.500000 45.000000)(9.737000 -28.500000 54.671001)(9.737000 -28.500000 54.671001)(6.229510 -28.500000 45.000000)(13.656500 -28.500000 54.671001)(13.656500 -28.500000 54.671001)(6.229510 -28.500000 45.000000)(15.857599 -28.500000 54.671001)(15.857599 -28.500000 54.671001)(6.229510 -28.500000 45.000000)(18.912800 -28.500000 54.671001)(7.053750 -28.500000 54.671001)(2.295100 -28.500000 54.671001)(-0.543607 -28.500000 49.835499)(2.295100 -28.500000 54.671001)(-0.476526 -28.500000 54.671001)(-0.543607 -28.500000 49.835499)(-0.476526 -28.500000 54.671001)(-5.366700 -28.500000 54.671001)(-0.543607 -28.500000 49.835499)(-5.366700 -28.500000 54.671001)(-7.975369 -28.500000 54.671001)(-0.543607 -28.500000 49.835499)(-20.000000 -28.500000 45.000000)(6.229510 -28.500000 45.000000)(-0.543607 -28.500000 49.835499)(-7.975369 -28.500000 54.671001)(-20.000000 -28.500000 45.000000)(-0.543607 -28.500000 49.835499)(6.229510 -28.500000 45.000000)(7.053750 -28.500000 54.671001)(-0.543607 -28.500000 49.835499)(20.000000 27.923500 54.671001)(20.000000 -28.500000 54.671001)(20.000000 -23.000000 45.000000)(20.000000 -23.000000 45.000000)(20.000000 -28.500000 54.671001)(20.000000 -28.500000 45.000000)(20.000000 27.923500 54.671001)(20.000000 -23.000000 45.000000)(20.000000 -23.000000 27.892200)(20.000000 27.923500 54.671001)(19.999201 29.499899 31.500000)(20.000000 29.500000 54.671001)(20.000000 27.923500 54.671001)(19.999300 24.000000 31.500000)(19.999201 29.499899 31.500000)(20.000000 -23.000000 27.892200)(20.000000 -23.000000 25.000000)(19.999100 24.000000 25.000000)(20.000000 -23.000000 27.892200)(19.999100 24.000000 25.000000)(19.999300 24.000000 31.500000)(20.000000 -23.000000 27.892200)(19.999300 24.000000 31.500000)(20.000000 27.923500 54.671001)(11.911500 29.500000 54.671001)(15.857599 29.500000 54.671001)(11.474600 29.500000 31.500000)(15.857599 29.500000 54.671001)(18.111300 29.500000 54.671001)(19.999201 29.499899 31.500000)(18.111300 29.500000 54.671001)(20.000000 29.500000 54.671001)(19.999201 29.499899 31.500000)(11.474600 29.500000 31.500000)(15.857599 29.500000 54.671001)(19.999201 29.499899 31.500000)(9.737000 29.500000 54.671001)(11.911500 29.500000 54.671001)(0.543593 29.500000 43.085499)(11.474600 29.500000 31.500000)(-18.912800 29.500000 54.671001)(0.543593 29.500000 43.085499)(-18.912800 29.500000 54.671001)(-17.895401 29.500000 54.671001)(0.543593 29.500000 43.085499)(-17.895401 29.500000 54.671001)(-12.609800 29.500000 54.671001)(0.543593 29.500000 43.085499)(-12.609800 29.500000 54.671001)(-10.085299 29.500000 54.671001)(0.543593 29.500000 43.085499)(-10.085299 29.500000 54.671001)(-5.366700 29.500000 54.671001)(0.543593 29.500000 43.085499)(-5.366700 29.500000 54.671001)(-2.680180 29.500000 54.671001)(0.543593 29.500000 43.085499)(-2.680180 29.500000 54.671001)(2.295100 29.500000 54.671001)(0.543593 29.500000 43.085499)(2.295100 29.500000 54.671001)(4.929830 29.500000 54.671001)(0.543593 29.500000 43.085499)(4.929830 29.500000 54.671001)(9.737000 29.500000 54.671001)(0.543593 29.500000 43.085499)(11.911500 29.500000 54.671001)(11.474600 29.500000 31.500000)(0.543593 29.500000 43.085499)(6.229510 -28.500000 45.000000)(20.000000 -28.500000 45.000000)(18.912800 -28.500000 54.671001)(18.912800 -28.500000 54.671001)(20.000000 -28.500000 45.000000)(19.922800 -28.500000 54.671001)(19.922800 -28.500000 54.671001)(20.000000 -28.500000 45.000000)(20.000000 -28.500000 54.671001)(-20.000000 27.923500 54.671001)(-20.000000 -23.000000 27.892200)(-20.000000 -23.000000 45.000000)(-20.000000 -23.000000 45.000000)(-20.000000 -28.500000 45.000000)(-20.000000 -28.500000 54.671001)(-20.000000 27.923500 54.671001)(-20.000000 -23.000000 45.000000)(-20.000000 -28.500000 54.671001)(-20.000000 -28.500000 45.000000)(-19.980200 -28.500000 25.015100)(6.229510 -28.500000 45.000000)(20.000000 -23.000000 27.892200)(20.000000 -23.000000 45.000000)(20.000000 -25.234600 26.717201)(20.000000 -28.500000 45.000000)(20.000000 -28.500000 25.000000)(20.000000 -25.750000 35.000000)(20.000000 -28.500000 25.000000)(20.000000 -25.234600 26.717201)(20.000000 -25.750000 35.000000)(20.000000 -25.234600 26.717201)(20.000000 -23.000000 45.000000)(20.000000 -25.750000 35.000000)(20.000000 -23.000000 45.000000)(20.000000 -28.500000 45.000000)(20.000000 -25.750000 35.000000)(20.000000 -23.000000 25.000000)(-2.222220 -23.000000 25.000000)(16.205999 24.000000 25.000000)(-2.222220 -23.000000 25.000000)(-16.207001 -23.000000 25.000000)(16.205999 24.000000 25.000000)(20.000000 -23.000000 25.000000)(16.205999 24.000000 25.000000)(19.999100 24.000000 25.000000)(20.000000 -24.222200 26.446100)(20.000000 -23.000000 25.000000)(20.000000 -23.000000 27.892200)(20.000000 -24.222200 26.446100)(20.000000 -25.444399 25.000000)(20.000000 -23.000000 25.000000)(20.000000 -24.222200 26.446100)(20.000000 -25.234600 26.717201)(20.000000 -25.444399 25.000000)(20.000000 -24.222200 26.446100)(20.000000 -23.000000 27.892200)(20.000000 -25.234600 26.717201)(-19.319000 24.000000 -5.176000)(20.000000 24.000000 0.000000)(13.031600 24.000000 25.000000)(13.031600 24.000000 25.000000)(20.000000 24.000000 0.000000)(16.205999 24.000000 25.000000)(16.205999 24.000000 25.000000)(20.000000 24.000000 0.000000)(19.999100 24.000000 25.000000)(19.999300 24.000000 31.500000)(20.000000 24.000000 0.000000)(19.999100 24.000000 25.000000)(11.474600 29.500000 31.500000)(19.999201 29.499899 31.500000)(19.998999 29.500000 25.000000)(-20.000000 29.500000 54.671001)(-18.912800 29.500000 54.671001)(-20.000000 29.500000 31.500000)(-20.000000 29.500000 25.000000)(-20.000000 29.500000 31.500000)(-20.000999 29.500000 25.000000)(-20.000000 29.500000 31.500000)(-18.912800 29.500000 54.671001)(11.474600 29.500000 31.500000)(-20.000000 29.500000 54.671001)(-20.000999 29.500000 25.000000)(-20.000000 29.500000 31.500000)(-19.980200 -28.500000 25.015100)(-19.980200 -28.500000 25.000000)(2.765450 -28.500000 25.000000)(-19.980200 -28.500000 25.015100)(2.765450 -28.500000 25.000000)(6.229510 -28.500000 45.000000)(6.229510 -28.500000 45.000000)(2.765450 -28.500000 25.000000)(20.000000 -28.500000 45.000000)(-20.000000 29.500000 54.671001)(-20.000999 29.500000 25.000000)(-20.000000 27.923500 54.671001)(-20.000999 29.500000 25.000000)(-20.000000 -23.000000 25.000000)(-20.000000 -23.000000 27.892200)(-20.000000 27.923500 54.671001)(-20.000999 29.500000 25.000000)(-20.000000 -23.000000 27.892200)(-20.000000 -28.500000 45.000000)(-20.000000 -23.000000 45.000000)(-20.000000 -25.750000 35.603901)(-20.000000 -23.000000 45.000000)(-20.000000 -23.000000 27.892200)(-20.000000 -25.750000 35.603901)(-20.000000 -23.000000 27.892200)(-20.000000 -26.203199 26.207800)(-20.000000 -25.750000 35.603901)(-20.000000 -26.203199 26.207800)(-20.000000 -28.500000 45.000000)(-20.000000 -25.750000 35.603901)(-20.000000 -28.500000 25.000000)(-19.980200 -28.500000 25.015100)(-20.000000 -28.500000 45.000000)(2.765450 -28.500000 25.000000)(20.000000 -28.500000 25.000000)(20.000000 -28.500000 45.000000)(20.000000 -28.500000 25.000000)(20.000000 -25.444399 25.000000)(20.000000 -25.234600 26.717201)(-2.222220 -23.000000 25.000000)(20.000000 -23.000000 25.000000)(20.000000 -23.000000 0.000000)(-16.207001 -23.000000 25.000000)(-2.222220 -23.000000 25.000000)(-20.000000 -23.000000 0.000000)(-20.000000 -23.000000 25.000000)(-16.207001 -23.000000 25.000000)(-20.000000 -23.000000 0.000000)(-20.000000 -23.000000 0.000000)(-2.222220 -23.000000 25.000000)(20.000000 -23.000000 0.000000)(-20.000000 29.500000 25.000000)(-20.000999 29.500000 25.000000)(-20.000000 25.134901 25.000000)(-20.000000 24.000000 25.000000)(-20.000000 25.134901 25.000000)(-20.000999 29.500000 25.000000)(-20.000000 24.000000 25.000000)(-20.000999 29.500000 25.000000)(-20.000000 -23.000000 25.000000)(-20.000000 24.000000 25.000000)(-19.879301 24.000000 25.000000)(-1.897500 3.250000 25.000000)(-19.879301 24.000000 25.000000)(13.031600 24.000000 25.000000)(-1.897500 3.250000 25.000000)(13.031600 24.000000 25.000000)(16.205999 24.000000 25.000000)(-1.897500 3.250000 25.000000)(16.205999 24.000000 25.000000)(-16.207001 -23.000000 25.000000)(-1.897500 3.250000 25.000000)(-16.207001 -23.000000 25.000000)(-20.000000 -23.000000 25.000000)(-1.897500 3.250000 25.000000)(-20.000000 -23.000000 25.000000)(-20.000000 24.000000 25.000000)(-1.897500 3.250000 25.000000)(20.000000 -23.000000 25.000000)(20.000000 -25.444399 25.000000)(20.000000 -23.000000 0.000000)(20.000000 -23.000000 0.000000)(20.000000 -25.444399 25.000000)(20.000000 -28.500000 0.000000)(19.999201 29.499899 31.500000)(19.999300 24.000000 31.500000)(20.000000 24.000000 0.000000)(-19.879301 24.000000 25.000000)(-19.319000 24.000000 -5.176000)(13.031600 24.000000 25.000000)(-19.319000 24.000000 -5.176000)(19.317999 24.000000 -5.176000)(20.000000 24.000000 0.000000)(-11.745999 29.500000 25.000000)(19.998999 29.500000 25.000000)(20.000000 29.500000 0.000000)(20.000000 29.500000 0.000000)(19.999201 29.499899 31.500000)(19.998999 29.500000 25.000000)(11.474600 29.500000 31.500000)(19.998999 29.500000 25.000000)(-0.000500 29.500000 28.250000)(19.998999 29.500000 25.000000)(-11.745999 29.500000 25.000000)(-0.000500 29.500000 28.250000)(-11.745999 29.500000 25.000000)(-20.000000 29.500000 31.500000)(-0.000500 29.500000 28.250000)(-20.000000 29.500000 31.500000)(11.474600 29.500000 31.500000)(-0.000500 29.500000 28.250000)(-20.000000 29.500000 25.000000)(-20.000000 29.500000 31.500000)(-11.745999 29.500000 25.000000)(-19.980200 -28.500000 25.015100)(-19.980200 -28.500000 25.000000)(-20.000000 -28.500000 25.000000)(-19.980200 -28.500000 25.000000)(-19.954000 -28.500000 -1.365000)(2.765450 -28.500000 25.000000)(-20.000000 -23.000000 27.892200)(-20.000000 -23.000000 25.000000)(-20.000000 -26.203199 26.207800)(-20.000000 -23.000000 25.000000)(-20.000000 -26.055601 25.000000)(-20.000000 -26.203199 26.207800)(-20.000000 -26.203199 26.207800)(-20.000000 -28.500000 25.000000)(-20.000000 -28.500000 45.000000)(-19.954000 -28.500000 -1.365000)(20.000000 -28.500000 0.000000)(2.765450 -28.500000 25.000000)(2.765450 -28.500000 25.000000)(20.000000 -28.500000 0.000000)(20.000000 -28.500000 25.000000)(20.000000 -25.444399 25.000000)(20.000000 -28.500000 25.000000)(20.000000 -28.500000 0.000000)(-19.954000 -23.000000 -1.365000)(-20.000000 -23.000000 0.000000)(20.000000 -23.000000 0.000000)(-20.000000 -23.000000 25.000000)(-20.000000 -23.000000 0.000000)(-20.000000 -26.055601 25.000000)(-20.000000 29.500000 0.000000)(-20.000000 24.000000 0.000000)(-20.000000 25.134901 25.000000)(-20.000000 25.134901 25.000000)(-20.000000 24.000000 0.000000)(-20.000000 24.000000 25.000000)(-20.000000 24.000000 25.000000)(-20.000000 24.000000 0.000000)(-19.879301 24.000000 25.000000)(-19.879301 24.000000 25.000000)(-20.000000 24.000000 0.000000)(-19.319000 24.000000 -5.176000)(-20.000000 29.500000 25.000000)(-20.000000 29.500000 0.000000)(-20.000000 25.134901 25.000000)(19.952999 -23.000000 -1.365000)(20.000000 -23.000000 0.000000)(20.000000 -28.500000 0.000000)(20.000000 29.500000 0.000000)(19.999201 29.499899 31.500000)(20.000000 24.000000 0.000000)(-19.319000 24.000000 -5.176000)(17.320000 24.000000 -10.000000)(19.317999 24.000000 -5.176000)(19.317999 29.500000 -5.176000)(20.000000 24.000000 0.000000)(19.317999 24.000000 -5.176000)(-20.000000 29.500000 25.000000)(-11.745999 29.500000 25.000000)(-20.000000 29.500000 0.000000)(-20.000000 29.500000 0.000000)(-11.745999 29.500000 25.000000)(20.000000 29.500000 0.000000)(-20.000000 -28.500000 25.000000)(-20.000000 -28.500000 0.000000)(-19.980200 -28.500000 25.000000)(-20.000000 -28.500000 0.000000)(-19.954000 -28.500000 -1.365000)(-19.980200 -28.500000 25.000000)(-20.000000 -26.203199 26.207800)(-20.000000 -26.055601 25.000000)(-20.000000 -28.500000 25.000000)(-19.954000 -28.500000 -1.365000)(19.952999 -28.500000 -1.365000)(20.000000 -28.500000 0.000000)(-18.845999 -23.000000 -6.698000)(-19.954000 -23.000000 -1.365000)(20.000000 -23.000000 0.000000)(-20.000000 -23.000000 0.000000)(-19.954000 -23.000000 -1.365000)(-19.954000 -28.500000 -1.365000)(-20.000000 -23.000000 0.000000)(-20.000000 -28.500000 0.000000)(-20.000000 -26.055601 25.000000)(-20.000000 -26.055601 25.000000)(-20.000000 -28.500000 0.000000)(-20.000000 -28.500000 25.000000)(-20.000000 29.500000 0.000000)(-19.319000 24.000000 -5.176000)(-20.000000 24.000000 0.000000)(19.952999 -23.000000 -1.365000)(20.000000 -28.500000 0.000000)(19.952999 -28.500000 -1.365000)(19.952999 -23.000000 -1.365000)(18.844999 -23.000000 -6.698000)(20.000000 -23.000000 0.000000)(19.317999 29.500000 -5.176000)(20.000000 29.500000 0.000000)(20.000000 24.000000 0.000000)(-19.319000 24.000000 -5.176000)(14.142000 24.000000 -14.142000)(17.320000 24.000000 -10.000000)(17.320000 29.500000 -10.000000)(19.317999 24.000000 -5.176000)(17.320000 24.000000 -10.000000)(17.320000 29.500000 -10.000000)(19.317999 29.500000 -5.176000)(19.317999 24.000000 -5.176000)(-19.319000 29.500000 -5.176000)(-20.000000 29.500000 0.000000)(20.000000 29.500000 0.000000)(-20.000000 -23.000000 0.000000)(-19.954000 -28.500000 -1.365000)(-20.000000 -28.500000 0.000000)(-19.954000 -28.500000 -1.365000)(18.844999 -28.500000 -6.698000)(19.952999 -28.500000 -1.365000)(-16.340000 -23.000000 -11.533999)(-18.845999 -23.000000 -6.698000)(20.000000 -23.000000 0.000000)(-19.954000 -23.000000 -1.365000)(-18.845999 -23.000000 -6.698000)(-18.845999 -28.500000 -6.698000)(-19.954000 -23.000000 -1.365000)(-18.845999 -28.500000 -6.698000)(-19.954000 -28.500000 -1.365000)(-20.000000 29.500000 0.000000)(-19.319000 29.500000 -5.176000)(-19.319000 24.000000 -5.176000)(18.844999 -23.000000 -6.698000)(19.952999 -23.000000 -1.365000)(19.952999 -28.500000 -1.365000)(18.844999 -23.000000 -6.698000)(16.339001 -23.000000 -11.533999)(20.000000 -23.000000 0.000000)(19.317999 29.500000 -5.176000)(17.320000 29.500000 -10.000000)(20.000000 29.500000 0.000000)(-19.319000 24.000000 -5.176000)(9.999000 24.000000 -17.320999)(14.142000 24.000000 -14.142000)(14.142000 29.500000 -14.142000)(17.320000 24.000000 -10.000000)(14.142000 24.000000 -14.142000)(14.142000 29.500000 -14.142000)(17.320000 29.500000 -10.000000)(17.320000 24.000000 -10.000000)(-17.320999 29.500000 -10.000000)(-19.319000 29.500000 -5.176000)(20.000000 29.500000 0.000000)(-19.954000 -28.500000 -1.365000)(16.339001 -28.500000 -11.533999)(18.844999 -28.500000 -6.698000)(18.844999 -23.000000 -6.698000)(19.952999 -28.500000 -1.365000)(18.844999 -28.500000 -6.698000)(-12.622000 -23.000000 -15.514000)(-16.340000 -23.000000 -11.533999)(20.000000 -23.000000 0.000000)(-18.845999 -23.000000 -6.698000)(-16.340000 -23.000000 -11.533999)(-16.340000 -28.500000 -11.533999)(-18.845999 -23.000000 -6.698000)(-16.340000 -28.500000 -11.533999)(-18.845999 -28.500000 -6.698000)(-18.845999 -28.500000 -6.698000)(-16.340000 -28.500000 -11.533999)(-19.954000 -28.500000 -1.365000)(-19.319000 29.500000 -5.176000)(-17.320999 24.000000 -10.000000)(-19.319000 24.000000 -5.176000)(20.000000 -23.000000 0.000000)(16.339001 -23.000000 -11.533999)(12.621000 -23.000000 -15.514000)(16.339001 -23.000000 -11.533999)(18.844999 -23.000000 -6.698000)(18.844999 -28.500000 -6.698000)(20.000000 29.500000 0.000000)(17.320000 29.500000 -10.000000)(14.142000 29.500000 -14.142000)(-19.319000 24.000000 -5.176000)(5.176000 24.000000 -19.319000)(9.999000 24.000000 -17.320999)(14.142000 24.000000 -14.142000)(9.999000 24.000000 -17.320999)(9.999000 29.500000 -17.320999)(14.142000 24.000000 -14.142000)(9.999000 29.500000 -17.320999)(14.142000 29.500000 -14.142000)(-14.143001 29.500000 -14.142000)(-17.320999 29.500000 -10.000000)(20.000000 29.500000 0.000000)(-19.319000 29.500000 -5.176000)(-17.320999 29.500000 -10.000000)(-17.320999 24.000000 -10.000000)(-19.954000 -28.500000 -1.365000)(12.621000 -28.500000 -15.514000)(16.339001 -28.500000 -11.533999)(16.339001 -23.000000 -11.533999)(18.844999 -28.500000 -6.698000)(16.339001 -28.500000 -11.533999)(-7.969000 -23.000000 -18.344000)(-12.622000 -23.000000 -15.514000)(20.000000 -23.000000 0.000000)(-16.340000 -23.000000 -11.533999)(-12.622000 -23.000000 -15.514000)(-12.622000 -28.500000 -15.514000)(-16.340000 -23.000000 -11.533999)(-12.622000 -28.500000 -15.514000)(-16.340000 -28.500000 -11.533999)(-16.340000 -28.500000 -11.533999)(-12.622000 -28.500000 -15.514000)(-19.954000 -28.500000 -1.365000)(-17.320999 24.000000 -10.000000)(-14.143001 24.000000 -14.142000)(-19.319000 24.000000 -5.176000)(7.967000 -23.000000 -18.344000)(20.000000 -23.000000 0.000000)(12.621000 -23.000000 -15.514000)(12.621000 -23.000000 -15.514000)(16.339001 -23.000000 -11.533999)(16.339001 -28.500000 -11.533999)(9.999000 29.500000 -17.320999)(20.000000 29.500000 0.000000)(14.142000 29.500000 -14.142000)(-19.319000 24.000000 -5.176000)(-0.001000 24.000000 -20.000000)(5.176000 24.000000 -19.319000)(9.999000 24.000000 -17.320999)(5.176000 24.000000 -19.319000)(5.176000 29.500000 -19.319000)(9.999000 24.000000 -17.320999)(5.176000 29.500000 -19.319000)(9.999000 29.500000 -17.320999)(-10.001000 29.500000 -17.320999)(-14.143001 29.500000 -14.142000)(20.000000 29.500000 0.000000)(-17.320999 29.500000 -10.000000)(-14.143001 29.500000 -14.142000)(-14.143001 24.000000 -14.142000)(-17.320999 29.500000 -10.000000)(-14.143001 24.000000 -14.142000)(-17.320999 24.000000 -10.000000)(-19.954000 -28.500000 -1.365000)(7.967000 -28.500000 -18.344000)(12.621000 -28.500000 -15.514000)(12.621000 -23.000000 -15.514000)(16.339001 -28.500000 -11.533999)(12.621000 -28.500000 -15.514000)(-2.724000 -23.000000 -19.813999)(-7.969000 -23.000000 -18.344000)(20.000000 -23.000000 0.000000)(-7.969000 -28.500000 -18.344000)(-12.622000 -23.000000 -15.514000)(-7.969000 -23.000000 -18.344000)(-7.969000 -28.500000 -18.344000)(-12.622000 -28.500000 -15.514000)(-12.622000 -23.000000 -15.514000)(-12.622000 -28.500000 -15.514000)(-7.969000 -28.500000 -18.344000)(-19.954000 -28.500000 -1.365000)(-14.143001 24.000000 -14.142000)(-10.001000 24.000000 -17.320999)(-19.319000 24.000000 -5.176000)(2.723000 -23.000000 -19.813999)(20.000000 -23.000000 0.000000)(7.967000 -23.000000 -18.344000)(12.621000 -28.500000 -15.514000)(7.967000 -23.000000 -18.344000)(12.621000 -23.000000 -15.514000)(5.176000 29.500000 -19.319000)(20.000000 29.500000 0.000000)(9.999000 29.500000 -17.320999)(-19.319000 24.000000 -5.176000)(-5.177000 24.000000 -19.319000)(-0.001000 24.000000 -20.000000)(5.176000 24.000000 -19.319000)(-0.001000 24.000000 -20.000000)(-0.001000 29.500000 -20.000000)(5.176000 24.000000 -19.319000)(-0.001000 29.500000 -20.000000)(5.176000 29.500000 -19.319000)(-5.177000 29.500000 -19.319000)(-10.001000 29.500000 -17.320999)(20.000000 29.500000 0.000000)(-10.001000 24.000000 -17.320999)(-14.143001 29.500000 -14.142000)(-10.001000 29.500000 -17.320999)(-10.001000 24.000000 -17.320999)(-14.143001 24.000000 -14.142000)(-14.143001 29.500000 -14.142000)(-19.954000 -28.500000 -1.365000)(2.723000 -28.500000 -19.813999)(7.967000 -28.500000 -18.344000)(12.621000 -28.500000 -15.514000)(7.967000 -28.500000 -18.344000)(7.967000 -23.000000 -18.344000)(-2.724000 -23.000000 -19.813999)(20.000000 -23.000000 0.000000)(2.723000 -23.000000 -19.813999)(-2.724000 -28.500000 -19.813999)(-7.969000 -23.000000 -18.344000)(-2.724000 -23.000000 -19.813999)(-2.724000 -28.500000 -19.813999)(-7.969000 -28.500000 -18.344000)(-7.969000 -23.000000 -18.344000)(-7.969000 -28.500000 -18.344000)(-2.724000 -28.500000 -19.813999)(-19.954000 -28.500000 -1.365000)(-10.001000 24.000000 -17.320999)(-5.177000 24.000000 -19.319000)(-19.319000 24.000000 -5.176000)(7.967000 -28.500000 -18.344000)(2.723000 -23.000000 -19.813999)(7.967000 -23.000000 -18.344000)(-0.001000 29.500000 -20.000000)(20.000000 29.500000 0.000000)(5.176000 29.500000 -19.319000)(-0.001000 24.000000 -20.000000)(-5.177000 24.000000 -19.319000)(-5.177000 29.500000 -19.319000)(-0.001000 24.000000 -20.000000)(-5.177000 29.500000 -19.319000)(-0.001000 29.500000 -20.000000)(-0.001000 29.500000 -20.000000)(-5.177000 29.500000 -19.319000)(20.000000 29.500000 0.000000)(-5.177000 24.000000 -19.319000)(-10.001000 29.500000 -17.320999)(-5.177000 29.500000 -19.319000)(-5.177000 24.000000 -19.319000)(-10.001000 24.000000 -17.320999)(-10.001000 29.500000 -17.320999)(-19.954000 -28.500000 -1.365000)(-2.724000 -28.500000 -19.813999)(2.723000 -28.500000 -19.813999)(7.967000 -28.500000 -18.344000)(2.723000 -28.500000 -19.813999)(2.723000 -23.000000 -19.813999)(2.723000 -28.500000 -19.813999)(-2.724000 -23.000000 -19.813999)(2.723000 -23.000000 -19.813999)(2.723000 -28.500000 -19.813999)(-2.724000 -28.500000 -19.813999)(-2.724000 -23.000000 -19.813999)(64.883301 -76.285896 52.691002)(64.883301 76.285896 52.691002)(78.493996 -35.100800 52.691002)(78.493996 35.100800 52.691002)(78.493996 -35.100800 52.691002)(64.883301 76.285896 52.691002)(64.883301 76.285896 52.691002)(64.883301 -76.285896 52.691002)(53.206898 90.937698 53.990200)(64.883301 -76.285896 52.691002)(53.206898 -90.937698 53.990200)(53.206898 90.937698 53.990200)(53.206898 -90.937698 53.990200)(45.529900 95.866501 54.478199)(53.206898 90.937698 53.990200)(53.206898 -90.937698 53.990200)(45.529900 -95.866501 54.478199)(45.529900 95.866501 54.478199)(45.529900 -95.866501 54.478199)(33.112999 101.930000 56.679699)(45.529900 95.866501 54.478199)(45.529900 -95.866501 54.478199)(33.112999 -101.930000 56.679699)(33.112999 101.930000 56.679699)(18.596601 -104.157997 58.672501)(9.737000 -101.774002 54.671001)(33.112999 -101.930000 56.679699)(33.112999 -101.930000 56.679699)(22.207399 101.649002 54.671001)(33.112999 101.930000 56.679699)(6.444800 -103.478996 60.388199)(9.737000 -101.774002 54.671001)(18.596601 -104.157997 58.672501)(33.112999 -101.930000 56.679699)(9.737000 -101.774002 54.671001)(15.857599 -101.660995 54.671001)(33.112999 -101.930000 56.679699)(22.207399 -101.649002 54.671001)(22.207399 101.649002 54.671001)(33.112999 101.930000 56.679699)(22.207399 101.649002 54.671001)(15.857599 101.660995 54.671001)(2.295100 -101.448997 54.671001)(6.444800 -103.478996 60.388199)(2.382450 -102.349998 57.991299)(6.444800 -103.478996 60.388199)(-1.679900 -102.785995 61.436001)(2.382450 -102.349998 57.991299)(-1.679900 -102.785995 61.436001)(2.295100 -101.448997 54.671001)(2.382450 -102.349998 57.991299)(2.295100 -101.448997 54.671001)(9.737000 -101.774002 54.671001)(6.444800 -103.478996 60.388199)(13.656500 -28.500000 54.671001)(15.857599 -101.660995 54.671001)(12.797299 -65.137001 54.671001)(15.857599 -101.660995 54.671001)(9.737000 -101.774002 54.671001)(12.797299 -65.137001 54.671001)(9.737000 -101.774002 54.671001)(9.737000 -28.500000 54.671001)(12.797299 -65.137001 54.671001)(9.737000 -28.500000 54.671001)(13.656500 -28.500000 54.671001)(12.797299 -65.137001 54.671001)(33.112999 -101.930000 56.679699)(15.857599 -101.660995 54.671001)(22.207399 -101.649002 54.671001)(22.207399 -101.649002 54.671001)(19.922800 -28.500000 54.671001)(20.000000 -28.500000 54.671001)(20.000000 29.500000 54.671001)(18.111300 29.500000 54.671001)(22.207399 101.649002 54.671001)(18.111300 29.500000 54.671001)(15.857599 101.660995 54.671001)(22.207399 101.649002 54.671001)(22.207399 -101.649002 54.671001)(20.000000 -28.500000 54.671001)(20.000000 27.923500 54.671001)(20.000000 29.500000 54.671001)(22.207399 -101.649002 54.671001)(20.000000 27.923500 54.671001)(22.207399 101.649002 54.671001)(22.207399 -101.649002 54.671001)(20.000000 29.500000 54.671001)(33.112999 101.930000 56.679699)(15.857599 101.660995 54.671001)(9.737000 101.774002 54.671001)(9.737000 101.774002 54.671001)(18.596601 104.157997 58.672501)(33.112999 101.930000 56.679699)(2.295100 -101.448997 54.671001)(-1.679900 -102.785995 61.436001)(-8.941400 -101.944000 62.374802)(7.053750 -28.500000 54.671001)(9.737000 -101.774002 54.671001)(6.016050 -65.137001 54.671001)(9.737000 -101.774002 54.671001)(2.295100 -101.448997 54.671001)(6.016050 -65.137001 54.671001)(2.295100 -101.448997 54.671001)(2.295100 -28.500000 54.671001)(6.016050 -65.137001 54.671001)(2.295100 -28.500000 54.671001)(7.053750 -28.500000 54.671001)(6.016050 -65.137001 54.671001)(15.857599 -101.660995 54.671001)(13.656500 -28.500000 54.671001)(15.857599 -28.500000 54.671001)(9.737000 -101.774002 54.671001)(7.053750 -28.500000 54.671001)(9.737000 -28.500000 54.671001)(19.922800 -28.500000 54.671001)(22.207399 -101.649002 54.671001)(19.032501 -65.080498 54.671001)(22.207399 -101.649002 54.671001)(15.857599 -101.660995 54.671001)(19.032501 -65.080498 54.671001)(15.857599 -101.660995 54.671001)(15.857599 -28.500000 54.671001)(19.032501 -65.080498 54.671001)(15.857599 -28.500000 54.671001)(18.912800 -28.500000 54.671001)(19.032501 -65.080498 54.671001)(18.912800 -28.500000 54.671001)(19.922800 -28.500000 54.671001)(19.032501 -65.080498 54.671001)(18.111300 29.500000 54.671001)(15.857599 29.500000 54.671001)(15.857599 101.660995 54.671001)(15.857599 29.500000 54.671001)(11.911500 29.500000 54.671001)(12.797299 65.637001 54.671001)(11.911500 29.500000 54.671001)(9.737000 101.774002 54.671001)(12.797299 65.637001 54.671001)(9.737000 101.774002 54.671001)(15.857599 101.660995 54.671001)(12.797299 65.637001 54.671001)(15.857599 101.660995 54.671001)(15.857599 29.500000 54.671001)(12.797299 65.637001 54.671001)(9.737000 101.774002 54.671001)(6.444800 103.478996 60.388199)(18.596601 104.157997 58.672501)(-5.366700 -100.209000 54.671001)(-8.941400 -101.944000 62.374802)(-28.534399 -98.273598 64.660805)(2.295100 -101.448997 54.671001)(-8.941400 -101.944000 62.374802)(-5.366700 -100.209000 54.671001)(-58.231400 -88.926704 54.671001)(-28.534399 -98.273598 64.660805)(-46.521900 -94.228600 66.603401)(2.295100 -101.448997 54.671001)(-0.476526 -28.500000 54.671001)(2.295100 -28.500000 54.671001)(-0.476526 -28.500000 54.671001)(2.295100 -101.448997 54.671001)(-1.535800 -64.974503 54.671001)(2.295100 -101.448997 54.671001)(-5.366700 -100.209000 54.671001)(-1.535800 -64.974503 54.671001)(-5.366700 -100.209000 54.671001)(-5.366700 -28.500000 54.671001)(-1.535800 -64.974503 54.671001)(-5.366700 -28.500000 54.671001)(-0.476526 -28.500000 54.671001)(-1.535800 -64.974503 54.671001)(-5.366700 -100.209000 54.671001)(-7.975369 -28.500000 54.671001)(-5.366700 -28.500000 54.671001)(-7.975369 -28.500000 54.671001)(-5.366700 -100.209000 54.671001)(-8.988250 -64.354500 54.671001)(-5.366700 -100.209000 54.671001)(-8.522690 -99.636398 54.671001)(-8.988250 -64.354500 54.671001)(-8.522690 -99.636398 54.671001)(-12.609800 -98.894798 54.671001)(-8.988250 -64.354500 54.671001)(-12.609800 -98.894798 54.671001)(-12.609800 -28.500000 54.671001)(-8.988250 -64.354500 54.671001)(-12.609800 -28.500000 54.671001)(-7.975369 -28.500000 54.671001)(-8.988250 -64.354500 54.671001)(-12.609800 -98.894798 54.671001)(-15.507700 -28.500000 54.671001)(-12.609800 -28.500000 54.671001)(-12.609800 -98.894798 54.671001)(-20.691801 -97.428299 54.671001)(-15.507700 -28.500000 54.671001)(-20.691801 -97.428299 54.671001)(-20.000000 -28.500000 54.671001)(-15.507700 -28.500000 54.671001)(-17.895401 29.500000 54.671001)(-18.912800 29.500000 54.671001)(-20.691801 97.428299 54.671001)(-18.912800 29.500000 54.671001)(-20.000000 29.500000 54.671001)(-20.691801 97.428299 54.671001)(-20.000000 29.500000 54.671001)(-20.691801 -97.428299 54.671001)(-20.691801 97.428299 54.671001)(-20.000000 27.923500 54.671001)(-20.691801 -97.428299 54.671001)(-20.000000 29.500000 54.671001)(-20.000000 -28.500000 54.671001)(-20.691801 -97.428299 54.671001)(-20.000000 27.923500 54.671001)(11.911500 29.500000 54.671001)(9.737000 29.500000 54.671001)(9.737000 101.774002 54.671001)(-12.609800 29.500000 54.671001)(-17.895401 29.500000 54.671001)(-16.650799 64.197395 54.671001)(-17.895401 29.500000 54.671001)(-20.691801 97.428299 54.671001)(-16.650799 64.197395 54.671001)(-20.691801 97.428299 54.671001)(-12.609800 98.894798 54.671001)(-16.650799 64.197395 54.671001)(-12.609800 98.894798 54.671001)(-12.609800 29.500000 54.671001)(-16.650799 64.197395 54.671001)(-10.085299 29.500000 54.671001)(-12.609800 29.500000 54.671001)(-12.609800 98.894798 54.671001)(-5.366700 29.500000 54.671001)(-10.085299 29.500000 54.671001)(-8.988250 64.854500 54.671001)(-10.085299 29.500000 54.671001)(-12.609800 98.894798 54.671001)(-8.988250 64.854500 54.671001)(-12.609800 98.894798 54.671001)(-8.522690 99.636398 54.671001)(-8.988250 64.854500 54.671001)(-8.522690 99.636398 54.671001)(-5.366700 100.209000 54.671001)(-8.988250 64.854500 54.671001)(-5.366700 100.209000 54.671001)(-5.366700 29.500000 54.671001)(-8.988250 64.854500 54.671001)(-2.680180 29.500000 54.671001)(-5.366700 29.500000 54.671001)(-5.366700 100.209000 54.671001)(2.295100 29.500000 54.671001)(-2.680180 29.500000 54.671001)(-1.535800 65.474503 54.671001)(-2.680180 29.500000 54.671001)(-5.366700 100.209000 54.671001)(-1.535800 65.474503 54.671001)(-5.366700 100.209000 54.671001)(2.295100 101.448997 54.671001)(-1.535800 65.474503 54.671001)(2.295100 101.448997 54.671001)(2.295100 29.500000 54.671001)(-1.535800 65.474503 54.671001)(4.929830 29.500000 54.671001)(2.295100 29.500000 54.671001)(2.295100 101.448997 54.671001)(9.737000 29.500000 54.671001)(4.929830 29.500000 54.671001)(6.016050 65.637001 54.671001)(4.929830 29.500000 54.671001)(2.295100 101.448997 54.671001)(6.016050 65.637001 54.671001)(2.295100 101.448997 54.671001)(9.737000 101.774002 54.671001)(6.016050 65.637001 54.671001)(9.737000 101.774002 54.671001)(9.737000 29.500000 54.671001)(6.016050 65.637001 54.671001)(2.295100 101.448997 54.671001)(6.444800 103.478996 60.388199)(9.737000 101.774002 54.671001)(-20.691801 -97.428299 54.671001)(-28.534399 -98.273598 64.660805)(-27.782200 -96.141800 54.671001)(-16.950499 -99.141602 59.226799)(-5.366700 -100.209000 54.671001)(-28.534399 -98.273598 64.660805)(-16.950499 -99.141602 59.226799)(-20.691801 -97.428299 54.671001)(-12.609800 -98.894798 54.671001)(-16.950499 -99.141602 59.226799)(-12.609800 -98.894798 54.671001)(-8.522690 -99.636398 54.671001)(-16.950499 -99.141602 59.226799)(-8.522690 -99.636398 54.671001)(-5.366700 -100.209000 54.671001)(-16.950499 -99.141602 59.226799)(-28.534399 -98.273598 64.660805)(-20.691801 -97.428299 54.671001)(-58.231400 -88.926704 54.671001)(-40.360600 -93.163994 54.671001)(-28.534399 -98.273598 64.660805)(-28.534399 -98.273598 64.660805)(-40.360600 -93.163994 54.671001)(-31.903900 -95.165100 54.671001)(-28.534399 -98.273598 64.660805)(-31.903900 -95.165100 54.671001)(-27.782200 -96.141800 54.671001)(-58.231400 -88.926704 54.671001)(-46.521900 -94.228600 66.603401)(-58.903999 -90.460297 67.765900)(-20.691801 -97.428299 54.671001)(-27.782200 96.141800 54.671001)(-20.691801 97.428299 54.671001)(-27.782200 96.141800 54.671001)(-28.534399 98.273598 64.660805)(-20.691801 97.428299 54.671001)(-28.534399 98.273598 64.660805)(-5.366700 100.209000 54.671001)(-16.950499 99.141602 59.226799)(-5.366700 100.209000 54.671001)(-8.522690 99.636398 54.671001)(-16.950499 99.141602 59.226799)(-8.522690 99.636398 54.671001)(-12.609800 98.894798 54.671001)(-16.950499 99.141602 59.226799)(-12.609800 98.894798 54.671001)(-20.691801 97.428299 54.671001)(-16.950499 99.141602 59.226799)(-20.691801 97.428299 54.671001)(-28.534399 98.273598 64.660805)(-16.950499 99.141602 59.226799)(2.295100 101.448997 54.671001)(-5.366700 100.209000 54.671001)(-8.941400 101.944000 62.374802)(6.444800 103.478996 60.388199)(2.295100 101.448997 54.671001)(2.382450 102.349998 57.991299)(2.295100 101.448997 54.671001)(-1.679900 102.785995 61.436001)(2.382450 102.349998 57.991299)(-1.679900 102.785995 61.436001)(6.444800 103.478996 60.388199)(2.382450 102.349998 57.991299)(-20.691801 -97.428299 54.671001)(-27.782200 -96.141800 54.671001)(-27.782200 96.141800 54.671001)(-40.360600 -93.163994 54.671001)(-58.231400 -88.926704 54.671001)(-58.231400 88.926704 54.671001)(-27.782200 -96.141800 54.671001)(-31.903900 -95.165100 54.671001)(-44.141098 92.273506 54.671001)(-31.903900 -95.165100 54.671001)(-40.360600 -93.163994 54.671001)(-44.141098 92.273506 54.671001)(-58.903999 -90.460297 67.765900)(-67.992096 -85.443001 54.671001)(-58.231400 -88.926704 54.671001)(-28.534399 98.273598 64.660805)(-8.941400 101.944000 62.374802)(-5.366700 100.209000 54.671001)(-28.534399 98.273598 64.660805)(-27.782200 96.141800 54.671001)(-31.903900 95.165100 54.671001)(-28.534399 98.273598 64.660805)(-31.903900 95.165100 54.671001)(-44.141098 92.273506 54.671001)(-28.534399 98.273598 64.660805)(-44.141098 92.273506 54.671001)(-58.231400 88.926704 54.671001)(-1.679900 102.785995 61.436001)(2.295100 101.448997 54.671001)(-8.941400 101.944000 62.374802)(-27.782200 -96.141800 54.671001)(-44.141098 92.273506 54.671001)(-31.903900 95.165100 54.671001)(-27.782200 -96.141800 54.671001)(-31.903900 95.165100 54.671001)(-27.782200 96.141800 54.671001)(-58.903999 -90.460297 67.765900)(-64.909401 -88.640800 68.304802)(-67.992096 -85.443001 54.671001)(-40.360600 -93.163994 54.671001)(-58.231400 88.926704 54.671001)(-44.141098 92.273506 54.671001)(-58.231400 -88.926704 54.671001)(-67.992096 85.443001 54.671001)(-58.231400 88.926704 54.671001)(-58.231400 -88.926704 54.671001)(-67.992096 -85.443001 54.671001)(-67.992096 85.443001 54.671001)(-28.534399 98.273598 64.660805)(-58.231400 88.926704 54.671001)(-46.521900 94.228600 66.603401)(-74.716095 -82.671501 54.671001)(-76.484505 -84.369698 69.301498)(-87.256599 -79.376694 68.048599)(-64.909401 -88.640800 68.304802)(-76.484505 -84.369698 69.301498)(-67.992096 -85.443001 54.671001)(-58.231400 88.926704 54.671001)(-67.992096 85.443001 54.671001)(-58.903999 90.460297 67.765900)(-67.992096 -85.443001 54.671001)(-74.716095 82.671501 54.671001)(-67.992096 85.443001 54.671001)(-46.521900 94.228600 66.603401)(-58.231400 88.926704 54.671001)(-58.903999 90.460297 67.765900)(-87.256599 -79.376694 68.048599)(-100.321999 -72.741798 70.787102)(-83.245598 -79.942200 54.671001)(-74.716095 -82.671501 54.671001)(-67.992096 -85.443001 54.671001)(-76.484505 -84.369698 69.301498)(-87.256599 -79.376694 68.048599)(-83.245598 -79.942200 54.671001)(-74.716095 -82.671501 54.671001)(-64.909401 88.640800 68.304802)(-58.903999 90.460297 67.765900)(-67.992096 85.443001 54.671001)(-67.992096 -85.443001 54.671001)(-74.716095 -82.671501 54.671001)(-74.716095 82.671501 54.671001)(-76.484505 84.369698 69.301498)(-67.992096 85.443001 54.671001)(-74.716095 82.671501 54.671001)(-106.402000 -68.350502 71.422104)(-108.254997 -60.827999 63.974998)(-100.321999 -72.741798 70.787102)(-100.321999 -72.741798 70.787102)(-88.201500 -76.748100 54.671001)(-83.245598 -79.942200 54.671001)(-74.716095 -82.671501 54.671001)(-83.245598 -79.942200 54.671001)(-83.245598 79.942200 54.671001)(-76.484505 84.369698 69.301498)(-64.909401 88.640800 68.304802)(-67.992096 85.443001 54.671001)(-74.716095 -82.671501 54.671001)(-83.245598 79.942200 54.671001)(-74.716095 82.671501 54.671001)(-87.256599 79.376694 68.048599)(-76.484505 84.369698 69.301498)(-74.716095 82.671501 54.671001)(-93.148598 -73.929901 54.671001)(-100.321999 -72.741798 70.787102)(-108.254997 -60.827999 63.974998)(-108.254997 -60.827999 63.974998)(-106.402000 -68.350502 71.422104)(-111.276001 -59.601002 71.605507)(-93.148598 -73.929901 54.671001)(-88.201500 -76.748100 54.671001)(-100.321999 -72.741798 70.787102)(-83.245598 -79.942200 54.671001)(-88.201500 -76.748100 54.671001)(-88.201500 76.748100 54.671001)(-83.245598 -79.942200 54.671001)(-88.201500 76.748100 54.671001)(-83.245598 79.942200 54.671001)(-87.256599 79.376694 68.048599)(-74.716095 82.671501 54.671001)(-83.245598 79.942200 54.671001)(-108.254997 -60.827999 63.974998)(-99.638000 -68.173897 54.671001)(-93.148598 -73.929901 54.671001)(-108.254997 -60.827999 63.974998)(-111.276001 -59.601002 71.605507)(-115.411995 -52.719002 71.834000)(-88.201500 -76.748100 54.671001)(-93.148598 -73.929901 54.671001)(-93.148598 73.929901 54.671001)(-88.201500 -76.748100 54.671001)(-93.148598 73.929901 54.671001)(-88.201500 76.748100 54.671001)(-100.321999 72.741798 70.787102)(-83.245598 79.942200 54.671001)(-88.201500 76.748100 54.671001)(-87.256599 79.376694 68.048599)(-83.245598 79.942200 54.671001)(-100.321999 72.741798 70.787102)(-115.411995 -52.719002 71.834000)(-118.166000 -45.432003 71.979996)(-112.210999 -47.767200 54.671001)(-105.074005 -61.956699 54.671001)(-99.638000 -68.173897 54.671001)(-108.254997 -60.827999 63.974998)(-93.148598 -73.929901 54.671001)(-99.638000 -68.173897 54.671001)(-99.638000 68.173897 54.671001)(-112.210999 -47.767200 54.671001)(-108.254997 -60.827999 63.974998)(-111.273994 -54.868797 63.252502)(-108.254997 -60.827999 63.974998)(-115.411995 -52.719002 71.834000)(-111.273994 -54.868797 63.252502)(-115.411995 -52.719002 71.834000)(-112.210999 -47.767200 54.671001)(-111.273994 -54.868797 63.252502)(-93.148598 -73.929901 54.671001)(-99.638000 68.173897 54.671001)(-93.148598 73.929901 54.671001)(-88.201500 76.748100 54.671001)(-93.148598 73.929901 54.671001)(-100.321999 72.741798 70.787102)(-106.402000 68.350502 71.422104)(-100.321999 72.741798 70.787102)(-108.254997 60.827999 63.974998)(-114.707001 -41.379002 54.671001)(-118.166000 -45.432003 71.979996)(-119.664001 -38.846001 72.057999)(-114.707001 -41.379002 54.671001)(-112.210999 -47.767200 54.671001)(-118.166000 -45.432003 71.979996)(-109.083000 -55.538700 54.671001)(-105.074005 -61.956699 54.671001)(-108.254997 -60.827999 63.974998)(-105.074005 -61.956699 54.671001)(-105.074005 61.956699 54.671001)(-99.638000 -68.173897 54.671001)(-99.638000 -68.173897 54.671001)(-105.074005 61.956699 54.671001)(-99.638000 68.173897 54.671001)(-108.254997 -60.827999 63.974998)(-112.210999 -47.767200 54.671001)(-109.083000 -55.538700 54.671001)(-93.148598 73.929901 54.671001)(-99.638000 68.173897 54.671001)(-108.254997 60.827999 63.974998)(-93.148598 73.929901 54.671001)(-108.254997 60.827999 63.974998)(-100.321999 72.741798 70.787102)(-108.254997 60.827999 63.974998)(-111.276001 59.601002 71.605507)(-106.402000 68.350502 71.422104)(-114.707001 -41.379002 54.671001)(-119.664001 -38.846001 72.057999)(-119.664001 38.846001 72.057999)(-114.707001 -41.379002 54.671001)(-114.707001 41.379002 54.671001)(-112.210999 -47.767200 54.671001)(-109.083000 -55.538700 54.671001)(-109.083000 55.538700 54.671001)(-105.074005 -61.956699 54.671001)(-105.074005 61.956699 54.671001)(-105.074005 -61.956699 54.671001)(-109.083000 55.538700 54.671001)(-108.254997 60.827999 63.974998)(-99.638000 68.173897 54.671001)(-105.074005 61.956699 54.671001)(-112.210999 -47.767200 54.671001)(-112.210999 47.767200 54.671001)(-109.083000 -55.538700 54.671001)(-108.254997 60.827999 63.974998)(-115.411995 52.719002 71.834000)(-111.276001 59.601002 71.605507)(-118.166000 45.432003 71.979996)(-114.707001 41.379002 54.671001)(-119.664001 38.846001 72.057999)(-119.664001 38.846001 72.057999)(-114.707001 41.379002 54.671001)(-114.707001 -41.379002 54.671001)(-112.210999 47.767200 54.671001)(-112.210999 -47.767200 54.671001)(-114.707001 41.379002 54.671001)(-109.083000 55.538700 54.671001)(-109.083000 -55.538700 54.671001)(-112.210999 47.767200 54.671001)(-108.254997 60.827999 63.974998)(-105.074005 61.956699 54.671001)(-109.083000 55.538700 54.671001)(-108.254997 60.827999 63.974998)(-112.210999 47.767200 54.671001)(-111.273994 54.868797 63.252502)(-112.210999 47.767200 54.671001)(-115.411995 52.719002 71.834000)(-111.273994 54.868797 63.252502)(-115.411995 52.719002 71.834000)(-108.254997 60.827999 63.974998)(-111.273994 54.868797 63.252502)(-118.166000 45.432003 71.979996)(-115.411995 52.719002 71.834000)(-112.210999 47.767200 54.671001)(-118.166000 45.432003 71.979996)(-112.210999 47.767200 54.671001)(-114.707001 41.379002 54.671001)(-112.210999 47.767200 54.671001)(-108.254997 60.827999 63.974998)(-109.083000 55.538700 54.671001)(96.291901 -44.521000 98.903595)(99.590500 -22.541000 101.000000)(95.693703 -47.537403 111.111000)(99.926003 -9.500000 99.068497)(99.477798 -10.524000 111.111000)(99.590500 -22.541000 101.000000)(96.291901 -44.521000 98.903595)(95.693703 -47.537403 111.111000)(91.061005 -63.225002 111.111000)(99.590500 -22.541000 101.000000)(99.440094 -27.166300 111.111000)(95.693703 -47.537403 111.111000)(99.926003 9.500000 99.068497)(99.477798 -10.524000 111.111000)(99.926003 -9.500000 99.068497)(99.477798 -10.524000 111.111000)(99.440094 -27.166300 111.111000)(99.590500 -22.541000 101.000000)(91.115105 -62.855900 99.500000)(96.291901 -44.521000 98.903595)(91.061005 -63.225002 111.111000)(91.061005 -63.225002 111.111000)(95.693703 -47.537403 111.111000)(59.477001 -53.464199 124.998001)(99.440094 -27.166300 111.111000)(59.477001 -53.464199 124.998001)(95.693703 -47.537403 111.111000)(99.477798 -10.524000 111.111000)(99.926003 9.500000 99.068497)(99.477798 10.524000 111.111000)(99.477798 -10.524000 111.111000)(59.477001 -53.464199 124.998001)(99.440094 -27.166300 111.111000)(91.061005 -63.225002 111.111000)(86.764900 -72.545097 111.111000)(91.115105 -62.855900 99.500000)(91.061005 -63.225002 111.111000)(59.477001 -53.464199 124.998001)(55.732803 -62.135998 124.996994)(88.890999 -68.807495 99.500000)(91.115105 -62.855900 99.500000)(86.764900 -72.545097 111.111000)(99.477798 10.524000 111.111000)(99.926003 9.500000 99.068497)(99.590500 22.541000 101.000000)(99.477798 10.524000 111.111000)(67.001999 0.000000 124.999001)(99.477798 -10.524000 111.111000)(59.477001 -53.464199 124.998001)(99.477798 -10.524000 111.111000)(62.306999 -44.734501 124.998001)(86.764900 -72.545097 111.111000)(91.061005 -63.225002 111.111000)(55.732803 -62.135998 124.996994)(55.732803 -62.135998 124.996994)(59.477001 -53.464199 124.998001)(54.416000 -44.364002 125.416992)(86.764900 -72.545097 111.111000)(85.863098 -75.680000 100.202003)(88.890999 -68.807495 99.500000)(99.590500 22.541000 101.000000)(99.440094 27.166300 111.111000)(99.477798 10.524000 111.111000)(99.477798 10.524000 111.111000)(62.306999 44.734501 124.998001)(67.001999 0.000000 124.999001)(62.306999 -44.734501 124.998001)(99.477798 -10.524000 111.111000)(67.001999 0.000000 124.999001)(59.477001 -53.464199 124.998001)(62.306999 -44.734501 124.998001)(54.416000 -44.364002 125.416992)(70.200302 -79.271500 115.089996)(67.893997 -96.406898 111.114998)(86.764900 -72.545097 111.111000)(70.200302 -79.271500 115.089996)(86.764900 -72.545097 111.111000)(55.732803 -62.135998 124.996994)(70.200302 -79.271500 115.089996)(55.732803 -62.135998 124.996994)(67.893997 -96.406898 111.114998)(51.168301 -68.315796 124.996994)(55.732803 -62.135998 124.996994)(54.416000 -44.364002 125.416992)(86.764900 -72.545097 111.111000)(80.172005 -85.216499 100.992004)(85.863098 -75.680000 100.202003)(99.477798 10.524000 111.111000)(99.440094 27.166300 111.111000)(59.477001 53.464199 124.998001)(95.693703 47.537403 111.111000)(99.440094 27.166300 111.111000)(99.590500 22.541000 101.000000)(62.306999 44.734501 124.998001)(99.477798 10.524000 111.111000)(59.477001 53.464199 124.998001)(58.250999 0.000000 125.685005)(67.001999 0.000000 124.999001)(62.306999 44.734501 124.998001)(62.306999 -44.734501 124.998001)(67.001999 0.000000 124.999001)(58.250999 0.000000 125.685005)(54.416000 -44.364002 125.416992)(62.306999 -44.734501 124.998001)(58.250999 0.000000 125.685005)(86.764900 -72.545097 111.111000)(67.893997 -96.406898 111.114998)(80.067001 -84.423203 110.739998)(51.168301 -68.315796 124.996994)(67.893997 -96.406898 111.114998)(55.732803 -62.135998 124.996994)(47.278000 -64.799004 125.185997)(51.168301 -68.315796 124.996994)(54.416000 -44.364002 125.416992)(86.764900 -72.545097 111.111000)(80.067001 -84.423203 110.739998)(80.172005 -85.216499 100.992004)(78.493996 -35.100800 52.691002)(83.731804 -40.151802 57.093601)(74.827995 -66.945099 56.433102)(83.731804 -40.151802 57.093601)(78.493996 -35.100800 52.691002)(86.056000 -9.500000 54.688400)(95.693703 47.537403 111.111000)(59.477001 53.464199 124.998001)(99.440094 27.166300 111.111000)(95.693703 47.537403 111.111000)(99.590500 22.541000 101.000000)(96.291901 44.521000 98.903595)(54.416000 44.364002 125.416992)(62.306999 44.734501 124.998001)(59.477001 53.464199 124.998001)(58.250999 0.000000 125.685005)(62.306999 44.734501 124.998001)(54.416000 44.364002 125.416992)(58.250999 0.000000 125.685005)(46.944000 -42.410000 125.835999)(54.416000 -44.364002 125.416992)(74.418205 -90.857101 106.054001)(74.182999 -91.999001 100.992004)(80.067001 -84.423203 110.739998)(74.418205 -90.857101 106.054001)(80.067001 -84.423203 110.739998)(67.893997 -96.406898 111.114998)(74.418205 -90.857101 106.054001)(67.893997 -96.406898 111.114998)(74.182999 -91.999001 100.992004)(51.168301 -68.315796 124.996994)(51.113697 -105.412003 111.115997)(67.893997 -96.406898 111.114998)(42.185001 -62.366001 125.375000)(47.278000 -64.799004 125.185997)(54.416000 -44.364002 125.416992)(51.168301 -68.315796 124.996994)(47.278000 -64.799004 125.185997)(38.340401 -73.971596 125.049995)(74.182999 -91.999001 100.992004)(80.172005 -85.216499 100.992004)(80.067001 -84.423203 110.739998)(74.827995 -66.945099 56.433102)(64.883301 -76.285896 52.691002)(78.493996 -35.100800 52.691002)(78.493996 -35.100800 52.691002)(78.493996 35.100800 52.691002)(86.056000 -9.500000 54.688400)(95.693703 47.537403 111.111000)(91.061005 63.225002 111.111000)(59.477001 53.464199 124.998001)(91.061005 63.225002 111.111000)(95.693703 47.537403 111.111000)(96.291901 44.521000 98.903595)(54.416000 44.364002 125.416992)(59.477001 53.464199 124.998001)(55.732803 62.135998 124.996994)(58.250999 0.000000 125.685005)(54.416000 44.364002 125.416992)(46.944000 42.410000 125.835999)(42.185001 -62.366001 125.375000)(54.416000 -44.364002 125.416992)(46.944000 -42.410000 125.835999)(46.944000 -42.410000 125.835999)(58.250999 0.000000 125.685005)(49.501003 0.000000 126.370995)(67.893997 -96.406898 111.114998)(65.656502 -98.986702 100.992004)(74.182999 -91.999001 100.992004)(56.278999 -104.368004 100.992004)(67.893997 -96.406898 111.114998)(51.113697 -105.412003 111.115997)(51.168301 -68.315796 124.996994)(46.771999 -72.111000 124.996002)(51.113697 -105.412003 111.115997)(47.278000 -64.799004 125.185997)(42.185001 -62.366001 125.375000)(38.340401 -73.971596 125.049995)(46.771999 -72.111000 124.996002)(51.168301 -68.315796 124.996994)(38.340401 -73.971596 125.049995)(67.417397 -80.710899 57.015900)(64.883301 -76.285896 52.691002)(74.827995 -66.945099 56.433102)(86.056000 9.500000 54.688400)(86.056000 -9.500000 54.688400)(78.493996 35.100800 52.691002)(91.061005 63.225002 111.111000)(55.732803 62.135998 124.996994)(59.477001 53.464199 124.998001)(91.115105 62.855900 99.500000)(91.061005 63.225002 111.111000)(96.291901 44.521000 98.903595)(54.416000 44.364002 125.416992)(55.732803 62.135998 124.996994)(51.168301 68.315796 124.996994)(46.944000 42.410000 125.835999)(54.416000 44.364002 125.416992)(42.185001 62.366001 125.375000)(49.501003 0.000000 126.370995)(58.250999 0.000000 125.685005)(46.944000 42.410000 125.835999)(42.185001 -62.366001 125.375000)(46.944000 -42.410000 125.835999)(37.091999 -59.934002 125.563995)(39.472000 -40.454998 126.255005)(46.944000 -42.410000 125.835999)(49.501003 0.000000 126.370995)(56.278999 -104.368004 100.992004)(65.656502 -98.986702 100.992004)(67.893997 -96.406898 111.114998)(51.113697 -105.412003 111.115997)(47.983501 -107.210999 100.992004)(56.278999 -104.368004 100.992004)(38.340401 -73.971596 125.049995)(51.113697 -105.412003 111.115997)(46.771999 -72.111000 124.996002)(32.000500 -66.527802 125.379997)(38.340401 -73.971596 125.049995)(37.092800 -68.170197 125.256004)(38.340401 -73.971596 125.049995)(42.185001 -62.366001 125.375000)(37.092800 -68.170197 125.256004)(42.185001 -62.366001 125.375000)(32.000500 -66.527802 125.379997)(37.092800 -68.170197 125.256004)(67.417397 -80.710899 57.015900)(53.206898 -90.937698 53.990200)(64.883301 -76.285896 52.691002)(86.056000 9.500000 54.688400)(78.493996 35.100800 52.691002)(83.731804 40.151802 57.093601)(78.493996 35.100800 52.691002)(64.883301 76.285896 52.691002)(74.827995 66.945099 56.433102)(86.764900 72.545097 111.111000)(55.732803 62.135998 124.996994)(91.061005 63.225002 111.111000)(91.115105 62.855900 99.500000)(86.764900 72.545097 111.111000)(91.061005 63.225002 111.111000)(54.416000 44.364002 125.416992)(51.168301 68.315796 124.996994)(47.278000 64.799004 125.185997)(67.893997 96.406898 111.114998)(51.168301 68.315796 124.996994)(55.732803 62.135998 124.996994)(42.185001 62.366001 125.375000)(37.091999 59.934002 125.563995)(46.944000 42.410000 125.835999)(54.416000 44.364002 125.416992)(47.278000 64.799004 125.185997)(42.185001 62.366001 125.375000)(49.501003 0.000000 126.370995)(46.944000 42.410000 125.835999)(39.472000 40.454998 126.255005)(42.185001 -62.366001 125.375000)(37.091999 -59.934002 125.563995)(32.000500 -66.527802 125.379997)(37.091999 -59.934002 125.563995)(46.944000 -42.410000 125.835999)(39.472000 -40.454998 126.255005)(39.472000 -40.454998 126.255005)(49.501003 0.000000 126.370995)(40.750000 0.000000 127.056999)(47.983501 -107.210999 100.992004)(51.113697 -105.412003 111.115997)(31.986099 -109.000000 101.998001)(51.113697 -105.412003 111.115997)(38.340401 -73.971596 125.049995)(31.980398 -109.071999 110.612000)(38.340401 -73.971596 125.049995)(32.000500 -66.527802 125.379997)(31.995401 -74.604301 125.071007)(67.417397 -80.710899 57.015900)(58.651203 -92.101204 60.165901)(53.206898 -90.937698 53.990200)(53.206898 90.937698 53.990200)(67.417397 80.710899 57.015900)(64.883301 76.285896 52.691002)(83.731804 40.151802 57.093601)(78.493996 35.100800 52.691002)(74.827995 66.945099 56.433102)(74.827995 66.945099 56.433102)(64.883301 76.285896 52.691002)(67.417397 80.710899 57.015900)(70.200302 79.271500 115.089996)(86.764900 72.545097 111.111000)(67.893997 96.406898 111.114998)(70.200302 79.271500 115.089996)(67.893997 96.406898 111.114998)(55.732803 62.135998 124.996994)(70.200302 79.271500 115.089996)(55.732803 62.135998 124.996994)(86.764900 72.545097 111.111000)(86.764900 72.545097 111.111000)(91.115105 62.855900 99.500000)(88.890999 68.807495 99.500000)(51.168301 68.315796 124.996994)(38.340401 73.971596 125.049995)(47.278000 64.799004 125.185997)(51.113697 105.412003 111.115997)(51.168301 68.315796 124.996994)(67.893997 96.406898 111.114998)(42.185001 62.366001 125.375000)(32.000500 66.527802 125.379997)(37.091999 59.934002 125.563995)(39.472000 40.454998 126.255005)(46.944000 42.410000 125.835999)(37.091999 59.934002 125.563995)(47.278000 64.799004 125.185997)(38.340401 73.971596 125.049995)(42.185001 62.366001 125.375000)(40.750000 0.000000 127.056999)(49.501003 0.000000 126.370995)(39.472000 40.454998 126.255005)(37.091999 -59.934002 125.563995)(31.998999 -59.401001 125.670998)(32.000500 -66.527802 125.379997)(39.472000 -40.454998 126.255005)(31.998999 -46.101002 126.304001)(37.091999 -59.934002 125.563995)(32.000000 -23.299999 127.318993)(39.472000 -40.454998 126.255005)(40.750000 0.000000 127.056999)(31.980398 -109.071999 110.612000)(31.986099 -109.000000 101.998001)(51.113697 -105.412003 111.115997)(38.340401 -73.971596 125.049995)(31.995401 -74.604301 125.071007)(31.980398 -109.071999 110.612000)(32.000500 -66.527802 125.379997)(-37.563999 0.000000 128.802002)(31.995401 -74.604301 125.071007)(58.651203 -92.101204 60.165901)(43.988201 -101.818001 62.554905)(53.206898 -90.937698 53.990200)(53.206898 90.937698 53.990200)(58.651203 92.101204 60.165901)(67.417397 80.710899 57.015900)(80.067001 84.423203 110.739998)(67.893997 96.406898 111.114998)(86.764900 72.545097 111.111000)(86.764900 72.545097 111.111000)(88.890999 68.807495 99.500000)(85.863098 75.680000 100.202003)(51.168301 68.315796 124.996994)(46.771999 72.111000 124.996002)(38.340401 73.971596 125.049995)(51.113697 105.412003 111.115997)(67.893997 96.406898 111.114998)(56.278999 104.368004 100.992004)(51.168301 68.315796 124.996994)(51.113697 105.412003 111.115997)(46.771999 72.111000 124.996002)(37.091999 59.934002 125.563995)(32.000500 66.527802 125.379997)(31.998999 59.401001 125.670998)(38.340401 73.971596 125.049995)(32.000500 66.527802 125.379997)(37.092800 68.170197 125.256004)(32.000500 66.527802 125.379997)(42.185001 62.366001 125.375000)(37.092800 68.170197 125.256004)(42.185001 62.366001 125.375000)(38.340401 73.971596 125.049995)(37.092800 68.170197 125.256004)(39.472000 40.454998 126.255005)(37.091999 59.934002 125.563995)(31.998999 46.101002 126.304001)(32.000000 23.299999 127.318993)(40.750000 0.000000 127.056999)(39.472000 40.454998 126.255005)(32.000500 -66.527802 125.379997)(31.998999 -59.401001 125.670998)(-37.563999 0.000000 128.802002)(37.091999 -59.934002 125.563995)(31.998999 -46.101002 126.304001)(31.998999 -59.401001 125.670998)(39.472000 -40.454998 126.255005)(32.000000 -38.500000 126.643005)(31.998999 -46.101002 126.304001)(39.472000 -40.454998 126.255005)(32.000000 -23.299999 127.318993)(32.000000 -38.500000 126.643005)(32.000000 -23.299999 127.318993)(40.750000 0.000000 127.056999)(32.000000 0.000000 127.742004)(31.980398 -109.071999 110.612000)(-12.332700 -105.570999 110.740997)(31.986099 -109.000000 101.998001)(31.995401 -74.604301 125.071007)(19.698000 -76.204002 125.000000)(31.980398 -109.071999 110.612000)(31.995401 -74.604301 125.071007)(-37.563999 0.000000 128.802002)(19.698000 -76.204002 125.000000)(43.988201 -101.818001 62.554905)(32.140800 -105.104996 63.342102)(33.112999 -101.930000 56.679699)(53.206898 -90.937698 53.990200)(43.988201 -101.818001 62.554905)(45.529900 -95.866501 54.478199)(43.988201 101.818001 62.554905)(53.206898 90.937698 53.990200)(45.529900 95.866501 54.478199)(53.206898 90.937698 53.990200)(43.988201 101.818001 62.554905)(58.651203 92.101204 60.165901)(74.418205 90.857101 106.054001)(80.067001 84.423203 110.739998)(74.182999 91.999001 100.992004)(74.418205 90.857101 106.054001)(74.182999 91.999001 100.992004)(67.893997 96.406898 111.114998)(74.418205 90.857101 106.054001)(67.893997 96.406898 111.114998)(80.067001 84.423203 110.739998)(80.172005 85.216499 100.992004)(80.067001 84.423203 110.739998)(86.764900 72.545097 111.111000)(85.863098 75.680000 100.202003)(80.172005 85.216499 100.992004)(86.764900 72.545097 111.111000)(46.771999 72.111000 124.996002)(51.113697 105.412003 111.115997)(38.340401 73.971596 125.049995)(65.656502 98.986702 100.992004)(56.278999 104.368004 100.992004)(67.893997 96.406898 111.114998)(51.113697 105.412003 111.115997)(56.278999 104.368004 100.992004)(47.983501 107.210999 100.992004)(31.998999 59.401001 125.670998)(32.000500 66.527802 125.379997)(-37.563999 0.000000 128.802002)(37.091999 59.934002 125.563995)(31.998999 59.401001 125.670998)(31.998999 46.101002 126.304001)(38.340401 73.971596 125.049995)(31.995401 74.604301 125.071007)(32.000500 66.527802 125.379997)(39.472000 40.454998 126.255005)(31.998999 46.101002 126.304001)(32.000000 38.500000 126.643005)(39.472000 40.454998 126.255005)(32.000000 38.500000 126.643005)(32.000000 23.299999 127.318993)(32.000000 23.299999 127.318993)(32.000000 0.000000 127.742004)(40.750000 0.000000 127.056999)(-37.563999 0.000000 128.802002)(31.998999 -59.401001 125.670998)(31.998999 -46.101002 126.304001)(31.998999 -46.101002 126.304001)(32.000000 -38.500000 126.643005)(-37.563999 0.000000 128.802002)(32.000000 -38.500000 126.643005)(32.000000 -23.299999 127.318993)(-37.563999 0.000000 128.802002)(32.000000 -23.299999 127.318993)(32.000000 0.000000 127.742004)(-37.563999 0.000000 128.802002)(5.444000 -75.083504 125.000999)(-12.332700 -105.570999 110.740997)(31.980398 -109.071999 110.612000)(31.986099 -109.000000 101.998001)(-12.332700 -105.570999 110.740997)(-34.333000 -101.409004 110.740997)(19.698000 -76.204002 125.000000)(5.444000 -75.083504 125.000999)(31.980398 -109.071999 110.612000)(19.698000 -76.204002 125.000000)(-37.563999 0.000000 128.802002)(5.444000 -75.083504 125.000999)(11.049900 -105.576996 69.548698)(33.112999 -101.930000 56.679699)(32.140800 -105.104996 63.342102)(33.112999 -101.930000 56.679699)(45.529900 -95.866501 54.478199)(43.988201 -101.818001 62.554905)(33.112999 101.930000 56.679699)(43.988201 101.818001 62.554905)(45.529900 95.866501 54.478199)(80.067001 84.423203 110.739998)(80.172005 85.216499 100.992004)(74.182999 91.999001 100.992004)(74.182999 91.999001 100.992004)(65.656502 98.986702 100.992004)(67.893997 96.406898 111.114998)(31.980398 109.071999 110.612000)(38.340401 73.971596 125.049995)(51.113697 105.412003 111.115997)(51.113697 105.412003 111.115997)(47.983501 107.210999 100.992004)(31.986099 109.000000 101.998001)(32.000500 66.527802 125.379997)(31.995401 74.604301 125.071007)(-37.563999 0.000000 128.802002)(31.998999 46.101002 126.304001)(31.998999 59.401001 125.670998)(-37.563999 0.000000 128.802002)(38.340401 73.971596 125.049995)(31.980398 109.071999 110.612000)(31.995401 74.604301 125.071007)(32.000000 38.500000 126.643005)(31.998999 46.101002 126.304001)(-37.563999 0.000000 128.802002)(32.000000 23.299999 127.318993)(32.000000 38.500000 126.643005)(-37.563999 0.000000 128.802002)(-37.563999 0.000000 128.802002)(32.000000 0.000000 127.742004)(32.000000 23.299999 127.318993)(5.444000 -75.083504 125.000999)(-10.806000 -72.998001 125.000999)(-12.332700 -105.570999 110.740997)(-34.333000 -101.409004 110.740997)(-12.332700 -105.570999 110.740997)(-63.107998 -92.641006 111.518005)(-40.895302 -101.299004 103.098000)(31.986099 -109.000000 101.998001)(-34.333000 -101.409004 110.740997)(5.444000 -75.083504 125.000999)(-37.563999 0.000000 128.802002)(-10.806000 -72.998001 125.000999)(18.596601 -104.157997 58.672501)(33.112999 -101.930000 56.679699)(11.049900 -105.576996 69.548698)(33.112999 101.930000 56.679699)(32.140800 105.104996 63.342102)(43.988201 101.818001 62.554905)(31.980398 109.071999 110.612000)(51.113697 105.412003 111.115997)(31.986099 109.000000 101.998001)(31.995401 74.604301 125.071007)(19.698000 76.204002 125.000000)(-37.563999 0.000000 128.802002)(31.995401 74.604301 125.071007)(31.980398 109.071999 110.612000)(19.698000 76.204002 125.000000)(-10.806000 -72.998001 125.000999)(-28.867001 -69.401001 125.000000)(-12.332700 -105.570999 110.740997)(-52.912998 -62.385002 125.000999)(-63.107998 -92.641006 111.518005)(-12.332700 -105.570999 110.740997)(-63.107998 -92.641006 111.518005)(-77.095505 -88.217499 110.740997)(-34.333000 -101.409004 110.740997)(-99.391495 -78.768501 103.000999)(-40.895302 -101.299004 103.098000)(-34.333000 -101.409004 110.740997)(-10.806000 -72.998001 125.000999)(-37.563999 0.000000 128.802002)(-28.867001 -69.401001 125.000000)(-20.287800 -102.351997 75.336395)(6.444800 -103.478996 60.388199)(11.049900 -105.576996 69.548698)(6.444800 -103.478996 60.388199)(18.596601 -104.157997 58.672501)(11.049900 -105.576996 69.548698)(32.140800 105.104996 63.342102)(33.112999 101.930000 56.679699)(11.049900 105.576996 69.548698)(31.980398 109.071999 110.612000)(31.986099 109.000000 101.998001)(-12.332700 105.570999 110.740997)(5.444000 75.083504 125.000999)(-37.563999 0.000000 128.802002)(19.698000 76.204002 125.000000)(19.698000 76.204002 125.000000)(31.980398 109.071999 110.612000)(5.444000 75.083504 125.000999)(-28.867001 -69.401001 125.000000)(-37.564999 -67.033997 125.000999)(-12.332700 -105.570999 110.740997)(-12.332700 -105.570999 110.740997)(-46.639999 -64.565002 125.000999)(-52.912998 -62.385002 125.000999)(-52.912998 -62.385002 125.000999)(-64.014999 -58.525002 125.000999)(-63.107998 -92.641006 111.518005)(-63.107998 -92.641006 111.518005)(-99.245697 -78.467102 110.740997)(-77.095505 -88.217499 110.740997)(-77.095505 -88.217499 110.740997)(-99.391495 -78.768501 103.000999)(-34.333000 -101.409004 110.740997)(-99.391495 -78.768501 103.000999)(-77.799500 -87.444000 83.959999)(-40.895302 -101.299004 103.098000)(-28.867001 -69.401001 125.000000)(-37.563999 0.000000 128.802002)(-37.564999 -67.033997 125.000999)(6.444800 -103.478996 60.388199)(-20.287800 -102.351997 75.336395)(-1.679900 -102.785995 61.436001)(-40.895302 -101.299004 103.098000)(-63.125000 -92.692001 83.631996)(-34.643200 -99.471100 82.808998)(11.049900 105.576996 69.548698)(33.112999 101.930000 56.679699)(18.596601 104.157997 58.672501)(-12.332700 105.570999 110.740997)(31.986099 109.000000 101.998001)(-34.333000 101.409004 110.740997)(-12.332700 105.570999 110.740997)(5.444000 75.083504 125.000999)(31.980398 109.071999 110.612000)(5.444000 75.083504 125.000999)(-10.806000 72.998001 125.000999)(-37.563999 0.000000 128.802002)(-37.564999 -67.033997 125.000999)(-46.639999 -64.565002 125.000999)(-12.332700 -105.570999 110.740997)(-46.639999 -64.565002 125.000999)(-37.563999 0.000000 128.802002)(-52.912998 -62.385002 125.000999)(-52.912998 -62.385002 125.000999)(-37.563999 0.000000 128.802002)(-64.014999 -58.525002 125.000999)(-75.350998 -53.839001 125.000999)(-63.107998 -92.641006 111.518005)(-64.014999 -58.525002 125.000999)(-86.457001 -48.639000 125.000999)(-99.245697 -78.467102 110.740997)(-63.107998 -92.641006 111.518005)(-99.391495 -78.768501 103.000999)(-77.095505 -88.217499 110.740997)(-99.245697 -78.467102 110.740997)(-77.799500 -87.444000 83.959999)(-63.125000 -92.692001 83.631996)(-40.895302 -101.299004 103.098000)(-99.391495 -78.768501 103.000999)(-100.689003 -77.298996 84.421997)(-77.799500 -87.444000 83.959999)(-37.564999 -67.033997 125.000999)(-37.563999 0.000000 128.802002)(-46.639999 -64.565002 125.000999)(-1.679900 -102.785995 61.436001)(-20.287800 -102.351997 75.336395)(-8.941400 -101.944000 62.374802)(-28.534399 -98.273598 64.660805)(-20.287800 -102.351997 75.336395)(-33.092899 -100.183006 78.662399)(-34.643200 -99.471100 82.808998)(-63.125000 -92.692001 83.631996)(-33.092899 -100.183006 78.662399)(11.049900 105.576996 69.548698)(18.596601 104.157997 58.672501)(6.444800 103.478996 60.388199)(-34.333000 101.409004 110.740997)(31.986099 109.000000 101.998001)(-40.895302 101.299004 103.098000)(-34.333000 101.409004 110.740997)(-63.107998 92.641006 111.518005)(-12.332700 105.570999 110.740997)(-12.332700 105.570999 110.740997)(-10.806000 72.998001 125.000999)(5.444000 75.083504 125.000999)(-10.806000 72.998001 125.000999)(-28.867001 69.401001 125.000000)(-37.563999 0.000000 128.802002)(-64.014999 -58.525002 125.000999)(-37.563999 0.000000 128.802002)(-75.350998 -53.839001 125.000999)(-75.350998 -53.839001 125.000999)(-86.457001 -48.639000 125.000999)(-63.107998 -92.641006 111.518005)(-95.023499 -42.722500 125.000999)(-99.245697 -78.467102 110.740997)(-86.457001 -48.639000 125.000999)(-99.245697 -78.467102 110.740997)(-107.528999 -73.895203 111.111000)(-99.391495 -78.768501 103.000999)(-77.799500 -87.444000 83.959999)(-79.699005 -85.818001 78.146004)(-63.125000 -92.692001 83.631996)(-100.689003 -77.298996 84.421997)(-99.391495 -78.768501 103.000999)(-107.574997 -73.966507 103.000999)(-77.799500 -87.444000 83.959999)(-100.689003 -77.298996 84.421997)(-79.699005 -85.818001 78.146004)(-28.534399 -98.273598 64.660805)(-8.941400 -101.944000 62.374802)(-20.287800 -102.351997 75.336395)(-46.521900 -94.228600 66.603401)(-28.534399 -98.273598 64.660805)(-33.092899 -100.183006 78.662399)(-63.125000 -92.692001 83.631996)(-79.699005 -85.818001 78.146004)(-33.092899 -100.183006 78.662399)(-20.287800 102.351997 75.336395)(11.049900 105.576996 69.548698)(6.444800 103.478996 60.388199)(-40.895302 101.299004 103.098000)(-99.391495 78.768501 103.000999)(-34.333000 101.409004 110.740997)(-12.332700 105.570999 110.740997)(-63.107998 92.641006 111.518005)(-52.912998 62.385002 125.000999)(-77.095505 88.217499 110.740997)(-63.107998 92.641006 111.518005)(-34.333000 101.409004 110.740997)(-10.806000 72.998001 125.000999)(-12.332700 105.570999 110.740997)(-28.867001 69.401001 125.000000)(-37.564999 67.033997 125.000999)(-37.563999 0.000000 128.802002)(-28.867001 69.401001 125.000000)(-75.350998 -53.839001 125.000999)(-37.563999 0.000000 128.802002)(-86.457001 -48.639000 125.000999)(-86.457001 -48.639000 125.000999)(-37.563999 0.000000 128.802002)(-95.023499 -42.722500 125.000999)(-99.245697 -78.467102 110.740997)(-95.023499 -42.722500 125.000999)(-107.528999 -73.895203 111.111000)(-107.528999 -73.895203 111.111000)(-107.574997 -73.966507 103.000999)(-99.391495 -78.768501 103.000999)(-108.177994 -72.914505 84.890503)(-100.689003 -77.298996 84.421997)(-107.574997 -73.966507 103.000999)(-108.177994 -72.914505 84.890503)(-79.699005 -85.818001 78.146004)(-100.689003 -77.298996 84.421997)(-79.699005 -85.818001 78.146004)(-46.521900 -94.228600 66.603401)(-33.092899 -100.183006 78.662399)(6.444800 103.478996 60.388199)(-1.679900 102.785995 61.436001)(-20.287800 102.351997 75.336395)(-40.895302 101.299004 103.098000)(-77.799500 87.444000 83.959999)(-99.391495 78.768501 103.000999)(-77.095505 88.217499 110.740997)(-34.333000 101.409004 110.740997)(-99.391495 78.768501 103.000999)(-52.912998 62.385002 125.000999)(-46.639999 64.565002 125.000999)(-12.332700 105.570999 110.740997)(-52.912998 62.385002 125.000999)(-63.107998 92.641006 111.518005)(-64.014999 58.525002 125.000999)(-99.245697 78.467102 110.740997)(-63.107998 92.641006 111.518005)(-77.095505 88.217499 110.740997)(-12.332700 105.570999 110.740997)(-37.564999 67.033997 125.000999)(-28.867001 69.401001 125.000000)(-37.564999 67.033997 125.000999)(-46.639999 64.565002 125.000999)(-37.563999 0.000000 128.802002)(-95.023499 -42.722500 125.000999)(-37.563999 0.000000 128.802002)(-101.683998 -34.464001 125.000000)(-107.528999 -73.895203 111.111000)(-95.023499 -42.722500 125.000999)(-122.460999 -60.956703 111.111000)(-122.460999 -60.956703 111.111000)(-107.574997 -73.966507 103.000999)(-107.528999 -73.895203 111.111000)(-107.574997 -73.966507 103.000999)(-113.540001 -69.028000 85.162003)(-108.177994 -72.914505 84.890503)(-108.176003 -71.695999 78.146004)(-79.699005 -85.818001 78.146004)(-108.177994 -72.914505 84.890503)(-79.699005 -85.818001 78.146004)(-58.903999 -90.460297 67.765900)(-46.521900 -94.228600 66.603401)(-8.941400 101.944000 62.374802)(-20.287800 102.351997 75.336395)(-1.679900 102.785995 61.436001)(-34.643200 99.471100 82.808998)(-63.125000 92.692001 83.631996)(-40.895302 101.299004 103.098000)(-40.895302 101.299004 103.098000)(-63.125000 92.692001 83.631996)(-77.799500 87.444000 83.959999)(-99.391495 78.768501 103.000999)(-77.799500 87.444000 83.959999)(-100.689003 77.298996 84.421997)(-77.095505 88.217499 110.740997)(-99.391495 78.768501 103.000999)(-99.245697 78.467102 110.740997)(-37.564999 67.033997 125.000999)(-12.332700 105.570999 110.740997)(-46.639999 64.565002 125.000999)(-46.639999 64.565002 125.000999)(-52.912998 62.385002 125.000999)(-37.563999 0.000000 128.802002)(-64.014999 58.525002 125.000999)(-63.107998 92.641006 111.518005)(-75.350998 53.839001 125.000999)(-52.912998 62.385002 125.000999)(-64.014999 58.525002 125.000999)(-37.563999 0.000000 128.802002)(-63.107998 92.641006 111.518005)(-99.245697 78.467102 110.740997)(-86.457001 48.639000 125.000999)(-101.683998 -34.464001 125.000000)(-37.563999 0.000000 128.802002)(-105.720993 -24.664000 125.000999)(-101.683998 -34.464001 125.000000)(-122.460999 -60.956703 111.111000)(-95.023499 -42.722500 125.000999)(-122.525002 -61.012501 103.000999)(-107.574997 -73.966507 103.000999)(-122.460999 -60.956703 111.111000)(-107.574997 -73.966507 103.000999)(-121.297005 -61.535801 85.411499)(-113.540001 -69.028000 85.162003)(-108.177994 -72.914505 84.890503)(-113.540001 -69.028000 85.162003)(-108.176003 -71.695999 78.146004)(-108.176003 -71.695999 78.146004)(-76.484505 -84.369698 69.301498)(-79.699005 -85.818001 78.146004)(-79.699005 -85.818001 78.146004)(-64.909401 -88.640800 68.304802)(-58.903999 -90.460297 67.765900)(-20.287800 102.351997 75.336395)(-8.941400 101.944000 62.374802)(-28.534399 98.273598 64.660805)(-34.643200 99.471100 82.808998)(-33.092899 100.183006 78.662399)(-63.125000 92.692001 83.631996)(-77.799500 87.444000 83.959999)(-63.125000 92.692001 83.631996)(-79.699005 85.818001 78.146004)(-79.699005 85.818001 78.146004)(-100.689003 77.298996 84.421997)(-77.799500 87.444000 83.959999)(-100.689003 77.298996 84.421997)(-107.574997 73.966507 103.000999)(-99.391495 78.768501 103.000999)(-99.245697 78.467102 110.740997)(-99.391495 78.768501 103.000999)(-107.528999 73.895203 111.111000)(-63.107998 92.641006 111.518005)(-86.457001 48.639000 125.000999)(-75.350998 53.839001 125.000999)(-64.014999 58.525002 125.000999)(-75.350998 53.839001 125.000999)(-37.563999 0.000000 128.802002)(-99.245697 78.467102 110.740997)(-95.023499 42.722500 125.000999)(-86.457001 48.639000 125.000999)(-33.092899 100.183006 78.662399)(-20.287800 102.351997 75.336395)(-28.534399 98.273598 64.660805)(-105.720993 -24.664000 125.000999)(-37.563999 0.000000 128.802002)(-107.000999 -15.499001 125.000000)(-101.683998 -34.464001 125.000000)(-105.720993 -24.664000 125.000999)(-131.843002 -46.164597 111.111000)(-101.683998 -34.464001 125.000000)(-131.843002 -46.164597 111.111000)(-122.460999 -60.956703 111.111000)(-121.297005 -61.535801 85.411499)(-107.574997 -73.966507 103.000999)(-122.525002 -61.012501 103.000999)(-122.525002 -61.012501 103.000999)(-122.460999 -60.956703 111.111000)(-131.843002 -46.164597 111.111000)(-121.297005 -61.535801 85.411499)(-119.723000 -61.626999 78.146004)(-113.540001 -69.028000 85.162003)(-113.540001 -69.028000 85.162003)(-119.723000 -61.626999 78.146004)(-108.176003 -71.695999 78.146004)(-108.176003 -71.695999 78.146004)(-87.256599 -79.376694 68.048599)(-76.484505 -84.369698 69.301498)(-79.699005 -85.818001 78.146004)(-76.484505 -84.369698 69.301498)(-64.909401 -88.640800 68.304802)(-33.092899 100.183006 78.662399)(-79.699005 85.818001 78.146004)(-63.125000 92.692001 83.631996)(-100.689003 77.298996 84.421997)(-79.699005 85.818001 78.146004)(-108.177994 72.914505 84.890503)(-100.689003 77.298996 84.421997)(-108.177994 72.914505 84.890503)(-107.574997 73.966507 103.000999)(-107.528999 73.895203 111.111000)(-99.391495 78.768501 103.000999)(-107.574997 73.966507 103.000999)(-107.528999 73.895203 111.111000)(-95.023499 42.722500 125.000999)(-99.245697 78.467102 110.740997)(-37.563999 0.000000 128.802002)(-75.350998 53.839001 125.000999)(-86.457001 48.639000 125.000999)(-37.563999 0.000000 128.802002)(-86.457001 48.639000 125.000999)(-95.023499 42.722500 125.000999)(-33.092899 100.183006 78.662399)(-28.534399 98.273598 64.660805)(-46.521900 94.228600 66.603401)(-107.000999 -15.499001 125.000000)(-37.563999 0.000000 128.802002)(-107.000999 15.499001 125.000000)(-107.000999 -15.499001 125.000000)(-138.042999 -27.235201 111.111000)(-105.720993 -24.664000 125.000999)(-131.843002 -46.164597 111.111000)(-105.720993 -24.664000 125.000999)(-138.042999 -27.235201 111.111000)(-129.090988 -50.981998 85.466499)(-121.297005 -61.535801 85.411499)(-122.525002 -61.012501 103.000999)(-122.525002 -61.012501 103.000999)(-131.843002 -46.164597 111.111000)(-133.220001 -44.370499 103.000999)(-121.297005 -61.535801 85.411499)(-128.703995 -49.460003 78.146004)(-119.723000 -61.626999 78.146004)(-119.723000 -61.626999 78.146004)(-100.321999 -72.741798 70.787102)(-108.176003 -71.695999 78.146004)(-108.176003 -71.695999 78.146004)(-100.321999 -72.741798 70.787102)(-87.256599 -79.376694 68.048599)(-33.092899 100.183006 78.662399)(-46.521900 94.228600 66.603401)(-79.699005 85.818001 78.146004)(-108.177994 72.914505 84.890503)(-79.699005 85.818001 78.146004)(-108.176003 71.695999 78.146004)(-107.574997 73.966507 103.000999)(-108.177994 72.914505 84.890503)(-113.540001 69.028000 85.162003)(-107.528999 73.895203 111.111000)(-107.574997 73.966507 103.000999)(-122.460999 60.956703 111.111000)(-95.023499 42.722500 125.000999)(-107.528999 73.895203 111.111000)(-122.460999 60.956703 111.111000)(-101.683998 34.464001 125.000000)(-37.563999 0.000000 128.802002)(-95.023499 42.722500 125.000999)(-37.563999 0.000000 128.802002)(-105.720993 24.664000 125.000999)(-107.000999 15.499001 125.000000)(-107.000999 -15.499001 125.000000)(-107.000999 15.499001 125.000000)(-139.541992 -15.499001 111.111000)(-107.000999 -15.499001 125.000000)(-139.541992 -15.499001 111.111000)(-138.042999 -27.235201 111.111000)(-131.843002 -46.164597 111.111000)(-138.042999 -27.235201 111.111000)(-133.220001 -44.370499 103.000999)(-128.703995 -49.460003 78.146004)(-121.297005 -61.535801 85.411499)(-129.090988 -50.981998 85.466499)(-129.090988 -50.981998 85.466499)(-122.525002 -61.012501 103.000999)(-133.220001 -44.370499 103.000999)(-123.637001 -55.118099 75.242805)(-128.703995 -49.460003 78.146004)(-123.153000 -54.568001 72.339500)(-123.637001 -55.118099 75.242805)(-123.153000 -54.568001 72.339500)(-119.723000 -61.626999 78.146004)(-123.637001 -55.118099 75.242805)(-119.723000 -61.626999 78.146004)(-128.703995 -49.460003 78.146004)(-119.723000 -61.626999 78.146004)(-106.402000 -68.350502 71.422104)(-100.321999 -72.741798 70.787102)(-46.521900 94.228600 66.603401)(-58.903999 90.460297 67.765900)(-79.699005 85.818001 78.146004)(-76.484505 84.369698 69.301498)(-108.176003 71.695999 78.146004)(-79.699005 85.818001 78.146004)(-113.540001 69.028000 85.162003)(-108.177994 72.914505 84.890503)(-108.176003 71.695999 78.146004)(-107.574997 73.966507 103.000999)(-113.540001 69.028000 85.162003)(-121.297005 61.535801 85.411499)(-107.574997 73.966507 103.000999)(-122.525002 61.012501 103.000999)(-122.460999 60.956703 111.111000)(-95.023499 42.722500 125.000999)(-122.460999 60.956703 111.111000)(-101.683998 34.464001 125.000000)(-105.720993 24.664000 125.000999)(-37.563999 0.000000 128.802002)(-101.683998 34.464001 125.000000)(-107.000999 15.499001 125.000000)(-105.720993 24.664000 125.000999)(-138.042999 27.235201 111.111000)(-107.000999 15.499001 125.000000)(-139.541992 15.499001 111.111000)(-139.541992 -15.499001 111.111000)(-138.042999 -27.235201 111.111000)(-139.541992 -15.499001 111.111000)(-138.794006 -25.389999 103.000999)(-133.220001 -44.370499 103.000999)(-138.042999 -27.235201 111.111000)(-138.794006 -25.389999 103.000999)(-129.090988 -50.981998 85.466499)(-133.236008 -42.855000 85.320000)(-128.703995 -49.460003 78.146004)(-133.236008 -42.855000 85.320000)(-129.090988 -50.981998 85.466499)(-133.220001 -44.370499 103.000999)(-127.956001 -47.260700 72.575302)(-123.153000 -54.568001 72.339500)(-128.703995 -49.460003 78.146004)(-119.723000 -61.626999 78.146004)(-123.153000 -54.568001 72.339500)(-115.643997 -63.428799 71.991402)(-115.643997 -63.428799 71.991402)(-106.402000 -68.350502 71.422104)(-119.723000 -61.626999 78.146004)(-58.903999 90.460297 67.765900)(-64.909401 88.640800 68.304802)(-79.699005 85.818001 78.146004)(-76.484505 84.369698 69.301498)(-87.256599 79.376694 68.048599)(-108.176003 71.695999 78.146004)(-79.699005 85.818001 78.146004)(-64.909401 88.640800 68.304802)(-76.484505 84.369698 69.301498)(-113.540001 69.028000 85.162003)(-108.176003 71.695999 78.146004)(-119.723000 61.626999 78.146004)(-107.574997 73.966507 103.000999)(-121.297005 61.535801 85.411499)(-122.525002 61.012501 103.000999)(-113.540001 69.028000 85.162003)(-119.723000 61.626999 78.146004)(-121.297005 61.535801 85.411499)(-122.525002 61.012501 103.000999)(-131.843002 46.164597 111.111000)(-122.460999 60.956703 111.111000)(-122.460999 60.956703 111.111000)(-131.843002 46.164597 111.111000)(-101.683998 34.464001 125.000000)(-101.683998 34.464001 125.000000)(-131.843002 46.164597 111.111000)(-105.720993 24.664000 125.000999)(-105.720993 24.664000 125.000999)(-131.843002 46.164597 111.111000)(-138.042999 27.235201 111.111000)(-107.000999 15.499001 125.000000)(-138.042999 27.235201 111.111000)(-139.541992 15.499001 111.111000)(-139.541992 15.499001 111.111000)(-140.000000 -8.516000 101.000999)(-139.541992 -15.499001 111.111000)(-139.750000 -15.499001 102.000999)(-138.794006 -25.389999 103.000999)(-139.541992 -15.499001 111.111000)(-137.310989 -30.674000 84.880997)(-133.220001 -44.370499 103.000999)(-138.794006 -25.389999 103.000999)(-132.447006 -42.843300 81.733002)(-134.865005 -35.636002 78.146004)(-128.703995 -49.460003 78.146004)(-132.447006 -42.843300 81.733002)(-128.703995 -49.460003 78.146004)(-133.236008 -42.855000 85.320000)(-132.447006 -42.843300 81.733002)(-133.236008 -42.855000 85.320000)(-134.865005 -35.636002 78.146004)(-135.537003 -36.309002 85.096001)(-133.236008 -42.855000 85.320000)(-133.220001 -44.370499 103.000999)(-127.956001 -47.260700 72.575302)(-128.703995 -49.460003 78.146004)(-134.865005 -35.636002 78.146004)(-127.956001 -47.260700 72.575302)(-127.956001 47.260700 72.575302)(-123.153000 -54.568001 72.339500)(-115.643997 -63.428799 71.991402)(-123.153000 -54.568001 72.339500)(-115.411995 -52.719002 71.834000)(-106.402000 -68.350502 71.422104)(-115.643997 -63.428799 71.991402)(-111.276001 -59.601002 71.605507)(-87.256599 79.376694 68.048599)(-100.321999 72.741798 70.787102)(-108.176003 71.695999 78.146004)(-108.176003 71.695999 78.146004)(-100.321999 72.741798 70.787102)(-119.723000 61.626999 78.146004)(-121.297005 61.535801 85.411499)(-129.090988 50.981998 85.466499)(-122.525002 61.012501 103.000999)(-128.703995 49.460003 78.146004)(-121.297005 61.535801 85.411499)(-119.723000 61.626999 78.146004)(-131.843002 46.164597 111.111000)(-122.525002 61.012501 103.000999)(-133.220001 44.370499 103.000999)(-138.042999 27.235201 111.111000)(-131.843002 46.164597 111.111000)(-133.220001 44.370499 103.000999)(-138.794006 25.389999 103.000999)(-139.541992 15.499001 111.111000)(-138.042999 27.235201 111.111000)(-139.541992 15.499001 111.111000)(-140.000000 8.516000 101.000999)(-140.000000 -8.516000 101.000999)(-140.000000 -8.516000 101.000999)(-139.750000 -15.499001 102.000999)(-139.541992 -15.499001 111.111000)(-138.422989 -23.705999 84.464203)(-138.794006 -25.389999 103.000999)(-139.750000 -15.499001 102.000999)(-138.422989 -23.705999 84.464203)(-137.310989 -30.674000 84.880997)(-138.794006 -25.389999 103.000999)(-133.220001 -44.370499 103.000999)(-137.310989 -30.674000 84.880997)(-135.537003 -36.309002 85.096001)(-133.236008 -42.855000 85.320000)(-135.537003 -36.309002 85.096001)(-134.865005 -35.636002 78.146004)(-127.956001 -47.260700 72.575302)(-134.865005 -35.636002 78.146004)(-131.410004 -39.997902 72.722900)(-123.153000 54.568001 72.339500)(-123.153000 -54.568001 72.339500)(-127.956001 47.260700 72.575302)(-127.956001 47.260700 72.575302)(-127.956001 -47.260700 72.575302)(-131.410004 39.997902 72.722900)(-111.276001 -59.601002 71.605507)(-115.643997 -63.428799 71.991402)(-115.411995 -52.719002 71.834000)(-115.411995 -52.719002 71.834000)(-123.153000 -54.568001 72.339500)(-118.166000 -45.432003 71.979996)(-100.321999 72.741798 70.787102)(-106.402000 68.350502 71.422104)(-119.723000 61.626999 78.146004)(-128.703995 49.460003 78.146004)(-129.090988 50.981998 85.466499)(-121.297005 61.535801 85.411499)(-133.220001 44.370499 103.000999)(-122.525002 61.012501 103.000999)(-129.090988 50.981998 85.466499)(-123.637001 55.118099 75.242805)(-123.153000 54.568001 72.339500)(-128.703995 49.460003 78.146004)(-123.637001 55.118099 75.242805)(-128.703995 49.460003 78.146004)(-119.723000 61.626999 78.146004)(-123.637001 55.118099 75.242805)(-119.723000 61.626999 78.146004)(-123.153000 54.568001 72.339500)(-138.042999 27.235201 111.111000)(-133.220001 44.370499 103.000999)(-138.794006 25.389999 103.000999)(-139.750000 15.499001 102.000999)(-139.541992 15.499001 111.111000)(-138.794006 25.389999 103.000999)(-139.750000 15.499001 102.000999)(-140.000000 8.516000 101.000999)(-139.541992 15.499001 111.111000)(-140.000000 8.516000 101.000999)(-139.000000 -15.499001 83.858002)(-140.000000 -8.516000 101.000999)(-139.000000 -15.499001 83.858002)(-139.750000 -15.499001 102.000999)(-140.000000 -8.516000 101.000999)(-139.000000 -15.499001 83.858002)(-138.422989 -23.705999 84.464203)(-139.750000 -15.499001 102.000999)(-137.932999 -20.583000 78.146004)(-137.310989 -30.674000 84.880997)(-138.422989 -23.705999 84.464203)(-135.537003 -36.309002 85.096001)(-137.310989 -30.674000 84.880997)(-134.865005 -35.636002 78.146004)(-134.865005 -35.636002 78.146004)(-134.247009 -32.984200 72.878304)(-131.410004 -39.997902 72.722900)(-131.410004 -39.997902 72.722900)(-131.410004 39.997902 72.722900)(-127.956001 -47.260700 72.575302)(-127.956001 47.260700 72.575302)(-128.703995 49.460003 78.146004)(-123.153000 54.568001 72.339500)(-123.153000 -54.568001 72.339500)(-123.153000 54.568001 72.339500)(-119.664001 -38.846001 72.057999)(-127.956001 47.260700 72.575302)(-131.410004 39.997902 72.722900)(-134.865005 35.636002 78.146004)(-118.166000 -45.432003 71.979996)(-123.153000 -54.568001 72.339500)(-119.664001 -38.846001 72.057999)(-106.402000 68.350502 71.422104)(-115.643997 63.428799 71.991402)(-119.723000 61.626999 78.146004)(-133.236008 42.855000 85.320000)(-129.090988 50.981998 85.466499)(-128.703995 49.460003 78.146004)(-129.090988 50.981998 85.466499)(-133.236008 42.855000 85.320000)(-133.220001 44.370499 103.000999)(-115.643997 63.428799 71.991402)(-123.153000 54.568001 72.339500)(-119.723000 61.626999 78.146004)(-138.794006 25.389999 103.000999)(-133.220001 44.370499 103.000999)(-137.310989 30.674000 84.880997)(-138.422989 23.705999 84.464203)(-139.750000 15.499001 102.000999)(-138.794006 25.389999 103.000999)(-139.000000 15.499001 83.858002)(-140.000000 8.516000 101.000999)(-139.750000 15.499001 102.000999)(-140.000000 8.516000 101.000999)(-139.000000 15.499001 83.858002)(-139.000000 -15.499001 83.858002)(-137.932999 -20.583000 78.146004)(-138.422989 -23.705999 84.464203)(-139.000000 -15.499001 83.858002)(-137.932999 -20.583000 78.146004)(-134.865005 -35.636002 78.146004)(-137.310989 -30.674000 84.880997)(-137.932999 -20.583000 78.146004)(-134.247009 -32.984200 72.878304)(-134.865005 -35.636002 78.146004)(-134.247009 -32.984200 72.878304)(-134.247009 32.984200 72.878304)(-131.410004 -39.997902 72.722900)(-131.410004 39.997902 72.722900)(-131.410004 -39.997902 72.722900)(-134.247009 32.984200 72.878304)(-134.865005 35.636002 78.146004)(-128.703995 49.460003 78.146004)(-127.956001 47.260700 72.575302)(-119.664001 38.846001 72.057999)(-119.664001 -38.846001 72.057999)(-123.153000 54.568001 72.339500)(-134.865005 35.636002 78.146004)(-131.410004 39.997902 72.722900)(-134.247009 32.984200 72.878304)(-111.276001 59.601002 71.605507)(-115.643997 63.428799 71.991402)(-106.402000 68.350502 71.422104)(-128.703995 49.460003 78.146004)(-134.865005 35.636002 78.146004)(-132.447006 42.843300 81.733002)(-134.865005 35.636002 78.146004)(-133.236008 42.855000 85.320000)(-132.447006 42.843300 81.733002)(-133.236008 42.855000 85.320000)(-128.703995 49.460003 78.146004)(-132.447006 42.843300 81.733002)(-133.236008 42.855000 85.320000)(-135.537003 36.309002 85.096001)(-133.220001 44.370499 103.000999)(-115.411995 52.719002 71.834000)(-123.153000 54.568001 72.339500)(-115.643997 63.428799 71.991402)(-135.537003 36.309002 85.096001)(-137.310989 30.674000 84.880997)(-133.220001 44.370499 103.000999)(-137.310989 30.674000 84.880997)(-138.422989 23.705999 84.464203)(-138.794006 25.389999 103.000999)(-138.422989 23.705999 84.464203)(-139.000000 15.499001 83.858002)(-139.750000 15.499001 102.000999)(-139.000000 15.499001 83.858002)(-137.932999 -20.583000 78.146004)(-139.000000 -15.499001 83.858002)(-134.247009 -32.984200 72.878304)(-137.932999 -20.583000 78.146004)(-135.649002 -27.183199 72.905098)(-134.247009 32.984200 72.878304)(-134.247009 -32.984200 72.878304)(-135.649002 27.183199 72.905098)(-118.166000 45.432003 71.979996)(-119.664001 38.846001 72.057999)(-123.153000 54.568001 72.339500)(-137.932999 20.583000 78.146004)(-134.865005 35.636002 78.146004)(-134.247009 32.984200 72.878304)(-115.411995 52.719002 71.834000)(-115.643997 63.428799 71.991402)(-111.276001 59.601002 71.605507)(-134.865005 35.636002 78.146004)(-135.537003 36.309002 85.096001)(-133.236008 42.855000 85.320000)(-118.166000 45.432003 71.979996)(-123.153000 54.568001 72.339500)(-115.411995 52.719002 71.834000)(-134.865005 35.636002 78.146004)(-137.310989 30.674000 84.880997)(-135.537003 36.309002 85.096001)(-137.932999 20.583000 78.146004)(-138.422989 23.705999 84.464203)(-137.310989 30.674000 84.880997)(-137.932999 20.583000 78.146004)(-139.000000 15.499001 83.858002)(-138.422989 23.705999 84.464203)(-139.000000 15.499001 83.858002)(-137.932999 20.583000 78.146004)(-137.932999 -20.583000 78.146004)(-137.932999 -20.583000 78.146004)(-136.356995 -21.594400 72.934601)(-135.649002 -27.183199 72.905098)(-135.649002 -27.183199 72.905098)(-135.649002 27.183199 72.905098)(-134.247009 -32.984200 72.878304)(-135.649002 27.183199 72.905098)(-137.932999 20.583000 78.146004)(-134.247009 32.984200 72.878304)(-137.310989 30.674000 84.880997)(-134.865005 35.636002 78.146004)(-137.932999 20.583000 78.146004)(-137.932999 -20.583000 78.146004)(-137.932999 20.583000 78.146004)(-137.209991 -4.731200 73.068001)(-136.692993 -16.414299 72.948906)(-136.356995 -21.594400 72.934601)(-137.932999 -20.583000 78.146004)(-136.356995 -21.594400 72.934601)(-136.356995 21.594400 72.934601)(-135.649002 -27.183199 72.905098)(-135.649002 27.183199 72.905098)(-135.649002 -27.183199 72.905098)(-136.356995 21.594400 72.934601)(-136.356995 21.594400 72.934601)(-137.932999 20.583000 78.146004)(-135.649002 27.183199 72.905098)(-137.209991 4.731200 73.068001)(-137.209991 -4.731200 73.068001)(-137.932999 20.583000 78.146004)(-137.209991 -4.731200 73.068001)(-136.692993 -16.414299 72.948906)(-137.932999 -20.583000 78.146004)(-136.692993 -16.414299 72.948906)(-136.692993 16.414299 72.948906)(-136.356995 -21.594400 72.934601)(-136.356995 21.594400 72.934601)(-136.356995 -21.594400 72.934601)(-136.692993 16.414299 72.948906)(-136.356995 21.594400 72.934601)(-136.692993 16.414299 72.948906)(-137.932999 20.583000 78.146004)(-137.932999 20.583000 78.146004)(-136.692993 16.414299 72.948906)(-137.209991 4.731200 73.068001)(-137.209991 -4.731200 73.068001)(-137.209991 4.731200 73.068001)(-136.692993 -16.414299 72.948906)(-136.692993 16.414299 72.948906)(-136.692993 -16.414299 72.948906)(-137.209991 4.731200 73.068001)(80.653999 -60.045002 93.608002)(81.005997 -64.062996 95.737999)(80.365997 -56.749001 90.467995)(80.365997 -56.749001 90.467995)(80.057999 -53.227001 82.149994)(80.162003 -54.418003 86.552002)(80.365997 -56.749001 90.467995)(81.005997 -64.062996 95.737999)(80.057999 -53.227001 82.149994)(81.028000 -64.310997 64.172997)(80.061005 -53.263000 77.587997)(80.057999 -53.227001 82.149994)(81.005997 -64.062996 95.737999)(81.028000 -64.310997 64.172997)(80.057999 -53.227001 82.149994)(80.170998 -54.522999 73.206001)(80.061005 -53.263000 77.587997)(80.673004 -60.260002 66.239998)(80.061005 -53.263000 77.587997)(81.028000 -64.310997 64.172997)(80.673004 -60.260002 66.239998)(81.028000 -64.310997 64.172997)(81.005997 -64.062996 95.737999)(81.394005 -68.504997 96.701004)(81.028000 -64.310997 64.172997)(81.394005 -68.504997 96.701004)(81.791000 -73.041000 96.426003)(80.170998 -54.522999 73.206001)(80.673004 -60.260002 66.239998)(80.379997 -56.915001 69.326996)(81.791000 -73.041000 96.426003)(82.167000 -77.334999 94.931999)(81.028000 -64.310997 64.172997)(82.746994 -83.962997 88.816002)(82.167000 -77.334999 94.931999)(82.492996 -81.068001 92.331001)(81.417000 -68.768005 63.280003)(81.028000 -64.310997 64.172997)(81.813995 -73.298996 63.628002)(81.028000 -64.310997 64.172997)(82.167000 -77.334999 94.931999)(82.746994 -83.962997 88.816002)(82.186996 -77.569000 65.188995)(81.813995 -73.298996 63.628002)(82.510002 -81.260002 67.848999)(81.813995 -73.298996 63.628002)(81.028000 -64.310997 64.172997)(82.759003 -84.099998 71.410004)(82.746994 -83.962997 88.816002)(82.759003 -84.099998 71.410004)(81.028000 -64.310997 64.172997)(82.965004 -86.460999 80.132004)(82.759003 -84.099998 71.410004)(82.907997 -85.807007 84.646004)(82.759003 -84.099998 71.410004)(82.746994 -83.962997 88.816002)(82.907997 -85.807007 84.646004)(81.813995 -73.298996 63.628002)(82.759003 -84.099998 71.410004)(82.510002 -81.260002 67.848999)(82.914001 -85.877998 75.608002)(82.759003 -84.099998 71.410004)(82.965004 -86.460999 80.132004)(80.186005 55.697998 87.178001)(80.067001 54.327999 82.828003)(80.403999 58.187000 90.994995)(80.147995 55.258999 73.838005)(80.067001 54.327999 82.828003)(80.053001 54.178001 78.268997)(81.849998 74.708000 96.278000)(80.403999 58.187000 90.994995)(80.067001 54.327999 82.828003)(81.849998 74.708000 96.278000)(80.702995 61.608002 93.996002)(80.403999 58.187000 90.994995)(80.147995 55.258999 73.838005)(80.343002 57.489998 69.865005)(80.067001 54.327999 82.828003)(82.220001 78.937004 94.609001)(81.849998 74.708000 96.278000)(80.067001 54.327999 82.828003)(81.849998 74.708000 96.278000)(81.061996 65.709999 95.959999)(80.702995 61.608002 93.996002)(80.971001 64.669998 64.411003)(81.358002 69.086998 63.335999)(80.625000 60.707001 66.642998)(80.343002 57.489998 69.865005)(80.625000 60.707001 66.642998)(80.067001 54.327999 82.828003)(82.220001 78.937004 94.609001)(80.067001 54.327999 82.828003)(82.924004 86.983002 83.984001)(81.849998 74.708000 96.278000)(81.454002 70.187004 96.739998)(81.061996 65.709999 95.959999)(81.754997 73.627998 63.496998)(82.134003 77.958000 64.880997)(81.358002 69.086998 63.335999)(80.067001 54.327999 82.828003)(80.625000 60.707001 66.642998)(81.358002 69.086998 63.335999)(82.924004 86.983002 83.984001)(80.067001 54.327999 82.828003)(82.965004 87.452003 79.445999)(82.537003 82.561005 91.857002)(82.220001 78.937004 94.609001)(82.924004 86.983002 83.984001)(82.965004 87.452003 79.445999)(81.358002 69.086998 63.335999)(82.134003 77.958000 64.880997)(82.134003 77.958000 64.880997)(82.465996 81.754997 67.387001)(82.965004 87.452003 79.445999)(82.965004 87.452003 79.445999)(80.067001 54.327999 82.828003)(81.515900 70.889999 73.082001)(80.067001 54.327999 82.828003)(81.358002 69.086998 63.335999)(81.515900 70.889999 73.082001)(81.358002 69.086998 63.335999)(82.965004 87.452003 79.445999)(81.515900 70.889999 73.082001)(82.537003 82.561005 91.857002)(82.924004 86.983002 83.984001)(82.777000 85.311005 88.224998)(82.465996 81.754997 67.387001)(82.726997 84.737999 70.828995)(82.965004 87.452003 79.445999)(82.965004 87.452003 79.445999)(82.726997 84.737999 70.828995)(82.897003 86.685005 74.950005)(51.999001 -58.038998 92.727997)(51.999001 -53.734001 86.889000)(97.436501 -35.610798 91.327507)(51.999001 -58.038998 92.727997)(97.436501 -35.610798 91.327507)(96.996002 -40.187000 95.039001)(97.804596 -33.058899 87.280197)(97.436501 -35.610798 91.327507)(51.999001 -53.734001 86.889000)(97.436501 -35.610798 91.327507)(99.590500 -22.541000 101.000000)(96.996002 -40.187000 95.039001)(96.996002 -40.187000 95.039001)(51.999001 -64.483002 96.629997)(51.999001 -58.038998 92.727997)(99.590500 -22.541000 101.000000)(97.436501 -35.610798 91.327507)(97.804596 -33.058899 87.280197)(51.999001 -53.734001 86.889000)(51.999001 -52.222000 80.000000)(97.804596 -33.058899 87.280197)(96.996002 -40.187000 95.039001)(99.590500 -22.541000 101.000000)(96.291901 -44.521000 98.903595)(51.999001 -64.483002 96.629997)(96.996002 -40.187000 95.039001)(96.291901 -44.521000 98.903595)(99.926003 -9.500000 99.068497)(99.590500 -22.541000 101.000000)(97.804596 -33.058899 87.280197)(51.999001 -52.222000 80.000000)(96.209198 -31.883900 79.223495)(97.804596 -33.058899 87.280197)(51.999001 -73.791496 98.000000)(51.999001 -64.483002 96.629997)(96.291901 -44.521000 98.903595)(51.999001 -53.734001 73.112007)(96.209198 -31.883900 79.223495)(51.999001 -52.222000 80.000000)(99.323700 -9.500000 91.039001)(99.926003 -9.500000 99.068497)(97.804596 -33.058899 87.280197)(97.804596 -33.058899 87.280197)(96.209198 -31.883900 79.223495)(99.323700 -9.500000 91.039001)(91.115105 -62.855900 99.500000)(51.999001 -73.791496 98.000000)(96.291901 -44.521000 98.903595)(92.589203 -35.396198 72.139999)(51.999001 -53.734001 73.112007)(51.999001 -58.038998 67.272003)(51.999001 -53.734001 73.112007)(92.589203 -35.396198 72.139999)(96.209198 -31.883900 79.223495)(99.323700 9.500000 91.039001)(99.926003 -9.500000 99.068497)(99.323700 -9.500000 91.039001)(98.497002 -9.500000 84.927002)(99.323700 -9.500000 91.039001)(96.209198 -31.883900 79.223495)(88.890999 -68.807495 99.500000)(51.999001 -73.791496 98.000000)(91.115105 -62.855900 99.500000)(82.298004 -81.828499 96.765999)(51.999001 -82.388000 96.629997)(51.999001 -73.791496 98.000000)(88.838303 -42.063499 66.603195)(51.999001 -58.038998 67.272003)(51.999001 -64.483002 63.371002)(88.838303 -42.063499 66.603195)(92.589203 -35.396198 72.139999)(51.999001 -58.038998 67.272003)(96.209198 -31.883900 79.223495)(92.589203 -35.396198 72.139999)(91.955002 -26.450001 67.496002)(99.323700 9.500000 91.039001)(99.926003 9.500000 99.068497)(99.926003 -9.500000 99.068497)(98.497002 9.500000 84.927002)(99.323700 9.500000 91.039001)(99.323700 -9.500000 91.039001)(96.897499 -9.500000 78.332001)(98.497002 -9.500000 84.927002)(96.209198 -31.883900 79.223495)(98.497002 9.500000 84.927002)(99.323700 -9.500000 91.039001)(98.497002 -9.500000 84.927002)(88.890999 -68.807495 99.500000)(85.863098 -75.680000 100.202003)(51.999001 -73.791496 98.000000)(82.298004 -81.828499 96.765999)(51.999001 -88.228004 92.727997)(51.999001 -82.388000 96.629997)(85.863098 -75.680000 100.202003)(82.298004 -81.828499 96.765999)(51.999001 -73.791496 98.000000)(51.999001 -88.228004 92.727997)(51.999001 -92.129997 86.889000)(51.999001 -86.856094 90.354500)(51.999001 -92.129997 86.889000)(51.999001 -86.649704 88.819901)(51.999001 -86.856094 90.354500)(85.219505 -49.765503 63.199497)(51.999001 -64.483002 63.371002)(51.999001 -73.791496 62.000000)(51.999001 -64.483002 63.371002)(85.219505 -49.765503 63.199497)(88.838303 -42.063499 66.603195)(91.955002 -26.450001 67.496002)(92.589203 -35.396198 72.139999)(88.838303 -42.063499 66.603195)(96.897499 -9.500000 78.332001)(96.209198 -31.883900 79.223495)(91.955002 -26.450001 67.496002)(97.804596 33.058899 87.280197)(99.926003 9.500000 99.068497)(99.323700 9.500000 91.039001)(99.323700 9.500000 91.039001)(98.497002 9.500000 84.927002)(96.209198 31.883900 79.223495)(96.897499 9.500000 78.332001)(98.497002 -9.500000 84.927002)(96.897499 -9.500000 78.332001)(96.897499 9.500000 78.332001)(98.497002 9.500000 84.927002)(98.497002 -9.500000 84.927002)(82.298004 -81.828499 96.765999)(77.864807 -87.469299 93.317802)(51.999001 -88.228004 92.727997)(85.863098 -75.680000 100.202003)(80.172005 -85.216499 100.992004)(82.298004 -81.828499 96.765999)(51.999001 -92.129997 86.889000)(51.999001 -88.228004 92.727997)(73.108894 -91.675903 87.547798)(51.999001 -88.511101 84.646004)(51.999001 -86.772598 88.547501)(51.999001 -92.129997 86.889000)(51.999001 -86.772598 88.547501)(51.999001 -86.652901 88.816002)(51.999001 -92.129997 86.889000)(51.999001 -92.129997 86.889000)(51.999001 -86.649704 88.819901)(51.999001 -86.652901 88.816002)(51.999001 -92.129997 86.889000)(51.999001 -93.500000 80.000000)(51.999001 -90.074799 84.409996)(51.999001 -93.500000 80.000000)(51.999001 -88.795807 82.696106)(51.999001 -90.074799 84.409996)(51.999001 -88.511101 84.646004)(51.999001 -92.129997 86.889000)(51.999001 -90.074799 84.409996)(51.999001 -73.791496 62.000000)(51.999001 -82.388000 63.371002)(80.540901 -60.279999 61.111500)(51.999001 -73.791496 62.000000)(80.540901 -60.279999 61.111500)(85.219505 -49.765503 63.199497)(83.731804 -40.151802 57.093601)(88.838303 -42.063499 66.603195)(85.219505 -49.765503 63.199497)(91.955002 -26.450001 67.496002)(88.838303 -42.063499 66.603195)(83.731804 -40.151802 57.093601)(94.705002 -9.500000 71.813004)(96.897499 -9.500000 78.332001)(91.955002 -26.450001 67.496002)(99.323700 9.500000 91.039001)(96.209198 31.883900 79.223495)(97.804596 33.058899 87.280197)(97.804596 33.058899 87.280197)(99.590500 22.541000 101.000000)(99.926003 9.500000 99.068497)(96.209198 31.883900 79.223495)(98.497002 9.500000 84.927002)(96.897499 9.500000 78.332001)(94.705002 9.500000 71.813004)(96.897499 9.500000 78.332001)(96.897499 -9.500000 78.332001)(51.999001 -88.228004 92.727997)(77.864807 -87.469299 93.317802)(73.108894 -91.675903 87.547798)(80.172005 -85.216499 100.992004)(77.864807 -87.469299 93.317802)(80.198494 -84.734795 97.154900)(77.864807 -87.469299 93.317802)(82.298004 -81.828499 96.765999)(80.198494 -84.734795 97.154900)(82.298004 -81.828499 96.765999)(80.172005 -85.216499 100.992004)(80.198494 -84.734795 97.154900)(51.999001 -92.129997 86.889000)(73.108894 -91.675903 87.547798)(68.789001 -93.382004 79.306496)(51.999001 -93.500000 80.000000)(51.999001 -92.129997 86.889000)(68.789001 -93.382004 79.306496)(51.999001 -89.170097 80.132004)(51.999001 -88.795807 82.696106)(51.999001 -93.500000 80.000000)(51.999001 -93.500000 80.000000)(51.999001 -92.129997 73.112007)(51.999001 -91.071800 77.903999)(51.999001 -92.129997 73.112007)(51.999001 -88.643600 76.077698)(51.999001 -91.071800 77.903999)(51.999001 -88.643600 76.077698)(51.999001 -89.135902 79.869003)(51.999001 -91.071800 77.903999)(51.999001 -89.135902 79.869003)(51.999001 -89.170097 80.132004)(51.999001 -91.071800 77.903999)(51.999001 -89.170097 80.132004)(51.999001 -93.500000 80.000000)(51.999001 -91.071800 77.903999)(51.999001 -88.475304 75.356697)(51.999001 -88.582596 75.608002)(51.999001 -92.129997 73.112007)(51.999001 -88.582596 75.608002)(51.999001 -88.643600 76.077698)(51.999001 -92.129997 73.112007)(51.999001 -92.129997 73.112007)(51.999001 -88.228004 67.272003)(51.999001 -88.984604 71.674896)(51.999001 -88.475304 75.356697)(51.999001 -92.129997 73.112007)(51.999001 -88.984604 71.674896)(71.241501 -81.567696 63.201504)(51.999001 -82.388000 63.371002)(51.999001 -88.228004 67.272003)(73.228500 -75.373703 60.096500)(80.540901 -60.279999 61.111500)(51.999001 -82.388000 63.371002)(80.540901 -60.279999 61.111500)(74.827995 -66.945099 56.433102)(85.219505 -49.765503 63.199497)(83.731804 -40.151802 57.093601)(85.219505 -49.765503 63.199497)(74.827995 -66.945099 56.433102)(86.056000 -9.500000 54.688400)(91.955002 -26.450001 67.496002)(83.731804 -40.151802 57.093601)(92.545799 -9.500000 66.533501)(94.705002 -9.500000 71.813004)(91.955002 -26.450001 67.496002)(94.705002 9.500000 71.813004)(96.897499 -9.500000 78.332001)(94.705002 -9.500000 71.813004)(97.804596 33.058899 87.280197)(96.209198 31.883900 79.223495)(51.999001 52.222000 80.000000)(97.436501 35.610798 91.327507)(99.590500 22.541000 101.000000)(97.804596 33.058899 87.280197)(91.955002 26.450001 67.496002)(96.209198 31.883900 79.223495)(96.897499 9.500000 78.332001)(91.955002 26.450001 67.496002)(96.897499 9.500000 78.332001)(94.705002 9.500000 71.813004)(74.182999 -91.999001 100.992004)(73.108894 -91.675903 87.547798)(75.687996 -89.771400 94.269905)(73.108894 -91.675903 87.547798)(77.864807 -87.469299 93.317802)(75.687996 -89.771400 94.269905)(77.864807 -87.469299 93.317802)(74.182999 -91.999001 100.992004)(75.687996 -89.771400 94.269905)(77.864807 -87.469299 93.317802)(80.172005 -85.216499 100.992004)(74.182999 -91.999001 100.992004)(73.108894 -91.675903 87.547798)(59.370998 -99.918999 78.313004)(68.789001 -93.382004 79.306496)(51.999001 -93.500000 80.000000)(68.789001 -93.382004 79.306496)(67.411995 -91.832001 72.609795)(51.999001 -92.129997 73.112007)(51.999001 -93.500000 80.000000)(67.411995 -91.832001 72.609795)(51.999001 -88.228004 67.272003)(51.999001 -92.129997 73.112007)(68.345894 -87.843903 66.998398)(68.345894 -87.843903 66.998398)(71.241501 -81.567696 63.201504)(51.999001 -88.228004 67.272003)(71.241501 -81.567696 63.201504)(73.228500 -75.373703 60.096500)(51.999001 -82.388000 63.371002)(73.228500 -75.373703 60.096500)(74.827995 -66.945099 56.433102)(80.540901 -60.279999 61.111500)(86.056000 -9.500000 54.688400)(90.143005 -9.500000 61.424999)(91.955002 -26.450001 67.496002)(90.143005 -9.500000 61.424999)(92.545799 -9.500000 66.533501)(91.955002 -26.450001 67.496002)(92.545799 9.500000 66.533501)(94.705002 -9.500000 71.813004)(92.545799 -9.500000 66.533501)(92.545799 9.500000 66.533501)(94.705002 9.500000 71.813004)(94.705002 -9.500000 71.813004)(96.209198 31.883900 79.223495)(51.999001 53.734001 73.112007)(51.999001 52.222000 80.000000)(51.999001 53.734001 86.889000)(97.804596 33.058899 87.280197)(51.999001 52.222000 80.000000)(51.999001 53.734001 86.889000)(97.436501 35.610798 91.327507)(97.804596 33.058899 87.280197)(96.996002 40.187000 95.039001)(99.590500 22.541000 101.000000)(97.436501 35.610798 91.327507)(92.589203 35.396198 72.139999)(96.209198 31.883900 79.223495)(91.955002 26.450001 67.496002)(91.955002 26.450001 67.496002)(94.705002 9.500000 71.813004)(92.545799 9.500000 66.533501)(73.108894 -91.675903 87.547798)(74.182999 -91.999001 100.992004)(65.656502 -98.986702 100.992004)(59.370998 -99.918999 78.313004)(54.476997 -98.970001 67.497002)(68.789001 -93.382004 79.306496)(62.245998 -100.546005 89.704002)(59.370998 -99.918999 78.313004)(73.108894 -91.675903 87.547798)(68.789001 -93.382004 79.306496)(54.476997 -98.970001 67.497002)(67.411995 -91.832001 72.609795)(51.999001 -92.129997 73.112007)(67.411995 -91.832001 72.609795)(68.345894 -87.843903 66.998398)(71.241501 -81.567696 63.201504)(68.345894 -87.843903 66.998398)(68.362801 -85.385300 63.844898)(68.345894 -87.843903 66.998398)(64.030495 -87.942505 60.691498)(68.362801 -85.385300 63.844898)(64.030495 -87.942505 60.691498)(71.241501 -81.567696 63.201504)(68.362801 -85.385300 63.844898)(73.228500 -75.373703 60.096500)(71.241501 -81.567696 63.201504)(67.417397 -80.710899 57.015900)(73.228500 -75.373703 60.096500)(67.417397 -80.710899 57.015900)(74.827995 -66.945099 56.433102)(86.056000 9.500000 54.688400)(90.143005 -9.500000 61.424999)(86.056000 -9.500000 54.688400)(90.143005 9.500000 61.424999)(92.545799 -9.500000 66.533501)(90.143005 -9.500000 61.424999)(92.545799 -9.500000 66.533501)(90.143005 9.500000 61.424999)(92.545799 9.500000 66.533501)(96.209198 31.883900 79.223495)(92.589203 35.396198 72.139999)(51.999001 53.734001 73.112007)(51.999001 56.674702 79.545898)(51.999001 56.761398 82.161102)(51.999001 52.222000 80.000000)(51.999001 56.761398 82.161102)(51.999001 56.783501 82.828003)(51.999001 52.222000 80.000000)(51.999001 56.783501 82.828003)(51.999001 57.967300 86.554695)(51.999001 52.222000 80.000000)(51.999001 57.967300 86.554695)(51.999001 58.164803 87.177101)(51.999001 52.222000 80.000000)(51.999001 56.674702 79.545898)(51.999001 52.222000 80.000000)(51.999001 53.734001 73.112007)(51.999001 52.222000 80.000000)(51.999001 60.328800 90.471794)(51.999001 60.672001 90.994095)(51.999001 64.483002 96.629997)(51.999001 52.222000 80.000000)(51.999001 60.672001 90.994095)(51.999001 58.164803 87.177101)(51.999001 60.328800 90.471794)(51.999001 52.222000 80.000000)(51.999001 64.483002 96.629997)(51.999001 53.734001 86.889000)(51.999001 52.222000 80.000000)(51.999001 53.734001 86.889000)(51.999001 58.038998 92.727997)(97.436501 35.610798 91.327507)(96.996002 40.187000 95.039001)(96.291901 44.521000 98.903595)(99.590500 22.541000 101.000000)(51.999001 58.038998 92.727997)(96.996002 40.187000 95.039001)(97.436501 35.610798 91.327507)(88.838303 42.063499 66.603195)(92.589203 35.396198 72.139999)(91.955002 26.450001 67.496002)(91.955002 26.450001 67.496002)(92.545799 9.500000 66.533501)(90.143005 9.500000 61.424999)(62.245998 -100.546005 89.704002)(73.108894 -91.675903 87.547798)(65.656502 -98.986702 100.992004)(59.370998 -99.918999 78.313004)(44.272999 -106.232002 78.313004)(54.476997 -98.970001 67.497002)(47.508003 -106.936996 89.703003)(59.370998 -99.918999 78.313004)(62.245998 -100.546005 89.704002)(67.411995 -91.832001 72.609795)(54.476997 -98.970001 67.497002)(68.345894 -87.843903 66.998398)(68.345894 -87.843903 66.998398)(54.476997 -98.970001 67.497002)(64.030495 -87.942505 60.691498)(67.417397 -80.710899 57.015900)(71.241501 -81.567696 63.201504)(64.030495 -87.942505 60.691498)(86.056000 9.500000 54.688400)(90.143005 9.500000 61.424999)(90.143005 -9.500000 61.424999)(51.999001 58.038998 67.272003)(51.999001 53.734001 73.112007)(92.589203 35.396198 72.139999)(51.999001 56.791599 77.621201)(51.999001 56.632298 78.268997)(51.999001 53.734001 73.112007)(51.999001 56.632298 78.268997)(51.999001 56.674702 79.545898)(51.999001 53.734001 73.112007)(51.999001 53.734001 73.112007)(51.999001 58.038998 67.272003)(51.999001 56.361298 73.408997)(51.999001 56.791599 77.621201)(51.999001 53.734001 73.112007)(51.999001 56.361298 73.408997)(51.999001 58.038998 92.727997)(51.999001 53.734001 86.889000)(51.999001 64.483002 96.629997)(96.291901 44.521000 98.903595)(96.996002 40.187000 95.039001)(51.999001 64.483002 96.629997)(51.999001 58.038998 92.727997)(51.999001 64.483002 96.629997)(96.996002 40.187000 95.039001)(83.731804 40.151802 57.093601)(88.838303 42.063499 66.603195)(91.955002 26.450001 67.496002)(51.999001 58.038998 67.272003)(92.589203 35.396198 72.139999)(88.838303 42.063499 66.603195)(91.955002 26.450001 67.496002)(90.143005 9.500000 61.424999)(86.056000 9.500000 54.688400)(62.245998 -100.546005 89.704002)(65.656502 -98.986702 100.992004)(56.278999 -104.368004 100.992004)(44.272999 -106.232002 78.313004)(59.370998 -99.918999 78.313004)(47.508003 -106.936996 89.703003)(44.272999 -106.232002 78.313004)(37.724499 -104.748001 65.893501)(54.476997 -98.970001 67.497002)(56.278999 -104.368004 100.992004)(47.508003 -106.936996 89.703003)(62.245998 -100.546005 89.704002)(54.476997 -98.970001 67.497002)(58.651203 -92.101204 60.165901)(64.030495 -87.942505 60.691498)(64.030495 -87.942505 60.691498)(58.651203 -92.101204 60.165901)(67.417397 -80.710899 57.015900)(96.291901 44.521000 98.903595)(51.999001 64.483002 96.629997)(51.999001 73.791496 98.000000)(86.056000 9.500000 54.688400)(83.731804 40.151802 57.093601)(91.955002 26.450001 67.496002)(88.838303 42.063499 66.603195)(83.731804 40.151802 57.093601)(85.219505 49.765503 63.199497)(88.838303 42.063499 66.603195)(51.999001 64.483002 63.371002)(51.999001 58.038998 67.272003)(51.999001 73.791496 98.000000)(91.115105 62.855900 99.500000)(96.291901 44.521000 98.903595)(56.278999 -104.368004 100.992004)(47.983501 -107.210999 100.992004)(47.508003 -106.936996 89.703003)(47.508003 -106.936996 89.703003)(31.976500 -108.278999 79.363998)(44.272999 -106.232002 78.313004)(37.724499 -104.748001 65.893501)(43.988201 -101.818001 62.554905)(54.476997 -98.970001 67.497002)(37.724499 -104.748001 65.893501)(44.272999 -106.232002 78.313004)(31.998999 -106.898003 70.579002)(43.988201 -101.818001 62.554905)(58.651203 -92.101204 60.165901)(54.476997 -98.970001 67.497002)(74.827995 66.945099 56.433102)(85.219505 49.765503 63.199497)(83.731804 40.151802 57.093601)(51.999001 64.483002 63.371002)(88.838303 42.063499 66.603195)(85.219505 49.765503 63.199497)(91.115105 62.855900 99.500000)(51.999001 73.791496 98.000000)(88.890999 68.807495 99.500000)(31.986099 -109.000000 101.998001)(47.508003 -106.936996 89.703003)(47.983501 -107.210999 100.992004)(39.729500 -107.805000 90.681000)(47.508003 -106.936996 89.703003)(31.986099 -109.000000 101.998001)(39.729500 -107.805000 90.681000)(31.986099 -109.000000 101.998001)(31.976500 -108.278999 79.363998)(39.729500 -107.805000 90.681000)(31.976500 -108.278999 79.363998)(47.508003 -106.936996 89.703003)(31.976500 -108.278999 79.363998)(31.998999 -106.898003 70.579002)(44.272999 -106.232002 78.313004)(37.724499 -104.748001 65.893501)(32.140800 -105.104996 63.342102)(43.988201 -101.818001 62.554905)(31.998999 -106.898003 70.579002)(32.140800 -105.104996 63.342102)(37.724499 -104.748001 65.893501)(74.827995 66.945099 56.433102)(67.417397 80.710899 57.015900)(73.228500 75.373703 60.096500)(51.999001 73.791496 62.000000)(51.999001 64.483002 63.371002)(85.219505 49.765503 63.199497)(82.298004 81.828499 96.765999)(51.999001 73.791496 98.000000)(51.999001 82.388000 96.629997)(74.827995 66.945099 56.433102)(80.540901 60.279999 61.111500)(85.219505 49.765503 63.199497)(85.863098 75.680000 100.202003)(88.890999 68.807495 99.500000)(51.999001 73.791496 98.000000)(31.986099 -109.000000 101.998001)(11.049900 -105.576996 69.548698)(31.976500 -108.278999 79.363998)(11.049900 -105.576996 69.548698)(31.998999 -106.898003 70.579002)(31.976500 -108.278999 79.363998)(32.140800 -105.104996 63.342102)(31.998999 -106.898003 70.579002)(11.049900 -105.576996 69.548698)(67.417397 80.710899 57.015900)(58.651203 92.101204 60.165901)(64.030495 87.942505 60.691498)(67.417397 80.710899 57.015900)(71.241501 81.567696 63.201504)(73.228500 75.373703 60.096500)(80.540901 60.279999 61.111500)(74.827995 66.945099 56.433102)(73.228500 75.373703 60.096500)(85.219505 49.765503 63.199497)(80.540901 60.279999 61.111500)(51.999001 73.791496 62.000000)(80.540901 60.279999 61.111500)(51.999001 82.388000 63.371002)(51.999001 73.791496 62.000000)(51.999001 82.388000 63.371002)(51.999001 88.228004 67.272003)(51.999001 84.773697 66.483200)(51.999001 88.228004 67.272003)(51.999001 84.638794 67.636993)(51.999001 84.773697 66.483200)(51.999001 87.880699 88.386200)(51.999001 92.129997 86.889000)(51.999001 87.524895 90.244598)(51.999001 92.129997 86.889000)(51.999001 88.228004 92.727997)(51.999001 87.524895 90.244598)(82.298004 81.828499 96.765999)(51.999001 82.388000 96.629997)(51.999001 88.228004 92.727997)(82.298004 81.828499 96.765999)(85.863098 75.680000 100.202003)(51.999001 73.791496 98.000000)(2.260000 -106.917000 81.665504)(11.049900 -105.576996 69.548698)(31.986099 -109.000000 101.998001)(43.988201 101.818001 62.554905)(54.476997 98.970001 67.497002)(58.651203 92.101204 60.165901)(54.476997 98.970001 67.497002)(64.030495 87.942505 60.691498)(58.651203 92.101204 60.165901)(64.030495 87.942505 60.691498)(71.241501 81.567696 63.201504)(67.417397 80.710899 57.015900)(73.228500 75.373703 60.096500)(71.241501 81.567696 63.201504)(51.999001 82.388000 63.371002)(73.228500 75.373703 60.096500)(51.999001 82.388000 63.371002)(80.540901 60.279999 61.111500)(71.241501 81.567696 63.201504)(51.999001 88.228004 67.272003)(51.999001 82.388000 63.371002)(51.999001 92.129997 73.112007)(51.999001 89.462303 75.381302)(51.999001 89.434494 75.219696)(51.999001 92.129997 73.112007)(51.999001 89.434494 75.219696)(51.999001 89.388100 74.950005)(51.999001 89.388100 74.950005)(51.999001 87.553703 71.096596)(51.999001 89.239403 71.326706)(51.999001 88.228004 67.272003)(51.999001 92.129997 73.112007)(51.999001 89.239403 71.326706)(51.999001 92.129997 73.112007)(51.999001 89.388100 74.950005)(51.999001 89.239403 71.326706)(51.999001 92.129997 86.889000)(51.999001 87.880699 88.386200)(51.999001 88.003601 88.224998)(51.999001 92.129997 86.889000)(51.999001 88.003601 88.224998)(51.999001 89.588005 84.235695)(51.999001 89.887596 82.070297)(51.999001 93.500000 80.000000)(51.999001 90.690300 84.193100)(51.999001 93.500000 80.000000)(51.999001 92.129997 86.889000)(51.999001 90.690300 84.193100)(51.999001 92.129997 86.889000)(51.999001 89.588005 84.235695)(51.999001 90.690300 84.193100)(51.999001 88.228004 92.727997)(51.999001 92.129997 86.889000)(73.108894 91.675903 87.547798)(77.864807 87.469299 93.317802)(82.298004 81.828499 96.765999)(51.999001 88.228004 92.727997)(82.298004 81.828499 96.765999)(80.172005 85.216499 100.992004)(85.863098 75.680000 100.202003)(56.278999 104.368004 100.992004)(65.656502 98.986702 100.992004)(62.245998 100.546005 89.704002)(47.983501 107.210999 100.992004)(56.278999 104.368004 100.992004)(47.508003 106.936996 89.703003)(-20.287800 -102.351997 75.336395)(11.049900 -105.576996 69.548698)(2.260000 -106.917000 81.665504)(-40.895302 -101.299004 103.098000)(2.260000 -106.917000 81.665504)(31.986099 -109.000000 101.998001)(54.476997 98.970001 67.497002)(43.988201 101.818001 62.554905)(37.724499 104.748001 65.893501)(64.030495 87.942505 60.691498)(54.476997 98.970001 67.497002)(68.345894 87.843903 66.998398)(68.345894 87.843903 66.998398)(71.241501 81.567696 63.201504)(68.362801 85.385300 63.844898)(71.241501 81.567696 63.201504)(64.030495 87.942505 60.691498)(68.362801 85.385300 63.844898)(64.030495 87.942505 60.691498)(68.345894 87.843903 66.998398)(68.362801 85.385300 63.844898)(71.241501 81.567696 63.201504)(68.345894 87.843903 66.998398)(51.999001 88.228004 67.272003)(51.999001 92.129997 73.112007)(51.999001 88.228004 67.272003)(68.345894 87.843903 66.998398)(51.999001 93.500000 80.000000)(51.999001 89.887596 82.070297)(51.999001 90.133507 79.709801)(51.999001 93.500000 80.000000)(51.999001 90.133507 79.709801)(51.999001 90.161003 79.445999)(51.999001 90.161003 79.445999)(51.999001 89.462303 75.381302)(51.999001 91.481094 77.591103)(51.999001 89.462303 75.381302)(51.999001 92.129997 73.112007)(51.999001 91.481094 77.591103)(51.999001 92.129997 73.112007)(51.999001 93.500000 80.000000)(51.999001 91.481094 77.591103)(51.999001 93.500000 80.000000)(51.999001 90.161003 79.445999)(51.999001 91.481094 77.591103)(51.999001 92.129997 86.889000)(51.999001 93.500000 80.000000)(68.789001 93.382004 79.306496)(51.999001 88.228004 92.727997)(73.108894 91.675903 87.547798)(77.864807 87.469299 93.317802)(51.999001 92.129997 86.889000)(68.789001 93.382004 79.306496)(73.108894 91.675903 87.547798)(77.864807 87.469299 93.317802)(80.172005 85.216499 100.992004)(80.198494 84.734795 97.154900)(80.172005 85.216499 100.992004)(82.298004 81.828499 96.765999)(80.198494 84.734795 97.154900)(82.298004 81.828499 96.765999)(77.864807 87.469299 93.317802)(80.198494 84.734795 97.154900)(77.864807 87.469299 93.317802)(74.182999 91.999001 100.992004)(80.172005 85.216499 100.992004)(65.656502 98.986702 100.992004)(74.182999 91.999001 100.992004)(73.108894 91.675903 87.547798)(65.656502 98.986702 100.992004)(73.108894 91.675903 87.547798)(62.245998 100.546005 89.704002)(62.245998 100.546005 89.704002)(47.508003 106.936996 89.703003)(56.278999 104.368004 100.992004)(47.508003 106.936996 89.703003)(31.986099 109.000000 101.998001)(47.983501 107.210999 100.992004)(-34.643200 -99.471100 82.808998)(-20.287800 -102.351997 75.336395)(2.260000 -106.917000 81.665504)(-34.643200 -99.471100 82.808998)(2.260000 -106.917000 81.665504)(-40.895302 -101.299004 103.098000)(32.140800 105.104996 63.342102)(37.724499 104.748001 65.893501)(43.988201 101.818001 62.554905)(54.476997 98.970001 67.497002)(37.724499 104.748001 65.893501)(44.272999 106.232002 78.313004)(67.411995 91.832001 72.609795)(68.345894 87.843903 66.998398)(54.476997 98.970001 67.497002)(51.999001 92.129997 73.112007)(68.345894 87.843903 66.998398)(67.411995 91.832001 72.609795)(51.999001 93.500000 80.000000)(51.999001 92.129997 73.112007)(67.411995 91.832001 72.609795)(51.999001 93.500000 80.000000)(67.411995 91.832001 72.609795)(68.789001 93.382004 79.306496)(75.687996 89.771400 94.269905)(73.108894 91.675903 87.547798)(74.182999 91.999001 100.992004)(75.687996 89.771400 94.269905)(74.182999 91.999001 100.992004)(77.864807 87.469299 93.317802)(75.687996 89.771400 94.269905)(77.864807 87.469299 93.317802)(73.108894 91.675903 87.547798)(73.108894 91.675903 87.547798)(68.789001 93.382004 79.306496)(59.370998 99.918999 78.313004)(62.245998 100.546005 89.704002)(73.108894 91.675903 87.547798)(59.370998 99.918999 78.313004)(59.370998 99.918999 78.313004)(47.508003 106.936996 89.703003)(62.245998 100.546005 89.704002)(39.729500 107.805000 90.681000)(31.986099 109.000000 101.998001)(47.508003 106.936996 89.703003)(39.729500 107.805000 90.681000)(47.508003 106.936996 89.703003)(31.976500 108.278999 79.363998)(39.729500 107.805000 90.681000)(31.976500 108.278999 79.363998)(31.986099 109.000000 101.998001)(-34.643200 -99.471100 82.808998)(-33.092899 -100.183006 78.662399)(-20.287800 -102.351997 75.336395)(32.140800 105.104996 63.342102)(31.998999 106.898003 70.579002)(37.724499 104.748001 65.893501)(11.049900 105.576996 69.548698)(31.998999 106.898003 70.579002)(32.140800 105.104996 63.342102)(31.998999 106.898003 70.579002)(44.272999 106.232002 78.313004)(37.724499 104.748001 65.893501)(59.370998 99.918999 78.313004)(54.476997 98.970001 67.497002)(44.272999 106.232002 78.313004)(67.411995 91.832001 72.609795)(54.476997 98.970001 67.497002)(68.789001 93.382004 79.306496)(68.789001 93.382004 79.306496)(54.476997 98.970001 67.497002)(59.370998 99.918999 78.313004)(59.370998 99.918999 78.313004)(44.272999 106.232002 78.313004)(47.508003 106.936996 89.703003)(44.272999 106.232002 78.313004)(31.976500 108.278999 79.363998)(47.508003 106.936996 89.703003)(31.986099 109.000000 101.998001)(31.976500 108.278999 79.363998)(11.049900 105.576996 69.548698)(31.976500 108.278999 79.363998)(31.998999 106.898003 70.579002)(11.049900 105.576996 69.548698)(31.998999 106.898003 70.579002)(31.976500 108.278999 79.363998)(44.272999 106.232002 78.313004)(2.260000 106.917000 81.665504)(31.986099 109.000000 101.998001)(11.049900 105.576996 69.548698)(31.986099 109.000000 101.998001)(2.260000 106.917000 81.665504)(-40.895302 101.299004 103.098000)(-20.287800 102.351997 75.336395)(2.260000 106.917000 81.665504)(11.049900 105.576996 69.548698)(2.260000 106.917000 81.665504)(-34.643200 99.471100 82.808998)(-40.895302 101.299004 103.098000)(2.260000 106.917000 81.665504)(-20.287800 102.351997 75.336395)(-34.643200 99.471100 82.808998)(-34.643200 99.471100 82.808998)(-20.287800 102.351997 75.336395)(-33.092899 100.183006 78.662399)(51.999001 62.723396 92.779999)(51.999001 64.483002 96.629997)(51.999001 60.672001 90.994095)(51.999001 63.854000 93.764404)(51.999001 64.483002 96.629997)(51.999001 63.678802 93.611801)(51.999001 64.483002 96.629997)(51.999001 62.723396 92.779999)(51.999001 63.678802 93.611801)(51.999001 58.038998 67.272003)(51.999001 58.988602 71.598404)(51.999001 56.361298 73.408997)(51.999001 58.988602 71.598404)(51.999001 58.042797 73.270302)(51.999001 56.361298 73.408997)(51.999001 58.042797 73.270302)(51.999001 57.721600 73.838005)(51.999001 56.361298 73.408997)(51.999001 57.721600 73.838005)(51.999001 56.791599 77.621201)(51.999001 56.361298 73.408997)(51.999001 64.483002 94.168503)(51.999001 64.483002 96.629997)(51.999001 64.120102 93.996002)(51.999001 64.120102 93.996002)(51.999001 64.483002 96.629997)(51.999001 63.854000 93.764404)(51.999001 60.412601 69.423897)(51.999001 59.969700 69.864105)(51.999001 58.038998 67.272003)(51.999001 59.969700 69.864105)(51.999001 58.988602 71.598404)(51.999001 58.038998 67.272003)(51.999001 58.038998 67.272003)(51.999001 64.483002 63.371002)(51.999001 61.260998 67.484695)(51.999001 63.211300 66.642097)(51.999001 60.412601 69.423897)(51.999001 61.260998 67.484695)(51.999001 64.483002 63.371002)(51.999001 63.211300 66.642097)(51.999001 61.260998 67.484695)(51.999001 60.412601 69.423897)(51.999001 58.038998 67.272003)(51.999001 61.260998 67.484695)(51.999001 65.069695 94.447296)(51.999001 64.483002 96.629997)(51.999001 64.483002 94.168503)(51.999001 82.388000 96.629997)(51.999001 73.791496 98.000000)(51.999001 73.848503 96.629997)(51.999001 72.288994 96.657906)(51.999001 73.791496 98.000000)(51.999001 72.127701 96.629997)(51.999001 72.127701 96.629997)(51.999001 73.791496 98.000000)(51.999001 64.483002 96.629997)(51.999001 72.288994 96.657906)(51.999001 72.763901 96.739998)(51.999001 73.435501 97.314995)(51.999001 72.763901 96.739998)(51.999001 73.848503 96.629997)(51.999001 73.435501 97.314995)(51.999001 73.848503 96.629997)(51.999001 73.791496 98.000000)(51.999001 73.435501 97.314995)(51.999001 73.791496 98.000000)(51.999001 72.288994 96.657906)(51.999001 73.435501 97.314995)(51.999001 67.768097 95.729797)(51.999001 68.252602 95.959999)(51.999001 66.442696 96.106003)(51.999001 66.442696 96.106003)(51.999001 68.402496 95.985893)(51.999001 68.252602 95.959999)(51.999001 68.402496 95.985893)(51.999001 64.483002 96.629997)(51.999001 66.442696 96.106003)(51.999001 64.483002 96.629997)(51.999001 67.457306 95.582100)(51.999001 66.442696 96.106003)(51.999001 67.457306 95.582100)(51.999001 67.768097 95.729797)(51.999001 66.442696 96.106003)(51.999001 66.830902 95.284401)(51.999001 67.457306 95.582100)(51.999001 64.483002 96.629997)(51.999001 66.339500 95.050797)(51.999001 66.830902 95.284401)(51.999001 64.483002 96.629997)(51.999001 66.339500 95.050797)(51.999001 64.483002 96.629997)(51.999001 65.921097 94.851997)(51.999001 65.921097 94.851997)(51.999001 64.483002 96.629997)(51.999001 65.538200 94.669998)(51.999001 65.538200 94.669998)(51.999001 64.483002 96.629997)(51.999001 65.069695 94.447296)(51.999001 88.228004 92.727997)(51.999001 82.388000 96.629997)(51.999001 82.919907 93.600304)(51.999001 82.919907 93.600304)(51.999001 82.388000 96.629997)(51.999001 81.581696 94.609001)(51.999001 81.581696 94.609001)(51.999001 82.388000 96.629997)(51.999001 81.233803 94.745300)(51.999001 81.233803 94.745300)(51.999001 82.388000 96.629997)(51.999001 77.319504 96.278000)(51.999001 82.388000 96.629997)(51.999001 73.848503 96.629997)(51.999001 76.895294 96.320999)(51.999001 77.319504 96.278000)(51.999001 82.388000 96.629997)(51.999001 76.895294 96.320999)(51.999001 68.402496 95.985893)(51.999001 72.127701 96.629997)(51.999001 64.483002 96.629997)(51.999001 88.228004 67.272003)(51.999001 86.348900 69.595299)(51.999001 84.638794 67.636993)(51.999001 84.638794 67.636993)(51.999001 84.420395 67.387001)(51.999001 84.773697 66.483200)(51.999001 84.420395 67.387001)(51.999001 81.319397 65.355896)(51.999001 84.773697 66.483200)(51.999001 85.232597 91.857002)(51.999001 88.228004 92.727997)(51.999001 84.970398 92.054504)(51.999001 84.970398 92.054504)(51.999001 88.228004 92.727997)(51.999001 82.919907 93.600304)(51.999001 85.232597 91.857002)(51.999001 87.825699 88.458298)(51.999001 87.524895 90.244598)(51.999001 87.524895 90.244598)(51.999001 87.880699 88.386200)(51.999001 87.825699 88.458298)(51.999001 88.228004 92.727997)(51.999001 85.232597 91.857002)(51.999001 87.524895 90.244598)(51.999001 87.426300 70.828995)(51.999001 86.348900 69.595299)(51.999001 88.228004 67.272003)(51.999001 87.553703 71.096596)(51.999001 87.426300 70.828995)(51.999001 89.239403 71.326706)(51.999001 87.426300 70.828995)(51.999001 88.228004 67.272003)(51.999001 89.239403 71.326706)(51.999001 89.588005 84.235695)(51.999001 89.688400 83.983101)(51.999001 90.690300 84.193100)(51.999001 89.688400 83.983101)(51.999001 89.887596 82.070297)(51.999001 90.690300 84.193100)(51.999001 64.483002 65.931602)(51.999001 63.722000 66.356705)(51.999001 64.483002 63.371002)(51.999001 63.722000 66.356705)(51.999001 63.211300 66.642097)(51.999001 64.483002 63.371002)(51.999001 73.791496 62.000000)(51.999001 73.415695 63.397900)(51.999001 72.138901 63.353001)(51.999001 73.791496 62.000000)(51.999001 72.138901 63.353001)(51.999001 71.655403 63.335999)(51.999001 71.655403 63.335999)(51.999001 67.727699 64.284897)(51.999001 64.483002 63.371002)(51.999001 67.727699 64.284897)(51.999001 67.205505 64.411003)(51.999001 64.483002 63.371002)(51.999001 67.205505 64.411003)(51.999001 64.483002 65.931602)(51.999001 64.483002 63.371002)(51.999001 73.791496 62.000000)(51.999001 71.655403 63.335999)(51.999001 64.483002 63.371002)(51.999001 81.319397 65.355896)(51.999001 80.909996 65.087700)(51.999001 82.388000 63.371002)(51.999001 82.388000 63.371002)(51.999001 80.909996 65.087700)(51.999001 80.594398 64.880997)(51.999001 76.231194 63.496998)(51.999001 73.415695 63.397900)(51.999001 73.791496 62.000000)(51.999001 80.594398 64.880997)(51.999001 76.640297 63.626804)(51.999001 77.901901 63.677898)(51.999001 73.791496 62.000000)(51.999001 82.388000 63.371002)(51.999001 77.901901 63.677898)(51.999001 82.388000 63.371002)(51.999001 80.594398 64.880997)(51.999001 77.901901 63.677898)(51.999001 76.231194 63.496998)(51.999001 73.791496 62.000000)(51.999001 77.901901 63.677898)(51.999001 81.319397 65.355896)(51.999001 82.388000 63.371002)(51.999001 84.773697 66.483200)(51.999001 -58.038998 92.727997)(51.999001 -64.483002 96.