#include "MainWindow.h"
#include "ui_MainWindow.h"  //to instantiate classes from ui

#include <QMessageBox>
#include <QFileDialog>
#include <QComboBox>
#include <QtCore>
#include <QShortcut>
#include <QPushButton>

#include <opencv2/core/core.hpp>
#include <opencv2/opencv.hpp>

#include <ros/package.h>
#include <std_msgs/String.h>
//#include "object_detection/DetectObjects.h"
//#include "object_detection/Object.h"
//#include "object_detection/DetectedObjects.h"
//#include "homer_gripping/GripObject.h"
//#include <homer_arm_planner/PathToPointRequest.h>
//#include <homer_arm_planner/LinearPathRequest.h>

#include <or_nodes/Modules/ORControlModule.h>

//#include "door_detection_messages/DetectDoorControl.h"
//#include "door_detection_messages/DetectHandleControl.h"
#include <sensor_msgs/JointState.h>
#include <boost/filesystem.hpp> // includes all needed Boost.Filesystem declarations
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/path.hpp>


#include "tools/stringTools.h"
#include <map>
#include <rviz/visualization_manager.h>
#include <rviz/render_panel.h>
#include <rviz/displays_panel.h>
#include <rviz/display.h>
#include <rviz/yaml_config_reader.h>
#include <rviz/yaml_config_writer.h>
//#include <rviz/image_view.h>

using namespace std;
using namespace boost::filesystem;


void MainWindow::executeSystemCommand(QString command)
{
    m_game_process = new QProcess();
    m_game_process->setProcessChannelMode(QProcess::MergedChannels);
    //m_game_process->setReadChannel(QProcess::StandardOutput);

    connect(m_game_process, SIGNAL(readyReadStandardOutput()), this, SLOT(readStandardOutPut()) );//readyReadStandardOutput()
    connect(m_game_process, SIGNAL(readyReadStandardError()), this, SLOT(readStandardOutPut()) );//readyReadStandardOutput()

    QStringList params;
    params.append("game_collection");
    params.append(command);
    //m_game_process->start("roslaunch", params);
    m_game_process->start("script -qc \"roslaunch game_collection "+command);
}

void MainWindow::readStandardOutPut()
{
    //    ROS_INFO_STREAM("Console output");
    QByteArray data = m_game_process->readAllStandardOutput();
    QString text = QString(data);


    QStringList lines = text.split("\n");

}


void MainWindow::driveForward()
{
    //robot_platform::MoveRobot msgMove;
    //msgMove.m_Distance = 0.1;
    //msgMove.m_Speed = 0.05;
    //msgMove.m_Permanent = false;
    //move_robot_pub_.publish(msgMove);
    ROS_INFO_STREAM("MOVE FORWARD");

}


void MainWindow::driveBackward()
{
    //robot_platform::MoveRobot msgMove;
    //msgMove.m_Distance = -0.1;
    //msgMove.m_Speed = 0.05;
    //msgMove.m_Permanent = false;
    //move_robot_pub_.publish(msgMove);
    ROS_INFO_STREAM("MOVE BACKWARD");


}


void MainWindow::driveLeft()
{
    //robot_platform::TurnRobot msgTurn;
    //msgTurn.m_Theta = 10;
    //msgTurn.m_Speed = 0.1;
    //msgTurn.m_Permanent = false;
    //turn_robot_pub_.publish(msgTurn);
    ROS_INFO("TURN LEFT");
}


void MainWindow::driveRight()
{
    //robot_platform::TurnRobot msgTurn;
    //msgTurn.m_Theta = -10;
    //msgTurn.m_Speed = 0.1;
    //msgTurn.m_Permanent = false;
    //turn_robot_pub_.publish(msgTurn);
    ROS_INFO("TURN RIGHT");
}

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow),
    m_Talker(0),
    m_IsRunning(false),
    m_TaskIndex(-1)
{
    ui->setupUi(this);

    qApp->installEventFilter(this);

    //    main_tabs_ = ui->mainTabs;

    //    main_tabs_->
    //	qtRosNode.getNodeHandle()
    QTabWidget* main_tabs;
    //    main_tabs->currentIndex(
    //check at the begining if there are buttons which should be disabled or enabled
    checkForEnableButtons();
    //initializing arm vaiables
    m_linear = false;
    m_collisionfree = false;


}

MainWindow::~MainWindow()
{
    if (ui) delete ui;
    //note: you have not to care about deleting QWidgets if they are children of this window
}


void MainWindow::loadFilesIntoComboBox(std::string filePath, std::string ext, QComboBox* cb)
{
    if ( !exists( filePath ) ) return;
    QStringList file_list;
    directory_iterator end_itr; // default construction yields past-the-end
    for ( directory_iterator itr( filePath ); itr != end_itr; ++itr )
    {
        if ( is_directory(itr->status()) )
        {
            continue;
        }
        else // if ( itr->leaf() == file_name ) // see below
        {
            std::string s;
            s = itr->path().stem().string();
            //ROS_INFO_STREAM(s);
            file_list.append(QString(s.c_str()));
            //ROS_INFO_STREAM(qs.toStdString());

        }
    }
    file_list.sort();
    for (auto i : file_list)
        cb->addItem(i);
}

template<typename T>
void MainWindow::registerMainTab(T** mainTab, ros::NodeHandle* nh, const std::string& tabName )
{
    *mainTab = new T( this, nh );

    std::string name = tabName;
    name.insert(0,1, '&');
    //note: tr is for multi language support
    ui->mainTabs->addTab ( *mainTab, tr ( name.c_str() ) );


    connect( ui->mainTabs, SIGNAL(currentChanged(int)), *mainTab, SLOT(controlActivityStatus(int)) );
}



void MainWindow::setQtRosNode(QtRosNode& qtRosNode)
{
    m_Talker = new Talker(qtRosNode.getNodeHandle(),"chatter");

    registerMainTab(&m_MapTab, qtRosNode.getNodeHandle(), "Map");

    ui->mainTabs->setCurrentIndex(0);

    //loading kinect camera visualization
    //kinect_rgb_image_display_ = new ImageDisplay(ui->kinectViewFrame);
    //ui->kinectViewFrame->layout()->addWidget(kinect_rgb_image_display_);
    //loading another camera visualization
    any_rgb_image_display_ = this->findChild<ImageDisplay*>("cameraViewFrame");
    //	std::cout << "    any_rgb_image_display_ = " <<     any_rgb_image_display_ << std::endl;
    //    any_rgb_image_display_ = new ImageDisplay(ui->cameraViewFrame);
    //    ui->cameraViewFrame->layout()->addWidget(any_rgb_image_display_);

    qRegisterMetaType<std::vector<homer_mapnav_msgs::PointOfInterest> >("std::vector<homer_mapnav_msgs::PointOfInterest>");
    qRegisterMetaType<std::vector<geometry_msgs::PoseStamped> >("std::vector<geometry_msgs::PoseStamped>");
    qRegisterMetaType<geometry_msgs::Pose>("geometry_msgs::Pose");
    qRegisterMetaType<sensor_msgs::Image::ConstPtr>("sensor_msgs::Image::ConstPtr");
    m_kinectViewFrame=this->findChild<ImageDisplay*>("kinectViewWidget");
    m_kinectLiveImageWidget = this->findChild<ImageDisplay*>("KinectLiveImageWidget");
    m_kinectLiveImageWidget_2=this->findChild<ImageDisplay*>("KinectLiveImageWidget_2");
    m_kinectLiveImageWidget_3=this->findChild<ImageDisplay*>("KinectLiveImageWidget_3");
    m_objectFileName=this->findChild<QLineEdit*>("objectNameField");
    connect(&qtRosNode, SIGNAL(poseUpdated(double,double,double)), m_MapTab, SLOT(updatePose(double,double,double)) );
    connect(&qtRosNode, SIGNAL(mapUpdated(unsigned char *,uint,double,geometry_msgs::Pose)),m_MapTab, SLOT(updateMap(unsigned char *,uint,double,geometry_msgs::Pose)));
    connect(&qtRosNode, SIGNAL(maskUpdated(const nav_msgs::OccupancyGrid::ConstPtr)),m_MapTab, SLOT(updateMask(const nav_msgs::OccupancyGrid::ConstPtr)));
    connect(&qtRosNode, SIGNAL(poiListUpdated(std::vector<homer_mapnav_msgs::PointOfInterest>)), m_MapTab, SLOT(updatePOIList(std::vector < homer_mapnav_msgs::PointOfInterest >)));
    connect(&qtRosNode, SIGNAL(pathUpdated(std::vector<geometry_msgs::PoseStamped>)), m_MapTab, SLOT(updatePath(std::vector<geometry_msgs::PoseStamped>)));
    connect(&qtRosNode, SIGNAL(followingPathUpdated(std::vector<geometry_msgs::PoseStamped>)), m_MapTab, SLOT(updateFollowingPath(std::vector<geometry_msgs::PoseStamped>)));



    //connect(&qtRosNode, SIGNAL(kinectRGBImageUpdate(const sensor_msgs::Image::ConstPtr&)), kinect_rgb_image_display_, SLOT(processImageData(const sensor_msgs::Image::ConstPtr& )));
    //connect(&qtRosNode, SIGNAL(kinectRGBImageUpdate(sensor_msgs::Image::ConstPtr)), kinect_rgb_image_display_, SLOT(callbackImageDisplay(sensor_msgs::Image::ConstPtr)));
    connect(&qtRosNode, SIGNAL(anyImageUpdate(const sensor_msgs::Image::ConstPtr&)), any_rgb_image_display_, SLOT(processImageData(const sensor_msgs::Image::ConstPtr)));
    connect(&qtRosNode, SIGNAL(learningStatus(std::vector<std::string>,std::string)), this, SLOT(updateImageTable(std::vector<std::string>,std::string)));
    connect(&qtRosNode, SIGNAL(objectNames(std::vector<std::string>,std::vector<std::string>)),this, SLOT(processObjectNames(std::vector<std::string>,std::vector<std::string>)));
    //connect(&qtRosNode, SIGNAL(), , SLOT(callbackSpeechOut(std::string))
    //connect(&qtRosNode, SIGNAL(kinectRGBImageUpdate(sensor_msgs::Image::ConstPtr)),this, SLOT(testSlot(const sensor_msgs::Image::ConstPtr & )));
    //as soon as the objectNameField(in object training tab) in the ui changes its text check if the saveButton should be enabled
    connect(m_objectFileName,SIGNAL(textEdited(const QString &)),this,SLOT(checkForEnableButtons()));
    connect(&qtRosNode, SIGNAL(emergencyButtonPressed(bool)), this, SLOT(processEmergencyButtonPressed(bool)));
    connect(&qtRosNode, SIGNAL(kinectRGBImageUpdate(const sensor_msgs::Image::ConstPtr&)), m_kinectLiveImageWidget, SLOT(processImageData(const sensor_msgs::Image::ConstPtr& )));
    connect(&qtRosNode, SIGNAL(kinectDebugGrayUpdate(const sensor_msgs::Image::ConstPtr&)), m_kinectLiveImageWidget_2, SLOT(processImageData(const sensor_msgs::Image::ConstPtr& )));
    connect(&qtRosNode, SIGNAL(kinectPrimaryRGBUpdate(const sensor_msgs::Image::ConstPtr&)), m_kinectLiveImageWidget_3, SLOT(processImageData(const sensor_msgs::Image::ConstPtr& )));
    connect(&qtRosNode, SIGNAL(kinectRGBImageUpdate(const sensor_msgs::Image::ConstPtr&)), m_kinectViewFrame, SLOT(processImageData(const sensor_msgs::Image::ConstPtr& )));


    //connect(&qtRosNode, SIGNAL(hardwareStatus(std::string,bool)), this, SLOT(processHardwareState(std::string,bool)));
    connect(&qtRosNode, SIGNAL(emergencyButtonPressed(bool)), this, SLOT(processEmergencyButtonPressed(bool)));
    connect(&qtRosNode, SIGNAL(rosShutdown()), this, SLOT(close()));

    //connect(&qtRosNode, SIGNAL(checkHardwareStatus()), this, SLOT(updateHardwareStatus()));
   // move_robot_pub_ = qtRosNode.getNodeHandle()->advertise<robot_platform::MoveRobot>("/robot_platform/MoveRobot", 1);
    //turn_robot_pub_ = qtRosNode.getNodeHandle()->advertise<robot_platform::TurnRobot>("/robot_platform/TurnRobot", 1);
    //stop_robot_pub_ = qtRosNode.getNodeHandle()->advertise<robot_platform::StopRobot>("/robot_platform/StopRobot", 1);
//    detect_objects_pub_ = qtRosNode.getNodeHandle()->advertise<object_detection::DetectObjects>("/object_detection/detect_objects", 1);
//    grip_object_pub_ = qtRosNode.getNodeHandle()->advertise<homer_gripping::GripObject>("/gripping/grip_object", 1);
//    m_arm_path_to_point_pub_ = qtRosNode.getNodeHandle()->advertise<homer_arm_planner::PathToPointRequest>("/homer_arm/path_to_point_request", 1);
//    m_arm_path_to_configuration_pub_ = qtRosNode.getNodeHandle()->advertise<homer_arm_planner::PathToConfigurationRequest>("/homer_arm/path_to_configuration_request", 1);
//    m_arm_linear_path_pub_ = qtRosNode.getNodeHandle()->advertise<homer_arm_planner::LinearPathRequest>("/homer_arm/linear_path_request", 1) ;
//    unblock_katana_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/r22_RosKatanaModule/unblock_motors", 1);
//    arm_safe_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/katana_arm_planner/safe_position",1);
//    arm_transport_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/katana_arm_planner/transport_position",1);

    //start_game_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/start_game", 1);
    //detect_doors_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/detect_doors", 1);
    speech_out_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::String>("/robot_face/speak", 1);
    //fake_user_input_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::String>("/robot_face/user_input", 1);
    fake_user_input_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::String>("recognized_speech", 1);

    //set_pan_tilt_pub_ = qtRosNode.getNodeHandle()->advertise<ptu::SetPanTilt>("/ptu/set_pan_tilt", 1);

    release_object_pub_=qtRosNode.getNodeHandle()->advertise<std_msgs::Bool>("/gripping/release_object",1);
    reset_katana_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/gripping/reset", 1);
    target_reached_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/homer_navigation/target_reached", 1);
    m_robot_platform_task_finished_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/robot_platform/task_finished", 1);

    //m_armMoveFinishedPub = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/katana/move_finished", 1);
    //m_armPathFinishedPub = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/homer_arm/path_finished", 1);

    //detect_planes_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/object_detection/detect_planes", 1);
    //detected_objects_pub_ = qtRosNode.getNodeHandle()->advertise<object_detection::DetectedObjects>("/object_detection/detect_objects", 1);
    //m_detected_person_pub_= qtRosNode.getNodeHandle()->advertise<ptu_person_detection::ptu_search_persons>("/ptu_person_detection/ptu_search_persons", 1);
    m_finished_talking_pub_=  qtRosNode.getNodeHandle()->advertise<std_msgs::String>("robot_face/talking_finished", 1);

    //m_finished_gripping_pub_=qtRosNode.getNodeHandle()->advertise<homer_gripping::GrippingFinished>("/gripping/finished_gripping", 1);
    m_release_finished_pub_=qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/gripping/finished_releasing", 1);
    rotate_gripper_pub_= qtRosNode.getNodeHandle()->advertise<std_msgs::Float64>("/katana_arm_planner/rotate_gripper",1);

    repeat_speech_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::String>("/robot_face/speak",1);
   // face_detection_pub_= qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/face_detection/detect_faces", 1);
   // open_oven_pub_ = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/final_2014/open_oven",1);
    start_navigation_pub_ = qtRosNode.getNodeHandle()->advertise<homer_mapnav_msgs::NavigateToPOI>("/homer_navigation/navigate_to_POI", 1);
    m_StopNavigationPublisher = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/homer_navigation/stop_navigation", 10);
    m_ORLearnCommandPublisher = qtRosNode.getNodeHandle()->advertise<or_msgs::OrLearnCommand>("/or/learn_commands", 10);
    m_ORCommandPublisher = qtRosNode.getNodeHandle()->advertise<or_msgs::OrCommand>("/or/commands", 10);
   // m_silhouette_detection_pub = qtRosNode.getNodeHandle()->advertise<std_msgs::Empty>("/silhouette_detection/start_detection",10);
    //m_HandleDetectionPub = m_NodeHandle->advertise<door_detection_messages::DetectHandleControl>("/handle_detection/detect_handle_control", 10);

    //m_DoorDetectionPub = m_NodeHandle->advertise<door_detection_messages::DetectDoorControl>("/door_detection/detect_door_control", 10);

    //subscribers
    m_speechFinishedSubscriber = qtRosNode.getNodeHandle()->subscribe( "robot_face/talking_finished", 1, &MainWindow::speech_sub, this );
    m_TargetReachedSubscriber = qtRosNode.getNodeHandle()->subscribe< std_msgs::Empty>("/homer_navigation/target_reached", 1, &MainWindow::drive_sub_r, this);
    m_TargetUnreachableSubscriber = qtRosNode.getNodeHandle()->subscribe< homer_mapnav_msgs::TargetUnreachable>("/homer_navigation/target_unreachable", 1, &MainWindow::drive_sub_u, this);
    //m_finishedGrippingSubscriber = qtRosNode.getNodeHandle()->subscribe<homer_gripping::GrippingFinished>("/gripping/finished_gripping", 1, &MainWindow::grasp_sub, this);
    //m_releasedGripperSubscriber = qtRosNode.getNodeHandle()->subscribe<std_msgs::Empty>("/gripping/finished_releasing", 1, &MainWindow::drop_sub, this);
    m_userInputSubscriber =  qtRosNode.getNodeHandle()->subscribe<std_msgs::String>("recognized_speech", 1, &MainWindow::user_input_cb, this);
    //m_StartGameSubscriber = qtRosNode.getNodeHandle()->subscribe<std_msgs::Empty>("/start_game", 1, &MainWindow::startgame_cb, this);
    //m_armJointsSubsriber = qtRosNode.getNodeHandle()->subscribe<sensor_msgs::JointState>("/joint_states",1,&MainWindow::actual_joint_state_sub,this);
    // The next lines integrate the RVIZ Renderpanel. It loads a rviz file in which new markers and sensor information can be added
    render_panel_ = new rviz::RenderPanel();
    ui->frame->layout()->addWidget(render_panel_);
    manager_ = new rviz::VisualizationManager( render_panel_ );

    rviz::YamlConfigReader reader;
    rviz::Config config;
    std::string filename = ros::package::getPath("homer_gui")+"/config/homer_display.rviz" ;

    reader.readFile( config, QString::fromStdString( filename ));
    if( !reader.error() )
    {
        manager_->load( config.mapGetChild( "Visualization Manager" ));
    }
    render_panel_->initialize( manager_->getSceneManager(), manager_ );


    manager_->initialize();
    manager_->startUpdate();

    loadConfigValue("/homer_gui/sTaskfile", m_taskfile);
    ROS_INFO_STREAM("LOADING TASK "<<m_taskfile);
    this->loadTaskFile(m_taskfile);

    new QShortcut(QKeySequence(Qt::CTRL + Qt::Key_W), this, SLOT(driveForward()));
    new QShortcut(QKeySequence(Qt::CTRL + Qt::Key_S), this, SLOT(driveBackward()));
    new QShortcut(QKeySequence(Qt::CTRL + Qt::Key_A), this, SLOT(driveLeft()));
    new QShortcut(QKeySequence(Qt::CTRL + Qt::Key_D), this, SLOT(driveRight()));


    //for(unsigned i = 0; i < m_HardwareStateButtons.size(); i++)
    //{
        //// init each button as "false" (red)
        //m_HardwareStateButtons.at(i)->setStyleSheet("background-color: red; color: white;");
        //// save now as "last update time" for each button
        //m_HardwareLastUpdate.insert(std::pair<std::string,ros::Time>(m_HardwareStateButtons.at(i)->text().toStdString(),ros::Time::now()));
    //}
}


void MainWindow::on_butFakeUserInput_clicked()
{
    // std_msgs::String msg;
    std_msgs::String msg;
    QString qStr;
    qStr = ui->comboFakeUserInput->currentText();
    std::string str = qStr.toStdString();
    std::transform(str.begin(), str.end(),str.begin(), ::toupper); // make uppercase
    msg.data = str;
    fake_user_input_pub_.publish(msg);
}

void MainWindow::on_butSpeak_clicked()
{
    std_msgs::String msg;
    msg.data = ui->comboSpeechOut->currentText().toStdString();
    speech_out_pub_.publish(msg);
}



void MainWindow::on_turnPtuRight_clicked()
{
//    ptu::SetPanTilt msg;
//    msg.absolute = false;
//
//    msg.panAngle = -0.1;
//    msg.tiltAngle = 0.0;
//
//    set_pan_tilt_pub_.publish(msg);
}

void MainWindow::on_turnPtuLeft_clicked()
{
//    ptu::SetPanTilt msg;
//    msg.absolute = false;

//    msg.panAngle = 0.1;
//    msg.tiltAngle = 0.0;

//    set_pan_tilt_pub_.publish(msg);
}

void MainWindow::on_turnPtuUp_clicked()
{
//    ptu::SetPanTilt msg;
//    msg.absolute = false;

//    msg.panAngle = 0.0;
//    msg.tiltAngle = 0.1;

//    set_pan_tilt_pub_.publish(msg);
}

void MainWindow::on_turnPtuDown_clicked()
{
//    ptu::SetPanTilt msg;
//    msg.absolute = false;

//    msg.panAngle = 0.0;
//    msg.tiltAngle = -0.1;

//    set_pan_tilt_pub_.publish(msg);
}



void MainWindow::on_pushButtonSimpleActionsRemoveAll_clicked()
{
    if (!m_IsRunning){
        m_Tasklist.clear();
        ui->SimpleActions_List->clear();
    }
}


void MainWindow::on_pushButtonSimpleActionsRemoveOne_clicked()
{
    int index = ui->SimpleActions_List->currentRow();

    if (index == -1)
        return; //Nothing selected

    // remove the hear command and all commands to the next end label
    if(m_Tasklist.at(index).type == task::label || m_Tasklist.at(index).type == task::hear)
    {
        // go back and find the corresponding HEAR command
        int start_index = -1;
        for(int i = index; i >= 0; i--)
        {
            if(m_Tasklist.at(i).type == task::hear)
            {
                start_index = i;
                break;
            }
        }

        // remove everyting from HEAR to LABEL end
        if(start_index != -1)
        {
            task::Task temp_task;
            do
            {
                temp_task = m_Tasklist.at(start_index);
                delete ui->SimpleActions_List->item(start_index);
                m_Tasklist.erase(m_Tasklist.begin() + start_index);
            }
            while(!(temp_task.type == task::label && temp_task.parameter == "end"));
        }
    }
    else
    {
        // just remove item
        delete ui->SimpleActions_List->item(index);
        m_Tasklist.erase(m_Tasklist.begin() + index);
    }


}

void MainWindow::on_pushButtonSimpleActionsUp_clicked()
{
    //GUI
    QListWidgetItem *current = ui->SimpleActions_List->currentItem();
    int currIndex = ui->SimpleActions_List->row(current);

    if (currIndex == 0 || currIndex == -1)
        return;

    // don't allow LABEL and HEAR to be moved
    if(m_Tasklist.at(currIndex).type == task::label || m_Tasklist.at(currIndex).type == task::hear)
    {
        return;
    }

    QListWidgetItem *prev = ui->SimpleActions_List->item(ui->SimpleActions_List->row(current) - 1);
    int prevIndex = ui->SimpleActions_List->row(prev);

    QListWidgetItem *temp = ui->SimpleActions_List->takeItem(prevIndex);
    ui->SimpleActions_List->insertItem(prevIndex, current);
    ui->SimpleActions_List->insertItem(currIndex, temp);


    //Backend
    std::swap(m_Tasklist[currIndex],m_Tasklist[prevIndex]);
}


void MainWindow::on_pushButtonSimpleActionsDown_clicked()
{
    //GUI
    QListWidgetItem *current = ui->SimpleActions_List->currentItem();
    int currIndex = ui->SimpleActions_List->row(current);

    if (currIndex == ui->SimpleActions_List->count()-1 || currIndex == -1)
        return;

    // don't allow LABEL and HEAR to be moved
    if(m_Tasklist.at(currIndex).type == task::label || m_Tasklist.at(currIndex).type == task::hear)
    {
        return;
    }

    QListWidgetItem *next = ui->SimpleActions_List->item(ui->SimpleActions_List->row(current) + 1);
    int nextIndex = ui->SimpleActions_List->row(next);

    QListWidgetItem *temp = ui->SimpleActions_List->takeItem(nextIndex);
    ui->SimpleActions_List->insertItem(currIndex, temp);
    ui->SimpleActions_List->insertItem(nextIndex, current);

    //Backend
    std::swap(m_Tasklist[currIndex],m_Tasklist[nextIndex]);

}

void MainWindow::on_pushButtonSimpleActionsStart_clicked()
{
    ui->pushButtonSimpleActionsRemoveAll->setEnabled(false);
    ui->pushButtonSimpleActionsRemoveOne->setEnabled(false);
    ui->pushButtonSimpleActionsUp->setEnabled(false);
    ui->pushButtonSimpleActionsDown->setEnabled(false);
    ui->pushButtonSimpleActionsStart->setEnabled(false);
    ui->pushButtonSimpleActionsSave->setEnabled(false);
    ui->pushButtonSimpleActionsLoad->setEnabled(false);
    ui->SimpleActions_List->setEnabled(false);
    ui->pushButtonSimpleActionsStop->setEnabled(true);
    m_IsRunning = true;
    nextTask();
}


void MainWindow::on_pushButtonSimpleActionsStop_clicked()
{
    if (m_IsRunning){
        if (m_Tasklist.at(m_TaskIndex).type == task::drive){
            std_msgs::Empty msg;
            m_StopNavigationPublisher.publish(msg);
        }
        m_IsRunning = false;
        nextTask();
    }
}



void MainWindow::on_pushButtonSimpleActionsSave_clicked()
{
    QString filename = QFileDialog::getSaveFileName(this,tr("Save Task List"),QString(),tr("Task List Files (*.tsk)"));

    if (!filename.endsWith(".tsk"))
        filename += ".tsk";

    ofstream myfile (filename.toStdString().c_str());
    if (myfile.is_open())
    {
        for(int i = 0; i < m_Tasklist.size(); ++i)
        {
            myfile << m_Tasklist[i].type << "\n";
            myfile << m_Tasklist[i].parameter <<"\n";

        }
        myfile.close();
    }
    else ROS_WARN_STREAM("Unable to open file");
}


void MainWindow::loadTaskFile(const std::string taskfile)
{

    m_Tasklist.clear();
    ui->SimpleActions_List->clear();

    std::string line;
    ifstream myfile (taskfile.c_str());
    if (myfile.is_open())
    {
        while ( getline (myfile,line) )
        {

            task::Task tsk;
            int tp = atoi(line.c_str());
            tsk.type = static_cast<task::TaskType>(tp);
            getline (myfile,tsk.parameter);

            QString tp_s;
            switch (tsk.type) {
            case task::drive:
                tp_s = "Drive to";
                break;
            case task::grasp:
                tp_s = "Grip";
                break;
            case task::speak:
                tp_s = "Speak";
                break;
            case task::drop:
                tp_s = "Drop";
                break;
            case task::hear:
                tp_s = "Hear";
                break;
            case task::label:
                tp_s = "    Label";
                break;
            default:
                tp_s = "ERROR";
                break;
            }

            //Add Task
            m_Tasklist.push_back(tsk);
            QString tmp = tp_s + " - " + QString::fromStdString(tsk.parameter);
            ui->SimpleActions_List->addItem(tmp);
        }
        myfile.close();
    }

    else ROS_WARN_STREAM("Unable to open file");
}


void MainWindow::on_pushButtonSimpleActionsLoad_clicked()
{
    QString filename = QFileDialog::getOpenFileName(this,tr("Load Task List"),QString(),tr("Task List Files (*.tsk)"));
    loadTaskFile(filename.toStdString());

}

void MainWindow::on_pushButtonSimpleActionsAdd_clicked()
{
    task::Task tsk;

    //ComboValue to Tasktype
    QString txt = ui->SimpleActions_Combo->currentText();

    if      (txt == "Speak")    tsk.type = task::speak;
    else if (txt == "Grip")     tsk.type = task::grasp;
    else if (txt == "Drive to") tsk.type = task::drive;
    else if (txt == "Drop")     tsk.type = task::drop;
    else if (txt == "Hear")     tsk.type = task::hear;
    else return; //ERROR!

    //Edit to Parameter
    tsk.parameter = ui->SimpleActions_Edit->text().toStdString();

    //Error Cases
    if (tsk.parameter == "" && (tsk.type == task::speak || tsk.type == task::drive))
    {
        return;
    }

    //Add Task
    m_Tasklist.push_back(tsk);
    ui->SimpleActions_List->addItem(txt+" - "+ui->SimpleActions_Edit->text());

    // special treatment of hear: for any comma separated word that can be heard, insert a label with this word
    if(txt == "Hear")
    {
        // divide input in separate comma separated words
        std::vector<std::string> local_words_to_hear = homer::splitString(tsk.parameter, ",");
        for(unsigned i = 0; i < local_words_to_hear.size(); i++)
        {
            std::string s = local_words_to_hear.at(i);
            task::Task label_tsk;
            label_tsk.type = task::label;
            label_tsk.parameter = s;
            m_Tasklist.push_back(label_tsk);
            ui->SimpleActions_List->addItem(QString("    Label")+" - "+QString::fromStdString(s));
        }
        // at the end add "end label"
        task::Task label_tsk;
        label_tsk.type = task::label;
        label_tsk.parameter = "end";
        m_Tasklist.push_back(label_tsk);
        ui->SimpleActions_List->addItem(QString("    Label")+" - "+QString("end"));
    }
}

void MainWindow::nextTask()
{
    ++m_TaskIndex;
    if (m_Tasklist.size()<=m_TaskIndex || m_IsRunning == false)
    {
        ui->pushButtonSimpleActionsRemoveAll->setEnabled(true);
        ui->pushButtonSimpleActionsRemoveOne->setEnabled(true);
        ui->pushButtonSimpleActionsUp->setEnabled(true);
        ui->pushButtonSimpleActionsDown->setEnabled(true);
        ui->pushButtonSimpleActionsSave->setEnabled(true);
        ui->pushButtonSimpleActionsLoad->setEnabled(true);
        ui->pushButtonSimpleActionsStart->setEnabled(true);
        ui->SimpleActions_List->setEnabled(true);
        ui->pushButtonSimpleActionsStop->setEnabled(false);
        m_TaskIndex = -1;
        m_IsRunning = false;
        return;
    }

    std::stringstream info;
    info << "Next Task is \"";

    task::TaskType ntype = m_Tasklist.at(m_TaskIndex).type;
    std::string nParameter = m_Tasklist.at(m_TaskIndex).parameter;

    if (ntype == task::speak)
    {
        info << "speaking";
        std_msgs::String msg;
        msg.data = nParameter;
        speech_out_pub_.publish(msg);
    }
    else if (ntype == task::grasp)
    {
        //info << "grasping";
        //homer_gripping::GripObject msg;
        //msg.name = nParameter;
        //msg.feedback = false;
        //grip_object_pub_.publish(msg);
    }
    else if (ntype == task::drive)
    {
        info << "driving";
        homer_mapnav_msgs::NavigateToPOI msg;
        msg.poi_name = nParameter;
        msg.distance_to_target = 0.03f;
        start_navigation_pub_.publish(msg);
    }
    else if  (ntype == task::drop)
    {
        info << "dropping";
        std_msgs::Bool msg;
        msg.data=true;
        release_object_pub_.publish(msg);
    }
    else if(ntype == task::hear)
    {
        info << "listening (hearing)";
        m_words_to_hear = homer::splitString(nParameter, ",");
    }
    else if(ntype == task::label)
    {
        // note: a valid label is never processed in this method (see MainWindow::user_input_cb)
        // thus, a label task means that the program should go to "label - end"
        task::Task tsk;
        for(unsigned i = m_TaskIndex; i < m_Tasklist.size(); i++)
        {
            tsk = m_Tasklist.at(i);
            if(tsk.type == task::label && tsk.parameter == "end")
            {
                m_TaskIndex = i;
                nextTask();
                return;
            }
        }
    }
    else
    {
        ROS_WARN_STREAM("UNKNOWN TASKTYPE - continue with next task.");
        nextTask();
        return;
    }

    info << "\". Parameter is \"" << nParameter << "\"";
    ROS_INFO_STREAM(info.str());
}

//Callbacks
void MainWindow::speech_sub(const std_msgs::String::ConstPtr& msg)
{
    if (m_IsRunning && (m_TaskIndex < m_Tasklist.size()) && m_Tasklist.at(m_TaskIndex).type == task::speak)
    {
        nextTask();
    }
    else
    {
        ROS_WARN_STREAM("SPEECH_SUB: Invalid CALLBACK received!");
    }
}

void MainWindow::drive_sub_r(const std_msgs::Empty::ConstPtr &msg)
{
    if (m_IsRunning && (m_TaskIndex < m_Tasklist.size()) && m_Tasklist.at(m_TaskIndex).type == task::drive)
    {
        nextTask();
    }
    else
    {
        ROS_WARN_STREAM("DRIVE_SUB: Invalid CALLBACK received!");
    }
}

void MainWindow::drive_sub_u(const homer_mapnav_msgs::TargetUnreachable::ConstPtr& msg )
{
    if (m_IsRunning && (m_TaskIndex < m_Tasklist.size()) && m_Tasklist.at(m_TaskIndex).type == task::drive)
    {
        nextTask();
    }
    else
    {
        ROS_WARN_STREAM("DRIVE_SUB: Invalid CALLBACK received!");
    }
}

void MainWindow::drop_sub(const std_msgs::Empty::ConstPtr & msg)
{
    if (m_IsRunning && (m_TaskIndex < m_Tasklist.size()) && m_Tasklist.at(m_TaskIndex).type == task::drop)
    {
        nextTask();
    }
    else
    {
        ROS_WARN_STREAM("DROP_SUB: Invalid CALLBACK received!");
    }
}

/*void MainWindow::grasp_sub(const homer_gripping::GrippingFinished::ConstPtr &msg)
{
    if (m_IsRunning && (m_TaskIndex < m_Tasklist.size()) && m_Tasklist.at(m_TaskIndex).type == task::grasp)
    {
        nextTask();
    }
    else
    {
        ROS_WARN_STREAM("GRASP_SUB: Invalid CALLBACK received!");
    }
}
*/

void MainWindow::user_input_cb( const std_msgs::String::ConstPtr& msg )
{
    if (m_IsRunning && (m_TaskIndex < m_Tasklist.size()) && m_Tasklist.at(m_TaskIndex).type == task::hear)
    {
        // check which word was recognized
        std::string heard_word = "";
        for(unsigned i = 0; i < m_words_to_hear.size(); i++)
        {
            std::string s = m_words_to_hear.at(i);
            std::string recognition = homer::lowercase(msg->data);
            if(recognition == s)
            {
                heard_word = s;
                break;
            }
        }

        // only if something was recognized proceed to next task
        if(heard_word != "")
        {
            // look for label that corresponds to heard word
            for(int i = m_TaskIndex+1; i < m_Tasklist.size(); i++)
            {
                task::Task tsk = m_Tasklist.at(i);
                if(tsk.type == task::label && tsk.parameter == heard_word)
                {
                    // set to i to skip the line "label - heard_word", i.e. the valid label does not appear during nextTask()
                    // that way every "label" found in nextTask() means "go to: label - end"
                    m_TaskIndex = i;
                    break;
                }
            }
            nextTask();
        }
    }
    else
    {
        ROS_WARN_STREAM("HEAR_SUB: Invalid CALLBACK received! --- isRunning: " << m_IsRunning << " index, size: " << m_TaskIndex << "," << m_Tasklist.size());
    }
}




void MainWindow::on_pushButtonRobotTaskFinished_clicked()
{
    std_msgs::Empty msg;
    m_robot_platform_task_finished_pub_.publish(msg);
}

void MainWindow::on_pushButtonReleasedFinished_clicked()
{
    std_msgs::Empty msg;
    m_release_finished_pub_.publish(msg);
}


void MainWindow::on_pushButtonDetectedPerson_clicked()
{
//    ptu_person_detection::ptu_search_persons msg;
//    m_detected_person_pub_.publish(msg);
}



void MainWindow::on_pushButtonTalkingFinished_clicked()
{
    std_msgs::String msg;
    m_finished_talking_pub_.publish(msg);
}

void MainWindow::on_pushButtonGruppingFinished_clicked()
{
//    homer_gripping::GrippingFinished msg;
//    m_finished_gripping_pub_.publish(msg);

}

//buttons for object recognition tab


void MainWindow::on_LoadBgdpushButton_clicked()
{
    QStringList files = QFileDialog::getOpenFileNames ( this, tr ( "Load Image" ), m_LastOpenPath,NULL,NULL, QFileDialog::DontUseNativeDialog);

    for ( int i = 0; i < files.size(); i++ )
    {
        QString file=files.at ( i );
        QDir fileDir ( file );
        fileDir.cdUp();
        m_LastOpenPath = fileDir.absolutePath();


        or_msgs::OrLearnCommand learnCommandMsg;
        learnCommandMsg.command = ORLearningModule::LoadBackgroundImage;
        learnCommandMsg.string_value = file.toStdString();
        m_ORLearnCommandPublisher.publish(learnCommandMsg);

    }
}

void MainWindow::on_GrabBgdpushButton_clicked()
{

    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::GrabBackgroundImage;
    //learnCommandMsg.int_value = m_CameraId; // TODO
    m_ORLearnCommandPublisher.publish(learnCommandMsg);

}

void MainWindow::on_GrabFgdpushButton_clicked()
{


    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::GrabForegroundImage;
    //learnCommandMsg.int_value = m_CameraId; // TODO
    m_ORLearnCommandPublisher.publish(learnCommandMsg);

}

void MainWindow::on_LoadFgdpushButton_clicked()
{
    QStringList files = QFileDialog::getOpenFileNames ( this, tr ( "Load Image" ), m_LastOpenPath,NULL,NULL,QFileDialog::DontUseNativeDialog );

    for ( int i = 0; i < files.size(); i++ )
    {
        QString file=files.at ( i );
        QDir fileDir ( file );
        fileDir.cdUp();
        m_LastOpenPath = fileDir.absolutePath();


        or_msgs::OrLearnCommand learnCommandMsg;
        learnCommandMsg.command = ORLearningModule::LoadForegroundImage;
        learnCommandMsg.string_value = file.toStdString();
        m_ORLearnCommandPublisher.publish(learnCommandMsg);

    }
}

void MainWindow::on_MaskOpenRadiushorizontalSlider_valueChanged(int value)
{
    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SetOpenRadius;
    learnCommandMsg.int_value = value;
    m_ORLearnCommandPublisher.publish(learnCommandMsg);
}

void MainWindow::on_AdditionalBorderhorizontalSlider_valueChanged(int value)
{
    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SetBorderSize;
    learnCommandMsg.int_value = value;
    m_ORLearnCommandPublisher.publish(learnCommandMsg);

}

void MainWindow::on_BgdDeletionThresholdhorizontalSlider_valueChanged(int value)
{
    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SetDifferenceThreshold;
    learnCommandMsg.int_value = value;
    m_ORLearnCommandPublisher.publish(learnCommandMsg);

}

void MainWindow::on_SingleSegmentcheckBox_stateChanged(int state)
{
    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SetIsolateLargestSegment;

    if ( state == Qt::Checked ) {
        learnCommandMsg.string_value = "true";
    } else if ( state == Qt::Unchecked ) {
        learnCommandMsg.string_value = "false";
    }

    m_ORLearnCommandPublisher.publish(learnCommandMsg);

}

void MainWindow::on_RemoveImagepushButton_clicked()
{
    if (m_SelectedRow < ui->imagetable->rowCount() )
    {

        or_msgs::OrLearnCommand learnCommandMsg;
        learnCommandMsg.command = ORLearningModule::DeleteImage;
        learnCommandMsg.int_value = m_SelectedRow;
        m_ORLearnCommandPublisher.publish(learnCommandMsg);
    }

}


void MainWindow::on_ResetpushButton_clicked()
{
    //starting from last row of the table delete the elements, till you rich the row 0
    //int i=ui->imagetable->rowCount()-1;
    //  while( i >=0 )
    // {
    //   m_SelectedRow=i;
    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::Reset;
    // learnCommandMsg.int_value =m_SelectedRow;
    m_ORLearnCommandPublisher.publish(learnCommandMsg);
    ui->imagetable->setRowCount ( 0 );

    //i--;

    //}

}

void MainWindow::on_objectTypecomboBox_activated(const QString type)
{
    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SetObjectType;
    learnCommandMsg.string_value = type.toStdString();
    m_ORLearnCommandPublisher.publish(learnCommandMsg);
}

void MainWindow::on_savepushButton_clicked()
{
    std::string objName = ( ui->objectNameField->text() ).toStdString();
    std::string objType = ui->objectTypecomboBox->currentText().toStdString();

    //TRACE_INFO ( "Creating Template '" + objName + "' with type '" + objType + "'" ); // TODO use ros


    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SetObjectType;
    learnCommandMsg.string_value = objType;
    m_ORLearnCommandPublisher.publish(learnCommandMsg);

    or_msgs::OrLearnCommand learnCommandMsg2;
    learnCommandMsg2.command = ORLearningModule::SaveObject;
    learnCommandMsg2.string_value = objName;
    m_ORLearnCommandPublisher.publish(learnCommandMsg2);


    ui->imagetable->setRowCount ( 0 );
    ui->objectNameField->clear();
    // ui->savepushButton->setEnabled (false);
}

void MainWindow::on_imagetable_cellClicked(int row, int column)
{
    m_SelectedRow = row;
    updateTable();
}
void MainWindow::checkForEnableButtons()
{
    ui->savepushButton->setEnabled( ( ui->objectNameField->displayText().length() > 0 ) && ( ui->imagetable->rowCount() > 0 ) );
}

void MainWindow::updateTable()
{

    QColor rowColor1 ( 235,235,235 );
    QColor rowColor2 ( 180,180,180 );
    for ( int i = 0; i <ui->imagetable->rowCount(); i++ )
    {
        if ( i == m_SelectedRow)
        {
            ui->imagetable->item ( i,0 )->setBackgroundColor ( rowColor2 );
            ui->imagetable->item ( i,1 )->setBackgroundColor ( rowColor2 );
        }
        else
        {
            ui->imagetable->item ( i,0 )->setBackgroundColor ( rowColor1 );
            ui->imagetable->item ( i,1 )->setBackgroundColor ( rowColor1 );
        }
    }

    ui->removeImagepushButton->setEnabled( m_SelectedRow<ui->imagetable->rowCount() );
    //ui->savepushButton->setEnabled( ( ui->objectNameField->displayText().length() > 0 ) && ( ui->imagetable->rowCount() > 0 ) );
    //saveObjectButton->setEnabled ( true ); // TODO remove after test

    if ( m_SelectedRow< ui->imagetable->rowCount() )
    {
        or_msgs::OrLearnCommand learnCommandMsg;
        learnCommandMsg.command = ORLearningModule::DisplayImage;
        learnCommandMsg.int_value =m_SelectedRow;
        m_ORLearnCommandPublisher.publish(learnCommandMsg);
    }

    else
    {
        ui->imagetable->setCurrentCell( 99999,0);
    }
}

void MainWindow::on_addImagepushButton_clicked()
{
    std::string name = (ui->imageNamelineEdit->text() ).toStdString();

    or_msgs::OrLearnCommand learnCommandMsg;
    learnCommandMsg.command = ORLearningModule::SaveImage;
    learnCommandMsg.string_value = name;
    m_ORLearnCommandPublisher.publish(learnCommandMsg);


    //pre-select new image
    m_SelectedRow = ui->imagetable->rowCount();
    ROS_INFO_STREAM("selected row is "<<m_SelectedRow);
    //images could be saved now, but the objectNameField must not be empty, check for it in checkForEnableButtons
    checkForEnableButtons();

}

void MainWindow::on_removeImagepushButton_clicked()
{
    if ( m_SelectedRow < ui->imagetable->rowCount() )
    {
        or_msgs::OrLearnCommand learnCommandMsg;
        learnCommandMsg.command = ORLearningModule::DeleteImage;
        learnCommandMsg.int_value = m_SelectedRow;
        m_ORLearnCommandPublisher.publish(learnCommandMsg);
    }
}


void MainWindow::StartRecognitionLoop()
{
    or_msgs::OrCommand commandMsg;
    commandMsg.command = ORControlModule::StartRecognitionLoop;
    commandMsg.int_value = 1; // todo this is a fake number: remove it
    m_ORCommandPublisher.publish(commandMsg);
}

void MainWindow::StopRecognitionLoop()
{

    or_msgs::OrCommand commandMsg;
    commandMsg.command = ORControlModule::StopRecognitionLoop;
    m_ORCommandPublisher.publish(commandMsg);
}

void MainWindow::on_GrabImagepushButton_clicked()
{



    or_msgs::OrCommand commandMsg;
    commandMsg.command = ORControlModule::GrabSingleImage;
    commandMsg.int_value = 1; // TODO handle camera id in receiving node - use ros topics for cameraid
    m_ORCommandPublisher.publish(commandMsg);

}

void MainWindow::on_LoadImagepushButton_clicked()
{
    //for unknown reason the fileDialog didn't work properly, DontUseNativeDialog is added to resolve
    QStringList files = QFileDialog::getOpenFileNames( this, tr ( "Select Object" ),m_LastOpenPath,tr("Image Files (*.png *.jpg *.bmp)"), NULL, QFileDialog::DontUseNativeDialog );

    for ( int i = 0; i < files.size(); i++ )
    {
        QString file=files.at ( i );
        QDir fileDir ( file );
        fileDir.cdUp();
        m_LastOpenPath = fileDir.absolutePath();

        or_msgs::OrCommand commandMsg;
        commandMsg.command = ORControlModule::LoadSingleImage;
        commandMsg.string_value = file.toStdString();
        m_ORCommandPublisher.publish(commandMsg);
    }
}
void MainWindow::on_loadObjectpushButton_clicked()
{

    QStringList files = QFileDialog::getOpenFileNames ( this, tr ( "Select Object" ), m_LastImageFolder, "Object Properties (*.objprop)\nAll files (*)",NULL, QFileDialog::DontUseNativeDialog );
    if( files.size()>0)
    {
        QFileInfo fileInfo( files[0] );
        QString base = fileInfo.baseName();
        QString absolutePath = fileInfo.absoluteFilePath();


        ROS_INFO_STREAM("base: " << base.toStdString());
        ROS_INFO_STREAM("absolutePath: " << absolutePath.toStdString());

        or_msgs::OrLearnCommand learnCommandMsg;
        learnCommandMsg.command = ORLearningModule::LoadObject;
        learnCommandMsg.string_value = absolutePath.toStdString();
        m_ORLearnCommandPublisher.publish(learnCommandMsg);
        ui->objectNameField->setText( base );
    }

}
void MainWindow::loadObject(std::string file){
    // file contains absolut path, here the directory is removed to retain only <objname>.objprops
    int slashPos = file.find_last_of( '/' );
    // here the file extension .objprops is removed
    file = file.substr( slashPos, file.length() - slashPos - 8 );

    std::cerr << "Loading object file: " << file << std::endl;


    or_msgs::OrCommand commandMsg;
    commandMsg.command = ORControlModule::LoadObject;
    commandMsg.string_value = file;
    m_ORCommandPublisher.publish(commandMsg);


}

void MainWindow::on_removeObjectpushButton_clicked()
{
    // if ( ( m_SelectedRow >= 0 ) && ( m_SelectedRow < ui->objecttableWidget->rowCount() ) )
    int currentRow=ui->objecttableWidget->currentRow();
    if ( ( currentRow> -1 ) && ( currentRow < ui->objecttableWidget->rowCount() ))

    {
        string name = ui->objecttableWidget->item ( currentRow, 1 )->text().toStdString();


        or_msgs::OrCommand commandMsg;
        commandMsg.command = ORControlModule::UnloadObject;
        commandMsg.string_value = name;
        m_ORCommandPublisher.publish(commandMsg);
    }

}
void MainWindow::updateDisplay()
{

}

void MainWindow::updateImageTable(std::vector<string> imageNames, string objType)
{
    ui->imagetable->setRowCount ( 0 );

    for ( unsigned i = 0; i < imageNames.size(); i++ )
    {
        int indexRow = ui->imagetable->rowCount();
        //create item with index number
        ui->imagetable->insertRow ( indexRow );
        std::ostringstream s;
        s << i;
        QTableWidgetItem* item = new QTableWidgetItem ( QString::fromStdString(s.str()) );
        item->setTextAlignment ( Qt::AlignCenter );
        item->setFlags ( Qt::ItemIsSelectable );
        ui->imagetable->setItem ( indexRow, 0, item );

        //create item with basename
        item = new QTableWidgetItem ( QString ( imageNames[i].c_str() ) );
        item->setTextAlignment ( Qt::AlignCenter );
        item->setFlags ( Qt::ItemIsSelectable );
        ui->imagetable->setItem ( indexRow, 1, item );
    }

    updateTable();

    ui->objectTypecomboBox->setCurrentIndex( ui->objectTypecomboBox->findText( objType.c_str() ) );

}



void MainWindow::on_StartRecognitionpushButton_clicked()
{
    or_msgs::OrCommand commandMsg;
    commandMsg.command = ORControlModule::StartRecognitionLoop;
    commandMsg.int_value = 1; // TODO remove camera id
    m_ORCommandPublisher.publish(commandMsg);
}

void MainWindow::on_StopRecognitionpushButton_clicked()
{
    or_msgs::OrCommand commandMsg;
    commandMsg.command = ORControlModule::StopRecognitionLoop;
    m_ORCommandPublisher.publish(commandMsg);
}



void MainWindow::on_loadObjectRecognitionpushButton_clicked()
{
    QStringList files = QFileDialog::getOpenFileNames ( this, tr ( "Load Object" ), m_LastOpenPath,"Objectproperties (*.objprop)",NULL, QFileDialog::DontUseNativeDialog );

    for ( int i = 0; i < files.size(); i++ )
    {
        //        QString file=files.at ( i );
        //        QDir fileDir ( file );
        //        fileDir.cdUp();
        //        m_LastOpenPath = fileDir.absolutePath();

        QFileInfo fileInfo( files.at ( i ) );
        QString absolutePath = fileInfo.absoluteFilePath();

        std::cerr << "m_LastOpenPath: " << absolutePath.toStdString() << std::endl;

        string file = absolutePath.toStdString() ;

        // file contains absolut path, here the directory is removed to retain only <objname>.objprops
        int slashPos = file.find_last_of( '/' );
        // here the file extension .objprops is removed
        file = file.substr( slashPos, file.length() - slashPos - 8 );

        std::cerr << "Loading object file: " << file << std::endl;
        {
            or_msgs::OrCommand commandMsg;
            commandMsg.command = ORControlModule::LoadObject;
            commandMsg.string_value = file;
            m_ORCommandPublisher.publish(commandMsg);
        }
    }
}
void MainWindow::updateObjectTable(std::vector<std::string> names, std::vector<std::string> types)
{
    ROS_INFO_STREAM("Updating Object Table, new size: " << names.size());

    ui->objecttableWidget->setSortingEnabled ( false );

    //save old state of checkboxes and recognition
    //QVector< std::string > UncheckedObjects;
    QVector< std::string > m_RecognizedObjects;
    for ( int i=0;i<ui->objecttableWidget->rowCount();++i )
    {
        //  if ( ui->objecttableWidget->item ( i,0 )->checkState() ==Qt::Unchecked )
        // {
        //   UncheckedObjects.push_back ( ui->objecttableWidget->item ( i,1 )->text().toStdString() );
        // }
        if ( ui->objecttableWidget->item ( i,0 )->backgroundColor() == ( QColor ( 0,0,0 ) ) )
        {
            m_RecognizedObjects.push_back ( ui->objecttableWidget->item ( i,1 )->text().toStdString() );
        }
    }

    ui->objecttableWidget->setRowCount ( 0 );
    ui->objecttableWidget->clearContents();

    QColor rowColor ( 235,235,235 );

    for(unsigned pos = 0; pos < names.size(); pos++)
    {
        std::string name = names.at(pos);
        int indexRow = ui->objecttableWidget->rowCount();
        m_ObjectRows[name] = indexRow;
        ui->objecttableWidget->insertRow ( indexRow );
        QString s;
        s.setNum(pos);
        //create item without checkbox
        QTableWidgetItem* item = new QTableWidgetItem(s);
        item->setBackground ( rowColor );
        ui->objecttableWidget->setItem ( indexRow,0,item );


        //keep state of checkboxes
        //    if ( UncheckedObjects.contains ( names.at(pos).c_str() ) )
        //   {
        //     ui->objecttableWidget->item ( indexRow,0 )->setCheckState ( Qt::Unchecked );
        // }
        //else
        // {
        //    ui->objecttableWidget->item ( indexRow,0 )->setCheckState ( Qt::Checked );
        //}
        //highlight recognized table entries
        if ( m_RecognizedObjects.contains ( names.at(pos).c_str() ) )
        {
            ui->objecttableWidget->item ( indexRow,0 )->setBackgroundColor ( QColor ( 0,0,0 ) );
        }

        //create item with object name
        QString objectName = QString::fromStdString ( name );
        item = new QTableWidgetItem ( objectName );
        item->setBackground ( rowColor );
        ui->objecttableWidget->setItem ( indexRow,1,item );

        //create item with object type
        item = new QTableWidgetItem ( QString ( types.at(pos).c_str() ) );
        item->setBackground ( rowColor );
        item->setTextAlignment ( Qt::AlignCenter );
        ui->objecttableWidget->setItem ( indexRow,2,item );

        //select row in table that was just added
        ui->objecttableWidget->selectRow ( indexRow );
        ui->objecttableWidget->scrollToItem ( ui->objecttableWidget->item ( indexRow,1 ), QAbstractItemView::EnsureVisible );
    }
    ui->objecttableWidget->setSortingEnabled ( true );
    ui->objecttableWidget->sortItems ( 1, Qt::AscendingOrder );
    ui->objecttableWidget->resizeColumnToContents ( 0 );
    // ui->removeObjectpushButton->setEnabled ( false );
    ui->objectsGroupBox->setText ( "Objects ("+QString::number ( ui->objecttableWidget->rowCount() ) +")" );

}

void MainWindow::processObjectNames(std::vector<std::string> names, std::vector<std::string> types)
{
    this->updateObjectTable(names, types);

}

