#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QProcess>
#include <QComboBox>
#include <QHash>
#include <QTabBar>

#include "talker.h"
//#include "listener.h"
#include "ButtonProcessAdministrator.h"

#include <vector>
#include <iostream>

#include <ros/node_handle.h>
#include <ros/publisher.h>
#include <ros/package.h>

#include "Containers/MapTab/MapTab.h"

#include <tf/transform_listener.h>
#include <std_msgs/Empty.h>
#include <std_msgs/Bool.h>
#include <std_msgs/String.h>
#include <std_msgs/Float64.h>

#include <std_msgs/Empty.h>
#include <homer_mapnav_msgs/NavigateToPOI.h>
#include <std_msgs/String.h>
//added for object recognition
#include <or_msgs/OrLearnCommand.h>
#include <or_msgs/OrCommand.h>
#include <or_nodes/Modules/ORLearningModule.h>
//
#include <homer_mapnav_msgs/TargetUnreachable.h>
#include <homer_mapnav_msgs/StopNavigation.h>

#include <ImageDisplay.h>

#include "QtRosNode.h"

//#include "tools/Robot.h"
#include <homer_nav_libs/tools/loadRosConfig.h>
#include "XmlStreamReader.h"


#define pi 3.1415
namespace rviz
{
class Display;
class RenderPanel;
class VisualizationManager;
class DisplaysPanel;
}

namespace cv {
class Mat;
}

namespace Ui {
class MainWindow;
}

namespace task {
enum TaskType {
    speak = 0,
    grasp,
    drive,
    drop,
    hear,
    label
};

struct Task {
    TaskType type;
    std::string parameter;
};

}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:

    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    //path for open dialog
    QString m_LastOpenPath;
    //member variables for the object training table
    int m_SelectedRow;
    QString m_LastImageFolder;
    //    bool eventFilter(QObject *object, QEvent *e);
    void setQtRosNode(QtRosNode& qtRosNode);

    ros::Publisher move_robot_pub_;
    ros::Publisher turn_robot_pub_;
    ros::Publisher stop_robot_pub_;
    ros::Publisher start_game_pub_;
    ros::Publisher detect_doors_pub_;
    ros::Publisher fake_user_input_pub_;
    ros::Publisher speech_out_pub_;
    ros::Publisher set_pan_tilt_pub_;
    ros::Publisher detect_objects_pub_;
    ros::Publisher detected_objects_pub_;
    ros::Publisher grip_object_pub_;
    ros::Publisher unblock_katana_pub_;
    ros::Publisher release_object_pub_;
    ros::Publisher arm_safe_pub_;
    ros::Publisher arm_transport_pub_;
    ros::Publisher target_reached_pub_;
    ros::Publisher detect_planes_pub_;
    ros::Publisher rotate_gripper_pub_;
    ros::Publisher repeat_speech_pub_;
    ros::Publisher face_detection_pub_;
    ros::Publisher reset_katana_pub_;
    ros::Publisher open_oven_pub_;
    ros::Publisher start_navigation_pub_;
    ros::Publisher m_robot_platform_task_finished_pub_;
    ros::Publisher m_StopNavigationPublisher;
    ros::Publisher m_release_finished_pub_;
    ros::Publisher m_arm_path_to_point_pub_;
    ros::Publisher m_arm_path_to_configuration_pub_;
    ros::Publisher m_arm_linear_path_pub_;
    ros::Publisher m_armMoveFinishedPub;
    ros::Publisher m_armPathFinishedPub ;
    //ros::Publisher m_detected_objects_pub_;
    ros::Publisher m_detected_person_pub_;
    ros::Publisher m_finished_talking_pub_;
    ros::Publisher m_finished_gripping_pub_;
    ros::Publisher m_ORLearnCommandPublisher;
    ros::Publisher m_ORCommandPublisher;
    ros::Publisher m_silhouette_detection_pub;
    //Subscribers
    ros::Subscriber m_speechFinishedSubscriber;
    ros::Subscriber m_TargetReachedSubscriber;
    ros::Subscriber m_TargetUnreachableSubscriber;
    //ros::Subscriber m_finishedGrippingSubscriber;
    ros::Subscriber m_releasedGripperSubscriber;
    ros::Subscriber m_userInputSubscriber;
    //ros::Subscriber m_hardware_state_sub;
    //subscriber to katana joint positions
    ros::Subscriber  m_armJointsSubsriber;
    ros::Subscriber m_StartGameSubscriber;

    tf::TransformListener m_tfListener ;

    //ros::Subscriber speech_out_sub_;
    //    void updateData();
    //
    //

signals:
    void changedActiveTab();

private slots:
    void on_butFakeUserInput_clicked();

    void on_butSpeak_clicked();


    void driveForward();
    void driveBackward();
    void driveLeft();
    void driveRight();

    void on_turnPtuRight_clicked();
    void on_turnPtuLeft_clicked();
    void on_turnPtuUp_clicked();
    void on_turnPtuDown_clicked();


    void updateImageTable(std::vector<std::string> imageNames, std::string objType);
    void processObjectNames(std::vector<std::string> names, std::vector<std::string> types);
    void updateObjectTable(std::vector<std::string> names, std::vector<std::string> types);

    //Simple Actions
    void on_pushButtonSimpleActionsRemoveAll_clicked();
    void on_pushButtonSimpleActionsRemoveOne_clicked();
    void on_pushButtonSimpleActionsUp_clicked();
    void on_pushButtonSimpleActionsDown_clicked();
    void on_pushButtonSimpleActionsStart_clicked();
    void on_pushButtonSimpleActionsStop_clicked();
    void on_pushButtonSimpleActionsSave_clicked();
    void on_pushButtonSimpleActionsLoad_clicked();
    void on_pushButtonSimpleActionsAdd_clicked();
    void nextTask();
    void speech_sub(const std_msgs::String::ConstPtr &msg);
    void drive_sub_r(const std_msgs::Empty::ConstPtr& msg );
    void drive_sub_u(const homer_mapnav_msgs::TargetUnreachable::ConstPtr &msg);
    void drop_sub(const std_msgs::Empty::ConstPtr &msg);
    //void grasp_sub(const homer_gripping::GrippingFinished::ConstPtr& msg);
    void user_input_cb( const std_msgs::String::ConstPtr& msg );
    //--------------------------------------------------------------------- !----
    //-----------------------------------------------------------------------
    void on_pushButtonRobotTaskFinished_clicked();

    void on_pushButtonReleasedFinished_clicked();

    void on_pushButtonDetectedPerson_clicked();

    void on_pushButtonTalkingFinished_clicked();

    void on_pushButtonGruppingFinished_clicked();

    void on_LoadBgdpushButton_clicked();

    void on_LoadFgdpushButton_clicked();

    void on_GrabBgdpushButton_clicked();

    void on_GrabFgdpushButton_clicked();

    void on_MaskOpenRadiushorizontalSlider_valueChanged(int value);

    void on_AdditionalBorderhorizontalSlider_valueChanged(int value);

    void on_BgdDeletionThresholdhorizontalSlider_valueChanged(int value);

    void on_SingleSegmentcheckBox_stateChanged(int state);

    void on_RemoveImagepushButton_clicked();

    void on_loadObjectpushButton_clicked();

    void on_ResetpushButton_clicked();

    void on_addImagepushButton_clicked();

    void on_objectTypecomboBox_activated(const QString type);

    void on_savepushButton_clicked();

    void on_imagetable_cellClicked(int row, int column);
    //a slot/function for checking to set the buttons which shouldn't always be enabled
    void checkForEnableButtons();


    void on_removeImagepushButton_clicked();


    void StartRecognitionLoop();

    void StopRecognitionLoop();

    void on_GrabImagepushButton_clicked();

    void on_LoadImagepushButton_clicked();
    void loadObject(std::string file);

    void on_removeObjectpushButton_clicked();
    void updateDisplay();



    void on_StartRecognitionpushButton_clicked();

    void on_StopRecognitionpushButton_clicked();



    void on_loadObjectRecognitionpushButton_clicked();



public slots:

    void readStandardOutPut();

private:


    Ui::MainWindow *ui;
    Talker* m_Talker;
    MapTab* m_MapTab;

    //belonging to the objecttableWidget
    std::map< std::string, int > m_ObjectRows;
    //QtWidgets paranted by this window (no need for smart pointers)
    rviz::VisualizationManager* manager_;
    rviz::VisualizationManager* manager2_;
    rviz::RenderPanel* render_panel_;
    rviz::DisplaysPanel* display_panel_;
    rviz::Display* grid_;
    rviz::Display* laser_;
    ImageDisplay* kinect_rgb_image_display_;
    ImageDisplay* any_rgb_image_display_;
    ImageDisplay* m_kinectLiveImageWidget;
    ImageDisplay* m_kinectLiveImageWidget_2;
    ImageDisplay* m_kinectLiveImageWidget_3;
    ImageDisplay* m_kinectViewFrame;
    //pointer to objectNameField in the ui
    QLineEdit* m_objectFileName;
    void loadFilesIntoComboBox(std::string filePath, std::string ext, QComboBox* cb);
    //void hardwareStateCallback( const hardware_state::HardwareState::ConstPtr& msg);
    void startgame_cb( const std_msgs::Empty::ConstPtr& msg);
    void loadTaskFile(const std::string taskfile);
    void executeSystemCommand(QString command);
    /** @brief update actual confuguration of arm in the GUI*/
    void updateArmActualConfiguration();
    /** @brief update actual XYZ position of arm in the GUI*/
    void updateArmActualXYZ();
    void updateTable();
    /** @brief registering main tabs in GUI*/
    template<typename T>
    void registerMainTab(T** mainTab, ros::NodeHandle* nh, const std::string& tabName );
    //for converting radian to grades
    int radToGrade(double rad);
    //Simple Actions
    bool m_IsRunning;
    int m_TaskIndex;
    std::vector<task::Task> m_Tasklist;
    std::vector<std::string> m_words_to_hear;

    std::vector<QPushButton*> m_HardwareStateButtons;
    //std::map<std::string, ros::Time> m_HardwareLastUpdate;

    std::map<std::string,double> m_actual_arm_configuration_map;
    //options for arm movement
    bool m_linear;
    bool m_collisionfree;
    std::string m_taskfile;
    QProcess * m_game_process;

};



#endif // MAINWINDOW_H
