/*******************************************************************************
 *  PoiLabel.cpp
 *
 *  (C) 2008 AG Aktives Sehen <agas@uni-koblenz.de>
 *           Universitaet Koblenz-Landau
 *
 * §Author: Christian Feinen
 *
 *  Additional information:
 *  $Id: PoiLabel.cpp 44313 2011-04-06 22:46:28Z agas $
 *******************************************************************************/

#include "PoiLabel.h"
#include "qpainter.h"
#include <ros/ros.h>

#define THIS PoiLabel

THIS::THIS(QPoint mapPosition, double theta, QString poiIconFileName, QString poiName, QString poiRemarks, int poiType, QWidget *parent, float zoomFactor)
 : QLabel(parent)
{
  m_PoiName = poiName;
  m_PoiIconFileName = poiIconFileName;
  m_PoiPosition = mapPosition;
  m_PoiOrientation = theta;
  QPixmap pm = QPixmap(poiIconFileName);
  QPainter painter(&pm);
  painter.translate(8, 8);
  painter.rotate(theta * 180 / M_PI);
  painter.setBrush( Qt::blue );
  QPolygon triangle;
  triangle << QPoint( -3, -2 );
  triangle << QPoint( 0, -8 );
  triangle << QPoint( 3, -2 );
  triangle << QPoint( -3, -2 );
  painter.drawPolygon( triangle );
  setScaledContents(true);
  setPixmap( pm );
  setGeometry(QRect(mapPosition, QSize(16, 16 )));
  setToolTip("poi name: " + poiName +"\nremarks: " + poiRemarks + "\npoi type: " + QString::number(poiType));
  show( );
}

QString THIS::getPoiName() const {
  return m_PoiName;
}

QString THIS::getPoiIconFileName() const {
  return m_PoiIconFileName;
}

QPoint THIS::getPoiPosition() const {
    return m_PoiPosition;
}

double THIS::getPoiOrientation() const {
    return m_PoiOrientation;
}

void THIS::setActive(bool value) {
  setFrameShape((value)? QFrame::Box : QFrame::NoFrame);
}

void THIS::setNewPoiIcon(QString poiIconFileName) {
  setPixmap(QPixmap(poiIconFileName));
}

void THIS::setOrientation(double orientation) {
    m_PoiOrientation = orientation;
}

#undef THIS
