#!/usr/bin/env batchflow
<?xml version="1.0"?>
<Document>
  <Network type="subnet" name="MAIN">
    <Node name="node_LOOP0_1" type="LOOP0" x="-206.000000" y="-91.000000">
      <Parameter name="LENGTH" type="int" value="512" description="FFT length in sample. [default: 512]"/>
      <Parameter name="SAMPLING_RATE" type="int" value="16000" description="Sampling Rate (Hz)."/>
      <Parameter name="A_MATRIX" type="subnet_param" value="ARG1" description="Filename of a transfer function matrix."/>
      <Parameter name="ADVANCE" type="int" value="160" description="The length in sample between a frame and a previous frame. [default: 160]"/>
      <Parameter name="TF_CONJ_FILENAME" type="subnet_param" value="ARG1" description="Filename of a pre-measured transfer function for separation."/>
      <Parameter name="NOISE_FILENAME" type="subnet_param" value="ARG2" description="Filename describing sound locations of the fixed noise sources. The specified noise sources are always separated in addition to sound sources in INPUT_SOURCES. Available only when FIXED_NOISE = true."/>
      <Parameter name="DOWHILE" type="bool" value="" description=""/>
    </Node>
    <Node name="node_RosNodeGenerator_1" type="RosNodeGenerator" x="-262.000000" y="-176.000000">
      <Parameter name="NODE_NAME" type="string" value="HARK_MASTER_NODE" description="Node name for ROS"/>
    </Node>
    <Node name="node_RosNodeGeneratorForJSK_1" type="RosNodeGeneratorForJSK" x="-82.000000" y="-176.000000">
      <Parameter name="NODE_NAME" type="string" value="HARK_JSK_MASTER_NODE" description="Node name for ROS"/>
    </Node>
    <NetOutput name="OUTPUT3" node="node_LOOP0_1" terminal="OUTPUT3" object_type="any" description="No description available"/>
    <NetOutput name="OUTPUT4" node="node_LOOP0_1" terminal="OUTPUT4" object_type="any" description="No description available"/>
    <Note x="0" y="0" visible="0" text="Created with FlowDesigner 0.9.1"/>
  </Network>
  <Network type="iterator" name="LOOP0">
    <Node name="node_MultiFFT_1" type="MultiFFT" x="-62.000000" y="-305.000000">
      <Parameter name="LENGTH" type="subnet_param" value="LENGTH" description="FFT length in sample. [default: 512]"/>
      <Parameter name="WINDOW" type="string" value="CONJ" description="A window function for FFT. WINDOW should be CONJ, HAMMING, RECTANGLE, or HANNING. [default: CONJ]"/>
      <Parameter name="WINDOW_LENGTH" type="subnet_param" value="LENGTH" description="Window length of the window function. [default: 512]"/>
    </Node>
    <Node name="node_LocalizeMUSIC_1" type="LocalizeMUSIC" x="-381.000000" y="-180.000000">
      <Parameter name="MUSIC_ALGORITHM" type="string" value="GEVD" description="Sound Source Localization Algorithm. If SEVD, NOISECM will be ignored"/>
      <Parameter name="TF_CHANNEL_SELECTION" type="object" value="&lt;Vector&lt;int&gt; 0 1 2 3 4 5 6&gt;" description="Microphone channels for localization"/>
      <Parameter name="LENGTH" type="subnet_param" value="LENGTH" description="The length of a frame (per channel)."/>
      <Parameter name="SAMPLING_RATE" type="subnet_param" value="SAMPLING_RATE" description="Sampling Rate (Hz)."/>
      <Parameter name="A_MATRIX" type="subnet_param" value="A_MATRIX" description="Filename of a transfer function matrix."/>
      <Parameter name="ELEVATION" type="float" value="0.0" description="An angle of elevation of source locations."/>
      <Parameter name="WINDOW" type="int" value="50" description="The number of frames used for calculating a correlation function."/>
      <Parameter name="PERIOD" type="int" value="50" description="The period in which the source localization is processed."/>
      <Parameter name="NUM_SOURCE" type="int" value="3" description="Number of sources, which should be less than number of channels."/>
      <Parameter name="MIN_DEG" type="int" value="-90" description="source direction (lower)."/>
      <Parameter name="MAX_DEG" type="int" value="90" description="source direction (higher)."/>
      <Parameter name="LOWER_BOUND_FREQUENCY" type="int" value="300" description="Lower bound of frequency (Hz) used for correlation function calculation."/>
      <Parameter name="UPPER_BOUND_FREQUENCY" type="int" value="2700" description="Upper bound of frequency (Hz) used for correlation function calculation."/>
      <Parameter name="SPECTRUM_WEIGHT_TYPE" type="string" value="A_Characteristic" description="MUSIC spectrum weight for each frequency bin."/>
      <Parameter name="A_CHAR_SCALING" type="float" value="1.0" description="Scaling factor of the A-Weight with respect to frequency"/>
      <Parameter name="MANUAL_WEIGHT_SPLINE" type="object" value="&lt;Matrix&lt;float&gt; &lt;rows 2&gt; &lt;cols 5&gt; &lt;data 0.0 2000.0 4000.0 6000.0 8000.0 1.0 1.0 1.0 1.0 1.0&gt; &gt;" description="MUSIC spectrum weight for each frequency bin. This is a 2 by M matrix. The first row represents the frequency, and the second row represents the weight gain. &quot;M&quot; represents the number of key points for the spectrum weight. The frequency range between M key points will be interpolated by spline manner. The format is &quot;&lt;Matrix&lt;float&gt; &lt;rows 2&gt; &lt;cols 2&gt; &lt;data 1 2 3 4&gt; &gt;&quot;."/>
      <Parameter name="MANUAL_WEIGHT_SQUARE" type="object" value="&lt;Vector&lt;float&gt; 0.0 2000.0 4000.0 6000.0 8000.0&gt;" description="MUSIC spectrum weight for each frequency bin. This is a M order vector. The element represents the frequency points for the square wave. &quot;M&quot; represents the number of key points for the square wave weight. The format is &quot;&lt;Vector&lt;float&gt; 1 2 3 4&gt;&quot;."/>
      <Parameter name="ENABLE_EIGENVALUE_WEIGHT" type="bool" value="false" description="If true, the spatial spectrum is weighted depending on the eigenvalues of a correlation matrix. We do not suggest to use this function with GEVD and GSVD, because the NOISECM changes the eigenvalue drastically. Only useful for SEVD."/>
      <Parameter name="DEBUG" type="bool" value="false" description="Debug option. If the parameter is true, this node outputs sound localization results to a standard output."/>
    </Node>
    <Node name="node_SourceTracker_1" type="SourceTracker" x="-88.000000" y="-172.000000">
      <Parameter name="THRESH" type="float" value="31" description="Power threshold for localization results. A localization result with higher power than THRESH is tracked, otherwise ignored."/>
      <Parameter name="PAUSE_LENGTH" type="float" value="1200" description="Life duration of source in ms. When any localization result for a source is found for more than PAUSE_LENGTH / 10 iterations, the source is terminated. [default: 800]"/>
      <Parameter name="MIN_SRC_INTERVAL" type="float" value="20" description="Source interval threshold in degree. When the angle between a localization result and a source is smaller than MIN_SRC_INTERVAL, the same ID is given to the localization result. [default: 20]"/>
      <Parameter name="MIN_ID" type="int" value="0" description="Minimum ID of source locations. MIN_ID should be greater than 0 or equal."/>
      <Parameter name="DEBUG" type="bool" value="false" description="Output debug information if true [default: false]"/>
    </Node>
    <Node name="node_SourceIntervalExtender_1" type="SourceIntervalExtender" x="75.000000" y="-173.000000">
      <Parameter name="PREROLL_LENGTH" type="int" value="50" description="Preroll length in frame. [default: 50]"/>
    </Node>
    <Node name="node_Synthesize_1" type="Synthesize" x="-121.000000" y="-51.000000">
      <Parameter name="LENGTH" type="subnet_param" value="LENGTH" description="Size of window length in sample. [default: 512]"/>
      <Parameter name="ADVANCE" type="subnet_param" value="ADVANCE" description="The length in sample between a frame and a previous frame. [default: 160]"/>
      <Parameter name="SAMPLING_RATE" type="subnet_param" value="SAMPLING_RATE" description="Sampling rate (Hz) [default: 16000]."/>
      <Parameter name="MIN_FREQUENCY" type="int" value="125" description="Minimum frequency (Hz) [default: 125]"/>
      <Parameter name="MAX_FREQUENCY" type="int" value="7900" description="Maximum frequency (Hz) [default: 7900]"/>
      <Parameter name="WINDOW" type="string" value="HAMMING" description="A window function for overlap-add. WINDOW should be CONJ, HAMMING, RECTANGLE, or HANNING. [default: HAMMING]"/>
      <Parameter name="OUTPUT_GAIN" type="float" value="1.0" description="Output gain factor. [default: 1.0]"/>
    </Node>
    <Node name="node_GHDSS_1" type="GHDSS" x="-391.000000" y="-51.000000">
      <Parameter name="LENGTH" type="subnet_param" value="LENGTH" description="The frame length of each channel (in samples) [default: 512]."/>
      <Parameter name="ADVANCE" type="subnet_param" value="ADVANCE" description="The shift length beween adjacent frames (in samples)[default: 160]."/>
      <Parameter name="SAMPLING_RATE" type="subnet_param" value="SAMPLING_RATE" description="Sampling rate (Hz) [default: 16000]."/>
      <Parameter name="LOWER_BOUND_FREQUENCY" type="int" value="0" description="Lower bound of frequency (Hz). [default: 0]"/>
      <Parameter name="UPPER_BOUND_FREQUENCY" type="int" value="8000" description="Upper bound of frequency (Hz). [default: 8000]"/>
      <Parameter name="TF_CONJ" type="string" value="DATABASE" description="Transfer function (TF) type. CALC generates TF from the geometrical relationship between microphones and a sound source, and DATABASE uses pre-measured TF [default: CALC]."/>
      <Parameter name="TF_CONJ_FILENAME" type="subnet_param" value="TF_CONJ_FILENAME" description="Filename of a pre-measured transfer function for separation."/>
      <Parameter name="MIC_FILENAME" type="string" value="" description="Filename for microphone positions."/>
      <Parameter name="MIC_POS_SHIFT" type="string" value="FIX" description="Method to decide the orgin of the coordinates. FIX uses the origin in the coordinates in MIC_FILENAME, SHIFT regards the center of microphone array as the origin. [default: FIX]"/>
      <Parameter name="FIXED_NOISE" type="bool" value="false" description="Flag to specify fixed noise sources. [default: false]"/>
      <Parameter name="FIXED_NOISE_FILENAME" type="subnet_param" value="NOISE_FILENAME" description="Filename describing sound locations of the fixed noise sources. The specified noise sources are always separated in addition to sound sources in INPUT_SOURCES. Available only when FIXED_NOISE = true."/>
      <Parameter name="INITW_FILENAME" type="string" value="" description="Filename of an initial separation matrix. If specified, a matrix in INITW_FILENAME is used as an initial separation matrix. Otherwise, initial separation matrix is estimated from the geometrical relationship or pre-measured TF according to TF_CONJ."/>
      <Parameter name="SPEED_OF_SOUND" type="float" value="343.0" description="Speed of sound(m/s) [default: 343.0]."/>
      <Parameter name="SS_METHOD" type="string" value="ADAPTIVE" description="The calculation method for SS step size parameter corresponding to the blind separation part. &quot;FIX&quot; uses a fixed step size,&quot;LC_MYU&quot; uses the same value as LC_MYU, and &quot;ADAPTIVE&quot; adaptively estimates an optimal step size. [default: ADAPTIVE]"/>
      <Parameter name="SS_SCAL" type="float" value="1.0" description="Scaling factor for SS step size. [default: 1.0]"/>
      <Parameter name="SS_MYU" type="float" value="0.001" description="SS step size value. [default 0.001]"/>
      <Parameter name="NOISE_FLOOR" type="float" value="0.0" description="Noise floor value. [default 0.0]"/>
      <Parameter name="LC_CONST" type="string" value="DIAG" description="The calculation method for geometric constraints. &quot;FULL&quot; uses all elements of a matrix, and &quot;DIAG&quot; only uses diagonal parts. [default: DIAG]"/>
      <Parameter name="LC_METHOD" type="string" value="ADAPTIVE" description="The calculation method for LC step size corresponding to geometric constraints. &quot;FIX&quot; uses a fixed value, and &quot;Adaptive&quot; adaptively estimates an optimal step size. [default: ADAPTIVE]"/>
      <Parameter name="LC_MYU" type="float" value="0.001" description="LC step size value. [default 0.001]"/>
      <Parameter name="UPDATE_METHOD_TF_CONJ" type="string" value="POS" description="Switching method of TF_CONJ data. [default: POS]"/>
      <Parameter name="UPDATE_METHOD_W" type="string" value="ID_POS" description="Switching method of separation matrix, W. [default: ID]"/>
      <Parameter name="UPDATE_ACCEPT_ANGLE" type="float" value="5.0" description="Angle allowance to switch separation matrix in degree. available when when UPDATE_METHOD_W is POS or ID_POS. [default: 5.0]"/>
      <Parameter name="EXPORT_W" type="bool" value="false" description="Separation matrix W is exported if true. [default: false]"/>
      <Parameter name="EXPORT_W_FILENAME" type="string" value="" description="The filename to export W."/>
      <Parameter name="UPDATE" type="string" value="STEP" description="The update method of separation matrix. &quot;STEP&quot; updates W sequentially, i.e., based on SS and then on LC cost. &quot;TOTAL&quot; updates W based on an integrated value of SS and LC cost [default: STEP]"/>
    </Node>
    <Node name="node_AudioStreamFromMic_1" type="AudioStreamFromMic" x="-402.000000" y="-299.000000">
      <Parameter name="LENGTH" type="subnet_param" value="LENGTH" description="The frame length of each channel (in samples) [default: 512]."/>
      <Parameter name="ADVANCE" type="subnet_param" value="ADVANCE" description="The shift length beween adjacent frames (in samples)[default: 160]."/>
      <Parameter name="CHANNEL_COUNT" type="int" value="7" description="The number of channels."/>
      <Parameter name="SAMPLING_RATE" type="subnet_param" value="SAMPLING_RATE" description="Sampling rate (Hz) [default: 16000]."/>
      <Parameter name="DEVICETYPE" type="string" value="ALSA" description="Device type [default: WS]."/>
      <Parameter name="GAIN" type="string" value="0dB" description="capture gain (dB)  [default: 0dB]."/>
      <Parameter name="DEVICE" type="string" value="plughw:1,0" description="Device name or IP address [default: 127.0.0.1]"/>
    </Node>
    <Node name="node_RosHarkParamsDynReconf_1" type="RosHarkParamsDynReconf" x="-828.000000" y="-125.000000">
      <Parameter name="ROS_DURATION" type="float" value="0.001" description="This allows you to specify a duration that you would like to loop at [sec]. Keep this value small."/>
    </Node>
    <Node name="node_RosHarkMsgsPublisher_1" type="RosHarkMsgsPublisher" x="452.333344" y="-303.333344">
      <Parameter name="ADVANCE" type="int" value="160" description="Shift sample number for sliding spectrum analysis."/>
      <Parameter name="ENABLE_DEBUG" type="bool" value="false" description="print debug message of this module in case of true."/>
      <Parameter name="TOPIC_NAME_HARKWAVE" type="string" value="HarkWave" description="Published topic name for ROS (HarkWave type message)"/>
      <Parameter name="TOPIC_NAME_HARKFFT" type="string" value="HarkFFT" description="Published topic name for ROS (HarkFFT type message)"/>
      <Parameter name="TOPIC_NAME_HARKFEATURE" type="string" value="HarkFeature" description="Published topic name for ROS (HarkFeature type message)"/>
      <Parameter name="TOPIC_NAME_HARKSOURCE" type="string" value="HarkSource" description="Published topic name for ROS (HarkSource type message)"/>
      <Parameter name="TOPIC_NAME_HARKSRCWAVE" type="string" value="HarkSrcWave" description="Published topic name for ROS (HarkSrcWave type message)"/>
      <Parameter name="TOPIC_NAME_HARKSRCFFT" type="string" value="HarkSrcFFT" description="Published topic name for ROS (HarkSrcFFT type message)"/>
      <Parameter name="TOPIC_NAME_HARKSRCFEATURE" type="string" value="HarkSrcFeature" description="Published topic name for ROS (HarkSrcFeature type message)"/>
      <Parameter name="TOPIC_NAME_HARKSRCFEATUREMFM" type="string" value="HarkSrcFeatureMFM" description="Published topic name for ROS (HarkSrcFeatureMFM type message)"/>
      <Parameter name="BUFFER_NUM" type="int" value="100" description="Buffer size for a ROS published message"/>
      <Parameter name="ROS_LOOP_RATE" type="float" value="100000" description="This allows you to specify a frequency that you would like to loop at [Hz]. Keep this value large. (If ROS interval is shorter than HARK interval, ROS interval is overwritten.)"/>
      <Parameter name="TIMESTAMP_TYPE" type="string" value="ROS_TIME_NOW" description="Time stamp type. If TIMESTAMP is connected, this is ignored."/>
      <Parameter name="SAMPLING_RATE" type="int" value="16000" description="The time increment is caluculated as ADVANCE / SAMPLING_RATE"/>
      <Parameter name="ROS_FRAME_ID" type="string" value="/head_mount_kinect_ir_link" description="ROS frame_id of the message header"/>
    </Node>
    <Node name="node_MelFilterBank_1" type="MelFilterBank" x="-229.000000" y="-6.000000">
      <Parameter name="LENGTH" type="int" value="512" description="Size of window length in sample. [default: 512]"/>
      <Parameter name="SAMPLING_RATE" type="int" value="16000" description="Sampling rate in Hz.  [default: 16000]"/>
      <Parameter name="CUTOFF" type="int" value="8000" description="Cutoff frequency in Hz. Mel-filterbanks are placed between 0 Hz and CUTOFF Hz. [default: 8000]"/>
      <Parameter name="MIN_FREQUENCY" type="int" value="63" description="Minimum frequency (Hz) [default: 63]"/>
      <Parameter name="MAX_FREQUENCY" type="int" value="8000" description="Maximum frequency (Hz) [default: 8000]"/>
      <Parameter name="FBANK_COUNT" type="int" value="13" description="The number of Mel filter banks. [default: 13]"/>
    </Node>
    <Node name="node_MFCCExtraction_1" type="MFCCExtraction" x="53.000000" y="1.000000">
      <Parameter name="FBANK_COUNT" type="int" value="24" description="Number of filter banks of FBANK. [default: 24]"/>
      <Parameter name="NUM_CEPS" type="int" value="12" description="Number of Cepstrum coefficients. [default: 12]"/>
      <Parameter name="USE_POWER" type="bool" value="false" description="Use power feature if true. [default: false]"/>
    </Node>
    <Node name="node_FeatureRemover_1" type="FeatureRemover" x="-180.000000" y="87.000000">
      <Parameter name="SELECTOR" type="object" value="&lt;Vector&lt;int&gt; 12 13 14 15 16 17 18 19 20 21 22 23 24 25&gt;" description="Component indices in a feature vector to remove. E.g. &lt;Vector&lt;int&gt; 13&gt; to remove 14th comopnent (The index start with 0)."/>
    </Node>
    <Node name="node_RosJskHarkMsgsPublisher_1" type="RosJskHarkMsgsPublisher" x="434.000000" y="-125.333344">
      <Parameter name="ADVANCE" type="int" value="160" description="Shift sample number for sliding spectrum analysis."/>
      <Parameter name="ENABLE_DEBUG" type="bool" value="false" description="print debug message of this module in case of true."/>
      <Parameter name="TOPIC_NAME_HARKPOWER" type="string" value="HarkPower" description="Published topic name for ROS (HarkPower type message)"/>
      <Parameter name="BUFFER_NUM" type="int" value="100" description="Buffer size for a ROS published message"/>
      <Parameter name="ROS_LOOP_RATE" type="float" value="100000" description="This allows you to specify a frequency that you would like to loop at [Hz]. Keep this value large. (If ROS interval is shorter than HARK interval, ROS interval is overwritten.)"/>
      <Parameter name="TIMESTAMP_TYPE" type="string" value="ROS_TIME_NOW" description="Time stamp type. If TIMESTAMP is connected, this is ignored."/>
      <Parameter name="SAMPLING_RATE" type="int" value="16000" description="The time increment is caluculated as ADVANCE / SAMPLING_RATE"/>
      <Parameter name="ROS_FRAME_ID" type="string" value="/head_mount_kinect_ir_link" description="ROS frame_id of the message header"/>
    </Node>
    <Link from="node_LocalizeMUSIC_1" output="OUTPUT" to="node_SourceTracker_1" input="INPUT"/>
    <Link from="node_SourceTracker_1" output="OUTPUT" to="node_SourceIntervalExtender_1" input="SOURCES"/>
    <Link from="node_MultiFFT_1" output="OUTPUT" to="node_LocalizeMUSIC_1" input="INPUT">-30 -305 46 -305 46 -252 -538 -252 -540 -195 -499.5 -195 </Link>
    <Link from="node_MultiFFT_1" output="OUTPUT" to="node_GHDSS_1" input="INPUT_FRAMES">-29.5 -305 46 -305 46 -252 -539 -252 -540 -192 -539 -58 -527 -58.5 </Link>
    <Link from="node_SourceIntervalExtender_1" output="OUTPUT" to="node_GHDSS_1" input="INPUT_SOURCES">151.5 -173 211 -173 211 -113 -566 -113 -566 -44 -527 -43.5 </Link>
    <Link from="node_GHDSS_1" output="OUTPUT" to="node_Synthesize_1" input="INPUT"/>
    <Link from="node_AudioStreamFromMic_1" output="AUDIO" to="node_MultiFFT_1" input="INPUT"/>
    <Link from="node_RosHarkParamsDynReconf_1" output="LocalizeMUSIC" to="node_LocalizeMUSIC_1" input="PARAMS">-641 -140 -592 -165 -499.5 -165 </Link>
    <Link from="node_RosHarkParamsDynReconf_1" output="SourceTracker" to="node_SourceTracker_1" input="PARAMS">-647.5 -125 -279 -125 -196.5 -164.5 </Link>
    <Link from="node_SourceIntervalExtender_1" output="OUTPUT" to="node_RosHarkMsgsPublisher_1" input="SRC_INFO">156 -173 211 -173 211 -333.333 262.333 -333.333 </Link>
    <Link from="node_MultiFFT_1" output="OUTPUT" to="node_RosHarkMsgsPublisher_1" input="MIC_FFT">-28.5 -305 28 -348.333 262.333 -348.333 </Link>
    <Link from="node_AudioStreamFromMic_1" output="AUDIO" to="node_RosHarkMsgsPublisher_1" input="MIC_WAVE">-262 -306.5 -202 -363.667 262.333 -363.333 </Link>
    <Link from="node_Synthesize_1" output="OUTPUT" to="node_RosHarkMsgsPublisher_1" input="SRC_WAVE">-80.5 -51 -29 -87 220 -88 220 -318.333 262.333 -318.333 </Link>
    <Link from="node_GHDSS_1" output="OUTPUT" to="node_RosHarkMsgsPublisher_1" input="SRC_FFT">-363 -51 -317 -79 231 -82 231 -303.333 262.333 -303.333 </Link>
    <Link from="node_GHDSS_1" output="OUTPUT" to="node_MelFilterBank_1" input="INPUT"/>
    <Link from="node_MelFilterBank_1" output="OUTPUT" to="node_MFCCExtraction_1" input="FBANK"/>
    <Link from="node_GHDSS_1" output="OUTPUT" to="node_MFCCExtraction_1" input="SPECTRUM">-363 -51 -316 9 -77 8.5 </Link>
    <Link from="node_MFCCExtraction_1" output="OUTPUT" to="node_FeatureRemover_1" input="INPUT">108 1 146 1 146 45 -279 43 -279 87 -234 87 </Link>
    <Link from="node_FeatureRemover_1" output="OUTPUT" to="node_RosHarkMsgsPublisher_1" input="SRC_FEATURE">-121.5 87 244 86 244 -288.333 262.333 -288.333 </Link>
    <Link from="node_LocalizeMUSIC_1" output="SPECTRUM" to="node_RosJskHarkMsgsPublisher_1" input="SRC_POWER">-253 -172.5 -214 -133.333 262.5 -132.833 </Link>
    <NetCondition name="CONDITION" node="node_AudioStreamFromMic_1" terminal="NOT_EOF"/>
    <NetOutput name="OUTPUT3" node="node_RosHarkMsgsPublisher_1" terminal="OUTPUT" object_type="ObjectRef" description="This is a dummy output, and it has no mean. Only for an activation of this module."/>
    <NetOutput name="OUTPUT4" node="node_RosJskHarkMsgsPublisher_1" terminal="OUTPUT" object_type="ObjectRef" description="This is a dummy output, and it has no mean. Only for an activation of this module."/>
    <Note x="0" y="0" visible="0" text="Created with FlowDesigner 0.9.1"/>
  </Network>
  <Parameter name="ARG1" type="int" value=""/>
  <Parameter name="ARG2" type="int" value=""/>
  <Parameter name="ARG3" type="int" value=""/>
</Document>
