// -*- mode: c++ -*-
/*********************************************************************
 * Software License Agreement (BSD License)
 *
 *  Copyright (c) 2014, JSK Lab
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/o2r other materials provided
 *     with the distribution.
 *   * Neither the name of the JSK Lab nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/


namespace jsk_rviz_plugins
{
  std::map<std::string, QString> entypo_character_map;
  std::map<std::string, QString> entypo_social_character_map;
  std::map<std::string, QString> fontawesome_character_map;
  void setupFont() {
    static bool font_initialized = false;
    if (!font_initialized) {
      font_initialized = true;
      addFont(Entypo_ttf, Entypo_ttf_len);
      addFont(Entypo_Social_ttf, Entypo_Social_ttf_len);
      addFont(fontawesome_webfont_ttf,
              font_awesome_4_2_0_fonts_fontawesome_webfont_ttf_len);

      entypo_character_map["phone"] = QString::fromWCharArray(L"\x1F4DE");
      entypo_character_map["mobile"] = QString::fromWCharArray(L"\x1F4F1");
      entypo_character_map["mouse"] = QString::fromWCharArray(L"\xE789");
      entypo_character_map["address"] = QString::fromWCharArray(L"\xE723");
      entypo_character_map["mail"] = QString::fromWCharArray(L"\x2709");
      entypo_character_map["paper-plane"] = QString::fromWCharArray(L"\x1F53F");
      entypo_character_map["pencil"] = QString::fromWCharArray(L"\x270E");
      entypo_character_map["feather"] = QString::fromWCharArray(L"\x2712");
      entypo_character_map["attach"] = QString::fromWCharArray(L"\x1F4CE");
      entypo_character_map["inbox"] = QString::fromWCharArray(L"\xE777");
      entypo_character_map["reply"] = QString::fromWCharArray(L"\xE712");
      entypo_character_map["reply-all"] = QString::fromWCharArray(L"\xE713");
      entypo_character_map["forward"] = QString::fromWCharArray(L"\x27A6");
      entypo_character_map["user"] = QString::fromWCharArray(L"\x1F464");
      entypo_character_map["users"] = QString::fromWCharArray(L"\x1F465");
      entypo_character_map["add-user"] = QString::fromWCharArray(L"\xE700");
      entypo_character_map["vcard"] = QString::fromWCharArray(L"\xE722");
      entypo_character_map["export"] = QString::fromWCharArray(L"\xE715");
      entypo_character_map["location"] = QString::fromWCharArray(L"\xE724");
      entypo_character_map["map"] = QString::fromWCharArray(L"\xE727");
      entypo_character_map["compass"] = QString::fromWCharArray(L"\xE728");
      entypo_character_map["direction"] = QString::fromWCharArray(L"\x27A2");
      entypo_character_map["hair-cross"] = QString::fromWCharArray(L"\x1F3AF");
      entypo_character_map["share"] = QString::fromWCharArray(L"\xE73C");
      entypo_character_map["shareable"] = QString::fromWCharArray(L"\xE73E");
      entypo_character_map["heart"] = QString::fromWCharArray(L"\x2665");
      entypo_character_map["heart-empty"] = QString::fromWCharArray(L"\x2661");
      entypo_character_map["star"] = QString::fromWCharArray(L"\x2605");
      entypo_character_map["star-empty"] = QString::fromWCharArray(L"\x2606");
      entypo_character_map["thumbs-up"] = QString::fromWCharArray(L"\x1F44D");
      entypo_character_map["thumbs-down"] = QString::fromWCharArray(L"\x1F44E");
      entypo_character_map["chat"] = QString::fromWCharArray(L"\xE720");
      entypo_character_map["comment"] = QString::fromWCharArray(L"\xE718");
      entypo_character_map["quote"] = QString::fromWCharArray(L"\x275E");
      entypo_character_map["home"] = QString::fromWCharArray(L"\x2302");
      entypo_character_map["popup"] = QString::fromWCharArray(L"\xE74C");
      entypo_character_map["search"] = QString::fromWCharArray(L"\x1F50D");
      entypo_character_map["flashlight"] = QString::fromWCharArray(L"\x1F526");
      entypo_character_map["print"] = QString::fromWCharArray(L"\xE716");
      entypo_character_map["bell"] = QString::fromWCharArray(L"\x1F514");
      entypo_character_map["link"] = QString::fromWCharArray(L"\x1F517");
      entypo_character_map["flag"] = QString::fromWCharArray(L"\x2691");
      entypo_character_map["cog"] = QString::fromWCharArray(L"\x2699");
      entypo_character_map["tools"] = QString::fromWCharArray(L"\x2692");
      entypo_character_map["trophy"] = QString::fromWCharArray(L"\x1F3C6");
      entypo_character_map["tag"] = QString::fromWCharArray(L"\xE70C");
      entypo_character_map["camera"] = QString::fromWCharArray(L"\x1F4F7");
      entypo_character_map["megaphone"] = QString::fromWCharArray(L"\x1F4E3");
      entypo_character_map["moon"] = QString::fromWCharArray(L"\x263D");
      entypo_character_map["palette"] = QString::fromWCharArray(L"\x1F3A8");
      entypo_character_map["leaf"] = QString::fromWCharArray(L"\x1F342");
      entypo_character_map["note"] = QString::fromWCharArray(L"\x266A");
      entypo_character_map["beamed-note"] = QString::fromWCharArray(L"\x266B");
      entypo_character_map["new"] = QString::fromWCharArray(L"\x1F4A5");
      entypo_character_map["graduation-cap"] = QString::fromWCharArray(L"\x1F393");
      entypo_character_map["book"] = QString::fromWCharArray(L"\x1F4D5");
      entypo_character_map["newspaper"] = QString::fromWCharArray(L"\x1F4F0");
      entypo_character_map["bag"] = QString::fromWCharArray(L"\x1F45C");
      entypo_character_map["airplane"] = QString::fromWCharArray(L"\x2708");
      entypo_character_map["lifebuoy"] = QString::fromWCharArray(L"\xE788");
      entypo_character_map["eye"] = QString::fromWCharArray(L"\xE70A");
      entypo_character_map["clock"] = QString::fromWCharArray(L"\x1F554");
      entypo_character_map["mic"] = QString::fromWCharArray(L"\x1F3A4");
      entypo_character_map["calendar"] = QString::fromWCharArray(L"\x1F4C5");
      entypo_character_map["flash"] = QString::fromWCharArray(L"\x26A1");
      entypo_character_map["thunder-cloud"] = QString::fromWCharArray(L"\x26C8");
      entypo_character_map["droplet"] = QString::fromWCharArray(L"\x1F4A7");
      entypo_character_map["cd"] = QString::fromWCharArray(L"\x1F4BF");
      entypo_character_map["briefcase"] = QString::fromWCharArray(L"\x1F4BC");
      entypo_character_map["air"] = QString::fromWCharArray(L"\x1F4A8");
      entypo_character_map["hourglass"] = QString::fromWCharArray(L"\x23F3");
      entypo_character_map["gauge"] = QString::fromWCharArray(L"\x1F6C7");
      entypo_character_map["language"] = QString::fromWCharArray(L"\x1F394");
      entypo_character_map["network"] = QString::fromWCharArray(L"\xE776");
      entypo_character_map["key"] = QString::fromWCharArray(L"\x1F511");
      entypo_character_map["battery"] = QString::fromWCharArray(L"\x1F50B");
      entypo_character_map["bucket"] = QString::fromWCharArray(L"\x1F4FE");
      entypo_character_map["magnet"] = QString::fromWCharArray(L"\xE7A1");
      entypo_character_map["drive"] = QString::fromWCharArray(L"\x1F4FD");
      entypo_character_map["cup"] = QString::fromWCharArray(L"\x2615");
      entypo_character_map["rocket"] = QString::fromWCharArray(L"\x1F680");
      entypo_character_map["brush"] = QString::fromWCharArray(L"\xE79A");
      entypo_character_map["suitcase"] = QString::fromWCharArray(L"\x1F6C6");
      entypo_character_map["traffic-cone"] = QString::fromWCharArray(L"\x1F6C8");
      entypo_character_map["globe"] = QString::fromWCharArray(L"\x1F30E");
      entypo_character_map["keyboard"] = QString::fromWCharArray(L"\x2328");
      entypo_character_map["browser"] = QString::fromWCharArray(L"\xE74E");
      entypo_character_map["publish"] = QString::fromWCharArray(L"\xE74D");
      entypo_character_map["progress-3"] = QString::fromWCharArray(L"\xE76B");
      entypo_character_map["progress-2"] = QString::fromWCharArray(L"\xE76A");
      entypo_character_map["progress-1"] = QString::fromWCharArray(L"\xE769");
      entypo_character_map["progress-0"] = QString::fromWCharArray(L"\xE768");
      entypo_character_map["light-down"] = QString::fromWCharArray(L"\x1F505");
      entypo_character_map["light-up"] = QString::fromWCharArray(L"\x1F506");
      entypo_character_map["adjust"] = QString::fromWCharArray(L"\x25D1");
      entypo_character_map["code"] = QString::fromWCharArray(L"\xE714");
      entypo_character_map["monitor"] = QString::fromWCharArray(L"\x1F4BB");
      entypo_character_map["infinity"] = QString::fromWCharArray(L"\x221E");
      entypo_character_map["light-bulb"] = QString::fromWCharArray(L"\x1F4A1");
      entypo_character_map["credit-card"] = QString::fromWCharArray(L"\x1F4B3");
      entypo_character_map["database"] = QString::fromWCharArray(L"\x1F4F8");
      entypo_character_map["voicemail"] = QString::fromWCharArray(L"\x2707");
      entypo_character_map["clipboard"] = QString::fromWCharArray(L"\x1F4CB");
      entypo_character_map["cart"] = QString::fromWCharArray(L"\xE73D");
      entypo_character_map["box"] = QString::fromWCharArray(L"\x1F4E6");
      entypo_character_map["ticket"] = QString::fromWCharArray(L"\x1F3AB");
      entypo_character_map["rss"] = QString::fromWCharArray(L"\xE73A");
      entypo_character_map["signal"] = QString::fromWCharArray(L"\x1F4F6");
      entypo_character_map["thermometer"] = QString::fromWCharArray(L"\x1F4FF");
      entypo_character_map["water"] = QString::fromWCharArray(L"\x1F4A6");
      entypo_character_map["sweden"] = QString::fromWCharArray(L"\xF601");
      entypo_character_map["line-graph"] = QString::fromWCharArray(L"\x1F4C8");
      entypo_character_map["pie-chart"] = QString::fromWCharArray(L"\x25F4");
      entypo_character_map["bar-graph"] = QString::fromWCharArray(L"\x1F4CA");
      entypo_character_map["area-graph"] = QString::fromWCharArray(L"\x1F53E");
      entypo_character_map["lock"] = QString::fromWCharArray(L"\x1F512");
      entypo_character_map["lock-open"] = QString::fromWCharArray(L"\x1F513");
      entypo_character_map["logout"] = QString::fromWCharArray(L"\xE741");
      entypo_character_map["login"] = QString::fromWCharArray(L"\xE740");
      entypo_character_map["check"] = QString::fromWCharArray(L"\x2713");
      entypo_character_map["cross"] = QString::fromWCharArray(L"\x274C");
      entypo_character_map["squared-minus"] = QString::fromWCharArray(L"\x229F");
      entypo_character_map["squared-plus"] = QString::fromWCharArray(L"\x229E");
      entypo_character_map["squared-cross"] = QString::fromWCharArray(L"\x274E");
      entypo_character_map["circled-minus"] = QString::fromWCharArray(L"\x2296");
      entypo_character_map["circled-plus"] = QString::fromWCharArray(L"\x2295");
      entypo_character_map["circled-cross"] = QString::fromWCharArray(L"\x2716");
      entypo_character_map["minus"] = QString::fromWCharArray(L"\x2796");
      entypo_character_map["plus"] = QString::fromWCharArray(L"\x2795");
      entypo_character_map["erase"] = QString::fromWCharArray(L"\x232B");
      entypo_character_map["block"] = QString::fromWCharArray(L"\x1F6AB");
      entypo_character_map["info"] = QString::fromWCharArray(L"\x2139");
      entypo_character_map["circled-info"] = QString::fromWCharArray(L"\xE705");
      entypo_character_map["help"] = QString::fromWCharArray(L"\x2753");
      entypo_character_map["circled-help"] = QString::fromWCharArray(L"\xE704");
      entypo_character_map["warning"] = QString::fromWCharArray(L"\x26A0");
      entypo_character_map["cycle"] = QString::fromWCharArray(L"\x1F504");
      entypo_character_map["cw"] = QString::fromWCharArray(L"\x27F3");
      entypo_character_map["ccw"] = QString::fromWCharArray(L"\x27F2");
      entypo_character_map["shuffle"] = QString::fromWCharArray(L"\x1F500");
      entypo_character_map["back"] = QString::fromWCharArray(L"\x1F519");
      entypo_character_map["level-down"] = QString::fromWCharArray(L"\x21B3");
      entypo_character_map["retweet"] = QString::fromWCharArray(L"\xE717");
      entypo_character_map["loop"] = QString::fromWCharArray(L"\x1F501");
      entypo_character_map["back-in-time"] = QString::fromWCharArray(L"\xE771");
      entypo_character_map["level-up"] = QString::fromWCharArray(L"\x21B0");
      entypo_character_map["switch"] = QString::fromWCharArray(L"\x21C6");
      entypo_character_map["numbered-list"] = QString::fromWCharArray(L"\xE005");
      entypo_character_map["add-to-list"] = QString::fromWCharArray(L"\xE003");
      entypo_character_map["layout"] = QString::fromWCharArray(L"\x268F");
      entypo_character_map["list"] = QString::fromWCharArray(L"\x2630");
      entypo_character_map["text-doc"] = QString::fromWCharArray(L"\x1F4C4");
      entypo_character_map["text-doc-inverted"] = QString::fromWCharArray(L"\xE731");
      entypo_character_map["doc"] = QString::fromWCharArray(L"\xE730");
      entypo_character_map["docs"] = QString::fromWCharArray(L"\xE736");
      entypo_character_map["landscape-doc"] = QString::fromWCharArray(L"\xE737");
      entypo_character_map["picture"] = QString::fromWCharArray(L"\x1F304");
      entypo_character_map["video"] = QString::fromWCharArray(L"\x1F3AC");
      entypo_character_map["music"] = QString::fromWCharArray(L"\x1F3B5");
      entypo_character_map["folder"] = QString::fromWCharArray(L"\x1F4C1");
      entypo_character_map["archive"] = QString::fromWCharArray(L"\xE800");
      entypo_character_map["trash"] = QString::fromWCharArray(L"\xE729");
      entypo_character_map["upload"] = QString::fromWCharArray(L"\x1F4E4");
      entypo_character_map["download"] = QString::fromWCharArray(L"\x1F4E5");
      entypo_character_map["save"] = QString::fromWCharArray(L"\x1F4BE");
      entypo_character_map["install"] = QString::fromWCharArray(L"\xE778");
      entypo_character_map["cloud"] = QString::fromWCharArray(L"\x2601");
      entypo_character_map["upload-cloud"] = QString::fromWCharArray(L"\xE711");
      entypo_character_map["bookmark"] = QString::fromWCharArray(L"\x1F516");
      entypo_character_map["bookmarks"] = QString::fromWCharArray(L"\x1F4D1");
      entypo_character_map["open-book"] = QString::fromWCharArray(L"\x1F4D6");
      entypo_character_map["play"] = QString::fromWCharArray(L"\x25B6");
      entypo_character_map["paus"] = QString::fromWCharArray(L"\x2016");
      entypo_character_map["record"] = QString::fromWCharArray(L"\x25CF");
      entypo_character_map["stop"] = QString::fromWCharArray(L"\x25A0");
      entypo_character_map["ff"] = QString::fromWCharArray(L"\x23E9");
      entypo_character_map["fb"] = QString::fromWCharArray(L"\x23EA");
      entypo_character_map["to-start"] = QString::fromWCharArray(L"\x23EE");
      entypo_character_map["to-end"] = QString::fromWCharArray(L"\x23ED");
      entypo_character_map["resize-full"] = QString::fromWCharArray(L"\xE744");
      entypo_character_map["resize-small"] = QString::fromWCharArray(L"\xE746");
      entypo_character_map["volume"] = QString::fromWCharArray(L"\x23F7");
      entypo_character_map["sound"] = QString::fromWCharArray(L"\x1F50A");
      entypo_character_map["mute"] = QString::fromWCharArray(L"\x1F507");
      entypo_character_map["flow-cascade"] = QString::fromWCharArray(L"\x1F568");
      entypo_character_map["flow-branch"] = QString::fromWCharArray(L"\x1F569");
      entypo_character_map["flow-tree"] = QString::fromWCharArray(L"\x1F56A");
      entypo_character_map["flow-line"] = QString::fromWCharArray(L"\x1F56B");
      entypo_character_map["flow-parallel"] = QString::fromWCharArray(L"\x1F56C");
      entypo_character_map["left-bold"] = QString::fromWCharArray(L"\xE4AD");
      entypo_character_map["down-bold"] = QString::fromWCharArray(L"\xE4B0");
      entypo_character_map["up-bold"] = QString::fromWCharArray(L"\xE4AF");
      entypo_character_map["right-bold"] = QString::fromWCharArray(L"\xE4AE");
      entypo_character_map["left"] = QString::fromWCharArray(L"\x2B05");
      entypo_character_map["down"] = QString::fromWCharArray(L"\x2B07");
      entypo_character_map["up"] = QString::fromWCharArray(L"\x2B06");
      entypo_character_map["right"] = QString::fromWCharArray(L"\x27A1");
      entypo_character_map["circled-left"] = QString::fromWCharArray(L"\xE759");
      entypo_character_map["circled-down"] = QString::fromWCharArray(L"\xE758");
      entypo_character_map["circled-up"] = QString::fromWCharArray(L"\xE75B");
      entypo_character_map["circled-right"] = QString::fromWCharArray(L"\xE75A");
      entypo_character_map["triangle-left"] = QString::fromWCharArray(L"\x25C2");
      entypo_character_map["triangle-down"] = QString::fromWCharArray(L"\x25BE");
      entypo_character_map["triangle-up"] = QString::fromWCharArray(L"\x25B4");
      entypo_character_map["triangle-right"] = QString::fromWCharArray(L"\x25B8");
      entypo_character_map["chevron-left"] = QString::fromWCharArray(L"\xE75D");
      entypo_character_map["chevron-down"] = QString::fromWCharArray(L"\xE75C");
      entypo_character_map["chevron-up"] = QString::fromWCharArray(L"\xE75F");
      entypo_character_map["chevron-right"] = QString::fromWCharArray(L"\xE75E");
      entypo_character_map["chevron-small-left"] = QString::fromWCharArray(L"\xE761");
      entypo_character_map["chevron-small-down"] = QString::fromWCharArray(L"\xE760");
      entypo_character_map["chevron-small-up"] = QString::fromWCharArray(L"\xE763");
      entypo_character_map["chevron-small-right"] = QString::fromWCharArray(L"\xE762");
      entypo_character_map["chevron-thin-left"] = QString::fromWCharArray(L"\xE765");
      entypo_character_map["chevron-thin-down"] = QString::fromWCharArray(L"\xE764");
      entypo_character_map["chevron-thin-up"] = QString::fromWCharArray(L"\xE767");
      entypo_character_map["chevron-thin-right"] = QString::fromWCharArray(L"\xE766");
      entypo_character_map["left-thin"] = QString::fromWCharArray(L"\x2190");
      entypo_character_map["down-thin"] = QString::fromWCharArray(L"\x2193");
      entypo_character_map["up-thin"] = QString::fromWCharArray(L"\x2191");
      entypo_character_map["right-thin"] = QString::fromWCharArray(L"\x2192");
      entypo_character_map["arrow-combo"] = QString::fromWCharArray(L"\xE74F");
      entypo_character_map["three-dots"] = QString::fromWCharArray(L"\x23F6");
      entypo_character_map["two-dots"] = QString::fromWCharArray(L"\x23F5");
      entypo_character_map["dot"] = QString::fromWCharArray(L"\x23F4");
      entypo_character_map["cc"] = QString::fromWCharArray(L"\x1F545");
      entypo_character_map["cc-by"] = QString::fromWCharArray(L"\x1F546");
      entypo_character_map["cc-nc"] = QString::fromWCharArray(L"\x1F547");
      entypo_character_map["cc-nc-eu"] = QString::fromWCharArray(L"\x1F548");
      entypo_character_map["cc-nc-jp"] = QString::fromWCharArray(L"\x1F549");
      entypo_character_map["cc-sa"] = QString::fromWCharArray(L"\x1F54A");
      entypo_character_map["cc-nd"] = QString::fromWCharArray(L"\x1F54B");
      entypo_character_map["cc-pd"] = QString::fromWCharArray(L"\x1F54C");
      entypo_character_map["cc-zero"] = QString::fromWCharArray(L"\x1F54D");
      entypo_character_map["cc-share"] = QString::fromWCharArray(L"\x1F54E");
      entypo_character_map["cc-remix"] = QString::fromWCharArray(L"\x1F54F");
      entypo_character_map["db-logo"] = QString::fromWCharArray(L"\x1F5F9");
      entypo_character_map["db-shape"] = QString::fromWCharArray(L"\x1F5FA");

      entypo_social_character_map["github"] = QString::fromWCharArray(L"\xF300");
      entypo_social_character_map["c-github"] = QString::fromWCharArray(L"\xF301");
      entypo_social_character_map["flickr"] = QString::fromWCharArray(L"\xF303");
      entypo_social_character_map["c-flickr"] = QString::fromWCharArray(L"\xF304");
      entypo_social_character_map["vimeo"] = QString::fromWCharArray(L"\xF306");
      entypo_social_character_map["c-vimeo"] = QString::fromWCharArray(L"\xF307");
      entypo_social_character_map["twitter"] = QString::fromWCharArray(L"\xF309");
      entypo_social_character_map["c-twitter"] = QString::fromWCharArray(L"\xF30A");
      entypo_social_character_map["facebook"] = QString::fromWCharArray(L"\xF30C");
      entypo_social_character_map["c-facebook"] = QString::fromWCharArray(L"\xF30D");
      entypo_social_character_map["s-facebook"] = QString::fromWCharArray(L"\xF30E");
      entypo_social_character_map["google+"] = QString::fromWCharArray(L"\xF30F");
      entypo_social_character_map["c-google+"] = QString::fromWCharArray(L"\xF310");
      entypo_social_character_map["pinterest"] = QString::fromWCharArray(L"\xF312");
      entypo_social_character_map["c-pinterest"] = QString::fromWCharArray(L"\xF313");
      entypo_social_character_map["tumblr"] = QString::fromWCharArray(L"\xF315");
      entypo_social_character_map["c-tumblr"] = QString::fromWCharArray(L"\xF316");
      entypo_social_character_map["linkedin"] = QString::fromWCharArray(L"\xF318");
      entypo_social_character_map["c-linkedin"] = QString::fromWCharArray(L"\xF319");
      entypo_social_character_map["dribbble"] = QString::fromWCharArray(L"\xF31B");
      entypo_social_character_map["c-dribbble"] = QString::fromWCharArray(L"\xF31C");
      entypo_social_character_map["stumbleupon"] = QString::fromWCharArray(L"\xF31E");
      entypo_social_character_map["c-stumbleupon"] = QString::fromWCharArray(L"\xF31F");
      entypo_social_character_map["lastfm"] = QString::fromWCharArray(L"\xF321");
      entypo_social_character_map["c-lastfm"] = QString::fromWCharArray(L"\xF322");
      entypo_social_character_map["rdio"] = QString::fromWCharArray(L"\xF324");
      entypo_social_character_map["c-rdio"] = QString::fromWCharArray(L"\xF325");
      entypo_social_character_map["spotify"] = QString::fromWCharArray(L"\xF327");
      entypo_social_character_map["c-spotify"] = QString::fromWCharArray(L"\xF328");
      entypo_social_character_map["qq"] = QString::fromWCharArray(L"\xF32A");
      entypo_social_character_map["instagram"] = QString::fromWCharArray(L"\xF32D");
      entypo_social_character_map["dropbox"] = QString::fromWCharArray(L"\xF330");
      entypo_social_character_map["evernote"] = QString::fromWCharArray(L"\xF333");
      entypo_social_character_map["flattr"] = QString::fromWCharArray(L"\xF336");
      entypo_social_character_map["skype"] = QString::fromWCharArray(L"\xF339");
      entypo_social_character_map["c-skype"] = QString::fromWCharArray(L"\xF33A");
      entypo_social_character_map["renren"] = QString::fromWCharArray(L"\xF33C");
      entypo_social_character_map["sina-weibo"] = QString::fromWCharArray(L"\xF33F");
      entypo_social_character_map["paypal"] = QString::fromWCharArray(L"\xF342");
      entypo_social_character_map["picasa"] = QString::fromWCharArray(L"\xF345");
      entypo_social_character_map["soundcloud"] = QString::fromWCharArray(L"\xF348");
      entypo_social_character_map["mixi"] = QString::fromWCharArray(L"\xF34B");
      entypo_social_character_map["behance"] = QString::fromWCharArray(L"\xF34E");
      entypo_social_character_map["google-circles"] = QString::fromWCharArray(L"\xF351");
      entypo_social_character_map["vk"] = QString::fromWCharArray(L"\xF354");
      entypo_social_character_map["smashing"] = QString::fromWCharArray(L"\xF357");
      fontawesome_character_map["fa-glass"] = QString::fromWCharArray(L"\xF000");
      fontawesome_character_map["fa-music"] = QString::fromWCharArray(L"\xF001");
      fontawesome_character_map["fa-search"] = QString::fromWCharArray(L"\xF002");
      fontawesome_character_map["fa-envelope-o"] = QString::fromWCharArray(L"\xF003");
      fontawesome_character_map["fa-heart"] = QString::fromWCharArray(L"\xF004");
      fontawesome_character_map["fa-star"] = QString::fromWCharArray(L"\xF005");
      fontawesome_character_map["fa-star-o"] = QString::fromWCharArray(L"\xF006");
      fontawesome_character_map["fa-user"] = QString::fromWCharArray(L"\xF007");
      fontawesome_character_map["fa-film"] = QString::fromWCharArray(L"\xF008");
      fontawesome_character_map["fa-th-large"] = QString::fromWCharArray(L"\xF009");
      fontawesome_character_map["fa-th"] = QString::fromWCharArray(L"\xF00a");
      fontawesome_character_map["fa-th-list"] = QString::fromWCharArray(L"\xF00b");
      fontawesome_character_map["fa-check"] = QString::fromWCharArray(L"\xF00c");
      fontawesome_character_map["fa-remove"] = QString::fromWCharArray(L"\xF00d");
      fontawesome_character_map["fa-close"] = QString::fromWCharArray(L"\xF00d");
      fontawesome_character_map["fa-times"] = QString::fromWCharArray(L"\xF00d");
      fontawesome_character_map["fa-search-plus"] = QString::fromWCharArray(L"\xF00e");
      fontawesome_character_map["fa-search-minus"] = QString::fromWCharArray(L"\xF010");
      fontawesome_character_map["fa-power-off"] = QString::fromWCharArray(L"\xF011");
      fontawesome_character_map["fa-signal"] = QString::fromWCharArray(L"\xF012");
      fontawesome_character_map["fa-gear"] = QString::fromWCharArray(L"\xF013");
      fontawesome_character_map["fa-cog"] = QString::fromWCharArray(L"\xF013");
      fontawesome_character_map["fa-trash-o"] = QString::fromWCharArray(L"\xF014");
      fontawesome_character_map["fa-home"] = QString::fromWCharArray(L"\xF015");
      fontawesome_character_map["fa-file-o"] = QString::fromWCharArray(L"\xF016");
      fontawesome_character_map["fa-clock-o"] = QString::fromWCharArray(L"\xF017");
      fontawesome_character_map["fa-road"] = QString::fromWCharArray(L"\xF018");
      fontawesome_character_map["fa-download"] = QString::fromWCharArray(L"\xF019");
      fontawesome_character_map["fa-arrow-circle-o-down"] = QString::fromWCharArray(L"\xF01a");
      fontawesome_character_map["fa-arrow-circle-o-up"] = QString::fromWCharArray(L"\xF01b");
      fontawesome_character_map["fa-inbox"] = QString::fromWCharArray(L"\xF01c");
      fontawesome_character_map["fa-play-circle-o"] = QString::fromWCharArray(L"\xF01d");
      fontawesome_character_map["fa-rotate-right"] = QString::fromWCharArray(L"\xF01e");
      fontawesome_character_map["fa-repeat"] = QString::fromWCharArray(L"\xF01e");
      fontawesome_character_map["fa-refresh"] = QString::fromWCharArray(L"\xF021");
      fontawesome_character_map["fa-list-alt"] = QString::fromWCharArray(L"\xF022");
      fontawesome_character_map["fa-lock"] = QString::fromWCharArray(L"\xF023");
      fontawesome_character_map["fa-flag"] = QString::fromWCharArray(L"\xF024");
      fontawesome_character_map["fa-headphones"] = QString::fromWCharArray(L"\xF025");
      fontawesome_character_map["fa-volume-off"] = QString::fromWCharArray(L"\xF026");
      fontawesome_character_map["fa-volume-down"] = QString::fromWCharArray(L"\xF027");
      fontawesome_character_map["fa-volume-up"] = QString::fromWCharArray(L"\xF028");
      fontawesome_character_map["fa-qrcode"] = QString::fromWCharArray(L"\xF029");
      fontawesome_character_map["fa-barcode"] = QString::fromWCharArray(L"\xF02a");
      fontawesome_character_map["fa-tag"] = QString::fromWCharArray(L"\xF02b");
      fontawesome_character_map["fa-tags"] = QString::fromWCharArray(L"\xF02c");
      fontawesome_character_map["fa-book"] = QString::fromWCharArray(L"\xF02d");
      fontawesome_character_map["fa-bookmark"] = QString::fromWCharArray(L"\xF02e");
      fontawesome_character_map["fa-print"] = QString::fromWCharArray(L"\xF02f");
      fontawesome_character_map["fa-camera"] = QString::fromWCharArray(L"\xF030");
      fontawesome_character_map["fa-font"] = QString::fromWCharArray(L"\xF031");
      fontawesome_character_map["fa-bold"] = QString::fromWCharArray(L"\xF032");
      fontawesome_character_map["fa-italic"] = QString::fromWCharArray(L"\xF033");
      fontawesome_character_map["fa-text-height"] = QString::fromWCharArray(L"\xF034");
      fontawesome_character_map["fa-text-width"] = QString::fromWCharArray(L"\xF035");
      fontawesome_character_map["fa-align-left"] = QString::fromWCharArray(L"\xF036");
      fontawesome_character_map["fa-align-center"] = QString::fromWCharArray(L"\xF037");
      fontawesome_character_map["fa-align-right"] = QString::fromWCharArray(L"\xF038");
      fontawesome_character_map["fa-align-justify"] = QString::fromWCharArray(L"\xF039");
      fontawesome_character_map["fa-list"] = QString::fromWCharArray(L"\xF03a");
      fontawesome_character_map["fa-dedent"] = QString::fromWCharArray(L"\xF03b");
      fontawesome_character_map["fa-outdent"] = QString::fromWCharArray(L"\xF03b");
      fontawesome_character_map["fa-indent"] = QString::fromWCharArray(L"\xF03c");
      fontawesome_character_map["fa-video-camera"] = QString::fromWCharArray(L"\xF03d");
      fontawesome_character_map["fa-photo"] = QString::fromWCharArray(L"\xF03e");
      fontawesome_character_map["fa-image"] = QString::fromWCharArray(L"\xF03e");
      fontawesome_character_map["fa-picture-o"] = QString::fromWCharArray(L"\xF03e");
      fontawesome_character_map["fa-pencil"] = QString::fromWCharArray(L"\xF040");
      fontawesome_character_map["fa-map-marker"] = QString::fromWCharArray(L"\xF041");
      fontawesome_character_map["fa-adjust"] = QString::fromWCharArray(L"\xF042");
      fontawesome_character_map["fa-tint"] = QString::fromWCharArray(L"\xF043");
      fontawesome_character_map["fa-edit"] = QString::fromWCharArray(L"\xF044");
      fontawesome_character_map["fa-pencil-square-o"] = QString::fromWCharArray(L"\xF044");
      fontawesome_character_map["fa-share-square-o"] = QString::fromWCharArray(L"\xF045");
      fontawesome_character_map["fa-check-square-o"] = QString::fromWCharArray(L"\xF046");
      fontawesome_character_map["fa-arrows"] = QString::fromWCharArray(L"\xF047");
      fontawesome_character_map["fa-step-backward"] = QString::fromWCharArray(L"\xF048");
      fontawesome_character_map["fa-fast-backward"] = QString::fromWCharArray(L"\xF049");
      fontawesome_character_map["fa-backward"] = QString::fromWCharArray(L"\xF04a");
      fontawesome_character_map["fa-play"] = QString::fromWCharArray(L"\xF04b");
      fontawesome_character_map["fa-pause"] = QString::fromWCharArray(L"\xF04c");
      fontawesome_character_map["fa-stop"] = QString::fromWCharArray(L"\xF04d");
      fontawesome_character_map["fa-forward"] = QString::fromWCharArray(L"\xF04e");
      fontawesome_character_map["fa-fast-forward"] = QString::fromWCharArray(L"\xF050");
      fontawesome_character_map["fa-step-forward"] = QString::fromWCharArray(L"\xF051");
      fontawesome_character_map["fa-eject"] = QString::fromWCharArray(L"\xF052");
      fontawesome_character_map["fa-chevron-left"] = QString::fromWCharArray(L"\xF053");
      fontawesome_character_map["fa-chevron-right"] = QString::fromWCharArray(L"\xF054");
      fontawesome_character_map["fa-plus-circle"] = QString::fromWCharArray(L"\xF055");
      fontawesome_character_map["fa-minus-circle"] = QString::fromWCharArray(L"\xF056");
      fontawesome_character_map["fa-times-circle"] = QString::fromWCharArray(L"\xF057");
      fontawesome_character_map["fa-check-circle"] = QString::fromWCharArray(L"\xF058");
      fontawesome_character_map["fa-question-circle"] = QString::fromWCharArray(L"\xF059");
      fontawesome_character_map["fa-info-circle"] = QString::fromWCharArray(L"\xF05a");
      fontawesome_character_map["fa-crosshairs"] = QString::fromWCharArray(L"\xF05b");
      fontawesome_character_map["fa-times-circle-o"] = QString::fromWCharArray(L"\xF05c");
      fontawesome_character_map["fa-check-circle-o"] = QString::fromWCharArray(L"\xF05d");
      fontawesome_character_map["fa-ban"] = QString::fromWCharArray(L"\xF05e");
      fontawesome_character_map["fa-arrow-left"] = QString::fromWCharArray(L"\xF060");
      fontawesome_character_map["fa-arrow-right"] = QString::fromWCharArray(L"\xF061");
      fontawesome_character_map["fa-arrow-up"] = QString::fromWCharArray(L"\xF062");
      fontawesome_character_map["fa-arrow-down"] = QString::fromWCharArray(L"\xF063");
      fontawesome_character_map["fa-mail-forward"] = QString::fromWCharArray(L"\xF064");
      fontawesome_character_map["fa-share"] = QString::fromWCharArray(L"\xF064");
      fontawesome_character_map["fa-expand"] = QString::fromWCharArray(L"\xF065");
      fontawesome_character_map["fa-compress"] = QString::fromWCharArray(L"\xF066");
      fontawesome_character_map["fa-plus"] = QString::fromWCharArray(L"\xF067");
      fontawesome_character_map["fa-minus"] = QString::fromWCharArray(L"\xF068");
      fontawesome_character_map["fa-asterisk"] = QString::fromWCharArray(L"\xF069");
      fontawesome_character_map["fa-exclamation-circle"] = QString::fromWCharArray(L"\xF06a");
      fontawesome_character_map["fa-gift"] = QString::fromWCharArray(L"\xF06b");
      fontawesome_character_map["fa-leaf"] = QString::fromWCharArray(L"\xF06c");
      fontawesome_character_map["fa-fire"] = QString::fromWCharArray(L"\xF06d");
      fontawesome_character_map["fa-eye"] = QString::fromWCharArray(L"\xF06e");
      fontawesome_character_map["fa-eye-slash"] = QString::fromWCharArray(L"\xF070");
      fontawesome_character_map["fa-warning"] = QString::fromWCharArray(L"\xF071");
      fontawesome_character_map["fa-exclamation-triangle"] = QString::fromWCharArray(L"\xF071");
      fontawesome_character_map["fa-plane"] = QString::fromWCharArray(L"\xF072");
      fontawesome_character_map["fa-calendar"] = QString::fromWCharArray(L"\xF073");
      fontawesome_character_map["fa-random"] = QString::fromWCharArray(L"\xF074");
      fontawesome_character_map["fa-comment"] = QString::fromWCharArray(L"\xF075");
      fontawesome_character_map["fa-magnet"] = QString::fromWCharArray(L"\xF076");
      fontawesome_character_map["fa-chevron-up"] = QString::fromWCharArray(L"\xF077");
      fontawesome_character_map["fa-chevron-down"] = QString::fromWCharArray(L"\xF078");
      fontawesome_character_map["fa-retweet"] = QString::fromWCharArray(L"\xF079");
      fontawesome_character_map["fa-shopping-cart"] = QString::fromWCharArray(L"\xF07a");
      fontawesome_character_map["fa-folder"] = QString::fromWCharArray(L"\xF07b");
      fontawesome_character_map["fa-folder-open"] = QString::fromWCharArray(L"\xF07c");
      fontawesome_character_map["fa-arrows-v"] = QString::fromWCharArray(L"\xF07d");
      fontawesome_character_map["fa-arrows-h"] = QString::fromWCharArray(L"\xF07e");
      fontawesome_character_map["fa-bar-chart-o"] = QString::fromWCharArray(L"\xF080");
      fontawesome_character_map["fa-bar-chart"] = QString::fromWCharArray(L"\xF080");
      fontawesome_character_map["fa-twitter-square"] = QString::fromWCharArray(L"\xF081");
      fontawesome_character_map["fa-facebook-square"] = QString::fromWCharArray(L"\xF082");
      fontawesome_character_map["fa-camera-retro"] = QString::fromWCharArray(L"\xF083");
      fontawesome_character_map["fa-key"] = QString::fromWCharArray(L"\xF084");
      fontawesome_character_map["fa-gears"] = QString::fromWCharArray(L"\xF085");
      fontawesome_character_map["fa-cogs"] = QString::fromWCharArray(L"\xF085");
      fontawesome_character_map["fa-comments"] = QString::fromWCharArray(L"\xF086");
      fontawesome_character_map["fa-thumbs-o-up"] = QString::fromWCharArray(L"\xF087");
      fontawesome_character_map["fa-thumbs-o-down"] = QString::fromWCharArray(L"\xF088");
      fontawesome_character_map["fa-star-half"] = QString::fromWCharArray(L"\xF089");
      fontawesome_character_map["fa-heart-o"] = QString::fromWCharArray(L"\xF08a");
      fontawesome_character_map["fa-sign-out"] = QString::fromWCharArray(L"\xF08b");
      fontawesome_character_map["fa-linkedin-square"] = QString::fromWCharArray(L"\xF08c");
      fontawesome_character_map["fa-thumb-tack"] = QString::fromWCharArray(L"\xF08d");
      fontawesome_character_map["fa-external-link"] = QString::fromWCharArray(L"\xF08e");
      fontawesome_character_map["fa-sign-in"] = QString::fromWCharArray(L"\xF090");
      fontawesome_character_map["fa-trophy"] = QString::fromWCharArray(L"\xF091");
      fontawesome_character_map["fa-github-square"] = QString::fromWCharArray(L"\xF092");
      fontawesome_character_map["fa-upload"] = QString::fromWCharArray(L"\xF093");
      fontawesome_character_map["fa-lemon-o"] = QString::fromWCharArray(L"\xF094");
      fontawesome_character_map["fa-phone"] = QString::fromWCharArray(L"\xF095");
      fontawesome_character_map["fa-square-o"] = QString::fromWCharArray(L"\xF096");
      fontawesome_character_map["fa-bookmark-o"] = QString::fromWCharArray(L"\xF097");
      fontawesome_character_map["fa-phone-square"] = QString::fromWCharArray(L"\xF098");
      fontawesome_character_map["fa-twitter"] = QString::fromWCharArray(L"\xF099");
      fontawesome_character_map["fa-facebook"] = QString::fromWCharArray(L"\xF09a");
      fontawesome_character_map["fa-github"] = QString::fromWCharArray(L"\xF09b");
      fontawesome_character_map["fa-unlock"] = QString::fromWCharArray(L"\xF09c");
      fontawesome_character_map["fa-credit-card"] = QString::fromWCharArray(L"\xF09d");
      fontawesome_character_map["fa-rss"] = QString::fromWCharArray(L"\xF09e");
      fontawesome_character_map["fa-hdd-o"] = QString::fromWCharArray(L"\xF0a0");
      fontawesome_character_map["fa-bullhorn"] = QString::fromWCharArray(L"\xF0a1");
      fontawesome_character_map["fa-bell"] = QString::fromWCharArray(L"\xF0f3");
      fontawesome_character_map["fa-certificate"] = QString::fromWCharArray(L"\xF0a3");
      fontawesome_character_map["fa-hand-o-right"] = QString::fromWCharArray(L"\xF0a4");
      fontawesome_character_map["fa-hand-o-left"] = QString::fromWCharArray(L"\xF0a5");
      fontawesome_character_map["fa-hand-o-up"] = QString::fromWCharArray(L"\xF0a6");
      fontawesome_character_map["fa-hand-o-down"] = QString::fromWCharArray(L"\xF0a7");
      fontawesome_character_map["fa-arrow-circle-left"] = QString::fromWCharArray(L"\xF0a8");
      fontawesome_character_map["fa-arrow-circle-right"] = QString::fromWCharArray(L"\xF0a9");
      fontawesome_character_map["fa-arrow-circle-up"] = QString::fromWCharArray(L"\xF0aa");
      fontawesome_character_map["fa-arrow-circle-down"] = QString::fromWCharArray(L"\xF0ab");
      fontawesome_character_map["fa-globe"] = QString::fromWCharArray(L"\xF0ac");
      fontawesome_character_map["fa-wrench"] = QString::fromWCharArray(L"\xF0ad");
      fontawesome_character_map["fa-tasks"] = QString::fromWCharArray(L"\xF0ae");
      fontawesome_character_map["fa-filter"] = QString::fromWCharArray(L"\xF0b0");
      fontawesome_character_map["fa-briefcase"] = QString::fromWCharArray(L"\xF0b1");
      fontawesome_character_map["fa-arrows-alt"] = QString::fromWCharArray(L"\xF0b2");
      fontawesome_character_map["fa-group"] = QString::fromWCharArray(L"\xF0c0");
      fontawesome_character_map["fa-users"] = QString::fromWCharArray(L"\xF0c0");
      fontawesome_character_map["fa-chain"] = QString::fromWCharArray(L"\xF0c1");
      fontawesome_character_map["fa-link"] = QString::fromWCharArray(L"\xF0c1");
      fontawesome_character_map["fa-cloud"] = QString::fromWCharArray(L"\xF0c2");
      fontawesome_character_map["fa-flask"] = QString::fromWCharArray(L"\xF0c3");
      fontawesome_character_map["fa-cut"] = QString::fromWCharArray(L"\xF0c4");
      fontawesome_character_map["fa-scissors"] = QString::fromWCharArray(L"\xF0c4");
      fontawesome_character_map["fa-copy"] = QString::fromWCharArray(L"\xF0c5");
      fontawesome_character_map["fa-files-o"] = QString::fromWCharArray(L"\xF0c5");
      fontawesome_character_map["fa-paperclip"] = QString::fromWCharArray(L"\xF0c6");
      fontawesome_character_map["fa-save"] = QString::fromWCharArray(L"\xF0c7");
      fontawesome_character_map["fa-floppy-o"] = QString::fromWCharArray(L"\xF0c7");
      fontawesome_character_map["fa-square"] = QString::fromWCharArray(L"\xF0c8");
      fontawesome_character_map["fa-navicon"] = QString::fromWCharArray(L"\xF0c9");
      fontawesome_character_map["fa-reorder"] = QString::fromWCharArray(L"\xF0c9");
      fontawesome_character_map["fa-bars"] = QString::fromWCharArray(L"\xF0c9");
      fontawesome_character_map["fa-list-ul"] = QString::fromWCharArray(L"\xF0ca");
      fontawesome_character_map["fa-list-ol"] = QString::fromWCharArray(L"\xF0cb");
      fontawesome_character_map["fa-strikethrough"] = QString::fromWCharArray(L"\xF0cc");
      fontawesome_character_map["fa-underline"] = QString::fromWCharArray(L"\xF0cd");
      fontawesome_character_map["fa-table"] = QString::fromWCharArray(L"\xF0ce");
      fontawesome_character_map["fa-magic"] = QString::fromWCharArray(L"\xF0d0");
      fontawesome_character_map["fa-truck"] = QString::fromWCharArray(L"\xF0d1");
      fontawesome_character_map["fa-pinterest"] = QString::fromWCharArray(L"\xF0d2");
      fontawesome_character_map["fa-pinterest-square"] = QString::fromWCharArray(L"\xF0d3");
      fontawesome_character_map["fa-google-plus-square"] = QString::fromWCharArray(L"\xF0d4");
      fontawesome_character_map["fa-google-plus"] = QString::fromWCharArray(L"\xF0d5");
      fontawesome_character_map["fa-money"] = QString::fromWCharArray(L"\xF0d6");
      fontawesome_character_map["fa-caret-down"] = QString::fromWCharArray(L"\xF0d7");
      fontawesome_character_map["fa-caret-up"] = QString::fromWCharArray(L"\xF0d8");
      fontawesome_character_map["fa-caret-left"] = QString::fromWCharArray(L"\xF0d9");
      fontawesome_character_map["fa-caret-right"] = QString::fromWCharArray(L"\xF0da");
      fontawesome_character_map["fa-columns"] = QString::fromWCharArray(L"\xF0db");
      fontawesome_character_map["fa-unsorted"] = QString::fromWCharArray(L"\xF0dc");
      fontawesome_character_map["fa-sort"] = QString::fromWCharArray(L"\xF0dc");
      fontawesome_character_map["fa-sort-down"] = QString::fromWCharArray(L"\xF0dd");
      fontawesome_character_map["fa-sort-desc"] = QString::fromWCharArray(L"\xF0dd");
      fontawesome_character_map["fa-sort-up"] = QString::fromWCharArray(L"\xF0de");
      fontawesome_character_map["fa-sort-asc"] = QString::fromWCharArray(L"\xF0de");
      fontawesome_character_map["fa-envelope"] = QString::fromWCharArray(L"\xF0e0");
      fontawesome_character_map["fa-linkedin"] = QString::fromWCharArray(L"\xF0e1");
      fontawesome_character_map["fa-rotate-left"] = QString::fromWCharArray(L"\xF0e2");
      fontawesome_character_map["fa-undo"] = QString::fromWCharArray(L"\xF0e2");
      fontawesome_character_map["fa-legal"] = QString::fromWCharArray(L"\xF0e3");
      fontawesome_character_map["fa-gavel"] = QString::fromWCharArray(L"\xF0e3");
      fontawesome_character_map["fa-dashboard"] = QString::fromWCharArray(L"\xF0e4");
      fontawesome_character_map["fa-tachometer"] = QString::fromWCharArray(L"\xF0e4");
      fontawesome_character_map["fa-comment-o"] = QString::fromWCharArray(L"\xF0e5");
      fontawesome_character_map["fa-comments-o"] = QString::fromWCharArray(L"\xF0e6");
      fontawesome_character_map["fa-flash"] = QString::fromWCharArray(L"\xF0e7");
      fontawesome_character_map["fa-bolt"] = QString::fromWCharArray(L"\xF0e7");
      fontawesome_character_map["fa-sitemap"] = QString::fromWCharArray(L"\xF0e8");
      fontawesome_character_map["fa-umbrella"] = QString::fromWCharArray(L"\xF0e9");
      fontawesome_character_map["fa-paste"] = QString::fromWCharArray(L"\xF0ea");
      fontawesome_character_map["fa-clipboard"] = QString::fromWCharArray(L"\xF0ea");
      fontawesome_character_map["fa-lightbulb-o"] = QString::fromWCharArray(L"\xF0eb");
      fontawesome_character_map["fa-exchange"] = QString::fromWCharArray(L"\xF0ec");
      fontawesome_character_map["fa-cloud-download"] = QString::fromWCharArray(L"\xF0ed");
      fontawesome_character_map["fa-cloud-upload"] = QString::fromWCharArray(L"\xF0ee");
      fontawesome_character_map["fa-user-md"] = QString::fromWCharArray(L"\xF0f0");
      fontawesome_character_map["fa-stethoscope"] = QString::fromWCharArray(L"\xF0f1");
      fontawesome_character_map["fa-suitcase"] = QString::fromWCharArray(L"\xF0f2");
      fontawesome_character_map["fa-bell-o"] = QString::fromWCharArray(L"\xF0a2");
      fontawesome_character_map["fa-coffee"] = QString::fromWCharArray(L"\xF0f4");
      fontawesome_character_map["fa-cutlery"] = QString::fromWCharArray(L"\xF0f5");
      fontawesome_character_map["fa-file-text-o"] = QString::fromWCharArray(L"\xF0f6");
      fontawesome_character_map["fa-building-o"] = QString::fromWCharArray(L"\xF0f7");
      fontawesome_character_map["fa-hospital-o"] = QString::fromWCharArray(L"\xF0f8");
      fontawesome_character_map["fa-ambulance"] = QString::fromWCharArray(L"\xF0f9");
      fontawesome_character_map["fa-medkit"] = QString::fromWCharArray(L"\xF0fa");
      fontawesome_character_map["fa-fighter-jet"] = QString::fromWCharArray(L"\xF0fb");
      fontawesome_character_map["fa-beer"] = QString::fromWCharArray(L"\xF0fc");
      fontawesome_character_map["fa-h-square"] = QString::fromWCharArray(L"\xF0fd");
      fontawesome_character_map["fa-plus-square"] = QString::fromWCharArray(L"\xF0fe");
      fontawesome_character_map["fa-angle-double-left"] = QString::fromWCharArray(L"\xF100");
      fontawesome_character_map["fa-angle-double-right"] = QString::fromWCharArray(L"\xF101");
      fontawesome_character_map["fa-angle-double-up"] = QString::fromWCharArray(L"\xF102");
      fontawesome_character_map["fa-angle-double-down"] = QString::fromWCharArray(L"\xF103");
      fontawesome_character_map["fa-angle-left"] = QString::fromWCharArray(L"\xF104");
      fontawesome_character_map["fa-angle-right"] = QString::fromWCharArray(L"\xF105");
      fontawesome_character_map["fa-angle-up"] = QString::fromWCharArray(L"\xF106");
      fontawesome_character_map["fa-angle-down"] = QString::fromWCharArray(L"\xF107");
      fontawesome_character_map["fa-desktop"] = QString::fromWCharArray(L"\xF108");
      fontawesome_character_map["fa-laptop"] = QString::fromWCharArray(L"\xF109");
      fontawesome_character_map["fa-tablet"] = QString::fromWCharArray(L"\xF10a");
      fontawesome_character_map["fa-mobile-phone"] = QString::fromWCharArray(L"\xF10b");
      fontawesome_character_map["fa-mobile"] = QString::fromWCharArray(L"\xF10b");
      fontawesome_character_map["fa-circle-o"] = QString::fromWCharArray(L"\xF10c");
      fontawesome_character_map["fa-quote-left"] = QString::fromWCharArray(L"\xF10d");
      fontawesome_character_map["fa-quote-right"] = QString::fromWCharArray(L"\xF10e");
      fontawesome_character_map["fa-spinner"] = QString::fromWCharArray(L"\xF110");
      fontawesome_character_map["fa-circle"] = QString::fromWCharArray(L"\xF111");
      fontawesome_character_map["fa-mail-reply"] = QString::fromWCharArray(L"\xF112");
      fontawesome_character_map["fa-reply"] = QString::fromWCharArray(L"\xF112");
      fontawesome_character_map["fa-github-alt"] = QString::fromWCharArray(L"\xF113");
      fontawesome_character_map["fa-folder-o"] = QString::fromWCharArray(L"\xF114");
      fontawesome_character_map["fa-folder-open-o"] = QString::fromWCharArray(L"\xF115");
      fontawesome_character_map["fa-smile-o"] = QString::fromWCharArray(L"\xF118");
      fontawesome_character_map["fa-frown-o"] = QString::fromWCharArray(L"\xF119");
      fontawesome_character_map["fa-meh-o"] = QString::fromWCharArray(L"\xF11a");
      fontawesome_character_map["fa-gamepad"] = QString::fromWCharArray(L"\xF11b");
      fontawesome_character_map["fa-keyboard-o"] = QString::fromWCharArray(L"\xF11c");
      fontawesome_character_map["fa-flag-o"] = QString::fromWCharArray(L"\xF11d");
      fontawesome_character_map["fa-flag-checkered"] = QString::fromWCharArray(L"\xF11e");
      fontawesome_character_map["fa-terminal"] = QString::fromWCharArray(L"\xF120");
      fontawesome_character_map["fa-code"] = QString::fromWCharArray(L"\xF121");
      fontawesome_character_map["fa-mail-reply-all"] = QString::fromWCharArray(L"\xF122");
      fontawesome_character_map["fa-reply-all"] = QString::fromWCharArray(L"\xF122");
      fontawesome_character_map["fa-star-half-empty"] = QString::fromWCharArray(L"\xF123");
      fontawesome_character_map["fa-star-half-full"] = QString::fromWCharArray(L"\xF123");
      fontawesome_character_map["fa-star-half-o"] = QString::fromWCharArray(L"\xF123");
      fontawesome_character_map["fa-location-arrow"] = QString::fromWCharArray(L"\xF124");
      fontawesome_character_map["fa-crop"] = QString::fromWCharArray(L"\xF125");
      fontawesome_character_map["fa-code-fork"] = QString::fromWCharArray(L"\xF126");
      fontawesome_character_map["fa-unlink"] = QString::fromWCharArray(L"\xF127");
      fontawesome_character_map["fa-chain-broken"] = QString::fromWCharArray(L"\xF127");
      fontawesome_character_map["fa-question"] = QString::fromWCharArray(L"\xF128");
      fontawesome_character_map["fa-info"] = QString::fromWCharArray(L"\xF129");
      fontawesome_character_map["fa-exclamation"] = QString::fromWCharArray(L"\xF12a");
      fontawesome_character_map["fa-superscript"] = QString::fromWCharArray(L"\xF12b");
      fontawesome_character_map["fa-subscript"] = QString::fromWCharArray(L"\xF12c");
      fontawesome_character_map["fa-eraser"] = QString::fromWCharArray(L"\xF12d");
      fontawesome_character_map["fa-puzzle-piece"] = QString::fromWCharArray(L"\xF12e");
      fontawesome_character_map["fa-microphone"] = QString::fromWCharArray(L"\xF130");
      fontawesome_character_map["fa-microphone-slash"] = QString::fromWCharArray(L"\xF131");
      fontawesome_character_map["fa-shield"] = QString::fromWCharArray(L"\xF132");
      fontawesome_character_map["fa-calendar-o"] = QString::fromWCharArray(L"\xF133");
      fontawesome_character_map["fa-fire-extinguisher"] = QString::fromWCharArray(L"\xF134");
      fontawesome_character_map["fa-rocket"] = QString::fromWCharArray(L"\xF135");
      fontawesome_character_map["fa-maxcdn"] = QString::fromWCharArray(L"\xF136");
      fontawesome_character_map["fa-chevron-circle-left"] = QString::fromWCharArray(L"\xF137");
      fontawesome_character_map["fa-chevron-circle-right"] = QString::fromWCharArray(L"\xF138");
      fontawesome_character_map["fa-chevron-circle-up"] = QString::fromWCharArray(L"\xF139");
      fontawesome_character_map["fa-chevron-circle-down"] = QString::fromWCharArray(L"\xF13a");
      fontawesome_character_map["fa-html5"] = QString::fromWCharArray(L"\xF13b");
      fontawesome_character_map["fa-css3"] = QString::fromWCharArray(L"\xF13c");
      fontawesome_character_map["fa-anchor"] = QString::fromWCharArray(L"\xF13d");
      fontawesome_character_map["fa-unlock-alt"] = QString::fromWCharArray(L"\xF13e");
      fontawesome_character_map["fa-bullseye"] = QString::fromWCharArray(L"\xF140");
      fontawesome_character_map["fa-ellipsis-h"] = QString::fromWCharArray(L"\xF141");
      fontawesome_character_map["fa-ellipsis-v"] = QString::fromWCharArray(L"\xF142");
      fontawesome_character_map["fa-rss-square"] = QString::fromWCharArray(L"\xF143");
      fontawesome_character_map["fa-play-circle"] = QString::fromWCharArray(L"\xF144");
      fontawesome_character_map["fa-ticket"] = QString::fromWCharArray(L"\xF145");
      fontawesome_character_map["fa-minus-square"] = QString::fromWCharArray(L"\xF146");
      fontawesome_character_map["fa-minus-square-o"] = QString::fromWCharArray(L"\xF147");
      fontawesome_character_map["fa-level-up"] = QString::fromWCharArray(L"\xF148");
      fontawesome_character_map["fa-level-down"] = QString::fromWCharArray(L"\xF149");
      fontawesome_character_map["fa-check-square"] = QString::fromWCharArray(L"\xF14a");
      fontawesome_character_map["fa-pencil-square"] = QString::fromWCharArray(L"\xF14b");
      fontawesome_character_map["fa-external-link-square"] = QString::fromWCharArray(L"\xF14c");
      fontawesome_character_map["fa-share-square"] = QString::fromWCharArray(L"\xF14d");
      fontawesome_character_map["fa-compass"] = QString::fromWCharArray(L"\xF14e");
      fontawesome_character_map["fa-toggle-down"] = QString::fromWCharArray(L"\xF150");
      fontawesome_character_map["fa-caret-square-o-down"] = QString::fromWCharArray(L"\xF150");
      fontawesome_character_map["fa-toggle-up"] = QString::fromWCharArray(L"\xF151");
      fontawesome_character_map["fa-caret-square-o-up"] = QString::fromWCharArray(L"\xF151");
      fontawesome_character_map["fa-toggle-right"] = QString::fromWCharArray(L"\xF152");
      fontawesome_character_map["fa-caret-square-o-right"] = QString::fromWCharArray(L"\xF152");
      fontawesome_character_map["fa-euro"] = QString::fromWCharArray(L"\xF153");
      fontawesome_character_map["fa-eur"] = QString::fromWCharArray(L"\xF153");
      fontawesome_character_map["fa-gbp"] = QString::fromWCharArray(L"\xF154");
      fontawesome_character_map["fa-dollar"] = QString::fromWCharArray(L"\xF155");
      fontawesome_character_map["fa-usd"] = QString::fromWCharArray(L"\xF155");
      fontawesome_character_map["fa-rupee"] = QString::fromWCharArray(L"\xF156");
      fontawesome_character_map["fa-inr"] = QString::fromWCharArray(L"\xF156");
      fontawesome_character_map["fa-cny"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-rmb"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-yen"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-jpy"] = QString::fromWCharArray(L"\xF157");
      fontawesome_character_map["fa-ruble"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-rouble"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-rub"] = QString::fromWCharArray(L"\xF158");
      fontawesome_character_map["fa-won"] = QString::fromWCharArray(L"\xF159");
      fontawesome_character_map["fa-krw"] = QString::fromWCharArray(L"\xF159");
      fontawesome_character_map["fa-bitcoin"] = QString::fromWCharArray(L"\xF15a");
      fontawesome_character_map["fa-btc"] = QString::fromWCharArray(L"\xF15a");
      fontawesome_character_map["fa-file"] = QString::fromWCharArray(L"\xF15b");
      fontawesome_character_map["fa-file-text"] = QString::fromWCharArray(L"\xF15c");
      fontawesome_character_map["fa-sort-alpha-asc"] = QString::fromWCharArray(L"\xF15d");
      fontawesome_character_map["fa-sort-alpha-desc"] = QString::fromWCharArray(L"\xF15e");
      fontawesome_character_map["fa-sort-amount-asc"] = QString::fromWCharArray(L"\xF160");
      fontawesome_character_map["fa-sort-amount-desc"] = QString::fromWCharArray(L"\xF161");
      fontawesome_character_map["fa-sort-numeric-asc"] = QString::fromWCharArray(L"\xF162");
      fontawesome_character_map["fa-sort-numeric-desc"] = QString::fromWCharArray(L"\xF163");
      fontawesome_character_map["fa-thumbs-up"] = QString::fromWCharArray(L"\xF164");
      fontawesome_character_map["fa-thumbs-down"] = QString::fromWCharArray(L"\xF165");
      fontawesome_character_map["fa-youtube-square"] = QString::fromWCharArray(L"\xF166");
      fontawesome_character_map["fa-youtube"] = QString::fromWCharArray(L"\xF167");
      fontawesome_character_map["fa-xing"] = QString::fromWCharArray(L"\xF168");
      fontawesome_character_map["fa-xing-square"] = QString::fromWCharArray(L"\xF169");
      fontawesome_character_map["fa-youtube-play"] = QString::fromWCharArray(L"\xF16a");
      fontawesome_character_map["fa-dropbox"] = QString::fromWCharArray(L"\xF16b");
      fontawesome_character_map["fa-stack-overflow"] = QString::fromWCharArray(L"\xF16c");
      fontawesome_character_map["fa-instagram"] = QString::fromWCharArray(L"\xF16d");
      fontawesome_character_map["fa-flickr"] = QString::fromWCharArray(L"\xF16e");
      fontawesome_character_map["fa-adn"] = QString::fromWCharArray(L"\xF170");
      fontawesome_character_map["fa-bitbucket"] = QString::fromWCharArray(L"\xF171");
      fontawesome_character_map["fa-bitbucket-square"] = QString::fromWCharArray(L"\xF172");
      fontawesome_character_map["fa-tumblr"] = QString::fromWCharArray(L"\xF173");
      fontawesome_character_map["fa-tumblr-square"] = QString::fromWCharArray(L"\xF174");
      fontawesome_character_map["fa-long-arrow-down"] = QString::fromWCharArray(L"\xF175");
      fontawesome_character_map["fa-long-arrow-up"] = QString::fromWCharArray(L"\xF176");
      fontawesome_character_map["fa-long-arrow-left"] = QString::fromWCharArray(L"\xF177");
      fontawesome_character_map["fa-long-arrow-right"] = QString::fromWCharArray(L"\xF178");
      fontawesome_character_map["fa-apple"] = QString::fromWCharArray(L"\xF179");
      fontawesome_character_map["fa-windows"] = QString::fromWCharArray(L"\xF17a");
      fontawesome_character_map["fa-android"] = QString::fromWCharArray(L"\xF17b");
      fontawesome_character_map["fa-linux"] = QString::fromWCharArray(L"\xF17c");
      fontawesome_character_map["fa-dribbble"] = QString::fromWCharArray(L"\xF17d");
      fontawesome_character_map["fa-skype"] = QString::fromWCharArray(L"\xF17e");
      fontawesome_character_map["fa-foursquare"] = QString::fromWCharArray(L"\xF180");
      fontawesome_character_map["fa-trello"] = QString::fromWCharArray(L"\xF181");
      fontawesome_character_map["fa-female"] = QString::fromWCharArray(L"\xF182");
      fontawesome_character_map["fa-male"] = QString::fromWCharArray(L"\xF183");
      fontawesome_character_map["fa-gittip"] = QString::fromWCharArray(L"\xF184");
      fontawesome_character_map["fa-sun-o"] = QString::fromWCharArray(L"\xF185");
      fontawesome_character_map["fa-moon-o"] = QString::fromWCharArray(L"\xF186");
      fontawesome_character_map["fa-archive"] = QString::fromWCharArray(L"\xF187");
      fontawesome_character_map["fa-bug"] = QString::fromWCharArray(L"\xF188");
      fontawesome_character_map["fa-vk"] = QString::fromWCharArray(L"\xF189");
      fontawesome_character_map["fa-weibo"] = QString::fromWCharArray(L"\xF18a");
      fontawesome_character_map["fa-renren"] = QString::fromWCharArray(L"\xF18b");
      fontawesome_character_map["fa-pagelines"] = QString::fromWCharArray(L"\xF18c");
      fontawesome_character_map["fa-stack-exchange"] = QString::fromWCharArray(L"\xF18d");
      fontawesome_character_map["fa-arrow-circle-o-right"] = QString::fromWCharArray(L"\xF18e");
      fontawesome_character_map["fa-arrow-circle-o-left"] = QString::fromWCharArray(L"\xF190");
      fontawesome_character_map["fa-toggle-left"] = QString::fromWCharArray(L"\xF191");
      fontawesome_character_map["fa-caret-square-o-left"] = QString::fromWCharArray(L"\xF191");
      fontawesome_character_map["fa-dot-circle-o"] = QString::fromWCharArray(L"\xF192");
      fontawesome_character_map["fa-wheelchair"] = QString::fromWCharArray(L"\xF193");
      fontawesome_character_map["fa-vimeo-square"] = QString::fromWCharArray(L"\xF194");
      fontawesome_character_map["fa-turkish-lira"] = QString::fromWCharArray(L"\xF195");
      fontawesome_character_map["fa-try"] = QString::fromWCharArray(L"\xF195");
      fontawesome_character_map["fa-plus-square-o"] = QString::fromWCharArray(L"\xF196");
      fontawesome_character_map["fa-space-shuttle"] = QString::fromWCharArray(L"\xF197");
      fontawesome_character_map["fa-slack"] = QString::fromWCharArray(L"\xF198");
      fontawesome_character_map["fa-envelope-square"] = QString::fromWCharArray(L"\xF199");
      fontawesome_character_map["fa-wordpress"] = QString::fromWCharArray(L"\xF19a");
      fontawesome_character_map["fa-openid"] = QString::fromWCharArray(L"\xF19b");
      fontawesome_character_map["fa-institution"] = QString::fromWCharArray(L"\xF19c");
      fontawesome_character_map["fa-bank"] = QString::fromWCharArray(L"\xF19c");
      fontawesome_character_map["fa-university"] = QString::fromWCharArray(L"\xF19c");
      fontawesome_character_map["fa-mortar-board"] = QString::fromWCharArray(L"\xF19d");
      fontawesome_character_map["fa-graduation-cap"] = QString::fromWCharArray(L"\xF19d");
      fontawesome_character_map["fa-yahoo"] = QString::fromWCharArray(L"\xF19e");
      fontawesome_character_map["fa-google"] = QString::fromWCharArray(L"\xF1a0");
      fontawesome_character_map["fa-reddit"] = QString::fromWCharArray(L"\xF1a1");
      fontawesome_character_map["fa-reddit-square"] = QString::fromWCharArray(L"\xF1a2");
      fontawesome_character_map["fa-stumbleupon-circle"] = QString::fromWCharArray(L"\xF1a3");
      fontawesome_character_map["fa-stumbleupon"] = QString::fromWCharArray(L"\xF1a4");
      fontawesome_character_map["fa-delicious"] = QString::fromWCharArray(L"\xF1a5");
      fontawesome_character_map["fa-digg"] = QString::fromWCharArray(L"\xF1a6");
      fontawesome_character_map["fa-pied-piper"] = QString::fromWCharArray(L"\xF1a7");
      fontawesome_character_map["fa-pied-piper-alt"] = QString::fromWCharArray(L"\xF1a8");
      fontawesome_character_map["fa-drupal"] = QString::fromWCharArray(L"\xF1a9");
      fontawesome_character_map["fa-joomla"] = QString::fromWCharArray(L"\xF1aa");
      fontawesome_character_map["fa-language"] = QString::fromWCharArray(L"\xF1ab");
      fontawesome_character_map["fa-fax"] = QString::fromWCharArray(L"\xF1ac");
      fontawesome_character_map["fa-building"] = QString::fromWCharArray(L"\xF1ad");
      fontawesome_character_map["fa-child"] = QString::fromWCharArray(L"\xF1ae");
      fontawesome_character_map["fa-paw"] = QString::fromWCharArray(L"\xF1b0");
      fontawesome_character_map["fa-spoon"] = QString::fromWCharArray(L"\xF1b1");
      fontawesome_character_map["fa-cube"] = QString::fromWCharArray(L"\xF1b2");
      fontawesome_character_map["fa-cubes"] = QString::fromWCharArray(L"\xF1b3");
      fontawesome_character_map["fa-behance"] = QString::fromWCharArray(L"\xF1b4");
      fontawesome_character_map["fa-behance-square"] = QString::fromWCharArray(L"\xF1b5");
      fontawesome_character_map["fa-steam"] = QString::fromWCharArray(L"\xF1b6");
      fontawesome_character_map["fa-steam-square"] = QString::fromWCharArray(L"\xF1b7");
      fontawesome_character_map["fa-recycle"] = QString::fromWCharArray(L"\xF1b8");
      fontawesome_character_map["fa-automobile"] = QString::fromWCharArray(L"\xF1b9");
      fontawesome_character_map["fa-car"] = QString::fromWCharArray(L"\xF1b9");
      fontawesome_character_map["fa-cab"] = QString::fromWCharArray(L"\xF1ba");
      fontawesome_character_map["fa-taxi"] = QString::fromWCharArray(L"\xF1ba");
      fontawesome_character_map["fa-tree"] = QString::fromWCharArray(L"\xF1bb");
      fontawesome_character_map["fa-spotify"] = QString::fromWCharArray(L"\xF1bc");
      fontawesome_character_map["fa-deviantart"] = QString::fromWCharArray(L"\xF1bd");
      fontawesome_character_map["fa-soundcloud"] = QString::fromWCharArray(L"\xF1be");
      fontawesome_character_map["fa-database"] = QString::fromWCharArray(L"\xF1c0");
      fontawesome_character_map["fa-file-pdf-o"] = QString::fromWCharArray(L"\xF1c1");
      fontawesome_character_map["fa-file-word-o"] = QString::fromWCharArray(L"\xF1c2");
      fontawesome_character_map["fa-file-excel-o"] = QString::fromWCharArray(L"\xF1c3");
      fontawesome_character_map["fa-file-powerpoint-o"] = QString::fromWCharArray(L"\xF1c4");
      fontawesome_character_map["fa-file-photo-o"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-picture-o"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-image-o"] = QString::fromWCharArray(L"\xF1c5");
      fontawesome_character_map["fa-file-zip-o"] = QString::fromWCharArray(L"\xF1c6");
      fontawesome_character_map["fa-file-archive-o"] = QString::fromWCharArray(L"\xF1c6");
      fontawesome_character_map["fa-file-sound-o"] = QString::fromWCharArray(L"\xF1c7");
      fontawesome_character_map["fa-file-audio-o"] = QString::fromWCharArray(L"\xF1c7");
      fontawesome_character_map["fa-file-movie-o"] = QString::fromWCharArray(L"\xF1c8");
      fontawesome_character_map["fa-file-video-o"] = QString::fromWCharArray(L"\xF1c8");
      fontawesome_character_map["fa-file-code-o"] = QString::fromWCharArray(L"\xF1c9");
      fontawesome_character_map["fa-vine"] = QString::fromWCharArray(L"\xF1ca");
      fontawesome_character_map["fa-codepen"] = QString::fromWCharArray(L"\xF1cb");
      fontawesome_character_map["fa-jsfiddle"] = QString::fromWCharArray(L"\xF1cc");
      fontawesome_character_map["fa-life-bouy"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-life-buoy"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-life-saver"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-support"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-life-ring"] = QString::fromWCharArray(L"\xF1cd");
      fontawesome_character_map["fa-circle-o-notch"] = QString::fromWCharArray(L"\xF1ce");
      fontawesome_character_map["fa-ra"] = QString::fromWCharArray(L"\xF1d0");
      fontawesome_character_map["fa-rebel"] = QString::fromWCharArray(L"\xF1d0");
      fontawesome_character_map["fa-ge"] = QString::fromWCharArray(L"\xF1d1");
      fontawesome_character_map["fa-empire"] = QString::fromWCharArray(L"\xF1d1");
      fontawesome_character_map["fa-git-square"] = QString::fromWCharArray(L"\xF1d2");
      fontawesome_character_map["fa-git"] = QString::fromWCharArray(L"\xF1d3");
      fontawesome_character_map["fa-hacker-news"] = QString::fromWCharArray(L"\xF1d4");
      fontawesome_character_map["fa-tencent-weibo"] = QString::fromWCharArray(L"\xF1d5");
      fontawesome_character_map["fa-qq"] = QString::fromWCharArray(L"\xF1d6");
      fontawesome_character_map["fa-wechat"] = QString::fromWCharArray(L"\xF1d7");
      fontawesome_character_map["fa-weixin"] = QString::fromWCharArray(L"\xF1d7");
      fontawesome_character_map["fa-send"] = QString::fromWCharArray(L"\xF1d8");
      fontawesome_character_map["fa-paper-plane"] = QString::fromWCharArray(L"\xF1d8");
      fontawesome_character_map["fa-send-o"] = QString::fromWCharArray(L"\xF1d9");
      fontawesome_character_map["fa-paper-plane-o"] = QString::fromWCharArray(L"\xF1d9");
      fontawesome_character_map["fa-history"] = QString::fromWCharArray(L"\xF1da");
      fontawesome_character_map["fa-circle-thin"] = QString::fromWCharArray(L"\xF1db");
      fontawesome_character_map["fa-header"] = QString::fromWCharArray(L"\xF1dc");
      fontawesome_character_map["fa-paragraph"] = QString::fromWCharArray(L"\xF1dd");
      fontawesome_character_map["fa-sliders"] = QString::fromWCharArray(L"\xF1de");
      fontawesome_character_map["fa-share-alt"] = QString::fromWCharArray(L"\xF1e0");
      fontawesome_character_map["fa-share-alt-square"] = QString::fromWCharArray(L"\xF1e1");
      fontawesome_character_map["fa-bomb"] = QString::fromWCharArray(L"\xF1e2");
      fontawesome_character_map["fa-soccer-ball-o"] = QString::fromWCharArray(L"\xF1e3");
      fontawesome_character_map["fa-futbol-o"] = QString::fromWCharArray(L"\xF1e3");
      fontawesome_character_map["fa-tty"] = QString::fromWCharArray(L"\xF1e4");
      fontawesome_character_map["fa-binoculars"] = QString::fromWCharArray(L"\xF1e5");
      fontawesome_character_map["fa-plug"] = QString::fromWCharArray(L"\xF1e6");
      fontawesome_character_map["fa-slideshare"] = QString::fromWCharArray(L"\xF1e7");
      fontawesome_character_map["fa-twitch"] = QString::fromWCharArray(L"\xF1e8");
      fontawesome_character_map["fa-yelp"] = QString::fromWCharArray(L"\xF1e9");
      fontawesome_character_map["fa-newspaper-o"] = QString::fromWCharArray(L"\xF1ea");
      fontawesome_character_map["fa-wifi"] = QString::fromWCharArray(L"\xF1eb");
      fontawesome_character_map["fa-calculator"] = QString::fromWCharArray(L"\xF1ec");
      fontawesome_character_map["fa-paypal"] = QString::fromWCharArray(L"\xF1ed");
      fontawesome_character_map["fa-google-wallet"] = QString::fromWCharArray(L"\xF1ee");
      fontawesome_character_map["fa-cc-visa"] = QString::fromWCharArray(L"\xF1f0");
      fontawesome_character_map["fa-cc-mastercard"] = QString::fromWCharArray(L"\xF1f1");
      fontawesome_character_map["fa-cc-discover"] = QString::fromWCharArray(L"\xF1f2");
      fontawesome_character_map["fa-cc-amex"] = QString::fromWCharArray(L"\xF1f3");
      fontawesome_character_map["fa-cc-paypal"] = QString::fromWCharArray(L"\xF1f4");
      fontawesome_character_map["fa-cc-stripe"] = QString::fromWCharArray(L"\xF1f5");
      fontawesome_character_map["fa-bell-slash"] = QString::fromWCharArray(L"\xF1f6");
      fontawesome_character_map["fa-bell-slash-o"] = QString::fromWCharArray(L"\xF1f7");
      fontawesome_character_map["fa-trash"] = QString::fromWCharArray(L"\xF1f8");
      fontawesome_character_map["fa-copyright"] = QString::fromWCharArray(L"\xF1f9");
      fontawesome_character_map["fa-at"] = QString::fromWCharArray(L"\xF1fa");
      fontawesome_character_map["fa-eyedropper"] = QString::fromWCharArray(L"\xF1fb");
      fontawesome_character_map["fa-paint-brush"] = QString::fromWCharArray(L"\xF1fc");
      fontawesome_character_map["fa-birthday-cake"] = QString::fromWCharArray(L"\xF1fd");
      fontawesome_character_map["fa-area-chart"] = QString::fromWCharArray(L"\xF1fe");
      fontawesome_character_map["fa-pie-chart"] = QString::fromWCharArray(L"\xF200");
      fontawesome_character_map["fa-line-chart"] = QString::fromWCharArray(L"\xF201");
      fontawesome_character_map["fa-lastfm"] = QString::fromWCharArray(L"\xF202");
      fontawesome_character_map["fa-lastfm-square"] = QString::fromWCharArray(L"\xF203");
      fontawesome_character_map["fa-toggle-off"] = QString::fromWCharArray(L"\xF204");
      fontawesome_character_map["fa-toggle-on"] = QString::fromWCharArray(L"\xF205");
      fontawesome_character_map["fa-bicycle"] = QString::fromWCharArray(L"\xF206");
      fontawesome_character_map["fa-bus"] = QString::fromWCharArray(L"\xF207");
      fontawesome_character_map["fa-ioxhost"] = QString::fromWCharArray(L"\xF208");
      fontawesome_character_map["fa-angellist"] = QString::fromWCharArray(L"\xF209");
      fontawesome_character_map["fa-cc"] = QString::fromWCharArray(L"\xF20a");
      fontawesome_character_map["fa-shekel"] = QString::fromWCharArray(L"\xF20b");
      fontawesome_character_map["fa-sheqel"] = QString::fromWCharArray(L"\xF20b");
      fontawesome_character_map["fa-ils"] = QString::fromWCharArray(L"\xF20b");
      fontawesome_character_map["fa-meanpath"] = QString::fromWCharArray(L"\xF20c");
    }
  }
}
