/*
Open Asset Import Library (ASSIMP)
----------------------------------------------------------------------

Copyright (c) 2006-2010, ASSIMP Development Team
All rights reserved.

Redistribution and use of this software in source and binary forms, 
with or without modification, are permitted provided that the 
following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.

* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the
  following disclaimer in the documentation and/or other
  materials provided with the distribution.

* Neither the name of the ASSIMP team, nor the names of its
  contributors may be used to endorse or promote products
  derived from this software without specific prior
  written permission of the ASSIMP Development Team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/

/** MACHINE-GENERATED by scripts/ICFImporter/CppGenerator.py */

#ifndef INCLUDED_IFC_READER_GEN_H
#define INCLUDED_IFC_READER_GEN_H

#include "STEPFile.h"

namespace Assimp {
namespace IFC {
	using namespace STEP;
	using namespace STEP::EXPRESS;
	
	
	struct NotImplemented : public ObjectHelper<NotImplemented,0> {
		
	};
	

	// ******************************************************************************
	// IFC Custom data types
	// ******************************************************************************


    // C++ wrapper type for IfcSoundPowerMeasure
    typedef REAL IfcSoundPowerMeasure;
    // C++ wrapper type for IfcDoorStyleOperationEnum
    typedef ENUMERATION IfcDoorStyleOperationEnum;
    // C++ wrapper type for IfcRotationalFrequencyMeasure
    typedef REAL IfcRotationalFrequencyMeasure;
    // C++ wrapper type for IfcCharacterStyleSelect
    typedef SELECT IfcCharacterStyleSelect;
    // C++ wrapper type for IfcElectricTimeControlTypeEnum
    typedef ENUMERATION IfcElectricTimeControlTypeEnum;
    // C++ wrapper type for IfcAirTerminalTypeEnum
    typedef ENUMERATION IfcAirTerminalTypeEnum;
    // C++ wrapper type for IfcProjectOrderTypeEnum
    typedef ENUMERATION IfcProjectOrderTypeEnum;
    // C++ wrapper type for IfcSequenceEnum
    typedef ENUMERATION IfcSequenceEnum;
    // C++ wrapper type for IfcSpecificHeatCapacityMeasure
    typedef REAL IfcSpecificHeatCapacityMeasure;
    // C++ wrapper type for IfcHeatingValueMeasure
    typedef REAL IfcHeatingValueMeasure;
    // C++ wrapper type for IfcRibPlateDirectionEnum
    typedef ENUMERATION IfcRibPlateDirectionEnum;
    // C++ wrapper type for IfcSensorTypeEnum
    typedef ENUMERATION IfcSensorTypeEnum;
    // C++ wrapper type for IfcElectricHeaterTypeEnum
    typedef ENUMERATION IfcElectricHeaterTypeEnum;
    // C++ wrapper type for IfcObjectiveEnum
    typedef ENUMERATION IfcObjectiveEnum;
    // C++ wrapper type for IfcTextStyleSelect
    typedef SELECT IfcTextStyleSelect;
    // C++ wrapper type for IfcColumnTypeEnum
    typedef ENUMERATION IfcColumnTypeEnum;
    // C++ wrapper type for IfcGasTerminalTypeEnum
    typedef ENUMERATION IfcGasTerminalTypeEnum;
    // C++ wrapper type for IfcMassDensityMeasure
    typedef REAL IfcMassDensityMeasure;
    // C++ wrapper type for IfcSimpleValue
    typedef SELECT IfcSimpleValue;
    // C++ wrapper type for IfcElectricConductanceMeasure
    typedef REAL IfcElectricConductanceMeasure;
    // C++ wrapper type for IfcBuildingElementProxyTypeEnum
    typedef ENUMERATION IfcBuildingElementProxyTypeEnum;
    // C++ wrapper type for IfcJunctionBoxTypeEnum
    typedef ENUMERATION IfcJunctionBoxTypeEnum;
    // C++ wrapper type for IfcModulusOfElasticityMeasure
    typedef REAL IfcModulusOfElasticityMeasure;
    // C++ wrapper type for IfcActionSourceTypeEnum
    typedef ENUMERATION IfcActionSourceTypeEnum;
    // C++ wrapper type for IfcSIUnitName
    typedef ENUMERATION IfcSIUnitName;
    // C++ wrapper type for IfcRotationalMassMeasure
    typedef REAL IfcRotationalMassMeasure;
    // C++ wrapper type for IfcMemberTypeEnum
    typedef ENUMERATION IfcMemberTypeEnum;
    // C++ wrapper type for IfcTextDecoration
    typedef STRING IfcTextDecoration;
    // C++ wrapper type for IfcPositiveLengthMeasure
    typedef REAL IfcPositiveLengthMeasure;
    // C++ wrapper type for IfcAmountOfSubstanceMeasure
    typedef REAL IfcAmountOfSubstanceMeasure;
    // C++ wrapper type for IfcDoorStyleConstructionEnum
    typedef ENUMERATION IfcDoorStyleConstructionEnum;
    // C++ wrapper type for IfcAngularVelocityMeasure
    typedef REAL IfcAngularVelocityMeasure;
    // C++ wrapper type for IfcDirectionSenseEnum
    typedef ENUMERATION IfcDirectionSenseEnum;
    // C++ wrapper type for IfcNullStyle
    typedef ENUMERATION IfcNullStyle;
    // C++ wrapper type for IfcMonthInYearNumber
    typedef INTEGER IfcMonthInYearNumber;
    // C++ wrapper type for IfcRampFlightTypeEnum
    typedef ENUMERATION IfcRampFlightTypeEnum;
    // C++ wrapper type for IfcWindowStyleOperationEnum
    typedef ENUMERATION IfcWindowStyleOperationEnum;
    // C++ wrapper type for IfcCurvatureMeasure
    typedef REAL IfcCurvatureMeasure;
    // C++ wrapper type for IfcBooleanOperator
    typedef ENUMERATION IfcBooleanOperator;
    // C++ wrapper type for IfcDuctFittingTypeEnum
    typedef ENUMERATION IfcDuctFittingTypeEnum;
    // C++ wrapper type for IfcCurrencyEnum
    typedef ENUMERATION IfcCurrencyEnum;
    // C++ wrapper type for IfcObjectTypeEnum
    typedef ENUMERATION IfcObjectTypeEnum;
    // C++ wrapper type for IfcThermalLoadTypeEnum
    typedef ENUMERATION IfcThermalLoadTypeEnum;
    // C++ wrapper type for IfcIonConcentrationMeasure
    typedef REAL IfcIonConcentrationMeasure;
    // C++ wrapper type for IfcClassificationNotationSelect
    typedef SELECT IfcClassificationNotationSelect;
    // C++ wrapper type for IfcBSplineCurveForm
    typedef ENUMERATION IfcBSplineCurveForm;
    // C++ wrapper type for IfcElementCompositionEnum
    typedef ENUMERATION IfcElementCompositionEnum;
    // C++ wrapper type for IfcDraughtingCalloutElement
    typedef SELECT IfcDraughtingCalloutElement;
    // C++ wrapper type for IfcFillStyleSelect
    typedef SELECT IfcFillStyleSelect;
    // C++ wrapper type for IfcHeatFluxDensityMeasure
    typedef REAL IfcHeatFluxDensityMeasure;
    // C++ wrapper type for IfcGeometricProjectionEnum
    typedef ENUMERATION IfcGeometricProjectionEnum;
    // C++ wrapper type for IfcFontVariant
    typedef STRING IfcFontVariant;
    // C++ wrapper type for IfcThermalResistanceMeasure
    typedef REAL IfcThermalResistanceMeasure;
    // C++ wrapper type for IfcReflectanceMethodEnum
    typedef ENUMERATION IfcReflectanceMethodEnum;
    // C++ wrapper type for IfcSlabTypeEnum
    typedef ENUMERATION IfcSlabTypeEnum;
    // C++ wrapper type for IfcPositiveRatioMeasure
    typedef REAL IfcPositiveRatioMeasure;
    // C++ wrapper type for IfcInternalOrExternalEnum
    typedef ENUMERATION IfcInternalOrExternalEnum;
    // C++ wrapper type for IfcDimensionExtentUsage
    typedef ENUMERATION IfcDimensionExtentUsage;
    // C++ wrapper type for IfcPipeFittingTypeEnum
    typedef ENUMERATION IfcPipeFittingTypeEnum;
    // C++ wrapper type for IfcSanitaryTerminalTypeEnum
    typedef ENUMERATION IfcSanitaryTerminalTypeEnum;
    // C++ wrapper type for IfcMinuteInHour
    typedef INTEGER IfcMinuteInHour;
    // C++ wrapper type for IfcWallTypeEnum
    typedef ENUMERATION IfcWallTypeEnum;
    // C++ wrapper type for IfcMolecularWeightMeasure
    typedef REAL IfcMolecularWeightMeasure;
    // C++ wrapper type for IfcUnitaryEquipmentTypeEnum
    typedef ENUMERATION IfcUnitaryEquipmentTypeEnum;
    // C++ wrapper type for IfcProcedureTypeEnum
    typedef ENUMERATION IfcProcedureTypeEnum;
    // C++ wrapper type for IfcDistributionChamberElementTypeEnum
    typedef ENUMERATION IfcDistributionChamberElementTypeEnum;
    // C++ wrapper type for IfcTextPath
    typedef ENUMERATION IfcTextPath;
    // C++ wrapper type for IfcCostScheduleTypeEnum
    typedef ENUMERATION IfcCostScheduleTypeEnum;
    // C++ wrapper type for IfcShell
    typedef SELECT IfcShell;
    // C++ wrapper type for IfcLinearMomentMeasure
    typedef REAL IfcLinearMomentMeasure;
    // C++ wrapper type for IfcElectricCurrentMeasure
    typedef REAL IfcElectricCurrentMeasure;
    // C++ wrapper type for IfcDaylightSavingHour
    typedef INTEGER IfcDaylightSavingHour;
    // C++ wrapper type for IfcNormalisedRatioMeasure
    typedef REAL IfcNormalisedRatioMeasure;
    // C++ wrapper type for IfcFanTypeEnum
    typedef ENUMERATION IfcFanTypeEnum;
    // C++ wrapper type for IfcContextDependentMeasure
    typedef REAL IfcContextDependentMeasure;
    // C++ wrapper type for IfcAheadOrBehind
    typedef ENUMERATION IfcAheadOrBehind;
    // C++ wrapper type for IfcFontStyle
    typedef STRING IfcFontStyle;
    // C++ wrapper type for IfcCooledBeamTypeEnum
    typedef ENUMERATION IfcCooledBeamTypeEnum;
    // C++ wrapper type for IfcSurfaceStyleElementSelect
    typedef SELECT IfcSurfaceStyleElementSelect;
    // C++ wrapper type for IfcYearNumber
    typedef INTEGER IfcYearNumber;
    // C++ wrapper type for IfcLabel
    typedef STRING IfcLabel;
    // C++ wrapper type for IfcTimeStamp
    typedef INTEGER IfcTimeStamp;
    // C++ wrapper type for IfcFireSuppressionTerminalTypeEnum
    typedef ENUMERATION IfcFireSuppressionTerminalTypeEnum;
    // C++ wrapper type for IfcDocumentConfidentialityEnum
    typedef ENUMERATION IfcDocumentConfidentialityEnum;
    // C++ wrapper type for IfcColourOrFactor
    typedef SELECT IfcColourOrFactor;
    // C++ wrapper type for IfcAirTerminalBoxTypeEnum
    typedef ENUMERATION IfcAirTerminalBoxTypeEnum;
    // C++ wrapper type for IfcNumericMeasure
    typedef NUMBER IfcNumericMeasure;
    // C++ wrapper type for IfcDerivedUnitEnum
    typedef ENUMERATION IfcDerivedUnitEnum;
    // C++ wrapper type for IfcCurveOrEdgeCurve
    typedef SELECT IfcCurveOrEdgeCurve;
    // C++ wrapper type for IfcLightEmissionSourceEnum
    typedef ENUMERATION IfcLightEmissionSourceEnum;
    // C++ wrapper type for IfcKinematicViscosityMeasure
    typedef REAL IfcKinematicViscosityMeasure;
    // C++ wrapper type for IfcBoxAlignment
    typedef STRING IfcBoxAlignment;
    // C++ wrapper type for IfcDocumentSelect
    typedef SELECT IfcDocumentSelect;
    // C++ wrapper type for IfcCableCarrierFittingTypeEnum
    typedef ENUMERATION IfcCableCarrierFittingTypeEnum;
    // C++ wrapper type for IfcPumpTypeEnum
    typedef ENUMERATION IfcPumpTypeEnum;
    // C++ wrapper type for IfcHourInDay
    typedef INTEGER IfcHourInDay;
    // C++ wrapper type for IfcProjectOrderRecordTypeEnum
    typedef ENUMERATION IfcProjectOrderRecordTypeEnum;
    // C++ wrapper type for IfcWindowStyleConstructionEnum
    typedef ENUMERATION IfcWindowStyleConstructionEnum;
    // C++ wrapper type for IfcPresentationStyleSelect
    typedef SELECT IfcPresentationStyleSelect;
    // C++ wrapper type for IfcCableSegmentTypeEnum
    typedef ENUMERATION IfcCableSegmentTypeEnum;
    // C++ wrapper type for IfcWasteTerminalTypeEnum
    typedef ENUMERATION IfcWasteTerminalTypeEnum;
    // C++ wrapper type for IfcIsothermalMoistureCapacityMeasure
    typedef REAL IfcIsothermalMoistureCapacityMeasure;
    // C++ wrapper type for IfcIdentifier
    typedef STRING IfcIdentifier;
    // C++ wrapper type for IfcRadioActivityMeasure
    typedef REAL IfcRadioActivityMeasure;
    // C++ wrapper type for IfcSymbolStyleSelect
    typedef SELECT IfcSymbolStyleSelect;
    // C++ wrapper type for IfcObjectReferenceSelect
    typedef SELECT IfcObjectReferenceSelect;
    // C++ wrapper type for IfcRoofTypeEnum
    typedef ENUMERATION IfcRoofTypeEnum;
    // C++ wrapper type for IfcReal
    typedef REAL IfcReal;
    // C++ wrapper type for IfcRoleEnum
    typedef ENUMERATION IfcRoleEnum;
    // C++ wrapper type for IfcMeasureValue
    typedef SELECT IfcMeasureValue;
    // C++ wrapper type for IfcPileTypeEnum
    typedef ENUMERATION IfcPileTypeEnum;
    // C++ wrapper type for IfcElectricCurrentEnum
    typedef ENUMERATION IfcElectricCurrentEnum;
    // C++ wrapper type for IfcTextTransformation
    typedef STRING IfcTextTransformation;
    // C++ wrapper type for IfcFilterTypeEnum
    typedef ENUMERATION IfcFilterTypeEnum;
    // C++ wrapper type for IfcTransformerTypeEnum
    typedef ENUMERATION IfcTransformerTypeEnum;
    // C++ wrapper type for IfcSurfaceSide
    typedef ENUMERATION IfcSurfaceSide;
    // C++ wrapper type for IfcSpaceHeaterTypeEnum
    typedef ENUMERATION IfcSpaceHeaterTypeEnum;
    // C++ wrapper type for IfcThermalTransmittanceMeasure
    typedef REAL IfcThermalTransmittanceMeasure;
    // C++ wrapper type for IfcTubeBundleTypeEnum
    typedef ENUMERATION IfcTubeBundleTypeEnum;
    // C++ wrapper type for IfcLightFixtureTypeEnum
    typedef ENUMERATION IfcLightFixtureTypeEnum;
    // C++ wrapper type for IfcInductanceMeasure
    typedef REAL IfcInductanceMeasure;
    // C++ wrapper type for IfcGlobalOrLocalEnum
    typedef ENUMERATION IfcGlobalOrLocalEnum;
    // C++ wrapper type for IfcOutletTypeEnum
    typedef ENUMERATION IfcOutletTypeEnum;
    // C++ wrapper type for IfcWorkControlTypeEnum
    typedef ENUMERATION IfcWorkControlTypeEnum;
    // C++ wrapper type for IfcWarpingMomentMeasure
    typedef REAL IfcWarpingMomentMeasure;
    // C++ wrapper type for IfcDynamicViscosityMeasure
    typedef REAL IfcDynamicViscosityMeasure;
    // C++ wrapper type for IfcEnergySequenceEnum
    typedef ENUMERATION IfcEnergySequenceEnum;
    // C++ wrapper type for IfcFillAreaStyleTileShapeSelect
    typedef SELECT IfcFillAreaStyleTileShapeSelect;
    // C++ wrapper type for IfcPointOrVertexPoint
    typedef SELECT IfcPointOrVertexPoint;
    // C++ wrapper type for IfcVibrationIsolatorTypeEnum
    typedef ENUMERATION IfcVibrationIsolatorTypeEnum;
    // C++ wrapper type for IfcTankTypeEnum
    typedef ENUMERATION IfcTankTypeEnum;
    // C++ wrapper type for IfcTimeSeriesDataTypeEnum
    typedef ENUMERATION IfcTimeSeriesDataTypeEnum;
    // C++ wrapper type for IfcSurfaceTextureEnum
    typedef ENUMERATION IfcSurfaceTextureEnum;
    // C++ wrapper type for IfcAddressTypeEnum
    typedef ENUMERATION IfcAddressTypeEnum;
    // C++ wrapper type for IfcChillerTypeEnum
    typedef ENUMERATION IfcChillerTypeEnum;
    // C++ wrapper type for IfcLightDistributionCurveEnum
    typedef ENUMERATION IfcLightDistributionCurveEnum;
    // C++ wrapper type for IfcReinforcingBarRoleEnum
    typedef ENUMERATION IfcReinforcingBarRoleEnum;
    // C++ wrapper type for IfcResourceConsumptionEnum
    typedef ENUMERATION IfcResourceConsumptionEnum;
    // C++ wrapper type for IfcCsgSelect
    typedef SELECT IfcCsgSelect;
    // C++ wrapper type for IfcModulusOfLinearSubgradeReactionMeasure
    typedef REAL IfcModulusOfLinearSubgradeReactionMeasure;
    // C++ wrapper type for IfcEvaporatorTypeEnum
    typedef ENUMERATION IfcEvaporatorTypeEnum;
    // C++ wrapper type for IfcTimeSeriesScheduleTypeEnum
    typedef ENUMERATION IfcTimeSeriesScheduleTypeEnum;
    // C++ wrapper type for IfcDayInMonthNumber
    typedef INTEGER IfcDayInMonthNumber;
    // C++ wrapper type for IfcElectricMotorTypeEnum
    typedef ENUMERATION IfcElectricMotorTypeEnum;
    // C++ wrapper type for IfcThermalConductivityMeasure
    typedef REAL IfcThermalConductivityMeasure;
    // C++ wrapper type for IfcEnergyMeasure
    typedef REAL IfcEnergyMeasure;
    // C++ wrapper type for IfcRotationalStiffnessMeasure
    typedef REAL IfcRotationalStiffnessMeasure;
    // C++ wrapper type for IfcDerivedMeasureValue
    typedef SELECT IfcDerivedMeasureValue;
    // C++ wrapper type for IfcDoorPanelOperationEnum
    typedef ENUMERATION IfcDoorPanelOperationEnum;
    // C++ wrapper type for IfcCurveStyleFontSelect
    typedef SELECT IfcCurveStyleFontSelect;
    // C++ wrapper type for IfcWindowPanelOperationEnum
    typedef ENUMERATION IfcWindowPanelOperationEnum;
    // C++ wrapper type for IfcDataOriginEnum
    typedef ENUMERATION IfcDataOriginEnum;
    // C++ wrapper type for IfcStairTypeEnum
    typedef ENUMERATION IfcStairTypeEnum;
    // C++ wrapper type for IfcRailingTypeEnum
    typedef ENUMERATION IfcRailingTypeEnum;
    // C++ wrapper type for IfcPowerMeasure
    typedef REAL IfcPowerMeasure;
    // C++ wrapper type for IfcStackTerminalTypeEnum
    typedef ENUMERATION IfcStackTerminalTypeEnum;
    // C++ wrapper type for IfcHatchLineDistanceSelect
    typedef SELECT IfcHatchLineDistanceSelect;
    // C++ wrapper type for IfcTrimmingSelect
    typedef SELECT IfcTrimmingSelect;
    // C++ wrapper type for IfcThermalExpansionCoefficientMeasure
    typedef REAL IfcThermalExpansionCoefficientMeasure;
    // C++ wrapper type for IfcLightDistributionDataSourceSelect
    typedef SELECT IfcLightDistributionDataSourceSelect;
    // C++ wrapper type for IfcTorqueMeasure
    typedef REAL IfcTorqueMeasure;
    // C++ wrapper type for IfcMassPerLengthMeasure
    typedef REAL IfcMassPerLengthMeasure;
    // C++ wrapper type for IfcValveTypeEnum
    typedef ENUMERATION IfcValveTypeEnum;
    // C++ wrapper type for IfcWindowPanelPositionEnum
    typedef ENUMERATION IfcWindowPanelPositionEnum;
    // C++ wrapper type for IfcSurfaceOrFaceSurface
    typedef SELECT IfcSurfaceOrFaceSurface;
    // C++ wrapper type for IfcPropertySourceEnum
    typedef ENUMERATION IfcPropertySourceEnum;
    // C++ wrapper type for IfcCableCarrierSegmentTypeEnum
    typedef ENUMERATION IfcCableCarrierSegmentTypeEnum;
    // C++ wrapper type for IfcCountMeasure
    typedef NUMBER IfcCountMeasure;
    // C++ wrapper type for IfcFontWeight
    typedef STRING IfcFontWeight;
    // C++ wrapper type for IfcPhysicalOrVirtualEnum
    typedef ENUMERATION IfcPhysicalOrVirtualEnum;
    // C++ wrapper type for IfcSpaceTypeEnum
    typedef ENUMERATION IfcSpaceTypeEnum;
    // C++ wrapper type for IfcVolumetricFlowRateMeasure
    typedef REAL IfcVolumetricFlowRateMeasure;
    // C++ wrapper type for IfcLuminousFluxMeasure
    typedef REAL IfcLuminousFluxMeasure;
    // C++ wrapper type for IfcEvaporativeCoolerTypeEnum
    typedef ENUMERATION IfcEvaporativeCoolerTypeEnum;
    // C++ wrapper type for IfcLayeredItem
    typedef SELECT IfcLayeredItem;
    // C++ wrapper type for IfcModulusOfSubgradeReactionMeasure
    typedef REAL IfcModulusOfSubgradeReactionMeasure;
    // C++ wrapper type for IfcHeatExchangerTypeEnum
    typedef ENUMERATION IfcHeatExchangerTypeEnum;
    // C++ wrapper type for IfcProtectiveDeviceTypeEnum
    typedef ENUMERATION IfcProtectiveDeviceTypeEnum;
    // C++ wrapper type for IfcDamperTypeEnum
    typedef ENUMERATION IfcDamperTypeEnum;
    // C++ wrapper type for IfcControllerTypeEnum
    typedef ENUMERATION IfcControllerTypeEnum;
    // C++ wrapper type for IfcMassFlowRateMeasure
    typedef REAL IfcMassFlowRateMeasure;
    // C++ wrapper type for IfcAssemblyPlaceEnum
    typedef ENUMERATION IfcAssemblyPlaceEnum;
    // C++ wrapper type for IfcAreaMeasure
    typedef REAL IfcAreaMeasure;
    // C++ wrapper type for IfcServiceLifeFactorTypeEnum
    typedef ENUMERATION IfcServiceLifeFactorTypeEnum;
    // C++ wrapper type for IfcVolumeMeasure
    typedef REAL IfcVolumeMeasure;
    // C++ wrapper type for IfcBeamTypeEnum
    typedef ENUMERATION IfcBeamTypeEnum;
    // C++ wrapper type for IfcStateEnum
    typedef ENUMERATION IfcStateEnum;
    // C++ wrapper type for IfcSectionTypeEnum
    typedef ENUMERATION IfcSectionTypeEnum;
    // C++ wrapper type for IfcFootingTypeEnum
    typedef ENUMERATION IfcFootingTypeEnum;
    // C++ wrapper type for IfcMonetaryMeasure
    typedef REAL IfcMonetaryMeasure;
    // C++ wrapper type for IfcLoadGroupTypeEnum
    typedef ENUMERATION IfcLoadGroupTypeEnum;
    // C++ wrapper type for IfcElectricGeneratorTypeEnum
    typedef ENUMERATION IfcElectricGeneratorTypeEnum;
    // C++ wrapper type for IfcFlowMeterTypeEnum
    typedef ENUMERATION IfcFlowMeterTypeEnum;
    // C++ wrapper type for IfcMaterialSelect
    typedef SELECT IfcMaterialSelect;
    // C++ wrapper type for IfcAnalysisModelTypeEnum
    typedef ENUMERATION IfcAnalysisModelTypeEnum;
    // C++ wrapper type for IfcTemperatureGradientMeasure
    typedef REAL IfcTemperatureGradientMeasure;
    // C++ wrapper type for IfcModulusOfRotationalSubgradeReactionMeasure
    typedef REAL IfcModulusOfRotationalSubgradeReactionMeasure;
    // C++ wrapper type for IfcColour
    typedef SELECT IfcColour;
    // C++ wrapper type for IfcCurtainWallTypeEnum
    typedef ENUMERATION IfcCurtainWallTypeEnum;
    // C++ wrapper type for IfcMetricValueSelect
    typedef SELECT IfcMetricValueSelect;
    // C++ wrapper type for IfcTextAlignment
    typedef STRING IfcTextAlignment;
    // C++ wrapper type for IfcDoorPanelPositionEnum
    typedef ENUMERATION IfcDoorPanelPositionEnum;
    // C++ wrapper type for IfcPlateTypeEnum
    typedef ENUMERATION IfcPlateTypeEnum;
    // C++ wrapper type for IfcSectionalAreaIntegralMeasure
    typedef REAL IfcSectionalAreaIntegralMeasure;
    // C++ wrapper type for IfcPresentableText
    typedef STRING IfcPresentableText;
    // C++ wrapper type for IfcVaporPermeabilityMeasure
    typedef REAL IfcVaporPermeabilityMeasure;
    // C++ wrapper type for IfcStructuralSurfaceTypeEnum
    typedef ENUMERATION IfcStructuralSurfaceTypeEnum;
    // C++ wrapper type for IfcLinearVelocityMeasure
    typedef REAL IfcLinearVelocityMeasure;
    // C++ wrapper type for IfcIntegerCountRateMeasure
    typedef INTEGER IfcIntegerCountRateMeasure;
    // C++ wrapper type for IfcAirToAirHeatRecoveryTypeEnum
    typedef ENUMERATION IfcAirToAirHeatRecoveryTypeEnum;
    // C++ wrapper type for IfcDocumentStatusEnum
    typedef ENUMERATION IfcDocumentStatusEnum;
    // C++ wrapper type for IfcLengthMeasure
    typedef REAL IfcLengthMeasure;
    // C++ wrapper type for IfcPlanarForceMeasure
    typedef REAL IfcPlanarForceMeasure;
    // C++ wrapper type for IfcBooleanOperand
    typedef SELECT IfcBooleanOperand;
    // C++ wrapper type for IfcInteger
    typedef INTEGER IfcInteger;
    // C++ wrapper type for IfcRampTypeEnum
    typedef ENUMERATION IfcRampTypeEnum;
    // C++ wrapper type for IfcActorSelect
    typedef SELECT IfcActorSelect;
    // C++ wrapper type for IfcElectricChargeMeasure
    typedef REAL IfcElectricChargeMeasure;
    // C++ wrapper type for IfcGeometricSetSelect
    typedef SELECT IfcGeometricSetSelect;
    // C++ wrapper type for IfcConnectionTypeEnum
    typedef ENUMERATION IfcConnectionTypeEnum;
    // C++ wrapper type for IfcValue
    typedef SELECT IfcValue;
    // C++ wrapper type for IfcCoolingTowerTypeEnum
    typedef ENUMERATION IfcCoolingTowerTypeEnum;
    // C++ wrapper type for IfcPlaneAngleMeasure
    typedef REAL IfcPlaneAngleMeasure;
    // C++ wrapper type for IfcSwitchingDeviceTypeEnum
    typedef ENUMERATION IfcSwitchingDeviceTypeEnum;
    // C++ wrapper type for IfcFlowDirectionEnum
    typedef ENUMERATION IfcFlowDirectionEnum;
    // C++ wrapper type for IfcThermalLoadSourceEnum
    typedef ENUMERATION IfcThermalLoadSourceEnum;
    // C++ wrapper type for IfcTextFontSelect
    typedef SELECT IfcTextFontSelect;
    // C++ wrapper type for IfcSpecularHighlightSelect
    typedef SELECT IfcSpecularHighlightSelect;
    // C++ wrapper type for IfcAnalysisTheoryTypeEnum
    typedef ENUMERATION IfcAnalysisTheoryTypeEnum;
    // C++ wrapper type for IfcTextFontName
    typedef STRING IfcTextFontName;
    // C++ wrapper type for IfcElectricVoltageMeasure
    typedef REAL IfcElectricVoltageMeasure;
    // C++ wrapper type for IfcTendonTypeEnum
    typedef ENUMERATION IfcTendonTypeEnum;
    // C++ wrapper type for IfcSoundPressureMeasure
    typedef REAL IfcSoundPressureMeasure;
    // C++ wrapper type for IfcElectricDistributionPointFunctionEnum
    typedef ENUMERATION IfcElectricDistributionPointFunctionEnum;
    // C++ wrapper type for IfcSpecularRoughness
    typedef REAL IfcSpecularRoughness;
    // C++ wrapper type for IfcActionTypeEnum
    typedef ENUMERATION IfcActionTypeEnum;
    // C++ wrapper type for IfcReinforcingBarSurfaceEnum
    typedef ENUMERATION IfcReinforcingBarSurfaceEnum;
    // C++ wrapper type for IfcHumidifierTypeEnum
    typedef ENUMERATION IfcHumidifierTypeEnum;
    // C++ wrapper type for IfcIlluminanceMeasure
    typedef REAL IfcIlluminanceMeasure;
    // C++ wrapper type for IfcLibrarySelect
    typedef SELECT IfcLibrarySelect;
    // C++ wrapper type for IfcText
    typedef STRING IfcText;
    // C++ wrapper type for IfcLayerSetDirectionEnum
    typedef ENUMERATION IfcLayerSetDirectionEnum;
    // C++ wrapper type for IfcBoilerTypeEnum
    typedef ENUMERATION IfcBoilerTypeEnum;
    // C++ wrapper type for IfcTimeMeasure
    typedef REAL IfcTimeMeasure;
    // C++ wrapper type for IfcAccelerationMeasure
    typedef REAL IfcAccelerationMeasure;
    // C++ wrapper type for IfcElectricFlowStorageDeviceTypeEnum
    typedef ENUMERATION IfcElectricFlowStorageDeviceTypeEnum;
    // C++ wrapper type for IfcLuminousIntensityMeasure
    typedef REAL IfcLuminousIntensityMeasure;
    // C++ wrapper type for IfcDefinedSymbolSelect
    typedef SELECT IfcDefinedSymbolSelect;
    // C++ wrapper type for IfcUnitEnum
    typedef ENUMERATION IfcUnitEnum;
    // C++ wrapper type for IfcInventoryTypeEnum
    typedef ENUMERATION IfcInventoryTypeEnum;
    // C++ wrapper type for IfcStructuralActivityAssignmentSelect
    typedef SELECT IfcStructuralActivityAssignmentSelect;
    // C++ wrapper type for IfcElementAssemblyTypeEnum
    typedef ENUMERATION IfcElementAssemblyTypeEnum;
    // C++ wrapper type for IfcServiceLifeTypeEnum
    typedef ENUMERATION IfcServiceLifeTypeEnum;
    // C++ wrapper type for IfcCoveringTypeEnum
    typedef ENUMERATION IfcCoveringTypeEnum;
    // C++ wrapper type for IfcStairFlightTypeEnum
    typedef ENUMERATION IfcStairFlightTypeEnum;
    // C++ wrapper type for IfcSIPrefix
    typedef ENUMERATION IfcSIPrefix;
    // C++ wrapper type for IfcElectricCapacitanceMeasure
    typedef REAL IfcElectricCapacitanceMeasure;
    // C++ wrapper type for IfcFlowInstrumentTypeEnum
    typedef ENUMERATION IfcFlowInstrumentTypeEnum;
    // C++ wrapper type for IfcThermodynamicTemperatureMeasure
    typedef REAL IfcThermodynamicTemperatureMeasure;
    // C++ wrapper type for IfcGloballyUniqueId
    typedef STRING IfcGloballyUniqueId;
    // C++ wrapper type for IfcLampTypeEnum
    typedef ENUMERATION IfcLampTypeEnum;
    // C++ wrapper type for IfcMagneticFluxMeasure
    typedef REAL IfcMagneticFluxMeasure;
    // C++ wrapper type for IfcSolidAngleMeasure
    typedef REAL IfcSolidAngleMeasure;
    // C++ wrapper type for IfcFrequencyMeasure
    typedef REAL IfcFrequencyMeasure;
    // C++ wrapper type for IfcTransportElementTypeEnum
    typedef ENUMERATION IfcTransportElementTypeEnum;
    // C++ wrapper type for IfcSoundScaleEnum
    typedef ENUMERATION IfcSoundScaleEnum;
    // C++ wrapper type for IfcPHMeasure
    typedef REAL IfcPHMeasure;
    // C++ wrapper type for IfcActuatorTypeEnum
    typedef ENUMERATION IfcActuatorTypeEnum;
    // C++ wrapper type for IfcPositivePlaneAngleMeasure
    typedef REAL IfcPositivePlaneAngleMeasure;
    // C++ wrapper type for IfcAppliedValueSelect
    typedef SELECT IfcAppliedValueSelect;
    // C++ wrapper type for IfcSecondInMinute
    typedef REAL IfcSecondInMinute;
    // C++ wrapper type for IfcDuctSegmentTypeEnum
    typedef ENUMERATION IfcDuctSegmentTypeEnum;
    // C++ wrapper type for IfcThermalAdmittanceMeasure
    typedef REAL IfcThermalAdmittanceMeasure;
    // C++ wrapper type for IfcSpecularExponent
    typedef REAL IfcSpecularExponent;
    // C++ wrapper type for IfcDateTimeSelect
    typedef SELECT IfcDateTimeSelect;
    // C++ wrapper type for IfcTransitionCode
    typedef ENUMERATION IfcTransitionCode;
    // C++ wrapper type for IfcDimensionCount
    typedef INTEGER IfcDimensionCount;
    // C++ wrapper type for IfcLinearStiffnessMeasure
    typedef REAL IfcLinearStiffnessMeasure;
    // C++ wrapper type for IfcCompoundPlaneAngleMeasure
    typedef ListOf< INTEGER, 3, 3 > IfcCompoundPlaneAngleMeasure;
    // C++ wrapper type for IfcElectricApplianceTypeEnum
    typedef ENUMERATION IfcElectricApplianceTypeEnum;
    // C++ wrapper type for IfcProfileTypeEnum
    typedef ENUMERATION IfcProfileTypeEnum;
    // C++ wrapper type for IfcCurveFontOrScaledCurveFontSelect
    typedef SELECT IfcCurveFontOrScaledCurveFontSelect;
    // C++ wrapper type for IfcProjectedOrTrueLengthEnum
    typedef ENUMERATION IfcProjectedOrTrueLengthEnum;
    // C++ wrapper type for IfcAbsorbedDoseMeasure
    typedef REAL IfcAbsorbedDoseMeasure;
    // C++ wrapper type for IfcParameterValue
    typedef REAL IfcParameterValue;
    // C++ wrapper type for IfcPileConstructionEnum
    typedef ENUMERATION IfcPileConstructionEnum;
    // C++ wrapper type for IfcMotorConnectionTypeEnum
    typedef ENUMERATION IfcMotorConnectionTypeEnum;
    // C++ wrapper type for IfcOccupantTypeEnum
    typedef ENUMERATION IfcOccupantTypeEnum;
    // C++ wrapper type for IfcUnit
    typedef SELECT IfcUnit;
    // C++ wrapper type for IfcLinearForceMeasure
    typedef REAL IfcLinearForceMeasure;
    // C++ wrapper type for IfcCondenserTypeEnum
    typedef ENUMERATION IfcCondenserTypeEnum;
    // C++ wrapper type for IfcDescriptiveMeasure
    typedef STRING IfcDescriptiveMeasure;
    // C++ wrapper type for IfcMomentOfInertiaMeasure
    typedef REAL IfcMomentOfInertiaMeasure;
    // C++ wrapper type for IfcDoseEquivalentMeasure
    typedef REAL IfcDoseEquivalentMeasure;
    // C++ wrapper type for IfcOrientationSelect
    typedef SELECT IfcOrientationSelect;
    // C++ wrapper type for IfcLogical
    typedef LOGICAL IfcLogical;
    // C++ wrapper type for IfcSizeSelect
    typedef SELECT IfcSizeSelect;
    // C++ wrapper type for IfcEnvironmentalImpactCategoryEnum
    typedef ENUMERATION IfcEnvironmentalImpactCategoryEnum;
    // C++ wrapper type for IfcLogicalOperatorEnum
    typedef ENUMERATION IfcLogicalOperatorEnum;
    // C++ wrapper type for IfcCompressorTypeEnum
    typedef ENUMERATION IfcCompressorTypeEnum;
    // C++ wrapper type for IfcBenchmarkEnum
    typedef ENUMERATION IfcBenchmarkEnum;
    // C++ wrapper type for IfcRatioMeasure
    typedef REAL IfcRatioMeasure;
    // C++ wrapper type for IfcVectorOrDirection
    typedef SELECT IfcVectorOrDirection;
    // C++ wrapper type for IfcConstraintEnum
    typedef ENUMERATION IfcConstraintEnum;
    // C++ wrapper type for IfcAlarmTypeEnum
    typedef ENUMERATION IfcAlarmTypeEnum;
    // C++ wrapper type for IfcLuminousIntensityDistributionMeasure
    typedef REAL IfcLuminousIntensityDistributionMeasure;
    // C++ wrapper type for IfcArithmeticOperatorEnum
    typedef ENUMERATION IfcArithmeticOperatorEnum;
    // C++ wrapper type for IfcAxis2Placement
    typedef SELECT IfcAxis2Placement;
    // C++ wrapper type for IfcForceMeasure
    typedef REAL IfcForceMeasure;
    // C++ wrapper type for IfcTrimmingPreference
    typedef ENUMERATION IfcTrimmingPreference;
    // C++ wrapper type for IfcElectricResistanceMeasure
    typedef REAL IfcElectricResistanceMeasure;
    // C++ wrapper type for IfcWarpingConstantMeasure
    typedef REAL IfcWarpingConstantMeasure;
    // C++ wrapper type for IfcPipeSegmentTypeEnum
    typedef ENUMERATION IfcPipeSegmentTypeEnum;
    // C++ wrapper type for IfcConditionCriterionSelect
    typedef SELECT IfcConditionCriterionSelect;
    // C++ wrapper type for IfcShearModulusMeasure
    typedef REAL IfcShearModulusMeasure;
    // C++ wrapper type for IfcPressureMeasure
    typedef REAL IfcPressureMeasure;
    // C++ wrapper type for IfcDuctSilencerTypeEnum
    typedef ENUMERATION IfcDuctSilencerTypeEnum;
    // C++ wrapper type for IfcBoolean
    typedef BOOLEAN IfcBoolean;
    // C++ wrapper type for IfcSectionModulusMeasure
    typedef REAL IfcSectionModulusMeasure;
    // C++ wrapper type for IfcChangeActionEnum
    typedef ENUMERATION IfcChangeActionEnum;
    // C++ wrapper type for IfcCoilTypeEnum
    typedef ENUMERATION IfcCoilTypeEnum;
    // C++ wrapper type for IfcMassMeasure
    typedef REAL IfcMassMeasure;
    // C++ wrapper type for IfcStructuralCurveTypeEnum
    typedef ENUMERATION IfcStructuralCurveTypeEnum;
    // C++ wrapper type for IfcPermeableCoveringOperationEnum
    typedef ENUMERATION IfcPermeableCoveringOperationEnum;
    // C++ wrapper type for IfcMagneticFluxDensityMeasure
    typedef REAL IfcMagneticFluxDensityMeasure;
    // C++ wrapper type for IfcMoistureDiffusivityMeasure
    typedef REAL IfcMoistureDiffusivityMeasure;


	// ******************************************************************************
	// IFC Entities
	// ******************************************************************************

	struct IfcProfileDef;
	struct IfcParameterizedProfileDef;
	struct IfcZShapeProfileDef;
	struct IfcRoot;
	struct IfcObjectDefinition;
	struct IfcTypeObject;
	struct IfcTypeProduct;
	struct IfcElementType;
	struct IfcFurnishingElementType;
	struct IfcFurnitureType;
	struct IfcObject;
	struct IfcProduct;
	struct IfcGrid;
	struct IfcRepresentationItem;
	struct IfcGeometricRepresentationItem;
	struct IfcOneDirectionRepeatFactor;
	struct IfcTwoDirectionRepeatFactor;
	struct IfcElement;
	struct IfcElementComponent;
	typedef NotImplemented IfcLocalTime; // (not currently used by Assimp)
	struct IfcSpatialStructureElementType;
	struct IfcControl;
	struct IfcActionRequest;
	typedef NotImplemented IfcTextureVertex; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertyDefinition; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertySetDefinition; // (not currently used by Assimp)
	typedef NotImplemented IfcFluidFlowProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcDocumentInformation; // (not currently used by Assimp)
	typedef NotImplemented IfcCalendarDate; // (not currently used by Assimp)
	struct IfcDistributionElementType;
	struct IfcDistributionFlowElementType;
	struct IfcEnergyConversionDeviceType;
	struct IfcCooledBeamType;
	struct IfcCsgPrimitive3D;
	struct IfcRectangularPyramid;
	typedef NotImplemented IfcStructuralLoad; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadStatic; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadLinearForce; // (not currently used by Assimp)
	struct IfcSurface;
	struct IfcBoundedSurface;
	struct IfcRectangularTrimmedSurface;
	typedef NotImplemented IfcPhysicalQuantity; // (not currently used by Assimp)
	typedef NotImplemented IfcPhysicalSimpleQuantity; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityVolume; // (not currently used by Assimp)
	typedef NotImplemented IfcQuantityArea; // (not currently used by Assimp)
	struct IfcGroup;
	struct IfcRelationship;
	typedef NotImplemented IfcRelAssigns; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToActor; // (not currently used by Assimp)
	struct IfcHalfSpaceSolid;
	struct IfcPolygonalBoundedHalfSpace;
	typedef NotImplemented IfcEnergyProperties; // (not currently used by Assimp)
	struct IfcAirToAirHeatRecoveryType;
	struct IfcFlowFittingType;
	struct IfcPipeFittingType;
	struct IfcRepresentation;
	struct IfcStyleModel;
	struct IfcStyledRepresentation;
	typedef NotImplemented IfcRelAssignsToControl; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToProjectOrder; // (not currently used by Assimp)
	typedef NotImplemented IfcDimensionalExponents; // (not currently used by Assimp)
	struct IfcBooleanResult;
	typedef NotImplemented IfcSoundProperties; // (not currently used by Assimp)
	struct IfcFeatureElement;
	struct IfcFeatureElementSubtraction;
	struct IfcOpeningElement;
	struct IfcConditionCriterion;
	struct IfcFlowTerminalType;
	struct IfcFlowControllerType;
	struct IfcSwitchingDeviceType;
	struct IfcSystem;
	struct IfcElectricalCircuit;
	typedef NotImplemented IfcActorRole; // (not currently used by Assimp)
	typedef NotImplemented IfcDateAndTime; // (not currently used by Assimp)
	typedef NotImplemented IfcDraughtingCalloutRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcDimensionCalloutRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcDerivedUnitElement; // (not currently used by Assimp)
	typedef NotImplemented IfcExternalReference; // (not currently used by Assimp)
	typedef NotImplemented IfcClassificationReference; // (not currently used by Assimp)
	struct IfcUnitaryEquipmentType;
	typedef NotImplemented IfcProperty; // (not currently used by Assimp)
	struct IfcPort;
	typedef NotImplemented IfcAddress; // (not currently used by Assimp)
	struct IfcPlacement;
	typedef NotImplemented IfcPreDefinedItem; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedColour; // (not currently used by Assimp)
	typedef NotImplemented IfcDraughtingPreDefinedColour; // (not currently used by Assimp)
	struct IfcArbitraryClosedProfileDef;
	struct IfcCurve;
	struct IfcConic;
	struct IfcCircle;
	typedef NotImplemented IfcAppliedValue; // (not currently used by Assimp)
	typedef NotImplemented IfcEnvironmentalImpactValue; // (not currently used by Assimp)
	typedef NotImplemented IfcSimpleProperty; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertySingleValue; // (not currently used by Assimp)
	struct IfcElementarySurface;
	struct IfcPlane;
	typedef NotImplemented IfcPropertyBoundedValue; // (not currently used by Assimp)
	struct IfcCostSchedule;
	typedef NotImplemented IfcMonetaryUnit; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionGeometry; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionCurveGeometry; // (not currently used by Assimp)
	struct IfcRightCircularCone;
	struct IfcElementAssembly;
	struct IfcBuildingElement;
	struct IfcMember;
	typedef NotImplemented IfcPropertyDependencyRelationship; // (not currently used by Assimp)
	struct IfcBuildingElementProxy;
	struct IfcStructuralActivity;
	struct IfcStructuralAction;
	struct IfcStructuralPlanarAction;
	struct IfcTopologicalRepresentationItem;
	struct IfcConnectedFaceSet;
	struct IfcSweptSurface;
	struct IfcSurfaceOfLinearExtrusion;
	struct IfcArbitraryProfileDefWithVoids;
	struct IfcProcess;
	struct IfcProcedure;
	typedef NotImplemented IfcCurveStyleFontPattern; // (not currently used by Assimp)
	struct IfcVector;
	struct IfcFaceBound;
	struct IfcFaceOuterBound;
	struct IfcFeatureElementAddition;
	struct IfcNamedUnit;
	struct IfcConversionBasedUnit;
	typedef NotImplemented IfcStructuralLoadSingleForce; // (not currently used by Assimp)
	struct IfcHeatExchangerType;
	struct IfcPresentationStyleAssignment;
	struct IfcFlowTreatmentDeviceType;
	struct IfcFilterType;
	struct IfcResource;
	struct IfcEvaporativeCoolerType;
	typedef NotImplemented IfcTextureCoordinate; // (not currently used by Assimp)
	typedef NotImplemented IfcTextureCoordinateGenerator; // (not currently used by Assimp)
	struct IfcOffsetCurve2D;
	struct IfcEdge;
	struct IfcSubedge;
	struct IfcProxy;
	struct IfcLine;
	struct IfcColumn;
	typedef NotImplemented IfcClassificationNotationFacet; // (not currently used by Assimp)
	struct IfcObjectPlacement;
	struct IfcGridPlacement;
	struct IfcDistributionControlElementType;
	typedef NotImplemented IfcStructuralLoadSingleForceWarping; // (not currently used by Assimp)
	typedef NotImplemented IfcExternallyDefinedTextFont; // (not currently used by Assimp)
	struct IfcRelConnects;
	typedef NotImplemented IfcRelConnectsElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsWithRealizingElements; // (not currently used by Assimp)
	typedef NotImplemented IfcConstraintClassificationRelationship; // (not currently used by Assimp)
	struct IfcAnnotation;
	struct IfcPlate;
	struct IfcSolidModel;
	struct IfcManifoldSolidBrep;
	typedef NotImplemented IfcPreDefinedCurveFont; // (not currently used by Assimp)
	typedef NotImplemented IfcBoundaryCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcBoundaryFaceCondition; // (not currently used by Assimp)
	struct IfcFlowStorageDeviceType;
	struct IfcStructuralItem;
	struct IfcStructuralMember;
	struct IfcStructuralCurveMember;
	struct IfcStructuralConnection;
	struct IfcStructuralSurfaceConnection;
	struct IfcCoilType;
	struct IfcDuctFittingType;
	struct IfcStyledItem;
	struct IfcAnnotationOccurrence;
	struct IfcAnnotationCurveOccurrence;
	struct IfcDimensionCurve;
	struct IfcBoundedCurve;
	struct IfcAxis1Placement;
	typedef NotImplemented IfcLightIntensityDistribution; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedSymbol; // (not currently used by Assimp)
	struct IfcColourSpecification;
	struct IfcStructuralPointAction;
	struct IfcSpatialStructureElement;
	struct IfcSpace;
	struct IfcContextDependentUnit;
	typedef NotImplemented IfcVirtualGridIntersection; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociates; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesClassification; // (not currently used by Assimp)
	struct IfcCoolingTowerType;
	typedef NotImplemented IfcMaterialProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcGeneralMaterialProperties; // (not currently used by Assimp)
	struct IfcFacetedBrepWithVoids;
	typedef NotImplemented IfcProfileProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcGeneralProfileProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralProfileProperties; // (not currently used by Assimp)
	struct IfcValveType;
	struct IfcSystemFurnitureElementType;
	struct IfcDiscreteAccessory;
	typedef NotImplemented IfcPerson; // (not currently used by Assimp)
	struct IfcBuildingElementType;
	struct IfcRailingType;
	struct IfcGasTerminalType;
	typedef NotImplemented IfcTimeSeries; // (not currently used by Assimp)
	typedef NotImplemented IfcIrregularTimeSeries; // (not currently used by Assimp)
	struct IfcSpaceProgram;
	struct IfcCovering;
	typedef NotImplemented IfcShapeAspect; // (not currently used by Assimp)
	struct IfcPresentationStyle;
	typedef NotImplemented IfcClassificationItemRelationship; // (not currently used by Assimp)
	struct IfcElectricHeaterType;
	struct IfcBuildingStorey;
	struct IfcVertex;
	struct IfcVertexPoint;
	struct IfcFlowInstrumentType;
	struct IfcUShapeProfileDef;
	struct IfcRamp;
	typedef NotImplemented IfcFillAreaStyle; // (not currently used by Assimp)
	struct IfcCompositeCurve;
	typedef NotImplemented IfcRelServicesBuildings; // (not currently used by Assimp)
	struct IfcStructuralCurveMemberVarying;
	typedef NotImplemented IfcRelReferencedInSpatialStructure; // (not currently used by Assimp)
	struct IfcRampFlightType;
	struct IfcDraughtingCallout;
	struct IfcDimensionCurveDirectedCallout;
	struct IfcRadiusDimension;
	struct IfcEdgeFeature;
	struct IfcSweptAreaSolid;
	struct IfcExtrudedAreaSolid;
	typedef NotImplemented IfcQuantityCount; // (not currently used by Assimp)
	struct IfcAnnotationTextOccurrence;
	typedef NotImplemented IfcReferencesValueDocument; // (not currently used by Assimp)
	struct IfcStair;
	typedef NotImplemented IfcSymbolStyle; // (not currently used by Assimp)
	struct IfcFillAreaStyleTileSymbolWithStyle;
	struct IfcAnnotationSymbolOccurrence;
	struct IfcTerminatorSymbol;
	struct IfcDimensionCurveTerminator;
	struct IfcRectangleProfileDef;
	struct IfcRectangleHollowProfileDef;
	typedef NotImplemented IfcRelAssociatesLibrary; // (not currently used by Assimp)
	struct IfcLocalPlacement;
	typedef NotImplemented IfcOpticalMaterialProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcServiceLifeFactor; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsTasks; // (not currently used by Assimp)
	struct IfcTask;
	struct IfcAnnotationFillAreaOccurrence;
	struct IfcFace;
	struct IfcFlowSegmentType;
	struct IfcDuctSegmentType;
	typedef NotImplemented IfcPropertyEnumeration; // (not currently used by Assimp)
	struct IfcConstructionResource;
	struct IfcConstructionEquipmentResource;
	struct IfcSanitaryTerminalType;
	typedef NotImplemented IfcPreDefinedDimensionSymbol; // (not currently used by Assimp)
	typedef NotImplemented IfcOrganization; // (not currently used by Assimp)
	struct IfcCircleProfileDef;
	struct IfcStructuralReaction;
	struct IfcStructuralPointReaction;
	struct IfcRailing;
	struct IfcTextLiteral;
	struct IfcCartesianTransformationOperator;
	typedef NotImplemented IfcCostValue; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyle; // (not currently used by Assimp)
	struct IfcLinearDimension;
	struct IfcDamperType;
	struct IfcSIUnit;
	typedef NotImplemented IfcSurfaceStyleLighting; // (not currently used by Assimp)
	struct IfcMeasureWithUnit;
	typedef NotImplemented IfcMaterialLayerSet; // (not currently used by Assimp)
	struct IfcDistributionElement;
	struct IfcDistributionControlElement;
	struct IfcTransformerType;
	struct IfcLaborResource;
	struct IfcDerivedProfileDef;
	typedef NotImplemented IfcRelConnectsStructuralMember; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsWithEccentricity; // (not currently used by Assimp)
	struct IfcFurnitureStandard;
	struct IfcStairFlightType;
	struct IfcWorkControl;
	struct IfcWorkPlan;
	typedef NotImplemented IfcRelDefines; // (not currently used by Assimp)
	typedef NotImplemented IfcRelDefinesByProperties; // (not currently used by Assimp)
	struct IfcCondition;
	typedef NotImplemented IfcGridAxis; // (not currently used by Assimp)
	struct IfcRelVoidsElement;
	struct IfcWindow;
	typedef NotImplemented IfcRelFlowControlElements; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsPortToElement; // (not currently used by Assimp)
	struct IfcProtectiveDeviceType;
	struct IfcJunctionBoxType;
	struct IfcStructuralAnalysisModel;
	struct IfcAxis2Placement2D;
	struct IfcSpaceType;
	struct IfcEllipseProfileDef;
	struct IfcDistributionFlowElement;
	struct IfcFlowMovingDevice;
	struct IfcSurfaceStyleWithTextures;
	struct IfcGeometricSet;
	typedef NotImplemented IfcMechanicalMaterialProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcMechanicalConcreteMaterialProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcRibPlateProfileProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcDocumentInformationRelationship; // (not currently used by Assimp)
	struct IfcProjectOrder;
	struct IfcBSplineCurve;
	struct IfcBezierCurve;
	struct IfcStructuralPointConnection;
	struct IfcFlowController;
	struct IfcElectricDistributionPoint;
	struct IfcSite;
	struct IfcOffsetCurve3D;
	typedef NotImplemented IfcPropertySet; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionSurfaceGeometry; // (not currently used by Assimp)
	struct IfcVirtualElement;
	struct IfcConstructionProductResource;
	typedef NotImplemented IfcWaterProperties; // (not currently used by Assimp)
	struct IfcSurfaceCurveSweptAreaSolid;
	typedef NotImplemented IfcPermeableCoveringProperties; // (not currently used by Assimp)
	struct IfcCartesianTransformationOperator3D;
	struct IfcCartesianTransformationOperator3DnonUniform;
	struct IfcCrewResource;
	struct IfcStructuralSurfaceMember;
	struct Ifc2DCompositeCurve;
	struct IfcRepresentationContext;
	struct IfcGeometricRepresentationContext;
	struct IfcFlowTreatmentDevice;
	typedef NotImplemented IfcTextStyleForDefinedFont; // (not currently used by Assimp)
	struct IfcRightCircularCylinder;
	struct IfcWasteTerminalType;
	typedef NotImplemented IfcSpaceThermalLoadProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcConstraintRelationship; // (not currently used by Assimp)
	struct IfcBuildingElementComponent;
	struct IfcBuildingElementPart;
	struct IfcWall;
	struct IfcWallStandardCase;
	typedef NotImplemented IfcApprovalActorRelationship; // (not currently used by Assimp)
	struct IfcPath;
	struct IfcDefinedSymbol;
	struct IfcStructuralSurfaceMemberVarying;
	struct IfcPoint;
	struct IfcSurfaceOfRevolution;
	struct IfcFlowTerminal;
	struct IfcFurnishingElement;
	typedef NotImplemented IfcCurveStyleFont; // (not currently used by Assimp)
	struct IfcSurfaceStyleShading;
	struct IfcSurfaceStyleRendering;
	typedef NotImplemented IfcCoordinatedUniversalTimeOffset; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadSingleDisplacement; // (not currently used by Assimp)
	struct IfcCircleHollowProfileDef;
	struct IfcFlowMovingDeviceType;
	struct IfcFanType;
	struct IfcStructuralPlanarActionVarying;
	struct IfcProductRepresentation;
	typedef NotImplemented IfcRelDefinesByType; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedTextFont; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyleFontModel; // (not currently used by Assimp)
	struct IfcStackTerminalType;
	typedef NotImplemented IfcApprovalPropertyRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcExternallyDefinedSymbol; // (not currently used by Assimp)
	struct IfcReinforcingElement;
	struct IfcReinforcingMesh;
	struct IfcOrderAction;
	typedef NotImplemented IfcRelCoversBldgElements; // (not currently used by Assimp)
	struct IfcLightSource;
	struct IfcLightSourceDirectional;
	struct IfcLoop;
	struct IfcVertexLoop;
	struct IfcChamferEdgeFeature;
	typedef NotImplemented IfcWindowPanelProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcClassification; // (not currently used by Assimp)
	struct IfcElementComponentType;
	struct IfcFastenerType;
	struct IfcMechanicalFastenerType;
	struct IfcScheduleTimeControl;
	struct IfcSurfaceStyle;
	typedef NotImplemented IfcReinforcementBarProperties; // (not currently used by Assimp)
	struct IfcOpenShell;
	typedef NotImplemented IfcLibraryReference; // (not currently used by Assimp)
	struct IfcSubContractResource;
	typedef NotImplemented IfcTimeSeriesReferenceRelationship; // (not currently used by Assimp)
	struct IfcSweptDiskSolid;
	struct IfcCompositeProfileDef;
	typedef NotImplemented IfcElectricalBaseProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcPreDefinedPointMarkerSymbol; // (not currently used by Assimp)
	struct IfcTankType;
	typedef NotImplemented IfcBoundaryNodeCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcBoundaryNodeConditionWarping; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToGroup; // (not currently used by Assimp)
	typedef NotImplemented IfcPresentationLayerAssignment; // (not currently used by Assimp)
	struct IfcSphere;
	struct IfcPolyLoop;
	struct IfcCableCarrierFittingType;
	struct IfcHumidifierType;
	typedef NotImplemented IfcPropertyListValue; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertyConstraintRelationship; // (not currently used by Assimp)
	struct IfcPerformanceHistory;
	struct IfcShapeModel;
	struct IfcTopologyRepresentation;
	struct IfcBuilding;
	struct IfcRoundedRectangleProfileDef;
	struct IfcStairFlight;
	typedef NotImplemented IfcSurfaceStyleRefraction; // (not currently used by Assimp)
	typedef NotImplemented IfcRelInteractionRequirements; // (not currently used by Assimp)
	typedef NotImplemented IfcConstraint; // (not currently used by Assimp)
	typedef NotImplemented IfcObjective; // (not currently used by Assimp)
	typedef NotImplemented IfcConnectionPortGeometry; // (not currently used by Assimp)
	struct IfcDistributionChamberElement;
	typedef NotImplemented IfcPersonAndOrganization; // (not currently used by Assimp)
	struct IfcShapeRepresentation;
	struct IfcRampFlight;
	struct IfcBeamType;
	struct IfcRelDecomposes;
	struct IfcRoof;
	struct IfcFooting;
	typedef NotImplemented IfcRelCoversSpaces; // (not currently used by Assimp)
	struct IfcLightSourceAmbient;
	typedef NotImplemented IfcTimeSeriesValue; // (not currently used by Assimp)
	struct IfcWindowStyle;
	typedef NotImplemented IfcPropertyReferenceValue; // (not currently used by Assimp)
	typedef NotImplemented IfcApproval; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsStructuralElement; // (not currently used by Assimp)
	struct IfcBuildingElementProxyType;
	typedef NotImplemented IfcRelAssociatesProfileProperties; // (not currently used by Assimp)
	struct IfcAxis2Placement3D;
	typedef NotImplemented IfcRelConnectsPorts; // (not currently used by Assimp)
	struct IfcEdgeCurve;
	struct IfcClosedShell;
	struct IfcTendonAnchor;
	struct IfcCondenserType;
	typedef NotImplemented IfcQuantityTime; // (not currently used by Assimp)
	typedef NotImplemented IfcSurfaceTexture; // (not currently used by Assimp)
	typedef NotImplemented IfcPixelTexture; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralConnectionCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcFailureConnectionCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcDocumentReference; // (not currently used by Assimp)
	typedef NotImplemented IfcMechanicalSteelMaterialProperties; // (not currently used by Assimp)
	struct IfcPipeSegmentType;
	struct IfcPointOnSurface;
	typedef NotImplemented IfcTable; // (not currently used by Assimp)
	typedef NotImplemented IfcLightDistributionData; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertyTableValue; // (not currently used by Assimp)
	typedef NotImplemented IfcPresentationLayerWithStyle; // (not currently used by Assimp)
	struct IfcAsset;
	struct IfcLightSourcePositional;
	typedef NotImplemented IfcLibraryInformation; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyleTextModel; // (not currently used by Assimp)
	struct IfcProjectionCurve;
	struct IfcFillAreaStyleTiles;
	struct IfcRelFillsElement;
	struct IfcElectricMotorType;
	struct IfcTendon;
	struct IfcDistributionChamberElementType;
	struct IfcMemberType;
	struct IfcStructuralLinearAction;
	struct IfcStructuralLinearActionVarying;
	struct IfcProductDefinitionShape;
	struct IfcFastener;
	struct IfcMechanicalFastener;
	typedef NotImplemented IfcFuelProperties; // (not currently used by Assimp)
	struct IfcEvaporatorType;
	typedef NotImplemented IfcMaterialLayerSetUsage; // (not currently used by Assimp)
	struct IfcDiscreteAccessoryType;
	struct IfcStructuralCurveConnection;
	struct IfcProjectionElement;
	typedef NotImplemented IfcImageTexture; // (not currently used by Assimp)
	struct IfcCoveringType;
	typedef NotImplemented IfcRelAssociatesAppliedValue; // (not currently used by Assimp)
	struct IfcPumpType;
	struct IfcPile;
	struct IfcUnitAssignment;
	struct IfcBoundingBox;
	struct IfcShellBasedSurfaceModel;
	struct IfcFacetedBrep;
	struct IfcTextLiteralWithExtent;
	typedef NotImplemented IfcApplication; // (not currently used by Assimp)
	typedef NotImplemented IfcExtendedMaterialProperties; // (not currently used by Assimp)
	struct IfcElectricApplianceType;
	typedef NotImplemented IfcRelOccupiesSpaces; // (not currently used by Assimp)
	struct IfcTrapeziumProfileDef;
	typedef NotImplemented IfcQuantityWeight; // (not currently used by Assimp)
	struct IfcRelContainedInSpatialStructure;
	struct IfcEdgeLoop;
	struct IfcProject;
	struct IfcCartesianPoint;
	typedef NotImplemented IfcMaterial; // (not currently used by Assimp)
	struct IfcCurveBoundedPlane;
	struct IfcWallType;
	struct IfcFillAreaStyleHatching;
	struct IfcEquipmentStandard;
	typedef NotImplemented IfcHygroscopicMaterialProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcDoorPanelProperties; // (not currently used by Assimp)
	struct IfcDiameterDimension;
	struct IfcStructuralLoadGroup;
	typedef NotImplemented IfcTelecomAddress; // (not currently used by Assimp)
	struct IfcConstructionMaterialResource;
	typedef NotImplemented IfcBlobTexture; // (not currently used by Assimp)
	typedef NotImplemented IfcIrregularTimeSeriesValue; // (not currently used by Assimp)
	struct IfcRelAggregates;
	struct IfcBoilerType;
	typedef NotImplemented IfcRelProjectsElement; // (not currently used by Assimp)
	struct IfcColourRgb;
	typedef NotImplemented IfcRelConnectsStructuralActivity; // (not currently used by Assimp)
	struct IfcDoorStyle;
	typedef NotImplemented IfcStructuralLoadSingleDisplacementDistortion; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToProcess; // (not currently used by Assimp)
	struct IfcDuctSilencerType;
	struct IfcLightSourceGoniometric;
	struct IfcActuatorType;
	struct IfcSensorType;
	struct IfcAirTerminalBoxType;
	struct IfcAnnotationSurfaceOccurrence;
	typedef NotImplemented IfcClassificationNotation; // (not currently used by Assimp)
	struct IfcRationalBezierCurve;
	struct IfcCartesianTransformationOperator2D;
	struct IfcCartesianTransformationOperator2DnonUniform;
	struct IfcMove;
	typedef NotImplemented IfcBoundaryEdgeCondition; // (not currently used by Assimp)
	typedef NotImplemented IfcDoorLiningProperties; // (not currently used by Assimp)
	struct IfcCableCarrierSegmentType;
	typedef NotImplemented IfcPostalAddress; // (not currently used by Assimp)
	typedef NotImplemented IfcRelConnectsPathElements; // (not currently used by Assimp)
	struct IfcElectricalElement;
	typedef NotImplemented IfcOwnerHistory; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralLoadTemperature; // (not currently used by Assimp)
	typedef NotImplemented IfcTextStyleWithBoxCharacteristics; // (not currently used by Assimp)
	struct IfcChillerType;
	typedef NotImplemented IfcRelSchedulesCostItems; // (not currently used by Assimp)
	struct IfcReinforcingBar;
	typedef NotImplemented IfcCurrencyRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcSoundValue; // (not currently used by Assimp)
	struct IfcCShapeProfileDef;
	struct IfcPermit;
	struct IfcSlabType;
	typedef NotImplemented IfcSlippageConnectionCondition; // (not currently used by Assimp)
	struct IfcLampType;
	struct IfcPlanarExtent;
	struct IfcAlarmType;
	typedef NotImplemented IfcDocumentElectronicFormat; // (not currently used by Assimp)
	struct IfcElectricFlowStorageDeviceType;
	struct IfcEquipmentElement;
	struct IfcLightFixtureType;
	typedef NotImplemented IfcMetric; // (not currently used by Assimp)
	typedef NotImplemented IfcRelNests; // (not currently used by Assimp)
	struct IfcCurtainWall;
	typedef NotImplemented IfcRelAssociatesDocument; // (not currently used by Assimp)
	typedef NotImplemented IfcComplexProperty; // (not currently used by Assimp)
	typedef NotImplemented IfcVertexBasedTextureMap; // (not currently used by Assimp)
	struct IfcSlab;
	struct IfcCurtainWallType;
	struct IfcOutletType;
	struct IfcCompressorType;
	struct IfcCraneRailAShapeProfileDef;
	struct IfcFlowSegment;
	struct IfcSectionedSpine;
	typedef NotImplemented IfcTableRow; // (not currently used by Assimp)
	typedef NotImplemented IfcDraughtingPreDefinedTextFont; // (not currently used by Assimp)
	struct IfcElectricTimeControlType;
	struct IfcFaceSurface;
	typedef NotImplemented IfcMaterialList; // (not currently used by Assimp)
	struct IfcMotorConnectionType;
	struct IfcFlowFitting;
	struct IfcPointOnCurve;
	struct IfcTransportElementType;
	typedef NotImplemented IfcRegularTimeSeries; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesConstraint; // (not currently used by Assimp)
	typedef NotImplemented IfcPropertyEnumeratedValue; // (not currently used by Assimp)
	typedef NotImplemented IfcStructuralSteelProfileProperties; // (not currently used by Assimp)
	struct IfcCableSegmentType;
	typedef NotImplemented IfcExternallyDefinedHatchStyle; // (not currently used by Assimp)
	struct IfcAnnotationSurface;
	struct IfcCompositeCurveSegment;
	struct IfcServiceLife;
	struct IfcPlateType;
	typedef NotImplemented IfcCurveStyle; // (not currently used by Assimp)
	typedef NotImplemented IfcSectionProperties; // (not currently used by Assimp)
	struct IfcVibrationIsolatorType;
	typedef NotImplemented IfcTextureMap; // (not currently used by Assimp)
	struct IfcTrimmedCurve;
	struct IfcMappedItem;
	typedef NotImplemented IfcMaterialLayer; // (not currently used by Assimp)
	struct IfcDirection;
	struct IfcBlock;
	struct IfcProjectOrderRecord;
	struct IfcFlowMeterType;
	struct IfcControllerType;
	struct IfcBeam;
	struct IfcArbitraryOpenProfileDef;
	struct IfcCenterLineProfileDef;
	typedef NotImplemented IfcStructuralLoadPlanarForce; // (not currently used by Assimp)
	struct IfcTimeSeriesSchedule;
	struct IfcRoundedEdgeFeature;
	typedef NotImplemented IfcWindowLiningProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcRelOverridesProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcApprovalRelationship; // (not currently used by Assimp)
	struct IfcIShapeProfileDef;
	struct IfcSpaceHeaterType;
	typedef NotImplemented IfcExternallyDefinedSurfaceStyle; // (not currently used by Assimp)
	typedef NotImplemented IfcDerivedUnit; // (not currently used by Assimp)
	struct IfcFlowStorageDevice;
	typedef NotImplemented IfcMaterialClassificationRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcClassificationItem; // (not currently used by Assimp)
	struct IfcRevolvedAreaSolid;
	typedef NotImplemented IfcConnectionPointGeometry; // (not currently used by Assimp)
	struct IfcDoor;
	struct IfcEllipse;
	struct IfcTubeBundleType;
	struct IfcAngularDimension;
	typedef NotImplemented IfcThermalMaterialProperties; // (not currently used by Assimp)
	struct IfcFaceBasedSurfaceModel;
	struct IfcCraneRailFShapeProfileDef;
	struct IfcColumnType;
	struct IfcTShapeProfileDef;
	struct IfcEnergyConversionDevice;
	typedef NotImplemented IfcConnectionPointEccentricity; // (not currently used by Assimp)
	typedef NotImplemented IfcReinforcementDefinitionProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcCurveStyleFontAndScaling; // (not currently used by Assimp)
	struct IfcWorkSchedule;
	typedef NotImplemented IfcOrganizationRelationship; // (not currently used by Assimp)
	struct IfcZone;
	struct IfcTransportElement;
	typedef NotImplemented IfcDraughtingPreDefinedCurveFont; // (not currently used by Assimp)
	struct IfcGeometricRepresentationSubContext;
	struct IfcLShapeProfileDef;
	struct IfcGeometricCurveSet;
	struct IfcActor;
	struct IfcOccupant;
	typedef NotImplemented IfcPhysicalComplexQuantity; // (not currently used by Assimp)
	struct IfcBooleanClippingResult;
	typedef NotImplemented IfcPreDefinedTerminatorSymbol; // (not currently used by Assimp)
	struct IfcAnnotationFillArea;
	typedef NotImplemented IfcConstraintAggregationRelationship; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesApproval; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssociatesMaterial; // (not currently used by Assimp)
	typedef NotImplemented IfcRelAssignsToProduct; // (not currently used by Assimp)
	typedef NotImplemented IfcAppliedValueRelationship; // (not currently used by Assimp)
	struct IfcLightSourceSpot;
	struct IfcFireSuppressionTerminalType;
	typedef NotImplemented IfcElementQuantity; // (not currently used by Assimp)
	typedef NotImplemented IfcDimensionPair; // (not currently used by Assimp)
	struct IfcElectricGeneratorType;
	typedef NotImplemented IfcRelSequence; // (not currently used by Assimp)
	struct IfcInventory;
	struct IfcPolyline;
	struct IfcBoxedHalfSpace;
	struct IfcAirTerminalType;
	typedef NotImplemented IfcSectionReinforcementProperties; // (not currently used by Assimp)
	struct IfcDistributionPort;
	struct IfcCostItem;
	struct IfcStructuredDimensionCallout;
	struct IfcStructuralResultGroup;
	typedef NotImplemented IfcRelSpaceBoundary; // (not currently used by Assimp)
	struct IfcOrientedEdge;
	typedef NotImplemented IfcRelAssignsToResource; // (not currently used by Assimp)
	struct IfcCsgSolid;
	typedef NotImplemented IfcProductsOfCombustionProperties; // (not currently used by Assimp)
	typedef NotImplemented IfcRelaxation; // (not currently used by Assimp)
	struct IfcPlanarBox;
	typedef NotImplemented IfcQuantityLength; // (not currently used by Assimp)
	struct IfcMaterialDefinitionRepresentation;
	struct IfcAsymmetricIShapeProfileDef;
	struct IfcRepresentationMap;



    // C++ wrapper for IfcProfileDef
    struct IfcProfileDef :  ObjectHelper<IfcProfileDef,2> { IfcProfileDef() : Object("IfcProfileDef") {}
		IfcProfileTypeEnum::Out ProfileType;
		Maybe< IfcLabel::Out > ProfileName;
    };

    // C++ wrapper for IfcParameterizedProfileDef
    struct IfcParameterizedProfileDef : IfcProfileDef, ObjectHelper<IfcParameterizedProfileDef,1> { IfcParameterizedProfileDef() : Object("IfcParameterizedProfileDef") {}
		Lazy< IfcAxis2Placement2D > Position;
    };

    // C++ wrapper for IfcZShapeProfileDef
    struct IfcZShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcZShapeProfileDef,6> { IfcZShapeProfileDef() : Object("IfcZShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out FlangeWidth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcPositiveLengthMeasure::Out > FilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > EdgeRadius;
    };

    // C++ wrapper for IfcRoot
    struct IfcRoot :  ObjectHelper<IfcRoot,4> { IfcRoot() : Object("IfcRoot") {}
		IfcGloballyUniqueId::Out GlobalId;
		Lazy< NotImplemented > OwnerHistory;
		Maybe< IfcLabel::Out > Name;
		Maybe< IfcText::Out > Description;
    };

    // C++ wrapper for IfcObjectDefinition
    struct IfcObjectDefinition : IfcRoot, ObjectHelper<IfcObjectDefinition,0> { IfcObjectDefinition() : Object("IfcObjectDefinition") {}

    };

    // C++ wrapper for IfcTypeObject
    struct IfcTypeObject : IfcObjectDefinition, ObjectHelper<IfcTypeObject,2> { IfcTypeObject() : Object("IfcTypeObject") {}
		Maybe< IfcLabel::Out > ApplicableOccurrence;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > HasPropertySets;
    };

    // C++ wrapper for IfcTypeProduct
    struct IfcTypeProduct : IfcTypeObject, ObjectHelper<IfcTypeProduct,2> { IfcTypeProduct() : Object("IfcTypeProduct") {}
		Maybe< ListOf< Lazy< IfcRepresentationMap >, 1, 0 > > RepresentationMaps;
		Maybe< IfcLabel::Out > Tag;
    };

    // C++ wrapper for IfcElementType
    struct IfcElementType : IfcTypeProduct, ObjectHelper<IfcElementType,1> { IfcElementType() : Object("IfcElementType") {}
		Maybe< IfcLabel::Out > ElementType;
    };

    // C++ wrapper for IfcFurnishingElementType
    struct IfcFurnishingElementType : IfcElementType, ObjectHelper<IfcFurnishingElementType,0> { IfcFurnishingElementType() : Object("IfcFurnishingElementType") {}

    };

    // C++ wrapper for IfcFurnitureType
    struct IfcFurnitureType : IfcFurnishingElementType, ObjectHelper<IfcFurnitureType,1> { IfcFurnitureType() : Object("IfcFurnitureType") {}
		IfcAssemblyPlaceEnum::Out AssemblyPlace;
    };

    // C++ wrapper for IfcObject
    struct IfcObject : IfcObjectDefinition, ObjectHelper<IfcObject,1> { IfcObject() : Object("IfcObject") {}
		Maybe< IfcLabel::Out > ObjectType;
    };

    // C++ wrapper for IfcProduct
    struct IfcProduct : IfcObject, ObjectHelper<IfcProduct,2> { IfcProduct() : Object("IfcProduct") {}
		Maybe< Lazy< IfcObjectPlacement > > ObjectPlacement;
		Maybe< Lazy< IfcProductRepresentation > > Representation;
    };

    // C++ wrapper for IfcGrid
    struct IfcGrid : IfcProduct, ObjectHelper<IfcGrid,3> { IfcGrid() : Object("IfcGrid") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > UAxes;
		ListOf< Lazy< NotImplemented >, 1, 0 > VAxes;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > WAxes;
    };

    // C++ wrapper for IfcRepresentationItem
    struct IfcRepresentationItem :  ObjectHelper<IfcRepresentationItem,0> { IfcRepresentationItem() : Object("IfcRepresentationItem") {}

    };

    // C++ wrapper for IfcGeometricRepresentationItem
    struct IfcGeometricRepresentationItem : IfcRepresentationItem, ObjectHelper<IfcGeometricRepresentationItem,0> { IfcGeometricRepresentationItem() : Object("IfcGeometricRepresentationItem") {}

    };

    // C++ wrapper for IfcOneDirectionRepeatFactor
    struct IfcOneDirectionRepeatFactor : IfcGeometricRepresentationItem, ObjectHelper<IfcOneDirectionRepeatFactor,1> { IfcOneDirectionRepeatFactor() : Object("IfcOneDirectionRepeatFactor") {}
		Lazy< IfcVector > RepeatFactor;
    };

    // C++ wrapper for IfcTwoDirectionRepeatFactor
    struct IfcTwoDirectionRepeatFactor : IfcOneDirectionRepeatFactor, ObjectHelper<IfcTwoDirectionRepeatFactor,1> { IfcTwoDirectionRepeatFactor() : Object("IfcTwoDirectionRepeatFactor") {}
		Lazy< IfcVector > SecondRepeatFactor;
    };

    // C++ wrapper for IfcElement
    struct IfcElement : IfcProduct, ObjectHelper<IfcElement,1> { IfcElement() : Object("IfcElement") {}
		Maybe< IfcIdentifier::Out > Tag;
    };

    // C++ wrapper for IfcElementComponent
    struct IfcElementComponent : IfcElement, ObjectHelper<IfcElementComponent,0> { IfcElementComponent() : Object("IfcElementComponent") {}

    };

    // C++ wrapper for IfcSpatialStructureElementType
    struct IfcSpatialStructureElementType : IfcElementType, ObjectHelper<IfcSpatialStructureElementType,0> { IfcSpatialStructureElementType() : Object("IfcSpatialStructureElementType") {}

    };

    // C++ wrapper for IfcControl
    struct IfcControl : IfcObject, ObjectHelper<IfcControl,0> { IfcControl() : Object("IfcControl") {}

    };

    // C++ wrapper for IfcActionRequest
    struct IfcActionRequest : IfcControl, ObjectHelper<IfcActionRequest,1> { IfcActionRequest() : Object("IfcActionRequest") {}
		IfcIdentifier::Out RequestID;
    };

    // C++ wrapper for IfcDistributionElementType
    struct IfcDistributionElementType : IfcElementType, ObjectHelper<IfcDistributionElementType,0> { IfcDistributionElementType() : Object("IfcDistributionElementType") {}

    };

    // C++ wrapper for IfcDistributionFlowElementType
    struct IfcDistributionFlowElementType : IfcDistributionElementType, ObjectHelper<IfcDistributionFlowElementType,0> { IfcDistributionFlowElementType() : Object("IfcDistributionFlowElementType") {}

    };

    // C++ wrapper for IfcEnergyConversionDeviceType
    struct IfcEnergyConversionDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcEnergyConversionDeviceType,0> { IfcEnergyConversionDeviceType() : Object("IfcEnergyConversionDeviceType") {}

    };

    // C++ wrapper for IfcCooledBeamType
    struct IfcCooledBeamType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCooledBeamType,1> { IfcCooledBeamType() : Object("IfcCooledBeamType") {}
		IfcCooledBeamTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCsgPrimitive3D
    struct IfcCsgPrimitive3D : IfcGeometricRepresentationItem, ObjectHelper<IfcCsgPrimitive3D,1> { IfcCsgPrimitive3D() : Object("IfcCsgPrimitive3D") {}
		Lazy< IfcAxis2Placement3D > Position;
    };

    // C++ wrapper for IfcRectangularPyramid
    struct IfcRectangularPyramid : IfcCsgPrimitive3D, ObjectHelper<IfcRectangularPyramid,3> { IfcRectangularPyramid() : Object("IfcRectangularPyramid") {}
		IfcPositiveLengthMeasure::Out XLength;
		IfcPositiveLengthMeasure::Out YLength;
		IfcPositiveLengthMeasure::Out Height;
    };

    // C++ wrapper for IfcSurface
    struct IfcSurface : IfcGeometricRepresentationItem, ObjectHelper<IfcSurface,0> { IfcSurface() : Object("IfcSurface") {}

    };

    // C++ wrapper for IfcBoundedSurface
    struct IfcBoundedSurface : IfcSurface, ObjectHelper<IfcBoundedSurface,0> { IfcBoundedSurface() : Object("IfcBoundedSurface") {}

    };

    // C++ wrapper for IfcRectangularTrimmedSurface
    struct IfcRectangularTrimmedSurface : IfcBoundedSurface, ObjectHelper<IfcRectangularTrimmedSurface,7> { IfcRectangularTrimmedSurface() : Object("IfcRectangularTrimmedSurface") {}
		Lazy< IfcSurface > BasisSurface;
		IfcParameterValue::Out U1;
		IfcParameterValue::Out V1;
		IfcParameterValue::Out U2;
		IfcParameterValue::Out V2;
		BOOLEAN::Out Usense;
		BOOLEAN::Out Vsense;
    };

    // C++ wrapper for IfcGroup
    struct IfcGroup : IfcObject, ObjectHelper<IfcGroup,0> { IfcGroup() : Object("IfcGroup") {}

    };

    // C++ wrapper for IfcRelationship
    struct IfcRelationship : IfcRoot, ObjectHelper<IfcRelationship,0> { IfcRelationship() : Object("IfcRelationship") {}

    };

    // C++ wrapper for IfcHalfSpaceSolid
    struct IfcHalfSpaceSolid : IfcGeometricRepresentationItem, ObjectHelper<IfcHalfSpaceSolid,2> { IfcHalfSpaceSolid() : Object("IfcHalfSpaceSolid") {}
		Lazy< IfcSurface > BaseSurface;
		BOOLEAN::Out AgreementFlag;
    };

    // C++ wrapper for IfcPolygonalBoundedHalfSpace
    struct IfcPolygonalBoundedHalfSpace : IfcHalfSpaceSolid, ObjectHelper<IfcPolygonalBoundedHalfSpace,2> { IfcPolygonalBoundedHalfSpace() : Object("IfcPolygonalBoundedHalfSpace") {}
		Lazy< IfcAxis2Placement3D > Position;
		Lazy< IfcBoundedCurve > PolygonalBoundary;
    };

    // C++ wrapper for IfcAirToAirHeatRecoveryType
    struct IfcAirToAirHeatRecoveryType : IfcEnergyConversionDeviceType, ObjectHelper<IfcAirToAirHeatRecoveryType,1> { IfcAirToAirHeatRecoveryType() : Object("IfcAirToAirHeatRecoveryType") {}
		IfcAirToAirHeatRecoveryTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowFittingType
    struct IfcFlowFittingType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowFittingType,0> { IfcFlowFittingType() : Object("IfcFlowFittingType") {}

    };

    // C++ wrapper for IfcPipeFittingType
    struct IfcPipeFittingType : IfcFlowFittingType, ObjectHelper<IfcPipeFittingType,1> { IfcPipeFittingType() : Object("IfcPipeFittingType") {}
		IfcPipeFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRepresentation
    struct IfcRepresentation :  ObjectHelper<IfcRepresentation,4> { IfcRepresentation() : Object("IfcRepresentation") {}
		Lazy< IfcRepresentationContext > ContextOfItems;
		Maybe< IfcLabel::Out > RepresentationIdentifier;
		Maybe< IfcLabel::Out > RepresentationType;
		ListOf< Lazy< IfcRepresentationItem >, 1, 0 > Items;
    };

    // C++ wrapper for IfcStyleModel
    struct IfcStyleModel : IfcRepresentation, ObjectHelper<IfcStyleModel,0> { IfcStyleModel() : Object("IfcStyleModel") {}

    };

    // C++ wrapper for IfcStyledRepresentation
    struct IfcStyledRepresentation : IfcStyleModel, ObjectHelper<IfcStyledRepresentation,0> { IfcStyledRepresentation() : Object("IfcStyledRepresentation") {}

    };

    // C++ wrapper for IfcBooleanResult
    struct IfcBooleanResult : IfcGeometricRepresentationItem, ObjectHelper<IfcBooleanResult,3> { IfcBooleanResult() : Object("IfcBooleanResult") {}
		IfcBooleanOperator::Out Operator;
		IfcBooleanOperand::Out FirstOperand;
		IfcBooleanOperand::Out SecondOperand;
    };

    // C++ wrapper for IfcFeatureElement
    struct IfcFeatureElement : IfcElement, ObjectHelper<IfcFeatureElement,0> { IfcFeatureElement() : Object("IfcFeatureElement") {}

    };

    // C++ wrapper for IfcFeatureElementSubtraction
    struct IfcFeatureElementSubtraction : IfcFeatureElement, ObjectHelper<IfcFeatureElementSubtraction,0> { IfcFeatureElementSubtraction() : Object("IfcFeatureElementSubtraction") {}

    };

    // C++ wrapper for IfcOpeningElement
    struct IfcOpeningElement : IfcFeatureElementSubtraction, ObjectHelper<IfcOpeningElement,0> { IfcOpeningElement() : Object("IfcOpeningElement") {}

    };

    // C++ wrapper for IfcConditionCriterion
    struct IfcConditionCriterion : IfcControl, ObjectHelper<IfcConditionCriterion,2> { IfcConditionCriterion() : Object("IfcConditionCriterion") {}
		IfcConditionCriterionSelect::Out Criterion;
		IfcDateTimeSelect::Out CriterionDateTime;
    };

    // C++ wrapper for IfcFlowTerminalType
    struct IfcFlowTerminalType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowTerminalType,0> { IfcFlowTerminalType() : Object("IfcFlowTerminalType") {}

    };

    // C++ wrapper for IfcFlowControllerType
    struct IfcFlowControllerType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowControllerType,0> { IfcFlowControllerType() : Object("IfcFlowControllerType") {}

    };

    // C++ wrapper for IfcSwitchingDeviceType
    struct IfcSwitchingDeviceType : IfcFlowControllerType, ObjectHelper<IfcSwitchingDeviceType,1> { IfcSwitchingDeviceType() : Object("IfcSwitchingDeviceType") {}
		IfcSwitchingDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSystem
    struct IfcSystem : IfcGroup, ObjectHelper<IfcSystem,0> { IfcSystem() : Object("IfcSystem") {}

    };

    // C++ wrapper for IfcElectricalCircuit
    struct IfcElectricalCircuit : IfcSystem, ObjectHelper<IfcElectricalCircuit,0> { IfcElectricalCircuit() : Object("IfcElectricalCircuit") {}

    };

    // C++ wrapper for IfcUnitaryEquipmentType
    struct IfcUnitaryEquipmentType : IfcEnergyConversionDeviceType, ObjectHelper<IfcUnitaryEquipmentType,1> { IfcUnitaryEquipmentType() : Object("IfcUnitaryEquipmentType") {}
		IfcUnitaryEquipmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPort
    struct IfcPort : IfcProduct, ObjectHelper<IfcPort,0> { IfcPort() : Object("IfcPort") {}

    };

    // C++ wrapper for IfcPlacement
    struct IfcPlacement : IfcGeometricRepresentationItem, ObjectHelper<IfcPlacement,1> { IfcPlacement() : Object("IfcPlacement") {}
		Lazy< IfcCartesianPoint > Location;
    };

    // C++ wrapper for IfcArbitraryClosedProfileDef
    struct IfcArbitraryClosedProfileDef : IfcProfileDef, ObjectHelper<IfcArbitraryClosedProfileDef,1> { IfcArbitraryClosedProfileDef() : Object("IfcArbitraryClosedProfileDef") {}
		Lazy< IfcCurve > OuterCurve;
    };

    // C++ wrapper for IfcCurve
    struct IfcCurve : IfcGeometricRepresentationItem, ObjectHelper<IfcCurve,0> { IfcCurve() : Object("IfcCurve") {}

    };

    // C++ wrapper for IfcConic
    struct IfcConic : IfcCurve, ObjectHelper<IfcConic,1> { IfcConic() : Object("IfcConic") {}
		IfcAxis2Placement::Out Position;
    };

    // C++ wrapper for IfcCircle
    struct IfcCircle : IfcConic, ObjectHelper<IfcCircle,1> { IfcCircle() : Object("IfcCircle") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcElementarySurface
    struct IfcElementarySurface : IfcSurface, ObjectHelper<IfcElementarySurface,1> { IfcElementarySurface() : Object("IfcElementarySurface") {}
		Lazy< IfcAxis2Placement3D > Position;
    };

    // C++ wrapper for IfcPlane
    struct IfcPlane : IfcElementarySurface, ObjectHelper<IfcPlane,0> { IfcPlane() : Object("IfcPlane") {}

    };

    // C++ wrapper for IfcCostSchedule
    struct IfcCostSchedule : IfcControl, ObjectHelper<IfcCostSchedule,8> { IfcCostSchedule() : Object("IfcCostSchedule") {}
		Maybe< IfcActorSelect::Out > SubmittedBy;
		Maybe< IfcActorSelect::Out > PreparedBy;
		Maybe< IfcDateTimeSelect::Out > SubmittedOn;
		Maybe< IfcLabel::Out > Status;
		Maybe< ListOf< IfcActorSelect, 1, 0 >::Out > TargetUsers;
		Maybe< IfcDateTimeSelect::Out > UpdateDate;
		IfcIdentifier::Out ID;
		IfcCostScheduleTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRightCircularCone
    struct IfcRightCircularCone : IfcCsgPrimitive3D, ObjectHelper<IfcRightCircularCone,2> { IfcRightCircularCone() : Object("IfcRightCircularCone") {}
		IfcPositiveLengthMeasure::Out Height;
		IfcPositiveLengthMeasure::Out BottomRadius;
    };

    // C++ wrapper for IfcElementAssembly
    struct IfcElementAssembly : IfcElement, ObjectHelper<IfcElementAssembly,2> { IfcElementAssembly() : Object("IfcElementAssembly") {}
		Maybe< IfcAssemblyPlaceEnum::Out > AssemblyPlace;
		IfcElementAssemblyTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBuildingElement
    struct IfcBuildingElement : IfcElement, ObjectHelper<IfcBuildingElement,0> { IfcBuildingElement() : Object("IfcBuildingElement") {}

    };

    // C++ wrapper for IfcMember
    struct IfcMember : IfcBuildingElement, ObjectHelper<IfcMember,0> { IfcMember() : Object("IfcMember") {}

    };

    // C++ wrapper for IfcBuildingElementProxy
    struct IfcBuildingElementProxy : IfcBuildingElement, ObjectHelper<IfcBuildingElementProxy,1> { IfcBuildingElementProxy() : Object("IfcBuildingElementProxy") {}
		Maybe< IfcElementCompositionEnum::Out > CompositionType;
    };

    // C++ wrapper for IfcStructuralActivity
    struct IfcStructuralActivity : IfcProduct, ObjectHelper<IfcStructuralActivity,2> { IfcStructuralActivity() : Object("IfcStructuralActivity") {}
		Lazy< NotImplemented > AppliedLoad;
		IfcGlobalOrLocalEnum::Out GlobalOrLocal;
    };

    // C++ wrapper for IfcStructuralAction
    struct IfcStructuralAction : IfcStructuralActivity, ObjectHelper<IfcStructuralAction,2> { IfcStructuralAction() : Object("IfcStructuralAction") {}
		BOOLEAN::Out DestabilizingLoad;
		Maybe< Lazy< IfcStructuralReaction > > CausedBy;
    };

    // C++ wrapper for IfcStructuralPlanarAction
    struct IfcStructuralPlanarAction : IfcStructuralAction, ObjectHelper<IfcStructuralPlanarAction,1> { IfcStructuralPlanarAction() : Object("IfcStructuralPlanarAction") {}
		IfcProjectedOrTrueLengthEnum::Out ProjectedOrTrue;
    };

    // C++ wrapper for IfcTopologicalRepresentationItem
    struct IfcTopologicalRepresentationItem : IfcRepresentationItem, ObjectHelper<IfcTopologicalRepresentationItem,0> { IfcTopologicalRepresentationItem() : Object("IfcTopologicalRepresentationItem") {}

    };

    // C++ wrapper for IfcConnectedFaceSet
    struct IfcConnectedFaceSet : IfcTopologicalRepresentationItem, ObjectHelper<IfcConnectedFaceSet,1> { IfcConnectedFaceSet() : Object("IfcConnectedFaceSet") {}
		ListOf< Lazy< IfcFace >, 1, 0 > CfsFaces;
    };

    // C++ wrapper for IfcSweptSurface
    struct IfcSweptSurface : IfcSurface, ObjectHelper<IfcSweptSurface,2> { IfcSweptSurface() : Object("IfcSweptSurface") {}
		Lazy< IfcProfileDef > SweptCurve;
		Lazy< IfcAxis2Placement3D > Position;
    };

    // C++ wrapper for IfcSurfaceOfLinearExtrusion
    struct IfcSurfaceOfLinearExtrusion : IfcSweptSurface, ObjectHelper<IfcSurfaceOfLinearExtrusion,2> { IfcSurfaceOfLinearExtrusion() : Object("IfcSurfaceOfLinearExtrusion") {}
		Lazy< IfcDirection > ExtrudedDirection;
		IfcLengthMeasure::Out Depth;
    };

    // C++ wrapper for IfcArbitraryProfileDefWithVoids
    struct IfcArbitraryProfileDefWithVoids : IfcArbitraryClosedProfileDef, ObjectHelper<IfcArbitraryProfileDefWithVoids,1> { IfcArbitraryProfileDefWithVoids() : Object("IfcArbitraryProfileDefWithVoids") {}
		ListOf< Lazy< IfcCurve >, 1, 0 > InnerCurves;
    };

    // C++ wrapper for IfcProcess
    struct IfcProcess : IfcObject, ObjectHelper<IfcProcess,0> { IfcProcess() : Object("IfcProcess") {}

    };

    // C++ wrapper for IfcProcedure
    struct IfcProcedure : IfcProcess, ObjectHelper<IfcProcedure,3> { IfcProcedure() : Object("IfcProcedure") {}
		IfcIdentifier::Out ProcedureID;
		IfcProcedureTypeEnum::Out ProcedureType;
		Maybe< IfcLabel::Out > UserDefinedProcedureType;
    };

    // C++ wrapper for IfcVector
    struct IfcVector : IfcGeometricRepresentationItem, ObjectHelper<IfcVector,2> { IfcVector() : Object("IfcVector") {}
		Lazy< IfcDirection > Orientation;
		IfcLengthMeasure::Out Magnitude;
    };

    // C++ wrapper for IfcFaceBound
    struct IfcFaceBound : IfcTopologicalRepresentationItem, ObjectHelper<IfcFaceBound,2> { IfcFaceBound() : Object("IfcFaceBound") {}
		Lazy< IfcLoop > Bound;
		BOOLEAN::Out Orientation;
    };

    // C++ wrapper for IfcFaceOuterBound
    struct IfcFaceOuterBound : IfcFaceBound, ObjectHelper<IfcFaceOuterBound,0> { IfcFaceOuterBound() : Object("IfcFaceOuterBound") {}

    };

    // C++ wrapper for IfcFeatureElementAddition
    struct IfcFeatureElementAddition : IfcFeatureElement, ObjectHelper<IfcFeatureElementAddition,0> { IfcFeatureElementAddition() : Object("IfcFeatureElementAddition") {}

    };

    // C++ wrapper for IfcNamedUnit
    struct IfcNamedUnit :  ObjectHelper<IfcNamedUnit,2> { IfcNamedUnit() : Object("IfcNamedUnit") {}
		Lazy< NotImplemented > Dimensions;
		IfcUnitEnum::Out UnitType;
    };

    // C++ wrapper for IfcConversionBasedUnit
    struct IfcConversionBasedUnit : IfcNamedUnit, ObjectHelper<IfcConversionBasedUnit,2> { IfcConversionBasedUnit() : Object("IfcConversionBasedUnit") {}
		IfcLabel::Out Name;
		Lazy< IfcMeasureWithUnit > ConversionFactor;
    };

    // C++ wrapper for IfcHeatExchangerType
    struct IfcHeatExchangerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcHeatExchangerType,1> { IfcHeatExchangerType() : Object("IfcHeatExchangerType") {}
		IfcHeatExchangerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPresentationStyleAssignment
    struct IfcPresentationStyleAssignment :  ObjectHelper<IfcPresentationStyleAssignment,1> { IfcPresentationStyleAssignment() : Object("IfcPresentationStyleAssignment") {}
		ListOf< IfcPresentationStyleSelect, 1, 0 >::Out Styles;
    };

    // C++ wrapper for IfcFlowTreatmentDeviceType
    struct IfcFlowTreatmentDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowTreatmentDeviceType,0> { IfcFlowTreatmentDeviceType() : Object("IfcFlowTreatmentDeviceType") {}

    };

    // C++ wrapper for IfcFilterType
    struct IfcFilterType : IfcFlowTreatmentDeviceType, ObjectHelper<IfcFilterType,1> { IfcFilterType() : Object("IfcFilterType") {}
		IfcFilterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcResource
    struct IfcResource : IfcObject, ObjectHelper<IfcResource,0> { IfcResource() : Object("IfcResource") {}

    };

    // C++ wrapper for IfcEvaporativeCoolerType
    struct IfcEvaporativeCoolerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcEvaporativeCoolerType,1> { IfcEvaporativeCoolerType() : Object("IfcEvaporativeCoolerType") {}
		IfcEvaporativeCoolerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcOffsetCurve2D
    struct IfcOffsetCurve2D : IfcCurve, ObjectHelper<IfcOffsetCurve2D,3> { IfcOffsetCurve2D() : Object("IfcOffsetCurve2D") {}
		Lazy< IfcCurve > BasisCurve;
		IfcLengthMeasure::Out Distance;
		LOGICAL::Out SelfIntersect;
    };

    // C++ wrapper for IfcEdge
    struct IfcEdge : IfcTopologicalRepresentationItem, ObjectHelper<IfcEdge,2> { IfcEdge() : Object("IfcEdge") {}
		Lazy< IfcVertex > EdgeStart;
		Lazy< IfcVertex > EdgeEnd;
    };

    // C++ wrapper for IfcSubedge
    struct IfcSubedge : IfcEdge, ObjectHelper<IfcSubedge,1> { IfcSubedge() : Object("IfcSubedge") {}
		Lazy< IfcEdge > ParentEdge;
    };

    // C++ wrapper for IfcProxy
    struct IfcProxy : IfcProduct, ObjectHelper<IfcProxy,2> { IfcProxy() : Object("IfcProxy") {}
		IfcObjectTypeEnum::Out ProxyType;
		Maybe< IfcLabel::Out > Tag;
    };

    // C++ wrapper for IfcLine
    struct IfcLine : IfcCurve, ObjectHelper<IfcLine,2> { IfcLine() : Object("IfcLine") {}
		Lazy< IfcCartesianPoint > Pnt;
		Lazy< IfcVector > Dir;
    };

    // C++ wrapper for IfcColumn
    struct IfcColumn : IfcBuildingElement, ObjectHelper<IfcColumn,0> { IfcColumn() : Object("IfcColumn") {}

    };

    // C++ wrapper for IfcObjectPlacement
    struct IfcObjectPlacement :  ObjectHelper<IfcObjectPlacement,0> { IfcObjectPlacement() : Object("IfcObjectPlacement") {}

    };

    // C++ wrapper for IfcGridPlacement
    struct IfcGridPlacement : IfcObjectPlacement, ObjectHelper<IfcGridPlacement,2> { IfcGridPlacement() : Object("IfcGridPlacement") {}
		Lazy< NotImplemented > PlacementLocation;
		Maybe< Lazy< NotImplemented > > PlacementRefDirection;
    };

    // C++ wrapper for IfcDistributionControlElementType
    struct IfcDistributionControlElementType : IfcDistributionElementType, ObjectHelper<IfcDistributionControlElementType,0> { IfcDistributionControlElementType() : Object("IfcDistributionControlElementType") {}

    };

    // C++ wrapper for IfcRelConnects
    struct IfcRelConnects : IfcRelationship, ObjectHelper<IfcRelConnects,0> { IfcRelConnects() : Object("IfcRelConnects") {}

    };

    // C++ wrapper for IfcAnnotation
    struct IfcAnnotation : IfcProduct, ObjectHelper<IfcAnnotation,0> { IfcAnnotation() : Object("IfcAnnotation") {}

    };

    // C++ wrapper for IfcPlate
    struct IfcPlate : IfcBuildingElement, ObjectHelper<IfcPlate,0> { IfcPlate() : Object("IfcPlate") {}

    };

    // C++ wrapper for IfcSolidModel
    struct IfcSolidModel : IfcGeometricRepresentationItem, ObjectHelper<IfcSolidModel,0> { IfcSolidModel() : Object("IfcSolidModel") {}

    };

    // C++ wrapper for IfcManifoldSolidBrep
    struct IfcManifoldSolidBrep : IfcSolidModel, ObjectHelper<IfcManifoldSolidBrep,1> { IfcManifoldSolidBrep() : Object("IfcManifoldSolidBrep") {}
		Lazy< IfcClosedShell > Outer;
    };

    // C++ wrapper for IfcFlowStorageDeviceType
    struct IfcFlowStorageDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowStorageDeviceType,0> { IfcFlowStorageDeviceType() : Object("IfcFlowStorageDeviceType") {}

    };

    // C++ wrapper for IfcStructuralItem
    struct IfcStructuralItem : IfcProduct, ObjectHelper<IfcStructuralItem,0> { IfcStructuralItem() : Object("IfcStructuralItem") {}

    };

    // C++ wrapper for IfcStructuralMember
    struct IfcStructuralMember : IfcStructuralItem, ObjectHelper<IfcStructuralMember,0> { IfcStructuralMember() : Object("IfcStructuralMember") {}

    };

    // C++ wrapper for IfcStructuralCurveMember
    struct IfcStructuralCurveMember : IfcStructuralMember, ObjectHelper<IfcStructuralCurveMember,1> { IfcStructuralCurveMember() : Object("IfcStructuralCurveMember") {}
		IfcStructuralCurveTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralConnection
    struct IfcStructuralConnection : IfcStructuralItem, ObjectHelper<IfcStructuralConnection,1> { IfcStructuralConnection() : Object("IfcStructuralConnection") {}
		Maybe< Lazy< NotImplemented > > AppliedCondition;
    };

    // C++ wrapper for IfcStructuralSurfaceConnection
    struct IfcStructuralSurfaceConnection : IfcStructuralConnection, ObjectHelper<IfcStructuralSurfaceConnection,0> { IfcStructuralSurfaceConnection() : Object("IfcStructuralSurfaceConnection") {}

    };

    // C++ wrapper for IfcCoilType
    struct IfcCoilType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCoilType,1> { IfcCoilType() : Object("IfcCoilType") {}
		IfcCoilTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDuctFittingType
    struct IfcDuctFittingType : IfcFlowFittingType, ObjectHelper<IfcDuctFittingType,1> { IfcDuctFittingType() : Object("IfcDuctFittingType") {}
		IfcDuctFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStyledItem
    struct IfcStyledItem : IfcRepresentationItem, ObjectHelper<IfcStyledItem,3> { IfcStyledItem() : Object("IfcStyledItem") {}
		Maybe< Lazy< IfcRepresentationItem > > Item;
		ListOf< Lazy< IfcPresentationStyleAssignment >, 1, 0 > Styles;
		Maybe< IfcLabel::Out > Name;
    };

    // C++ wrapper for IfcAnnotationOccurrence
    struct IfcAnnotationOccurrence : IfcStyledItem, ObjectHelper<IfcAnnotationOccurrence,0> { IfcAnnotationOccurrence() : Object("IfcAnnotationOccurrence") {}

    };

    // C++ wrapper for IfcAnnotationCurveOccurrence
    struct IfcAnnotationCurveOccurrence : IfcAnnotationOccurrence, ObjectHelper<IfcAnnotationCurveOccurrence,0> { IfcAnnotationCurveOccurrence() : Object("IfcAnnotationCurveOccurrence") {}

    };

    // C++ wrapper for IfcDimensionCurve
    struct IfcDimensionCurve : IfcAnnotationCurveOccurrence, ObjectHelper<IfcDimensionCurve,0> { IfcDimensionCurve() : Object("IfcDimensionCurve") {}

    };

    // C++ wrapper for IfcBoundedCurve
    struct IfcBoundedCurve : IfcCurve, ObjectHelper<IfcBoundedCurve,0> { IfcBoundedCurve() : Object("IfcBoundedCurve") {}

    };

    // C++ wrapper for IfcAxis1Placement
    struct IfcAxis1Placement : IfcPlacement, ObjectHelper<IfcAxis1Placement,1> { IfcAxis1Placement() : Object("IfcAxis1Placement") {}
		Maybe< Lazy< IfcDirection > > Axis;
    };

    // C++ wrapper for IfcColourSpecification
    struct IfcColourSpecification :  ObjectHelper<IfcColourSpecification,1> { IfcColourSpecification() : Object("IfcColourSpecification") {}
		Maybe< IfcLabel::Out > Name;
    };

    // C++ wrapper for IfcStructuralPointAction
    struct IfcStructuralPointAction : IfcStructuralAction, ObjectHelper<IfcStructuralPointAction,0> { IfcStructuralPointAction() : Object("IfcStructuralPointAction") {}

    };

    // C++ wrapper for IfcSpatialStructureElement
    struct IfcSpatialStructureElement : IfcProduct, ObjectHelper<IfcSpatialStructureElement,2> { IfcSpatialStructureElement() : Object("IfcSpatialStructureElement") {}
		Maybe< IfcLabel::Out > LongName;
		IfcElementCompositionEnum::Out CompositionType;
    };

    // C++ wrapper for IfcSpace
    struct IfcSpace : IfcSpatialStructureElement, ObjectHelper<IfcSpace,2> { IfcSpace() : Object("IfcSpace") {}
		IfcInternalOrExternalEnum::Out InteriorOrExteriorSpace;
		Maybe< IfcLengthMeasure::Out > ElevationWithFlooring;
    };

    // C++ wrapper for IfcContextDependentUnit
    struct IfcContextDependentUnit : IfcNamedUnit, ObjectHelper<IfcContextDependentUnit,1> { IfcContextDependentUnit() : Object("IfcContextDependentUnit") {}
		IfcLabel::Out Name;
    };

    // C++ wrapper for IfcCoolingTowerType
    struct IfcCoolingTowerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCoolingTowerType,1> { IfcCoolingTowerType() : Object("IfcCoolingTowerType") {}
		IfcCoolingTowerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFacetedBrepWithVoids
    struct IfcFacetedBrepWithVoids : IfcManifoldSolidBrep, ObjectHelper<IfcFacetedBrepWithVoids,1> { IfcFacetedBrepWithVoids() : Object("IfcFacetedBrepWithVoids") {}
		ListOf< Lazy< IfcClosedShell >, 1, 0 > Voids;
    };

    // C++ wrapper for IfcValveType
    struct IfcValveType : IfcFlowControllerType, ObjectHelper<IfcValveType,1> { IfcValveType() : Object("IfcValveType") {}
		IfcValveTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSystemFurnitureElementType
    struct IfcSystemFurnitureElementType : IfcFurnishingElementType, ObjectHelper<IfcSystemFurnitureElementType,0> { IfcSystemFurnitureElementType() : Object("IfcSystemFurnitureElementType") {}

    };

    // C++ wrapper for IfcDiscreteAccessory
    struct IfcDiscreteAccessory : IfcElementComponent, ObjectHelper<IfcDiscreteAccessory,0> { IfcDiscreteAccessory() : Object("IfcDiscreteAccessory") {}

    };

    // C++ wrapper for IfcBuildingElementType
    struct IfcBuildingElementType : IfcElementType, ObjectHelper<IfcBuildingElementType,0> { IfcBuildingElementType() : Object("IfcBuildingElementType") {}

    };

    // C++ wrapper for IfcRailingType
    struct IfcRailingType : IfcBuildingElementType, ObjectHelper<IfcRailingType,1> { IfcRailingType() : Object("IfcRailingType") {}
		IfcRailingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcGasTerminalType
    struct IfcGasTerminalType : IfcFlowTerminalType, ObjectHelper<IfcGasTerminalType,1> { IfcGasTerminalType() : Object("IfcGasTerminalType") {}
		IfcGasTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSpaceProgram
    struct IfcSpaceProgram : IfcControl, ObjectHelper<IfcSpaceProgram,5> { IfcSpaceProgram() : Object("IfcSpaceProgram") {}
		IfcIdentifier::Out SpaceProgramIdentifier;
		Maybe< IfcAreaMeasure::Out > MaxRequiredArea;
		Maybe< IfcAreaMeasure::Out > MinRequiredArea;
		Maybe< Lazy< IfcSpatialStructureElement > > RequestedLocation;
		IfcAreaMeasure::Out StandardRequiredArea;
    };

    // C++ wrapper for IfcCovering
    struct IfcCovering : IfcBuildingElement, ObjectHelper<IfcCovering,1> { IfcCovering() : Object("IfcCovering") {}
		Maybe< IfcCoveringTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcPresentationStyle
    struct IfcPresentationStyle :  ObjectHelper<IfcPresentationStyle,1> { IfcPresentationStyle() : Object("IfcPresentationStyle") {}
		Maybe< IfcLabel::Out > Name;
    };

    // C++ wrapper for IfcElectricHeaterType
    struct IfcElectricHeaterType : IfcFlowTerminalType, ObjectHelper<IfcElectricHeaterType,1> { IfcElectricHeaterType() : Object("IfcElectricHeaterType") {}
		IfcElectricHeaterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBuildingStorey
    struct IfcBuildingStorey : IfcSpatialStructureElement, ObjectHelper<IfcBuildingStorey,1> { IfcBuildingStorey() : Object("IfcBuildingStorey") {}
		Maybe< IfcLengthMeasure::Out > Elevation;
    };

    // C++ wrapper for IfcVertex
    struct IfcVertex : IfcTopologicalRepresentationItem, ObjectHelper<IfcVertex,0> { IfcVertex() : Object("IfcVertex") {}

    };

    // C++ wrapper for IfcVertexPoint
    struct IfcVertexPoint : IfcVertex, ObjectHelper<IfcVertexPoint,1> { IfcVertexPoint() : Object("IfcVertexPoint") {}
		Lazy< IfcPoint > VertexGeometry;
    };

    // C++ wrapper for IfcFlowInstrumentType
    struct IfcFlowInstrumentType : IfcDistributionControlElementType, ObjectHelper<IfcFlowInstrumentType,1> { IfcFlowInstrumentType() : Object("IfcFlowInstrumentType") {}
		IfcFlowInstrumentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcUShapeProfileDef
    struct IfcUShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcUShapeProfileDef,8> { IfcUShapeProfileDef() : Object("IfcUShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out FlangeWidth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcPositiveLengthMeasure::Out > FilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > EdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > FlangeSlope;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInX;
    };

    // C++ wrapper for IfcRamp
    struct IfcRamp : IfcBuildingElement, ObjectHelper<IfcRamp,1> { IfcRamp() : Object("IfcRamp") {}
		IfcRampTypeEnum::Out ShapeType;
    };

    // C++ wrapper for IfcCompositeCurve
    struct IfcCompositeCurve : IfcBoundedCurve, ObjectHelper<IfcCompositeCurve,2> { IfcCompositeCurve() : Object("IfcCompositeCurve") {}
		ListOf< Lazy< IfcCompositeCurveSegment >, 1, 0 > Segments;
		LOGICAL::Out SelfIntersect;
    };

    // C++ wrapper for IfcStructuralCurveMemberVarying
    struct IfcStructuralCurveMemberVarying : IfcStructuralCurveMember, ObjectHelper<IfcStructuralCurveMemberVarying,0> { IfcStructuralCurveMemberVarying() : Object("IfcStructuralCurveMemberVarying") {}

    };

    // C++ wrapper for IfcRampFlightType
    struct IfcRampFlightType : IfcBuildingElementType, ObjectHelper<IfcRampFlightType,1> { IfcRampFlightType() : Object("IfcRampFlightType") {}
		IfcRampFlightTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDraughtingCallout
    struct IfcDraughtingCallout : IfcGeometricRepresentationItem, ObjectHelper<IfcDraughtingCallout,1> { IfcDraughtingCallout() : Object("IfcDraughtingCallout") {}
		ListOf< IfcDraughtingCalloutElement, 1, 0 >::Out Contents;
    };

    // C++ wrapper for IfcDimensionCurveDirectedCallout
    struct IfcDimensionCurveDirectedCallout : IfcDraughtingCallout, ObjectHelper<IfcDimensionCurveDirectedCallout,0> { IfcDimensionCurveDirectedCallout() : Object("IfcDimensionCurveDirectedCallout") {}

    };

    // C++ wrapper for IfcRadiusDimension
    struct IfcRadiusDimension : IfcDimensionCurveDirectedCallout, ObjectHelper<IfcRadiusDimension,0> { IfcRadiusDimension() : Object("IfcRadiusDimension") {}

    };

    // C++ wrapper for IfcEdgeFeature
    struct IfcEdgeFeature : IfcFeatureElementSubtraction, ObjectHelper<IfcEdgeFeature,1> { IfcEdgeFeature() : Object("IfcEdgeFeature") {}
		Maybe< IfcPositiveLengthMeasure::Out > FeatureLength;
    };

    // C++ wrapper for IfcSweptAreaSolid
    struct IfcSweptAreaSolid : IfcSolidModel, ObjectHelper<IfcSweptAreaSolid,2> { IfcSweptAreaSolid() : Object("IfcSweptAreaSolid") {}
		Lazy< IfcProfileDef > SweptArea;
		Lazy< IfcAxis2Placement3D > Position;
    };

    // C++ wrapper for IfcExtrudedAreaSolid
    struct IfcExtrudedAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcExtrudedAreaSolid,2> { IfcExtrudedAreaSolid() : Object("IfcExtrudedAreaSolid") {}
		Lazy< IfcDirection > ExtrudedDirection;
		IfcPositiveLengthMeasure::Out Depth;
    };

    // C++ wrapper for IfcAnnotationTextOccurrence
    struct IfcAnnotationTextOccurrence : IfcAnnotationOccurrence, ObjectHelper<IfcAnnotationTextOccurrence,0> { IfcAnnotationTextOccurrence() : Object("IfcAnnotationTextOccurrence") {}

    };

    // C++ wrapper for IfcStair
    struct IfcStair : IfcBuildingElement, ObjectHelper<IfcStair,1> { IfcStair() : Object("IfcStair") {}
		IfcStairTypeEnum::Out ShapeType;
    };

    // C++ wrapper for IfcFillAreaStyleTileSymbolWithStyle
    struct IfcFillAreaStyleTileSymbolWithStyle : IfcGeometricRepresentationItem, ObjectHelper<IfcFillAreaStyleTileSymbolWithStyle,1> { IfcFillAreaStyleTileSymbolWithStyle() : Object("IfcFillAreaStyleTileSymbolWithStyle") {}
		Lazy< IfcAnnotationSymbolOccurrence > Symbol;
    };

    // C++ wrapper for IfcAnnotationSymbolOccurrence
    struct IfcAnnotationSymbolOccurrence : IfcAnnotationOccurrence, ObjectHelper<IfcAnnotationSymbolOccurrence,0> { IfcAnnotationSymbolOccurrence() : Object("IfcAnnotationSymbolOccurrence") {}

    };

    // C++ wrapper for IfcTerminatorSymbol
    struct IfcTerminatorSymbol : IfcAnnotationSymbolOccurrence, ObjectHelper<IfcTerminatorSymbol,1> { IfcTerminatorSymbol() : Object("IfcTerminatorSymbol") {}
		Lazy< IfcAnnotationCurveOccurrence > AnnotatedCurve;
    };

    // C++ wrapper for IfcDimensionCurveTerminator
    struct IfcDimensionCurveTerminator : IfcTerminatorSymbol, ObjectHelper<IfcDimensionCurveTerminator,1> { IfcDimensionCurveTerminator() : Object("IfcDimensionCurveTerminator") {}
		IfcDimensionExtentUsage::Out Role;
    };

    // C++ wrapper for IfcRectangleProfileDef
    struct IfcRectangleProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcRectangleProfileDef,2> { IfcRectangleProfileDef() : Object("IfcRectangleProfileDef") {}
		IfcPositiveLengthMeasure::Out XDim;
		IfcPositiveLengthMeasure::Out YDim;
    };

    // C++ wrapper for IfcRectangleHollowProfileDef
    struct IfcRectangleHollowProfileDef : IfcRectangleProfileDef, ObjectHelper<IfcRectangleHollowProfileDef,3> { IfcRectangleHollowProfileDef() : Object("IfcRectangleHollowProfileDef") {}
		IfcPositiveLengthMeasure::Out WallThickness;
		Maybe< IfcPositiveLengthMeasure::Out > InnerFilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > OuterFilletRadius;
    };

    // C++ wrapper for IfcLocalPlacement
    struct IfcLocalPlacement : IfcObjectPlacement, ObjectHelper<IfcLocalPlacement,2> { IfcLocalPlacement() : Object("IfcLocalPlacement") {}
		Maybe< Lazy< IfcObjectPlacement > > PlacementRelTo;
		IfcAxis2Placement::Out RelativePlacement;
    };

    // C++ wrapper for IfcTask
    struct IfcTask : IfcProcess, ObjectHelper<IfcTask,5> { IfcTask() : Object("IfcTask") {}
		IfcIdentifier::Out TaskId;
		Maybe< IfcLabel::Out > Status;
		Maybe< IfcLabel::Out > WorkMethod;
		BOOLEAN::Out IsMilestone;
		Maybe< INTEGER::Out > Priority;
    };

    // C++ wrapper for IfcAnnotationFillAreaOccurrence
    struct IfcAnnotationFillAreaOccurrence : IfcAnnotationOccurrence, ObjectHelper<IfcAnnotationFillAreaOccurrence,2> { IfcAnnotationFillAreaOccurrence() : Object("IfcAnnotationFillAreaOccurrence") {}
		Maybe< Lazy< IfcPoint > > FillStyleTarget;
		Maybe< IfcGlobalOrLocalEnum::Out > GlobalOrLocal;
    };

    // C++ wrapper for IfcFace
    struct IfcFace : IfcTopologicalRepresentationItem, ObjectHelper<IfcFace,1> { IfcFace() : Object("IfcFace") {}
		ListOf< Lazy< IfcFaceBound >, 1, 0 > Bounds;
    };

    // C++ wrapper for IfcFlowSegmentType
    struct IfcFlowSegmentType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowSegmentType,0> { IfcFlowSegmentType() : Object("IfcFlowSegmentType") {}

    };

    // C++ wrapper for IfcDuctSegmentType
    struct IfcDuctSegmentType : IfcFlowSegmentType, ObjectHelper<IfcDuctSegmentType,1> { IfcDuctSegmentType() : Object("IfcDuctSegmentType") {}
		IfcDuctSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcConstructionResource
    struct IfcConstructionResource : IfcResource, ObjectHelper<IfcConstructionResource,4> { IfcConstructionResource() : Object("IfcConstructionResource") {}
		Maybe< IfcIdentifier::Out > ResourceIdentifier;
		Maybe< IfcLabel::Out > ResourceGroup;
		Maybe< IfcResourceConsumptionEnum::Out > ResourceConsumption;
		Maybe< Lazy< IfcMeasureWithUnit > > BaseQuantity;
    };

    // C++ wrapper for IfcConstructionEquipmentResource
    struct IfcConstructionEquipmentResource : IfcConstructionResource, ObjectHelper<IfcConstructionEquipmentResource,0> { IfcConstructionEquipmentResource() : Object("IfcConstructionEquipmentResource") {}

    };

    // C++ wrapper for IfcSanitaryTerminalType
    struct IfcSanitaryTerminalType : IfcFlowTerminalType, ObjectHelper<IfcSanitaryTerminalType,1> { IfcSanitaryTerminalType() : Object("IfcSanitaryTerminalType") {}
		IfcSanitaryTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCircleProfileDef
    struct IfcCircleProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcCircleProfileDef,1> { IfcCircleProfileDef() : Object("IfcCircleProfileDef") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcStructuralReaction
    struct IfcStructuralReaction : IfcStructuralActivity, ObjectHelper<IfcStructuralReaction,0> { IfcStructuralReaction() : Object("IfcStructuralReaction") {}

    };

    // C++ wrapper for IfcStructuralPointReaction
    struct IfcStructuralPointReaction : IfcStructuralReaction, ObjectHelper<IfcStructuralPointReaction,0> { IfcStructuralPointReaction() : Object("IfcStructuralPointReaction") {}

    };

    // C++ wrapper for IfcRailing
    struct IfcRailing : IfcBuildingElement, ObjectHelper<IfcRailing,1> { IfcRailing() : Object("IfcRailing") {}
		Maybe< IfcRailingTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcTextLiteral
    struct IfcTextLiteral : IfcGeometricRepresentationItem, ObjectHelper<IfcTextLiteral,3> { IfcTextLiteral() : Object("IfcTextLiteral") {}
		IfcPresentableText::Out Literal;
		IfcAxis2Placement::Out Placement;
		IfcTextPath::Out Path;
    };

    // C++ wrapper for IfcCartesianTransformationOperator
    struct IfcCartesianTransformationOperator : IfcGeometricRepresentationItem, ObjectHelper<IfcCartesianTransformationOperator,4> { IfcCartesianTransformationOperator() : Object("IfcCartesianTransformationOperator") {}
		Maybe< Lazy< IfcDirection > > Axis1;
		Maybe< Lazy< IfcDirection > > Axis2;
		Lazy< IfcCartesianPoint > LocalOrigin;
		Maybe< REAL::Out > Scale;
    };

    // C++ wrapper for IfcLinearDimension
    struct IfcLinearDimension : IfcDimensionCurveDirectedCallout, ObjectHelper<IfcLinearDimension,0> { IfcLinearDimension() : Object("IfcLinearDimension") {}

    };

    // C++ wrapper for IfcDamperType
    struct IfcDamperType : IfcFlowControllerType, ObjectHelper<IfcDamperType,1> { IfcDamperType() : Object("IfcDamperType") {}
		IfcDamperTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSIUnit
    struct IfcSIUnit : IfcNamedUnit, ObjectHelper<IfcSIUnit,2> { IfcSIUnit() : Object("IfcSIUnit") {}
		Maybe< IfcSIPrefix::Out > Prefix;
		IfcSIUnitName::Out Name;
    };

    // C++ wrapper for IfcMeasureWithUnit
    struct IfcMeasureWithUnit :  ObjectHelper<IfcMeasureWithUnit,2> { IfcMeasureWithUnit() : Object("IfcMeasureWithUnit") {}
		IfcValue::Out ValueComponent;
		IfcUnit::Out UnitComponent;
    };

    // C++ wrapper for IfcDistributionElement
    struct IfcDistributionElement : IfcElement, ObjectHelper<IfcDistributionElement,0> { IfcDistributionElement() : Object("IfcDistributionElement") {}

    };

    // C++ wrapper for IfcDistributionControlElement
    struct IfcDistributionControlElement : IfcDistributionElement, ObjectHelper<IfcDistributionControlElement,1> { IfcDistributionControlElement() : Object("IfcDistributionControlElement") {}
		Maybe< IfcIdentifier::Out > ControlElementId;
    };

    // C++ wrapper for IfcTransformerType
    struct IfcTransformerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcTransformerType,1> { IfcTransformerType() : Object("IfcTransformerType") {}
		IfcTransformerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLaborResource
    struct IfcLaborResource : IfcConstructionResource, ObjectHelper<IfcLaborResource,1> { IfcLaborResource() : Object("IfcLaborResource") {}
		Maybe< IfcText::Out > SkillSet;
    };

    // C++ wrapper for IfcDerivedProfileDef
    struct IfcDerivedProfileDef : IfcProfileDef, ObjectHelper<IfcDerivedProfileDef,3> { IfcDerivedProfileDef() : Object("IfcDerivedProfileDef") {}
		Lazy< IfcProfileDef > ParentProfile;
		Lazy< IfcCartesianTransformationOperator2D > Operator;
		Maybe< IfcLabel::Out > Label;
    };

    // C++ wrapper for IfcFurnitureStandard
    struct IfcFurnitureStandard : IfcControl, ObjectHelper<IfcFurnitureStandard,0> { IfcFurnitureStandard() : Object("IfcFurnitureStandard") {}

    };

    // C++ wrapper for IfcStairFlightType
    struct IfcStairFlightType : IfcBuildingElementType, ObjectHelper<IfcStairFlightType,1> { IfcStairFlightType() : Object("IfcStairFlightType") {}
		IfcStairFlightTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcWorkControl
    struct IfcWorkControl : IfcControl, ObjectHelper<IfcWorkControl,10> { IfcWorkControl() : Object("IfcWorkControl") {}
		IfcIdentifier::Out Identifier;
		IfcDateTimeSelect::Out CreationDate;
		Maybe< ListOf< Lazy< NotImplemented >, 1, 0 > > Creators;
		Maybe< IfcLabel::Out > Purpose;
		Maybe< IfcTimeMeasure::Out > Duration;
		Maybe< IfcTimeMeasure::Out > TotalFloat;
		IfcDateTimeSelect::Out StartTime;
		Maybe< IfcDateTimeSelect::Out > FinishTime;
		Maybe< IfcWorkControlTypeEnum::Out > WorkControlType;
		Maybe< IfcLabel::Out > UserDefinedControlType;
    };

    // C++ wrapper for IfcWorkPlan
    struct IfcWorkPlan : IfcWorkControl, ObjectHelper<IfcWorkPlan,0> { IfcWorkPlan() : Object("IfcWorkPlan") {}

    };

    // C++ wrapper for IfcCondition
    struct IfcCondition : IfcGroup, ObjectHelper<IfcCondition,0> { IfcCondition() : Object("IfcCondition") {}

    };

    // C++ wrapper for IfcRelVoidsElement
    struct IfcRelVoidsElement : IfcRelConnects, ObjectHelper<IfcRelVoidsElement,2> { IfcRelVoidsElement() : Object("IfcRelVoidsElement") {}
		Lazy< IfcElement > RelatingBuildingElement;
		Lazy< IfcFeatureElementSubtraction > RelatedOpeningElement;
    };

    // C++ wrapper for IfcWindow
    struct IfcWindow : IfcBuildingElement, ObjectHelper<IfcWindow,2> { IfcWindow() : Object("IfcWindow") {}
		Maybe< IfcPositiveLengthMeasure::Out > OverallHeight;
		Maybe< IfcPositiveLengthMeasure::Out > OverallWidth;
    };

    // C++ wrapper for IfcProtectiveDeviceType
    struct IfcProtectiveDeviceType : IfcFlowControllerType, ObjectHelper<IfcProtectiveDeviceType,1> { IfcProtectiveDeviceType() : Object("IfcProtectiveDeviceType") {}
		IfcProtectiveDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcJunctionBoxType
    struct IfcJunctionBoxType : IfcFlowFittingType, ObjectHelper<IfcJunctionBoxType,1> { IfcJunctionBoxType() : Object("IfcJunctionBoxType") {}
		IfcJunctionBoxTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralAnalysisModel
    struct IfcStructuralAnalysisModel : IfcSystem, ObjectHelper<IfcStructuralAnalysisModel,4> { IfcStructuralAnalysisModel() : Object("IfcStructuralAnalysisModel") {}
		IfcAnalysisModelTypeEnum::Out PredefinedType;
		Maybe< Lazy< IfcAxis2Placement3D > > OrientationOf2DPlane;
		Maybe< ListOf< Lazy< IfcStructuralLoadGroup >, 1, 0 > > LoadedBy;
		Maybe< ListOf< Lazy< IfcStructuralResultGroup >, 1, 0 > > HasResults;
    };

    // C++ wrapper for IfcAxis2Placement2D
    struct IfcAxis2Placement2D : IfcPlacement, ObjectHelper<IfcAxis2Placement2D,1> { IfcAxis2Placement2D() : Object("IfcAxis2Placement2D") {}
		Maybe< Lazy< IfcDirection > > RefDirection;
    };

    // C++ wrapper for IfcSpaceType
    struct IfcSpaceType : IfcSpatialStructureElementType, ObjectHelper<IfcSpaceType,1> { IfcSpaceType() : Object("IfcSpaceType") {}
		IfcSpaceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcEllipseProfileDef
    struct IfcEllipseProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcEllipseProfileDef,2> { IfcEllipseProfileDef() : Object("IfcEllipseProfileDef") {}
		IfcPositiveLengthMeasure::Out SemiAxis1;
		IfcPositiveLengthMeasure::Out SemiAxis2;
    };

    // C++ wrapper for IfcDistributionFlowElement
    struct IfcDistributionFlowElement : IfcDistributionElement, ObjectHelper<IfcDistributionFlowElement,0> { IfcDistributionFlowElement() : Object("IfcDistributionFlowElement") {}

    };

    // C++ wrapper for IfcFlowMovingDevice
    struct IfcFlowMovingDevice : IfcDistributionFlowElement, ObjectHelper<IfcFlowMovingDevice,0> { IfcFlowMovingDevice() : Object("IfcFlowMovingDevice") {}

    };

    // C++ wrapper for IfcSurfaceStyleWithTextures
    struct IfcSurfaceStyleWithTextures :  ObjectHelper<IfcSurfaceStyleWithTextures,1> { IfcSurfaceStyleWithTextures() : Object("IfcSurfaceStyleWithTextures") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > Textures;
    };

    // C++ wrapper for IfcGeometricSet
    struct IfcGeometricSet : IfcGeometricRepresentationItem, ObjectHelper<IfcGeometricSet,1> { IfcGeometricSet() : Object("IfcGeometricSet") {}
		ListOf< IfcGeometricSetSelect, 1, 0 >::Out Elements;
    };

    // C++ wrapper for IfcProjectOrder
    struct IfcProjectOrder : IfcControl, ObjectHelper<IfcProjectOrder,3> { IfcProjectOrder() : Object("IfcProjectOrder") {}
		IfcIdentifier::Out ID;
		IfcProjectOrderTypeEnum::Out PredefinedType;
		Maybe< IfcLabel::Out > Status;
    };

    // C++ wrapper for IfcBSplineCurve
    struct IfcBSplineCurve : IfcBoundedCurve, ObjectHelper<IfcBSplineCurve,5> { IfcBSplineCurve() : Object("IfcBSplineCurve") {}
		INTEGER::Out Degree;
		ListOf< Lazy< IfcCartesianPoint >, 2, 0 > ControlPointsList;
		IfcBSplineCurveForm::Out CurveForm;
		LOGICAL::Out ClosedCurve;
		LOGICAL::Out SelfIntersect;
    };

    // C++ wrapper for IfcBezierCurve
    struct IfcBezierCurve : IfcBSplineCurve, ObjectHelper<IfcBezierCurve,0> { IfcBezierCurve() : Object("IfcBezierCurve") {}

    };

    // C++ wrapper for IfcStructuralPointConnection
    struct IfcStructuralPointConnection : IfcStructuralConnection, ObjectHelper<IfcStructuralPointConnection,0> { IfcStructuralPointConnection() : Object("IfcStructuralPointConnection") {}

    };

    // C++ wrapper for IfcFlowController
    struct IfcFlowController : IfcDistributionFlowElement, ObjectHelper<IfcFlowController,0> { IfcFlowController() : Object("IfcFlowController") {}

    };

    // C++ wrapper for IfcElectricDistributionPoint
    struct IfcElectricDistributionPoint : IfcFlowController, ObjectHelper<IfcElectricDistributionPoint,2> { IfcElectricDistributionPoint() : Object("IfcElectricDistributionPoint") {}
		IfcElectricDistributionPointFunctionEnum::Out DistributionPointFunction;
		Maybe< IfcLabel::Out > UserDefinedFunction;
    };

    // C++ wrapper for IfcSite
    struct IfcSite : IfcSpatialStructureElement, ObjectHelper<IfcSite,5> { IfcSite() : Object("IfcSite") {}
		Maybe< IfcCompoundPlaneAngleMeasure::Out > RefLatitude;
		Maybe< IfcCompoundPlaneAngleMeasure::Out > RefLongitude;
		Maybe< IfcLengthMeasure::Out > RefElevation;
		Maybe< IfcLabel::Out > LandTitleNumber;
		Maybe< Lazy< NotImplemented > > SiteAddress;
    };

    // C++ wrapper for IfcOffsetCurve3D
    struct IfcOffsetCurve3D : IfcCurve, ObjectHelper<IfcOffsetCurve3D,4> { IfcOffsetCurve3D() : Object("IfcOffsetCurve3D") {}
		Lazy< IfcCurve > BasisCurve;
		IfcLengthMeasure::Out Distance;
		LOGICAL::Out SelfIntersect;
		Lazy< IfcDirection > RefDirection;
    };

    // C++ wrapper for IfcVirtualElement
    struct IfcVirtualElement : IfcElement, ObjectHelper<IfcVirtualElement,0> { IfcVirtualElement() : Object("IfcVirtualElement") {}

    };

    // C++ wrapper for IfcConstructionProductResource
    struct IfcConstructionProductResource : IfcConstructionResource, ObjectHelper<IfcConstructionProductResource,0> { IfcConstructionProductResource() : Object("IfcConstructionProductResource") {}

    };

    // C++ wrapper for IfcSurfaceCurveSweptAreaSolid
    struct IfcSurfaceCurveSweptAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcSurfaceCurveSweptAreaSolid,4> { IfcSurfaceCurveSweptAreaSolid() : Object("IfcSurfaceCurveSweptAreaSolid") {}
		Lazy< IfcCurve > Directrix;
		IfcParameterValue::Out StartParam;
		IfcParameterValue::Out EndParam;
		Lazy< IfcSurface > ReferenceSurface;
    };

    // C++ wrapper for IfcCartesianTransformationOperator3D
    struct IfcCartesianTransformationOperator3D : IfcCartesianTransformationOperator, ObjectHelper<IfcCartesianTransformationOperator3D,1> { IfcCartesianTransformationOperator3D() : Object("IfcCartesianTransformationOperator3D") {}
		Maybe< Lazy< IfcDirection > > Axis3;
    };

    // C++ wrapper for IfcCartesianTransformationOperator3DnonUniform
    struct IfcCartesianTransformationOperator3DnonUniform : IfcCartesianTransformationOperator3D, ObjectHelper<IfcCartesianTransformationOperator3DnonUniform,2> { IfcCartesianTransformationOperator3DnonUniform() : Object("IfcCartesianTransformationOperator3DnonUniform") {}
		Maybe< REAL::Out > Scale2;
		Maybe< REAL::Out > Scale3;
    };

    // C++ wrapper for IfcCrewResource
    struct IfcCrewResource : IfcConstructionResource, ObjectHelper<IfcCrewResource,0> { IfcCrewResource() : Object("IfcCrewResource") {}

    };

    // C++ wrapper for IfcStructuralSurfaceMember
    struct IfcStructuralSurfaceMember : IfcStructuralMember, ObjectHelper<IfcStructuralSurfaceMember,2> { IfcStructuralSurfaceMember() : Object("IfcStructuralSurfaceMember") {}
		IfcStructuralSurfaceTypeEnum::Out PredefinedType;
		Maybe< IfcPositiveLengthMeasure::Out > Thickness;
    };

    // C++ wrapper for Ifc2DCompositeCurve
    struct Ifc2DCompositeCurve : IfcCompositeCurve, ObjectHelper<Ifc2DCompositeCurve,0> { Ifc2DCompositeCurve() : Object("Ifc2DCompositeCurve") {}

    };

    // C++ wrapper for IfcRepresentationContext
    struct IfcRepresentationContext :  ObjectHelper<IfcRepresentationContext,2> { IfcRepresentationContext() : Object("IfcRepresentationContext") {}
		Maybe< IfcLabel::Out > ContextIdentifier;
		Maybe< IfcLabel::Out > ContextType;
    };

    // C++ wrapper for IfcGeometricRepresentationContext
    struct IfcGeometricRepresentationContext : IfcRepresentationContext, ObjectHelper<IfcGeometricRepresentationContext,4> { IfcGeometricRepresentationContext() : Object("IfcGeometricRepresentationContext") {}
		IfcDimensionCount::Out CoordinateSpaceDimension;
		Maybe< REAL::Out > Precision;
		IfcAxis2Placement::Out WorldCoordinateSystem;
		Maybe< Lazy< IfcDirection > > TrueNorth;
    };

    // C++ wrapper for IfcFlowTreatmentDevice
    struct IfcFlowTreatmentDevice : IfcDistributionFlowElement, ObjectHelper<IfcFlowTreatmentDevice,0> { IfcFlowTreatmentDevice() : Object("IfcFlowTreatmentDevice") {}

    };

    // C++ wrapper for IfcRightCircularCylinder
    struct IfcRightCircularCylinder : IfcCsgPrimitive3D, ObjectHelper<IfcRightCircularCylinder,2> { IfcRightCircularCylinder() : Object("IfcRightCircularCylinder") {}
		IfcPositiveLengthMeasure::Out Height;
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcWasteTerminalType
    struct IfcWasteTerminalType : IfcFlowTerminalType, ObjectHelper<IfcWasteTerminalType,1> { IfcWasteTerminalType() : Object("IfcWasteTerminalType") {}
		IfcWasteTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBuildingElementComponent
    struct IfcBuildingElementComponent : IfcBuildingElement, ObjectHelper<IfcBuildingElementComponent,0> { IfcBuildingElementComponent() : Object("IfcBuildingElementComponent") {}

    };

    // C++ wrapper for IfcBuildingElementPart
    struct IfcBuildingElementPart : IfcBuildingElementComponent, ObjectHelper<IfcBuildingElementPart,0> { IfcBuildingElementPart() : Object("IfcBuildingElementPart") {}

    };

    // C++ wrapper for IfcWall
    struct IfcWall : IfcBuildingElement, ObjectHelper<IfcWall,0> { IfcWall() : Object("IfcWall") {}

    };

    // C++ wrapper for IfcWallStandardCase
    struct IfcWallStandardCase : IfcWall, ObjectHelper<IfcWallStandardCase,0> { IfcWallStandardCase() : Object("IfcWallStandardCase") {}

    };

    // C++ wrapper for IfcPath
    struct IfcPath : IfcTopologicalRepresentationItem, ObjectHelper<IfcPath,1> { IfcPath() : Object("IfcPath") {}
		ListOf< Lazy< IfcOrientedEdge >, 1, 0 > EdgeList;
    };

    // C++ wrapper for IfcDefinedSymbol
    struct IfcDefinedSymbol : IfcGeometricRepresentationItem, ObjectHelper<IfcDefinedSymbol,2> { IfcDefinedSymbol() : Object("IfcDefinedSymbol") {}
		IfcDefinedSymbolSelect::Out Definition;
		Lazy< IfcCartesianTransformationOperator2D > Target;
    };

    // C++ wrapper for IfcStructuralSurfaceMemberVarying
    struct IfcStructuralSurfaceMemberVarying : IfcStructuralSurfaceMember, ObjectHelper<IfcStructuralSurfaceMemberVarying,2> { IfcStructuralSurfaceMemberVarying() : Object("IfcStructuralSurfaceMemberVarying") {}
		ListOf< IfcPositiveLengthMeasure, 2, 0 >::Out SubsequentThickness;
		Lazy< NotImplemented > VaryingThicknessLocation;
    };

    // C++ wrapper for IfcPoint
    struct IfcPoint : IfcGeometricRepresentationItem, ObjectHelper<IfcPoint,0> { IfcPoint() : Object("IfcPoint") {}

    };

    // C++ wrapper for IfcSurfaceOfRevolution
    struct IfcSurfaceOfRevolution : IfcSweptSurface, ObjectHelper<IfcSurfaceOfRevolution,1> { IfcSurfaceOfRevolution() : Object("IfcSurfaceOfRevolution") {}
		Lazy< IfcAxis1Placement > AxisPosition;
    };

    // C++ wrapper for IfcFlowTerminal
    struct IfcFlowTerminal : IfcDistributionFlowElement, ObjectHelper<IfcFlowTerminal,0> { IfcFlowTerminal() : Object("IfcFlowTerminal") {}

    };

    // C++ wrapper for IfcFurnishingElement
    struct IfcFurnishingElement : IfcElement, ObjectHelper<IfcFurnishingElement,0> { IfcFurnishingElement() : Object("IfcFurnishingElement") {}

    };

    // C++ wrapper for IfcSurfaceStyleShading
    struct IfcSurfaceStyleShading :  ObjectHelper<IfcSurfaceStyleShading,1> { IfcSurfaceStyleShading() : Object("IfcSurfaceStyleShading") {}
		Lazy< IfcColourRgb > SurfaceColour;
    };

    // C++ wrapper for IfcSurfaceStyleRendering
    struct IfcSurfaceStyleRendering : IfcSurfaceStyleShading, ObjectHelper<IfcSurfaceStyleRendering,8> { IfcSurfaceStyleRendering() : Object("IfcSurfaceStyleRendering") {}
		Maybe< IfcNormalisedRatioMeasure::Out > Transparency;
		Maybe< IfcColourOrFactor::Out > DiffuseColour;
		Maybe< IfcColourOrFactor::Out > TransmissionColour;
		Maybe< IfcColourOrFactor::Out > DiffuseTransmissionColour;
		Maybe< IfcColourOrFactor::Out > ReflectionColour;
		Maybe< IfcColourOrFactor::Out > SpecularColour;
		Maybe< IfcSpecularHighlightSelect::Out > SpecularHighlight;
		IfcReflectanceMethodEnum::Out ReflectanceMethod;
    };

    // C++ wrapper for IfcCircleHollowProfileDef
    struct IfcCircleHollowProfileDef : IfcCircleProfileDef, ObjectHelper<IfcCircleHollowProfileDef,1> { IfcCircleHollowProfileDef() : Object("IfcCircleHollowProfileDef") {}
		IfcPositiveLengthMeasure::Out WallThickness;
    };

    // C++ wrapper for IfcFlowMovingDeviceType
    struct IfcFlowMovingDeviceType : IfcDistributionFlowElementType, ObjectHelper<IfcFlowMovingDeviceType,0> { IfcFlowMovingDeviceType() : Object("IfcFlowMovingDeviceType") {}

    };

    // C++ wrapper for IfcFanType
    struct IfcFanType : IfcFlowMovingDeviceType, ObjectHelper<IfcFanType,1> { IfcFanType() : Object("IfcFanType") {}
		IfcFanTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralPlanarActionVarying
    struct IfcStructuralPlanarActionVarying : IfcStructuralPlanarAction, ObjectHelper<IfcStructuralPlanarActionVarying,2> { IfcStructuralPlanarActionVarying() : Object("IfcStructuralPlanarActionVarying") {}
		Lazy< NotImplemented > VaryingAppliedLoadLocation;
		ListOf< Lazy< NotImplemented >, 2, 0 > SubsequentAppliedLoads;
    };

    // C++ wrapper for IfcProductRepresentation
    struct IfcProductRepresentation :  ObjectHelper<IfcProductRepresentation,3> { IfcProductRepresentation() : Object("IfcProductRepresentation") {}
		Maybe< IfcLabel::Out > Name;
		Maybe< IfcText::Out > Description;
		ListOf< Lazy< IfcRepresentation >, 1, 0 > Representations;
    };

    // C++ wrapper for IfcStackTerminalType
    struct IfcStackTerminalType : IfcFlowTerminalType, ObjectHelper<IfcStackTerminalType,1> { IfcStackTerminalType() : Object("IfcStackTerminalType") {}
		IfcStackTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcReinforcingElement
    struct IfcReinforcingElement : IfcBuildingElementComponent, ObjectHelper<IfcReinforcingElement,1> { IfcReinforcingElement() : Object("IfcReinforcingElement") {}
		Maybe< IfcLabel::Out > SteelGrade;
    };

    // C++ wrapper for IfcReinforcingMesh
    struct IfcReinforcingMesh : IfcReinforcingElement, ObjectHelper<IfcReinforcingMesh,8> { IfcReinforcingMesh() : Object("IfcReinforcingMesh") {}
		Maybe< IfcPositiveLengthMeasure::Out > MeshLength;
		Maybe< IfcPositiveLengthMeasure::Out > MeshWidth;
		IfcPositiveLengthMeasure::Out LongitudinalBarNominalDiameter;
		IfcPositiveLengthMeasure::Out TransverseBarNominalDiameter;
		IfcAreaMeasure::Out LongitudinalBarCrossSectionArea;
		IfcAreaMeasure::Out TransverseBarCrossSectionArea;
		IfcPositiveLengthMeasure::Out LongitudinalBarSpacing;
		IfcPositiveLengthMeasure::Out TransverseBarSpacing;
    };

    // C++ wrapper for IfcOrderAction
    struct IfcOrderAction : IfcTask, ObjectHelper<IfcOrderAction,1> { IfcOrderAction() : Object("IfcOrderAction") {}
		IfcIdentifier::Out ActionID;
    };

    // C++ wrapper for IfcLightSource
    struct IfcLightSource : IfcGeometricRepresentationItem, ObjectHelper<IfcLightSource,4> { IfcLightSource() : Object("IfcLightSource") {}
		Maybe< IfcLabel::Out > Name;
		Lazy< IfcColourRgb > LightColour;
		Maybe< IfcNormalisedRatioMeasure::Out > AmbientIntensity;
		Maybe< IfcNormalisedRatioMeasure::Out > Intensity;
    };

    // C++ wrapper for IfcLightSourceDirectional
    struct IfcLightSourceDirectional : IfcLightSource, ObjectHelper<IfcLightSourceDirectional,1> { IfcLightSourceDirectional() : Object("IfcLightSourceDirectional") {}
		Lazy< IfcDirection > Orientation;
    };

    // C++ wrapper for IfcLoop
    struct IfcLoop : IfcTopologicalRepresentationItem, ObjectHelper<IfcLoop,0> { IfcLoop() : Object("IfcLoop") {}

    };

    // C++ wrapper for IfcVertexLoop
    struct IfcVertexLoop : IfcLoop, ObjectHelper<IfcVertexLoop,1> { IfcVertexLoop() : Object("IfcVertexLoop") {}
		Lazy< IfcVertex > LoopVertex;
    };

    // C++ wrapper for IfcChamferEdgeFeature
    struct IfcChamferEdgeFeature : IfcEdgeFeature, ObjectHelper<IfcChamferEdgeFeature,2> { IfcChamferEdgeFeature() : Object("IfcChamferEdgeFeature") {}
		Maybe< IfcPositiveLengthMeasure::Out > Width;
		Maybe< IfcPositiveLengthMeasure::Out > Height;
    };

    // C++ wrapper for IfcElementComponentType
    struct IfcElementComponentType : IfcElementType, ObjectHelper<IfcElementComponentType,0> { IfcElementComponentType() : Object("IfcElementComponentType") {}

    };

    // C++ wrapper for IfcFastenerType
    struct IfcFastenerType : IfcElementComponentType, ObjectHelper<IfcFastenerType,0> { IfcFastenerType() : Object("IfcFastenerType") {}

    };

    // C++ wrapper for IfcMechanicalFastenerType
    struct IfcMechanicalFastenerType : IfcFastenerType, ObjectHelper<IfcMechanicalFastenerType,0> { IfcMechanicalFastenerType() : Object("IfcMechanicalFastenerType") {}

    };

    // C++ wrapper for IfcScheduleTimeControl
    struct IfcScheduleTimeControl : IfcControl, ObjectHelper<IfcScheduleTimeControl,18> { IfcScheduleTimeControl() : Object("IfcScheduleTimeControl") {}
		Maybe< IfcDateTimeSelect::Out > ActualStart;
		Maybe< IfcDateTimeSelect::Out > EarlyStart;
		Maybe< IfcDateTimeSelect::Out > LateStart;
		Maybe< IfcDateTimeSelect::Out > ScheduleStart;
		Maybe< IfcDateTimeSelect::Out > ActualFinish;
		Maybe< IfcDateTimeSelect::Out > EarlyFinish;
		Maybe< IfcDateTimeSelect::Out > LateFinish;
		Maybe< IfcDateTimeSelect::Out > ScheduleFinish;
		Maybe< IfcTimeMeasure::Out > ScheduleDuration;
		Maybe< IfcTimeMeasure::Out > ActualDuration;
		Maybe< IfcTimeMeasure::Out > RemainingTime;
		Maybe< IfcTimeMeasure::Out > FreeFloat;
		Maybe< IfcTimeMeasure::Out > TotalFloat;
		Maybe< BOOLEAN::Out > IsCritical;
		Maybe< IfcDateTimeSelect::Out > StatusTime;
		Maybe< IfcTimeMeasure::Out > StartFloat;
		Maybe< IfcTimeMeasure::Out > FinishFloat;
		Maybe< IfcPositiveRatioMeasure::Out > Completion;
    };

    // C++ wrapper for IfcSurfaceStyle
    struct IfcSurfaceStyle : IfcPresentationStyle, ObjectHelper<IfcSurfaceStyle,2> { IfcSurfaceStyle() : Object("IfcSurfaceStyle") {}
		IfcSurfaceSide::Out Side;
		ListOf< IfcSurfaceStyleElementSelect, 1, 5 >::Out Styles;
    };

    // C++ wrapper for IfcOpenShell
    struct IfcOpenShell : IfcConnectedFaceSet, ObjectHelper<IfcOpenShell,0> { IfcOpenShell() : Object("IfcOpenShell") {}

    };

    // C++ wrapper for IfcSubContractResource
    struct IfcSubContractResource : IfcConstructionResource, ObjectHelper<IfcSubContractResource,2> { IfcSubContractResource() : Object("IfcSubContractResource") {}
		Maybe< IfcActorSelect::Out > SubContractor;
		Maybe< IfcText::Out > JobDescription;
    };

    // C++ wrapper for IfcSweptDiskSolid
    struct IfcSweptDiskSolid : IfcSolidModel, ObjectHelper<IfcSweptDiskSolid,5> { IfcSweptDiskSolid() : Object("IfcSweptDiskSolid") {}
		Lazy< IfcCurve > Directrix;
		IfcPositiveLengthMeasure::Out Radius;
		Maybe< IfcPositiveLengthMeasure::Out > InnerRadius;
		IfcParameterValue::Out StartParam;
		IfcParameterValue::Out EndParam;
    };

    // C++ wrapper for IfcCompositeProfileDef
    struct IfcCompositeProfileDef : IfcProfileDef, ObjectHelper<IfcCompositeProfileDef,2> { IfcCompositeProfileDef() : Object("IfcCompositeProfileDef") {}
		ListOf< Lazy< IfcProfileDef >, 2, 0 > Profiles;
		Maybe< IfcLabel::Out > Label;
    };

    // C++ wrapper for IfcTankType
    struct IfcTankType : IfcFlowStorageDeviceType, ObjectHelper<IfcTankType,1> { IfcTankType() : Object("IfcTankType") {}
		IfcTankTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSphere
    struct IfcSphere : IfcCsgPrimitive3D, ObjectHelper<IfcSphere,1> { IfcSphere() : Object("IfcSphere") {}
		IfcPositiveLengthMeasure::Out Radius;
    };

    // C++ wrapper for IfcPolyLoop
    struct IfcPolyLoop : IfcLoop, ObjectHelper<IfcPolyLoop,1> { IfcPolyLoop() : Object("IfcPolyLoop") {}
		ListOf< Lazy< IfcCartesianPoint >, 3, 0 > Polygon;
    };

    // C++ wrapper for IfcCableCarrierFittingType
    struct IfcCableCarrierFittingType : IfcFlowFittingType, ObjectHelper<IfcCableCarrierFittingType,1> { IfcCableCarrierFittingType() : Object("IfcCableCarrierFittingType") {}
		IfcCableCarrierFittingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcHumidifierType
    struct IfcHumidifierType : IfcEnergyConversionDeviceType, ObjectHelper<IfcHumidifierType,1> { IfcHumidifierType() : Object("IfcHumidifierType") {}
		IfcHumidifierTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPerformanceHistory
    struct IfcPerformanceHistory : IfcControl, ObjectHelper<IfcPerformanceHistory,1> { IfcPerformanceHistory() : Object("IfcPerformanceHistory") {}
		IfcLabel::Out LifeCyclePhase;
    };

    // C++ wrapper for IfcShapeModel
    struct IfcShapeModel : IfcRepresentation, ObjectHelper<IfcShapeModel,0> { IfcShapeModel() : Object("IfcShapeModel") {}

    };

    // C++ wrapper for IfcTopologyRepresentation
    struct IfcTopologyRepresentation : IfcShapeModel, ObjectHelper<IfcTopologyRepresentation,0> { IfcTopologyRepresentation() : Object("IfcTopologyRepresentation") {}

    };

    // C++ wrapper for IfcBuilding
    struct IfcBuilding : IfcSpatialStructureElement, ObjectHelper<IfcBuilding,3> { IfcBuilding() : Object("IfcBuilding") {}
		Maybe< IfcLengthMeasure::Out > ElevationOfRefHeight;
		Maybe< IfcLengthMeasure::Out > ElevationOfTerrain;
		Maybe< Lazy< NotImplemented > > BuildingAddress;
    };

    // C++ wrapper for IfcRoundedRectangleProfileDef
    struct IfcRoundedRectangleProfileDef : IfcRectangleProfileDef, ObjectHelper<IfcRoundedRectangleProfileDef,1> { IfcRoundedRectangleProfileDef() : Object("IfcRoundedRectangleProfileDef") {}
		IfcPositiveLengthMeasure::Out RoundingRadius;
    };

    // C++ wrapper for IfcStairFlight
    struct IfcStairFlight : IfcBuildingElement, ObjectHelper<IfcStairFlight,4> { IfcStairFlight() : Object("IfcStairFlight") {}
		Maybe< INTEGER::Out > NumberOfRiser;
		Maybe< INTEGER::Out > NumberOfTreads;
		Maybe< IfcPositiveLengthMeasure::Out > RiserHeight;
		Maybe< IfcPositiveLengthMeasure::Out > TreadLength;
    };

    // C++ wrapper for IfcDistributionChamberElement
    struct IfcDistributionChamberElement : IfcDistributionFlowElement, ObjectHelper<IfcDistributionChamberElement,0> { IfcDistributionChamberElement() : Object("IfcDistributionChamberElement") {}

    };

    // C++ wrapper for IfcShapeRepresentation
    struct IfcShapeRepresentation : IfcShapeModel, ObjectHelper<IfcShapeRepresentation,0> { IfcShapeRepresentation() : Object("IfcShapeRepresentation") {}

    };

    // C++ wrapper for IfcRampFlight
    struct IfcRampFlight : IfcBuildingElement, ObjectHelper<IfcRampFlight,0> { IfcRampFlight() : Object("IfcRampFlight") {}

    };

    // C++ wrapper for IfcBeamType
    struct IfcBeamType : IfcBuildingElementType, ObjectHelper<IfcBeamType,1> { IfcBeamType() : Object("IfcBeamType") {}
		IfcBeamTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcRelDecomposes
    struct IfcRelDecomposes : IfcRelationship, ObjectHelper<IfcRelDecomposes,2> { IfcRelDecomposes() : Object("IfcRelDecomposes") {}
		Lazy< IfcObjectDefinition > RelatingObject;
		ListOf< Lazy< IfcObjectDefinition >, 1, 0 > RelatedObjects;
    };

    // C++ wrapper for IfcRoof
    struct IfcRoof : IfcBuildingElement, ObjectHelper<IfcRoof,1> { IfcRoof() : Object("IfcRoof") {}
		IfcRoofTypeEnum::Out ShapeType;
    };

    // C++ wrapper for IfcFooting
    struct IfcFooting : IfcBuildingElement, ObjectHelper<IfcFooting,1> { IfcFooting() : Object("IfcFooting") {}
		IfcFootingTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLightSourceAmbient
    struct IfcLightSourceAmbient : IfcLightSource, ObjectHelper<IfcLightSourceAmbient,0> { IfcLightSourceAmbient() : Object("IfcLightSourceAmbient") {}

    };

    // C++ wrapper for IfcWindowStyle
    struct IfcWindowStyle : IfcTypeProduct, ObjectHelper<IfcWindowStyle,4> { IfcWindowStyle() : Object("IfcWindowStyle") {}
		IfcWindowStyleConstructionEnum::Out ConstructionType;
		IfcWindowStyleOperationEnum::Out OperationType;
		BOOLEAN::Out ParameterTakesPrecedence;
		BOOLEAN::Out Sizeable;
    };

    // C++ wrapper for IfcBuildingElementProxyType
    struct IfcBuildingElementProxyType : IfcBuildingElementType, ObjectHelper<IfcBuildingElementProxyType,1> { IfcBuildingElementProxyType() : Object("IfcBuildingElementProxyType") {}
		IfcBuildingElementProxyTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAxis2Placement3D
    struct IfcAxis2Placement3D : IfcPlacement, ObjectHelper<IfcAxis2Placement3D,2> { IfcAxis2Placement3D() : Object("IfcAxis2Placement3D") {}
		Maybe< Lazy< IfcDirection > > Axis;
		Maybe< Lazy< IfcDirection > > RefDirection;
    };

    // C++ wrapper for IfcEdgeCurve
    struct IfcEdgeCurve : IfcEdge, ObjectHelper<IfcEdgeCurve,2> { IfcEdgeCurve() : Object("IfcEdgeCurve") {}
		Lazy< IfcCurve > EdgeGeometry;
		BOOLEAN::Out SameSense;
    };

    // C++ wrapper for IfcClosedShell
    struct IfcClosedShell : IfcConnectedFaceSet, ObjectHelper<IfcClosedShell,0> { IfcClosedShell() : Object("IfcClosedShell") {}

    };

    // C++ wrapper for IfcTendonAnchor
    struct IfcTendonAnchor : IfcReinforcingElement, ObjectHelper<IfcTendonAnchor,0> { IfcTendonAnchor() : Object("IfcTendonAnchor") {}

    };

    // C++ wrapper for IfcCondenserType
    struct IfcCondenserType : IfcEnergyConversionDeviceType, ObjectHelper<IfcCondenserType,1> { IfcCondenserType() : Object("IfcCondenserType") {}
		IfcCondenserTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPipeSegmentType
    struct IfcPipeSegmentType : IfcFlowSegmentType, ObjectHelper<IfcPipeSegmentType,1> { IfcPipeSegmentType() : Object("IfcPipeSegmentType") {}
		IfcPipeSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPointOnSurface
    struct IfcPointOnSurface : IfcPoint, ObjectHelper<IfcPointOnSurface,3> { IfcPointOnSurface() : Object("IfcPointOnSurface") {}
		Lazy< IfcSurface > BasisSurface;
		IfcParameterValue::Out PointParameterU;
		IfcParameterValue::Out PointParameterV;
    };

    // C++ wrapper for IfcAsset
    struct IfcAsset : IfcGroup, ObjectHelper<IfcAsset,9> { IfcAsset() : Object("IfcAsset") {}
		IfcIdentifier::Out AssetID;
		Lazy< NotImplemented > OriginalValue;
		Lazy< NotImplemented > CurrentValue;
		Lazy< NotImplemented > TotalReplacementCost;
		IfcActorSelect::Out Owner;
		IfcActorSelect::Out User;
		Lazy< NotImplemented > ResponsiblePerson;
		Lazy< NotImplemented > IncorporationDate;
		Lazy< NotImplemented > DepreciatedValue;
    };

    // C++ wrapper for IfcLightSourcePositional
    struct IfcLightSourcePositional : IfcLightSource, ObjectHelper<IfcLightSourcePositional,5> { IfcLightSourcePositional() : Object("IfcLightSourcePositional") {}
		Lazy< IfcCartesianPoint > Position;
		IfcPositiveLengthMeasure::Out Radius;
		IfcReal::Out ConstantAttenuation;
		IfcReal::Out DistanceAttenuation;
		IfcReal::Out QuadricAttenuation;
    };

    // C++ wrapper for IfcProjectionCurve
    struct IfcProjectionCurve : IfcAnnotationCurveOccurrence, ObjectHelper<IfcProjectionCurve,0> { IfcProjectionCurve() : Object("IfcProjectionCurve") {}

    };

    // C++ wrapper for IfcFillAreaStyleTiles
    struct IfcFillAreaStyleTiles : IfcGeometricRepresentationItem, ObjectHelper<IfcFillAreaStyleTiles,3> { IfcFillAreaStyleTiles() : Object("IfcFillAreaStyleTiles") {}
		Lazy< IfcOneDirectionRepeatFactor > TilingPattern;
		ListOf< IfcFillAreaStyleTileShapeSelect, 1, 0 >::Out Tiles;
		IfcPositiveRatioMeasure::Out TilingScale;
    };

    // C++ wrapper for IfcRelFillsElement
    struct IfcRelFillsElement : IfcRelConnects, ObjectHelper<IfcRelFillsElement,2> { IfcRelFillsElement() : Object("IfcRelFillsElement") {}
		Lazy< IfcOpeningElement > RelatingOpeningElement;
		Lazy< IfcElement > RelatedBuildingElement;
    };

    // C++ wrapper for IfcElectricMotorType
    struct IfcElectricMotorType : IfcEnergyConversionDeviceType, ObjectHelper<IfcElectricMotorType,1> { IfcElectricMotorType() : Object("IfcElectricMotorType") {}
		IfcElectricMotorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTendon
    struct IfcTendon : IfcReinforcingElement, ObjectHelper<IfcTendon,8> { IfcTendon() : Object("IfcTendon") {}
		IfcTendonTypeEnum::Out PredefinedType;
		IfcPositiveLengthMeasure::Out NominalDiameter;
		IfcAreaMeasure::Out CrossSectionArea;
		Maybe< IfcForceMeasure::Out > TensionForce;
		Maybe< IfcPressureMeasure::Out > PreStress;
		Maybe< IfcNormalisedRatioMeasure::Out > FrictionCoefficient;
		Maybe< IfcPositiveLengthMeasure::Out > AnchorageSlip;
		Maybe< IfcPositiveLengthMeasure::Out > MinCurvatureRadius;
    };

    // C++ wrapper for IfcDistributionChamberElementType
    struct IfcDistributionChamberElementType : IfcDistributionFlowElementType, ObjectHelper<IfcDistributionChamberElementType,1> { IfcDistributionChamberElementType() : Object("IfcDistributionChamberElementType") {}
		IfcDistributionChamberElementTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcMemberType
    struct IfcMemberType : IfcBuildingElementType, ObjectHelper<IfcMemberType,1> { IfcMemberType() : Object("IfcMemberType") {}
		IfcMemberTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcStructuralLinearAction
    struct IfcStructuralLinearAction : IfcStructuralAction, ObjectHelper<IfcStructuralLinearAction,1> { IfcStructuralLinearAction() : Object("IfcStructuralLinearAction") {}
		IfcProjectedOrTrueLengthEnum::Out ProjectedOrTrue;
    };

    // C++ wrapper for IfcStructuralLinearActionVarying
    struct IfcStructuralLinearActionVarying : IfcStructuralLinearAction, ObjectHelper<IfcStructuralLinearActionVarying,2> { IfcStructuralLinearActionVarying() : Object("IfcStructuralLinearActionVarying") {}
		Lazy< NotImplemented > VaryingAppliedLoadLocation;
		ListOf< Lazy< NotImplemented >, 1, 0 > SubsequentAppliedLoads;
    };

    // C++ wrapper for IfcProductDefinitionShape
    struct IfcProductDefinitionShape : IfcProductRepresentation, ObjectHelper<IfcProductDefinitionShape,0> { IfcProductDefinitionShape() : Object("IfcProductDefinitionShape") {}

    };

    // C++ wrapper for IfcFastener
    struct IfcFastener : IfcElementComponent, ObjectHelper<IfcFastener,0> { IfcFastener() : Object("IfcFastener") {}

    };

    // C++ wrapper for IfcMechanicalFastener
    struct IfcMechanicalFastener : IfcFastener, ObjectHelper<IfcMechanicalFastener,2> { IfcMechanicalFastener() : Object("IfcMechanicalFastener") {}
		Maybe< IfcPositiveLengthMeasure::Out > NominalDiameter;
		Maybe< IfcPositiveLengthMeasure::Out > NominalLength;
    };

    // C++ wrapper for IfcEvaporatorType
    struct IfcEvaporatorType : IfcEnergyConversionDeviceType, ObjectHelper<IfcEvaporatorType,1> { IfcEvaporatorType() : Object("IfcEvaporatorType") {}
		IfcEvaporatorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDiscreteAccessoryType
    struct IfcDiscreteAccessoryType : IfcElementComponentType, ObjectHelper<IfcDiscreteAccessoryType,0> { IfcDiscreteAccessoryType() : Object("IfcDiscreteAccessoryType") {}

    };

    // C++ wrapper for IfcStructuralCurveConnection
    struct IfcStructuralCurveConnection : IfcStructuralConnection, ObjectHelper<IfcStructuralCurveConnection,0> { IfcStructuralCurveConnection() : Object("IfcStructuralCurveConnection") {}

    };

    // C++ wrapper for IfcProjectionElement
    struct IfcProjectionElement : IfcFeatureElementAddition, ObjectHelper<IfcProjectionElement,0> { IfcProjectionElement() : Object("IfcProjectionElement") {}

    };

    // C++ wrapper for IfcCoveringType
    struct IfcCoveringType : IfcBuildingElementType, ObjectHelper<IfcCoveringType,1> { IfcCoveringType() : Object("IfcCoveringType") {}
		IfcCoveringTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPumpType
    struct IfcPumpType : IfcFlowMovingDeviceType, ObjectHelper<IfcPumpType,1> { IfcPumpType() : Object("IfcPumpType") {}
		IfcPumpTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPile
    struct IfcPile : IfcBuildingElement, ObjectHelper<IfcPile,2> { IfcPile() : Object("IfcPile") {}
		IfcPileTypeEnum::Out PredefinedType;
		Maybe< IfcPileConstructionEnum::Out > ConstructionType;
    };

    // C++ wrapper for IfcUnitAssignment
    struct IfcUnitAssignment :  ObjectHelper<IfcUnitAssignment,1> { IfcUnitAssignment() : Object("IfcUnitAssignment") {}
		ListOf< IfcUnit, 1, 0 >::Out Units;
    };

    // C++ wrapper for IfcBoundingBox
    struct IfcBoundingBox : IfcGeometricRepresentationItem, ObjectHelper<IfcBoundingBox,4> { IfcBoundingBox() : Object("IfcBoundingBox") {}
		Lazy< IfcCartesianPoint > Corner;
		IfcPositiveLengthMeasure::Out XDim;
		IfcPositiveLengthMeasure::Out YDim;
		IfcPositiveLengthMeasure::Out ZDim;
    };

    // C++ wrapper for IfcShellBasedSurfaceModel
    struct IfcShellBasedSurfaceModel : IfcGeometricRepresentationItem, ObjectHelper<IfcShellBasedSurfaceModel,1> { IfcShellBasedSurfaceModel() : Object("IfcShellBasedSurfaceModel") {}
		ListOf< IfcShell, 1, 0 >::Out SbsmBoundary;
    };

    // C++ wrapper for IfcFacetedBrep
    struct IfcFacetedBrep : IfcManifoldSolidBrep, ObjectHelper<IfcFacetedBrep,0> { IfcFacetedBrep() : Object("IfcFacetedBrep") {}

    };

    // C++ wrapper for IfcTextLiteralWithExtent
    struct IfcTextLiteralWithExtent : IfcTextLiteral, ObjectHelper<IfcTextLiteralWithExtent,2> { IfcTextLiteralWithExtent() : Object("IfcTextLiteralWithExtent") {}
		Lazy< IfcPlanarExtent > Extent;
		IfcBoxAlignment::Out BoxAlignment;
    };

    // C++ wrapper for IfcElectricApplianceType
    struct IfcElectricApplianceType : IfcFlowTerminalType, ObjectHelper<IfcElectricApplianceType,1> { IfcElectricApplianceType() : Object("IfcElectricApplianceType") {}
		IfcElectricApplianceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTrapeziumProfileDef
    struct IfcTrapeziumProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcTrapeziumProfileDef,4> { IfcTrapeziumProfileDef() : Object("IfcTrapeziumProfileDef") {}
		IfcPositiveLengthMeasure::Out BottomXDim;
		IfcPositiveLengthMeasure::Out TopXDim;
		IfcPositiveLengthMeasure::Out YDim;
		IfcLengthMeasure::Out TopXOffset;
    };

    // C++ wrapper for IfcRelContainedInSpatialStructure
    struct IfcRelContainedInSpatialStructure : IfcRelConnects, ObjectHelper<IfcRelContainedInSpatialStructure,2> { IfcRelContainedInSpatialStructure() : Object("IfcRelContainedInSpatialStructure") {}
		ListOf< Lazy< IfcProduct >, 1, 0 > RelatedElements;
		Lazy< IfcSpatialStructureElement > RelatingStructure;
    };

    // C++ wrapper for IfcEdgeLoop
    struct IfcEdgeLoop : IfcLoop, ObjectHelper<IfcEdgeLoop,1> { IfcEdgeLoop() : Object("IfcEdgeLoop") {}
		ListOf< Lazy< IfcOrientedEdge >, 1, 0 > EdgeList;
    };

    // C++ wrapper for IfcProject
    struct IfcProject : IfcObject, ObjectHelper<IfcProject,4> { IfcProject() : Object("IfcProject") {}
		Maybe< IfcLabel::Out > LongName;
		Maybe< IfcLabel::Out > Phase;
		ListOf< Lazy< IfcRepresentationContext >, 1, 0 > RepresentationContexts;
		Lazy< IfcUnitAssignment > UnitsInContext;
    };

    // C++ wrapper for IfcCartesianPoint
    struct IfcCartesianPoint : IfcPoint, ObjectHelper<IfcCartesianPoint,1> { IfcCartesianPoint() : Object("IfcCartesianPoint") {}
		ListOf< IfcLengthMeasure, 1, 3 >::Out Coordinates;
    };

    // C++ wrapper for IfcCurveBoundedPlane
    struct IfcCurveBoundedPlane : IfcBoundedSurface, ObjectHelper<IfcCurveBoundedPlane,3> { IfcCurveBoundedPlane() : Object("IfcCurveBoundedPlane") {}
		Lazy< IfcPlane > BasisSurface;
		Lazy< IfcCurve > OuterBoundary;
		ListOf< Lazy< IfcCurve >, 0, 0 > InnerBoundaries;
    };

    // C++ wrapper for IfcWallType
    struct IfcWallType : IfcBuildingElementType, ObjectHelper<IfcWallType,1> { IfcWallType() : Object("IfcWallType") {}
		IfcWallTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFillAreaStyleHatching
    struct IfcFillAreaStyleHatching : IfcGeometricRepresentationItem, ObjectHelper<IfcFillAreaStyleHatching,5> { IfcFillAreaStyleHatching() : Object("IfcFillAreaStyleHatching") {}
		Lazy< NotImplemented > HatchLineAppearance;
		IfcHatchLineDistanceSelect::Out StartOfNextHatchLine;
		Maybe< Lazy< IfcCartesianPoint > > PointOfReferenceHatchLine;
		Maybe< Lazy< IfcCartesianPoint > > PatternStart;
		IfcPlaneAngleMeasure::Out HatchLineAngle;
    };

    // C++ wrapper for IfcEquipmentStandard
    struct IfcEquipmentStandard : IfcControl, ObjectHelper<IfcEquipmentStandard,0> { IfcEquipmentStandard() : Object("IfcEquipmentStandard") {}

    };

    // C++ wrapper for IfcDiameterDimension
    struct IfcDiameterDimension : IfcDimensionCurveDirectedCallout, ObjectHelper<IfcDiameterDimension,0> { IfcDiameterDimension() : Object("IfcDiameterDimension") {}

    };

    // C++ wrapper for IfcStructuralLoadGroup
    struct IfcStructuralLoadGroup : IfcGroup, ObjectHelper<IfcStructuralLoadGroup,5> { IfcStructuralLoadGroup() : Object("IfcStructuralLoadGroup") {}
		IfcLoadGroupTypeEnum::Out PredefinedType;
		IfcActionTypeEnum::Out ActionType;
		IfcActionSourceTypeEnum::Out ActionSource;
		Maybe< IfcPositiveRatioMeasure::Out > Coefficient;
		Maybe< IfcLabel::Out > Purpose;
    };

    // C++ wrapper for IfcConstructionMaterialResource
    struct IfcConstructionMaterialResource : IfcConstructionResource, ObjectHelper<IfcConstructionMaterialResource,2> { IfcConstructionMaterialResource() : Object("IfcConstructionMaterialResource") {}
		Maybe< ListOf< IfcActorSelect, 1, 0 >::Out > Suppliers;
		Maybe< IfcRatioMeasure::Out > UsageRatio;
    };

    // C++ wrapper for IfcRelAggregates
    struct IfcRelAggregates : IfcRelDecomposes, ObjectHelper<IfcRelAggregates,0> { IfcRelAggregates() : Object("IfcRelAggregates") {}

    };

    // C++ wrapper for IfcBoilerType
    struct IfcBoilerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcBoilerType,1> { IfcBoilerType() : Object("IfcBoilerType") {}
		IfcBoilerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcColourRgb
    struct IfcColourRgb : IfcColourSpecification, ObjectHelper<IfcColourRgb,3> { IfcColourRgb() : Object("IfcColourRgb") {}
		IfcNormalisedRatioMeasure::Out Red;
		IfcNormalisedRatioMeasure::Out Green;
		IfcNormalisedRatioMeasure::Out Blue;
    };

    // C++ wrapper for IfcDoorStyle
    struct IfcDoorStyle : IfcTypeProduct, ObjectHelper<IfcDoorStyle,4> { IfcDoorStyle() : Object("IfcDoorStyle") {}
		IfcDoorStyleOperationEnum::Out OperationType;
		IfcDoorStyleConstructionEnum::Out ConstructionType;
		BOOLEAN::Out ParameterTakesPrecedence;
		BOOLEAN::Out Sizeable;
    };

    // C++ wrapper for IfcDuctSilencerType
    struct IfcDuctSilencerType : IfcFlowTreatmentDeviceType, ObjectHelper<IfcDuctSilencerType,1> { IfcDuctSilencerType() : Object("IfcDuctSilencerType") {}
		IfcDuctSilencerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLightSourceGoniometric
    struct IfcLightSourceGoniometric : IfcLightSource, ObjectHelper<IfcLightSourceGoniometric,6> { IfcLightSourceGoniometric() : Object("IfcLightSourceGoniometric") {}
		Lazy< IfcAxis2Placement3D > Position;
		Maybe< Lazy< IfcColourRgb > > ColourAppearance;
		IfcThermodynamicTemperatureMeasure::Out ColourTemperature;
		IfcLuminousFluxMeasure::Out LuminousFlux;
		IfcLightEmissionSourceEnum::Out LightEmissionSource;
		IfcLightDistributionDataSourceSelect::Out LightDistributionDataSource;
    };

    // C++ wrapper for IfcActuatorType
    struct IfcActuatorType : IfcDistributionControlElementType, ObjectHelper<IfcActuatorType,1> { IfcActuatorType() : Object("IfcActuatorType") {}
		IfcActuatorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcSensorType
    struct IfcSensorType : IfcDistributionControlElementType, ObjectHelper<IfcSensorType,1> { IfcSensorType() : Object("IfcSensorType") {}
		IfcSensorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAirTerminalBoxType
    struct IfcAirTerminalBoxType : IfcFlowControllerType, ObjectHelper<IfcAirTerminalBoxType,1> { IfcAirTerminalBoxType() : Object("IfcAirTerminalBoxType") {}
		IfcAirTerminalBoxTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAnnotationSurfaceOccurrence
    struct IfcAnnotationSurfaceOccurrence : IfcAnnotationOccurrence, ObjectHelper<IfcAnnotationSurfaceOccurrence,0> { IfcAnnotationSurfaceOccurrence() : Object("IfcAnnotationSurfaceOccurrence") {}

    };

    // C++ wrapper for IfcRationalBezierCurve
    struct IfcRationalBezierCurve : IfcBezierCurve, ObjectHelper<IfcRationalBezierCurve,1> { IfcRationalBezierCurve() : Object("IfcRationalBezierCurve") {}
		ListOf< REAL, 2, 0 >::Out WeightsData;
    };

    // C++ wrapper for IfcCartesianTransformationOperator2D
    struct IfcCartesianTransformationOperator2D : IfcCartesianTransformationOperator, ObjectHelper<IfcCartesianTransformationOperator2D,0> { IfcCartesianTransformationOperator2D() : Object("IfcCartesianTransformationOperator2D") {}

    };

    // C++ wrapper for IfcCartesianTransformationOperator2DnonUniform
    struct IfcCartesianTransformationOperator2DnonUniform : IfcCartesianTransformationOperator2D, ObjectHelper<IfcCartesianTransformationOperator2DnonUniform,1> { IfcCartesianTransformationOperator2DnonUniform() : Object("IfcCartesianTransformationOperator2DnonUniform") {}
		Maybe< REAL::Out > Scale2;
    };

    // C++ wrapper for IfcMove
    struct IfcMove : IfcTask, ObjectHelper<IfcMove,3> { IfcMove() : Object("IfcMove") {}
		Lazy< IfcSpatialStructureElement > MoveFrom;
		Lazy< IfcSpatialStructureElement > MoveTo;
		Maybe< ListOf< IfcText, 1, 0 >::Out > PunchList;
    };

    // C++ wrapper for IfcCableCarrierSegmentType
    struct IfcCableCarrierSegmentType : IfcFlowSegmentType, ObjectHelper<IfcCableCarrierSegmentType,1> { IfcCableCarrierSegmentType() : Object("IfcCableCarrierSegmentType") {}
		IfcCableCarrierSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricalElement
    struct IfcElectricalElement : IfcElement, ObjectHelper<IfcElectricalElement,0> { IfcElectricalElement() : Object("IfcElectricalElement") {}

    };

    // C++ wrapper for IfcChillerType
    struct IfcChillerType : IfcEnergyConversionDeviceType, ObjectHelper<IfcChillerType,1> { IfcChillerType() : Object("IfcChillerType") {}
		IfcChillerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcReinforcingBar
    struct IfcReinforcingBar : IfcReinforcingElement, ObjectHelper<IfcReinforcingBar,5> { IfcReinforcingBar() : Object("IfcReinforcingBar") {}
		IfcPositiveLengthMeasure::Out NominalDiameter;
		IfcAreaMeasure::Out CrossSectionArea;
		Maybe< IfcPositiveLengthMeasure::Out > BarLength;
		IfcReinforcingBarRoleEnum::Out BarRole;
		Maybe< IfcReinforcingBarSurfaceEnum::Out > BarSurface;
    };

    // C++ wrapper for IfcCShapeProfileDef
    struct IfcCShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcCShapeProfileDef,6> { IfcCShapeProfileDef() : Object("IfcCShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out Width;
		IfcPositiveLengthMeasure::Out WallThickness;
		IfcPositiveLengthMeasure::Out Girth;
		Maybe< IfcPositiveLengthMeasure::Out > InternalFilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInX;
    };

    // C++ wrapper for IfcPermit
    struct IfcPermit : IfcControl, ObjectHelper<IfcPermit,1> { IfcPermit() : Object("IfcPermit") {}
		IfcIdentifier::Out PermitID;
    };

    // C++ wrapper for IfcSlabType
    struct IfcSlabType : IfcBuildingElementType, ObjectHelper<IfcSlabType,1> { IfcSlabType() : Object("IfcSlabType") {}
		IfcSlabTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcLampType
    struct IfcLampType : IfcFlowTerminalType, ObjectHelper<IfcLampType,1> { IfcLampType() : Object("IfcLampType") {}
		IfcLampTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcPlanarExtent
    struct IfcPlanarExtent : IfcGeometricRepresentationItem, ObjectHelper<IfcPlanarExtent,2> { IfcPlanarExtent() : Object("IfcPlanarExtent") {}
		IfcLengthMeasure::Out SizeInX;
		IfcLengthMeasure::Out SizeInY;
    };

    // C++ wrapper for IfcAlarmType
    struct IfcAlarmType : IfcDistributionControlElementType, ObjectHelper<IfcAlarmType,1> { IfcAlarmType() : Object("IfcAlarmType") {}
		IfcAlarmTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricFlowStorageDeviceType
    struct IfcElectricFlowStorageDeviceType : IfcFlowStorageDeviceType, ObjectHelper<IfcElectricFlowStorageDeviceType,1> { IfcElectricFlowStorageDeviceType() : Object("IfcElectricFlowStorageDeviceType") {}
		IfcElectricFlowStorageDeviceTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcEquipmentElement
    struct IfcEquipmentElement : IfcElement, ObjectHelper<IfcEquipmentElement,0> { IfcEquipmentElement() : Object("IfcEquipmentElement") {}

    };

    // C++ wrapper for IfcLightFixtureType
    struct IfcLightFixtureType : IfcFlowTerminalType, ObjectHelper<IfcLightFixtureType,1> { IfcLightFixtureType() : Object("IfcLightFixtureType") {}
		IfcLightFixtureTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCurtainWall
    struct IfcCurtainWall : IfcBuildingElement, ObjectHelper<IfcCurtainWall,0> { IfcCurtainWall() : Object("IfcCurtainWall") {}

    };

    // C++ wrapper for IfcSlab
    struct IfcSlab : IfcBuildingElement, ObjectHelper<IfcSlab,1> { IfcSlab() : Object("IfcSlab") {}
		Maybe< IfcSlabTypeEnum::Out > PredefinedType;
    };

    // C++ wrapper for IfcCurtainWallType
    struct IfcCurtainWallType : IfcBuildingElementType, ObjectHelper<IfcCurtainWallType,1> { IfcCurtainWallType() : Object("IfcCurtainWallType") {}
		IfcCurtainWallTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcOutletType
    struct IfcOutletType : IfcFlowTerminalType, ObjectHelper<IfcOutletType,1> { IfcOutletType() : Object("IfcOutletType") {}
		IfcOutletTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCompressorType
    struct IfcCompressorType : IfcFlowMovingDeviceType, ObjectHelper<IfcCompressorType,1> { IfcCompressorType() : Object("IfcCompressorType") {}
		IfcCompressorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCraneRailAShapeProfileDef
    struct IfcCraneRailAShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcCraneRailAShapeProfileDef,12> { IfcCraneRailAShapeProfileDef() : Object("IfcCraneRailAShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out OverallHeight;
		IfcPositiveLengthMeasure::Out BaseWidth2;
		Maybe< IfcPositiveLengthMeasure::Out > Radius;
		IfcPositiveLengthMeasure::Out HeadWidth;
		IfcPositiveLengthMeasure::Out HeadDepth2;
		IfcPositiveLengthMeasure::Out HeadDepth3;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out BaseWidth4;
		IfcPositiveLengthMeasure::Out BaseDepth1;
		IfcPositiveLengthMeasure::Out BaseDepth2;
		IfcPositiveLengthMeasure::Out BaseDepth3;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInY;
    };

    // C++ wrapper for IfcFlowSegment
    struct IfcFlowSegment : IfcDistributionFlowElement, ObjectHelper<IfcFlowSegment,0> { IfcFlowSegment() : Object("IfcFlowSegment") {}

    };

    // C++ wrapper for IfcSectionedSpine
    struct IfcSectionedSpine : IfcGeometricRepresentationItem, ObjectHelper<IfcSectionedSpine,3> { IfcSectionedSpine() : Object("IfcSectionedSpine") {}
		Lazy< IfcCompositeCurve > SpineCurve;
		ListOf< Lazy< IfcProfileDef >, 2, 0 > CrossSections;
		ListOf< Lazy< IfcAxis2Placement3D >, 2, 0 > CrossSectionPositions;
    };

    // C++ wrapper for IfcElectricTimeControlType
    struct IfcElectricTimeControlType : IfcFlowControllerType, ObjectHelper<IfcElectricTimeControlType,1> { IfcElectricTimeControlType() : Object("IfcElectricTimeControlType") {}
		IfcElectricTimeControlTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFaceSurface
    struct IfcFaceSurface : IfcFace, ObjectHelper<IfcFaceSurface,2> { IfcFaceSurface() : Object("IfcFaceSurface") {}
		Lazy< IfcSurface > FaceSurface;
		BOOLEAN::Out SameSense;
    };

    // C++ wrapper for IfcMotorConnectionType
    struct IfcMotorConnectionType : IfcEnergyConversionDeviceType, ObjectHelper<IfcMotorConnectionType,1> { IfcMotorConnectionType() : Object("IfcMotorConnectionType") {}
		IfcMotorConnectionTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowFitting
    struct IfcFlowFitting : IfcDistributionFlowElement, ObjectHelper<IfcFlowFitting,0> { IfcFlowFitting() : Object("IfcFlowFitting") {}

    };

    // C++ wrapper for IfcPointOnCurve
    struct IfcPointOnCurve : IfcPoint, ObjectHelper<IfcPointOnCurve,2> { IfcPointOnCurve() : Object("IfcPointOnCurve") {}
		Lazy< IfcCurve > BasisCurve;
		IfcParameterValue::Out PointParameter;
    };

    // C++ wrapper for IfcTransportElementType
    struct IfcTransportElementType : IfcElementType, ObjectHelper<IfcTransportElementType,1> { IfcTransportElementType() : Object("IfcTransportElementType") {}
		IfcTransportElementTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcCableSegmentType
    struct IfcCableSegmentType : IfcFlowSegmentType, ObjectHelper<IfcCableSegmentType,1> { IfcCableSegmentType() : Object("IfcCableSegmentType") {}
		IfcCableSegmentTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAnnotationSurface
    struct IfcAnnotationSurface : IfcGeometricRepresentationItem, ObjectHelper<IfcAnnotationSurface,2> { IfcAnnotationSurface() : Object("IfcAnnotationSurface") {}
		Lazy< IfcGeometricRepresentationItem > Item;
		Maybe< Lazy< NotImplemented > > TextureCoordinates;
    };

    // C++ wrapper for IfcCompositeCurveSegment
    struct IfcCompositeCurveSegment : IfcGeometricRepresentationItem, ObjectHelper<IfcCompositeCurveSegment,3> { IfcCompositeCurveSegment() : Object("IfcCompositeCurveSegment") {}
		IfcTransitionCode::Out Transition;
		BOOLEAN::Out SameSense;
		Lazy< IfcCurve > ParentCurve;
    };

    // C++ wrapper for IfcServiceLife
    struct IfcServiceLife : IfcControl, ObjectHelper<IfcServiceLife,2> { IfcServiceLife() : Object("IfcServiceLife") {}
		IfcServiceLifeTypeEnum::Out ServiceLifeType;
		IfcTimeMeasure::Out ServiceLifeDuration;
    };

    // C++ wrapper for IfcPlateType
    struct IfcPlateType : IfcBuildingElementType, ObjectHelper<IfcPlateType,1> { IfcPlateType() : Object("IfcPlateType") {}
		IfcPlateTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcVibrationIsolatorType
    struct IfcVibrationIsolatorType : IfcDiscreteAccessoryType, ObjectHelper<IfcVibrationIsolatorType,1> { IfcVibrationIsolatorType() : Object("IfcVibrationIsolatorType") {}
		IfcVibrationIsolatorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTrimmedCurve
    struct IfcTrimmedCurve : IfcBoundedCurve, ObjectHelper<IfcTrimmedCurve,5> { IfcTrimmedCurve() : Object("IfcTrimmedCurve") {}
		Lazy< IfcCurve > BasisCurve;
		ListOf< IfcTrimmingSelect, 1, 2 >::Out Trim1;
		ListOf< IfcTrimmingSelect, 1, 2 >::Out Trim2;
		BOOLEAN::Out SenseAgreement;
		IfcTrimmingPreference::Out MasterRepresentation;
    };

    // C++ wrapper for IfcMappedItem
    struct IfcMappedItem : IfcRepresentationItem, ObjectHelper<IfcMappedItem,2> { IfcMappedItem() : Object("IfcMappedItem") {}
		Lazy< IfcRepresentationMap > MappingSource;
		Lazy< IfcCartesianTransformationOperator > MappingTarget;
    };

    // C++ wrapper for IfcDirection
    struct IfcDirection : IfcGeometricRepresentationItem, ObjectHelper<IfcDirection,1> { IfcDirection() : Object("IfcDirection") {}
		ListOf< REAL, 2, 3 >::Out DirectionRatios;
    };

    // C++ wrapper for IfcBlock
    struct IfcBlock : IfcCsgPrimitive3D, ObjectHelper<IfcBlock,3> { IfcBlock() : Object("IfcBlock") {}
		IfcPositiveLengthMeasure::Out XLength;
		IfcPositiveLengthMeasure::Out YLength;
		IfcPositiveLengthMeasure::Out ZLength;
    };

    // C++ wrapper for IfcProjectOrderRecord
    struct IfcProjectOrderRecord : IfcControl, ObjectHelper<IfcProjectOrderRecord,2> { IfcProjectOrderRecord() : Object("IfcProjectOrderRecord") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > Records;
		IfcProjectOrderRecordTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowMeterType
    struct IfcFlowMeterType : IfcFlowControllerType, ObjectHelper<IfcFlowMeterType,1> { IfcFlowMeterType() : Object("IfcFlowMeterType") {}
		IfcFlowMeterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcControllerType
    struct IfcControllerType : IfcDistributionControlElementType, ObjectHelper<IfcControllerType,1> { IfcControllerType() : Object("IfcControllerType") {}
		IfcControllerTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBeam
    struct IfcBeam : IfcBuildingElement, ObjectHelper<IfcBeam,0> { IfcBeam() : Object("IfcBeam") {}

    };

    // C++ wrapper for IfcArbitraryOpenProfileDef
    struct IfcArbitraryOpenProfileDef : IfcProfileDef, ObjectHelper<IfcArbitraryOpenProfileDef,1> { IfcArbitraryOpenProfileDef() : Object("IfcArbitraryOpenProfileDef") {}
		Lazy< IfcBoundedCurve > Curve;
    };

    // C++ wrapper for IfcCenterLineProfileDef
    struct IfcCenterLineProfileDef : IfcArbitraryOpenProfileDef, ObjectHelper<IfcCenterLineProfileDef,1> { IfcCenterLineProfileDef() : Object("IfcCenterLineProfileDef") {}
		IfcPositiveLengthMeasure::Out Thickness;
    };

    // C++ wrapper for IfcTimeSeriesSchedule
    struct IfcTimeSeriesSchedule : IfcControl, ObjectHelper<IfcTimeSeriesSchedule,3> { IfcTimeSeriesSchedule() : Object("IfcTimeSeriesSchedule") {}
		Maybe< ListOf< IfcDateTimeSelect, 1, 0 >::Out > ApplicableDates;
		IfcTimeSeriesScheduleTypeEnum::Out TimeSeriesScheduleType;
		Lazy< NotImplemented > TimeSeries;
    };

    // C++ wrapper for IfcRoundedEdgeFeature
    struct IfcRoundedEdgeFeature : IfcEdgeFeature, ObjectHelper<IfcRoundedEdgeFeature,1> { IfcRoundedEdgeFeature() : Object("IfcRoundedEdgeFeature") {}
		Maybe< IfcPositiveLengthMeasure::Out > Radius;
    };

    // C++ wrapper for IfcIShapeProfileDef
    struct IfcIShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcIShapeProfileDef,5> { IfcIShapeProfileDef() : Object("IfcIShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out OverallWidth;
		IfcPositiveLengthMeasure::Out OverallDepth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcPositiveLengthMeasure::Out > FilletRadius;
    };

    // C++ wrapper for IfcSpaceHeaterType
    struct IfcSpaceHeaterType : IfcEnergyConversionDeviceType, ObjectHelper<IfcSpaceHeaterType,1> { IfcSpaceHeaterType() : Object("IfcSpaceHeaterType") {}
		IfcSpaceHeaterTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcFlowStorageDevice
    struct IfcFlowStorageDevice : IfcDistributionFlowElement, ObjectHelper<IfcFlowStorageDevice,0> { IfcFlowStorageDevice() : Object("IfcFlowStorageDevice") {}

    };

    // C++ wrapper for IfcRevolvedAreaSolid
    struct IfcRevolvedAreaSolid : IfcSweptAreaSolid, ObjectHelper<IfcRevolvedAreaSolid,2> { IfcRevolvedAreaSolid() : Object("IfcRevolvedAreaSolid") {}
		Lazy< IfcAxis1Placement > Axis;
		IfcPlaneAngleMeasure::Out Angle;
    };

    // C++ wrapper for IfcDoor
    struct IfcDoor : IfcBuildingElement, ObjectHelper<IfcDoor,2> { IfcDoor() : Object("IfcDoor") {}
		Maybe< IfcPositiveLengthMeasure::Out > OverallHeight;
		Maybe< IfcPositiveLengthMeasure::Out > OverallWidth;
    };

    // C++ wrapper for IfcEllipse
    struct IfcEllipse : IfcConic, ObjectHelper<IfcEllipse,2> { IfcEllipse() : Object("IfcEllipse") {}
		IfcPositiveLengthMeasure::Out SemiAxis1;
		IfcPositiveLengthMeasure::Out SemiAxis2;
    };

    // C++ wrapper for IfcTubeBundleType
    struct IfcTubeBundleType : IfcEnergyConversionDeviceType, ObjectHelper<IfcTubeBundleType,1> { IfcTubeBundleType() : Object("IfcTubeBundleType") {}
		IfcTubeBundleTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcAngularDimension
    struct IfcAngularDimension : IfcDimensionCurveDirectedCallout, ObjectHelper<IfcAngularDimension,0> { IfcAngularDimension() : Object("IfcAngularDimension") {}

    };

    // C++ wrapper for IfcFaceBasedSurfaceModel
    struct IfcFaceBasedSurfaceModel : IfcGeometricRepresentationItem, ObjectHelper<IfcFaceBasedSurfaceModel,1> { IfcFaceBasedSurfaceModel() : Object("IfcFaceBasedSurfaceModel") {}
		ListOf< Lazy< IfcConnectedFaceSet >, 1, 0 > FbsmFaces;
    };

    // C++ wrapper for IfcCraneRailFShapeProfileDef
    struct IfcCraneRailFShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcCraneRailFShapeProfileDef,9> { IfcCraneRailFShapeProfileDef() : Object("IfcCraneRailFShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out OverallHeight;
		IfcPositiveLengthMeasure::Out HeadWidth;
		Maybe< IfcPositiveLengthMeasure::Out > Radius;
		IfcPositiveLengthMeasure::Out HeadDepth2;
		IfcPositiveLengthMeasure::Out HeadDepth3;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out BaseDepth1;
		IfcPositiveLengthMeasure::Out BaseDepth2;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInY;
    };

    // C++ wrapper for IfcColumnType
    struct IfcColumnType : IfcBuildingElementType, ObjectHelper<IfcColumnType,1> { IfcColumnType() : Object("IfcColumnType") {}
		IfcColumnTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcTShapeProfileDef
    struct IfcTShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcTShapeProfileDef,10> { IfcTShapeProfileDef() : Object("IfcTShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		IfcPositiveLengthMeasure::Out FlangeWidth;
		IfcPositiveLengthMeasure::Out WebThickness;
		IfcPositiveLengthMeasure::Out FlangeThickness;
		Maybe< IfcPositiveLengthMeasure::Out > FilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > FlangeEdgeRadius;
		Maybe< IfcPositiveLengthMeasure::Out > WebEdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > WebSlope;
		Maybe< IfcPlaneAngleMeasure::Out > FlangeSlope;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInY;
    };

    // C++ wrapper for IfcEnergyConversionDevice
    struct IfcEnergyConversionDevice : IfcDistributionFlowElement, ObjectHelper<IfcEnergyConversionDevice,0> { IfcEnergyConversionDevice() : Object("IfcEnergyConversionDevice") {}

    };

    // C++ wrapper for IfcWorkSchedule
    struct IfcWorkSchedule : IfcWorkControl, ObjectHelper<IfcWorkSchedule,0> { IfcWorkSchedule() : Object("IfcWorkSchedule") {}

    };

    // C++ wrapper for IfcZone
    struct IfcZone : IfcGroup, ObjectHelper<IfcZone,0> { IfcZone() : Object("IfcZone") {}

    };

    // C++ wrapper for IfcTransportElement
    struct IfcTransportElement : IfcElement, ObjectHelper<IfcTransportElement,3> { IfcTransportElement() : Object("IfcTransportElement") {}
		Maybe< IfcTransportElementTypeEnum::Out > OperationType;
		Maybe< IfcMassMeasure::Out > CapacityByWeight;
		Maybe< IfcCountMeasure::Out > CapacityByNumber;
    };

    // C++ wrapper for IfcGeometricRepresentationSubContext
    struct IfcGeometricRepresentationSubContext : IfcGeometricRepresentationContext, ObjectHelper<IfcGeometricRepresentationSubContext,4> { IfcGeometricRepresentationSubContext() : Object("IfcGeometricRepresentationSubContext") {}
		Lazy< IfcGeometricRepresentationContext > ParentContext;
		Maybe< IfcPositiveRatioMeasure::Out > TargetScale;
		IfcGeometricProjectionEnum::Out TargetView;
		Maybe< IfcLabel::Out > UserDefinedTargetView;
    };

    // C++ wrapper for IfcLShapeProfileDef
    struct IfcLShapeProfileDef : IfcParameterizedProfileDef, ObjectHelper<IfcLShapeProfileDef,8> { IfcLShapeProfileDef() : Object("IfcLShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out Depth;
		Maybe< IfcPositiveLengthMeasure::Out > Width;
		IfcPositiveLengthMeasure::Out Thickness;
		Maybe< IfcPositiveLengthMeasure::Out > FilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > EdgeRadius;
		Maybe< IfcPlaneAngleMeasure::Out > LegSlope;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInX;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInY;
    };

    // C++ wrapper for IfcGeometricCurveSet
    struct IfcGeometricCurveSet : IfcGeometricSet, ObjectHelper<IfcGeometricCurveSet,0> { IfcGeometricCurveSet() : Object("IfcGeometricCurveSet") {}

    };

    // C++ wrapper for IfcActor
    struct IfcActor : IfcObject, ObjectHelper<IfcActor,1> { IfcActor() : Object("IfcActor") {}
		IfcActorSelect::Out TheActor;
    };

    // C++ wrapper for IfcOccupant
    struct IfcOccupant : IfcActor, ObjectHelper<IfcOccupant,1> { IfcOccupant() : Object("IfcOccupant") {}
		IfcOccupantTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcBooleanClippingResult
    struct IfcBooleanClippingResult : IfcBooleanResult, ObjectHelper<IfcBooleanClippingResult,0> { IfcBooleanClippingResult() : Object("IfcBooleanClippingResult") {}

    };

    // C++ wrapper for IfcAnnotationFillArea
    struct IfcAnnotationFillArea : IfcGeometricRepresentationItem, ObjectHelper<IfcAnnotationFillArea,2> { IfcAnnotationFillArea() : Object("IfcAnnotationFillArea") {}
		Lazy< IfcCurve > OuterBoundary;
		Maybe< ListOf< Lazy< IfcCurve >, 1, 0 > > InnerBoundaries;
    };

    // C++ wrapper for IfcLightSourceSpot
    struct IfcLightSourceSpot : IfcLightSourcePositional, ObjectHelper<IfcLightSourceSpot,4> { IfcLightSourceSpot() : Object("IfcLightSourceSpot") {}
		Lazy< IfcDirection > Orientation;
		Maybe< IfcReal::Out > ConcentrationExponent;
		IfcPositivePlaneAngleMeasure::Out SpreadAngle;
		IfcPositivePlaneAngleMeasure::Out BeamWidthAngle;
    };

    // C++ wrapper for IfcFireSuppressionTerminalType
    struct IfcFireSuppressionTerminalType : IfcFlowTerminalType, ObjectHelper<IfcFireSuppressionTerminalType,1> { IfcFireSuppressionTerminalType() : Object("IfcFireSuppressionTerminalType") {}
		IfcFireSuppressionTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcElectricGeneratorType
    struct IfcElectricGeneratorType : IfcEnergyConversionDeviceType, ObjectHelper<IfcElectricGeneratorType,1> { IfcElectricGeneratorType() : Object("IfcElectricGeneratorType") {}
		IfcElectricGeneratorTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcInventory
    struct IfcInventory : IfcGroup, ObjectHelper<IfcInventory,6> { IfcInventory() : Object("IfcInventory") {}
		IfcInventoryTypeEnum::Out InventoryType;
		IfcActorSelect::Out Jurisdiction;
		ListOf< Lazy< NotImplemented >, 1, 0 > ResponsiblePersons;
		Lazy< NotImplemented > LastUpdateDate;
		Maybe< Lazy< NotImplemented > > CurrentValue;
		Maybe< Lazy< NotImplemented > > OriginalValue;
    };

    // C++ wrapper for IfcPolyline
    struct IfcPolyline : IfcBoundedCurve, ObjectHelper<IfcPolyline,1> { IfcPolyline() : Object("IfcPolyline") {}
		ListOf< Lazy< IfcCartesianPoint >, 2, 0 > Points;
    };

    // C++ wrapper for IfcBoxedHalfSpace
    struct IfcBoxedHalfSpace : IfcHalfSpaceSolid, ObjectHelper<IfcBoxedHalfSpace,1> { IfcBoxedHalfSpace() : Object("IfcBoxedHalfSpace") {}
		Lazy< IfcBoundingBox > Enclosure;
    };

    // C++ wrapper for IfcAirTerminalType
    struct IfcAirTerminalType : IfcFlowTerminalType, ObjectHelper<IfcAirTerminalType,1> { IfcAirTerminalType() : Object("IfcAirTerminalType") {}
		IfcAirTerminalTypeEnum::Out PredefinedType;
    };

    // C++ wrapper for IfcDistributionPort
    struct IfcDistributionPort : IfcPort, ObjectHelper<IfcDistributionPort,1> { IfcDistributionPort() : Object("IfcDistributionPort") {}
		Maybe< IfcFlowDirectionEnum::Out > FlowDirection;
    };

    // C++ wrapper for IfcCostItem
    struct IfcCostItem : IfcControl, ObjectHelper<IfcCostItem,0> { IfcCostItem() : Object("IfcCostItem") {}

    };

    // C++ wrapper for IfcStructuredDimensionCallout
    struct IfcStructuredDimensionCallout : IfcDraughtingCallout, ObjectHelper<IfcStructuredDimensionCallout,0> { IfcStructuredDimensionCallout() : Object("IfcStructuredDimensionCallout") {}

    };

    // C++ wrapper for IfcStructuralResultGroup
    struct IfcStructuralResultGroup : IfcGroup, ObjectHelper<IfcStructuralResultGroup,3> { IfcStructuralResultGroup() : Object("IfcStructuralResultGroup") {}
		IfcAnalysisTheoryTypeEnum::Out TheoryType;
		Maybe< Lazy< IfcStructuralLoadGroup > > ResultForLoadGroup;
		BOOLEAN::Out IsLinear;
    };

    // C++ wrapper for IfcOrientedEdge
    struct IfcOrientedEdge : IfcEdge, ObjectHelper<IfcOrientedEdge,2> { IfcOrientedEdge() : Object("IfcOrientedEdge") {}
		Lazy< IfcEdge > EdgeElement;
		BOOLEAN::Out Orientation;
    };

    // C++ wrapper for IfcCsgSolid
    struct IfcCsgSolid : IfcSolidModel, ObjectHelper<IfcCsgSolid,1> { IfcCsgSolid() : Object("IfcCsgSolid") {}
		IfcCsgSelect::Out TreeRootExpression;
    };

    // C++ wrapper for IfcPlanarBox
    struct IfcPlanarBox : IfcPlanarExtent, ObjectHelper<IfcPlanarBox,1> { IfcPlanarBox() : Object("IfcPlanarBox") {}
		IfcAxis2Placement::Out Placement;
    };

    // C++ wrapper for IfcMaterialDefinitionRepresentation
    struct IfcMaterialDefinitionRepresentation : IfcProductRepresentation, ObjectHelper<IfcMaterialDefinitionRepresentation,1> { IfcMaterialDefinitionRepresentation() : Object("IfcMaterialDefinitionRepresentation") {}
		Lazy< NotImplemented > RepresentedMaterial;
    };

    // C++ wrapper for IfcAsymmetricIShapeProfileDef
    struct IfcAsymmetricIShapeProfileDef : IfcIShapeProfileDef, ObjectHelper<IfcAsymmetricIShapeProfileDef,4> { IfcAsymmetricIShapeProfileDef() : Object("IfcAsymmetricIShapeProfileDef") {}
		IfcPositiveLengthMeasure::Out TopFlangeWidth;
		Maybe< IfcPositiveLengthMeasure::Out > TopFlangeThickness;
		Maybe< IfcPositiveLengthMeasure::Out > TopFlangeFilletRadius;
		Maybe< IfcPositiveLengthMeasure::Out > CentreOfGravityInY;
    };

    // C++ wrapper for IfcRepresentationMap
    struct IfcRepresentationMap :  ObjectHelper<IfcRepresentationMap,2> { IfcRepresentationMap() : Object("IfcRepresentationMap") {}
		IfcAxis2Placement::Out MappingOrigin;
		Lazy< IfcRepresentation > MappedRepresentation;
    };

	void GetSchema(EXPRESS::ConversionSchema& out);

} //! IFC
namespace STEP {

	// ******************************************************************************
	// Converter stubs
	// ******************************************************************************
	
#define DECL_CONV_STUB(type) template <> size_t GenericFill<IFC::type>(const STEP::DB& db, const EXPRESS::LIST& params, IFC::type* in)
	
	DECL_CONV_STUB(IfcProfileDef);
	DECL_CONV_STUB(IfcParameterizedProfileDef);
	DECL_CONV_STUB(IfcZShapeProfileDef);
	DECL_CONV_STUB(IfcRoot);
	DECL_CONV_STUB(IfcObjectDefinition);
	DECL_CONV_STUB(IfcTypeObject);
	DECL_CONV_STUB(IfcTypeProduct);
	DECL_CONV_STUB(IfcElementType);
	DECL_CONV_STUB(IfcFurnishingElementType);
	DECL_CONV_STUB(IfcFurnitureType);
	DECL_CONV_STUB(IfcObject);
	DECL_CONV_STUB(IfcProduct);
	DECL_CONV_STUB(IfcGrid);
	DECL_CONV_STUB(IfcRepresentationItem);
	DECL_CONV_STUB(IfcGeometricRepresentationItem);
	DECL_CONV_STUB(IfcOneDirectionRepeatFactor);
	DECL_CONV_STUB(IfcTwoDirectionRepeatFactor);
	DECL_CONV_STUB(IfcElement);
	DECL_CONV_STUB(IfcElementComponent);
	DECL_CONV_STUB(IfcSpatialStructureElementType);
	DECL_CONV_STUB(IfcControl);
	DECL_CONV_STUB(IfcActionRequest);
	DECL_CONV_STUB(IfcDistributionElementType);
	DECL_CONV_STUB(IfcDistributionFlowElementType);
	DECL_CONV_STUB(IfcEnergyConversionDeviceType);
	DECL_CONV_STUB(IfcCooledBeamType);
	DECL_CONV_STUB(IfcCsgPrimitive3D);
	DECL_CONV_STUB(IfcRectangularPyramid);
	DECL_CONV_STUB(IfcSurface);
	DECL_CONV_STUB(IfcBoundedSurface);
	DECL_CONV_STUB(IfcRectangularTrimmedSurface);
	DECL_CONV_STUB(IfcGroup);
	DECL_CONV_STUB(IfcRelationship);
	DECL_CONV_STUB(IfcHalfSpaceSolid);
	DECL_CONV_STUB(IfcPolygonalBoundedHalfSpace);
	DECL_CONV_STUB(IfcAirToAirHeatRecoveryType);
	DECL_CONV_STUB(IfcFlowFittingType);
	DECL_CONV_STUB(IfcPipeFittingType);
	DECL_CONV_STUB(IfcRepresentation);
	DECL_CONV_STUB(IfcStyleModel);
	DECL_CONV_STUB(IfcStyledRepresentation);
	DECL_CONV_STUB(IfcBooleanResult);
	DECL_CONV_STUB(IfcFeatureElement);
	DECL_CONV_STUB(IfcFeatureElementSubtraction);
	DECL_CONV_STUB(IfcOpeningElement);
	DECL_CONV_STUB(IfcConditionCriterion);
	DECL_CONV_STUB(IfcFlowTerminalType);
	DECL_CONV_STUB(IfcFlowControllerType);
	DECL_CONV_STUB(IfcSwitchingDeviceType);
	DECL_CONV_STUB(IfcSystem);
	DECL_CONV_STUB(IfcElectricalCircuit);
	DECL_CONV_STUB(IfcUnitaryEquipmentType);
	DECL_CONV_STUB(IfcPort);
	DECL_CONV_STUB(IfcPlacement);
	DECL_CONV_STUB(IfcArbitraryClosedProfileDef);
	DECL_CONV_STUB(IfcCurve);
	DECL_CONV_STUB(IfcConic);
	DECL_CONV_STUB(IfcCircle);
	DECL_CONV_STUB(IfcElementarySurface);
	DECL_CONV_STUB(IfcPlane);
	DECL_CONV_STUB(IfcCostSchedule);
	DECL_CONV_STUB(IfcRightCircularCone);
	DECL_CONV_STUB(IfcElementAssembly);
	DECL_CONV_STUB(IfcBuildingElement);
	DECL_CONV_STUB(IfcMember);
	DECL_CONV_STUB(IfcBuildingElementProxy);
	DECL_CONV_STUB(IfcStructuralActivity);
	DECL_CONV_STUB(IfcStructuralAction);
	DECL_CONV_STUB(IfcStructuralPlanarAction);
	DECL_CONV_STUB(IfcTopologicalRepresentationItem);
	DECL_CONV_STUB(IfcConnectedFaceSet);
	DECL_CONV_STUB(IfcSweptSurface);
	DECL_CONV_STUB(IfcSurfaceOfLinearExtrusion);
	DECL_CONV_STUB(IfcArbitraryProfileDefWithVoids);
	DECL_CONV_STUB(IfcProcess);
	DECL_CONV_STUB(IfcProcedure);
	DECL_CONV_STUB(IfcVector);
	DECL_CONV_STUB(IfcFaceBound);
	DECL_CONV_STUB(IfcFaceOuterBound);
	DECL_CONV_STUB(IfcFeatureElementAddition);
	DECL_CONV_STUB(IfcNamedUnit);
	DECL_CONV_STUB(IfcConversionBasedUnit);
	DECL_CONV_STUB(IfcHeatExchangerType);
	DECL_CONV_STUB(IfcPresentationStyleAssignment);
	DECL_CONV_STUB(IfcFlowTreatmentDeviceType);
	DECL_CONV_STUB(IfcFilterType);
	DECL_CONV_STUB(IfcResource);
	DECL_CONV_STUB(IfcEvaporativeCoolerType);
	DECL_CONV_STUB(IfcOffsetCurve2D);
	DECL_CONV_STUB(IfcEdge);
	DECL_CONV_STUB(IfcSubedge);
	DECL_CONV_STUB(IfcProxy);
	DECL_CONV_STUB(IfcLine);
	DECL_CONV_STUB(IfcColumn);
	DECL_CONV_STUB(IfcObjectPlacement);
	DECL_CONV_STUB(IfcGridPlacement);
	DECL_CONV_STUB(IfcDistributionControlElementType);
	DECL_CONV_STUB(IfcRelConnects);
	DECL_CONV_STUB(IfcAnnotation);
	DECL_CONV_STUB(IfcPlate);
	DECL_CONV_STUB(IfcSolidModel);
	DECL_CONV_STUB(IfcManifoldSolidBrep);
	DECL_CONV_STUB(IfcFlowStorageDeviceType);
	DECL_CONV_STUB(IfcStructuralItem);
	DECL_CONV_STUB(IfcStructuralMember);
	DECL_CONV_STUB(IfcStructuralCurveMember);
	DECL_CONV_STUB(IfcStructuralConnection);
	DECL_CONV_STUB(IfcStructuralSurfaceConnection);
	DECL_CONV_STUB(IfcCoilType);
	DECL_CONV_STUB(IfcDuctFittingType);
	DECL_CONV_STUB(IfcStyledItem);
	DECL_CONV_STUB(IfcAnnotationOccurrence);
	DECL_CONV_STUB(IfcAnnotationCurveOccurrence);
	DECL_CONV_STUB(IfcDimensionCurve);
	DECL_CONV_STUB(IfcBoundedCurve);
	DECL_CONV_STUB(IfcAxis1Placement);
	DECL_CONV_STUB(IfcColourSpecification);
	DECL_CONV_STUB(IfcStructuralPointAction);
	DECL_CONV_STUB(IfcSpatialStructureElement);
	DECL_CONV_STUB(IfcSpace);
	DECL_CONV_STUB(IfcContextDependentUnit);
	DECL_CONV_STUB(IfcCoolingTowerType);
	DECL_CONV_STUB(IfcFacetedBrepWithVoids);
	DECL_CONV_STUB(IfcValveType);
	DECL_CONV_STUB(IfcSystemFurnitureElementType);
	DECL_CONV_STUB(IfcDiscreteAccessory);
	DECL_CONV_STUB(IfcBuildingElementType);
	DECL_CONV_STUB(IfcRailingType);
	DECL_CONV_STUB(IfcGasTerminalType);
	DECL_CONV_STUB(IfcSpaceProgram);
	DECL_CONV_STUB(IfcCovering);
	DECL_CONV_STUB(IfcPresentationStyle);
	DECL_CONV_STUB(IfcElectricHeaterType);
	DECL_CONV_STUB(IfcBuildingStorey);
	DECL_CONV_STUB(IfcVertex);
	DECL_CONV_STUB(IfcVertexPoint);
	DECL_CONV_STUB(IfcFlowInstrumentType);
	DECL_CONV_STUB(IfcUShapeProfileDef);
	DECL_CONV_STUB(IfcRamp);
	DECL_CONV_STUB(IfcCompositeCurve);
	DECL_CONV_STUB(IfcStructuralCurveMemberVarying);
	DECL_CONV_STUB(IfcRampFlightType);
	DECL_CONV_STUB(IfcDraughtingCallout);
	DECL_CONV_STUB(IfcDimensionCurveDirectedCallout);
	DECL_CONV_STUB(IfcRadiusDimension);
	DECL_CONV_STUB(IfcEdgeFeature);
	DECL_CONV_STUB(IfcSweptAreaSolid);
	DECL_CONV_STUB(IfcExtrudedAreaSolid);
	DECL_CONV_STUB(IfcAnnotationTextOccurrence);
	DECL_CONV_STUB(IfcStair);
	DECL_CONV_STUB(IfcFillAreaStyleTileSymbolWithStyle);
	DECL_CONV_STUB(IfcAnnotationSymbolOccurrence);
	DECL_CONV_STUB(IfcTerminatorSymbol);
	DECL_CONV_STUB(IfcDimensionCurveTerminator);
	DECL_CONV_STUB(IfcRectangleProfileDef);
	DECL_CONV_STUB(IfcRectangleHollowProfileDef);
	DECL_CONV_STUB(IfcLocalPlacement);
	DECL_CONV_STUB(IfcTask);
	DECL_CONV_STUB(IfcAnnotationFillAreaOccurrence);
	DECL_CONV_STUB(IfcFace);
	DECL_CONV_STUB(IfcFlowSegmentType);
	DECL_CONV_STUB(IfcDuctSegmentType);
	DECL_CONV_STUB(IfcConstructionResource);
	DECL_CONV_STUB(IfcConstructionEquipmentResource);
	DECL_CONV_STUB(IfcSanitaryTerminalType);
	DECL_CONV_STUB(IfcCircleProfileDef);
	DECL_CONV_STUB(IfcStructuralReaction);
	DECL_CONV_STUB(IfcStructuralPointReaction);
	DECL_CONV_STUB(IfcRailing);
	DECL_CONV_STUB(IfcTextLiteral);
	DECL_CONV_STUB(IfcCartesianTransformationOperator);
	DECL_CONV_STUB(IfcLinearDimension);
	DECL_CONV_STUB(IfcDamperType);
	DECL_CONV_STUB(IfcSIUnit);
	DECL_CONV_STUB(IfcMeasureWithUnit);
	DECL_CONV_STUB(IfcDistributionElement);
	DECL_CONV_STUB(IfcDistributionControlElement);
	DECL_CONV_STUB(IfcTransformerType);
	DECL_CONV_STUB(IfcLaborResource);
	DECL_CONV_STUB(IfcDerivedProfileDef);
	DECL_CONV_STUB(IfcFurnitureStandard);
	DECL_CONV_STUB(IfcStairFlightType);
	DECL_CONV_STUB(IfcWorkControl);
	DECL_CONV_STUB(IfcWorkPlan);
	DECL_CONV_STUB(IfcCondition);
	DECL_CONV_STUB(IfcRelVoidsElement);
	DECL_CONV_STUB(IfcWindow);
	DECL_CONV_STUB(IfcProtectiveDeviceType);
	DECL_CONV_STUB(IfcJunctionBoxType);
	DECL_CONV_STUB(IfcStructuralAnalysisModel);
	DECL_CONV_STUB(IfcAxis2Placement2D);
	DECL_CONV_STUB(IfcSpaceType);
	DECL_CONV_STUB(IfcEllipseProfileDef);
	DECL_CONV_STUB(IfcDistributionFlowElement);
	DECL_CONV_STUB(IfcFlowMovingDevice);
	DECL_CONV_STUB(IfcSurfaceStyleWithTextures);
	DECL_CONV_STUB(IfcGeometricSet);
	DECL_CONV_STUB(IfcProjectOrder);
	DECL_CONV_STUB(IfcBSplineCurve);
	DECL_CONV_STUB(IfcBezierCurve);
	DECL_CONV_STUB(IfcStructuralPointConnection);
	DECL_CONV_STUB(IfcFlowController);
	DECL_CONV_STUB(IfcElectricDistributionPoint);
	DECL_CONV_STUB(IfcSite);
	DECL_CONV_STUB(IfcOffsetCurve3D);
	DECL_CONV_STUB(IfcVirtualElement);
	DECL_CONV_STUB(IfcConstructionProductResource);
	DECL_CONV_STUB(IfcSurfaceCurveSweptAreaSolid);
	DECL_CONV_STUB(IfcCartesianTransformationOperator3D);
	DECL_CONV_STUB(IfcCartesianTransformationOperator3DnonUniform);
	DECL_CONV_STUB(IfcCrewResource);
	DECL_CONV_STUB(IfcStructuralSurfaceMember);
	DECL_CONV_STUB(Ifc2DCompositeCurve);
	DECL_CONV_STUB(IfcRepresentationContext);
	DECL_CONV_STUB(IfcGeometricRepresentationContext);
	DECL_CONV_STUB(IfcFlowTreatmentDevice);
	DECL_CONV_STUB(IfcRightCircularCylinder);
	DECL_CONV_STUB(IfcWasteTerminalType);
	DECL_CONV_STUB(IfcBuildingElementComponent);
	DECL_CONV_STUB(IfcBuildingElementPart);
	DECL_CONV_STUB(IfcWall);
	DECL_CONV_STUB(IfcWallStandardCase);
	DECL_CONV_STUB(IfcPath);
	DECL_CONV_STUB(IfcDefinedSymbol);
	DECL_CONV_STUB(IfcStructuralSurfaceMemberVarying);
	DECL_CONV_STUB(IfcPoint);
	DECL_CONV_STUB(IfcSurfaceOfRevolution);
	DECL_CONV_STUB(IfcFlowTerminal);
	DECL_CONV_STUB(IfcFurnishingElement);
	DECL_CONV_STUB(IfcSurfaceStyleShading);
	DECL_CONV_STUB(IfcSurfaceStyleRendering);
	DECL_CONV_STUB(IfcCircleHollowProfileDef);
	DECL_CONV_STUB(IfcFlowMovingDeviceType);
	DECL_CONV_STUB(IfcFanType);
	DECL_CONV_STUB(IfcStructuralPlanarActionVarying);
	DECL_CONV_STUB(IfcProductRepresentation);
	DECL_CONV_STUB(IfcStackTerminalType);
	DECL_CONV_STUB(IfcReinforcingElement);
	DECL_CONV_STUB(IfcReinforcingMesh);
	DECL_CONV_STUB(IfcOrderAction);
	DECL_CONV_STUB(IfcLightSource);
	DECL_CONV_STUB(IfcLightSourceDirectional);
	DECL_CONV_STUB(IfcLoop);
	DECL_CONV_STUB(IfcVertexLoop);
	DECL_CONV_STUB(IfcChamferEdgeFeature);
	DECL_CONV_STUB(IfcElementComponentType);
	DECL_CONV_STUB(IfcFastenerType);
	DECL_CONV_STUB(IfcMechanicalFastenerType);
	DECL_CONV_STUB(IfcScheduleTimeControl);
	DECL_CONV_STUB(IfcSurfaceStyle);
	DECL_CONV_STUB(IfcOpenShell);
	DECL_CONV_STUB(IfcSubContractResource);
	DECL_CONV_STUB(IfcSweptDiskSolid);
	DECL_CONV_STUB(IfcCompositeProfileDef);
	DECL_CONV_STUB(IfcTankType);
	DECL_CONV_STUB(IfcSphere);
	DECL_CONV_STUB(IfcPolyLoop);
	DECL_CONV_STUB(IfcCableCarrierFittingType);
	DECL_CONV_STUB(IfcHumidifierType);
	DECL_CONV_STUB(IfcPerformanceHistory);
	DECL_CONV_STUB(IfcShapeModel);
	DECL_CONV_STUB(IfcTopologyRepresentation);
	DECL_CONV_STUB(IfcBuilding);
	DECL_CONV_STUB(IfcRoundedRectangleProfileDef);
	DECL_CONV_STUB(IfcStairFlight);
	DECL_CONV_STUB(IfcDistributionChamberElement);
	DECL_CONV_STUB(IfcShapeRepresentation);
	DECL_CONV_STUB(IfcRampFlight);
	DECL_CONV_STUB(IfcBeamType);
	DECL_CONV_STUB(IfcRelDecomposes);
	DECL_CONV_STUB(IfcRoof);
	DECL_CONV_STUB(IfcFooting);
	DECL_CONV_STUB(IfcLightSourceAmbient);
	DECL_CONV_STUB(IfcWindowStyle);
	DECL_CONV_STUB(IfcBuildingElementProxyType);
	DECL_CONV_STUB(IfcAxis2Placement3D);
	DECL_CONV_STUB(IfcEdgeCurve);
	DECL_CONV_STUB(IfcClosedShell);
	DECL_CONV_STUB(IfcTendonAnchor);
	DECL_CONV_STUB(IfcCondenserType);
	DECL_CONV_STUB(IfcPipeSegmentType);
	DECL_CONV_STUB(IfcPointOnSurface);
	DECL_CONV_STUB(IfcAsset);
	DECL_CONV_STUB(IfcLightSourcePositional);
	DECL_CONV_STUB(IfcProjectionCurve);
	DECL_CONV_STUB(IfcFillAreaStyleTiles);
	DECL_CONV_STUB(IfcRelFillsElement);
	DECL_CONV_STUB(IfcElectricMotorType);
	DECL_CONV_STUB(IfcTendon);
	DECL_CONV_STUB(IfcDistributionChamberElementType);
	DECL_CONV_STUB(IfcMemberType);
	DECL_CONV_STUB(IfcStructuralLinearAction);
	DECL_CONV_STUB(IfcStructuralLinearActionVarying);
	DECL_CONV_STUB(IfcProductDefinitionShape);
	DECL_CONV_STUB(IfcFastener);
	DECL_CONV_STUB(IfcMechanicalFastener);
	DECL_CONV_STUB(IfcEvaporatorType);
	DECL_CONV_STUB(IfcDiscreteAccessoryType);
	DECL_CONV_STUB(IfcStructuralCurveConnection);
	DECL_CONV_STUB(IfcProjectionElement);
	DECL_CONV_STUB(IfcCoveringType);
	DECL_CONV_STUB(IfcPumpType);
	DECL_CONV_STUB(IfcPile);
	DECL_CONV_STUB(IfcUnitAssignment);
	DECL_CONV_STUB(IfcBoundingBox);
	DECL_CONV_STUB(IfcShellBasedSurfaceModel);
	DECL_CONV_STUB(IfcFacetedBrep);
	DECL_CONV_STUB(IfcTextLiteralWithExtent);
	DECL_CONV_STUB(IfcElectricApplianceType);
	DECL_CONV_STUB(IfcTrapeziumProfileDef);
	DECL_CONV_STUB(IfcRelContainedInSpatialStructure);
	DECL_CONV_STUB(IfcEdgeLoop);
	DECL_CONV_STUB(IfcProject);
	DECL_CONV_STUB(IfcCartesianPoint);
	DECL_CONV_STUB(IfcCurveBoundedPlane);
	DECL_CONV_STUB(IfcWallType);
	DECL_CONV_STUB(IfcFillAreaStyleHatching);
	DECL_CONV_STUB(IfcEquipmentStandard);
	DECL_CONV_STUB(IfcDiameterDimension);
	DECL_CONV_STUB(IfcStructuralLoadGroup);
	DECL_CONV_STUB(IfcConstructionMaterialResource);
	DECL_CONV_STUB(IfcRelAggregates);
	DECL_CONV_STUB(IfcBoilerType);
	DECL_CONV_STUB(IfcColourRgb);
	DECL_CONV_STUB(IfcDoorStyle);
	DECL_CONV_STUB(IfcDuctSilencerType);
	DECL_CONV_STUB(IfcLightSourceGoniometric);
	DECL_CONV_STUB(IfcActuatorType);
	DECL_CONV_STUB(IfcSensorType);
	DECL_CONV_STUB(IfcAirTerminalBoxType);
	DECL_CONV_STUB(IfcAnnotationSurfaceOccurrence);
	DECL_CONV_STUB(IfcRationalBezierCurve);
	DECL_CONV_STUB(IfcCartesianTransformationOperator2D);
	DECL_CONV_STUB(IfcCartesianTransformationOperator2DnonUniform);
	DECL_CONV_STUB(IfcMove);
	DECL_CONV_STUB(IfcCableCarrierSegmentType);
	DECL_CONV_STUB(IfcElectricalElement);
	DECL_CONV_STUB(IfcChillerType);
	DECL_CONV_STUB(IfcReinforcingBar);
	DECL_CONV_STUB(IfcCShapeProfileDef);
	DECL_CONV_STUB(IfcPermit);
	DECL_CONV_STUB(IfcSlabType);
	DECL_CONV_STUB(IfcLampType);
	DECL_CONV_STUB(IfcPlanarExtent);
	DECL_CONV_STUB(IfcAlarmType);
	DECL_CONV_STUB(IfcElectricFlowStorageDeviceType);
	DECL_CONV_STUB(IfcEquipmentElement);
	DECL_CONV_STUB(IfcLightFixtureType);
	DECL_CONV_STUB(IfcCurtainWall);
	DECL_CONV_STUB(IfcSlab);
	DECL_CONV_STUB(IfcCurtainWallType);
	DECL_CONV_STUB(IfcOutletType);
	DECL_CONV_STUB(IfcCompressorType);
	DECL_CONV_STUB(IfcCraneRailAShapeProfileDef);
	DECL_CONV_STUB(IfcFlowSegment);
	DECL_CONV_STUB(IfcSectionedSpine);
	DECL_CONV_STUB(IfcElectricTimeControlType);
	DECL_CONV_STUB(IfcFaceSurface);
	DECL_CONV_STUB(IfcMotorConnectionType);
	DECL_CONV_STUB(IfcFlowFitting);
	DECL_CONV_STUB(IfcPointOnCurve);
	DECL_CONV_STUB(IfcTransportElementType);
	DECL_CONV_STUB(IfcCableSegmentType);
	DECL_CONV_STUB(IfcAnnotationSurface);
	DECL_CONV_STUB(IfcCompositeCurveSegment);
	DECL_CONV_STUB(IfcServiceLife);
	DECL_CONV_STUB(IfcPlateType);
	DECL_CONV_STUB(IfcVibrationIsolatorType);
	DECL_CONV_STUB(IfcTrimmedCurve);
	DECL_CONV_STUB(IfcMappedItem);
	DECL_CONV_STUB(IfcDirection);
	DECL_CONV_STUB(IfcBlock);
	DECL_CONV_STUB(IfcProjectOrderRecord);
	DECL_CONV_STUB(IfcFlowMeterType);
	DECL_CONV_STUB(IfcControllerType);
	DECL_CONV_STUB(IfcBeam);
	DECL_CONV_STUB(IfcArbitraryOpenProfileDef);
	DECL_CONV_STUB(IfcCenterLineProfileDef);
	DECL_CONV_STUB(IfcTimeSeriesSchedule);
	DECL_CONV_STUB(IfcRoundedEdgeFeature);
	DECL_CONV_STUB(IfcIShapeProfileDef);
	DECL_CONV_STUB(IfcSpaceHeaterType);
	DECL_CONV_STUB(IfcFlowStorageDevice);
	DECL_CONV_STUB(IfcRevolvedAreaSolid);
	DECL_CONV_STUB(IfcDoor);
	DECL_CONV_STUB(IfcEllipse);
	DECL_CONV_STUB(IfcTubeBundleType);
	DECL_CONV_STUB(IfcAngularDimension);
	DECL_CONV_STUB(IfcFaceBasedSurfaceModel);
	DECL_CONV_STUB(IfcCraneRailFShapeProfileDef);
	DECL_CONV_STUB(IfcColumnType);
	DECL_CONV_STUB(IfcTShapeProfileDef);
	DECL_CONV_STUB(IfcEnergyConversionDevice);
	DECL_CONV_STUB(IfcWorkSchedule);
	DECL_CONV_STUB(IfcZone);
	DECL_CONV_STUB(IfcTransportElement);
	DECL_CONV_STUB(IfcGeometricRepresentationSubContext);
	DECL_CONV_STUB(IfcLShapeProfileDef);
	DECL_CONV_STUB(IfcGeometricCurveSet);
	DECL_CONV_STUB(IfcActor);
	DECL_CONV_STUB(IfcOccupant);
	DECL_CONV_STUB(IfcBooleanClippingResult);
	DECL_CONV_STUB(IfcAnnotationFillArea);
	DECL_CONV_STUB(IfcLightSourceSpot);
	DECL_CONV_STUB(IfcFireSuppressionTerminalType);
	DECL_CONV_STUB(IfcElectricGeneratorType);
	DECL_CONV_STUB(IfcInventory);
	DECL_CONV_STUB(IfcPolyline);
	DECL_CONV_STUB(IfcBoxedHalfSpace);
	DECL_CONV_STUB(IfcAirTerminalType);
	DECL_CONV_STUB(IfcDistributionPort);
	DECL_CONV_STUB(IfcCostItem);
	DECL_CONV_STUB(IfcStructuredDimensionCallout);
	DECL_CONV_STUB(IfcStructuralResultGroup);
	DECL_CONV_STUB(IfcOrientedEdge);
	DECL_CONV_STUB(IfcCsgSolid);
	DECL_CONV_STUB(IfcPlanarBox);
	DECL_CONV_STUB(IfcMaterialDefinitionRepresentation);
	DECL_CONV_STUB(IfcAsymmetricIShapeProfileDef);
	DECL_CONV_STUB(IfcRepresentationMap);


#undef DECL_CONV_STUB

} //! STEP
} //! Assimp

#endif // INCLUDED_IFC_READER_GEN_H
