/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import java.io.IOException;
import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.FactoryGlobal;
import jp.go.aist.rtm.RTC.InPortConsumerFactory;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class OutPortPushConnector
extends OutPortConnector {
    private InPortConsumer m_consumer;
    private PublisherBase m_publisher;
    private BufferBase<OutputStream> m_buffer;

    public OutPortPushConnector(ConnectorBase.Profile profile, InPortConsumer inPortConsumer, BufferBase<OutputStream> bufferBase) throws Exception {
        super(profile);
        try {
            this._Constructor(profile, inPortConsumer, bufferBase);
        }
        catch (Exception exception) {
            throw new Exception("bad_alloc()");
        }
    }

    public OutPortPushConnector(ConnectorBase.Profile profile, InPortConsumer inPortConsumer) throws Exception {
        super(profile);
        BufferBase<OutputStream> bufferBase = null;
        try {
            this._Constructor(profile, inPortConsumer, bufferBase);
        }
        catch (Exception exception) {
            throw new Exception("bad_alloc()");
        }
    }

    private void _Constructor(ConnectorBase.Profile profile, InPortConsumer inPortConsumer, BufferBase<OutputStream> bufferBase) throws Exception {
        this.m_consumer = inPortConsumer;
        this.m_publisher = null;
        this.m_buffer = bufferBase;
        this.m_publisher = this.createPublisher(profile);
        if (this.m_buffer == null) {
            this.m_buffer = this.createBuffer(profile);
        }
        if (this.m_publisher == null || this.m_buffer == null || this.m_consumer == null) {
            if (this.m_publisher == null) {
                this.rtcout.println(0, "m_publisher is null");
            }
            if (this.m_buffer == null) {
                this.rtcout.println(0, "m_buffer is null");
            }
            if (this.m_consumer == null) {
                this.rtcout.println(0, "m_consumer is null");
            }
            throw new Exception("bad_alloc()");
        }
        ReturnCode returnCode = this.m_publisher.init(profile.properties);
        if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
            throw new Exception("bad_alloc()");
        }
        this.m_consumer.init(profile.properties);
        this.m_publisher.setConsumer(this.m_consumer);
        this.m_publisher.setBuffer(this.m_buffer);
    }

    @Override
    public ReturnCode write(OutputStream outputStream) {
        this.rtcout.println(2, "write()");
        InputStream inputStream = outputStream.create_input_stream();
        try {
            this.rtcout.println(0, "data size = " + inputStream.available() + "byte");
        }
        catch (IOException iOException) {
            this.rtcout.println(0, "an I/O error occurs.");
        }
        return this.m_publisher.write(outputStream, 0, 0);
    }

    @Override
    public ReturnCode disconnect() {
        FactoryGlobal factoryGlobal;
        this.rtcout.println(2, "disconnect()");
        if (this.m_publisher != null) {
            this.rtcout.println(3, "delete publisher");
            factoryGlobal = PublisherBaseFactory.instance();
            factoryGlobal.deleteObject(this.m_publisher.getName(), this.m_publisher);
        }
        this.m_publisher = null;
        if (this.m_consumer != null) {
            this.rtcout.println(3, "delete consumer");
            factoryGlobal = InPortConsumerFactory.instance();
            factoryGlobal.deleteObject(this.m_consumer);
        }
        this.m_consumer = null;
        if (this.m_buffer != null) {
            this.rtcout.println(3, "delete buffer");
            factoryGlobal = BufferFactory.instance();
            factoryGlobal.deleteObject(this.m_buffer);
        }
        this.m_buffer = null;
        this.rtcout.println(2, "disconnect() done");
        return ReturnCode.PORT_OK;
    }

    @Override
    public void activate() {
        this.m_publisher.activate();
    }

    @Override
    public BufferBase<OutputStream> getBuffer() {
        return this.m_buffer;
    }

    @Override
    public void deactivate() {
        this.m_publisher.deactivate();
    }

    protected PublisherBase createPublisher(ConnectorBase.Profile profile) {
        String string = profile.properties.getProperty("subscription_type", "flush");
        string = StringUtil.normalize(string);
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        return (PublisherBase)publisherBaseFactory.createObject(string);
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.Profile profile) {
        String string = profile.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }
}

