/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import jp.go.aist.rtm.RTC.InPortConsumerFactory;
import jp.go.aist.rtm.RTC.OutPortProviderFactory;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.OutPortProvider;
import jp.go.aist.rtm.RTC.port.OutPortPullConnector;
import jp.go.aist.rtm.RTC.port.OutPortPushConnector;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.OutputStream;

public class OutPortBase
extends PortBase {
    protected String m_name = new String();
    protected List<Publisher> m_publishers = new ArrayList<Publisher>();
    protected Properties m_properties = new Properties();
    protected Vector<OutPortConnector> m_connectors = new Vector();
    protected Vector<InPortConsumer> m_consumers = new Vector();
    protected Vector<String> m_providerTypes = new Vector();
    protected Vector<String> m_consumerTypes = new Vector();
    protected Vector<OutPortProvider> m_providers = new Vector();
    private String m_endian = new String();

    public OutPortBase(String string, String string2) {
        super(string);
        this.m_name = string;
        this.m_endian = "litlle";
        this.rtcout.println(0, "Port name: " + string);
        this.rtcout.println(0, "setting port.port_type: DataOutPort");
        this.addProperty("port.port_type", "DataOutPort", String.class);
        this.rtcout.println(0, "setting dataport.data_type: " + string2);
        this.addProperty("dataport.data_type", string2, String.class);
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        String string3 = StringUtil.flatten(publisherBaseFactory.getIdentifiers());
        string3 = string3.trim();
        this.rtcout.println(0, "available subscription_type: " + string3);
        this.addProperty("dataport.subscription_type", string3, String.class);
        this.initConsumers();
        this.initProviders();
    }

    void init(Properties properties) {
        this.rtcout.println(2, "init()");
        this.rtcout.println(2, "given properties:");
        String string = new String();
        properties._dump(string, properties, 0);
        this.rtcout.println(0, string);
        this.m_properties.merge(properties);
        this.rtcout.println(0, "updated properties:");
        string = "";
        this.m_properties._dump(string, this.m_properties, 0);
        this.configure();
    }

    public Properties properties() {
        this.rtcout.println(2, "properties()");
        return this.m_properties;
    }

    public String name() {
        this.rtcout.println(2, "name() = " + this.m_name);
        return this.m_name;
    }

    public final Vector<OutPortConnector> connectors() {
        this.rtcout.println(2, "connectors(): size = " + this.m_connectors.size());
        return this.m_connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<ConnectorBase.Profile> getConnectorProfiles() {
        this.rtcout.println(2, "getConnectorProfiles(): size = " + this.m_connectors.size());
        Vector<ConnectorBase.Profile> vector = new Vector<ConnectorBase.Profile>();
        Vector<OutPortConnector> vector2 = this.m_connectors;
        synchronized (vector2) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                vector.add(this.m_connectors.elementAt(i).profile());
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getConnectorIds() {
        Vector<String> vector = new Vector<String>();
        Vector<OutPortConnector> vector2 = this.m_connectors;
        synchronized (vector2) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                vector.add(this.m_connectors.elementAt(i).id());
            }
        }
        this.rtcout.println(2, "getConnectorIds(): " + vector.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> getConnectorNames() {
        Vector<String> vector = new Vector<String>();
        Vector<OutPortConnector> vector2 = this.m_connectors;
        synchronized (vector2) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                vector.add(this.m_connectors.elementAt(i).name());
            }
        }
        this.rtcout.println(2, "getConnectorNames(): " + vector.toString());
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnectorProfileById(String string, ConnectorBase.Profile profile) {
        this.rtcout.println(2, "getConnectorProfileById(id = " + string + ")");
        String string2 = string;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(this.m_connectors.elementAt(i).id())) continue;
                profile = this.m_connectors.elementAt(i).profile();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnectorProfileByName(String string, ConnectorBase.Profile profile) {
        this.rtcout.println(2, "getConnectorProfileByNmae(name = " + string + ")");
        String string2 = string;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                if (!string2.equals(this.m_connectors.elementAt(i).name())) continue;
                profile = this.m_connectors.elementAt(i).profile();
                return true;
            }
        }
        return false;
    }

    public boolean publishInterfaceProfiles(NVListHolder nVListHolder) {
        this.rtcout.println(2, "publishInterfaceProfiles()");
        for (OutPortProvider outPortProvider : this.m_providers) {
            outPortProvider.publishInterfaceProfile(nVListHolder);
        }
        return true;
    }

    public void onConnect(String string, PublisherBase publisherBase) {
    }

    public void onDisconnect(String string) {
    }

    @Override
    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        Object object2;
        this.rtcout.println(2, "publishInterfaces()");
        Properties properties = this.m_properties;
        Object object3 = new Properties();
        Object object4 = new NVListHolder(connectorProfileHolder.value.properties);
        NVUtil.copyToProperties((Properties)object3, (NVListHolder)object4);
        properties.merge(((Properties)object3).getNode("dataport"));
        object3 = new NVListHolder(connectorProfileHolder.value.properties);
        try {
            int n;
            object4 = NVUtil.find((NVListHolder)object3, "dataport.serializer.cdr.endian");
            object2 = object4.type().kind() == TCKind.tk_wstring ? object4.extract_wstring() : object4.extract_string();
            object2 = StringUtil.normalize((String)object2);
            object = ((String)object2).split(",");
            object2 = "";
            for (n = 0; n < ((String[])object).length; ++n) {
                String string = object[n].trim();
                if (!string.equals("big") && !string.equals("little")) continue;
                object2 = ((String)object2).length() != 0 ? (String)object2 + "," + string : (String)object2 + string;
            }
            n = NVUtil.find_index((NVListHolder)object3, "dataport.serializer.cdr.endian");
            ((NVListHolder)object3).value[n].value.insert_string((String)object2);
            connectorProfileHolder.value.properties = ((NVListHolder)object3).value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object4 = properties.getProperty("dataflow_type");
        object4 = StringUtil.normalize((String)object4);
        if (((String)object4).equals("push")) {
            this.rtcout.println(3, "dataflow_type = push .... do nothing");
            return ReturnCode_t.RTC_OK;
        }
        if (((String)object4).equals("pull")) {
            this.rtcout.println(3, "dataflow_type = pull .... create PushConnector");
            object2 = this.createProvider(connectorProfileHolder, properties);
            if (object2 == null) {
                return ReturnCode_t.BAD_PARAMETER;
            }
            object = this.createConnector(connectorProfileHolder, properties, (OutPortProvider)object2);
            if (object == null) {
                return ReturnCode_t.RTC_ERROR;
            }
            this.rtcout.println(3, "publishInterface() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(6, "unsupported dataflow_type");
        return ReturnCode_t.BAD_PARAMETER;
    }

    @Override
    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        Object object2;
        this.rtcout.println(2, "subscribeInterfaces()");
        Properties properties = this.m_properties;
        Object object3 = new Properties();
        Object object4 = new NVListHolder(connectorProfileHolder.value.properties);
        NVUtil.copyToProperties((Properties)object3, (NVListHolder)object4);
        properties.merge(((Properties)object3).getNode("dataport"));
        object3 = new NVListHolder(connectorProfileHolder.value.properties);
        try {
            object4 = NVUtil.find((NVListHolder)object3, "dataport.serializer.cdr.endian");
            object2 = object4.type().kind() == TCKind.tk_wstring ? object4.extract_wstring() : object4.extract_string();
            object2 = StringUtil.normalize((String)object2);
            object = ((String)object2).split(",");
            String string = object[0].trim();
            if (string.length() == 0) {
                return ReturnCode_t.UNSUPPORTED;
            }
            this.m_endian = string.equals("little") || string.equals("big") ? string : "little";
        }
        catch (Exception exception) {
            this.m_endian = "little";
        }
        this.rtcout.println(2, "endian = " + this.m_endian);
        object4 = properties.getProperty("dataflow_type");
        object4 = StringUtil.normalize((String)object4);
        if (((String)object4).equals("push")) {
            this.rtcout.println(3, "dataflow_type = push .... create PushConnector");
            object2 = this.createConsumer(connectorProfileHolder, properties);
            if (object2 == null) {
                return ReturnCode_t.BAD_PARAMETER;
            }
            object = this.createConnector(connectorProfileHolder, properties, (InPortConsumer)object2);
            if (object == null) {
                return ReturnCode_t.RTC_ERROR;
            }
            this.rtcout.println(3, "publishInterface() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        if (((String)object4).equals("pull")) {
            this.rtcout.println(3, "dataflow_type = pull .... do nothing.");
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(6, "unsupported dataflow_type.");
        return ReturnCode_t.BAD_PARAMETER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeInterfaces(ConnectorProfile connectorProfile) {
        this.rtcout.println(2, "unsubscribeInterfaces()");
        String string = connectorProfile.connector_id;
        this.rtcout.println(0, "connector_id: " + string);
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            Iterator<OutPortConnector> iterator = this.m_connectors.iterator();
            while (iterator.hasNext()) {
                OutPortConnector outPortConnector = iterator.next();
                if (!string.equals(outPortConnector.id())) continue;
                outPortConnector.disconnect();
                iterator.remove();
                this.rtcout.println(2, "delete connector: " + string);
                return;
            }
        }
        this.rtcout.println(6, "specified connector not found: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateInterfaces() {
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                this.m_connectors.elementAt(i).activate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateInterfaces() {
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                this.m_connectors.elementAt(i).deactivate();
            }
        }
    }

    protected void configure() {
    }

    protected void initProviders() {
        Object object;
        this.rtcout.println(2, "initProviders()");
        OutPortProviderFactory outPortProviderFactory = OutPortProviderFactory.instance();
        Set set = outPortProviderFactory.getIdentifiers();
        this.rtcout.println(3, "available providers: " + set.toString());
        String string = StringUtil.normalize(this.m_properties.getProperty("provider_types"));
        if (this.m_properties.hasKey("provider_types") != null && !string.equals("all")) {
            this.rtcout.println(3, "allowed providers: " + this.m_properties.getProperty("provider_types"));
            object = set;
            set.clear();
            Vector<String> vector = StringUtil.split(this.m_properties.getProperty("provider_types"), ",");
            HashSet hashSet = new HashSet(object);
            HashSet<String> hashSet2 = new HashSet<String>(vector);
            for (String string2 : hashSet) {
                if (!hashSet2.contains(string2)) continue;
                set.add(string2);
            }
        }
        if (set.size() > 0) {
            this.rtcout.println(3, "dataflow_type pull is supported");
            this.appendProperty("dataport.dataflow_type", "push");
            this.appendProperty("dataport.interface_type", StringUtil.flatten(set));
        }
        object = set.iterator();
        while (object.hasNext()) {
            this.m_providerTypes.add((String)object.next());
        }
    }

    protected void initConsumers() {
        Object object;
        this.rtcout.println(2, "initConsumers()");
        InPortConsumerFactory inPortConsumerFactory = InPortConsumerFactory.instance();
        Set set = inPortConsumerFactory.getIdentifiers();
        this.rtcout.println(3, "available InPortConsumer: " + set.toString());
        String string = StringUtil.normalize(this.m_properties.getProperty("consumer_types"));
        if (this.m_properties.hasKey("consumer_types") != null && !string.equals("all")) {
            this.rtcout.println(3, "allowed consumers: " + this.m_properties.getProperty("consumer_types"));
            object = set;
            set.clear();
            Vector<String> vector = StringUtil.split(this.m_properties.getProperty("consumer_types"), ",");
            HashSet hashSet = new HashSet(object);
            HashSet<String> hashSet2 = new HashSet<String>(vector);
            for (String string2 : hashSet) {
                if (!hashSet2.contains(string2)) continue;
                set.add(string2);
            }
        }
        if (set.size() > 0) {
            this.rtcout.println(3, "dataflow_type pull is supported");
            this.appendProperty("dataport.dataflow_type", "push");
            this.appendProperty("dataport.interface_type", StringUtil.flatten(set));
        }
        object = set.iterator();
        while (object.hasNext()) {
            this.m_consumerTypes.add((String)object.next());
        }
    }

    protected OutPortProvider createProvider(ConnectorProfileHolder connectorProfileHolder, Properties properties) {
        if (properties.getProperty("interface_type").length() != 0 && !StringUtil.includes(this.m_providerTypes, properties.getProperty("interface_type"), true)) {
            this.rtcout.println(6, "no provider found");
            this.rtcout.println(6, "interface_type:  " + properties.getProperty("interface_type"));
            this.rtcout.println(6, "interface_types:  " + this.m_providerTypes.toString());
            return null;
        }
        this.rtcout.println(3, "interface_type:  " + properties.getProperty("interface_type"));
        OutPortProviderFactory outPortProviderFactory = OutPortProviderFactory.instance();
        OutPortProvider outPortProvider = (OutPortProvider)outPortProviderFactory.createObject(properties.getProperty("interface_type"));
        if (outPortProvider != null) {
            this.rtcout.println(3, "provider created");
            outPortProvider.init(properties.getNode("provider"));
            NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
            if (!outPortProvider.publishInterface(nVListHolder)) {
                this.rtcout.println(6, "publishing interface information error");
                outPortProviderFactory.deleteObject(outPortProvider);
                return null;
            }
            connectorProfileHolder.value.properties = nVListHolder.value;
            return outPortProvider;
        }
        this.rtcout.println(6, "provider creation failed");
        return null;
    }

    protected InPortConsumer createConsumer(ConnectorProfileHolder connectorProfileHolder, Properties properties) {
        if (properties.getProperty("interface_type").length() != 0 && !StringUtil.includes(this.m_consumerTypes, properties.getProperty("interface_type"), true)) {
            this.rtcout.println(6, "no consumer found");
            this.rtcout.println(6, "interface_type:  " + properties.getProperty("interface_type"));
            this.rtcout.println(6, "interface_types:  " + this.m_consumerTypes.toString());
            return null;
        }
        this.rtcout.println(3, "interface_type:  " + properties.getProperty("interface_type"));
        InPortConsumerFactory inPortConsumerFactory = InPortConsumerFactory.instance();
        InPortConsumer inPortConsumer = (InPortConsumer)inPortConsumerFactory.createObject(properties.getProperty("interface_type"));
        if (inPortConsumer != null) {
            this.rtcout.println(3, "consumer created");
            inPortConsumer.init(properties.getNode("consumer"));
            NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
            if (!inPortConsumer.subscribeInterface(nVListHolder)) {
                this.rtcout.println(6, "interface subscription failed.");
                inPortConsumerFactory.deleteObject(inPortConsumer);
                return null;
            }
            return inPortConsumer;
        }
        this.rtcout.println(6, "consumer creation failed");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutPortConnector createConnector(ConnectorProfileHolder connectorProfileHolder, Properties properties, InPortConsumer inPortConsumer) {
        ConnectorBase.Profile profile = new ConnectorBase.Profile(connectorProfileHolder.value.name, connectorProfileHolder.value.connector_id, CORBA_SeqUtil.refToVstring(connectorProfileHolder.value.ports), properties);
        OutPortPushConnector outPortPushConnector = null;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            try {
                BufferBase<OutputStream> bufferBase = null;
                outPortPushConnector = new OutPortPushConnector(profile, inPortConsumer, bufferBase);
                if (outPortPushConnector == null) {
                    this.rtcout.println(6, "old compiler? new returned 0;");
                    return null;
                }
                this.rtcout.println(2, "OutPortPushConnector create");
                this.m_connectors.add(outPortPushConnector);
                this.rtcout.println(0, "connector push backed: " + this.m_connectors.size());
                return outPortPushConnector;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "OutPortPullConnector creation failed");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutPortConnector createConnector(ConnectorProfileHolder connectorProfileHolder, Properties properties, OutPortProvider outPortProvider) {
        ConnectorBase.Profile profile = new ConnectorBase.Profile(connectorProfileHolder.value.name, connectorProfileHolder.value.connector_id, CORBA_SeqUtil.refToVstring(connectorProfileHolder.value.ports), properties);
        OutPortPullConnector outPortPullConnector = null;
        Vector<OutPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            try {
                BufferBase<OutputStream> bufferBase = null;
                outPortPullConnector = new OutPortPullConnector(profile, outPortProvider, bufferBase);
                if (outPortPullConnector == null) {
                    this.rtcout.println(6, "old compiler? new returned 0;");
                    return null;
                }
                this.rtcout.println(2, "OutPortPushConnector create");
                this.m_connectors.add(outPortPullConnector);
                this.rtcout.println(0, "connector push backed: " + this.m_connectors.size());
                return outPortPullConnector;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "OutPortPullConnector creation failed");
                return null;
            }
        }
    }

    public boolean isLittleEndian() {
        return this.m_endian.equals("little");
    }

    protected class Publisher {
        public String id;
        public PublisherBase publisher;

        public Publisher(String string, PublisherBase publisherBase) {
            this.id = string;
            this.publisher = publisherBase;
        }
    }
}

