/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port.publisher;

import java.util.Set;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.PeriodicTaskBase;
import jp.go.aist.rtm.RTC.PeriodicTaskFactory;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.portable.OutputStream;

public class PublisherPeriodic
extends PublisherBase
implements Runnable,
ObjectCreator<PublisherBase>,
ObjectDestructor {
    private InPortConsumer m_consumer = null;
    private boolean m_running;
    private long m_millisec;
    private int m_nanosec;
    private static final String id_name = "periodic";
    protected Logbuf rtcout;
    private boolean m_active = false;
    private Policy m_pushPolicy;
    private BufferBase<OutputStream> m_buffer = null;
    private int m_skipn = 0;
    private PeriodicTaskBase m_task = null;
    private ReturnCode m_retcode;
    private int m_leftskip = 0;
    private String m_retmutex = new String();
    private boolean m_readback = false;

    public PublisherPeriodic() {
        this.rtcout = new Logbuf("PublisherPeriodic");
        this.m_retcode = ReturnCode.PORT_OK;
        this.m_pushPolicy = Policy.NEW;
    }

    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int svc() {
        String string = this.m_retmutex;
        synchronized (string) {
            switch (this.m_pushPolicy) {
                case ALL: {
                    this.m_retcode = this.pushAll();
                    break;
                }
                case FIFO: {
                    this.m_retcode = this.pushFifo();
                    break;
                }
                case SKIP: {
                    this.m_retcode = this.pushSkip();
                    break;
                }
                case NEW: {
                    this.m_retcode = this.pushNew();
                    break;
                }
                default: {
                    this.m_retcode = this.pushNew();
                }
            }
        }
        return 0;
    }

    protected ReturnCode pushAll() {
        this.rtcout.println(2, "pushAll()");
        while (this.m_buffer.readable() > 0) {
            OutputStream outputStream = this.m_buffer.get();
            ReturnCode returnCode = this.m_consumer.put(outputStream);
            if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
                this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
                return returnCode;
            }
            this.m_buffer.advanceRptr();
        }
        return ReturnCode.PORT_OK;
    }

    protected ReturnCode pushFifo() {
        this.rtcout.println(2, "pushFifo()");
        if (this.m_buffer.empty() && !this.m_readback) {
            this.rtcout.println(3, "buffer empty");
            return ReturnCode.BUFFER_EMPTY;
        }
        OutputStream outputStream = this.m_buffer.get();
        ReturnCode returnCode = this.m_consumer.put(outputStream);
        if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
            this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
            return returnCode;
        }
        this.m_buffer.advanceRptr();
        return returnCode;
    }

    protected ReturnCode pushSkip() {
        this.rtcout.println(2, "pushSkip()");
        if (this.m_buffer.empty() && !this.m_readback) {
            this.rtcout.println(3, "buffer empty");
            return ReturnCode.BUFFER_EMPTY;
        }
        ReturnCode returnCode = ReturnCode.PORT_OK;
        int n = this.m_buffer.readable() + this.m_leftskip;
        int n2 = n / (this.m_skipn + 1);
        int n3 = this.m_skipn - this.m_leftskip;
        for (int i = 0; i < n2; ++i) {
            this.m_buffer.advanceRptr(n3);
            OutputStream outputStream = this.m_buffer.get();
            returnCode = this.m_consumer.put(outputStream);
            if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
                this.m_buffer.advanceRptr(-n3);
                this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
                return returnCode;
            }
            n3 = this.m_skipn + 1;
        }
        this.m_buffer.advanceRptr(this.m_buffer.readable());
        this.m_leftskip = n % (this.m_skipn + 1);
        return returnCode;
    }

    protected ReturnCode pushNew() {
        this.rtcout.println(2, "pushNew()");
        if (this.m_buffer.empty() && !this.m_readback) {
            this.rtcout.println(3, "buffer empty");
            return ReturnCode.BUFFER_EMPTY;
        }
        this.m_buffer.advanceRptr(this.m_buffer.readable() - 1);
        OutputStream outputStream = this.m_buffer.get();
        ReturnCode returnCode = this.m_consumer.put(outputStream);
        this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
        this.m_buffer.advanceRptr();
        return returnCode;
    }

    @Override
    public void run() {
        this.svc();
    }

    public int open() {
        this.m_running = true;
        Thread thread = new Thread(this);
        thread.start();
        return 0;
    }

    @Override
    public void release() {
        this.m_running = false;
    }

    @Override
    public ReturnCode init(Properties properties) {
        double d;
        this.rtcout.println(2, "init()");
        String string = new String();
        properties._dump(string, properties, 0);
        this.rtcout.println(0, string);
        String string2 = properties.getProperty("publisher.push_policy", "new");
        this.rtcout.println(3, "push_policy: " + string2);
        String string3 = properties.getProperty("publisher.skip_count", "0");
        this.rtcout.println(3, "skip_count: " + string3);
        string2 = StringUtil.normalize(string2);
        if (string2.equals("all")) {
            this.m_pushPolicy = Policy.ALL;
        } else if (string2.equals("fifo")) {
            this.m_pushPolicy = Policy.FIFO;
        } else if (string2.equals("skip")) {
            this.m_pushPolicy = Policy.SKIP;
        } else if (string2.equals("new")) {
            this.m_pushPolicy = Policy.NEW;
        } else {
            this.rtcout.println(6, "invalid push_policy value: " + string2);
            this.m_pushPolicy = Policy.NEW;
        }
        try {
            this.m_skipn = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            this.rtcout.println(6, "invalid skip_count value: " + string3);
            this.m_skipn = 0;
        }
        if (this.m_skipn < 0) {
            this.rtcout.println(6, "invalid skip_count value: " + this.m_skipn);
            this.m_skipn = 0;
        }
        PeriodicTaskFactory periodicTaskFactory = PeriodicTaskFactory.instance();
        Set set = periodicTaskFactory.getIdentifiers();
        this.rtcout.println(3, "available task types: " + set.toString());
        this.m_task = (PeriodicTaskBase)periodicTaskFactory.createObject(properties.getProperty("thread_type", "default"));
        if (this.m_task == null) {
            this.rtcout.println(6, "Task creation failed: " + properties.getProperty("thread_type", "default"));
            return ReturnCode.INVALID_ARGS;
        }
        this.rtcout.println(0, "Task creation succeeded.");
        this.m_task.setTask(this);
        String string4 = properties.getProperty("push_rate");
        if (!string4.equals("")) {
            d = Double.valueOf(string4);
            if (d <= 0.0) {
                d = 1000.0;
            }
            this.rtcout.println(3, "Task period " + d + "[Hz]");
        } else {
            d = 1000.0;
        }
        this.m_task.setPeriod(1.0 / d);
        Properties properties2 = properties.getNode("measurement");
        this.m_task.executionMeasure(StringUtil.toBool(properties2.getProperty("exec_time"), "enable", "disable", true));
        try {
            int n = Integer.parseInt(properties2.getProperty("exec_count"));
            this.m_task.executionMeasureCount(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_task.periodicMeasure(StringUtil.toBool(properties2.getProperty("period_time"), "enable", "disable", true));
        try {
            int n = Integer.parseInt(properties2.getProperty("period_count"));
            this.m_task.periodicMeasureCount(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_task._suspend();
        this.m_task.activate();
        this.m_task._suspend();
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setConsumer(InPortConsumer inPortConsumer) {
        this.rtcout.println(2, "setConsumer()");
        if (inPortConsumer == null) {
            this.rtcout.println(6, "setConsumer(consumer = null): invalid argument.");
            return ReturnCode.INVALID_ARGS;
        }
        this.m_consumer = inPortConsumer;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setBuffer(BufferBase<OutputStream> bufferBase) {
        this.rtcout.println(2, "setBuffer()");
        if (bufferBase == null) {
            this.rtcout.println(6, "setBuffer(buffer = null): invalid argument.");
            return ReturnCode.INVALID_ARGS;
        }
        this.m_buffer = bufferBase;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode write(OutputStream outputStream, int n, int n2) {
        this.rtcout.println(0, "write()");
        if (this.m_consumer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_buffer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_retcode.equals((Object)ReturnCode.CONNECTION_LOST)) {
            this.rtcout.println(3, "write(): connection lost.");
            return this.m_retcode;
        }
        if (this.m_retcode.equals((Object)ReturnCode.BUFFER_FULL)) {
            this.rtcout.println(3, "write(): InPort buffer is full.");
            this.m_buffer.write(outputStream, n, n2);
            return ReturnCode.BUFFER_FULL;
        }
        jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode = this.m_buffer.write(outputStream, n, n2);
        this.rtcout.println(3, returnCode.name() + " = write()");
        this.m_task._resume();
        return this.convertReturn(returnCode);
    }

    @Override
    public ReturnCode write(OutputStream outputStream) {
        return this.write(outputStream, -1, 0);
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    @Override
    public ReturnCode activate() {
        if (this.m_task == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_buffer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        this.m_active = true;
        this.m_task._resume();
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode deactivate() {
        if (this.m_task == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        this.m_active = false;
        this.m_task._suspend();
        return ReturnCode.PORT_OK;
    }

    @Override
    public PublisherBase creator_() {
        return new PublisherPeriodic();
    }

    @Override
    public void destructor_(Object object) {
        PublisherPeriodic publisherPeriodic = (PublisherPeriodic)object;
        if (publisherPeriodic.m_task != null) {
            PeriodicTaskFactory periodicTaskFactory = PeriodicTaskFactory.instance();
            periodicTaskFactory.deleteObject(publisherPeriodic.m_task);
        }
        object = null;
    }

    protected ReturnCode convertReturn(jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode) {
        switch (returnCode) {
            case BUFFER_OK: {
                return ReturnCode.PORT_OK;
            }
            case BUFFER_EMPTY: {
                return ReturnCode.BUFFER_EMPTY;
            }
            case TIMEOUT: {
                return ReturnCode.BUFFER_TIMEOUT;
            }
            case PRECONDITION_NOT_MET: {
                return ReturnCode.PRECONDITION_NOT_MET;
            }
        }
        return ReturnCode.PORT_ERROR;
    }

    public static void PublisherPeriodicInit() {
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        publisherBaseFactory.addFactory(id_name, new PublisherPeriodic(), new PublisherPeriodic());
    }

    @Override
    public String getName() {
        return id_name;
    }

    protected static enum Policy {
        ALL,
        FIFO,
        SKIP,
        NEW;

    }
}

