/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port.publisher;

import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.Properties;
import org.omg.CORBA.portable.OutputStream;

public class PublisherFlush
extends PublisherBase
implements ObjectCreator<PublisherBase>,
ObjectDestructor {
    private static final String id_name = "flush";
    protected Logbuf rtcout = new Logbuf("PublisherFlush");
    private InPortConsumer m_consumer = null;
    private boolean m_active = false;
    private ConnectorListeners m_listeners = null;
    private ConnectorBase.ConnectorInfo m_profile;
    private ReturnCode m_retcode = ReturnCode.PORT_OK;

    public void destruct() {
        this.m_consumer = null;
        this.m_listeners = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public ReturnCode init(Properties properties) {
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setConsumer(InPortConsumer inPortConsumer) {
        if (inPortConsumer == null) {
            return ReturnCode.INVALID_ARGS;
        }
        this.m_consumer = inPortConsumer;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setBuffer(BufferBase<OutputStream> bufferBase) {
        this.rtcout.println(2, "setBuffer()");
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setListener(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners) {
        this.rtcout.println(2, "setListeners()");
        if (connectorListeners == null) {
            this.rtcout.println(6, "setListeners(listeners == 0): invalid argument");
            return ReturnCode.INVALID_ARGS;
        }
        this.m_profile = connectorInfo;
        this.m_listeners = connectorListeners;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode write(OutputStream outputStream, int n, int n2) {
        if (this.m_consumer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_listeners == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_retcode.equals((Object)ReturnCode.CONNECTION_LOST)) {
            this.rtcout.println(3, "write(): connection lost.");
            return this.m_retcode;
        }
        this.onSend(outputStream);
        ReturnCode returnCode = this.m_consumer.put(outputStream);
        switch (returnCode) {
            case PORT_OK: {
                this.onReceived(outputStream);
                return returnCode;
            }
            case PORT_ERROR: {
                this.onReceiverError(outputStream);
                return returnCode;
            }
            case SEND_FULL: {
                this.onReceiverFull(outputStream);
                return returnCode;
            }
            case SEND_TIMEOUT: {
                this.onReceiverTimeout(outputStream);
                return returnCode;
            }
            case CONNECTION_LOST: {
                this.onReceiverTimeout(outputStream);
                return returnCode;
            }
            case UNKNOWN_ERROR: {
                this.onReceiverError(outputStream);
                return returnCode;
            }
        }
        this.onReceiverError(outputStream);
        return returnCode;
    }

    @Override
    public ReturnCode write(OutputStream outputStream) {
        return this.write(outputStream, -1, 0);
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    @Override
    public ReturnCode activate() {
        this.m_active = true;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode deactivate() {
        this.m_active = false;
        return ReturnCode.PORT_OK;
    }

    @Override
    public PublisherBase creator_() {
        return new PublisherFlush();
    }

    @Override
    public void destructor_(Object object) {
        object = null;
    }

    public static void PublisherFlushInit() {
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        publisherBaseFactory.addFactory(id_name, new PublisherFlush(), new PublisherFlush());
    }

    @Override
    public String getName() {
        return id_name;
    }

    protected void onSend(OutputStream outputStream) {
        this.m_listeners.connectorData_[5].notify(this.m_profile, outputStream);
    }

    protected void onReceived(OutputStream outputStream) {
        this.m_listeners.connectorData_[6].notify(this.m_profile, outputStream);
    }

    protected void onReceiverFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[7].notify(this.m_profile, outputStream);
    }

    protected void onReceiverTimeout(OutputStream outputStream) {
        this.m_listeners.connectorData_[8].notify(this.m_profile, outputStream);
    }

    protected void onReceiverError(OutputStream outputStream) {
        this.m_listeners.connectorData_[9].notify(this.m_profile, outputStream);
    }
}

