/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

public class TimeValue {
    private final int TIMEVALUE_ONE_SECOND_IN_USECS = 1000000;
    private long tv_sec;
    private long tv_usec;

    public TimeValue() {
        this.tv_sec = 0L;
        this.tv_usec = 0L;
        this.normalize();
    }

    public TimeValue(long l, long l2) {
        this.tv_sec = l;
        this.tv_usec = l2;
    }

    public TimeValue(double d) {
        double d2 = d >= 0.0 ? 0.5 : -0.5;
        this.tv_sec = (int)d;
        this.tv_usec = (long)((d - (double)this.tv_sec) * 1000000.0 + d2);
        this.normalize();
    }

    public TimeValue(TimeValue timeValue) {
        this.tv_sec = timeValue.tv_sec;
        this.tv_usec = timeValue.tv_usec;
    }

    public long getSec() {
        return this.tv_sec;
    }

    public long getUsec() {
        return this.tv_usec;
    }

    public TimeValue minus(TimeValue timeValue) {
        TimeValue timeValue2 = new TimeValue();
        if (this.tv_sec >= timeValue.tv_sec) {
            if (this.tv_usec >= timeValue.tv_usec) {
                timeValue2.tv_sec = this.tv_sec - timeValue.tv_sec;
                timeValue2.tv_usec = this.tv_usec - timeValue.tv_usec;
            } else {
                timeValue2.tv_sec = this.tv_sec - timeValue.tv_sec - 1L;
                timeValue2.tv_usec = this.tv_usec + 1000000L - timeValue.tv_usec;
            }
        } else if (timeValue.tv_usec >= this.tv_usec) {
            timeValue2.tv_sec = -(timeValue.tv_sec - this.tv_sec);
            timeValue2.tv_usec = -(timeValue.tv_usec - this.tv_usec);
        } else {
            timeValue2.tv_sec = -(timeValue.tv_sec - this.tv_sec - 1L);
            timeValue2.tv_usec = -(timeValue.tv_usec + 1000000L) + this.tv_usec;
        }
        timeValue2.normalize();
        return timeValue2;
    }

    public TimeValue plus(TimeValue timeValue) {
        TimeValue timeValue2 = new TimeValue();
        timeValue2.tv_sec = this.tv_sec + timeValue.tv_sec;
        timeValue2.tv_usec = this.tv_usec + timeValue.tv_usec;
        if (timeValue2.tv_usec > 1000000L) {
            ++timeValue2.tv_sec;
            timeValue2.tv_usec -= 1000000L;
        }
        timeValue2.normalize();
        return timeValue2;
    }

    public TimeValue convert(double d) {
        double d2 = d >= 0.0 ? 0.5 : -0.5;
        this.tv_sec = (long)d;
        this.tv_usec = (long)((d - (double)this.tv_sec) * 1000000.0 + d2);
        this.normalize();
        return this;
    }

    public double toDouble() {
        this.normalize();
        return (double)this.tv_sec + (double)this.tv_usec / 1000000.0;
    }

    public long sec() {
        return this.tv_sec;
    }

    public long usec() {
        return this.tv_usec;
    }

    public int sign() {
        this.normalize();
        if (this.tv_sec > 0L) {
            return 1;
        }
        if (this.tv_sec < 0L) {
            return -1;
        }
        if (this.tv_usec > 0L) {
            return 1;
        }
        if (this.tv_usec < 0L) {
            return -1;
        }
        return 0;
    }

    private void normalize() {
        if (this.tv_usec >= 1000000L) {
            do {
                ++this.tv_sec;
                this.tv_usec -= 1000000L;
            } while (this.tv_usec >= 1000000L);
        } else if (this.tv_usec <= -1000000L) {
            do {
                --this.tv_sec;
                this.tv_usec += 1000000L;
            } while (this.tv_usec <= -1000000L);
        }
        if (this.tv_sec >= 1L && this.tv_usec < 0L) {
            --this.tv_sec;
            this.tv_usec += 1000000L;
        } else if (this.tv_sec < 0L && this.tv_usec > 0L) {
            ++this.tv_sec;
            this.tv_usec -= 1000000L;
        }
    }
}

