/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import RTC.RTObject;
import RTC.ReturnCode_t;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.FileHandler;
import jp.go.aist.rtm.RTC.CorbaObjectManager;
import jp.go.aist.rtm.RTC.FactoryBase;
import jp.go.aist.rtm.RTC.FactoryJava;
import jp.go.aist.rtm.RTC.ManagerConfig;
import jp.go.aist.rtm.RTC.ModuleInitProc;
import jp.go.aist.rtm.RTC.ModuleManager;
import jp.go.aist.rtm.RTC.NamingManager;
import jp.go.aist.rtm.RTC.ObjectManager;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.RtcDeleteFunc;
import jp.go.aist.rtm.RTC.RtcNewFunc;
import jp.go.aist.rtm.RTC.executionContext.ECFactoryBase;
import jp.go.aist.rtm.RTC.executionContext.ECFactoryJava;
import jp.go.aist.rtm.RTC.executionContext.ExecutionContextBase;
import jp.go.aist.rtm.RTC.executionContext.ExtTrigExecutionContext;
import jp.go.aist.rtm.RTC.executionContext.PeriodicExecutionContext;
import jp.go.aist.rtm.RTC.log.LogStream;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.log.LogbufOn;
import jp.go.aist.rtm.RTC.log.MedLogbuf;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.RTCUtil;
import jp.go.aist.rtm.RTC.util.StringUtil;
import jp.go.aist.rtm.RTC.util.TimeValue;
import jp.go.aist.rtm.RTC.util.Timer;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manager {
    protected static Manager manager;
    protected static String manager_mutex;
    protected ORB m_pORB;
    protected POA m_pPOA;
    protected POAManager m_pPOAManager;
    protected ModuleInitProc m_initProc = null;
    protected Properties m_config = new Properties();
    protected ModuleManager m_module;
    protected NamingManager m_namingManager;
    protected CorbaObjectManager m_objManager;
    protected Timer m_timer;
    protected Logbuf m_Logbuf;
    protected MedLogbuf m_MedLogbuf;
    protected LogStream rtcout;
    protected ObjectManager<String, RTObject_impl> m_compManager = new ObjectManager();
    protected ObjectManager<String, FactoryBase> m_factory = new ObjectManager();
    protected ObjectManager<String, java.lang.Object> m_ecfactory = new ObjectManager();
    protected Vector<ExecutionContextBase> m_ecs = new Vector();
    protected OrbRunner m_runner = null;
    protected Terminator m_terminator = null;
    protected int m_terminate_waiting;

    static {
        manager_mutex = new String();
    }

    protected Manager() {
        this.m_Logbuf = new Logbuf();
        this.m_MedLogbuf = new MedLogbuf(this.m_Logbuf);
        this.rtcout = new LogStream(this.m_MedLogbuf);
    }

    public Manager(Manager rhs) {
        this.m_Logbuf = new Logbuf();
        this.m_MedLogbuf = new MedLogbuf(this.m_Logbuf);
        this.rtcout = new LogStream(this.m_MedLogbuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager init(String[] argv) {
        if (manager == null) {
            String string = manager_mutex;
            synchronized (string) {
                if (manager == null) {
                    try {
                        manager = new Manager();
                        manager.initManager(argv);
                        manager.initLogger();
                        manager.initORB();
                        manager.initNaming();
                        manager.initExecContext();
                        manager.initTimer();
                    }
                    catch (Exception e) {
                        manager = null;
                    }
                }
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manager instance() {
        if (manager == null) {
            String string = manager_mutex;
            synchronized (string) {
                if (manager == null) {
                    try {
                        manager = new Manager();
                        manager.initManager(null);
                        manager.initLogger();
                        manager.initORB();
                        manager.initNaming();
                        manager.initExecContext();
                        manager.initTimer();
                    }
                    catch (Exception e) {
                        manager = null;
                    }
                }
            }
        }
        return manager;
    }

    public void terminate() {
        if (this.m_terminator != null) {
            this.m_terminator.terminate();
        }
    }

    public void shutdown() {
        this.rtcout.println(6, "Manager.shutdown()");
        this.shutdownComponents();
        this.shutdownNaming();
        this.shutdownORB();
        this.shutdownManager();
        if (this.m_runner != null) {
            try {
                this.m_runner.wait();
            }
            catch (InterruptedException e) {
                this.rtcout.println(4, "Exception: Caught InterruptedException in Manager.shutdown().");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
        } else {
            this.join();
        }
        this.shutdownLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        this.rtcout.println(6, "Manager.join()");
        Integer n = this.m_terminate_waiting;
        synchronized (n) {
            ++this.m_terminate_waiting;
        }
        while (true) {
            n = this.m_terminate_waiting;
            synchronized (n) {
                if (this.m_terminate_waiting > 1) {
                    break;
                }
            }
            try {
                Thread.sleep(0L, 100000);
            }
            catch (InterruptedException e) {
                this.rtcout.println(4, "Exception: Caught InterruptedException in Manager.join().");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Logbuf getLogbuf() {
        return this.m_Logbuf;
    }

    public Properties getConfig() {
        return this.m_config;
    }

    public void setModuleInitProc(ModuleInitProc initProc) {
        this.m_initProc = initProc;
    }

    public boolean activateManager() {
        this.rtcout.println(6, "Manager.activateManager()");
        try {
            this.getPOAManager().activate();
            if (this.m_initProc != null) {
                this.m_initProc.myModuleInit(this);
            }
        }
        catch (Exception e) {
            this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.activateManager().");
            this.rtcout.println(4, e.getMessage());
            return false;
        }
        return true;
    }

    public void runManager() {
        this.runManager(false);
    }

    public void runManager(boolean noBlocking) {
        if (noBlocking) {
            this.rtcout.println(6, "Manager.runManager(): non-blocking mode");
            this.m_runner = new OrbRunner(this.m_pORB);
            this.m_runner.open("");
        } else {
            this.rtcout.println(6, "Manager.runManager(): blocking mode");
            this.m_pORB.run();
            this.rtcout.println(6, "Manager.runManager(): ORB was terminated");
            this.join();
        }
    }

    public void load(String moduleFileName, String initFunc) {
        this.rtcout.println(6, "Manager.load()");
        try {
            this.m_module.load(moduleFileName, initFunc);
        }
        catch (Exception e) {
            this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.load().");
            this.rtcout.println(4, e.getMessage());
            e.printStackTrace();
        }
    }

    public void unload(String moduleFileName) {
        this.rtcout.println(6, "Manager.unload()");
        this.m_module.unload(moduleFileName);
    }

    public void unloadAll() {
        this.rtcout.println(6, "Manager.unloadAll()");
        this.m_module.unloadAll();
    }

    public Vector<String> getLoadedModules() {
        this.rtcout.println(6, "Manager.getLoadedModules()");
        return this.m_module.getLoadedModules();
    }

    public Vector<String> getLoadableModules() {
        this.rtcout.println(6, "Manager.getLoadableModules()");
        return this.m_module.getLoadableModules();
    }

    public boolean registerFactory(Properties profile, RtcNewFunc new_func, RtcDeleteFunc delete_func) {
        this.rtcout.println(6, "Manager.registerFactory(" + profile.getProperty("type_name") + ")");
        try {
            FactoryJava factory = new FactoryJava(profile, new_func, delete_func);
            this.m_factory.registerObject(factory, new FactoryPredicate(factory));
            return true;
        }
        catch (Exception ex) {
            this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.registerFactory().");
            this.rtcout.println(4, ex.getMessage());
            return false;
        }
    }

    public boolean registerECFactory(String name) {
        this.rtcout.println(6, "Manager.registerECFactory(" + name + ")");
        try {
            ECFactoryJava factory = new ECFactoryJava(name);
            this.m_ecfactory.registerObject(factory, new ECFactoryPredicate(factory));
            return true;
        }
        catch (Exception ex) {
            this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.registerECFactory().");
            this.rtcout.println(4, ex.getMessage());
            return false;
        }
    }

    public Vector<String> getModulesFactories() {
        this.rtcout.println(6, "Manager.getModulesFactories()");
        Vector<String> factoryIds = new Vector<String>();
        int i = 0;
        while (i < this.m_factory.m_objects.size()) {
            factoryIds.add(((FactoryBase)this.m_factory.m_objects.elementAt(i)).profile().getProperty("implementation_id"));
            ++i;
        }
        return factoryIds;
    }

    public void clearModulesFactories() {
        this.m_factory = new ObjectManager();
    }

    public void clearModules() {
        this.m_compManager = new ObjectManager();
    }

    public RTObject_impl createComponent(String moduleName) {
        this.rtcout.println(6, "Manager.createComponent(" + moduleName + ")");
        RTObject_impl comp = null;
        int i = 0;
        while (i < this.m_factory.m_objects.size()) {
            FactoryBase factory = (FactoryBase)this.m_factory.m_objects.elementAt(i);
            if (factory.m_Profile.getProperty("implementation_id").equals(moduleName)) {
                comp = ((FactoryBase)this.m_factory.m_objects.elementAt(i)).create(this);
                if (comp == null) {
                    return null;
                }
                try {
                    this.m_objManager.activate(comp);
                }
                catch (ServantAlreadyActive e) {
                    this.rtcout.println(4, "Exception: Caught ServantAlreadyActive Exception in Manager.createComponent().");
                    this.rtcout.println(4, e.getMessage());
                    e.printStackTrace();
                }
                catch (WrongPolicy e) {
                    this.rtcout.println(4, "Exception: Caught WrongPolicy Exception in Manager.createComponent().");
                    this.rtcout.println(4, e.getMessage());
                    e.printStackTrace();
                }
                catch (ObjectNotActive e) {
                    this.rtcout.println(4, "Exception: Caught ObjectNotActive Exception in Manager.createComponent().");
                    this.rtcout.println(4, e.getMessage());
                    e.printStackTrace();
                }
                this.rtcout.println(6, "RTC Created: " + moduleName);
            }
            ++i;
        }
        this.configureComponent(comp);
        if (comp.initialize() != ReturnCode_t.RTC_OK) {
            this.rtcout.println(6, "RTC initialization failed: " + moduleName);
            comp.exit();
            return null;
        }
        this.rtcout.println(6, "RTC initialization succeeded: " + moduleName);
        this.bindExecutionContext(comp);
        this.registerComponent(comp);
        return comp;
    }

    public void cleanupComponent(RTObject_impl comp) {
        this.rtcout.println(6, "Manager.shutdownComponents()");
        this.unregisterComponent(comp);
    }

    public boolean registerComponent(RTObject_impl comp) {
        this.rtcout.println(6, "Manager.registerComponent(" + comp.getInstanceName() + ")");
        this.m_compManager.registerObject(comp, new InstanceName(comp));
        String[] names = comp.getNamingNames();
        int i = 0;
        while (i < names.length) {
            this.rtcout.println(6, "Bind name: " + names[i]);
            this.m_namingManager.bindObject(names[i], comp);
            ++i;
        }
        return true;
    }

    public boolean unregisterComponent(RTObject_impl comp) {
        this.rtcout.println(6, "Manager.unregisterComponent(" + comp.getInstanceName() + ")");
        this.m_compManager.unregisterObject(new InstanceName(comp));
        String[] names = comp.getNamingNames();
        int i = 0;
        while (i < names.length) {
            this.rtcout.println(6, "Unbind name: " + names[i]);
            this.m_namingManager.unbindObject(names[i]);
            ++i;
        }
        return true;
    }

    public boolean bindExecutionContext(RTObject_impl comp) {
        ExecutionContextBase exec_cxt;
        this.rtcout.println(6, "Manager.bindExecutionContext()");
        this.rtcout.println(6, "ExecutionContext type: " + this.m_config.getProperty("exec_cxt.periodic.type"));
        RTObject rtobj = comp.getObjRef();
        if (RTCUtil.isDataFlowParticipant(rtobj)) {
            String ectype = this.m_config.getProperty("exec_cxt.periodic.type");
            exec_cxt = ((ECFactoryBase)this.m_ecfactory.find(new ECFactoryPredicate(ectype))).create();
            try {
                this.m_objManager.activate(exec_cxt);
            }
            catch (ServantAlreadyActive e) {
                this.rtcout.println(4, "Exception: Caught ServantAlreadyActive Exception in Manager.bindExecutionContext() DataFlowParticipant.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (WrongPolicy e) {
                this.rtcout.println(4, "Exception: Caught WrongPolicy Exception in Manager.bindExecutionContext() DataFlowParticipant.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (ObjectNotActive e) {
                this.rtcout.println(4, "Exception: Caught ObjectNotActive Exception in Manager.bindExecutionContext() DataFlowParticipant.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            String rate = this.m_config.getProperty("exec_cxt.periodic.rate");
            exec_cxt.set_rate(Double.valueOf(rate));
        } else {
            String ectype = this.m_config.getProperty("exec_cxt.evdriven.type");
            exec_cxt = ((ECFactoryBase)this.m_ecfactory.find(new ECFactoryPredicate(ectype))).create();
            try {
                this.m_objManager.activate(exec_cxt);
            }
            catch (ServantAlreadyActive e) {
                this.rtcout.println(4, "Exception: Caught ServantAlreadyActive Exception in Manager.bindExecutionContext() FsmParticipant.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (WrongPolicy e) {
                this.rtcout.println(4, "Exception: Caught WrongPolicy Exception in Manager.bindExecutionContext() FsmParticipant.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (ObjectNotActive e) {
                this.rtcout.println(4, "Exception: Caught ObjectNotActive Exception in Manager.bindExecutionContext() FsmParticipant.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
        }
        exec_cxt.add(rtobj);
        exec_cxt.start();
        this.m_ecs.add(exec_cxt);
        return true;
    }

    public void deleteComponent(String instanceName) {
        this.rtcout.println(6, "Manager.deleteComponent(" + instanceName + ")");
    }

    public RTObject_impl getComponent(String instanceName) {
        this.rtcout.println(6, "Manager.getComponent(" + instanceName + ")");
        return null;
    }

    public Vector<RTObject_impl> getComponents() {
        this.rtcout.println(6, "Manager.getComponents()");
        return this.m_compManager.getObjects();
    }

    public ORB getORB() {
        this.rtcout.println(6, "Manager.getORB()");
        return this.m_pORB;
    }

    public POA getPOA() {
        this.rtcout.println(6, "Manager.getPOA()");
        return this.m_pPOA;
    }

    public POAManager getPOAManager() {
        this.rtcout.println(6, "Manager.getPOAManager()");
        return this.m_pPOAManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initManager(String[] argv) throws Exception {
        ManagerConfig config = new ManagerConfig(argv);
        if (this.m_config == null) {
            this.m_config = new Properties();
        }
        config.configure(this.m_config);
        this.m_config.setProperty("logger.file_name", this.formatString(this.m_config.getProperty("logger.file_name"), this.m_config));
        this.m_module = new ModuleManager(this.m_config);
        Terminator terminator = this.m_terminator = new Terminator(this);
        synchronized (terminator) {
            this.m_terminate_waiting = 0;
        }
        if (StringUtil.toBool(this.m_config.getProperty("timer.enable"), "YES", "NO", true)) {
            TimeValue tm = new TimeValue(0L, 100L);
            String tick = new String(this.m_config.getProperty("timer.tick"));
            if (tick != null && !tick.equals("")) {
                tm.convert(Double.valueOf(tick));
                this.m_timer = new Timer(tm);
                this.m_timer.start();
            }
        }
    }

    protected void shutdownManager() {
        this.rtcout.println(6, "Manager.shutdownManager()");
    }

    protected boolean initLogger() {
        this.rtcout.setLogLevel(0);
        if (StringUtil.toBool(this.m_config.getProperty("logger.enable"), "YES", "NO", true)) {
            this.m_Logbuf = new LogbufOn();
            String logfile = new String(this.m_config.getProperty("logger.file_name"));
            if (logfile == null || logfile.equals("")) {
                logfile = "./rtc.log";
            }
            try {
                this.m_Logbuf.open(new FileHandler(logfile));
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.m_MedLogbuf = new MedLogbuf(this.m_Logbuf);
            this.rtcout = new LogStream(this.m_MedLogbuf);
            this.m_MedLogbuf.setSuffix(this.m_config.getProperty("manager.name"));
            this.m_MedLogbuf.setDateFmt(this.m_config.getProperty("logger.date_format"));
            this.rtcout.setLogLevel(this.m_config.getProperty("logger.log_level"));
            this.rtcout.setLogLock(StringUtil.toBool(this.m_config.getProperty("logger.stream_lock"), "enable", "disable", false));
            this.rtcout.println(3, this.m_config.getProperty("openrtm.version"));
            this.rtcout.println(3, "Copyright (C) 2003-2008");
            this.rtcout.println(3, "  Noriaki Ando");
            this.rtcout.println(3, "  Task-intelligence Research Group,");
            this.rtcout.println(3, "  Intelligent Systems Research Institute, AIST");
            this.rtcout.println(3, "Manager starting.");
            this.rtcout.println(3, "Starting local logging.");
        }
        return true;
    }

    protected void shutdownLogger() {
        this.rtcout.println(6, "Manager.shutdownLogger()");
    }

    protected boolean initORB() {
        block3: {
            this.rtcout.println(6, "Manager.initORB()");
            try {
                String[] args = this.createORBOptions().split(" ");
                this.m_pORB = ORBUtil.getOrb(args);
                Object obj = this.m_pORB.resolve_initial_references("RootPOA");
                this.m_pPOA = POAHelper.narrow((Object)obj);
                if (this.m_pPOA != null) break block3;
                this.rtcout.println(1, "Could not resolve RootPOA.");
                return false;
            }
            catch (Exception ex) {
                this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.initORB().");
                this.rtcout.println(4, ex.getMessage());
                return false;
            }
        }
        this.m_pPOAManager = this.m_pPOA.the_POAManager();
        this.m_objManager = new CorbaObjectManager(this.m_pORB, this.m_pPOA);
        return true;
    }

    protected String createORBOptions() {
        String opt = new String(this.m_config.getProperty("corba.args"));
        String corba = new String(this.m_config.getProperty("corba.id"));
        String endpoint = new String(this.m_config.getProperty("corba.endpoint"));
        if (endpoint != null && endpoint.length() != 0) {
            if (opt != null && opt.length() != 0) {
                opt = String.valueOf(opt) + " ";
            }
            if (corba.equals("omniORB")) {
                opt = "-ORBendPoint giop:tcp:" + endpoint;
            } else if (corba.equals("TAO")) {
                opt = "-ORBEndPoint iiop://" + endpoint;
            } else if (corba.equals("MICO")) {
                opt = "-ORBIIOPAddr inet:" + endpoint;
            }
        }
        return opt;
    }

    protected void shutdownORB() {
        this.rtcout.println(6, "Manager.shutdownORB()");
        try {
            while (this.m_pORB.work_pending()) {
                this.rtcout.println(8, "Pending work still exists.");
                if (!this.m_pORB.work_pending()) continue;
                this.m_pORB.perform_work();
            }
        }
        catch (Exception e) {
            this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.shutdownORB().");
            this.rtcout.println(4, e.getMessage());
            e.getStackTrace();
        }
        this.rtcout.println(5, "No pending works of ORB. Shutting down POA and ORB.");
        if (this.m_pPOA != null) {
            try {
                if (this.m_pPOAManager != null) {
                    this.m_pPOAManager.deactivate(false, true);
                }
                this.rtcout.println(5, "POA Manager was deactivated.");
                this.m_pPOA.destroy(false, true);
                this.m_pPOA = null;
                this.rtcout.println(5, "POA was destroid.");
            }
            catch (SystemException ex) {
                this.rtcout.println(1, "Caught SystemException during root POA destruction");
            }
            catch (Exception ex) {
                this.rtcout.println(1, "Caught unknown exception during POA destruction.");
            }
        }
        if (this.m_pORB != null) {
            try {
                this.m_pORB.shutdown(true);
                this.rtcout.println(5, "ORB was shutdown.");
                this.rtcout.println(5, "ORB was destroied.");
                this.m_pORB = null;
            }
            catch (SystemException ex) {
                this.rtcout.println(1, "Caught SystemException during ORB shutdown");
            }
            catch (Exception ex) {
                this.rtcout.println(1, "Caught unknown exception during ORB shutdown.");
            }
        }
    }

    protected boolean initNaming() {
        this.rtcout.println(6, "Manager.initNaming()");
        this.m_namingManager = new NamingManager(this);
        if (!StringUtil.toBool(this.m_config.getProperty("naming.enable"), "YES", "NO", true)) {
            return true;
        }
        String[] meth = this.m_config.getProperty("naming.type").split(",");
        int i = 0;
        while (i < meth.length) {
            String[] names = this.m_config.getProperty(String.valueOf(meth[i]) + ".nameservers").split(",");
            int j = 0;
            while (j < names.length) {
                this.rtcout.println(6, "Register Naming Server: " + meth[i] + " " + names[j]);
                String[] nameServer = names[j].split(":");
                if (nameServer.length == 1 && !nameServer[0].equals("")) {
                    int n = j;
                    names[n] = String.valueOf(names[n]) + ":2809";
                }
                if (!names[j].equals("")) {
                    this.m_namingManager.registerNameServer(meth[i], names[j]);
                }
                ++j;
            }
            ++i;
        }
        if (StringUtil.toBool(this.m_config.getProperty("naming.update.enable"), "YES", "NO", true)) {
            TimeValue tm = new TimeValue(10L, 0L);
            String intr = new String(this.m_config.getProperty("naming.update.interval"));
            if (intr != null && !intr.equals("")) {
                tm.convert(Double.valueOf(intr));
            }
            if (this.m_timer != null) {
                this.m_timer.registerListenerObj(this.m_namingManager, tm);
            }
        }
        return true;
    }

    protected void shutdownNaming() {
        this.rtcout.println(6, "Manager.shutdownNaming()");
        this.m_namingManager.unbindAll();
    }

    protected void shutdownComponents() {
        this.rtcout.println(6, "Manager.shutdownComponents()");
        Vector<RTObject_impl> comps = this.m_namingManager.getObjects();
        int i = 0;
        while (i < comps.size()) {
            try {
                comps.elementAt(i).exit();
                Properties p = new Properties(comps.elementAt(i).getInstanceName());
                p.merge(comps.elementAt(i).getProperties());
                this.rtcout.level(8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.m_ecs.size()) {
            try {
                this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_ecs.elementAt(i)));
            }
            catch (Exception e) {
                this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.shutdownComponents().");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
    }

    protected void configureComponent(RTObject_impl comp) {
        BufferedReader conff;
        String category = new String(comp.getCategory());
        String type_name = new String(comp.getTypeName());
        String inst_name = new String(comp.getInstanceName());
        String type_conf = new String(String.valueOf(category) + "." + type_name + ".config_file");
        String name_conf = new String(String.valueOf(category) + "." + inst_name + ".config_file");
        Properties type_prop = new Properties();
        Properties name_prop = new Properties();
        if (this.m_config.getProperty(name_conf) != null && this.m_config.getProperty(name_conf).length() != 0) {
            try {
                conff = new BufferedReader(new FileReader(this.m_config.getProperty(name_conf)));
                name_prop.load(conff);
            }
            catch (FileNotFoundException e) {
                this.rtcout.println(4, "Exception: Caught FileNotFoundException in Manager.configureComponent() name_conf.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                this.rtcout.println(4, "Exception: Caught unknown in Manager.configureComponent() name_conf.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.m_config.getProperty(type_conf) != null && this.m_config.getProperty(type_conf).length() != 0) {
            try {
                conff = new BufferedReader(new FileReader(this.m_config.getProperty(type_conf)));
                type_prop.load(conff);
            }
            catch (FileNotFoundException e) {
                this.rtcout.println(4, "Exception: Caught FileNotFoundException in Manager.configureComponent() type_conf.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.configureComponent() type_conf.");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
        }
        type_prop.merge(name_prop);
        comp.getProperties().merge(type_prop);
        StringBuffer naming_formats = new StringBuffer();
        Properties comp_prop = comp.getProperties();
        naming_formats.append(this.m_config.getProperty("naming.formats"));
        naming_formats.append(", " + comp_prop.getProperty("naming.formats"));
        String naming_formats_result = StringUtil.flatten(StringUtil.unique_sv(naming_formats.toString().split(",")));
        comp.getProperties().setProperty("naming.formats", naming_formats.toString());
        String naming_names = this.formatString(naming_formats_result, comp.getProperties());
        comp.getProperties().setProperty("naming.names", naming_names);
    }

    protected boolean initExecContext() {
        this.rtcout.println(6, "Manager::initExecContext()");
        PeriodicExecutionContext.PeriodicExecutionContextInit(this);
        ExtTrigExecutionContext.ExtTrigExecutionContextInit(this);
        return true;
    }

    protected boolean initTimer() {
        return true;
    }

    protected boolean mergeProperty(Properties properties, String fileName) {
        if (fileName == null) {
            this.rtcout.println(1, "Invalid configuration file name.");
            return false;
        }
        if (fileName.length() != 0) {
            try {
                BufferedReader conff = new BufferedReader(new FileReader(fileName));
                properties.load(conff);
                conff.close();
                return true;
            }
            catch (FileNotFoundException e) {
                this.rtcout.println(4, "Exception: Caught FileNotFoundException in Manager.mergeProperty().");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                this.rtcout.println(4, "Exception: Caught unknown Exception in Manager.mergeProperty().");
                this.rtcout.println(4, e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }

    protected String formatString(String namingFormat, Properties properties) {
        StringBuffer str = new StringBuffer();
        int count = 0;
        int i = 0;
        while (i < namingFormat.length()) {
            char c = namingFormat.charAt(i);
            if (c == '%') {
                if (++count % 2 == 0) {
                    str.append(c);
                }
            } else if (count > 0 && count % 2 != 0) {
                count = 0;
                if (c == 'n') {
                    str.append(properties.getProperty("instance_name"));
                } else if (c == 't') {
                    str.append(properties.getProperty("type_name"));
                } else if (c == 'm') {
                    str.append(properties.getProperty("type_name"));
                } else if (c == 'v') {
                    str.append(properties.getProperty("version"));
                } else if (c == 'V') {
                    str.append(properties.getProperty("vendor"));
                } else if (c == 'c') {
                    str.append(properties.getProperty("category"));
                } else if (c == 'h') {
                    str.append(this.m_config.getProperty("manager.os.hostname"));
                } else if (c == 'M') {
                    str.append(this.m_config.getProperty("manager.name"));
                } else if (c == 'p') {
                    str.append(this.m_config.getProperty("manager.pid"));
                } else {
                    str.append(c);
                }
            } else {
                count = 0;
                str.append(c);
            }
            ++i;
        }
        return str.toString();
    }

    protected class InstanceName
    implements equalFunctor {
        public String m_name;

        public InstanceName(RTObject_impl comp) {
            this.m_name = new String(comp.getInstanceName());
        }

        public InstanceName(String name) {
            this.m_name = new String(name);
        }

        public boolean equalof(java.lang.Object comp) {
            return this.m_name.equals(((RTObject_impl)comp).getInstanceName());
        }
    }

    protected class FactoryPredicate
    implements equalFunctor {
        public String m_name;

        public FactoryPredicate(String name) {
            this.m_name = name;
        }

        public FactoryPredicate(FactoryBase factory) {
            this.m_name = factory.profile().getProperty("implementation_id");
        }

        public boolean equalof(java.lang.Object factory) {
            return this.m_name.equals(((FactoryBase)factory).profile().getProperty("implementation_id"));
        }
    }

    class ECFactoryPredicate
    implements equalFunctor {
        public String m_name;

        public ECFactoryPredicate(String name) {
            this.m_name = name;
        }

        public ECFactoryPredicate(ECFactoryBase factory) {
            this.m_name = factory.name();
        }

        public boolean equalof(java.lang.Object factory) {
            return this.m_name.equals(((ECFactoryBase)factory).name());
        }
    }

    protected class OrbRunner
    implements Runnable {
        private ORB m_pORB;

        public OrbRunner(ORB orb) {
            this.m_pORB = orb;
            this.open("");
        }

        public int open(String args) {
            Thread t = new Thread(this);
            t.start();
            return 0;
        }

        public int svc() {
            this.m_pORB.run();
            Manager.instance().shutdown();
            return 0;
        }

        public int close(long flags) {
            return 0;
        }

        public void run() {
            this.svc();
        }
    }

    protected class Terminator
    implements Runnable {
        public Manager m_manager;

        public Terminator(Manager manager2) {
            this.m_manager = manager2;
        }

        public void terminate() {
            this.open("");
        }

        public int open(String args) {
            Thread t = new Thread(this);
            t.start();
            return 0;
        }

        public int svc() {
            Manager.instance().shutdown();
            return 0;
        }

        public void run() {
            this.svc();
        }
    }
}

