/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;
import jp.go.aist.rtm.RTC.DefaultConfiguration;
import jp.go.aist.rtm.RTC.util.Properties;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ManagerConfig {
    public static final String[] CONFIG_FILE_PATH;
    public static final String CONFIG_FILE_ENV = "RTC_MANAGER_CONFIG";
    protected String m_configFile;

    static {
        String[] stringArray = new String[6];
        stringArray[0] = "./rtc.conf";
        stringArray[1] = "/etc/rtc.conf";
        stringArray[2] = "/etc/rtc/rtc.conf";
        stringArray[3] = "/usr/local/etc/rtc.conf";
        stringArray[4] = "/usr/local/etc/rtc/rtc.conf";
        CONFIG_FILE_PATH = stringArray;
    }

    public ManagerConfig() {
    }

    public ManagerConfig(String[] args) throws Exception {
        this.init(args);
    }

    public void init(String[] args) throws Exception {
        this.parseArgs(args);
    }

    public void configure(Properties properties) throws FileNotFoundException, IOException {
        properties.setDefaults(DefaultConfiguration.default_config);
        if (this.findConfigFile()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.m_configFile));
                properties.load(reader);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        this.setSystemInformation(properties);
    }

    protected void parseArgs(String[] args) throws IllegalArgumentException {
        CommandLine commandLine;
        Options options = new Options();
        options.addOption("f", true, "configuration file");
        options.addOption("l", true, "load module");
        options.addOption("o", true, "other options");
        options.addOption("d", false, "use default configuration");
        try {
            BasicParser parser = new BasicParser();
            commandLine = parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse arguments.");
        }
        if (commandLine.hasOption("f")) {
            this.m_configFile = commandLine.getOptionValue("f");
        }
        commandLine.hasOption("l");
        commandLine.hasOption("o");
        commandLine.hasOption("d");
    }

    protected boolean findConfigFile() {
        if (this.m_configFile != null && this.m_configFile.length() != 0 && this.fileExist(this.m_configFile)) {
            return true;
        }
        String env = System.getenv(CONFIG_FILE_ENV);
        if (env != null && this.fileExist(env)) {
            this.m_configFile = env;
            return true;
        }
        int i = 0;
        while (CONFIG_FILE_PATH[i] != null) {
            if (this.fileExist(CONFIG_FILE_PATH[i])) {
                this.m_configFile = CONFIG_FILE_PATH[i];
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setSystemInformation(Properties properties) {
        String osName = "UNKNOWN";
        String osRelease = "UNKNOWN";
        String osVersion = "UNKNOWN";
        String osArch = "UNKNOWN";
        String hostName = "UNKNOWN";
        String pid = "UNKNOWN";
        try {
            java.util.Properties sysInfo = System.getProperties();
            osName = sysInfo.getProperty("os.name");
            osVersion = sysInfo.getProperty("os.version");
            osArch = sysInfo.getProperty("os.arch");
            pid = String.valueOf(System.getProperty("java.version")) + new Random().nextInt();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
        }
        properties.setProperty("manager.os.name", osName);
        properties.setProperty("manager.os.release", osRelease);
        properties.setProperty("manager.os.version", osVersion);
        properties.setProperty("manager.os.arch", osArch);
        properties.setProperty("manager.os.hostname", hostName);
        properties.setProperty("manager.pid", pid);
    }

    protected boolean fileExist(String filePath) {
        return new File(filePath).exists();
    }
}

