/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.Vector;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.NamingBase;
import jp.go.aist.rtm.RTC.NamingOnCorba;
import jp.go.aist.rtm.RTC.RTObject_impl;
import jp.go.aist.rtm.RTC.log.LogStream;
import jp.go.aist.rtm.RTC.log.MedLogbuf;
import jp.go.aist.rtm.RTC.util.CallbackFunction;
import jp.go.aist.rtm.RTC.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingManager
implements NamingBase,
CallbackFunction {
    protected Vector<Names> m_names = new Vector();
    protected Vector<Comps> m_compNames = new Vector();
    protected Manager m_manager;
    protected MedLogbuf m_MedLogbuf;
    protected LogStream rtcout;

    public NamingManager(Manager manager) {
        this.m_manager = manager;
        this.m_MedLogbuf = new MedLogbuf(manager.getLogbuf());
        this.rtcout = new LogStream(this.m_MedLogbuf);
        this.m_MedLogbuf.setSuffix("naming_svc");
        this.m_MedLogbuf.setDateFmt(manager.getConfig().getProperty("logger.date_format"));
        this.rtcout.setLogLevel(manager.getConfig().getProperty("logger.log_level"));
        this.rtcout.setLogLock(StringUtil.toBool(manager.getConfig().getProperty("logger.stream_lock"), "enable", "disable", false));
    }

    public void registerNameServer(String method, String name_server) {
        this.rtcout.println(6, "NamingManager::registerNameServer(" + method + ", " + name_server + ")");
        NamingBase name = this.createNamingObj(method, name_server);
        this.m_names.add(new Names(method, name_server, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindObject(String name, RTObject_impl rtobj) {
        this.rtcout.println(6, "NamingManager::bindObject(" + name + ")");
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int intIdx = 0;
            while (intIdx < this.m_names.size()) {
                if (this.m_names.elementAt((int)intIdx).ns != null) {
                    this.m_names.elementAt((int)intIdx).ns.bindObject(name, rtobj);
                }
                ++intIdx;
            }
            this.registerCompName(name, rtobj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        this.rtcout.println(6, "NamingManager::update()");
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int intIdx = 0;
            while (intIdx < this.m_names.size()) {
                NamingBase nsobj;
                if (this.m_names.elementAt((int)intIdx).ns == null && (nsobj = this.createNamingObj(this.m_names.elementAt((int)intIdx).method, this.m_names.elementAt((int)intIdx).nsname)) != null) {
                    this.rtcout.println(3, "New name server found: " + this.m_names.elementAt((int)intIdx).method + "/" + this.m_names.elementAt((int)intIdx).nsname);
                    this.m_names.elementAt((int)intIdx).ns = nsobj;
                    this.bindCompsTo(nsobj);
                }
                ++intIdx;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindObject(String name) {
        this.rtcout.println(6, "NamingManager::unbindObject(" + name + ")");
        Vector<Names> vector = this.m_names;
        synchronized (vector) {
            int intIdx = 0;
            while (intIdx < this.m_names.size()) {
                if (this.m_names.elementAt((int)intIdx).ns != null) {
                    this.m_names.elementAt((int)intIdx).ns.unbindObject(name);
                }
                ++intIdx;
            }
            this.unregisterCompName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindAll() {
        this.rtcout.println(6, "NamingManager::unbindAll(): " + this.m_compNames.size() + " names.");
        Vector<Comps> vector = this.m_compNames;
        synchronized (vector) {
            int intIdx = 0;
            while (intIdx < this.m_compNames.size()) {
                this.unbindObject(this.m_compNames.elementAt((int)intIdx).name);
                ++intIdx;
            }
        }
    }

    protected synchronized Vector<RTObject_impl> getObjects() {
        Vector<RTObject_impl> comps = new Vector<RTObject_impl>();
        int intIdx = 0;
        while (intIdx < this.m_compNames.size()) {
            comps.add(this.m_compNames.elementAt((int)intIdx).rtobj);
            ++intIdx;
        }
        return comps;
    }

    protected NamingBase createNamingObj(String method, String name_server) {
        String m = new String(method);
        if (m.endsWith("corba")) {
            NamingOnCorba name;
            block4: {
                try {
                    NamingOnCorba nameb;
                    name = nameb = new NamingOnCorba(this.m_manager.getORB(), name_server);
                    if (name != null) break block4;
                    return null;
                }
                catch (Exception ex) {
                    this.rtcout.println(3, "NameServer connection failed: " + method + "/" + name_server);
                    return null;
                }
            }
            this.rtcout.println(3, "NameServer connection succeeded: " + method + "/" + name_server);
            return name;
        }
        return null;
    }

    protected void bindCompsTo(NamingBase ns) {
        int intIdx = 0;
        while (intIdx < this.m_compNames.size()) {
            ns.bindObject(this.m_compNames.elementAt((int)intIdx).name, this.m_compNames.elementAt((int)intIdx).rtobj);
            ++intIdx;
        }
    }

    protected void registerCompName(String name, RTObject_impl rtobj) {
        int intIdx = 0;
        while (intIdx < this.m_compNames.size()) {
            if (this.m_compNames.elementAt((int)intIdx).name.equals(name)) {
                this.m_compNames.elementAt((int)intIdx).rtobj = rtobj;
                return;
            }
            ++intIdx;
        }
        this.m_compNames.add(new Comps(name, rtobj));
    }

    protected void unregisterCompName(String name) {
        int intIdx = 0;
        while (intIdx < this.m_compNames.size()) {
            if (this.m_compNames.elementAt((int)intIdx).name.equals(name)) {
                this.m_compNames.remove(this.m_compNames.elementAt(intIdx));
                return;
            }
            ++intIdx;
        }
    }

    @Override
    public void doOperate() {
        this.update();
    }

    protected class Names {
        public String method;
        public String nsname;
        public NamingBase ns;

        public Names(String meth, String name, NamingBase naming) {
            this.method = new String(meth);
            this.nsname = new String(name);
            this.ns = naming;
        }
    }

    protected class Comps {
        public String name;
        public RTObject_impl rtobj;

        public Comps(String n, RTObject_impl obj) {
            this.name = new String(n);
            this.rtobj = obj;
        }
    }
}

