/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.util.HashMap;
import jp.go.aist.rtm.RTC.StateAction;
import jp.go.aist.rtm.RTC.StateHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachine<STATE, LISTENER> {
    protected int m_num;
    protected LISTENER m_listener;
    protected HashMap<STATE, StateAction> m_entry;
    protected HashMap<STATE, StateAction> m_predo;
    protected HashMap<STATE, StateAction> m_do;
    protected HashMap<STATE, StateAction> m_postdo;
    protected HashMap<STATE, StateAction> m_exit;
    protected StateAction m_transit;
    protected StateHolder<STATE> m_states = new StateHolder();
    protected boolean m_selftrans;

    public StateMachine(int num_of_state) {
        this.m_num = num_of_state;
        this.m_entry = new HashMap();
        this.m_predo = new HashMap();
        this.m_do = new HashMap();
        this.m_postdo = new HashMap();
        this.m_exit = new HashMap();
        this.m_transit = null;
    }

    public void setNOP() {
        this.m_entry = new HashMap();
        this.m_predo = new HashMap();
        this.m_do = new HashMap();
        this.m_postdo = new HashMap();
        this.m_exit = new HashMap();
        this.m_transit = null;
    }

    public void setListener(LISTENER listener) {
        this.m_listener = listener;
    }

    public boolean setEntryAction(STATE state, StateAction call_back) {
        this.m_entry.put(state, call_back);
        return true;
    }

    public boolean setPreDoAction(STATE state, StateAction call_back) {
        this.m_predo.put(state, call_back);
        return true;
    }

    public boolean setDoAction(STATE state, StateAction call_back) {
        this.m_do.put(state, call_back);
        return true;
    }

    public boolean setPostDoAction(STATE state, StateAction call_back) {
        this.m_postdo.put(state, call_back);
        return true;
    }

    public boolean setExitAction(STATE state, StateAction call_back) {
        this.m_exit.put(state, call_back);
        return true;
    }

    public boolean setTransitionAction(StateAction call_back) {
        this.m_transit = call_back;
        return true;
    }

    public void setStartState(StateHolder states) {
        this.m_states.curr = states.curr;
        this.m_states.prev = states.prev;
        this.m_states.next = states.next;
    }

    public synchronized STATE getState() {
        return this.m_states.curr;
    }

    public synchronized boolean isIn(STATE state) {
        return this.m_states.curr == state;
    }

    public synchronized void goTo(STATE state) {
        this.m_states.next = state;
        if (this.m_states.curr == state) {
            this.m_selftrans = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void worker() {
        StateHolder state;
        StateHolder<STATE> stateHolder = this.m_states;
        synchronized (stateHolder) {
            state = new StateHolder(this.m_states);
        }
        if (state.curr == state.next) {
            if (this.m_predo.get(state.curr) != null) {
                this.m_predo.get(state.curr).doAction(state);
            }
            if (this.need_trans()) {
                return;
            }
            if (this.m_do.get(state.curr) != null) {
                this.m_do.get(state.curr).doAction(state);
            }
            if (this.need_trans()) {
                return;
            }
            if (this.m_postdo.get(state.curr) != null) {
                this.m_postdo.get(state.curr).doAction(state);
            }
        } else {
            if (this.m_exit.get(state.curr) != null) {
                this.m_exit.get(state.curr).doAction(state);
            }
            stateHolder = this.m_states;
            synchronized (stateHolder) {
                state = new StateHolder(this.m_states);
            }
            if (state.curr != state.next) {
                state.curr = state.next;
                if (this.m_entry.get(state.curr) != null) {
                    this.m_entry.get(state.curr).doAction(state);
                }
                this.update_curr(state.curr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean need_trans() {
        StateHolder<STATE> stateHolder = this.m_states;
        synchronized (stateHolder) {
            return this.m_states.curr != this.m_states.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update_curr(STATE curr) {
        StateHolder<STATE> stateHolder = this.m_states;
        synchronized (stateHolder) {
            this.m_states.curr = curr;
        }
    }
}

