/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import java.util.Vector;
import jp.go.aist.rtm.RTC.util.CallbackFunction;
import jp.go.aist.rtm.RTC.util.ListenerBase;
import jp.go.aist.rtm.RTC.util.ListenerObject;
import jp.go.aist.rtm.RTC.util.TimeValue;

public class Timer
implements Runnable {
    private TimeValue m_interval = new TimeValue();
    private boolean m_running;
    private Vector<Task> m_tasks = new Vector();

    public Timer(TimeValue interval) {
        this.m_interval = new TimeValue(interval);
        this.m_running = false;
    }

    public int open() {
        Thread t = new Thread(this);
        t.start();
        return 0;
    }

    public int svc() {
        while (this.m_running) {
            try {
                this.invoke();
                if (this.m_interval.getSec() != 0L) {
                    Thread.sleep(this.m_interval.getSec() * 1000L);
                }
                Thread.sleep(0L, (int)this.m_interval.getUsec());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public void run() {
        this.svc();
    }

    public synchronized void start() {
        if (!this.m_running) {
            this.m_running = true;
            this.open();
        }
    }

    public synchronized void stop() {
        this.m_running = false;
    }

    public void invoke() {
        if (this.m_tasks == null) {
            this.m_tasks = new Vector();
        }
        int intIdx = 0;
        while (intIdx < this.m_tasks.size()) {
            this.m_tasks.elementAt((int)intIdx).remains = this.m_tasks.elementAt((int)intIdx).remains.minus(this.m_interval);
            if (this.m_tasks.elementAt((int)intIdx).remains.getUsec() < 0L) {
                this.m_tasks.elementAt((int)intIdx).listener.invoke();
                this.m_tasks.elementAt((int)intIdx).remains = this.m_tasks.elementAt((int)intIdx).period;
            }
            ++intIdx;
        }
    }

    public synchronized ListenerBase registerListener(ListenerBase listener, TimeValue tm) {
        if (this.m_tasks == null) {
            this.m_tasks = new Vector();
        }
        int intIdx = 0;
        while (intIdx < this.m_tasks.size()) {
            if (this.m_tasks.elementAt((int)intIdx).listener.equals(listener)) {
                this.m_tasks.elementAt((int)intIdx).period = tm;
                this.m_tasks.elementAt((int)intIdx).remains = tm;
                return listener;
            }
            ++intIdx;
        }
        this.m_tasks.add(new Task(listener, tm));
        return listener;
    }

    public ListenerBase registerListenerObj(CallbackFunction cbf, TimeValue tm) {
        return this.registerListener(new ListenerObject(cbf), tm);
    }

    public synchronized boolean unregisterListener(ListenerBase id) {
        int intidx = 0;
        while (intidx < this.m_tasks.size()) {
            if (this.m_tasks.elementAt((int)intidx).listener.equals(id)) {
                this.m_tasks.remove(this.m_tasks.elementAt(intidx));
                return true;
            }
            ++intidx;
        }
        return false;
    }

    private class Task {
        public ListenerBase listener;
        TimeValue period;
        TimeValue remains;

        public Task(ListenerBase l, TimeValue p) {
            this.listener = l;
            this.period = new TimeValue(p);
            this.remains = new TimeValue(p);
        }
    }
}

