/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.util;

import RTC.Time;
import RTC.TimeHelper;
import RTC.TimedBoolean;
import RTC.TimedBooleanHelper;
import RTC.TimedBooleanSeq;
import RTC.TimedBooleanSeqHelper;
import RTC.TimedChar;
import RTC.TimedCharHelper;
import RTC.TimedCharSeq;
import RTC.TimedCharSeqHelper;
import RTC.TimedDouble;
import RTC.TimedDoubleHelper;
import RTC.TimedDoubleSeq;
import RTC.TimedDoubleSeqHelper;
import RTC.TimedFloat;
import RTC.TimedFloatHelper;
import RTC.TimedFloatSeq;
import RTC.TimedFloatSeqHelper;
import RTC.TimedLong;
import RTC.TimedLongHelper;
import RTC.TimedLongSeq;
import RTC.TimedLongSeqHelper;
import RTC.TimedOctet;
import RTC.TimedOctetHelper;
import RTC.TimedOctetSeq;
import RTC.TimedOctetSeqHelper;
import RTC.TimedShort;
import RTC.TimedShortHelper;
import RTC.TimedShortSeq;
import RTC.TimedShortSeqHelper;
import RTC.TimedState;
import RTC.TimedStateHelper;
import RTC.TimedString;
import RTC.TimedStringHelper;
import RTC.TimedStringSeq;
import RTC.TimedStringSeqHelper;
import RTC.TimedULong;
import RTC.TimedULongHelper;
import RTC.TimedULongSeq;
import RTC.TimedULongSeqHelper;
import RTC.TimedUShort;
import RTC.TimedUShortHelper;
import RTC.TimedUShortSeq;
import RTC.TimedUShortSeqHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeCast<T> {
    private Class<T> klass;

    public TypeCast(Class<T> klass) {
        assert (klass != null);
        this.klass = klass;
    }

    public T castType(Any data) {
        if (this.klass.equals(Byte.class)) {
            return this.klass.cast(data.extract_octet());
        }
        if (this.klass.equals(Double.class)) {
            return this.klass.cast(data.extract_double());
        }
        if (this.klass.equals(Float.class)) {
            return this.klass.cast(Float.valueOf(data.extract_float()));
        }
        if (this.klass.equals(Integer.class)) {
            return this.klass.cast(data.extract_long());
        }
        if (this.klass.equals(Long.class)) {
            return this.klass.cast(data.extract_longlong());
        }
        if (this.klass.equals(Short.class)) {
            return this.klass.cast(data.extract_short());
        }
        if (this.klass.equals(Time.class)) {
            return this.klass.cast(TimeHelper.extract(data));
        }
        if (this.klass.equals(TimedBoolean.class)) {
            return this.klass.cast(TimedBooleanHelper.extract(data));
        }
        if (this.klass.equals(TimedChar.class)) {
            return this.klass.cast(TimedCharHelper.extract(data));
        }
        if (this.klass.equals(TimedDouble.class)) {
            return this.klass.cast(TimedDoubleHelper.extract(data));
        }
        if (this.klass.equals(TimedFloat.class)) {
            return this.klass.cast(TimedFloatHelper.extract(data));
        }
        if (this.klass.equals(TimedLong.class)) {
            return this.klass.cast(TimedLongHelper.extract(data));
        }
        if (this.klass.equals(TimedOctet.class)) {
            return this.klass.cast(TimedOctetHelper.extract(data));
        }
        if (this.klass.equals(TimedShort.class)) {
            return this.klass.cast(TimedShortHelper.extract(data));
        }
        if (this.klass.equals(TimedState.class)) {
            return this.klass.cast(TimedStateHelper.extract(data));
        }
        if (this.klass.equals(TimedString.class)) {
            return this.klass.cast(TimedStringHelper.extract(data));
        }
        if (this.klass.equals(TimedULong.class)) {
            return this.klass.cast(TimedULongHelper.extract(data));
        }
        if (this.klass.equals(TimedUShort.class)) {
            return this.klass.cast(TimedUShortHelper.extract(data));
        }
        if (this.klass.equals(TimedBooleanSeq.class)) {
            return this.klass.cast(TimedBooleanSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedCharSeq.class)) {
            return this.klass.cast(TimedCharSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedDoubleSeq.class)) {
            return this.klass.cast(TimedDoubleSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedFloatSeq.class)) {
            return this.klass.cast(TimedFloatSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedLongSeq.class)) {
            return this.klass.cast(TimedLongSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedOctetSeq.class)) {
            return this.klass.cast(TimedOctetSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedShortSeq.class)) {
            return this.klass.cast(TimedShortSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedStringSeq.class)) {
            return this.klass.cast(TimedStringSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedULongSeq.class)) {
            return this.klass.cast(TimedULongSeqHelper.extract(data));
        }
        if (this.klass.equals(TimedUShortSeq.class)) {
            return this.klass.cast(TimedUShortSeqHelper.extract(data));
        }
        String className = this.klass.getCanonicalName();
        if (className == null) {
            throw new IllegalStateException("Cannot get class name.");
        }
        try {
            Class<?> helper = Class.forName(String.valueOf(className) + "Helper", true, this.klass.getClassLoader());
            Method method = helper.getMethod("extract", Any.class);
            java.lang.Object targetObject = method.invoke(null, data);
            return this.klass.cast(targetObject);
        }
        catch (Exception ex) {
            throw new ClassCastException("Unknown data type.");
        }
    }

    public T castType(Object obj) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String className = this.klass.getCanonicalName();
        if (className == null) {
            throw new IllegalStateException("Cannot get class name.");
        }
        Class<?> helper = Class.forName(String.valueOf(className) + "Helper", true, this.klass.getClassLoader());
        Method method = helper.getMethod("narrow", Object.class);
        java.lang.Object narrowedObj = method.invoke(null, obj);
        return this.klass.cast(narrowedObj);
    }

    public Any castAny(T data) {
        data = this.replaceNull(data);
        Any any = ORBUtil.getOrb().create_any();
        if (this.klass.equals(Byte.class)) {
            any.insert_octet(((Byte)Byte.class.cast(data)).byteValue());
            return any;
        }
        if (this.klass.equals(Double.class)) {
            any.insert_double(((Double)Double.class.cast(data)).doubleValue());
            return any;
        }
        if (this.klass.equals(Float.class)) {
            any.insert_float(((Float)Float.class.cast(data)).floatValue());
            return any;
        }
        if (this.klass.equals(Integer.class)) {
            any.insert_long(((Integer)Integer.class.cast(data)).intValue());
            return any;
        }
        if (this.klass.equals(Long.class)) {
            any.insert_longlong(((Long)Long.class.cast(data)).longValue());
            return any;
        }
        if (this.klass.equals(Short.class)) {
            any.insert_short(((Short)Short.class.cast(data)).shortValue());
            return any;
        }
        if (this.klass.equals(Time.class)) {
            TimeHelper.insert(any, (Time)Time.class.cast(data));
            return any;
        }
        if (this.klass.equals(TimedBoolean.class)) {
            TimedBoolean timedData = (TimedBoolean)TimedBoolean.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedBooleanHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedChar.class)) {
            TimedChar timedData = (TimedChar)TimedChar.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedCharHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedDouble.class)) {
            TimedDouble timedData = (TimedDouble)TimedDouble.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedDoubleHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedFloat.class)) {
            TimedFloat timedData = (TimedFloat)TimedFloat.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedFloatHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedLong.class)) {
            TimedLong timedData = (TimedLong)TimedLong.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedLongHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedOctet.class)) {
            TimedOctet timedData = (TimedOctet)TimedOctet.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedOctetHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedShort.class)) {
            TimedShort timedData = (TimedShort)TimedShort.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedShortHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedState.class)) {
            TimedState timedData = (TimedState)TimedState.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedStateHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedString.class)) {
            TimedString timedData = (TimedString)TimedString.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            timedData.data = this.fillString(timedData.data);
            TimedStringHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedULong.class)) {
            TimedULong timedData = (TimedULong)TimedULong.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedULongHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedUShort.class)) {
            TimedUShort timedData = (TimedUShort)TimedUShort.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedUShortHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedBooleanSeq.class)) {
            TimedBooleanSeq timedData = (TimedBooleanSeq)TimedBooleanSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedBooleanSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedCharSeq.class)) {
            TimedCharSeq timedData = (TimedCharSeq)TimedCharSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedCharSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedDoubleSeq.class)) {
            TimedDoubleSeq timedData = (TimedDoubleSeq)TimedDoubleSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedDoubleSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedFloatSeq.class)) {
            TimedFloatSeq timedData = (TimedFloatSeq)TimedFloatSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedFloatSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedLongSeq.class)) {
            TimedLongSeq timedData = (TimedLongSeq)TimedLongSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedLongSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedOctetSeq.class)) {
            TimedOctetSeq timedData = (TimedOctetSeq)TimedOctetSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedOctetSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedShortSeq.class)) {
            TimedShortSeq timedData = (TimedShortSeq)TimedShortSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedShortSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedStringSeq.class)) {
            TimedStringSeq timedData = (TimedStringSeq)TimedStringSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedStringSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedULongSeq.class)) {
            TimedULongSeq timedData = (TimedULongSeq)TimedULongSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedULongSeqHelper.insert(any, timedData);
            return any;
        }
        if (this.klass.equals(TimedUShortSeq.class)) {
            TimedUShortSeq timedData = (TimedUShortSeq)TimedUShortSeq.class.cast(data);
            timedData.tm = this.fillTime(timedData.tm);
            TimedUShortSeqHelper.insert(any, timedData);
            return any;
        }
        String className = this.klass.getCanonicalName();
        if (className == null) {
            throw new IllegalStateException("Cannot get class name.");
        }
        try {
            Class<?> targetClass = Class.forName(className, true, this.klass.getClassLoader());
            java.lang.Object targetObject = targetClass.cast(data);
            Class<?> helper = Class.forName(String.valueOf(className) + "Helper", true, this.klass.getClassLoader());
            Method method = helper.getMethod("insert", Any.class, targetClass);
            method.invoke(null, any, targetObject);
            return any;
        }
        catch (Exception ex) {
            throw new ClassCastException("Unknown data type.");
        }
    }

    public static String getDataTypeCodeName(Class klass) {
        return klass.getSimpleName();
    }

    public String getDataTypeCodeName() {
        return TypeCast.getDataTypeCodeName(this.klass);
    }

    private Time fillTime(Time time) {
        if (time != null) {
            return time;
        }
        long millis = System.currentTimeMillis();
        int sec = (int)(millis / 1000L);
        int nsec = (int)(millis % 1000L * 1000000L);
        return new Time(sec, nsec);
    }

    private String fillString(String str) {
        if (str != null) {
            return str;
        }
        return new String();
    }

    private T replaceNull(T data) {
        if (data != null) {
            return data;
        }
        if (this.klass.equals(Byte.class)) {
            return (T)new Byte(0);
        }
        if (this.klass.equals(Double.class)) {
            return (T)new Double(0.0);
        }
        if (this.klass.equals(Float.class)) {
            return (T)new Float(0.0f);
        }
        if (this.klass.equals(Integer.class)) {
            return (T)new Integer(0);
        }
        if (this.klass.equals(Long.class)) {
            return (T)new Long(0L);
        }
        if (this.klass.equals(Short.class)) {
            return (T)new Short(0);
        }
        if (this.klass.equals(Time.class)) {
            return (T)new Time();
        }
        if (this.klass.equals(TimedBoolean.class)) {
            return (T)new TimedBoolean();
        }
        if (this.klass.equals(TimedChar.class)) {
            return (T)new TimedChar();
        }
        if (this.klass.equals(TimedDouble.class)) {
            return (T)new TimedDouble();
        }
        if (this.klass.equals(TimedFloat.class)) {
            return (T)new TimedFloat();
        }
        if (this.klass.equals(TimedLong.class)) {
            return (T)new TimedLong();
        }
        if (this.klass.equals(TimedOctet.class)) {
            return (T)new TimedOctet();
        }
        if (this.klass.equals(TimedShort.class)) {
            return (T)new TimedShort();
        }
        if (this.klass.equals(TimedState.class)) {
            return (T)new TimedState();
        }
        if (this.klass.equals(TimedString.class)) {
            return (T)new TimedString();
        }
        if (this.klass.equals(TimedULong.class)) {
            return (T)new TimedULong();
        }
        if (this.klass.equals(TimedUShort.class)) {
            return (T)new TimedUShort();
        }
        if (this.klass.equals(TimedBooleanSeq.class)) {
            return (T)new TimedBooleanSeq(null, new boolean[0]);
        }
        if (this.klass.equals(TimedCharSeq.class)) {
            return (T)new TimedCharSeq(null, new char[0]);
        }
        if (this.klass.equals(TimedDoubleSeq.class)) {
            return (T)new TimedDoubleSeq(null, new double[0]);
        }
        if (this.klass.equals(TimedFloatSeq.class)) {
            return (T)new TimedFloatSeq(null, new float[0]);
        }
        if (this.klass.equals(TimedLongSeq.class)) {
            return (T)new TimedLongSeq(null, new int[0]);
        }
        if (this.klass.equals(TimedOctetSeq.class)) {
            return (T)new TimedOctetSeq(null, new byte[0]);
        }
        if (this.klass.equals(TimedShortSeq.class)) {
            return (T)new TimedShortSeq(null, new short[0]);
        }
        if (this.klass.equals(TimedStringSeq.class)) {
            return (T)new TimedStringSeq(null, new String[0]);
        }
        if (this.klass.equals(TimedULongSeq.class)) {
            return (T)new TimedULongSeq(null, new int[0]);
        }
        if (this.klass.equals(TimedUShortSeq.class)) {
            return (T)new TimedUShortSeq(null, new short[0]);
        }
        throw new ClassCastException("Unknown data type.");
    }
}

