/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringHolder;
import jp.go.aist.rtm.RTC.util.StringUtil;

public class ModuleManager {
    private final String CONFIG_EXT = "manager.modules.config_ext";
    private final String CONFIG_PATH = "manager.modules.config_path";
    private final String DETECT_MOD = "manager.modules.detect_loadable";
    private final String MOD_LOADPTH = "manager.modules.load_path";
    private final String INITFUNC_SFX = "manager.modules.init_func_suffix";
    private final String INITFUNC_PFX = "manager.modules.init_func_prefix";
    private final String ALLOW_ABSPATH = "manager.modules.abs_path_allowed";
    private final String ALLOW_URL = "manager.modules.download_allowed";
    private final String MOD_DWNDIR = "manager.modules.download_dir";
    private final String MOD_DELMOD = "manager.modules.download_cleanup";
    private final String MOD_PRELOAD = "manager.modules.preload";
    protected Properties m_properties;
    protected Map<String, DLLEntity> m_modules = new HashMap<String, DLLEntity>();
    protected Vector<String> m_loadPath = new Vector();
    protected Vector<String> m_configPath = new Vector();
    protected boolean m_downloadAllowed;
    protected boolean m_absoluteAllowed;
    protected String m_initFuncSuffix = new String();
    protected String m_initFuncPrefix = new String();
    private Logbuf rtcout = new Logbuf("ModuleManager");

    public ModuleManager(Properties properties) {
        this.m_properties = properties;
        this.m_configPath = new Vector();
        String[] stringArray = properties.getProperty("manager.modules.config_path").split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_configPath.add(stringArray[i].trim());
        }
        this.m_loadPath = new Vector();
        String[] stringArray2 = properties.getProperty("manager.modules.load_path").split(",");
        String string = System.getProperty("file.separator");
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray2[i].trim();
            if (stringArray2[i].substring(0, 2).equals("." + string)) {
                stringArray2[i] = stringArray2[i].substring(2);
            }
            this.m_loadPath.add(stringArray2[i]);
        }
        this.m_absoluteAllowed = StringUtil.toBool(properties.getProperty("manager.modules.abs_path_allowed"), "yes", "no", false);
        this.m_downloadAllowed = StringUtil.toBool(properties.getProperty("manager.modules.download_allowed"), "yes", "no", false);
        this.m_initFuncSuffix = properties.getProperty("manager.modules.init_func_suffix");
        this.m_initFuncPrefix = properties.getProperty("manager.modules.init_func_prefix");
    }

    public void destruct() {
        this.unloadAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destruct();
        }
        finally {
            super.finalize();
        }
    }

    public String load(String string) throws Exception {
        this.rtcout.println(2, "load(fname = " + string + ")");
        String string2 = null;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("moduleName is empty.:load()");
        }
        try {
            new URL(string);
            if (!this.m_downloadAllowed) {
                throw new IllegalArgumentException("Downloading module is not allowed.");
            }
            throw new IllegalArgumentException("Not implemented." + string);
        }
        catch (MalformedURLException malformedURLException) {
            Object object;
            String string3 = System.getProperty("file.separator");
            Class clazz = null;
            File file = new File(string);
            if (file.exists()) {
                if (!this.m_absoluteAllowed) {
                    throw new IllegalArgumentException("Absolute path is not allowed");
                }
                object = this.createURLClassLoader(file.getParent());
                if (object != null) {
                    String string4 = file.getName();
                    string4 = this.getModuleName(string4);
                    StringHolder stringHolder = new StringHolder();
                    clazz = this.getClassFromName((URLClassLoader)object, string4, stringHolder);
                    string2 = stringHolder.value;
                }
            } else {
                if (this.m_loadPath.size() == 0) {
                    throw new ClassNotFoundException();
                }
                for (int i = 0; i < this.m_loadPath.size(); ++i) {
                    Object object2;
                    String string5;
                    if (this.m_loadPath.elementAt(i).equals("") || this.m_loadPath.elementAt(i).length() == 0) {
                        string5 = string;
                    } else {
                        object2 = this.m_loadPath.elementAt(i);
                        string5 = (String)object2 + string3 + string;
                    }
                    file = new File(string5);
                    if (file.isAbsolute()) {
                        object2 = this.createURLClassLoader(file.getParent());
                        if (object2 == null) continue;
                        String string6 = file.getName();
                        string6 = this.getModuleName(string6);
                        StringHolder stringHolder = new StringHolder();
                        clazz = this.getClassFromName((URLClassLoader)object2, string6, stringHolder);
                        string2 = stringHolder.value;
                        if (clazz == null) continue;
                        break;
                    }
                    try {
                        string5 = this.getModuleName(string5);
                        string5 = string5.replace(string3, ".");
                        string5 = string5.replace("..", ".");
                        clazz = Class.forName(string5);
                        string2 = string5;
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException("Not implemented." + string);
            }
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("Invalid file name.");
            }
            object = new DLLEntity();
            ((DLLEntity)object).properties = new Properties();
            ((DLLEntity)object).properties.setProperty("file_path", string2);
            ((DLLEntity)object).dll = clazz;
            this.m_modules.put(string2, (DLLEntity)object);
            return string2;
        }
    }

    private Class getClassFromName(URLClassLoader uRLClassLoader, String string, StringHolder stringHolder) {
        String string2 = System.getProperty("file.separator");
        Class clazz = null;
        try {
            clazz = uRLClassLoader.loadClass(string);
            stringHolder.value = string;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string3 = noClassDefFoundError.getMessage();
            String string4 = "wrong name: ";
            int n = string3.indexOf(string4);
            String string5 = string3.substring(n + string4.length(), string3.length() - 1);
            URL[] uRLArray = uRLClassLoader.getURLs();
            ArrayList<URL> arrayList = new ArrayList<URL>(Arrays.asList(uRLArray));
            for (int i = 0; i < uRLArray.length; ++i) {
                String string6 = new String();
                String string7 = new String();
                try {
                    string7 = uRLArray[i].toURI().getPath();
                }
                catch (Exception exception) {
                    continue;
                }
                int n2 = string5.lastIndexOf(string);
                String string8 = string5.substring(0, n2);
                if (!string7.endsWith(string8)) continue;
                int n3 = string7.lastIndexOf(string8);
                string6 = string7.substring(0, n3);
                File file = new File(string6);
                try {
                    URI uRI = file.toURI();
                    arrayList.add(uRI.toURL());
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("java.net.MalformedURLException: toURL() threw Exception." + malformedURLException);
                }
            }
            URL[] uRLArray2 = arrayList.toArray(new URL[0]);
            uRLClassLoader = URLClassLoader.newInstance(uRLArray2, uRLClassLoader);
            string5 = string5.replace("/", ".");
            string5 = string5.trim();
            clazz = this.getClassFromName(uRLClassLoader, string5, stringHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private String getModuleName(String string) {
        String[] stringArray = new String[]{".class", ".jar"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            int n = string.lastIndexOf(stringArray[i]);
            string = string.substring(0, n);
            if (!stringArray[i].equals(".jar")) break;
            string = string + "." + string;
            break;
        }
        return string;
    }

    private URLClassLoader createURLClassLoader(String string) {
        Object object;
        File file = new File(string);
        URL[] uRLArray = new URL[1];
        try {
            object = file.toURI();
            uRLArray[0] = ((URI)object).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            this.rtcout.println(5, "java.net.MalformedURLException: toURL() threw Exception." + malformedURLException);
            return null;
        }
        object = new URLClassLoader(uRLArray);
        return object;
    }

    public String load(String string, String string2) throws Exception {
        this.rtcout.println(2, "load(fname = " + string + "   init_func = " + string2 + ")");
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("moduleName is empty.:load()");
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("methodName is empty.:load()");
        }
        String string3 = this.load(string);
        Method method = this.symbol(string3, string2);
        DLLEntity dLLEntity = this.m_modules.get(string3);
        Class clazz = dLLEntity.dll;
        if (clazz == null) {
            throw new ClassNotFoundException("Not implemented." + string);
        }
        try {
            method.invoke(clazz.newInstance(), new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException;
        }
        catch (InstantiationException instantiationException) {
            throw instantiationException;
        }
        return string3;
    }

    public void unload(String string) throws Exception {
        if (!this.m_modules.containsKey(string)) {
            throw new IllegalArgumentException("Not Found:" + string);
        }
        this.m_modules.remove(string);
    }

    public void unloadAll() {
        this.m_modules = new HashMap<String, DLLEntity>();
    }

    public Method symbol(String string, String string2) throws Exception {
        Method method;
        Class clazz = this.m_modules.get((Object)string).dll;
        if (clazz == null) {
            throw new IllegalArgumentException("Not Found(symbol):" + string);
        }
        try {
            method = clazz.getMethod(string2, new Class[0]);
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw noSuchMethodException;
        }
        return method;
    }

    public String getInitFuncName(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\.");
        return this.m_initFuncPrefix + stringArray[stringArray.length - 1] + this.m_initFuncSuffix;
    }

    public void setLoadpath(Vector<String> vector) {
        this.m_loadPath = new Vector<String>(vector);
    }

    public Vector<String> getLoadPath() {
        return new Vector<String>(this.m_loadPath);
    }

    public void addLoadPath(Vector<String> vector) {
        this.m_loadPath.addAll(vector);
    }

    public Vector<Properties> getLoadedModules() {
        Vector<Properties> vector = new Vector<Properties>();
        Set<String> set = this.m_modules.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            vector.add(this.m_modules.get((Object)iterator.next()).properties);
        }
        return vector;
    }

    public Vector<Properties> getLoadableModules() {
        String[] stringArray;
        Serializable serializable;
        this.rtcout.println(2, "getLoadableModules()");
        Vector<String> vector = new Vector<String>();
        String string = System.getProperty("file.separator");
        for (int i = 0; i < this.m_loadPath.size(); ++i) {
            String string2 = this.m_loadPath.elementAt(i);
            if (string2 == null || string2.equals("")) continue;
            serializable = new File(string2);
            stringArray = serializable.list(new FileFilter());
            for (int j = 0; j < stringArray.length; ++j) {
                vector.add(string2 + string + stringArray[j]);
            }
        }
        Vector<Properties> vector2 = new Vector<Properties>();
        for (int i = 0; i < vector.size(); ++i) {
            Serializable serializable2;
            String[] stringArray2;
            Object object;
            serializable = null;
            stringArray = new File((String)vector.elementAt(i));
            if (stringArray.isAbsolute()) {
                object = this.createURLClassLoader(stringArray.getParent());
                if (object != null) {
                    stringArray2 = stringArray.getName();
                    stringArray2 = this.getModuleName((String)stringArray2);
                    serializable2 = new StringHolder();
                    serializable = this.getClassFromName((URLClassLoader)object, (String)stringArray2, (StringHolder)serializable2);
                }
            } else {
                object = ((String)vector.elementAt(i)).split(".class");
                object[0] = object[0].replace(string, ".");
                object[0] = ((String)object[0]).replace("..", ".");
                try {
                    serializable = Class.forName((String)object[0], true, this.getClass().getClassLoader());
                }
                catch (Exception exception) {
                    continue;
                }
            }
            try {
                object = ((Class)serializable).getField("component_conf");
                stringArray2 = (String[])((Field)object).get(null);
                serializable2 = new ArrayList<String>(Arrays.asList(stringArray2));
                ((ArrayList)serializable2).add(0, "module_file_name");
                ((ArrayList)serializable2).add(1, stringArray.getName());
                ((ArrayList)serializable2).add(2, "module_file_path");
                ((ArrayList)serializable2).add(3, vector.elementAt(i));
                vector2.add(new Properties(((ArrayList)serializable2).toArray(new String[0])));
                this.rtcout.println(2, "loadabe module:" + (String)vector.elementAt(i));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vector2;
    }

    public void allowAbsolutePath() {
        this.m_absoluteAllowed = true;
    }

    public void disallowAbsolutePath() {
        this.m_absoluteAllowed = false;
    }

    public void allowModuleDownload() {
        this.m_downloadAllowed = true;
    }

    public void disallowModuleDownload() {
        this.m_downloadAllowed = false;
    }

    private class FileFilter
    implements FilenameFilter {
        private final String FILTER_KEYWORD = ".class,.jar";

        private FileFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            File file2 = new File(string);
            if (file2.isDirectory()) {
                return false;
            }
            String[] stringArray = ".class,.jar".split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                return true;
            }
            return false;
        }
    }

    private class DLLEntity {
        public Properties properties;
        public Class dll;

        private DLLEntity() {
        }
    }
}

