/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC;

import OpenRTM.DataFlowComponent;
import OpenRTM.DataFlowComponentHelper;
import OpenRTM.DataFlowComponentPOA;
import RTC.ComponentProfile;
import RTC.ConnectorProfile;
import RTC.ExecutionContext;
import RTC.ExecutionContextHelper;
import RTC.ExecutionContextListHolder;
import RTC.ExecutionContextService;
import RTC.ExecutionContextServiceHelper;
import RTC.ExecutionContextServiceListHolder;
import RTC.LightweightRTObject;
import RTC.PortProfile;
import RTC.PortService;
import RTC.RTObject;
import RTC.RTObjectHelper;
import RTC.ReturnCode_t;
import _SDOPackage.Configuration;
import _SDOPackage.DeviceProfile;
import _SDOPackage.InterfaceNotImplemented;
import _SDOPackage.InternalError;
import _SDOPackage.InvalidParameter;
import _SDOPackage.Monitoring;
import _SDOPackage.NVListHolder;
import _SDOPackage.NameValue;
import _SDOPackage.NotAvailable;
import _SDOPackage.Organization;
import _SDOPackage.OrganizationListHolder;
import _SDOPackage.SDOService;
import _SDOPackage.SDOServiceHolder;
import _SDOPackage.ServiceProfile;
import _SDOPackage.ServiceProfileHolder;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Vector;
import jp.go.aist.rtm.RTC.ComponentActionListeners;
import jp.go.aist.rtm.RTC.ConfigAdmin;
import jp.go.aist.rtm.RTC.ConfigurationParamListener;
import jp.go.aist.rtm.RTC.ConfigurationSetListener;
import jp.go.aist.rtm.RTC.ConfigurationSetNameListener;
import jp.go.aist.rtm.RTC.ExecutionContextActionListener;
import jp.go.aist.rtm.RTC.ExecutionContextActionListenerType;
import jp.go.aist.rtm.RTC.Manager;
import jp.go.aist.rtm.RTC.PortActionListener;
import jp.go.aist.rtm.RTC.PortActionListenerType;
import jp.go.aist.rtm.RTC.PostComponentActionListener;
import jp.go.aist.rtm.RTC.PostComponentActionListenerType;
import jp.go.aist.rtm.RTC.PreComponentActionListener;
import jp.go.aist.rtm.RTC.PreComponentActionListenerType;
import jp.go.aist.rtm.RTC.SDOPackage.Configuration_impl;
import jp.go.aist.rtm.RTC.SdoServiceAdmin;
import jp.go.aist.rtm.RTC.SdoServiceProviderBase;
import jp.go.aist.rtm.RTC.executionContext.ExecutionContextBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.CorbaPort;
import jp.go.aist.rtm.RTC.port.InPort;
import jp.go.aist.rtm.RTC.port.InPortBase;
import jp.go.aist.rtm.RTC.port.OutPort;
import jp.go.aist.rtm.RTC.port.OutPortBase;
import jp.go.aist.rtm.RTC.port.PortAdmin;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.port.PortConnectListener;
import jp.go.aist.rtm.RTC.port.PortConnectListeners;
import jp.go.aist.rtm.RTC.port.PortConnectRetListener;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import jp.go.aist.rtm.RTC.util.POAUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.ValueHolder;
import jp.go.aist.rtm.RTC.util.equalFunctor;
import jp.go.aist.rtm.RTC.util.operatorFunc;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class RTObject_impl
extends DataFlowComponentPOA {
    static final String[] default_conf = new String[]{"implementation_id", "", "type_name", "", "description", "", "version", "", "vendor", "", "category", "", "activity_type", "", "max_instance", "", "language", "", "lang_type", "", "conf", "", ""};
    public static final int ECOTHER_OFFSET = 1000;
    protected Manager m_pManager;
    protected ORB m_pORB;
    protected POA m_pPOA;
    protected OrganizationListHolder m_sdoOwnedOrganizations = new OrganizationListHolder();
    protected Configuration_impl m_pSdoConfigImpl;
    protected Configuration m_pSdoConfig;
    protected OrganizationListHolder m_sdoOrganizations = new OrganizationListHolder();
    protected NVListHolder m_sdoStatus = new NVListHolder();
    protected ComponentProfile m_profile = new ComponentProfile();
    protected RTObject m_objref;
    protected PortAdmin m_portAdmin;
    protected ExecutionContextServiceListHolder m_ecMine;
    protected Vector<ExecutionContextBase> m_eclist = new Vector();
    protected ExecutionContextServiceListHolder m_ecOther;
    protected boolean m_created;
    protected boolean m_exiting;
    protected Properties m_properties = new Properties();
    protected ConfigAdmin m_configsets;
    protected SdoServiceAdmin m_sdoservice;
    protected boolean m_readAll;
    protected boolean m_writeAll;
    protected PortConnectListeners m_portconnListeners = new PortConnectListeners();
    protected Logbuf rtcout;
    protected Vector<InPortBase> m_inports = new Vector();
    protected Vector<OutPortBase> m_outports = new Vector();
    protected boolean m_readAllCompletion;
    protected boolean m_writeAllCompletion;
    protected ComponentActionListeners m_actionListeners = new ComponentActionListeners();

    public RTObject_impl(Manager manager) {
        this.m_pManager = manager;
        this.m_pORB = manager.getORB();
        this.m_pPOA = manager.getPOA();
        this.m_portAdmin = new PortAdmin(manager.getORB(), manager.getPOA());
        this.m_created = true;
        this.m_properties = new Properties(default_conf);
        this.m_configsets = new ConfigAdmin(this.m_properties.getNode("conf"));
        this.m_readAll = false;
        this.m_writeAll = false;
        this.m_readAllCompletion = false;
        this.m_writeAllCompletion = false;
        this.rtcout = new Logbuf("RTObject_impl");
        this.m_properties.setProperty("sdo.service.provider.enabled_services", manager.getConfig().getProperty("sdo.service.provider.enabled_services"));
        this.m_properties.setProperty("sdo.service.consumer.enabled_services", manager.getConfig().getProperty("sdo.service.consumer.enabled_services"));
        this.m_sdoservice = new SdoServiceAdmin(this);
        this.m_objref = this._this();
        this.m_pSdoConfigImpl = new Configuration_impl(this.m_configsets, this.m_sdoservice);
        this.m_pSdoConfig = this.m_pSdoConfigImpl.getObjRef();
        if (this.m_ecMine == null) {
            this.m_ecMine = new ExecutionContextServiceListHolder();
            this.m_ecMine.value = new ExecutionContextService[0];
        }
        if (this.m_ecOther == null) {
            this.m_ecOther = new ExecutionContextServiceListHolder();
            this.m_ecOther.value = new ExecutionContextService[0];
        }
        if (this.m_sdoOwnedOrganizations.value == null) {
            this.m_sdoOwnedOrganizations.value = new Organization[0];
        }
        this.m_profile.properties = new NameValue[0];
    }

    public RTObject_impl(ORB oRB, POA pOA) {
        this.m_pManager = null;
        this.m_pORB = oRB;
        this.m_pPOA = pOA;
        this.m_portAdmin = new PortAdmin(oRB, pOA);
        this.m_created = true;
        this.m_properties = new Properties(default_conf);
        this.m_configsets = new ConfigAdmin(this.m_properties.getNode("conf"));
        this.m_readAll = false;
        this.m_writeAll = false;
        this.m_readAllCompletion = false;
        this.m_writeAllCompletion = false;
        this.rtcout = new Logbuf("RTObject_impl");
        this.m_sdoservice = new SdoServiceAdmin(this);
        this.m_objref = this._this();
        this.m_pSdoConfigImpl = new Configuration_impl(this.m_configsets, this.m_sdoservice);
        this.m_pSdoConfig = this.m_pSdoConfigImpl.getObjRef();
        if (this.m_ecMine == null) {
            this.m_ecMine = new ExecutionContextServiceListHolder();
            this.m_ecMine.value = new ExecutionContextService[0];
        }
        if (this.m_ecOther == null) {
            this.m_ecOther = new ExecutionContextServiceListHolder();
            this.m_ecOther.value = new ExecutionContextService[0];
        }
        Manager manager = Manager.instance();
        this.m_profile.properties = new NameValue[0];
    }

    @Override
    public DataFlowComponent _this() {
        if (this.m_objref == null) {
            try {
                this.m_objref = RTObjectHelper.narrow(POAUtil.getRef(this));
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return DataFlowComponentHelper.narrow(this.m_objref);
    }

    protected ReturnCode_t onInitialize() {
        this.rtcout.println(2, "RTObject_impl.onInitialize()");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onFinalize() {
        this.rtcout.println(2, "RTObject_impl.onFinalize()");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onStartup(int n) {
        this.rtcout.println(2, "RTObject_impl.onStartup(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onShutdown(int n) {
        this.rtcout.println(2, "RTObject_impl.onShutdown(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onActivated(int n) {
        this.rtcout.println(2, "RTObject_impl.onActivated(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onDeactivated(int n) {
        this.rtcout.println(2, "RTObject_impl.onDeactivated(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onExecute(int n) {
        this.rtcout.println(2, "RTObject_impl.onExecute(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onAborting(int n) {
        this.rtcout.println(2, "RTObject_impl.onAborting(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onError(int n) {
        this.rtcout.println(2, "RTObject_impl.onError(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onReset(int n) {
        this.rtcout.println(2, "RTObject_impl.onReset(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onStateUpdate(int n) {
        this.rtcout.println(2, "RTObject_impl.onStateUpdete(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    protected ReturnCode_t onRateChanged(int n) {
        this.rtcout.println(2, "RTObject_impl.onRateChanged(" + n + ")");
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t initialize() {
        this.rtcout.println(2, "RTObject_impl.initialize()");
        if (!this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        String string = new String();
        string = string + this.m_properties.getProperty("exec_cxt.periodic.type");
        string = string + "?";
        string = string + "rate=" + this.m_properties.getProperty("exec_cxt.periodic.rate");
        ExecutionContextBase executionContextBase = Manager.instance().createContext(string);
        if (executionContextBase == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        executionContextBase.set_rate(Double.valueOf(this.m_properties.getProperty("exec_cxt.periodic.rate")));
        this.m_eclist.add(executionContextBase);
        ExecutionContextService executionContextService = executionContextBase.getObjRef();
        if (executionContextService == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        executionContextBase.bindComponent(this);
        ReturnCode_t returnCode_t = this.on_initialize();
        if (returnCode_t != ReturnCode_t.RTC_OK) {
            return returnCode_t;
        }
        this.m_created = false;
        if (this.m_ecMine.value.length == 0) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        for (int i = 0; i < this.m_ecMine.value.length; ++i) {
            this.rtcout.println(3, "EC[" + i + "] starting");
            this.m_ecMine.value[i].start();
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t _finalize() throws SystemException {
        this.rtcout.println(2, "RTObject_impl._finalize()");
        if (this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        if (this.m_ecOther.value.length != 0) {
            int n = this.m_ecOther.value.length;
            for (int i = 0; i < n; ++i) {
                if (this.m_ecOther.value[i] == null) continue;
                return ReturnCode_t.PRECONDITION_NOT_MET;
            }
            this.m_ecOther.value = null;
        }
        ReturnCode_t returnCode_t = this.on_finalize();
        this.shutdown();
        return returnCode_t;
    }

    @Override
    public ReturnCode_t exit() throws SystemException {
        int n;
        this.rtcout.println(2, "RTObject_impl.exit()");
        if (this.m_created) {
            return ReturnCode_t.PRECONDITION_NOT_MET;
        }
        CORBA_SeqUtil.for_each(this.m_ecMine, (operatorFunc)new deactivate_comps((LightweightRTObject)this.m_objref._duplicate()));
        CORBA_SeqUtil.for_each(this.m_ecOther, (operatorFunc)new deactivate_comps((LightweightRTObject)this.m_objref._duplicate()));
        int n2 = this.m_ecMine.value.length;
        for (n = 0; n < n2; ++n) {
        }
        n2 = this.m_ecOther.value.length;
        for (n = 0; n < n2; ++n) {
            if (this.m_ecOther.value[n] == null) continue;
            this.m_ecOther.value[n].remove_component(this._this());
        }
        ReturnCode_t returnCode_t = this._finalize();
        return returnCode_t;
    }

    @Override
    public boolean is_alive(ExecutionContext executionContext) throws SystemException {
        int n;
        this.rtcout.println(2, "RTObject_impl.is_alive()");
        int n2 = this.m_ecMine.value.length;
        for (n = 0; n < n2; ++n) {
            if (!executionContext._is_equivalent(this.m_ecMine.value[n])) continue;
            return true;
        }
        n2 = this.m_ecOther.value.length;
        for (n = 0; n < n2; ++n) {
            if (this.m_ecOther.value[n] == null || !executionContext._is_equivalent(this.m_ecOther.value[n])) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExecutionContext[] get_owned_contexts() throws SystemException {
        this.rtcout.println(2, "RTObject_impl.get_owned_contexts()");
        ExecutionContextListHolder executionContextListHolder = new ExecutionContextListHolder();
        executionContextListHolder.value = new ExecutionContext[0];
        CORBA_SeqUtil.for_each(this.m_ecMine, (operatorFunc)new ec_copy(executionContextListHolder));
        return executionContextListHolder.value;
    }

    @Override
    public ExecutionContext get_context(int n) {
        this.rtcout.println(2, "RTObject_impl.get_context(" + n + ")");
        if (n < 1000) {
            if (n < this.m_ecMine.value.length) {
                ExecutionContextService executionContextService = this.m_ecMine.value[n];
                return executionContextService;
            }
            return null;
        }
        int n2 = n - 1000;
        if (n2 < this.m_ecOther.value.length && this.m_ecOther.value[n2] != null) {
            ExecutionContextService executionContextService = this.m_ecOther.value[n2];
            return executionContextService;
        }
        return null;
    }

    @Override
    public ExecutionContext[] get_participating_contexts() throws SystemException {
        this.rtcout.println(2, "RTObject_impl.get_participating_contexts()");
        ExecutionContextListHolder executionContextListHolder = new ExecutionContextListHolder();
        executionContextListHolder.value = new ExecutionContext[0];
        CORBA_SeqUtil.for_each(this.m_ecOther, (operatorFunc)new ec_copy(executionContextListHolder));
        return executionContextListHolder.value;
    }

    @Override
    public int get_context_handle(ExecutionContext executionContext) throws SystemException {
        this.rtcout.println(2, "RTObject_impl.get_context_handle()");
        int n = CORBA_SeqUtil.find(this.m_ecMine, (equalFunctor)new ec_find(executionContext));
        if (n != -1) {
            return n;
        }
        n = CORBA_SeqUtil.find(this.m_ecOther, (equalFunctor)new ec_find(executionContext));
        if (n != -1) {
            return 1000 + n;
        }
        return -1;
    }

    public int bindContext(ExecutionContext executionContext) {
        int n;
        this.rtcout.println(2, "RTObject_impl.bindContext()");
        ExecutionContextService executionContextService = ExecutionContextServiceHelper.narrow(executionContext);
        if (executionContextService == null) {
            return -1;
        }
        int n2 = this.m_ecMine.value.length;
        for (n = 0; n < n2; ++n) {
            if (this.m_ecMine.value[n] != null) continue;
            this.m_ecMine.value[n] = (ExecutionContextService)executionContextService._duplicate();
            this.onAttachExecutionContext(n);
            return n;
        }
        CORBA_SeqUtil.push_back(this.m_ecMine, (ExecutionContextService)executionContextService._duplicate());
        n = this.m_ecMine.value.length - 1;
        return n;
    }

    @Override
    public ComponentProfile get_component_profile() {
        this.rtcout.println(2, "RTObject_impl.get_component_profile()");
        try {
            ComponentProfile componentProfile = new ComponentProfile();
            componentProfile.instance_name = this.m_properties.getProperty("instance_name");
            componentProfile.type_name = this.m_properties.getProperty("type_name");
            componentProfile.description = this.m_properties.getProperty("description");
            componentProfile.version = this.m_properties.getProperty("version");
            componentProfile.vendor = this.m_properties.getProperty("vendor");
            componentProfile.category = this.m_properties.getProperty("category");
            componentProfile.parent = this.m_profile.parent;
            componentProfile.properties = this.m_profile.properties;
            componentProfile.port_profiles = this.m_portAdmin.getPortProfileList().value;
            NVListHolder nVListHolder = new NVListHolder(componentProfile.properties);
            NVUtil.copyFromProperties(nVListHolder, this.m_properties);
            componentProfile.properties = nVListHolder.value;
            return componentProfile;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public PortService[] get_ports() {
        this.rtcout.println(2, "RTObject_impl.get_ports()");
        try {
            return this.m_portAdmin.getPortServiceList().value;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public int attach_context(ExecutionContext executionContext) throws SystemException {
        int n;
        this.rtcout.println(2, "RTObject_impl.attach_context()");
        ExecutionContextService executionContextService = ExecutionContextServiceHelper.narrow(executionContext);
        if (executionContextService == null) {
            return -1;
        }
        int n2 = this.m_ecOther.value.length;
        for (n = 0; n < n2; ++n) {
            if (this.m_ecOther.value[n] != null) continue;
            this.m_ecOther.value[n] = (ExecutionContextService)executionContextService._duplicate();
            int n3 = n + 1000;
            this.onAttachExecutionContext(n3);
            return n3;
        }
        CORBA_SeqUtil.push_back(this.m_ecOther, (ExecutionContextService)executionContextService._duplicate());
        n = this.m_ecOther.value.length - 1 + 1000;
        this.onAttachExecutionContext(n);
        return n;
    }

    @Override
    public ReturnCode_t detach_context(int n) throws SystemException {
        this.rtcout.println(2, "RTObject_impl.detach_context(" + n + ")");
        int n2 = this.m_ecOther.value.length;
        if (n < 1000 || n - 1000 > n2) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        int n3 = n - 1000;
        if (this.m_ecOther.value[n3] == null) {
            return ReturnCode_t.BAD_PARAMETER;
        }
        this.m_ecOther.value[n3] = null;
        this.onDetachExecutionContext(n);
        return ReturnCode_t.RTC_OK;
    }

    @Override
    public ReturnCode_t on_initialize() {
        this.rtcout.println(2, "RTObject_impl.on_initialize()");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnInitialize(0);
            returnCode_t = this.onInitialize();
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        String string = this.m_properties.getProperty("configuration.active_config", "default");
        if (this.m_configsets.haveConfig(string)) {
            this.m_configsets.update(string);
        } else {
            this.m_configsets.update("default");
        }
        this.postOnInitialize(0, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_finalize() {
        this.rtcout.println(2, "RTObject_impl.on_finalize()");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnFinalize(0);
            returnCode_t = this.onFinalize();
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnFinalize(0, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_startup(int n) {
        this.rtcout.println(2, "RTObject_impl.on_startup(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnStartup(n);
            returnCode_t = this.onStartup(n);
            this.postOnStartup(n, returnCode_t);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_shutdown(int n) {
        this.rtcout.println(2, "RTObject_impl.on_shutdown(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnShutdown(n);
            returnCode_t = this.onShutdown(n);
            this.postOnShutdown(n, returnCode_t);
        }
        catch (Exception exception) {
            return ReturnCode_t.RTC_ERROR;
        }
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_activated(int n) {
        this.rtcout.println(2, "RTObject_impl.on_activated(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnActivated(n);
            this.m_configsets.update();
            returnCode_t = this.onActivated(n);
            this.m_portAdmin.activatePorts();
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnActivated(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_deactivated(int n) {
        this.rtcout.println(2, "RTObject_impl.on_deactivated(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnDeactivated(n);
            this.m_portAdmin.deactivatePorts();
            returnCode_t = this.onDeactivated(n);
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnDeactivated(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_aborting(int n) {
        this.rtcout.println(2, "RTObject_impl.on_aborting(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnAborting(n);
            returnCode_t = this.onAborting(n);
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnAborting(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_error(int n) {
        this.rtcout.println(2, "RTObject_impl.on_error(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnError(n);
            returnCode_t = this.onError(n);
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.m_configsets.update();
        this.postOnError(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_reset(int n) {
        this.rtcout.println(2, "RTObject_impl.on_reset(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnReset(n);
            returnCode_t = this.onReset(n);
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnReset(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_execute(int n) {
        this.rtcout.println(2, "RTObject_impl.on_execute(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnExecute(n);
            if (this.m_readAll) {
                this.readAll();
            }
            returnCode_t = this.onExecute(n);
            if (this.m_writeAll) {
                this.writeAll();
            }
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnExecute(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_state_update(int n) {
        this.rtcout.println(2, "RTObject_impl.on_state_update(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnStateUpdate(n);
            returnCode_t = this.onStateUpdate(n);
            this.m_configsets.update();
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnStateUpdate(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public ReturnCode_t on_rate_changed(int n) {
        this.rtcout.println(2, "RTObject_impl.on_rate_changed(" + n + ")");
        ReturnCode_t returnCode_t = ReturnCode_t.RTC_ERROR;
        try {
            this.preOnRateChanged(n);
            returnCode_t = this.onRateChanged(n);
        }
        catch (Exception exception) {
            returnCode_t = ReturnCode_t.RTC_ERROR;
        }
        this.postOnRateChanged(n, returnCode_t);
        return returnCode_t;
    }

    @Override
    public Organization[] get_owned_organizations() throws NotAvailable {
        this.rtcout.println(2, "RTObject_impl.get_owned_organizations()");
        try {
            return (Organization[])this.m_sdoOwnedOrganizations.value.clone();
        }
        catch (Exception exception) {
            throw new NotAvailable();
        }
    }

    @Override
    public String get_sdo_id() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_sdo_id()");
        try {
            String string = this.m_profile.instance_name;
            return string;
        }
        catch (Exception exception) {
            throw new InternalError("get_sdo_id()");
        }
    }

    @Override
    public String get_sdo_type() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_sdo_type()");
        try {
            String string = this.m_profile.description;
            return string;
        }
        catch (Exception exception) {
            throw new InternalError("get_sdo_type()");
        }
    }

    @Override
    public DeviceProfile get_device_profile() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_device_profile()");
        try {
            DeviceProfile deviceProfile = this.m_pSdoConfigImpl.getDeviceProfile();
            return deviceProfile;
        }
        catch (Exception exception) {
            throw new InternalError("get_device_profile()");
        }
    }

    @Override
    public ServiceProfile[] get_service_profiles() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_service_profiles()");
        ServiceProfile[] serviceProfileArray = new ServiceProfile[1];
        try {
            serviceProfileArray = this.m_sdoservice.getServiceProviderProfiles();
            this.rtcout.println(2, "SDO ServiceProfiles[" + serviceProfileArray.length + "]");
        }
        catch (Exception exception) {
            this.rtcout.println(6, "Unknown exception cought in get_service_profiles().");
            throw new InternalError("get_service_profiles()");
        }
        return serviceProfileArray;
    }

    @Override
    public ServiceProfile get_service_profile(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_service_profile(" + string + ")");
        if (string == null || string.equals("")) {
            throw new InvalidParameter("get_service_profile(): Empty name.");
        }
        try {
            ServiceProfile serviceProfile = this.m_sdoservice.getServiceProviderProfile(string);
            if (serviceProfile == null || !string.equals(serviceProfile.id)) {
                throw new InvalidParameter("get_service_profile(): Inexist id.");
            }
            ServiceProfileHolder serviceProfileHolder = new ServiceProfileHolder(serviceProfile);
            return serviceProfileHolder.value;
        }
        catch (InvalidParameter invalidParameter) {
            this.rtcout.println(6, "InvalidParameter exception: name (" + string + ") is not found");
            throw invalidParameter;
        }
        catch (Exception exception) {
            this.rtcout.println(6, "Unknown exception cought in get_service_profile(" + string + ") is not found");
            throw new InternalError("get_service_profile()");
        }
    }

    @Override
    public SDOService get_sdo_service(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_sdo_service(" + string + ")");
        if (string == null || string.equals("")) {
            throw new InvalidParameter("get_sdo_service(): Empty name.");
        }
        try {
            SDOService sDOService = this.m_sdoservice.getServiceProvider(string);
            if (sDOService == null) {
                throw new InvalidParameter("get_sdo_service(): Inexist id.");
            }
            SDOServiceHolder sDOServiceHolder = new SDOServiceHolder(sDOService);
            return sDOServiceHolder.value;
        }
        catch (InvalidParameter invalidParameter) {
            throw invalidParameter;
        }
        catch (Exception exception) {
            throw new InternalError("get_service_profile()");
        }
    }

    @Override
    public Configuration get_configuration() throws InterfaceNotImplemented, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_configuration()");
        if (this.m_pSdoConfig == null) {
            throw new InterfaceNotImplemented();
        }
        try {
            Configuration configuration = this.m_pSdoConfig;
            return configuration;
        }
        catch (Exception exception) {
            throw new InternalError("get_configuration()");
        }
    }

    @Override
    public Monitoring get_monitoring() throws InterfaceNotImplemented, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_monitoring()");
        throw new InterfaceNotImplemented();
    }

    @Override
    public Organization[] get_organizations() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_organizations()");
        try {
            OrganizationListHolder organizationListHolder = new OrganizationListHolder(this.m_pSdoConfigImpl.getOrganizations().value);
            return organizationListHolder.value;
        }
        catch (Exception exception) {
            throw new InternalError("get_organizations()");
        }
    }

    @Override
    public NameValue[] get_status_list() throws NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_status_list()");
        if (this.m_sdoStatus.value == null) {
            NVListHolder nVListHolder = new NVListHolder();
            CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNV("", "", String.class));
            try {
                return (NameValue[])nVListHolder.value.clone();
            }
            catch (Exception exception) {
                throw new InternalError("get_status_list()");
            }
        }
        try {
            return (NameValue[])this.m_sdoStatus.value.clone();
        }
        catch (Exception exception) {
            throw new InternalError("get_status_list()");
        }
    }

    @Override
    public Any get_status(String string) throws InvalidParameter, NotAvailable, InternalError {
        this.rtcout.println(2, "RTObject_impl.get_status(" + string + ")");
        int n = CORBA_SeqUtil.find(this.m_sdoStatus, (equalFunctor)new nv_name(string));
        if (n < 0) {
            throw new InvalidParameter("get_status(): Not found");
        }
        try {
            Any any = ORBUtil.getOrb().create_any();
            any = this.m_sdoStatus.value[n].value;
            return any;
        }
        catch (Exception exception) {
            throw new InternalError("get_status()");
        }
    }

    public final String getInstanceName() {
        this.rtcout.println(2, "RTObject_impl.getInstanceName()");
        return this.m_profile.instance_name;
    }

    public void setInstanceName(String string) {
        this.rtcout.println(2, "RTObject_impl.setInstanceName(" + string + ")");
        this.m_properties.setProperty("instance_name", string);
        this.m_profile.instance_name = this.m_properties.getProperty("instance_name");
    }

    public final String getTypeName() {
        this.rtcout.println(2, "RTObject_impl.getTypeName()");
        return this.m_profile.type_name;
    }

    public final String getCategory() {
        this.rtcout.println(2, "RTObject_impl.getCategory()");
        return this.m_profile.category;
    }

    public String[] getNamingNames() {
        this.rtcout.println(2, "RTObject_impl.getNamingNames()");
        return this.m_properties.getProperty("naming.names").split(",");
    }

    public void setObjRef(RTObject rTObject) {
        this.rtcout.println(2, "RTObject_impl.setObjRef()");
        this.m_objref = rTObject;
    }

    public final RTObject getObjRef() {
        this.rtcout.println(2, "RTObject_impl.getObjRef()");
        return (RTObject)this.m_objref._duplicate();
    }

    public void setProperties(Properties properties) {
        this.rtcout.println(2, "RTObject_impl.setProperties()");
        this.m_properties.merge(properties);
        try {
            this.syncAttributesByProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void syncAttributesByProperties() throws Exception {
        DeviceProfile deviceProfile = this.m_pSdoConfigImpl.getDeviceProfile();
        deviceProfile.device_type = this.m_properties.getProperty("category");
        deviceProfile.manufacturer = this.m_properties.getProperty("vendor");
        deviceProfile.model = this.m_properties.getProperty("type_name");
        deviceProfile.version = this.m_properties.getProperty("version");
        deviceProfile.properties = new NameValue[0];
        this.m_pSdoConfigImpl.set_device_profile(deviceProfile);
        this.m_profile.instance_name = this.m_properties.getProperty("instance_name");
        this.m_profile.type_name = this.m_properties.getProperty("type_name");
        this.m_profile.description = this.m_properties.getProperty("description");
        this.m_profile.version = this.m_properties.getProperty("version");
        this.m_profile.vendor = this.m_properties.getProperty("vendor");
        this.m_profile.category = this.m_properties.getProperty("category");
        this.m_profile.properties = new NameValue[0];
        this.m_profile.port_profiles = new PortProfile[0];
    }

    public Properties getProperties() {
        this.rtcout.println(2, "RTObject_impl.getProperties()");
        return this.m_properties;
    }

    public boolean bindParameter(String string, ValueHolder valueHolder, String string2) {
        this.rtcout.println(2, "RTObject_impl.bindParameter(" + string + "," + string2 + ")");
        this.m_configsets.bindParameter(string, valueHolder, string2);
        return true;
    }

    public void updateParameters(String string) {
        this.rtcout.println(2, "RTObject_impl.updateParameters(" + string + ")");
        this.m_configsets.update(string);
    }

    public void registerPort(PortBase portBase) {
        this.rtcout.println(2, "RTObject_impl.registerPort(PortBase)");
        if (!this.addPort(portBase)) {
            this.rtcout.println(6, "addPort(PortBase&) failed.");
        }
    }

    public boolean addPort(PortBase portBase) {
        this.rtcout.println(2, "addPort(PortBase)");
        portBase.setOwner(this.getObjRef());
        portBase.setPortConnectListenerHolder(this.m_portconnListeners);
        this.onAddPort(portBase.getPortProfile());
        return this.m_portAdmin.addPort(portBase);
    }

    public void registerPort(PortService portService) {
        this.rtcout.println(2, "RTObject_impl.registerPort(PortService)");
        if (!this.addPort(portService)) {
            this.rtcout.println(6, "addPort(PortBase&) failed.");
        }
    }

    public boolean addPort(PortService portService) {
        this.rtcout.println(2, "addPort(PortService_ptr)");
        return this.m_portAdmin.addPort(portService);
    }

    public void registerPort(CorbaPort corbaPort) {
        this.rtcout.println(2, "registerPort(CorbaPort)");
        if (!this.addPort(corbaPort)) {
            this.rtcout.println(6, "addPort(CorbaPort&) failed.");
        }
    }

    public boolean addPort(CorbaPort corbaPort) {
        this.rtcout.println(2, "addPort(CrobaPort)");
        String string = "port.corbaport.";
        this.m_properties.getNode(string).merge(this.m_properties.getNode("port.corba"));
        corbaPort.init(this.m_properties.getNode(string));
        return this.addPort((PortBase)corbaPort);
    }

    public <DataType, Buffer> void registerInPort(Class<DataType> clazz, String string, InPort<DataType> inPort) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerInPort(" + string + ")");
        this.registerInPort(string, inPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addInPort(String string, InPortBase inPortBase) {
        this.rtcout.println(2, "addInPort(" + string + ")");
        String string2 = "port.inport.";
        string2 = string2 + string;
        this.m_properties.getNode(string2).merge(this.m_properties.getNode("port.inport.dataport"));
        boolean bl = this.addPort(inPortBase);
        if (!bl) {
            this.rtcout.println(6, "addInPort() failed.");
            return bl;
        }
        inPortBase.init(this.m_properties.getNode(string2));
        Vector<InPortBase> vector = this.m_inports;
        synchronized (vector) {
            this.m_inports.add(inPortBase);
        }
        return bl;
    }

    public void registerInPort(String string, InPortBase inPortBase) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerInPort(" + string + ")");
        if (!this.addInPort(string, inPortBase)) {
            this.rtcout.println(6, "addInPort(" + string + ") failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOutPort(String string, OutPortBase outPortBase) {
        this.rtcout.println(2, "addOutPort(" + string + ")");
        String string2 = "port.outport.";
        string2 = string2 + string;
        this.m_properties.getNode(string2).merge(this.m_properties.getNode("port.outport.dataport"));
        boolean bl = this.addPort(outPortBase);
        if (!bl) {
            this.rtcout.println(6, "addOutPort() failed.");
            return bl;
        }
        outPortBase.init(this.m_properties.getNode(string2));
        Vector<OutPortBase> vector = this.m_outports;
        synchronized (vector) {
            this.m_outports.add(outPortBase);
        }
        return bl;
    }

    public <DataType, Buffer> void registerOutPort(Class<DataType> clazz, String string, OutPort<DataType> outPort) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerOutPort()");
        this.registerOutPort(string, outPort);
    }

    public void registerOutPort(String string, OutPortBase outPortBase) throws Exception {
        this.rtcout.println(2, "RTObject_impl.registerOutPort(" + string + ")");
        if (!this.addOutPort(string, outPortBase)) {
            this.rtcout.println(6, "addOutPort(" + string + ") failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInPort(InPortBase inPortBase) {
        this.rtcout.println(2, "removeInPort()");
        boolean bl = this.removePort(inPortBase);
        Vector<InPortBase> vector = this.m_inports;
        synchronized (vector) {
            Iterator<InPortBase> iterator = this.m_inports.iterator();
            if (bl) {
                while (!iterator.hasNext()) {
                    if (iterator.next() != inPortBase) continue;
                    this.m_inports.remove(iterator);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOutPort(OutPortBase outPortBase) {
        this.rtcout.println(2, "removeOutPort()");
        boolean bl = this.removePort(outPortBase);
        Vector<OutPortBase> vector = this.m_outports;
        synchronized (vector) {
            Iterator<OutPortBase> iterator = this.m_outports.iterator();
            if (bl) {
                while (!iterator.hasNext()) {
                    if (iterator.next() != outPortBase) continue;
                    this.m_outports.remove(iterator);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean removePort(PortBase portBase) {
        this.rtcout.println(2, "removePort(PortBase)");
        this.onRemovePort(portBase.getPortProfile());
        return this.m_portAdmin.removePort(portBase);
    }

    public boolean removePort(PortService portService) {
        this.rtcout.println(2, "removePort(PortService)");
        return this.m_portAdmin.removePort(portService);
    }

    public boolean removePort(CorbaPort corbaPort) {
        this.rtcout.println(2, "removePort(CorbaPortort)");
        this.onRemovePort(corbaPort.getPortProfile());
        return this.m_portAdmin.removePort(corbaPort);
    }

    public void deletePort(PortBase portBase) {
        this.rtcout.println(2, "RTObject_impl.deletePort(PortBase)");
        if (!this.removePort(portBase)) {
            this.rtcout.println(6, "removePort(PortBase&) failed.");
        }
    }

    public void deletePort(PortService portService) {
        this.rtcout.println(2, "RTObject_impl.deletePort(PortService)");
        if (!this.removePort(portService)) {
            this.rtcout.println(6, "removePort(PortService_pt) failed.");
        }
    }

    public void deletePort(CorbaPort corbaPort) {
        this.rtcout.println(2, "RTObject_impl.deletePort(CorbaPort)");
        if (!this.removePort(corbaPort)) {
            this.rtcout.println(6, "removePort(CorbaPort) failed.");
        }
    }

    public void deletePortByName(String string) {
        this.rtcout.println(2, "RTObject_impl.deletePortByNamed(" + string + ")");
        this.m_portAdmin.deletePortByName(string);
    }

    public ExecutionContext getExecutionContext(int n) {
        return this.get_context(n);
    }

    public double getExecutionRate(int n) {
        ExecutionContext executionContext = this.getExecutionContext(n);
        if (executionContext == null) {
            return 0.0;
        }
        return executionContext.get_rate();
    }

    public ReturnCode_t setExecutionRate(int n, double d) {
        ExecutionContext executionContext = this.getExecutionContext(n);
        if (executionContext == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        executionContext.set_rate(d);
        return ReturnCode_t.RTC_OK;
    }

    public boolean isOwnExecutionContext(int n) {
        return n < 1000;
    }

    public ReturnCode_t deactivate(int n) {
        ExecutionContext executionContext = this.getExecutionContext(n);
        if (executionContext == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        return executionContext.deactivate_component((LightweightRTObject)this.getObjRef()._duplicate());
    }

    public ReturnCode_t activate(int n) {
        ExecutionContext executionContext = this.getExecutionContext(n);
        if (executionContext == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        return executionContext.activate_component((LightweightRTObject)this.getObjRef()._duplicate());
    }

    public ReturnCode_t reset(int n) {
        ExecutionContext executionContext = this.getExecutionContext(n);
        if (executionContext == null) {
            return ReturnCode_t.RTC_ERROR;
        }
        return executionContext.reset_component((LightweightRTObject)this.getObjRef()._duplicate());
    }

    public boolean addSdoServiceProvider(ServiceProfile serviceProfile, SdoServiceProviderBase sdoServiceProviderBase) {
        return this.m_sdoservice.addSdoServiceProvider(serviceProfile, sdoServiceProviderBase);
    }

    public boolean removeSdoServiceProvider(String string) {
        return this.m_sdoservice.removeSdoServiceProvider(string);
    }

    public boolean addSdoServiceConsumer(ServiceProfile serviceProfile) {
        return this.m_sdoservice.addSdoServiceConsumer(serviceProfile);
    }

    public boolean removeSdoServiceConsumer(String string) {
        return this.m_sdoservice.removeSdoServiceConsumer(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAll() {
        this.rtcout.println(2, "readAll()");
        Vector<InPortBase> vector = this.m_inports;
        synchronized (vector) {
            Iterator<InPortBase> iterator = this.m_inports.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (iterator.next().read()) continue;
                this.rtcout.println(3, "The error occurred in readAll().");
                bl = false;
                if (this.m_readAllCompletion) continue;
                return false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeAll() {
        this.rtcout.println(2, "writeAll()");
        Vector<OutPortBase> vector = this.m_outports;
        synchronized (vector) {
            Iterator<OutPortBase> iterator = this.m_outports.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                if (iterator.next().write()) continue;
                this.rtcout.println(3, "The error occurred in writeAll().");
                bl = false;
                if (this.m_writeAllCompletion) continue;
                return false;
            }
            return bl;
        }
    }

    public void setReadAll(boolean bl, boolean bl2) {
        this.m_readAll = bl;
        this.m_readAllCompletion = bl2;
    }

    public void setReadAll() {
        this.setReadAll(true, false);
    }

    public void setReadAll(boolean bl) {
        this.setReadAll(bl, false);
    }

    public void setWriteAll(boolean bl, boolean bl2) {
        this.m_writeAll = bl;
        this.m_writeAllCompletion = bl2;
    }

    public void setWriteAll() {
        this.setWriteAll(true, false);
    }

    public void setWriteAll(boolean bl) {
        this.setWriteAll(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizePorts() {
        this.rtcout.println(2, "RTObject_impl.finalizePorts()");
        this.m_portAdmin.finalizePorts();
        Vector<PortBase> vector = this.m_inports;
        synchronized (vector) {
            this.m_inports.clear();
        }
        vector = this.m_outports;
        synchronized (vector) {
            this.m_outports.clear();
        }
    }

    public void finalizeContexts() {
        this.rtcout.println(2, "RTObject_impl.finalizeContexts()");
        int n = this.m_eclist.size();
        for (int i = 0; i < n; ++i) {
            try {
                this.m_eclist.elementAt(i).stop();
                this.m_eclist.elementAt(i).finalizeExecutionContext();
                this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_eclist.elementAt(i)));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!this.m_eclist.isEmpty()) {
            this.m_eclist.clear();
        }
    }

    public void addPreComponentActionListener(int n, PreComponentActionListener preComponentActionListener, boolean bl) {
        if (n < 12) {
            this.rtcout.println(2, "addPreComponentActionListener(" + PreComponentActionListenerType.toString(n) + ")");
            this.m_actionListeners.preaction_[n].addObserver(preComponentActionListener);
            return;
        }
        this.rtcout.println(6, "addPreComponentActionListener(): Invalid listener type.");
    }

    public void addPreComponentActionListener(int n, PreComponentActionListener preComponentActionListener) {
        this.addPreComponentActionListener(n, preComponentActionListener, true);
    }

    public <DataType> PreComponentActionListener addPreComponentActionListener(int n, DataType DataType, String string) {
        class Noname
        extends PreComponentActionListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, Integer.TYPE);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(int n) {
                try {
                    this.m_method.invoke(this.m_obj, n);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addPreComponentActionListener(n, noname, true);
        return noname;
    }

    public void removePreComponentActionListener(int n, PreComponentActionListener preComponentActionListener) {
        if (n < 12) {
            this.rtcout.println(2, "removePreComponentActionListener(" + PreComponentActionListenerType.toString(n) + ")");
            this.m_actionListeners.preaction_[n].deleteObserver(preComponentActionListener);
            return;
        }
        this.rtcout.println(6, "removePreComponentActionListener(): Invalid listener type.");
    }

    public void addPostComponentActionListener(int n, PostComponentActionListener postComponentActionListener, boolean bl) {
        if (n < 12) {
            this.rtcout.println(2, "addPostComponentActionListener(" + PostComponentActionListenerType.toString(n) + ")");
            this.m_actionListeners.postaction_[n].addObserver(postComponentActionListener);
            return;
        }
        this.rtcout.println(6, "addPostComponentActionListener(): Invalid listener type.");
    }

    public void addPostComponentActionListener(int n, PostComponentActionListener postComponentActionListener) {
        this.addPostComponentActionListener(n, postComponentActionListener, true);
    }

    public <DataType> PostComponentActionListener addPostComponentActionListener(int n, DataType DataType, String string) {
        class Noname
        extends PostComponentActionListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, Integer.TYPE, ReturnCode_t.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(int n, ReturnCode_t returnCode_t) {
                try {
                    this.m_method.invoke(this.m_obj, n, returnCode_t);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addPostComponentActionListener(n, noname, true);
        return noname;
    }

    public void removePostComponentActionListener(int n, PostComponentActionListener postComponentActionListener) {
        if (n < 12) {
            this.rtcout.println(2, "removePostComponentActionListener(" + PostComponentActionListenerType.toString(n) + ")");
            this.m_actionListeners.postaction_[n].deleteObserver(postComponentActionListener);
            return;
        }
        this.rtcout.println(6, "removePostComponentActionListener(): Invalid listener type.");
    }

    public void addPortActionListener(int n, PortActionListener portActionListener, boolean bl) {
        if (n < 2) {
            this.rtcout.println(2, "addPortActionListener(" + PortActionListenerType.toString(n) + ")");
            this.m_actionListeners.portaction_[n].addObserver(portActionListener);
            return;
        }
        this.rtcout.println(6, "addPortActionListener(): Invalid listener type.");
    }

    public void addPortActionListener(int n, PortActionListener portActionListener) {
        this.addPortActionListener(n, portActionListener, true);
    }

    public <DataType> PortActionListener addPortActionListener(int n, DataType DataType, String string) {
        class Noname
        extends PortActionListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, PortProfile.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(PortProfile portProfile) {
                try {
                    this.m_method.invoke(this.m_obj, portProfile);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addPortActionListener(n, noname, true);
        return noname;
    }

    public void removePortActionListener(int n, PortActionListener portActionListener) {
        if (n < 2) {
            this.rtcout.println(2, "removePortActionListener(" + PortActionListenerType.toString(n) + ")");
            this.m_actionListeners.portaction_[n].deleteObserver(portActionListener);
            return;
        }
        this.rtcout.println(6, "removePortActionListener(): Invalid listener type.");
    }

    public void addExecutionContextActionListener(int n, ExecutionContextActionListener executionContextActionListener, boolean bl) {
        if (n < 2) {
            this.rtcout.println(2, "addExecutionContextActionListener(" + ExecutionContextActionListenerType.toString(n) + ")");
            this.m_actionListeners.ecaction_[n].addObserver(executionContextActionListener);
            return;
        }
        this.rtcout.println(6, "addExecutionContextActionListener(): Invalid listener type.");
    }

    public void addExecutionContextActionListener(int n, ExecutionContextActionListener executionContextActionListener) {
        this.addExecutionContextActionListener(n, executionContextActionListener, true);
    }

    public <DataType> ExecutionContextActionListener addExecutionContextActionListener(int n, DataType DataType, String string) {
        class Noname
        extends ExecutionContextActionListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, Integer.TYPE);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(int n) {
                try {
                    this.m_method.invoke(this.m_obj, n);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addExecutionContextActionListener(n, noname, true);
        return noname;
    }

    public void removeExecutionContextActionListener(int n, ExecutionContextActionListener executionContextActionListener) {
        if (n < 2) {
            this.rtcout.println(2, "removeExecutionContextActionListener(" + ExecutionContextActionListenerType.toString(n) + ")");
            this.m_actionListeners.ecaction_[n].deleteObserver(executionContextActionListener);
            return;
        }
        this.rtcout.println(6, "removeexecutionContextActionListener(): Invalid listener type.");
    }

    public void addPortConnectListener(int n, PortConnectListener portConnectListener) {
        this.addPortConnectListener(n, portConnectListener, true);
    }

    public void addPortConnectListener(int n, PortConnectListener portConnectListener, boolean bl) {
        if (n < 3) {
            this.m_portconnListeners.portconnect_[n].addObserver(portConnectListener);
        }
    }

    public <DataType> PortConnectListener addPortConnectListener(int n, DataType DataType, String string) {
        class Noname
        extends PortConnectListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, String.class, ConnectorProfile.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(String string, ConnectorProfile connectorProfile) {
                try {
                    this.m_method.invoke(this.m_obj, string, connectorProfile);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addPortConnectListener(n, noname, true);
        return noname;
    }

    public void removePortConnectListener(int n, PortConnectListener portConnectListener) {
        if (n < 3) {
            this.m_portconnListeners.portconnect_[n].deleteObserver(portConnectListener);
        }
    }

    public void addPortConnectRetListener(int n, PortConnectRetListener portConnectRetListener) {
        this.addPortConnectRetListener(n, portConnectRetListener, true);
    }

    public void addPortConnectRetListener(int n, PortConnectRetListener portConnectRetListener, boolean bl) {
        if (n < 6) {
            this.m_portconnListeners.portconnret_[n].addObserver(portConnectRetListener);
        }
    }

    public <DataType> PortConnectRetListener addPortConnectRetListener(int n, DataType DataType, String string) {
        class Noname
        extends PortConnectRetListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, String.class, ConnectorProfile.class, ReturnCode_t.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(String string, ConnectorProfile connectorProfile, ReturnCode_t returnCode_t) {
                try {
                    this.m_method.invoke(this.m_obj, string, connectorProfile, returnCode_t);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addPortConnectRetListener(n, noname, true);
        return noname;
    }

    public void removePortConnectRetListener(int n, PortConnectRetListener portConnectRetListener) {
        if (n < 6) {
            this.m_portconnListeners.portconnret_[n].deleteObserver(portConnectRetListener);
        }
    }

    public void addConfigurationParamListener(int n, ConfigurationParamListener configurationParamListener, boolean bl) {
        this.m_configsets.addConfigurationParamListener(n, configurationParamListener, bl);
    }

    public void addConfigurationParamListener(int n, ConfigurationParamListener configurationParamListener) {
        this.addConfigurationParamListener(n, configurationParamListener, true);
    }

    public <DataType> ConfigurationParamListener addConfigurationParamListener(int n, DataType DataType, String string) {
        class Noname
        extends ConfigurationParamListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, String.class, String.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(String string, String string2) {
                try {
                    this.m_method.invoke(this.m_obj, string, string2);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addConfigurationParamListener(n, noname, true);
        return noname;
    }

    public void removeConfigurationParamListener(int n, ConfigurationParamListener configurationParamListener) {
        this.m_configsets.removeConfigurationParamListener(n, configurationParamListener);
    }

    public void addConfigurationSetListener(int n, ConfigurationSetListener configurationSetListener, boolean bl) {
        this.m_configsets.addConfigurationSetListener(n, configurationSetListener, bl);
    }

    public void addConfigurationSetListener(int n, ConfigurationSetListener configurationSetListener) {
        this.addConfigurationSetListener(n, configurationSetListener, true);
    }

    public <DataType> ConfigurationSetListener addConfigurationSetListener(int n, DataType DataType, String string) {
        class Noname
        extends ConfigurationSetListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, Properties.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(Properties properties) {
                try {
                    this.m_method.invoke(this.m_obj, properties);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addConfigurationSetListener(n, noname, true);
        return noname;
    }

    public void removeConfigurationSetListener(int n, ConfigurationSetListener configurationSetListener) {
        this.m_configsets.removeConfigurationSetListener(n, configurationSetListener);
    }

    public void addConfigurationSetNameListener(int n, ConfigurationSetNameListener configurationSetNameListener, boolean bl) {
        this.m_configsets.addConfigurationSetNameListener(n, configurationSetNameListener, bl);
    }

    public void addConfigurationSetNameListener(int n, ConfigurationSetNameListener configurationSetNameListener) {
        this.addConfigurationSetNameListener(n, configurationSetNameListener, true);
    }

    public <DataType> ConfigurationSetNameListener addConfigurationSetNameListener(int n, DataType DataType, String string) {
        class Noname
        extends ConfigurationSetNameListener {
            private DataType m_obj;
            private Method m_method;

            public Noname(DataType DataType, String string) {
                this.m_obj = DataType;
                try {
                    Class<?> clazz = this.m_obj.getClass();
                    this.m_method = clazz.getMethod(string, String.class);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }

            @Override
            public void operator(String string) {
                try {
                    this.m_method.invoke(this.m_obj, string);
                }
                catch (Exception exception) {
                    RTObject_impl.this.rtcout.println(5, "Exception caught." + exception.toString());
                }
            }
        }
        Noname noname = new Noname(DataType, string);
        this.addConfigurationSetNameListener(n, noname, true);
        return noname;
    }

    public void removeConfigurationSetNameListener(int n, ConfigurationSetNameListener configurationSetNameListener) {
        this.m_configsets.removeConfigurationSetNameListener(n, configurationSetNameListener);
    }

    protected void shutdown() {
        try {
            this.finalizePorts();
            this.finalizeContexts();
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this.m_pSdoConfigImpl));
            this.m_pPOA.deactivate_object(this.m_pPOA.servant_to_id((Servant)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_pManager != null) {
            this.m_pManager.cleanupComponent(this);
        }
    }

    protected void preOnInitialize(int n) {
        this.m_actionListeners.preaction_[0].notify(n);
    }

    protected void preOnFinalize(int n) {
        this.m_actionListeners.preaction_[1].notify(n);
    }

    protected void preOnStartup(int n) {
        this.m_actionListeners.preaction_[2].notify(n);
    }

    protected void preOnShutdown(int n) {
        this.m_actionListeners.preaction_[3].notify(n);
    }

    protected void preOnActivated(int n) {
        this.m_actionListeners.preaction_[4].notify(n);
    }

    protected void preOnDeactivated(int n) {
        this.m_actionListeners.preaction_[5].notify(n);
    }

    protected void preOnAborting(int n) {
        this.m_actionListeners.preaction_[6].notify(n);
    }

    protected void preOnError(int n) {
        this.m_actionListeners.preaction_[7].notify(n);
    }

    protected void preOnReset(int n) {
        this.m_actionListeners.preaction_[8].notify(n);
    }

    protected void preOnExecute(int n) {
        this.m_actionListeners.preaction_[9].notify(n);
    }

    protected void preOnStateUpdate(int n) {
        this.m_actionListeners.preaction_[10].notify(n);
    }

    protected void preOnRateChanged(int n) {
        this.m_actionListeners.preaction_[11].notify(n);
    }

    protected void postOnInitialize(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[0].notify(n, returnCode_t);
    }

    protected void postOnFinalize(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[1].notify(n, returnCode_t);
    }

    protected void postOnStartup(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[2].notify(n, returnCode_t);
    }

    protected void postOnShutdown(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[3].notify(n, returnCode_t);
    }

    protected void postOnActivated(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[4].notify(n, returnCode_t);
    }

    protected void postOnDeactivated(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[5].notify(n, returnCode_t);
    }

    protected void postOnAborting(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[6].notify(n, returnCode_t);
    }

    protected void postOnError(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[7].notify(n, returnCode_t);
    }

    protected void postOnReset(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[8].notify(n, returnCode_t);
    }

    protected void postOnExecute(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[9].notify(n, returnCode_t);
    }

    protected void postOnStateUpdate(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[10].notify(n, returnCode_t);
    }

    protected void postOnRateChanged(int n, ReturnCode_t returnCode_t) {
        this.m_actionListeners.postaction_[11].notify(n, returnCode_t);
    }

    protected void onAddPort(PortProfile portProfile) {
        this.m_actionListeners.portaction_[0].notify(portProfile);
    }

    protected void onRemovePort(PortProfile portProfile) {
        this.m_actionListeners.portaction_[1].notify(portProfile);
    }

    protected void onAttachExecutionContext(int n) {
        this.m_actionListeners.ecaction_[0].notify(n);
    }

    protected void onDetachExecutionContext(int n) {
        this.m_actionListeners.ecaction_[1].notify(n);
    }

    class deactivate_comps
    implements operatorFunc {
        LightweightRTObject m_comp;

        deactivate_comps(LightweightRTObject lightweightRTObject) {
            this.m_comp = lightweightRTObject;
        }

        @Override
        public void operator(Object object) {
            this.operator((ExecutionContextService)object);
        }

        void operator(ExecutionContextService executionContextService) {
            if (executionContextService != null && !executionContextService._non_existent()) {
                executionContextService.deactivate_component((LightweightRTObject)this.m_comp._duplicate());
                executionContextService.stop();
            }
        }
    }

    class ec_find
    implements equalFunctor {
        private ExecutionContext m_ec;

        public ec_find(ExecutionContext executionContext) {
            this.m_ec = executionContext;
        }

        @Override
        public boolean equalof(Object object) {
            return this.operator((ExecutionContextService)object);
        }

        public boolean operator(ExecutionContextService executionContextService) {
            try {
                if (executionContextService != null) {
                    ExecutionContext executionContext = ExecutionContextHelper.narrow(executionContextService);
                    return this.m_ec._is_equivalent(executionContext);
                }
            }
            catch (Exception exception) {
                return false;
            }
            return false;
        }
    }

    class ec_copy
    implements operatorFunc {
        private ExecutionContextListHolder m_eclist;

        public ec_copy(ExecutionContextListHolder executionContextListHolder) {
            this.m_eclist = executionContextListHolder;
        }

        @Override
        public void operator(Object object) {
            this.operator((ExecutionContextService)object);
        }

        public void operator(ExecutionContextService executionContextService) {
            if (executionContextService != null) {
                CORBA_SeqUtil.push_back(this.m_eclist, (ExecutionContext)executionContextService._duplicate());
            }
        }
    }

    class nv_name
    implements equalFunctor {
        private String m_name;

        public nv_name(String string) {
            this.m_name = string;
        }

        @Override
        public boolean equalof(Object object) {
            return this.m_name.equals(((NameValue)object).name);
        }
    }
}

