/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.ReturnCode_t;
import _SDOPackage.NVListHolder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.InPortProviderFactory;
import jp.go.aist.rtm.RTC.OutPortConsumerFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorDataListenerT;
import jp.go.aist.rtm.RTC.port.ConnectorDataListenerType;
import jp.go.aist.rtm.RTC.port.ConnectorListener;
import jp.go.aist.rtm.RTC.port.ConnectorListenerType;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.InPortProvider;
import jp.go.aist.rtm.RTC.port.InPortPullConnector;
import jp.go.aist.rtm.RTC.port.InPortPushConnector;
import jp.go.aist.rtm.RTC.port.OutPortConsumer;
import jp.go.aist.rtm.RTC.port.PortBase;
import jp.go.aist.rtm.RTC.util.CORBA_SeqUtil;
import jp.go.aist.rtm.RTC.util.NVUtil;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.portable.OutputStream;

public abstract class InPortBase
extends PortBase {
    protected boolean m_singlebuffer;
    protected BufferBase<OutputStream> m_thebuffer;
    protected Properties m_properties = new Properties();
    protected Vector<String> m_providerTypes = new Vector();
    protected Vector<String> m_consumerTypes = new Vector();
    protected Vector<InPortConnector> m_connectors = new Vector();
    private boolean m_isLittleEndian;
    protected ConnectorListeners m_listeners = new ConnectorListeners();

    public InPortBase(String string, String string2) {
        super(string);
        this.rtcout.println(3, "Port name: " + string);
        this.m_singlebuffer = true;
        this.m_thebuffer = null;
        this.m_isLittleEndian = true;
        this.rtcout.println(3, "setting port.port_type: DataIntPort");
        this.addProperty("port.port_type", "DataInPort", String.class);
        this.rtcout.println(3, "setting dataport.data_type: " + string2);
        this.addProperty("dataport.data_type", string2, String.class);
        this.addProperty("dataport.subscription_type", "Any", String.class);
    }

    public Properties properties() {
        this.rtcout.println(2, "properties()");
        return this.m_properties;
    }

    public final Vector<InPortConnector> connectors() {
        this.rtcout.println(2, "connectors(): size = " + this.m_connectors.size());
        return this.m_connectors;
    }

    public Vector<ConnectorBase.ConnectorInfo> getConnectorProfiles() {
        this.rtcout.println(2, "getConnectorProfiles(): size = " + this.m_connectors.size());
        Vector<ConnectorBase.ConnectorInfo> vector = new Vector<ConnectorBase.ConnectorInfo>();
        int n = this.m_connectors.size();
        for (int i = 0; i < n; ++i) {
            vector.add(this.m_connectors.elementAt(i).profile());
        }
        return vector;
    }

    public Vector<String> getConnectorIds() {
        Vector<String> vector = new Vector<String>();
        int n = this.m_connectors.size();
        for (int i = 0; i < n; ++i) {
            vector.add(this.m_connectors.elementAt(i).id());
        }
        this.rtcout.println(2, "getConnectorIds(): " + vector);
        return vector;
    }

    public Vector<String> getConnectorNames() {
        Vector<String> vector = new Vector<String>();
        int n = this.m_connectors.size();
        for (int i = 0; i < n; ++i) {
            vector.add(this.m_connectors.elementAt(i).name());
        }
        this.rtcout.println(2, "getConnectorNames(): " + vector);
        return vector;
    }

    public InPortConnector getConnectorById(String string) {
        this.rtcout.println(2, "getConnectorById(id = " + string + ")");
        String string2 = string;
        int n = this.m_connectors.size();
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(this.m_connectors.elementAt(i).id())) continue;
            return this.m_connectors.elementAt(i);
        }
        this.rtcout.println(5, "ConnectorProfile with the id(" + string + ") not found.");
        return null;
    }

    public InPortConnector getConnectorByName(String string) {
        this.rtcout.println(2, "getConnectorByName(name = " + string + ")");
        String string2 = string;
        int n = this.m_connectors.size();
        for (int i = 0; i < n; ++i) {
            if (!string2.equals(this.m_connectors.elementAt(i).name())) continue;
            return this.m_connectors.elementAt(i);
        }
        this.rtcout.println(5, "ConnectorProfile with the name(" + string + ") not found.");
        return null;
    }

    public boolean getConnectorProfileById(String string, ConnectorBase.ConnectorInfoHolder connectorInfoHolder) {
        this.rtcout.println(2, "getConnectorProfileById(id = " + string + ")");
        InPortConnector inPortConnector = this.getConnectorById(string);
        if (inPortConnector == null) {
            return false;
        }
        connectorInfoHolder.value = inPortConnector.profile();
        return true;
    }

    public boolean getConnectorProfileByName(String string, ConnectorBase.ConnectorInfoHolder connectorInfoHolder) {
        this.rtcout.println(2, "getConnectorProfileByName(name = " + string + ")");
        InPortConnector inPortConnector = this.getConnectorByName(string);
        if (inPortConnector == null) {
            return false;
        }
        connectorInfoHolder.value = inPortConnector.profile();
        return true;
    }

    public void init(Properties properties) {
        this.rtcout.println(2, "init()");
        this.m_properties.merge(properties);
        if (this.m_singlebuffer) {
            this.rtcout.println(3, "single buffer mode.");
            BufferFactory bufferFactory = BufferFactory.instance();
            this.m_thebuffer = (BufferBase)bufferFactory.createObject("ring_buffer");
            if (this.m_thebuffer == null) {
                this.rtcout.println(6, "default buffer creation failed.");
            }
        } else {
            this.rtcout.println(3, "multi buffer mode.");
        }
        this.initProviders();
        this.initConsumers();
        int n = -1;
        String string = this.m_properties.getProperty("connection_limit", "-1");
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            this.rtcout.println(6, "invalid connection_limit value: " + string);
        }
        this.setConnectionLimit(n);
    }

    public abstract boolean read();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateInterfaces() {
        this.rtcout.println(2, "activateInterfaces()");
        Vector<InPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                this.m_connectors.elementAt(i).activate();
                this.rtcout.println(3, "activate connector: " + this.m_connectors.elementAt(i).name() + " " + this.m_connectors.elementAt(i).id());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivateInterfaces() {
        this.rtcout.println(2, "deactivateInterfaces()");
        Vector<InPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            int n = this.m_connectors.size();
            for (int i = 0; i < n; ++i) {
                this.m_connectors.elementAt(i).deactivate();
                this.rtcout.println(3, "deactivate connector: " + this.m_connectors.elementAt(i).name() + " " + this.m_connectors.elementAt(i).id());
            }
        }
    }

    @Override
    public ReturnCode_t connect(ConnectorProfileHolder connectorProfileHolder) {
        int n;
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        Properties properties = new Properties();
        NVUtil.copyToProperties(properties, nVListHolder);
        if (null != properties.findNode("dataport") && (n = NVUtil.find_index(nVListHolder, "dataport.serializer.cdr.endian")) < 0) {
            CORBA_SeqUtil.push_back(nVListHolder, NVUtil.newNVString("dataport.serializer.cdr.endian", "little,big"));
            connectorProfileHolder.value.properties = nVListHolder.value;
        }
        return super.connect(connectorProfileHolder);
    }

    @Override
    protected ReturnCode_t publishInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        Object object2;
        Object object3;
        this.rtcout.println(2, "publishInterfaces()");
        ReturnCode_t returnCode_t = this._publishInterfaces();
        if (returnCode_t != ReturnCode_t.RTC_OK) {
            return returnCode_t;
        }
        Properties properties = this.m_properties;
        Object object4 = new Properties();
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        NVUtil.copyToProperties((Properties)object4, nVListHolder);
        properties.merge(((Properties)object4).getNode("dataport"));
        properties.merge(((Properties)object4).getNode("dataport.inport"));
        this.rtcout.println(3, "ConnectorProfile::properties are as follows.");
        object4 = new String();
        object4 = properties._dump((String)object4, properties, 0);
        this.rtcout.println(3, (String)object4);
        nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        try {
            int n;
            object3 = NVUtil.find(nVListHolder, "dataport.serializer.cdr.endian");
            object2 = object3.type().kind() == TCKind.tk_wstring ? object3.extract_wstring() : object3.extract_string();
            object2 = StringUtil.normalize((String)object2);
            object = ((String)object2).split(",");
            object2 = "";
            for (n = 0; n < ((String[])object).length; ++n) {
                String string = object[n].trim();
                if (!string.equals("big") && !string.equals("little")) continue;
                object2 = ((String)object2).length() != 0 ? (String)object2 + "," + string : (String)object2 + string;
            }
            n = NVUtil.find_index(nVListHolder, "dataport.serializer.cdr.endian");
            nVListHolder.value[n].value.insert_string((String)object2);
            connectorProfileHolder.value.properties = nVListHolder.value;
        }
        catch (Exception exception) {
            // empty catch block
        }
        object3 = properties.getProperty("dataflow_type");
        object3 = StringUtil.normalize((String)object3);
        if (((String)object3).equals("push")) {
            this.rtcout.println(3, "dataflow_type = push .... create PushConnector");
            object2 = this.createProvider(connectorProfileHolder, properties);
            if (object2 == null) {
                this.rtcout.println(6, "InPort provider creation failed.");
                return ReturnCode_t.BAD_PARAMETER;
            }
            object = this.createConnector(connectorProfileHolder, properties, (InPortProvider)object2);
            if (object == null) {
                this.rtcout.println(6, "PushConnector creation failed.");
                return ReturnCode_t.RTC_ERROR;
            }
            object2.setConnector((InPortConnector)object);
            this.rtcout.println(3, "publishInterface() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        if (((String)object3).equals("pull")) {
            this.rtcout.println(3, "dataflow_type = pull .... do nothing.");
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(6, "unsupported dataflow_type:" + (String)object3);
        return ReturnCode_t.BAD_PARAMETER;
    }

    @Override
    protected ReturnCode_t subscribeInterfaces(ConnectorProfileHolder connectorProfileHolder) {
        Object object;
        Object object2;
        Object object3;
        this.rtcout.println(2, "subscribeInterfaces()");
        Properties properties = this.m_properties;
        Object object4 = new Properties();
        NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        NVUtil.copyToProperties((Properties)object4, nVListHolder);
        properties.merge(((Properties)object4).getNode("dataport"));
        properties.merge(((Properties)object4).getNode("dataport.inport"));
        this.rtcout.println(3, "ConnectorProfile::properties are as follows.");
        object4 = new String();
        object4 = properties._dump((String)object4, properties, 0);
        this.rtcout.println(3, (String)object4);
        nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
        try {
            object3 = NVUtil.find(nVListHolder, "dataport.serializer.cdr.endian");
            object2 = object3.type().kind() == TCKind.tk_wstring ? object3.extract_wstring() : object3.extract_string();
            object2 = StringUtil.normalize((String)object2);
            object = ((String)object2).split(",");
            String string = object[0].trim();
            if (string.length() == 0) {
                this.rtcout.println(6, "unsupported endian");
                return ReturnCode_t.UNSUPPORTED;
            }
            this.m_isLittleEndian = string.equals("little") ? true : !string.equals("big");
        }
        catch (Exception exception) {
            this.m_isLittleEndian = true;
        }
        this.rtcout.println(2, "Little Endian = " + this.m_isLittleEndian);
        object3 = properties.getProperty("dataflow_type");
        object3 = StringUtil.normalize((String)object3);
        if (((String)object3).equals("push")) {
            this.rtcout.println(3, "dataflow_type is push.");
            object2 = this.getConnectorById(connectorProfileHolder.value.connector_id);
            if (object2 == null) {
                this.rtcout.println(6, "specified connector not found: " + connectorProfileHolder.value.connector_id);
                return ReturnCode_t.RTC_ERROR;
            }
            ((InPortConnector)object2).setEndian(this.m_isLittleEndian);
            this.rtcout.println(3, "subscribeInterfaces() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        if (((String)object3).equals("pull")) {
            this.rtcout.println(3, "dataflow_type is pull.");
            object2 = this.createConsumer(connectorProfileHolder, properties);
            if (object2 == null) {
                return ReturnCode_t.BAD_PARAMETER;
            }
            object = this.createConnector(connectorProfileHolder, properties, (OutPortConsumer)object2);
            if (object == null) {
                return ReturnCode_t.RTC_ERROR;
            }
            object2.setConnector((InPortConnector)object);
            ((InPortConnector)object).setEndian(this.m_isLittleEndian);
            this.rtcout.println(3, "publishInterface() successfully finished.");
            return ReturnCode_t.RTC_OK;
        }
        this.rtcout.println(6, "unsupported dataflow_type:" + (String)object3);
        return ReturnCode_t.BAD_PARAMETER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unsubscribeInterfaces(ConnectorProfile connectorProfile) {
        this.rtcout.println(2, "unsubscribeInterfaces()");
        String string = connectorProfile.connector_id;
        this.rtcout.println(0, "connector_id: " + string);
        Vector<InPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            Iterator<InPortConnector> iterator = this.m_connectors.iterator();
            while (iterator.hasNext()) {
                InPortConnector inPortConnector = iterator.next();
                if (!string.equals(inPortConnector.id())) continue;
                inPortConnector.disconnect();
                iterator.remove();
                this.rtcout.println(2, "delete connector: " + string);
                return;
            }
            this.rtcout.println(6, "specified connector not found: " + string);
            return;
        }
    }

    public void addConnectorDataListener(int n, ConnectorDataListenerT connectorDataListenerT, boolean bl) {
        if (n < 10) {
            this.rtcout.println(2, "addConnectorDataListener(" + ConnectorDataListenerType.toString(n) + ")");
            this.m_listeners.connectorData_[n].addObserver(connectorDataListenerT);
            return;
        }
        this.rtcout.println(6, "addConnectorDataListener(): Invalid listener type.");
    }

    public void addConnectorDataListener(int n, ConnectorDataListenerT connectorDataListenerT) {
        this.addConnectorDataListener(n, connectorDataListenerT, true);
    }

    public void removeConnectorDataListener(int n, ConnectorDataListenerT connectorDataListenerT) {
        if (n < 10) {
            this.rtcout.println(2, "removeConnectorDataListener(" + ConnectorDataListenerType.toString(n) + ")");
            this.m_listeners.connectorData_[n].deleteObserver(connectorDataListenerT);
            return;
        }
        this.rtcout.println(6, "removeConnectorDataListener(): Invalid listener type.");
    }

    public void addConnectorListener(int n, ConnectorListener connectorListener, boolean bl) {
        if (n < 7) {
            this.rtcout.println(2, "addConnectorListener(" + ConnectorListenerType.toString(n) + ")");
            this.m_listeners.connector_[n].addObserver(connectorListener);
            return;
        }
        this.rtcout.println(6, "addConnectorListener(): Invalid listener type.");
    }

    public void addConnectorListener(int n, ConnectorListener connectorListener) {
        this.addConnectorListener(n, connectorListener, true);
    }

    public void removeConnectorListener(int n, ConnectorListener connectorListener) {
        if (n < 7) {
            this.rtcout.println(2, "removeConnectorListener(" + ConnectorListenerType.toString(n) + ")");
            this.m_listeners.connector_[n].deleteObserver(connectorListener);
            return;
        }
        this.rtcout.println(6, "removeConnectorListener(): Invalid listener type.");
    }

    protected void initProviders() {
        Object object;
        this.rtcout.println(2, "initProviders()");
        InPortProviderFactory inPortProviderFactory = InPortProviderFactory.instance();
        Set set = inPortProviderFactory.getIdentifiers();
        this.rtcout.println(3, "available providers: " + set.toString());
        String string = StringUtil.normalize(this.m_properties.getProperty("provider_types"));
        if (this.m_properties.hasKey("provider_types") != null && !string.equals("all")) {
            this.rtcout.println(3, "allowed providers: " + this.m_properties.getProperty("provider_types"));
            object = set;
            set.clear();
            Vector<String> vector = StringUtil.split(this.m_properties.getProperty("provider_types"), ",");
            HashSet hashSet = new HashSet(object);
            HashSet<String> hashSet2 = new HashSet<String>(vector);
            for (String string2 : hashSet) {
                if (!hashSet2.contains(string2)) continue;
                set.add(string2);
            }
        }
        if (set.size() > 0) {
            this.rtcout.println(3, "dataflow_type push is supported");
            this.appendProperty("dataport.dataflow_type", "push");
            this.appendProperty("dataport.interface_type", StringUtil.flatten(set));
        }
        object = set.iterator();
        while (object.hasNext()) {
            this.m_providerTypes.add((String)object.next());
        }
    }

    protected void initConsumers() {
        Object object;
        this.rtcout.println(2, "iinitConsumers()");
        OutPortConsumerFactory outPortConsumerFactory = OutPortConsumerFactory.instance();
        Set set = outPortConsumerFactory.getIdentifiers();
        this.rtcout.println(3, "available consumer: " + StringUtil.flatten(set));
        String string = StringUtil.normalize(this.m_properties.getProperty("consumer_types"));
        if (this.m_properties.hasKey("consumer_types") != null && !string.equals("all")) {
            this.rtcout.println(3, "allowed consumers: " + this.m_properties.getProperty("consumer_types"));
            object = set;
            set.clear();
            Vector<String> vector = StringUtil.split(this.m_properties.getProperty("consumer_types"), ",");
            HashSet hashSet = new HashSet(object);
            HashSet<String> hashSet2 = new HashSet<String>(vector);
            for (String string2 : hashSet) {
                if (!hashSet2.contains(string2)) continue;
                set.add(string2);
            }
        }
        if (set.size() > 0) {
            this.rtcout.println(3, "dataflow_type pull is supported");
            this.appendProperty("dataport.dataflow_type", "pull");
            this.appendProperty("dataport.interface_type", StringUtil.flatten(set));
        }
        object = set.iterator();
        while (object.hasNext()) {
            this.m_consumerTypes.add((String)object.next());
        }
    }

    protected InPortProvider createProvider(ConnectorProfileHolder connectorProfileHolder, Properties properties) {
        if (properties.getProperty("interface_type").length() != 0 && !StringUtil.includes(this.m_providerTypes, properties.getProperty("interface_type"), true)) {
            this.rtcout.println(6, "no provider found");
            this.rtcout.println(6, "interface_type:  " + properties.getProperty("interface_type"));
            this.rtcout.println(6, "interface_types:  " + this.m_providerTypes.toString());
            return null;
        }
        this.rtcout.println(3, "interface_type:  " + properties.getProperty("interface_type"));
        InPortProviderFactory inPortProviderFactory = InPortProviderFactory.instance();
        InPortProvider inPortProvider = (InPortProvider)inPortProviderFactory.createObject(properties.getProperty("interface_type"));
        if (inPortProvider != null) {
            this.rtcout.println(3, "provider created");
            inPortProvider.init(properties.getNode("provider"));
            NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
            if (!inPortProvider.publishInterface(nVListHolder)) {
                this.rtcout.println(6, "publishing interface information error");
                inPortProviderFactory.deleteObject(inPortProvider);
                return null;
            }
            connectorProfileHolder.value.properties = nVListHolder.value;
            return inPortProvider;
        }
        this.rtcout.println(6, "provider creation failed");
        return null;
    }

    protected OutPortConsumer createConsumer(ConnectorProfileHolder connectorProfileHolder, Properties properties) {
        if (properties.getProperty("interface_type").length() != 0 && !StringUtil.includes(this.m_consumerTypes, properties.getProperty("interface_type"), true)) {
            this.rtcout.println(6, "no consumer found");
            this.rtcout.println(6, "interface_type:  " + properties.getProperty("interface_type"));
            this.rtcout.println(6, "interface_types:  " + this.m_consumerTypes.toString());
            return null;
        }
        this.rtcout.println(3, "interface_type:  " + properties.getProperty("interface_type"));
        OutPortConsumerFactory outPortConsumerFactory = OutPortConsumerFactory.instance();
        OutPortConsumer outPortConsumer = (OutPortConsumer)outPortConsumerFactory.createObject(properties.getProperty("interface_type"));
        if (outPortConsumer != null) {
            this.rtcout.println(3, "consumer created");
            outPortConsumer.init(properties.getNode("consumer"));
            NVListHolder nVListHolder = new NVListHolder(connectorProfileHolder.value.properties);
            if (!outPortConsumer.subscribeInterface(nVListHolder)) {
                this.rtcout.println(6, "interface subscription failed.");
                outPortConsumerFactory.deleteObject(outPortConsumer);
                return null;
            }
            return outPortConsumer;
        }
        this.rtcout.println(6, "consumer creation failed");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InPortConnector createConnector(ConnectorProfileHolder connectorProfileHolder, Properties properties, InPortProvider inPortProvider) {
        ConnectorBase.ConnectorInfo connectorInfo = new ConnectorBase.ConnectorInfo(connectorProfileHolder.value.name, connectorProfileHolder.value.connector_id, CORBA_SeqUtil.refToVstring(connectorProfileHolder.value.ports), properties);
        InPortPushConnector inPortPushConnector = null;
        Vector<InPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            try {
                if (this.m_singlebuffer) {
                    inPortPushConnector = new InPortPushConnector(connectorInfo, inPortProvider, this.m_listeners, this.m_thebuffer);
                } else {
                    BufferBase<OutputStream> bufferBase = null;
                    inPortPushConnector = new InPortPushConnector(connectorInfo, inPortProvider, this.m_listeners, bufferBase);
                }
                if (inPortPushConnector == null) {
                    this.rtcout.println(6, "old compiler? new returned 0;");
                    return null;
                }
                this.rtcout.println(2, "InPortPushConnector create");
                this.m_connectors.add(inPortPushConnector);
                this.rtcout.println(0, "connector push backed: " + this.m_connectors.size());
                return inPortPushConnector;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "InPortPushConnector creation failed");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InPortConnector createConnector(ConnectorProfileHolder connectorProfileHolder, Properties properties, OutPortConsumer outPortConsumer) {
        ConnectorBase.ConnectorInfo connectorInfo = new ConnectorBase.ConnectorInfo(connectorProfileHolder.value.name, connectorProfileHolder.value.connector_id, CORBA_SeqUtil.refToVstring(connectorProfileHolder.value.ports), properties);
        InPortPullConnector inPortPullConnector = null;
        Vector<InPortConnector> vector = this.m_connectors;
        synchronized (vector) {
            try {
                if (this.m_singlebuffer) {
                    inPortPullConnector = new InPortPullConnector(connectorInfo, outPortConsumer, this.m_listeners, this.m_thebuffer);
                } else {
                    BufferBase<OutputStream> bufferBase = null;
                    inPortPullConnector = new InPortPullConnector(connectorInfo, outPortConsumer, this.m_listeners, bufferBase);
                }
                if (inPortPullConnector == null) {
                    this.rtcout.println(6, "old compiler? new returned 0;");
                    return null;
                }
                this.rtcout.println(2, "InPortPullConnector create");
                this.m_connectors.add(inPortPullConnector);
                this.rtcout.println(0, "connector push backed: " + this.m_connectors.size());
                return inPortPullConnector;
            }
            catch (Exception exception) {
                this.rtcout.println(6, "InPortPullConnector creation failed");
                return null;
            }
        }
    }

    public boolean isLittleEndian() {
        return this.m_isLittleEndian;
    }
}

