/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import com.sun.corba.se.impl.encoding.EncapsOutputStream;
import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.OutPortConsumerFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.OutPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.DataRef;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class InPortPullConnector
extends InPortConnector {
    private OutPortConsumer m_consumer;
    private Logbuf rtcout;
    private ConnectorListeners m_listeners;

    public InPortPullConnector(ConnectorBase.ConnectorInfo connectorInfo, OutPortConsumer outPortConsumer, ConnectorListeners connectorListeners, BufferBase<OutputStream> bufferBase) throws Exception {
        super(connectorInfo, bufferBase);
        this.m_consumer = outPortConsumer;
        this.m_listeners = connectorListeners;
        this.rtcout = new Logbuf("InPortPullConnector");
        if (bufferBase == null) {
            this.m_buffer = this.createBuffer(this.m_profile);
        }
        if (this.m_buffer == null || this.m_consumer == null) {
            throw new Exception("bad_alloc()");
        }
        this.m_buffer.init(connectorInfo.properties.getNode("buffer"));
        this.m_consumer.setBuffer(this.m_buffer);
        this.m_consumer.setListener(connectorInfo, this.m_listeners);
        this.onConnect();
    }

    @Override
    public ReturnCode read(DataRef<InputStream> dataRef) {
        this.rtcout.println(2, "InPortPullConnector.read()");
        if (this.m_consumer == null) {
            return ReturnCode.PORT_ERROR;
        }
        EncapsOutputStream encapsOutputStream = new EncapsOutputStream(this.m_spi_orb, this.m_isLittleEndian);
        ReturnCode returnCode = this.m_consumer.get((OutputStream)encapsOutputStream);
        DataRef<EncapsOutputStream> dataRef2 = new DataRef<EncapsOutputStream>(encapsOutputStream);
        dataRef.v = ((OutputStream)dataRef2.v).create_input_stream();
        return returnCode;
    }

    @Override
    public ReturnCode disconnect() {
        this.rtcout.println(2, "disconnect()");
        this.onDisconnect();
        if (this.m_consumer != null) {
            this.rtcout.println(3, "delete consumer");
            OutPortConsumerFactory outPortConsumerFactory = OutPortConsumerFactory.instance();
            outPortConsumerFactory.deleteObject(this.m_consumer);
        }
        return ReturnCode.PORT_OK;
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.ConnectorInfo connectorInfo) {
        String string = connectorInfo.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }

    protected void onConnect() {
        this.m_listeners.connector_[5].notify(this.m_profile);
    }

    protected void onDisconnect() {
        this.m_listeners.connector_[6].notify(this.m_profile);
    }

    @Override
    public void setListener(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners) {
    }
}

