/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import jp.go.aist.rtm.RTC.BufferFactory;
import jp.go.aist.rtm.RTC.FactoryGlobal;
import jp.go.aist.rtm.RTC.InPortProviderFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConnector;
import jp.go.aist.rtm.RTC.port.InPortProvider;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.util.DataRef;
import org.omg.CORBA.Any;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class InPortPushConnector
extends InPortConnector {
    private InPortProvider m_provider;
    private boolean m_deleteBuffer;
    private ConnectorListeners m_listeners;

    public InPortPushConnector(ConnectorBase.ConnectorInfo connectorInfo, InPortProvider inPortProvider, ConnectorListeners connectorListeners, BufferBase<OutputStream> bufferBase) throws Exception {
        super(connectorInfo, bufferBase);
        this.m_provider = inPortProvider;
        this.m_listeners = connectorListeners;
        this.m_deleteBuffer = bufferBase == null;
        if (this.m_buffer == null) {
            this.m_buffer = this.createBuffer(connectorInfo);
        }
        if (this.m_buffer == null || this.m_provider == null) {
            if (this.m_buffer == null) {
                this.rtcout.println(0, "    m_buffer is null.");
            }
            if (this.m_provider == null) {
                this.rtcout.println(0, "    m_provider is null.");
            }
            throw new Exception("bad_alloc()");
        }
        this.m_buffer.init(connectorInfo.properties.getNode("buffer"));
        this.m_provider.init(connectorInfo.properties);
        this.m_provider.setBuffer(this.m_buffer);
        this.m_provider.setListener(connectorInfo, this.m_listeners);
        this.onConnect();
    }

    @Override
    public void setListener(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners) {
        this.m_provider.setListener(connectorInfo, this.m_listeners);
    }

    @Override
    public ReturnCode read(DataRef<InputStream> dataRef) {
        this.rtcout.println(2, "read()");
        if (this.m_buffer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        Any any = this.m_orb.create_any();
        OutputStream outputStream = any.create_output_stream();
        DataRef<OutputStream> dataRef2 = new DataRef<OutputStream>(outputStream);
        jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode = this.m_buffer.read(dataRef2, -1, -1);
        dataRef.v = ((OutputStream)dataRef2.v).create_input_stream();
        return this.convertReturn(returnCode);
    }

    @Override
    public ReturnCode disconnect() {
        FactoryGlobal factoryGlobal;
        this.rtcout.println(2, "disconnect()");
        this.onDisconnect();
        if (this.m_provider != null) {
            factoryGlobal = InPortProviderFactory.instance();
            factoryGlobal.deleteObject(this.m_provider);
        }
        this.m_provider = null;
        if (this.m_buffer != null && this.m_deleteBuffer) {
            factoryGlobal = BufferFactory.instance();
            factoryGlobal.deleteObject(this.m_buffer);
        }
        this.m_buffer = null;
        return ReturnCode.PORT_OK;
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    protected BufferBase<OutputStream> createBuffer(ConnectorBase.ConnectorInfo connectorInfo) {
        String string = connectorInfo.properties.getProperty("buffer_type", "ring_buffer");
        BufferFactory bufferFactory = BufferFactory.instance();
        return (BufferBase)bufferFactory.createObject(string);
    }

    protected void onConnect() {
        this.m_listeners.connector_[5].notify(this.m_profile);
    }

    protected void onDisconnect() {
        this.m_listeners.connector_[6].notify(this.m_profile);
    }

    protected ReturnCode convertReturn(jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode) {
        switch (returnCode) {
            case BUFFER_OK: {
                return ReturnCode.PORT_OK;
            }
            case BUFFER_EMPTY: {
                return ReturnCode.BUFFER_EMPTY;
            }
            case TIMEOUT: {
                return ReturnCode.BUFFER_TIMEOUT;
            }
            case PRECONDITION_NOT_MET: {
                return ReturnCode.PRECONDITION_NOT_MET;
            }
        }
        return ReturnCode.PORT_ERROR;
    }
}

