/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port;

import RTC.ConnectorProfile;
import RTC.ConnectorProfileHolder;
import RTC.Time;
import com.sun.corba.se.spi.orb.ORB;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Vector;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.buffer.RingBuffer;
import jp.go.aist.rtm.RTC.port.OnConnect;
import jp.go.aist.rtm.RTC.port.OnDisconnect;
import jp.go.aist.rtm.RTC.port.OnOverflow;
import jp.go.aist.rtm.RTC.port.OnRead;
import jp.go.aist.rtm.RTC.port.OnReadConvert;
import jp.go.aist.rtm.RTC.port.OnUnderflow;
import jp.go.aist.rtm.RTC.port.OnWrite;
import jp.go.aist.rtm.RTC.port.OnWriteConvert;
import jp.go.aist.rtm.RTC.port.OutPortBase;
import jp.go.aist.rtm.RTC.port.OutPortConnector;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.DataRef;
import jp.go.aist.rtm.RTC.util.ORBUtil;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public class OutPort<DataType>
extends OutPortBase {
    private BufferBase<DataType> m_buffer;
    private DataRef<DataType> m_value;
    private long m_timeoutTick;
    private boolean m_readBlock;
    private long m_readTimeout;
    private boolean m_writeBlock;
    private long m_writeTimeout;
    private OnWrite<DataType> m_OnWrite;
    private OnWriteConvert<DataType> m_OnWriteConvert;
    private OnRead<DataType> m_OnRead;
    private OnReadConvert<DataType> m_OnReadConvert;
    private OnOverflow<DataType> m_OnOverflow;
    private OnUnderflow<DataType> m_OnUnderflow;
    private OnConnect m_OnConnect;
    private OnDisconnect m_OnDisconnect;
    private Streamable m_streamable = null;
    private Field m_field = null;
    private ORB m_spi_orb;
    private Vector<ReturnCode> m_status = new Vector();

    private static <DataType> String toTypeCode(DataRef<DataType> dataRef) {
        String string = dataRef.v.getClass().getSimpleName();
        return string;
    }

    private static <DataType> String toRepositoryId(DataRef<DataType> dataRef) {
        String string = new String();
        Class<?> clazz = dataRef.v.getClass();
        String string2 = clazz.getName();
        try {
            Class<?> clazz2 = Class.forName(string2 + "Helper");
            Method method = clazz2.getMethod("id", new Class[0]);
            string = (String)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void write_stream(DataType DataType, OutputStream outputStream) {
        try {
            this.m_field.set(this.m_streamable, DataType);
            this.m_streamable._write(outputStream);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.rtcout.println(5, "Exception caught." + illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.rtcout.println(5, "Exception caught." + illegalArgumentException.toString());
        }
    }

    public void setTimestamp(DataType DataType) {
        long l = System.nanoTime();
        Time time = new Time((int)(l / 1000000000L), (int)(l % 1000000000L));
        Class<?> clazz = DataType.getClass();
        String string = clazz.getName();
        try {
            clazz.getField("tm").set(DataType, time);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    private void set_timestamp(DataType DataType) {
        long l = System.nanoTime();
        Time time = new Time((int)(l / 1000000000L), (int)(l % 1000000000L));
        Class<?> clazz = DataType.getClass();
        String string = clazz.getName();
        try {
            clazz.getField("tm").set(DataType, time);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Time get_timestamp() {
        long l = System.nanoTime();
        Time time = new Time((int)(l / 1000000000L), (int)(l % 1000000000L));
        return time;
    }

    public OutPort(String string, DataRef<DataType> dataRef) {
        this(new RingBuffer(8), string, dataRef);
    }

    public OutPort(String string, DataRef<DataType> dataRef, int n) {
        this(new RingBuffer(n), string, dataRef);
    }

    public OutPort(BufferBase<DataType> bufferBase, String string, DataRef<DataType> dataRef) {
        super(string, OutPort.toRepositoryId(dataRef));
        this.m_value = dataRef;
        this.m_timeoutTick = 1000L;
        this.m_readBlock = false;
        this.m_readTimeout = 0L;
        this.m_writeBlock = false;
        this.m_writeTimeout = 0L;
        this.m_OnWrite = null;
        this.m_OnWriteConvert = null;
        this.m_OnRead = null;
        this.m_OnReadConvert = null;
        this.m_OnOverflow = null;
        this.m_OnUnderflow = null;
        this.m_spi_orb = (ORB)ORBUtil.getOrb();
        Class<?> clazz = dataRef.v.getClass();
        String string2 = clazz.getName();
        try {
            Class<?> clazz2 = Class.forName(string2 + "Holder", true, this.getClass().getClassLoader());
            this.m_streamable = (Streamable)clazz2.newInstance();
            this.m_field = this.m_streamable.getClass().getField("value");
        }
        catch (InstantiationException instantiationException) {
            this.rtcout.println(5, "Exception caught." + instantiationException.toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.rtcout.println(5, "Exception caught." + classNotFoundException.toString());
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.rtcout.println(5, "Exception caught." + noSuchFieldException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.rtcout.println(5, "Exception caught." + illegalAccessException.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.rtcout.println(5, "Exception caught." + illegalArgumentException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(DataType DataType) {
        this.rtcout.println(2, "DataType write()");
        if (this.m_OnWrite != null) {
            this.m_OnWrite.run(DataType);
            this.rtcout.println(2, "OnWrite called");
        }
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        Object object = m_connectorsMutex;
        synchronized (object) {
            int n = this.m_connectors.size();
            if (n <= 0) {
                return false;
            }
            this.m_status.setSize(n);
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                ReturnCode returnCode;
                if (this.m_OnWriteConvert != null) {
                    this.rtcout.println(3, "m_connectors.OnWriteConvert called");
                    returnCode = ((OutPortConnector)this.m_connectors.elementAt(i)).write(this.m_OnWriteConvert.run(DataType));
                } else {
                    this.rtcout.println(3, "m_connectors.write called");
                    returnCode = ((OutPortConnector)this.m_connectors.elementAt(i)).write(DataType);
                }
                this.m_status.add(i, returnCode);
                if (returnCode.equals((Object)ReturnCode.PORT_OK)) continue;
                bl = false;
                String string = ((OutPortConnector)this.m_connectors.elementAt(i)).id();
                ConnectorProfile connectorProfile = this.findConnProfile(string);
                if (!returnCode.equals((Object)ReturnCode.CONNECTION_LOST)) continue;
                this.rtcout.println(2, "connection_lost id: " + string);
                if (this.m_onConnectionLost != null) {
                    ConnectorProfileHolder connectorProfileHolder = new ConnectorProfileHolder(connectorProfile);
                    this.m_onConnectionLost.run(connectorProfileHolder);
                }
                vector.add(string);
            }
        }
        object = vector.iterator();
        while (object.hasNext()) {
            this.disconnect((String)object.next());
        }
        return bl;
    }

    @Override
    public boolean write() {
        return this.write(this.m_value.v);
    }

    public boolean insert(DataType DataType) {
        return this.write(DataType);
    }

    public void setReadBlock(boolean bl) {
        this.m_readBlock = bl;
    }

    public void setWriteBlock(boolean bl) {
        this.m_writeBlock = bl;
    }

    public void setReadTimeout(long l) {
        this.m_readTimeout = l;
    }

    public void setWriteTimeout(long l) {
        this.m_writeTimeout = l;
    }

    ReturnCode getStatus(int n) {
        return this.m_status.elementAt(n);
    }

    Vector<ReturnCode> getStatusList() {
        return this.m_status;
    }

    public void setOnWrite(OnWrite<DataType> onWrite) {
        this.m_OnWrite = onWrite;
    }

    public void setOnWriteConvert(OnWriteConvert<DataType> onWriteConvert) {
        this.m_OnWriteConvert = onWriteConvert;
    }

    public void setOnOverflow(OnOverflow<DataType> onOverflow) {
        this.m_OnOverflow = onOverflow;
    }

    public void setOnRead(OnRead<DataType> onRead) {
        this.m_OnRead = onRead;
    }

    public void setOnReadConvert(OnReadConvert<DataType> onReadConvert) {
        this.m_OnReadConvert = onReadConvert;
    }

    public void setOnUnderflow(OnUnderflow<DataType> onUnderflow) {
        this.m_OnUnderflow = onUnderflow;
    }

    public void setOnConnect(OnConnect onConnect) {
        this.m_OnConnect = onConnect;
    }

    public void setOnDisconnect(OnDisconnect onDisconnect) {
        this.m_OnDisconnect = onDisconnect;
    }

    @Override
    public void onConnect(String string, PublisherBase publisherBase) {
        this.rtcout.println(2, "onConnect(id = " + string + ")");
    }

    @Override
    public void onDisconnect(String string) {
        this.rtcout.println(2, "onDisconnect(id = " + string + ")");
    }

    public boolean setStreamable(Streamable streamable) {
        try {
            this.m_streamable = streamable;
            this.m_field = this.m_streamable.getClass().getField("value");
            return true;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.rtcout.println(5, "Exception caught." + noSuchFieldException.toString());
            return false;
        }
    }
}

