/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.rtm.RTC.port.publisher;

import java.util.Set;
import jp.go.aist.rtm.RTC.ObjectCreator;
import jp.go.aist.rtm.RTC.ObjectDestructor;
import jp.go.aist.rtm.RTC.PeriodicTaskBase;
import jp.go.aist.rtm.RTC.PeriodicTaskFactory;
import jp.go.aist.rtm.RTC.PublisherBaseFactory;
import jp.go.aist.rtm.RTC.buffer.BufferBase;
import jp.go.aist.rtm.RTC.log.Logbuf;
import jp.go.aist.rtm.RTC.port.ConnectorBase;
import jp.go.aist.rtm.RTC.port.ConnectorListeners;
import jp.go.aist.rtm.RTC.port.InPortConsumer;
import jp.go.aist.rtm.RTC.port.ReturnCode;
import jp.go.aist.rtm.RTC.port.publisher.PublisherBase;
import jp.go.aist.rtm.RTC.util.Properties;
import jp.go.aist.rtm.RTC.util.StringUtil;
import org.omg.CORBA.portable.OutputStream;

public class PublisherPeriodic
extends PublisherBase
implements Runnable,
ObjectCreator<PublisherBase>,
ObjectDestructor {
    private InPortConsumer m_consumer = null;
    private boolean m_running;
    private long m_millisec;
    private int m_nanosec;
    private static final String id_name = "periodic";
    protected Logbuf rtcout;
    private boolean m_active = false;
    private Policy m_pushPolicy;
    private BufferBase<OutputStream> m_buffer = null;
    private int m_skipn = 0;
    private PeriodicTaskBase m_task = null;
    private ReturnCode m_retcode;
    private int m_leftskip = 0;
    private String m_retmutex = new String();
    private boolean m_readback = false;
    private ConnectorListeners m_listeners = null;
    private ConnectorBase.ConnectorInfo m_profile;

    public PublisherPeriodic() {
        this.rtcout = new Logbuf("PublisherPeriodic");
        this.m_retcode = ReturnCode.PORT_OK;
        this.m_pushPolicy = Policy.NEW;
    }

    public void update() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int svc() {
        String string = this.m_retmutex;
        synchronized (string) {
            switch (this.m_pushPolicy) {
                case ALL: {
                    this.m_retcode = this.pushAll();
                    break;
                }
                case FIFO: {
                    this.m_retcode = this.pushFifo();
                    break;
                }
                case SKIP: {
                    this.m_retcode = this.pushSkip();
                    break;
                }
                case NEW: {
                    this.m_retcode = this.pushNew();
                    break;
                }
                default: {
                    this.m_retcode = this.pushNew();
                }
            }
        }
        return 0;
    }

    protected ReturnCode pushAll() {
        this.rtcout.println(2, "pushAll()");
        while (this.m_buffer.readable() > 0) {
            OutputStream outputStream = this.m_buffer.get();
            this.onBufferRead(outputStream);
            this.onSend(outputStream);
            ReturnCode returnCode = this.m_consumer.put(outputStream);
            if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
                this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
                return this.invokeListener(returnCode, outputStream);
            }
            this.onReceived(outputStream);
            this.m_buffer.advanceRptr();
        }
        return ReturnCode.PORT_OK;
    }

    protected ReturnCode pushFifo() {
        this.rtcout.println(2, "pushFifo()");
        if (this.m_buffer.empty() && !this.m_readback) {
            this.rtcout.println(3, "buffer empty");
            return ReturnCode.BUFFER_EMPTY;
        }
        OutputStream outputStream = this.m_buffer.get();
        this.onBufferRead(outputStream);
        this.onSend(outputStream);
        ReturnCode returnCode = this.m_consumer.put(outputStream);
        if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
            this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
            return this.invokeListener(returnCode, outputStream);
        }
        this.onReceived(outputStream);
        this.m_buffer.advanceRptr();
        return returnCode;
    }

    protected ReturnCode pushSkip() {
        this.rtcout.println(2, "pushSkip()");
        if (this.m_buffer.empty() && !this.m_readback) {
            this.rtcout.println(3, "buffer empty");
            return ReturnCode.BUFFER_EMPTY;
        }
        ReturnCode returnCode = ReturnCode.PORT_OK;
        int n = this.m_buffer.readable();
        int n2 = n + this.m_leftskip;
        int n3 = n2 / (this.m_skipn + 1);
        int n4 = this.m_skipn - this.m_leftskip;
        for (int i = 0; i < n3; ++i) {
            this.m_buffer.advanceRptr(n4);
            OutputStream outputStream = this.m_buffer.get();
            this.onBufferRead(outputStream);
            this.onSend(outputStream);
            returnCode = this.m_consumer.put(outputStream);
            if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
                this.m_buffer.advanceRptr(-n4);
                this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
                return this.invokeListener(returnCode, outputStream);
            }
            this.onReceived(outputStream);
            n4 = this.m_skipn + 1;
        }
        this.m_buffer.advanceRptr(n);
        this.m_leftskip = n2 % (this.m_skipn + 1);
        return returnCode;
    }

    protected ReturnCode pushNew() {
        this.rtcout.println(2, "pushNew()");
        if (this.m_buffer.empty() && !this.m_readback) {
            this.rtcout.println(3, "buffer empty");
            return ReturnCode.BUFFER_EMPTY;
        }
        this.m_readback = true;
        this.m_buffer.advanceRptr(this.m_buffer.readable() - 1);
        OutputStream outputStream = this.m_buffer.get();
        this.onBufferRead(outputStream);
        this.onSend(outputStream);
        ReturnCode returnCode = this.m_consumer.put(outputStream);
        if (!returnCode.equals((Object)ReturnCode.PORT_OK)) {
            this.rtcout.println(3, (Object)((Object)returnCode) + " = consumer.put()");
            return this.invokeListener(returnCode, outputStream);
        }
        this.onReceived(outputStream);
        this.m_buffer.advanceRptr();
        return returnCode;
    }

    @Override
    public void run() {
        this.svc();
    }

    public int open() {
        this.m_running = true;
        Thread thread = new Thread(this);
        thread.start();
        return 0;
    }

    @Override
    public void release() {
        this.m_running = false;
    }

    @Override
    public ReturnCode init(Properties properties) {
        this.rtcout.println(2, "init()");
        String string = new String();
        properties._dump(string, properties, 0);
        this.rtcout.println(0, string);
        this.setPushPolicy(properties);
        if (!this.createTask(properties)) {
            return ReturnCode.INVALID_ARGS;
        }
        return ReturnCode.PORT_OK;
    }

    protected void setPushPolicy(Properties properties) {
        String string = properties.getProperty("publisher.push_policy", "new");
        this.rtcout.println(3, "push_policy: " + string);
        string = StringUtil.normalize(string);
        if (string.equals("all")) {
            this.m_pushPolicy = Policy.ALL;
        } else if (string.equals("fifo")) {
            this.m_pushPolicy = Policy.FIFO;
        } else if (string.equals("skip")) {
            this.m_pushPolicy = Policy.SKIP;
        } else if (string.equals("new")) {
            this.m_pushPolicy = Policy.NEW;
        } else {
            this.rtcout.println(6, "invalid push_policy value: " + string);
            this.m_pushPolicy = Policy.NEW;
        }
        String string2 = properties.getProperty("publisher.skip_count", "0");
        this.rtcout.println(3, "skip_count: " + string2);
        try {
            this.m_skipn = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.rtcout.println(6, "invalid skip_count value: " + string2);
            this.m_skipn = 0;
        }
        if (this.m_skipn < 0) {
            this.rtcout.println(6, "invalid skip_count value: " + this.m_skipn);
            this.m_skipn = 0;
        }
    }

    protected boolean createTask(Properties properties) {
        PeriodicTaskFactory periodicTaskFactory = PeriodicTaskFactory.instance();
        Set set = periodicTaskFactory.getIdentifiers();
        this.rtcout.println(3, "available task types: " + set.toString());
        this.m_task = (PeriodicTaskBase)periodicTaskFactory.createObject(properties.getProperty("thread_type", "default"));
        if (this.m_task == null) {
            this.rtcout.println(6, "Task creation failed: " + properties.getProperty("thread_type", "default"));
            return false;
        }
        this.rtcout.println(0, "Task creation succeeded.");
        this.m_task.setTask(this);
        String string = properties.getProperty("publisher.push_rate");
        if (string.equals("") && (string = properties.getProperty("push_rate")).equals("")) {
            this.rtcout.println(6, "publisher.push_rate/push_rate were not found.");
            return false;
        }
        double d = Double.valueOf(string);
        if (d <= 0.0) {
            this.rtcout.println(6, "invalid period: " + d + "[s]");
            return false;
        }
        this.m_task.setPeriod(1.0 / d);
        Properties properties2 = properties.getNode("measurement");
        this.m_task.executionMeasure(StringUtil.toBool(properties2.getProperty("exec_time"), "enable", "disable", true));
        try {
            int n = Integer.parseInt(properties2.getProperty("exec_count"));
            this.m_task.executionMeasureCount(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_task.periodicMeasure(StringUtil.toBool(properties2.getProperty("period_time"), "enable", "disable", true));
        try {
            int n = Integer.parseInt(properties2.getProperty("period_count"));
            this.m_task.periodicMeasureCount(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_task._suspend();
        this.m_task.activate();
        this.m_task._suspend();
        return true;
    }

    @Override
    public ReturnCode setConsumer(InPortConsumer inPortConsumer) {
        this.rtcout.println(2, "setConsumer()");
        if (inPortConsumer == null) {
            this.rtcout.println(6, "setConsumer(consumer = null): invalid argument.");
            return ReturnCode.INVALID_ARGS;
        }
        this.m_consumer = inPortConsumer;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setBuffer(BufferBase<OutputStream> bufferBase) {
        this.rtcout.println(2, "setBuffer()");
        if (bufferBase == null) {
            this.rtcout.println(6, "setBuffer(buffer = null): invalid argument.");
            return ReturnCode.INVALID_ARGS;
        }
        this.m_buffer = bufferBase;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode setListener(ConnectorBase.ConnectorInfo connectorInfo, ConnectorListeners connectorListeners) {
        this.rtcout.println(2, "setListeners()");
        if (connectorListeners == null) {
            this.rtcout.println(6, "setListeners(listeners == 0): invalid argument");
            return ReturnCode.INVALID_ARGS;
        }
        this.m_profile = connectorInfo;
        this.m_listeners = connectorListeners;
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode write(OutputStream outputStream, int n, int n2) {
        this.rtcout.println(0, "write()");
        if (this.m_consumer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_buffer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_listeners == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_retcode.equals((Object)ReturnCode.CONNECTION_LOST)) {
            this.rtcout.println(3, "write(): connection lost.");
            return this.m_retcode;
        }
        if (this.m_retcode.equals((Object)ReturnCode.SEND_FULL)) {
            this.rtcout.println(3, "write(): InPort buffer is full.");
            this.m_buffer.write(outputStream, n, n2);
            return ReturnCode.BUFFER_FULL;
        }
        this.onBufferWrite(outputStream);
        jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode = this.m_buffer.write(outputStream, n, n2);
        this.rtcout.println(3, returnCode.name() + " = write()");
        this.m_task._resume();
        return this.convertReturn(returnCode, outputStream);
    }

    @Override
    public ReturnCode write(OutputStream outputStream) {
        return this.write(outputStream, -1, 0);
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    @Override
    public ReturnCode activate() {
        if (this.m_task == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        if (this.m_buffer == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        this.m_active = true;
        this.m_task._resume();
        return ReturnCode.PORT_OK;
    }

    @Override
    public ReturnCode deactivate() {
        if (this.m_task == null) {
            return ReturnCode.PRECONDITION_NOT_MET;
        }
        this.m_active = false;
        this.m_task._suspend();
        return ReturnCode.PORT_OK;
    }

    @Override
    public PublisherBase creator_() {
        return new PublisherPeriodic();
    }

    @Override
    public void destructor_(Object object) {
        PublisherPeriodic publisherPeriodic = (PublisherPeriodic)object;
        if (publisherPeriodic.m_task != null) {
            PeriodicTaskFactory periodicTaskFactory = PeriodicTaskFactory.instance();
            periodicTaskFactory.deleteObject(publisherPeriodic.m_task);
        }
        object = null;
    }

    protected ReturnCode convertReturn(jp.go.aist.rtm.RTC.buffer.ReturnCode returnCode, OutputStream outputStream) {
        switch (returnCode) {
            case BUFFER_OK: {
                return ReturnCode.PORT_OK;
            }
            case BUFFER_ERROR: {
                return ReturnCode.BUFFER_ERROR;
            }
            case BUFFER_FULL: {
                this.onBufferFull(outputStream);
                return ReturnCode.BUFFER_FULL;
            }
            case NOT_SUPPORTED: {
                return ReturnCode.PORT_ERROR;
            }
            case TIMEOUT: {
                this.onBufferWriteTimeout(outputStream);
                return ReturnCode.BUFFER_TIMEOUT;
            }
            case PRECONDITION_NOT_MET: {
                return ReturnCode.PRECONDITION_NOT_MET;
            }
        }
        return ReturnCode.PORT_ERROR;
    }

    protected ReturnCode invokeListener(ReturnCode returnCode, OutputStream outputStream) {
        switch (returnCode) {
            case PORT_ERROR: {
                this.onReceiverError(outputStream);
                return ReturnCode.PORT_ERROR;
            }
            case SEND_FULL: {
                this.onReceiverFull(outputStream);
                return ReturnCode.SEND_FULL;
            }
            case SEND_TIMEOUT: {
                this.onReceiverTimeout(outputStream);
                return ReturnCode.SEND_TIMEOUT;
            }
            case CONNECTION_LOST: {
                this.onReceiverError(outputStream);
                return ReturnCode.CONNECTION_LOST;
            }
            case UNKNOWN_ERROR: {
                this.onReceiverError(outputStream);
                return ReturnCode.UNKNOWN_ERROR;
            }
        }
        this.onReceiverError(outputStream);
        return ReturnCode.PORT_ERROR;
    }

    public static void PublisherPeriodicInit() {
        PublisherBaseFactory publisherBaseFactory = PublisherBaseFactory.instance();
        publisherBaseFactory.addFactory(id_name, new PublisherPeriodic(), new PublisherPeriodic());
    }

    @Override
    public String getName() {
        return id_name;
    }

    protected void onBufferWrite(OutputStream outputStream) {
        this.m_listeners.connectorData_[0].notify(this.m_profile, outputStream);
    }

    protected void onBufferFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[1].notify(this.m_profile, outputStream);
    }

    protected void onBufferWriteTimeout(OutputStream outputStream) {
        this.m_listeners.connectorData_[2].notify(this.m_profile, outputStream);
    }

    protected void onBufferRead(OutputStream outputStream) {
        this.m_listeners.connectorData_[4].notify(this.m_profile, outputStream);
    }

    protected void onSend(OutputStream outputStream) {
        this.m_listeners.connectorData_[5].notify(this.m_profile, outputStream);
    }

    protected void onReceived(OutputStream outputStream) {
        this.m_listeners.connectorData_[6].notify(this.m_profile, outputStream);
    }

    protected void onReceiverFull(OutputStream outputStream) {
        this.m_listeners.connectorData_[7].notify(this.m_profile, outputStream);
    }

    protected void onReceiverTimeout(OutputStream outputStream) {
        this.m_listeners.connectorData_[8].notify(this.m_profile, outputStream);
    }

    protected void onReceiverError(OutputStream outputStream) {
        this.m_listeners.connectorData_[9].notify(this.m_profile, outputStream);
    }

    protected void onBufferEmpty() {
        this.m_listeners.connector_[0].notify(this.m_profile);
    }

    protected void onSenderEmpty() {
        this.m_listeners.connector_[2].notify(this.m_profile);
    }

    protected void onSenderError() {
        this.m_listeners.connector_[4].notify(this.m_profile);
    }

    protected static enum Policy {
        ALL,
        FIFO,
        SKIP,
        NEW;

    }
}

