/*
 * Decompiled with CFR 0.152.
 */
package jp.go.aist.hrp.simulator;

import java.util.Hashtable;
import jp.go.aist.hrp.simulator.BodyInfo;
import jp.go.aist.hrp.simulator.BodyInfoHelper;
import jp.go.aist.hrp.simulator.CharacterPosition;
import jp.go.aist.hrp.simulator.CharacterPositionSequenceHelper;
import jp.go.aist.hrp.simulator.CollisionDetector;
import jp.go.aist.hrp.simulator.CollisionDetectorHelper;
import jp.go.aist.hrp.simulator.CollisionDetectorOperations;
import jp.go.aist.hrp.simulator.CollisionSequenceHelper;
import jp.go.aist.hrp.simulator.CollisionSequenceHolder;
import jp.go.aist.hrp.simulator.DblArray3Helper;
import jp.go.aist.hrp.simulator.DblArray9Helper;
import jp.go.aist.hrp.simulator.DblSequenceHelper;
import jp.go.aist.hrp.simulator.DistanceSequenceHelper;
import jp.go.aist.hrp.simulator.DistanceSequenceHolder;
import jp.go.aist.hrp.simulator.LinkPair;
import jp.go.aist.hrp.simulator.LinkPairHelper;
import jp.go.aist.hrp.simulator.LinkPairSequenceHelper;
import jp.go.aist.hrp.simulator.LinkPairSequenceHolder;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class CollisionDetectorPOA
extends Servant
implements CollisionDetectorOperations,
InvokeHandler {
    private static Hashtable _methods = new Hashtable();
    private static String[] __ids;

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) {
        OutputStream outputStream = null;
        Integer n = (Integer)_methods.get(string);
        if (n == null) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_MAYBE);
        }
        switch (n) {
            case 0: {
                this.destroy();
                outputStream = responseHandler.createReply();
                break;
            }
            case 1: {
                LinkPair linkPair = LinkPairHelper.read(inputStream);
                this.addCollisionPair(linkPair);
                outputStream = responseHandler.createReply();
                break;
            }
            case 2: {
                boolean bl = inputStream.read_boolean();
                CharacterPosition[] characterPositionArray = CharacterPositionSequenceHelper.read(inputStream);
                LinkPairSequenceHolder linkPairSequenceHolder = new LinkPairSequenceHolder();
                boolean bl2 = false;
                bl2 = this.queryIntersectionForDefinedPairs(bl, characterPositionArray, linkPairSequenceHolder);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(bl2);
                LinkPairSequenceHelper.write(outputStream, linkPairSequenceHolder.value);
                break;
            }
            case 3: {
                boolean bl = inputStream.read_boolean();
                LinkPair[] linkPairArray = LinkPairSequenceHelper.read(inputStream);
                CharacterPosition[] characterPositionArray = CharacterPositionSequenceHelper.read(inputStream);
                LinkPairSequenceHolder linkPairSequenceHolder = new LinkPairSequenceHolder();
                boolean bl3 = false;
                bl3 = this.queryIntersectionForGivenPairs(bl, linkPairArray, characterPositionArray, linkPairSequenceHolder);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(bl3);
                LinkPairSequenceHelper.write(outputStream, linkPairSequenceHolder.value);
                break;
            }
            case 4: {
                CharacterPosition[] characterPositionArray = CharacterPositionSequenceHelper.read(inputStream);
                CollisionSequenceHolder collisionSequenceHolder = new CollisionSequenceHolder();
                boolean bl = false;
                bl = this.queryContactDeterminationForDefinedPairs(characterPositionArray, collisionSequenceHolder);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(bl);
                CollisionSequenceHelper.write(outputStream, collisionSequenceHolder.value);
                break;
            }
            case 5: {
                LinkPair[] linkPairArray = LinkPairSequenceHelper.read(inputStream);
                CharacterPosition[] characterPositionArray = CharacterPositionSequenceHelper.read(inputStream);
                CollisionSequenceHolder collisionSequenceHolder = new CollisionSequenceHolder();
                boolean bl = false;
                bl = this.queryContactDeterminationForGivenPairs(linkPairArray, characterPositionArray, collisionSequenceHolder);
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(bl);
                CollisionSequenceHelper.write(outputStream, collisionSequenceHolder.value);
                break;
            }
            case 6: {
                CharacterPosition[] characterPositionArray = CharacterPositionSequenceHelper.read(inputStream);
                DistanceSequenceHolder distanceSequenceHolder = new DistanceSequenceHolder();
                this.queryDistanceForDefinedPairs(characterPositionArray, distanceSequenceHolder);
                outputStream = responseHandler.createReply();
                DistanceSequenceHelper.write(outputStream, distanceSequenceHolder.value);
                break;
            }
            case 7: {
                LinkPair[] linkPairArray = LinkPairSequenceHelper.read(inputStream);
                CharacterPosition[] characterPositionArray = CharacterPositionSequenceHelper.read(inputStream);
                DistanceSequenceHolder distanceSequenceHolder = new DistanceSequenceHolder();
                this.queryDistanceForGivenPairs(linkPairArray, characterPositionArray, distanceSequenceHolder);
                outputStream = responseHandler.createReply();
                DistanceSequenceHelper.write(outputStream, distanceSequenceHolder.value);
                break;
            }
            case 8: {
                double[] dArray = DblArray3Helper.read(inputStream);
                double[] dArray2 = DblArray3Helper.read(inputStream);
                double d = 0.0;
                d = this.queryDistanceWithRay(dArray, dArray2);
                outputStream = responseHandler.createReply();
                outputStream.write_double(d);
                break;
            }
            case 9: {
                double[] dArray = DblArray3Helper.read(inputStream);
                double[] dArray3 = DblArray9Helper.read(inputStream);
                double d = inputStream.read_double();
                double d2 = inputStream.read_double();
                double[] dArray4 = null;
                dArray4 = this.scanDistanceWithRay(dArray, dArray3, d, d2);
                outputStream = responseHandler.createReply();
                DblSequenceHelper.write(outputStream, dArray4);
                break;
            }
            case 10: {
                String string2 = inputStream.read_string();
                BodyInfo bodyInfo = BodyInfoHelper.read(inputStream);
                this.registerCharacter(string2, bodyInfo);
                outputStream = responseHandler.createReply();
                break;
            }
            default: {
                throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return (String[])__ids.clone();
    }

    public CollisionDetector _this() {
        return CollisionDetectorHelper.narrow(super._this_object());
    }

    public CollisionDetector _this(ORB oRB) {
        return CollisionDetectorHelper.narrow(super._this_object(oRB));
    }

    static {
        _methods.put("destroy", new Integer(0));
        _methods.put("addCollisionPair", new Integer(1));
        _methods.put("queryIntersectionForDefinedPairs", new Integer(2));
        _methods.put("queryIntersectionForGivenPairs", new Integer(3));
        _methods.put("queryContactDeterminationForDefinedPairs", new Integer(4));
        _methods.put("queryContactDeterminationForGivenPairs", new Integer(5));
        _methods.put("queryDistanceForDefinedPairs", new Integer(6));
        _methods.put("queryDistanceForGivenPairs", new Integer(7));
        _methods.put("queryDistanceWithRay", new Integer(8));
        _methods.put("scanDistanceWithRay", new Integer(9));
        _methods.put("registerCharacter", new Integer(10));
        __ids = new String[]{"IDL:OpenHRP/CollisionDetector:1.0", "IDL:OpenHRP/World:1.0"};
    }
}

