#!/usr/bin/env python
# -*- coding: euc-jp -*-

##
# @file Listener.py
# @brief Listener class
# @date $Date: 2007/08/23$
# @author Noriaki Ando <n-ando@aist.go.jp> and Shinji Kurihara
#
# Copyright (C) 2007-2008
#     Task-intelligence Research Group,
#     Intelligent Systems Research Institute,
#     National Institute of
#         Advanced Industrial Science and Technology (AIST), Japan
#     All rights reserved.



##
# @if jp
# @class ListenerBase
# @brief ListenerBase 饹
#
# ޡϿꥹʡݥ󥿡ե饹
#
# @since 0.4.0
#
# @else
# @class ListenerBase
# @brief ListenerBase class
# @endif
class ListenerBase:
  """
  """

  ##
  # @if jp
  # @brief Хå(֥饹)
  #
  # ХåѴؿ<BR>
  # ֥饹Ǥμ
  #
  # @param self
  #
  # @else
  #
  # @endif
  def invoke(self):
    pass



##
# @if jp
# @class ListenerObject
# @brief ListenerObject 饹
#
# ޡϿꥹʡѴ쥯饹
#
# @since 0.4.0
#
# @else
# @class ListenerObject
# @brief ListenerObject class
# @endif
class ListenerObject(ListenerBase):
  """
  """

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param obj ꥹʡ֥
  # @param cbf ХåѴؿ
  #
  # @else
  #
  # @endif
  def __init__(self,obj,cbf):
    self.obj = obj
    self.cbf = cbf


  ##
  # @if jp
  # @brief Хåѽ
  #
  # ХåѴؿ
  #
  # @param self
  #
  # @else
  #
  # @endif
  def invoke(self):
    self.cbf(self.obj)



##
# @if jp
# @class ListenerFunc
# @brief ListenerFunc 饹
#
# Хåѥ֥ȡ
#
# @since 0.4.0
#
# @else
# @class ListenerFunc
# @brief ListenerFunc class
# @endif
class ListenerFunc(ListenerBase):
  """
  """

  ##
  # @if jp
  # @brief 󥹥ȥ饯
  #
  # 󥹥ȥ饯
  #
  # @param self
  # @param cbf ХåѴؿ
  #
  # @else
  #
  # @endif
  def __init__(self,cbf):
    self.cbf = cbf


  ##
  # @if jp
  # @brief Хå
  #
  # ХåѴؿ
  #
  # @param self
  #
  # @else
  #
  # @endif
  def invoke(self):
    self.cbf()
