// -*- C++ -*-
/*!
 * @file PeriodicTaskBase.h
 * @brief TaskFuncBase TaskFunc PeriodicTaskBase class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2009
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

#ifndef COIL_PERIODICTASKBASE_H
#define COIL_PERIODICTASKBASE_H

#include <coil/TimeValue.h>
#include <coil/TimeMeasure.h>
#include <coil/Task.h>

namespace coil
{
  /*!
   * @if jp
   *
   * @class TaskFuncBase
   * @brief TaskFuncBase 饹
   *
   * @else
   *
   * @class TaskFuncBase
   * @brief TaskFuncBase class
   *
   * @endif
   */
  class TaskFuncBase
  {
  public:
    /*!
     * @if jp
     *
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     *
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~TaskFuncBase() {}

    /*!
     * @if jp
     *
     * @brief ֥Ȥδؿ¹ѽ貾۴ؿ
     *
     * ֥Ȥδؿ¹ѽ貾۴ؿ
     *
     * @else
     *
     * @brief Functor
     *
     * Pure virtual function for Functor.
     *
     * @endif
     */
    virtual int operator()() = 0;
  };
  
  /*!
   * @if jp
   *
   * @class TaskFunc
   * @brief TaskFunc ƥץ졼ȥ饹
   *
   * @else
   *
   * @class TaskFunc
   * @brief TaskFunc template class
   *
   * @endif
   */
  template <typename T, typename F = int (*)()>
  class TaskFunc
    : public TaskFuncBase
  {
  public:
    /*!
     * @if jp
     *
     * @brief 󥹥ȥ饯
     *
     * 󥹥ȥ饯
     *
     * @param obj ֥
     * @param func ؿ
     *
     * @else
     *
     * @brief Constructor
     *
     * Constructor
     *
     * @param obj Object.
     * @param func Function.
     *
     * @endif
     */
    TaskFunc(T* obj, F func)
      : m_obj(obj), m_func(func)
    {
    }

    /*!
     * @if jp
     *
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     *
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~TaskFunc() {}

    /*!
     * @if jp
     *
     * @brief ֥Ȥδؿ¹
     *
     * ֥Ȥδؿ¹Ԥ롣
     *
     * @else
     *
     * @brief Functor
     *
     * Execute a function of the object.
     *
     * @endif
     */
    virtual int operator()()
    {
      return (m_obj->*m_func)();
    }

    /*!
     * @if jp
     * @brief ֥
     * @else
     * @brief object
     * @endif
     */
    T* m_obj;

    /*!
     * @if jp
     * @brief ؿ
     * @else
     * @brief function
     * @endif
     */
    F m_func;
  };

  /*!
   * @if jp
   *
   * @class PeriodicTaskBase
   * @brief PeriodicTaskBase 饹
   *
   * @else
   *
   * @class PeriodicTaskBase
   * @brief PeriodicTaskBase class
   *
   * @endif
   */
  class PeriodicTaskBase
    : public coil::Task
  {
  public:
    /*!
     * @if jp
     *
     * @brief ǥȥ饯
     *
     * ǥȥ饯
     *
     * @else
     *
     * @brief Destructor
     *
     * Destructor
     *
     * @endif
     */
    virtual ~PeriodicTaskBase(){};

    /*!
     * @if jp
     *
     * @brief ¹Ԥ򳫻Ϥ貾۴ؿ
     *
     * ¹Ԥ򳫻Ϥ貾۴ؿ
     *
     * @else
     *
     * @brief Starting the task
     *
     * Pure virtual function for starting the task.
     *
     * @endif
     */
    virtual void activate() = 0;

    /*!
     * @if jp
     *
     * @brief ¹Ԥλ貾۴ؿ
     *
     * ¹Ԥλ貾۴ؿ
     *
     * @else
     *
     * @brief Finalizing the task
     *
     * Pure virtual function for finalizing the task.
     *
     * @endif
     */
    virtual void finalize() = 0;

    /*!
     * @if jp
     *
     * @brief ¹ԤǤ貾۴ؿ
     *
     * ¹ԤǤ貾۴ؿ
     *
     * @else
     *
     * @brief Suspending the task
     *
     * Pure virtual function for suspending the task.
     *
     * @endif
     */
    virtual int suspend(void) = 0;

    /*!
     * @if jp
     *
     * @brief ǤƤ륿Ƴ貾۴ؿ
     *
     * ǤƤ륿Ƴ貾۴ؿ
     *
     * @else
     *
     * @brief Resuming the suspended task
     *
     * Pure virtual function for resuming the suspended task.
     *
     * @endif
     */
    virtual int resume(void) = 0;

    /*!
     * @if jp
     *
     * @brief ǤƤ륿1¹Ԥ貾۴ؿ
     *
     * ǤƤ륿1¹Ԥ貾۴ؿ
     *
     * @else
     *
     * @brief Executing the suspended task one tick
     *
     * Pure virtual function for executing the suspended task one tick.
     *
     * @endif
     */
    virtual void signal() = 0;

    /*!
     * @if jp
     *
     * @brief ¹Դؿ򥻥åȤ貾۴ؿ
     *
     * ¹Դؿ򥻥åȤ貾۴ؿ
     *
     * @param func ؿ
     * @param delete_in_dtor ե饰
     *
     * @else
     *
     * @brief Setting task execution function
     *
     * Pure virtual function for setting task execution function.
     *
     * @param func Function.
     * @param delete_in_dtor Delete flag.
     *
     * @endif
     */
    virtual bool setTask(TaskFuncBase* func, bool delete_in_dtor = true) = 0;

    /*!
     * @if jp
     *
     * @brief ¹Դؿ򥻥åȤ
     *
     * ¹Դؿ򥻥åȤ
     *
     * @param obj ֥
     * @param fun ؿ
     *
     * @return true: , false: 
     *
     * @else
     *
     * @brief Setting task execution function
     *
     * Pure virtual function for setting task execution function.
     *
     * @param obj Object.
     * @param fun Function.
     *
     * @return true: successful, false: failed
     *
     * @endif
     */
    template <class O, class F>
    bool setTask(O* obj, F fun)
    {
      return this->setTask(new TaskFunc<O, F>(obj, fun));
    }

    /*!
     * @if jp
     *
     * @brief ¹Լ򥻥åȤ貾۴ؿ
     *
     * ¹Լ򥻥åȤ貾۴ؿ
     *
     * @param period ¹Լ
     *
     * @else
     *
     * @brief Setting task execution period
     *
     * Pure virtual function for setting task execution period.
     *
     * @param period Execution period.
     *
     * @endif
     */
    virtual void setPeriod(double period) = 0;

    /*!
     * @if jp
     *
     * @brief ¹Լ򥻥åȤ貾۴ؿ
     *
     * ¹Լ򥻥åȤ貾۴ؿ
     *
     * @param period ¹Լ
     *
     * @else
     *
     * @brief Setting task execution period
     *
     * Pure virtual function for setting task execution period.
     *
     * @param period Execution period.
     *
     * @endif
     */
    virtual void setPeriod(coil::TimeValue& period) = 0;

    /*!
     * @if jp
     *
     * @brief ؿ¹Իַ¬ͭˤ貾۴ؿ
     *
     * ؿ¹Իַ¬ͭˤ貾۴ؿ
     *
     * @param value ե饰(true: ͭ, false: ̵)
     *
     * @else
     *
     * @brief Validate a Task execute time measurement
     *
     * Pure virtual function for validate a Task execute time measurement.
     *
     * @param value flag(true: Valid, false: Invalid).
     *
     * @endif
     */
    virtual void executionMeasure(bool value) = 0;

    /*!
     * @if jp
     *
     * @brief ؿ¹Իַ¬ѽ貾۴ؿ
     *
     * ؿ¹Իַ¬ѽ貾۴ؿ
     *
     * @param n ¬
     *
     * @else
     *
     * @brief Task execute time measurement period
     *
     * Pure virtual function for task execute time measurement period.
     *
     * @param n Measurement period.
     *
     * @endif
     */
    virtual void executionMeasureCount(int n) = 0;

    /*!
     * @if jp
     *
     * @brief ַ¬ͭˤ貾۴ؿ
     *
     * ַ¬ͭˤ貾۴ؿ
     *
     * @param value ե饰(true: ͭ, false: ̵)
     *
     * @else
     *
     * @brief Validate a Task period time measurement
     *
     * Pure virtual function for validate a Task period time measurement.
     *
     * @param value flag(true: Valid, false: Invalid).
     *
     * @endif
     */
    virtual void periodicMeasure(bool value) = 0;

    /*!
     * @if jp
     *
     * @brief ַ¬ѽ貾۴ؿ
     *
     * ַ¬ѽ貾۴ؿ
     *
     * @param n ¬
     *
     * @else
     *
     * @brief Task period time measurement count
     *
     * Pure virtual function for task period time measurement count.
     *
     * @param n Measurement period.
     *
     * @endif
     */
    virtual void periodicMeasureCount(int n) = 0;

    /*!
     * @if jp
     *
     * @brief ؿ¹Իַ¬̤貾۴ؿ
     *
     * ؿ¹Իַ¬̤貾۴ؿ
     *
     * @else
     *
     * @brief Get a result in task execute time measurement
     *
     * Pure virtual function for get a result in task execute time measurement.
     *
     * @endif
     */
    virtual coil::TimeMeasure::Statistics getExecStat() = 0;

    /*!
     * @if jp
     *
     * @brief ַ¬̤貾۴ؿ
     *
     * ַ¬̤貾۴ؿ
     *
     * @else
     *
     * @brief Get a result in task period time measurement
     *
     * Pure virtual function for get a result in task period time measurement.
     *
     * @endif
     */
    virtual coil::TimeMeasure::Statistics getPeriodStat() = 0;

  };
}; // namespace coil

#endif // COIL_PERIODICTASKBASE_H
