// -*- C++ -*-

#include "OpenHRPExecutionContext.h"
#include <rtm/ECFactory.h>

namespace RTC
{
  /*!
   * @if jp
   * @brief 󥹥ȥ饯
   * @else
   * @brief Constructor
   * @endif
   */
  OpenHRPExecutionContext::OpenHRPExecutionContext()
    : PeriodicExecutionContext()
  {
  }

  /*!
   * @if jp
   * @brief ǥȥ饯
   * @else
   * @brief Destructor 
   * @endif
   */
  OpenHRPExecutionContext::~OpenHRPExecutionContext()
  {
  }

  /*!
   * @if jp
   * @brief ExecutionContextνʤ
   * @else
   * @brief Proceed with tick of ExecutionContext
   * @endif
   */
  void OpenHRPExecutionContext::tick()
    throw (CORBA::SystemException)
  {
    std::for_each(m_comps.begin(), m_comps.end(), invoke_worker());
    return;
  }

  /*!
   * @if jp
   * @brief ExecutionContext Υåɼ¹ԥե饰
   * @else
   * @brief The thread running flag of ExecutionContext
   * @endif
   */
  int OpenHRPExecutionContext::svc(void)
  {
    return 0;
  }
};


extern "C"
{
  /*!
   * @if jp
   * @brief ECFactoryؤϿΤνؿ
   * @else
   * @brief Initialization function to register to ECFactory
   * @endif
   */
  void OpenHRPExecutionContextInit(RTC::Manager* manager)
  {
    manager->registerECFactory("SynchExtTriggerEC",
			       RTC::ECCreate<RTC::OpenHRPExecutionContext>,
			       RTC::ECDelete<RTC::OpenHRPExecutionContext>);
    
  }
};
