/*******************************************************************************
 *  ORAutoLearningModule.h
 *
 *  (C) 2006 AG Aktives Sehen <agas@uni-koblenz.de>
 *           Universitaet Koblenz-Landau
 *
 *******************************************************************************/

#ifndef ORFaceLearningModule_H
#define ORFaceLearningModule_H

#include "ORMatchingModule.h"
#include "ORLoaderModule.h" // TODO temp remove

#include <robbie_architecture/Architecture/StateMachine/StateMachine.h>
#include <robbie_architecture/Workers/Math/Box2D.h>

#include <std_msgs/Empty.h>
#include <std_msgs/String.h>
#include <std_msgs/Bool.h>
#include <face_detection/FaceDetectionResult.h>
#include <face_detection/Face.h>

#include <opencv2/opencv.hpp>

class ImageMaskCV;
class ObjectProperties;
class ImagePropertiesCV;


/**
 * @class  ORFaceLearningModule
 * @brief  This module uses the ObjectRecogitionModule for autmatically learning faces applied with an oval mask.
 *         Only the biggest face in the image will be learned.
 * @author Susanne Thierfelder (R12), David Gossow, Viktor Seib (R22)
 */

class ORFaceLearningModule
{
  public:

    enum ModuleStateT
    {
      IDLE,
      GRABBING_IMAGES
    };

    /** @brief The constructor. */
    ORFaceLearningModule(ros::NodeHandle *nh, ORMatchingModule* objRecMatchingModule, ORLoaderModule *objRecLoaderModule);

    /** @brief The destructor. */
    virtual ~ORFaceLearningModule();

  protected:

    /** @brief Is called when all modules are loaded and thread has started. */
    virtual void init();

    /** @brief Is called in constant intervals. */
    void idleProcess();

    ros::Publisher m_ptu_pub;

  private:

    void learnFaceCallback(std_msgs::String::ConstPtr msg);
    void faceDetectionCallback(face_detection::FaceDetectionResult::ConstPtr msg);

    ImagePropertiesCV* makeImageProperties( cv::Mat *image_gray, cv::Mat *image_color );

    ImageMaskCV* makeOvalMask ( cv::Mat *image_gray );

    ImageMaskCV* makeFaceMask( cv::Mat *image_gray );

    void getImage();

    void addImage( cv::Mat *image_gray, cv::Mat *image_color );

    void saveObject();

    StateMachine<ModuleStateT> m_ModuleMachine;

    ObjectProperties* m_ObjectProperties;

    //name of image
    std::string m_ImgName;
    //number of images that are taken before object is saved
    int m_ImageCount;

    bool m_FilterFaces;
    std::vector< Box2D< int > > m_Faces;
    float m_FaceAdditionalBorder;

    int m_DetectionAttempts;

    ORMatchingModule* m_ORMatchingModule;
    ORLoaderModule* m_ORLoaderModule;  // TODO temp remove

    // ros subscriber
    ros::Subscriber m_LearnFaceSub;
    ros::Subscriber m_DetectedFacesSub;

    // ros publisher
    ros::Publisher m_DetectFacesPub;
    ros::Publisher m_FaceLearningFinishedPub;
};

#endif

