/*
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateDeviceControllerCategories.py script *
 *                                                        *
 **********************************************************/
#import <Foundation/Foundation.h>
#import <libARCommands/ARCommands.h>
#import "MiniDroneDeviceController.h"
#import "MiniDroneARNetworkConfig.h"

/*
 * MiniDrone send flat trim was correctly processed
 */
extern NSString *const MiniDroneDeviceControllerPilotingStateFlatTrimChangedNotification;
/*
 * Drone flying state changed
 */
extern NSString *const MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotification;
extern NSString *const MiniDroneDeviceControllerPilotingStateFlyingStateChangedNotificationStateKey; /* Drone flying state */
/*
 * Drone alert state changed
 */
extern NSString *const MiniDroneDeviceControllerPilotingStateAlertStateChangedNotification;
extern NSString *const MiniDroneDeviceControllerPilotingStateAlertStateChangedNotificationStateKey; /* Drone alert state */
/*
 * Set MiniDrone automatic take off mode
 */
extern NSString *const MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotification;
extern NSString *const MiniDroneDeviceControllerPilotingStateAutoTakeOffModeChangedNotificationStateKey; /* State of automatic take off mode */
/*
 * State of picture recording
 */
extern NSString *const MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotification;
extern NSString *const MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationStateKey; /* 1 if picture has been taken, 0 otherwise */
extern NSString *const MiniDroneDeviceControllerMediaRecordStatePictureStateChangedNotificationMass_storage_idKey; /* Mass storage id to record */
/*
 * Max Altitude sent by product
 */
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotification;
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationCurrentKey; /* Current altitude max */
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMinKey; /* Range min of altitude */
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxAltitudeChangedNotificationMaxKey; /* Range max of altitude */
/*
 * Max tilt sent by product
 */
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotification;
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationCurrentKey; /* Current max tilt */
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMinKey; /* Range min of tilt */
extern NSString *const MiniDroneDeviceControllerPilotingSettingsStateMaxTiltChangedNotificationMaxKey; /* Range max of tilt */
/*
 * Max vertical speed sent by product
 */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotification;
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationCurrentKey; /* Current max vertical speed in m/s */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMinKey; /* Range min of vertical speed */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxVerticalSpeedChangedNotificationMaxKey; /* Range max of vertical speed */
/*
 * Max rotation speed sent by product
 */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotification;
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationCurrentKey; /* Current max rotation speed in degree/s */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMinKey; /* Range min of rotation speed */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateMaxRotationSpeedChangedNotificationMaxKey; /* Range max of rotation speed */
/*
 * Presence of wheels sent by product
 */
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotification;
extern NSString *const MiniDroneDeviceControllerSpeedSettingsStateWheelsChangedNotificationPresentKey; /* 1 if present, 0 if not present */
/*
 * Product Motors versions
 */
extern NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotification;
extern NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationMotorKey; /* Product Motor number [1 - 4] */
extern NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationTypeKey; /* Product Motor type */
extern NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationSoftwareKey; /* Product Motors software version */
extern NSString *const MiniDroneDeviceControllerSettingsStateProductMotorsVersionChangedNotificationHardwareKey; /* Product Motors hardware version */
/*
 * Product Inertial versions
 */
extern NSString *const MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotification;
extern NSString *const MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationSoftwareKey; /* Product Inertial software version */
extern NSString *const MiniDroneDeviceControllerSettingsStateProductInertialVersionChangedNotificationHardwareKey; /* Product Inertial hardware version */
/*
 * MiniDrone cut out mode
 */
extern NSString *const MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotification;
extern NSString *const MiniDroneDeviceControllerSettingsStateCutOutModeChangedNotificationEnableKey; /* State of cut out mode (1 if is activate, 0 otherwise) */
/*
 * Flood control regulation
 */
extern NSString *const MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotification;
extern NSString *const MiniDroneDeviceControllerFloodControlStateFloodControlChangedNotificationDelayKey; /* Delay (in ms) between two PCMD */

@class MiniDroneDeviceController;

@interface MiniDroneDeviceController (libARCommands)
- (void)registerMiniDroneARCommandsCallbacks;
- (void)unregisterMiniDroneARCommandsCallbacks;
/* 
 * Do a flat trim
 */
- (BOOL)MiniDroneDeviceController_SendPilotingFlatTrim:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Ask the drone to take off
 */
- (BOOL)MiniDroneDeviceController_SendPilotingTakeOff:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Ask the drone to move around.
 */
- (BOOL)MiniDroneDeviceController_SendPilotingPCMD:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withFlag:(uint8_t)flag withRoll:(int8_t)roll withPitch:(int8_t)pitch withYaw:(int8_t)yaw withGaz:(int8_t)gaz withPsi:(float)psi;
/* 
 * Ask the MiniDrone to land
 */
- (BOOL)MiniDroneDeviceController_SendPilotingLanding:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Put drone in emergency state
 */
- (BOOL)MiniDroneDeviceController_SendPilotingEmergency:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock;
/* 
 * Set MiniDrone automatic take off mode
 */
- (BOOL)MiniDroneDeviceController_SendPilotingAutoTakeOffMode:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withState:(uint8_t)state;
/* 
 * Make a flip
 */
- (BOOL)MiniDroneDeviceController_SendAnimationsFlip:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withDirection:(eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION)direction;
/* 
 * Change the product cap
 */
- (BOOL)MiniDroneDeviceController_SendAnimationsCap:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withOffset:(int16_t)offset;
/* 
 * Take picture
 */
- (BOOL)MiniDroneDeviceController_SendMediaRecordPicture:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withMass_storage_id:(uint8_t)mass_storage_id;
/* 
 * Set Max Altitude
 */
- (BOOL)MiniDroneDeviceController_SendPilotingSettingsMaxAltitude:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current;
/* 
 * Set Max Tilt
 */
- (BOOL)MiniDroneDeviceController_SendPilotingSettingsMaxTilt:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current;
/* 
 * Set Max Vertical speed
 */
- (BOOL)MiniDroneDeviceController_SendSpeedSettingsMaxVerticalSpeed:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current;
/* 
 * Set Max Rotation speed
 */
- (BOOL)MiniDroneDeviceController_SendSpeedSettingsMaxRotationSpeed:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withCurrent:(float)current;
/* 
 * Presence of wheels
 */
- (BOOL)MiniDroneDeviceController_SendSpeedSettingsWheels:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withPresent:(uint8_t)present;
/* 
 * Set MiniDrone cut out mode
 */
- (BOOL)MiniDroneDeviceController_SendSettingsCutOutMode:(int)bufferId withSendPolicy:(eARNETWORK_SEND_POLICY)policy withCompletionBlock:(DeviceControllerCompletionBlock)completionBlock withEnable:(uint8_t)enable;
@end

// END GENERATED CODE
