/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/********************************************
 *            AUTOGENERATED FILE            *
 *             DO NOT MODIFY IT             *
 *                                          *
 * To add new commands :                    *
 *  - Modify ../../Xml/commands.xml file    *
 *  - Re-run generateCommandsList.py script *
 *                                          *
 ********************************************/
#include <libARCommands/ARCOMMANDS_Generator.h>
#include <libARCommands/ARCOMMANDS_Decoder.h>
#include <jni.h>
#include <stdlib.h>

#define TOSTRING_STRING_SIZE (1024)

static jfieldID g_dataSize_id = 0;
static JavaVM *g_vm = NULL;

JNIEXPORT jstring JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeToString (JNIEnv *env, jobject thizz, jlong jpdata, jint jdataSize)
{
    jstring ret = NULL;
    eARCOMMANDS_DECODER_ERROR err = ARCOMMANDS_DECODER_OK;
    char *cstr = calloc (TOSTRING_STRING_SIZE, 1);
    if (cstr == NULL)
    {
        return ret;
    }
    err = ARCOMMANDS_Decoder_DescribeBuffer ((uint8_t *)(intptr_t)jpdata, jdataSize, cstr, TOSTRING_STRING_SIZE);
    if (err == ARCOMMANDS_DECODER_OK)
    {
        ret = (*env)->NewStringUTF(env, cstr);
    }
    free (cstr);
    return ret;
}
JNIEXPORT jstring JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeStaticToString (JNIEnv *env, jclass clazz, jlong jpdata, jint jdataSize)
{
    jstring ret = NULL;
    eARCOMMANDS_DECODER_ERROR err = ARCOMMANDS_DECODER_OK;
    char *cstr = calloc (TOSTRING_STRING_SIZE, 1);
    if (cstr == NULL)
    {
        return ret;
    }
    err = ARCOMMANDS_Decoder_DescribeBuffer ((uint8_t *)(intptr_t)jpdata, jdataSize, cstr, TOSTRING_STRING_SIZE);
    if (err == ARCOMMANDS_DECODER_OK)
    {
        ret = (*env)->NewStringUTF(env, cstr);
    }
    free (cstr);
    return ret;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeDecode (JNIEnv *env, jobject thizz, jlong jpdata, jint jdataSize)
{
    uint8_t *pdata = (uint8_t *) (intptr_t)jpdata;
    eARCOMMANDS_DECODER_ERROR err = ARCOMMANDS_Decoder_DecodeBuffer (pdata, jdataSize);
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetGenericDefault (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateGenericDefault ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingFlatTrim (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingFlatTrim ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingTakeOff (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingTakeOff ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingPCMD (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte flag, jbyte roll, jbyte pitch, jbyte yaw, jbyte gaz, jint timestampAndSeqNum)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingPCMD ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)flag, (int8_t)roll, (int8_t)pitch, (int8_t)yaw, (int8_t)gaz, (uint32_t)timestampAndSeqNum);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingLanding (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingLanding ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingEmergency (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingEmergency ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingNavigateHome (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingNavigateHome ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingAutoTakeOffMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingAutoTakeOffMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingMoveBy (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat dX, jfloat dY, jfloat dZ, jfloat dPsi)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingMoveBy ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)dX, (float)dY, (float)dZ, (float)dPsi);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingUserTakeOff (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingUserTakeOff ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingCircle (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject direction)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_direction_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_ENUM");
    jmethodID j_direction_mid = (*env)->GetMethodID (env, j_direction_class, "getValue", "()I");
    jint j_direction_enum = (*env)->CallIntMethod (env, direction, j_direction_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingCircle ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_direction_enum);
    (*env)->DeleteLocalRef (env, j_direction_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3AnimationsFlip (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject direction)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_direction_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_ENUM");
    jmethodID j_direction_mid = (*env)->GetMethodID (env, j_direction_class, "getValue", "()I");
    jint j_direction_enum = (*env)->CallIntMethod (env, direction, j_direction_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3AnimationsFlip ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_direction_enum);
    (*env)->DeleteLocalRef (env, j_direction_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3CameraOrientation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte tilt, jbyte pan)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3CameraOrientation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int8_t)tilt, (int8_t)pan);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordPicture (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPicture ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordVideo (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject record, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_ENUM");
    jmethodID j_record_mid = (*env)->GetMethodID (env, j_record_class, "getValue", "()I");
    jint j_record_enum = (*env)->CallIntMethod (env, record, j_record_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideo ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_record_enum, (uint8_t)mass_storage_id);
    (*env)->DeleteLocalRef (env, j_record_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordPictureV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPictureV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordVideoV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject record)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_ENUM");
    jmethodID j_record_mid = (*env)->GetMethodID (env, j_record_class, "getValue", "()I");
    jint j_record_enum = (*env)->CallIntMethod (env, record, j_record_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideoV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_record_enum);
    (*env)->DeleteLocalRef (env, j_record_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkWifiScan (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject band)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiScan ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_band_enum);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkWifiAuthChannel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiAuthChannel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsMaxAltitude (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxAltitude ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsMaxTilt (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxTilt ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsAbsolutControl (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte on)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsAbsolutControl ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)on);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsMaxDistance (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxDistance ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsNoFlyOverMaxDistance (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte shouldNotFlyOver)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsNoFlyOverMaxDistance ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)shouldNotFlyOver);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsBankedTurn (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsBankedTurn ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsMinAltitude (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMinAltitude ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsCirclingDirection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_ENUM");
    jmethodID j_value_mid = (*env)->GetMethodID (env, j_value_class, "getValue", "()I");
    jint j_value_enum = (*env)->CallIntMethod (env, value, j_value_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingDirection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_value_enum);
    (*env)->DeleteLocalRef (env, j_value_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsCirclingRadius (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingRadius ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsCirclingAltitude (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingAltitude ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsPitchMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_ENUM");
    jmethodID j_value_mid = (*env)->GetMethodID (env, j_value_class, "getValue", "()I");
    jint j_value_enum = (*env)->CallIntMethod (env, value, j_value_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsPitchMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_value_enum);
    (*env)->DeleteLocalRef (env, j_value_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsLandingMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_ENUM");
    jmethodID j_value_mid = (*env)->GetMethodID (env, j_value_class, "getValue", "()I");
    jint j_value_enum = (*env)->CallIntMethod (env, value, j_value_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsLandingMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_value_enum);
    (*env)->DeleteLocalRef (env, j_value_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsMaxVerticalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxVerticalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsMaxRotationSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxRotationSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsHullProtection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte present)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsHullProtection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)present);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsOutdoor (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte outdoor)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsOutdoor ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)outdoor);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsMaxPitchRollRotationSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxPitchRollRotationSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkSettingsWifiSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkSettingsWifiSecurity (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jstring key, jobject keyType)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    const char *c_key = (*env)->GetStringUTFChars (env, key, NULL);
    jclass j_keyType_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE_ENUM");
    jmethodID j_keyType_mid = (*env)->GetMethodID (env, j_keyType_class, "getValue", "()I");
    jint j_keyType_enum = (*env)->CallIntMethod (env, keyType, j_keyType_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSecurity ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, c_key, j_keyType_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->ReleaseStringUTFChars (env, key, c_key);
    (*env)->DeleteLocalRef (env, j_keyType_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsPictureFormatSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsPictureFormatSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsAutoWhiteBalanceSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsAutoWhiteBalanceSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsExpositionSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsExpositionSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsSaturationSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsSaturationSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsTimelapseSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled, jfloat interval)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsTimelapseSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled, (float)interval);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsVideoAutorecordSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoAutorecordSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsVideoStabilizationMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject mode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_ENUM");
    jmethodID j_mode_mid = (*env)->GetMethodID (env, j_mode_class, "getValue", "()I");
    jint j_mode_enum = (*env)->CallIntMethod (env, mode, j_mode_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoStabilizationMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_mode_enum);
    (*env)->DeleteLocalRef (env, j_mode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaStreamingVideoEnable (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enable)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingVideoEnable ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enable);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsSetHome (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jdouble altitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSetHome ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (double)altitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsResetHome (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsResetHome ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsSendControllerGPS (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jdouble altitude, jdouble horizontalAccuracy, jdouble verticalAccuracy)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSendControllerGPS ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (double)altitude, (double)horizontalAccuracy, (double)verticalAccuracy);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsHomeType (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsHomeType ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsReturnHomeDelay (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort delay)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsReturnHomeDelay ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)delay);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3AntiflickeringElectricFrequency (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject frequency)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_frequency_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_ENUM");
    jmethodID j_frequency_mid = (*env)->GetMethodID (env, j_frequency_class, "getValue", "()I");
    jint j_frequency_enum = (*env)->CallIntMethod (env, frequency, j_frequency_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringElectricFrequency ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_frequency_enum);
    (*env)->DeleteLocalRef (env, j_frequency_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3AntiflickeringSetMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject mode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_ENUM");
    jmethodID j_mode_mid = (*env)->GetMethodID (env, j_mode_class, "getValue", "()I");
    jint j_mode_enum = (*env)->CallIntMethod (env, mode, j_mode_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringSetMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_mode_enum);
    (*env)->DeleteLocalRef (env, j_mode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordStatePictureStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStatePictureStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordStateVideoStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStateVideoStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, (uint8_t)mass_storage_id);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordStatePictureStateChangedV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStatePictureStateChangedV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordStateVideoStateChangedV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordStateVideoStateChangedV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordEventPictureEventChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject event, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM");
    jmethodID j_event_mid = (*env)->GetMethodID (env, j_event_class, "getValue", "()I");
    jint j_event_enum = (*env)->CallIntMethod (env, event, j_event_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordEventPictureEventChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_event_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_event_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaRecordEventVideoEventChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject event, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM");
    jmethodID j_event_mid = (*env)->GetMethodID (env, j_event_class, "getValue", "()I");
    jint j_event_enum = (*env)->CallIntMethod (env, event, j_event_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordEventVideoEventChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_event_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_event_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateFlatTrimChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateFlatTrimChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateFlyingStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateFlyingStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateAlertStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAlertStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateNavigateHomeStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jobject reason)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_reason_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_ENUM");
    jmethodID j_reason_mid = (*env)->GetMethodID (env, j_reason_class, "getValue", "()I");
    jint j_reason_enum = (*env)->CallIntMethod (env, reason, j_reason_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateNavigateHomeStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, j_reason_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_reason_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStatePositionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jdouble altitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStatePositionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (double)altitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat speedX, jfloat speedY, jfloat speedZ)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)speedX, (float)speedY, (float)speedZ);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateAttitudeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat roll, jfloat pitch, jfloat yaw)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAttitudeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)roll, (float)pitch, (float)yaw);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateAutoTakeOffModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAutoTakeOffModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingStateAltitudeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble altitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingStateAltitudeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)altitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingEventMoveByEnd (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat dX, jfloat dY, jfloat dZ, jfloat dPsi, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingEventMoveByEnd ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)dX, (float)dY, (float)dZ, (float)dPsi, j_error_enum);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkStateWifiScanListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid, jshort rssi, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkStateWifiScanListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid, (int16_t)rssi, j_band_enum, (uint8_t)channel);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkStateAllWifiScanChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkStateAllWifiScanChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkStateWifiAuthChannelListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject band, jbyte channel, jbyte in_or_out)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkStateWifiAuthChannelListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_band_enum, (uint8_t)channel, (uint8_t)in_or_out);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkStateAllWifiAuthChannelChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkStateAllWifiAuthChannelChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateMaxAltitudeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxAltitudeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateMaxTiltChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxTiltChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateAbsolutControlChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte on)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAbsolutControlChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)on);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateMaxDistanceChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMaxDistanceChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte shouldNotFlyOver)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)shouldNotFlyOver);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateBankedTurnChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateBankedTurnChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateMinAltitudeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateMinAltitudeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateCirclingDirectionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_ENUM");
    jmethodID j_value_mid = (*env)->GetMethodID (env, j_value_class, "getValue", "()I");
    jint j_value_enum = (*env)->CallIntMethod (env, value, j_value_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingDirectionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_value_enum);
    (*env)->DeleteLocalRef (env, j_value_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateCirclingRadiusChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort current, jshort min, jshort max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingRadiusChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)current, (uint16_t)min, (uint16_t)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateCirclingAltitudeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort current, jshort min, jshort max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateCirclingAltitudeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)current, (uint16_t)min, (uint16_t)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStatePitchModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_ENUM");
    jmethodID j_value_mid = (*env)->GetMethodID (env, j_value_class, "getValue", "()I");
    jint j_value_enum = (*env)->CallIntMethod (env, value, j_value_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStatePitchModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_value_enum);
    (*env)->DeleteLocalRef (env, j_value_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PilotingSettingsStateLandingModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_ENUM");
    jmethodID j_value_mid = (*env)->GetMethodID (env, j_value_class, "getValue", "()I");
    jint j_value_enum = (*env)->CallIntMethod (env, value, j_value_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsStateLandingModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_value_enum);
    (*env)->DeleteLocalRef (env, j_value_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsStateMaxVerticalSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxVerticalSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsStateMaxRotationSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxRotationSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsStateHullProtectionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte present)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateHullProtectionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)present);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsStateOutdoorChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte outdoor)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateOutdoorChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)outdoor);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkSettingsStateWifiSelectionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSelectionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkSettingsStateWifiSecurityChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSecurityChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3NetworkSettingsStateWifiSecurity (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jstring key, jobject keyType)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    const char *c_key = (*env)->GetStringUTFChars (env, key, NULL);
    jclass j_keyType_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE_ENUM");
    jmethodID j_keyType_mid = (*env)->GetMethodID (env, j_keyType_class, "getValue", "()I");
    jint j_keyType_enum = (*env)->CallIntMethod (env, keyType, j_keyType_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsStateWifiSecurity ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, c_key, j_keyType_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->ReleaseStringUTFChars (env, key, c_key);
    (*env)->DeleteLocalRef (env, j_keyType_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateProductMotorVersionListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte motor_number, jstring type, jstring software, jstring hardware)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_type = (*env)->GetStringUTFChars (env, type, NULL);
    const char *c_software = (*env)->GetStringUTFChars (env, software, NULL);
    const char *c_hardware = (*env)->GetStringUTFChars (env, hardware, NULL);
    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateProductMotorVersionListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)motor_number, c_type, c_software, c_hardware);
    (*env)->ReleaseStringUTFChars (env, type, c_type);
    (*env)->ReleaseStringUTFChars (env, software, c_software);
    (*env)->ReleaseStringUTFChars (env, hardware, c_hardware);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateProductGPSVersionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring software, jstring hardware)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_software = (*env)->GetStringUTFChars (env, software, NULL);
    const char *c_hardware = (*env)->GetStringUTFChars (env, hardware, NULL);
    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateProductGPSVersionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_software, c_hardware);
    (*env)->ReleaseStringUTFChars (env, software, c_software);
    (*env)->ReleaseStringUTFChars (env, hardware, c_hardware);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateMotorErrorStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte motorIds, jobject motorError)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_motorError_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ENUM");
    jmethodID j_motorError_mid = (*env)->GetMethodID (env, j_motorError_class, "getValue", "()I");
    jint j_motorError_enum = (*env)->CallIntMethod (env, motorError, j_motorError_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorErrorStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)motorIds, j_motorError_enum);
    (*env)->DeleteLocalRef (env, j_motorError_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateMotorSoftwareVersionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring version)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_version = (*env)->GetStringUTFChars (env, version, NULL);
    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorSoftwareVersionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_version);
    (*env)->ReleaseStringUTFChars (env, version, c_version);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateMotorFlightsStatusChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort nbFlights, jshort lastFlightDuration, jint totalFlightDuration)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorFlightsStatusChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)nbFlights, (uint16_t)lastFlightDuration, (uint32_t)totalFlightDuration);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateMotorErrorLastErrorChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject motorError)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_motorError_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ENUM");
    jmethodID j_motorError_mid = (*env)->GetMethodID (env, j_motorError_class, "getValue", "()I");
    jint j_motorError_enum = (*env)->CallIntMethod (env, motorError, j_motorError_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateMotorErrorLastErrorChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_motorError_enum);
    (*env)->DeleteLocalRef (env, j_motorError_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3SettingsStateP7ID (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring serialID)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_serialID = (*env)->GetStringUTFChars (env, serialID, NULL);
    err = ARCOMMANDS_Generator_GenerateARDrone3SettingsStateP7ID ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_serialID);
    (*env)->ReleaseStringUTFChars (env, serialID, c_serialID);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStatePictureFormatChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStatePictureFormatChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStateAutoWhiteBalanceChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateAutoWhiteBalanceChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStateExpositionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateExpositionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStateSaturationChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat value, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateSaturationChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)value, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStateTimelapseChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled, jfloat interval, jfloat minInterval, jfloat maxInterval)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateTimelapseChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled, (float)interval, (float)minInterval, (float)maxInterval);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStateVideoAutorecordChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateVideoAutorecordChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PictureSettingsStateVideoStabilizationModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject mode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_ENUM");
    jmethodID j_mode_mid = (*env)->GetMethodID (env, j_mode_class, "getValue", "()I");
    jint j_mode_enum = (*env)->CallIntMethod (env, mode, j_mode_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsStateVideoStabilizationModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_mode_enum);
    (*env)->DeleteLocalRef (env, j_mode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3MediaStreamingStateVideoEnableChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject enabled)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_enabled_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM");
    jmethodID j_enabled_mid = (*env)->GetMethodID (env, j_enabled_class, "getValue", "()I");
    jint j_enabled_enum = (*env)->CallIntMethod (env, enabled, j_enabled_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingStateVideoEnableChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_enabled_enum);
    (*env)->DeleteLocalRef (env, j_enabled_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsStateHomeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jdouble altitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateHomeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (double)altitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsStateResetHomeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jdouble altitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateResetHomeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (double)altitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsStateGPSFixStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte fixed)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateGPSFixStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)fixed);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsStateGPSUpdateStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateGPSUpdateStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsStateHomeTypeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateHomeTypeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSSettingsStateReturnHomeDelayChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort delay)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsStateReturnHomeDelayChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)delay);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3CameraStateOrientation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte tilt, jbyte pan)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3CameraStateOrientation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int8_t)tilt, (int8_t)pan);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3CameraStateDefaultCameraOrientation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte tilt, jbyte pan)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3CameraStateDefaultCameraOrientation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int8_t)tilt, (int8_t)pan);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3AntiflickeringStateElectricFrequencyChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject frequency)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_frequency_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_ENUM");
    jmethodID j_frequency_mid = (*env)->GetMethodID (env, j_frequency_class, "getValue", "()I");
    jint j_frequency_enum = (*env)->CallIntMethod (env, frequency, j_frequency_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringStateElectricFrequencyChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_frequency_enum);
    (*env)->DeleteLocalRef (env, j_frequency_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3AntiflickeringStateModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject mode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_ENUM");
    jmethodID j_mode_mid = (*env)->GetMethodID (env, j_mode_class, "getValue", "()I");
    jint j_mode_enum = (*env)->CallIntMethod (env, mode, j_mode_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringStateModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_mode_enum);
    (*env)->DeleteLocalRef (env, j_mode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSStateNumberOfSatelliteChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte numberOfSatellite)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3GPSStateNumberOfSatelliteChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)numberOfSatellite);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSStateHomeTypeAvailabilityChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jbyte available)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3GPSStateHomeTypeAvailabilityChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, (uint8_t)available);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3GPSStateHomeTypeChosenChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateARDrone3GPSStateHomeTypeChosenChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetARDrone3PROStateFeatures (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jlong features)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateARDrone3PROStateFeatures ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint64_t)features);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoPilotingPCMD (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte flag, jbyte speed, jbyte turn)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPCMD ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)flag, (int8_t)speed, (int8_t)turn);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoPilotingPosture (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPosture ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoPilotingAddCapOffset (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat offset)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingAddCapOffset ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)offset);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsJumpStop (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpStop ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsJumpCancel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpCancel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsJumpLoad (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpLoad ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsJump (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJump ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsSimpleAnimation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_id_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_ENUM");
    jmethodID j_id_mid = (*env)->GetMethodID (env, j_id_class, "getValue", "()I");
    jint j_id_enum = (*env)->CallIntMethod (env, id, j_id_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsSimpleAnimation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_id_enum);
    (*env)->DeleteLocalRef (env, j_id_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordPicture (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPicture ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordVideo (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject record, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_ENUM");
    jmethodID j_record_mid = (*env)->GetMethodID (env, j_record_class, "getValue", "()I");
    jint j_record_enum = (*env)->CallIntMethod (env, record, j_record_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideo ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_record_enum, (uint8_t)mass_storage_id);
    (*env)->DeleteLocalRef (env, j_record_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordPictureV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPictureV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordVideoV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject record)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_ENUM");
    jmethodID j_record_mid = (*env)->GetMethodID (env, j_record_class, "getValue", "()I");
    jint j_record_enum = (*env)->CallIntMethod (env, record, j_record_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideoV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_record_enum);
    (*env)->DeleteLocalRef (env, j_record_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkSettingsWifiSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsWifiSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkWifiScan (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject band)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiScan ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_band_enum);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkWifiAuthChannel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiAuthChannel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAudioSettingsMasterVolume (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte volume)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsMasterVolume ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)volume);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAudioSettingsTheme (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject theme)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_theme_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_ENUM");
    jmethodID j_theme_mid = (*env)->GetMethodID (env, j_theme_class, "getValue", "()I");
    jint j_theme_enum = (*env)->CallIntMethod (env, theme, j_theme_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsTheme ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_theme_enum);
    (*env)->DeleteLocalRef (env, j_theme_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanAllScriptsMetadata (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanAllScriptsMetadata ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanScriptUploaded (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring uuid, jstring md5Hash)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_uuid = (*env)->GetStringUTFChars (env, uuid, NULL);
    const char *c_md5Hash = (*env)->GetStringUTFChars (env, md5Hash, NULL);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptUploaded ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_uuid, c_md5Hash);
    (*env)->ReleaseStringUTFChars (env, uuid, c_uuid);
    (*env)->ReleaseStringUTFChars (env, md5Hash, c_md5Hash);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanScriptDelete (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring uuid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_uuid = (*env)->GetStringUTFChars (env, uuid, NULL);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptDelete ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_uuid);
    (*env)->ReleaseStringUTFChars (env, uuid, c_uuid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanPlayScript (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring uuid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_uuid = (*env)->GetStringUTFChars (env, uuid, NULL);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanPlayScript ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_uuid);
    (*env)->ReleaseStringUTFChars (env, uuid, c_uuid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoSpeedSettingsOutdoor (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte outdoor)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsOutdoor ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)outdoor);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaStreamingVideoEnable (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enable)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingVideoEnable ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enable);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoVideoSettingsAutorecord (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsAutorecord ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoPilotingStatePostureChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStatePostureChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoPilotingStateAlertStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStateAlertStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoPilotingStateSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte speed, jshort realSpeed)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingStateSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int8_t)speed, (int16_t)realSpeed);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsStateJumpLoadChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpLoadChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsStateJumpTypeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpTypeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAnimationsStateJumpMotorProblemChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsStateJumpMotorProblemChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_error_enum);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoSettingsStateProductGPSVersionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring software, jstring hardware)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_software = (*env)->GetStringUTFChars (env, software, NULL);
    const char *c_hardware = (*env)->GetStringUTFChars (env, hardware, NULL);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoSettingsStateProductGPSVersionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_software, c_hardware);
    (*env)->ReleaseStringUTFChars (env, software, c_software);
    (*env)->ReleaseStringUTFChars (env, hardware, c_hardware);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordStatePictureStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStatePictureStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordStateVideoStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStateVideoStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, (uint8_t)mass_storage_id);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordStatePictureStateChangedV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStatePictureStateChangedV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordStateVideoStateChangedV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordStateVideoStateChangedV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordEventPictureEventChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject event, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM");
    jmethodID j_event_mid = (*env)->GetMethodID (env, j_event_class, "getValue", "()I");
    jint j_event_enum = (*env)->CallIntMethod (env, event, j_event_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordEventPictureEventChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_event_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_event_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaRecordEventVideoEventChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject event, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM");
    jmethodID j_event_mid = (*env)->GetMethodID (env, j_event_class, "getValue", "()I");
    jint j_event_enum = (*env)->CallIntMethod (env, event, j_event_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordEventVideoEventChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_event_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_event_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkSettingsStateWifiSelectionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsStateWifiSelectionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkStateWifiScanListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid, jshort rssi, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateWifiScanListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid, (int16_t)rssi, j_band_enum, (uint8_t)channel);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkStateAllWifiScanChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateAllWifiScanChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkStateWifiAuthChannelListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject band, jbyte channel, jbyte in_or_out)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateWifiAuthChannelListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_band_enum, (uint8_t)channel, (uint8_t)in_or_out);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkStateAllWifiAuthChannelChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateAllWifiAuthChannelChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoNetworkStateLinkQualityChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte quality)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkStateLinkQualityChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)quality);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAudioSettingsStateMasterVolumeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte volume)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsStateMasterVolumeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)volume);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoAudioSettingsStateThemeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject theme)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_theme_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_ENUM");
    jmethodID j_theme_mid = (*env)->GetMethodID (env, j_theme_class, "getValue", "()I");
    jint j_theme_enum = (*env)->CallIntMethod (env, theme, j_theme_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsStateThemeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_theme_enum);
    (*env)->DeleteLocalRef (env, j_theme_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanStateScriptMetadataListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring uuid, jbyte version, jstring product, jstring name, jlong lastModified)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_uuid = (*env)->GetStringUTFChars (env, uuid, NULL);
    const char *c_product = (*env)->GetStringUTFChars (env, product, NULL);
    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptMetadataListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_uuid, (uint8_t)version, c_product, c_name, (uint64_t)lastModified);
    (*env)->ReleaseStringUTFChars (env, uuid, c_uuid);
    (*env)->ReleaseStringUTFChars (env, product, c_product);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanStateAllScriptsMetadataChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateAllScriptsMetadataChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanStateScriptUploadChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject resultCode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_resultCode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ENUM");
    jmethodID j_resultCode_mid = (*env)->GetMethodID (env, j_resultCode_class, "getValue", "()I");
    jint j_resultCode_enum = (*env)->CallIntMethod (env, resultCode, j_resultCode_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptUploadChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_resultCode_enum);
    (*env)->DeleteLocalRef (env, j_resultCode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanStateScriptDeleteChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject resultCode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_resultCode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ENUM");
    jmethodID j_resultCode_mid = (*env)->GetMethodID (env, j_resultCode_class, "getValue", "()I");
    jint j_resultCode_enum = (*env)->CallIntMethod (env, resultCode, j_resultCode_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStateScriptDeleteChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_resultCode_enum);
    (*env)->DeleteLocalRef (env, j_resultCode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoRoadPlanStatePlayScriptChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject resultCode)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_resultCode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_ENUM");
    jmethodID j_resultCode_mid = (*env)->GetMethodID (env, j_resultCode_class, "getValue", "()I");
    jint j_resultCode_enum = (*env)->CallIntMethod (env, resultCode, j_resultCode_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanStatePlayScriptChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_resultCode_enum);
    (*env)->DeleteLocalRef (env, j_resultCode_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoSpeedSettingsStateOutdoorChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte outdoor)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsStateOutdoorChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)outdoor);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoMediaStreamingStateVideoEnableChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject enabled)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_enabled_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM");
    jmethodID j_enabled_mid = (*env)->GetMethodID (env, j_enabled_class, "getValue", "()I");
    jint j_enabled_enum = (*env)->CallIntMethod (env, enabled, j_enabled_mid);
    err = ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingStateVideoEnableChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_enabled_enum);
    (*env)->DeleteLocalRef (env, j_enabled_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetJumpingSumoVideoSettingsStateAutorecordChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsStateAutorecordChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingFlatTrim (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingFlatTrim ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingTakeOff (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingTakeOff ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingPCMD (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte flag, jbyte roll, jbyte pitch, jbyte yaw, jbyte gaz, jint timestamp)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingPCMD ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)flag, (int8_t)roll, (int8_t)pitch, (int8_t)yaw, (int8_t)gaz, (uint32_t)timestamp);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingLanding (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingLanding ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingEmergency (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingEmergency ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingAutoTakeOffMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingAutoTakeOffMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneAnimationsFlip (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject direction)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_direction_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_ENUM");
    jmethodID j_direction_mid = (*env)->GetMethodID (env, j_direction_class, "getValue", "()I");
    jint j_direction_enum = (*env)->CallIntMethod (env, direction, j_direction_mid);
    err = ARCOMMANDS_Generator_GenerateMiniDroneAnimationsFlip ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_direction_enum);
    (*env)->DeleteLocalRef (env, j_direction_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneAnimationsCap (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort offset)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneAnimationsCap ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int16_t)offset);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneMediaRecordPicture (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPicture ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneMediaRecordPictureV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPictureV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingSettingsMaxAltitude (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxAltitude ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingSettingsMaxTilt (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxTilt ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsMaxVerticalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxVerticalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsMaxRotationSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxRotationSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsWheels (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte present)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsWheels ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)present);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsMaxHorizontalSpeed (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxHorizontalSpeed ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSettingsCutOutMode (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enable)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSettingsCutOutMode ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enable);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneGPSControllerLatitudeForRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLatitudeForRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneGPSControllerLongitudeForRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble longitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLongitudeForRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)longitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneConfigurationControllerType (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_type = (*env)->GetStringUTFChars (env, type, NULL);
    err = ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerType ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_type);
    (*env)->ReleaseStringUTFChars (env, type, c_type);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneConfigurationControllerName (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerName ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_name);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingStateFlatTrimChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingStateFlatTrimChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingStateFlyingStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingStateFlyingStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingStateAlertStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingStateAlertStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingStateAutoTakeOffModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingStateAutoTakeOffModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneMediaRecordStatePictureStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte state, jbyte mass_storage_id)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordStatePictureStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)state, (uint8_t)mass_storage_id);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneMediaRecordStatePictureStateChangedV2 (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordStatePictureStateChangedV2 ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneMediaRecordEventPictureEventChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject event, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM");
    jmethodID j_event_mid = (*env)->GetMethodID (env, j_event_class, "getValue", "()I");
    jint j_event_enum = (*env)->CallIntMethod (env, event, j_event_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordEventPictureEventChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_event_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_event_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingSettingsStateMaxAltitudeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsStateMaxAltitudeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDronePilotingSettingsStateMaxTiltChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsStateMaxTiltChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsStateMaxVerticalSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxVerticalSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsStateMaxRotationSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxRotationSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsStateWheelsChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte present)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateWheelsChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)present);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat current, jfloat min, jfloat max)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsStateMaxHorizontalSpeedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)current, (float)min, (float)max);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSettingsStateProductMotorsVersionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte motor, jstring type, jstring software, jstring hardware)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_type = (*env)->GetStringUTFChars (env, type, NULL);
    const char *c_software = (*env)->GetStringUTFChars (env, software, NULL);
    const char *c_hardware = (*env)->GetStringUTFChars (env, hardware, NULL);
    err = ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateProductMotorsVersionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)motor, c_type, c_software, c_hardware);
    (*env)->ReleaseStringUTFChars (env, type, c_type);
    (*env)->ReleaseStringUTFChars (env, software, c_software);
    (*env)->ReleaseStringUTFChars (env, hardware, c_hardware);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSettingsStateProductInertialVersionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring software, jstring hardware)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_software = (*env)->GetStringUTFChars (env, software, NULL);
    const char *c_hardware = (*env)->GetStringUTFChars (env, hardware, NULL);
    err = ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateProductInertialVersionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_software, c_hardware);
    (*env)->ReleaseStringUTFChars (env, software, c_software);
    (*env)->ReleaseStringUTFChars (env, hardware, c_hardware);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneSettingsStateCutOutModeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enable)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneSettingsStateCutOutModeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enable);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetMiniDroneFloodControlStateFloodControlChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort delay)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateMiniDroneFloodControlStateFloodControlChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)delay);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiRequestWifiList (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiRequestWifiList ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiRequestCurrentWifi (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiRequestCurrentWifi ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiConnectToWifi (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring bssid, jstring ssid, jstring passphrase)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_bssid = (*env)->GetStringUTFChars (env, bssid, NULL);
    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    const char *c_passphrase = (*env)->GetStringUTFChars (env, passphrase, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiConnectToWifi ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_bssid, c_ssid, c_passphrase);
    (*env)->ReleaseStringUTFChars (env, bssid, c_bssid);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    (*env)->ReleaseStringUTFChars (env, passphrase, c_passphrase);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiForgetWifi (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiForgetWifi ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiWifiAuthChannel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiWifiAuthChannel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerDeviceRequestDeviceList (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerDeviceRequestDeviceList ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerDeviceRequestCurrentDevice (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerDeviceRequestCurrentDevice ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerDeviceConnectToDevice (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring deviceName)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_deviceName = (*env)->GetStringUTFChars (env, deviceName, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerDeviceConnectToDevice ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_deviceName);
    (*env)->ReleaseStringUTFChars (env, deviceName, c_deviceName);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSettingsAllSettings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSettingsAllSettings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSettingsReset (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSettingsReset ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCommonAllStates (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerCommonAllStates ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAccessPointSettingsAccessPointSSID (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsAccessPointSSID ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAccessPointSettingsAccessPointChannel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsAccessPointChannel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)channel);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAccessPointSettingsWifiSelection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsWifiSelection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCameraResetOrientation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerCameraResetOrientation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerGamepadInfosGetGamepadControls (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosGetGamepadControls ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsGetCurrentButtonMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsGetCurrentButtonMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsGetAvailableButtonMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsGetAvailableButtonMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsSetButtonMapping (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint key_id, jstring mapping_uid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_mapping_uid = (*env)->GetStringUTFChars (env, mapping_uid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsSetButtonMapping ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int32_t)key_id, c_mapping_uid);
    (*env)->ReleaseStringUTFChars (env, mapping_uid, c_mapping_uid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsDefaultButtonMapping (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsDefaultButtonMapping ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsGetCurrentAxisMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsGetCurrentAxisMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsGetAvailableAxisMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsGetAvailableAxisMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsSetAxisMapping (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint axis_id, jstring mapping_uid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_mapping_uid = (*env)->GetStringUTFChars (env, mapping_uid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsSetAxisMapping ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int32_t)axis_id, c_mapping_uid);
    (*env)->ReleaseStringUTFChars (env, mapping_uid, c_mapping_uid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsDefaultAxisMapping (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsDefaultAxisMapping ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersGetCurrentAxisFilters (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersGetCurrentAxisFilters ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersGetPresetAxisFilters (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersGetPresetAxisFilters ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersSetAxisFilter (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint axis_id, jstring filter_uid_or_builder)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_filter_uid_or_builder = (*env)->GetStringUTFChars (env, filter_uid_or_builder, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersSetAxisFilter ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int32_t)axis_id, c_filter_uid_or_builder);
    (*env)->ReleaseStringUTFChars (env, filter_uid_or_builder, c_filter_uid_or_builder);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersDefaultAxisFilters (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersDefaultAxisFilters ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCoPilotingSetPilotingSource (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject source)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_source_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_ENUM");
    jmethodID j_source_mid = (*env)->GetMethodID (env, j_source_class, "getValue", "()I");
    jint j_source_enum = (*env)->CallIntMethod (env, source, j_source_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerCoPilotingSetPilotingSource ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_source_enum);
    (*env)->DeleteLocalRef (env, j_source_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdates (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enable)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdates ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enable);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiStateWifiList (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring bssid, jstring ssid, jbyte secured, jbyte saved, jint rssi, jint frequency)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_bssid = (*env)->GetStringUTFChars (env, bssid, NULL);
    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiList ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_bssid, c_ssid, (uint8_t)secured, (uint8_t)saved, (int32_t)rssi, (int32_t)frequency);
    (*env)->ReleaseStringUTFChars (env, bssid, c_bssid);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiStateConnexionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid, jobject status)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_ENUM");
    jmethodID j_status_mid = (*env)->GetMethodID (env, j_status_class, "getValue", "()I");
    jint j_status_enum = (*env)->CallIntMethod (env, status, j_status_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiStateConnexionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid, j_status_enum);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    (*env)->DeleteLocalRef (env, j_status_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiStateWifiAuthChannelListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject band, jbyte channel, jbyte in_or_out)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiAuthChannelListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_band_enum, (uint8_t)channel, (uint8_t)in_or_out);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiStateAllWifiAuthChannelChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiStateAllWifiAuthChannelChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerWifiStateWifiSignalChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte level)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerWifiStateWifiSignalChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)level);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerDeviceStateDeviceList (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerDeviceStateDeviceList ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_name);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerDeviceStateConnexionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject status, jstring deviceName, jshort deviceProductID)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_ENUM");
    jmethodID j_status_mid = (*env)->GetMethodID (env, j_status_class, "getValue", "()I");
    jint j_status_enum = (*env)->CallIntMethod (env, status, j_status_mid);
    const char *c_deviceName = (*env)->GetStringUTFChars (env, deviceName, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerDeviceStateConnexionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_status_enum, c_deviceName, (uint16_t)deviceProductID);
    (*env)->DeleteLocalRef (env, j_status_class);
    (*env)->ReleaseStringUTFChars (env, deviceName, c_deviceName);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSettingsStateAllSettingsChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateAllSettingsChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSettingsStateResetChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateResetChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSettingsStateProductSerialChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring serialNumber)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_serialNumber = (*env)->GetStringUTFChars (env, serialNumber, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateProductSerialChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_serialNumber);
    (*env)->ReleaseStringUTFChars (env, serialNumber, c_serialNumber);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSettingsStateProductVariantChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject variant)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_variant_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_ENUM");
    jmethodID j_variant_mid = (*env)->GetMethodID (env, j_variant_class, "getValue", "()I");
    jint j_variant_enum = (*env)->CallIntMethod (env, variant, j_variant_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerSettingsStateProductVariantChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_variant_enum);
    (*env)->DeleteLocalRef (env, j_variant_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCommonStateAllStatesChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerCommonStateAllStatesChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSkyControllerStateBatteryChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte percent)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateBatteryChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)percent);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSkyControllerStateGpsFixChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte fixed)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateGpsFixChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)fixed);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerSkyControllerStateGpsPositionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jdouble altitude, jfloat heading)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerSkyControllerStateGpsPositionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (double)altitude, (float)heading);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAccessPointSettingsStateAccessPointSSIDChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateAccessPointSSIDChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAccessPointSettingsStateAccessPointChannelChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateAccessPointChannelChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)channel);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAccessPointSettingsStateWifiSelectionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAccessPointSettingsStateWifiSelectionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerGamepadInfosStateGamepadControl (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jint id, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosStateGamepadControl ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, (int32_t)id, c_name);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerGamepadInfosStateAllGamepadControlsSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerGamepadInfosStateAllGamepadControlsSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsStateCurrentButtonMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint key_id, jstring mapping_uid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_mapping_uid = (*env)->GetStringUTFChars (env, mapping_uid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateCurrentButtonMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int32_t)key_id, c_mapping_uid);
    (*env)->ReleaseStringUTFChars (env, mapping_uid, c_mapping_uid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAllCurrentButtonMappingsSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsStateAvailableButtonMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring mapping_uid, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_mapping_uid = (*env)->GetStringUTFChars (env, mapping_uid, NULL);
    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAvailableButtonMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_mapping_uid, c_name);
    (*env)->ReleaseStringUTFChars (env, mapping_uid, c_mapping_uid);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsStateCurrentAxisMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint axis_id, jstring mapping_uid)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_mapping_uid = (*env)->GetStringUTFChars (env, mapping_uid, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateCurrentAxisMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int32_t)axis_id, c_mapping_uid);
    (*env)->ReleaseStringUTFChars (env, mapping_uid, c_mapping_uid);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAllCurrentAxisMappingsSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsStateAvailableAxisMappings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring mapping_uid, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_mapping_uid = (*env)->GetStringUTFChars (env, mapping_uid, NULL);
    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAvailableAxisMappings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_mapping_uid, c_name);
    (*env)->ReleaseStringUTFChars (env, mapping_uid, c_mapping_uid);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisMappingsStateAllAvailableAxisMappingsSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersStateCurrentAxisFilters (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint axis_id, jstring filter_uid_or_builder)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_filter_uid_or_builder = (*env)->GetStringUTFChars (env, filter_uid_or_builder, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateCurrentAxisFilters ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int32_t)axis_id, c_filter_uid_or_builder);
    (*env)->ReleaseStringUTFChars (env, filter_uid_or_builder, c_filter_uid_or_builder);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersStateAllCurrentFiltersSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateAllCurrentFiltersSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersStatePresetAxisFilters (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring filter_uid, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_filter_uid = (*env)->GetStringUTFChars (env, filter_uid, NULL);
    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStatePresetAxisFilters ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_filter_uid, c_name);
    (*env)->ReleaseStringUTFChars (env, filter_uid, c_filter_uid);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerAxisFiltersStateAllPresetFiltersSent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerAxisFiltersStateAllPresetFiltersSent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCoPilotingStatePilotingSource (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject source)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_source_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_ENUM");
    jmethodID j_source_mid = (*env)->GetMethodID (env, j_source_class, "getValue", "()I");
    jint j_source_enum = (*env)->CallIntMethod (env, source, j_source_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerCoPilotingStatePilotingSource ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_source_enum);
    (*env)->DeleteLocalRef (env, j_source_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCalibrationStateMagnetoCalibrationState (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject status, jbyte X_Quality, jbyte Y_Quality, jbyte Z_Quality)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_ENUM");
    jmethodID j_status_mid = (*env)->GetMethodID (env, j_status_class, "getValue", "()I");
    jint j_status_enum = (*env)->CallIntMethod (env, status, j_status_mid);
    err = ARCOMMANDS_Generator_GenerateSkyControllerCalibrationStateMagnetoCalibrationState ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_status_enum, (uint8_t)X_Quality, (uint8_t)Y_Quality, (uint8_t)Z_Quality);
    (*env)->DeleteLocalRef (env, j_status_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesState (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesState ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetSkyControllerButtonEventsSettings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateSkyControllerButtonEventsSettings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1GeographicRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte distance_is_default, jfloat distance, jbyte elevation_is_default, jfloat elevation, jbyte azimuth_is_default, jfloat azimuth)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1GeographicRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)distance_is_default, (float)distance, (uint8_t)elevation_is_default, (float)elevation, (uint8_t)azimuth_is_default, (float)azimuth);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1RelativeRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte distance_is_default, jfloat distance, jbyte elevation_is_default, jfloat elevation, jbyte azimuth_is_default, jfloat azimuth)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1RelativeRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)distance_is_default, (float)distance, (uint8_t)elevation_is_default, (float)elevation, (uint8_t)azimuth_is_default, (float)azimuth);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1LookAtRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1LookAtRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1SpiralAnimRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte speed_is_default, jfloat speed, jbyte revolution_nb_is_default, jfloat revolution_number, jbyte vertical_distance_is_default, jfloat vertical_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1SpiralAnimRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)speed_is_default, (float)speed, (uint8_t)revolution_nb_is_default, (float)revolution_number, (uint8_t)vertical_distance_is_default, (float)vertical_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1SwingAnimRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte speed_is_default, jfloat speed, jbyte vertical_distance_is_default, jfloat vertical_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1SwingAnimRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)speed_is_default, (float)speed, (uint8_t)vertical_distance_is_default, (float)vertical_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1BoomerangAnimRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte speed_is_default, jfloat speed, jbyte distance_is_default, jfloat distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1BoomerangAnimRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)speed_is_default, (float)speed, (uint8_t)distance_is_default, (float)distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1CandleAnimRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte speed_is_default, jfloat speed, jbyte vertical_distance_is_default, jfloat vertical_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1CandleAnimRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)speed_is_default, (float)speed, (uint8_t)vertical_distance_is_default, (float)vertical_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1DollySlideAnimRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte start, jbyte speed_is_default, jfloat speed, jbyte angle_is_default, jfloat angle, jbyte horizontal_distance_is_default, jfloat horizontal_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1DollySlideAnimRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)start, (uint8_t)speed_is_default, (float)speed, (uint8_t)angle_is_default, (float)angle, (uint8_t)horizontal_distance_is_default, (float)horizontal_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1UserFramingPosition (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte horizontal, jbyte vertical)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1UserFramingPosition ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int8_t)horizontal, (int8_t)vertical);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1UserGPSData (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude, jfloat altitude, jfloat horizontal_accuracy, jfloat vertical_accuracy, jfloat north_speed, jfloat east_speed, jfloat down_speed, jdouble timestamp)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1UserGPSData ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude, (float)altitude, (float)horizontal_accuracy, (float)vertical_accuracy, (float)north_speed, (float)east_speed, (float)down_speed, (double)timestamp);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1UserBaroData (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat pressure, jdouble timestamp)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1UserBaroData ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)pressure, (double)timestamp);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1LynxDetection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat target_pan, jfloat target_tilt, jfloat change_of_scale, jbyte confidence_index, jbyte is_new_selection, jlong timestamp)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1LynxDetection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)target_pan, (float)target_tilt, (float)change_of_scale, (uint8_t)confidence_index, (uint8_t)is_new_selection, (uint64_t)timestamp);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1Availability (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateUnknownFeature1Availability ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1Run (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateUnknownFeature1Run ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1GeographicConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte distance_is_default, jfloat distance, jbyte elevation_is_default, jfloat elevation, jbyte azimuth_is_default, jfloat azimuth)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1GeographicConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)distance_is_default, (float)distance, (uint8_t)elevation_is_default, (float)elevation, (uint8_t)azimuth_is_default, (float)azimuth);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1RelativeConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte distance_is_default, jfloat distance, jbyte elevation_is_default, jfloat elevation, jbyte azimuth_is_default, jfloat azimuth)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1RelativeConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)distance_is_default, (float)distance, (uint8_t)elevation_is_default, (float)elevation, (uint8_t)azimuth_is_default, (float)azimuth);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1AnimRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateUnknownFeature1AnimRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1SpiralAnimConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte speed_is_default, jfloat speed, jbyte revolution_nb_is_default, jfloat revolution_nb, jbyte vertical_distance_is_default, jfloat vertical_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1SpiralAnimConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)speed_is_default, (float)speed, (uint8_t)revolution_nb_is_default, (float)revolution_nb, (uint8_t)vertical_distance_is_default, (float)vertical_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1SwingAnimConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte speed_is_default, jfloat speed, jbyte vertical_distance_is_default, jfloat vertical_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1SwingAnimConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)speed_is_default, (float)speed, (uint8_t)vertical_distance_is_default, (float)vertical_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1BoomerangAnimConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte speed_is_default, jfloat speed, jbyte distance_is_default, jfloat distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1BoomerangAnimConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)speed_is_default, (float)speed, (uint8_t)distance_is_default, (float)distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1CandleAnimConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte speed_is_default, jfloat speed, jbyte vertical_distance_is_default, jfloat vertical_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1CandleAnimConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)speed_is_default, (float)speed, (uint8_t)vertical_distance_is_default, (float)vertical_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1DollySlideAnimConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte speed_is_default, jfloat speed, jbyte angle_is_default, jfloat angle, jbyte horizontal_distance_is_default, jfloat horizontal_distance)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1DollySlideAnimConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)speed_is_default, (float)speed, (uint8_t)angle_is_default, (float)angle, (uint8_t)horizontal_distance_is_default, (float)horizontal_distance);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetUnknownFeature1UserFramingPositionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte horizontal, jbyte vertical)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateUnknownFeature1UserFramingPositionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int8_t)horizontal, (int8_t)vertical);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonNetworkDisconnect (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonNetworkDisconnect ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsAllSettings (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonSettingsAllSettings ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsReset (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonSettingsReset ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsProductName (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsProductName ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_name);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsCountry (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring code)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_code = (*env)->GetStringUTFChars (env, code, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsCountry ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_code);
    (*env)->ReleaseStringUTFChars (env, code, c_code);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsAutoCountry (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte automatic)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonSettingsAutoCountry ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)automatic);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonAllStates (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonAllStates ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonCurrentDate (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring date)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_date = (*env)->GetStringUTFChars (env, date, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonCommonCurrentDate ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_date);
    (*env)->ReleaseStringUTFChars (env, date, c_date);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonCurrentTime (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring time)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_time = (*env)->GetStringUTFChars (env, time, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonCommonCurrentTime ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_time);
    (*env)->ReleaseStringUTFChars (env, time, c_time);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonReboot (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonReboot ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonOverHeatSwitchOff (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonOverHeatSwitchOff ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonOverHeatVentilate (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonOverHeatVentilate ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonControllerIsPiloting (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte piloting)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonControllerIsPiloting ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)piloting);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonWifiSettingsOutdoorSetting (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte outdoor)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonWifiSettingsOutdoorSetting ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)outdoor);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonMavlinkStart (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring filepath, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_filepath = (*env)->GetStringUTFChars (env, filepath, NULL);
    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINK_START_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateCommonMavlinkStart ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_filepath, j_type_enum);
    (*env)->ReleaseStringUTFChars (env, filepath, c_filepath);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonMavlinkPause (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonMavlinkPause ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonMavlinkStop (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonMavlinkStop ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCalibrationMagnetoCalibration (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte calibrate)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCalibrationMagnetoCalibration ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)calibrate);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonGPSControllerPositionForRun (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jdouble latitude, jdouble longitude)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonGPSControllerPositionForRun ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (double)latitude, (double)longitude);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAudioControllerReadyForStreaming (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte ready)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonAudioControllerReadyForStreaming ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)ready);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonHeadlightsIntensity (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte left, jbyte right)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonHeadlightsIntensity ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)left, (uint8_t)right);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAnimationsStartAnimation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject anim)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_anim_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_ENUM");
    jmethodID j_anim_mid = (*env)->GetMethodID (env, j_anim_class, "getValue", "()I");
    jint j_anim_enum = (*env)->CallIntMethod (env, anim, j_anim_mid);
    err = ARCOMMANDS_Generator_GenerateCommonAnimationsStartAnimation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_anim_enum);
    (*env)->DeleteLocalRef (env, j_anim_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAnimationsStopAnimation (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject anim)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_anim_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_ENUM");
    jmethodID j_anim_mid = (*env)->GetMethodID (env, j_anim_class, "getValue", "()I");
    jint j_anim_enum = (*env)->CallIntMethod (env, anim, j_anim_mid);
    err = ARCOMMANDS_Generator_GenerateCommonAnimationsStopAnimation ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_anim_enum);
    (*env)->DeleteLocalRef (env, j_anim_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAnimationsStopAllAnimations (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonAnimationsStopAllAnimations ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAccessoryConfig (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject accessory)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_accessory_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_ENUM");
    jmethodID j_accessory_mid = (*env)->GetMethodID (env, j_accessory_class, "getValue", "()I");
    jint j_accessory_enum = (*env)->CallIntMethod (env, accessory, j_accessory_mid);
    err = ARCOMMANDS_Generator_GenerateCommonAccessoryConfig ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_accessory_enum);
    (*env)->DeleteLocalRef (env, j_accessory_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonChargerSetMaxChargeRate (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject rate)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_ENUM");
    jmethodID j_rate_mid = (*env)->GetMethodID (env, j_rate_class, "getValue", "()I");
    jint j_rate_enum = (*env)->CallIntMethod (env, rate, j_rate_mid);
    err = ARCOMMANDS_Generator_GenerateCommonChargerSetMaxChargeRate ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_rate_enum);
    (*env)->DeleteLocalRef (env, j_rate_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonNetworkEventDisconnection (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject cause)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_cause_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_ENUM");
    jmethodID j_cause_mid = (*env)->GetMethodID (env, j_cause_class, "getValue", "()I");
    jint j_cause_enum = (*env)->CallIntMethod (env, cause, j_cause_mid);
    err = ARCOMMANDS_Generator_GenerateCommonNetworkEventDisconnection ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_cause_enum);
    (*env)->DeleteLocalRef (env, j_cause_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateAllSettingsChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateAllSettingsChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateResetChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateResetChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateProductNameChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateProductNameChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_name);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateProductVersionChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring software, jstring hardware)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_software = (*env)->GetStringUTFChars (env, software, NULL);
    const char *c_hardware = (*env)->GetStringUTFChars (env, hardware, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateProductVersionChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_software, c_hardware);
    (*env)->ReleaseStringUTFChars (env, software, c_software);
    (*env)->ReleaseStringUTFChars (env, hardware, c_hardware);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateProductSerialHighChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring high)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_high = (*env)->GetStringUTFChars (env, high, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateProductSerialHighChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_high);
    (*env)->ReleaseStringUTFChars (env, high, c_high);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateProductSerialLowChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring low)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_low = (*env)->GetStringUTFChars (env, low, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateProductSerialLowChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_low);
    (*env)->ReleaseStringUTFChars (env, low, c_low);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateCountryChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring code)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_code = (*env)->GetStringUTFChars (env, code, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateCountryChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_code);
    (*env)->ReleaseStringUTFChars (env, code, c_code);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonSettingsStateAutoCountryChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte automatic)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonSettingsStateAutoCountryChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)automatic);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateAllStatesChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonStateAllStatesChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateBatteryStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte percent)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonStateBatteryStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)percent);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateMassStorageStateListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte mass_storage_id, jstring name)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_name = (*env)->GetStringUTFChars (env, name, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageStateListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)mass_storage_id, c_name);
    (*env)->ReleaseStringUTFChars (env, name, c_name);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateMassStorageInfoStateListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte mass_storage_id, jint size, jint used_size, jbyte plugged, jbyte full, jbyte internal)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageInfoStateListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)mass_storage_id, (uint32_t)size, (uint32_t)used_size, (uint8_t)plugged, (uint8_t)full, (uint8_t)internal);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateCurrentDateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring date)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_date = (*env)->GetStringUTFChars (env, date, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonCommonStateCurrentDateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_date);
    (*env)->ReleaseStringUTFChars (env, date, c_date);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateCurrentTimeChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring time)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_time = (*env)->GetStringUTFChars (env, time, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonCommonStateCurrentTimeChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_time);
    (*env)->ReleaseStringUTFChars (env, time, c_time);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateMassStorageInfoRemainingListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jint free_space, jshort rec_time, jint photo_remaining)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonStateMassStorageInfoRemainingListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint32_t)free_space, (uint16_t)rec_time, (uint32_t)photo_remaining);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateWifiSignalChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort rssi)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCommonStateWifiSignalChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int16_t)rssi);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateSensorsStatesListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject sensorName, jbyte sensorState)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_sensorName_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_ENUM");
    jmethodID j_sensorName_mid = (*env)->GetMethodID (env, j_sensorName_class, "getValue", "()I");
    jint j_sensorName_enum = (*env)->CallIntMethod (env, sensorName, j_sensorName_mid);
    err = ARCOMMANDS_Generator_GenerateCommonCommonStateSensorsStatesListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_sensorName_enum, (uint8_t)sensorState);
    (*env)->DeleteLocalRef (env, j_sensorName_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateProductModel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject model)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_model_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_ENUM");
    jmethodID j_model_mid = (*env)->GetMethodID (env, j_model_class, "getValue", "()I");
    jint j_model_enum = (*env)->CallIntMethod (env, model, j_model_mid);
    err = ARCOMMANDS_Generator_GenerateCommonCommonStateProductModel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_model_enum);
    (*env)->DeleteLocalRef (env, j_model_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCommonStateCountryListKnown (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte listFlags, jstring countryCodes)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_countryCodes = (*env)->GetStringUTFChars (env, countryCodes, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonCommonStateCountryListKnown ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)listFlags, c_countryCodes);
    (*env)->ReleaseStringUTFChars (env, countryCodes, c_countryCodes);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonOverHeatStateOverHeatChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonOverHeatStateOverHeatChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonOverHeatStateOverHeatRegulationChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte regulationType)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonOverHeatStateOverHeatRegulationChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)regulationType);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonWifiSettingsStateOutdoorSettingsChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte outdoor)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonWifiSettingsStateOutdoorSettingsChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)outdoor);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonMavlinkStateMavlinkFilePlayingStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject state, jstring filepath, jobject type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    const char *c_filepath = (*env)->GetStringUTFChars (env, filepath, NULL);
    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    err = ARCOMMANDS_Generator_GenerateCommonMavlinkStateMavlinkFilePlayingStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_state_enum, c_filepath, j_type_enum);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->ReleaseStringUTFChars (env, filepath, c_filepath);
    (*env)->DeleteLocalRef (env, j_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonMavlinkStateMavlinkPlayErrorStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateCommonMavlinkStateMavlinkPlayErrorStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_error_enum);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCalibrationStateMagnetoCalibrationStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte xAxisCalibration, jbyte yAxisCalibration, jbyte zAxisCalibration, jbyte calibrationFailed)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)xAxisCalibration, (uint8_t)yAxisCalibration, (uint8_t)zAxisCalibration, (uint8_t)calibrationFailed);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCalibrationStateMagnetoCalibrationRequiredState (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte required)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationRequiredState ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)required);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject axis)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_axis_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_ENUM");
    jmethodID j_axis_mid = (*env)->GetMethodID (env, j_axis_class, "getValue", "()I");
    jint j_axis_enum = (*env)->CallIntMethod (env, axis, j_axis_mid);
    err = ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_axis_enum);
    (*env)->DeleteLocalRef (env, j_axis_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCalibrationStateMagnetoCalibrationStartedChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte started)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCalibrationStateMagnetoCalibrationStartedChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)started);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonCameraSettingsStateCameraSettingsChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jfloat fov, jfloat panMax, jfloat panMin, jfloat tiltMax, jfloat tiltMin)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonCameraSettingsStateCameraSettingsChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (float)fov, (float)panMax, (float)panMin, (float)tiltMax, (float)tiltMin);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonFlightPlanStateAvailabilityStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte AvailabilityState)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonFlightPlanStateAvailabilityStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)AvailabilityState);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonFlightPlanStateComponentStateListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject component, jbyte State)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_component_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_ENUM");
    jmethodID j_component_mid = (*env)->GetMethodID (env, j_component_class, "getValue", "()I");
    jint j_component_enum = (*env)->CallIntMethod (env, component, j_component_mid);
    err = ARCOMMANDS_Generator_GenerateCommonFlightPlanStateComponentStateListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_component_enum, (uint8_t)State);
    (*env)->DeleteLocalRef (env, j_component_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonFlightPlanEventStartingErrorEvent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonFlightPlanEventStartingErrorEvent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonFlightPlanEventSpeedBridleEvent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonFlightPlanEventSpeedBridleEvent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonARLibsVersionsStateControllerLibARCommandsVersion (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring version)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_version = (*env)->GetStringUTFChars (env, version, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateControllerLibARCommandsVersion ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_version);
    (*env)->ReleaseStringUTFChars (env, version, c_version);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonARLibsVersionsStateSkyControllerLibARCommandsVersion (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring version)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_version = (*env)->GetStringUTFChars (env, version, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateSkyControllerLibARCommandsVersion ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_version);
    (*env)->ReleaseStringUTFChars (env, version, c_version);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonARLibsVersionsStateDeviceLibARCommandsVersion (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring version)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_version = (*env)->GetStringUTFChars (env, version, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonARLibsVersionsStateDeviceLibARCommandsVersion ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_version);
    (*env)->ReleaseStringUTFChars (env, version, c_version);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAudioStateAudioStreamingRunning (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte running)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonAudioStateAudioStreamingRunning ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)running);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonHeadlightsStateIntensityChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte left, jbyte right)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonHeadlightsStateIntensityChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)left, (uint8_t)right);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAnimationsStateList (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject anim, jobject state, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_anim_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_ENUM");
    jmethodID j_anim_mid = (*env)->GetMethodID (env, j_anim_class, "getValue", "()I");
    jint j_anim_enum = (*env)->CallIntMethod (env, anim, j_anim_mid);
    jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_ENUM");
    jmethodID j_state_mid = (*env)->GetMethodID (env, j_state_class, "getValue", "()I");
    jint j_state_enum = (*env)->CallIntMethod (env, state, j_state_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateCommonAnimationsStateList ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_anim_enum, j_state_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_anim_class);
    (*env)->DeleteLocalRef (env, j_state_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAccessoryStateSupportedAccessoriesListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject accessory)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_accessory_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_ENUM");
    jmethodID j_accessory_mid = (*env)->GetMethodID (env, j_accessory_class, "getValue", "()I");
    jint j_accessory_enum = (*env)->CallIntMethod (env, accessory, j_accessory_mid);
    err = ARCOMMANDS_Generator_GenerateCommonAccessoryStateSupportedAccessoriesListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_accessory_enum);
    (*env)->DeleteLocalRef (env, j_accessory_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAccessoryStateAccessoryConfigChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject newAccessory, jobject error)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_newAccessory_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_ENUM");
    jmethodID j_newAccessory_mid = (*env)->GetMethodID (env, j_newAccessory_class, "getValue", "()I");
    jint j_newAccessory_enum = (*env)->CallIntMethod (env, newAccessory, j_newAccessory_mid);
    jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_ENUM");
    jmethodID j_error_mid = (*env)->GetMethodID (env, j_error_class, "getValue", "()I");
    jint j_error_enum = (*env)->CallIntMethod (env, error, j_error_mid);
    err = ARCOMMANDS_Generator_GenerateCommonAccessoryStateAccessoryConfigChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_newAccessory_enum, j_error_enum);
    (*env)->DeleteLocalRef (env, j_newAccessory_class);
    (*env)->DeleteLocalRef (env, j_error_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonAccessoryStateAccessoryConfigModificationEnabled (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte enabled)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonAccessoryStateAccessoryConfigModificationEnabled ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)enabled);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonChargerStateMaxChargeRateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject rate)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_ENUM");
    jmethodID j_rate_mid = (*env)->GetMethodID (env, j_rate_class, "getValue", "()I");
    jint j_rate_enum = (*env)->CallIntMethod (env, rate, j_rate_mid);
    err = ARCOMMANDS_Generator_GenerateCommonChargerStateMaxChargeRateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_rate_enum);
    (*env)->DeleteLocalRef (env, j_rate_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonChargerStateCurrentChargeStateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject status, jobject phase)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_ENUM");
    jmethodID j_status_mid = (*env)->GetMethodID (env, j_status_class, "getValue", "()I");
    jint j_status_enum = (*env)->CallIntMethod (env, status, j_status_mid);
    jclass j_phase_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_ENUM");
    jmethodID j_phase_mid = (*env)->GetMethodID (env, j_phase_class, "getValue", "()I");
    jint j_phase_enum = (*env)->CallIntMethod (env, phase, j_phase_mid);
    err = ARCOMMANDS_Generator_GenerateCommonChargerStateCurrentChargeStateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_status_enum, j_phase_enum);
    (*env)->DeleteLocalRef (env, j_status_class);
    (*env)->DeleteLocalRef (env, j_phase_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonChargerStateLastChargeRateChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject rate)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_ENUM");
    jmethodID j_rate_mid = (*env)->GetMethodID (env, j_rate_class, "getValue", "()I");
    jint j_rate_enum = (*env)->CallIntMethod (env, rate, j_rate_mid);
    err = ARCOMMANDS_Generator_GenerateCommonChargerStateLastChargeRateChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_rate_enum);
    (*env)->DeleteLocalRef (env, j_rate_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonChargerStateChargingInfo (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject phase, jobject rate, jbyte intensity, jbyte fullChargingTime)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_phase_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_ENUM");
    jmethodID j_phase_mid = (*env)->GetMethodID (env, j_phase_class, "getValue", "()I");
    jint j_phase_enum = (*env)->CallIntMethod (env, phase, j_phase_mid);
    jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_ENUM");
    jmethodID j_rate_mid = (*env)->GetMethodID (env, j_rate_class, "getValue", "()I");
    jint j_rate_enum = (*env)->CallIntMethod (env, rate, j_rate_mid);
    err = ARCOMMANDS_Generator_GenerateCommonChargerStateChargingInfo ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_phase_enum, j_rate_enum, (uint8_t)intensity, (uint8_t)fullChargingTime);
    (*env)->DeleteLocalRef (env, j_phase_class);
    (*env)->DeleteLocalRef (env, j_rate_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonRunStateRunIdChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring runId)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_runId = (*env)->GetStringUTFChars (env, runId, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonRunStateRunIdChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_runId);
    (*env)->ReleaseStringUTFChars (env, runId, c_runId);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugStatsSendPacket (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring packet)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_packet = (*env)->GetStringUTFChars (env, packet, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonDebugStatsSendPacket ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_packet);
    (*env)->ReleaseStringUTFChars (env, packet, c_packet);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugStatsStartSendingPacketFromDrone (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte frequency, jbyte packetSize, jint date)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonDebugStatsStartSendingPacketFromDrone ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)frequency, (uint8_t)packetSize, (uint32_t)date);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugStatsStopSendingPacketFromDrone (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonDebugStatsStopSendingPacketFromDrone ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugDebugSettingsGetAll (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsGetAll ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugDebugSettingsSet (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort id, jstring value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_value = (*env)->GetStringUTFChars (env, value, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsSet ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)id, c_value);
    (*env)->ReleaseStringUTFChars (env, value, c_value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugStatsEventSendPacket (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring packet)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_packet = (*env)->GetStringUTFChars (env, packet, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonDebugStatsEventSendPacket ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_packet);
    (*env)->ReleaseStringUTFChars (env, packet, c_packet);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugDebugSettingsStateInfo (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte listFlags, jshort id, jstring label, jobject type, jobject mode, jstring range_min, jstring range_max, jstring range_step, jstring value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_label = (*env)->GetStringUTFChars (env, label, NULL);
    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_ENUM");
    jmethodID j_mode_mid = (*env)->GetMethodID (env, j_mode_class, "getValue", "()I");
    jint j_mode_enum = (*env)->CallIntMethod (env, mode, j_mode_mid);
    const char *c_range_min = (*env)->GetStringUTFChars (env, range_min, NULL);
    const char *c_range_max = (*env)->GetStringUTFChars (env, range_max, NULL);
    const char *c_range_step = (*env)->GetStringUTFChars (env, range_step, NULL);
    const char *c_value = (*env)->GetStringUTFChars (env, value, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsStateInfo ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)listFlags, (uint16_t)id, c_label, j_type_enum, j_mode_enum, c_range_min, c_range_max, c_range_step, c_value);
    (*env)->ReleaseStringUTFChars (env, label, c_label);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_mode_class);
    (*env)->ReleaseStringUTFChars (env, range_min, c_range_min);
    (*env)->ReleaseStringUTFChars (env, range_max, c_range_max);
    (*env)->ReleaseStringUTFChars (env, range_step, c_range_step);
    (*env)->ReleaseStringUTFChars (env, value, c_value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetCommonDebugDebugSettingsStateListChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort id, jstring value)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_value = (*env)->GetStringUTFChars (env, value, NULL);
    err = ARCOMMANDS_Generator_GenerateCommonDebugDebugSettingsStateListChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint16_t)id, c_value);
    (*env)->ReleaseStringUTFChars (env, value, c_value);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetProProBoughtFeatures (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jlong features)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateProProBoughtFeatures ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint64_t)features);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetProProResponse (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte listFlags, jstring signedChallenge)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_signedChallenge = (*env)->GetStringUTFChars (env, signedChallenge, NULL);
    err = ARCOMMANDS_Generator_GenerateProProResponse ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)listFlags, c_signedChallenge);
    (*env)->ReleaseStringUTFChars (env, signedChallenge, c_signedChallenge);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetProProActivateFeatures (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jlong features)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateProProActivateFeatures ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint64_t)features);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetProProStateSupportedFeatures (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject status, jlong features)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_ENUM");
    jmethodID j_status_mid = (*env)->GetMethodID (env, j_status_class, "getValue", "()I");
    jint j_status_enum = (*env)->CallIntMethod (env, status, j_status_mid);
    err = ARCOMMANDS_Generator_GenerateProProStateSupportedFeatures ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_status_enum, (uint64_t)features);
    (*env)->DeleteLocalRef (env, j_status_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetProProStateFeaturesActivated (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jlong features)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateProProStateFeaturesActivated ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint64_t)features);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetProProEventChallengeEvent (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring challenge)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_challenge = (*env)->GetStringUTFChars (env, challenge, NULL);
    err = ARCOMMANDS_Generator_GenerateProProEventChallengeEvent ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_challenge);
    (*env)->ReleaseStringUTFChars (env, challenge, c_challenge);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiScan (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jbyte band)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateWifiScan ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (uint8_t)band);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiUpdateAuthorizedChannels (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateWifiUpdateAuthorizedChannels ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiSetApChannel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateWifiSetApChannel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiSetSecurity (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jstring key, jobject key_type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    const char *c_key = (*env)->GetStringUTFChars (env, key, NULL);
    jclass j_key_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_KEY_TYPE_ENUM");
    jmethodID j_key_type_mid = (*env)->GetMethodID (env, j_key_type_class, "getValue", "()I");
    jint j_key_type_enum = (*env)->CallIntMethod (env, key_type, j_key_type_mid);
    err = ARCOMMANDS_Generator_GenerateWifiSetSecurity ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, c_key, j_key_type_enum);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->ReleaseStringUTFChars (env, key, c_key);
    (*env)->DeleteLocalRef (env, j_key_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiSetCountry (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject selection_mode, jstring code)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_selection_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM");
    jmethodID j_selection_mode_mid = (*env)->GetMethodID (env, j_selection_mode_class, "getValue", "()I");
    jint j_selection_mode_enum = (*env)->CallIntMethod (env, selection_mode, j_selection_mode_mid);
    const char *c_code = (*env)->GetStringUTFChars (env, code, NULL);
    err = ARCOMMANDS_Generator_GenerateWifiSetCountry ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_selection_mode_enum, c_code);
    (*env)->DeleteLocalRef (env, j_selection_mode_class);
    (*env)->ReleaseStringUTFChars (env, code, c_code);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiSetEnvironement (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject environement)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_environement_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM");
    jmethodID j_environement_mid = (*env)->GetMethodID (env, j_environement_class, "getValue", "()I");
    jint j_environement_enum = (*env)->CallIntMethod (env, environement, j_environement_mid);
    err = ARCOMMANDS_Generator_GenerateWifiSetEnvironement ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_environement_enum);
    (*env)->DeleteLocalRef (env, j_environement_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiScannedItem (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring ssid, jshort rssi, jobject band, jbyte channel, jbyte list_flags)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_ssid = (*env)->GetStringUTFChars (env, ssid, NULL);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateWifiScannedItem ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_ssid, (int16_t)rssi, j_band_enum, (uint8_t)channel, (uint8_t)list_flags);
    (*env)->ReleaseStringUTFChars (env, ssid, c_ssid);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiAuthorizedChannel (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject band, jbyte channel, jbyte environement, jbyte list_flags)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateWifiAuthorizedChannel ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_band_enum, (uint8_t)channel, (uint8_t)environement, (uint8_t)list_flags);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiApChannelChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject type, jobject band, jbyte channel)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM");
    jmethodID j_type_mid = (*env)->GetMethodID (env, j_type_class, "getValue", "()I");
    jint j_type_enum = (*env)->CallIntMethod (env, type, j_type_mid);
    jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
    jmethodID j_band_mid = (*env)->GetMethodID (env, j_band_class, "getValue", "()I");
    jint j_band_enum = (*env)->CallIntMethod (env, band, j_band_mid);
    err = ARCOMMANDS_Generator_GenerateWifiApChannelChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_type_enum, j_band_enum, (uint8_t)channel);
    (*env)->DeleteLocalRef (env, j_type_class);
    (*env)->DeleteLocalRef (env, j_band_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiSecurityChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jstring key, jobject key_type)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    const char *c_key = (*env)->GetStringUTFChars (env, key, NULL);
    jclass j_key_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM");
    jmethodID j_key_type_mid = (*env)->GetMethodID (env, j_key_type_class, "getValue", "()I");
    jint j_key_type_enum = (*env)->CallIntMethod (env, key_type, j_key_type_mid);
    err = ARCOMMANDS_Generator_GenerateWifiSecurityChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, c_key, j_key_type_enum);
    (*env)->ReleaseStringUTFChars (env, key, c_key);
    (*env)->DeleteLocalRef (env, j_key_type_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiCountryChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject selection_mode, jstring code)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_selection_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM");
    jmethodID j_selection_mode_mid = (*env)->GetMethodID (env, j_selection_mode_class, "getValue", "()I");
    jint j_selection_mode_enum = (*env)->CallIntMethod (env, selection_mode, j_selection_mode_mid);
    const char *c_code = (*env)->GetStringUTFChars (env, code, NULL);
    err = ARCOMMANDS_Generator_GenerateWifiCountryChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_selection_mode_enum, c_code);
    (*env)->DeleteLocalRef (env, j_selection_mode_class);
    (*env)->ReleaseStringUTFChars (env, code, c_code);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiEnvironementChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jobject environement)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    jclass j_environement_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM");
    jmethodID j_environement_mid = (*env)->GetMethodID (env, j_environement_class, "getValue", "()I");
    jint j_environement_enum = (*env)->CallIntMethod (env, environement, j_environement_mid);
    err = ARCOMMANDS_Generator_GenerateWifiEnvironementChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, j_environement_enum);
    (*env)->DeleteLocalRef (env, j_environement_class);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}

JNIEXPORT jint JNICALL
Java_com_parrot_arsdk_arcommands_ARCommand_nativeSetWifiRssiChanged (JNIEnv *env, jobject thizz, jlong c_pdata, jint dataLen, jshort rssi)
{
    int32_t c_dataSize = 0;
    eARCOMMANDS_GENERATOR_ERROR err = ARCOMMANDS_GENERATOR_ERROR;
    if (g_dataSize_id == 0)
    {
        jclass clz = (*env)->GetObjectClass (env, thizz);
        if (clz != 0)
        {
            g_dataSize_id = (*env)->GetFieldID (env, clz, "used", "I");
            (*env)->DeleteLocalRef (env, clz);
        }
        else
        {
            return err;
        }
    }

    err = ARCOMMANDS_Generator_GenerateWifiRssiChanged ((uint8_t *) (intptr_t) c_pdata, dataLen, &c_dataSize, (int16_t)rssi);
    if (err == ARCOMMANDS_GENERATOR_OK)
    {
        (*env)->SetIntField (env, thizz, g_dataSize_id, (jint)c_dataSize);
    }
    return err;
}


void ARCOMMANDS_JNI_GenericDefaultnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandGenericDefaultListener", "Lcom/parrot/arsdk/arcommands/ARCommandGenericDefaultListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onGenericDefaultUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_ARDrone3PilotingFlatTrimnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingFlatTrimListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingFlatTrimListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingFlatTrimUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingTakeOffnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingTakeOffListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingTakeOffListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingTakeOffUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingPCMDnativeCb (uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestampAndSeqNum, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingPCMDListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingPCMDListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingPCMDUpdate", "(BBBBBI)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)flag, roll, pitch, yaw, gaz, (jint)timestampAndSeqNum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingLandingnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingLandingListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingLandingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingLandingUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingEmergencynativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingEmergencyListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingEmergencyListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingEmergencyUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingNavigateHomenativeCb (uint8_t start, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingNavigateHomeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingNavigateHomeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingNavigateHomeUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingAutoTakeOffModenativeCb (uint8_t state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingAutoTakeOffModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingAutoTakeOffModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingAutoTakeOffModeUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingMoveBynativeCb (float dX, float dY, float dZ, float dPsi, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingMoveByListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingMoveByListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingMoveByUpdate", "(FFFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, dX, dY, dZ, dPsi);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingUserTakeOffnativeCb (uint8_t state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingUserTakeOffListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingUserTakeOffListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingUserTakeOffUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingCirclenativeCb (eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION direction, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingCircleListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingCircleListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingCircleUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_direction_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_ENUM");
        jmethodID j_direction_mid = (*env)->GetStaticMethodID (env, j_direction_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION_ENUM;");
        jobject j_direction_enum = (*env)->CallStaticObjectMethod (env, j_direction_class, j_direction_mid, direction);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_direction_enum);
        (*env)->DeleteLocalRef (env, j_direction_class);
        (*env)->DeleteLocalRef (env, j_direction_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3AnimationsFlipnativeCb (eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION direction, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3AnimationsFlipListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3AnimationsFlipListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3AnimationsFlipUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_direction_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_ENUM");
        jmethodID j_direction_mid = (*env)->GetStaticMethodID (env, j_direction_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION_ENUM;");
        jobject j_direction_enum = (*env)->CallStaticObjectMethod (env, j_direction_class, j_direction_mid, direction);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_direction_enum);
        (*env)->DeleteLocalRef (env, j_direction_class);
        (*env)->DeleteLocalRef (env, j_direction_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3CameraOrientationnativeCb (int8_t tilt, int8_t pan, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3CameraOrientationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3CameraOrientationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3CameraOrientationUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, tilt, pan);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordPicturenativeCb (uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordPictureListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordPictureListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordPictureUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordVideonativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordVideoListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordVideoListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordVideoUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_ENUM");
        jmethodID j_record_mid = (*env)->GetStaticMethodID (env, j_record_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD_ENUM;");
        jobject j_record_enum = (*env)->CallStaticObjectMethod (env, j_record_class, j_record_mid, record);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_record_enum, (jbyte)mass_storage_id);
        (*env)->DeleteLocalRef (env, j_record_class);
        (*env)->DeleteLocalRef (env, j_record_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordPictureV2nativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordPictureV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordPictureV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordPictureV2Update", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordVideoV2nativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD record, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordVideoV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordVideoV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordVideoV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_ENUM");
        jmethodID j_record_mid = (*env)->GetStaticMethodID (env, j_record_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD_ENUM;");
        jobject j_record_enum = (*env)->CallStaticObjectMethod (env, j_record_class, j_record_mid, record);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_record_enum);
        (*env)->DeleteLocalRef (env, j_record_class);
        (*env)->DeleteLocalRef (env, j_record_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkWifiScannativeCb (eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND band, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkWifiScanListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkWifiScanListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkWifiScanUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_band_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkWifiAuthChannelnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkWifiAuthChannelListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkWifiAuthChannelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkWifiAuthChannelUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsMaxAltitudenativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsMaxAltitudeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsMaxAltitudeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsMaxAltitudeUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsMaxTiltnativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsMaxTiltListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsMaxTiltListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsMaxTiltUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsAbsolutControlnativeCb (uint8_t on, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsAbsolutControlListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsAbsolutControlListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsAbsolutControlUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)on);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsMaxDistancenativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsMaxDistanceListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsMaxDistanceListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsMaxDistanceUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsNoFlyOverMaxDistancenativeCb (uint8_t shouldNotFlyOver, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsNoFlyOverMaxDistanceListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsNoFlyOverMaxDistanceListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsNoFlyOverMaxDistanceUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)shouldNotFlyOver);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeednativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeednativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationnativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationnativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeednativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsBankedTurnnativeCb (uint8_t value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsBankedTurnListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsBankedTurnListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsBankedTurnUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsMinAltitudenativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsMinAltitudeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsMinAltitudeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsMinAltitudeUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsCirclingDirectionnativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsCirclingDirectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsCirclingDirectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsCirclingDirectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_ENUM");
        jmethodID j_value_mid = (*env)->GetStaticMethodID (env, j_value_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE_ENUM;");
        jobject j_value_enum = (*env)->CallStaticObjectMethod (env, j_value_class, j_value_mid, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_value_enum);
        (*env)->DeleteLocalRef (env, j_value_class);
        (*env)->DeleteLocalRef (env, j_value_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsCirclingRadiusnativeCb (uint16_t value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsCirclingRadiusListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsCirclingRadiusListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsCirclingRadiusUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsCirclingAltitudenativeCb (uint16_t value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsCirclingAltitudeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsCirclingAltitudeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsCirclingAltitudeUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsPitchModenativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsPitchModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsPitchModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsPitchModeUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_ENUM");
        jmethodID j_value_mid = (*env)->GetStaticMethodID (env, j_value_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE_ENUM;");
        jobject j_value_enum = (*env)->CallStaticObjectMethod (env, j_value_class, j_value_mid, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_value_enum);
        (*env)->DeleteLocalRef (env, j_value_class);
        (*env)->DeleteLocalRef (env, j_value_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsLandingModenativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsLandingModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsLandingModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsLandingModeUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_ENUM");
        jmethodID j_value_mid = (*env)->GetStaticMethodID (env, j_value_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE_ENUM;");
        jobject j_value_enum = (*env)->CallStaticObjectMethod (env, j_value_class, j_value_mid, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_value_enum);
        (*env)->DeleteLocalRef (env, j_value_class);
        (*env)->DeleteLocalRef (env, j_value_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsMaxVerticalSpeednativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsMaxVerticalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsMaxVerticalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsMaxVerticalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsMaxRotationSpeednativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsMaxRotationSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsMaxRotationSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsMaxRotationSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsHullProtectionnativeCb (uint8_t present, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsHullProtectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsHullProtectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsHullProtectionUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)present);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsOutdoornativeCb (uint8_t outdoor, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsOutdoorListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsOutdoorListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsOutdoorUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)outdoor);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsMaxPitchRollRotationSpeednativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsMaxPitchRollRotationSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsMaxPitchRollRotationSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsMaxPitchRollRotationSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkSettingsWifiSelectionnativeCb (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkSettingsWifiSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkSettingsWifiSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkSettingsWifiSelectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkSettingsWifiSecuritynativeCb (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE type, char * key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE keyType, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkSettingsWifiSecurityListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkSettingsWifiSecurityListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkSettingsWifiSecurityUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_ENUM;Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jstring j_key = (*env)->NewStringUTF (env, key);
        jclass j_keyType_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE_ENUM");
        jmethodID j_keyType_mid = (*env)->GetStaticMethodID (env, j_keyType_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE_ENUM;");
        jobject j_keyType_enum = (*env)->CallStaticObjectMethod (env, j_keyType_class, j_keyType_mid, keyType);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_key, j_keyType_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_key);
        (*env)->DeleteLocalRef (env, j_keyType_class);
        (*env)->DeleteLocalRef (env, j_keyType_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsPictureFormatSelectionnativeCb (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsPictureFormatSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsPictureFormatSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsPictureFormatSelectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsAutoWhiteBalanceSelectionnativeCb (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsAutoWhiteBalanceSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsAutoWhiteBalanceSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsAutoWhiteBalanceSelectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsExpositionSelectionnativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsExpositionSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsExpositionSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsExpositionSelectionUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsSaturationSelectionnativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsSaturationSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsSaturationSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsSaturationSelectionUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsTimelapseSelectionnativeCb (uint8_t enabled, float interval, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsTimelapseSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsTimelapseSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsTimelapseSelectionUpdate", "(BF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled, interval);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsVideoAutorecordSelectionnativeCb (uint8_t enabled, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsVideoAutorecordSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsVideoAutorecordSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsVideoAutorecordSelectionUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsVideoStabilizationModenativeCb (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE mode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsVideoStabilizationModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsVideoStabilizationModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsVideoStabilizationModeUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_ENUM");
        jmethodID j_mode_mid = (*env)->GetStaticMethodID (env, j_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE_ENUM;");
        jobject j_mode_enum = (*env)->CallStaticObjectMethod (env, j_mode_class, j_mode_mid, mode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_mode_enum);
        (*env)->DeleteLocalRef (env, j_mode_class);
        (*env)->DeleteLocalRef (env, j_mode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaStreamingVideoEnablenativeCb (uint8_t enable, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaStreamingVideoEnableListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaStreamingVideoEnableListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaStreamingVideoEnableUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enable);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsSetHomenativeCb (double latitude, double longitude, double altitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsSetHomeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsSetHomeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsSetHomeUpdate", "(DDD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsResetHomenativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsResetHomeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsResetHomeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsResetHomeUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsSendControllerGPSnativeCb (double latitude, double longitude, double altitude, double horizontalAccuracy, double verticalAccuracy, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsSendControllerGPSListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsSendControllerGPSListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsSendControllerGPSUpdate", "(DDDDD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude, horizontalAccuracy, verticalAccuracy);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsHomeTypenativeCb (eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsHomeTypeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsHomeTypeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsHomeTypeUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsReturnHomeDelaynativeCb (uint16_t delay, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsReturnHomeDelayListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsReturnHomeDelayListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsReturnHomeDelayUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)delay);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3AntiflickeringElectricFrequencynativeCb (eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY frequency, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3AntiflickeringElectricFrequencyListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3AntiflickeringElectricFrequencyListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3AntiflickeringElectricFrequencyUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_frequency_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_ENUM");
        jmethodID j_frequency_mid = (*env)->GetStaticMethodID (env, j_frequency_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY_ENUM;");
        jobject j_frequency_enum = (*env)->CallStaticObjectMethod (env, j_frequency_class, j_frequency_mid, frequency);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_frequency_enum);
        (*env)->DeleteLocalRef (env, j_frequency_class);
        (*env)->DeleteLocalRef (env, j_frequency_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3AntiflickeringSetModenativeCb (eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE mode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3AntiflickeringSetModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3AntiflickeringSetModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3AntiflickeringSetModeUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_ENUM");
        jmethodID j_mode_mid = (*env)->GetStaticMethodID (env, j_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE_ENUM;");
        jobject j_mode_enum = (*env)->CallStaticObjectMethod (env, j_mode_class, j_mode_mid, mode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_mode_enum);
        (*env)->DeleteLocalRef (env, j_mode_class);
        (*env)->DeleteLocalRef (env, j_mode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordStatePictureStateChangednativeCb (uint8_t state, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordStatePictureStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordStatePictureStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordStatePictureStateChangedUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordStateVideoStateChangednativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE state, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordStateVideoStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordStateVideoStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordStateVideoStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, (jbyte)mass_storage_id);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordStatePictureStateChangedV2nativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordStatePictureStateChangedV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordStatePictureStateChangedV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordStatePictureStateChangedV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordStateVideoStateChangedV2nativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordStateVideoStateChangedV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordStateVideoStateChangedV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordStateVideoStateChangedV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordEventPictureEventChangednativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordEventPictureEventChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordEventPictureEventChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordEventPictureEventChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM");
        jmethodID j_event_mid = (*env)->GetStaticMethodID (env, j_event_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM;");
        jobject j_event_enum = (*env)->CallStaticObjectMethod (env, j_event_class, j_event_mid, event);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_event_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_event_class);
        (*env)->DeleteLocalRef (env, j_event_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaRecordEventVideoEventChangednativeCb (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaRecordEventVideoEventChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaRecordEventVideoEventChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaRecordEventVideoEventChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM");
        jmethodID j_event_mid = (*env)->GetStaticMethodID (env, j_event_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM;");
        jobject j_event_enum = (*env)->CallStaticObjectMethod (env, j_event_class, j_event_mid, event);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_event_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_event_class);
        (*env)->DeleteLocalRef (env, j_event_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateFlatTrimChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateFlatTrimChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateFlatTrimChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateFlatTrimChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateFlyingStateChangednativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateFlyingStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateFlyingStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateFlyingStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateAlertStateChangednativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateAlertStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateAlertStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateAlertStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateNavigateHomeStateChangednativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE state, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON reason, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateNavigateHomeStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateNavigateHomeStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateNavigateHomeStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_reason_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_ENUM");
        jmethodID j_reason_mid = (*env)->GetStaticMethodID (env, j_reason_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON_ENUM;");
        jobject j_reason_enum = (*env)->CallStaticObjectMethod (env, j_reason_class, j_reason_mid, reason);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_reason_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_reason_class);
        (*env)->DeleteLocalRef (env, j_reason_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStatePositionChangednativeCb (double latitude, double longitude, double altitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStatePositionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStatePositionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStatePositionChangedUpdate", "(DDD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateSpeedChangednativeCb (float speedX, float speedY, float speedZ, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, speedX, speedY, speedZ);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateAttitudeChangednativeCb (float roll, float pitch, float yaw, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateAttitudeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateAttitudeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateAttitudeChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, roll, pitch, yaw);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateAutoTakeOffModeChangednativeCb (uint8_t state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateAutoTakeOffModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateAutoTakeOffModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateAutoTakeOffModeChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingStateAltitudeChangednativeCb (double altitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingStateAltitudeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingStateAltitudeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingStateAltitudeChangedUpdate", "(D)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, altitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingEventMoveByEndnativeCb (float dX, float dY, float dZ, float dPsi, eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingEventMoveByEndListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingEventMoveByEndListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingEventMoveByEndUpdate", "(FFFFLcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, dX, dY, dZ, dPsi, j_error_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkStateWifiScanListChangednativeCb (char * ssid, int16_t rssi, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkStateWifiScanListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkStateWifiScanListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkStateWifiScanListChangedUpdate", "(Ljava/lang/String;SLcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid, rssi, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_ssid);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkStateAllWifiScanChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkStateAllWifiScanChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkStateAllWifiScanChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkStateAllWifiScanChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkStateWifiAuthChannelListChangednativeCb (eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND band, uint8_t channel, uint8_t in_or_out, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkStateWifiAuthChannelListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkStateWifiAuthChannelListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkStateWifiAuthChannelListChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM;BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_band_enum, (jbyte)channel, (jbyte)in_or_out);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkStateAllWifiAuthChannelChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkStateAllWifiAuthChannelChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkStateAllWifiAuthChannelChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkStateAllWifiAuthChannelChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMaxAltitudeChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateMaxAltitudeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateMaxAltitudeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateMaxAltitudeChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMaxTiltChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateMaxTiltChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateMaxTiltChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateMaxTiltChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAbsolutControlChangednativeCb (uint8_t on, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateAbsolutControlChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateAbsolutControlChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateAbsolutControlChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)on);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMaxDistanceChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateMaxDistanceChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateMaxDistanceChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateMaxDistanceChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangednativeCb (uint8_t shouldNotFlyOver, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)shouldNotFlyOver);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeednativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeednativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationnativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationnativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeednativeCb (float value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateBankedTurnChangednativeCb (uint8_t state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateBankedTurnChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateBankedTurnChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateBankedTurnChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMinAltitudeChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateMinAltitudeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateMinAltitudeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateMinAltitudeChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateCirclingDirectionChangednativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateCirclingDirectionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateCirclingDirectionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateCirclingDirectionChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_ENUM");
        jmethodID j_value_mid = (*env)->GetStaticMethodID (env, j_value_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE_ENUM;");
        jobject j_value_enum = (*env)->CallStaticObjectMethod (env, j_value_class, j_value_mid, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_value_enum);
        (*env)->DeleteLocalRef (env, j_value_class);
        (*env)->DeleteLocalRef (env, j_value_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateCirclingRadiusChangednativeCb (uint16_t current, uint16_t min, uint16_t max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateCirclingRadiusChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateCirclingRadiusChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateCirclingRadiusChangedUpdate", "(SSS)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)current, (jshort)min, (jshort)max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateCirclingAltitudeChangednativeCb (uint16_t current, uint16_t min, uint16_t max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateCirclingAltitudeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateCirclingAltitudeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateCirclingAltitudeChangedUpdate", "(SSS)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)current, (jshort)min, (jshort)max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStatePitchModeChangednativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStatePitchModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStatePitchModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStatePitchModeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_ENUM");
        jmethodID j_value_mid = (*env)->GetStaticMethodID (env, j_value_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE_ENUM;");
        jobject j_value_enum = (*env)->CallStaticObjectMethod (env, j_value_class, j_value_mid, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_value_enum);
        (*env)->DeleteLocalRef (env, j_value_class);
        (*env)->DeleteLocalRef (env, j_value_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateLandingModeChangednativeCb (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PilotingSettingsStateLandingModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PilotingSettingsStateLandingModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PilotingSettingsStateLandingModeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_value_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_ENUM");
        jmethodID j_value_mid = (*env)->GetStaticMethodID (env, j_value_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE_ENUM;");
        jobject j_value_enum = (*env)->CallStaticObjectMethod (env, j_value_class, j_value_mid, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_value_enum);
        (*env)->DeleteLocalRef (env, j_value_class);
        (*env)->DeleteLocalRef (env, j_value_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsStateMaxVerticalSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsStateMaxVerticalSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsStateMaxVerticalSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateMaxRotationSpeedChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsStateMaxRotationSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsStateMaxRotationSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsStateMaxRotationSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateHullProtectionChangednativeCb (uint8_t present, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsStateHullProtectionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsStateHullProtectionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsStateHullProtectionChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)present);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateOutdoorChangednativeCb (uint8_t outdoor, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsStateOutdoorChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsStateOutdoorChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsStateOutdoorChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)outdoor);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkSettingsStateWifiSelectionChangednativeCb (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkSettingsStateWifiSelectionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkSettingsStateWifiSelectionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkSettingsStateWifiSelectionChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkSettingsStateWifiSecurityChangednativeCb (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkSettingsStateWifiSecurityChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkSettingsStateWifiSecurityChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkSettingsStateWifiSecurityChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3NetworkSettingsStateWifiSecuritynativeCb (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE type, char * key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE keyType, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3NetworkSettingsStateWifiSecurityListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3NetworkSettingsStateWifiSecurityListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3NetworkSettingsStateWifiSecurityUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_ENUM;Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jstring j_key = (*env)->NewStringUTF (env, key);
        jclass j_keyType_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE_ENUM");
        jmethodID j_keyType_mid = (*env)->GetStaticMethodID (env, j_keyType_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE_ENUM;");
        jobject j_keyType_enum = (*env)->CallStaticObjectMethod (env, j_keyType_class, j_keyType_mid, keyType);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_key, j_keyType_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_key);
        (*env)->DeleteLocalRef (env, j_keyType_class);
        (*env)->DeleteLocalRef (env, j_keyType_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateProductMotorVersionListChangednativeCb (uint8_t motor_number, char * type, char * software, char * hardware, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateProductMotorVersionListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateProductMotorVersionListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateProductMotorVersionListChangedUpdate", "(BLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_type = (*env)->NewStringUTF (env, type);
        jstring j_software = (*env)->NewStringUTF (env, software);
        jstring j_hardware = (*env)->NewStringUTF (env, hardware);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)motor_number, j_type, j_software, j_hardware);
        (*env)->DeleteLocalRef (env, j_type);
        (*env)->DeleteLocalRef (env, j_software);
        (*env)->DeleteLocalRef (env, j_hardware);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateProductGPSVersionChangednativeCb (char * software, char * hardware, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateProductGPSVersionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateProductGPSVersionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateProductGPSVersionChangedUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_software = (*env)->NewStringUTF (env, software);
        jstring j_hardware = (*env)->NewStringUTF (env, hardware);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_software, j_hardware);
        (*env)->DeleteLocalRef (env, j_software);
        (*env)->DeleteLocalRef (env, j_hardware);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateMotorErrorStateChangednativeCb (uint8_t motorIds, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR motorError, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateMotorErrorStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateMotorErrorStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateMotorErrorStateChangedUpdate", "(BLcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_motorError_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ENUM");
        jmethodID j_motorError_mid = (*env)->GetStaticMethodID (env, j_motorError_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR_ENUM;");
        jobject j_motorError_enum = (*env)->CallStaticObjectMethod (env, j_motorError_class, j_motorError_mid, motorError);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)motorIds, j_motorError_enum);
        (*env)->DeleteLocalRef (env, j_motorError_class);
        (*env)->DeleteLocalRef (env, j_motorError_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateMotorSoftwareVersionChangednativeCb (char * version, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateMotorSoftwareVersionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateMotorSoftwareVersionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateMotorSoftwareVersionChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_version = (*env)->NewStringUTF (env, version);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_version);
        (*env)->DeleteLocalRef (env, j_version);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateMotorFlightsStatusChangednativeCb (uint16_t nbFlights, uint16_t lastFlightDuration, uint32_t totalFlightDuration, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateMotorFlightsStatusChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateMotorFlightsStatusChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateMotorFlightsStatusChangedUpdate", "(SSI)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)nbFlights, (jshort)lastFlightDuration, (jint)totalFlightDuration);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateMotorErrorLastErrorChangednativeCb (eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR motorError, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateMotorErrorLastErrorChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateMotorErrorLastErrorChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateMotorErrorLastErrorChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_motorError_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ENUM");
        jmethodID j_motorError_mid = (*env)->GetStaticMethodID (env, j_motorError_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR_ENUM;");
        jobject j_motorError_enum = (*env)->CallStaticObjectMethod (env, j_motorError_class, j_motorError_mid, motorError);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_motorError_enum);
        (*env)->DeleteLocalRef (env, j_motorError_class);
        (*env)->DeleteLocalRef (env, j_motorError_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3SettingsStateP7IDnativeCb (char * serialID, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3SettingsStateP7IDListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3SettingsStateP7IDListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3SettingsStateP7IDUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_serialID = (*env)->NewStringUTF (env, serialID);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_serialID);
        (*env)->DeleteLocalRef (env, j_serialID);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStatePictureFormatChangednativeCb (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStatePictureFormatChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStatePictureFormatChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStatePictureFormatChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStateAutoWhiteBalanceChangednativeCb (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStateAutoWhiteBalanceChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStateAutoWhiteBalanceChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStateAutoWhiteBalanceChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStateExpositionChangednativeCb (float value, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStateExpositionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStateExpositionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStateExpositionChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStateSaturationChangednativeCb (float value, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStateSaturationChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStateSaturationChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStateSaturationChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, value, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStateTimelapseChangednativeCb (uint8_t enabled, float interval, float minInterval, float maxInterval, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStateTimelapseChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStateTimelapseChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStateTimelapseChangedUpdate", "(BFFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled, interval, minInterval, maxInterval);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStateVideoAutorecordChangednativeCb (uint8_t enabled, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStateVideoAutorecordChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStateVideoAutorecordChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStateVideoAutorecordChangedUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PictureSettingsStateVideoStabilizationModeChangednativeCb (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE mode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PictureSettingsStateVideoStabilizationModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PictureSettingsStateVideoStabilizationModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PictureSettingsStateVideoStabilizationModeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_ENUM");
        jmethodID j_mode_mid = (*env)->GetStaticMethodID (env, j_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE_ENUM;");
        jobject j_mode_enum = (*env)->CallStaticObjectMethod (env, j_mode_class, j_mode_mid, mode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_mode_enum);
        (*env)->DeleteLocalRef (env, j_mode_class);
        (*env)->DeleteLocalRef (env, j_mode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3MediaStreamingStateVideoEnableChangednativeCb (eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED enabled, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3MediaStreamingStateVideoEnableChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3MediaStreamingStateVideoEnableChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3MediaStreamingStateVideoEnableChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_enabled_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM");
        jmethodID j_enabled_mid = (*env)->GetStaticMethodID (env, j_enabled_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM;");
        jobject j_enabled_enum = (*env)->CallStaticObjectMethod (env, j_enabled_class, j_enabled_mid, enabled);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_enabled_enum);
        (*env)->DeleteLocalRef (env, j_enabled_class);
        (*env)->DeleteLocalRef (env, j_enabled_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsStateHomeChangednativeCb (double latitude, double longitude, double altitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsStateHomeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsStateHomeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsStateHomeChangedUpdate", "(DDD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsStateResetHomeChangednativeCb (double latitude, double longitude, double altitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsStateResetHomeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsStateResetHomeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsStateResetHomeChangedUpdate", "(DDD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsStateGPSFixStateChangednativeCb (uint8_t fixed, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsStateGPSFixStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsStateGPSFixStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsStateGPSFixStateChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)fixed);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsStateGPSUpdateStateChangednativeCb (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsStateGPSUpdateStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsStateGPSUpdateStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsStateGPSUpdateStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsStateHomeTypeChangednativeCb (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsStateHomeTypeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsStateHomeTypeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsStateHomeTypeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSSettingsStateReturnHomeDelayChangednativeCb (uint16_t delay, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSSettingsStateReturnHomeDelayChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSSettingsStateReturnHomeDelayChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSSettingsStateReturnHomeDelayChangedUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)delay);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3CameraStateOrientationnativeCb (int8_t tilt, int8_t pan, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3CameraStateOrientationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3CameraStateOrientationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3CameraStateOrientationUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, tilt, pan);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3CameraStateDefaultCameraOrientationnativeCb (int8_t tilt, int8_t pan, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3CameraStateDefaultCameraOrientationListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3CameraStateDefaultCameraOrientationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3CameraStateDefaultCameraOrientationUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, tilt, pan);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3AntiflickeringStateElectricFrequencyChangednativeCb (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY frequency, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3AntiflickeringStateElectricFrequencyChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3AntiflickeringStateElectricFrequencyChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3AntiflickeringStateElectricFrequencyChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_frequency_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_ENUM");
        jmethodID j_frequency_mid = (*env)->GetStaticMethodID (env, j_frequency_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY_ENUM;");
        jobject j_frequency_enum = (*env)->CallStaticObjectMethod (env, j_frequency_class, j_frequency_mid, frequency);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_frequency_enum);
        (*env)->DeleteLocalRef (env, j_frequency_class);
        (*env)->DeleteLocalRef (env, j_frequency_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3AntiflickeringStateModeChangednativeCb (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE mode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3AntiflickeringStateModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3AntiflickeringStateModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3AntiflickeringStateModeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_ENUM");
        jmethodID j_mode_mid = (*env)->GetStaticMethodID (env, j_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE_ENUM;");
        jobject j_mode_enum = (*env)->CallStaticObjectMethod (env, j_mode_class, j_mode_mid, mode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_mode_enum);
        (*env)->DeleteLocalRef (env, j_mode_class);
        (*env)->DeleteLocalRef (env, j_mode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSStateNumberOfSatelliteChangednativeCb (uint8_t numberOfSatellite, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSStateNumberOfSatelliteChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSStateNumberOfSatelliteChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSStateNumberOfSatelliteChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)numberOfSatellite);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSStateHomeTypeAvailabilityChangednativeCb (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE type, uint8_t available, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSStateHomeTypeAvailabilityChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSStateHomeTypeAvailabilityChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSStateHomeTypeAvailabilityChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, (jbyte)available);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3GPSStateHomeTypeChosenChangednativeCb (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3GPSStateHomeTypeChosenChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3GPSStateHomeTypeChosenChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3GPSStateHomeTypeChosenChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ARDrone3PROStateFeaturesnativeCb (uint64_t features, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandARDrone3PROStateFeaturesListener", "Lcom/parrot/arsdk/arcommands/ARCommandARDrone3PROStateFeaturesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onARDrone3PROStateFeaturesUpdate", "(J)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jlong)features);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_JumpingSumoPilotingPCMDnativeCb (uint8_t flag, int8_t speed, int8_t turn, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoPilotingPCMDListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoPilotingPCMDListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoPilotingPCMDUpdate", "(BBB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)flag, speed, turn);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoPilotingPosturenativeCb (eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoPilotingPostureListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoPilotingPostureListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoPilotingPostureUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoPilotingAddCapOffsetnativeCb (float offset, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoPilotingAddCapOffsetListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoPilotingAddCapOffsetListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoPilotingAddCapOffsetUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, offset);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsJumpStopnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsJumpStopListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsJumpStopListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsJumpStopUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsJumpCancelnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsJumpCancelListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsJumpCancelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsJumpCancelUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsJumpLoadnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsJumpLoadListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsJumpLoadListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsJumpLoadUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsJumpnativeCb (eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsJumpListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsJumpListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsJumpUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsSimpleAnimationnativeCb (eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsSimpleAnimationListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsSimpleAnimationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsSimpleAnimationUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_id_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_ENUM");
        jmethodID j_id_mid = (*env)->GetStaticMethodID (env, j_id_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID_ENUM;");
        jobject j_id_enum = (*env)->CallStaticObjectMethod (env, j_id_class, j_id_mid, id);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_id_enum);
        (*env)->DeleteLocalRef (env, j_id_class);
        (*env)->DeleteLocalRef (env, j_id_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordPicturenativeCb (uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordPictureListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordPictureListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordPictureUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordVideonativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordVideoListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordVideoListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordVideoUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_ENUM");
        jmethodID j_record_mid = (*env)->GetStaticMethodID (env, j_record_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD_ENUM;");
        jobject j_record_enum = (*env)->CallStaticObjectMethod (env, j_record_class, j_record_mid, record);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_record_enum, (jbyte)mass_storage_id);
        (*env)->DeleteLocalRef (env, j_record_class);
        (*env)->DeleteLocalRef (env, j_record_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordPictureV2nativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordPictureV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordPictureV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordPictureV2Update", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordVideoV2nativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD record, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordVideoV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordVideoV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordVideoV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_record_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_ENUM");
        jmethodID j_record_mid = (*env)->GetStaticMethodID (env, j_record_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD_ENUM;");
        jobject j_record_enum = (*env)->CallStaticObjectMethod (env, j_record_class, j_record_mid, record);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_record_enum);
        (*env)->DeleteLocalRef (env, j_record_class);
        (*env)->DeleteLocalRef (env, j_record_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkSettingsWifiSelectionnativeCb (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkSettingsWifiSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkSettingsWifiSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkSettingsWifiSelectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkWifiScannativeCb (eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND band, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkWifiScanListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkWifiScanListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkWifiScanUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_band_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkWifiAuthChannelnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkWifiAuthChannelListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkWifiAuthChannelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkWifiAuthChannelUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAudioSettingsMasterVolumenativeCb (uint8_t volume, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAudioSettingsMasterVolumeListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAudioSettingsMasterVolumeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAudioSettingsMasterVolumeUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)volume);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAudioSettingsThemenativeCb (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME theme, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAudioSettingsThemeListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAudioSettingsThemeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAudioSettingsThemeUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_theme_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_ENUM");
        jmethodID j_theme_mid = (*env)->GetStaticMethodID (env, j_theme_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME_ENUM;");
        jobject j_theme_enum = (*env)->CallStaticObjectMethod (env, j_theme_class, j_theme_mid, theme);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_theme_enum);
        (*env)->DeleteLocalRef (env, j_theme_class);
        (*env)->DeleteLocalRef (env, j_theme_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanAllScriptsMetadatanativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanAllScriptsMetadataListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanAllScriptsMetadataListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanAllScriptsMetadataUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanScriptUploadednativeCb (char * uuid, char * md5Hash, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanScriptUploadedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanScriptUploadedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanScriptUploadedUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_uuid = (*env)->NewStringUTF (env, uuid);
        jstring j_md5Hash = (*env)->NewStringUTF (env, md5Hash);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_uuid, j_md5Hash);
        (*env)->DeleteLocalRef (env, j_uuid);
        (*env)->DeleteLocalRef (env, j_md5Hash);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanScriptDeletenativeCb (char * uuid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanScriptDeleteListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanScriptDeleteListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanScriptDeleteUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_uuid = (*env)->NewStringUTF (env, uuid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_uuid);
        (*env)->DeleteLocalRef (env, j_uuid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanPlayScriptnativeCb (char * uuid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanPlayScriptListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanPlayScriptListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanPlayScriptUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_uuid = (*env)->NewStringUTF (env, uuid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_uuid);
        (*env)->DeleteLocalRef (env, j_uuid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoSpeedSettingsOutdoornativeCb (uint8_t outdoor, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoSpeedSettingsOutdoorListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoSpeedSettingsOutdoorListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoSpeedSettingsOutdoorUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)outdoor);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaStreamingVideoEnablenativeCb (uint8_t enable, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaStreamingVideoEnableListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaStreamingVideoEnableListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaStreamingVideoEnableUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enable);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoVideoSettingsAutorecordnativeCb (uint8_t enabled, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoVideoSettingsAutorecordListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoVideoSettingsAutorecordListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoVideoSettingsAutorecordUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoPilotingStatePostureChangednativeCb (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoPilotingStatePostureChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoPilotingStatePostureChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoPilotingStatePostureChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoPilotingStateAlertStateChangednativeCb (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoPilotingStateAlertStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoPilotingStateAlertStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoPilotingStateAlertStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoPilotingStateSpeedChangednativeCb (int8_t speed, int16_t realSpeed, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoPilotingStateSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoPilotingStateSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoPilotingStateSpeedChangedUpdate", "(BS)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, speed, realSpeed);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsStateJumpLoadChangednativeCb (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsStateJumpLoadChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsStateJumpLoadChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsStateJumpLoadChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsStateJumpTypeChangednativeCb (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsStateJumpTypeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsStateJumpTypeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsStateJumpTypeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAnimationsStateJumpMotorProblemChangednativeCb (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAnimationsStateJumpMotorProblemChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAnimationsStateJumpMotorProblemChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAnimationsStateJumpMotorProblemChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_error_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoSettingsStateProductGPSVersionChangednativeCb (char * software, char * hardware, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoSettingsStateProductGPSVersionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoSettingsStateProductGPSVersionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoSettingsStateProductGPSVersionChangedUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_software = (*env)->NewStringUTF (env, software);
        jstring j_hardware = (*env)->NewStringUTF (env, hardware);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_software, j_hardware);
        (*env)->DeleteLocalRef (env, j_software);
        (*env)->DeleteLocalRef (env, j_hardware);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordStatePictureStateChangednativeCb (uint8_t state, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordStatePictureStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordStatePictureStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordStatePictureStateChangedUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordStateVideoStateChangednativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE state, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordStateVideoStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordStateVideoStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordStateVideoStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, (jbyte)mass_storage_id);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordStatePictureStateChangedV2nativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordStatePictureStateChangedV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordStatePictureStateChangedV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordStatePictureStateChangedV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordStateVideoStateChangedV2nativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordStateVideoStateChangedV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordStateVideoStateChangedV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordStateVideoStateChangedV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordEventPictureEventChangednativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordEventPictureEventChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordEventPictureEventChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordEventPictureEventChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM");
        jmethodID j_event_mid = (*env)->GetStaticMethodID (env, j_event_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM;");
        jobject j_event_enum = (*env)->CallStaticObjectMethod (env, j_event_class, j_event_mid, event);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_event_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_event_class);
        (*env)->DeleteLocalRef (env, j_event_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaRecordEventVideoEventChangednativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaRecordEventVideoEventChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaRecordEventVideoEventChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaRecordEventVideoEventChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM");
        jmethodID j_event_mid = (*env)->GetStaticMethodID (env, j_event_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT_ENUM;");
        jobject j_event_enum = (*env)->CallStaticObjectMethod (env, j_event_class, j_event_mid, event);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_event_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_event_class);
        (*env)->DeleteLocalRef (env, j_event_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkSettingsStateWifiSelectionChangednativeCb (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkSettingsStateWifiSelectionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkSettingsStateWifiSelectionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkSettingsStateWifiSelectionChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkStateWifiScanListChangednativeCb (char * ssid, int16_t rssi, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkStateWifiScanListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkStateWifiScanListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkStateWifiScanListChangedUpdate", "(Ljava/lang/String;SLcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid, rssi, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_ssid);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkStateAllWifiScanChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkStateAllWifiScanChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkStateAllWifiScanChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkStateAllWifiScanChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkStateWifiAuthChannelListChangednativeCb (eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND band, uint8_t channel, uint8_t in_or_out, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkStateWifiAuthChannelListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkStateWifiAuthChannelListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkStateWifiAuthChannelListChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM;BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_band_enum, (jbyte)channel, (jbyte)in_or_out);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkStateAllWifiAuthChannelChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkStateAllWifiAuthChannelChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkStateAllWifiAuthChannelChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkStateAllWifiAuthChannelChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoNetworkStateLinkQualityChangednativeCb (uint8_t quality, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoNetworkStateLinkQualityChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoNetworkStateLinkQualityChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoNetworkStateLinkQualityChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)quality);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAudioSettingsStateMasterVolumeChangednativeCb (uint8_t volume, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAudioSettingsStateMasterVolumeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAudioSettingsStateMasterVolumeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAudioSettingsStateMasterVolumeChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)volume);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoAudioSettingsStateThemeChangednativeCb (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME theme, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoAudioSettingsStateThemeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoAudioSettingsStateThemeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoAudioSettingsStateThemeChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_theme_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_ENUM");
        jmethodID j_theme_mid = (*env)->GetStaticMethodID (env, j_theme_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME_ENUM;");
        jobject j_theme_enum = (*env)->CallStaticObjectMethod (env, j_theme_class, j_theme_mid, theme);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_theme_enum);
        (*env)->DeleteLocalRef (env, j_theme_class);
        (*env)->DeleteLocalRef (env, j_theme_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanStateScriptMetadataListChangednativeCb (char * uuid, uint8_t version, char * product, char * name, uint64_t lastModified, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanStateScriptMetadataListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanStateScriptMetadataListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanStateScriptMetadataListChangedUpdate", "(Ljava/lang/String;BLjava/lang/String;Ljava/lang/String;J)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_uuid = (*env)->NewStringUTF (env, uuid);
        jstring j_product = (*env)->NewStringUTF (env, product);
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_uuid, (jbyte)version, j_product, j_name, (jlong)lastModified);
        (*env)->DeleteLocalRef (env, j_uuid);
        (*env)->DeleteLocalRef (env, j_product);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanStateAllScriptsMetadataChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanStateAllScriptsMetadataChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanStateAllScriptsMetadataChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanStateAllScriptsMetadataChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanStateScriptUploadChangednativeCb (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE resultCode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanStateScriptUploadChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanStateScriptUploadChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanStateScriptUploadChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_resultCode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ENUM");
        jmethodID j_resultCode_mid = (*env)->GetStaticMethodID (env, j_resultCode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE_ENUM;");
        jobject j_resultCode_enum = (*env)->CallStaticObjectMethod (env, j_resultCode_class, j_resultCode_mid, resultCode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_resultCode_enum);
        (*env)->DeleteLocalRef (env, j_resultCode_class);
        (*env)->DeleteLocalRef (env, j_resultCode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanStateScriptDeleteChangednativeCb (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE resultCode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanStateScriptDeleteChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanStateScriptDeleteChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanStateScriptDeleteChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_resultCode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ENUM");
        jmethodID j_resultCode_mid = (*env)->GetStaticMethodID (env, j_resultCode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE_ENUM;");
        jobject j_resultCode_enum = (*env)->CallStaticObjectMethod (env, j_resultCode_class, j_resultCode_mid, resultCode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_resultCode_enum);
        (*env)->DeleteLocalRef (env, j_resultCode_class);
        (*env)->DeleteLocalRef (env, j_resultCode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoRoadPlanStatePlayScriptChangednativeCb (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE resultCode, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoRoadPlanStatePlayScriptChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoRoadPlanStatePlayScriptChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoRoadPlanStatePlayScriptChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_resultCode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_ENUM");
        jmethodID j_resultCode_mid = (*env)->GetStaticMethodID (env, j_resultCode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE_ENUM;");
        jobject j_resultCode_enum = (*env)->CallStaticObjectMethod (env, j_resultCode_class, j_resultCode_mid, resultCode);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_resultCode_enum);
        (*env)->DeleteLocalRef (env, j_resultCode_class);
        (*env)->DeleteLocalRef (env, j_resultCode_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoSpeedSettingsStateOutdoorChangednativeCb (uint8_t outdoor, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoSpeedSettingsStateOutdoorChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoSpeedSettingsStateOutdoorChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoSpeedSettingsStateOutdoorChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)outdoor);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoMediaStreamingStateVideoEnableChangednativeCb (eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED enabled, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoMediaStreamingStateVideoEnableChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoMediaStreamingStateVideoEnableChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoMediaStreamingStateVideoEnableChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_enabled_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM");
        jmethodID j_enabled_mid = (*env)->GetStaticMethodID (env, j_enabled_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED_ENUM;");
        jobject j_enabled_enum = (*env)->CallStaticObjectMethod (env, j_enabled_class, j_enabled_mid, enabled);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_enabled_enum);
        (*env)->DeleteLocalRef (env, j_enabled_class);
        (*env)->DeleteLocalRef (env, j_enabled_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_JumpingSumoVideoSettingsStateAutorecordChangednativeCb (uint8_t enabled, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandJumpingSumoVideoSettingsStateAutorecordChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandJumpingSumoVideoSettingsStateAutorecordChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onJumpingSumoVideoSettingsStateAutorecordChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_MiniDronePilotingFlatTrimnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingFlatTrimListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingFlatTrimListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingFlatTrimUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingTakeOffnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingTakeOffListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingTakeOffListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingTakeOffUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingPCMDnativeCb (uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestamp, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingPCMDListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingPCMDListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingPCMDUpdate", "(BBBBBI)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)flag, roll, pitch, yaw, gaz, (jint)timestamp);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingLandingnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingLandingListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingLandingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingLandingUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingEmergencynativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingEmergencyListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingEmergencyListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingEmergencyUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingAutoTakeOffModenativeCb (uint8_t state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingAutoTakeOffModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingAutoTakeOffModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingAutoTakeOffModeUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneAnimationsFlipnativeCb (eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION direction, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneAnimationsFlipListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneAnimationsFlipListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneAnimationsFlipUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_direction_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_ENUM");
        jmethodID j_direction_mid = (*env)->GetStaticMethodID (env, j_direction_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION_ENUM;");
        jobject j_direction_enum = (*env)->CallStaticObjectMethod (env, j_direction_class, j_direction_mid, direction);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_direction_enum);
        (*env)->DeleteLocalRef (env, j_direction_class);
        (*env)->DeleteLocalRef (env, j_direction_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneAnimationsCapnativeCb (int16_t offset, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneAnimationsCapListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneAnimationsCapListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneAnimationsCapUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, offset);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneMediaRecordPicturenativeCb (uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneMediaRecordPictureListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneMediaRecordPictureListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneMediaRecordPictureUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneMediaRecordPictureV2nativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneMediaRecordPictureV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneMediaRecordPictureV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneMediaRecordPictureV2Update", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingSettingsMaxAltitudenativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingSettingsMaxAltitudeListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingSettingsMaxAltitudeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingSettingsMaxAltitudeUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingSettingsMaxTiltnativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingSettingsMaxTiltListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingSettingsMaxTiltListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingSettingsMaxTiltUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsMaxVerticalSpeednativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsMaxVerticalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsMaxVerticalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsMaxVerticalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsMaxRotationSpeednativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsMaxRotationSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsMaxRotationSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsMaxRotationSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsWheelsnativeCb (uint8_t present, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsWheelsListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsWheelsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsWheelsUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)present);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsMaxHorizontalSpeednativeCb (float current, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsMaxHorizontalSpeedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsMaxHorizontalSpeedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsMaxHorizontalSpeedUpdate", "(F)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSettingsCutOutModenativeCb (uint8_t enable, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSettingsCutOutModeListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSettingsCutOutModeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSettingsCutOutModeUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enable);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneGPSControllerLatitudeForRunnativeCb (double latitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneGPSControllerLatitudeForRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneGPSControllerLatitudeForRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneGPSControllerLatitudeForRunUpdate", "(D)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneGPSControllerLongitudeForRunnativeCb (double longitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneGPSControllerLongitudeForRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneGPSControllerLongitudeForRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneGPSControllerLongitudeForRunUpdate", "(D)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, longitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneConfigurationControllerTypenativeCb (char * type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneConfigurationControllerTypeListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneConfigurationControllerTypeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneConfigurationControllerTypeUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_type = (*env)->NewStringUTF (env, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type);
        (*env)->DeleteLocalRef (env, j_type);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneConfigurationControllerNamenativeCb (char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneConfigurationControllerNameListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneConfigurationControllerNameListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneConfigurationControllerNameUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_name);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingStateFlatTrimChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingStateFlatTrimChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingStateFlatTrimChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingStateFlatTrimChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingStateFlyingStateChangednativeCb (eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingStateFlyingStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingStateFlyingStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingStateFlyingStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingStateAlertStateChangednativeCb (eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingStateAlertStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingStateAlertStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingStateAlertStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingStateAutoTakeOffModeChangednativeCb (uint8_t state, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingStateAutoTakeOffModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingStateAutoTakeOffModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingStateAutoTakeOffModeChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneMediaRecordStatePictureStateChangednativeCb (uint8_t state, uint8_t mass_storage_id, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneMediaRecordStatePictureStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneMediaRecordStatePictureStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneMediaRecordStatePictureStateChangedUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)state, (jbyte)mass_storage_id);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneMediaRecordStatePictureStateChangedV2nativeCb (eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE state, eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneMediaRecordStatePictureStateChangedV2Listener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneMediaRecordStatePictureStateChangedV2Listener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneMediaRecordStatePictureStateChangedV2Update", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneMediaRecordEventPictureEventChangednativeCb (eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT event, eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneMediaRecordEventPictureEventChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneMediaRecordEventPictureEventChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneMediaRecordEventPictureEventChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_event_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM");
        jmethodID j_event_mid = (*env)->GetStaticMethodID (env, j_event_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT_ENUM;");
        jobject j_event_enum = (*env)->CallStaticObjectMethod (env, j_event_class, j_event_mid, event);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_event_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_event_class);
        (*env)->DeleteLocalRef (env, j_event_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingSettingsStateMaxAltitudeChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingSettingsStateMaxAltitudeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingSettingsStateMaxAltitudeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingSettingsStateMaxAltitudeChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDronePilotingSettingsStateMaxTiltChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDronePilotingSettingsStateMaxTiltChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDronePilotingSettingsStateMaxTiltChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDronePilotingSettingsStateMaxTiltChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsStateMaxRotationSpeedChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsStateMaxRotationSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsStateMaxRotationSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsStateMaxRotationSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsStateWheelsChangednativeCb (uint8_t present, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsStateWheelsChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsStateWheelsChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsStateWheelsChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)present);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangednativeCb (float current, float min, float max, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedUpdate", "(FFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, current, min, max);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSettingsStateProductMotorsVersionChangednativeCb (uint8_t motor, char * type, char * software, char * hardware, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSettingsStateProductMotorsVersionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSettingsStateProductMotorsVersionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSettingsStateProductMotorsVersionChangedUpdate", "(BLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_type = (*env)->NewStringUTF (env, type);
        jstring j_software = (*env)->NewStringUTF (env, software);
        jstring j_hardware = (*env)->NewStringUTF (env, hardware);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)motor, j_type, j_software, j_hardware);
        (*env)->DeleteLocalRef (env, j_type);
        (*env)->DeleteLocalRef (env, j_software);
        (*env)->DeleteLocalRef (env, j_hardware);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSettingsStateProductInertialVersionChangednativeCb (char * software, char * hardware, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSettingsStateProductInertialVersionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSettingsStateProductInertialVersionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSettingsStateProductInertialVersionChangedUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_software = (*env)->NewStringUTF (env, software);
        jstring j_hardware = (*env)->NewStringUTF (env, hardware);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_software, j_hardware);
        (*env)->DeleteLocalRef (env, j_software);
        (*env)->DeleteLocalRef (env, j_hardware);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneSettingsStateCutOutModeChangednativeCb (uint8_t enable, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneSettingsStateCutOutModeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneSettingsStateCutOutModeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneSettingsStateCutOutModeChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enable);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_MiniDroneFloodControlStateFloodControlChangednativeCb (uint16_t delay, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandMiniDroneFloodControlStateFloodControlChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandMiniDroneFloodControlStateFloodControlChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onMiniDroneFloodControlStateFloodControlChangedUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)delay);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_SkyControllerWifiRequestWifiListnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiRequestWifiListListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiRequestWifiListListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiRequestWifiListUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiRequestCurrentWifinativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiRequestCurrentWifiListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiRequestCurrentWifiListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiRequestCurrentWifiUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiConnectToWifinativeCb (char * bssid, char * ssid, char * passphrase, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiConnectToWifiListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiConnectToWifiListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiConnectToWifiUpdate", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_bssid = (*env)->NewStringUTF (env, bssid);
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        jstring j_passphrase = (*env)->NewStringUTF (env, passphrase);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_bssid, j_ssid, j_passphrase);
        (*env)->DeleteLocalRef (env, j_bssid);
        (*env)->DeleteLocalRef (env, j_ssid);
        (*env)->DeleteLocalRef (env, j_passphrase);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiForgetWifinativeCb (char * ssid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiForgetWifiListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiForgetWifiListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiForgetWifiUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid);
        (*env)->DeleteLocalRef (env, j_ssid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiWifiAuthChannelnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiWifiAuthChannelListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiWifiAuthChannelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiWifiAuthChannelUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerDeviceRequestDeviceListnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerDeviceRequestDeviceListListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerDeviceRequestDeviceListListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerDeviceRequestDeviceListUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerDeviceRequestCurrentDevicenativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerDeviceRequestCurrentDeviceListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerDeviceRequestCurrentDeviceListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerDeviceRequestCurrentDeviceUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerDeviceConnectToDevicenativeCb (char * deviceName, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerDeviceConnectToDeviceListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerDeviceConnectToDeviceListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerDeviceConnectToDeviceUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_deviceName = (*env)->NewStringUTF (env, deviceName);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_deviceName);
        (*env)->DeleteLocalRef (env, j_deviceName);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSettingsAllSettingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSettingsAllSettingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSettingsAllSettingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSettingsAllSettingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSettingsResetnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSettingsResetListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSettingsResetListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSettingsResetUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCommonAllStatesnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCommonAllStatesListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCommonAllStatesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCommonAllStatesUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAccessPointSettingsAccessPointSSIDnativeCb (char * ssid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAccessPointSettingsAccessPointSSIDListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAccessPointSettingsAccessPointSSIDListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAccessPointSettingsAccessPointSSIDUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid);
        (*env)->DeleteLocalRef (env, j_ssid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAccessPointSettingsAccessPointChannelnativeCb (uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAccessPointSettingsAccessPointChannelListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAccessPointSettingsAccessPointChannelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAccessPointSettingsAccessPointChannelUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)channel);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAccessPointSettingsWifiSelectionnativeCb (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAccessPointSettingsWifiSelectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAccessPointSettingsWifiSelectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAccessPointSettingsWifiSelectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCameraResetOrientationnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCameraResetOrientationListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCameraResetOrientationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCameraResetOrientationUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerGamepadInfosGetGamepadControlsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerGamepadInfosGetGamepadControlsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerGamepadInfosGetGamepadControlsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerGamepadInfosGetGamepadControlsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsGetCurrentButtonMappingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsGetCurrentButtonMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsGetCurrentButtonMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsGetCurrentButtonMappingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsGetAvailableButtonMappingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsGetAvailableButtonMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsGetAvailableButtonMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsGetAvailableButtonMappingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsSetButtonMappingnativeCb (int32_t key_id, char * mapping_uid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsSetButtonMappingListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsSetButtonMappingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsSetButtonMappingUpdate", "(ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_mapping_uid = (*env)->NewStringUTF (env, mapping_uid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, key_id, j_mapping_uid);
        (*env)->DeleteLocalRef (env, j_mapping_uid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsDefaultButtonMappingnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsDefaultButtonMappingListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsDefaultButtonMappingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsDefaultButtonMappingUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsGetCurrentAxisMappingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsGetCurrentAxisMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsGetCurrentAxisMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsGetCurrentAxisMappingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsGetAvailableAxisMappingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsGetAvailableAxisMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsGetAvailableAxisMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsGetAvailableAxisMappingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsSetAxisMappingnativeCb (int32_t axis_id, char * mapping_uid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsSetAxisMappingListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsSetAxisMappingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsSetAxisMappingUpdate", "(ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_mapping_uid = (*env)->NewStringUTF (env, mapping_uid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, axis_id, j_mapping_uid);
        (*env)->DeleteLocalRef (env, j_mapping_uid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsDefaultAxisMappingnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsDefaultAxisMappingListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsDefaultAxisMappingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsDefaultAxisMappingUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersGetCurrentAxisFiltersnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersGetCurrentAxisFiltersListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersGetCurrentAxisFiltersListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersGetCurrentAxisFiltersUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersGetPresetAxisFiltersnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersGetPresetAxisFiltersListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersGetPresetAxisFiltersListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersGetPresetAxisFiltersUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersSetAxisFilternativeCb (int32_t axis_id, char * filter_uid_or_builder, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersSetAxisFilterListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersSetAxisFilterListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersSetAxisFilterUpdate", "(ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_filter_uid_or_builder = (*env)->NewStringUTF (env, filter_uid_or_builder);
        (*env)->CallVoidMethod (env, delegate, d_methodid, axis_id, j_filter_uid_or_builder);
        (*env)->DeleteLocalRef (env, j_filter_uid_or_builder);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersDefaultAxisFiltersnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersDefaultAxisFiltersListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersDefaultAxisFiltersListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersDefaultAxisFiltersUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCoPilotingSetPilotingSourcenativeCb (eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE source, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCoPilotingSetPilotingSourceListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCoPilotingSetPilotingSourceListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCoPilotingSetPilotingSourceUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_source_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_ENUM");
        jmethodID j_source_mid = (*env)->GetStaticMethodID (env, j_source_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE_ENUM;");
        jobject j_source_enum = (*env)->CallStaticObjectMethod (env, j_source_class, j_source_mid, source);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_source_enum);
        (*env)->DeleteLocalRef (env, j_source_class);
        (*env)->DeleteLocalRef (env, j_source_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesnativeCb (uint8_t enable, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enable);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiStateWifiListnativeCb (char * bssid, char * ssid, uint8_t secured, uint8_t saved, int32_t rssi, int32_t frequency, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiStateWifiListListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiStateWifiListListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiStateWifiListUpdate", "(Ljava/lang/String;Ljava/lang/String;BBII)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_bssid = (*env)->NewStringUTF (env, bssid);
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_bssid, j_ssid, (jbyte)secured, (jbyte)saved, rssi, frequency);
        (*env)->DeleteLocalRef (env, j_bssid);
        (*env)->DeleteLocalRef (env, j_ssid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiStateConnexionChangednativeCb (char * ssid, eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS status, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiStateConnexionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiStateConnexionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiStateConnexionChangedUpdate", "(Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_ENUM");
        jmethodID j_status_mid = (*env)->GetStaticMethodID (env, j_status_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS_ENUM;");
        jobject j_status_enum = (*env)->CallStaticObjectMethod (env, j_status_class, j_status_mid, status);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid, j_status_enum);
        (*env)->DeleteLocalRef (env, j_ssid);
        (*env)->DeleteLocalRef (env, j_status_class);
        (*env)->DeleteLocalRef (env, j_status_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiStateWifiAuthChannelListChangednativeCb (eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND band, uint8_t channel, uint8_t in_or_out, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiStateWifiAuthChannelListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiStateWifiAuthChannelListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiStateWifiAuthChannelListChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM;BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_band_enum, (jbyte)channel, (jbyte)in_or_out);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiStateAllWifiAuthChannelChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiStateAllWifiAuthChannelChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiStateAllWifiAuthChannelChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiStateAllWifiAuthChannelChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerWifiStateWifiSignalChangednativeCb (uint8_t level, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerWifiStateWifiSignalChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerWifiStateWifiSignalChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerWifiStateWifiSignalChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)level);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerDeviceStateDeviceListnativeCb (char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerDeviceStateDeviceListListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerDeviceStateDeviceListListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerDeviceStateDeviceListUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_name);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerDeviceStateConnexionChangednativeCb (eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS status, char * deviceName, uint16_t deviceProductID, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerDeviceStateConnexionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerDeviceStateConnexionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerDeviceStateConnexionChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_ENUM;Ljava/lang/String;S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_ENUM");
        jmethodID j_status_mid = (*env)->GetStaticMethodID (env, j_status_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS_ENUM;");
        jobject j_status_enum = (*env)->CallStaticObjectMethod (env, j_status_class, j_status_mid, status);
        jstring j_deviceName = (*env)->NewStringUTF (env, deviceName);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_status_enum, j_deviceName, (jshort)deviceProductID);
        (*env)->DeleteLocalRef (env, j_status_class);
        (*env)->DeleteLocalRef (env, j_status_enum);
        (*env)->DeleteLocalRef (env, j_deviceName);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSettingsStateAllSettingsChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSettingsStateAllSettingsChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSettingsStateAllSettingsChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSettingsStateAllSettingsChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSettingsStateResetChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSettingsStateResetChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSettingsStateResetChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSettingsStateResetChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSettingsStateProductSerialChangednativeCb (char * serialNumber, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSettingsStateProductSerialChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSettingsStateProductSerialChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSettingsStateProductSerialChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_serialNumber = (*env)->NewStringUTF (env, serialNumber);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_serialNumber);
        (*env)->DeleteLocalRef (env, j_serialNumber);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSettingsStateProductVariantChangednativeCb (eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT variant, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSettingsStateProductVariantChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSettingsStateProductVariantChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSettingsStateProductVariantChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_variant_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_ENUM");
        jmethodID j_variant_mid = (*env)->GetStaticMethodID (env, j_variant_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT_ENUM;");
        jobject j_variant_enum = (*env)->CallStaticObjectMethod (env, j_variant_class, j_variant_mid, variant);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_variant_enum);
        (*env)->DeleteLocalRef (env, j_variant_class);
        (*env)->DeleteLocalRef (env, j_variant_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCommonStateAllStatesChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCommonStateAllStatesChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCommonStateAllStatesChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCommonStateAllStatesChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSkyControllerStateBatteryChangednativeCb (uint8_t percent, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSkyControllerStateBatteryChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSkyControllerStateBatteryChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSkyControllerStateBatteryChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)percent);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSkyControllerStateGpsFixChangednativeCb (uint8_t fixed, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSkyControllerStateGpsFixChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSkyControllerStateGpsFixChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSkyControllerStateGpsFixChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)fixed);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerSkyControllerStateGpsPositionChangednativeCb (double latitude, double longitude, double altitude, float heading, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerSkyControllerStateGpsPositionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerSkyControllerStateGpsPositionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerSkyControllerStateGpsPositionChangedUpdate", "(DDDF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude, heading);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAccessPointSettingsStateAccessPointSSIDChangednativeCb (char * ssid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAccessPointSettingsStateAccessPointSSIDChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAccessPointSettingsStateAccessPointSSIDChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAccessPointSettingsStateAccessPointSSIDChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid);
        (*env)->DeleteLocalRef (env, j_ssid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAccessPointSettingsStateAccessPointChannelChangednativeCb (uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAccessPointSettingsStateAccessPointChannelChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAccessPointSettingsStateAccessPointChannelChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAccessPointSettingsStateAccessPointChannelChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)channel);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAccessPointSettingsStateWifiSelectionChangednativeCb (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE type, eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAccessPointSettingsStateWifiSelectionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAccessPointSettingsStateWifiSelectionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAccessPointSettingsStateWifiSelectionChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerGamepadInfosStateGamepadControlnativeCb (eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE type, int32_t id, char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerGamepadInfosStateGamepadControlListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerGamepadInfosStateGamepadControlListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerGamepadInfosStateGamepadControlUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_ENUM;ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, id, j_name);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerGamepadInfosStateAllGamepadControlsSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerGamepadInfosStateAllGamepadControlsSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerGamepadInfosStateAllGamepadControlsSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerGamepadInfosStateAllGamepadControlsSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsStateCurrentButtonMappingsnativeCb (int32_t key_id, char * mapping_uid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsStateCurrentButtonMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsStateCurrentButtonMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsStateCurrentButtonMappingsUpdate", "(ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_mapping_uid = (*env)->NewStringUTF (env, mapping_uid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, key_id, j_mapping_uid);
        (*env)->DeleteLocalRef (env, j_mapping_uid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsStateAvailableButtonMappingsnativeCb (char * mapping_uid, char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsStateAvailableButtonMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsStateAvailableButtonMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsStateAvailableButtonMappingsUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_mapping_uid = (*env)->NewStringUTF (env, mapping_uid);
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_mapping_uid, j_name);
        (*env)->DeleteLocalRef (env, j_mapping_uid);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsStateCurrentAxisMappingsnativeCb (int32_t axis_id, char * mapping_uid, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsStateCurrentAxisMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsStateCurrentAxisMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsStateCurrentAxisMappingsUpdate", "(ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_mapping_uid = (*env)->NewStringUTF (env, mapping_uid);
        (*env)->CallVoidMethod (env, delegate, d_methodid, axis_id, j_mapping_uid);
        (*env)->DeleteLocalRef (env, j_mapping_uid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsStateAvailableAxisMappingsnativeCb (char * mapping_uid, char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsStateAvailableAxisMappingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsStateAvailableAxisMappingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsStateAvailableAxisMappingsUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_mapping_uid = (*env)->NewStringUTF (env, mapping_uid);
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_mapping_uid, j_name);
        (*env)->DeleteLocalRef (env, j_mapping_uid);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersStateCurrentAxisFiltersnativeCb (int32_t axis_id, char * filter_uid_or_builder, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersStateCurrentAxisFiltersListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersStateCurrentAxisFiltersListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersStateCurrentAxisFiltersUpdate", "(ILjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_filter_uid_or_builder = (*env)->NewStringUTF (env, filter_uid_or_builder);
        (*env)->CallVoidMethod (env, delegate, d_methodid, axis_id, j_filter_uid_or_builder);
        (*env)->DeleteLocalRef (env, j_filter_uid_or_builder);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersStateAllCurrentFiltersSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersStateAllCurrentFiltersSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersStateAllCurrentFiltersSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersStateAllCurrentFiltersSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersStatePresetAxisFiltersnativeCb (char * filter_uid, char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersStatePresetAxisFiltersListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersStatePresetAxisFiltersListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersStatePresetAxisFiltersUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_filter_uid = (*env)->NewStringUTF (env, filter_uid);
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_filter_uid, j_name);
        (*env)->DeleteLocalRef (env, j_filter_uid);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerAxisFiltersStateAllPresetFiltersSentnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerAxisFiltersStateAllPresetFiltersSentListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerAxisFiltersStateAllPresetFiltersSentListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerAxisFiltersStateAllPresetFiltersSentUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCoPilotingStatePilotingSourcenativeCb (eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE source, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCoPilotingStatePilotingSourceListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCoPilotingStatePilotingSourceListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCoPilotingStatePilotingSourceUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_source_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_ENUM");
        jmethodID j_source_mid = (*env)->GetStaticMethodID (env, j_source_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE_ENUM;");
        jobject j_source_enum = (*env)->CallStaticObjectMethod (env, j_source_class, j_source_mid, source);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_source_enum);
        (*env)->DeleteLocalRef (env, j_source_class);
        (*env)->DeleteLocalRef (env, j_source_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCalibrationStateMagnetoCalibrationStatenativeCb (eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS status, uint8_t X_Quality, uint8_t Y_Quality, uint8_t Z_Quality, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCalibrationStateMagnetoCalibrationStateListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCalibrationStateMagnetoCalibrationStateListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCalibrationStateMagnetoCalibrationStateUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_ENUM;BBB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_ENUM");
        jmethodID j_status_mid = (*env)->GetStaticMethodID (env, j_status_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS_ENUM;");
        jobject j_status_enum = (*env)->CallStaticObjectMethod (env, j_status_class, j_status_mid, status);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_status_enum, (jbyte)X_Quality, (jbyte)Y_Quality, (jbyte)Z_Quality);
        (*env)->DeleteLocalRef (env, j_status_class);
        (*env)->DeleteLocalRef (env, j_status_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStatenativeCb (uint8_t enabled, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_SkyControllerButtonEventsSettingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandSkyControllerButtonEventsSettingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandSkyControllerButtonEventsSettingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onSkyControllerButtonEventsSettingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_UnknownFeature1GeographicRunnativeCb (uint8_t start, uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1GeographicRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1GeographicRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1GeographicRunUpdate", "(BBFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)distance_is_default, distance, (jbyte)elevation_is_default, elevation, (jbyte)azimuth_is_default, azimuth);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1RelativeRunnativeCb (uint8_t start, uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1RelativeRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1RelativeRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1RelativeRunUpdate", "(BBFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)distance_is_default, distance, (jbyte)elevation_is_default, elevation, (jbyte)azimuth_is_default, azimuth);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1LookAtRunnativeCb (uint8_t start, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1LookAtRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1LookAtRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1LookAtRunUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1SpiralAnimRunnativeCb (uint8_t start, uint8_t speed_is_default, float speed, uint8_t revolution_nb_is_default, float revolution_number, uint8_t vertical_distance_is_default, float vertical_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1SpiralAnimRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1SpiralAnimRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1SpiralAnimRunUpdate", "(BBFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)speed_is_default, speed, (jbyte)revolution_nb_is_default, revolution_number, (jbyte)vertical_distance_is_default, vertical_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1SwingAnimRunnativeCb (uint8_t start, uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1SwingAnimRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1SwingAnimRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1SwingAnimRunUpdate", "(BBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)speed_is_default, speed, (jbyte)vertical_distance_is_default, vertical_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1BoomerangAnimRunnativeCb (uint8_t start, uint8_t speed_is_default, float speed, uint8_t distance_is_default, float distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1BoomerangAnimRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1BoomerangAnimRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1BoomerangAnimRunUpdate", "(BBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)speed_is_default, speed, (jbyte)distance_is_default, distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1CandleAnimRunnativeCb (uint8_t start, uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1CandleAnimRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1CandleAnimRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1CandleAnimRunUpdate", "(BBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)speed_is_default, speed, (jbyte)vertical_distance_is_default, vertical_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1DollySlideAnimRunnativeCb (uint8_t start, uint8_t speed_is_default, float speed, uint8_t angle_is_default, float angle, uint8_t horizontal_distance_is_default, float horizontal_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1DollySlideAnimRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1DollySlideAnimRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1DollySlideAnimRunUpdate", "(BBFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)start, (jbyte)speed_is_default, speed, (jbyte)angle_is_default, angle, (jbyte)horizontal_distance_is_default, horizontal_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1UserFramingPositionnativeCb (int8_t horizontal, int8_t vertical, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1UserFramingPositionListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1UserFramingPositionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1UserFramingPositionUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, horizontal, vertical);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1UserGPSDatanativeCb (double latitude, double longitude, float altitude, float horizontal_accuracy, float vertical_accuracy, float north_speed, float east_speed, float down_speed, double timestamp, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1UserGPSDataListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1UserGPSDataListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1UserGPSDataUpdate", "(DDFFFFFFD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude, altitude, horizontal_accuracy, vertical_accuracy, north_speed, east_speed, down_speed, timestamp);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1UserBaroDatanativeCb (float pressure, double timestamp, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1UserBaroDataListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1UserBaroDataListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1UserBaroDataUpdate", "(FD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, pressure, timestamp);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1LynxDetectionnativeCb (float target_pan, float target_tilt, float change_of_scale, uint8_t confidence_index, uint8_t is_new_selection, uint64_t timestamp, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1LynxDetectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1LynxDetectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1LynxDetectionUpdate", "(FFFBBJ)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, target_pan, target_tilt, change_of_scale, (jbyte)confidence_index, (jbyte)is_new_selection, (jlong)timestamp);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1AvailabilitynativeCb (eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1AvailabilityListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1AvailabilityListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1AvailabilityUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1RunnativeCb (eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1RunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1RunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1RunUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1GeographicConfigChangednativeCb (uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1GeographicConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1GeographicConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1GeographicConfigChangedUpdate", "(BFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)distance_is_default, distance, (jbyte)elevation_is_default, elevation, (jbyte)azimuth_is_default, azimuth);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1RelativeConfigChangednativeCb (uint8_t distance_is_default, float distance, uint8_t elevation_is_default, float elevation, uint8_t azimuth_is_default, float azimuth, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1RelativeConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1RelativeConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1RelativeConfigChangedUpdate", "(BFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)distance_is_default, distance, (jbyte)elevation_is_default, elevation, (jbyte)azimuth_is_default, azimuth);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1AnimRunnativeCb (eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1AnimRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1AnimRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1AnimRunUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1SpiralAnimConfigChangednativeCb (uint8_t speed_is_default, float speed, uint8_t revolution_nb_is_default, float revolution_nb, uint8_t vertical_distance_is_default, float vertical_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1SpiralAnimConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1SpiralAnimConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1SpiralAnimConfigChangedUpdate", "(BFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)speed_is_default, speed, (jbyte)revolution_nb_is_default, revolution_nb, (jbyte)vertical_distance_is_default, vertical_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1SwingAnimConfigChangednativeCb (uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1SwingAnimConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1SwingAnimConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1SwingAnimConfigChangedUpdate", "(BFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)speed_is_default, speed, (jbyte)vertical_distance_is_default, vertical_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1BoomerangAnimConfigChangednativeCb (uint8_t speed_is_default, float speed, uint8_t distance_is_default, float distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1BoomerangAnimConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1BoomerangAnimConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1BoomerangAnimConfigChangedUpdate", "(BFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)speed_is_default, speed, (jbyte)distance_is_default, distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1CandleAnimConfigChangednativeCb (uint8_t speed_is_default, float speed, uint8_t vertical_distance_is_default, float vertical_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1CandleAnimConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1CandleAnimConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1CandleAnimConfigChangedUpdate", "(BFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)speed_is_default, speed, (jbyte)vertical_distance_is_default, vertical_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1DollySlideAnimConfigChangednativeCb (uint8_t speed_is_default, float speed, uint8_t angle_is_default, float angle, uint8_t horizontal_distance_is_default, float horizontal_distance, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1DollySlideAnimConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1DollySlideAnimConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1DollySlideAnimConfigChangedUpdate", "(BFBFBF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)speed_is_default, speed, (jbyte)angle_is_default, angle, (jbyte)horizontal_distance_is_default, horizontal_distance);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_UnknownFeature1UserFramingPositionChangednativeCb (int8_t horizontal, int8_t vertical, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandUnknownFeature1UserFramingPositionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandUnknownFeature1UserFramingPositionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onUnknownFeature1UserFramingPositionChangedUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, horizontal, vertical);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_CommonNetworkDisconnectnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonNetworkDisconnectListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonNetworkDisconnectListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonNetworkDisconnectUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsAllSettingsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsAllSettingsListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsAllSettingsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsAllSettingsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsResetnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsResetListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsResetListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsResetUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsProductNamenativeCb (char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsProductNameListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsProductNameListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsProductNameUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_name);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsCountrynativeCb (char * code, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsCountryListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsCountryListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsCountryUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_code = (*env)->NewStringUTF (env, code);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_code);
        (*env)->DeleteLocalRef (env, j_code);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsAutoCountrynativeCb (uint8_t automatic, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsAutoCountryListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsAutoCountryListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsAutoCountryUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)automatic);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonAllStatesnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonAllStatesListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonAllStatesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonAllStatesUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonCurrentDatenativeCb (char * date, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonCurrentDateListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonCurrentDateListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonCurrentDateUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_date = (*env)->NewStringUTF (env, date);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_date);
        (*env)->DeleteLocalRef (env, j_date);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonCurrentTimenativeCb (char * time, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonCurrentTimeListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonCurrentTimeListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonCurrentTimeUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_time = (*env)->NewStringUTF (env, time);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_time);
        (*env)->DeleteLocalRef (env, j_time);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonRebootnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonRebootListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonRebootListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonRebootUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonOverHeatSwitchOffnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonOverHeatSwitchOffListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonOverHeatSwitchOffListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonOverHeatSwitchOffUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonOverHeatVentilatenativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonOverHeatVentilateListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonOverHeatVentilateListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonOverHeatVentilateUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonControllerIsPilotingnativeCb (uint8_t piloting, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonControllerIsPilotingListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonControllerIsPilotingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonControllerIsPilotingUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)piloting);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonWifiSettingsOutdoorSettingnativeCb (uint8_t outdoor, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonWifiSettingsOutdoorSettingListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonWifiSettingsOutdoorSettingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonWifiSettingsOutdoorSettingUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)outdoor);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonMavlinkStartnativeCb (char * filepath, eARCOMMANDS_COMMON_MAVLINK_START_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonMavlinkStartListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonMavlinkStartListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonMavlinkStartUpdate", "(Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINK_START_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_filepath = (*env)->NewStringUTF (env, filepath);
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINK_START_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINK_START_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_filepath, j_type_enum);
        (*env)->DeleteLocalRef (env, j_filepath);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonMavlinkPausenativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonMavlinkPauseListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonMavlinkPauseListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonMavlinkPauseUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonMavlinkStopnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonMavlinkStopListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonMavlinkStopListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonMavlinkStopUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCalibrationMagnetoCalibrationnativeCb (uint8_t calibrate, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCalibrationMagnetoCalibrationListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCalibrationMagnetoCalibrationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCalibrationMagnetoCalibrationUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)calibrate);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonGPSControllerPositionForRunnativeCb (double latitude, double longitude, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonGPSControllerPositionForRunListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonGPSControllerPositionForRunListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonGPSControllerPositionForRunUpdate", "(DD)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, latitude, longitude);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAudioControllerReadyForStreamingnativeCb (uint8_t ready, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAudioControllerReadyForStreamingListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAudioControllerReadyForStreamingListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAudioControllerReadyForStreamingUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)ready);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonHeadlightsIntensitynativeCb (uint8_t left, uint8_t right, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonHeadlightsIntensityListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonHeadlightsIntensityListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonHeadlightsIntensityUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)left, (jbyte)right);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAnimationsStartAnimationnativeCb (eARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM anim, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAnimationsStartAnimationListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAnimationsStartAnimationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAnimationsStartAnimationUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_anim_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_ENUM");
        jmethodID j_anim_mid = (*env)->GetStaticMethodID (env, j_anim_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STARTANIMATION_ANIM_ENUM;");
        jobject j_anim_enum = (*env)->CallStaticObjectMethod (env, j_anim_class, j_anim_mid, anim);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_anim_enum);
        (*env)->DeleteLocalRef (env, j_anim_class);
        (*env)->DeleteLocalRef (env, j_anim_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAnimationsStopAnimationnativeCb (eARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM anim, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAnimationsStopAnimationListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAnimationsStopAnimationListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAnimationsStopAnimationUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_anim_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_ENUM");
        jmethodID j_anim_mid = (*env)->GetStaticMethodID (env, j_anim_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONS_STOPANIMATION_ANIM_ENUM;");
        jobject j_anim_enum = (*env)->CallStaticObjectMethod (env, j_anim_class, j_anim_mid, anim);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_anim_enum);
        (*env)->DeleteLocalRef (env, j_anim_class);
        (*env)->DeleteLocalRef (env, j_anim_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAnimationsStopAllAnimationsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAnimationsStopAllAnimationsListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAnimationsStopAllAnimationsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAnimationsStopAllAnimationsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAccessoryConfignativeCb (eARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY accessory, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAccessoryConfigListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAccessoryConfigListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAccessoryConfigUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_accessory_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_ENUM");
        jmethodID j_accessory_mid = (*env)->GetStaticMethodID (env, j_accessory_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORY_CONFIG_ACCESSORY_ENUM;");
        jobject j_accessory_enum = (*env)->CallStaticObjectMethod (env, j_accessory_class, j_accessory_mid, accessory);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_accessory_enum);
        (*env)->DeleteLocalRef (env, j_accessory_class);
        (*env)->DeleteLocalRef (env, j_accessory_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonChargerSetMaxChargeRatenativeCb (eARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE rate, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonChargerSetMaxChargeRateListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonChargerSetMaxChargeRateListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonChargerSetMaxChargeRateUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_ENUM");
        jmethodID j_rate_mid = (*env)->GetStaticMethodID (env, j_rate_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGER_SETMAXCHARGERATE_RATE_ENUM;");
        jobject j_rate_enum = (*env)->CallStaticObjectMethod (env, j_rate_class, j_rate_mid, rate);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_rate_enum);
        (*env)->DeleteLocalRef (env, j_rate_class);
        (*env)->DeleteLocalRef (env, j_rate_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonNetworkEventDisconnectionnativeCb (eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE cause, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonNetworkEventDisconnectionListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonNetworkEventDisconnectionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonNetworkEventDisconnectionUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_cause_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_ENUM");
        jmethodID j_cause_mid = (*env)->GetStaticMethodID (env, j_cause_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE_ENUM;");
        jobject j_cause_enum = (*env)->CallStaticObjectMethod (env, j_cause_class, j_cause_mid, cause);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_cause_enum);
        (*env)->DeleteLocalRef (env, j_cause_class);
        (*env)->DeleteLocalRef (env, j_cause_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateAllSettingsChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateAllSettingsChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateAllSettingsChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateAllSettingsChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateResetChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateResetChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateResetChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateResetChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateProductNameChangednativeCb (char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateProductNameChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateProductNameChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateProductNameChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_name);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateProductVersionChangednativeCb (char * software, char * hardware, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateProductVersionChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateProductVersionChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateProductVersionChangedUpdate", "(Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_software = (*env)->NewStringUTF (env, software);
        jstring j_hardware = (*env)->NewStringUTF (env, hardware);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_software, j_hardware);
        (*env)->DeleteLocalRef (env, j_software);
        (*env)->DeleteLocalRef (env, j_hardware);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateProductSerialHighChangednativeCb (char * high, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateProductSerialHighChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateProductSerialHighChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateProductSerialHighChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_high = (*env)->NewStringUTF (env, high);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_high);
        (*env)->DeleteLocalRef (env, j_high);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateProductSerialLowChangednativeCb (char * low, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateProductSerialLowChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateProductSerialLowChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateProductSerialLowChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_low = (*env)->NewStringUTF (env, low);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_low);
        (*env)->DeleteLocalRef (env, j_low);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateCountryChangednativeCb (char * code, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateCountryChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateCountryChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateCountryChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_code = (*env)->NewStringUTF (env, code);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_code);
        (*env)->DeleteLocalRef (env, j_code);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonSettingsStateAutoCountryChangednativeCb (uint8_t automatic, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonSettingsStateAutoCountryChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonSettingsStateAutoCountryChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonSettingsStateAutoCountryChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)automatic);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateAllStatesChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateAllStatesChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateAllStatesChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateAllStatesChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateBatteryStateChangednativeCb (uint8_t percent, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateBatteryStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateBatteryStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateBatteryStateChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)percent);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateMassStorageStateListChangednativeCb (uint8_t mass_storage_id, char * name, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateMassStorageStateListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateMassStorageStateListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateMassStorageStateListChangedUpdate", "(BLjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_name = (*env)->NewStringUTF (env, name);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)mass_storage_id, j_name);
        (*env)->DeleteLocalRef (env, j_name);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateMassStorageInfoStateListChangednativeCb (uint8_t mass_storage_id, uint32_t size, uint32_t used_size, uint8_t plugged, uint8_t full, uint8_t internal, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateMassStorageInfoStateListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateMassStorageInfoStateListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateMassStorageInfoStateListChangedUpdate", "(BIIBBB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)mass_storage_id, (jint)size, (jint)used_size, (jbyte)plugged, (jbyte)full, (jbyte)internal);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateCurrentDateChangednativeCb (char * date, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateCurrentDateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateCurrentDateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateCurrentDateChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_date = (*env)->NewStringUTF (env, date);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_date);
        (*env)->DeleteLocalRef (env, j_date);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateCurrentTimeChangednativeCb (char * time, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateCurrentTimeChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateCurrentTimeChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateCurrentTimeChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_time = (*env)->NewStringUTF (env, time);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_time);
        (*env)->DeleteLocalRef (env, j_time);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateMassStorageInfoRemainingListChangednativeCb (uint32_t free_space, uint16_t rec_time, uint32_t photo_remaining, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateMassStorageInfoRemainingListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateMassStorageInfoRemainingListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateMassStorageInfoRemainingListChangedUpdate", "(ISI)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jint)free_space, (jshort)rec_time, (jint)photo_remaining);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateWifiSignalChangednativeCb (int16_t rssi, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateWifiSignalChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateWifiSignalChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateWifiSignalChangedUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, rssi);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateSensorsStatesListChangednativeCb (eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME sensorName, uint8_t sensorState, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateSensorsStatesListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateSensorsStatesListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateSensorsStatesListChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_sensorName_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_ENUM");
        jmethodID j_sensorName_mid = (*env)->GetStaticMethodID (env, j_sensorName_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME_ENUM;");
        jobject j_sensorName_enum = (*env)->CallStaticObjectMethod (env, j_sensorName_class, j_sensorName_mid, sensorName);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_sensorName_enum, (jbyte)sensorState);
        (*env)->DeleteLocalRef (env, j_sensorName_class);
        (*env)->DeleteLocalRef (env, j_sensorName_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateProductModelnativeCb (eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL model, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateProductModelListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateProductModelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateProductModelUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_model_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_ENUM");
        jmethodID j_model_mid = (*env)->GetStaticMethodID (env, j_model_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL_ENUM;");
        jobject j_model_enum = (*env)->CallStaticObjectMethod (env, j_model_class, j_model_mid, model);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_model_enum);
        (*env)->DeleteLocalRef (env, j_model_class);
        (*env)->DeleteLocalRef (env, j_model_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCommonStateCountryListKnownnativeCb (uint8_t listFlags, char * countryCodes, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCommonStateCountryListKnownListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCommonStateCountryListKnownListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCommonStateCountryListKnownUpdate", "(BLjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_countryCodes = (*env)->NewStringUTF (env, countryCodes);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)listFlags, j_countryCodes);
        (*env)->DeleteLocalRef (env, j_countryCodes);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonOverHeatStateOverHeatChangednativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonOverHeatStateOverHeatChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonOverHeatStateOverHeatChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonOverHeatStateOverHeatChangedUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonOverHeatStateOverHeatRegulationChangednativeCb (uint8_t regulationType, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonOverHeatStateOverHeatRegulationChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonOverHeatStateOverHeatRegulationChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonOverHeatStateOverHeatRegulationChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)regulationType);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonWifiSettingsStateOutdoorSettingsChangednativeCb (uint8_t outdoor, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonWifiSettingsStateOutdoorSettingsChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonWifiSettingsStateOutdoorSettingsChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonWifiSettingsStateOutdoorSettingsChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)outdoor);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonMavlinkStateMavlinkFilePlayingStateChangednativeCb (eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE state, char * filepath, eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonMavlinkStateMavlinkFilePlayingStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonMavlinkStateMavlinkFilePlayingStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonMavlinkStateMavlinkFilePlayingStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_ENUM;Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jstring j_filepath = (*env)->NewStringUTF (env, filepath);
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKFILEPLAYINGSTATECHANGED_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_state_enum, j_filepath, j_type_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_filepath);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonMavlinkStateMavlinkPlayErrorStateChangednativeCb (eARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonMavlinkStateMavlinkPlayErrorStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonMavlinkStateMavlinkPlayErrorStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonMavlinkStateMavlinkPlayErrorStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_MAVLINKSTATE_MAVLINKPLAYERRORSTATECHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_error_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCalibrationStateMagnetoCalibrationStateChangednativeCb (uint8_t xAxisCalibration, uint8_t yAxisCalibration, uint8_t zAxisCalibration, uint8_t calibrationFailed, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCalibrationStateMagnetoCalibrationStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCalibrationStateMagnetoCalibrationStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCalibrationStateMagnetoCalibrationStateChangedUpdate", "(BBBB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)xAxisCalibration, (jbyte)yAxisCalibration, (jbyte)zAxisCalibration, (jbyte)calibrationFailed);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCalibrationStateMagnetoCalibrationRequiredStatenativeCb (uint8_t required, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCalibrationStateMagnetoCalibrationRequiredStateListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCalibrationStateMagnetoCalibrationRequiredStateListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCalibrationStateMagnetoCalibrationRequiredStateUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)required);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangednativeCb (eARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS axis, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_axis_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_ENUM");
        jmethodID j_axis_mid = (*env)->GetStaticMethodID (env, j_axis_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CALIBRATIONSTATE_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED_AXIS_ENUM;");
        jobject j_axis_enum = (*env)->CallStaticObjectMethod (env, j_axis_class, j_axis_mid, axis);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_axis_enum);
        (*env)->DeleteLocalRef (env, j_axis_class);
        (*env)->DeleteLocalRef (env, j_axis_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCalibrationStateMagnetoCalibrationStartedChangednativeCb (uint8_t started, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCalibrationStateMagnetoCalibrationStartedChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCalibrationStateMagnetoCalibrationStartedChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCalibrationStateMagnetoCalibrationStartedChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)started);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonCameraSettingsStateCameraSettingsChangednativeCb (float fov, float panMax, float panMin, float tiltMax, float tiltMin, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonCameraSettingsStateCameraSettingsChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonCameraSettingsStateCameraSettingsChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonCameraSettingsStateCameraSettingsChangedUpdate", "(FFFFF)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, fov, panMax, panMin, tiltMax, tiltMin);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonFlightPlanStateAvailabilityStateChangednativeCb (uint8_t AvailabilityState, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonFlightPlanStateAvailabilityStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonFlightPlanStateAvailabilityStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonFlightPlanStateAvailabilityStateChangedUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)AvailabilityState);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonFlightPlanStateComponentStateListChangednativeCb (eARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT component, uint8_t State, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonFlightPlanStateComponentStateListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonFlightPlanStateComponentStateListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonFlightPlanStateComponentStateListChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_component_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_ENUM");
        jmethodID j_component_mid = (*env)->GetStaticMethodID (env, j_component_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_FLIGHTPLANSTATE_COMPONENTSTATELISTCHANGED_COMPONENT_ENUM;");
        jobject j_component_enum = (*env)->CallStaticObjectMethod (env, j_component_class, j_component_mid, component);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_component_enum, (jbyte)State);
        (*env)->DeleteLocalRef (env, j_component_class);
        (*env)->DeleteLocalRef (env, j_component_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonFlightPlanEventStartingErrorEventnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonFlightPlanEventStartingErrorEventListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonFlightPlanEventStartingErrorEventListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonFlightPlanEventStartingErrorEventUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonFlightPlanEventSpeedBridleEventnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonFlightPlanEventSpeedBridleEventListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonFlightPlanEventSpeedBridleEventListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonFlightPlanEventSpeedBridleEventUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonARLibsVersionsStateControllerLibARCommandsVersionnativeCb (char * version, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonARLibsVersionsStateControllerLibARCommandsVersionListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonARLibsVersionsStateControllerLibARCommandsVersionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonARLibsVersionsStateControllerLibARCommandsVersionUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_version = (*env)->NewStringUTF (env, version);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_version);
        (*env)->DeleteLocalRef (env, j_version);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionnativeCb (char * version, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonARLibsVersionsStateSkyControllerLibARCommandsVersionListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonARLibsVersionsStateSkyControllerLibARCommandsVersionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonARLibsVersionsStateSkyControllerLibARCommandsVersionUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_version = (*env)->NewStringUTF (env, version);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_version);
        (*env)->DeleteLocalRef (env, j_version);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonARLibsVersionsStateDeviceLibARCommandsVersionnativeCb (char * version, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonARLibsVersionsStateDeviceLibARCommandsVersionListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonARLibsVersionsStateDeviceLibARCommandsVersionListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonARLibsVersionsStateDeviceLibARCommandsVersionUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_version = (*env)->NewStringUTF (env, version);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_version);
        (*env)->DeleteLocalRef (env, j_version);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAudioStateAudioStreamingRunningnativeCb (uint8_t running, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAudioStateAudioStreamingRunningListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAudioStateAudioStreamingRunningListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAudioStateAudioStreamingRunningUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)running);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonHeadlightsStateIntensityChangednativeCb (uint8_t left, uint8_t right, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonHeadlightsStateIntensityChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonHeadlightsStateIntensityChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonHeadlightsStateIntensityChangedUpdate", "(BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)left, (jbyte)right);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAnimationsStateListnativeCb (eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM anim, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE state, eARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAnimationsStateListListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAnimationsStateListListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAnimationsStateListUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_anim_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_ENUM");
        jmethodID j_anim_mid = (*env)->GetStaticMethodID (env, j_anim_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ANIM_ENUM;");
        jobject j_anim_enum = (*env)->CallStaticObjectMethod (env, j_anim_class, j_anim_mid, anim);
        jclass j_state_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_ENUM");
        jmethodID j_state_mid = (*env)->GetStaticMethodID (env, j_state_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_STATE_ENUM;");
        jobject j_state_enum = (*env)->CallStaticObjectMethod (env, j_state_class, j_state_mid, state);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ANIMATIONSSTATE_LIST_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_anim_enum, j_state_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_anim_class);
        (*env)->DeleteLocalRef (env, j_anim_enum);
        (*env)->DeleteLocalRef (env, j_state_class);
        (*env)->DeleteLocalRef (env, j_state_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAccessoryStateSupportedAccessoriesListChangednativeCb (eARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY accessory, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAccessoryStateSupportedAccessoriesListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAccessoryStateSupportedAccessoriesListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAccessoryStateSupportedAccessoriesListChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_accessory_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_ENUM");
        jmethodID j_accessory_mid = (*env)->GetStaticMethodID (env, j_accessory_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_SUPPORTEDACCESSORIESLISTCHANGED_ACCESSORY_ENUM;");
        jobject j_accessory_enum = (*env)->CallStaticObjectMethod (env, j_accessory_class, j_accessory_mid, accessory);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_accessory_enum);
        (*env)->DeleteLocalRef (env, j_accessory_class);
        (*env)->DeleteLocalRef (env, j_accessory_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAccessoryStateAccessoryConfigChangednativeCb (eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY newAccessory, eARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR error, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAccessoryStateAccessoryConfigChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAccessoryStateAccessoryConfigChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAccessoryStateAccessoryConfigChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_newAccessory_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_ENUM");
        jmethodID j_newAccessory_mid = (*env)->GetStaticMethodID (env, j_newAccessory_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_NEWACCESSORY_ENUM;");
        jobject j_newAccessory_enum = (*env)->CallStaticObjectMethod (env, j_newAccessory_class, j_newAccessory_mid, newAccessory);
        jclass j_error_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_ENUM");
        jmethodID j_error_mid = (*env)->GetStaticMethodID (env, j_error_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_ACCESSORYSTATE_ACCESSORYCONFIGCHANGED_ERROR_ENUM;");
        jobject j_error_enum = (*env)->CallStaticObjectMethod (env, j_error_class, j_error_mid, error);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_newAccessory_enum, j_error_enum);
        (*env)->DeleteLocalRef (env, j_newAccessory_class);
        (*env)->DeleteLocalRef (env, j_newAccessory_enum);
        (*env)->DeleteLocalRef (env, j_error_class);
        (*env)->DeleteLocalRef (env, j_error_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonAccessoryStateAccessoryConfigModificationEnablednativeCb (uint8_t enabled, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonAccessoryStateAccessoryConfigModificationEnabledListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonAccessoryStateAccessoryConfigModificationEnabledListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonAccessoryStateAccessoryConfigModificationEnabledUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)enabled);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonChargerStateMaxChargeRateChangednativeCb (eARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE rate, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonChargerStateMaxChargeRateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonChargerStateMaxChargeRateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonChargerStateMaxChargeRateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_ENUM");
        jmethodID j_rate_mid = (*env)->GetStaticMethodID (env, j_rate_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_MAXCHARGERATECHANGED_RATE_ENUM;");
        jobject j_rate_enum = (*env)->CallStaticObjectMethod (env, j_rate_class, j_rate_mid, rate);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_rate_enum);
        (*env)->DeleteLocalRef (env, j_rate_class);
        (*env)->DeleteLocalRef (env, j_rate_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonChargerStateCurrentChargeStateChangednativeCb (eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS status, eARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE phase, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonChargerStateCurrentChargeStateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonChargerStateCurrentChargeStateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonChargerStateCurrentChargeStateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_ENUM");
        jmethodID j_status_mid = (*env)->GetStaticMethodID (env, j_status_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_STATUS_ENUM;");
        jobject j_status_enum = (*env)->CallStaticObjectMethod (env, j_status_class, j_status_mid, status);
        jclass j_phase_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_ENUM");
        jmethodID j_phase_mid = (*env)->GetStaticMethodID (env, j_phase_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CURRENTCHARGESTATECHANGED_PHASE_ENUM;");
        jobject j_phase_enum = (*env)->CallStaticObjectMethod (env, j_phase_class, j_phase_mid, phase);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_status_enum, j_phase_enum);
        (*env)->DeleteLocalRef (env, j_status_class);
        (*env)->DeleteLocalRef (env, j_status_enum);
        (*env)->DeleteLocalRef (env, j_phase_class);
        (*env)->DeleteLocalRef (env, j_phase_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonChargerStateLastChargeRateChangednativeCb (eARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE rate, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonChargerStateLastChargeRateChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonChargerStateLastChargeRateChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonChargerStateLastChargeRateChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_ENUM");
        jmethodID j_rate_mid = (*env)->GetStaticMethodID (env, j_rate_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_LASTCHARGERATECHANGED_RATE_ENUM;");
        jobject j_rate_enum = (*env)->CallStaticObjectMethod (env, j_rate_class, j_rate_mid, rate);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_rate_enum);
        (*env)->DeleteLocalRef (env, j_rate_class);
        (*env)->DeleteLocalRef (env, j_rate_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonChargerStateChargingInfonativeCb (eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE phase, eARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE rate, uint8_t intensity, uint8_t fullChargingTime, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonChargerStateChargingInfoListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonChargerStateChargingInfoListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonChargerStateChargingInfoUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_ENUM;BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_phase_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_ENUM");
        jmethodID j_phase_mid = (*env)->GetStaticMethodID (env, j_phase_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_PHASE_ENUM;");
        jobject j_phase_enum = (*env)->CallStaticObjectMethod (env, j_phase_class, j_phase_mid, phase);
        jclass j_rate_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_ENUM");
        jmethodID j_rate_mid = (*env)->GetStaticMethodID (env, j_rate_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMON_CHARGERSTATE_CHARGINGINFO_RATE_ENUM;");
        jobject j_rate_enum = (*env)->CallStaticObjectMethod (env, j_rate_class, j_rate_mid, rate);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_phase_enum, j_rate_enum, (jbyte)intensity, (jbyte)fullChargingTime);
        (*env)->DeleteLocalRef (env, j_phase_class);
        (*env)->DeleteLocalRef (env, j_phase_enum);
        (*env)->DeleteLocalRef (env, j_rate_class);
        (*env)->DeleteLocalRef (env, j_rate_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonRunStateRunIdChangednativeCb (char * runId, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonRunStateRunIdChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonRunStateRunIdChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonRunStateRunIdChangedUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_runId = (*env)->NewStringUTF (env, runId);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_runId);
        (*env)->DeleteLocalRef (env, j_runId);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_CommonDebugStatsSendPacketnativeCb (char * packet, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugStatsSendPacketListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugStatsSendPacketListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugStatsSendPacketUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_packet = (*env)->NewStringUTF (env, packet);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_packet);
        (*env)->DeleteLocalRef (env, j_packet);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugStatsStartSendingPacketFromDronenativeCb (uint8_t frequency, uint8_t packetSize, uint32_t date, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugStatsStartSendingPacketFromDroneListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugStatsStartSendingPacketFromDroneListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugStatsStartSendingPacketFromDroneUpdate", "(BBI)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)frequency, (jbyte)packetSize, (jint)date);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugStatsStopSendingPacketFromDronenativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugStatsStopSendingPacketFromDroneListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugStatsStopSendingPacketFromDroneListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugStatsStopSendingPacketFromDroneUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugDebugSettingsGetAllnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugDebugSettingsGetAllListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugDebugSettingsGetAllListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugDebugSettingsGetAllUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugDebugSettingsSetnativeCb (uint16_t id, char * value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugDebugSettingsSetListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugDebugSettingsSetListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugDebugSettingsSetUpdate", "(SLjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_value = (*env)->NewStringUTF (env, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)id, j_value);
        (*env)->DeleteLocalRef (env, j_value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugStatsEventSendPacketnativeCb (char * packet, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugStatsEventSendPacketListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugStatsEventSendPacketListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugStatsEventSendPacketUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_packet = (*env)->NewStringUTF (env, packet);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_packet);
        (*env)->DeleteLocalRef (env, j_packet);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugDebugSettingsStateInfonativeCb (uint8_t listFlags, uint16_t id, char * label, eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE type, eARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE mode, char * range_min, char * range_max, char * range_step, char * value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugDebugSettingsStateInfoListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugDebugSettingsStateInfoListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugDebugSettingsStateInfoUpdate", "(BSLjava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_ENUM;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_label = (*env)->NewStringUTF (env, label);
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_ENUM");
        jmethodID j_mode_mid = (*env)->GetStaticMethodID (env, j_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_COMMONDEBUG_DEBUGSETTINGSSTATE_INFO_MODE_ENUM;");
        jobject j_mode_enum = (*env)->CallStaticObjectMethod (env, j_mode_class, j_mode_mid, mode);
        jstring j_range_min = (*env)->NewStringUTF (env, range_min);
        jstring j_range_max = (*env)->NewStringUTF (env, range_max);
        jstring j_range_step = (*env)->NewStringUTF (env, range_step);
        jstring j_value = (*env)->NewStringUTF (env, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)listFlags, (jshort)id, j_label, j_type_enum, j_mode_enum, j_range_min, j_range_max, j_range_step, j_value);
        (*env)->DeleteLocalRef (env, j_label);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_mode_class);
        (*env)->DeleteLocalRef (env, j_mode_enum);
        (*env)->DeleteLocalRef (env, j_range_min);
        (*env)->DeleteLocalRef (env, j_range_max);
        (*env)->DeleteLocalRef (env, j_range_step);
        (*env)->DeleteLocalRef (env, j_value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_CommonDebugDebugSettingsStateListChangednativeCb (uint16_t id, char * value, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandCommonDebugDebugSettingsStateListChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandCommonDebugDebugSettingsStateListChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onCommonDebugDebugSettingsStateListChangedUpdate", "(SLjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_value = (*env)->NewStringUTF (env, value);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jshort)id, j_value);
        (*env)->DeleteLocalRef (env, j_value);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_ProProBoughtFeaturesnativeCb (uint64_t features, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandProProBoughtFeaturesListener", "Lcom/parrot/arsdk/arcommands/ARCommandProProBoughtFeaturesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onProProBoughtFeaturesUpdate", "(J)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jlong)features);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ProProResponsenativeCb (uint8_t listFlags, char * signedChallenge, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandProProResponseListener", "Lcom/parrot/arsdk/arcommands/ARCommandProProResponseListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onProProResponseUpdate", "(BLjava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_signedChallenge = (*env)->NewStringUTF (env, signedChallenge);
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)listFlags, j_signedChallenge);
        (*env)->DeleteLocalRef (env, j_signedChallenge);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ProProActivateFeaturesnativeCb (uint64_t features, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandProProActivateFeaturesListener", "Lcom/parrot/arsdk/arcommands/ARCommandProProActivateFeaturesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onProProActivateFeaturesUpdate", "(J)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jlong)features);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ProProStateSupportedFeaturesnativeCb (eARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS status, uint64_t features, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandProProStateSupportedFeaturesListener", "Lcom/parrot/arsdk/arcommands/ARCommandProProStateSupportedFeaturesListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onProProStateSupportedFeaturesUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_ENUM;J)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_status_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_ENUM");
        jmethodID j_status_mid = (*env)->GetStaticMethodID (env, j_status_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_PRO_PROSTATE_SUPPORTEDFEATURES_STATUS_ENUM;");
        jobject j_status_enum = (*env)->CallStaticObjectMethod (env, j_status_class, j_status_mid, status);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_status_enum, (jlong)features);
        (*env)->DeleteLocalRef (env, j_status_class);
        (*env)->DeleteLocalRef (env, j_status_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ProProStateFeaturesActivatednativeCb (uint64_t features, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandProProStateFeaturesActivatedListener", "Lcom/parrot/arsdk/arcommands/ARCommandProProStateFeaturesActivatedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onProProStateFeaturesActivatedUpdate", "(J)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jlong)features);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_ProProEventChallengeEventnativeCb (char * challenge, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandProProEventChallengeEventListener", "Lcom/parrot/arsdk/arcommands/ARCommandProProEventChallengeEventListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onProProEventChallengeEventUpdate", "(Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_challenge = (*env)->NewStringUTF (env, challenge);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_challenge);
        (*env)->DeleteLocalRef (env, j_challenge);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


void ARCOMMANDS_JNI_WifiScannativeCb (uint8_t band, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiScanListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiScanListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiScanUpdate", "(B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, (jbyte)band);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiUpdateAuthorizedChannelsnativeCb (void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiUpdateAuthorizedChannelsListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiUpdateAuthorizedChannelsListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiUpdateAuthorizedChannelsUpdate", "()V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiSetApChannelnativeCb (eARCOMMANDS_WIFI_SELECTION_TYPE type, eARCOMMANDS_WIFI_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiSetApChannelListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiSetApChannelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiSetApChannelUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiSetSecuritynativeCb (eARCOMMANDS_WIFI_SECURITY_TYPE type, char * key, eARCOMMANDS_WIFI_SECURITY_KEY_TYPE key_type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiSetSecurityListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiSetSecurityListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiSetSecurityUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM;Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_KEY_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jstring j_key = (*env)->NewStringUTF (env, key);
        jclass j_key_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_KEY_TYPE_ENUM");
        jmethodID j_key_type_mid = (*env)->GetStaticMethodID (env, j_key_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_KEY_TYPE_ENUM;");
        jobject j_key_type_enum = (*env)->CallStaticObjectMethod (env, j_key_type_class, j_key_type_mid, key_type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_key, j_key_type_enum);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_key);
        (*env)->DeleteLocalRef (env, j_key_type_class);
        (*env)->DeleteLocalRef (env, j_key_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiSetCountrynativeCb (eARCOMMANDS_WIFI_COUNTRY_SELECTION selection_mode, char * code, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiSetCountryListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiSetCountryListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiSetCountryUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_selection_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM");
        jmethodID j_selection_mode_mid = (*env)->GetStaticMethodID (env, j_selection_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM;");
        jobject j_selection_mode_enum = (*env)->CallStaticObjectMethod (env, j_selection_mode_class, j_selection_mode_mid, selection_mode);
        jstring j_code = (*env)->NewStringUTF (env, code);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_selection_mode_enum, j_code);
        (*env)->DeleteLocalRef (env, j_selection_mode_class);
        (*env)->DeleteLocalRef (env, j_selection_mode_enum);
        (*env)->DeleteLocalRef (env, j_code);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiSetEnvironementnativeCb (eARCOMMANDS_WIFI_ENVIRONEMENT environement, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiSetEnvironementListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiSetEnvironementListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiSetEnvironementUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_environement_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM");
        jmethodID j_environement_mid = (*env)->GetStaticMethodID (env, j_environement_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM;");
        jobject j_environement_enum = (*env)->CallStaticObjectMethod (env, j_environement_class, j_environement_mid, environement);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_environement_enum);
        (*env)->DeleteLocalRef (env, j_environement_class);
        (*env)->DeleteLocalRef (env, j_environement_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiScannedItemnativeCb (char * ssid, int16_t rssi, eARCOMMANDS_WIFI_BAND band, uint8_t channel, uint8_t list_flags, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiScannedItemListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiScannedItemListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiScannedItemUpdate", "(Ljava/lang/String;SLcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;BB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_ssid = (*env)->NewStringUTF (env, ssid);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_ssid, rssi, j_band_enum, (jbyte)channel, (jbyte)list_flags);
        (*env)->DeleteLocalRef (env, j_ssid);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiAuthorizedChannelnativeCb (eARCOMMANDS_WIFI_BAND band, uint8_t channel, uint8_t environement, uint8_t list_flags, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiAuthorizedChannelListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiAuthorizedChannelListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiAuthorizedChannelUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;BBB)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_band_enum, (jbyte)channel, (jbyte)environement, (jbyte)list_flags);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiApChannelChangednativeCb (eARCOMMANDS_WIFI_SELECTION_TYPE type, eARCOMMANDS_WIFI_BAND band, uint8_t channel, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiApChannelChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiApChannelChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiApChannelChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;B)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM");
        jmethodID j_type_mid = (*env)->GetStaticMethodID (env, j_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SELECTION_TYPE_ENUM;");
        jobject j_type_enum = (*env)->CallStaticObjectMethod (env, j_type_class, j_type_mid, type);
        jclass j_band_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM");
        jmethodID j_band_mid = (*env)->GetStaticMethodID (env, j_band_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_BAND_ENUM;");
        jobject j_band_enum = (*env)->CallStaticObjectMethod (env, j_band_class, j_band_mid, band);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_type_enum, j_band_enum, (jbyte)channel);
        (*env)->DeleteLocalRef (env, j_type_class);
        (*env)->DeleteLocalRef (env, j_type_enum);
        (*env)->DeleteLocalRef (env, j_band_class);
        (*env)->DeleteLocalRef (env, j_band_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiSecurityChangednativeCb (char * key, eARCOMMANDS_WIFI_SECURITY_TYPE key_type, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiSecurityChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiSecurityChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiSecurityChangedUpdate", "(Ljava/lang/String;Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jstring j_key = (*env)->NewStringUTF (env, key);
        jclass j_key_type_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM");
        jmethodID j_key_type_mid = (*env)->GetStaticMethodID (env, j_key_type_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_SECURITY_TYPE_ENUM;");
        jobject j_key_type_enum = (*env)->CallStaticObjectMethod (env, j_key_type_class, j_key_type_mid, key_type);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_key, j_key_type_enum);
        (*env)->DeleteLocalRef (env, j_key);
        (*env)->DeleteLocalRef (env, j_key_type_class);
        (*env)->DeleteLocalRef (env, j_key_type_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiCountryChangednativeCb (eARCOMMANDS_WIFI_COUNTRY_SELECTION selection_mode, char * code, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiCountryChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiCountryChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiCountryChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM;Ljava/lang/String;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_selection_mode_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM");
        jmethodID j_selection_mode_mid = (*env)->GetStaticMethodID (env, j_selection_mode_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_COUNTRY_SELECTION_ENUM;");
        jobject j_selection_mode_enum = (*env)->CallStaticObjectMethod (env, j_selection_mode_class, j_selection_mode_mid, selection_mode);
        jstring j_code = (*env)->NewStringUTF (env, code);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_selection_mode_enum, j_code);
        (*env)->DeleteLocalRef (env, j_selection_mode_class);
        (*env)->DeleteLocalRef (env, j_selection_mode_enum);
        (*env)->DeleteLocalRef (env, j_code);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiEnvironementChangednativeCb (eARCOMMANDS_WIFI_ENVIRONEMENT environement, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiEnvironementChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiEnvironementChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiEnvironementChangedUpdate", "(Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM;)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        jclass j_environement_class = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM");
        jmethodID j_environement_mid = (*env)->GetStaticMethodID (env, j_environement_class, "getFromValue", "(I)Lcom/parrot/arsdk/arcommands/ARCOMMANDS_WIFI_ENVIRONEMENT_ENUM;");
        jobject j_environement_enum = (*env)->CallStaticObjectMethod (env, j_environement_class, j_environement_mid, environement);
        (*env)->CallVoidMethod (env, delegate, d_methodid, j_environement_enum);
        (*env)->DeleteLocalRef (env, j_environement_class);
        (*env)->DeleteLocalRef (env, j_environement_enum);
    }
    (*env)->DeleteLocalRef (env, delegate);
}

void ARCOMMANDS_JNI_WifiRssiChangednativeCb (int16_t rssi, void *custom)
{
    jclass clazz = (jclass)custom;
    jint res;
    JNIEnv *env = NULL;
    res = (*g_vm)->GetEnv (g_vm, (void **)&env, JNI_VERSION_1_6);
    if (res < 0) { return; }
    jfieldID delegate_fid = (*env)->GetStaticFieldID (env, clazz, "_ARCommandWifiRssiChangedListener", "Lcom/parrot/arsdk/arcommands/ARCommandWifiRssiChangedListener;");
    jobject delegate = (*env)->GetStaticObjectField (env, clazz, delegate_fid);
    if (delegate == NULL) { return; }

    jclass d_clazz = (*env)->GetObjectClass (env, delegate);
    jmethodID d_methodid = (*env)->GetMethodID (env, d_clazz, "onWifiRssiChangedUpdate", "(S)V");
    (*env)->DeleteLocalRef (env, d_clazz);
    if (d_methodid != NULL)
    {
        (*env)->CallVoidMethod (env, delegate, d_methodid, rssi);
    }
    (*env)->DeleteLocalRef (env, delegate);
}


JNIEXPORT jint JNICALL
JNI_OnLoad (JavaVM *vm, void *reserved)
{
    g_vm = vm;
    JNIEnv *env = NULL;
    if ((*vm)->GetEnv (vm, (void **)&env, JNI_VERSION_1_6) != JNI_OK)
    {
        return -1;
    }
    jclass clazz = (*env)->FindClass (env, "com/parrot/arsdk/arcommands/ARCommand");
    if (clazz == NULL)
    {
        return -1;
    }
    jclass g_class = (*env)->NewGlobalRef (env, clazz);
    if (g_class == NULL)
    {
        return -1;
    }

    ARCOMMANDS_Decoder_SetGenericDefaultCallback (ARCOMMANDS_JNI_GenericDefaultnativeCb, (void *)g_class);


    ARCOMMANDS_Decoder_SetARDrone3PilotingFlatTrimCallback (ARCOMMANDS_JNI_ARDrone3PilotingFlatTrimnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingTakeOffCallback (ARCOMMANDS_JNI_ARDrone3PilotingTakeOffnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingPCMDCallback (ARCOMMANDS_JNI_ARDrone3PilotingPCMDnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingLandingCallback (ARCOMMANDS_JNI_ARDrone3PilotingLandingnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingEmergencyCallback (ARCOMMANDS_JNI_ARDrone3PilotingEmergencynativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingNavigateHomeCallback (ARCOMMANDS_JNI_ARDrone3PilotingNavigateHomenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingAutoTakeOffModeCallback (ARCOMMANDS_JNI_ARDrone3PilotingAutoTakeOffModenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingMoveByCallback (ARCOMMANDS_JNI_ARDrone3PilotingMoveBynativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingUserTakeOffCallback (ARCOMMANDS_JNI_ARDrone3PilotingUserTakeOffnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingCircleCallback (ARCOMMANDS_JNI_ARDrone3PilotingCirclenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3AnimationsFlipCallback (ARCOMMANDS_JNI_ARDrone3AnimationsFlipnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3CameraOrientationCallback (ARCOMMANDS_JNI_ARDrone3CameraOrientationnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordPictureCallback (ARCOMMANDS_JNI_ARDrone3MediaRecordPicturenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordVideoCallback (ARCOMMANDS_JNI_ARDrone3MediaRecordVideonativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordPictureV2Callback (ARCOMMANDS_JNI_ARDrone3MediaRecordPictureV2nativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordVideoV2Callback (ARCOMMANDS_JNI_ARDrone3MediaRecordVideoV2nativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkWifiScanCallback (ARCOMMANDS_JNI_ARDrone3NetworkWifiScannativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkWifiAuthChannelCallback (ARCOMMANDS_JNI_ARDrone3NetworkWifiAuthChannelnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxAltitudeCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsMaxAltitudenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxTiltCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsMaxTiltnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsAbsolutControlCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsAbsolutControlnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxDistanceCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsMaxDistancenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsNoFlyOverMaxDistancenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsBankedTurnCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsBankedTurnnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMinAltitudeCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsMinAltitudenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingDirectionCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsCirclingDirectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingRadiusCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsCirclingRadiusnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingAltitudeCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsCirclingAltitudenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsPitchModeCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsPitchModenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsLandingModeCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsLandingModenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxVerticalSpeedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsMaxVerticalSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxRotationSpeedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsMaxRotationSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsHullProtectionCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsHullProtectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsOutdoorCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsOutdoornativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsMaxPitchRollRotationSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsWifiSelectionCallback (ARCOMMANDS_JNI_ARDrone3NetworkSettingsWifiSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsWifiSecurityCallback (ARCOMMANDS_JNI_ARDrone3NetworkSettingsWifiSecuritynativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsPictureFormatSelectionCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsPictureFormatSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsAutoWhiteBalanceSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsExpositionSelectionCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsExpositionSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsSaturationSelectionCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsSaturationSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsTimelapseSelectionCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsTimelapseSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsVideoAutorecordSelectionCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsVideoAutorecordSelectionnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsVideoStabilizationModeCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsVideoStabilizationModenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaStreamingVideoEnableCallback (ARCOMMANDS_JNI_ARDrone3MediaStreamingVideoEnablenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsSetHomeCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsSetHomenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsResetHomeCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsResetHomenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsSendControllerGPSCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsSendControllerGPSnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsHomeTypeCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsHomeTypenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsReturnHomeDelayCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsReturnHomeDelaynativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3AntiflickeringElectricFrequencyCallback (ARCOMMANDS_JNI_ARDrone3AntiflickeringElectricFrequencynativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3AntiflickeringSetModeCallback (ARCOMMANDS_JNI_ARDrone3AntiflickeringSetModenativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedCallback (ARCOMMANDS_JNI_ARDrone3MediaRecordStatePictureStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedCallback (ARCOMMANDS_JNI_ARDrone3MediaRecordStateVideoStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_JNI_ARDrone3MediaRecordStatePictureStateChangedV2nativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedV2Callback (ARCOMMANDS_JNI_ARDrone3MediaRecordStateVideoStateChangedV2nativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventPictureEventChangedCallback (ARCOMMANDS_JNI_ARDrone3MediaRecordEventPictureEventChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventVideoEventChangedCallback (ARCOMMANDS_JNI_ARDrone3MediaRecordEventVideoEventChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlatTrimChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateFlatTrimChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlyingStateChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateFlyingStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateAlertStateChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateAlertStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateNavigateHomeStateChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateNavigateHomeStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStatePositionChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStatePositionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateSpeedChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateSpeedChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateAttitudeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateAttitudeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateAutoTakeOffModeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateAutoTakeOffModeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingStateAltitudeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingStateAltitudeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingEventMoveByEndCallback (ARCOMMANDS_JNI_ARDrone3PilotingEventMoveByEndnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiScanListChangedCallback (ARCOMMANDS_JNI_ARDrone3NetworkStateWifiScanListChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiScanChangedCallback (ARCOMMANDS_JNI_ARDrone3NetworkStateAllWifiScanChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiAuthChannelListChangedCallback (ARCOMMANDS_JNI_ARDrone3NetworkStateWifiAuthChannelListChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_JNI_ARDrone3NetworkStateAllWifiAuthChannelChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxAltitudeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMaxAltitudeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxTiltChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMaxTiltChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAbsolutControlChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAbsolutControlChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxDistanceChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMaxDistanceChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateBankedTurnChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateBankedTurnChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMinAltitudeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateMinAltitudeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingDirectionChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateCirclingDirectionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingRadiusChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateCirclingRadiusChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateCirclingAltitudeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStatePitchModeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStatePitchModeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateLandingModeChangedCallback (ARCOMMANDS_JNI_ARDrone3PilotingSettingsStateLandingModeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateMaxRotationSpeedChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateHullProtectionChangedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateHullProtectionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateOutdoorChangedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateOutdoorChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback (ARCOMMANDS_JNI_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_JNI_ARDrone3NetworkSettingsStateWifiSelectionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityChangedCallback (ARCOMMANDS_JNI_ARDrone3NetworkSettingsStateWifiSecurityChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityCallback (ARCOMMANDS_JNI_ARDrone3NetworkSettingsStateWifiSecuritynativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductMotorVersionListChangedCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateProductMotorVersionListChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductGPSVersionChangedCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateProductGPSVersionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorStateChangedCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateMotorErrorStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorSoftwareVersionChangedCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateMotorSoftwareVersionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorFlightsStatusChangedCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateMotorFlightsStatusChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorLastErrorChangedCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateMotorErrorLastErrorChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3SettingsStateP7IDCallback (ARCOMMANDS_JNI_ARDrone3SettingsStateP7IDnativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStatePictureFormatChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStatePictureFormatChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStateAutoWhiteBalanceChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateExpositionChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStateExpositionChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateSaturationChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStateSaturationChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateTimelapseChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStateTimelapseChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoAutorecordChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStateVideoAutorecordChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback (ARCOMMANDS_JNI_ARDrone3PictureSettingsStateVideoStabilizationModeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3MediaStreamingStateVideoEnableChangedCallback (ARCOMMANDS_JNI_ARDrone3MediaStreamingStateVideoEnableChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeChangedCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsStateHomeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateResetHomeChangedCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsStateResetHomeChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSFixStateChangedCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsStateGPSFixStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSUpdateStateChangedCallback (ARCOMMANDS_JNI_ARDrone3GPSSettingsStateGPSUpdateStateChangednativeCb, (void *)g_class);

    ARCOMMANDS_Decoder_SetA