/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/********************************************
 *            AUTOGENERATED FILE            *
 *             DO NOT MODIFY IT             *
 *                                          *
 * To add new commands :                    *
 *  - Modify ../Xml/commands.xml file       *
 *  - Re-run generateCommandsList.py script *
 *                                          *
 ********************************************/
#include <config.h>
#include <stdio.h>
#include "ARCOMMANDS_ReadWrite.h"
#include <libARCommands/ARCOMMANDS_Types.h>
#include <libARCommands/ARCOMMANDS_Decoder.h>
#include <libARCommands/ARCOMMANDS_Ids.h>
#include <libARSAL/ARSAL_Mutex.h>

// CALLBACK VARIABLES + SETTERS

static ARSAL_Mutex_t ARCOMMANDS_Decoder_Mutex;
static int ARCOMMANDS_Decoder_IsInit = 0;
static int ARCOMMANDS_Decoder_Init (void)
{
    if ((ARCOMMANDS_Decoder_IsInit == 0) &&
        (ARSAL_Mutex_Init (&ARCOMMANDS_Decoder_Mutex) == 0))
    {
        ARCOMMANDS_Decoder_IsInit = 1;
    } // No else --> Do nothing if already initialized
    return ARCOMMANDS_Decoder_IsInit;
}

// Feature generic

static ARCOMMANDS_Decoder_GenericDefaultCallback_t ARCOMMANDS_Decoder_GenericDefaultCb = NULL;
static void *ARCOMMANDS_Decoder_GenericDefaultCustom = NULL;
void ARCOMMANDS_Decoder_SetGenericDefaultCallback (ARCOMMANDS_Decoder_GenericDefaultCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_GenericDefaultCb = callback;
        ARCOMMANDS_Decoder_GenericDefaultCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature ARDrone3

static ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingFlatTrimCallback (ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingTakeOffCallback (ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingPCMDCallback (ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingLandingCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingLandingCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingLandingCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingLandingCallback (ARCOMMANDS_Decoder_ARDrone3PilotingLandingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingLandingCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingLandingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingEmergencyCallback (ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingNavigateHomeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingAutoTakeOffModeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingMoveByCallback (ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingUserTakeOffCallback (ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingCircleCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingCircleCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingCircleCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingCircleCallback (ARCOMMANDS_Decoder_ARDrone3PilotingCircleCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingCircleCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingCircleCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCallback_t ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3AnimationsFlipCallback (ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCb = callback;
        ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3CameraOrientationCallback_t ARCOMMANDS_Decoder_ARDrone3CameraOrientationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3CameraOrientationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3CameraOrientationCallback (ARCOMMANDS_Decoder_ARDrone3CameraOrientationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3CameraOrientationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3CameraOrientationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCallback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordPictureCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCallback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordVideoCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Callback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Cb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Custom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordPictureV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Cb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Callback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Cb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Custom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordVideoV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Cb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkWifiScanCallback (ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkWifiAuthChannelCallback (ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxAltitudeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxTiltCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsAbsolutControlCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMaxDistanceCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsBankedTurnCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsMinAltitudeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingDirectionCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingRadiusCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsCirclingAltitudeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsPitchModeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsLandingModeCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsHullProtectionCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsOutdoorCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsWifiSelectionCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsWifiSecurityCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsPictureFormatSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsExpositionSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsSaturationSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsTimelapseSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsVideoAutorecordSelectionCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsVideoStabilizationModeCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCallback_t ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaStreamingVideoEnableCallback (ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsSetHomeCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsResetHomeCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsSendControllerGPSCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsHomeTypeCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsReturnHomeDelayCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCallback_t ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringElectricFrequencyCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCb = callback;
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCallback_t ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringSetModeCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCb = callback;
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Callback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Cb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Custom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Cb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Callback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Cb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Custom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedV2Callback (ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Cb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCallback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventPictureEventChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCallback_t ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventVideoEventChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlatTrimChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlyingStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAlertStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateNavigateHomeStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStatePositionChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAttitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAutoTakeOffModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingStateAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingEventMoveByEndCallback (ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiScanListChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiScanChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiAuthChannelListChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxTiltChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAbsolutControlChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxDistanceChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateBankedTurnChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMinAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingDirectionChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingRadiusChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStatePitchModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateLandingModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateHullProtectionChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateOutdoorChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityChangedCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCallback_t ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityCallback (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCb = callback;
        ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductMotorVersionListChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductGPSVersionChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorSoftwareVersionChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorFlightsStatusChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorLastErrorChangedCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCallback_t ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3SettingsStateP7IDCallback (ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCb = callback;
        ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStatePictureFormatChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateExpositionChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateSaturationChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateTimelapseChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoAutorecordChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCallback_t ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3MediaStreamingStateVideoEnableChangedCallback (ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateResetHomeChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSFixStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSUpdateStateChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeTypeChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateReturnHomeDelayChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCallback_t ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3CameraStateOrientationCallback (ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCallback_t ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3CameraStateDefaultCameraOrientationCallback (ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCb = callback;
        ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCallback_t ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateElectricFrequencyChangedCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCallback_t ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateModeChangedCallback (ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSStateNumberOfSatelliteChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeAvailabilityChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCallback_t ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeChosenChangedCallback (ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCb = callback;
        ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCallback_t ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCb = NULL;
static void *ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCustom = NULL;
void ARCOMMANDS_Decoder_SetARDrone3PROStateFeaturesCallback (ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCb = callback;
        ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature JumpingSumo

static ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCallback_t ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingPCMDCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCallback_t ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingPostureCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCallback_t ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingAddCapOffsetCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpStopCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpCancelCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpLoadCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsJumpCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsSimpleAnimationCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordPictureCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordVideoCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Callback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Cb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Custom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordPictureV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Cb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Callback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Cb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Custom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordVideoV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Cb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkSettingsWifiSelectionCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkWifiScanCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkWifiAuthChannelCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCallback_t ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsMasterVolumeCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCallback_t ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsThemeCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanAllScriptsMetadataCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanScriptUploadedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanScriptDeleteCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanPlayScriptCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCallback_t ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoSpeedSettingsOutdoorCallback (ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaStreamingVideoEnableCallback (ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCallback_t ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoVideoSettingsAutorecordCallback (ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingStatePostureChangedCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateAlertStateChangedCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateSpeedChangedCallback (ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpLoadChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpTypeChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpMotorProblemChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoSettingsStateProductGPSVersionChangedCallback (ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Callback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Cb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Custom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Cb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Callback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Cb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Custom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedV2Callback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Cb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventPictureEventChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventVideoEventChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiScanListChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiScanChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiAuthChannelListChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateLinkQualityChangedCallback (ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateMasterVolumeChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateThemeChangedCallback (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptMetadataListChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptUploadChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptDeleteChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStatePlayScriptChangedCallback (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoSpeedSettingsStateOutdoorChangedCallback (ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoMediaStreamingStateVideoEnableChangedCallback (ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCallback_t ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCb = NULL;
static void *ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetJumpingSumoVideoSettingsStateAutorecordChangedCallback (ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCb = callback;
        ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature MiniDrone

static ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCallback_t ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingFlatTrimCallback (ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCallback_t ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingTakeOffCallback (ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingPCMDCallback_t ARCOMMANDS_Decoder_MiniDronePilotingPCMDCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingPCMDCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingPCMDCallback (ARCOMMANDS_Decoder_MiniDronePilotingPCMDCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingPCMDCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingPCMDCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingLandingCallback_t ARCOMMANDS_Decoder_MiniDronePilotingLandingCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingLandingCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingLandingCallback (ARCOMMANDS_Decoder_MiniDronePilotingLandingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingLandingCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingLandingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCallback_t ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingEmergencyCallback (ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCallback_t ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingAutoTakeOffModeCallback (ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCallback_t ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneAnimationsFlipCallback (ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCb = callback;
        ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneAnimationsCapCallback_t ARCOMMANDS_Decoder_MiniDroneAnimationsCapCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneAnimationsCapCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneAnimationsCapCallback (ARCOMMANDS_Decoder_MiniDroneAnimationsCapCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneAnimationsCapCb = callback;
        ARCOMMANDS_Decoder_MiniDroneAnimationsCapCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCallback_t ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordPictureCallback (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCb = callback;
        ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Callback_t ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Cb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Custom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordPictureV2Callback (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Cb = callback;
        ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCallback_t ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsMaxAltitudeCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCallback_t ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsMaxTiltCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsMaxVerticalSpeedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsMaxRotationSpeedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsWheelsCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsMaxHorizontalSpeedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCallback_t ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSettingsCutOutModeCallback (ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCallback_t ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneGPSControllerLatitudeForRunCallback (ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCb = callback;
        ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCallback_t ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneGPSControllerLongitudeForRunCallback (ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCb = callback;
        ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCallback_t ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneConfigurationControllerTypeCallback (ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCb = callback;
        ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCallback_t ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneConfigurationControllerNameCallback (ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCb = callback;
        ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCallback_t ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlatTrimChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCallback_t ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlyingStateChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCallback_t ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateAlertStateChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCallback_t ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingStateAutoTakeOffModeChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCallback_t ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedCallback (ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Callback_t ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Cb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Custom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedV2Callback (ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Callback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Cb = callback;
        ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Custom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCallback_t ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneMediaRecordEventPictureEventChangedCallback (ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCallback_t ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxAltitudeChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCallback_t ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxTiltChangedCallback (ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateWheelsChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductMotorsVersionChangedCallback (ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductInertialVersionChangedCallback (ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCallback_t ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneSettingsStateCutOutModeChangedCallback (ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCallback_t ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCb = NULL;
static void *ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetMiniDroneFloodControlStateFloodControlChangedCallback (ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCb = callback;
        ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature SkyController

static ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCallback_t ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiRequestWifiListCallback (ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCallback_t ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiRequestCurrentWifiCallback (ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCallback_t ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiConnectToWifiCallback (ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCallback_t ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiForgetWifiCallback (ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCallback_t ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiWifiAuthChannelCallback (ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCallback_t ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerDeviceRequestDeviceListCallback (ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCb = callback;
        ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCallback_t ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerDeviceRequestCurrentDeviceCallback (ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCb = callback;
        ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCallback_t ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerDeviceConnectToDeviceCallback (ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCb = callback;
        ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCallback_t ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSettingsAllSettingsCallback (ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSettingsResetCallback_t ARCOMMANDS_Decoder_SkyControllerSettingsResetCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSettingsResetCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSettingsResetCallback (ARCOMMANDS_Decoder_SkyControllerSettingsResetCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSettingsResetCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSettingsResetCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCallback_t ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCommonAllStatesCallback (ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCallback_t ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsAccessPointSSIDCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCallback_t ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsAccessPointChannelCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCallback_t ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsWifiSelectionCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCallback_t ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCameraResetOrientationCallback (ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCallback_t ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerGamepadInfosGetGamepadControlsCallback (ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsGetCurrentButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsGetAvailableButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsSetButtonMappingCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsDefaultButtonMappingCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsGetCurrentAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsGetAvailableAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsSetAxisMappingCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsDefaultAxisMappingCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersGetCurrentAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersGetPresetAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersSetAxisFilterCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersDefaultAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCallback_t ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCoPilotingSetPilotingSourceCallback (ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCallback_t ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCallback (ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCallback_t ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateWifiListCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCallback_t ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateConnexionChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCallback_t ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateWifiAuthChannelListChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCallback_t ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateAllWifiAuthChannelChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCallback_t ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerWifiStateWifiSignalChangedCallback (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCallback_t ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerDeviceStateDeviceListCallback (ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCb = callback;
        ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCallback_t ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerDeviceStateConnexionChangedCallback (ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateAllSettingsChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateResetChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateProductSerialChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSettingsStateProductVariantChangedCallback (ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCallback_t ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCommonStateAllStatesChangedCallback (ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSkyControllerStateBatteryChangedCallback (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSkyControllerStateGpsFixChangedCallback (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCallback_t ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerSkyControllerStateGpsPositionChangedCallback (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCallback_t ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsStateAccessPointSSIDChangedCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCallback_t ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsStateAccessPointChannelChangedCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCallback_t ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAccessPointSettingsStateWifiSelectionChangedCallback (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCallback_t ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerGamepadInfosStateGamepadControlCallback (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCb = callback;
        ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCallback_t ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerGamepadInfosStateAllGamepadControlsSentCallback (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateCurrentButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateAvailableButtonMappingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCallback_t ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateCurrentAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateAvailableAxisMappingsCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCallback_t ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStateCurrentAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStateAllCurrentFiltersSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStatePresetAxisFiltersCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCallback_t ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerAxisFiltersStateAllPresetFiltersSentCallback (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCb = callback;
        ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCallback_t ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCoPilotingStatePilotingSourceCallback (ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCallback_t ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCalibrationStateMagnetoCalibrationStateCallback (ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCallback_t ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCallback (ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCb = callback;
        ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCallback_t ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCb = NULL;
static void *ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCustom = NULL;
void ARCOMMANDS_Decoder_SetSkyControllerButtonEventsSettingsCallback (ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCb = callback;
        ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature unknown_feature_1

static ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1GeographicRunCallback (ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1RelativeRunCallback (ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1LookAtRunCallback (ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1SpiralAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1SwingAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1BoomerangAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1CandleAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1DollySlideAnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCallback_t ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1UserFramingPositionCallback (ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCallback_t ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1UserGPSDataCallback (ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCallback_t ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1UserBaroDataCallback (ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCallback_t ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1LynxDetectionCallback (ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCallback_t ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1AvailabilityCallback (ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1RunCallback_t ARCOMMANDS_Decoder_UnknownFeature1RunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1RunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1RunCallback (ARCOMMANDS_Decoder_UnknownFeature1RunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1RunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1RunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1GeographicConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1RelativeConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1AnimRunCallback_t ARCOMMANDS_Decoder_UnknownFeature1AnimRunCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1AnimRunCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1AnimRunCallback (ARCOMMANDS_Decoder_UnknownFeature1AnimRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1AnimRunCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1AnimRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1SpiralAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1SwingAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1BoomerangAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1CandleAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1DollySlideAnimConfigChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCallback_t ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetUnknownFeature1UserFramingPositionChangedCallback (ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCb = callback;
        ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature common

static ARCOMMANDS_Decoder_CommonNetworkDisconnectCallback_t ARCOMMANDS_Decoder_CommonNetworkDisconnectCb = NULL;
static void *ARCOMMANDS_Decoder_CommonNetworkDisconnectCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonNetworkDisconnectCallback (ARCOMMANDS_Decoder_CommonNetworkDisconnectCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonNetworkDisconnectCb = callback;
        ARCOMMANDS_Decoder_CommonNetworkDisconnectCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsAllSettingsCallback_t ARCOMMANDS_Decoder_CommonSettingsAllSettingsCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsAllSettingsCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsAllSettingsCallback (ARCOMMANDS_Decoder_CommonSettingsAllSettingsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsAllSettingsCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsAllSettingsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsResetCallback_t ARCOMMANDS_Decoder_CommonSettingsResetCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsResetCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsResetCallback (ARCOMMANDS_Decoder_CommonSettingsResetCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsResetCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsResetCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsProductNameCallback_t ARCOMMANDS_Decoder_CommonSettingsProductNameCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsProductNameCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsProductNameCallback (ARCOMMANDS_Decoder_CommonSettingsProductNameCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsProductNameCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsProductNameCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsCountryCallback_t ARCOMMANDS_Decoder_CommonSettingsCountryCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsCountryCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsCountryCallback (ARCOMMANDS_Decoder_CommonSettingsCountryCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsCountryCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsCountryCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsAutoCountryCallback_t ARCOMMANDS_Decoder_CommonSettingsAutoCountryCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsAutoCountryCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsAutoCountryCallback (ARCOMMANDS_Decoder_CommonSettingsAutoCountryCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsAutoCountryCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsAutoCountryCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonAllStatesCallback_t ARCOMMANDS_Decoder_CommonCommonAllStatesCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonAllStatesCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonAllStatesCallback (ARCOMMANDS_Decoder_CommonCommonAllStatesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonAllStatesCb = callback;
        ARCOMMANDS_Decoder_CommonCommonAllStatesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonCurrentDateCallback_t ARCOMMANDS_Decoder_CommonCommonCurrentDateCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonCurrentDateCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonCurrentDateCallback (ARCOMMANDS_Decoder_CommonCommonCurrentDateCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonCurrentDateCb = callback;
        ARCOMMANDS_Decoder_CommonCommonCurrentDateCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonCurrentTimeCallback_t ARCOMMANDS_Decoder_CommonCommonCurrentTimeCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonCurrentTimeCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonCurrentTimeCallback (ARCOMMANDS_Decoder_CommonCommonCurrentTimeCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonCurrentTimeCb = callback;
        ARCOMMANDS_Decoder_CommonCommonCurrentTimeCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonRebootCallback_t ARCOMMANDS_Decoder_CommonCommonRebootCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonRebootCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonRebootCallback (ARCOMMANDS_Decoder_CommonCommonRebootCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonRebootCb = callback;
        ARCOMMANDS_Decoder_CommonCommonRebootCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCallback_t ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCb = NULL;
static void *ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonOverHeatSwitchOffCallback (ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCb = callback;
        ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonOverHeatVentilateCallback_t ARCOMMANDS_Decoder_CommonOverHeatVentilateCb = NULL;
static void *ARCOMMANDS_Decoder_CommonOverHeatVentilateCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonOverHeatVentilateCallback (ARCOMMANDS_Decoder_CommonOverHeatVentilateCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonOverHeatVentilateCb = callback;
        ARCOMMANDS_Decoder_CommonOverHeatVentilateCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonControllerIsPilotingCallback_t ARCOMMANDS_Decoder_CommonControllerIsPilotingCb = NULL;
static void *ARCOMMANDS_Decoder_CommonControllerIsPilotingCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonControllerIsPilotingCallback (ARCOMMANDS_Decoder_CommonControllerIsPilotingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonControllerIsPilotingCb = callback;
        ARCOMMANDS_Decoder_CommonControllerIsPilotingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCallback_t ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCb = NULL;
static void *ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonWifiSettingsOutdoorSettingCallback (ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCb = callback;
        ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonMavlinkStartCallback_t ARCOMMANDS_Decoder_CommonMavlinkStartCb = NULL;
static void *ARCOMMANDS_Decoder_CommonMavlinkStartCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonMavlinkStartCallback (ARCOMMANDS_Decoder_CommonMavlinkStartCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonMavlinkStartCb = callback;
        ARCOMMANDS_Decoder_CommonMavlinkStartCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonMavlinkPauseCallback_t ARCOMMANDS_Decoder_CommonMavlinkPauseCb = NULL;
static void *ARCOMMANDS_Decoder_CommonMavlinkPauseCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonMavlinkPauseCallback (ARCOMMANDS_Decoder_CommonMavlinkPauseCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonMavlinkPauseCb = callback;
        ARCOMMANDS_Decoder_CommonMavlinkPauseCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonMavlinkStopCallback_t ARCOMMANDS_Decoder_CommonMavlinkStopCb = NULL;
static void *ARCOMMANDS_Decoder_CommonMavlinkStopCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonMavlinkStopCallback (ARCOMMANDS_Decoder_CommonMavlinkStopCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonMavlinkStopCb = callback;
        ARCOMMANDS_Decoder_CommonMavlinkStopCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCallback_t ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCalibrationMagnetoCalibrationCallback (ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCb = callback;
        ARCOMMANDS_Decoder_CommonCalibrationMagnetoCalibrationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCallback_t ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCb = NULL;
static void *ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonGPSControllerPositionForRunCallback (ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCb = callback;
        ARCOMMANDS_Decoder_CommonGPSControllerPositionForRunCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCallback_t ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAudioControllerReadyForStreamingCallback (ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCb = callback;
        ARCOMMANDS_Decoder_CommonAudioControllerReadyForStreamingCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonHeadlightsIntensityCallback_t ARCOMMANDS_Decoder_CommonHeadlightsIntensityCb = NULL;
static void *ARCOMMANDS_Decoder_CommonHeadlightsIntensityCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonHeadlightsIntensityCallback (ARCOMMANDS_Decoder_CommonHeadlightsIntensityCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonHeadlightsIntensityCb = callback;
        ARCOMMANDS_Decoder_CommonHeadlightsIntensityCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCallback_t ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAnimationsStartAnimationCallback (ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCb = callback;
        ARCOMMANDS_Decoder_CommonAnimationsStartAnimationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCallback_t ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAnimationsStopAnimationCallback (ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCb = callback;
        ARCOMMANDS_Decoder_CommonAnimationsStopAnimationCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCallback_t ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAnimationsStopAllAnimationsCallback (ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCb = callback;
        ARCOMMANDS_Decoder_CommonAnimationsStopAllAnimationsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAccessoryConfigCallback_t ARCOMMANDS_Decoder_CommonAccessoryConfigCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAccessoryConfigCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAccessoryConfigCallback (ARCOMMANDS_Decoder_CommonAccessoryConfigCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAccessoryConfigCb = callback;
        ARCOMMANDS_Decoder_CommonAccessoryConfigCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCallback_t ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCb = NULL;
static void *ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonChargerSetMaxChargeRateCallback (ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCb = callback;
        ARCOMMANDS_Decoder_CommonChargerSetMaxChargeRateCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCallback_t ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCb = NULL;
static void *ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonNetworkEventDisconnectionCallback (ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCb = callback;
        ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateAllSettingsChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateResetChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductNameChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductVersionChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialHighChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateProductSerialLowChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateCountryChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCallback_t ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonSettingsStateAutoCountryChangedCallback (ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCb = callback;
        ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateAllStatesChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateBatteryStateChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageStateListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoStateListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateCurrentDateChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateCurrentTimeChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateMassStorageInfoRemainingListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateWifiSignalChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCallback_t ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateSensorsStatesListChangedCallback (ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateProductModelCallback_t ARCOMMANDS_Decoder_CommonCommonStateProductModelCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateProductModelCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateProductModelCallback (ARCOMMANDS_Decoder_CommonCommonStateProductModelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateProductModelCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateProductModelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCallback_t ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCommonStateCountryListKnownCallback (ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCb = callback;
        ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCallback_t ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatChangedCallback (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCb = callback;
        ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCallback_t ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonOverHeatStateOverHeatRegulationChangedCallback (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCb = callback;
        ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCallback_t ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonWifiSettingsStateOutdoorSettingsChangedCallback (ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCb = callback;
        ARCOMMANDS_Decoder_CommonWifiSettingsStateOutdoorSettingsChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCallback_t ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkFilePlayingStateChangedCallback (ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkFilePlayingStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCallback_t ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonMavlinkStateMavlinkPlayErrorStateChangedCallback (ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonMavlinkStateMavlinkPlayErrorStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCallback_t ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStateChangedCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCallback_t ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationRequiredStateCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCb = callback;
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationRequiredStateCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback_t ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCallback_t ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCalibrationStateMagnetoCalibrationStartedChangedCallback (ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCalibrationStateMagnetoCalibrationStartedChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCallback_t ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonCameraSettingsStateCameraSettingsChangedCallback (ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCb = callback;
        ARCOMMANDS_Decoder_CommonCameraSettingsStateCameraSettingsChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCallback_t ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonFlightPlanStateAvailabilityStateChangedCallback (ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonFlightPlanStateAvailabilityStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCallback_t ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonFlightPlanStateComponentStateListChangedCallback (ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonFlightPlanStateComponentStateListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCallback_t ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCb = NULL;
static void *ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonFlightPlanEventStartingErrorEventCallback (ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCb = callback;
        ARCOMMANDS_Decoder_CommonFlightPlanEventStartingErrorEventCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCallback_t ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCb = NULL;
static void *ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonFlightPlanEventSpeedBridleEventCallback (ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCb = callback;
        ARCOMMANDS_Decoder_CommonFlightPlanEventSpeedBridleEventCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCallback_t ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCb = NULL;
static void *ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonARLibsVersionsStateControllerLibARCommandsVersionCallback (ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCb = callback;
        ARCOMMANDS_Decoder_CommonARLibsVersionsStateControllerLibARCommandsVersionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCallback_t ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCb = NULL;
static void *ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonARLibsVersionsStateSkyControllerLibARCommandsVersionCallback (ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCb = callback;
        ARCOMMANDS_Decoder_CommonARLibsVersionsStateSkyControllerLibARCommandsVersionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCallback_t ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCb = NULL;
static void *ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonARLibsVersionsStateDeviceLibARCommandsVersionCallback (ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCb = callback;
        ARCOMMANDS_Decoder_CommonARLibsVersionsStateDeviceLibARCommandsVersionCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCallback_t ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAudioStateAudioStreamingRunningCallback (ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCb = callback;
        ARCOMMANDS_Decoder_CommonAudioStateAudioStreamingRunningCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCallback_t ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonHeadlightsStateIntensityChangedCallback (ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCb = callback;
        ARCOMMANDS_Decoder_CommonHeadlightsStateIntensityChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAnimationsStateListCallback_t ARCOMMANDS_Decoder_CommonAnimationsStateListCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAnimationsStateListCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAnimationsStateListCallback (ARCOMMANDS_Decoder_CommonAnimationsStateListCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAnimationsStateListCb = callback;
        ARCOMMANDS_Decoder_CommonAnimationsStateListCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCallback_t ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAccessoryStateSupportedAccessoriesListChangedCallback (ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonAccessoryStateSupportedAccessoriesListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCallback_t ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAccessoryStateAccessoryConfigChangedCallback (ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCb = callback;
        ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCallback_t ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCb = NULL;
static void *ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonAccessoryStateAccessoryConfigModificationEnabledCallback (ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCb = callback;
        ARCOMMANDS_Decoder_CommonAccessoryStateAccessoryConfigModificationEnabledCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCallback_t ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonChargerStateMaxChargeRateChangedCallback (ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonChargerStateMaxChargeRateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCallback_t ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonChargerStateCurrentChargeStateChangedCallback (ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonChargerStateCurrentChargeStateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCallback_t ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonChargerStateLastChargeRateChangedCallback (ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCb = callback;
        ARCOMMANDS_Decoder_CommonChargerStateLastChargeRateChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCallback_t ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCb = NULL;
static void *ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonChargerStateChargingInfoCallback (ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCb = callback;
        ARCOMMANDS_Decoder_CommonChargerStateChargingInfoCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCallback_t ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonRunStateRunIdChangedCallback (ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCb = callback;
        ARCOMMANDS_Decoder_CommonRunStateRunIdChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature commonDebug

static ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCallback_t ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugStatsSendPacketCallback (ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCb = callback;
        ARCOMMANDS_Decoder_CommonDebugStatsSendPacketCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCallback_t ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugStatsStartSendingPacketFromDroneCallback (ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCb = callback;
        ARCOMMANDS_Decoder_CommonDebugStatsStartSendingPacketFromDroneCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCallback_t ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugStatsStopSendingPacketFromDroneCallback (ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCb = callback;
        ARCOMMANDS_Decoder_CommonDebugStatsStopSendingPacketFromDroneCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCallback_t ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsGetAllCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCb = callback;
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsGetAllCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCallback_t ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsSetCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCb = callback;
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsSetCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCallback_t ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugStatsEventSendPacketCallback (ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCb = callback;
        ARCOMMANDS_Decoder_CommonDebugStatsEventSendPacketCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCallback_t ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsStateInfoCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCb = callback;
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateInfoCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCallback_t ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCb = NULL;
static void *ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetCommonDebugDebugSettingsStateListChangedCallback (ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCb = callback;
        ARCOMMANDS_Decoder_CommonDebugDebugSettingsStateListChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature pro

static ARCOMMANDS_Decoder_ProProBoughtFeaturesCallback_t ARCOMMANDS_Decoder_ProProBoughtFeaturesCb = NULL;
static void *ARCOMMANDS_Decoder_ProProBoughtFeaturesCustom = NULL;
void ARCOMMANDS_Decoder_SetProProBoughtFeaturesCallback (ARCOMMANDS_Decoder_ProProBoughtFeaturesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ProProBoughtFeaturesCb = callback;
        ARCOMMANDS_Decoder_ProProBoughtFeaturesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ProProResponseCallback_t ARCOMMANDS_Decoder_ProProResponseCb = NULL;
static void *ARCOMMANDS_Decoder_ProProResponseCustom = NULL;
void ARCOMMANDS_Decoder_SetProProResponseCallback (ARCOMMANDS_Decoder_ProProResponseCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ProProResponseCb = callback;
        ARCOMMANDS_Decoder_ProProResponseCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ProProActivateFeaturesCallback_t ARCOMMANDS_Decoder_ProProActivateFeaturesCb = NULL;
static void *ARCOMMANDS_Decoder_ProProActivateFeaturesCustom = NULL;
void ARCOMMANDS_Decoder_SetProProActivateFeaturesCallback (ARCOMMANDS_Decoder_ProProActivateFeaturesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ProProActivateFeaturesCb = callback;
        ARCOMMANDS_Decoder_ProProActivateFeaturesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCallback_t ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCb = NULL;
static void *ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCustom = NULL;
void ARCOMMANDS_Decoder_SetProProStateSupportedFeaturesCallback (ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCb = callback;
        ARCOMMANDS_Decoder_ProProStateSupportedFeaturesCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCallback_t ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCb = NULL;
static void *ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCustom = NULL;
void ARCOMMANDS_Decoder_SetProProStateFeaturesActivatedCallback (ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCb = callback;
        ARCOMMANDS_Decoder_ProProStateFeaturesActivatedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_ProProEventChallengeEventCallback_t ARCOMMANDS_Decoder_ProProEventChallengeEventCb = NULL;
static void *ARCOMMANDS_Decoder_ProProEventChallengeEventCustom = NULL;
void ARCOMMANDS_Decoder_SetProProEventChallengeEventCallback (ARCOMMANDS_Decoder_ProProEventChallengeEventCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_ProProEventChallengeEventCb = callback;
        ARCOMMANDS_Decoder_ProProEventChallengeEventCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// Feature wifi

static ARCOMMANDS_Decoder_WifiScanCallback_t ARCOMMANDS_Decoder_WifiScanCb = NULL;
static void *ARCOMMANDS_Decoder_WifiScanCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiScanCallback (ARCOMMANDS_Decoder_WifiScanCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiScanCb = callback;
        ARCOMMANDS_Decoder_WifiScanCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCallback_t ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCb = NULL;
static void *ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiUpdateAuthorizedChannelsCallback (ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCb = callback;
        ARCOMMANDS_Decoder_WifiUpdateAuthorizedChannelsCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiSetApChannelCallback_t ARCOMMANDS_Decoder_WifiSetApChannelCb = NULL;
static void *ARCOMMANDS_Decoder_WifiSetApChannelCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiSetApChannelCallback (ARCOMMANDS_Decoder_WifiSetApChannelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiSetApChannelCb = callback;
        ARCOMMANDS_Decoder_WifiSetApChannelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiSetSecurityCallback_t ARCOMMANDS_Decoder_WifiSetSecurityCb = NULL;
static void *ARCOMMANDS_Decoder_WifiSetSecurityCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiSetSecurityCallback (ARCOMMANDS_Decoder_WifiSetSecurityCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiSetSecurityCb = callback;
        ARCOMMANDS_Decoder_WifiSetSecurityCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiSetCountryCallback_t ARCOMMANDS_Decoder_WifiSetCountryCb = NULL;
static void *ARCOMMANDS_Decoder_WifiSetCountryCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiSetCountryCallback (ARCOMMANDS_Decoder_WifiSetCountryCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiSetCountryCb = callback;
        ARCOMMANDS_Decoder_WifiSetCountryCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiSetEnvironementCallback_t ARCOMMANDS_Decoder_WifiSetEnvironementCb = NULL;
static void *ARCOMMANDS_Decoder_WifiSetEnvironementCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiSetEnvironementCallback (ARCOMMANDS_Decoder_WifiSetEnvironementCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiSetEnvironementCb = callback;
        ARCOMMANDS_Decoder_WifiSetEnvironementCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiScannedItemCallback_t ARCOMMANDS_Decoder_WifiScannedItemCb = NULL;
static void *ARCOMMANDS_Decoder_WifiScannedItemCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiScannedItemCallback (ARCOMMANDS_Decoder_WifiScannedItemCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiScannedItemCb = callback;
        ARCOMMANDS_Decoder_WifiScannedItemCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiAuthorizedChannelCallback_t ARCOMMANDS_Decoder_WifiAuthorizedChannelCb = NULL;
static void *ARCOMMANDS_Decoder_WifiAuthorizedChannelCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiAuthorizedChannelCallback (ARCOMMANDS_Decoder_WifiAuthorizedChannelCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiAuthorizedChannelCb = callback;
        ARCOMMANDS_Decoder_WifiAuthorizedChannelCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiApChannelChangedCallback_t ARCOMMANDS_Decoder_WifiApChannelChangedCb = NULL;
static void *ARCOMMANDS_Decoder_WifiApChannelChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiApChannelChangedCallback (ARCOMMANDS_Decoder_WifiApChannelChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiApChannelChangedCb = callback;
        ARCOMMANDS_Decoder_WifiApChannelChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiSecurityChangedCallback_t ARCOMMANDS_Decoder_WifiSecurityChangedCb = NULL;
static void *ARCOMMANDS_Decoder_WifiSecurityChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiSecurityChangedCallback (ARCOMMANDS_Decoder_WifiSecurityChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiSecurityChangedCb = callback;
        ARCOMMANDS_Decoder_WifiSecurityChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiCountryChangedCallback_t ARCOMMANDS_Decoder_WifiCountryChangedCb = NULL;
static void *ARCOMMANDS_Decoder_WifiCountryChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiCountryChangedCallback (ARCOMMANDS_Decoder_WifiCountryChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiCountryChangedCb = callback;
        ARCOMMANDS_Decoder_WifiCountryChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiEnvironementChangedCallback_t ARCOMMANDS_Decoder_WifiEnvironementChangedCb = NULL;
static void *ARCOMMANDS_Decoder_WifiEnvironementChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiEnvironementChangedCallback (ARCOMMANDS_Decoder_WifiEnvironementChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiEnvironementChangedCb = callback;
        ARCOMMANDS_Decoder_WifiEnvironementChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}
static ARCOMMANDS_Decoder_WifiRssiChangedCallback_t ARCOMMANDS_Decoder_WifiRssiChangedCb = NULL;
static void *ARCOMMANDS_Decoder_WifiRssiChangedCustom = NULL;
void ARCOMMANDS_Decoder_SetWifiRssiChangedCallback (ARCOMMANDS_Decoder_WifiRssiChangedCallback_t callback, void *custom)
{
    if (ARCOMMANDS_Decoder_Init () == 1)
    {
        ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
        ARCOMMANDS_Decoder_WifiRssiChangedCb = callback;
        ARCOMMANDS_Decoder_WifiRssiChangedCustom = custom;
        ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
    } // No else --> do nothing if library can not be initialized
}

// DECODER ENTRY POINT
eARCOMMANDS_DECODER_ERROR
ARCOMMANDS_Decoder_DecodeBuffer (uint8_t *buffer, int32_t buffLen)
{
    eARCOMMANDS_ID_FEATURE commandFetaure = -1;
    int commandClass = -1;
    int commandId = -1;
    int32_t error = 0;
    int32_t offset = 0;
    eARCOMMANDS_DECODER_ERROR retVal = ARCOMMANDS_DECODER_OK;
    if (NULL == buffer)
    {
        retVal = ARCOMMANDS_DECODER_ERROR;
    } // No else --> Arg check

    if (retVal == ARCOMMANDS_DECODER_OK)
    {
        if (ARCOMMANDS_Decoder_Init () == 0)
        {
            retVal = ARCOMMANDS_DECODER_ERROR;
        } // No else --> keep retVal to OK if init went fine
    } // No else --> Processing block

    if (retVal == ARCOMMANDS_DECODER_OK)
    {
        commandFetaure = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
        if (error == 1)
        {
            retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
        } // No else --> Do not modify retVal if read went fine
    } // No else --> Processing block

    if (retVal == ARCOMMANDS_DECODER_OK)
    {
        commandClass = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
        if (error == 1)
        {
            retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
        } // No else --> Do not modify retVal if read went fine
    } // No else --> Processing block

    if (retVal == ARCOMMANDS_DECODER_OK)
    {
        commandId = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
        if (error == 1)
        {
            retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
        } // No else --> Do not modify retVal if read went fine
    } // No else --> Processing block

    if (retVal == ARCOMMANDS_DECODER_OK)
    {
        switch (commandFetaure)
        {
        case ARCOMMANDS_ID_FEATURE_GENERIC:
        {
            if (commandClass == ARCOMMANDS_ID_FEATURE_CLASS)
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_GENERIC_CMD_DEFAULT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_GenericDefaultCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_GenericDefaultCb (ARCOMMANDS_Decoder_GenericDefaultCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_GENERIC_PROEVENT_CMD_DEFAULT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            else
            {
                retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_GENERIC */
        case ARCOMMANDS_ID_FEATURE_ARDRONE3:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_FLATTRIM:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCb (ARCOMMANDS_Decoder_ARDrone3PilotingFlatTrimCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_FLATTRIM */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_TAKEOFF:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCb (ARCOMMANDS_Decoder_ARDrone3PilotingTakeOffCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_TAKEOFF */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_PCMD:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCb != NULL)
                    {
                        uint8_t _flag;
                        int8_t _roll;
                        int8_t _pitch;
                        int8_t _yaw;
                        int8_t _gaz;
                        uint32_t _timestampAndSeqNum;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _flag = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _roll =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pitch =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _yaw =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _gaz =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _timestampAndSeqNum = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCb (_flag, _roll, _pitch, _yaw, _gaz, _timestampAndSeqNum, ARCOMMANDS_Decoder_ARDrone3PilotingPCMDCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_PCMD */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_LANDING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingLandingCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingLandingCb (ARCOMMANDS_Decoder_ARDrone3PilotingLandingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_LANDING */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_EMERGENCY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCb (ARCOMMANDS_Decoder_ARDrone3PilotingEmergencyCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_EMERGENCY */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_NAVIGATEHOME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCb != NULL)
                    {
                        uint8_t _start;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCb (_start, ARCOMMANDS_Decoder_ARDrone3PilotingNavigateHomeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_NAVIGATEHOME */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_AUTOTAKEOFFMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCb != NULL)
                    {
                        uint8_t _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCb (_state, ARCOMMANDS_Decoder_ARDrone3PilotingAutoTakeOffModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_AUTOTAKEOFFMODE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_MOVEBY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCb != NULL)
                    {
                        float _dX;
                        float _dY;
                        float _dZ;
                        float _dPsi;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dX = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dY = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dZ = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dPsi = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCb (_dX, _dY, _dZ, _dPsi, ARCOMMANDS_Decoder_ARDrone3PilotingMoveByCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_MOVEBY */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_USERTAKEOFF:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCb != NULL)
                    {
                        uint8_t _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCb (_state, ARCOMMANDS_Decoder_ARDrone3PilotingUserTakeOffCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_USERTAKEOFF */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_CIRCLE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingCircleCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION _direction;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _direction = (eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingCircleCb (_direction, ARCOMMANDS_Decoder_ARDrone3PilotingCircleCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_CIRCLE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_ANIMATIONS_CMD_FLIP:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION _direction;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _direction = (eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCb (_direction, ARCOMMANDS_Decoder_ARDrone3AnimationsFlipCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANIMATIONS_CMD_FLIP */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERA:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_CAMERA_CMD_ORIENTATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3CameraOrientationCb != NULL)
                    {
                        int8_t _tilt;
                        int8_t _pan;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _tilt =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pan =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3CameraOrientationCb (_tilt, _pan, ARCOMMANDS_Decoder_ARDrone3CameraOrientationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_CAMERA_CMD_ORIENTATION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERA */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTURE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCb != NULL)
                    {
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCb (_mass_storage_id, ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTURE */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEO:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD _record;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _record = (eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCb (_record, _mass_storage_id, ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEO */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTUREV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Cb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Cb (ARCOMMANDS_Decoder_ARDrone3MediaRecordPictureV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTUREV2 */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEOV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Cb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD _record;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _record = (eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Cb (_record, ARCOMMANDS_Decoder_ARDrone3MediaRecordVideoV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEOV2 */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCb != NULL)
                    {
                        uint8_t _state;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCb (_state, _mass_storage_id, ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCb (_state, _mass_storage_id, ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Cb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state;
                        eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Cb (_state, _error, ARCOMMANDS_Decoder_ARDrone3MediaRecordStatePictureStateChangedV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2 */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Cb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state;
                        eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Cb (_state, _error, ARCOMMANDS_Decoder_ARDrone3MediaRecordStateVideoStateChangedV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2 */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event;
                        eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _event = (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCb (_event, _error, ARCOMMANDS_Decoder_ARDrone3MediaRecordEventPictureEventChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event;
                        eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _event = (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCb (_event, _error, ARCOMMANDS_Decoder_ARDrone3MediaRecordEventVideoEventChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDEVENT */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLATTRIMCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCb (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlatTrimChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLATTRIMCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLYINGSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCb (_state, ARCOMMANDS_Decoder_ARDrone3PilotingStateFlyingStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLYINGSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALERTSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCb (_state, ARCOMMANDS_Decoder_ARDrone3PilotingStateAlertStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALERTSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_NAVIGATEHOMESTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE _state;
                        eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON _reason;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _reason = (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCb (_state, _reason, ARCOMMANDS_Decoder_ARDrone3PilotingStateNavigateHomeStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_NAVIGATEHOMESTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_POSITIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        double _altitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCb (_latitude, _longitude, _altitude, ARCOMMANDS_Decoder_ARDrone3PilotingStatePositionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_POSITIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_SPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCb != NULL)
                    {
                        float _speedX;
                        float _speedY;
                        float _speedZ;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speedX = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speedY = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speedZ = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCb (_speedX, _speedY, _speedZ, ARCOMMANDS_Decoder_ARDrone3PilotingStateSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_SPEEDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ATTITUDECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCb != NULL)
                    {
                        float _roll;
                        float _pitch;
                        float _yaw;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _roll = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pitch = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _yaw = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCb (_roll, _pitch, _yaw, ARCOMMANDS_Decoder_ARDrone3PilotingStateAttitudeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ATTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCb != NULL)
                    {
                        uint8_t _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCb (_state, ARCOMMANDS_Decoder_ARDrone3PilotingStateAutoTakeOffModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALTITUDECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCb != NULL)
                    {
                        double _altitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCb (_altitude, ARCOMMANDS_Decoder_ARDrone3PilotingStateAltitudeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALTITUDECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGEVENT_CMD_MOVEBYEND:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCb != NULL)
                    {
                        float _dX;
                        float _dY;
                        float _dZ;
                        float _dPsi;
                        eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dX = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dY = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dZ = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _dPsi = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCb (_dX, _dY, _dZ, _dPsi, _error, ARCOMMANDS_Decoder_ARDrone3PilotingEventMoveByEndCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGEVENT_CMD_MOVEBYEND */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGEVENT */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFISCAN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND _band;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCb (_band, ARCOMMANDS_Decoder_ARDrone3NetworkWifiScanCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFISCAN */
                case ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFIAUTHCHANNEL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCb (ARCOMMANDS_Decoder_ARDrone3NetworkWifiAuthChannelCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFIAUTHCHANNEL */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORK */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFISCANLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCb != NULL)
                    {
                        char * _ssid = NULL;
                        int16_t _rssi;
                        eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _rssi =  (int16_t)ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCb (_ssid, _rssi, _band, _channel, ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiScanListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFISCANLISTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFISCANCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCb (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiScanChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFISCANCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band;
                        uint8_t _channel;
                        uint8_t _in_or_out;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _in_or_out = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCb (_band, _channel, _in_or_out, ARCOMMANDS_Decoder_ARDrone3NetworkStateWifiAuthChannelListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCb (ARCOMMANDS_Decoder_ARDrone3NetworkStateAllWifiAuthChannelChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXALTITUDE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCb (_current, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxAltitudeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXALTITUDE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXTILT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCb (_current, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxTiltCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXTILT */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_ABSOLUTCONTROL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCb != NULL)
                    {
                        uint8_t _on;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _on = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCb (_on, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsAbsolutControlCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_ABSOLUTCONTROL */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXDISTANCE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMaxDistanceCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXDISTANCE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_NOFLYOVERMAXDISTANCE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCb != NULL)
                    {
                        uint8_t _shouldNotFlyOver;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _shouldNotFlyOver = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCb (_shouldNotFlyOver, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsNoFlyOverMaxDistanceCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_NOFLYOVERMAXDISTANCE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALACCELERATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXROTATIONSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXROTATIONSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_BANKEDTURN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCb != NULL)
                    {
                        uint8_t _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsBankedTurnCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_BANKEDTURN */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MINALTITUDE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCb (_current, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsMinAltitudeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MINALTITUDE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGDIRECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingDirectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGDIRECTION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGRADIUS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCb != NULL)
                    {
                        uint16_t _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingRadiusCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGRADIUS */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGALTITUDE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCb != NULL)
                    {
                        uint16_t _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsCirclingAltitudeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGALTITUDE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_PITCHMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsPitchModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_PITCHMODE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_LANDINGMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsLandingModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_LANDINGMODE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxAltitudeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxTiltChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_ABSOLUTCONTROLCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCb != NULL)
                    {
                        uint8_t _on;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _on = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCb (_on, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAbsolutControlChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_ABSOLUTCONTROLCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXDISTANCECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMaxDistanceChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXDISTANCECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_NOFLYOVERMAXDISTANCECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCb != NULL)
                    {
                        uint8_t _shouldNotFlyOver;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _shouldNotFlyOver = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCb (_shouldNotFlyOver, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_NOFLYOVERMAXDISTANCECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXROTATIONSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXROTATIONSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_BANKEDTURNCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCb != NULL)
                    {
                        uint8_t _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCb (_state, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateBankedTurnChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_BANKEDTURNCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MINALTITUDECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateMinAltitudeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MINALTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGDIRECTIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingDirectionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGDIRECTIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGRADIUSCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCb != NULL)
                    {
                        uint16_t _current;
                        uint16_t _min;
                        uint16_t _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingRadiusChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGRADIUSCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGALTITUDECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCb != NULL)
                    {
                        uint16_t _current;
                        uint16_t _min;
                        uint16_t _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateCirclingAltitudeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGALTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_PITCHMODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStatePitchModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_PITCHMODECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_LANDINGMODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCb (_value, ARCOMMANDS_Decoder_ARDrone3PilotingSettingsStateLandingModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_LANDINGMODECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXVERTICALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCb (_current, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxVerticalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXVERTICALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXROTATIONSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCb (_current, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxRotationSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXROTATIONSPEED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_HULLPROTECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCb != NULL)
                    {
                        uint8_t _present;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _present = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCb (_present, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsHullProtectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_HULLPROTECTION */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_OUTDOOR:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCb != NULL)
                    {
                        uint8_t _outdoor;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _outdoor = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCb (_outdoor, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsOutdoorCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_OUTDOOR */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXPITCHROLLROTATIONSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCb (_current, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsMaxPitchRollRotationSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXPITCHROLLROTATIONSPEED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxRotationSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_HULLPROTECTIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCb != NULL)
                    {
                        uint8_t _present;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _present = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCb (_present, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateHullProtectionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_HULLPROTECTIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCb != NULL)
                    {
                        uint8_t _outdoor;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _outdoor = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCb (_outdoor, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateOutdoorChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXPITCHROLLROTATIONSPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_ARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXPITCHROLLROTATIONSPEEDCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE _type;
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCb (_type, _band, _channel, ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISELECTION */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISECURITY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE _type;
                        char * _key = NULL;
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE _keyType;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _key = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _keyType = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCb (_type, _key, _keyType, ARCOMMANDS_Decoder_ARDrone3NetworkSettingsWifiSecurityCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISECURITY */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type;
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCb (_type, _band, _channel, ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSelectionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCb (_type, ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITYCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE _type;
                        char * _key = NULL;
                        eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE _keyType;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _key = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _keyType = (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCb (_type, _key, _keyType, ARCOMMANDS_Decoder_ARDrone3NetworkSettingsStateWifiSecurityCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITY */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTMOTORVERSIONLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCb != NULL)
                    {
                        uint8_t _motor_number;
                        char * _type = NULL;
                        char * _software = NULL;
                        char * _hardware = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _motor_number = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _software = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _hardware = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCb (_motor_number, _type, _software, _hardware, ARCOMMANDS_Decoder_ARDrone3SettingsStateProductMotorVersionListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTMOTORVERSIONLISTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCb != NULL)
                    {
                        char * _software = NULL;
                        char * _hardware = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _software = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _hardware = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCb (_software, _hardware, ARCOMMANDS_Decoder_ARDrone3SettingsStateProductGPSVersionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCb != NULL)
                    {
                        uint8_t _motorIds;
                        eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR _motorError;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _motorIds = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _motorError = (eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCb (_motorIds, _motorError, ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORSOFTWAREVERSIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCb != NULL)
                    {
                        char * _version = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _version = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCb (_version, ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorSoftwareVersionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORSOFTWAREVERSIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORFLIGHTSSTATUSCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCb != NULL)
                    {
                        uint16_t _nbFlights;
                        uint16_t _lastFlightDuration;
                        uint32_t _totalFlightDuration;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _nbFlights = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _lastFlightDuration = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _totalFlightDuration = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCb (_nbFlights, _lastFlightDuration, _totalFlightDuration, ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorFlightsStatusChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORFLIGHTSSTATUSCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORLASTERRORCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR _motorError;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _motorError = (eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCb (_motorError, ARCOMMANDS_Decoder_ARDrone3SettingsStateMotorErrorLastErrorChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORLASTERRORCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_P7ID:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCb != NULL)
                    {
                        char * _serialID = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _serialID = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCb (_serialID, ARCOMMANDS_Decoder_ARDrone3SettingsStateP7IDCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_P7ID */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_PICTUREFORMATSELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCb (_type, ARCOMMANDS_Decoder_ARDrone3PictureSettingsPictureFormatSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_PICTUREFORMATSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_AUTOWHITEBALANCESELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCb (_type, ARCOMMANDS_Decoder_ARDrone3PictureSettingsAutoWhiteBalanceSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_AUTOWHITEBALANCESELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_EXPOSITIONSELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCb (_value, ARCOMMANDS_Decoder_ARDrone3PictureSettingsExpositionSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_EXPOSITIONSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_SATURATIONSELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCb != NULL)
                    {
                        float _value;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCb (_value, ARCOMMANDS_Decoder_ARDrone3PictureSettingsSaturationSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_SATURATIONSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_TIMELAPSESELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCb != NULL)
                    {
                        uint8_t _enabled;
                        float _interval;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _interval = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCb (_enabled, _interval, ARCOMMANDS_Decoder_ARDrone3PictureSettingsTimelapseSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_TIMELAPSESELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOAUTORECORDSELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCb != NULL)
                    {
                        uint8_t _enabled;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCb (_enabled, _mass_storage_id, ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoAutorecordSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOAUTORECORDSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOSTABILIZATIONMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE _mode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mode = (eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCb (_mode, ARCOMMANDS_Decoder_ARDrone3PictureSettingsVideoStabilizationModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOSTABILIZATIONMODE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_PICTUREFORMATCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCb (_type, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStatePictureFormatChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_PICTUREFORMATCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_AUTOWHITEBALANCECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCb (_type, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateAutoWhiteBalanceChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_AUTOWHITEBALANCECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_EXPOSITIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCb != NULL)
                    {
                        float _value;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCb (_value, _min, _max, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateExpositionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_EXPOSITIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_SATURATIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCb != NULL)
                    {
                        float _value;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _value = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCb (_value, _min, _max, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateSaturationChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_SATURATIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_TIMELAPSECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCb != NULL)
                    {
                        uint8_t _enabled;
                        float _interval;
                        float _minInterval;
                        float _maxInterval;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _interval = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _minInterval = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _maxInterval = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCb (_enabled, _interval, _minInterval, _maxInterval, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateTimelapseChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_TIMELAPSECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOAUTORECORDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCb != NULL)
                    {
                        uint8_t _enabled;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCb (_enabled, _mass_storage_id, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoAutorecordChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOAUTORECORDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOSTABILIZATIONMODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE _mode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mode = (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCb (_mode, ARCOMMANDS_Decoder_ARDrone3PictureSettingsStateVideoStabilizationModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOSTABILIZATIONMODECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMING_CMD_VIDEOENABLE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCb != NULL)
                    {
                        uint8_t _enable;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enable = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCb (_enable, ARCOMMANDS_Decoder_ARDrone3MediaStreamingVideoEnableCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMING_CMD_VIDEOENABLE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMING */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = (eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCb (_enabled, ARCOMMANDS_Decoder_ARDrone3MediaStreamingStateVideoEnableChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMINGSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SETHOME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        double _altitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCb (_latitude, _longitude, _altitude, ARCOMMANDS_Decoder_ARDrone3GPSSettingsSetHomeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SETHOME */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RESETHOME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCb (ARCOMMANDS_Decoder_ARDrone3GPSSettingsResetHomeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RESETHOME */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SENDCONTROLLERGPS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        double _altitude;
                        double _horizontalAccuracy;
                        double _verticalAccuracy;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontalAccuracy = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _verticalAccuracy = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCb (_latitude, _longitude, _altitude, _horizontalAccuracy, _verticalAccuracy, ARCOMMANDS_Decoder_ARDrone3GPSSettingsSendControllerGPSCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SENDCONTROLLERGPS */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_HOMETYPE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCb (_type, ARCOMMANDS_Decoder_ARDrone3GPSSettingsHomeTypeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_HOMETYPE */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RETURNHOMEDELAY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCb != NULL)
                    {
                        uint16_t _delay;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _delay = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCb (_delay, ARCOMMANDS_Decoder_ARDrone3GPSSettingsReturnHomeDelayCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RETURNHOMEDELAY */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        double _altitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCb (_latitude, _longitude, _altitude, ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RESETHOMECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        double _altitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCb (_latitude, _longitude, _altitude, ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateResetHomeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RESETHOMECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSFIXSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCb != NULL)
                    {
                        uint8_t _fixed;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _fixed = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCb (_fixed, ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSFixStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSFIXSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSUPDATESTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCb (_state, ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateGPSUpdateStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSUPDATESTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMETYPECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCb (_type, ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateHomeTypeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMETYPECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RETURNHOMEDELAYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCb != NULL)
                    {
                        uint16_t _delay;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _delay = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCb (_delay, ARCOMMANDS_Decoder_ARDrone3GPSSettingsStateReturnHomeDelayChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RETURNHOMEDELAYCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERASTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_ORIENTATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCb != NULL)
                    {
                        int8_t _tilt;
                        int8_t _pan;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _tilt =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pan =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCb (_tilt, _pan, ARCOMMANDS_Decoder_ARDrone3CameraStateOrientationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_ORIENTATION */
                case ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_DEFAULTCAMERAORIENTATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCb != NULL)
                    {
                        int8_t _tilt;
                        int8_t _pan;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _tilt =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pan =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCb (_tilt, _pan, ARCOMMANDS_Decoder_ARDrone3CameraStateDefaultCameraOrientationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_DEFAULTCAMERAORIENTATION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERASTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_ELECTRICFREQUENCY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY _frequency;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _frequency = (eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCb (_frequency, ARCOMMANDS_Decoder_ARDrone3AntiflickeringElectricFrequencyCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_ELECTRICFREQUENCY */
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_SETMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE _mode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mode = (eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCb (_mode, ARCOMMANDS_Decoder_ARDrone3AntiflickeringSetModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_SETMODE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERING */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_ELECTRICFREQUENCYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY _frequency;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _frequency = (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCb (_frequency, ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateElectricFrequencyChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_ELECTRICFREQUENCYCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_MODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE _mode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mode = (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCb (_mode, ARCOMMANDS_Decoder_ARDrone3AntiflickeringStateModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_MODECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERINGSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_NUMBEROFSATELLITECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCb != NULL)
                    {
                        uint8_t _numberOfSatellite;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _numberOfSatellite = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCb (_numberOfSatellite, ARCOMMANDS_Decoder_ARDrone3GPSStateNumberOfSatelliteChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_NUMBEROFSATELLITECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPEAVAILABILITYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE _type;
                        uint8_t _available;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _available = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCb (_type, _available, ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeAvailabilityChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPEAVAILABILITYCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPECHOSENCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCb != NULL)
                    {
                        eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCb (_type, ARCOMMANDS_Decoder_ARDrone3GPSStateHomeTypeChosenChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPECHOSENCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PROSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PROSTATE_CMD_FEATURES:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCb != NULL)
                    {
                        uint64_t _features;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _features = ARCOMMANDS_ReadWrite_Read64FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCb (_features, ARCOMMANDS_Decoder_ARDrone3PROStateFeaturesCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PROSTATE_CMD_FEATURES */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PROSTATE */
            default:
                retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_ARDRONE3 */
        case ARCOMMANDS_ID_FEATURE_JUMPINGSUMO:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_PCMD:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCb != NULL)
                    {
                        uint8_t _flag;
                        int8_t _speed;
                        int8_t _turn;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _flag = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _turn =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCb (_flag, _speed, _turn, ARCOMMANDS_Decoder_JumpingSumoPilotingPCMDCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_PCMD */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_POSTURE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCb (_type, ARCOMMANDS_Decoder_JumpingSumoPilotingPostureCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_POSTURE */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_ADDCAPOFFSET:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCb != NULL)
                    {
                        float _offset;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _offset = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCb (_offset, ARCOMMANDS_Decoder_JumpingSumoPilotingAddCapOffsetCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_ADDCAPOFFSET */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_POSTURECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCb (_state, ARCOMMANDS_Decoder_JumpingSumoPilotingStatePostureChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_POSTURECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_ALERTSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCb (_state, ARCOMMANDS_Decoder_JumpingSumoPilotingStateAlertStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_ALERTSTATECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_SPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCb != NULL)
                    {
                        int8_t _speed;
                        int16_t _realSpeed;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _realSpeed =  (int16_t)ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCb (_speed, _realSpeed, ARCOMMANDS_Decoder_JumpingSumoPilotingStateSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_SPEEDCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPSTOP:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCb (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpStopCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPSTOP */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPCANCEL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCb (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCancelCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPCANCEL */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPLOAD:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCb (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpLoadCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPLOAD */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMP:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCb (_type, ARCOMMANDS_Decoder_JumpingSumoAnimationsJumpCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMP */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_SIMPLEANIMATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID _id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _id = (eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCb (_id, ARCOMMANDS_Decoder_JumpingSumoAnimationsSimpleAnimationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_SIMPLEANIMATION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPLOADCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCb (_state, ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpLoadChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPLOADCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPTYPECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCb (_state, ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpTypeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPTYPECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPMOTORPROBLEMCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCb (_error, ARCOMMANDS_Decoder_JumpingSumoAnimationsStateJumpMotorProblemChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPMOTORPROBLEMCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCb != NULL)
                    {
                        char * _software = NULL;
                        char * _hardware = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _software = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _hardware = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCb (_software, _hardware, ARCOMMANDS_Decoder_JumpingSumoSettingsStateProductGPSVersionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTURE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCb != NULL)
                    {
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCb (_mass_storage_id, ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTURE */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEO:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD _record;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _record = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCb (_record, _mass_storage_id, ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEO */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTUREV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Cb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Cb (ARCOMMANDS_Decoder_JumpingSumoMediaRecordPictureV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTUREV2 */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEOV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Cb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD _record;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _record = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Cb (_record, ARCOMMANDS_Decoder_JumpingSumoMediaRecordVideoV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEOV2 */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCb != NULL)
                    {
                        uint8_t _state;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCb (_state, _mass_storage_id, ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCb (_state, _mass_storage_id, ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Cb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state;
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Cb (_state, _error, ARCOMMANDS_Decoder_JumpingSumoMediaRecordStatePictureStateChangedV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2 */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Cb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state;
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Cb (_state, _error, ARCOMMANDS_Decoder_JumpingSumoMediaRecordStateVideoStateChangedV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2 */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event;
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _event = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCb (_event, _error, ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventPictureEventChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event;
                        eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _event = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCb (_event, _error, ARCOMMANDS_Decoder_JumpingSumoMediaRecordEventVideoEventChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDEVENT */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGS_CMD_WIFISELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE _type;
                        eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCb (_type, _band, _channel, ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsWifiSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGS_CMD_WIFISELECTION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type;
                        eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCb (_type, _band, _channel, ARCOMMANDS_Decoder_JumpingSumoNetworkSettingsStateWifiSelectionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFISCAN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND _band;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCb (_band, ARCOMMANDS_Decoder_JumpingSumoNetworkWifiScanCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFISCAN */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFIAUTHCHANNEL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCb (ARCOMMANDS_Decoder_JumpingSumoNetworkWifiAuthChannelCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFIAUTHCHANNEL */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORK */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFISCANLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCb != NULL)
                    {
                        char * _ssid = NULL;
                        int16_t _rssi;
                        eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _rssi =  (int16_t)ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCb (_ssid, _rssi, _band, _channel, ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiScanListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFISCANLISTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFISCANCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCb (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiScanChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFISCANCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band;
                        uint8_t _channel;
                        uint8_t _in_or_out;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _in_or_out = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCb (_band, _channel, _in_or_out, ARCOMMANDS_Decoder_JumpingSumoNetworkStateWifiAuthChannelListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCb (ARCOMMANDS_Decoder_JumpingSumoNetworkStateAllWifiAuthChannelChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_LINKQUALITYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCb != NULL)
                    {
                        uint8_t _quality;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _quality = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCb (_quality, ARCOMMANDS_Decoder_JumpingSumoNetworkStateLinkQualityChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_LINKQUALITYCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_MASTERVOLUME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCb != NULL)
                    {
                        uint8_t _volume;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _volume = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCb (_volume, ARCOMMANDS_Decoder_JumpingSumoAudioSettingsMasterVolumeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_MASTERVOLUME */
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_THEME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME _theme;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _theme = (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCb (_theme, ARCOMMANDS_Decoder_JumpingSumoAudioSettingsThemeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_THEME */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_MASTERVOLUMECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCb != NULL)
                    {
                        uint8_t _volume;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _volume = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCb (_volume, ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateMasterVolumeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_MASTERVOLUMECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_THEMECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME _theme;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _theme = (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCb (_theme, ARCOMMANDS_Decoder_JumpingSumoAudioSettingsStateThemeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_THEMECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_ALLSCRIPTSMETADATA:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCb (ARCOMMANDS_Decoder_JumpingSumoRoadPlanAllScriptsMetadataCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_ALLSCRIPTSMETADATA */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTUPLOADED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCb != NULL)
                    {
                        char * _uuid = NULL;
                        char * _md5Hash = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _uuid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _md5Hash = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCb (_uuid, _md5Hash, ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptUploadedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTUPLOADED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTDELETE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCb != NULL)
                    {
                        char * _uuid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _uuid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCb (_uuid, ARCOMMANDS_Decoder_JumpingSumoRoadPlanScriptDeleteCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTDELETE */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_PLAYSCRIPT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCb != NULL)
                    {
                        char * _uuid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _uuid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCb (_uuid, ARCOMMANDS_Decoder_JumpingSumoRoadPlanPlayScriptCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_PLAYSCRIPT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTMETADATALISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCb != NULL)
                    {
                        char * _uuid = NULL;
                        uint8_t _version;
                        char * _product = NULL;
                        char * _name = NULL;
                        uint64_t _lastModified;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _uuid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _version = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _product = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _lastModified = ARCOMMANDS_ReadWrite_Read64FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCb (_uuid, _version, _product, _name, _lastModified, ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptMetadataListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTMETADATALISTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_ALLSCRIPTSMETADATACHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCb (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateAllScriptsMetadataChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_ALLSCRIPTSMETADATACHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTUPLOADCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE _resultCode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _resultCode = (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCb (_resultCode, ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptUploadChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTUPLOADCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTDELETECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE _resultCode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _resultCode = (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCb (_resultCode, ARCOMMANDS_Decoder_JumpingSumoRoadPlanStateScriptDeleteChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTDELETECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_PLAYSCRIPTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE _resultCode;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _resultCode = (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCb (_resultCode, ARCOMMANDS_Decoder_JumpingSumoRoadPlanStatePlayScriptChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_PLAYSCRIPTCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGS_CMD_OUTDOOR:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCb != NULL)
                    {
                        uint8_t _outdoor;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _outdoor = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCb (_outdoor, ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsOutdoorCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGS_CMD_OUTDOOR */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCb != NULL)
                    {
                        uint8_t _outdoor;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _outdoor = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCb (_outdoor, ARCOMMANDS_Decoder_JumpingSumoSpeedSettingsStateOutdoorChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMING_CMD_VIDEOENABLE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCb != NULL)
                    {
                        uint8_t _enable;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enable = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCb (_enable, ARCOMMANDS_Decoder_JumpingSumoMediaStreamingVideoEnableCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMING_CMD_VIDEOENABLE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMING */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCb != NULL)
                    {
                        eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = (eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCb (_enabled, ARCOMMANDS_Decoder_JumpingSumoMediaStreamingStateVideoEnableChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMINGSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGS_CMD_AUTORECORD:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCb != NULL)
                    {
                        uint8_t _enabled;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCb (_enabled, ARCOMMANDS_Decoder_JumpingSumoVideoSettingsAutorecordCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGS_CMD_AUTORECORD */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGSSTATE_CMD_AUTORECORDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCb != NULL)
                    {
                        uint8_t _enabled;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCb (_enabled, ARCOMMANDS_Decoder_JumpingSumoVideoSettingsStateAutorecordChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGSSTATE_CMD_AUTORECORDCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGSSTATE */
            default:
                retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_JUMPINGSUMO */
        case ARCOMMANDS_ID_FEATURE_MINIDRONE:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_FLATTRIM:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCb (ARCOMMANDS_Decoder_MiniDronePilotingFlatTrimCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_FLATTRIM */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_TAKEOFF:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCb (ARCOMMANDS_Decoder_MiniDronePilotingTakeOffCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_TAKEOFF */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_PCMD:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingPCMDCb != NULL)
                    {
                        uint8_t _flag;
                        int8_t _roll;
                        int8_t _pitch;
                        int8_t _yaw;
                        int8_t _gaz;
                        uint32_t _timestamp;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _flag = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _roll =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pitch =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _yaw =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _gaz =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _timestamp = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingPCMDCb (_flag, _roll, _pitch, _yaw, _gaz, _timestamp, ARCOMMANDS_Decoder_MiniDronePilotingPCMDCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_PCMD */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_LANDING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingLandingCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingLandingCb (ARCOMMANDS_Decoder_MiniDronePilotingLandingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_LANDING */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_EMERGENCY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCb (ARCOMMANDS_Decoder_MiniDronePilotingEmergencyCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_EMERGENCY */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_AUTOTAKEOFFMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCb != NULL)
                    {
                        uint8_t _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCb (_state, ARCOMMANDS_Decoder_MiniDronePilotingAutoTakeOffModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_AUTOTAKEOFFMODE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLATTRIMCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCb (ARCOMMANDS_Decoder_MiniDronePilotingStateFlatTrimChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLATTRIMCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLYINGSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCb != NULL)
                    {
                        eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCb (_state, ARCOMMANDS_Decoder_MiniDronePilotingStateFlyingStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLYINGSTATECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_ALERTSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCb != NULL)
                    {
                        eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCb (_state, ARCOMMANDS_Decoder_MiniDronePilotingStateAlertStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_ALERTSTATECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCb != NULL)
                    {
                        uint8_t _state;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCb (_state, ARCOMMANDS_Decoder_MiniDronePilotingStateAutoTakeOffModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_FLIP:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCb != NULL)
                    {
                        eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION _direction;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _direction = (eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCb (_direction, ARCOMMANDS_Decoder_MiniDroneAnimationsFlipCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_FLIP */
                case ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_CAP:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneAnimationsCapCb != NULL)
                    {
                        int16_t _offset;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _offset =  (int16_t)ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneAnimationsCapCb (_offset, ARCOMMANDS_Decoder_MiniDroneAnimationsCapCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_CAP */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORD:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTURE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCb != NULL)
                    {
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCb (_mass_storage_id, ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTURE */
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTUREV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Cb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Cb (ARCOMMANDS_Decoder_MiniDroneMediaRecordPictureV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTUREV2 */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORD */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCb != NULL)
                    {
                        uint8_t _state;
                        uint8_t _mass_storage_id;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCb (_state, _mass_storage_id, ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Cb != NULL)
                    {
                        eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state;
                        eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _state = (eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Cb (_state, _error, ARCOMMANDS_Decoder_MiniDroneMediaRecordStatePictureStateChangedV2Custom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2 */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCb != NULL)
                    {
                        eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event;
                        eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _event = (eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _error = (eARCOMMANDS_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCb (_event, _error, ARCOMMANDS_Decoder_MiniDroneMediaRecordEventPictureEventChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDEVENT */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXALTITUDE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCb (_current, ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxAltitudeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXALTITUDE */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXTILT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCb (_current, ARCOMMANDS_Decoder_MiniDronePilotingSettingsMaxTiltCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXTILT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxAltitudeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_MiniDronePilotingSettingsStateMaxTiltChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGSSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXVERTICALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCb (_current, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxVerticalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXVERTICALSPEED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXROTATIONSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCb (_current, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxRotationSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXROTATIONSPEED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_WHEELS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCb != NULL)
                    {
                        uint8_t _present;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _present = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCb (_present, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsWheelsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_WHEELS */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXHORIZONTALSPEED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCb != NULL)
                    {
                        float _current;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCb (_current, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsMaxHorizontalSpeedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXHORIZONTALSPEED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxRotationSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_WHEELSCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCb != NULL)
                    {
                        uint8_t _present;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _present = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCb (_present, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateWheelsChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_WHEELSCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXHORIZONTALSPEEDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCb != NULL)
                    {
                        float _current;
                        float _min;
                        float _max;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _current = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _min = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _max = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCb (_current, _min, _max, ARCOMMANDS_Decoder_MiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXHORIZONTALSPEEDCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SETTINGS_CMD_CUTOUTMODE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCb != NULL)
                    {
                        uint8_t _enable;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enable = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCb (_enable, ARCOMMANDS_Decoder_MiniDroneSettingsCutOutModeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGS_CMD_CUTOUTMODE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTMOTORSVERSIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCb != NULL)
                    {
                        uint8_t _motor;
                        char * _type = NULL;
                        char * _software = NULL;
                        char * _hardware = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _motor = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _software = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _hardware = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCb (_motor, _type, _software, _hardware, ARCOMMANDS_Decoder_MiniDroneSettingsStateProductMotorsVersionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTMOTORSVERSIONCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTINERTIALVERSIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCb != NULL)
                    {
                        char * _software = NULL;
                        char * _hardware = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _software = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _hardware = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCb (_software, _hardware, ARCOMMANDS_Decoder_MiniDroneSettingsStateProductInertialVersionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTINERTIALVERSIONCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_CUTOUTMODECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCb != NULL)
                    {
                        uint8_t _enable;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enable = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCb (_enable, ARCOMMANDS_Decoder_MiniDroneSettingsStateCutOutModeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_CUTOUTMODECHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_FLOODCONTROLSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_FLOODCONTROLSTATE_CMD_FLOODCONTROLCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCb != NULL)
                    {
                        uint16_t _delay;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _delay = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCb (_delay, ARCOMMANDS_Decoder_MiniDroneFloodControlStateFloodControlChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_FLOODCONTROLSTATE_CMD_FLOODCONTROLCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_FLOODCONTROLSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_GPS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLATITUDEFORRUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCb != NULL)
                    {
                        double _latitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCb (_latitude, ARCOMMANDS_Decoder_MiniDroneGPSControllerLatitudeForRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLATITUDEFORRUN */
                case ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLONGITUDEFORRUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCb != NULL)
                    {
                        double _longitude;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCb (_longitude, ARCOMMANDS_Decoder_MiniDroneGPSControllerLongitudeForRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLONGITUDEFORRUN */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_GPS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_CONFIGURATION:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERTYPE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCb != NULL)
                    {
                        char * _type = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCb (_type, ARCOMMANDS_Decoder_MiniDroneConfigurationControllerTypeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERTYPE */
                case ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERNAME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCb != NULL)
                    {
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCb (_name, ARCOMMANDS_Decoder_MiniDroneConfigurationControllerNameCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERNAME */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_CONFIGURATION */
            default:
                retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_MINIDRONE */
        case ARCOMMANDS_ID_FEATURE_SKYCONTROLLER:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFILIST:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCb != NULL)
                    {
                        char * _bssid = NULL;
                        char * _ssid = NULL;
                        uint8_t _secured;
                        uint8_t _saved;
                        int32_t _rssi;
                        int32_t _frequency;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _bssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _secured = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _saved = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _rssi =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _frequency =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCb (_bssid, _ssid, _secured, _saved, _rssi, _frequency, ARCOMMANDS_Decoder_SkyControllerWifiStateWifiListCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFILIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_CONNEXIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCb != NULL)
                    {
                        char * _ssid = NULL;
                        eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS _status;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _status = (eARCOMMANDS_SKYCONTROLLER_WIFISTATE_CONNEXIONCHANGED_STATUS)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCb (_ssid, _status, ARCOMMANDS_Decoder_SkyControllerWifiStateConnexionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_CONNEXIONCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFIAUTHCHANNELLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band;
                        uint8_t _channel;
                        uint8_t _in_or_out;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_SKYCONTROLLER_WIFISTATE_WIFIAUTHCHANNELLISTCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _in_or_out = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCb (_band, _channel, _in_or_out, ARCOMMANDS_Decoder_SkyControllerWifiStateWifiAuthChannelListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFIAUTHCHANNELLISTCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_ALLWIFIAUTHCHANNELCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCb (ARCOMMANDS_Decoder_SkyControllerWifiStateAllWifiAuthChannelChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_ALLWIFIAUTHCHANNELCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFISIGNALCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCb != NULL)
                    {
                        uint8_t _level;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _level = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCb (_level, ARCOMMANDS_Decoder_SkyControllerWifiStateWifiSignalChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFISIGNALCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTWIFILIST:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCb (ARCOMMANDS_Decoder_SkyControllerWifiRequestWifiListCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTWIFILIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTCURRENTWIFI:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCb (ARCOMMANDS_Decoder_SkyControllerWifiRequestCurrentWifiCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTCURRENTWIFI */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_CONNECTTOWIFI:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCb != NULL)
                    {
                        char * _bssid = NULL;
                        char * _ssid = NULL;
                        char * _passphrase = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _bssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _passphrase = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCb (_bssid, _ssid, _passphrase, ARCOMMANDS_Decoder_SkyControllerWifiConnectToWifiCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_CONNECTTOWIFI */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_FORGETWIFI:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCb != NULL)
                    {
                        char * _ssid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCb (_ssid, ARCOMMANDS_Decoder_SkyControllerWifiForgetWifiCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_FORGETWIFI */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_WIFIAUTHCHANNEL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCb (ARCOMMANDS_Decoder_SkyControllerWifiWifiAuthChannelCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_WIFIAUTHCHANNEL */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTDEVICELIST:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCb (ARCOMMANDS_Decoder_SkyControllerDeviceRequestDeviceListCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTDEVICELIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTCURRENTDEVICE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCb (ARCOMMANDS_Decoder_SkyControllerDeviceRequestCurrentDeviceCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTCURRENTDEVICE */
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_CONNECTTODEVICE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCb != NULL)
                    {
                        char * _deviceName = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _deviceName = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCb (_deviceName, ARCOMMANDS_Decoder_SkyControllerDeviceConnectToDeviceCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_CONNECTTODEVICE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICESTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_DEVICELIST:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCb != NULL)
                    {
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCb (_name, ARCOMMANDS_Decoder_SkyControllerDeviceStateDeviceListCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_DEVICELIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_CONNEXIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS _status;
                        char * _deviceName = NULL;
                        uint16_t _deviceProductID;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _status = (eARCOMMANDS_SKYCONTROLLER_DEVICESTATE_CONNEXIONCHANGED_STATUS)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _deviceName = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _deviceProductID = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCb (_status, _deviceName, _deviceProductID, ARCOMMANDS_Decoder_SkyControllerDeviceStateConnexionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_CONNEXIONCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICESTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_ALLSETTINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCb (ARCOMMANDS_Decoder_SkyControllerSettingsAllSettingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_ALLSETTINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_RESET:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSettingsResetCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSettingsResetCb (ARCOMMANDS_Decoder_SkyControllerSettingsResetCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_RESET */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCb (ARCOMMANDS_Decoder_SkyControllerSettingsStateAllSettingsChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_RESETCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCb (ARCOMMANDS_Decoder_SkyControllerSettingsStateResetChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_RESETCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTSERIALCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCb != NULL)
                    {
                        char * _serialNumber = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _serialNumber = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCb (_serialNumber, ARCOMMANDS_Decoder_SkyControllerSettingsStateProductSerialChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTSERIALCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTVARIANTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT _variant;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _variant = (eARCOMMANDS_SKYCONTROLLER_SETTINGSSTATE_PRODUCTVARIANTCHANGED_VARIANT)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCb (_variant, ARCOMMANDS_Decoder_SkyControllerSettingsStateProductVariantChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTVARIANTCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMON:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COMMON_CMD_ALLSTATES:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCb (ARCOMMANDS_Decoder_SkyControllerCommonAllStatesCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COMMON_CMD_ALLSTATES */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMON */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COMMONSTATE_CMD_ALLSTATESCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCb (ARCOMMANDS_Decoder_SkyControllerCommonStateAllStatesChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COMMONSTATE_CMD_ALLSTATESCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMONSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_BATTERYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCb != NULL)
                    {
                        uint8_t _percent;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _percent = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCb (_percent, ARCOMMANDS_Decoder_SkyControllerSkyControllerStateBatteryChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_BATTERYCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSFIXCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCb != NULL)
                    {
                        uint8_t _fixed;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _fixed = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCb (_fixed, ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsFixChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSFIXCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSPOSITIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        double _altitude;
                        float _heading;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _heading = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCb (_latitude, _longitude, _altitude, _heading, ARCOMMANDS_Decoder_SkyControllerSkyControllerStateGpsPositionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSPOSITIONCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTSSID:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCb != NULL)
                    {
                        char * _ssid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCb (_ssid, ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointSSIDCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTSSID */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTCHANNEL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCb != NULL)
                    {
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCb (_channel, ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsAccessPointChannelCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTCHANNEL */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_WIFISELECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE _type;
                        eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGS_WIFISELECTION_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCb (_type, _band, _channel, ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsWifiSelectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_WIFISELECTION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTSSIDCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCb != NULL)
                    {
                        char * _ssid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _ssid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCb (_ssid, ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointSSIDChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTSSIDCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTCHANNELCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCb != NULL)
                    {
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCb (_channel, ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateAccessPointChannelChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTCHANNELCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_WIFISELECTIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type;
                        eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band;
                        uint8_t _channel;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _band = (eARCOMMANDS_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_WIFISELECTIONCHANGED_BAND)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _channel = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCb (_type, _band, _channel, ARCOMMANDS_Decoder_SkyControllerAccessPointSettingsStateWifiSelectionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_WIFISELECTIONCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CAMERA:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_CAMERA_CMD_RESETORIENTATION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCb (ARCOMMANDS_Decoder_SkyControllerCameraResetOrientationCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CAMERA_CMD_RESETORIENTATION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CAMERA */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOS_CMD_GETGAMEPADCONTROLS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCb (ARCOMMANDS_Decoder_SkyControllerGamepadInfosGetGamepadControlsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOS_CMD_GETGAMEPADCONTROLS */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_GAMEPADCONTROL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE _type;
                        int32_t _id;
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_SKYCONTROLLER_GAMEPADINFOSSTATE_GAMEPADCONTROL_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCb (_type, _id, _name, ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateGamepadControlCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_GAMEPADCONTROL */
                case ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_ALLGAMEPADCONTROLSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCb (ARCOMMANDS_Decoder_SkyControllerGamepadInfosStateAllGamepadControlsSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_ALLGAMEPADCONTROLSSENT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETCURRENTBUTTONMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCb (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetCurrentButtonMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETCURRENTBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETAVAILABLEBUTTONMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCb (ARCOMMANDS_Decoder_SkyControllerButtonMappingsGetAvailableButtonMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETAVAILABLEBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_SETBUTTONMAPPING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCb != NULL)
                    {
                        int32_t _key_id;
                        char * _mapping_uid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _key_id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mapping_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCb (_key_id, _mapping_uid, ARCOMMANDS_Decoder_SkyControllerButtonMappingsSetButtonMappingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_SETBUTTONMAPPING */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_DEFAULTBUTTONMAPPING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCb (ARCOMMANDS_Decoder_SkyControllerButtonMappingsDefaultButtonMappingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_DEFAULTBUTTONMAPPING */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_CURRENTBUTTONMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCb != NULL)
                    {
                        int32_t _key_id;
                        char * _mapping_uid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _key_id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mapping_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCb (_key_id, _mapping_uid, ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateCurrentButtonMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_CURRENTBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLCURRENTBUTTONMAPPINGSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCb (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllCurrentButtonMappingsSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLCURRENTBUTTONMAPPINGSSENT */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_AVAILABLEBUTTONMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCb != NULL)
                    {
                        char * _mapping_uid = NULL;
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mapping_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCb (_mapping_uid, _name, ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAvailableButtonMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_AVAILABLEBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLAVAILABLEBUTTONSMAPPINGSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCb (ARCOMMANDS_Decoder_SkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLAVAILABLEBUTTONSMAPPINGSSENT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETCURRENTAXISMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCb (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetCurrentAxisMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETCURRENTAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETAVAILABLEAXISMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCb (ARCOMMANDS_Decoder_SkyControllerAxisMappingsGetAvailableAxisMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETAVAILABLEAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_SETAXISMAPPING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCb != NULL)
                    {
                        int32_t _axis_id;
                        char * _mapping_uid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _axis_id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mapping_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCb (_axis_id, _mapping_uid, ARCOMMANDS_Decoder_SkyControllerAxisMappingsSetAxisMappingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_SETAXISMAPPING */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_DEFAULTAXISMAPPING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCb (ARCOMMANDS_Decoder_SkyControllerAxisMappingsDefaultAxisMappingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_DEFAULTAXISMAPPING */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_CURRENTAXISMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCb != NULL)
                    {
                        int32_t _axis_id;
                        char * _mapping_uid = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _axis_id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mapping_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCb (_axis_id, _mapping_uid, ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateCurrentAxisMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_CURRENTAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLCURRENTAXISMAPPINGSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCb (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllCurrentAxisMappingsSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLCURRENTAXISMAPPINGSSENT */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_AVAILABLEAXISMAPPINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCb != NULL)
                    {
                        char * _mapping_uid = NULL;
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mapping_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCb (_mapping_uid, _name, ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAvailableAxisMappingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_AVAILABLEAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLAVAILABLEAXISMAPPINGSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCb (ARCOMMANDS_Decoder_SkyControllerAxisMappingsStateAllAvailableAxisMappingsSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLAVAILABLEAXISMAPPINGSSENT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETCURRENTAXISFILTERS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCb (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetCurrentAxisFiltersCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETCURRENTAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETPRESETAXISFILTERS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCb (ARCOMMANDS_Decoder_SkyControllerAxisFiltersGetPresetAxisFiltersCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETPRESETAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_SETAXISFILTER:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCb != NULL)
                    {
                        int32_t _axis_id;
                        char * _filter_uid_or_builder = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _axis_id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _filter_uid_or_builder = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCb (_axis_id, _filter_uid_or_builder, ARCOMMANDS_Decoder_SkyControllerAxisFiltersSetAxisFilterCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_SETAXISFILTER */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_DEFAULTAXISFILTERS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCb (ARCOMMANDS_Decoder_SkyControllerAxisFiltersDefaultAxisFiltersCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_DEFAULTAXISFILTERS */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_CURRENTAXISFILTERS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCb != NULL)
                    {
                        int32_t _axis_id;
                        char * _filter_uid_or_builder = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _axis_id =  (int32_t)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _filter_uid_or_builder = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCb (_axis_id, _filter_uid_or_builder, ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateCurrentAxisFiltersCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_CURRENTAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLCURRENTFILTERSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCb (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllCurrentFiltersSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLCURRENTFILTERSSENT */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_PRESETAXISFILTERS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCb != NULL)
                    {
                        char * _filter_uid = NULL;
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _filter_uid = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCb (_filter_uid, _name, ARCOMMANDS_Decoder_SkyControllerAxisFiltersStatePresetAxisFiltersCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_PRESETAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLPRESETFILTERSSENT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCb (ARCOMMANDS_Decoder_SkyControllerAxisFiltersStateAllPresetFiltersSentCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLPRESETFILTERSSENT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COPILOTING_CMD_SETPILOTINGSOURCE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE _source;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _source = (eARCOMMANDS_SKYCONTROLLER_COPILOTING_SETPILOTINGSOURCE_SOURCE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCb (_source, ARCOMMANDS_Decoder_SkyControllerCoPilotingSetPilotingSourceCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COPILOTING_CMD_SETPILOTINGSOURCE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTING */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COPILOTINGSTATE_CMD_PILOTINGSOURCE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE _source;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _source = (eARCOMMANDS_SKYCONTROLLER_COPILOTINGSTATE_PILOTINGSOURCE_SOURCE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCb (_source, ARCOMMANDS_Decoder_SkyControllerCoPilotingStatePilotingSourceCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COPILOTINGSTATE_CMD_PILOTINGSOURCE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTINGSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATION:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATION_CMD_ENABLEMAGNETOCALIBRATIONQUALITYUPDATES:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCb != NULL)
                    {
                        uint8_t _enable;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enable = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCb (_enable, ARCOMMANDS_Decoder_SkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATION_CMD_ENABLEMAGNETOCALIBRATIONQUALITYUPDATES */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATION */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATIONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCb != NULL)
                    {
                        eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS _status;
                        uint8_t _X_Quality;
                        uint8_t _Y_Quality;
                        uint8_t _Z_Quality;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _status = (eARCOMMANDS_SKYCONTROLLER_CALIBRATIONSTATE_MAGNETOCALIBRATIONSTATE_STATUS)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _X_Quality = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _Y_Quality = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _Z_Quality = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCb (_status, _X_Quality, _Y_Quality, _Z_Quality, ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationStateCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATE */
                case ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONQUALITYUPDATESSTATE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCb != NULL)
                    {
                        uint8_t _enabled;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _enabled = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCb (_enabled, ARCOMMANDS_Decoder_SkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONQUALITYUPDATESSTATE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATIONSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONEVENTS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONEVENTS_CMD_SETTINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCb (ARCOMMANDS_Decoder_SkyControllerButtonEventsSettingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONEVENTS_CMD_SETTINGS */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONEVENTS */
            default:
                retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_SKYCONTROLLER */
        case ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1:
        {
            if (commandClass == ARCOMMANDS_ID_FEATURE_CLASS)
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _distance_is_default;
                        float _distance;
                        uint8_t _elevation_is_default;
                        float _elevation;
                        uint8_t _azimuth_is_default;
                        float _azimuth;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCb (_start, _distance_is_default, _distance, _elevation_is_default, _elevation, _azimuth_is_default, _azimuth, ARCOMMANDS_Decoder_UnknownFeature1GeographicRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_GEOGRAPHIC_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _distance_is_default;
                        float _distance;
                        uint8_t _elevation_is_default;
                        float _elevation;
                        uint8_t _azimuth_is_default;
                        float _azimuth;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCb (_start, _distance_is_default, _distance, _elevation_is_default, _elevation, _azimuth_is_default, _azimuth, ARCOMMANDS_Decoder_UnknownFeature1RelativeRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_RELATIVE_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LOOK_AT_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCb != NULL)
                    {
                        uint8_t _start;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCb (_start, ARCOMMANDS_Decoder_UnknownFeature1LookAtRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_LOOK_AT_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _revolution_nb_is_default;
                        float _revolution_number;
                        uint8_t _vertical_distance_is_default;
                        float _vertical_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _revolution_nb_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _revolution_number = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCb (_start, _speed_is_default, _speed, _revolution_nb_is_default, _revolution_number, _vertical_distance_is_default, _vertical_distance, ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_SPIRAL_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _vertical_distance_is_default;
                        float _vertical_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCb (_start, _speed_is_default, _speed, _vertical_distance_is_default, _vertical_distance, ARCOMMANDS_Decoder_UnknownFeature1SwingAnimRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_SWING_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _distance_is_default;
                        float _distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCb (_start, _speed_is_default, _speed, _distance_is_default, _distance, ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_BOOMERANG_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _vertical_distance_is_default;
                        float _vertical_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCb (_start, _speed_is_default, _speed, _vertical_distance_is_default, _vertical_distance, ARCOMMANDS_Decoder_UnknownFeature1CandleAnimRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_CANDLE_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCb != NULL)
                    {
                        uint8_t _start;
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _angle_is_default;
                        float _angle;
                        uint8_t _horizontal_distance_is_default;
                        float _horizontal_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _start = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _angle_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _angle = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCb (_start, _speed_is_default, _speed, _angle_is_default, _angle, _horizontal_distance_is_default, _horizontal_distance, ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_DOLLY_SLIDE_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCb != NULL)
                    {
                        int8_t _horizontal;
                        int8_t _vertical;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCb (_horizontal, _vertical, ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_USER_FRAMING_POSITION */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_GPS_DATA:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCb != NULL)
                    {
                        double _latitude;
                        double _longitude;
                        float _altitude;
                        float _horizontal_accuracy;
                        float _vertical_accuracy;
                        float _north_speed;
                        float _east_speed;
                        float _down_speed;
                        double _timestamp;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _latitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _longitude = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _altitude = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal_accuracy = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_accuracy = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _north_speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _east_speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _down_speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _timestamp = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCb (_latitude, _longitude, _altitude, _horizontal_accuracy, _vertical_accuracy, _north_speed, _east_speed, _down_speed, _timestamp, ARCOMMANDS_Decoder_UnknownFeature1UserGPSDataCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_USER_GPS_DATA */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_BARO_DATA:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCb != NULL)
                    {
                        float _pressure;
                        double _timestamp;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _pressure = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _timestamp = ARCOMMANDS_ReadWrite_ReadDoubleFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCb (_pressure, _timestamp, ARCOMMANDS_Decoder_UnknownFeature1UserBaroDataCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_USER_BARO_DATA */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LYNX_DETECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCb != NULL)
                    {
                        float _target_pan;
                        float _target_tilt;
                        float _change_of_scale;
                        uint8_t _confidence_index;
                        uint8_t _is_new_selection;
                        uint64_t _timestamp;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _target_pan = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _target_tilt = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _change_of_scale = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _confidence_index = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _is_new_selection = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _timestamp = ARCOMMANDS_ReadWrite_Read64FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCb (_target_pan, _target_tilt, _change_of_scale, _confidence_index, _is_new_selection, _timestamp, ARCOMMANDS_Decoder_UnknownFeature1LynxDetectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_LYNX_DETECTION */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_AVAILABILITY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCb != NULL)
                    {
                        eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_UNKNOWN_FEATURE_1_TYPES_AVAILABLE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCb (_type, ARCOMMANDS_Decoder_UnknownFeature1AvailabilityCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_AVAILABILITY */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1RunCb != NULL)
                    {
                        eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_UNKNOWN_FEATURE_1_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1RunCb (_type, ARCOMMANDS_Decoder_UnknownFeature1RunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCb != NULL)
                    {
                        uint8_t _distance_is_default;
                        float _distance;
                        uint8_t _elevation_is_default;
                        float _elevation;
                        uint8_t _azimuth_is_default;
                        float _azimuth;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCb (_distance_is_default, _distance, _elevation_is_default, _elevation, _azimuth_is_default, _azimuth, ARCOMMANDS_Decoder_UnknownFeature1GeographicConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_GEOGRAPHIC_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCb != NULL)
                    {
                        uint8_t _distance_is_default;
                        float _distance;
                        uint8_t _elevation_is_default;
                        float _elevation;
                        uint8_t _azimuth_is_default;
                        float _azimuth;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _elevation = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _azimuth = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCb (_distance_is_default, _distance, _elevation_is_default, _elevation, _azimuth_is_default, _azimuth, ARCOMMANDS_Decoder_UnknownFeature1RelativeConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_RELATIVE_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_ANIM_RUN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1AnimRunCb != NULL)
                    {
                        eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE _type;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _type = (eARCOMMANDS_UNKNOWN_FEATURE_1_ANIM_TYPE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1AnimRunCb (_type, ARCOMMANDS_Decoder_UnknownFeature1AnimRunCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCb != NULL)
                    {
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _revolution_nb_is_default;
                        float _revolution_nb;
                        uint8_t _vertical_distance_is_default;
                        float _vertical_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _revolution_nb_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _revolution_nb = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCb (_speed_is_default, _speed, _revolution_nb_is_default, _revolution_nb, _vertical_distance_is_default, _vertical_distance, ARCOMMANDS_Decoder_UnknownFeature1SpiralAnimConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_SPIRAL_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCb != NULL)
                    {
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _vertical_distance_is_default;
                        float _vertical_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCb (_speed_is_default, _speed, _vertical_distance_is_default, _vertical_distance, ARCOMMANDS_Decoder_UnknownFeature1SwingAnimConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_SWING_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCb != NULL)
                    {
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _distance_is_default;
                        float _distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCb (_speed_is_default, _speed, _distance_is_default, _distance, ARCOMMANDS_Decoder_UnknownFeature1BoomerangAnimConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_BOOMERANG_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCb != NULL)
                    {
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _vertical_distance_is_default;
                        float _vertical_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCb (_speed_is_default, _speed, _vertical_distance_is_default, _vertical_distance, ARCOMMANDS_Decoder_UnknownFeature1CandleAnimConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_CANDLE_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_CONFIG_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCb != NULL)
                    {
                        uint8_t _speed_is_default;
                        float _speed;
                        uint8_t _angle_is_default;
                        float _angle;
                        uint8_t _horizontal_distance_is_default;
                        float _horizontal_distance;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _speed = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _angle_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _angle = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal_distance_is_default = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal_distance = ARCOMMANDS_ReadWrite_ReadFloatFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCb (_speed_is_default, _speed, _angle_is_default, _angle, _horizontal_distance_is_default, _horizontal_distance, ARCOMMANDS_Decoder_UnknownFeature1DollySlideAnimConfigChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_DOLLY_SLIDE_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION_CHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCb != NULL)
                    {
                        int8_t _horizontal;
                        int8_t _vertical;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _horizontal =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _vertical =  (int8_t)ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCb (_horizontal, _vertical, ARCOMMANDS_Decoder_UnknownFeature1UserFramingPositionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_BUTTONEVENTS_CMD_USER_FRAMING_POSITION_CHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            else
            {
                retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1 */
        case ARCOMMANDS_ID_FEATURE_COMMON:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_COMMON_CLASS_NETWORK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_NETWORK_CMD_DISCONNECT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonNetworkDisconnectCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonNetworkDisconnectCb (ARCOMMANDS_Decoder_CommonNetworkDisconnectCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_NETWORK_CMD_DISCONNECT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_NETWORK */
            case ARCOMMANDS_ID_COMMON_CLASS_NETWORKEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_NETWORKEVENT_CMD_DISCONNECTION:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCb != NULL)
                    {
                        eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE _cause;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _cause = (eARCOMMANDS_COMMON_NETWORKEVENT_DISCONNECTION_CAUSE)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCb (_cause, ARCOMMANDS_Decoder_CommonNetworkEventDisconnectionCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_NETWORKEVENT_CMD_DISCONNECTION */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_NETWORKEVENT */
            case ARCOMMANDS_ID_COMMON_CLASS_SETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_ALLSETTINGS:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsAllSettingsCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsAllSettingsCb (ARCOMMANDS_Decoder_CommonSettingsAllSettingsCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_ALLSETTINGS */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_RESET:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsResetCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsResetCb (ARCOMMANDS_Decoder_CommonSettingsResetCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_RESET */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_PRODUCTNAME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsProductNameCb != NULL)
                    {
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsProductNameCb (_name, ARCOMMANDS_Decoder_CommonSettingsProductNameCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_PRODUCTNAME */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_COUNTRY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsCountryCb != NULL)
                    {
                        char * _code = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _code = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsCountryCb (_code, ARCOMMANDS_Decoder_CommonSettingsCountryCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_COUNTRY */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_AUTOCOUNTRY:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsAutoCountryCb != NULL)
                    {
                        uint8_t _automatic;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _automatic = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsAutoCountryCb (_automatic, ARCOMMANDS_Decoder_CommonSettingsAutoCountryCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_AUTOCOUNTRY */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_SETTINGS */
            case ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCb (ARCOMMANDS_Decoder_CommonSettingsStateAllSettingsChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_RESETCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCb (ARCOMMANDS_Decoder_CommonSettingsStateResetChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_RESETCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTNAMECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCb != NULL)
                    {
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCb (_name, ARCOMMANDS_Decoder_CommonSettingsStateProductNameChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTNAMECHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTVERSIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCb != NULL)
                    {
                        char * _software = NULL;
                        char * _hardware = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _software = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _hardware = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCb (_software, _hardware, ARCOMMANDS_Decoder_CommonSettingsStateProductVersionChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTVERSIONCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALHIGHCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCb != NULL)
                    {
                        char * _high = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _high = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCb (_high, ARCOMMANDS_Decoder_CommonSettingsStateProductSerialHighChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALHIGHCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALLOWCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCb != NULL)
                    {
                        char * _low = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _low = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCb (_low, ARCOMMANDS_Decoder_CommonSettingsStateProductSerialLowChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALLOWCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_COUNTRYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCb != NULL)
                    {
                        char * _code = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _code = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCb (_code, ARCOMMANDS_Decoder_CommonSettingsStateCountryChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_COUNTRYCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_AUTOCOUNTRYCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCb != NULL)
                    {
                        uint8_t _automatic;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _automatic = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCb (_automatic, ARCOMMANDS_Decoder_CommonSettingsStateAutoCountryChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_AUTOCOUNTRYCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_COMMON:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_ALLSTATES:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonAllStatesCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonAllStatesCb (ARCOMMANDS_Decoder_CommonCommonAllStatesCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_ALLSTATES */
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTDATE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonCurrentDateCb != NULL)
                    {
                        char * _date = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _date = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonCurrentDateCb (_date, ARCOMMANDS_Decoder_CommonCommonCurrentDateCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTDATE */
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTTIME:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonCurrentTimeCb != NULL)
                    {
                        char * _time = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _time = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonCurrentTimeCb (_time, ARCOMMANDS_Decoder_CommonCommonCurrentTimeCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTTIME */
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_REBOOT:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonRebootCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonRebootCb (ARCOMMANDS_Decoder_CommonCommonRebootCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_REBOOT */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_COMMON */
            case ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_ALLSTATESCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCb (ARCOMMANDS_Decoder_CommonCommonStateAllStatesChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_ALLSTATESCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_BATTERYSTATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCb != NULL)
                    {
                        uint8_t _percent;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _percent = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCb (_percent, ARCOMMANDS_Decoder_CommonCommonStateBatteryStateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_BATTERYSTATECHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGESTATELISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCb != NULL)
                    {
                        uint8_t _mass_storage_id;
                        char * _name = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _name = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCb (_mass_storage_id, _name, ARCOMMANDS_Decoder_CommonCommonStateMassStorageStateListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGESTATELISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOSTATELISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCb != NULL)
                    {
                        uint8_t _mass_storage_id;
                        uint32_t _size;
                        uint32_t _used_size;
                        uint8_t _plugged;
                        uint8_t _full;
                        uint8_t _internal;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _mass_storage_id = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _size = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _used_size = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _plugged = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _full = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _internal = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCb (_mass_storage_id, _size, _used_size, _plugged, _full, _internal, ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoStateListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOSTATELISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTDATECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCb != NULL)
                    {
                        char * _date = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _date = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCb (_date, ARCOMMANDS_Decoder_CommonCommonStateCurrentDateChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTDATECHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTTIMECHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCb != NULL)
                    {
                        char * _time = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _time = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCb (_time, ARCOMMANDS_Decoder_CommonCommonStateCurrentTimeChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTTIMECHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOREMAININGLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCb != NULL)
                    {
                        uint32_t _free_space;
                        uint16_t _rec_time;
                        uint32_t _photo_remaining;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _free_space = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _rec_time = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _photo_remaining = ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCb (_free_space, _rec_time, _photo_remaining, ARCOMMANDS_Decoder_CommonCommonStateMassStorageInfoRemainingListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOREMAININGLISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_WIFISIGNALCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCb != NULL)
                    {
                        int16_t _rssi;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _rssi =  (int16_t)ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCb (_rssi, ARCOMMANDS_Decoder_CommonCommonStateWifiSignalChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_WIFISIGNALCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_SENSORSSTATESLISTCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCb != NULL)
                    {
                        eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME _sensorName;
                        uint8_t _sensorState;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _sensorName = (eARCOMMANDS_COMMON_COMMONSTATE_SENSORSSTATESLISTCHANGED_SENSORNAME)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _sensorState = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCb (_sensorName, _sensorState, ARCOMMANDS_Decoder_CommonCommonStateSensorsStatesListChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_SENSORSSTATESLISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_PRODUCTMODEL:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateProductModelCb != NULL)
                    {
                        eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL _model;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _model = (eARCOMMANDS_COMMON_COMMONSTATE_PRODUCTMODEL_MODEL)ARCOMMANDS_ReadWrite_Read32FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateProductModelCb (_model, ARCOMMANDS_Decoder_CommonCommonStateProductModelCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_PRODUCTMODEL */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_COUNTRYLISTKNOWN:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCb != NULL)
                    {
                        uint8_t _listFlags;
                        char * _countryCodes = NULL;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _listFlags = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _countryCodes = ARCOMMANDS_ReadWrite_ReadStringFromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCb (_listFlags, _countryCodes, ARCOMMANDS_Decoder_CommonCommonStateCountryListKnownCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_COUNTRYLISTKNOWN */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_OVERHEAT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_SWITCHOFF:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCb (ARCOMMANDS_Decoder_CommonOverHeatSwitchOffCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_SWITCHOFF */
                case ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_VENTILATE:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonOverHeatVentilateCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonOverHeatVentilateCb (ARCOMMANDS_Decoder_CommonOverHeatVentilateCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_VENTILATE */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_OVERHEAT */
            case ARCOMMANDS_ID_COMMON_CLASS_OVERHEATSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCb != NULL)
                    {
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCb (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATCHANGED */
                case ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATREGULATIONCHANGED:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCb != NULL)
                    {
                        uint8_t _regulationType;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _regulationType = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCb (_regulationType, ARCOMMANDS_Decoder_CommonOverHeatStateOverHeatRegulationChangedCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATREGULATIONCHANGED */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_OVERHEATSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_CONTROLLER:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CONTROLLER_CMD_ISPILOTING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonControllerIsPilotingCb != NULL)
                    {
                        uint8_t _piloting;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _piloting = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonControllerIsPilotingCb (_piloting, ARCOMMANDS_Decoder_CommonControllerIsPilotingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_CONTROLLER_CMD_ISPILOTING */
                default:
                    retVal = ARCOMMANDS_DECODER_ERROR_UNKNOWN_COMMAND;
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CONTROLLER */
            case ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_WIFISETTINGS_CMD_OUTDOORSETTING:
                {
                    ARSAL_Mutex_Lock (&ARCOMMANDS_Decoder_Mutex);
                    if (ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCb != NULL)
                    {
                        uint8_t _outdoor;
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            _outdoor = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, buffLen, &offset, &error);
                            if (error == 1)
                            {
                                retVal = ARCOMMANDS_DECODER_ERROR_NOT_ENOUGH_DATA;
                            } // No else --> Do not modify retVal if read went fine
                        } // No else --> Processing block
                        if (retVal == ARCOMMANDS_DECODER_OK)
                        {
                            ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCb (_outdoor, ARCOMMANDS_Decoder_CommonWifiSettingsOutdoorSettingCustom);
                        } // No else --> Processing block
                    }
                    else
                    {
                        retVal = ARCOMMANDS_DECODER_ERROR_NO_CALLBACK;
                    }
                    ARSAL_Mutex_Unlock (&ARCOMMANDS_Decoder_Mutex);
                }
                break; /* ARCOMMANDS_ID_COMMON_WIFISETTINGS_CM