/*
    Copyright (C) 2014 Parrot SA
    
    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in
    the documentation and/or other materials provided with the
    distribution.
    * Neither the name of Parrot nor the names
    of its contributors may be used to endorse or promote products
    derived from this software without specific prior written
    permission.
    
    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/
/********************************************
 *            AUTOGENERATED FILE            *
 *             DO NOT MODIFY IT             *
 *                                          *
 * To add new commands :                    *
 *  - Modify ../Xml/commands.xml file       *
 *  - Re-run generateCommandsList.py script *
 *                                          *
 ********************************************/
#include <config.h>
#include <stdlib.h>
#include "ARCOMMANDS_ReadWrite.h"
#include <libARCommands/ARCOMMANDS_Types.h>
#include <libARCommands/ARCOMMANDS_Filter.h>
#include <libARCommands/ARCOMMANDS_Ids.h>


// ARCOMMANDS_Filter_t structure definition
struct ARCOMMANDS_Filter_t
{
    // Feature generic
    eARCOMMANDS_FILTER_STATUS CmdGenericDefaultBehavior;

    // Feature ARDrone3
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingFlatTrimBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingTakeOffBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingPCMDBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingLandingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingEmergencyBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingNavigateHomeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingAutoTakeOffModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingMoveByBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingUserTakeOffBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingCircleBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3AnimationsFlipBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3CameraOrientationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordPictureBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordVideoBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordPictureV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordVideoV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkWifiScanBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkWifiAuthChannelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsMaxAltitudeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsMaxTiltBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsAbsolutControlBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsMaxDistanceBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsBankedTurnBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsMinAltitudeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsCirclingDirectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsCirclingRadiusBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsCirclingAltitudeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsPitchModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsLandingModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsMaxVerticalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsMaxRotationSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsHullProtectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsOutdoorBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkSettingsWifiSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkSettingsWifiSecurityBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsPictureFormatSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsExpositionSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsSaturationSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsTimelapseSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsVideoAutorecordSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsVideoStabilizationModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaStreamingVideoEnableBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsSetHomeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsResetHomeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsSendControllerGPSBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsHomeTypeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsReturnHomeDelayBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3AntiflickeringElectricFrequencyBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3AntiflickeringSetModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordStatePictureStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordStateVideoStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordStatePictureStateChangedV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordStateVideoStateChangedV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordEventPictureEventChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaRecordEventVideoEventChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateFlatTrimChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateFlyingStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateAlertStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateNavigateHomeStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStatePositionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateAttitudeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateAutoTakeOffModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingStateAltitudeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingEventMoveByEndBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkStateWifiScanListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkStateAllWifiScanChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkStateWifiAuthChannelListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkStateAllWifiAuthChannelChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateMaxTiltChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateAbsolutControlChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateMaxDistanceChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateBankedTurnChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateMinAltitudeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStatePitchModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PilotingSettingsStateLandingModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsStateHullProtectionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsStateOutdoorChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkSettingsStateWifiSelectionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkSettingsStateWifiSecurityChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3NetworkSettingsStateWifiSecurityBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateProductMotorVersionListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateProductGPSVersionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateMotorErrorStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateMotorSoftwareVersionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateMotorFlightsStatusChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateMotorErrorLastErrorChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3SettingsStateP7IDBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStatePictureFormatChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStateExpositionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStateSaturationChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStateTimelapseChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStateVideoAutorecordChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3MediaStreamingStateVideoEnableChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsStateHomeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsStateResetHomeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsStateGPSFixStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsStateHomeTypeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3CameraStateOrientationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3CameraStateDefaultCameraOrientationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3AntiflickeringStateElectricFrequencyChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3AntiflickeringStateModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSStateNumberOfSatelliteChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSStateHomeTypeAvailabilityChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3GPSStateHomeTypeChosenChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdARDrone3PROStateFeaturesBehavior;

    // Feature JumpingSumo
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoPilotingPCMDBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoPilotingPostureBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoPilotingAddCapOffsetBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsJumpStopBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsJumpCancelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsJumpLoadBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsJumpBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsSimpleAnimationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordPictureBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordVideoBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordPictureV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordVideoV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkSettingsWifiSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkWifiScanBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkWifiAuthChannelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAudioSettingsMasterVolumeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAudioSettingsThemeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanAllScriptsMetadataBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanScriptUploadedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanScriptDeleteBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanPlayScriptBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoSpeedSettingsOutdoorBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaStreamingVideoEnableBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoVideoSettingsAutorecordBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoPilotingStatePostureChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoPilotingStateAlertStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoPilotingStateSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsStateJumpLoadChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsStateJumpTypeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoSettingsStateProductGPSVersionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordStatePictureStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordStateVideoStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordStatePictureStateChangedV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordStateVideoStateChangedV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordEventPictureEventChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaRecordEventVideoEventChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkStateWifiScanListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkStateAllWifiScanChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoNetworkStateLinkQualityChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoAudioSettingsStateThemeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanStateScriptUploadChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanStateScriptDeleteChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoRoadPlanStatePlayScriptChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoSpeedSettingsStateOutdoorChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoMediaStreamingStateVideoEnableChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdJumpingSumoVideoSettingsStateAutorecordChangedBehavior;

    // Feature MiniDrone
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingFlatTrimBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingTakeOffBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingPCMDBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingLandingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingEmergencyBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingAutoTakeOffModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneAnimationsFlipBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneAnimationsCapBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneMediaRecordPictureBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneMediaRecordPictureV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingSettingsMaxAltitudeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingSettingsMaxTiltBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsMaxVerticalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsMaxRotationSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsWheelsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSettingsCutOutModeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneGPSControllerLatitudeForRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneGPSControllerLongitudeForRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneConfigurationControllerTypeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneConfigurationControllerNameBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingStateFlatTrimChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingStateFlyingStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingStateAlertStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingStateAutoTakeOffModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneMediaRecordStatePictureStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneMediaRecordStatePictureStateChangedV2Behavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneMediaRecordEventPictureEventChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDronePilotingSettingsStateMaxTiltChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsStateWheelsChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSettingsStateProductMotorsVersionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSettingsStateProductInertialVersionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneSettingsStateCutOutModeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdMiniDroneFloodControlStateFloodControlChangedBehavior;

    // Feature SkyController
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiRequestWifiListBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiRequestCurrentWifiBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiConnectToWifiBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiForgetWifiBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiWifiAuthChannelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerDeviceRequestDeviceListBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerDeviceRequestCurrentDeviceBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerDeviceConnectToDeviceBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSettingsAllSettingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSettingsResetBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCommonAllStatesBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAccessPointSettingsAccessPointSSIDBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAccessPointSettingsAccessPointChannelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAccessPointSettingsWifiSelectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCameraResetOrientationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerGamepadInfosGetGamepadControlsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsSetButtonMappingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsDefaultButtonMappingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsSetAxisMappingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsDefaultAxisMappingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersGetPresetAxisFiltersBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersSetAxisFilterBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersDefaultAxisFiltersBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCoPilotingSetPilotingSourceBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiStateWifiListBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiStateConnexionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiStateWifiAuthChannelListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiStateAllWifiAuthChannelChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerWifiStateWifiSignalChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerDeviceStateDeviceListBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerDeviceStateConnexionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSettingsStateAllSettingsChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSettingsStateResetChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSettingsStateProductSerialChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSettingsStateProductVariantChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCommonStateAllStatesChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSkyControllerStateBatteryChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSkyControllerStateGpsFixChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerSkyControllerStateGpsPositionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerGamepadInfosStateGamepadControlBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersStatePresetAxisFiltersBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCoPilotingStatePilotingSourceBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCalibrationStateMagnetoCalibrationStateBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior;
    eARCOMMANDS_FILTER_STATUS CmdSkyControllerButtonEventsSettingsBehavior;

    // Feature unknown_feature_1
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1GeographicRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1RelativeRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1LookAtRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1SpiralAnimRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1SwingAnimRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1BoomerangAnimRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1CandleAnimRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1DollySlideAnimRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1UserFramingPositionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1UserGPSDataBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1UserBaroDataBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1LynxDetectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1AvailabilityBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1RunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1GeographicConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1RelativeConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1AnimRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1SpiralAnimConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1SwingAnimConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1BoomerangAnimConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1CandleAnimConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1DollySlideAnimConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdUnknownFeature1UserFramingPositionChangedBehavior;

    // Feature common
    eARCOMMANDS_FILTER_STATUS CmdCommonNetworkDisconnectBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsAllSettingsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsResetBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsProductNameBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsCountryBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsAutoCountryBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonAllStatesBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonCurrentDateBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonCurrentTimeBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonRebootBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonOverHeatSwitchOffBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonOverHeatVentilateBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonControllerIsPilotingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonWifiSettingsOutdoorSettingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonMavlinkStartBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonMavlinkPauseBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonMavlinkStopBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCalibrationMagnetoCalibrationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonGPSControllerPositionForRunBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAudioControllerReadyForStreamingBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonHeadlightsIntensityBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAnimationsStartAnimationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAnimationsStopAnimationBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAnimationsStopAllAnimationsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAccessoryConfigBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonChargerSetMaxChargeRateBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonNetworkEventDisconnectionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateAllSettingsChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateResetChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateProductNameChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateProductVersionChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateProductSerialHighChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateProductSerialLowChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateCountryChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonSettingsStateAutoCountryChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateAllStatesChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateBatteryStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateMassStorageStateListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateMassStorageInfoStateListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateCurrentDateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateCurrentTimeChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateMassStorageInfoRemainingListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateWifiSignalChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateSensorsStatesListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateProductModelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCommonStateCountryListKnownBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonOverHeatStateOverHeatChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonOverHeatStateOverHeatRegulationChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonWifiSettingsStateOutdoorSettingsChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCalibrationStateMagnetoCalibrationStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonCameraSettingsStateCameraSettingsChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonFlightPlanStateAvailabilityStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonFlightPlanStateComponentStateListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonFlightPlanEventStartingErrorEventBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonFlightPlanEventSpeedBridleEventBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAudioStateAudioStreamingRunningBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonHeadlightsStateIntensityChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAnimationsStateListBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAccessoryStateSupportedAccessoriesListChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAccessoryStateAccessoryConfigChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonAccessoryStateAccessoryConfigModificationEnabledBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonChargerStateMaxChargeRateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonChargerStateCurrentChargeStateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonChargerStateLastChargeRateChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonChargerStateChargingInfoBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonRunStateRunIdChangedBehavior;

    // Feature commonDebug
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugStatsSendPacketBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugStatsStartSendingPacketFromDroneBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugStatsStopSendingPacketFromDroneBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugDebugSettingsGetAllBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugDebugSettingsSetBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugStatsEventSendPacketBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugDebugSettingsStateInfoBehavior;
    eARCOMMANDS_FILTER_STATUS CmdCommonDebugDebugSettingsStateListChangedBehavior;

    // Feature pro
    eARCOMMANDS_FILTER_STATUS CmdProProBoughtFeaturesBehavior;
    eARCOMMANDS_FILTER_STATUS CmdProProResponseBehavior;
    eARCOMMANDS_FILTER_STATUS CmdProProActivateFeaturesBehavior;
    eARCOMMANDS_FILTER_STATUS CmdProProStateSupportedFeaturesBehavior;
    eARCOMMANDS_FILTER_STATUS CmdProProStateFeaturesActivatedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdProProEventChallengeEventBehavior;

    // Feature wifi
    eARCOMMANDS_FILTER_STATUS CmdWifiScanBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiUpdateAuthorizedChannelsBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiSetApChannelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiSetSecurityBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiSetCountryBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiSetEnvironementBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiScannedItemBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiAuthorizedChannelBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiApChannelChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiSecurityChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiCountryChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiEnvironementChangedBehavior;
    eARCOMMANDS_FILTER_STATUS CmdWifiRssiChangedBehavior;

};


// Constructor
ARCOMMANDS_Filter_t* ARCOMMANDS_Filter_NewFilter (eARCOMMANDS_FILTER_STATUS defaultBehavior, eARCOMMANDS_FILTER_ERROR *error)
{
    ARCOMMANDS_Filter_t *retFilter = NULL;
    eARCOMMANDS_FILTER_ERROR localError = ARCOMMANDS_FILTER_OK;
    if ((defaultBehavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (defaultBehavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        localError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Args check

    if (localError == ARCOMMANDS_FILTER_OK)
    {
        retFilter = malloc (sizeof (struct ARCOMMANDS_Filter_t));
        if (retFilter == NULL)
        {
            localError = ARCOMMANDS_FILTER_ERROR_ALLOC;
        } // No else : Error processing.
    } // No else : Processing block

    // Setup default behavior
    if (localError == ARCOMMANDS_FILTER_OK)
    {
        // Feature generic
        retFilter->CmdGenericDefaultBehavior = defaultBehavior;
        // Feature ARDrone3
        retFilter->CmdARDrone3PilotingFlatTrimBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingTakeOffBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingPCMDBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingLandingBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingEmergencyBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingNavigateHomeBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingAutoTakeOffModeBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingMoveByBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingUserTakeOffBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingCircleBehavior = defaultBehavior;
        retFilter->CmdARDrone3AnimationsFlipBehavior = defaultBehavior;
        retFilter->CmdARDrone3CameraOrientationBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordPictureBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordVideoBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordPictureV2Behavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordVideoV2Behavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkWifiScanBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkWifiAuthChannelBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsMaxAltitudeBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsMaxTiltBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsAbsolutControlBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsMaxDistanceBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsBankedTurnBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsMinAltitudeBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsCirclingDirectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsCirclingRadiusBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsCirclingAltitudeBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsPitchModeBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsLandingModeBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsMaxVerticalSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsMaxRotationSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsHullProtectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsOutdoorBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkSettingsWifiSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkSettingsWifiSecurityBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsPictureFormatSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsExpositionSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsSaturationSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsTimelapseSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsVideoAutorecordSelectionBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsVideoStabilizationModeBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaStreamingVideoEnableBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsSetHomeBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsResetHomeBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsSendControllerGPSBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsHomeTypeBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsReturnHomeDelayBehavior = defaultBehavior;
        retFilter->CmdARDrone3AntiflickeringElectricFrequencyBehavior = defaultBehavior;
        retFilter->CmdARDrone3AntiflickeringSetModeBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordStatePictureStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordStateVideoStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordStatePictureStateChangedV2Behavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordStateVideoStateChangedV2Behavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordEventPictureEventChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaRecordEventVideoEventChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateFlatTrimChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateFlyingStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateAlertStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateNavigateHomeStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStatePositionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateAttitudeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateAutoTakeOffModeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingStateAltitudeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingEventMoveByEndBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkStateWifiScanListChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkStateAllWifiScanChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkStateWifiAuthChannelListChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkStateAllWifiAuthChannelChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateMaxTiltChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateAbsolutControlChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateMaxDistanceChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateBankedTurnChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateMinAltitudeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStatePitchModeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PilotingSettingsStateLandingModeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsStateHullProtectionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsStateOutdoorChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkSettingsStateWifiSelectionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkSettingsStateWifiSecurityChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3NetworkSettingsStateWifiSecurityBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateProductMotorVersionListChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateProductGPSVersionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateMotorErrorStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateMotorSoftwareVersionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateMotorFlightsStatusChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateMotorErrorLastErrorChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3SettingsStateP7IDBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStatePictureFormatChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStateExpositionChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStateSaturationChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStateTimelapseChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStateVideoAutorecordChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3MediaStreamingStateVideoEnableChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsStateHomeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsStateResetHomeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsStateGPSFixStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsStateHomeTypeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3CameraStateOrientationBehavior = defaultBehavior;
        retFilter->CmdARDrone3CameraStateDefaultCameraOrientationBehavior = defaultBehavior;
        retFilter->CmdARDrone3AntiflickeringStateElectricFrequencyChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3AntiflickeringStateModeChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSStateNumberOfSatelliteChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSStateHomeTypeAvailabilityChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3GPSStateHomeTypeChosenChangedBehavior = defaultBehavior;
        retFilter->CmdARDrone3PROStateFeaturesBehavior = defaultBehavior;
        // Feature JumpingSumo
        retFilter->CmdJumpingSumoPilotingPCMDBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoPilotingPostureBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoPilotingAddCapOffsetBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsJumpStopBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsJumpCancelBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsJumpLoadBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsJumpBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsSimpleAnimationBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordPictureBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordVideoBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordPictureV2Behavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordVideoV2Behavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkSettingsWifiSelectionBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkWifiScanBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkWifiAuthChannelBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAudioSettingsMasterVolumeBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAudioSettingsThemeBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanAllScriptsMetadataBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanScriptUploadedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanScriptDeleteBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanPlayScriptBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoSpeedSettingsOutdoorBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaStreamingVideoEnableBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoVideoSettingsAutorecordBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoPilotingStatePostureChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoPilotingStateAlertStateChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoPilotingStateSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsStateJumpLoadChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsStateJumpTypeChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoSettingsStateProductGPSVersionChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordStatePictureStateChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordStateVideoStateChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordStatePictureStateChangedV2Behavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordStateVideoStateChangedV2Behavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordEventPictureEventChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaRecordEventVideoEventChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkStateWifiScanListChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkStateAllWifiScanChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoNetworkStateLinkQualityChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoAudioSettingsStateThemeChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanStateScriptUploadChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanStateScriptDeleteChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoRoadPlanStatePlayScriptChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoSpeedSettingsStateOutdoorChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoMediaStreamingStateVideoEnableChangedBehavior = defaultBehavior;
        retFilter->CmdJumpingSumoVideoSettingsStateAutorecordChangedBehavior = defaultBehavior;
        // Feature MiniDrone
        retFilter->CmdMiniDronePilotingFlatTrimBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingTakeOffBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingPCMDBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingLandingBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingEmergencyBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingAutoTakeOffModeBehavior = defaultBehavior;
        retFilter->CmdMiniDroneAnimationsFlipBehavior = defaultBehavior;
        retFilter->CmdMiniDroneAnimationsCapBehavior = defaultBehavior;
        retFilter->CmdMiniDroneMediaRecordPictureBehavior = defaultBehavior;
        retFilter->CmdMiniDroneMediaRecordPictureV2Behavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingSettingsMaxAltitudeBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingSettingsMaxTiltBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsMaxVerticalSpeedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsMaxRotationSpeedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsWheelsBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSettingsCutOutModeBehavior = defaultBehavior;
        retFilter->CmdMiniDroneGPSControllerLatitudeForRunBehavior = defaultBehavior;
        retFilter->CmdMiniDroneGPSControllerLongitudeForRunBehavior = defaultBehavior;
        retFilter->CmdMiniDroneConfigurationControllerTypeBehavior = defaultBehavior;
        retFilter->CmdMiniDroneConfigurationControllerNameBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingStateFlatTrimChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingStateFlyingStateChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingStateAlertStateChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingStateAutoTakeOffModeChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneMediaRecordStatePictureStateChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneMediaRecordStatePictureStateChangedV2Behavior = defaultBehavior;
        retFilter->CmdMiniDroneMediaRecordEventPictureEventChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDronePilotingSettingsStateMaxTiltChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsStateWheelsChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSettingsStateProductMotorsVersionChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSettingsStateProductInertialVersionChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneSettingsStateCutOutModeChangedBehavior = defaultBehavior;
        retFilter->CmdMiniDroneFloodControlStateFloodControlChangedBehavior = defaultBehavior;
        // Feature SkyController
        retFilter->CmdSkyControllerWifiRequestWifiListBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiRequestCurrentWifiBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiConnectToWifiBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiForgetWifiBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiWifiAuthChannelBehavior = defaultBehavior;
        retFilter->CmdSkyControllerDeviceRequestDeviceListBehavior = defaultBehavior;
        retFilter->CmdSkyControllerDeviceRequestCurrentDeviceBehavior = defaultBehavior;
        retFilter->CmdSkyControllerDeviceConnectToDeviceBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSettingsAllSettingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSettingsResetBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCommonAllStatesBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAccessPointSettingsAccessPointSSIDBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAccessPointSettingsAccessPointChannelBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAccessPointSettingsWifiSelectionBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCameraResetOrientationBehavior = defaultBehavior;
        retFilter->CmdSkyControllerGamepadInfosGetGamepadControlsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsSetButtonMappingBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsDefaultButtonMappingBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsSetAxisMappingBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsDefaultAxisMappingBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersGetPresetAxisFiltersBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersSetAxisFilterBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersDefaultAxisFiltersBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCoPilotingSetPilotingSourceBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiStateWifiListBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiStateConnexionChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiStateWifiAuthChannelListChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiStateAllWifiAuthChannelChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerWifiStateWifiSignalChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerDeviceStateDeviceListBehavior = defaultBehavior;
        retFilter->CmdSkyControllerDeviceStateConnexionChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSettingsStateAllSettingsChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSettingsStateResetChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSettingsStateProductSerialChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSettingsStateProductVariantChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCommonStateAllStatesChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSkyControllerStateBatteryChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSkyControllerStateGpsFixChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerSkyControllerStateGpsPositionChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior = defaultBehavior;
        retFilter->CmdSkyControllerGamepadInfosStateGamepadControlBehavior = defaultBehavior;
        retFilter->CmdSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersStatePresetAxisFiltersBehavior = defaultBehavior;
        retFilter->CmdSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCoPilotingStatePilotingSourceBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCalibrationStateMagnetoCalibrationStateBehavior = defaultBehavior;
        retFilter->CmdSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior = defaultBehavior;
        retFilter->CmdSkyControllerButtonEventsSettingsBehavior = defaultBehavior;
        // Feature unknown_feature_1
        retFilter->CmdUnknownFeature1GeographicRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1RelativeRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1LookAtRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1SpiralAnimRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1SwingAnimRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1BoomerangAnimRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1CandleAnimRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1DollySlideAnimRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1UserFramingPositionBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1UserGPSDataBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1UserBaroDataBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1LynxDetectionBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1AvailabilityBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1RunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1GeographicConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1RelativeConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1AnimRunBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1SpiralAnimConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1SwingAnimConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1BoomerangAnimConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1CandleAnimConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1DollySlideAnimConfigChangedBehavior = defaultBehavior;
        retFilter->CmdUnknownFeature1UserFramingPositionChangedBehavior = defaultBehavior;
        // Feature common
        retFilter->CmdCommonNetworkDisconnectBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsAllSettingsBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsResetBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsProductNameBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsCountryBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsAutoCountryBehavior = defaultBehavior;
        retFilter->CmdCommonCommonAllStatesBehavior = defaultBehavior;
        retFilter->CmdCommonCommonCurrentDateBehavior = defaultBehavior;
        retFilter->CmdCommonCommonCurrentTimeBehavior = defaultBehavior;
        retFilter->CmdCommonCommonRebootBehavior = defaultBehavior;
        retFilter->CmdCommonOverHeatSwitchOffBehavior = defaultBehavior;
        retFilter->CmdCommonOverHeatVentilateBehavior = defaultBehavior;
        retFilter->CmdCommonControllerIsPilotingBehavior = defaultBehavior;
        retFilter->CmdCommonWifiSettingsOutdoorSettingBehavior = defaultBehavior;
        retFilter->CmdCommonMavlinkStartBehavior = defaultBehavior;
        retFilter->CmdCommonMavlinkPauseBehavior = defaultBehavior;
        retFilter->CmdCommonMavlinkStopBehavior = defaultBehavior;
        retFilter->CmdCommonCalibrationMagnetoCalibrationBehavior = defaultBehavior;
        retFilter->CmdCommonGPSControllerPositionForRunBehavior = defaultBehavior;
        retFilter->CmdCommonAudioControllerReadyForStreamingBehavior = defaultBehavior;
        retFilter->CmdCommonHeadlightsIntensityBehavior = defaultBehavior;
        retFilter->CmdCommonAnimationsStartAnimationBehavior = defaultBehavior;
        retFilter->CmdCommonAnimationsStopAnimationBehavior = defaultBehavior;
        retFilter->CmdCommonAnimationsStopAllAnimationsBehavior = defaultBehavior;
        retFilter->CmdCommonAccessoryConfigBehavior = defaultBehavior;
        retFilter->CmdCommonChargerSetMaxChargeRateBehavior = defaultBehavior;
        retFilter->CmdCommonNetworkEventDisconnectionBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateAllSettingsChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateResetChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateProductNameChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateProductVersionChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateProductSerialHighChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateProductSerialLowChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateCountryChangedBehavior = defaultBehavior;
        retFilter->CmdCommonSettingsStateAutoCountryChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateAllStatesChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateBatteryStateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateMassStorageStateListChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateMassStorageInfoStateListChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateCurrentDateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateCurrentTimeChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateMassStorageInfoRemainingListChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateWifiSignalChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateSensorsStatesListChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateProductModelBehavior = defaultBehavior;
        retFilter->CmdCommonCommonStateCountryListKnownBehavior = defaultBehavior;
        retFilter->CmdCommonOverHeatStateOverHeatChangedBehavior = defaultBehavior;
        retFilter->CmdCommonOverHeatStateOverHeatRegulationChangedBehavior = defaultBehavior;
        retFilter->CmdCommonWifiSettingsStateOutdoorSettingsChangedBehavior = defaultBehavior;
        retFilter->CmdCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCalibrationStateMagnetoCalibrationStateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior = defaultBehavior;
        retFilter->CmdCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior = defaultBehavior;
        retFilter->CmdCommonCameraSettingsStateCameraSettingsChangedBehavior = defaultBehavior;
        retFilter->CmdCommonFlightPlanStateAvailabilityStateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonFlightPlanStateComponentStateListChangedBehavior = defaultBehavior;
        retFilter->CmdCommonFlightPlanEventStartingErrorEventBehavior = defaultBehavior;
        retFilter->CmdCommonFlightPlanEventSpeedBridleEventBehavior = defaultBehavior;
        retFilter->CmdCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior = defaultBehavior;
        retFilter->CmdCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior = defaultBehavior;
        retFilter->CmdCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior = defaultBehavior;
        retFilter->CmdCommonAudioStateAudioStreamingRunningBehavior = defaultBehavior;
        retFilter->CmdCommonHeadlightsStateIntensityChangedBehavior = defaultBehavior;
        retFilter->CmdCommonAnimationsStateListBehavior = defaultBehavior;
        retFilter->CmdCommonAccessoryStateSupportedAccessoriesListChangedBehavior = defaultBehavior;
        retFilter->CmdCommonAccessoryStateAccessoryConfigChangedBehavior = defaultBehavior;
        retFilter->CmdCommonAccessoryStateAccessoryConfigModificationEnabledBehavior = defaultBehavior;
        retFilter->CmdCommonChargerStateMaxChargeRateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonChargerStateCurrentChargeStateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonChargerStateLastChargeRateChangedBehavior = defaultBehavior;
        retFilter->CmdCommonChargerStateChargingInfoBehavior = defaultBehavior;
        retFilter->CmdCommonRunStateRunIdChangedBehavior = defaultBehavior;
        // Feature commonDebug
        retFilter->CmdCommonDebugStatsSendPacketBehavior = defaultBehavior;
        retFilter->CmdCommonDebugStatsStartSendingPacketFromDroneBehavior = defaultBehavior;
        retFilter->CmdCommonDebugStatsStopSendingPacketFromDroneBehavior = defaultBehavior;
        retFilter->CmdCommonDebugDebugSettingsGetAllBehavior = defaultBehavior;
        retFilter->CmdCommonDebugDebugSettingsSetBehavior = defaultBehavior;
        retFilter->CmdCommonDebugStatsEventSendPacketBehavior = defaultBehavior;
        retFilter->CmdCommonDebugDebugSettingsStateInfoBehavior = defaultBehavior;
        retFilter->CmdCommonDebugDebugSettingsStateListChangedBehavior = defaultBehavior;
        // Feature pro
        retFilter->CmdProProBoughtFeaturesBehavior = defaultBehavior;
        retFilter->CmdProProResponseBehavior = defaultBehavior;
        retFilter->CmdProProActivateFeaturesBehavior = defaultBehavior;
        retFilter->CmdProProStateSupportedFeaturesBehavior = defaultBehavior;
        retFilter->CmdProProStateFeaturesActivatedBehavior = defaultBehavior;
        retFilter->CmdProProEventChallengeEventBehavior = defaultBehavior;
        // Feature wifi
        retFilter->CmdWifiScanBehavior = defaultBehavior;
        retFilter->CmdWifiUpdateAuthorizedChannelsBehavior = defaultBehavior;
        retFilter->CmdWifiSetApChannelBehavior = defaultBehavior;
        retFilter->CmdWifiSetSecurityBehavior = defaultBehavior;
        retFilter->CmdWifiSetCountryBehavior = defaultBehavior;
        retFilter->CmdWifiSetEnvironementBehavior = defaultBehavior;
        retFilter->CmdWifiScannedItemBehavior = defaultBehavior;
        retFilter->CmdWifiAuthorizedChannelBehavior = defaultBehavior;
        retFilter->CmdWifiApChannelChangedBehavior = defaultBehavior;
        retFilter->CmdWifiSecurityChangedBehavior = defaultBehavior;
        retFilter->CmdWifiCountryChangedBehavior = defaultBehavior;
        retFilter->CmdWifiEnvironementChangedBehavior = defaultBehavior;
        retFilter->CmdWifiRssiChangedBehavior = defaultBehavior;
    } // No else : Processing block

    if (error != NULL)
    {
        *error = localError;
    } // No else : Set error only if pointer is not NULL
    return retFilter;
}

void ARCOMMANDS_Filter_DeleteFilter (ARCOMMANDS_Filter_t **filter)
{
    if ((filter != NULL) &&
        (*filter != NULL))
    {
        free (*filter);
        *filter = NULL;
    } // No else : No need to delete an invalid filter instance
}

eARCOMMANDS_FILTER_STATUS ARCOMMANDS_Filter_FilterCommand (ARCOMMANDS_Filter_t *filter, uint8_t *buffer, uint32_t len, eARCOMMANDS_FILTER_ERROR *error)
{
    eARCOMMANDS_ID_FEATURE commandFeature = -1;
    int commandClass = -1;
    int commandId = -1;
    int32_t offset = 0;
    int32_t readError = 0;
    eARCOMMANDS_FILTER_ERROR localError = ARCOMMANDS_FILTER_OK;
    eARCOMMANDS_FILTER_STATUS retStatus = ARCOMMANDS_FILTER_STATUS_UNKNOWN;

    // Args check
    if (filter == NULL)
    {
        localError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((buffer == NULL) ||
        (len < 4))
    {
        localError = ARCOMMANDS_FILTER_ERROR_BAD_BUFFER;
    } // No else : Args check

    if (localError == ARCOMMANDS_FILTER_OK)
    {
        commandFeature = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, len, &offset, &readError);
        if (readError == 1)
        {
            localError = ARCOMMANDS_FILTER_ERROR_BAD_BUFFER;
        }
    } // No else : Processing block

    if (localError == ARCOMMANDS_FILTER_OK)
    {
        commandClass = ARCOMMANDS_ReadWrite_Read8FromBuffer (buffer, len, &offset, &readError);
        if (readError == 1)
        {
            localError = ARCOMMANDS_FILTER_ERROR_BAD_BUFFER;
        }
    } // No else : Processing block

    if (localError == ARCOMMANDS_FILTER_OK)
    {
        commandId = ARCOMMANDS_ReadWrite_Read16FromBuffer (buffer, len, &offset, &readError);
        if (readError == 1)
        {
            localError = ARCOMMANDS_FILTER_ERROR_BAD_BUFFER;
        }
    } // No else : Processing block

    if (localError == ARCOMMANDS_FILTER_OK)
    {
        switch (commandFeature)
        {
        case ARCOMMANDS_ID_FEATURE_GENERIC:
        {
            if (commandClass == ARCOMMANDS_ID_FEATURE_CLASS)
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_GENERIC_CMD_DEFAULT:
                {
                    retStatus = filter->CmdGenericDefaultBehavior;
                }
                break; /* ARCOMMANDS_ID_GENERIC_CMD_DEFAULT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            //Else Do nothing, the default answer is already UNKNOWN
        }
        break; /* ARCOMMANDS_ID_FEATURE_GENERIC */
        case ARCOMMANDS_ID_FEATURE_ARDRONE3:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_FLATTRIM:
                {
                    retStatus = filter->CmdARDrone3PilotingFlatTrimBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_FLATTRIM */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_TAKEOFF:
                {
                    retStatus = filter->CmdARDrone3PilotingTakeOffBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_TAKEOFF */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_PCMD:
                {
                    retStatus = filter->CmdARDrone3PilotingPCMDBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_PCMD */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_LANDING:
                {
                    retStatus = filter->CmdARDrone3PilotingLandingBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_LANDING */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_EMERGENCY:
                {
                    retStatus = filter->CmdARDrone3PilotingEmergencyBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_EMERGENCY */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_NAVIGATEHOME:
                {
                    retStatus = filter->CmdARDrone3PilotingNavigateHomeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_NAVIGATEHOME */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_AUTOTAKEOFFMODE:
                {
                    retStatus = filter->CmdARDrone3PilotingAutoTakeOffModeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_AUTOTAKEOFFMODE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_MOVEBY:
                {
                    retStatus = filter->CmdARDrone3PilotingMoveByBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_MOVEBY */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_USERTAKEOFF:
                {
                    retStatus = filter->CmdARDrone3PilotingUserTakeOffBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_USERTAKEOFF */
                case ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_CIRCLE:
                {
                    retStatus = filter->CmdARDrone3PilotingCircleBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTING_CMD_CIRCLE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTING */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_ANIMATIONS_CMD_FLIP:
                {
                    retStatus = filter->CmdARDrone3AnimationsFlipBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANIMATIONS_CMD_FLIP */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERA:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_CAMERA_CMD_ORIENTATION:
                {
                    retStatus = filter->CmdARDrone3CameraOrientationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_CAMERA_CMD_ORIENTATION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERA */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTURE:
                {
                    retStatus = filter->CmdARDrone3MediaRecordPictureBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTURE */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEO:
                {
                    retStatus = filter->CmdARDrone3MediaRecordVideoBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEO */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTUREV2:
                {
                    retStatus = filter->CmdARDrone3MediaRecordPictureV2Behavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_PICTUREV2 */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEOV2:
                {
                    retStatus = filter->CmdARDrone3MediaRecordVideoV2Behavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORD_CMD_VIDEOV2 */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORD */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3MediaRecordStatePictureStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3MediaRecordStateVideoStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2:
                {
                    retStatus = filter->CmdARDrone3MediaRecordStatePictureStateChangedV2Behavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2 */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2:
                {
                    retStatus = filter->CmdARDrone3MediaRecordStateVideoStateChangedV2Behavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2 */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED:
                {
                    retStatus = filter->CmdARDrone3MediaRecordEventPictureEventChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED:
                {
                    retStatus = filter->CmdARDrone3MediaRecordEventVideoEventChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIARECORDEVENT */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLATTRIMCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateFlatTrimChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLATTRIMCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLYINGSTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateFlyingStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_FLYINGSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALERTSTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateAlertStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALERTSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_NAVIGATEHOMESTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateNavigateHomeStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_NAVIGATEHOMESTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_POSITIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStatePositionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_POSITIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_SPEEDCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_SPEEDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ATTITUDECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateAttitudeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ATTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateAutoTakeOffModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALTITUDECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingStateAltitudeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSTATE_CMD_ALTITUDECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGEVENT_CMD_MOVEBYEND:
                {
                    retStatus = filter->CmdARDrone3PilotingEventMoveByEndBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGEVENT_CMD_MOVEBYEND */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGEVENT */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFISCAN:
                {
                    retStatus = filter->CmdARDrone3NetworkWifiScanBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFISCAN */
                case ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFIAUTHCHANNEL:
                {
                    retStatus = filter->CmdARDrone3NetworkWifiAuthChannelBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORK_CMD_WIFIAUTHCHANNEL */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORK */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFISCANLISTCHANGED:
                {
                    retStatus = filter->CmdARDrone3NetworkStateWifiScanListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFISCANLISTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFISCANCHANGED:
                {
                    retStatus = filter->CmdARDrone3NetworkStateAllWifiScanChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFISCANCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED:
                {
                    retStatus = filter->CmdARDrone3NetworkStateWifiAuthChannelListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED:
                {
                    retStatus = filter->CmdARDrone3NetworkStateAllWifiAuthChannelChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXALTITUDE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsMaxAltitudeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXALTITUDE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXTILT:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsMaxTiltBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXTILT */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_ABSOLUTCONTROL:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsAbsolutControlBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_ABSOLUTCONTROL */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXDISTANCE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsMaxDistanceBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MAXDISTANCE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_NOFLYOVERMAXDISTANCE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_NOFLYOVERMAXDISTANCE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALSPEED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALSPEED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALACCELERATION:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXVERTICALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXROTATIONSPEED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_SETAUTONOMOUSFLIGHTMAXROTATIONSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_BANKEDTURN:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsBankedTurnBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_BANKEDTURN */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MINALTITUDE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsMinAltitudeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_MINALTITUDE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGDIRECTION:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsCirclingDirectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGDIRECTION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGRADIUS:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsCirclingRadiusBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGRADIUS */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGALTITUDE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsCirclingAltitudeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_CIRCLINGALTITUDE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_PITCHMODE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsPitchModeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_PITCHMODE */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_LANDINGMODE:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsLandingModeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGS_CMD_LANDINGMODE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateMaxTiltChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_ABSOLUTCONTROLCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateAbsolutControlChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_ABSOLUTCONTROLCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXDISTANCECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateMaxDistanceChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MAXDISTANCECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_NOFLYOVERMAXDISTANCECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_NOFLYOVERMAXDISTANCECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALSPEED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXROTATIONSPEED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_AUTONOMOUSFLIGHTMAXROTATIONSPEED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_BANKEDTURNCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateBankedTurnChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_BANKEDTURNCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MINALTITUDECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateMinAltitudeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_MINALTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGDIRECTIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGDIRECTIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGRADIUSCHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGRADIUSCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGALTITUDECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_CIRCLINGALTITUDECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_PITCHMODECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStatePitchModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_PITCHMODECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_LANDINGMODECHANGED:
                {
                    retStatus = filter->CmdARDrone3PilotingSettingsStateLandingModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PILOTINGSETTINGSSTATE_CMD_LANDINGMODECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PILOTINGSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXVERTICALSPEED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsMaxVerticalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXVERTICALSPEED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXROTATIONSPEED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsMaxRotationSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXROTATIONSPEED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_HULLPROTECTION:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsHullProtectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_HULLPROTECTION */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_OUTDOOR:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsOutdoorBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_OUTDOOR */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXPITCHROLLROTATIONSPEED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGS_CMD_MAXPITCHROLLROTATIONSPEED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_HULLPROTECTIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsStateHullProtectionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_HULLPROTECTIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsStateOutdoorChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXPITCHROLLROTATIONSPEEDCHANGED:
                {
                    retStatus = filter->CmdARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SPEEDSETTINGSSTATE_CMD_MAXPITCHROLLROTATIONSPEEDCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_SPEEDSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISELECTION:
                {
                    retStatus = filter->CmdARDrone3NetworkSettingsWifiSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISELECTION */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISECURITY:
                {
                    retStatus = filter->CmdARDrone3NetworkSettingsWifiSecurityBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGS_CMD_WIFISECURITY */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3NetworkSettingsStateWifiSelectionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITYCHANGED:
                {
                    retStatus = filter->CmdARDrone3NetworkSettingsStateWifiSecurityChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITYCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITY:
                {
                    retStatus = filter->CmdARDrone3NetworkSettingsStateWifiSecurityBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_NETWORKSETTINGSSTATE_CMD_WIFISECURITY */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_NETWORKSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTMOTORVERSIONLISTCHANGED:
                {
                    retStatus = filter->CmdARDrone3SettingsStateProductMotorVersionListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTMOTORVERSIONLISTCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3SettingsStateProductGPSVersionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORSTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3SettingsStateMotorErrorStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORSOFTWAREVERSIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3SettingsStateMotorSoftwareVersionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORSOFTWAREVERSIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORFLIGHTSSTATUSCHANGED:
                {
                    retStatus = filter->CmdARDrone3SettingsStateMotorFlightsStatusChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORFLIGHTSSTATUSCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORLASTERRORCHANGED:
                {
                    retStatus = filter->CmdARDrone3SettingsStateMotorErrorLastErrorChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_MOTORERRORLASTERRORCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_P7ID:
                {
                    retStatus = filter->CmdARDrone3SettingsStateP7IDBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_SETTINGSSTATE_CMD_P7ID */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_PICTUREFORMATSELECTION:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsPictureFormatSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_PICTUREFORMATSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_AUTOWHITEBALANCESELECTION:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_AUTOWHITEBALANCESELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_EXPOSITIONSELECTION:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsExpositionSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_EXPOSITIONSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_SATURATIONSELECTION:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsSaturationSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_SATURATIONSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_TIMELAPSESELECTION:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsTimelapseSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_TIMELAPSESELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOAUTORECORDSELECTION:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsVideoAutorecordSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOAUTORECORDSELECTION */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOSTABILIZATIONMODE:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsVideoStabilizationModeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGS_CMD_VIDEOSTABILIZATIONMODE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_PICTUREFORMATCHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStatePictureFormatChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_PICTUREFORMATCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_AUTOWHITEBALANCECHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_AUTOWHITEBALANCECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_EXPOSITIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStateExpositionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_EXPOSITIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_SATURATIONCHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStateSaturationChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_SATURATIONCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_TIMELAPSECHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStateTimelapseChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_TIMELAPSECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOAUTORECORDCHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStateVideoAutorecordChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOAUTORECORDCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOSTABILIZATIONMODECHANGED:
                {
                    retStatus = filter->CmdARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PICTURESETTINGSSTATE_CMD_VIDEOSTABILIZATIONMODECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PICTURESETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMING_CMD_VIDEOENABLE:
                {
                    retStatus = filter->CmdARDrone3MediaStreamingVideoEnableBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMING_CMD_VIDEOENABLE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMING */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED:
                {
                    retStatus = filter->CmdARDrone3MediaStreamingStateVideoEnableChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_MEDIASTREAMINGSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SETHOME:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsSetHomeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SETHOME */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RESETHOME:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsResetHomeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RESETHOME */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SENDCONTROLLERGPS:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsSendControllerGPSBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_SENDCONTROLLERGPS */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_HOMETYPE:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsHomeTypeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_HOMETYPE */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RETURNHOMEDELAY:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsReturnHomeDelayBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGS_CMD_RETURNHOMEDELAY */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGS */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMECHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsStateHomeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RESETHOMECHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsStateResetHomeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RESETHOMECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSFIXSTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsStateGPSFixStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSFIXSTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSUPDATESTATECHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_GPSUPDATESTATECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMETYPECHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsStateHomeTypeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_HOMETYPECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RETURNHOMEDELAYCHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSETTINGSSTATE_CMD_RETURNHOMEDELAYCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSETTINGSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERASTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_ORIENTATION:
                {
                    retStatus = filter->CmdARDrone3CameraStateOrientationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_ORIENTATION */
                case ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_DEFAULTCAMERAORIENTATION:
                {
                    retStatus = filter->CmdARDrone3CameraStateDefaultCameraOrientationBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_CAMERASTATE_CMD_DEFAULTCAMERAORIENTATION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_CAMERASTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_ELECTRICFREQUENCY:
                {
                    retStatus = filter->CmdARDrone3AntiflickeringElectricFrequencyBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_ELECTRICFREQUENCY */
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_SETMODE:
                {
                    retStatus = filter->CmdARDrone3AntiflickeringSetModeBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERING_CMD_SETMODE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERING */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_ELECTRICFREQUENCYCHANGED:
                {
                    retStatus = filter->CmdARDrone3AntiflickeringStateElectricFrequencyChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_ELECTRICFREQUENCYCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_MODECHANGED:
                {
                    retStatus = filter->CmdARDrone3AntiflickeringStateModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_ANTIFLICKERINGSTATE_CMD_MODECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_ANTIFLICKERINGSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_NUMBEROFSATELLITECHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSStateNumberOfSatelliteChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_NUMBEROFSATELLITECHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPEAVAILABILITYCHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSStateHomeTypeAvailabilityChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPEAVAILABILITYCHANGED */
                case ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPECHOSENCHANGED:
                {
                    retStatus = filter->CmdARDrone3GPSStateHomeTypeChosenChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_GPSSTATE_CMD_HOMETYPECHOSENCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_GPSSTATE */
            case ARCOMMANDS_ID_ARDRONE3_CLASS_PROSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_ARDRONE3_PROSTATE_CMD_FEATURES:
                {
                    retStatus = filter->CmdARDrone3PROStateFeaturesBehavior;
                }
                break; /* ARCOMMANDS_ID_ARDRONE3_PROSTATE_CMD_FEATURES */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_ARDRONE3_CLASS_PROSTATE */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_ARDRONE3 */
        case ARCOMMANDS_ID_FEATURE_JUMPINGSUMO:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_PCMD:
                {
                    retStatus = filter->CmdJumpingSumoPilotingPCMDBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_PCMD */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_POSTURE:
                {
                    retStatus = filter->CmdJumpingSumoPilotingPostureBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_POSTURE */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_ADDCAPOFFSET:
                {
                    retStatus = filter->CmdJumpingSumoPilotingAddCapOffsetBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTING_CMD_ADDCAPOFFSET */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTING */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_POSTURECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoPilotingStatePostureChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_POSTURECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_ALERTSTATECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoPilotingStateAlertStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_ALERTSTATECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_SPEEDCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoPilotingStateSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_PILOTINGSTATE_CMD_SPEEDCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_PILOTINGSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPSTOP:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsJumpStopBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPSTOP */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPCANCEL:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsJumpCancelBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPCANCEL */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPLOAD:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsJumpLoadBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMPLOAD */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMP:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsJumpBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_JUMP */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_SIMPLEANIMATION:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsSimpleAnimationBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONS_CMD_SIMPLEANIMATION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPLOADCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsStateJumpLoadChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPLOADCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPTYPECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsStateJumpTypeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPTYPECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPMOTORPROBLEMCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ANIMATIONSSTATE_CMD_JUMPMOTORPROBLEMCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ANIMATIONSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoSettingsStateProductGPSVersionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_SETTINGSSTATE_CMD_PRODUCTGPSVERSIONCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTURE:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordPictureBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTURE */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEO:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordVideoBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEO */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTUREV2:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordPictureV2Behavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_PICTUREV2 */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEOV2:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordVideoV2Behavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORD_CMD_VIDEOV2 */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORD */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordStatePictureStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordStateVideoStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordStatePictureStateChangedV2Behavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2 */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordStateVideoStateChangedV2Behavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDSTATE_CMD_VIDEOSTATECHANGEDV2 */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordEventPictureEventChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoMediaRecordEventVideoEventChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIARECORDEVENT_CMD_VIDEOEVENTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIARECORDEVENT */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGS_CMD_WIFISELECTION:
                {
                    retStatus = filter->CmdJumpingSumoNetworkSettingsWifiSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGS_CMD_WIFISELECTION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSETTINGSSTATE_CMD_WIFISELECTIONCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFISCAN:
                {
                    retStatus = filter->CmdJumpingSumoNetworkWifiScanBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFISCAN */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFIAUTHCHANNEL:
                {
                    retStatus = filter->CmdJumpingSumoNetworkWifiAuthChannelBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORK_CMD_WIFIAUTHCHANNEL */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORK */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFISCANLISTCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoNetworkStateWifiScanListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFISCANLISTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFISCANCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoNetworkStateAllWifiScanChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFISCANCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_WIFIAUTHCHANNELLISTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_ALLWIFIAUTHCHANNELCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_LINKQUALITYCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoNetworkStateLinkQualityChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_NETWORKSTATE_CMD_LINKQUALITYCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_NETWORKSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_MASTERVOLUME:
                {
                    retStatus = filter->CmdJumpingSumoAudioSettingsMasterVolumeBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_MASTERVOLUME */
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_THEME:
                {
                    retStatus = filter->CmdJumpingSumoAudioSettingsThemeBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGS_CMD_THEME */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_MASTERVOLUMECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_MASTERVOLUMECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_THEMECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoAudioSettingsStateThemeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_AUDIOSETTINGSSTATE_CMD_THEMECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_AUDIOSETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_ALLSCRIPTSMETADATA:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanAllScriptsMetadataBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_ALLSCRIPTSMETADATA */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTUPLOADED:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanScriptUploadedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTUPLOADED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTDELETE:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanScriptDeleteBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_SCRIPTDELETE */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_PLAYSCRIPT:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanPlayScriptBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLAN_CMD_PLAYSCRIPT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLAN */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTMETADATALISTCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTMETADATALISTCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_ALLSCRIPTSMETADATACHANGED:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_ALLSCRIPTSMETADATACHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTUPLOADCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanStateScriptUploadChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTUPLOADCHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTDELETECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanStateScriptDeleteChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_SCRIPTDELETECHANGED */
                case ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_PLAYSCRIPTCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoRoadPlanStatePlayScriptChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_ROADPLANSTATE_CMD_PLAYSCRIPTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_ROADPLANSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGS_CMD_OUTDOOR:
                {
                    retStatus = filter->CmdJumpingSumoSpeedSettingsOutdoorBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGS_CMD_OUTDOOR */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoSpeedSettingsStateOutdoorChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_SPEEDSETTINGSSTATE_CMD_OUTDOORCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_SPEEDSETTINGSSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMING_CMD_VIDEOENABLE:
                {
                    retStatus = filter->CmdJumpingSumoMediaStreamingVideoEnableBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMING_CMD_VIDEOENABLE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMING */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED:
                {
                    retStatus = filter->CmdJumpingSumoMediaStreamingStateVideoEnableChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_MEDIASTREAMINGSTATE_CMD_VIDEOENABLECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_MEDIASTREAMINGSTATE */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGS_CMD_AUTORECORD:
                {
                    retStatus = filter->CmdJumpingSumoVideoSettingsAutorecordBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGS_CMD_AUTORECORD */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGS */
            case ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGSSTATE_CMD_AUTORECORDCHANGED:
                {
                    retStatus = filter->CmdJumpingSumoVideoSettingsStateAutorecordChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_JUMPINGSUMO_VIDEOSETTINGSSTATE_CMD_AUTORECORDCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_JUMPINGSUMO_CLASS_VIDEOSETTINGSSTATE */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_JUMPINGSUMO */
        case ARCOMMANDS_ID_FEATURE_MINIDRONE:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_FLATTRIM:
                {
                    retStatus = filter->CmdMiniDronePilotingFlatTrimBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_FLATTRIM */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_TAKEOFF:
                {
                    retStatus = filter->CmdMiniDronePilotingTakeOffBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_TAKEOFF */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_PCMD:
                {
                    retStatus = filter->CmdMiniDronePilotingPCMDBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_PCMD */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_LANDING:
                {
                    retStatus = filter->CmdMiniDronePilotingLandingBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_LANDING */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_EMERGENCY:
                {
                    retStatus = filter->CmdMiniDronePilotingEmergencyBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_EMERGENCY */
                case ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_AUTOTAKEOFFMODE:
                {
                    retStatus = filter->CmdMiniDronePilotingAutoTakeOffModeBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTING_CMD_AUTOTAKEOFFMODE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTING */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLATTRIMCHANGED:
                {
                    retStatus = filter->CmdMiniDronePilotingStateFlatTrimChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLATTRIMCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLYINGSTATECHANGED:
                {
                    retStatus = filter->CmdMiniDronePilotingStateFlyingStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_FLYINGSTATECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_ALERTSTATECHANGED:
                {
                    retStatus = filter->CmdMiniDronePilotingStateAlertStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_ALERTSTATECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED:
                {
                    retStatus = filter->CmdMiniDronePilotingStateAutoTakeOffModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSTATE_CMD_AUTOTAKEOFFMODECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_FLIP:
                {
                    retStatus = filter->CmdMiniDroneAnimationsFlipBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_FLIP */
                case ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_CAP:
                {
                    retStatus = filter->CmdMiniDroneAnimationsCapBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_ANIMATIONS_CMD_CAP */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORD:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTURE:
                {
                    retStatus = filter->CmdMiniDroneMediaRecordPictureBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTURE */
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTUREV2:
                {
                    retStatus = filter->CmdMiniDroneMediaRecordPictureV2Behavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORD_CMD_PICTUREV2 */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORD */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED:
                {
                    retStatus = filter->CmdMiniDroneMediaRecordStatePictureStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2:
                {
                    retStatus = filter->CmdMiniDroneMediaRecordStatePictureStateChangedV2Behavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORDSTATE_CMD_PICTURESTATECHANGEDV2 */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED:
                {
                    retStatus = filter->CmdMiniDroneMediaRecordEventPictureEventChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_MEDIARECORDEVENT_CMD_PICTUREEVENTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_MEDIARECORDEVENT */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXALTITUDE:
                {
                    retStatus = filter->CmdMiniDronePilotingSettingsMaxAltitudeBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXALTITUDE */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXTILT:
                {
                    retStatus = filter->CmdMiniDronePilotingSettingsMaxTiltBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGS_CMD_MAXTILT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED:
                {
                    retStatus = filter->CmdMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXALTITUDECHANGED */
                case ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED:
                {
                    retStatus = filter->CmdMiniDronePilotingSettingsStateMaxTiltChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_PILOTINGSETTINGSSTATE_CMD_MAXTILTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_PILOTINGSETTINGSSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXVERTICALSPEED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsMaxVerticalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXVERTICALSPEED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXROTATIONSPEED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsMaxRotationSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXROTATIONSPEED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_WHEELS:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsWheelsBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_WHEELS */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXHORIZONTALSPEED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGS_CMD_MAXHORIZONTALSPEED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXVERTICALSPEEDCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXROTATIONSPEEDCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_WHEELSCHANGED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsStateWheelsChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_WHEELSCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXHORIZONTALSPEEDCHANGED:
                {
                    retStatus = filter->CmdMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SPEEDSETTINGSSTATE_CMD_MAXHORIZONTALSPEEDCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SPEEDSETTINGSSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SETTINGS_CMD_CUTOUTMODE:
                {
                    retStatus = filter->CmdMiniDroneSettingsCutOutModeBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGS_CMD_CUTOUTMODE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTMOTORSVERSIONCHANGED:
                {
                    retStatus = filter->CmdMiniDroneSettingsStateProductMotorsVersionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTMOTORSVERSIONCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTINERTIALVERSIONCHANGED:
                {
                    retStatus = filter->CmdMiniDroneSettingsStateProductInertialVersionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_PRODUCTINERTIALVERSIONCHANGED */
                case ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_CUTOUTMODECHANGED:
                {
                    retStatus = filter->CmdMiniDroneSettingsStateCutOutModeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_SETTINGSSTATE_CMD_CUTOUTMODECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_FLOODCONTROLSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_FLOODCONTROLSTATE_CMD_FLOODCONTROLCHANGED:
                {
                    retStatus = filter->CmdMiniDroneFloodControlStateFloodControlChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_FLOODCONTROLSTATE_CMD_FLOODCONTROLCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_FLOODCONTROLSTATE */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_GPS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLATITUDEFORRUN:
                {
                    retStatus = filter->CmdMiniDroneGPSControllerLatitudeForRunBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLATITUDEFORRUN */
                case ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLONGITUDEFORRUN:
                {
                    retStatus = filter->CmdMiniDroneGPSControllerLongitudeForRunBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_GPS_CMD_CONTROLLERLONGITUDEFORRUN */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_GPS */
            case ARCOMMANDS_ID_MINIDRONE_CLASS_CONFIGURATION:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERTYPE:
                {
                    retStatus = filter->CmdMiniDroneConfigurationControllerTypeBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERTYPE */
                case ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERNAME:
                {
                    retStatus = filter->CmdMiniDroneConfigurationControllerNameBehavior;
                }
                break; /* ARCOMMANDS_ID_MINIDRONE_CONFIGURATION_CMD_CONTROLLERNAME */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_MINIDRONE_CLASS_CONFIGURATION */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_MINIDRONE */
        case ARCOMMANDS_ID_FEATURE_SKYCONTROLLER:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFILIST:
                {
                    retStatus = filter->CmdSkyControllerWifiStateWifiListBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFILIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_CONNEXIONCHANGED:
                {
                    retStatus = filter->CmdSkyControllerWifiStateConnexionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_CONNEXIONCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFIAUTHCHANNELLISTCHANGED:
                {
                    retStatus = filter->CmdSkyControllerWifiStateWifiAuthChannelListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFIAUTHCHANNELLISTCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_ALLWIFIAUTHCHANNELCHANGED:
                {
                    retStatus = filter->CmdSkyControllerWifiStateAllWifiAuthChannelChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_ALLWIFIAUTHCHANNELCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFISIGNALCHANGED:
                {
                    retStatus = filter->CmdSkyControllerWifiStateWifiSignalChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFISTATE_CMD_WIFISIGNALCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFISTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTWIFILIST:
                {
                    retStatus = filter->CmdSkyControllerWifiRequestWifiListBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTWIFILIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTCURRENTWIFI:
                {
                    retStatus = filter->CmdSkyControllerWifiRequestCurrentWifiBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_REQUESTCURRENTWIFI */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_CONNECTTOWIFI:
                {
                    retStatus = filter->CmdSkyControllerWifiConnectToWifiBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_CONNECTTOWIFI */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_FORGETWIFI:
                {
                    retStatus = filter->CmdSkyControllerWifiForgetWifiBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_FORGETWIFI */
                case ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_WIFIAUTHCHANNEL:
                {
                    retStatus = filter->CmdSkyControllerWifiWifiAuthChannelBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_WIFI_CMD_WIFIAUTHCHANNEL */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_WIFI */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTDEVICELIST:
                {
                    retStatus = filter->CmdSkyControllerDeviceRequestDeviceListBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTDEVICELIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTCURRENTDEVICE:
                {
                    retStatus = filter->CmdSkyControllerDeviceRequestCurrentDeviceBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_REQUESTCURRENTDEVICE */
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_CONNECTTODEVICE:
                {
                    retStatus = filter->CmdSkyControllerDeviceConnectToDeviceBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICE_CMD_CONNECTTODEVICE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICESTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_DEVICELIST:
                {
                    retStatus = filter->CmdSkyControllerDeviceStateDeviceListBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_DEVICELIST */
                case ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_CONNEXIONCHANGED:
                {
                    retStatus = filter->CmdSkyControllerDeviceStateConnexionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_DEVICESTATE_CMD_CONNEXIONCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_DEVICESTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_ALLSETTINGS:
                {
                    retStatus = filter->CmdSkyControllerSettingsAllSettingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_ALLSETTINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_RESET:
                {
                    retStatus = filter->CmdSkyControllerSettingsResetBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGS_CMD_RESET */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSettingsStateAllSettingsChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_RESETCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSettingsStateResetChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_RESETCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTSERIALCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSettingsStateProductSerialChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTSERIALCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTVARIANTCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSettingsStateProductVariantChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SETTINGSSTATE_CMD_PRODUCTVARIANTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMON:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COMMON_CMD_ALLSTATES:
                {
                    retStatus = filter->CmdSkyControllerCommonAllStatesBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COMMON_CMD_ALLSTATES */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMON */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COMMONSTATE_CMD_ALLSTATESCHANGED:
                {
                    retStatus = filter->CmdSkyControllerCommonStateAllStatesChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COMMONSTATE_CMD_ALLSTATESCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COMMONSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_BATTERYCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSkyControllerStateBatteryChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_BATTERYCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSFIXCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSkyControllerStateGpsFixChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSFIXCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSPOSITIONCHANGED:
                {
                    retStatus = filter->CmdSkyControllerSkyControllerStateGpsPositionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_SKYCONTROLLERSTATE_CMD_GPSPOSITIONCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_SKYCONTROLLERSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTSSID:
                {
                    retStatus = filter->CmdSkyControllerAccessPointSettingsAccessPointSSIDBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTSSID */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTCHANNEL:
                {
                    retStatus = filter->CmdSkyControllerAccessPointSettingsAccessPointChannelBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_ACCESSPOINTCHANNEL */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_WIFISELECTION:
                {
                    retStatus = filter->CmdSkyControllerAccessPointSettingsWifiSelectionBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGS_CMD_WIFISELECTION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTSSIDCHANGED:
                {
                    retStatus = filter->CmdSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTSSIDCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTCHANNELCHANGED:
                {
                    retStatus = filter->CmdSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_ACCESSPOINTCHANNELCHANGED */
                case ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_WIFISELECTIONCHANGED:
                {
                    retStatus = filter->CmdSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_ACCESSPOINTSETTINGSSTATE_CMD_WIFISELECTIONCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_ACCESSPOINTSETTINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CAMERA:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_CAMERA_CMD_RESETORIENTATION:
                {
                    retStatus = filter->CmdSkyControllerCameraResetOrientationBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CAMERA_CMD_RESETORIENTATION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CAMERA */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOS_CMD_GETGAMEPADCONTROLS:
                {
                    retStatus = filter->CmdSkyControllerGamepadInfosGetGamepadControlsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOS_CMD_GETGAMEPADCONTROLS */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_GAMEPADCONTROL:
                {
                    retStatus = filter->CmdSkyControllerGamepadInfosStateGamepadControlBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_GAMEPADCONTROL */
                case ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_ALLGAMEPADCONTROLSSENT:
                {
                    retStatus = filter->CmdSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_GAMEPADINFOSSTATE_CMD_ALLGAMEPADCONTROLSSENT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_GAMEPADINFOSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETCURRENTBUTTONMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETCURRENTBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETAVAILABLEBUTTONMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_GETAVAILABLEBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_SETBUTTONMAPPING:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsSetButtonMappingBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_SETBUTTONMAPPING */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_DEFAULTBUTTONMAPPING:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsDefaultButtonMappingBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGS_CMD_DEFAULTBUTTONMAPPING */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_CURRENTBUTTONMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_CURRENTBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLCURRENTBUTTONMAPPINGSSENT:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLCURRENTBUTTONMAPPINGSSENT */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_AVAILABLEBUTTONMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_AVAILABLEBUTTONMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLAVAILABLEBUTTONSMAPPINGSSENT:
                {
                    retStatus = filter->CmdSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONMAPPINGSSTATE_CMD_ALLAVAILABLEBUTTONSMAPPINGSSENT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONMAPPINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETCURRENTAXISMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETCURRENTAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETAVAILABLEAXISMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_GETAVAILABLEAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_SETAXISMAPPING:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsSetAxisMappingBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_SETAXISMAPPING */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_DEFAULTAXISMAPPING:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsDefaultAxisMappingBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGS_CMD_DEFAULTAXISMAPPING */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_CURRENTAXISMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_CURRENTAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLCURRENTAXISMAPPINGSSENT:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLCURRENTAXISMAPPINGSSENT */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_AVAILABLEAXISMAPPINGS:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_AVAILABLEAXISMAPPINGS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLAVAILABLEAXISMAPPINGSSENT:
                {
                    retStatus = filter->CmdSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISMAPPINGSSTATE_CMD_ALLAVAILABLEAXISMAPPINGSSENT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISMAPPINGSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETCURRENTAXISFILTERS:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETCURRENTAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETPRESETAXISFILTERS:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersGetPresetAxisFiltersBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_GETPRESETAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_SETAXISFILTER:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersSetAxisFilterBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_SETAXISFILTER */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_DEFAULTAXISFILTERS:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersDefaultAxisFiltersBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERS_CMD_DEFAULTAXISFILTERS */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERS */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_CURRENTAXISFILTERS:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_CURRENTAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLCURRENTFILTERSSENT:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLCURRENTFILTERSSENT */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_PRESETAXISFILTERS:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersStatePresetAxisFiltersBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_PRESETAXISFILTERS */
                case ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLPRESETFILTERSSENT:
                {
                    retStatus = filter->CmdSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_AXISFILTERSSTATE_CMD_ALLPRESETFILTERSSENT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_AXISFILTERSSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTING:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COPILOTING_CMD_SETPILOTINGSOURCE:
                {
                    retStatus = filter->CmdSkyControllerCoPilotingSetPilotingSourceBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COPILOTING_CMD_SETPILOTINGSOURCE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTING */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTINGSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_COPILOTINGSTATE_CMD_PILOTINGSOURCE:
                {
                    retStatus = filter->CmdSkyControllerCoPilotingStatePilotingSourceBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_COPILOTINGSTATE_CMD_PILOTINGSOURCE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_COPILOTINGSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATION:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATION_CMD_ENABLEMAGNETOCALIBRATIONQUALITYUPDATES:
                {
                    retStatus = filter->CmdSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATION_CMD_ENABLEMAGNETOCALIBRATIONQUALITYUPDATES */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATION */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATIONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATE:
                {
                    retStatus = filter->CmdSkyControllerCalibrationStateMagnetoCalibrationStateBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATE */
                case ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONQUALITYUPDATESSTATE:
                {
                    retStatus = filter->CmdSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONQUALITYUPDATESSTATE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_CALIBRATIONSTATE */
            case ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONEVENTS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_SKYCONTROLLER_BUTTONEVENTS_CMD_SETTINGS:
                {
                    retStatus = filter->CmdSkyControllerButtonEventsSettingsBehavior;
                }
                break; /* ARCOMMANDS_ID_SKYCONTROLLER_BUTTONEVENTS_CMD_SETTINGS */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_SKYCONTROLLER_CLASS_BUTTONEVENTS */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_SKYCONTROLLER */
        case ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1:
        {
            if (commandClass == ARCOMMANDS_ID_FEATURE_CLASS)
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1GeographicRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1RelativeRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LOOK_AT_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1LookAtRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LOOK_AT_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1SpiralAnimRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1SwingAnimRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1BoomerangAnimRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1CandleAnimRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1DollySlideAnimRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION:
                {
                    retStatus = filter->CmdUnknownFeature1UserFramingPositionBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_GPS_DATA:
                {
                    retStatus = filter->CmdUnknownFeature1UserGPSDataBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_GPS_DATA */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_BARO_DATA:
                {
                    retStatus = filter->CmdUnknownFeature1UserBaroDataBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_BARO_DATA */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LYNX_DETECTION:
                {
                    retStatus = filter->CmdUnknownFeature1LynxDetectionBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_LYNX_DETECTION */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_AVAILABILITY:
                {
                    retStatus = filter->CmdUnknownFeature1AvailabilityBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_AVAILABILITY */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1RunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1GeographicConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_GEOGRAPHIC_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1RelativeConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_RELATIVE_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_ANIM_RUN:
                {
                    retStatus = filter->CmdUnknownFeature1AnimRunBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_ANIM_RUN */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1SpiralAnimConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SPIRAL_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1SwingAnimConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_SWING_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1BoomerangAnimConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_BOOMERANG_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1CandleAnimConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_CANDLE_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_CONFIG_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1DollySlideAnimConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_DOLLY_SLIDE_ANIM_CONFIG_CHANGED */
                case ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION_CHANGED:
                {
                    retStatus = filter->CmdUnknownFeature1UserFramingPositionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_UNKNOWN_FEATURE_1_CMD_USER_FRAMING_POSITION_CHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            //Else Do nothing, the default answer is already UNKNOWN
        }
        break; /* ARCOMMANDS_ID_FEATURE_UNKNOWN_FEATURE_1 */
        case ARCOMMANDS_ID_FEATURE_COMMON:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_COMMON_CLASS_NETWORK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_NETWORK_CMD_DISCONNECT:
                {
                    retStatus = filter->CmdCommonNetworkDisconnectBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_NETWORK_CMD_DISCONNECT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_NETWORK */
            case ARCOMMANDS_ID_COMMON_CLASS_NETWORKEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_NETWORKEVENT_CMD_DISCONNECTION:
                {
                    retStatus = filter->CmdCommonNetworkEventDisconnectionBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_NETWORKEVENT_CMD_DISCONNECTION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_NETWORKEVENT */
            case ARCOMMANDS_ID_COMMON_CLASS_SETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_ALLSETTINGS:
                {
                    retStatus = filter->CmdCommonSettingsAllSettingsBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_ALLSETTINGS */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_RESET:
                {
                    retStatus = filter->CmdCommonSettingsResetBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_RESET */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_PRODUCTNAME:
                {
                    retStatus = filter->CmdCommonSettingsProductNameBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_PRODUCTNAME */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_COUNTRY:
                {
                    retStatus = filter->CmdCommonSettingsCountryBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_COUNTRY */
                case ARCOMMANDS_ID_COMMON_SETTINGS_CMD_AUTOCOUNTRY:
                {
                    retStatus = filter->CmdCommonSettingsAutoCountryBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGS_CMD_AUTOCOUNTRY */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_SETTINGS */
            case ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateAllSettingsChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_ALLSETTINGSCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_RESETCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateResetChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_RESETCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTNAMECHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateProductNameChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTNAMECHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTVERSIONCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateProductVersionChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTVERSIONCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALHIGHCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateProductSerialHighChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALHIGHCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALLOWCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateProductSerialLowChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_PRODUCTSERIALLOWCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_COUNTRYCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateCountryChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_COUNTRYCHANGED */
                case ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_AUTOCOUNTRYCHANGED:
                {
                    retStatus = filter->CmdCommonSettingsStateAutoCountryChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_SETTINGSSTATE_CMD_AUTOCOUNTRYCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_SETTINGSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_COMMON:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_ALLSTATES:
                {
                    retStatus = filter->CmdCommonCommonAllStatesBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_ALLSTATES */
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTDATE:
                {
                    retStatus = filter->CmdCommonCommonCurrentDateBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTDATE */
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTTIME:
                {
                    retStatus = filter->CmdCommonCommonCurrentTimeBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_CURRENTTIME */
                case ARCOMMANDS_ID_COMMON_COMMON_CMD_REBOOT:
                {
                    retStatus = filter->CmdCommonCommonRebootBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMON_CMD_REBOOT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_COMMON */
            case ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_ALLSTATESCHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateAllStatesChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_ALLSTATESCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_BATTERYSTATECHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateBatteryStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_BATTERYSTATECHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGESTATELISTCHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateMassStorageStateListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGESTATELISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOSTATELISTCHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateMassStorageInfoStateListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOSTATELISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTDATECHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateCurrentDateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTDATECHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTTIMECHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateCurrentTimeChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_CURRENTTIMECHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOREMAININGLISTCHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateMassStorageInfoRemainingListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_MASSSTORAGEINFOREMAININGLISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_WIFISIGNALCHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateWifiSignalChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_WIFISIGNALCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_SENSORSSTATESLISTCHANGED:
                {
                    retStatus = filter->CmdCommonCommonStateSensorsStatesListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_SENSORSSTATESLISTCHANGED */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_PRODUCTMODEL:
                {
                    retStatus = filter->CmdCommonCommonStateProductModelBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_PRODUCTMODEL */
                case ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_COUNTRYLISTKNOWN:
                {
                    retStatus = filter->CmdCommonCommonStateCountryListKnownBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_COMMONSTATE_CMD_COUNTRYLISTKNOWN */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_COMMONSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_OVERHEAT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_SWITCHOFF:
                {
                    retStatus = filter->CmdCommonOverHeatSwitchOffBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_SWITCHOFF */
                case ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_VENTILATE:
                {
                    retStatus = filter->CmdCommonOverHeatVentilateBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEAT_CMD_VENTILATE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_OVERHEAT */
            case ARCOMMANDS_ID_COMMON_CLASS_OVERHEATSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATCHANGED:
                {
                    retStatus = filter->CmdCommonOverHeatStateOverHeatChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATCHANGED */
                case ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATREGULATIONCHANGED:
                {
                    retStatus = filter->CmdCommonOverHeatStateOverHeatRegulationChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_OVERHEATSTATE_CMD_OVERHEATREGULATIONCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_OVERHEATSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_CONTROLLER:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CONTROLLER_CMD_ISPILOTING:
                {
                    retStatus = filter->CmdCommonControllerIsPilotingBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CONTROLLER_CMD_ISPILOTING */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CONTROLLER */
            case ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_WIFISETTINGS_CMD_OUTDOORSETTING:
                {
                    retStatus = filter->CmdCommonWifiSettingsOutdoorSettingBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_WIFISETTINGS_CMD_OUTDOORSETTING */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGS */
            case ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_WIFISETTINGSSTATE_CMD_OUTDOORSETTINGSCHANGED:
                {
                    retStatus = filter->CmdCommonWifiSettingsStateOutdoorSettingsChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_WIFISETTINGSSTATE_CMD_OUTDOORSETTINGSCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_WIFISETTINGSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_MAVLINK:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_MAVLINK_CMD_START:
                {
                    retStatus = filter->CmdCommonMavlinkStartBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_MAVLINK_CMD_START */
                case ARCOMMANDS_ID_COMMON_MAVLINK_CMD_PAUSE:
                {
                    retStatus = filter->CmdCommonMavlinkPauseBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_MAVLINK_CMD_PAUSE */
                case ARCOMMANDS_ID_COMMON_MAVLINK_CMD_STOP:
                {
                    retStatus = filter->CmdCommonMavlinkStopBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_MAVLINK_CMD_STOP */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_MAVLINK */
            case ARCOMMANDS_ID_COMMON_CLASS_MAVLINKSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_MAVLINKSTATE_CMD_MAVLINKFILEPLAYINGSTATECHANGED:
                {
                    retStatus = filter->CmdCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_MAVLINKSTATE_CMD_MAVLINKFILEPLAYINGSTATECHANGED */
                case ARCOMMANDS_ID_COMMON_MAVLINKSTATE_CMD_MAVLINKPLAYERRORSTATECHANGED:
                {
                    retStatus = filter->CmdCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_MAVLINKSTATE_CMD_MAVLINKPLAYERRORSTATECHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_MAVLINKSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_CALIBRATION:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CALIBRATION_CMD_MAGNETOCALIBRATION:
                {
                    retStatus = filter->CmdCommonCalibrationMagnetoCalibrationBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CALIBRATION_CMD_MAGNETOCALIBRATION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CALIBRATION */
            case ARCOMMANDS_ID_COMMON_CLASS_CALIBRATIONSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATECHANGED:
                {
                    retStatus = filter->CmdCommonCalibrationStateMagnetoCalibrationStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTATECHANGED */
                case ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONREQUIREDSTATE:
                {
                    retStatus = filter->CmdCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONREQUIREDSTATE */
                case ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED:
                {
                    retStatus = filter->CmdCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONAXISTOCALIBRATECHANGED */
                case ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTARTEDCHANGED:
                {
                    retStatus = filter->CmdCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CALIBRATIONSTATE_CMD_MAGNETOCALIBRATIONSTARTEDCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CALIBRATIONSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_CAMERASETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CAMERASETTINGSSTATE_CMD_CAMERASETTINGSCHANGED:
                {
                    retStatus = filter->CmdCommonCameraSettingsStateCameraSettingsChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CAMERASETTINGSSTATE_CMD_CAMERASETTINGSCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CAMERASETTINGSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_GPS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_GPS_CMD_CONTROLLERPOSITIONFORRUN:
                {
                    retStatus = filter->CmdCommonGPSControllerPositionForRunBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_GPS_CMD_CONTROLLERPOSITIONFORRUN */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_GPS */
            case ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_FLIGHTPLANSTATE_CMD_AVAILABILITYSTATECHANGED:
                {
                    retStatus = filter->CmdCommonFlightPlanStateAvailabilityStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_FLIGHTPLANSTATE_CMD_AVAILABILITYSTATECHANGED */
                case ARCOMMANDS_ID_COMMON_FLIGHTPLANSTATE_CMD_COMPONENTSTATELISTCHANGED:
                {
                    retStatus = filter->CmdCommonFlightPlanStateComponentStateListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_FLIGHTPLANSTATE_CMD_COMPONENTSTATELISTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_FLIGHTPLANEVENT_CMD_STARTINGERROREVENT:
                {
                    retStatus = filter->CmdCommonFlightPlanEventStartingErrorEventBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_FLIGHTPLANEVENT_CMD_STARTINGERROREVENT */
                case ARCOMMANDS_ID_COMMON_FLIGHTPLANEVENT_CMD_SPEEDBRIDLEEVENT:
                {
                    retStatus = filter->CmdCommonFlightPlanEventSpeedBridleEventBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_FLIGHTPLANEVENT_CMD_SPEEDBRIDLEEVENT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_FLIGHTPLANEVENT */
            case ARCOMMANDS_ID_COMMON_CLASS_ARLIBSVERSIONSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_CONTROLLERLIBARCOMMANDSVERSION:
                {
                    retStatus = filter->CmdCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_CONTROLLERLIBARCOMMANDSVERSION */
                case ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_SKYCONTROLLERLIBARCOMMANDSVERSION:
                {
                    retStatus = filter->CmdCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_SKYCONTROLLERLIBARCOMMANDSVERSION */
                case ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_DEVICELIBARCOMMANDSVERSION:
                {
                    retStatus = filter->CmdCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ARLIBSVERSIONSSTATE_CMD_DEVICELIBARCOMMANDSVERSION */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_ARLIBSVERSIONSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_AUDIO:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_AUDIO_CMD_CONTROLLERREADYFORSTREAMING:
                {
                    retStatus = filter->CmdCommonAudioControllerReadyForStreamingBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_AUDIO_CMD_CONTROLLERREADYFORSTREAMING */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_AUDIO */
            case ARCOMMANDS_ID_COMMON_CLASS_AUDIOSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_AUDIOSTATE_CMD_AUDIOSTREAMINGRUNNING:
                {
                    retStatus = filter->CmdCommonAudioStateAudioStreamingRunningBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_AUDIOSTATE_CMD_AUDIOSTREAMINGRUNNING */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_AUDIOSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_HEADLIGHTS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_HEADLIGHTS_CMD_INTENSITY:
                {
                    retStatus = filter->CmdCommonHeadlightsIntensityBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_HEADLIGHTS_CMD_INTENSITY */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_HEADLIGHTS */
            case ARCOMMANDS_ID_COMMON_CLASS_HEADLIGHTSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_HEADLIGHTSSTATE_CMD_INTENSITYCHANGED:
                {
                    retStatus = filter->CmdCommonHeadlightsStateIntensityChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_HEADLIGHTSSTATE_CMD_INTENSITYCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_HEADLIGHTSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STARTANIMATION:
                {
                    retStatus = filter->CmdCommonAnimationsStartAnimationBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STARTANIMATION */
                case ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STOPANIMATION:
                {
                    retStatus = filter->CmdCommonAnimationsStopAnimationBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STOPANIMATION */
                case ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STOPALLANIMATIONS:
                {
                    retStatus = filter->CmdCommonAnimationsStopAllAnimationsBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ANIMATIONS_CMD_STOPALLANIMATIONS */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONS */
            case ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_ANIMATIONSSTATE_CMD_LIST:
                {
                    retStatus = filter->CmdCommonAnimationsStateListBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ANIMATIONSSTATE_CMD_LIST */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_ANIMATIONSSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_ACCESSORY:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_ACCESSORY_CMD_CONFIG:
                {
                    retStatus = filter->CmdCommonAccessoryConfigBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ACCESSORY_CMD_CONFIG */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_ACCESSORY */
            case ARCOMMANDS_ID_COMMON_CLASS_ACCESSORYSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_SUPPORTEDACCESSORIESLISTCHANGED:
                {
                    retStatus = filter->CmdCommonAccessoryStateSupportedAccessoriesListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_SUPPORTEDACCESSORIESLISTCHANGED */
                case ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_ACCESSORYCONFIGCHANGED:
                {
                    retStatus = filter->CmdCommonAccessoryStateAccessoryConfigChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_ACCESSORYCONFIGCHANGED */
                case ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_ACCESSORYCONFIGMODIFICATIONENABLED:
                {
                    retStatus = filter->CmdCommonAccessoryStateAccessoryConfigModificationEnabledBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_ACCESSORYSTATE_CMD_ACCESSORYCONFIGMODIFICATIONENABLED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_ACCESSORYSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_CHARGER:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CHARGER_CMD_SETMAXCHARGERATE:
                {
                    retStatus = filter->CmdCommonChargerSetMaxChargeRateBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CHARGER_CMD_SETMAXCHARGERATE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CHARGER */
            case ARCOMMANDS_ID_COMMON_CLASS_CHARGERSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_MAXCHARGERATECHANGED:
                {
                    retStatus = filter->CmdCommonChargerStateMaxChargeRateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_MAXCHARGERATECHANGED */
                case ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_CURRENTCHARGESTATECHANGED:
                {
                    retStatus = filter->CmdCommonChargerStateCurrentChargeStateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_CURRENTCHARGESTATECHANGED */
                case ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_LASTCHARGERATECHANGED:
                {
                    retStatus = filter->CmdCommonChargerStateLastChargeRateChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_LASTCHARGERATECHANGED */
                case ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_CHARGINGINFO:
                {
                    retStatus = filter->CmdCommonChargerStateChargingInfoBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_CHARGERSTATE_CMD_CHARGINGINFO */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_CHARGERSTATE */
            case ARCOMMANDS_ID_COMMON_CLASS_RUNSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMON_RUNSTATE_CMD_RUNIDCHANGED:
                {
                    retStatus = filter->CmdCommonRunStateRunIdChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMON_RUNSTATE_CMD_RUNIDCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMON_CLASS_RUNSTATE */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_COMMON */
        case ARCOMMANDS_ID_FEATURE_COMMONDEBUG:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_COMMONDEBUG_CLASS_STATS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMONDEBUG_STATS_CMD_SENDPACKET:
                {
                    retStatus = filter->CmdCommonDebugStatsSendPacketBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_STATS_CMD_SENDPACKET */
                case ARCOMMANDS_ID_COMMONDEBUG_STATS_CMD_STARTSENDINGPACKETFROMDRONE:
                {
                    retStatus = filter->CmdCommonDebugStatsStartSendingPacketFromDroneBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_STATS_CMD_STARTSENDINGPACKETFROMDRONE */
                case ARCOMMANDS_ID_COMMONDEBUG_STATS_CMD_STOPSENDINGPACKETFROMDRONE:
                {
                    retStatus = filter->CmdCommonDebugStatsStopSendingPacketFromDroneBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_STATS_CMD_STOPSENDINGPACKETFROMDRONE */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMONDEBUG_CLASS_STATS */
            case ARCOMMANDS_ID_COMMONDEBUG_CLASS_STATSEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMONDEBUG_STATSEVENT_CMD_SENDPACKET:
                {
                    retStatus = filter->CmdCommonDebugStatsEventSendPacketBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_STATSEVENT_CMD_SENDPACKET */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMONDEBUG_CLASS_STATSEVENT */
            case ARCOMMANDS_ID_COMMONDEBUG_CLASS_DEBUGSETTINGS:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGS_CMD_GETALL:
                {
                    retStatus = filter->CmdCommonDebugDebugSettingsGetAllBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGS_CMD_GETALL */
                case ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGS_CMD_SET:
                {
                    retStatus = filter->CmdCommonDebugDebugSettingsSetBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGS_CMD_SET */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMONDEBUG_CLASS_DEBUGSETTINGS */
            case ARCOMMANDS_ID_COMMONDEBUG_CLASS_DEBUGSETTINGSSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGSSTATE_CMD_INFO:
                {
                    retStatus = filter->CmdCommonDebugDebugSettingsStateInfoBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGSSTATE_CMD_INFO */
                case ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGSSTATE_CMD_LISTCHANGED:
                {
                    retStatus = filter->CmdCommonDebugDebugSettingsStateListChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_COMMONDEBUG_DEBUGSETTINGSSTATE_CMD_LISTCHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_COMMONDEBUG_CLASS_DEBUGSETTINGSSTATE */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_COMMONDEBUG */
        case ARCOMMANDS_ID_FEATURE_PRO:
        {
            switch (commandClass)
            {
            case ARCOMMANDS_ID_PRO_CLASS_PRO:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_PRO_PRO_CMD_BOUGHTFEATURES:
                {
                    retStatus = filter->CmdProProBoughtFeaturesBehavior;
                }
                break; /* ARCOMMANDS_ID_PRO_PRO_CMD_BOUGHTFEATURES */
                case ARCOMMANDS_ID_PRO_PRO_CMD_RESPONSE:
                {
                    retStatus = filter->CmdProProResponseBehavior;
                }
                break; /* ARCOMMANDS_ID_PRO_PRO_CMD_RESPONSE */
                case ARCOMMANDS_ID_PRO_PRO_CMD_ACTIVATEFEATURES:
                {
                    retStatus = filter->CmdProProActivateFeaturesBehavior;
                }
                break; /* ARCOMMANDS_ID_PRO_PRO_CMD_ACTIVATEFEATURES */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_PRO_CLASS_PRO */
            case ARCOMMANDS_ID_PRO_CLASS_PROSTATE:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_PRO_PROSTATE_CMD_SUPPORTEDFEATURES:
                {
                    retStatus = filter->CmdProProStateSupportedFeaturesBehavior;
                }
                break; /* ARCOMMANDS_ID_PRO_PROSTATE_CMD_SUPPORTEDFEATURES */
                case ARCOMMANDS_ID_PRO_PROSTATE_CMD_FEATURESACTIVATED:
                {
                    retStatus = filter->CmdProProStateFeaturesActivatedBehavior;
                }
                break; /* ARCOMMANDS_ID_PRO_PROSTATE_CMD_FEATURESACTIVATED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_PRO_CLASS_PROSTATE */
            case ARCOMMANDS_ID_PRO_CLASS_PROEVENT:
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_PRO_PROEVENT_CMD_CHALLENGEEVENT:
                {
                    retStatus = filter->CmdProProEventChallengeEventBehavior;
                }
                break; /* ARCOMMANDS_ID_PRO_PROEVENT_CMD_CHALLENGEEVENT */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            break; /* ARCOMMANDS_ID_PRO_CLASS_PROEVENT */
            default:
                // Do nothing, the default answer is already UNKNOWN
                break;
            }
        }
        break; /* ARCOMMANDS_ID_FEATURE_PRO */
        case ARCOMMANDS_ID_FEATURE_WIFI:
        {
            if (commandClass == ARCOMMANDS_ID_FEATURE_CLASS)
            {
                switch (commandId)
                {
                case ARCOMMANDS_ID_WIFI_CMD_SCAN:
                {
                    retStatus = filter->CmdWifiScanBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SCAN */
                case ARCOMMANDS_ID_WIFI_CMD_UPDATE_AUTHORIZED_CHANNELS:
                {
                    retStatus = filter->CmdWifiUpdateAuthorizedChannelsBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_UPDATE_AUTHORIZED_CHANNELS */
                case ARCOMMANDS_ID_WIFI_CMD_SET_AP_CHANNEL:
                {
                    retStatus = filter->CmdWifiSetApChannelBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SET_AP_CHANNEL */
                case ARCOMMANDS_ID_WIFI_CMD_SET_SECURITY:
                {
                    retStatus = filter->CmdWifiSetSecurityBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SET_SECURITY */
                case ARCOMMANDS_ID_WIFI_CMD_SET_COUNTRY:
                {
                    retStatus = filter->CmdWifiSetCountryBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SET_COUNTRY */
                case ARCOMMANDS_ID_WIFI_CMD_SET_ENVIRONEMENT:
                {
                    retStatus = filter->CmdWifiSetEnvironementBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SET_ENVIRONEMENT */
                case ARCOMMANDS_ID_WIFI_CMD_SCANNED_ITEM:
                {
                    retStatus = filter->CmdWifiScannedItemBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SCANNED_ITEM */
                case ARCOMMANDS_ID_WIFI_CMD_AUTHORIZED_CHANNEL:
                {
                    retStatus = filter->CmdWifiAuthorizedChannelBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_AUTHORIZED_CHANNEL */
                case ARCOMMANDS_ID_WIFI_CMD_AP_CHANNEL_CHANGED:
                {
                    retStatus = filter->CmdWifiApChannelChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_AP_CHANNEL_CHANGED */
                case ARCOMMANDS_ID_WIFI_CMD_SECURITY_CHANGED:
                {
                    retStatus = filter->CmdWifiSecurityChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_SECURITY_CHANGED */
                case ARCOMMANDS_ID_WIFI_CMD_COUNTRY_CHANGED:
                {
                    retStatus = filter->CmdWifiCountryChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_COUNTRY_CHANGED */
                case ARCOMMANDS_ID_WIFI_CMD_ENVIRONEMENT_CHANGED:
                {
                    retStatus = filter->CmdWifiEnvironementChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_ENVIRONEMENT_CHANGED */
                case ARCOMMANDS_ID_WIFI_CMD_RSSI_CHANGED:
                {
                    retStatus = filter->CmdWifiRssiChangedBehavior;
                }
                break; /* ARCOMMANDS_ID_WIFI_CMD_RSSI_CHANGED */
                default:
                    // Do nothing, the default answer is already UNKNOWN
                    break;
                }
            }
            //Else Do nothing, the default answer is already UNKNOWN
        }
        break; /* ARCOMMANDS_ID_FEATURE_WIFI */
        default:
            // Do nothing, the default answer is already UNKNOWN
            break;
        }
    }

    if (localError != ARCOMMANDS_FILTER_OK)
    {
        retStatus = ARCOMMANDS_FILTER_STATUS_ERROR;
    } // No else : Keep retStatus if no error occured

    if (error != NULL)
    {
        *error = localError;
    } // No else : Set error only if pointer is not NULL

    return retStatus;
}


// Filter ON/OFF functions
// Feature generic

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetGenericBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdGenericDefaultBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetGenericDefaultBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdGenericDefaultBehavior = behavior;
    }

    return retError;
}


// Feature ARDrone3

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingFlatTrimBehavior = behavior;
        filter->CmdARDrone3PilotingTakeOffBehavior = behavior;
        filter->CmdARDrone3PilotingPCMDBehavior = behavior;
        filter->CmdARDrone3PilotingLandingBehavior = behavior;
        filter->CmdARDrone3PilotingEmergencyBehavior = behavior;
        filter->CmdARDrone3PilotingNavigateHomeBehavior = behavior;
        filter->CmdARDrone3PilotingAutoTakeOffModeBehavior = behavior;
        filter->CmdARDrone3PilotingMoveByBehavior = behavior;
        filter->CmdARDrone3PilotingUserTakeOffBehavior = behavior;
        filter->CmdARDrone3PilotingCircleBehavior = behavior;
        filter->CmdARDrone3AnimationsFlipBehavior = behavior;
        filter->CmdARDrone3CameraOrientationBehavior = behavior;
        filter->CmdARDrone3MediaRecordPictureBehavior = behavior;
        filter->CmdARDrone3MediaRecordVideoBehavior = behavior;
        filter->CmdARDrone3MediaRecordPictureV2Behavior = behavior;
        filter->CmdARDrone3MediaRecordVideoV2Behavior = behavior;
        filter->CmdARDrone3NetworkWifiScanBehavior = behavior;
        filter->CmdARDrone3NetworkWifiAuthChannelBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMaxAltitudeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMaxTiltBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsAbsolutControlBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMaxDistanceBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsBankedTurnBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMinAltitudeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsCirclingDirectionBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsCirclingRadiusBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsCirclingAltitudeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsPitchModeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsLandingModeBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsMaxVerticalSpeedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsMaxRotationSpeedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsHullProtectionBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsOutdoorBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsWifiSelectionBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsWifiSecurityBehavior = behavior;
        filter->CmdARDrone3PictureSettingsPictureFormatSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsExpositionSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsSaturationSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsTimelapseSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsVideoAutorecordSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsVideoStabilizationModeBehavior = behavior;
        filter->CmdARDrone3MediaStreamingVideoEnableBehavior = behavior;
        filter->CmdARDrone3GPSSettingsSetHomeBehavior = behavior;
        filter->CmdARDrone3GPSSettingsResetHomeBehavior = behavior;
        filter->CmdARDrone3GPSSettingsSendControllerGPSBehavior = behavior;
        filter->CmdARDrone3GPSSettingsHomeTypeBehavior = behavior;
        filter->CmdARDrone3GPSSettingsReturnHomeDelayBehavior = behavior;
        filter->CmdARDrone3AntiflickeringElectricFrequencyBehavior = behavior;
        filter->CmdARDrone3AntiflickeringSetModeBehavior = behavior;
        filter->CmdARDrone3MediaRecordStatePictureStateChangedBehavior = behavior;
        filter->CmdARDrone3MediaRecordStateVideoStateChangedBehavior = behavior;
        filter->CmdARDrone3MediaRecordStatePictureStateChangedV2Behavior = behavior;
        filter->CmdARDrone3MediaRecordStateVideoStateChangedV2Behavior = behavior;
        filter->CmdARDrone3MediaRecordEventPictureEventChangedBehavior = behavior;
        filter->CmdARDrone3MediaRecordEventVideoEventChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateFlatTrimChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateFlyingStateChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAlertStateChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateNavigateHomeStateChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStatePositionChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateSpeedChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAttitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAutoTakeOffModeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingEventMoveByEndBehavior = behavior;
        filter->CmdARDrone3NetworkStateWifiScanListChangedBehavior = behavior;
        filter->CmdARDrone3NetworkStateAllWifiScanChangedBehavior = behavior;
        filter->CmdARDrone3NetworkStateWifiAuthChannelListChangedBehavior = behavior;
        filter->CmdARDrone3NetworkStateAllWifiAuthChannelChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMaxTiltChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAbsolutControlChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMaxDistanceChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateBankedTurnChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMinAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStatePitchModeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateLandingModeChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateHullProtectionChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateOutdoorChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsStateWifiSelectionChangedBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsStateWifiSecurityChangedBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsStateWifiSecurityBehavior = behavior;
        filter->CmdARDrone3SettingsStateProductMotorVersionListChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateProductGPSVersionChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorErrorStateChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorSoftwareVersionChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorFlightsStatusChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorErrorLastErrorChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateP7IDBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStatePictureFormatChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateExpositionChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateSaturationChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateTimelapseChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateVideoAutorecordChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior = behavior;
        filter->CmdARDrone3MediaStreamingStateVideoEnableChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateHomeChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateResetHomeChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateGPSFixStateChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateHomeTypeChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior = behavior;
        filter->CmdARDrone3CameraStateOrientationBehavior = behavior;
        filter->CmdARDrone3CameraStateDefaultCameraOrientationBehavior = behavior;
        filter->CmdARDrone3AntiflickeringStateElectricFrequencyChangedBehavior = behavior;
        filter->CmdARDrone3AntiflickeringStateModeChangedBehavior = behavior;
        filter->CmdARDrone3GPSStateNumberOfSatelliteChangedBehavior = behavior;
        filter->CmdARDrone3GPSStateHomeTypeAvailabilityChangedBehavior = behavior;
        filter->CmdARDrone3GPSStateHomeTypeChosenChangedBehavior = behavior;
        filter->CmdARDrone3PROStateFeaturesBehavior = behavior;
    }

    return retError;
}

// Command class Piloting

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingFlatTrimBehavior = behavior;
        filter->CmdARDrone3PilotingTakeOffBehavior = behavior;
        filter->CmdARDrone3PilotingPCMDBehavior = behavior;
        filter->CmdARDrone3PilotingLandingBehavior = behavior;
        filter->CmdARDrone3PilotingEmergencyBehavior = behavior;
        filter->CmdARDrone3PilotingNavigateHomeBehavior = behavior;
        filter->CmdARDrone3PilotingAutoTakeOffModeBehavior = behavior;
        filter->CmdARDrone3PilotingMoveByBehavior = behavior;
        filter->CmdARDrone3PilotingUserTakeOffBehavior = behavior;
        filter->CmdARDrone3PilotingCircleBehavior = behavior;
    }

    return retError;
}

// Command class Animations

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AnimationsFlipBehavior = behavior;
    }

    return retError;
}

// Command class Camera

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3CameraOrientationBehavior = behavior;
    }

    return retError;
}

// Command class MediaRecord

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordPictureBehavior = behavior;
        filter->CmdARDrone3MediaRecordVideoBehavior = behavior;
        filter->CmdARDrone3MediaRecordPictureV2Behavior = behavior;
        filter->CmdARDrone3MediaRecordVideoV2Behavior = behavior;
    }

    return retError;
}

// Command class MediaRecordState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordStatePictureStateChangedBehavior = behavior;
        filter->CmdARDrone3MediaRecordStateVideoStateChangedBehavior = behavior;
        filter->CmdARDrone3MediaRecordStatePictureStateChangedV2Behavior = behavior;
        filter->CmdARDrone3MediaRecordStateVideoStateChangedV2Behavior = behavior;
    }

    return retError;
}

// Command class MediaRecordEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordEventPictureEventChangedBehavior = behavior;
        filter->CmdARDrone3MediaRecordEventVideoEventChangedBehavior = behavior;
    }

    return retError;
}

// Command class PilotingState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateFlatTrimChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateFlyingStateChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAlertStateChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateNavigateHomeStateChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStatePositionChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateSpeedChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAttitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAutoTakeOffModeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingStateAltitudeChangedBehavior = behavior;
    }

    return retError;
}

// Command class PilotingEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingEventMoveByEndBehavior = behavior;
    }

    return retError;
}

// Command class Network

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkWifiScanBehavior = behavior;
        filter->CmdARDrone3NetworkWifiAuthChannelBehavior = behavior;
    }

    return retError;
}

// Command class NetworkState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkStateWifiScanListChangedBehavior = behavior;
        filter->CmdARDrone3NetworkStateAllWifiScanChangedBehavior = behavior;
        filter->CmdARDrone3NetworkStateWifiAuthChannelListChangedBehavior = behavior;
        filter->CmdARDrone3NetworkStateAllWifiAuthChannelChangedBehavior = behavior;
    }

    return retError;
}

// Command class PilotingSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsMaxAltitudeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMaxTiltBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsAbsolutControlBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMaxDistanceBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsBankedTurnBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsMinAltitudeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsCirclingDirectionBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsCirclingRadiusBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsCirclingAltitudeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsPitchModeBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsLandingModeBehavior = behavior;
    }

    return retError;
}

// Command class PilotingSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMaxTiltChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAbsolutControlChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMaxDistanceChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateBankedTurnChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateMinAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStatePitchModeChangedBehavior = behavior;
        filter->CmdARDrone3PilotingSettingsStateLandingModeChangedBehavior = behavior;
    }

    return retError;
}

// Command class SpeedSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsMaxVerticalSpeedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsMaxRotationSpeedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsHullProtectionBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsOutdoorBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior = behavior;
    }

    return retError;
}

// Command class SpeedSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateHullProtectionChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateOutdoorChangedBehavior = behavior;
        filter->CmdARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior = behavior;
    }

    return retError;
}

// Command class NetworkSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsWifiSelectionBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsWifiSecurityBehavior = behavior;
    }

    return retError;
}

// Command class NetworkSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsStateWifiSelectionChangedBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsStateWifiSecurityChangedBehavior = behavior;
        filter->CmdARDrone3NetworkSettingsStateWifiSecurityBehavior = behavior;
    }

    return retError;
}

// Command class SettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateProductMotorVersionListChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateProductGPSVersionChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorErrorStateChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorSoftwareVersionChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorFlightsStatusChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateMotorErrorLastErrorChangedBehavior = behavior;
        filter->CmdARDrone3SettingsStateP7IDBehavior = behavior;
    }

    return retError;
}

// Command class PictureSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsPictureFormatSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsExpositionSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsSaturationSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsTimelapseSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsVideoAutorecordSelectionBehavior = behavior;
        filter->CmdARDrone3PictureSettingsVideoStabilizationModeBehavior = behavior;
    }

    return retError;
}

// Command class PictureSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStatePictureFormatChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateExpositionChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateSaturationChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateTimelapseChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateVideoAutorecordChangedBehavior = behavior;
        filter->CmdARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior = behavior;
    }

    return retError;
}

// Command class MediaStreaming

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaStreamingVideoEnableBehavior = behavior;
    }

    return retError;
}

// Command class MediaStreamingState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaStreamingStateVideoEnableChangedBehavior = behavior;
    }

    return retError;
}

// Command class GPSSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsSetHomeBehavior = behavior;
        filter->CmdARDrone3GPSSettingsResetHomeBehavior = behavior;
        filter->CmdARDrone3GPSSettingsSendControllerGPSBehavior = behavior;
        filter->CmdARDrone3GPSSettingsHomeTypeBehavior = behavior;
        filter->CmdARDrone3GPSSettingsReturnHomeDelayBehavior = behavior;
    }

    return retError;
}

// Command class GPSSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateHomeChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateResetHomeChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateGPSFixStateChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateHomeTypeChangedBehavior = behavior;
        filter->CmdARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior = behavior;
    }

    return retError;
}

// Command class CameraState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3CameraStateOrientationBehavior = behavior;
        filter->CmdARDrone3CameraStateDefaultCameraOrientationBehavior = behavior;
    }

    return retError;
}

// Command class Antiflickering

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AntiflickeringElectricFrequencyBehavior = behavior;
        filter->CmdARDrone3AntiflickeringSetModeBehavior = behavior;
    }

    return retError;
}

// Command class AntiflickeringState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AntiflickeringStateElectricFrequencyChangedBehavior = behavior;
        filter->CmdARDrone3AntiflickeringStateModeChangedBehavior = behavior;
    }

    return retError;
}

// Command class GPSState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSStateNumberOfSatelliteChangedBehavior = behavior;
        filter->CmdARDrone3GPSStateHomeTypeAvailabilityChangedBehavior = behavior;
        filter->CmdARDrone3GPSStateHomeTypeChosenChangedBehavior = behavior;
    }

    return retError;
}

// Command class PROState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PROStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PROStateFeaturesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingFlatTrimBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingFlatTrimBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingTakeOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingTakeOffBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingPCMDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingPCMDBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingLandingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingLandingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingEmergencyBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingEmergencyBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingNavigateHomeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingNavigateHomeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingAutoTakeOffModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingAutoTakeOffModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingMoveByBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingMoveByBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingUserTakeOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingUserTakeOffBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingCircleBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingCircleBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AnimationsFlipBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AnimationsFlipBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3CameraOrientationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordPictureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordPictureBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordVideoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordVideoBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordPictureV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordPictureV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordVideoV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordVideoV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkWifiScanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkWifiScanBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkWifiAuthChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkWifiAuthChannelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsMaxAltitudeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxTiltBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsMaxTiltBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsAbsolutControlBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsAbsolutControlBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMaxDistanceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsMaxDistanceBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsNoFlyOverMaxDistanceBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAccelerationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAccelerationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsBankedTurnBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsBankedTurnBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsMinAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsMinAltitudeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingDirectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsCirclingDirectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingRadiusBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsCirclingRadiusBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsCirclingAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsCirclingAltitudeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsPitchModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsPitchModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsLandingModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsLandingModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsMaxVerticalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsMaxRotationSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsHullProtectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsHullProtectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsOutdoorBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsOutdoorBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsMaxPitchRollRotationSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsWifiSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsWifiSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsWifiSecurityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsWifiSecurityBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsPictureFormatSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsPictureFormatSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsAutoWhiteBalanceSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsExpositionSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsExpositionSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsSaturationSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsSaturationSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsTimelapseSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsTimelapseSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsVideoAutorecordSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsVideoAutorecordSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsVideoStabilizationModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsVideoStabilizationModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingVideoEnableBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaStreamingVideoEnableBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsSetHomeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsSetHomeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsResetHomeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsResetHomeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsSendControllerGPSBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsSendControllerGPSBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsHomeTypeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsHomeTypeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsReturnHomeDelayBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsReturnHomeDelayBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringElectricFrequencyBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AntiflickeringElectricFrequencyBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringSetModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AntiflickeringSetModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStatePictureStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordStatePictureStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStateVideoStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordStateVideoStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStatePictureStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordStatePictureStateChangedV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordStateVideoStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordStateVideoStateChangedV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordEventPictureEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordEventPictureEventChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaRecordEventVideoEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaRecordEventVideoEventChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateFlatTrimChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateFlatTrimChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateFlyingStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateFlyingStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAlertStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateAlertStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateNavigateHomeStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateNavigateHomeStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStatePositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStatePositionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAttitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateAttitudeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAutoTakeOffModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateAutoTakeOffModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingStateAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingStateAltitudeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingEventMoveByEndBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingEventMoveByEndBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateWifiScanListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkStateWifiScanListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateAllWifiScanChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkStateAllWifiScanChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateWifiAuthChannelListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkStateWifiAuthChannelListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkStateAllWifiAuthChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkStateAllWifiAuthChannelChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateMaxAltitudeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxTiltChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateMaxTiltChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAbsolutControlChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateAbsolutControlChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMaxDistanceChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateMaxDistanceChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateBankedTurnChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateBankedTurnChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateMinAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateMinAltitudeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateCirclingDirectionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateCirclingRadiusChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateCirclingAltitudeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStatePitchModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStatePitchModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PilotingSettingsStateLandingModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PilotingSettingsStateLandingModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsStateMaxVerticalSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsStateMaxRotationSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateHullProtectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsStateHullProtectionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateOutdoorChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsStateOutdoorChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSelectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsStateWifiSelectionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSecurityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsStateWifiSecurityChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3NetworkSettingsStateWifiSecurityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3NetworkSettingsStateWifiSecurityBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateProductMotorVersionListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateProductMotorVersionListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateProductGPSVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateProductGPSVersionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorErrorStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateMotorErrorStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorSoftwareVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateMotorSoftwareVersionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorFlightsStatusChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateMotorFlightsStatusChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateMotorErrorLastErrorChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateMotorErrorLastErrorChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3SettingsStateP7IDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3SettingsStateP7IDBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStatePictureFormatChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStatePictureFormatChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStateAutoWhiteBalanceChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateExpositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStateExpositionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateSaturationChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStateSaturationChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateTimelapseChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStateTimelapseChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateVideoAutorecordChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStateVideoAutorecordChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PictureSettingsStateVideoStabilizationModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3MediaStreamingStateVideoEnableChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3MediaStreamingStateVideoEnableChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateHomeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateHomeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateResetHomeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateResetHomeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateGPSFixStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateGPSFixStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateGPSUpdateStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateHomeTypeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateHomeTypeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSSettingsStateReturnHomeDelayChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraStateOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3CameraStateOrientationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3CameraStateDefaultCameraOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3CameraStateDefaultCameraOrientationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateElectricFrequencyChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AntiflickeringStateElectricFrequencyChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3AntiflickeringStateModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3AntiflickeringStateModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateNumberOfSatelliteChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSStateNumberOfSatelliteChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateHomeTypeAvailabilityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSStateHomeTypeAvailabilityChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3GPSStateHomeTypeChosenChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3GPSStateHomeTypeChosenChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetARDrone3PROStateFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdARDrone3PROStateFeaturesBehavior = behavior;
    }

    return retError;
}


// Feature JumpingSumo

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingPCMDBehavior = behavior;
        filter->CmdJumpingSumoPilotingPostureBehavior = behavior;
        filter->CmdJumpingSumoPilotingAddCapOffsetBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpStopBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpCancelBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpLoadBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpBehavior = behavior;
        filter->CmdJumpingSumoAnimationsSimpleAnimationBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordPictureBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordVideoBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordPictureV2Behavior = behavior;
        filter->CmdJumpingSumoMediaRecordVideoV2Behavior = behavior;
        filter->CmdJumpingSumoNetworkSettingsWifiSelectionBehavior = behavior;
        filter->CmdJumpingSumoNetworkWifiScanBehavior = behavior;
        filter->CmdJumpingSumoNetworkWifiAuthChannelBehavior = behavior;
        filter->CmdJumpingSumoAudioSettingsMasterVolumeBehavior = behavior;
        filter->CmdJumpingSumoAudioSettingsThemeBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanAllScriptsMetadataBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanScriptUploadedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanScriptDeleteBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanPlayScriptBehavior = behavior;
        filter->CmdJumpingSumoSpeedSettingsOutdoorBehavior = behavior;
        filter->CmdJumpingSumoMediaStreamingVideoEnableBehavior = behavior;
        filter->CmdJumpingSumoVideoSettingsAutorecordBehavior = behavior;
        filter->CmdJumpingSumoPilotingStatePostureChangedBehavior = behavior;
        filter->CmdJumpingSumoPilotingStateAlertStateChangedBehavior = behavior;
        filter->CmdJumpingSumoPilotingStateSpeedChangedBehavior = behavior;
        filter->CmdJumpingSumoAnimationsStateJumpLoadChangedBehavior = behavior;
        filter->CmdJumpingSumoAnimationsStateJumpTypeChangedBehavior = behavior;
        filter->CmdJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior = behavior;
        filter->CmdJumpingSumoSettingsStateProductGPSVersionChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordStatePictureStateChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordStateVideoStateChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordStatePictureStateChangedV2Behavior = behavior;
        filter->CmdJumpingSumoMediaRecordStateVideoStateChangedV2Behavior = behavior;
        filter->CmdJumpingSumoMediaRecordEventPictureEventChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordEventVideoEventChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateWifiScanListChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateAllWifiScanChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateLinkQualityChangedBehavior = behavior;
        filter->CmdJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior = behavior;
        filter->CmdJumpingSumoAudioSettingsStateThemeChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateScriptUploadChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateScriptDeleteChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStatePlayScriptChangedBehavior = behavior;
        filter->CmdJumpingSumoSpeedSettingsStateOutdoorChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaStreamingStateVideoEnableChangedBehavior = behavior;
        filter->CmdJumpingSumoVideoSettingsStateAutorecordChangedBehavior = behavior;
    }

    return retError;
}

// Command class Piloting

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingPCMDBehavior = behavior;
        filter->CmdJumpingSumoPilotingPostureBehavior = behavior;
        filter->CmdJumpingSumoPilotingAddCapOffsetBehavior = behavior;
    }

    return retError;
}

// Command class PilotingState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingStatePostureChangedBehavior = behavior;
        filter->CmdJumpingSumoPilotingStateAlertStateChangedBehavior = behavior;
        filter->CmdJumpingSumoPilotingStateSpeedChangedBehavior = behavior;
    }

    return retError;
}

// Command class Animations

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsJumpStopBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpCancelBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpLoadBehavior = behavior;
        filter->CmdJumpingSumoAnimationsJumpBehavior = behavior;
        filter->CmdJumpingSumoAnimationsSimpleAnimationBehavior = behavior;
    }

    return retError;
}

// Command class AnimationsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsStateJumpLoadChangedBehavior = behavior;
        filter->CmdJumpingSumoAnimationsStateJumpTypeChangedBehavior = behavior;
        filter->CmdJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior = behavior;
    }

    return retError;
}

// Command class SettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoSettingsStateProductGPSVersionChangedBehavior = behavior;
    }

    return retError;
}

// Command class MediaRecord

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordPictureBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordVideoBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordPictureV2Behavior = behavior;
        filter->CmdJumpingSumoMediaRecordVideoV2Behavior = behavior;
    }

    return retError;
}

// Command class MediaRecordState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordStatePictureStateChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordStateVideoStateChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordStatePictureStateChangedV2Behavior = behavior;
        filter->CmdJumpingSumoMediaRecordStateVideoStateChangedV2Behavior = behavior;
    }

    return retError;
}

// Command class MediaRecordEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordEventPictureEventChangedBehavior = behavior;
        filter->CmdJumpingSumoMediaRecordEventVideoEventChangedBehavior = behavior;
    }

    return retError;
}

// Command class NetworkSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkSettingsWifiSelectionBehavior = behavior;
    }

    return retError;
}

// Command class NetworkSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior = behavior;
    }

    return retError;
}

// Command class Network

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkWifiScanBehavior = behavior;
        filter->CmdJumpingSumoNetworkWifiAuthChannelBehavior = behavior;
    }

    return retError;
}

// Command class NetworkState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkStateWifiScanListChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateAllWifiScanChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior = behavior;
        filter->CmdJumpingSumoNetworkStateLinkQualityChangedBehavior = behavior;
    }

    return retError;
}

// Command class AudioSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAudioSettingsMasterVolumeBehavior = behavior;
        filter->CmdJumpingSumoAudioSettingsThemeBehavior = behavior;
    }

    return retError;
}

// Command class AudioSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior = behavior;
        filter->CmdJumpingSumoAudioSettingsStateThemeChangedBehavior = behavior;
    }

    return retError;
}

// Command class RoadPlan

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanAllScriptsMetadataBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanScriptUploadedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanScriptDeleteBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanPlayScriptBehavior = behavior;
    }

    return retError;
}

// Command class RoadPlanState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateScriptUploadChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStateScriptDeleteChangedBehavior = behavior;
        filter->CmdJumpingSumoRoadPlanStatePlayScriptChangedBehavior = behavior;
    }

    return retError;
}

// Command class SpeedSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoSpeedSettingsOutdoorBehavior = behavior;
    }

    return retError;
}

// Command class SpeedSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoSpeedSettingsStateOutdoorChangedBehavior = behavior;
    }

    return retError;
}

// Command class MediaStreaming

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaStreamingVideoEnableBehavior = behavior;
    }

    return retError;
}

// Command class MediaStreamingState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaStreamingStateVideoEnableChangedBehavior = behavior;
    }

    return retError;
}

// Command class VideoSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoVideoSettingsAutorecordBehavior = behavior;
    }

    return retError;
}

// Command class VideoSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoVideoSettingsStateAutorecordChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingPCMDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingPCMDBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingPostureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingPostureBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingAddCapOffsetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingAddCapOffsetBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpStopBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsJumpStopBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpCancelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsJumpCancelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpLoadBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsJumpLoadBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsJumpBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsJumpBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsSimpleAnimationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsSimpleAnimationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordPictureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordPictureBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordVideoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordVideoBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordPictureV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordPictureV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordVideoV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordVideoV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsWifiSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkSettingsWifiSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkWifiScanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkWifiScanBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkWifiAuthChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkWifiAuthChannelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsMasterVolumeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAudioSettingsMasterVolumeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsThemeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAudioSettingsThemeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanAllScriptsMetadataBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanAllScriptsMetadataBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanScriptUploadedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanScriptUploadedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanScriptDeleteBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanScriptDeleteBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanPlayScriptBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanPlayScriptBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsOutdoorBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoSpeedSettingsOutdoorBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingVideoEnableBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaStreamingVideoEnableBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsAutorecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoVideoSettingsAutorecordBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStatePostureChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingStatePostureChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStateAlertStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingStateAlertStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoPilotingStateSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoPilotingStateSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpLoadChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsStateJumpLoadChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpTypeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsStateJumpTypeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAnimationsStateJumpMotorProblemChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSettingsStateProductGPSVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoSettingsStateProductGPSVersionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStatePictureStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordStatePictureStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateVideoStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordStateVideoStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStatePictureStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordStatePictureStateChangedV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordStateVideoStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordStateVideoStateChangedV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventPictureEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordEventPictureEventChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaRecordEventVideoEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaRecordEventVideoEventChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkSettingsStateWifiSelectionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateWifiScanListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkStateWifiScanListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateAllWifiScanChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkStateAllWifiScanChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkStateWifiAuthChannelListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkStateAllWifiAuthChannelChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoNetworkStateLinkQualityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoNetworkStateLinkQualityChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAudioSettingsStateMasterVolumeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoAudioSettingsStateThemeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoAudioSettingsStateThemeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanStateScriptMetadataListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanStateAllScriptsMetadataChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptUploadChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanStateScriptUploadChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStateScriptDeleteChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanStateScriptDeleteChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoRoadPlanStatePlayScriptChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoRoadPlanStatePlayScriptChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoSpeedSettingsStateOutdoorChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoSpeedSettingsStateOutdoorChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoMediaStreamingStateVideoEnableChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoMediaStreamingStateVideoEnableChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetJumpingSumoVideoSettingsStateAutorecordChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdJumpingSumoVideoSettingsStateAutorecordChangedBehavior = behavior;
    }

    return retError;
}


// Feature MiniDrone

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingFlatTrimBehavior = behavior;
        filter->CmdMiniDronePilotingTakeOffBehavior = behavior;
        filter->CmdMiniDronePilotingPCMDBehavior = behavior;
        filter->CmdMiniDronePilotingLandingBehavior = behavior;
        filter->CmdMiniDronePilotingEmergencyBehavior = behavior;
        filter->CmdMiniDronePilotingAutoTakeOffModeBehavior = behavior;
        filter->CmdMiniDroneAnimationsFlipBehavior = behavior;
        filter->CmdMiniDroneAnimationsCapBehavior = behavior;
        filter->CmdMiniDroneMediaRecordPictureBehavior = behavior;
        filter->CmdMiniDroneMediaRecordPictureV2Behavior = behavior;
        filter->CmdMiniDronePilotingSettingsMaxAltitudeBehavior = behavior;
        filter->CmdMiniDronePilotingSettingsMaxTiltBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsMaxVerticalSpeedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsMaxRotationSpeedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsWheelsBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior = behavior;
        filter->CmdMiniDroneSettingsCutOutModeBehavior = behavior;
        filter->CmdMiniDroneGPSControllerLatitudeForRunBehavior = behavior;
        filter->CmdMiniDroneGPSControllerLongitudeForRunBehavior = behavior;
        filter->CmdMiniDroneConfigurationControllerTypeBehavior = behavior;
        filter->CmdMiniDroneConfigurationControllerNameBehavior = behavior;
        filter->CmdMiniDronePilotingStateFlatTrimChangedBehavior = behavior;
        filter->CmdMiniDronePilotingStateFlyingStateChangedBehavior = behavior;
        filter->CmdMiniDronePilotingStateAlertStateChangedBehavior = behavior;
        filter->CmdMiniDronePilotingStateAutoTakeOffModeChangedBehavior = behavior;
        filter->CmdMiniDroneMediaRecordStatePictureStateChangedBehavior = behavior;
        filter->CmdMiniDroneMediaRecordStatePictureStateChangedV2Behavior = behavior;
        filter->CmdMiniDroneMediaRecordEventPictureEventChangedBehavior = behavior;
        filter->CmdMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior = behavior;
        filter->CmdMiniDronePilotingSettingsStateMaxTiltChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateWheelsChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior = behavior;
        filter->CmdMiniDroneSettingsStateProductMotorsVersionChangedBehavior = behavior;
        filter->CmdMiniDroneSettingsStateProductInertialVersionChangedBehavior = behavior;
        filter->CmdMiniDroneSettingsStateCutOutModeChangedBehavior = behavior;
        filter->CmdMiniDroneFloodControlStateFloodControlChangedBehavior = behavior;
    }

    return retError;
}

// Command class Piloting

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingFlatTrimBehavior = behavior;
        filter->CmdMiniDronePilotingTakeOffBehavior = behavior;
        filter->CmdMiniDronePilotingPCMDBehavior = behavior;
        filter->CmdMiniDronePilotingLandingBehavior = behavior;
        filter->CmdMiniDronePilotingEmergencyBehavior = behavior;
        filter->CmdMiniDronePilotingAutoTakeOffModeBehavior = behavior;
    }

    return retError;
}

// Command class PilotingState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingStateFlatTrimChangedBehavior = behavior;
        filter->CmdMiniDronePilotingStateFlyingStateChangedBehavior = behavior;
        filter->CmdMiniDronePilotingStateAlertStateChangedBehavior = behavior;
        filter->CmdMiniDronePilotingStateAutoTakeOffModeChangedBehavior = behavior;
    }

    return retError;
}

// Command class Animations

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneAnimationsFlipBehavior = behavior;
        filter->CmdMiniDroneAnimationsCapBehavior = behavior;
    }

    return retError;
}

// Command class MediaRecord

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordPictureBehavior = behavior;
        filter->CmdMiniDroneMediaRecordPictureV2Behavior = behavior;
    }

    return retError;
}

// Command class MediaRecordState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordStatePictureStateChangedBehavior = behavior;
        filter->CmdMiniDroneMediaRecordStatePictureStateChangedV2Behavior = behavior;
    }

    return retError;
}

// Command class MediaRecordEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordEventPictureEventChangedBehavior = behavior;
    }

    return retError;
}

// Command class PilotingSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingSettingsMaxAltitudeBehavior = behavior;
        filter->CmdMiniDronePilotingSettingsMaxTiltBehavior = behavior;
    }

    return retError;
}

// Command class PilotingSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior = behavior;
        filter->CmdMiniDronePilotingSettingsStateMaxTiltChangedBehavior = behavior;
    }

    return retError;
}

// Command class SpeedSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsMaxVerticalSpeedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsMaxRotationSpeedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsWheelsBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior = behavior;
    }

    return retError;
}

// Command class SpeedSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateWheelsChangedBehavior = behavior;
        filter->CmdMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior = behavior;
    }

    return retError;
}

// Command class Settings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSettingsCutOutModeBehavior = behavior;
    }

    return retError;
}

// Command class SettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSettingsStateProductMotorsVersionChangedBehavior = behavior;
        filter->CmdMiniDroneSettingsStateProductInertialVersionChangedBehavior = behavior;
        filter->CmdMiniDroneSettingsStateCutOutModeChangedBehavior = behavior;
    }

    return retError;
}

// Command class FloodControlState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneFloodControlStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneFloodControlStateFloodControlChangedBehavior = behavior;
    }

    return retError;
}

// Command class GPS

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneGPSBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneGPSControllerLatitudeForRunBehavior = behavior;
        filter->CmdMiniDroneGPSControllerLongitudeForRunBehavior = behavior;
    }

    return retError;
}

// Command class Configuration

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneConfigurationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneConfigurationControllerTypeBehavior = behavior;
        filter->CmdMiniDroneConfigurationControllerNameBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingFlatTrimBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingFlatTrimBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingTakeOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingTakeOffBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingPCMDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingPCMDBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingLandingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingLandingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingEmergencyBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingEmergencyBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingAutoTakeOffModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingAutoTakeOffModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneAnimationsFlipBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneAnimationsFlipBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneAnimationsCapBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneAnimationsCapBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordPictureBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordPictureBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordPictureV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordPictureV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsMaxAltitudeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingSettingsMaxAltitudeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsMaxTiltBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingSettingsMaxTiltBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxVerticalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsMaxVerticalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxRotationSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsMaxRotationSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsWheelsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsWheelsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsMaxHorizontalSpeedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsCutOutModeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSettingsCutOutModeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneGPSControllerLatitudeForRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneGPSControllerLatitudeForRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneGPSControllerLongitudeForRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneGPSControllerLongitudeForRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneConfigurationControllerTypeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneConfigurationControllerTypeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneConfigurationControllerNameBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneConfigurationControllerNameBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateFlatTrimChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingStateFlatTrimChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateFlyingStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingStateFlyingStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateAlertStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingStateAlertStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingStateAutoTakeOffModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingStateAutoTakeOffModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordStatePictureStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordStatePictureStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordStatePictureStateChangedV2Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordStatePictureStateChangedV2Behavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneMediaRecordEventPictureEventChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneMediaRecordEventPictureEventChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingSettingsStateMaxAltitudeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDronePilotingSettingsStateMaxTiltChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDronePilotingSettingsStateMaxTiltChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsStateMaxRotationSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateWheelsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsStateWheelsChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateProductMotorsVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSettingsStateProductMotorsVersionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateProductInertialVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSettingsStateProductInertialVersionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneSettingsStateCutOutModeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneSettingsStateCutOutModeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetMiniDroneFloodControlStateFloodControlChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdMiniDroneFloodControlStateFloodControlChangedBehavior = behavior;
    }

    return retError;
}


// Feature SkyController

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiRequestWifiListBehavior = behavior;
        filter->CmdSkyControllerWifiRequestCurrentWifiBehavior = behavior;
        filter->CmdSkyControllerWifiConnectToWifiBehavior = behavior;
        filter->CmdSkyControllerWifiForgetWifiBehavior = behavior;
        filter->CmdSkyControllerWifiWifiAuthChannelBehavior = behavior;
        filter->CmdSkyControllerDeviceRequestDeviceListBehavior = behavior;
        filter->CmdSkyControllerDeviceRequestCurrentDeviceBehavior = behavior;
        filter->CmdSkyControllerDeviceConnectToDeviceBehavior = behavior;
        filter->CmdSkyControllerSettingsAllSettingsBehavior = behavior;
        filter->CmdSkyControllerSettingsResetBehavior = behavior;
        filter->CmdSkyControllerCommonAllStatesBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsAccessPointSSIDBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsAccessPointChannelBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsWifiSelectionBehavior = behavior;
        filter->CmdSkyControllerCameraResetOrientationBehavior = behavior;
        filter->CmdSkyControllerGamepadInfosGetGamepadControlsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsSetButtonMappingBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsDefaultButtonMappingBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsSetAxisMappingBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsDefaultAxisMappingBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersGetPresetAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersSetAxisFilterBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersDefaultAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerCoPilotingSetPilotingSourceBehavior = behavior;
        filter->CmdSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior = behavior;
        filter->CmdSkyControllerWifiStateWifiListBehavior = behavior;
        filter->CmdSkyControllerWifiStateConnexionChangedBehavior = behavior;
        filter->CmdSkyControllerWifiStateWifiAuthChannelListChangedBehavior = behavior;
        filter->CmdSkyControllerWifiStateAllWifiAuthChannelChangedBehavior = behavior;
        filter->CmdSkyControllerWifiStateWifiSignalChangedBehavior = behavior;
        filter->CmdSkyControllerDeviceStateDeviceListBehavior = behavior;
        filter->CmdSkyControllerDeviceStateConnexionChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateAllSettingsChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateResetChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateProductSerialChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateProductVariantChangedBehavior = behavior;
        filter->CmdSkyControllerCommonStateAllStatesChangedBehavior = behavior;
        filter->CmdSkyControllerSkyControllerStateBatteryChangedBehavior = behavior;
        filter->CmdSkyControllerSkyControllerStateGpsFixChangedBehavior = behavior;
        filter->CmdSkyControllerSkyControllerStateGpsPositionChangedBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior = behavior;
        filter->CmdSkyControllerGamepadInfosStateGamepadControlBehavior = behavior;
        filter->CmdSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStatePresetAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior = behavior;
        filter->CmdSkyControllerCoPilotingStatePilotingSourceBehavior = behavior;
        filter->CmdSkyControllerCalibrationStateMagnetoCalibrationStateBehavior = behavior;
        filter->CmdSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior = behavior;
        filter->CmdSkyControllerButtonEventsSettingsBehavior = behavior;
    }

    return retError;
}

// Command class WifiState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiStateWifiListBehavior = behavior;
        filter->CmdSkyControllerWifiStateConnexionChangedBehavior = behavior;
        filter->CmdSkyControllerWifiStateWifiAuthChannelListChangedBehavior = behavior;
        filter->CmdSkyControllerWifiStateAllWifiAuthChannelChangedBehavior = behavior;
        filter->CmdSkyControllerWifiStateWifiSignalChangedBehavior = behavior;
    }

    return retError;
}

// Command class Wifi

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiRequestWifiListBehavior = behavior;
        filter->CmdSkyControllerWifiRequestCurrentWifiBehavior = behavior;
        filter->CmdSkyControllerWifiConnectToWifiBehavior = behavior;
        filter->CmdSkyControllerWifiForgetWifiBehavior = behavior;
        filter->CmdSkyControllerWifiWifiAuthChannelBehavior = behavior;
    }

    return retError;
}

// Command class Device

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceRequestDeviceListBehavior = behavior;
        filter->CmdSkyControllerDeviceRequestCurrentDeviceBehavior = behavior;
        filter->CmdSkyControllerDeviceConnectToDeviceBehavior = behavior;
    }

    return retError;
}

// Command class DeviceState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceStateDeviceListBehavior = behavior;
        filter->CmdSkyControllerDeviceStateConnexionChangedBehavior = behavior;
    }

    return retError;
}

// Command class Settings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsAllSettingsBehavior = behavior;
        filter->CmdSkyControllerSettingsResetBehavior = behavior;
    }

    return retError;
}

// Command class SettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsStateAllSettingsChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateResetChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateProductSerialChangedBehavior = behavior;
        filter->CmdSkyControllerSettingsStateProductVariantChangedBehavior = behavior;
    }

    return retError;
}

// Command class Common

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCommonAllStatesBehavior = behavior;
    }

    return retError;
}

// Command class CommonState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCommonStateAllStatesChangedBehavior = behavior;
    }

    return retError;
}

// Command class SkyControllerState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSkyControllerStateBatteryChangedBehavior = behavior;
        filter->CmdSkyControllerSkyControllerStateGpsFixChangedBehavior = behavior;
        filter->CmdSkyControllerSkyControllerStateGpsPositionChangedBehavior = behavior;
    }

    return retError;
}

// Command class AccessPointSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsAccessPointSSIDBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsAccessPointChannelBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsWifiSelectionBehavior = behavior;
    }

    return retError;
}

// Command class AccessPointSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior = behavior;
        filter->CmdSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior = behavior;
    }

    return retError;
}

// Command class Camera

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCameraBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCameraResetOrientationBehavior = behavior;
    }

    return retError;
}

// Command class GamepadInfos

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerGamepadInfosGetGamepadControlsBehavior = behavior;
    }

    return retError;
}

// Command class GamepadInfosState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerGamepadInfosStateGamepadControlBehavior = behavior;
        filter->CmdSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior = behavior;
    }

    return retError;
}

// Command class ButtonMappings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsSetButtonMappingBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsDefaultButtonMappingBehavior = behavior;
    }

    return retError;
}

// Command class ButtonMappingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior = behavior;
        filter->CmdSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior = behavior;
    }

    return retError;
}

// Command class AxisMappings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsSetAxisMappingBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsDefaultAxisMappingBehavior = behavior;
    }

    return retError;
}

// Command class AxisMappingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior = behavior;
        filter->CmdSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior = behavior;
    }

    return retError;
}

// Command class AxisFilters

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersGetPresetAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersSetAxisFilterBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersDefaultAxisFiltersBehavior = behavior;
    }

    return retError;
}

// Command class AxisFiltersState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStatePresetAxisFiltersBehavior = behavior;
        filter->CmdSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior = behavior;
    }

    return retError;
}

// Command class CoPiloting

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCoPilotingSetPilotingSourceBehavior = behavior;
    }

    return retError;
}

// Command class CoPilotingState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCoPilotingStatePilotingSourceBehavior = behavior;
    }

    return retError;
}

// Command class Calibration

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior = behavior;
    }

    return retError;
}

// Command class CalibrationState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCalibrationStateMagnetoCalibrationStateBehavior = behavior;
        filter->CmdSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior = behavior;
    }

    return retError;
}

// Command class ButtonEvents

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonEventsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonEventsSettingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiRequestWifiListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiRequestWifiListBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiRequestCurrentWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiRequestCurrentWifiBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiConnectToWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiConnectToWifiBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiForgetWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiForgetWifiBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiWifiAuthChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiWifiAuthChannelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceRequestDeviceListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceRequestDeviceListBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceRequestCurrentDeviceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceRequestCurrentDeviceBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceConnectToDeviceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceConnectToDeviceBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsAllSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsAllSettingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsResetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsResetBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonAllStatesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCommonAllStatesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsAccessPointSSIDBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsAccessPointSSIDBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsAccessPointChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsAccessPointChannelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsWifiSelectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsWifiSelectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCameraResetOrientationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCameraResetOrientationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosGetGamepadControlsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerGamepadInfosGetGamepadControlsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsGetCurrentButtonMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsGetAvailableButtonMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsSetButtonMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsSetButtonMappingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsDefaultButtonMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsDefaultButtonMappingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsGetCurrentAxisMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsGetAvailableAxisMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsSetAxisMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsSetAxisMappingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsDefaultAxisMappingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsDefaultAxisMappingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersGetCurrentAxisFiltersBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersGetPresetAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersGetPresetAxisFiltersBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersSetAxisFilterBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersSetAxisFilterBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersDefaultAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersDefaultAxisFiltersBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingSetPilotingSourceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCoPilotingSetPilotingSourceBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCalibrationEnableMagnetoCalibrationQualityUpdatesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiStateWifiListBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateConnexionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiStateConnexionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiAuthChannelListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiStateWifiAuthChannelListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateAllWifiAuthChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiStateAllWifiAuthChannelChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerWifiStateWifiSignalChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerWifiStateWifiSignalChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceStateDeviceListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceStateDeviceListBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerDeviceStateConnexionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerDeviceStateConnexionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateAllSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsStateAllSettingsChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateResetChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsStateResetChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateProductSerialChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsStateProductSerialChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSettingsStateProductVariantChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSettingsStateProductVariantChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCommonStateAllStatesChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCommonStateAllStatesChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateBatteryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSkyControllerStateBatteryChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateGpsFixChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSkyControllerStateGpsFixChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerSkyControllerStateGpsPositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerSkyControllerStateGpsPositionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsStateAccessPointSSIDChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsStateAccessPointChannelChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAccessPointSettingsStateWifiSelectionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateGamepadControlBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerGamepadInfosStateGamepadControlBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerGamepadInfosStateAllGamepadControlsSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsStateCurrentButtonMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsStateAllCurrentButtonMappingsSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsStateAvailableButtonMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonMappingsStateAllAvailableButtonsMappingsSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsStateCurrentAxisMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsStateAllCurrentAxisMappingsSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsStateAvailableAxisMappingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisMappingsStateAllAvailableAxisMappingsSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersStateCurrentAxisFiltersBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersStateAllCurrentFiltersSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStatePresetAxisFiltersBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersStatePresetAxisFiltersBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerAxisFiltersStateAllPresetFiltersSentBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCoPilotingStatePilotingSourceBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCoPilotingStatePilotingSourceBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationStateMagnetoCalibrationStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCalibrationStateMagnetoCalibrationStateBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerCalibrationStateMagnetoCalibrationQualityUpdatesStateBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetSkyControllerButtonEventsSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdSkyControllerButtonEventsSettingsBehavior = behavior;
    }

    return retError;
}


// Feature unknown_feature_1

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1Behavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1GeographicRunBehavior = behavior;
        filter->CmdUnknownFeature1RelativeRunBehavior = behavior;
        filter->CmdUnknownFeature1LookAtRunBehavior = behavior;
        filter->CmdUnknownFeature1SpiralAnimRunBehavior = behavior;
        filter->CmdUnknownFeature1SwingAnimRunBehavior = behavior;
        filter->CmdUnknownFeature1BoomerangAnimRunBehavior = behavior;
        filter->CmdUnknownFeature1CandleAnimRunBehavior = behavior;
        filter->CmdUnknownFeature1DollySlideAnimRunBehavior = behavior;
        filter->CmdUnknownFeature1UserFramingPositionBehavior = behavior;
        filter->CmdUnknownFeature1UserGPSDataBehavior = behavior;
        filter->CmdUnknownFeature1UserBaroDataBehavior = behavior;
        filter->CmdUnknownFeature1LynxDetectionBehavior = behavior;
        filter->CmdUnknownFeature1AvailabilityBehavior = behavior;
        filter->CmdUnknownFeature1RunBehavior = behavior;
        filter->CmdUnknownFeature1GeographicConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1RelativeConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1AnimRunBehavior = behavior;
        filter->CmdUnknownFeature1SpiralAnimConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1SwingAnimConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1BoomerangAnimConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1CandleAnimConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1DollySlideAnimConfigChangedBehavior = behavior;
        filter->CmdUnknownFeature1UserFramingPositionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1GeographicRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1GeographicRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1RelativeRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1RelativeRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1LookAtRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1LookAtRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SpiralAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1SpiralAnimRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SwingAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1SwingAnimRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1BoomerangAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1BoomerangAnimRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1CandleAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1CandleAnimRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1DollySlideAnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1DollySlideAnimRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserFramingPositionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1UserFramingPositionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserGPSDataBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1UserGPSDataBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserBaroDataBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1UserBaroDataBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1LynxDetectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1LynxDetectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1AvailabilityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1AvailabilityBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1RunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1RunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1GeographicConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1GeographicConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1RelativeConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1RelativeConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1AnimRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1AnimRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SpiralAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1SpiralAnimConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1SwingAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1SwingAnimConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1BoomerangAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1BoomerangAnimConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1CandleAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1CandleAnimConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1DollySlideAnimConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1DollySlideAnimConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetUnknownFeature1UserFramingPositionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdUnknownFeature1UserFramingPositionChangedBehavior = behavior;
    }

    return retError;
}


// Feature common

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonNetworkDisconnectBehavior = behavior;
        filter->CmdCommonSettingsAllSettingsBehavior = behavior;
        filter->CmdCommonSettingsResetBehavior = behavior;
        filter->CmdCommonSettingsProductNameBehavior = behavior;
        filter->CmdCommonSettingsCountryBehavior = behavior;
        filter->CmdCommonSettingsAutoCountryBehavior = behavior;
        filter->CmdCommonCommonAllStatesBehavior = behavior;
        filter->CmdCommonCommonCurrentDateBehavior = behavior;
        filter->CmdCommonCommonCurrentTimeBehavior = behavior;
        filter->CmdCommonCommonRebootBehavior = behavior;
        filter->CmdCommonOverHeatSwitchOffBehavior = behavior;
        filter->CmdCommonOverHeatVentilateBehavior = behavior;
        filter->CmdCommonControllerIsPilotingBehavior = behavior;
        filter->CmdCommonWifiSettingsOutdoorSettingBehavior = behavior;
        filter->CmdCommonMavlinkStartBehavior = behavior;
        filter->CmdCommonMavlinkPauseBehavior = behavior;
        filter->CmdCommonMavlinkStopBehavior = behavior;
        filter->CmdCommonCalibrationMagnetoCalibrationBehavior = behavior;
        filter->CmdCommonGPSControllerPositionForRunBehavior = behavior;
        filter->CmdCommonAudioControllerReadyForStreamingBehavior = behavior;
        filter->CmdCommonHeadlightsIntensityBehavior = behavior;
        filter->CmdCommonAnimationsStartAnimationBehavior = behavior;
        filter->CmdCommonAnimationsStopAnimationBehavior = behavior;
        filter->CmdCommonAnimationsStopAllAnimationsBehavior = behavior;
        filter->CmdCommonAccessoryConfigBehavior = behavior;
        filter->CmdCommonChargerSetMaxChargeRateBehavior = behavior;
        filter->CmdCommonNetworkEventDisconnectionBehavior = behavior;
        filter->CmdCommonSettingsStateAllSettingsChangedBehavior = behavior;
        filter->CmdCommonSettingsStateResetChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductNameChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductVersionChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductSerialHighChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductSerialLowChangedBehavior = behavior;
        filter->CmdCommonSettingsStateCountryChangedBehavior = behavior;
        filter->CmdCommonSettingsStateAutoCountryChangedBehavior = behavior;
        filter->CmdCommonCommonStateAllStatesChangedBehavior = behavior;
        filter->CmdCommonCommonStateBatteryStateChangedBehavior = behavior;
        filter->CmdCommonCommonStateMassStorageStateListChangedBehavior = behavior;
        filter->CmdCommonCommonStateMassStorageInfoStateListChangedBehavior = behavior;
        filter->CmdCommonCommonStateCurrentDateChangedBehavior = behavior;
        filter->CmdCommonCommonStateCurrentTimeChangedBehavior = behavior;
        filter->CmdCommonCommonStateMassStorageInfoRemainingListChangedBehavior = behavior;
        filter->CmdCommonCommonStateWifiSignalChangedBehavior = behavior;
        filter->CmdCommonCommonStateSensorsStatesListChangedBehavior = behavior;
        filter->CmdCommonCommonStateProductModelBehavior = behavior;
        filter->CmdCommonCommonStateCountryListKnownBehavior = behavior;
        filter->CmdCommonOverHeatStateOverHeatChangedBehavior = behavior;
        filter->CmdCommonOverHeatStateOverHeatRegulationChangedBehavior = behavior;
        filter->CmdCommonWifiSettingsStateOutdoorSettingsChangedBehavior = behavior;
        filter->CmdCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior = behavior;
        filter->CmdCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationStateChangedBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior = behavior;
        filter->CmdCommonCameraSettingsStateCameraSettingsChangedBehavior = behavior;
        filter->CmdCommonFlightPlanStateAvailabilityStateChangedBehavior = behavior;
        filter->CmdCommonFlightPlanStateComponentStateListChangedBehavior = behavior;
        filter->CmdCommonFlightPlanEventStartingErrorEventBehavior = behavior;
        filter->CmdCommonFlightPlanEventSpeedBridleEventBehavior = behavior;
        filter->CmdCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior = behavior;
        filter->CmdCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior = behavior;
        filter->CmdCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior = behavior;
        filter->CmdCommonAudioStateAudioStreamingRunningBehavior = behavior;
        filter->CmdCommonHeadlightsStateIntensityChangedBehavior = behavior;
        filter->CmdCommonAnimationsStateListBehavior = behavior;
        filter->CmdCommonAccessoryStateSupportedAccessoriesListChangedBehavior = behavior;
        filter->CmdCommonAccessoryStateAccessoryConfigChangedBehavior = behavior;
        filter->CmdCommonAccessoryStateAccessoryConfigModificationEnabledBehavior = behavior;
        filter->CmdCommonChargerStateMaxChargeRateChangedBehavior = behavior;
        filter->CmdCommonChargerStateCurrentChargeStateChangedBehavior = behavior;
        filter->CmdCommonChargerStateLastChargeRateChangedBehavior = behavior;
        filter->CmdCommonChargerStateChargingInfoBehavior = behavior;
        filter->CmdCommonRunStateRunIdChangedBehavior = behavior;
    }

    return retError;
}

// Command class Network

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonNetworkDisconnectBehavior = behavior;
    }

    return retError;
}

// Command class NetworkEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonNetworkEventDisconnectionBehavior = behavior;
    }

    return retError;
}

// Command class Settings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsAllSettingsBehavior = behavior;
        filter->CmdCommonSettingsResetBehavior = behavior;
        filter->CmdCommonSettingsProductNameBehavior = behavior;
        filter->CmdCommonSettingsCountryBehavior = behavior;
        filter->CmdCommonSettingsAutoCountryBehavior = behavior;
    }

    return retError;
}

// Command class SettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateAllSettingsChangedBehavior = behavior;
        filter->CmdCommonSettingsStateResetChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductNameChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductVersionChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductSerialHighChangedBehavior = behavior;
        filter->CmdCommonSettingsStateProductSerialLowChangedBehavior = behavior;
        filter->CmdCommonSettingsStateCountryChangedBehavior = behavior;
        filter->CmdCommonSettingsStateAutoCountryChangedBehavior = behavior;
    }

    return retError;
}

// Command class Common

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonAllStatesBehavior = behavior;
        filter->CmdCommonCommonCurrentDateBehavior = behavior;
        filter->CmdCommonCommonCurrentTimeBehavior = behavior;
        filter->CmdCommonCommonRebootBehavior = behavior;
    }

    return retError;
}

// Command class CommonState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateAllStatesChangedBehavior = behavior;
        filter->CmdCommonCommonStateBatteryStateChangedBehavior = behavior;
        filter->CmdCommonCommonStateMassStorageStateListChangedBehavior = behavior;
        filter->CmdCommonCommonStateMassStorageInfoStateListChangedBehavior = behavior;
        filter->CmdCommonCommonStateCurrentDateChangedBehavior = behavior;
        filter->CmdCommonCommonStateCurrentTimeChangedBehavior = behavior;
        filter->CmdCommonCommonStateMassStorageInfoRemainingListChangedBehavior = behavior;
        filter->CmdCommonCommonStateWifiSignalChangedBehavior = behavior;
        filter->CmdCommonCommonStateSensorsStatesListChangedBehavior = behavior;
        filter->CmdCommonCommonStateProductModelBehavior = behavior;
        filter->CmdCommonCommonStateCountryListKnownBehavior = behavior;
    }

    return retError;
}

// Command class OverHeat

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonOverHeatSwitchOffBehavior = behavior;
        filter->CmdCommonOverHeatVentilateBehavior = behavior;
    }

    return retError;
}

// Command class OverHeatState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonOverHeatStateOverHeatChangedBehavior = behavior;
        filter->CmdCommonOverHeatStateOverHeatRegulationChangedBehavior = behavior;
    }

    return retError;
}

// Command class Controller

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonControllerBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonControllerIsPilotingBehavior = behavior;
    }

    return retError;
}

// Command class WifiSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonWifiSettingsOutdoorSettingBehavior = behavior;
    }

    return retError;
}

// Command class WifiSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonWifiSettingsStateOutdoorSettingsChangedBehavior = behavior;
    }

    return retError;
}

// Command class Mavlink

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkStartBehavior = behavior;
        filter->CmdCommonMavlinkPauseBehavior = behavior;
        filter->CmdCommonMavlinkStopBehavior = behavior;
    }

    return retError;
}

// Command class MavlinkState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior = behavior;
        filter->CmdCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior = behavior;
    }

    return retError;
}

// Command class Calibration

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationMagnetoCalibrationBehavior = behavior;
    }

    return retError;
}

// Command class CalibrationState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationStateMagnetoCalibrationStateChangedBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior = behavior;
        filter->CmdCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior = behavior;
    }

    return retError;
}

// Command class CameraSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCameraSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCameraSettingsStateCameraSettingsChangedBehavior = behavior;
    }

    return retError;
}

// Command class GPS

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonGPSBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonGPSControllerPositionForRunBehavior = behavior;
    }

    return retError;
}

// Command class FlightPlanState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonFlightPlanStateAvailabilityStateChangedBehavior = behavior;
        filter->CmdCommonFlightPlanStateComponentStateListChangedBehavior = behavior;
    }

    return retError;
}

// Command class FlightPlanEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonFlightPlanEventStartingErrorEventBehavior = behavior;
        filter->CmdCommonFlightPlanEventSpeedBridleEventBehavior = behavior;
    }

    return retError;
}

// Command class ARLibsVersionsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior = behavior;
        filter->CmdCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior = behavior;
        filter->CmdCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior = behavior;
    }

    return retError;
}

// Command class Audio

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAudioControllerReadyForStreamingBehavior = behavior;
    }

    return retError;
}

// Command class AudioState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAudioStateAudioStreamingRunningBehavior = behavior;
    }

    return retError;
}

// Command class Headlights

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonHeadlightsIntensityBehavior = behavior;
    }

    return retError;
}

// Command class HeadlightsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonHeadlightsStateIntensityChangedBehavior = behavior;
    }

    return retError;
}

// Command class Animations

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAnimationsStartAnimationBehavior = behavior;
        filter->CmdCommonAnimationsStopAnimationBehavior = behavior;
        filter->CmdCommonAnimationsStopAllAnimationsBehavior = behavior;
    }

    return retError;
}

// Command class AnimationsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAnimationsStateListBehavior = behavior;
    }

    return retError;
}

// Command class Accessory

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAccessoryConfigBehavior = behavior;
    }

    return retError;
}

// Command class AccessoryState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAccessoryStateSupportedAccessoriesListChangedBehavior = behavior;
        filter->CmdCommonAccessoryStateAccessoryConfigChangedBehavior = behavior;
        filter->CmdCommonAccessoryStateAccessoryConfigModificationEnabledBehavior = behavior;
    }

    return retError;
}

// Command class Charger

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerSetMaxChargeRateBehavior = behavior;
    }

    return retError;
}

// Command class ChargerState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerStateMaxChargeRateChangedBehavior = behavior;
        filter->CmdCommonChargerStateCurrentChargeStateChangedBehavior = behavior;
        filter->CmdCommonChargerStateLastChargeRateChangedBehavior = behavior;
        filter->CmdCommonChargerStateChargingInfoBehavior = behavior;
    }

    return retError;
}

// Command class RunState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonRunStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonRunStateRunIdChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkDisconnectBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonNetworkDisconnectBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsAllSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsAllSettingsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsResetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsResetBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsProductNameBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsProductNameBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsCountryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsCountryBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsAutoCountryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsAutoCountryBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonAllStatesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonAllStatesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonCurrentDateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonCurrentDateBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonCurrentTimeBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonCurrentTimeBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonRebootBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonRebootBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatSwitchOffBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonOverHeatSwitchOffBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatVentilateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonOverHeatVentilateBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonControllerIsPilotingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonControllerIsPilotingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsOutdoorSettingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonWifiSettingsOutdoorSettingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStartBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkStartBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkPauseBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkPauseBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStopBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkStopBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationMagnetoCalibrationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationMagnetoCalibrationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonGPSControllerPositionForRunBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonGPSControllerPositionForRunBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioControllerReadyForStreamingBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAudioControllerReadyForStreamingBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsIntensityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonHeadlightsIntensityBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStartAnimationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAnimationsStartAnimationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStopAnimationBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAnimationsStopAnimationBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStopAllAnimationsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAnimationsStopAllAnimationsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryConfigBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAccessoryConfigBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerSetMaxChargeRateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerSetMaxChargeRateBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonNetworkEventDisconnectionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonNetworkEventDisconnectionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateAllSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateAllSettingsChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateResetChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateResetChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductNameChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateProductNameChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductVersionChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateProductVersionChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductSerialHighChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateProductSerialHighChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateProductSerialLowChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateProductSerialLowChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateCountryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateCountryChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonSettingsStateAutoCountryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonSettingsStateAutoCountryChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateAllStatesChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateAllStatesChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateBatteryStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateBatteryStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateMassStorageStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateMassStorageStateListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateMassStorageInfoStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateMassStorageInfoStateListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateCurrentDateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateCurrentDateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateCurrentTimeChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateCurrentTimeChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateMassStorageInfoRemainingListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateMassStorageInfoRemainingListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateWifiSignalChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateWifiSignalChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateSensorsStatesListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateSensorsStatesListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateProductModelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateProductModelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCommonStateCountryListKnownBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCommonStateCountryListKnownBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatStateOverHeatChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonOverHeatStateOverHeatChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonOverHeatStateOverHeatRegulationChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonOverHeatStateOverHeatRegulationChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonWifiSettingsStateOutdoorSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonWifiSettingsStateOutdoorSettingsChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkStateMavlinkFilePlayingStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonMavlinkStateMavlinkPlayErrorStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationStateMagnetoCalibrationStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationStateMagnetoCalibrationRequiredStateBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationStateMagnetoCalibrationAxisToCalibrateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCalibrationStateMagnetoCalibrationStartedChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonCameraSettingsStateCameraSettingsChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonCameraSettingsStateCameraSettingsChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanStateAvailabilityStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonFlightPlanStateAvailabilityStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanStateComponentStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonFlightPlanStateComponentStateListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanEventStartingErrorEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonFlightPlanEventStartingErrorEventBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonFlightPlanEventSpeedBridleEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonFlightPlanEventSpeedBridleEventBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonARLibsVersionsStateControllerLibARCommandsVersionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonARLibsVersionsStateSkyControllerLibARCommandsVersionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonARLibsVersionsStateDeviceLibARCommandsVersionBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAudioStateAudioStreamingRunningBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAudioStateAudioStreamingRunningBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonHeadlightsStateIntensityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonHeadlightsStateIntensityChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAnimationsStateListBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAnimationsStateListBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateSupportedAccessoriesListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAccessoryStateSupportedAccessoriesListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateAccessoryConfigChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAccessoryStateAccessoryConfigChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonAccessoryStateAccessoryConfigModificationEnabledBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonAccessoryStateAccessoryConfigModificationEnabledBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateMaxChargeRateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerStateMaxChargeRateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateCurrentChargeStateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerStateCurrentChargeStateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateLastChargeRateChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerStateLastChargeRateChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonChargerStateChargingInfoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonChargerStateChargingInfoBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonRunStateRunIdChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonRunStateRunIdChangedBehavior = behavior;
    }

    return retError;
}


// Feature commonDebug

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsSendPacketBehavior = behavior;
        filter->CmdCommonDebugStatsStartSendingPacketFromDroneBehavior = behavior;
        filter->CmdCommonDebugStatsStopSendingPacketFromDroneBehavior = behavior;
        filter->CmdCommonDebugDebugSettingsGetAllBehavior = behavior;
        filter->CmdCommonDebugDebugSettingsSetBehavior = behavior;
        filter->CmdCommonDebugStatsEventSendPacketBehavior = behavior;
        filter->CmdCommonDebugDebugSettingsStateInfoBehavior = behavior;
        filter->CmdCommonDebugDebugSettingsStateListChangedBehavior = behavior;
    }

    return retError;
}

// Command class Stats

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsSendPacketBehavior = behavior;
        filter->CmdCommonDebugStatsStartSendingPacketFromDroneBehavior = behavior;
        filter->CmdCommonDebugStatsStopSendingPacketFromDroneBehavior = behavior;
    }

    return retError;
}

// Command class StatsEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsEventSendPacketBehavior = behavior;
    }

    return retError;
}

// Command class DebugSettings

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugDebugSettingsGetAllBehavior = behavior;
        filter->CmdCommonDebugDebugSettingsSetBehavior = behavior;
    }

    return retError;
}

// Command class DebugSettingsState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugDebugSettingsStateInfoBehavior = behavior;
        filter->CmdCommonDebugDebugSettingsStateListChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsSendPacketBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsSendPacketBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsStartSendingPacketFromDroneBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsStartSendingPacketFromDroneBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsStopSendingPacketFromDroneBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsStopSendingPacketFromDroneBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsGetAllBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugDebugSettingsGetAllBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsSetBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugDebugSettingsSetBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugStatsEventSendPacketBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugStatsEventSendPacketBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateInfoBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugDebugSettingsStateInfoBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetCommonDebugDebugSettingsStateListChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdCommonDebugDebugSettingsStateListChangedBehavior = behavior;
    }

    return retError;
}


// Feature pro

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProBoughtFeaturesBehavior = behavior;
        filter->CmdProProResponseBehavior = behavior;
        filter->CmdProProActivateFeaturesBehavior = behavior;
        filter->CmdProProStateSupportedFeaturesBehavior = behavior;
        filter->CmdProProStateFeaturesActivatedBehavior = behavior;
        filter->CmdProProEventChallengeEventBehavior = behavior;
    }

    return retError;
}

// Command class Pro

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProBoughtFeaturesBehavior = behavior;
        filter->CmdProProResponseBehavior = behavior;
        filter->CmdProProActivateFeaturesBehavior = behavior;
    }

    return retError;
}

// Command class ProState

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProStateBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProStateSupportedFeaturesBehavior = behavior;
        filter->CmdProProStateFeaturesActivatedBehavior = behavior;
    }

    return retError;
}

// Command class ProEvent

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProEventChallengeEventBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProBoughtFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProBoughtFeaturesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProResponseBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProResponseBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProActivateFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProActivateFeaturesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProStateSupportedFeaturesBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProStateSupportedFeaturesBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProStateFeaturesActivatedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProStateFeaturesActivatedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetProProEventChallengeEventBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdProProEventChallengeEventBehavior = behavior;
    }

    return retError;
}


// Feature wifi

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;

    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiScanBehavior = behavior;
        filter->CmdWifiUpdateAuthorizedChannelsBehavior = behavior;
        filter->CmdWifiSetApChannelBehavior = behavior;
        filter->CmdWifiSetSecurityBehavior = behavior;
        filter->CmdWifiSetCountryBehavior = behavior;
        filter->CmdWifiSetEnvironementBehavior = behavior;
        filter->CmdWifiScannedItemBehavior = behavior;
        filter->CmdWifiAuthorizedChannelBehavior = behavior;
        filter->CmdWifiApChannelChangedBehavior = behavior;
        filter->CmdWifiSecurityChangedBehavior = behavior;
        filter->CmdWifiCountryChangedBehavior = behavior;
        filter->CmdWifiEnvironementChangedBehavior = behavior;
        filter->CmdWifiRssiChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiScanBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiScanBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiUpdateAuthorizedChannelsBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiUpdateAuthorizedChannelsBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetApChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiSetApChannelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetSecurityBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiSetSecurityBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetCountryBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiSetCountryBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSetEnvironementBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiSetEnvironementBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiScannedItemBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiScannedItemBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiAuthorizedChannelBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiAuthorizedChannelBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiApChannelChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiApChannelChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiSecurityChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiSecurityChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiCountryChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiCountryChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiEnvironementChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiEnvironementChangedBehavior = behavior;
    }

    return retError;
}

eARCOMMANDS_FILTER_ERROR ARCOMMANDS_Filter_SetWifiRssiChangedBehavior (ARCOMMANDS_Filter_t *filter, eARCOMMANDS_FILTER_STATUS behavior)
{
    eARCOMMANDS_FILTER_ERROR retError = ARCOMMANDS_FILTER_OK;
    if (filter == NULL)
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_FILTER;
    } // No else : Args check

    if ((behavior != ARCOMMANDS_FILTER_STATUS_ALLOWED) &&
        (behavior != ARCOMMANDS_FILTER_STATUS_BLOCKED))
    {
        retError = ARCOMMANDS_FILTER_ERROR_BAD_STATUS;
    } // No else : Arg check

    if (retError == ARCOMMANDS_FILTER_OK)
    {
        filter->CmdWifiRssiChangedBehavior = behavior;
    }

    return retError;
}


// END GENERATED CODE
