/**********************************************************
 *            AUTOGENERATED FILE                          *
 *             DO NOT MODIFY IT                           *
 *                                                        *
 * To add new commands :                                  *
 *  - Modify ../Xml/commands.xml file                     *
 *  - Re-run generateFeatureControllers.py script         *
 *                                                        *
 **********************************************************/

/**
* @file ARCONTROLLER_Feature.c
* @brief Feature controller allow to send command related of a Feature.
*/

#include <stdio.h>
#include <libARSAL/ARSAL_Mutex.h>
#include <libARCommands/ARCommands.h>
#include <libARController/ARCONTROLLER_Network.h>
#include <libARController/ARCONTROLLER_Feature.h>

#include "ARCONTROLLER_Feature.h"

#define ARCONTROLLER_FEATURE_TAG "ARCONTROLLER_Feature"

void ARCONTROLLER_Feature_DeleteCommandsDictionary (ARCONTROLLER_DICTIONARY_COMMANDS_t **dictionary)
{
    // -- Delete a commands dictionary --
    
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdTmp = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *dictElement = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *dictTmp = NULL;
    
    if (dictionary != NULL)
    {
        if ((*dictionary) != NULL)
        {
            // Free the hash table contents
            HASH_ITER(hh, (*dictionary), dictCmdElement, dictCmdTmp)
            {
                // Free the hash table contents
                HASH_ITER(hh, dictCmdElement->elements, dictElement, dictTmp)
                {
                    // for each element
                    
                    if (dictElement->arguments != NULL)
                    {
                        // delete all arguments
                        ARCONTROLLER_Feature_DeleteArgumentsDictionary (&(dictElement->arguments));
                    }
                    
                    if (dictElement->key != NULL)
                    {
                        // free the key of the element
                        free (dictElement->key);
                        dictElement->key = NULL;
                    }
                    
                    HASH_DEL (dictCmdElement->elements, dictElement);
                    free (dictElement);
                    dictElement = NULL;
                }
                
                HASH_DEL ((*dictionary), dictCmdElement);
                free (dictCmdElement);
                dictCmdElement = NULL;
            }
            
            free (*dictionary);
            (*dictionary) = NULL;
        }
    }
}

ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_Feature_NewCommandsElement (int commandKey, eARCONTROLLER_ERROR *error)
{
    // -- New Commands Element --
    
    //local declarations
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_COMMANDS_t));
    
    if (dictCmdElement != NULL)
    {
        dictCmdElement->command = commandKey;
        dictCmdElement->elements = NULL;
    }
    else
    {
        localError = ARCONTROLLER_ERROR_ALLOC;
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return dictCmdElement;
}

void ARCONTROLLER_Feature_DeleteCommandsElement (ARCONTROLLER_DICTIONARY_COMMANDS_t **dictCmdElement)
{
    // -- Delete a commands Element --
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *dictElement = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *dictTmp = NULL;
    
    if (dictCmdElement != NULL)
    {
        if ((*dictCmdElement) != NULL)
        {
            // Free the hash table contents
            HASH_ITER(hh, (*dictCmdElement)->elements, dictElement, dictTmp)
            {
                // for each element
                
                HASH_DEL ((*dictCmdElement)->elements, dictElement);
                ARCONTROLLER_Feature_DeleteElement (&dictElement);
            }
            
            free (*dictCmdElement);
            (*dictCmdElement) = NULL;
        }
    }
}

void ARCONTROLLER_Feature_DeleteElement (ARCONTROLLER_DICTIONARY_ELEMENT_t **element)
{
    // -- Delete an element --
    
    if (element != NULL)
    {
        if ((*element) != NULL)
        {
            if ((*element)->arguments != NULL)
            {
                // delete all arguments
                ARCONTROLLER_Feature_DeleteArgumentsDictionary (&((*element)->arguments));
            }
            
            if ((*element)->key != NULL)
            {
                // free the key of the element
                free ((*element)->key);
                (*element)->key = NULL;
            }
            
            free (*element);
            (*element) = NULL;
        }
    }
}

void ARCONTROLLER_Feature_DeleteArgumentsDictionary (ARCONTROLLER_DICTIONARY_ARG_t **dictionary)
{
    // -- Delete arguments dictionary --
    
    ARCONTROLLER_DICTIONARY_ARG_t *dictElement = NULL;
    ARCONTROLLER_DICTIONARY_ARG_t *dictTmp = NULL;
    
    if (dictionary != NULL)
    {
        if ((*dictionary) != NULL)
        {
            // Free the hash table contents
            HASH_ITER(hh, (*dictionary), dictElement, dictTmp)
            {
                /* for each element of the arguments dictionary */
                if ((dictElement->valueType == ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING) && (dictElement->value.String != NULL))
                {
                    free (dictElement->value.String);
                    dictElement->value.String = NULL;
                }
                
                HASH_DEL((*dictionary), dictElement);
                free(dictElement);
                dictElement = NULL;
            }
            
            free (*dictionary);
            (*dictionary) = NULL;
        }
    }
}

void ARCONTROLLER_Feature_AddElement (ARCONTROLLER_DICTIONARY_ELEMENT_t **elementDict, ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement)
{
    // -- Set new element in CommandElements --
    ARCONTROLLER_DICTIONARY_ELEMENT_t *oldElement = NULL;
    
    // Find if the element already exist
    HASH_FIND_STR ((*elementDict), newElement->key, oldElement);
    if (oldElement != NULL)
    {
        HASH_REPLACE_STR ((*elementDict), key, newElement, oldElement);
        
        ARCONTROLLER_Feature_DeleteArgumentsDictionary (&(oldElement->arguments));
        free (oldElement);
        oldElement = NULL;
    }
    else
    {
        HASH_ADD_KEYPTR (hh, (*elementDict), newElement->key, strlen(newElement->key), newElement);
    }
    
}

/*******************************
 * --- FEATURE generic --- 
 ******************************/

/*************************
 * Private header
 *************************/

/*************************
 * Implementation
 *************************/

ARCONTROLLER_FEATURE_Generic_t *ARCONTROLLER_FEATURE_Generic_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error)
{
    // -- Create a new Feature Controller --
    
    //local declarations
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
   ARCONTROLLER_FEATURE_Generic_t *featureController =  NULL;
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller
        featureController = malloc (sizeof (ARCONTROLLER_FEATURE_Generic_t));
        if (featureController != NULL)
        {
            featureController->sendDefault = ARCONTROLLER_FEATURE_Generic_SendDefault;
            
            featureController->privatePart = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller private part
        featureController->privatePart = malloc (sizeof (ARCONTROLLER_FEATURE_Generic_Private_t));
        if (featureController->privatePart != NULL)
        {
            featureController->privatePart->networkController = networkController;
            featureController->privatePart->dictionary = NULL;
            featureController->privatePart->commandCallbacks = NULL;
            // Create the mutex 
            if (ARSAL_Mutex_Init (&(featureController->privatePart->mutex)) != 0)
            {
                localError = ARCONTROLLER_ERROR_INIT_MUTEX;
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        localError = ARCONTROLLER_FEATURE_Generic_RegisterARCommands (featureController);
    }
    // No else: skipped by an error 
    
    // delete the feature Controller if an error occurred
    if (localError != ARCONTROLLER_OK)
    {
        ARCONTROLLER_FEATURE_Generic_Delete (&featureController);
    }
    // No else: skipped no error 
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return featureController;
}

void ARCONTROLLER_FEATURE_Generic_Delete (ARCONTROLLER_FEATURE_Generic_t **feature)
{
    // -- Delete the generic feature Controller --
    
    if (feature != NULL)
    {
        if ((*feature) != NULL)
        {
            ARCONTROLLER_FEATURE_Generic_UnregisterARCommands ((*feature));
            
            if ((*feature)->privatePart != NULL)
            {
                ARSAL_Mutex_Destroy (&((*feature)->privatePart->mutex));
                
                if ((*feature)->privatePart->dictionary != NULL)
                {
                    ARCONTROLLER_Feature_DeleteCommandsDictionary (&((*feature)->privatePart->dictionary));
                }
                
                if ((*feature)->privatePart->commandCallbacks != NULL)
                {
                    // Free the hash table contents the command callback
                    ARCONTROLLER_Dictionary_DeleteDictionary (&((*feature)->privatePart->commandCallbacks));
                }
                
                free ((*feature)->privatePart);
                (*feature)->privatePart = NULL;
            }
            
            free (*feature);
            (*feature) = NULL;
        }
    }
}

ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_Generic_GetDictionary (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Get the dictionary of the generic Feature Controller --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictionary = NULL;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        dictionary = feature->privatePart->dictionary;
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return dictionary;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_AddCallback (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Add a callback to use when a command in project <code>Generic</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_AddDictionaryElement (&(feature->privatePart->commandCallbacks), commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_RemoveCallback (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Remove a callback to use when a command in project <code>Generic</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_RemoveDictionaryElement (feature->privatePart->commandCallbacks, commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_RegisterARCommands (ARCONTROLLER_FEATURE_Generic_t *feature)
{
    // -- Register the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_UnregisterARCommands (ARCONTROLLER_FEATURE_Generic_t *feature)
{
    // -- Unregister the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_SendDefault (ARCONTROLLER_FEATURE_Generic_t *feature)
{
    // -- Send a command <code>Default</code> in project <code>Generic</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Default command
        cmdError = ARCOMMANDS_Generator_GenerateGenericDefault(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_Generic_SetNetworkController (ARCONTROLLER_FEATURE_Generic_t *feature, ARCONTROLLER_Network_t *networkController)
{
    // -- Set a NetworkController to use to send commands. --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->networkController = networkController;
    }
    
    return error;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_Generic_GetCommandElements (ARCONTROLLER_FEATURE_Generic_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error)
{
    // -- Get Command Arguments --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *commandDic = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *elements = NULL;
    
    // Check parameters
    if ((feature == NULL) ||
        (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        // Find elements
        HASH_FIND_INT (feature->privatePart->dictionary, &(commandKey), commandDic);
        if (commandDic != NULL)
        {
            elements = commandDic->elements;
        }
        // NO Else ; Command not found 
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (elements == NULL)
        {
            localError = ARCONTROLLER_ERROR_NO_ELEMENT;
        }
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return elements;
}

/************************
 * Private Implementation
 *************************/
/*******************************
 * --- FEATURE ARDrone3 --- 
 ******************************/

/*************************
 * Private header
 *************************/

/*************************
 * Implementation
 *************************/

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_mediarecordstate_picturestatechanged_state";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID = "arcontroller_dictionary_key_ardrone3_mediarecordstate_picturestatechanged_mass_storage_id";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_mediarecordstate_videostatechanged_state";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_MASS_STORAGE_ID = "arcontroller_dictionary_key_ardrone3_mediarecordstate_videostatechanged_mass_storage_id";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE = "arcontroller_dictionary_key_ardrone3_mediarecordstate_picturestatechangedv2_state";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR = "arcontroller_dictionary_key_ardrone3_mediarecordstate_picturestatechangedv2_error";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE = "arcontroller_dictionary_key_ardrone3_mediarecordstate_videostatechangedv2_state";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR = "arcontroller_dictionary_key_ardrone3_mediarecordstate_videostatechangedv2_error";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT = "arcontroller_dictionary_key_ardrone3_mediarecordevent_pictureeventchanged_event";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR = "arcontroller_dictionary_key_ardrone3_mediarecordevent_pictureeventchanged_error";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT = "arcontroller_dictionary_key_ardrone3_mediarecordevent_videoeventchanged_event";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR = "arcontroller_dictionary_key_ardrone3_mediarecordevent_videoeventchanged_error";


const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_pilotingstate_flyingstatechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_pilotingstate_alertstatechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_pilotingstate_navigatehomestatechanged_state";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON = "arcontroller_dictionary_key_ardrone3_pilotingstate_navigatehomestatechanged_reason";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_LATITUDE = "arcontroller_dictionary_key_ardrone3_pilotingstate_positionchanged_latitude";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_LONGITUDE = "arcontroller_dictionary_key_ardrone3_pilotingstate_positionchanged_longitude";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_ALTITUDE = "arcontroller_dictionary_key_ardrone3_pilotingstate_positionchanged_altitude";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDX = "arcontroller_dictionary_key_ardrone3_pilotingstate_speedchanged_speedx";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDY = "arcontroller_dictionary_key_ardrone3_pilotingstate_speedchanged_speedy";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDZ = "arcontroller_dictionary_key_ardrone3_pilotingstate_speedchanged_speedz";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_ROLL = "arcontroller_dictionary_key_ardrone3_pilotingstate_attitudechanged_roll";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_PITCH = "arcontroller_dictionary_key_ardrone3_pilotingstate_attitudechanged_pitch";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_YAW = "arcontroller_dictionary_key_ardrone3_pilotingstate_attitudechanged_yaw";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_pilotingstate_autotakeoffmodechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED_ALTITUDE = "arcontroller_dictionary_key_ardrone3_pilotingstate_altitudechanged_altitude";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DX = "arcontroller_dictionary_key_ardrone3_pilotingevent_movebyend_dx";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DY = "arcontroller_dictionary_key_ardrone3_pilotingevent_movebyend_dy";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DZ = "arcontroller_dictionary_key_ardrone3_pilotingevent_movebyend_dz";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DPSI = "arcontroller_dictionary_key_ardrone3_pilotingevent_movebyend_dpsi";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR = "arcontroller_dictionary_key_ardrone3_pilotingevent_movebyend_error";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_SSID = "arcontroller_dictionary_key_ardrone3_networkstate_wifiscanlistchanged_ssid";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_RSSI = "arcontroller_dictionary_key_ardrone3_networkstate_wifiscanlistchanged_rssi";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND = "arcontroller_dictionary_key_ardrone3_networkstate_wifiscanlistchanged_band";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_CHANNEL = "arcontroller_dictionary_key_ardrone3_networkstate_wifiscanlistchanged_channel";


const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND = "arcontroller_dictionary_key_ardrone3_networkstate_wifiauthchannellistchanged_band";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL = "arcontroller_dictionary_key_ardrone3_networkstate_wifiauthchannellistchanged_channel";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT = "arcontroller_dictionary_key_ardrone3_networkstate_wifiauthchannellistchanged_in_or_out";


const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxaltitudechanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MIN = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxaltitudechanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MAX = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxaltitudechanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxtiltchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxtiltchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxtiltchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED_ON = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_absolutcontrolchanged_on";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxdistancechanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_MIN = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxdistancechanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_MAX = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_maxdistancechanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED_SHOULDNOTFLYOVER = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_noflyovermaxdistancechanged_shouldnotflyover";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_autonomousflightmaxhorizontalspeed_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_autonomousflightmaxverticalspeed_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_autonomousflightmaxhorizontalacceleration_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_autonomousflightmaxverticalacceleration_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_autonomousflightmaxrotationspeed_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED_STATE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_bankedturnchanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_minaltitudechanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_MIN = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_minaltitudechanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_MAX = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_minaltitudechanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingdirectionchanged_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingradiuschanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingradiuschanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingradiuschanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingaltitudechanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_MIN = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingaltitudechanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_MAX = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_circlingaltitudechanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_pitchmodechanged_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE = "arcontroller_dictionary_key_ardrone3_pilotingsettingsstate_landingmodechanged_value";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxverticalspeedchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxverticalspeedchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxverticalspeedchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxrotationspeedchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxrotationspeedchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxrotationspeedchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED_PRESENT = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_hullprotectionchanged_present";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED_OUTDOOR = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_outdoorchanged_outdoor";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_CURRENT = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxpitchrollrotationspeedchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxpitchrollrotationspeedchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_speedsettingsstate_maxpitchrollrotationspeedchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifiselectionchanged_type";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifiselectionchanged_band";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifiselectionchanged_channel";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifisecuritychanged_type";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifisecurity_type";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEY = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifisecurity_key";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE = "arcontroller_dictionary_key_ardrone3_networksettingsstate_wifisecurity_keytype";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_MOTOR_NUMBER = "arcontroller_dictionary_key_ardrone3_settingsstate_productmotorversionlistchanged_motor_number";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_settingsstate_productmotorversionlistchanged_type";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_SOFTWARE = "arcontroller_dictionary_key_ardrone3_settingsstate_productmotorversionlistchanged_software";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_HARDWARE = "arcontroller_dictionary_key_ardrone3_settingsstate_productmotorversionlistchanged_hardware";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_SOFTWARE = "arcontroller_dictionary_key_ardrone3_settingsstate_productgpsversionchanged_software";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_HARDWARE = "arcontroller_dictionary_key_ardrone3_settingsstate_productgpsversionchanged_hardware";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORIDS = "arcontroller_dictionary_key_ardrone3_settingsstate_motorerrorstatechanged_motorids";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR = "arcontroller_dictionary_key_ardrone3_settingsstate_motorerrorstatechanged_motorerror";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED_VERSION = "arcontroller_dictionary_key_ardrone3_settingsstate_motorsoftwareversionchanged_version";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_NBFLIGHTS = "arcontroller_dictionary_key_ardrone3_settingsstate_motorflightsstatuschanged_nbflights";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_LASTFLIGHTDURATION = "arcontroller_dictionary_key_ardrone3_settingsstate_motorflightsstatuschanged_lastflightduration";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_TOTALFLIGHTDURATION = "arcontroller_dictionary_key_ardrone3_settingsstate_motorflightsstatuschanged_totalflightduration";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR = "arcontroller_dictionary_key_ardrone3_settingsstate_motorerrorlasterrorchanged_motorerror";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID_SERIALID = "arcontroller_dictionary_key_ardrone3_settingsstate_p7id_serialid";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_pictureformatchanged_type";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_autowhitebalancechanged_type";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_VALUE = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_expositionchanged_value";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_expositionchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_expositionchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_VALUE = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_saturationchanged_value";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_MIN = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_saturationchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_MAX = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_saturationchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_ENABLED = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_timelapsechanged_enabled";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_INTERVAL = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_timelapsechanged_interval";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_MININTERVAL = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_timelapsechanged_mininterval";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_MAXINTERVAL = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_timelapsechanged_maxinterval";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED_ENABLED = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_videoautorecordchanged_enabled";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED_MASS_STORAGE_ID = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_videoautorecordchanged_mass_storage_id";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE = "arcontroller_dictionary_key_ardrone3_picturesettingsstate_videostabilizationmodechanged_mode";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED = "arcontroller_dictionary_key_ardrone3_mediastreamingstate_videoenablechanged_enabled";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_LATITUDE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_homechanged_latitude";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_LONGITUDE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_homechanged_longitude";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_ALTITUDE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_homechanged_altitude";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_LATITUDE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_resethomechanged_latitude";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_LONGITUDE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_resethomechanged_longitude";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_ALTITUDE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_resethomechanged_altitude";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED_FIXED = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_gpsfixstatechanged_fixed";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_gpsupdatestatechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_hometypechanged_type";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED_DELAY = "arcontroller_dictionary_key_ardrone3_gpssettingsstate_returnhomedelaychanged_delay";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION_TILT = "arcontroller_dictionary_key_ardrone3_camerastate_orientation_tilt";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION_PAN = "arcontroller_dictionary_key_ardrone3_camerastate_orientation_pan";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION_TILT = "arcontroller_dictionary_key_ardrone3_camerastate_defaultcameraorientation_tilt";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION_PAN = "arcontroller_dictionary_key_ardrone3_camerastate_defaultcameraorientation_pan";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY = "arcontroller_dictionary_key_ardrone3_antiflickeringstate_electricfrequencychanged_frequency";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE = "arcontroller_dictionary_key_ardrone3_antiflickeringstate_modechanged_mode";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED_NUMBEROFSATELLITE = "arcontroller_dictionary_key_ardrone3_gpsstate_numberofsatellitechanged_numberofsatellite";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_gpsstate_hometypeavailabilitychanged_type";
const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_AVAILABLE = "arcontroller_dictionary_key_ardrone3_gpsstate_hometypeavailabilitychanged_available";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE = "arcontroller_dictionary_key_ardrone3_gpsstate_hometypechosenchanged_type";

const char *ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES_FEATURES = "arcontroller_dictionary_key_ardrone3_prostate_features_features";

ARCONTROLLER_FEATURE_ARDrone3_t *ARCONTROLLER_FEATURE_ARDrone3_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error)
{
    // -- Create a new Feature Controller --
    
    //local declarations
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
   ARCONTROLLER_FEATURE_ARDrone3_t *featureController =  NULL;
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller
        featureController = malloc (sizeof (ARCONTROLLER_FEATURE_ARDrone3_t));
        if (featureController != NULL)
        {
            featureController->sendPilotingFlatTrim = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingFlatTrim;
            featureController->sendPilotingTakeOff = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingTakeOff;
            featureController->sendPilotingPCMD = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingPCMD;
            featureController->setPilotingPCMD = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMD;
            featureController->setPilotingPCMDFlag = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDFlag;
            featureController->setPilotingPCMDRoll = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDRoll;
            featureController->setPilotingPCMDPitch = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDPitch;
            featureController->setPilotingPCMDYaw = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDYaw;
            featureController->setPilotingPCMDGaz = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDGaz;
            featureController->setPilotingPCMDTimestampAndSeqNum = ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDTimestampAndSeqNum;
            featureController->sendPilotingLanding = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingLanding;
            featureController->sendPilotingEmergency = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingEmergency;
            featureController->sendPilotingNavigateHome = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingNavigateHome;
            featureController->sendPilotingAutoTakeOffMode = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingAutoTakeOffMode;
            featureController->sendPilotingMoveBy = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingMoveBy;
            featureController->sendPilotingUserTakeOff = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingUserTakeOff;
            featureController->sendPilotingCircle = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingCircle;
            featureController->sendAnimationsFlip = ARCONTROLLER_FEATURE_ARDrone3_SendAnimationsFlip;
            featureController->sendCameraOrientation = ARCONTROLLER_FEATURE_ARDrone3_SendCameraOrientation;
            featureController->sendMediaRecordPicture = ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPicture;
            featureController->sendMediaRecordVideo = ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideo;
            featureController->sendMediaRecordPictureV2 = ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPictureV2;
            featureController->sendMediaRecordVideoV2 = ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideoV2;
            featureController->sendNetworkWifiScan = ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiScan;
            featureController->sendNetworkWifiAuthChannel = ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiAuthChannel;
            featureController->sendPilotingSettingsMaxAltitude = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxAltitude;
            featureController->sendPilotingSettingsMaxTilt = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxTilt;
            featureController->sendPilotingSettingsAbsolutControl = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsAbsolutControl;
            featureController->sendPilotingSettingsMaxDistance = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxDistance;
            featureController->sendPilotingSettingsNoFlyOverMaxDistance = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsNoFlyOverMaxDistance;
            featureController->sendPilotingSettingsSetAutonomousFlightMaxHorizontalSpeed = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalSpeed;
            featureController->sendPilotingSettingsSetAutonomousFlightMaxVerticalSpeed = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalSpeed;
            featureController->sendPilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration;
            featureController->sendPilotingSettingsSetAutonomousFlightMaxVerticalAcceleration = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalAcceleration;
            featureController->sendPilotingSettingsSetAutonomousFlightMaxRotationSpeed = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxRotationSpeed;
            featureController->sendPilotingSettingsBankedTurn = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsBankedTurn;
            featureController->sendPilotingSettingsMinAltitude = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMinAltitude;
            featureController->sendPilotingSettingsCirclingDirection = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingDirection;
            featureController->sendPilotingSettingsCirclingRadius = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingRadius;
            featureController->sendPilotingSettingsCirclingAltitude = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingAltitude;
            featureController->sendPilotingSettingsPitchMode = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsPitchMode;
            featureController->sendPilotingSettingsLandingMode = ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsLandingMode;
            featureController->sendSpeedSettingsMaxVerticalSpeed = ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxVerticalSpeed;
            featureController->sendSpeedSettingsMaxRotationSpeed = ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxRotationSpeed;
            featureController->sendSpeedSettingsHullProtection = ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsHullProtection;
            featureController->sendSpeedSettingsOutdoor = ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsOutdoor;
            featureController->sendSpeedSettingsMaxPitchRollRotationSpeed = ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxPitchRollRotationSpeed;
            featureController->sendNetworkSettingsWifiSelection = ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSelection;
            featureController->sendNetworkSettingsWifiSecurity = ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSecurity;
            featureController->sendPictureSettingsPictureFormatSelection = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsPictureFormatSelection;
            featureController->sendPictureSettingsAutoWhiteBalanceSelection = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsAutoWhiteBalanceSelection;
            featureController->sendPictureSettingsExpositionSelection = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsExpositionSelection;
            featureController->sendPictureSettingsSaturationSelection = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsSaturationSelection;
            featureController->sendPictureSettingsTimelapseSelection = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsTimelapseSelection;
            featureController->sendPictureSettingsVideoAutorecordSelection = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoAutorecordSelection;
            featureController->sendPictureSettingsVideoStabilizationMode = ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoStabilizationMode;
            featureController->sendMediaStreamingVideoEnable = ARCONTROLLER_FEATURE_ARDrone3_SendMediaStreamingVideoEnable;
            featureController->sendGPSSettingsSetHome = ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSetHome;
            featureController->sendGPSSettingsResetHome = ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsResetHome;
            featureController->sendGPSSettingsSendControllerGPS = ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSendControllerGPS;
            featureController->sendGPSSettingsHomeType = ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsHomeType;
            featureController->sendGPSSettingsReturnHomeDelay = ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsReturnHomeDelay;
            featureController->sendAntiflickeringElectricFrequency = ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringElectricFrequency;
            featureController->sendAntiflickeringSetMode = ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringSetMode;
            
            featureController->privatePart = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller private part
        featureController->privatePart = malloc (sizeof (ARCONTROLLER_FEATURE_ARDrone3_Private_t));
        if (featureController->privatePart != NULL)
        {
            featureController->privatePart->networkController = networkController;
            featureController->privatePart->dictionary = NULL;
            featureController->privatePart->commandCallbacks = NULL;
            featureController->privatePart->PilotingPCMDParameters = NULL;
            // Create the mutex 
            if (ARSAL_Mutex_Init (&(featureController->privatePart->mutex)) != 0)
            {
                localError = ARCONTROLLER_ERROR_INIT_MUTEX;
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        featureController->privatePart->PilotingPCMDParameters = calloc (1, sizeof (ARCONTROLLER_ARDrone3_PilotingPCMDParameters_t));
        if (featureController->privatePart->PilotingPCMDParameters == NULL)
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        localError = ARCONTROLLER_FEATURE_ARDrone3_RegisterARCommands (featureController);
    }
    // No else: skipped by an error 
    
    // delete the feature Controller if an error occurred
    if (localError != ARCONTROLLER_OK)
    {
        ARCONTROLLER_FEATURE_ARDrone3_Delete (&featureController);
    }
    // No else: skipped no error 
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return featureController;
}

void ARCONTROLLER_FEATURE_ARDrone3_Delete (ARCONTROLLER_FEATURE_ARDrone3_t **feature)
{
    // -- Delete the ARDrone3 feature Controller --
    
    if (feature != NULL)
    {
        if ((*feature) != NULL)
        {
            ARCONTROLLER_FEATURE_ARDrone3_UnregisterARCommands ((*feature));
            
            if ((*feature)->privatePart != NULL)
            {
                ARSAL_Mutex_Destroy (&((*feature)->privatePart->mutex));
                
                if ((*feature)->privatePart->dictionary != NULL)
                {
                    ARCONTROLLER_Feature_DeleteCommandsDictionary (&((*feature)->privatePart->dictionary));
                }
                
                if ((*feature)->privatePart->commandCallbacks != NULL)
                {
                    // Free the hash table contents the command callback
                    ARCONTROLLER_Dictionary_DeleteDictionary (&((*feature)->privatePart->commandCallbacks));
                }
                
                if ((*feature)->privatePart->PilotingPCMDParameters != NULL)
                {
                    free ((*feature)->privatePart->PilotingPCMDParameters);
                    (*feature)->privatePart->PilotingPCMDParameters = NULL;
                }
                free ((*feature)->privatePart);
                (*feature)->privatePart = NULL;
            }
            
            free (*feature);
            (*feature) = NULL;
        }
    }
}

ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_ARDrone3_GetDictionary (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Get the dictionary of the ARDrone3 Feature Controller --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictionary = NULL;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        dictionary = feature->privatePart->dictionary;
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return dictionary;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_AddCallback (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Add a callback to use when a command in project <code>ARDrone3</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_AddDictionaryElement (&(feature->privatePart->commandCallbacks), commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_RemoveCallback (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Remove a callback to use when a command in project <code>ARDrone3</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_RemoveDictionaryElement (feature->privatePart->commandCallbacks, commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_RegisterARCommands (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Register the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStatePictureStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStateVideoStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedV2Callback (&ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStatePictureStateChangedV2Callback, feature);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedV2Callback (&ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStateVideoStateChangedV2Callback, feature);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventPictureEventChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_MediaRecordEventPictureEventChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventVideoEventChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_MediaRecordEventVideoEventChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlatTrimChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateFlatTrimChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlyingStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateFlyingStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAlertStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAlertStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateNavigateHomeStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateNavigateHomeStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStatePositionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStatePositionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateSpeedChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAttitudeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAttitudeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAutoTakeOffModeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAutoTakeOffModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAltitudeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAltitudeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingEventMoveByEndCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingEventMoveByEndCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiScanListChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkStateWifiScanListChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiScanChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkStateAllWifiScanChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiAuthChannelListChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkStateWifiAuthChannelListChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiAuthChannelChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkStateAllWifiAuthChannelChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxAltitudeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMaxAltitudeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxTiltChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMaxTiltChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAbsolutControlChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAbsolutControlChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxDistanceChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMaxDistanceChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateBankedTurnChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateBankedTurnChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMinAltitudeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMinAltitudeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingDirectionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateCirclingDirectionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingRadiusChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateCirclingRadiusChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateCirclingAltitudeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStatePitchModeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStatePitchModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateLandingModeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateLandingModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateMaxVerticalSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateMaxRotationSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateHullProtectionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateHullProtectionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateOutdoorChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateOutdoorChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSelectionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkSettingsStateWifiSelectionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkSettingsStateWifiSecurityChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityCallback (&ARCONTROLLER_FEATURE_ARDrone3_NetworkSettingsStateWifiSecurityCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductMotorVersionListChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateProductMotorVersionListChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductGPSVersionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateProductGPSVersionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorErrorStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorSoftwareVersionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorSoftwareVersionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorFlightsStatusChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorFlightsStatusChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorLastErrorChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorErrorLastErrorChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateP7IDCallback (&ARCONTROLLER_FEATURE_ARDrone3_SettingsStateP7IDCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStatePictureFormatChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStatePictureFormatChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateAutoWhiteBalanceChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateExpositionChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateExpositionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateSaturationChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateSaturationChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateTimelapseChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateTimelapseChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoAutorecordChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateVideoAutorecordChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateVideoStabilizationModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3MediaStreamingStateVideoEnableChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_MediaStreamingStateVideoEnableChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateHomeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateResetHomeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateResetHomeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSFixStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateGPSFixStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSUpdateStateChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateGPSUpdateStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeTypeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateHomeTypeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateReturnHomeDelayChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateReturnHomeDelayChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3CameraStateOrientationCallback (&ARCONTROLLER_FEATURE_ARDrone3_CameraStateOrientationCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3CameraStateDefaultCameraOrientationCallback (&ARCONTROLLER_FEATURE_ARDrone3_CameraStateDefaultCameraOrientationCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateElectricFrequencyChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_AntiflickeringStateElectricFrequencyChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateModeChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_AntiflickeringStateModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSStateNumberOfSatelliteChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSStateNumberOfSatelliteChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeAvailabilityChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSStateHomeTypeAvailabilityChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeChosenChangedCallback (&ARCONTROLLER_FEATURE_ARDrone3_GPSStateHomeTypeChosenChangedCallback, feature);
        ARCOMMANDS_Decoder_SetARDrone3PROStateFeaturesCallback (&ARCONTROLLER_FEATURE_ARDrone3_PROStateFeaturesCallback, feature);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_UnregisterARCommands (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Unregister the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStatePictureStateChangedV2Callback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordStateVideoStateChangedV2Callback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventPictureEventChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3MediaRecordEventVideoEventChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlatTrimChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateFlyingStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAlertStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateNavigateHomeStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStatePositionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAttitudeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAutoTakeOffModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingStateAltitudeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingEventMoveByEndCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiScanListChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiScanChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateWifiAuthChannelListChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkStateAllWifiAuthChannelChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxAltitudeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxTiltChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAbsolutControlChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMaxDistanceChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateBankedTurnChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateMinAltitudeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingDirectionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingRadiusChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateCirclingAltitudeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStatePitchModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PilotingSettingsStateLandingModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxVerticalSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxRotationSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateHullProtectionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateOutdoorChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSelectionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3NetworkSettingsStateWifiSecurityCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductMotorVersionListChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateProductGPSVersionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorSoftwareVersionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorFlightsStatusChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateMotorErrorLastErrorChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3SettingsStateP7IDCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStatePictureFormatChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateAutoWhiteBalanceChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateExpositionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateSaturationChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateTimelapseChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoAutorecordChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PictureSettingsStateVideoStabilizationModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3MediaStreamingStateVideoEnableChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateResetHomeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSFixStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateGPSUpdateStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateHomeTypeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSSettingsStateReturnHomeDelayChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3CameraStateOrientationCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3CameraStateDefaultCameraOrientationCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateElectricFrequencyChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3AntiflickeringStateModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSStateNumberOfSatelliteChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeAvailabilityChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3GPSStateHomeTypeChosenChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetARDrone3PROStateFeaturesCallback (NULL, NULL);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingFlatTrim (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>PilotingFlatTrim</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send FlatTrim command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingFlatTrim(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingTakeOff (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>PilotingTakeOff</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send TakeOff command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingTakeOff(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingPCMD (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestampAndSeqNum)
{
    // -- Send a command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PCMD command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingPCMD(cmdBuffer, sizeof(cmdBuffer), &cmdSize, flag, roll, pitch, yaw, gaz, timestampAndSeqNum);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMD (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _flag, int8_t _roll, int8_t _pitch, int8_t _yaw, int8_t _gaz, uint32_t _timestampAndSeqNum)
{
    // -- Set the parameter for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->flag = _flag;
        feature->privatePart->PilotingPCMDParameters->roll = _roll;
        feature->privatePart->PilotingPCMDParameters->pitch = _pitch;
        feature->privatePart->PilotingPCMDParameters->yaw = _yaw;
        feature->privatePart->PilotingPCMDParameters->gaz = _gaz;
        feature->privatePart->PilotingPCMDParameters->timestampAndSeqNum = _timestampAndSeqNum;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_ARDrone3_SendPilotingPCMDStruct (ARCONTROLLER_FEATURE_ARDrone3_t *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize)
{
    // -- Send the a command <code>PilotingPCMD</code> in project <code>ARDrone3</code> with the parame set beforehand  --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    int32_t cmdSize = 0;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL) ||
       (cmdBuffer == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PCMD command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingPCMD(cmdBuffer, cmdBufferSize, &cmdSize, feature->privatePart->PilotingPCMDParameters->flag, feature->privatePart->PilotingPCMDParameters->roll, feature->privatePart->PilotingPCMDParameters->pitch, feature->privatePart->PilotingPCMDParameters->yaw, feature->privatePart->PilotingPCMDParameters->gaz, feature->privatePart->PilotingPCMDParameters->timestampAndSeqNum);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
        if (netError != ARNETWORK_OK)
        {
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_FEATURE_TAG, "Network sending error : %s", ARNETWORK_Error_ToString (netError));
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDFlag (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _flag)
{
    // -- Set the flag for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->flag = _flag;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDRoll (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t _roll)
{
    // -- Set the roll for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->roll = _roll;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDPitch (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t _pitch)
{
    // -- Set the pitch for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->pitch = _pitch;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDYaw (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t _yaw)
{
    // -- Set the yaw for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->yaw = _yaw;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDGaz (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t _gaz)
{
    // -- Set the gaz for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->gaz = _gaz;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetPilotingPCMDTimestampAndSeqNum (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint32_t _timestampAndSeqNum)
{
    // -- Set the timestampAndSeqNum for the command <code>PilotingPCMD</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->timestampAndSeqNum = _timestampAndSeqNum;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingLanding (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>PilotingLanding</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Landing command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingLanding(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingEmergency (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>PilotingEmergency</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Emergency command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingEmergency(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_HIGH_PRIORITY, ARNETWORK_MANAGER_CALLBACK_RETURN_RETRY, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingNavigateHome (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t start)
{
    // -- Send a command <code>PilotingNavigateHome</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send NavigateHome command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingNavigateHome(cmdBuffer, sizeof(cmdBuffer), &cmdSize, start);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingAutoTakeOffMode (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t state)
{
    // -- Send a command <code>PilotingAutoTakeOffMode</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send AutoTakeOffMode command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingAutoTakeOffMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, state);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingMoveBy (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float dX, float dY, float dZ, float dPsi)
{
    // -- Send a command <code>PilotingMoveBy</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MoveBy command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingMoveBy(cmdBuffer, sizeof(cmdBuffer), &cmdSize, dX, dY, dZ, dPsi);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingUserTakeOff (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t state)
{
    // -- Send a command <code>PilotingUserTakeOff</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send UserTakeOff command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingUserTakeOff(cmdBuffer, sizeof(cmdBuffer), &cmdSize, state);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingCircle (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTING_CIRCLE_DIRECTION direction)
{
    // -- Send a command <code>PilotingCircle</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Circle command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingCircle(cmdBuffer, sizeof(cmdBuffer), &cmdSize, direction);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendAnimationsFlip (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANIMATIONS_FLIP_DIRECTION direction)
{
    // -- Send a command <code>AnimationsFlip</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Flip command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3AnimationsFlip(cmdBuffer, sizeof(cmdBuffer), &cmdSize, direction);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendCameraOrientation (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t tilt, int8_t pan)
{
    // -- Send a command <code>CameraOrientation</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Orientation command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3CameraOrientation(cmdBuffer, sizeof(cmdBuffer), &cmdSize, tilt, pan);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPicture (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t mass_storage_id)
{
    // -- Send a command <code>MediaRecordPicture</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Picture command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPicture(cmdBuffer, sizeof(cmdBuffer), &cmdSize, mass_storage_id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideo (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id)
{
    // -- Send a command <code>MediaRecordVideo</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Video command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideo(cmdBuffer, sizeof(cmdBuffer), &cmdSize, record, mass_storage_id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordPictureV2 (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>MediaRecordPictureV2</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PictureV2 command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordPictureV2(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendMediaRecordVideoV2 (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORD_VIDEOV2_RECORD record)
{
    // -- Send a command <code>MediaRecordVideoV2</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send VideoV2 command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3MediaRecordVideoV2(cmdBuffer, sizeof(cmdBuffer), &cmdSize, record);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiScan (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORK_WIFISCAN_BAND band)
{
    // -- Send a command <code>NetworkWifiScan</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiScan command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiScan(cmdBuffer, sizeof(cmdBuffer), &cmdSize, band);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendNetworkWifiAuthChannel (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>NetworkWifiAuthChannel</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiAuthChannel command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3NetworkWifiAuthChannel(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxAltitude (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current)
{
    // -- Send a command <code>PilotingSettingsMaxAltitude</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxAltitude command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxAltitude(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxTilt (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current)
{
    // -- Send a command <code>PilotingSettingsMaxTilt</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxTilt command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxTilt(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsAbsolutControl (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t on)
{
    // -- Send a command <code>PilotingSettingsAbsolutControl</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send AbsolutControl command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsAbsolutControl(cmdBuffer, sizeof(cmdBuffer), &cmdSize, on);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMaxDistance (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PilotingSettingsMaxDistance</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxDistance command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMaxDistance(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsNoFlyOverMaxDistance (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t shouldNotFlyOver)
{
    // -- Send a command <code>PilotingSettingsNoFlyOverMaxDistance</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send NoFlyOverMaxDistance command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsNoFlyOverMaxDistance(cmdBuffer, sizeof(cmdBuffer), &cmdSize, shouldNotFlyOver);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetAutonomousFlightMaxHorizontalSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PilotingSettingsSetAutonomousFlightMaxVerticalSpeed</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetAutonomousFlightMaxVerticalSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetAutonomousFlightMaxHorizontalAcceleration command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxHorizontalAcceleration(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxVerticalAcceleration (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetAutonomousFlightMaxVerticalAcceleration command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxVerticalAcceleration(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsSetAutonomousFlightMaxRotationSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PilotingSettingsSetAutonomousFlightMaxRotationSpeed</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetAutonomousFlightMaxRotationSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsSetAutonomousFlightMaxRotationSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsBankedTurn (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t value)
{
    // -- Send a command <code>PilotingSettingsBankedTurn</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send BankedTurn command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsBankedTurn(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsMinAltitude (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current)
{
    // -- Send a command <code>PilotingSettingsMinAltitude</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MinAltitude command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsMinAltitude(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingDirection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_CIRCLINGDIRECTION_VALUE value)
{
    // -- Send a command <code>PilotingSettingsCirclingDirection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send CirclingDirection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingDirection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingRadius (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t value)
{
    // -- Send a command <code>PilotingSettingsCirclingRadius</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send CirclingRadius command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingRadius(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsCirclingAltitude (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t value)
{
    // -- Send a command <code>PilotingSettingsCirclingAltitude</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send CirclingAltitude command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsCirclingAltitude(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsPitchMode (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_PITCHMODE_VALUE value)
{
    // -- Send a command <code>PilotingSettingsPitchMode</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PitchMode command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsPitchMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPilotingSettingsLandingMode (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGS_LANDINGMODE_VALUE value)
{
    // -- Send a command <code>PilotingSettingsLandingMode</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send LandingMode command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PilotingSettingsLandingMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxVerticalSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current)
{
    // -- Send a command <code>SpeedSettingsMaxVerticalSpeed</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxVerticalSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxVerticalSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxRotationSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current)
{
    // -- Send a command <code>SpeedSettingsMaxRotationSpeed</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxRotationSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxRotationSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsHullProtection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t present)
{
    // -- Send a command <code>SpeedSettingsHullProtection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send HullProtection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsHullProtection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, present);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsOutdoor (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t outdoor)
{
    // -- Send a command <code>SpeedSettingsOutdoor</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Outdoor command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsOutdoor(cmdBuffer, sizeof(cmdBuffer), &cmdSize, outdoor);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendSpeedSettingsMaxPitchRollRotationSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float current)
{
    // -- Send a command <code>SpeedSettingsMaxPitchRollRotationSpeed</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxPitchRollRotationSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3SpeedSettingsMaxPitchRollRotationSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel)
{
    // -- Send a command <code>NetworkSettingsWifiSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type, band, channel);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendNetworkSettingsWifiSecurity (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_TYPE type, char * key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGS_WIFISECURITY_KEYTYPE keyType)
{
    // -- Send a command <code>NetworkSettingsWifiSecurity</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiSecurity command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3NetworkSettingsWifiSecurity(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type, key, keyType);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsPictureFormatSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_PICTUREFORMATSELECTION_TYPE type)
{
    // -- Send a command <code>PictureSettingsPictureFormatSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PictureFormatSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsPictureFormatSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsAutoWhiteBalanceSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_AUTOWHITEBALANCESELECTION_TYPE type)
{
    // -- Send a command <code>PictureSettingsAutoWhiteBalanceSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send AutoWhiteBalanceSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsAutoWhiteBalanceSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsExpositionSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PictureSettingsExpositionSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ExpositionSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsExpositionSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsSaturationSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float value)
{
    // -- Send a command <code>PictureSettingsSaturationSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SaturationSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsSaturationSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, value);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsTimelapseSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t enabled, float interval)
{
    // -- Send a command <code>PictureSettingsTimelapseSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send TimelapseSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsTimelapseSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, enabled, interval);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoAutorecordSelection (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t enabled, uint8_t mass_storage_id)
{
    // -- Send a command <code>PictureSettingsVideoAutorecordSelection</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send VideoAutorecordSelection command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoAutorecordSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, enabled, mass_storage_id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendPictureSettingsVideoStabilizationMode (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGS_VIDEOSTABILIZATIONMODE_MODE mode)
{
    // -- Send a command <code>PictureSettingsVideoStabilizationMode</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send VideoStabilizationMode command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3PictureSettingsVideoStabilizationMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, mode);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendMediaStreamingVideoEnable (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t enable)
{
    // -- Send a command <code>MediaStreamingVideoEnable</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send VideoEnable command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3MediaStreamingVideoEnable(cmdBuffer, sizeof(cmdBuffer), &cmdSize, enable);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSetHome (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double latitude, double longitude, double altitude)
{
    // -- Send a command <code>GPSSettingsSetHome</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetHome command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSetHome(cmdBuffer, sizeof(cmdBuffer), &cmdSize, latitude, longitude, altitude);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsResetHome (ARCONTROLLER_FEATURE_ARDrone3_t *feature)
{
    // -- Send a command <code>GPSSettingsResetHome</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ResetHome command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsResetHome(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsSendControllerGPS (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double latitude, double longitude, double altitude, double horizontalAccuracy, double verticalAccuracy)
{
    // -- Send a command <code>GPSSettingsSendControllerGPS</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SendControllerGPS command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsSendControllerGPS(cmdBuffer, sizeof(cmdBuffer), &cmdSize, latitude, longitude, altitude, horizontalAccuracy, verticalAccuracy);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsHomeType (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_GPSSETTINGS_HOMETYPE_TYPE type)
{
    // -- Send a command <code>GPSSettingsHomeType</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send HomeType command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsHomeType(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendGPSSettingsReturnHomeDelay (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t delay)
{
    // -- Send a command <code>GPSSettingsReturnHomeDelay</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ReturnHomeDelay command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3GPSSettingsReturnHomeDelay(cmdBuffer, sizeof(cmdBuffer), &cmdSize, delay);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringElectricFrequency (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_ELECTRICFREQUENCY_FREQUENCY frequency)
{
    // -- Send a command <code>AntiflickeringElectricFrequency</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ElectricFrequency command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringElectricFrequency(cmdBuffer, sizeof(cmdBuffer), &cmdSize, frequency);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SendAntiflickeringSetMode (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANTIFLICKERING_SETMODE_MODE mode)
{
    // -- Send a command <code>AntiflickeringSetMode</code> in project <code>ARDrone3</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SetMode command
        cmdError = ARCOMMANDS_Generator_GenerateARDrone3AntiflickeringSetMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, mode);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStatePictureStateChangedCallback (uint8_t _state, uint8_t _mass_storage_id, void *customData)
{
    // -- callback used when the command <code>MediaRecordStatePictureStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStatePictureStateChanged (feature,  _state,  _mass_storage_id, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStateVideoStateChangedCallback (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id, void *customData)
{
    // -- callback used when the command <code>MediaRecordStateVideoStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStateVideoStateChanged (feature,  _state,  _mass_storage_id, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStatePictureStateChangedV2Callback (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordStatePictureStateChangedV2</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStatePictureStateChangedV2 (feature,  _state,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaRecordStateVideoStateChangedV2Callback (eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordStateVideoStateChangedV2</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStateVideoStateChangedV2 (feature,  _state,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaRecordEventPictureEventChangedCallback (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordEventPictureEventChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordEventPictureEventChanged (feature,  _event,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaRecordEventVideoEventChangedCallback (eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordEventVideoEventChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordEventVideoEventChanged (feature,  _event,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateFlatTrimChangedCallback (void *customData)
{
    // -- callback used when the command <code>PilotingStateFlatTrimChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLATTRIMCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateFlatTrimChanged (feature, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateFlyingStateChangedCallback (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>PilotingStateFlyingStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateFlyingStateChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAlertStateChangedCallback (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>PilotingStateAlertStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAlertStateChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateNavigateHomeStateChangedCallback (eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE _state, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON _reason, void *customData)
{
    // -- callback used when the command <code>PilotingStateNavigateHomeStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateNavigateHomeStateChanged (feature,  _state,  _reason, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStatePositionChangedCallback (double _latitude, double _longitude, double _altitude, void *customData)
{
    // -- callback used when the command <code>PilotingStatePositionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStatePositionChanged (feature,  _latitude,  _longitude,  _altitude, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateSpeedChangedCallback (float _speedX, float _speedY, float _speedZ, void *customData)
{
    // -- callback used when the command <code>PilotingStateSpeedChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateSpeedChanged (feature,  _speedX,  _speedY,  _speedZ, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAttitudeChangedCallback (float _roll, float _pitch, float _yaw, void *customData)
{
    // -- callback used when the command <code>PilotingStateAttitudeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAttitudeChanged (feature,  _roll,  _pitch,  _yaw, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAutoTakeOffModeChangedCallback (uint8_t _state, void *customData)
{
    // -- callback used when the command <code>PilotingStateAutoTakeOffModeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAutoTakeOffModeChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingStateAltitudeChangedCallback (double _altitude, void *customData)
{
    // -- callback used when the command <code>PilotingStateAltitudeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAltitudeChanged (feature,  _altitude, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingEventMoveByEndCallback (float _dX, float _dY, float _dZ, float _dPsi, eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR _error, void *customData)
{
    // -- callback used when the command <code>PilotingEventMoveByEnd</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingEventMoveByEnd (feature,  _dX,  _dY,  _dZ,  _dPsi,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkStateWifiScanListChangedCallback (char * _ssid, int16_t _rssi, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel, void *customData)
{
    // -- callback used when the command <code>NetworkStateWifiScanListChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateWifiScanListChanged (feature,  _ssid,  _rssi,  _band,  _channel, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkStateAllWifiScanChangedCallback (void *customData)
{
    // -- callback used when the command <code>NetworkStateAllWifiScanChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFISCANCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateAllWifiScanChanged (feature, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkStateWifiAuthChannelListChangedCallback (eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out, void *customData)
{
    // -- callback used when the command <code>NetworkStateWifiAuthChannelListChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int listIndex = 0;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        listIndex = HASH_COUNT (dictCmdElement->elements);
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateWifiAuthChannelListChanged (feature,  _band,  _channel,  _in_or_out, listIndex, 
&error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkStateAllWifiAuthChannelChangedCallback (void *customData)
{
    // -- callback used when the command <code>NetworkStateAllWifiAuthChannelChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateAllWifiAuthChannelChanged (feature, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMaxAltitudeChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateMaxAltitudeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMaxAltitudeChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMaxTiltChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateMaxTiltChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMaxTiltChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAbsolutControlChangedCallback (uint8_t _on, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateAbsolutControlChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAbsolutControlChanged (feature,  _on, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMaxDistanceChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateMaxDistanceChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMaxDistanceChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateNoFlyOverMaxDistanceChangedCallback (uint8_t _shouldNotFlyOver, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateNoFlyOverMaxDistanceChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateNoFlyOverMaxDistanceChanged (feature,  _shouldNotFlyOver, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxHorizontalSpeedCallback (float _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxHorizontalSpeed (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxVerticalSpeedCallback (float _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateAutonomousFlightMaxVerticalSpeed</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxVerticalSpeed (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxHorizontalAccelerationCallback (float _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxVerticalAccelerationCallback (float _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxVerticalAcceleration (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateAutonomousFlightMaxRotationSpeedCallback (float _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateAutonomousFlightMaxRotationSpeed</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxRotationSpeed (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateBankedTurnChangedCallback (uint8_t _state, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateBankedTurnChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateBankedTurnChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateMinAltitudeChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateMinAltitudeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMinAltitudeChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateCirclingDirectionChangedCallback (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateCirclingDirectionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateCirclingDirectionChanged (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateCirclingRadiusChangedCallback (uint16_t _current, uint16_t _min, uint16_t _max, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateCirclingRadiusChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateCirclingRadiusChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateCirclingAltitudeChangedCallback (uint16_t _current, uint16_t _min, uint16_t _max, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateCirclingAltitudeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateCirclingAltitudeChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStatePitchModeChangedCallback (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStatePitchModeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStatePitchModeChanged (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PilotingSettingsStateLandingModeChangedCallback (eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE _value, void *customData)
{
    // -- callback used when the command <code>PilotingSettingsStateLandingModeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateLandingModeChanged (feature,  _value, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateMaxVerticalSpeedChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>SpeedSettingsStateMaxVerticalSpeedChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateMaxVerticalSpeedChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateMaxRotationSpeedChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>SpeedSettingsStateMaxRotationSpeedChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateMaxRotationSpeedChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateHullProtectionChangedCallback (uint8_t _present, void *customData)
{
    // -- callback used when the command <code>SpeedSettingsStateHullProtectionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateHullProtectionChanged (feature,  _present, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateOutdoorChangedCallback (uint8_t _outdoor, void *customData)
{
    // -- callback used when the command <code>SpeedSettingsStateOutdoorChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateOutdoorChanged (feature,  _outdoor, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SpeedSettingsStateMaxPitchRollRotationSpeedChangedCallback (float _current, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>SpeedSettingsStateMaxPitchRollRotationSpeedChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateMaxPitchRollRotationSpeedChanged (feature,  _current,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkSettingsStateWifiSelectionChangedCallback (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel, void *customData)
{
    // -- callback used when the command <code>NetworkSettingsStateWifiSelectionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkSettingsStateWifiSelectionChanged (feature,  _type,  _band,  _channel, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkSettingsStateWifiSecurityChangedCallback (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE _type, void *customData)
{
    // -- callback used when the command <code>NetworkSettingsStateWifiSecurityChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkSettingsStateWifiSecurityChanged (feature,  _type, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_NetworkSettingsStateWifiSecurityCallback (eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE _type, char * _key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE _keyType, void *customData)
{
    // -- callback used when the command <code>NetworkSettingsStateWifiSecurity</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementNetworkSettingsStateWifiSecurity (feature,  _type,  _key,  _keyType, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateProductMotorVersionListChangedCallback (uint8_t _motor_number, char * _type, char * _software, char * _hardware, void *customData)
{
    // -- callback used when the command <code>SettingsStateProductMotorVersionListChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateProductMotorVersionListChanged (feature,  _motor_number,  _type,  _software,  _hardware, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateProductGPSVersionChangedCallback (char * _software, char * _hardware, void *customData)
{
    // -- callback used when the command <code>SettingsStateProductGPSVersionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateProductGPSVersionChanged (feature,  _software,  _hardware, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorErrorStateChangedCallback (uint8_t _motorIds, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR _motorError, void *customData)
{
    // -- callback used when the command <code>SettingsStateMotorErrorStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorErrorStateChanged (feature,  _motorIds,  _motorError, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorSoftwareVersionChangedCallback (char * _version, void *customData)
{
    // -- callback used when the command <code>SettingsStateMotorSoftwareVersionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorSoftwareVersionChanged (feature,  _version, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorFlightsStatusChangedCallback (uint16_t _nbFlights, uint16_t _lastFlightDuration, uint32_t _totalFlightDuration, void *customData)
{
    // -- callback used when the command <code>SettingsStateMotorFlightsStatusChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorFlightsStatusChanged (feature,  _nbFlights,  _lastFlightDuration,  _totalFlightDuration, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateMotorErrorLastErrorChangedCallback (eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR _motorError, void *customData)
{
    // -- callback used when the command <code>SettingsStateMotorErrorLastErrorChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorErrorLastErrorChanged (feature,  _motorError, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_SettingsStateP7IDCallback (char * _serialID, void *customData)
{
    // -- callback used when the command <code>SettingsStateP7ID</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateP7ID (feature,  _serialID, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStatePictureFormatChangedCallback (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE _type, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStatePictureFormatChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStatePictureFormatChanged (feature,  _type, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateAutoWhiteBalanceChangedCallback (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE _type, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStateAutoWhiteBalanceChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateAutoWhiteBalanceChanged (feature,  _type, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateExpositionChangedCallback (float _value, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStateExpositionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateExpositionChanged (feature,  _value,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateSaturationChangedCallback (float _value, float _min, float _max, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStateSaturationChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateSaturationChanged (feature,  _value,  _min,  _max, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateTimelapseChangedCallback (uint8_t _enabled, float _interval, float _minInterval, float _maxInterval, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStateTimelapseChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateTimelapseChanged (feature,  _enabled,  _interval,  _minInterval,  _maxInterval, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateVideoAutorecordChangedCallback (uint8_t _enabled, uint8_t _mass_storage_id, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStateVideoAutorecordChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateVideoAutorecordChanged (feature,  _enabled,  _mass_storage_id, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PictureSettingsStateVideoStabilizationModeChangedCallback (eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE _mode, void *customData)
{
    // -- callback used when the command <code>PictureSettingsStateVideoStabilizationModeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateVideoStabilizationModeChanged (feature,  _mode, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_MediaStreamingStateVideoEnableChangedCallback (eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled, void *customData)
{
    // -- callback used when the command <code>MediaStreamingStateVideoEnableChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementMediaStreamingStateVideoEnableChanged (feature,  _enabled, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateHomeChangedCallback (double _latitude, double _longitude, double _altitude, void *customData)
{
    // -- callback used when the command <code>GPSSettingsStateHomeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateHomeChanged (feature,  _latitude,  _longitude,  _altitude, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateResetHomeChangedCallback (double _latitude, double _longitude, double _altitude, void *customData)
{
    // -- callback used when the command <code>GPSSettingsStateResetHomeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateResetHomeChanged (feature,  _latitude,  _longitude,  _altitude, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateGPSFixStateChangedCallback (uint8_t _fixed, void *customData)
{
    // -- callback used when the command <code>GPSSettingsStateGPSFixStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateGPSFixStateChanged (feature,  _fixed, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateGPSUpdateStateChangedCallback (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>GPSSettingsStateGPSUpdateStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateGPSUpdateStateChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateHomeTypeChangedCallback (eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE _type, void *customData)
{
    // -- callback used when the command <code>GPSSettingsStateHomeTypeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateHomeTypeChanged (feature,  _type, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSSettingsStateReturnHomeDelayChangedCallback (uint16_t _delay, void *customData)
{
    // -- callback used when the command <code>GPSSettingsStateReturnHomeDelayChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateReturnHomeDelayChanged (feature,  _delay, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_CameraStateOrientationCallback (int8_t _tilt, int8_t _pan, void *customData)
{
    // -- callback used when the command <code>CameraStateOrientation</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementCameraStateOrientation (feature,  _tilt,  _pan, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_CameraStateDefaultCameraOrientationCallback (int8_t _tilt, int8_t _pan, void *customData)
{
    // -- callback used when the command <code>CameraStateDefaultCameraOrientation</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementCameraStateDefaultCameraOrientation (feature,  _tilt,  _pan, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_AntiflickeringStateElectricFrequencyChangedCallback (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY _frequency, void *customData)
{
    // -- callback used when the command <code>AntiflickeringStateElectricFrequencyChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementAntiflickeringStateElectricFrequencyChanged (feature,  _frequency, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_AntiflickeringStateModeChangedCallback (eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE _mode, void *customData)
{
    // -- callback used when the command <code>AntiflickeringStateModeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementAntiflickeringStateModeChanged (feature,  _mode, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSStateNumberOfSatelliteChangedCallback (uint8_t _numberOfSatellite, void *customData)
{
    // -- callback used when the command <code>GPSStateNumberOfSatelliteChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSStateNumberOfSatelliteChanged (feature,  _numberOfSatellite, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSStateHomeTypeAvailabilityChangedCallback (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE _type, uint8_t _available, void *customData)
{
    // -- callback used when the command <code>GPSStateHomeTypeAvailabilityChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSStateHomeTypeAvailabilityChanged (feature,  _type,  _available, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_GPSStateHomeTypeChosenChangedCallback (eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE _type, void *customData)
{
    // -- callback used when the command <code>GPSStateHomeTypeChosenChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementGPSStateHomeTypeChosenChanged (feature,  _type, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_ARDrone3_PROStateFeaturesCallback (uint64_t _features, void *customData)
{
    // -- callback used when the command <code>PROStateFeatures</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_ARDrone3_t *feature = (ARCONTROLLER_FEATURE_ARDrone3_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_ARDrone3_NewCmdElementPROStateFeatures (feature,  _features, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStatePictureStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _state, uint8_t _mass_storage_id, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStatePictureStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE;
            argDictNewElement->value.U8 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID;
            argDictNewElement->value.U8 = _mass_storage_id;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStateVideoStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStateVideoStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGED_MASS_STORAGE_ID;
            argDictNewElement->value.U8 = _mass_storage_id;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStatePictureStateChangedV2 (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStatePictureStateChangedV2 -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordStateVideoStateChangedV2 (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStateVideoStateChangedV2 -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordEventPictureEventChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordEventPictureEventChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT;
            argDictNewElement->value.I32 = _event;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaRecordEventVideoEventChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordEventVideoEventChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT;
            argDictNewElement->value.I32 = _event;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateFlatTrimChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateFlatTrimChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateFlyingStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateFlyingStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_FLYINGSTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAlertStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateAlertStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALERTSTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateNavigateHomeStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE _state, eARCOMMANDS_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON _reason, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateNavigateHomeStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_NAVIGATEHOMESTATECHANGED_REASON;
            argDictNewElement->value.I32 = _reason;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStatePositionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double _latitude, double _longitude, double _altitude, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStatePositionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_LATITUDE;
            argDictNewElement->value.Double = _latitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_LONGITUDE;
            argDictNewElement->value.Double = _longitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_POSITIONCHANGED_ALTITUDE;
            argDictNewElement->value.Double = _altitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateSpeedChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _speedX, float _speedY, float _speedZ, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateSpeedChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDX;
            argDictNewElement->value.Float = _speedX;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDY;
            argDictNewElement->value.Float = _speedY;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_SPEEDCHANGED_SPEEDZ;
            argDictNewElement->value.Float = _speedZ;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAttitudeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _roll, float _pitch, float _yaw, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateAttitudeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_ROLL;
            argDictNewElement->value.Float = _roll;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_PITCH;
            argDictNewElement->value.Float = _pitch;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ATTITUDECHANGED_YAW;
            argDictNewElement->value.Float = _yaw;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAutoTakeOffModeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateAutoTakeOffModeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED_STATE;
            argDictNewElement->value.U8 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingStateAltitudeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double _altitude, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateAltitudeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSTATE_ALTITUDECHANGED_ALTITUDE;
            argDictNewElement->value.Double = _altitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingEventMoveByEnd (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _dX, float _dY, float _dZ, float _dPsi, eARCOMMANDS_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingEventMoveByEnd -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DX;
            argDictNewElement->value.Float = _dX;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DY;
            argDictNewElement->value.Float = _dY;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DZ;
            argDictNewElement->value.Float = _dZ;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_DPSI;
            argDictNewElement->value.Float = _dPsi;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGEVENT_MOVEBYEND_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateWifiScanListChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, char * _ssid, int16_t _rssi, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateWifiScanListChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (_ssid);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, _ssid, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_SSID;
            strLength = strlen (_ssid);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _ssid, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_RSSI;
            argDictNewElement->value.I16 = _rssi;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_BAND;
            argDictNewElement->value.I32 = _band;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFISCANLISTCHANGED_CHANNEL;
            argDictNewElement->value.U8 = _channel;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateAllWifiScanChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateAllWifiScanChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateWifiAuthChannelListChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out, int listIndex, 
eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateWifiAuthChannelListChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        //Alloc Element Key
        elementKeyLength = snprintf (NULL, 0, "%d", listIndex);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            snprintf (newElement->key, (elementKeyLength + 1), "%d", listIndex);
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND;
            argDictNewElement->value.I32 = _band;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL;
            argDictNewElement->value.U8 = _channel;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT;
            argDictNewElement->value.U8 = _in_or_out;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkStateAllWifiAuthChannelChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateAllWifiAuthChannelChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMaxAltitudeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateMaxAltitudeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMaxTiltChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateMaxTiltChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAbsolutControlChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _on, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateAbsolutControlChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_ABSOLUTCONTROLCHANGED_ON;
            argDictNewElement->value.U8 = _on;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMaxDistanceChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateMaxDistanceChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MAXDISTANCECHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateNoFlyOverMaxDistanceChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _shouldNotFlyOver, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateNoFlyOverMaxDistanceChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_NOFLYOVERMAXDISTANCECHANGED_SHOULDNOTFLYOVER;
            argDictNewElement->value.U8 = _shouldNotFlyOver;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxHorizontalSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateAutonomousFlightMaxHorizontalSpeed -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALSPEED_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxVerticalSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateAutonomousFlightMaxVerticalSpeed -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALSPEED_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateAutonomousFlightMaxHorizontalAcceleration -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXHORIZONTALACCELERATION_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxVerticalAcceleration (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateAutonomousFlightMaxVerticalAcceleration -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXVERTICALACCELERATION_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateAutonomousFlightMaxRotationSpeed (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateAutonomousFlightMaxRotationSpeed -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_AUTONOMOUSFLIGHTMAXROTATIONSPEED_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateBankedTurnChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateBankedTurnChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_BANKEDTURNCHANGED_STATE;
            argDictNewElement->value.U8 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateMinAltitudeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateMinAltitudeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_MINALTITUDECHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateCirclingDirectionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateCirclingDirectionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGDIRECTIONCHANGED_VALUE;
            argDictNewElement->value.I32 = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateCirclingRadiusChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t _current, uint16_t _min, uint16_t _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateCirclingRadiusChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_CURRENT;
            argDictNewElement->value.U16 = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_MIN;
            argDictNewElement->value.U16 = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGRADIUSCHANGED_MAX;
            argDictNewElement->value.U16 = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateCirclingAltitudeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t _current, uint16_t _min, uint16_t _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateCirclingAltitudeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_CURRENT;
            argDictNewElement->value.U16 = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_MIN;
            argDictNewElement->value.U16 = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_CIRCLINGALTITUDECHANGED_MAX;
            argDictNewElement->value.U16 = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStatePitchModeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStatePitchModeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_PITCHMODECHANGED_VALUE;
            argDictNewElement->value.I32 = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPilotingSettingsStateLandingModeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE _value, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingSettingsStateLandingModeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PILOTINGSETTINGSSTATE_LANDINGMODECHANGED_VALUE;
            argDictNewElement->value.I32 = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateMaxVerticalSpeedChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SpeedSettingsStateMaxVerticalSpeedChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateMaxRotationSpeedChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SpeedSettingsStateMaxRotationSpeedChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateHullProtectionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _present, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SpeedSettingsStateHullProtectionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_HULLPROTECTIONCHANGED_PRESENT;
            argDictNewElement->value.U8 = _present;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateOutdoorChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _outdoor, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SpeedSettingsStateOutdoorChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_OUTDOORCHANGED_OUTDOOR;
            argDictNewElement->value.U8 = _outdoor;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSpeedSettingsStateMaxPitchRollRotationSpeedChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _current, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SpeedSettingsStateMaxPitchRollRotationSpeedChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_CURRENT;
            argDictNewElement->value.Float = _current;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SPEEDSETTINGSSTATE_MAXPITCHROLLROTATIONSPEEDCHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkSettingsStateWifiSelectionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkSettingsStateWifiSelectionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND;
            argDictNewElement->value.I32 = _band;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL;
            argDictNewElement->value.U8 = _channel;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkSettingsStateWifiSecurityChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE _type, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkSettingsStateWifiSecurityChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITYCHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementNetworkSettingsStateWifiSecurity (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE _type, char * _key, eARCOMMANDS_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE _keyType, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkSettingsStateWifiSecurity -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEY;
            strLength = strlen (_key);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _key, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_NETWORKSETTINGSSTATE_WIFISECURITY_KEYTYPE;
            argDictNewElement->value.I32 = _keyType;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateProductMotorVersionListChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _motor_number, char * _type, char * _software, char * _hardware, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateProductMotorVersionListChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = snprintf (NULL, 0, "%"PRIu8, _motor_number);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            snprintf (newElement->key, (elementKeyLength + 1), "%"PRIu8, _motor_number);
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_MOTOR_NUMBER;
            argDictNewElement->value.U8 = _motor_number;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_TYPE;
            strLength = strlen (_type);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _type, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_SOFTWARE;
            strLength = strlen (_software);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _software, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTMOTORVERSIONLISTCHANGED_HARDWARE;
            strLength = strlen (_hardware);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _hardware, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateProductGPSVersionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, char * _software, char * _hardware, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateProductGPSVersionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_SOFTWARE;
            strLength = strlen (_software);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _software, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_HARDWARE;
            strLength = strlen (_hardware);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _hardware, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorErrorStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _motorIds, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR _motorError, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateMotorErrorStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORIDS;
            argDictNewElement->value.U8 = _motorIds;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORSTATECHANGED_MOTORERROR;
            argDictNewElement->value.I32 = _motorError;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorSoftwareVersionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, char * _version, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateMotorSoftwareVersionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORSOFTWAREVERSIONCHANGED_VERSION;
            strLength = strlen (_version);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _version, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorFlightsStatusChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t _nbFlights, uint16_t _lastFlightDuration, uint32_t _totalFlightDuration, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateMotorFlightsStatusChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_NBFLIGHTS;
            argDictNewElement->value.U16 = _nbFlights;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_LASTFLIGHTDURATION;
            argDictNewElement->value.U16 = _lastFlightDuration;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U32;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORFLIGHTSSTATUSCHANGED_TOTALFLIGHTDURATION;
            argDictNewElement->value.U32 = _totalFlightDuration;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateMotorErrorLastErrorChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR _motorError, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateMotorErrorLastErrorChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_MOTORERRORLASTERRORCHANGED_MOTORERROR;
            argDictNewElement->value.I32 = _motorError;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementSettingsStateP7ID (ARCONTROLLER_FEATURE_ARDrone3_t *feature, char * _serialID, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateP7ID -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_SETTINGSSTATE_P7ID_SERIALID;
            strLength = strlen (_serialID);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _serialID, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStatePictureFormatChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE _type, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStatePictureFormatChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_PICTUREFORMATCHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateAutoWhiteBalanceChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE _type, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStateAutoWhiteBalanceChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_AUTOWHITEBALANCECHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateExpositionChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStateExpositionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_EXPOSITIONCHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateSaturationChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, float _value, float _min, float _max, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStateSaturationChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_VALUE;
            argDictNewElement->value.Float = _value;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_MIN;
            argDictNewElement->value.Float = _min;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_SATURATIONCHANGED_MAX;
            argDictNewElement->value.Float = _max;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateTimelapseChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _enabled, float _interval, float _minInterval, float _maxInterval, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStateTimelapseChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_ENABLED;
            argDictNewElement->value.U8 = _enabled;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_INTERVAL;
            argDictNewElement->value.Float = _interval;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_MININTERVAL;
            argDictNewElement->value.Float = _minInterval;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_FLOAT;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_TIMELAPSECHANGED_MAXINTERVAL;
            argDictNewElement->value.Float = _maxInterval;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateVideoAutorecordChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _enabled, uint8_t _mass_storage_id, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStateVideoAutorecordChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED_ENABLED;
            argDictNewElement->value.U8 = _enabled;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOAUTORECORDCHANGED_MASS_STORAGE_ID;
            argDictNewElement->value.U8 = _mass_storage_id;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPictureSettingsStateVideoStabilizationModeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE _mode, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PictureSettingsStateVideoStabilizationModeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PICTURESETTINGSSTATE_VIDEOSTABILIZATIONMODECHANGED_MODE;
            argDictNewElement->value.I32 = _mode;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementMediaStreamingStateVideoEnableChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaStreamingStateVideoEnableChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED;
            argDictNewElement->value.I32 = _enabled;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateHomeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double _latitude, double _longitude, double _altitude, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSSettingsStateHomeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_LATITUDE;
            argDictNewElement->value.Double = _latitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_LONGITUDE;
            argDictNewElement->value.Double = _longitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMECHANGED_ALTITUDE;
            argDictNewElement->value.Double = _altitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateResetHomeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, double _latitude, double _longitude, double _altitude, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSSettingsStateResetHomeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_LATITUDE;
            argDictNewElement->value.Double = _latitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_LONGITUDE;
            argDictNewElement->value.Double = _longitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_DOUBLE;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RESETHOMECHANGED_ALTITUDE;
            argDictNewElement->value.Double = _altitude;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateGPSFixStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _fixed, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSSettingsStateGPSFixStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSFIXSTATECHANGED_FIXED;
            argDictNewElement->value.U8 = _fixed;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateGPSUpdateStateChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSSettingsStateGPSUpdateStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_GPSUPDATESTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateHomeTypeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE _type, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSSettingsStateHomeTypeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_HOMETYPECHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSSettingsStateReturnHomeDelayChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint16_t _delay, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSSettingsStateReturnHomeDelayChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSETTINGSSTATE_RETURNHOMEDELAYCHANGED_DELAY;
            argDictNewElement->value.U16 = _delay;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementCameraStateOrientation (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t _tilt, int8_t _pan, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event CameraStateOrientation -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION_TILT;
            argDictNewElement->value.I8 = _tilt;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_ORIENTATION_PAN;
            argDictNewElement->value.I8 = _pan;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementCameraStateDefaultCameraOrientation (ARCONTROLLER_FEATURE_ARDrone3_t *feature, int8_t _tilt, int8_t _pan, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event CameraStateDefaultCameraOrientation -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION_TILT;
            argDictNewElement->value.I8 = _tilt;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_CAMERASTATE_DEFAULTCAMERAORIENTATION_PAN;
            argDictNewElement->value.I8 = _pan;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementAntiflickeringStateElectricFrequencyChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY _frequency, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AntiflickeringStateElectricFrequencyChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_ELECTRICFREQUENCYCHANGED_FREQUENCY;
            argDictNewElement->value.I32 = _frequency;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementAntiflickeringStateModeChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE _mode, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AntiflickeringStateModeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_ANTIFLICKERINGSTATE_MODECHANGED_MODE;
            argDictNewElement->value.I32 = _mode;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSStateNumberOfSatelliteChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint8_t _numberOfSatellite, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSStateNumberOfSatelliteChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_NUMBEROFSATELLITECHANGED_NUMBEROFSATELLITE;
            argDictNewElement->value.U8 = _numberOfSatellite;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSStateHomeTypeAvailabilityChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE _type, uint8_t _available, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSStateHomeTypeAvailabilityChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = snprintf (NULL, 0, "%d", _type);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            snprintf (newElement->key, (elementKeyLength + 1), "%d", _type);
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPEAVAILABILITYCHANGED_AVAILABLE;
            argDictNewElement->value.U8 = _available;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementGPSStateHomeTypeChosenChanged (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCOMMANDS_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE _type, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event GPSStateHomeTypeChosenChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_GPSSTATE_HOMETYPECHOSENCHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_NewCmdElementPROStateFeatures (ARCONTROLLER_FEATURE_ARDrone3_t *feature, uint64_t _features, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PROStateFeatures -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U64;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_ARDRONE3_PROSTATE_FEATURES_FEATURES;
            argDictNewElement->value.U64 = _features;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_ARDrone3_SetNetworkController (ARCONTROLLER_FEATURE_ARDrone3_t *feature, ARCONTROLLER_Network_t *networkController)
{
    // -- Set a NetworkController to use to send commands. --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->networkController = networkController;
    }
    
    return error;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_ARDrone3_GetCommandElements (ARCONTROLLER_FEATURE_ARDrone3_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error)
{
    // -- Get Command Arguments --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *commandDic = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *elements = NULL;
    
    // Check parameters
    if ((feature == NULL) ||
        (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        // Find elements
        HASH_FIND_INT (feature->privatePart->dictionary, &(commandKey), commandDic);
        if (commandDic != NULL)
        {
            elements = commandDic->elements;
        }
        // NO Else ; Command not found 
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (elements == NULL)
        {
            localError = ARCONTROLLER_ERROR_NO_ELEMENT;
        }
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return elements;
}

/************************
 * Private Implementation
 *************************/
/*******************************
 * --- FEATURE JumpingSumo --- 
 ******************************/

/*************************
 * Private header
 *************************/

/*************************
 * Implementation
 *************************/

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE = "arcontroller_dictionary_key_jumpingsumo_pilotingstate_posturechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE = "arcontroller_dictionary_key_jumpingsumo_pilotingstate_alertstatechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED_SPEED = "arcontroller_dictionary_key_jumpingsumo_pilotingstate_speedchanged_speed";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED_REALSPEED = "arcontroller_dictionary_key_jumpingsumo_pilotingstate_speedchanged_realspeed";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE = "arcontroller_dictionary_key_jumpingsumo_animationsstate_jumploadchanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE = "arcontroller_dictionary_key_jumpingsumo_animationsstate_jumptypechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR = "arcontroller_dictionary_key_jumpingsumo_animationsstate_jumpmotorproblemchanged_error";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_SOFTWARE = "arcontroller_dictionary_key_jumpingsumo_settingsstate_productgpsversionchanged_software";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_HARDWARE = "arcontroller_dictionary_key_jumpingsumo_settingsstate_productgpsversionchanged_hardware";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_picturestatechanged_state";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_picturestatechanged_mass_storage_id";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_videostatechanged_state";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_MASS_STORAGE_ID = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_videostatechanged_mass_storage_id";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_picturestatechangedv2_state";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_picturestatechangedv2_error";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_videostatechangedv2_state";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR = "arcontroller_dictionary_key_jumpingsumo_mediarecordstate_videostatechangedv2_error";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT = "arcontroller_dictionary_key_jumpingsumo_mediarecordevent_pictureeventchanged_event";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR = "arcontroller_dictionary_key_jumpingsumo_mediarecordevent_pictureeventchanged_error";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT = "arcontroller_dictionary_key_jumpingsumo_mediarecordevent_videoeventchanged_event";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR = "arcontroller_dictionary_key_jumpingsumo_mediarecordevent_videoeventchanged_error";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE = "arcontroller_dictionary_key_jumpingsumo_networksettingsstate_wifiselectionchanged_type";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND = "arcontroller_dictionary_key_jumpingsumo_networksettingsstate_wifiselectionchanged_band";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL = "arcontroller_dictionary_key_jumpingsumo_networksettingsstate_wifiselectionchanged_channel";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_SSID = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiscanlistchanged_ssid";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_RSSI = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiscanlistchanged_rssi";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiscanlistchanged_band";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_CHANNEL = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiscanlistchanged_channel";


const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiauthchannellistchanged_band";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiauthchannellistchanged_channel";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT = "arcontroller_dictionary_key_jumpingsumo_networkstate_wifiauthchannellistchanged_in_or_out";


const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED_QUALITY = "arcontroller_dictionary_key_jumpingsumo_networkstate_linkqualitychanged_quality";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED_VOLUME = "arcontroller_dictionary_key_jumpingsumo_audiosettingsstate_mastervolumechanged_volume";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME = "arcontroller_dictionary_key_jumpingsumo_audiosettingsstate_themechanged_theme";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_UUID = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptmetadatalistchanged_uuid";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_VERSION = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptmetadatalistchanged_version";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_PRODUCT = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptmetadatalistchanged_product";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_NAME = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptmetadatalistchanged_name";
const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_LASTMODIFIED = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptmetadatalistchanged_lastmodified";


const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptuploadchanged_resultcode";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_scriptdeletechanged_resultcode";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE = "arcontroller_dictionary_key_jumpingsumo_roadplanstate_playscriptchanged_resultcode";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED_OUTDOOR = "arcontroller_dictionary_key_jumpingsumo_speedsettingsstate_outdoorchanged_outdoor";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED = "arcontroller_dictionary_key_jumpingsumo_mediastreamingstate_videoenablechanged_enabled";

const char *ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED_ENABLED = "arcontroller_dictionary_key_jumpingsumo_videosettingsstate_autorecordchanged_enabled";

ARCONTROLLER_FEATURE_JumpingSumo_t *ARCONTROLLER_FEATURE_JumpingSumo_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error)
{
    // -- Create a new Feature Controller --
    
    //local declarations
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
   ARCONTROLLER_FEATURE_JumpingSumo_t *featureController =  NULL;
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller
        featureController = malloc (sizeof (ARCONTROLLER_FEATURE_JumpingSumo_t));
        if (featureController != NULL)
        {
            featureController->sendPilotingPCMD = ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPCMD;
            featureController->setPilotingPCMD = ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMD;
            featureController->setPilotingPCMDFlag = ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDFlag;
            featureController->setPilotingPCMDSpeed = ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDSpeed;
            featureController->setPilotingPCMDTurn = ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDTurn;
            featureController->sendPilotingPosture = ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPosture;
            featureController->sendPilotingAddCapOffset = ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingAddCapOffset;
            featureController->sendAnimationsJumpStop = ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpStop;
            featureController->sendAnimationsJumpCancel = ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpCancel;
            featureController->sendAnimationsJumpLoad = ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpLoad;
            featureController->sendAnimationsJump = ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJump;
            featureController->sendAnimationsSimpleAnimation = ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsSimpleAnimation;
            featureController->sendMediaRecordPicture = ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPicture;
            featureController->sendMediaRecordVideo = ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideo;
            featureController->sendMediaRecordPictureV2 = ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPictureV2;
            featureController->sendMediaRecordVideoV2 = ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideoV2;
            featureController->sendNetworkSettingsWifiSelection = ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkSettingsWifiSelection;
            featureController->sendNetworkWifiScan = ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiScan;
            featureController->sendNetworkWifiAuthChannel = ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiAuthChannel;
            featureController->sendAudioSettingsMasterVolume = ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsMasterVolume;
            featureController->sendAudioSettingsTheme = ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsTheme;
            featureController->sendRoadPlanAllScriptsMetadata = ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanAllScriptsMetadata;
            featureController->sendRoadPlanScriptUploaded = ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptUploaded;
            featureController->sendRoadPlanScriptDelete = ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptDelete;
            featureController->sendRoadPlanPlayScript = ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanPlayScript;
            featureController->sendSpeedSettingsOutdoor = ARCONTROLLER_FEATURE_JumpingSumo_SendSpeedSettingsOutdoor;
            featureController->sendMediaStreamingVideoEnable = ARCONTROLLER_FEATURE_JumpingSumo_SendMediaStreamingVideoEnable;
            featureController->sendVideoSettingsAutorecord = ARCONTROLLER_FEATURE_JumpingSumo_SendVideoSettingsAutorecord;
            
            featureController->privatePart = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller private part
        featureController->privatePart = malloc (sizeof (ARCONTROLLER_FEATURE_JumpingSumo_Private_t));
        if (featureController->privatePart != NULL)
        {
            featureController->privatePart->networkController = networkController;
            featureController->privatePart->dictionary = NULL;
            featureController->privatePart->commandCallbacks = NULL;
            featureController->privatePart->PilotingPCMDParameters = NULL;
            // Create the mutex 
            if (ARSAL_Mutex_Init (&(featureController->privatePart->mutex)) != 0)
            {
                localError = ARCONTROLLER_ERROR_INIT_MUTEX;
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        featureController->privatePart->PilotingPCMDParameters = calloc (1, sizeof (ARCONTROLLER_JumpingSumo_PilotingPCMDParameters_t));
        if (featureController->privatePart->PilotingPCMDParameters == NULL)
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        localError = ARCONTROLLER_FEATURE_JumpingSumo_RegisterARCommands (featureController);
    }
    // No else: skipped by an error 
    
    // delete the feature Controller if an error occurred
    if (localError != ARCONTROLLER_OK)
    {
        ARCONTROLLER_FEATURE_JumpingSumo_Delete (&featureController);
    }
    // No else: skipped no error 
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return featureController;
}

void ARCONTROLLER_FEATURE_JumpingSumo_Delete (ARCONTROLLER_FEATURE_JumpingSumo_t **feature)
{
    // -- Delete the JumpingSumo feature Controller --
    
    if (feature != NULL)
    {
        if ((*feature) != NULL)
        {
            ARCONTROLLER_FEATURE_JumpingSumo_UnregisterARCommands ((*feature));
            
            if ((*feature)->privatePart != NULL)
            {
                ARSAL_Mutex_Destroy (&((*feature)->privatePart->mutex));
                
                if ((*feature)->privatePart->dictionary != NULL)
                {
                    ARCONTROLLER_Feature_DeleteCommandsDictionary (&((*feature)->privatePart->dictionary));
                }
                
                if ((*feature)->privatePart->commandCallbacks != NULL)
                {
                    // Free the hash table contents the command callback
                    ARCONTROLLER_Dictionary_DeleteDictionary (&((*feature)->privatePart->commandCallbacks));
                }
                
                if ((*feature)->privatePart->PilotingPCMDParameters != NULL)
                {
                    free ((*feature)->privatePart->PilotingPCMDParameters);
                    (*feature)->privatePart->PilotingPCMDParameters = NULL;
                }
                free ((*feature)->privatePart);
                (*feature)->privatePart = NULL;
            }
            
            free (*feature);
            (*feature) = NULL;
        }
    }
}

ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_JumpingSumo_GetDictionary (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Get the dictionary of the JumpingSumo Feature Controller --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictionary = NULL;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        dictionary = feature->privatePart->dictionary;
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return dictionary;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_AddCallback (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Add a callback to use when a command in project <code>JumpingSumo</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_AddDictionaryElement (&(feature->privatePart->commandCallbacks), commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_RemoveCallback (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Remove a callback to use when a command in project <code>JumpingSumo</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_RemoveDictionaryElement (feature->privatePart->commandCallbacks, commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_RegisterARCommands (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Register the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARCOMMANDS_Decoder_SetJumpingSumoPilotingStatePostureChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_PilotingStatePostureChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateAlertStateChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_PilotingStateAlertStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateSpeedChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_PilotingStateSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpLoadChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_AnimationsStateJumpLoadChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpTypeChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_AnimationsStateJumpTypeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpMotorProblemChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_AnimationsStateJumpMotorProblemChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoSettingsStateProductGPSVersionChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_SettingsStateProductGPSVersionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStatePictureStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStateVideoStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedV2Callback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStatePictureStateChangedV2Callback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedV2Callback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStateVideoStateChangedV2Callback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventPictureEventChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordEventPictureEventChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventVideoEventChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordEventVideoEventChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_NetworkSettingsStateWifiSelectionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiScanListChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateWifiScanListChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiScanChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateAllWifiScanChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiAuthChannelListChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateWifiAuthChannelListChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateAllWifiAuthChannelChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateLinkQualityChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateLinkQualityChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateMasterVolumeChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_AudioSettingsStateMasterVolumeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateThemeChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_AudioSettingsStateThemeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptMetadataListChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateScriptMetadataListChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateAllScriptsMetadataChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptUploadChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateScriptUploadChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptDeleteChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateScriptDeleteChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStatePlayScriptChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStatePlayScriptChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoSpeedSettingsStateOutdoorChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_SpeedSettingsStateOutdoorChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaStreamingStateVideoEnableChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_MediaStreamingStateVideoEnableChangedCallback, feature);
        ARCOMMANDS_Decoder_SetJumpingSumoVideoSettingsStateAutorecordChangedCallback (&ARCONTROLLER_FEATURE_JumpingSumo_VideoSettingsStateAutorecordChangedCallback, feature);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_UnregisterARCommands (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Unregister the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARCOMMANDS_Decoder_SetJumpingSumoPilotingStatePostureChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateAlertStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoPilotingStateSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpLoadChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpTypeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoAnimationsStateJumpMotorProblemChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoSettingsStateProductGPSVersionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStatePictureStateChangedV2Callback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordStateVideoStateChangedV2Callback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventPictureEventChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaRecordEventVideoEventChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkSettingsStateWifiSelectionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiScanListChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiScanChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateWifiAuthChannelListChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateAllWifiAuthChannelChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoNetworkStateLinkQualityChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateMasterVolumeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoAudioSettingsStateThemeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptMetadataListChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateAllScriptsMetadataChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptUploadChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStateScriptDeleteChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoRoadPlanStatePlayScriptChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoSpeedSettingsStateOutdoorChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoMediaStreamingStateVideoEnableChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetJumpingSumoVideoSettingsStateAutorecordChangedCallback (NULL, NULL);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPCMD (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t flag, int8_t speed, int8_t turn)
{
    // -- Send a command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PCMD command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPCMD(cmdBuffer, sizeof(cmdBuffer), &cmdSize, flag, speed, turn);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMD (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _flag, int8_t _speed, int8_t _turn)
{
    // -- Set the parameter for the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->flag = _flag;
        feature->privatePart->PilotingPCMDParameters->speed = _speed;
        feature->privatePart->PilotingPCMDParameters->turn = _turn;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_JumpingSumo_SendPilotingPCMDStruct (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize)
{
    // -- Send the a command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> with the parame set beforehand  --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    int32_t cmdSize = 0;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL) ||
       (cmdBuffer == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PCMD command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPCMD(cmdBuffer, cmdBufferSize, &cmdSize, feature->privatePart->PilotingPCMDParameters->flag, feature->privatePart->PilotingPCMDParameters->speed, feature->privatePart->PilotingPCMDParameters->turn);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
        if (netError != ARNETWORK_OK)
        {
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_FEATURE_TAG, "Network sending error : %s", ARNETWORK_Error_ToString (netError));
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDFlag (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _flag)
{
    // -- Set the flag for the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->flag = _flag;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDSpeed (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, int8_t _speed)
{
    // -- Set the speed for the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->speed = _speed;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SetPilotingPCMDTurn (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, int8_t _turn)
{
    // -- Set the turn for the command <code>PilotingPCMD</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->turn = _turn;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingPosture (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_PILOTING_POSTURE_TYPE type)
{
    // -- Send a command <code>PilotingPosture</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Posture command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingPosture(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendPilotingAddCapOffset (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, float offset)
{
    // -- Send a command <code>PilotingAddCapOffset</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send AddCapOffset command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoPilotingAddCapOffset(cmdBuffer, sizeof(cmdBuffer), &cmdSize, offset);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpStop (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Send a command <code>AnimationsJumpStop</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send JumpStop command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpStop(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_HIGH_PRIORITY, ARNETWORK_MANAGER_CALLBACK_RETURN_RETRY, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpCancel (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Send a command <code>AnimationsJumpCancel</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send JumpCancel command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpCancel(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJumpLoad (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Send a command <code>AnimationsJumpLoad</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send JumpLoad command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJumpLoad(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsJump (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_JUMP_TYPE type)
{
    // -- Send a command <code>AnimationsJump</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Jump command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsJump(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAnimationsSimpleAnimation (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONS_SIMPLEANIMATION_ID id)
{
    // -- Send a command <code>AnimationsSimpleAnimation</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send SimpleAnimation command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAnimationsSimpleAnimation(cmdBuffer, sizeof(cmdBuffer), &cmdSize, id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPicture (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t mass_storage_id)
{
    // -- Send a command <code>MediaRecordPicture</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Picture command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPicture(cmdBuffer, sizeof(cmdBuffer), &cmdSize, mass_storage_id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideo (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEO_RECORD record, uint8_t mass_storage_id)
{
    // -- Send a command <code>MediaRecordVideo</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Video command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideo(cmdBuffer, sizeof(cmdBuffer), &cmdSize, record, mass_storage_id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordPictureV2 (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Send a command <code>MediaRecordPictureV2</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PictureV2 command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordPictureV2(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendMediaRecordVideoV2 (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORD_VIDEOV2_RECORD record)
{
    // -- Send a command <code>MediaRecordVideoV2</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send VideoV2 command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoMediaRecordVideoV2(cmdBuffer, sizeof(cmdBuffer), &cmdSize, record);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkSettingsWifiSelection (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_TYPE type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGS_WIFISELECTION_BAND band, uint8_t channel)
{
    // -- Send a command <code>NetworkSettingsWifiSelection</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiSelection command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkSettingsWifiSelection(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type, band, channel);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiScan (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_NETWORK_WIFISCAN_BAND band)
{
    // -- Send a command <code>NetworkWifiScan</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiScan command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiScan(cmdBuffer, sizeof(cmdBuffer), &cmdSize, band);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendNetworkWifiAuthChannel (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Send a command <code>NetworkWifiAuthChannel</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send WifiAuthChannel command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoNetworkWifiAuthChannel(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsMasterVolume (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t volume)
{
    // -- Send a command <code>AudioSettingsMasterVolume</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MasterVolume command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsMasterVolume(cmdBuffer, sizeof(cmdBuffer), &cmdSize, volume);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendAudioSettingsTheme (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGS_THEME_THEME theme)
{
    // -- Send a command <code>AudioSettingsTheme</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Theme command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoAudioSettingsTheme(cmdBuffer, sizeof(cmdBuffer), &cmdSize, theme);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanAllScriptsMetadata (ARCONTROLLER_FEATURE_JumpingSumo_t *feature)
{
    // -- Send a command <code>RoadPlanAllScriptsMetadata</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send AllScriptsMetadata command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanAllScriptsMetadata(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptUploaded (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * uuid, char * md5Hash)
{
    // -- Send a command <code>RoadPlanScriptUploaded</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ScriptUploaded command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptUploaded(cmdBuffer, sizeof(cmdBuffer), &cmdSize, uuid, md5Hash);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanScriptDelete (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * uuid)
{
    // -- Send a command <code>RoadPlanScriptDelete</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ScriptDelete command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanScriptDelete(cmdBuffer, sizeof(cmdBuffer), &cmdSize, uuid);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendRoadPlanPlayScript (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * uuid)
{
    // -- Send a command <code>RoadPlanPlayScript</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PlayScript command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoRoadPlanPlayScript(cmdBuffer, sizeof(cmdBuffer), &cmdSize, uuid);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendSpeedSettingsOutdoor (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t outdoor)
{
    // -- Send a command <code>SpeedSettingsOutdoor</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Outdoor command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoSpeedSettingsOutdoor(cmdBuffer, sizeof(cmdBuffer), &cmdSize, outdoor);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendMediaStreamingVideoEnable (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t enable)
{
    // -- Send a command <code>MediaStreamingVideoEnable</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send VideoEnable command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoMediaStreamingVideoEnable(cmdBuffer, sizeof(cmdBuffer), &cmdSize, enable);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SendVideoSettingsAutorecord (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t enabled)
{
    // -- Send a command <code>VideoSettingsAutorecord</code> in project <code>JumpingSumo</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Autorecord command
        cmdError = ARCOMMANDS_Generator_GenerateJumpingSumoVideoSettingsAutorecord(cmdBuffer, sizeof(cmdBuffer), &cmdSize, enabled);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

void ARCONTROLLER_FEATURE_JumpingSumo_PilotingStatePostureChangedCallback (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>PilotingStatePostureChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementPilotingStatePostureChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_PilotingStateAlertStateChangedCallback (eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>PilotingStateAlertStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementPilotingStateAlertStateChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_PilotingStateSpeedChangedCallback (int8_t _speed, int16_t _realSpeed, void *customData)
{
    // -- callback used when the command <code>PilotingStateSpeedChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementPilotingStateSpeedChanged (feature,  _speed,  _realSpeed, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_AnimationsStateJumpLoadChangedCallback (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>AnimationsStateJumpLoadChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementAnimationsStateJumpLoadChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_AnimationsStateJumpTypeChangedCallback (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE _state, void *customData)
{
    // -- callback used when the command <code>AnimationsStateJumpTypeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementAnimationsStateJumpTypeChanged (feature,  _state, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_AnimationsStateJumpMotorProblemChangedCallback (eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR _error, void *customData)
{
    // -- callback used when the command <code>AnimationsStateJumpMotorProblemChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementAnimationsStateJumpMotorProblemChanged (feature,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_SettingsStateProductGPSVersionChangedCallback (char * _software, char * _hardware, void *customData)
{
    // -- callback used when the command <code>SettingsStateProductGPSVersionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementSettingsStateProductGPSVersionChanged (feature,  _software,  _hardware, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStatePictureStateChangedCallback (uint8_t _state, uint8_t _mass_storage_id, void *customData)
{
    // -- callback used when the command <code>MediaRecordStatePictureStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStatePictureStateChanged (feature,  _state,  _mass_storage_id, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStateVideoStateChangedCallback (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id, void *customData)
{
    // -- callback used when the command <code>MediaRecordStateVideoStateChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStateVideoStateChanged (feature,  _state,  _mass_storage_id, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStatePictureStateChangedV2Callback (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordStatePictureStateChangedV2</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStatePictureStateChangedV2 (feature,  _state,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordStateVideoStateChangedV2Callback (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordStateVideoStateChangedV2</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStateVideoStateChangedV2 (feature,  _state,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordEventPictureEventChangedCallback (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordEventPictureEventChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordEventPictureEventChanged (feature,  _event,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaRecordEventVideoEventChangedCallback (eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error, void *customData)
{
    // -- callback used when the command <code>MediaRecordEventVideoEventChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordEventVideoEventChanged (feature,  _event,  _error, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_NetworkSettingsStateWifiSelectionChangedCallback (eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel, void *customData)
{
    // -- callback used when the command <code>NetworkSettingsStateWifiSelectionChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementNetworkSettingsStateWifiSelectionChanged (feature,  _type,  _band,  _channel, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateWifiScanListChangedCallback (char * _ssid, int16_t _rssi, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel, void *customData)
{
    // -- callback used when the command <code>NetworkStateWifiScanListChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateWifiScanListChanged (feature,  _ssid,  _rssi,  _band,  _channel, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateAllWifiScanChangedCallback (void *customData)
{
    // -- callback used when the command <code>NetworkStateAllWifiScanChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFISCANCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateAllWifiScanChanged (feature, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateWifiAuthChannelListChangedCallback (eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out, void *customData)
{
    // -- callback used when the command <code>NetworkStateWifiAuthChannelListChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int listIndex = 0;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        listIndex = HASH_COUNT (dictCmdElement->elements);
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateWifiAuthChannelListChanged (feature,  _band,  _channel,  _in_or_out, listIndex, 
&error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateAllWifiAuthChannelChangedCallback (void *customData)
{
    // -- callback used when the command <code>NetworkStateAllWifiAuthChannelChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_ALLWIFIAUTHCHANNELCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateAllWifiAuthChannelChanged (feature, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_NetworkStateLinkQualityChangedCallback (uint8_t _quality, void *customData)
{
    // -- callback used when the command <code>NetworkStateLinkQualityChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateLinkQualityChanged (feature,  _quality, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_AudioSettingsStateMasterVolumeChangedCallback (uint8_t _volume, void *customData)
{
    // -- callback used when the command <code>AudioSettingsStateMasterVolumeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementAudioSettingsStateMasterVolumeChanged (feature,  _volume, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_AudioSettingsStateThemeChangedCallback (eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME _theme, void *customData)
{
    // -- callback used when the command <code>AudioSettingsStateThemeChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementAudioSettingsStateThemeChanged (feature,  _theme, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateScriptMetadataListChangedCallback (char * _uuid, uint8_t _version, char * _product, char * _name, uint64_t _lastModified, void *customData)
{
    // -- callback used when the command <code>RoadPlanStateScriptMetadataListChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateScriptMetadataListChanged (feature,  _uuid,  _version,  _product,  _name,  _lastModified, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateAllScriptsMetadataChangedCallback (void *customData)
{
    // -- callback used when the command <code>RoadPlanStateAllScriptsMetadataChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_ALLSCRIPTSMETADATACHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateAllScriptsMetadataChanged (feature, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateScriptUploadChangedCallback (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE _resultCode, void *customData)
{
    // -- callback used when the command <code>RoadPlanStateScriptUploadChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateScriptUploadChanged (feature,  _resultCode, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStateScriptDeleteChangedCallback (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE _resultCode, void *customData)
{
    // -- callback used when the command <code>RoadPlanStateScriptDeleteChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateScriptDeleteChanged (feature,  _resultCode, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_RoadPlanStatePlayScriptChangedCallback (eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE _resultCode, void *customData)
{
    // -- callback used when the command <code>RoadPlanStatePlayScriptChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStatePlayScriptChanged (feature,  _resultCode, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_SpeedSettingsStateOutdoorChangedCallback (uint8_t _outdoor, void *customData)
{
    // -- callback used when the command <code>SpeedSettingsStateOutdoorChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementSpeedSettingsStateOutdoorChanged (feature,  _outdoor, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_MediaStreamingStateVideoEnableChangedCallback (eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled, void *customData)
{
    // -- callback used when the command <code>MediaStreamingStateVideoEnableChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementMediaStreamingStateVideoEnableChanged (feature,  _enabled, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

void ARCONTROLLER_FEATURE_JumpingSumo_VideoSettingsStateAutorecordChangedCallback (uint8_t _enabled, void *customData)
{
    // -- callback used when the command <code>VideoSettingsStateAutorecordChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_JumpingSumo_t *feature = (ARCONTROLLER_FEATURE_JumpingSumo_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
    int elementAdded = 0;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Find command elements
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        HASH_FIND_INT (feature->privatePart->dictionary, &commandKey, dictCmdElement);
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (dictCmdElement == NULL)
        {
            // New command element
            isANewCommandElement = 1;
            dictCmdElement = ARCONTROLLER_Feature_NewCommandsElement (commandKey, &error);
        }
        // No Else ; commandElement already exists.
        
    }
    
    if (error == ARCONTROLLER_OK)
    {
        //Create new element
        newElement = ARCONTROLLER_JumpingSumo_NewCmdElementVideoSettingsStateAutorecordChanged (feature,  _enabled, &error);
    }
    
    //Set new element in CommandElements 
    if (error == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        ARCONTROLLER_Feature_AddElement (&(dictCmdElement->elements), newElement);
        
        //Add new commandElement if necessary
        if (isANewCommandElement)
        {
            HASH_ADD_INT (feature->privatePart->dictionary, command, dictCmdElement);
        }
        
        elementAdded = 1;
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    if (error == ARCONTROLLER_OK)
    {
        // Notification Callback
        error = ARCONTROLLER_Dictionary_Notify (feature->privatePart->commandCallbacks, dictCmdElement->command, dictCmdElement->elements);
    }
    
    // if an error occurred 
    if (error != ARCONTROLLER_OK)
    {
        // cleanup
        if ((dictCmdElement != NULL) && (isANewCommandElement))
        {
            ARCONTROLLER_Feature_DeleteCommandsElement(&dictCmdElement);
        }
        
        if ((newElement != NULL) && (!elementAdded ))
        {
            ARCONTROLLER_Feature_DeleteElement (&newElement);
        }
        
    }
    
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementPilotingStatePostureChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStatePostureChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_POSTURECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementPilotingStateAlertStateChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateAlertStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_ALERTSTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementPilotingStateSpeedChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, int8_t _speed, int16_t _realSpeed, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event PilotingStateSpeedChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED_SPEED;
            argDictNewElement->value.I8 = _speed;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_PILOTINGSTATE_SPEEDCHANGED_REALSPEED;
            argDictNewElement->value.I16 = _realSpeed;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementAnimationsStateJumpLoadChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AnimationsStateJumpLoadChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPLOADCHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementAnimationsStateJumpTypeChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE _state, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AnimationsStateJumpTypeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPTYPECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementAnimationsStateJumpMotorProblemChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AnimationsStateJumpMotorProblemChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ANIMATIONSSTATE_JUMPMOTORPROBLEMCHANGED_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementSettingsStateProductGPSVersionChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * _software, char * _hardware, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SettingsStateProductGPSVersionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_SOFTWARE;
            strLength = strlen (_software);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _software, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SETTINGSSTATE_PRODUCTGPSVERSIONCHANGED_HARDWARE;
            strLength = strlen (_hardware);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _hardware, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStatePictureStateChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _state, uint8_t _mass_storage_id, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStatePictureStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE;
            argDictNewElement->value.U8 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID;
            argDictNewElement->value.U8 = _mass_storage_id;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStateVideoStateChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE _state, uint8_t _mass_storage_id, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStateVideoStateChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGED_MASS_STORAGE_ID;
            argDictNewElement->value.U8 = _mass_storage_id;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStatePictureStateChangedV2 (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStatePictureStateChangedV2 -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordStateVideoStateChangedV2 (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE _state, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordStateVideoStateChangedV2 -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_STATE;
            argDictNewElement->value.I32 = _state;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDSTATE_VIDEOSTATECHANGEDV2_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordEventPictureEventChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordEventPictureEventChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT;
            argDictNewElement->value.I32 = _event;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaRecordEventVideoEventChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT _event, eARCOMMANDS_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR _error, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaRecordEventVideoEventChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_EVENT;
            argDictNewElement->value.I32 = _event;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIARECORDEVENT_VIDEOEVENTCHANGED_ERROR;
            argDictNewElement->value.I32 = _error;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementNetworkSettingsStateWifiSelectionChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE _type, eARCOMMANDS_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND _band, uint8_t _channel, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkSettingsStateWifiSelectionChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_TYPE;
            argDictNewElement->value.I32 = _type;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_BAND;
            argDictNewElement->value.I32 = _band;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSETTINGSSTATE_WIFISELECTIONCHANGED_CHANNEL;
            argDictNewElement->value.U8 = _channel;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateWifiScanListChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * _ssid, int16_t _rssi, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND _band, uint8_t _channel, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateWifiScanListChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (_ssid);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, _ssid, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_SSID;
            strLength = strlen (_ssid);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _ssid, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_I16;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_RSSI;
            argDictNewElement->value.I16 = _rssi;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_BAND;
            argDictNewElement->value.I32 = _band;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFISCANLISTCHANGED_CHANNEL;
            argDictNewElement->value.U8 = _channel;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateAllWifiScanChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateAllWifiScanChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateWifiAuthChannelListChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND _band, uint8_t _channel, uint8_t _in_or_out, int listIndex, 
eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateWifiAuthChannelListChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        //Alloc Element Key
        elementKeyLength = snprintf (NULL, 0, "%d", listIndex);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            snprintf (newElement->key, (elementKeyLength + 1), "%d", listIndex);
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_BAND;
            argDictNewElement->value.I32 = _band;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_CHANNEL;
            argDictNewElement->value.U8 = _channel;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_WIFIAUTHCHANNELLISTCHANGED_IN_OR_OUT;
            argDictNewElement->value.U8 = _in_or_out;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateAllWifiAuthChannelChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateAllWifiAuthChannelChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementNetworkStateLinkQualityChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _quality, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event NetworkStateLinkQualityChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_NETWORKSTATE_LINKQUALITYCHANGED_QUALITY;
            argDictNewElement->value.U8 = _quality;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementAudioSettingsStateMasterVolumeChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _volume, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AudioSettingsStateMasterVolumeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_MASTERVOLUMECHANGED_VOLUME;
            argDictNewElement->value.U8 = _volume;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementAudioSettingsStateThemeChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME _theme, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event AudioSettingsStateThemeChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_AUDIOSETTINGSSTATE_THEMECHANGED_THEME;
            argDictNewElement->value.I32 = _theme;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateScriptMetadataListChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, char * _uuid, uint8_t _version, char * _product, char * _name, uint64_t _lastModified, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event RoadPlanStateScriptMetadataListChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    int strLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (_uuid);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, _uuid, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_UUID;
            strLength = strlen (_uuid);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _uuid, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_VERSION;
            argDictNewElement->value.U8 = _version;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_PRODUCT;
            strLength = strlen (_product);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _product, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_STRING;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_NAME;
            strLength = strlen (_name);
            argDictNewElement->value.String = malloc (strLength + 1);
            if (argDictNewElement->value.String != NULL)
            {
                strncpy (argDictNewElement->value.String, _name, strLength);
                argDictNewElement->value.String[strLength] = '\0';
            }
            else
            {
                localError = ARCONTROLLER_ERROR_ALLOC;
            }
            
            if (localError == ARCONTROLLER_OK)
            {
                HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U64;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTMETADATALISTCHANGED_LASTMODIFIED;
            argDictNewElement->value.U64 = _lastModified;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                if (newElement->arguments->value.String != NULL)
                {
                    free(newElement->arguments->value.String);
                    newElement->arguments->value.String = NULL;
                }
                
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateAllScriptsMetadataChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event RoadPlanStateAllScriptsMetadataChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateScriptUploadChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE _resultCode, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event RoadPlanStateScriptUploadChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTUPLOADCHANGED_RESULTCODE;
            argDictNewElement->value.I32 = _resultCode;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStateScriptDeleteChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE _resultCode, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event RoadPlanStateScriptDeleteChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_SCRIPTDELETECHANGED_RESULTCODE;
            argDictNewElement->value.I32 = _resultCode;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementRoadPlanStatePlayScriptChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE _resultCode, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event RoadPlanStatePlayScriptChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_ROADPLANSTATE_PLAYSCRIPTCHANGED_RESULTCODE;
            argDictNewElement->value.I32 = _resultCode;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementSpeedSettingsStateOutdoorChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _outdoor, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event SpeedSettingsStateOutdoorChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_SPEEDSETTINGSSTATE_OUTDOORCHANGED_OUTDOOR;
            argDictNewElement->value.U8 = _outdoor;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementMediaStreamingStateVideoEnableChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCOMMANDS_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED _enabled, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event MediaStreamingStateVideoEnableChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_ENUM;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_MEDIASTREAMINGSTATE_VIDEOENABLECHANGED_ENABLED;
            argDictNewElement->value.I32 = _enabled;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_NewCmdElementVideoSettingsStateAutorecordChanged (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, uint8_t _enabled, eARCONTROLLER_ERROR *error)
{
    // -- Create element of an event VideoSettingsStateAutorecordChanged -- 
    
    ARCONTROLLER_DICTIONARY_ELEMENT_t *newElement = NULL;
    int elementKeyLength = 0;
    ARCONTROLLER_DICTIONARY_ARG_t *argDictNewElement = NULL;
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    //Create Element Dictionary
    if (localError == ARCONTROLLER_OK)
    {
        // New element
        newElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ELEMENT_t));
        if (newElement != NULL)
        {
            newElement->key = NULL;
            newElement->arguments = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    if (localError == ARCONTROLLER_OK)
    {
        //Alloc Element Key
        elementKeyLength = strlen (ARCONTROLLER_DICTIONARY_SINGLE_KEY);
        newElement->key = malloc (elementKeyLength + 1);
        if (newElement->key != NULL)
        {
            strncpy (newElement->key, ARCONTROLLER_DICTIONARY_SINGLE_KEY, (elementKeyLength + 1));
            newElement->key[elementKeyLength] = '\0';
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    //Create argument Dictionary
    //Add argument To the element
    if (localError == ARCONTROLLER_OK)
    {
        // New argument element
        argDictNewElement = malloc (sizeof(ARCONTROLLER_DICTIONARY_ARG_t));
        if (argDictNewElement != NULL)
        {
            argDictNewElement->valueType = ARCONTROLLER_DICTIONARY_VALUE_TYPE_U8;
            argDictNewElement->argument = ARCONTROLLER_DICTIONARY_KEY_JUMPINGSUMO_VIDEOSETTINGSSTATE_AUTORECORDCHANGED_ENABLED;
            argDictNewElement->value.U8 = _enabled;
            
            HASH_ADD_KEYPTR (hh, newElement->arguments, argDictNewElement->argument, strlen(argDictNewElement->argument), argDictNewElement);
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    
    // If an error occurred 
    if (localError != ARCONTROLLER_OK)
    {
        // cleanup
        if (newElement != NULL)
        {
            if (newElement->arguments != NULL)
            {
                free (newElement->arguments);
                newElement->arguments = NULL;
            }
            
            if (newElement->key != NULL)
            {
                free (newElement->key);
                newElement->key = NULL;
            }
            
            free (newElement);
            newElement = NULL;
        }

        free (argDictNewElement);
        argDictNewElement = NULL;
    }
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return newElement;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_JumpingSumo_SetNetworkController (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, ARCONTROLLER_Network_t *networkController)
{
    // -- Set a NetworkController to use to send commands. --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->networkController = networkController;
    }
    
    return error;
}

ARCONTROLLER_DICTIONARY_ELEMENT_t *ARCONTROLLER_JumpingSumo_GetCommandElements (ARCONTROLLER_FEATURE_JumpingSumo_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, eARCONTROLLER_ERROR *error)
{
    // -- Get Command Arguments --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *commandDic = NULL;
    ARCONTROLLER_DICTIONARY_ELEMENT_t *elements = NULL;
    
    // Check parameters
    if ((feature == NULL) ||
        (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets localError to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        ARSAL_Mutex_Lock (&(feature->privatePart->mutex));
        
        // Find elements
        HASH_FIND_INT (feature->privatePart->dictionary, &(commandKey), commandDic);
        if (commandDic != NULL)
        {
            elements = commandDic->elements;
        }
        // NO Else ; Command not found 
        
        ARSAL_Mutex_Unlock (&(feature->privatePart->mutex));
        
        if (elements == NULL)
        {
            localError = ARCONTROLLER_ERROR_NO_ELEMENT;
        }
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return elements;
}

/************************
 * Private Implementation
 *************************/
/*******************************
 * --- FEATURE MiniDrone --- 
 ******************************/

/*************************
 * Private header
 *************************/

/*************************
 * Implementation
 *************************/


const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLYINGSTATECHANGED_STATE = "arcontroller_dictionary_key_minidrone_pilotingstate_flyingstatechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_ALERTSTATECHANGED_STATE = "arcontroller_dictionary_key_minidrone_pilotingstate_alertstatechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_AUTOTAKEOFFMODECHANGED_STATE = "arcontroller_dictionary_key_minidrone_pilotingstate_autotakeoffmodechanged_state";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED_STATE = "arcontroller_dictionary_key_minidrone_mediarecordstate_picturestatechanged_state";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGED_MASS_STORAGE_ID = "arcontroller_dictionary_key_minidrone_mediarecordstate_picturestatechanged_mass_storage_id";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_STATE = "arcontroller_dictionary_key_minidrone_mediarecordstate_picturestatechangedv2_state";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDSTATE_PICTURESTATECHANGEDV2_ERROR = "arcontroller_dictionary_key_minidrone_mediarecordstate_picturestatechangedv2_error";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_EVENT = "arcontroller_dictionary_key_minidrone_mediarecordevent_pictureeventchanged_event";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_MEDIARECORDEVENT_PICTUREEVENTCHANGED_ERROR = "arcontroller_dictionary_key_minidrone_mediarecordevent_pictureeventchanged_error";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_CURRENT = "arcontroller_dictionary_key_minidrone_pilotingsettingsstate_maxaltitudechanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MIN = "arcontroller_dictionary_key_minidrone_pilotingsettingsstate_maxaltitudechanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXALTITUDECHANGED_MAX = "arcontroller_dictionary_key_minidrone_pilotingsettingsstate_maxaltitudechanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_CURRENT = "arcontroller_dictionary_key_minidrone_pilotingsettingsstate_maxtiltchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MIN = "arcontroller_dictionary_key_minidrone_pilotingsettingsstate_maxtiltchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSETTINGSSTATE_MAXTILTCHANGED_MAX = "arcontroller_dictionary_key_minidrone_pilotingsettingsstate_maxtiltchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_CURRENT = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxverticalspeedchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MIN = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxverticalspeedchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXVERTICALSPEEDCHANGED_MAX = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxverticalspeedchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_CURRENT = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxrotationspeedchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MIN = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxrotationspeedchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXROTATIONSPEEDCHANGED_MAX = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxrotationspeedchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_WHEELSCHANGED_PRESENT = "arcontroller_dictionary_key_minidrone_speedsettingsstate_wheelschanged_present";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED_CURRENT = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxhorizontalspeedchanged_current";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED_MIN = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxhorizontalspeedchanged_min";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SPEEDSETTINGSSTATE_MAXHORIZONTALSPEEDCHANGED_MAX = "arcontroller_dictionary_key_minidrone_speedsettingsstate_maxhorizontalspeedchanged_max";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_MOTOR = "arcontroller_dictionary_key_minidrone_settingsstate_productmotorsversionchanged_motor";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_TYPE = "arcontroller_dictionary_key_minidrone_settingsstate_productmotorsversionchanged_type";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_SOFTWARE = "arcontroller_dictionary_key_minidrone_settingsstate_productmotorsversionchanged_software";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTMOTORSVERSIONCHANGED_HARDWARE = "arcontroller_dictionary_key_minidrone_settingsstate_productmotorsversionchanged_hardware";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED_SOFTWARE = "arcontroller_dictionary_key_minidrone_settingsstate_productinertialversionchanged_software";
const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_PRODUCTINERTIALVERSIONCHANGED_HARDWARE = "arcontroller_dictionary_key_minidrone_settingsstate_productinertialversionchanged_hardware";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_SETTINGSSTATE_CUTOUTMODECHANGED_ENABLE = "arcontroller_dictionary_key_minidrone_settingsstate_cutoutmodechanged_enable";

const char *ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_FLOODCONTROLSTATE_FLOODCONTROLCHANGED_DELAY = "arcontroller_dictionary_key_minidrone_floodcontrolstate_floodcontrolchanged_delay";

ARCONTROLLER_FEATURE_MiniDrone_t *ARCONTROLLER_FEATURE_MiniDrone_New (ARCONTROLLER_Network_t *networkController, eARCONTROLLER_ERROR *error)
{
    // -- Create a new Feature Controller --
    
    //local declarations
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
   ARCONTROLLER_FEATURE_MiniDrone_t *featureController =  NULL;
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller
        featureController = malloc (sizeof (ARCONTROLLER_FEATURE_MiniDrone_t));
        if (featureController != NULL)
        {
            featureController->sendPilotingFlatTrim = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingFlatTrim;
            featureController->sendPilotingTakeOff = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingTakeOff;
            featureController->sendPilotingPCMD = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingPCMD;
            featureController->setPilotingPCMD = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMD;
            featureController->setPilotingPCMDFlag = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDFlag;
            featureController->setPilotingPCMDRoll = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDRoll;
            featureController->setPilotingPCMDPitch = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDPitch;
            featureController->setPilotingPCMDYaw = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDYaw;
            featureController->setPilotingPCMDGaz = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDGaz;
            featureController->setPilotingPCMDTimestamp = ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDTimestamp;
            featureController->sendPilotingLanding = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingLanding;
            featureController->sendPilotingEmergency = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingEmergency;
            featureController->sendPilotingAutoTakeOffMode = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingAutoTakeOffMode;
            featureController->sendAnimationsFlip = ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsFlip;
            featureController->sendAnimationsCap = ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsCap;
            featureController->sendMediaRecordPicture = ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPicture;
            featureController->sendMediaRecordPictureV2 = ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPictureV2;
            featureController->sendPilotingSettingsMaxAltitude = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxAltitude;
            featureController->sendPilotingSettingsMaxTilt = ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxTilt;
            featureController->sendSpeedSettingsMaxVerticalSpeed = ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxVerticalSpeed;
            featureController->sendSpeedSettingsMaxRotationSpeed = ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxRotationSpeed;
            featureController->sendSpeedSettingsWheels = ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsWheels;
            featureController->sendSpeedSettingsMaxHorizontalSpeed = ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxHorizontalSpeed;
            featureController->sendSettingsCutOutMode = ARCONTROLLER_FEATURE_MiniDrone_SendSettingsCutOutMode;
            featureController->sendGPSControllerLatitudeForRun = ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLatitudeForRun;
            featureController->sendGPSControllerLongitudeForRun = ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLongitudeForRun;
            featureController->sendConfigurationControllerType = ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerType;
            featureController->sendConfigurationControllerName = ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerName;
            
            featureController->privatePart = NULL;
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        // Create the Feature Controller private part
        featureController->privatePart = malloc (sizeof (ARCONTROLLER_FEATURE_MiniDrone_Private_t));
        if (featureController->privatePart != NULL)
        {
            featureController->privatePart->networkController = networkController;
            featureController->privatePart->dictionary = NULL;
            featureController->privatePart->commandCallbacks = NULL;
            featureController->privatePart->PilotingPCMDParameters = NULL;
            // Create the mutex 
            if (ARSAL_Mutex_Init (&(featureController->privatePart->mutex)) != 0)
            {
                localError = ARCONTROLLER_ERROR_INIT_MUTEX;
            }
        }
        else
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        featureController->privatePart->PilotingPCMDParameters = calloc (1, sizeof (ARCONTROLLER_MiniDrone_PilotingPCMDParameters_t));
        if (featureController->privatePart->PilotingPCMDParameters == NULL)
        {
            localError = ARCONTROLLER_ERROR_ALLOC;
        }
    }
    // No else: skipped by an error 
    
    if (localError == ARCONTROLLER_OK)
    {
        localError = ARCONTROLLER_FEATURE_MiniDrone_RegisterARCommands (featureController);
    }
    // No else: skipped by an error 
    
    // delete the feature Controller if an error occurred
    if (localError != ARCONTROLLER_OK)
    {
        ARCONTROLLER_FEATURE_MiniDrone_Delete (&featureController);
    }
    // No else: skipped no error 
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return featureController;
}

void ARCONTROLLER_FEATURE_MiniDrone_Delete (ARCONTROLLER_FEATURE_MiniDrone_t **feature)
{
    // -- Delete the MiniDrone feature Controller --
    
    if (feature != NULL)
    {
        if ((*feature) != NULL)
        {
            ARCONTROLLER_FEATURE_MiniDrone_UnregisterARCommands ((*feature));
            
            if ((*feature)->privatePart != NULL)
            {
                ARSAL_Mutex_Destroy (&((*feature)->privatePart->mutex));
                
                if ((*feature)->privatePart->dictionary != NULL)
                {
                    ARCONTROLLER_Feature_DeleteCommandsDictionary (&((*feature)->privatePart->dictionary));
                }
                
                if ((*feature)->privatePart->commandCallbacks != NULL)
                {
                    // Free the hash table contents the command callback
                    ARCONTROLLER_Dictionary_DeleteDictionary (&((*feature)->privatePart->commandCallbacks));
                }
                
                if ((*feature)->privatePart->PilotingPCMDParameters != NULL)
                {
                    free ((*feature)->privatePart->PilotingPCMDParameters);
                    (*feature)->privatePart->PilotingPCMDParameters = NULL;
                }
                free ((*feature)->privatePart);
                (*feature)->privatePart = NULL;
            }
            
            free (*feature);
            (*feature) = NULL;
        }
    }
}

ARCONTROLLER_DICTIONARY_COMMANDS_t *ARCONTROLLER_FEATURE_MiniDrone_GetDictionary (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_ERROR *error)
{
    // -- Get the dictionary of the MiniDrone Feature Controller --
    
    eARCONTROLLER_ERROR localError = ARCONTROLLER_OK;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictionary = NULL;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        localError = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (localError == ARCONTROLLER_OK)
    {
        dictionary = feature->privatePart->dictionary;
    }
    
    // Return the error
    if (error != NULL)
    {
        *error = localError;
    }
    // No else: error is not returned 
    
    return dictionary;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_AddCallback (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Add a callback to use when a command in project <code>MiniDrone</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_AddDictionaryElement (&(feature->privatePart->commandCallbacks), commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_RemoveCallback (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCONTROLLER_DICTIONARY_KEY commandKey, ARCONTROLLER_DICTIONARY_CALLBACK_t callback, void *customData)
{
    // -- Remove a callback to use when a command in project <code>MiniDrone</code> is received --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Dictionary_RemoveDictionaryElement (feature->privatePart->commandCallbacks, commandKey, callback, customData);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_RegisterARCommands (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Register the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlatTrimChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_PilotingStateFlatTrimChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlyingStateChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_PilotingStateFlyingStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateAlertStateChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_PilotingStateAlertStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateAutoTakeOffModeChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_PilotingStateAutoTakeOffModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_MediaRecordStatePictureStateChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedV2Callback (&ARCONTROLLER_FEATURE_MiniDrone_MediaRecordStatePictureStateChangedV2Callback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneMediaRecordEventPictureEventChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_MediaRecordEventPictureEventChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxAltitudeChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_PilotingSettingsStateMaxAltitudeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxTiltChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_PilotingSettingsStateMaxTiltChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SpeedSettingsStateMaxVerticalSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SpeedSettingsStateMaxRotationSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateWheelsChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SpeedSettingsStateWheelsChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SpeedSettingsStateMaxHorizontalSpeedChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductMotorsVersionChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SettingsStateProductMotorsVersionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductInertialVersionChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SettingsStateProductInertialVersionChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneSettingsStateCutOutModeChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_SettingsStateCutOutModeChangedCallback, feature);
        ARCOMMANDS_Decoder_SetMiniDroneFloodControlStateFloodControlChangedCallback (&ARCONTROLLER_FEATURE_MiniDrone_FloodControlStateFloodControlChangedCallback, feature);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_UnregisterARCommands (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Unregister the feature controller to be called when the commands are decoded. -- 
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) || (feature->privatePart == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlatTrimChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateFlyingStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateAlertStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDronePilotingStateAutoTakeOffModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneMediaRecordStatePictureStateChangedV2Callback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneMediaRecordEventPictureEventChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxAltitudeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDronePilotingSettingsStateMaxTiltChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxVerticalSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxRotationSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateWheelsChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSpeedSettingsStateMaxHorizontalSpeedChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductMotorsVersionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSettingsStateProductInertialVersionChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneSettingsStateCutOutModeChangedCallback (NULL, NULL);
        ARCOMMANDS_Decoder_SetMiniDroneFloodControlStateFloodControlChangedCallback (NULL, NULL);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingFlatTrim (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Send a command <code>PilotingFlatTrim</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send FlatTrim command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingFlatTrim(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingTakeOff (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Send a command <code>PilotingTakeOff</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send TakeOff command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingTakeOff(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingPCMD (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t flag, int8_t roll, int8_t pitch, int8_t yaw, int8_t gaz, uint32_t timestamp)
{
    // -- Send a command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PCMD command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingPCMD(cmdBuffer, sizeof(cmdBuffer), &cmdSize, flag, roll, pitch, yaw, gaz, timestamp);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMD (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t _flag, int8_t _roll, int8_t _pitch, int8_t _yaw, int8_t _gaz, uint32_t _timestamp)
{
    // -- Set the parameter for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->flag = _flag;
        feature->privatePart->PilotingPCMDParameters->roll = _roll;
        feature->privatePart->PilotingPCMDParameters->pitch = _pitch;
        feature->privatePart->PilotingPCMDParameters->yaw = _yaw;
        feature->privatePart->PilotingPCMDParameters->gaz = _gaz;
        feature->privatePart->PilotingPCMDParameters->timestamp = _timestamp;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_MiniDrone_SendPilotingPCMDStruct (ARCONTROLLER_FEATURE_MiniDrone_t *feature, u_int8_t *cmdBuffer, int32_t cmdBufferSize)
{
    // -- Send the a command <code>PilotingPCMD</code> in project <code>MiniDrone</code> with the parame set beforehand  --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    int32_t cmdSize = 0;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL) ||
       (cmdBuffer == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PCMD command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingPCMD(cmdBuffer, cmdBufferSize, &cmdSize, feature->privatePart->PilotingPCMDParameters->flag, feature->privatePart->PilotingPCMDParameters->roll, feature->privatePart->PilotingPCMDParameters->pitch, feature->privatePart->PilotingPCMDParameters->yaw, feature->privatePart->PilotingPCMDParameters->gaz, feature->privatePart->PilotingPCMDParameters->timestamp);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_NOT_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
        if (netError != ARNETWORK_OK)
        {
            ARSAL_PRINT(ARSAL_PRINT_ERROR, ARCONTROLLER_FEATURE_TAG, "Network sending error : %s", ARNETWORK_Error_ToString (netError));
        }
        
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDFlag (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t _flag)
{
    // -- Set the flag for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->flag = _flag;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDRoll (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t _roll)
{
    // -- Set the roll for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->roll = _roll;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDPitch (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t _pitch)
{
    // -- Set the pitch for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->pitch = _pitch;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDYaw (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t _yaw)
{
    // -- Set the yaw for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->yaw = _yaw;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDGaz (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int8_t _gaz)
{
    // -- Set the gaz for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->gaz = _gaz;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SetPilotingPCMDTimestamp (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint32_t _timestamp)
{
    // -- Set the timestamp for the command <code>PilotingPCMD</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    
    // Check parameters
    if ((feature == NULL) ||
       (feature->privatePart == NULL) ||
       (feature->privatePart->PilotingPCMDParameters == NULL))
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        feature->privatePart->PilotingPCMDParameters->timestamp = _timestamp;
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingLanding (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Send a command <code>PilotingLanding</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Landing command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingLanding(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingEmergency (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Send a command <code>PilotingEmergency</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Emergency command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingEmergency(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_HIGH_PRIORITY, ARNETWORK_MANAGER_CALLBACK_RETURN_RETRY, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingAutoTakeOffMode (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t state)
{
    // -- Send a command <code>PilotingAutoTakeOffMode</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send AutoTakeOffMode command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingAutoTakeOffMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, state);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsFlip (ARCONTROLLER_FEATURE_MiniDrone_t *feature, eARCOMMANDS_MINIDRONE_ANIMATIONS_FLIP_DIRECTION direction)
{
    // -- Send a command <code>AnimationsFlip</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Flip command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneAnimationsFlip(cmdBuffer, sizeof(cmdBuffer), &cmdSize, direction);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendAnimationsCap (ARCONTROLLER_FEATURE_MiniDrone_t *feature, int16_t offset)
{
    // -- Send a command <code>AnimationsCap</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Cap command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneAnimationsCap(cmdBuffer, sizeof(cmdBuffer), &cmdSize, offset);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPicture (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t mass_storage_id)
{
    // -- Send a command <code>MediaRecordPicture</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Picture command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPicture(cmdBuffer, sizeof(cmdBuffer), &cmdSize, mass_storage_id);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendMediaRecordPictureV2 (ARCONTROLLER_FEATURE_MiniDrone_t *feature)
{
    // -- Send a command <code>MediaRecordPictureV2</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send PictureV2 command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneMediaRecordPictureV2(cmdBuffer, sizeof(cmdBuffer), &cmdSize);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxAltitude (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current)
{
    // -- Send a command <code>PilotingSettingsMaxAltitude</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxAltitude command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxAltitude(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendPilotingSettingsMaxTilt (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current)
{
    // -- Send a command <code>PilotingSettingsMaxTilt</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxTilt command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDronePilotingSettingsMaxTilt(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxVerticalSpeed (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current)
{
    // -- Send a command <code>SpeedSettingsMaxVerticalSpeed</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxVerticalSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxVerticalSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxRotationSpeed (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current)
{
    // -- Send a command <code>SpeedSettingsMaxRotationSpeed</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxRotationSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxRotationSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsWheels (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t present)
{
    // -- Send a command <code>SpeedSettingsWheels</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send Wheels command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsWheels(cmdBuffer, sizeof(cmdBuffer), &cmdSize, present);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendSpeedSettingsMaxHorizontalSpeed (ARCONTROLLER_FEATURE_MiniDrone_t *feature, float current)
{
    // -- Send a command <code>SpeedSettingsMaxHorizontalSpeed</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send MaxHorizontalSpeed command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSpeedSettingsMaxHorizontalSpeed(cmdBuffer, sizeof(cmdBuffer), &cmdSize, current);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendSettingsCutOutMode (ARCONTROLLER_FEATURE_MiniDrone_t *feature, uint8_t enable)
{
    // -- Send a command <code>SettingsCutOutMode</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send CutOutMode command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneSettingsCutOutMode(cmdBuffer, sizeof(cmdBuffer), &cmdSize, enable);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLatitudeForRun (ARCONTROLLER_FEATURE_MiniDrone_t *feature, double latitude)
{
    // -- Send a command <code>GPSControllerLatitudeForRun</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ControllerLatitudeForRun command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLatitudeForRun(cmdBuffer, sizeof(cmdBuffer), &cmdSize, latitude);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendGPSControllerLongitudeForRun (ARCONTROLLER_FEATURE_MiniDrone_t *feature, double longitude)
{
    // -- Send a command <code>GPSControllerLongitudeForRun</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ControllerLongitudeForRun command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneGPSControllerLongitudeForRun(cmdBuffer, sizeof(cmdBuffer), &cmdSize, longitude);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerType (ARCONTROLLER_FEATURE_MiniDrone_t *feature, char * type)
{
    // -- Send a command <code>ConfigurationControllerType</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ControllerType command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerType(cmdBuffer, sizeof(cmdBuffer), &cmdSize, type);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

eARCONTROLLER_ERROR ARCONTROLLER_FEATURE_MiniDrone_SendConfigurationControllerName (ARCONTROLLER_FEATURE_MiniDrone_t *feature, char * name)
{
    // -- Send a command <code>ConfigurationControllerName</code> in project <code>MiniDrone</code> --
    
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    u_int8_t cmdBuffer[128];
    int32_t cmdSize = 0;
    eARCOMMANDS_GENERATOR_ERROR cmdError = ARCOMMANDS_GENERATOR_OK;
    eARNETWORK_ERROR netError = ARNETWORK_OK;
    
    // Check parameters
    if (feature == NULL)
    {
        error = ARCONTROLLER_ERROR_BAD_PARAMETER;
    }
    // No Else: the checking parameters sets error to ARNETWORK_ERROR_BAD_PARAMETER and stop the processing
    
    if (error == ARCONTROLLER_OK)
    {
        // Send ControllerName command
        cmdError = ARCOMMANDS_Generator_GenerateMiniDroneConfigurationControllerName(cmdBuffer, sizeof(cmdBuffer), &cmdSize, name);
        if (cmdError != ARCOMMANDS_GENERATOR_OK)
        {
            error = ARCONTROLLER_ERROR_COMMAND_GENERATING;
        }
    }
    
    if (error == ARCONTROLLER_OK)
    {
        error = ARCONTROLLER_Network_SendData (feature->privatePart->networkController, cmdBuffer, cmdSize, ARCONTROLLER_NETWORK_SENDING_DATA_TYPE_ACK, ARNETWORK_MANAGER_CALLBACK_RETURN_DATA_POP, &netError);
    }
    
    return error;
}

void ARCONTROLLER_FEATURE_MiniDrone_PilotingStateFlatTrimChangedCallback (void *customData)
{
    // -- callback used when the command <code>PilotingStateFlatTrimChanged</code> is decoded -- 
    
    ARCONTROLLER_FEATURE_MiniDrone_t *feature = (ARCONTROLLER_FEATURE_MiniDrone_t *)customData;
    eARCONTROLLER_ERROR error = ARCONTROLLER_OK;
    int commandKey = ARCONTROLLER_DICTIONARY_KEY_MINIDRONE_PILOTINGSTATE_FLATTRIMCHANGED;
    ARCONTROLLER_DICTIONARY_COMMANDS_t *dictCmdElement = NULL;
    int isANewCommandElement = 0;
  