/*
    Copyright (C) 2014 Parrot SA

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in
      the documentation and/or other materials provided with the 
      distribution.
    * Neither the name of Parrot nor the names
      of its contributors may be used to endorse or promote products
      derived from this software without specific prior written
      permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
    FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
    COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
    INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
    BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
    OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
    AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
    OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
    OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
*/

/**
 * @file ARDISCOVERY_NetworkConfiguration.h
 * @brief network configuration used to create a network
 * @date 02/03/2015
 * @author maxime.maitre@parrot.com
 */

#ifndef _ARDISCOVERY_DISCOVERY_NETWORK_CONFIGURATION_H_
#define _ARDISCOVERY_DISCOVERY_NETWORK_CONFIGURATION_H_

#include <libARNetwork/ARNETWORK_IOBufferParam.h>
#include <libARCommands/ARCOMMANDS_Generator.h>

/**
 * @brief Way to start/stop video streaming
 */
typedef enum {
    ARDISCOVERY_STREAM_STARTSTOP_NONE,
    ARDISCOVERY_STREAM_STARTSTOP_ARCOMMANDS,
    ARDISCOVERY_STREAM_STARTSTOP_RTSP,
} eARDISCOVERY_STREAM_STARTSTOP_TYPE;

typedef eARCOMMANDS_GENERATOR_ERROR (*commandGenerator)(uint8_t *buffer,
                                                        int32_t buffLen,
                                                        int32_t *cmdLen);

/**
 * @brief 
 */
typedef struct 
{
    int controllerLoopIntervalMs;
    
    int controllerToDeviceNotAckId;
    int controllerToDeviceAckId;
    int controllerToDeviceHightPriority;
    int controllerToDeviceARStreamAck;
    int controllerToDeviceARStreamAudioAck;
    int controllerToDeviceARStreamAudioData;
    int deviceToControllerNotAckId;
    int deviceToControllerAckId;
    //int deviceToControllerHightPriority;
    int deviceToControllerARStreamData;
    int deviceToControllerARStreamAudioData;
    int deviceToControllerARStreamAudioAck;

    int hasVideo;
    eARDISCOVERY_STREAM_STARTSTOP_TYPE streamType;

    /* if streamType == ARCOMMANDS */
    commandGenerator startCommand;
    commandGenerator stopCommand;

    /* if streamType == RTSP */
    char *rtspAddress;
    
    int numberOfControllerToDeviceParam;
    ARNETWORK_IOBufferParam_t *controllerToDeviceParams;
    int numberOfDeviceToControllerParam;
    ARNETWORK_IOBufferParam_t *deviceToControllerParams;
    
    int pingDelayMs;
    
    int numberOfDeviceToControllerCommandsBufferIds;
    int *deviceToControllerCommandsBufferIds;
} ARDISCOVERY_NetworkConfiguration_t;

#endif // _ARDISCOVERY_DISCOVERY_NETWORK_CONFIGURATION_H_
